#include <xmms/plugin.h>
#include <glib.h>
#include <stdlib.h>
#include <time.h>
#include "gdancer.h"
#include "about.h"
#include "gui.h"
#include "audioprocessing.h"
#include "config.h"

/* Have to declare the functions up here so the VisPlugin struct
 * can have them listed */
void gd_init (void);
void gd_cleanup (void);
void gd_start (void);
void gd_stop (void);

GList *gdancers = NULL;	/* Make list of dancers */
GDconf gdconfig; /* Make global config */

VisPlugin gdancer_vp =
{
	NULL,		/* Handle (Filled in by xmms) */
	NULL,		/* Filename (filled in by xmms) */
	0,		/* Session ID */
	"GDancer",	/* Description */
	0,		/* Number of PCM channels wanted */
	1,		/* Number of freq channels wanted */
	gd_init,	/* called when plugin is enabled */
	gd_cleanup,	/* called when plugin is disabled */
	show_about,	/* show about */
	global_config,	/* show configure box */
	NULL,		/* Disable plugin (call with pointer) */
	gd_start,	/* When playback starts */
	gd_stop,	/* When playback stops */
	NULL,		/* Render pcm data */
	gd_renderfreq	/* Render feq data */
};

/* Gives the above structure to xmms */
VisPlugin *get_vplugin_info(void)
{
	return &gdancer_vp;
}

void gd_cleanup (void)
{
	gd_save_config();
	g_list_foreach (gdancers, (GFunc) clean_dancer, NULL);
	g_list_free (gdancers);
}

void gd_init (void)
{
	srand (time(NULL));
	gdancers = NULL;	/* Make sure list is clear */
	load_global_config();	/* Load global settings */
	gd_make_dancers();	/* Setup all the dancers */
}

void gd_start (void)
{

}

void gd_stop (void)
{

}

