/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.ErrorListener;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Type;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AttributeDef
extends AbstractLeafElement
implements Extendable {
    protected String name = "";
    protected AttributeDef extending = null;
    protected boolean _final = false;
    protected boolean _abstract = false;
    protected Set extendedBy = new HashSet(2);
    protected Type domain = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected AttributeDef() {
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        Container cont;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.interlis.ili2c.metamodel.Viewable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cont = this.getContainer(clazz)) == null) {
            return this.getName();
        }
        return String.valueOf(cont.getScopedName(null)) + ":" + this.getName();
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        Element.checkNameSanity(name, false);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("ch.interlis.ili2c.metamodel.AttributeDef");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkNameUniqueness(newValue, clazz, (AttributeDef)this.getRealExtending(), "err_attributeDef_duplicateName");
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public Element getExtending() {
        return this.extending;
    }

    public Element getRealExtending() {
        Element ext = this.getExtending();
        return ext != null ? ext.getReal() : null;
    }

    public boolean isExtendingIndirectly(Element ext) {
        AttributeDef parent = this;
        while (parent != null) {
            if (parent == ext) {
                return true;
            }
            parent = parent.extending;
        }
        return false;
    }

    public boolean isDependentOn(Element e) {
        if (e instanceof AttributeDef) {
            boolean i = this.isExtendingIndirectly((AttributeDef)e);
            return i;
        }
        return false;
    }

    public void setExtending(Element ext) throws PropertyVetoException {
        AttributeDef oldValue = this.extending;
        AttributeDef newValue = (AttributeDef)ext;
        if (oldValue == newValue) {
            return;
        }
        if (newValue != null && newValue.isFinal()) {
            throw new IllegalArgumentException(Element.formatMessage("err_cantExtendFinal", newValue.toString()));
        }
        if (newValue != null && newValue.isExtendingIndirectly(this)) {
            throw new IllegalArgumentException(Element.formatMessage("err_cyclicExtension", this.toString(), newValue.toString()));
        }
        if (this.domain != null) {
            if (newValue == null) {
                this.domain.checkTypeExtension(null);
            } else {
                this.domain.checkTypeExtension(newValue.getDomain());
            }
        }
        this.fireVetoableChange("extending", oldValue, newValue);
        if (this.domain != null) {
            if (newValue == null) {
                this.domain.setExtending(null);
            } else {
                this.domain.setExtending(newValue.getDomain());
            }
        }
        if (oldValue != null) {
            oldValue.extendedBy.remove(this);
        }
        this.extending = newValue;
        if (newValue != null) {
            newValue.extendedBy.add(this);
        }
        this.firePropertyChange("extending", oldValue, newValue);
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setAbstract(boolean abst) throws PropertyVetoException {
        boolean oldValue = this._abstract;
        boolean newValue = abst;
        if (oldValue == newValue) {
            return;
        }
        if (newValue && this.isFinal()) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_abstractFinal"));
        }
        if (!newValue && this.domain != null && this.domain.isAbstract()) {
            throw new IllegalArgumentException(Element.formatMessage("err_attributeDef_concreteWithAbstractDomain", this.toString()));
        }
        this.fireVetoableChange("abstract", oldValue, newValue);
        this._abstract = newValue;
        this.firePropertyChange("abstract", oldValue, newValue);
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setFinal(boolean fin) throws PropertyVetoException {
        boolean oldValue = this._final;
        boolean newValue = fin;
        if (oldValue == newValue) {
            return;
        }
        if (newValue && this.isAbstract()) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_abstractFinal"));
        }
        if (newValue && !this.extendedBy.isEmpty()) {
            throw new IllegalArgumentException(Element.formatMessage("err_cantMakeExtendedFinal", this.toString(), this.extendedBy.iterator().next().toString()));
        }
        this.fireVetoableChange("final", oldValue, newValue);
        this._final = newValue;
        this.firePropertyChange("final", oldValue, newValue);
    }

    public boolean isExtending(Element ext) {
        AttributeDef parent = this;
        while (parent != null) {
            if (parent == ext) {
                return true;
            }
            parent = parent.extending;
        }
        return false;
    }

    public Set getExtensions() {
        HashSet result = new HashSet();
        this.getExtensions_recursiveHelper(result);
        return result;
    }

    private final void getExtensions_recursiveHelper(Set s) {
        s.add(this);
        Iterator iter = this.extendedBy.iterator();
        while (iter.hasNext()) {
            ((AttributeDef)iter.next()).getExtensions_recursiveHelper(s);
        }
    }

    public Type getDomain() {
        return this.domain;
    }

    public Type getDomainResolvingAliases() {
        return Type.findReal(this.domain);
    }

    public void setDomain(Type domain) throws PropertyVetoException {
        Type oldValue = this.domain;
        Type newValue = domain;
        Object realNewValue = null;
        if (newValue == null) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_nullNotAcceptable"));
        }
        if (oldValue == newValue) {
            return;
        }
        if (newValue != null && newValue.isAbstract() && !this.isAbstract()) {
            throw new IllegalArgumentException(Element.formatMessage("err_attributeDef_domainIsAbstractButAttrIsNot", this.toString()));
        }
        this.fireVetoableChange("domain", oldValue, newValue);
        if (this.extending == null) {
            newValue.setExtending(null);
        } else {
            newValue.setExtending(this.extending.getDomain());
        }
        this.domain = newValue;
        this.firePropertyChange("domain", oldValue, newValue);
    }

    public boolean checkStructuralEquivalence(Element with, ErrorListener listener) {
        Type otherDomain;
        if (!super.checkStructuralEquivalence(with, listener)) {
            return false;
        }
        Type myDomain = this.getDomain();
        if (myDomain == (otherDomain = ((AttributeDef)with).getDomain())) {
            return true;
        }
        if (myDomain == null) {
            return false;
        }
        if (!myDomain.checkStructuralEquivalence(otherDomain, listener)) {
            listener.error(new ErrorListener.ErrorEvent(Element.formatMessage("err_diff_attributeType", this.toString(), with.toString()), this, 5));
            return false;
        }
        return true;
    }
}

