/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;
import org.apache.xerces.impl.xs.XSParticleDecl;

public class XSCMLeaf
extends CMNode {
    private XSParticleDecl fLeaf = null;
    private int fPosition = -1;

    public XSCMLeaf(XSParticleDecl xSParticleDecl, int n) {
        super(xSParticleDecl.fType);
        this.fLeaf = xSParticleDecl;
        this.fPosition = n;
    }

    public XSCMLeaf(XSParticleDecl xSParticleDecl) {
        this(xSParticleDecl, -1);
    }

    final XSParticleDecl getLeaf() {
        return this.fLeaf;
    }

    final int getPosition() {
        return this.fPosition;
    }

    final void setPosition(int n) {
        this.fPosition = n;
    }

    public boolean isNullable() {
        return this.fPosition == -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.fLeaf.fValue.toString());
        if (this.fPosition >= 0) {
            stringBuffer.append(" (Pos:" + new Integer(this.fPosition).toString() + ")");
        }
        return stringBuffer.toString();
    }

    protected void calcFirstPos(CMStateSet cMStateSet) {
        if (this.fPosition == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(this.fPosition);
        }
    }

    protected void calcLastPos(CMStateSet cMStateSet) {
        if (this.fPosition == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(this.fPosition);
        }
    }
}

