/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.CombiningIterator;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.Selection;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableAlias;
import java.beans.PropertyVetoException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class View
extends Viewable {
    protected List selections = new LinkedList();
    private boolean propTransient = false;

    protected Collection createElements() {
        return new AbstractCollection(){

            public Iterator iterator() {
                return new CombiningIterator(new Iterator[]{View.this.selections.iterator(), View.this.attributes.iterator(), View.this.constraints.iterator()});
            }

            public int size() {
                return View.this.selections.size() + View.this.attributes.size() + View.this.constraints.size();
            }

            public boolean add(Object o) {
                if (o == null) {
                    throw new IllegalArgumentException(Element.rsrc.getString("err_nullNotAcceptable"));
                }
                if (o instanceof Selection) {
                    return View.this.selections.add(o);
                }
                if (o instanceof LocalAttribute) {
                    return View.this.attributes.add(o);
                }
                if (o instanceof Constraint) {
                    return View.this.constraints.add(o);
                }
                throw new ClassCastException();
            }
        };
    }

    public String toString() {
        return "VIEW " + this.getScopedName(null);
    }

    protected void checkForDuplicateNames(ViewableAlias[] aliases) throws IllegalArgumentException {
        int i = 0;
        while (i < aliases.length) {
            String curName = aliases[i].getName();
            int j = 0;
            while (j < i) {
                if (curName.equals(aliases[j].getName())) {
                    throw new IllegalArgumentException(Element.formatMessage("err_view_dupAlias", curName, aliases[i].getAliasing().toString(), aliases[j].getAliasing().toString()));
                }
                ++j;
            }
            ++i;
        }
    }

    public void setExtending(Element extending) throws PropertyVetoException {
        if (extending != null) {
            throw new IllegalArgumentException(Element.formatMessage("err_view_notExtensible", this.toString(), extending.toString()));
        }
        super.setExtending((View)extending);
    }

    public boolean isDependentOn(Element other) {
        Iterator iter = this.selections.iterator();
        while (iter.hasNext()) {
            Selection sel = (Selection)iter.next();
            if (sel == other) {
                return true;
            }
            Viewable selected = sel.getSelected();
            if (selected == null || selected != other && !selected.isDependentOn(other)) continue;
            return true;
        }
        return super.isDependentOn(other);
    }

    public void setTransient(boolean transient1) {
        this.propTransient = transient1;
    }
}

