/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom3;

import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.dom3.DOMImplementationSource;
import org.w3c.dom.DOMImplementation;

public class DOMImplementationRegistry {
    public static String PROPERTY = "org.w3c.dom.DOMImplementationSourceList";
    private static Vector sources = new Vector();
    private static boolean initialized = false;

    private static void initialize() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        initialized = true;
        String string = System.getProperty(PROPERTY);
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            Object obj = Class.forName(stringTokenizer.nextToken()).newInstance();
            sources.addElement(obj);
        }
    }

    public static DOMImplementation getDOMImplementation(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!initialized) {
            DOMImplementationRegistry.initialize();
        }
        int n = sources.size();
        int n2 = 0;
        while (n2 < n) {
            DOMImplementationSource dOMImplementationSource = (DOMImplementationSource)sources.elementAt(n2);
            DOMImplementation dOMImplementation = dOMImplementationSource.getDOMImplementation(string);
            if (dOMImplementation != null) {
                return dOMImplementation;
            }
            ++n2;
        }
        return null;
    }

    public static void addSource(DOMImplementationSource dOMImplementationSource) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!initialized) {
            DOMImplementationRegistry.initialize();
        }
        sources.addElement(dOMImplementationSource);
        StringBuffer stringBuffer = new StringBuffer(System.getProperty(PROPERTY));
        stringBuffer.append(" " + dOMImplementationSource.getClass().getName());
        System.setProperty(PROPERTY, stringBuffer.toString());
    }
}

