/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.26
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif


/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_OWN           0x1
#define SWIG_POINTER_DISOWN        0x2
#define SWIG_TRACK_OBJECTS	        0x4

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/***********************************************************************
 * rubytracking.swg
 *
 * This file contains support for tracking mappings from 
 * Ruby objects to C++ objects.  This functionality is needed
 * to implement mark functions for Ruby's mark and sweep
 * garbage collector.
 ************************************************************************/

/* Global Ruby hash table to store Trackings from C/C++
   structs to Ruby Objects. */
static VALUE swig_ruby_trackings;

/* Setup a Ruby hash table to store Trackings */
static void SWIG_RubyInitializeTrackings() {
	/* Create a ruby hash table to store Trackings from C++ 
	objects to Ruby objects.  Also make sure to tell
	the garabage collector about the hash table. */
	swig_ruby_trackings = rb_hash_new();
	rb_gc_register_address(&swig_ruby_trackings);
}

/* Get a Ruby number to reference a pointer */
static VALUE SWIG_RubyPtrToReference(void* ptr) {
	/* We cast the pointer to an unsigned long
	 and then store a reference to it using
	 a Ruby number object. */

	/* Convert the pointer to a Ruby number */
	unsigned long value = (unsigned long) ptr;
	return LONG2NUM(value);
}

/* Get a Ruby number to reference an object */
static VALUE SWIG_RubyObjectToReference(VALUE object) {
	/* We cast the object to an unsigned long
	 and then store a reference to it using
	 a Ruby number object. */

	/* Convert the Object to a Ruby number */
	unsigned long value = (unsigned long) object;
	return LONG2NUM(value);
}

/* Get a Ruby object from a previously stored reference */
static VALUE SWIG_RubyReferenceToObject(VALUE reference) {
	/* The provided Ruby number object is a reference
	to the Ruby object we want.*/

	/* First convert the Ruby number to a C number */
	unsigned long value = NUM2LONG(reference);
	return (VALUE) value;
}

/* Add a Tracking from a C/C++ struct to a Ruby object */
static void SWIG_RubyAddTracking(void* ptr, VALUE object) {
	/* In a Ruby hash table we store the pointer and
	the associated Ruby object.  The trick here is
	that we cannot store the Ruby object directly - if
	we do then it cannot be garbage collected.  So
	instead we typecast it as a unsigned long and
	convert it to a Ruby number object.*/

	/* Get a reference to the pointer as a Ruby number */
	VALUE key = SWIG_RubyPtrToReference(ptr);

	/* Get a reference to the Ruby object as a Ruby number */
	VALUE value = SWIG_RubyObjectToReference(object);

  /* Store the mapping to the global hash table. */
	rb_hash_aset(swig_ruby_trackings, key, value);
}

/* Get the Ruby object that owns the specified C/C++ struct */
static VALUE SWIG_RubyInstanceFor(void* ptr) {
	/* Get a reference to the pointer as a Ruby number */
	VALUE key = SWIG_RubyPtrToReference(ptr);

	/* Now lookup the value stored in the global hash table */
	VALUE value = rb_hash_aref(swig_ruby_trackings, key);
	
	if (value == Qnil) {
	  /* No object exists - return nil. */
		return Qnil;
	}
	else {
		/* Convert this value to Ruby object */
		return SWIG_RubyReferenceToObject(value);
	}
}

/* Remove a Tracking from a C/C++ struct to a Ruby object */
static void SWIG_RubyRemoveTracking(void* ptr) {
	/* Get a reference to the pointer as a Ruby number */
	VALUE key = SWIG_RubyPtrToReference(ptr);

	/* Define delete method - in C++ this could be marked as
	   static but unfortunately not in C. */
	VALUE delete_function = rb_intern("delete");

	/* Delete the object from the hash table by calling Ruby's
	   do this we need to call the Hash.delete method.*/
	rb_funcall(swig_ruby_trackings, delete_function, 1, key);
}

/* This is a helper method that unlinks a Ruby object from its
   underlying C++ object.  This is needed if the lifetime of the
   Ruby object is longer than the C++ object */
static void SWIG_RubyUnlinkObjects(void* ptr) {
	VALUE object = SWIG_RubyInstanceFor(ptr);

	if (object != Qnil) {
		DATA_PTR(object) = 0;
	}
}

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)
#define SWIG_GetModule(clientdata) \
  SWIG_Ruby_GetModule()
#define SWIG_SetModule(clientdata, pointer) \
  SWIG_Ruby_SetModule(pointer)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)

/* rubydef.swg */
#ifdef __cplusplus
extern "C" {
#endif

static VALUE _mSWIG = Qnil;
static VALUE _cSWIG_Pointer = Qnil;
static VALUE swig_runtime_data_type_pointer = Qnil;

/* Initialize Ruby runtime support */
static void
SWIG_Ruby_InitRuntime(void)
{
    if (_mSWIG == Qnil) {
        _mSWIG = rb_define_module("SWIG");
    }
}

/* Define Ruby class for C type */
static void
SWIG_Ruby_define_class(swig_type_info *type)
{
    VALUE klass;
    char *klass_name = (char *) malloc(4 + strlen(type->name) + 1);
    sprintf(klass_name, "TYPE%s", type->name);
    if (NIL_P(_cSWIG_Pointer)) {
	_cSWIG_Pointer = rb_define_class_under(_mSWIG, "Pointer", rb_cObject);
	rb_undef_method(CLASS_OF(_cSWIG_Pointer), "new");
    }
    klass = rb_define_class_under(_mSWIG, klass_name, _cSWIG_Pointer);
    free((void *) klass_name);
}

/* Create a new pointer object */
static VALUE
SWIG_Ruby_NewPointerObj(void *ptr, swig_type_info *type, int flags)
{
	 int own = flags & SWIG_POINTER_OWN;
	 int track = flags & SWIG_TRACK_OBJECTS;
	 
    char *klass_name;
    swig_class *sklass;
    VALUE klass;
    VALUE obj;
    
    if (!ptr)
      return Qnil;
    
    /* Have we already wrapped this pointer? */
    if (track) {
	    obj = SWIG_RubyInstanceFor(ptr);
   	 if (obj != Qnil) {
      	return obj;
    	}
    }
		
    if (type->clientdata) {
      sklass = (swig_class *) type->clientdata;
      obj = Data_Wrap_Struct(sklass->klass, VOIDFUNC(sklass->mark), (own ? VOIDFUNC(sklass->destroy) : 0), ptr);
    } else {
      klass_name = (char *) malloc(4 + strlen(type->name) + 1);
      sprintf(klass_name, "TYPE%s", type->name);
      klass = rb_const_get(_mSWIG, rb_intern(klass_name));
      free((void *) klass_name);
      obj = Data_Wrap_Struct(klass, 0, 0, ptr);
    }
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    
    /* Keep track of this object if necessary */
    if (track) {
	   SWIG_RubyAddTracking(ptr, obj);
    }
   
    return obj;
}

/* Create a new class instance (always owned) */
static VALUE
SWIG_Ruby_NewClassInstance(VALUE klass, swig_type_info *type)
{
    VALUE obj;
    swig_class *sklass = (swig_class *) type->clientdata;
    obj = Data_Wrap_Struct(klass, VOIDFUNC(sklass->mark), VOIDFUNC(sklass->destroy), 0);
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Get type mangle from class name */
static SWIGINLINE char *
SWIG_Ruby_MangleStr(VALUE obj)
{
  VALUE stype = rb_iv_get(obj, "__swigtype__");
  return StringValuePtr(stype);
}

/* Convert a pointer value */
static int
SWIG_Ruby_ConvertPtr(VALUE obj, void **ptr, swig_type_info *ty, int flags)
{
  char *c;
  swig_cast_info *tc;

  /* Grab the pointer */
  if (NIL_P(obj)) {
    *ptr = 0;
    return 0;
  } else {
    Data_Get_Struct(obj, void, *ptr);
  }
  
  /* Check to see if the input object is giving up ownership
     of the underlying C struct or C++ object.  If so then we
     need to reset the destructor since the Ruby object no 
     longer owns the underlying C++ object.*/ 
  if (flags & SWIG_POINTER_DISOWN) {
	 if (flags & SWIG_TRACK_OBJECTS) {
      /* We are tracking objects.  Thus we change the destructor
		 * to SWIG_RubyRemoveTracking.  This allows us to
		 * remove the mapping from the C++ to Ruby object
		 * when the Ruby object is garbage collected.  If we don't
		 * do this, then it is possible we will return a reference 
		 * to a Ruby object that no longer exists thereby crashing Ruby. */
		RDATA(obj)->dfree = SWIG_RubyRemoveTracking;
  	 } else {    
      RDATA(obj)->dfree = 0;
    }
  }

  /* Do type-checking if type info was provided */
  if (ty) {
    if (ty->clientdata) {
        if (rb_obj_is_kind_of(obj, ((swig_class *) (ty->clientdata))->klass)) {
          if (*ptr == 0)
            rb_raise(rb_eRuntimeError, "This %s already released", ty->str);
          return 0;
        }
    }
    if ((c = SWIG_MangleStr(obj)) == NULL) {
      if (flags & SWIG_POINTER_EXCEPTION)
        rb_raise(rb_eTypeError, "Expected %s", ty->str);
      else
        return -1;
    }
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) {
      if (flags & SWIG_POINTER_EXCEPTION)
        rb_raise(rb_eTypeError, "Expected %s", ty->str);
      else
        return -1;
    }
    *ptr = SWIG_TypeCast(tc, *ptr);
  }
  return 0;
}

/* Convert a pointer value, signal an exception on a type mismatch */
static SWIGINLINE void *
SWIG_Ruby_MustGetPtr(VALUE obj, swig_type_info *ty, int argnum, int flags)
{
  void *result;
  SWIG_ConvertPtr(obj, &result, ty, flags | SWIG_POINTER_EXCEPTION);
  return result;
}

/* Check convert */
static SWIGINLINE int
SWIG_Ruby_CheckConvert(VALUE obj, swig_type_info *ty)
{
  char *c = SWIG_MangleStr(obj);
  if (!c)
    return 0;
  return SWIG_TypeCheck(c,ty) != 0;
}

static VALUE
SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r, ptr, sz);
  strcpy(r, type->name);
  return rb_str_new2(result);
}

/* Convert a packed value value */
static void
SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  const char  *c;

  if (TYPE(obj) != T_STRING) goto type_error;
  c = StringValuePtr(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c, ptr, sz);
  if (ty) {
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) goto type_error;
  }
  return;

type_error:

  if (flags) {
    if (ty) {
      rb_raise(rb_eTypeError, "Type error. Expected %s", ty->name);
    } else {
      rb_raise(rb_eTypeError, "Expected a pointer");
    }
  }
}

static swig_module_info *SWIG_Ruby_GetModule() {
    VALUE pointer;
    swig_module_info *ret = 0;

   /* first check if pointer already created */
    pointer = rb_gv_get("$swig_runtime_data_type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME);
    if (pointer != Qnil) {
      Data_Get_Struct(pointer, swig_module_info, ret);
    }
    return ret;
}

static void SWIG_Ruby_SetModule(swig_module_info *pointer) {
      /* register a new class */
      VALUE cl = rb_define_class("swig_runtime_data", rb_cObject);
      /* create and store the structure pointer to a global variable */
      swig_runtime_data_type_pointer = Data_Wrap_Struct(cl, 0, 0, pointer);
      rb_define_readonly_variable("$swig_runtime_data_type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, &swig_runtime_data_type_pointer);
}

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_CPLErrorHandler swig_types[0]
#define SWIGTYPE_p_CPLXMLNode swig_types[1]
#define SWIGTYPE_p_GDALColorEntry swig_types[2]
#define SWIGTYPE_p_GDALColorTable swig_types[3]
#define SWIGTYPE_p_GDALDatasetShadow swig_types[4]
#define SWIGTYPE_p_GDALDriverShadow swig_types[5]
#define SWIGTYPE_p_GDALMajorObjectShadow swig_types[6]
#define SWIGTYPE_p_GDALRasterBandShadow swig_types[7]
#define SWIGTYPE_p_GDAL_GCP swig_types[8]
#define SWIGTYPE_p_double swig_types[9]
#define SWIGTYPE_p_int swig_types[10]
#define SWIGTYPE_p_p_GDAL_GCP swig_types[11]
#define SWIGTYPE_p_p_char swig_types[12]
#define SWIGTYPE_p_unsigned_long swig_types[13]
static swig_type_info *swig_types[15];
static swig_module_info swig_module = {swig_types, 14, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_gdal
#define SWIG_name    "Gdal::Gdal"

static VALUE mGdal;

static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include <iostream>
using namespace std;

#include "cpl_port.h"
#include "cpl_string.h"

#include "gdal.h"
#include "gdal_priv.h"
#include "gdal_alg.h"
#include "gdalwarper.h"

typedef void GDALMajorObjectShadow;
typedef void GDALDriverShadow;
typedef void GDALDatasetShadow;
typedef void GDALRasterBandShadow;

typedef int FALSE_IS_ERR;



void VeryQuiteErrorHandler(CPLErr eclass, int code, const char *msg ) {
  /* If the error class is CE_Fatal, we want to have a message issued
     because the CPL support code does an abort() before any exception
     can be generated */
  if (eclass == CE_Fatal ) {
    CPLDefaultErrorHandler(eclass, code, msg );
  }
}


void UseExceptions() {
  CPLSetErrorHandler( (CPLErrorHandler) VeryQuiteErrorHandler );
}

void DontUseExceptions() {
  CPLSetErrorHandler( CPLDefaultErrorHandler );
}


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


SWIGINTERN void SWIG_exception_(int code, const char *msg) {
    switch (code) {
        case SWIG_MemoryError:
            rb_raise(rb_eNoMemError, msg);
            break;
        case SWIG_IOError:
            rb_raise(rb_eIOError, msg);
            break;
        case SWIG_RuntimeError:
            rb_raise(rb_eRuntimeError, msg);
            break;
        case SWIG_IndexError:
            rb_raise(rb_eIndexError, msg);
            break;
        case SWIG_TypeError:
            rb_raise(rb_eTypeError, msg);
            break;
        case SWIG_DivisionByZero:
            rb_raise(rb_eZeroDivError, msg);
            break;
        case SWIG_OverflowError:
            rb_raise(rb_eRangeError, msg);
            break;
        case SWIG_SyntaxError:
            rb_raise(rb_eSyntaxError, msg);
            break;
        case SWIG_ValueError:
            rb_raise(rb_eArgError, msg);
            break;
        case SWIG_SystemError:
            rb_raise(rb_eFatal, msg);
            break;
        case SWIG_UnknownError:
            rb_raise(rb_eRuntimeError, msg);
            break;
        default:
            break;
    }
}

#define SWIG_exception(a, b) SWIG_exception_((a), (b))


#include <stdexcept>



static CPLXMLNode *RubyArrayToXMLTree(VALUE rubyArray)
{
    int      nChildCount = 0, iChild, nType;
    CPLXMLNode *psThisNode;
    CPLXMLNode *psChild;
    char       *pszText = NULL;

    nChildCount = RARRAY(rubyArray)->len - 2;
    if( nChildCount < 0 )
    {
		 rb_raise(rb_eRuntimeError, "Error in input XMLTree, child count is less than zero.");
    }

	 VALUE item1 = rb_ary_entry(rubyArray, 0);
	 nType = NUM2INT(item1);

	 VALUE item2 = rb_ary_entry(rubyArray, 1);
	 pszText = StringValuePtr(item2);

    psThisNode = CPLCreateXMLNode( NULL, (CPLXMLNodeType) nType, pszText );

    for( iChild = 0; iChild < nChildCount; iChild++ )
    {
        psChild = RubyArrayToXMLTree( rb_ary_entry(rubyArray,iChild+2) );
        CPLAddXMLChild( psThisNode, psChild );
    }

    return psThisNode;
}

static VALUE XMLTreeToRubyArray( CPLXMLNode *psTree )
{
    int      nChildCount = 0, iChild;
    CPLXMLNode *psChild;

    for( psChild = psTree->psChild; 
         psChild != NULL; 
         psChild = psChild->psNext )
        nChildCount++;

    VALUE rubyArray = rb_ary_new2(nChildCount+2);

	 rb_ary_store(rubyArray, 0, INT2NUM((int) psTree->eType));
	 rb_ary_store(rubyArray, 1, rb_str_new2(psTree->pszValue));

    for( psChild = psTree->psChild, iChild = 2; 
         psChild != NULL; 
         psChild = psChild->psNext, iChild++ )
    {
        rb_ary_store(rubyArray, iChild, XMLTreeToRubyArray(psChild));
    }

    return rubyArray; 
}


  void Debug( const char *msg_class, const char *message ) {
    CPLDebug( msg_class, message );
  }
  void Error( CPLErr msg_class = CE_Failure, int err_code = 0, const char* msg = "error" ) {
    CPLError( msg_class, err_code, msg );
  }

  CPLErr PushErrorHandler( char const * pszCallbackName = "CPLQuietErrorHandler" ) {
    CPLErrorHandler pfnHandler = NULL;
    if( EQUAL(pszCallbackName,"CPLQuietErrorHandler") )
      pfnHandler = CPLQuietErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLDefaultErrorHandler") )
      pfnHandler = CPLDefaultErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLLoggingErrorHandler") )
      pfnHandler = CPLLoggingErrorHandler;

    if ( pfnHandler == NULL )
      return CE_Fatal;

    CPLPushErrorHandler( pfnHandler );

    return CE_None;
  }


static char const *GDALMajorObjectShadow_GetDescription(GDALMajorObjectShadow *self){
    return GDALGetDescription( self );
  }
static void GDALMajorObjectShadow_SetDescription(GDALMajorObjectShadow *self,char const *pszNewDesc){
    GDALSetDescription( self, pszNewDesc );
  }
static char **GDALMajorObjectShadow_GetMetadata_Dict(GDALMajorObjectShadow *self,char const *pszDomain=""){
    return GDALGetMetadata( self, pszDomain );
  }
static char **GDALMajorObjectShadow_GetMetadata_List(GDALMajorObjectShadow *self,char const *pszDomain=""){
    return GDALGetMetadata( self, pszDomain );
  }
static CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_0(GDALMajorObjectShadow *self,char **papszMetadata,char const *pszDomain=""){
    return GDALSetMetadata( self, papszMetadata, pszDomain );
  }
static CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_1(GDALMajorObjectShadow *self,char *pszMetadataString,char const *pszDomain=""){
    char *tmpList[2];
    tmpList[0] = pszMetadataString;
    tmpList[1] = 0;
    return GDALSetMetadata( self, tmpList, pszDomain );
  }
static GDALDatasetShadow *GDALDriverShadow_Create(GDALDriverShadow *self,char const *name,int xsize,int ysize,int bands=1,GDALDataType eType=GDT_Byte,char **options=0){
    GDALDatasetShadow* ds = (GDALDatasetShadow*) GDALCreate( self, name, xsize, ysize, bands, eType, options );
    return ds;
  }
static GDALDatasetShadow *GDALDriverShadow_CreateCopy(GDALDriverShadow *self,char const *name,GDALDatasetShadow *src,int strict=1,char **options=0){
    GDALDatasetShadow *ds = (GDALDatasetShadow*) GDALCreateCopy(self, name, src, strict, 0, 0, 0 );
    return ds;
  }
static int GDALDriverShadow_Delete(GDALDriverShadow *self,char const *name){
    return GDALDeleteDataset( self, name );
  }

char const *GDALDriverShadow_ShortName_get( GDALDriverShadow *h ) {
  return GDALGetDriverShortName( h );
}
char const *GDALDriverShadow_LongName_get( GDALDriverShadow *h ) {
  return GDALGetDriverLongName( h );
}
char const *GDALDriverShadow_HelpTopic_get( GDALDriverShadow *h ) {
  return GDALGetDriverHelpTopic( h );
}

static GDAL_GCP *new_GDAL_GCP(double x=0.0,double y=0.0,double z=0.0,double pixel=0.0,double line=0.0,char const *info="",char const *id=""){
    GDAL_GCP *self = (GDAL_GCP*) CPLMalloc( sizeof( GDAL_GCP ) );
    self->dfGCPX = x;
    self->dfGCPY = y;
    self->dfGCPZ = z;
    self->dfGCPPixel = pixel;
    self->dfGCPLine = line;
    self->pszInfo =  CPLStrdup( (info == 0) ? "" : info );
    self->pszId = CPLStrdup( (id==0)? "" : id );
    return self;
  }


double GDAL_GCP_GCPX_get( GDAL_GCP *h ) {
  return h->dfGCPX;
}
void GDAL_GCP_GCPX_set( GDAL_GCP *h, double val ) {
  h->dfGCPX = val;
}
double GDAL_GCP_GCPY_get( GDAL_GCP *h ) {
  return h->dfGCPY;
}
void GDAL_GCP_GCPY_set( GDAL_GCP *h, double val ) {
  h->dfGCPY = val;
}
double GDAL_GCP_GCPZ_get( GDAL_GCP *h ) {
  return h->dfGCPZ;
}
void GDAL_GCP_GCPZ_set( GDAL_GCP *h, double val ) {
  h->dfGCPZ = val;
}
double GDAL_GCP_GCPPixel_get( GDAL_GCP *h ) {
  return h->dfGCPPixel;
}
void GDAL_GCP_GCPPixel_set( GDAL_GCP *h, double val ) {
  h->dfGCPPixel = val;
}
double GDAL_GCP_GCPLine_get( GDAL_GCP *h ) {
  return h->dfGCPLine;
}
void GDAL_GCP_GCPLine_set( GDAL_GCP *h, double val ) {
  h->dfGCPLine = val;
}
const char * GDAL_GCP_Info_get( GDAL_GCP *h ) {
  return h->pszInfo;
}
void GDAL_GCP_Info_set( GDAL_GCP *h, const char * val ) {
  if ( h->pszInfo ) 
    CPLFree( h->pszInfo );
  h->pszInfo = CPLStrdup(val);
}
const char * GDAL_GCP_Id_get( GDAL_GCP *h ) {
  return h->pszId;
}
void GDAL_GCP_Id_set( GDAL_GCP *h, const char * val ) {
  if ( h->pszId ) 
    CPLFree( h->pszId );
  h->pszId = CPLStrdup(val);
}



/* Duplicate, but transposed names for C# because 
*  the C# module outputs backwards names
*/
double GDAL_GCP_get_GCPX( GDAL_GCP *h ) {
  return h->dfGCPX;
}
void GDAL_GCP_set_GCPX( GDAL_GCP *h, double val ) {
  h->dfGCPX = val;
}
double GDAL_GCP_get_GCPY( GDAL_GCP *h ) {
  return h->dfGCPY;
}
void GDAL_GCP_set_GCPY( GDAL_GCP *h, double val ) {
  h->dfGCPY = val;
}
double GDAL_GCP_get_GCPZ( GDAL_GCP *h ) {
  return h->dfGCPZ;
}
void GDAL_GCP_set_GCPZ( GDAL_GCP *h, double val ) {
  h->dfGCPZ = val;
}
double GDAL_GCP_get_GCPPixel( GDAL_GCP *h ) {
  return h->dfGCPPixel;
}
void GDAL_GCP_set_GCPPixel( GDAL_GCP *h, double val ) {
  h->dfGCPPixel = val;
}
double GDAL_GCP_get_GCPLine( GDAL_GCP *h ) {
  return h->dfGCPLine;
}
void GDAL_GCP_set_GCPLine( GDAL_GCP *h, double val ) {
  h->dfGCPLine = val;
}
const char * GDAL_GCP_get_Info( GDAL_GCP *h ) {
  return h->pszInfo;
}
void GDAL_GCP_set_Info( GDAL_GCP *h, const char * val ) {
  if ( h->pszInfo ) 
    CPLFree( h->pszInfo );
  h->pszInfo = CPLStrdup(val);
}
const char * GDAL_GCP_get_Id( GDAL_GCP *h ) {
  return h->pszId;
}
void GDAL_GCP_set_Id( GDAL_GCP *h, const char * val ) {
  if ( h->pszId ) 
    CPLFree( h->pszId );
  h->pszId = CPLStrdup(val);
}


static GDALDriverShadow *GDALDatasetShadow_GetDriver(GDALDatasetShadow *self){
    return (GDALDriverShadow*) GDALGetDatasetDriver( self );
  }
static GDALRasterBandShadow *GDALDatasetShadow_GetRasterBand(GDALDatasetShadow *self,int nBand){
    return (GDALRasterBandShadow*) GDALGetRasterBand( self, nBand );
  }
static char const *GDALDatasetShadow_GetProjection(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
static char const *GDALDatasetShadow_GetProjectionRef(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
static CPLErr GDALDatasetShadow_SetProjection(GDALDatasetShadow *self,char const *prj){
    return GDALSetProjection( self, prj );
  }
static void GDALDatasetShadow_GetGeoTransform(GDALDatasetShadow *self,double argout[6]){
    if ( GDALGetGeoTransform( self, argout ) != 0 ) {
      argout[0] = 0.0;
      argout[1] = 1.0;
      argout[2] = 0.0;
      argout[3] = 0.0;
      argout[4] = 0.0;
      argout[5] = 1.0;
    }
  }
static CPLErr GDALDatasetShadow_SetGeoTransform(GDALDatasetShadow *self,double argin[6]){
    return GDALSetGeoTransform( self, argin );
  }
static int GDALDatasetShadow_BuildOverviews(GDALDatasetShadow *self,char const *resampling="NEAREST",int overviewlist=0,int *pOverviews=0){
    return GDALBuildOverviews( self, resampling, overviewlist, pOverviews, 0, 0, 0, 0);
  }
static int GDALDatasetShadow_GetGCPCount(GDALDatasetShadow *self){
    return GDALGetGCPCount( self );
  }
static char const *GDALDatasetShadow_GetGCPProjection(GDALDatasetShadow *self){
    return GDALGetGCPProjection( self );
  }
static void GDALDatasetShadow_GetGCPs(GDALDatasetShadow *self,int *nGCPs,GDAL_GCP const **pGCPs){
    *nGCPs = GDALGetGCPCount( self );
    *pGCPs = GDALGetGCPs( self );
  }
static CPLErr GDALDatasetShadow_SetGCPs(GDALDatasetShadow *self,int nGCPs,GDAL_GCP const *pGCPs,char const *pszGCPProjection){
    return GDALSetGCPs( self, nGCPs, pGCPs, pszGCPProjection );
  }
static void GDALDatasetShadow_FlushCache(GDALDatasetShadow *self){
    GDALFlushCache( self );
  }
static CPLErr GDALDatasetShadow_AddBand(GDALDatasetShadow *self,GDALDataType datatype=GDT_Byte,char **options=0){
    return GDALAddBand( self, datatype, options );
  }
static CPLErr GDALDatasetShadow_WriteRaster(GDALDatasetShadow *self,int xoff,int yoff,int xsize,int ysize,int buf_len,char *buf_string,int *buf_xsize=0,int *buf_ysize=0,GDALDataType *buf_type=0,int band_list=0,int *pband_list=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype;
    if ( buf_type != 0 ) {
      ntype = (GDALDataType) *buf_type;
    } else {
      int lastband = GDALGetRasterCount( self ) - 1;
      ntype = GDALGetRasterDataType( GDALGetRasterBand( self, lastband ) );
    }
    bool myBandList = false;
    int nBandCount;
    int *pBandList;
    if ( band_list != 0 ) {
      myBandList = false;
      nBandCount = band_list;
      pBandList = pband_list;
    }
    else {
      myBandList = true;
      nBandCount = GDALGetRasterCount( self );
      pBandList = (int*) CPLMalloc( sizeof(int) * nBandCount );
      for( int i = 0; i< nBandCount; ++i ) {
        pBandList[i] = i;
      }
    }
    return GDALDatasetRasterIO( self, GF_Write, xoff, yoff, xsize, ysize,
                                (void*) buf_string, nxsize, nysize, ntype,
                                band_list, pband_list, 0, 0, 0 );
    if ( myBandList ) {
       CPLFree( pBandList );
    }
  }

int GDALDatasetShadow_RasterXSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterXSize( h );
}
int GDALDatasetShadow_RasterYSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterYSize( h );
}
int GDALDatasetShadow_RasterCount_get( GDALDatasetShadow *h ) {
  return GDALGetRasterCount( h );
}


static
CPLErr ReadRaster_internal( GDALRasterBandShadow *obj, 
                            int xoff, int yoff, int xsize, int ysize,
                            int buf_xsize, int buf_ysize,
                            GDALDataType buf_type,
                            int *buf_size, char **buf )
{

  *buf_size = buf_xsize * buf_ysize * GDALGetDataTypeSize( buf_type ) / 8;
  *buf = (char*) malloc( *buf_size );
  CPLErr result =  GDALRasterIO( obj, GF_Read, xoff, yoff, xsize, ysize,
                                 (void *) *buf, buf_xsize, buf_ysize,
                                 buf_type, 0, 0 );
  if ( result != CE_None ) {
    free( *buf );
    *buf = 0;
    *buf_size = 0;
  }
  return result;
}

static
CPLErr WriteRaster_internal( GDALRasterBandShadow *obj,
                             int xoff, int yoff, int xsize, int ysize,
                             int buf_xsize, int buf_ysize,
                             GDALDataType buf_type,
                             int buf_size, char *buffer )
{
    if ( buf_size < buf_xsize * buf_ysize * GDALGetDataTypeSize( buf_type) /8 ) {
      return CE_Failure;
    }

    return GDALRasterIO( obj, GF_Write, xoff, yoff, xsize, ysize, 
		        (void *) buffer, buf_xsize, buf_ysize, buf_type, 0, 0 );
}

static GDALColorInterp GDALRasterBandShadow_GetRasterColorInterpretation(GDALRasterBandShadow *self){
    return GDALGetRasterColorInterpretation( self );
  }
static CPLErr GDALRasterBandShadow_SetRasterColorInterpretation(GDALRasterBandShadow *self,GDALColorInterp val){
    return GDALSetRasterColorInterpretation( self, val );
  }
static void GDALRasterBandShadow_GetNoDataValue(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterNoDataValue( self, hasval );
  }
static CPLErr GDALRasterBandShadow_SetNoDataValue(GDALRasterBandShadow *self,double d){
    return GDALSetRasterNoDataValue( self, d );
  }
static void GDALRasterBandShadow_GetMinimum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMinimum( self, hasval );
  }
static void GDALRasterBandShadow_GetMaximum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMaximum( self, hasval );
  }
static void GDALRasterBandShadow_GetOffset(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterOffset( self, hasval );
  }
static void GDALRasterBandShadow_GetScale(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterScale( self, hasval );
  }
static int GDALRasterBandShadow_GetOverviewCount(GDALRasterBandShadow *self){
    return GDALGetOverviewCount( self );
  }
static GDALRasterBandShadow *GDALRasterBandShadow_GetOverview(GDALRasterBandShadow *self,int i){
    return (GDALRasterBandShadow*) GDALGetOverview( self, i );
  }
static int GDALRasterBandShadow_Checksum(GDALRasterBandShadow *self,int xoff=0,int yoff=0,int *xsize=0,int *ysize=0){
    int nxsize = (xsize!=0) ? *xsize : GDALGetRasterBandXSize( self );
    int nysize = (ysize!=0) ? *ysize : GDALGetRasterBandYSize( self );
    return GDALChecksumImage( self, xoff, yoff, nxsize, nysize );
  }
static void GDALRasterBandShadow_ComputeRasterMinMax(GDALRasterBandShadow *self,double argout[2],int approx_ok=0){
    GDALComputeRasterMinMax( self, approx_ok, argout );
  }
static CPLErr GDALRasterBandShadow_Fill(GDALRasterBandShadow *self,double real_fill,double imag_fill=0.0){
    return GDALFillRaster( self, real_fill, imag_fill );
  }
static CPLErr GDALRasterBandShadow_ReadRaster(GDALRasterBandShadow *self,int xoff,int yoff,int xsize,int ysize,int *buf_len,char **buf,int *buf_xsize=0,int *buf_ysize=0,int *buf_type=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype  = (buf_type==0) ? GDALGetRasterDataType(self)
                                        : (GDALDataType)*buf_type;
    return ReadRaster_internal( self, xoff, yoff, xsize, ysize,
                                nxsize, nysize, ntype, buf_len, buf );
  }
static CPLErr GDALRasterBandShadow_WriteRaster(GDALRasterBandShadow *self,int xoff,int yoff,int xsize,int ysize,int buf_len,char *buf_string,int *buf_xsize=0,int *buf_ysize=0,int *buf_type=0){
    int nxsize = (buf_xsize==0) ? xsize : *buf_xsize;
    int nysize = (buf_ysize==0) ? ysize : *buf_ysize;
    GDALDataType ntype  = (buf_type==0) ? GDALGetRasterDataType(self)
                                        : (GDALDataType)*buf_type;
    return WriteRaster_internal( self, xoff, yoff, xsize, ysize,
                                 nxsize, nysize, ntype, buf_len, buf_string );
  }
static void GDALRasterBandShadow_FlushCache(GDALRasterBandShadow *self){
    GDALFlushRasterCache( self );
  }
static GDALColorTable *GDALRasterBandShadow_GetRasterColorTable(GDALRasterBandShadow *self){
    return (GDALColorTable*) GDALGetRasterColorTable( self );
  }
static int GDALRasterBandShadow_SetRasterColorTable(GDALRasterBandShadow *self,GDALColorTable *arg){
    return GDALSetRasterColorTable( self, arg );
  }

GDALDataType GDALRasterBandShadow_DataType_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterDataType( h );
}
int GDALRasterBandShadow_XSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandXSize( h );
}
int GDALRasterBandShadow_YSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandYSize( h );
}


int GetDriverCount() {
  return GDALGetDriverCount();
}


GDALDriverShadow* GetDriverByName( char const *name ) {
  return (GDALDriverShadow*) GDALGetDriverByName( name );
}


GDALDriverShadow* GetDriver( int i ) {
  return (GDALDriverShadow*) GDALGetDriver( i );
}


GDALDatasetShadow* Open( char const* name, GDALAccess eAccess = GA_ReadOnly ) {
  GDALDatasetShadow *ds = GDALOpen( name, eAccess );
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow* OpenShared( char const* name, GDALAccess eAccess = GA_ReadOnly ) {
  GDALDatasetShadow *ds = GDALOpenShared( name, eAccess );
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow *AutoCreateWarpedVRT( GDALDatasetShadow *src_ds,
                                        const char *src_wkt = 0,
                                        const char *dst_wkt = 0,
                                        GDALResampleAlg eResampleAlg = GRA_NearestNeighbour,
                                        double maxerror = 0.0 ) {
  GDALDatasetShadow *ds = GDALAutoCreateWarpedVRT( src_ds, src_wkt,
                                                   dst_wkt,
                                                   eResampleAlg,
                                                   maxerror,
                                                   0 );
  if (ds == 0) {
    throw CPLGetLastErrorMsg();
  }
  return ds;
  
}

static VALUE
_wrap_UseExceptions(int argc, VALUE *argv, VALUE self) {
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    UseExceptions();
    
    return Qnil;
}


static VALUE
_wrap_DontUseExceptions(int argc, VALUE *argv, VALUE self) {
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    DontUseExceptions();
    
    return Qnil;
}


static VALUE
_wrap_debug(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = StringValuePtr(argv[0]);
    arg2 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        Debug((char const *)arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_error(int argc, VALUE *argv, VALUE self) {
    CPLErr arg1 = (CPLErr) CE_Failure ;
    int arg2 = (int) 0 ;
    char *arg3 = (char *) "error" ;
    
    if ((argc < 0) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        {
            /* %typemap(ruby,in) CPLErr */
            arg1 = (CPLErr) NUM2INT(argv[0]);
        }
    }
    if (argc > 1) {
        arg2 = NUM2INT(argv[1]);
    }
    if (argc > 2) {
        arg3 = StringValuePtr(argv[2]);
    }
    {
        CPLErrorReset();
        Error(arg1,arg2,(char const *)arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_push_error_handler__SWIG_0(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) "CPLQuietErrorHandler" ;
    CPLErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = StringValuePtr(argv[0]);
    }
    {
        CPLErrorReset();
        result = (CPLErr)PushErrorHandler((char const *)arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    return vresult;
}


static VALUE
_wrap_push_error_handler__SWIG_1(int argc, VALUE *argv, VALUE self) {
    CPLErrorHandler arg1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        CPLErrorHandler * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_CPLErrorHandler, 0);
        if (ptr) arg1 = *ptr;
    }
    {
        CPLErrorReset();
        CPLPushErrorHandler(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE _wrap_push_error_handler(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[1];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 1); ii++) {
        argv[ii] = args[ii];
    }
    if ((argc >= 0) && (argc <= 1)) {
        int _v;
        if (argc <= 0) {
            return _wrap_push_error_handler__SWIG_0(nargs, args, self);
        }
        {
            _v = (TYPE(argv[0]) == T_STRING) ? 1 : 0;
        }
        if (_v) {
            return _wrap_push_error_handler__SWIG_0(nargs, args, self);
        }
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_CPLErrorHandler, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            return _wrap_push_error_handler__SWIG_1(nargs, args, self);
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'push_error_handler'");
    return Qnil;
}


static VALUE
_wrap_pop_error_handler(int argc, VALUE *argv, VALUE self) {
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        CPLPopErrorHandler();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_error_reset(int argc, VALUE *argv, VALUE self) {
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        CPLErrorReset();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_get_last_error_no(int argc, VALUE *argv, VALUE self) {
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        result = (int)CPLGetLastErrorNo();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_get_last_error_type(int argc, VALUE *argv, VALUE self) {
    CPLErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        result = (CPLErr)CPLGetLastErrorType();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    return vresult;
}


static VALUE
_wrap_get_last_error_msg(int argc, VALUE *argv, VALUE self) {
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        result = (char *)CPLGetLastErrorMsg();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_push_finder_location(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        CPLPushFinderLocation((char const *)arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_pop_finder_location(int argc, VALUE *argv, VALUE self) {
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        CPLPopFinderLocation();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_finder_clean(int argc, VALUE *argv, VALUE self) {
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        CPLFinderClean();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_find_file(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = StringValuePtr(argv[0]);
    arg2 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        result = (char *)CPLFindFile((char const *)arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_set_config_option(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = StringValuePtr(argv[0]);
    arg2 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        CPLSetConfigOption((char const *)arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_get_config_option(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = StringValuePtr(argv[0]);
    arg2 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        result = (char *)CPLGetConfigOption((char const *)arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


swig_class cMajorObject;

static VALUE
_wrap_MajorObject_get_description(int argc, VALUE *argv, VALUE self) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0);
    {
        CPLErrorReset();
        result = (char *)GDALMajorObjectShadow_GetDescription(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_MajorObject_set_description(int argc, VALUE *argv, VALUE self) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        GDALMajorObjectShadow_SetDescription(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_MajorObject_get_metadata_dict(int argc, VALUE *argv, VALUE self) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char *arg2 = (char *) "" ;
    char **result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0);
    if (argc > 0) {
        arg2 = StringValuePtr(argv[0]);
    }
    {
        CPLErrorReset();
        result = (char **)GDALMajorObjectShadow_GetMetadata_Dict(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) char **dict */
        
        /* Get a pointer to the c array */
        char **stringarray = result;
        
        /* Create a new hash table, this will be returned to Ruby.  */
        vresult = rb_hash_new();
        if ( stringarray != NULL ) {
            while (*stringarray != NULL ) {
                /* Get the key and value */
                char const *valptr;
                char *keyptr;
                valptr = CPLParseNameValue( *stringarray, &keyptr );
                
                if ( valptr != 0 ) {
                    /* Convert the key and value to Ruby strings */
                    VALUE nm = rb_str_new2( keyptr );
                    VALUE val = rb_str_new2( valptr );
                    /* Save the key, value pair to the hash table. */
                    rb_hash_aset(vresult, nm, val);
                    CPLFree( keyptr );
                }
                stringarray++;
            }
        }
    }
    return vresult;
}


static VALUE
_wrap_MajorObject_get_metadata_list(int argc, VALUE *argv, VALUE self) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char *arg2 = (char *) "" ;
    char **result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0);
    if (argc > 0) {
        arg2 = StringValuePtr(argv[0]);
    }
    {
        CPLErrorReset();
        result = (char **)GDALMajorObjectShadow_GetMetadata_List(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) char **options */
        
        char **stringarray = result;
        if ( stringarray == NULL ) {
            vresult = Qnil;
        }
        else {
            int len = CSLCount( stringarray );
            vresult = rb_ary_new2( len );
            for ( int i = 0; i < len; ++i, ++stringarray ) {
                VALUE nm = rb_str_new2( *stringarray );
                rb_ary_push(vresult, nm);
            }
            CSLDestroy( result );
        }
    }
    return vresult;
}


static VALUE
_wrap_MajorObject_set_metadata__SWIG_0(int argc, VALUE *argv, VALUE self) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    char *arg3 = (char *) "" ;
    CPLErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0);
    {
        /* %typemap(ruby,in) char **dict */
        
        arg2 = NULL;
        
        /* is the provided object an array or a hash? */
        if ( TYPE(argv[0]) == T_ARRAY) {
            /* get the size of the array */
            int size = RARRAY(argv[0])->len;
            
            for (int i = 0; i < size; i++) {
                /* get the ruby object */
                VALUE value = rb_ary_entry(argv[0], i);
                
                /* Convert the value to a string via ruby duck typing 
                       * (i.e., the object might not actually be a string)
                       */
                char *pszItem = StringValuePtr(value);
                arg2 = CSLAddString( arg2, pszItem );
            }
        }
        
        else if ( TYPE(argv[0]) == T_HASH) {
            /* This is a hash - get the size by calling via the ruby method */
            int size = NUM2INT(rb_funcall(argv[0], rb_intern("size"), 0, NULL));
            
            if ( size > 0 ) {
                /* Get the keys by caling via ruby */
                VALUE keys_arr = rb_funcall(argv[0], rb_intern("keys"), 0, NULL);
                
                for( int i=0; i<size; i++ ) {
                    /* Get the key and value as ruby objects */
                    VALUE key = rb_ary_entry(keys_arr, i);
                    VALUE value = rb_hash_aref(argv[0], key);
                    
                    /* Convert the key and value to strings via ruby duck typing 
                             * (i.e., the objects might not actually be strings)
                             */
                    char *nm = StringValuePtr(key);
                    char *val = StringValuePtr(value);
                    
                    /* Add the value */
                    arg2 = CSLAddNameValue( arg2, nm, val );
                }
            }
        }
        else {
            rb_raise(rb_eTypeError, "Argument must be dictionary or sequence of strings");
        }
    }
    if (argc > 1) {
        arg3 = StringValuePtr(argv[1]);
    }
    {
        CPLErrorReset();
        result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_0(arg1,arg2,(char const *)arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    {
        /* %typemap(ruby,freearg) char **dict */
        CSLDestroy( arg2 );
    }
    return vresult;
}


static VALUE
_wrap_MajorObject_set_metadata__SWIG_1(int argc, VALUE *argv, VALUE self) {
    GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) "" ;
    CPLErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALMajorObjectShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    if (argc > 1) {
        arg3 = StringValuePtr(argv[1]);
    }
    {
        CPLErrorReset();
        result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_1(arg1,arg2,(char const *)arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    return vresult;
}


static VALUE _wrap_MajorObject_set_metadata(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii-1];
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_GDALMajorObjectShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                /* %typemap(ruby,typecheck,precedence=SWIG_TYPECHECK_POINTER) (char **dict) */
                _v = ((TYPE(argv[1]) == T_HASH) || (TYPE(argv[1]) == T_ARRAY)) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_MajorObject_set_metadata__SWIG_0(nargs, args, self);
                }
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_MajorObject_set_metadata__SWIG_0(nargs, args, self);
                }
            }
        }
    }
    if ((argc >= 2) && (argc <= 3)) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_GDALMajorObjectShadow, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (TYPE(argv[1]) == T_STRING) ? 1 : 0;
            }
            if (_v) {
                if (argc <= 2) {
                    return _wrap_MajorObject_set_metadata__SWIG_1(nargs, args, self);
                }
                {
                    _v = (TYPE(argv[2]) == T_STRING) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_MajorObject_set_metadata__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'MajorObject_set_metadata'");
    return Qnil;
}


swig_class cDriver;

static VALUE
_wrap_Driver_short_name_get(int argc, VALUE *argv, VALUE self) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0);
    {
        CPLErrorReset();
        result = (char *)GDALDriverShadow_ShortName_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Driver_long_name_get(int argc, VALUE *argv, VALUE self) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0);
    {
        CPLErrorReset();
        result = (char *)GDALDriverShadow_LongName_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Driver_help_topic_get(int argc, VALUE *argv, VALUE self) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0);
    {
        CPLErrorReset();
        result = (char *)GDALDriverShadow_HelpTopic_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Driver_create_(int argc, VALUE *argv, VALUE self) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int arg3 ;
    int arg4 ;
    int arg5 = (int) 1 ;
    GDALDataType arg6 = (GDALDataType) GDT_Byte ;
    char **arg7 = (char **) 0 ;
    GDALDatasetShadow *result;
    char *kwnames[] = {
        "self","name","xsize","ysize","bands","eType","options", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    if (argc > 3) {
        arg5 = NUM2INT(argv[3]);
    }
    if (argc > 4) {
        {
            /* %typemap(ruby,in) CPLErr */
            arg6 = (GDALDataType) NUM2INT(argv[4]);
        }
    }
    if (argc > 5) {
        {
            /* %typemap(ruby,in) char **options */
            
            /* Check if is a list */
            Check_Type(argv[5], T_ARRAY);
            
            int size = RARRAY(argv[5])->len;
            for (int i = 0; i < size; i++) {
                VALUE item = rb_ary_entry(argv[5], i);
                char *pszItem = StringValuePtr(item);
                arg7 = CSLAddString( arg7, pszItem );
            }
        }
    }
    {
        CPLErrorReset();
        result = (GDALDatasetShadow *)GDALDriverShadow_Create(arg1,(char const *)arg2,arg3,arg4,arg5,arg6,arg7);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALDatasetShadow,1);
    {
        /* %typemap(ruby,freearg) char **options */
        
        CSLDestroy( arg7 );
    }
    return vresult;
}


static VALUE
_wrap_Driver_create_copy(int argc, VALUE *argv, VALUE self) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    GDALDatasetShadow *arg3 = (GDALDatasetShadow *) 0 ;
    int arg4 = (int) 1 ;
    char **arg5 = (char **) 0 ;
    GDALDatasetShadow *result;
    char *kwnames[] = {
        "self","name","src","strict","options", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_GDALDatasetShadow, 0);
    if (argc > 2) {
        arg4 = NUM2INT(argv[2]);
    }
    if (argc > 3) {
        {
            /* %typemap(ruby,in) char **options */
            
            /* Check if is a list */
            Check_Type(argv[3], T_ARRAY);
            
            int size = RARRAY(argv[3])->len;
            for (int i = 0; i < size; i++) {
                VALUE item = rb_ary_entry(argv[3], i);
                char *pszItem = StringValuePtr(item);
                arg5 = CSLAddString( arg5, pszItem );
            }
        }
    }
    {
        CPLErrorReset();
        result = (GDALDatasetShadow *)GDALDriverShadow_CreateCopy(arg1,(char const *)arg2,arg3,arg4,arg5);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALDatasetShadow,1);
    {
        /* %typemap(ruby,freearg) char **options */
        
        CSLDestroy( arg5 );
    }
    return vresult;
}


static VALUE
_wrap_Driver_delete_(int argc, VALUE *argv, VALUE self) {
    GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDriverShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (int)GDALDriverShadow_Delete(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


swig_class cGCP;

static VALUE
_wrap_GCP_gcpx_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        CPLErrorReset();
        GDAL_GCP_GCPX_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_GCP_gcpx_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_GCPX_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_GCP_gcpy_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        CPLErrorReset();
        GDAL_GCP_GCPY_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_GCP_gcpy_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_GCPY_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_GCP_gcpz_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        CPLErrorReset();
        GDAL_GCP_GCPZ_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_GCP_gcpz_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_GCPZ_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_GCP_gcppixel_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        CPLErrorReset();
        GDAL_GCP_GCPPixel_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_GCP_gcppixel_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_GCPPixel_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_GCP_gcpline_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        CPLErrorReset();
        GDAL_GCP_GCPLine_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_GCP_gcpline_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_GCPLine_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_GCP_info_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        GDAL_GCP_Info_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_GCP_info_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (char *)GDAL_GCP_Info_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_GCP_id_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        GDAL_GCP_Id_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_GCP_id_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (char *)GDAL_GCP_Id_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_GCP_allocate(VALUE self) {
#else
    static VALUE
    _wrap_GCP_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_GDAL_GCP);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_GCP(int argc, VALUE *argv, VALUE self) {
    double arg1 = (double) 0.0 ;
    double arg2 = (double) 0.0 ;
    double arg3 = (double) 0.0 ;
    double arg4 = (double) 0.0 ;
    double arg5 = (double) 0.0 ;
    char *arg6 = (char *) "" ;
    char *arg7 = (char *) "" ;
    GDAL_GCP *result;
    
    if ((argc < 0) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = (double) NUM2DBL(argv[0]);
    }
    if (argc > 1) {
        arg2 = (double) NUM2DBL(argv[1]);
    }
    if (argc > 2) {
        arg3 = (double) NUM2DBL(argv[2]);
    }
    if (argc > 3) {
        arg4 = (double) NUM2DBL(argv[3]);
    }
    if (argc > 4) {
        arg5 = (double) NUM2DBL(argv[4]);
    }
    if (argc > 5) {
        arg6 = StringValuePtr(argv[5]);
    }
    if (argc > 6) {
        arg7 = StringValuePtr(argv[6]);
    }
    {
        CPLErrorReset();
        result = (GDAL_GCP *)new_GDAL_GCP(arg1,arg2,arg3,arg4,arg5,(char const *)arg6,(char const *)arg7);
        DATA_PTR(self) = result;
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return self;
}


static void delete_GDAL_GCP(GDAL_GCP *self){
    if ( self->pszInfo )
      CPLFree( self->pszInfo );
    if ( self->pszId )
      CPLFree( self->pszId );
    CPLFree( self );
  }
static void
free_GDAL_GCP(GDAL_GCP *arg1) {
    delete_GDAL_GCP(arg1);
}

static VALUE
_wrap_gdal_gcp_gcpx_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_GCPX_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_gcpx_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_GCPX_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_gcpy_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_GCPY_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_gcpy_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_GCPY_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_gcpz_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_GCPZ_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_gcpz_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_GCPZ_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_gcppixel_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_GCPPixel_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_gcppixel_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_GCPPixel_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_gcpline_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_GCPLine_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_gcpline_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_GCPLine_set(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_info_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (char *)GDAL_GCP_Info_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_info_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_Info_set(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_id_get(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (char *)GDAL_GCP_Id_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_id_set(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_Id_set(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_get_gcpx(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_get_GCPX(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_set_gcpx(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_set_GCPX(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_get_gcpy(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_get_GCPY(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_set_gcpy(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_set_GCPY(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_get_gcpz(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_get_GCPZ(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_set_gcpz(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_set_GCPZ(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_get_gcppixel(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_get_GCPPixel(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_set_gcppixel(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_set_GCPPixel(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_get_gcpline(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (double)GDAL_GCP_get_GCPLine(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_set_gcpline(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    double arg2 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = (double) NUM2DBL(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_set_GCPLine(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_get_info(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (char *)GDAL_GCP_get_Info(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_set_info(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_set_Info(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_gdal_gcp_get_id(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    {
        CPLErrorReset();
        result = (char *)GDAL_GCP_get_Id(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_gdal_gcp_set_id(int argc, VALUE *argv, VALUE self) {
    GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
    char *arg2 = (char *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDAL_GCP, 0);
    arg2 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        GDAL_GCP_set_Id(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_GCPsToGeoTransform(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    GDAL_GCP *arg2 = (GDAL_GCP *) 0 ;
    double *arg3 ;
    int arg4 = (int) 1 ;
    FALSE_IS_ERR result;
    GDAL_GCP *tmpGCPList1 ;
    double argout3[6] ;
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (double argout3[ANY]) */
        arg3 = argout3;
    }
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        /* %typemap(ruby, in,numinputs=1) (int nGCPs, GDAL_GCP const *pGCPs ) */
        
        /* Check if is a list */
        Check_Type(argv[0], T_ARRAY);
        
        arg1 = RARRAY(argv[0])->len;
        tmpGCPList1 = (GDAL_GCP*) malloc(arg1*sizeof(GDAL_GCP));
        arg2 = tmpGCPList1;
        
        for( int i = 0; i<arg1; i++ ) {
            VALUE rubyItem = rb_ary_entry(argv[0],i);
            GDAL_GCP *item = 0;
            
            SWIG_ConvertPtr( rubyItem, (void**)&item, SWIGTYPE_p_GDAL_GCP, SWIG_POINTER_EXCEPTION | 0 );
            
            if (!item) {
                rb_raise(rb_eRuntimeError, "GDAL_GCP item cannot be nil");
            }
            
            memcpy( (void*) item, (void*) tmpGCPList1, sizeof( GDAL_GCP ) );
            ++tmpGCPList1;
        }
    }
    if (argc > 1) {
        arg4 = NUM2INT(argv[1]);
    }
    {
        CPLErrorReset();
        result = GDALGCPsToGeoTransform(arg1,(GDAL_GCP const *)arg2,arg3,arg4);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) IF_FALSE_RETURN_NONE */
        if (result == 0 ) {
            vresult = Qnil;
        }
    }
    {
        /* %typemap(ruby,argout) (double argout[ANY]) */
        vresult = rb_ary_new();
        
        for(int i=0; i<6; i++)
        {
            VALUE value = rb_float_new(arg3[i]);
            rb_ary_push(vresult, value);
        }
    }
    {
        /* %typemap(ruby, freearg) (int nGCPs, GDAL_GCP const *pGCPs ) */
        if (arg2) {
            free( (void*) arg2 );
        }
    }
    return vresult;
}


swig_class cDataset;

static VALUE
_wrap_Dataset_raster_xsize_get(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        CPLErrorReset();
        result = (int)GDALDatasetShadow_RasterXSize_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Dataset_raster_ysize_get(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        CPLErrorReset();
        result = (int)GDALDatasetShadow_RasterYSize_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Dataset_raster_count_get(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        CPLErrorReset();
        result = (int)GDALDatasetShadow_RasterCount_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static void delete_GDALDatasetShadow(GDALDatasetShadow *self){
    if ( GDALDereferenceDataset( self ) <= 0 ) {
      GDALClose(self);
    }
  }
static void
free_GDALDatasetShadow(GDALDatasetShadow *arg1) {
    delete_GDALDatasetShadow(arg1);
}

static VALUE
_wrap_Dataset_get_driver(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    GDALDriverShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        CPLErrorReset();
        result = (GDALDriverShadow *)GDALDatasetShadow_GetDriver(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALDriverShadow,0);
    return vresult;
}


static VALUE
_wrap_Dataset_get_raster_band(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int arg2 ;
    GDALRasterBandShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (GDALRasterBandShadow *)GDALDatasetShadow_GetRasterBand(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALRasterBandShadow,0);
    return vresult;
}


static VALUE
_wrap_Dataset_get_projection(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        CPLErrorReset();
        result = (char *)GDALDatasetShadow_GetProjection(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Dataset_get_projection_ref(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        CPLErrorReset();
        result = (char *)GDALDatasetShadow_GetProjectionRef(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Dataset_set_projection(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    CPLErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    arg2 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (CPLErr)GDALDatasetShadow_SetProjection(arg1,(char const *)arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    return vresult;
}


static VALUE
_wrap_Dataset_get_geo_transform(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    double *arg2 ;
    double argout2[6] ;
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (double argout2[ANY]) */
        arg2 = argout2;
    }
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        CPLErrorReset();
        GDALDatasetShadow_GetGeoTransform(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,argout) (double argout[ANY]) */
        vresult = rb_ary_new();
        
        for(int i=0; i<6; i++)
        {
            VALUE value = rb_float_new(arg2[i]);
            rb_ary_push(vresult, value);
        }
    }
    return vresult;
}


static VALUE
_wrap_Dataset_set_geo_transform(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    double *arg2 ;
    CPLErr result;
    double argin2[6] ;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        /* %typemap(ruby,in) (double argin2[ANY]) (double argin2[6]) */
        /* Make sure this is an array. */
        Check_Type(argv[0], T_ARRAY);
        
        /* Get the length */
        int seq_size = RARRAY(argv[0])->len;
        
        if ( seq_size != 6 ) {
            rb_raise(rb_eRangeError, "sequence must have length %i.", seq_size);
        }
        
        for( int i = 0; i<6; i++ ) {
            /* Get the Ruby Object */
            VALUE item = rb_ary_entry(argv[0],i);
            
            /* Convert to double */
            arg2[i] = NUM2DBL(item);
        }
    }
    {
        CPLErrorReset();
        result = (CPLErr)GDALDatasetShadow_SetGeoTransform(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    return vresult;
}


static VALUE
_wrap_Dataset_build_overviews(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *arg2 = (char *) "NEAREST" ;
    int arg3 = (int) 0 ;
    int *arg4 = (int *) 0 ;
    int result;
    char *kwnames[] = {
        "self","resampling","overviewlist", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    if (argc > 0) {
        arg2 = StringValuePtr(argv[0]);
    }
    if (argc > 1) {
        {
            /* %typemap(ruby,in,numinputs=1) (int nList, int* pList) */
            
            /* Make sure this is an array. */
            Check_Type(argv[1], T_ARRAY);
            
            /* Get the length */
            arg3 = RARRAY(argv[1])->len;
            
            /* Allocate space for the C array. */
            arg4 = (int*) malloc(arg3*sizeof(int));
            
            for( int i = 0; i<arg3; i++ ) {
                /* Get the Ruby Object */
                VALUE item = rb_ary_entry(argv[1],i);
                /* Conver to an integer */
                arg4[i] = NUM2INT(item);
            }
        }
    }
    {
        CPLErrorReset();
        result = (int)GDALDatasetShadow_BuildOverviews(arg1,(char const *)arg2,arg3,arg4);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    {
        /* %typemap(ruby,freearg) (int nList, int* pList) */
        if (arg4) {
            free((void*) arg4);
        }
    }
    return vresult;
}


static VALUE
_wrap_Dataset_get_gcpcount(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        CPLErrorReset();
        result = (int)GDALDatasetShadow_GetGCPCount(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Dataset_get_gcpprojection(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        CPLErrorReset();
        result = (char *)GDALDatasetShadow_GetGCPProjection(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Dataset_get_gcps(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int *arg2 = (int *) 0 ;
    GDAL_GCP **arg3 = (GDAL_GCP **) 0 ;
    int nGCPs2 = 0 ;
    GDAL_GCP *pGCPs2 = 0 ;
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby, in,numinputs=0) (int *nGCPs2, GDAL_GCP const **pGCPs2 ) */
        arg2 = &nGCPs2;
        arg3 = &pGCPs2;
    }
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        CPLErrorReset();
        GDALDatasetShadow_GetGCPs(arg1,arg2,(GDAL_GCP const **)arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby, argout) (int *nGCPs, GDAL_GCP const **pGCPs ) */
        
        vresult = rb_ary_new2(*arg2);
        
        for( int i = 0; i < *arg2; i++ ) {
            GDAL_GCP *o = new_GDAL_GCP( (*arg3)[i].dfGCPX,
            (*arg3)[i].dfGCPY,
            (*arg3)[i].dfGCPZ,
            (*arg3)[i].dfGCPPixel,
            (*arg3)[i].dfGCPLine,
            (*arg3)[i].pszInfo,
            (*arg3)[i].pszId );
            
            rb_ary_store(vresult, i, 
            SWIG_NewPointerObj((void*)o, SWIGTYPE_p_GDAL_GCP,1));
        }
    }
    return vresult;
}


static VALUE
_wrap_Dataset_set_gcps(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int arg2 ;
    GDAL_GCP *arg3 = (GDAL_GCP *) 0 ;
    char *arg4 = (char *) 0 ;
    CPLErr result;
    GDAL_GCP *tmpGCPList2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        /* %typemap(ruby, in,numinputs=1) (int nGCPs, GDAL_GCP const *pGCPs ) */
        
        /* Check if is a list */
        Check_Type(argv[0], T_ARRAY);
        
        arg2 = RARRAY(argv[0])->len;
        tmpGCPList2 = (GDAL_GCP*) malloc(arg2*sizeof(GDAL_GCP));
        arg3 = tmpGCPList2;
        
        for( int i = 0; i<arg2; i++ ) {
            VALUE rubyItem = rb_ary_entry(argv[0],i);
            GDAL_GCP *item = 0;
            
            SWIG_ConvertPtr( rubyItem, (void**)&item, SWIGTYPE_p_GDAL_GCP, SWIG_POINTER_EXCEPTION | 0 );
            
            if (!item) {
                rb_raise(rb_eRuntimeError, "GDAL_GCP item cannot be nil");
            }
            
            memcpy( (void*) item, (void*) tmpGCPList2, sizeof( GDAL_GCP ) );
            ++tmpGCPList2;
        }
    }
    arg4 = StringValuePtr(argv[1]);
    {
        CPLErrorReset();
        result = (CPLErr)GDALDatasetShadow_SetGCPs(arg1,arg2,(GDAL_GCP const *)arg3,(char const *)arg4);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    {
        /* %typemap(ruby, freearg) (int nGCPs, GDAL_GCP const *pGCPs ) */
        if (arg3) {
            free( (void*) arg3 );
        }
    }
    return vresult;
}


static VALUE
_wrap_Dataset_flush_cache(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    {
        CPLErrorReset();
        GDALDatasetShadow_FlushCache(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Dataset_add_band(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    GDALDataType arg2 = (GDALDataType) GDT_Byte ;
    char **arg3 = (char **) 0 ;
    CPLErr result;
    char *kwnames[] = {
        "self","datatype","options", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    if (argc > 0) {
        {
            /* %typemap(ruby,in) CPLErr */
            arg2 = (GDALDataType) NUM2INT(argv[0]);
        }
    }
    if (argc > 1) {
        {
            /* %typemap(ruby,in) char **options */
            
            /* Check if is a list */
            Check_Type(argv[1], T_ARRAY);
            
            int size = RARRAY(argv[1])->len;
            for (int i = 0; i < size; i++) {
                VALUE item = rb_ary_entry(argv[1], i);
                char *pszItem = StringValuePtr(item);
                arg3 = CSLAddString( arg3, pszItem );
            }
        }
    }
    {
        CPLErrorReset();
        result = (CPLErr)GDALDatasetShadow_AddBand(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    {
        /* %typemap(ruby,freearg) char **options */
        
        CSLDestroy( arg3 );
    }
    return vresult;
}


static VALUE
_wrap_Dataset_write_raster(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int arg6 ;
    char *arg7 = (char *) 0 ;
    int *arg8 = (int *) 0 ;
    int *arg9 = (int *) 0 ;
    GDALDataType *arg10 = (GDALDataType *) 0 ;
    int arg11 = (int) 0 ;
    int *arg12 = (int *) 0 ;
    CPLErr result;
    char *kwnames[] = {
        "self","xoff","yoff","xsize","ysize","buf_len","buf_xsize","buf_ysize","buf_type","band_list", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 5) || (argc > 9))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]);
    {
        arg6 = (int) StringValueLen(argv[4]);
        arg7 = (char *) StringValuePtr(argv[4]);
    }
    if (argc > 5) {
        SWIG_ConvertPtr(argv[5], (void **) &arg8, SWIGTYPE_p_int, 0);
    }
    if (argc > 6) {
        SWIG_ConvertPtr(argv[6], (void **) &arg9, SWIGTYPE_p_int, 0);
    }
    if (argc > 7) {
        SWIG_ConvertPtr(argv[7], (void **) &arg10, SWIGTYPE_p_int, 0);
    }
    if (argc > 8) {
        {
            /* %typemap(ruby,in,numinputs=1) (int nList, int* pList) */
            
            /* Make sure this is an array. */
            Check_Type(argv[8], T_ARRAY);
            
            /* Get the length */
            arg11 = RARRAY(argv[8])->len;
            
            /* Allocate space for the C array. */
            arg12 = (int*) malloc(arg11*sizeof(int));
            
            for( int i = 0; i<arg11; i++ ) {
                /* Get the Ruby Object */
                VALUE item = rb_ary_entry(argv[8],i);
                /* Conver to an integer */
                arg12[i] = NUM2INT(item);
            }
        }
    }
    {
        CPLErrorReset();
        result = (CPLErr)GDALDatasetShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    {
        /* %typemap(ruby,freearg) (int nList, int* pList) */
        if (arg12) {
            free((void*) arg12);
        }
    }
    return vresult;
}


swig_class cBand;

static VALUE
_wrap_Band_xsize_get(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        result = (int)GDALRasterBandShadow_XSize_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Band_ysize_get(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        result = (int)GDALRasterBandShadow_YSize_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Band_data_type_get(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    GDALDataType result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        result = (GDALDataType)GDALRasterBandShadow_DataType_get(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Band_get_raster_color_interpretation(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    GDALColorInterp result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        result = (GDALColorInterp)GDALRasterBandShadow_GetRasterColorInterpretation(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Band_set_raster_color_interpretation(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    GDALColorInterp arg2 ;
    CPLErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        /* %typemap(ruby,in) CPLErr */
        arg2 = (GDALColorInterp) NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        result = (CPLErr)GDALRasterBandShadow_SetRasterColorInterpretation(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    return vresult;
}


static VALUE
_wrap_Band_get_no_data_value(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 = (double *) 0 ;
    int *arg3 = (int *) 0 ;
    double tmpval2 ;
    int tmphasval2 ;
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (double *val, int*hasval) */
        arg2 = &tmpval2;
        arg3 = &tmphasval2;
    }
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        GDALRasterBandShadow_GetNoDataValue(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,argout) (double *val, int*hasval) */
        
        if ( !*arg3 ) {
            vresult = Qnil;
        }
        else {
            vresult = rb_float_new(*arg2);
        }
    }
    return vresult;
}


static VALUE
_wrap_Band_set_no_data_value(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double arg2 ;
    CPLErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    arg2 = (double) NUM2DBL(argv[0]);
    {
        CPLErrorReset();
        result = (CPLErr)GDALRasterBandShadow_SetNoDataValue(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    return vresult;
}


static VALUE
_wrap_Band_get_minimum(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 = (double *) 0 ;
    int *arg3 = (int *) 0 ;
    double tmpval2 ;
    int tmphasval2 ;
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (double *val, int*hasval) */
        arg2 = &tmpval2;
        arg3 = &tmphasval2;
    }
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        GDALRasterBandShadow_GetMinimum(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,argout) (double *val, int*hasval) */
        
        if ( !*arg3 ) {
            vresult = Qnil;
        }
        else {
            vresult = rb_float_new(*arg2);
        }
    }
    return vresult;
}


static VALUE
_wrap_Band_get_maximum(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 = (double *) 0 ;
    int *arg3 = (int *) 0 ;
    double tmpval2 ;
    int tmphasval2 ;
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (double *val, int*hasval) */
        arg2 = &tmpval2;
        arg3 = &tmphasval2;
    }
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        GDALRasterBandShadow_GetMaximum(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,argout) (double *val, int*hasval) */
        
        if ( !*arg3 ) {
            vresult = Qnil;
        }
        else {
            vresult = rb_float_new(*arg2);
        }
    }
    return vresult;
}


static VALUE
_wrap_Band_get_offset(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 = (double *) 0 ;
    int *arg3 = (int *) 0 ;
    double tmpval2 ;
    int tmphasval2 ;
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (double *val, int*hasval) */
        arg2 = &tmpval2;
        arg3 = &tmphasval2;
    }
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        GDALRasterBandShadow_GetOffset(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,argout) (double *val, int*hasval) */
        
        if ( !*arg3 ) {
            vresult = Qnil;
        }
        else {
            vresult = rb_float_new(*arg2);
        }
    }
    return vresult;
}


static VALUE
_wrap_Band_get_scale(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 = (double *) 0 ;
    int *arg3 = (int *) 0 ;
    double tmpval2 ;
    int tmphasval2 ;
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (double *val, int*hasval) */
        arg2 = &tmpval2;
        arg3 = &tmphasval2;
    }
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        GDALRasterBandShadow_GetScale(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,argout) (double *val, int*hasval) */
        
        if ( !*arg3 ) {
            vresult = Qnil;
        }
        else {
            vresult = rb_float_new(*arg2);
        }
    }
    return vresult;
}


static VALUE
_wrap_Band_get_overview_count(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        result = (int)GDALRasterBandShadow_GetOverviewCount(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Band_get_overview(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int arg2 ;
    GDALRasterBandShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (GDALRasterBandShadow *)GDALRasterBandShadow_GetOverview(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALRasterBandShadow,0);
    return vresult;
}


static VALUE
_wrap_Band_checksum(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int arg2 = (int) 0 ;
    int arg3 = (int) 0 ;
    int *arg4 = (int *) 0 ;
    int *arg5 = (int *) 0 ;
    int result;
    char *kwnames[] = {
        "self","xoff","yoff","xsize","ysize", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    if (argc > 0) {
        arg2 = NUM2INT(argv[0]);
    }
    if (argc > 1) {
        arg3 = NUM2INT(argv[1]);
    }
    if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_int, 0);
    }
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_int, 0);
    }
    {
        CPLErrorReset();
        result = (int)GDALRasterBandShadow_Checksum(arg1,arg2,arg3,arg4,arg5);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Band_compute_raster_min_max(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double *arg2 ;
    int arg3 = (int) 0 ;
    double argout2[2] ;
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (double argout2[ANY]) */
        arg2 = argout2;
    }
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    if (argc > 0) {
        arg3 = NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        GDALRasterBandShadow_ComputeRasterMinMax(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,argout) (double argout[ANY]) */
        vresult = rb_ary_new();
        
        for(int i=0; i<2; i++)
        {
            VALUE value = rb_float_new(arg2[i]);
            rb_ary_push(vresult, value);
        }
    }
    return vresult;
}


static VALUE
_wrap_Band_fill(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    double arg2 ;
    double arg3 = (double) 0.0 ;
    CPLErr result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    arg2 = (double) NUM2DBL(argv[0]);
    if (argc > 1) {
        arg3 = (double) NUM2DBL(argv[1]);
    }
    {
        CPLErrorReset();
        result = (CPLErr)GDALRasterBandShadow_Fill(arg1,arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    return vresult;
}


static VALUE
_wrap_Band_read_raster(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int *arg6 = (int *) 0 ;
    char **arg7 = (char **) 0 ;
    int *arg8 = (int *) 0 ;
    int *arg9 = (int *) 0 ;
    int *arg10 = (int *) 0 ;
    CPLErr result;
    int nLen6 = 0 ;
    char *pBuf6 = 0 ;
    char *kwnames[] = {
        "self","xoff","yoff","xsize","ysize","buf_xsize","buf_ysize","buf_type", NULL 
    };
    VALUE vresult = Qnil;
    
    {
        /* %typemap(ruby,in,numinputs=0) (int *nLen6, char **pBuf6 ) ( int nLen6 = 0, char *pBuf6 = 0 ) */
        arg6 = &nLen6;
        arg7 = &pBuf6;
    }
    if ((argc < 4) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]);
    if (argc > 4) {
        SWIG_ConvertPtr(argv[4], (void **) &arg8, SWIGTYPE_p_int, 0);
    }
    if (argc > 5) {
        SWIG_ConvertPtr(argv[5], (void **) &arg9, SWIGTYPE_p_int, 0);
    }
    if (argc > 6) {
        SWIG_ConvertPtr(argv[6], (void **) &arg10, SWIGTYPE_p_int, 0);
    }
    {
        CPLErrorReset();
        result = (CPLErr)GDALRasterBandShadow_ReadRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    {
        /* %typemap(ruby,argout) (int *nLen, char **pBuf ) */
        vresult = rb_str_new(*arg7, *arg6);
    }
    {
        /* %typemap(ruby,freearg) (int *nLen, char **pBuf ) */
        if( *arg7 ) {
            free( *arg7 );
        }
    }
    return vresult;
}


static VALUE
_wrap_Band_write_raster(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int arg6 ;
    char *arg7 = (char *) 0 ;
    int *arg8 = (int *) 0 ;
    int *arg9 = (int *) 0 ;
    int *arg10 = (int *) 0 ;
    CPLErr result;
    char *kwnames[] = {
        "self","xoff","yoff","xsize","ysize","buf_len","buf_xsize","buf_ysize","buf_type", NULL 
    };
    VALUE vresult = Qnil;
    
    if ((argc < 5) || (argc > 8))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]);
    {
        arg6 = (int) StringValueLen(argv[4]);
        arg7 = (char *) StringValuePtr(argv[4]);
    }
    if (argc > 5) {
        SWIG_ConvertPtr(argv[5], (void **) &arg8, SWIGTYPE_p_int, 0);
    }
    if (argc > 6) {
        SWIG_ConvertPtr(argv[6], (void **) &arg9, SWIGTYPE_p_int, 0);
    }
    if (argc > 7) {
        SWIG_ConvertPtr(argv[7], (void **) &arg10, SWIGTYPE_p_int, 0);
    }
    {
        CPLErrorReset();
        result = (CPLErr)GDALRasterBandShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) CPLErr */
        vresult = (CPLErr)LONG2NUM(result);
    }
    return vresult;
}


static VALUE
_wrap_Band_flush_cache(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        GDALRasterBandShadow_FlushCache(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_Band_get_raster_color_table(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    GDALColorTable *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    {
        CPLErrorReset();
        result = (GDALColorTable *)GDALRasterBandShadow_GetRasterColorTable(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALColorTable,0);
    return vresult;
}


static VALUE
_wrap_Band_set_raster_color_table(int argc, VALUE *argv, VALUE self) {
    GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
    GDALColorTable *arg2 = (GDALColorTable *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALRasterBandShadow, 0);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_GDALColorTable, 0);
    {
        CPLErrorReset();
        result = (int)GDALRasterBandShadow_SetRasterColorTable(arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


swig_class cColorTable;

#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_ColorTable_allocate(VALUE self) {
#else
    static VALUE
    _wrap_ColorTable_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_GDALColorTable);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_ColorTable(int argc, VALUE *argv, VALUE self) {
    GDALPaletteInterp arg1 = (GDALPaletteInterp) GPI_RGB ;
    GDALColorTable *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        {
            /* %typemap(ruby,in) CPLErr */
            arg1 = (GDALPaletteInterp) NUM2INT(argv[0]);
        }
    }
    {
        CPLErrorReset();
        result = (GDALColorTable *)new GDALColorTable(arg1);
        DATA_PTR(self) = result;
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return self;
}


static void
free_GDALColorTable(GDALColorTable *arg1) {
    delete arg1;
}

static VALUE
_wrap_ColorTable_clone(int argc, VALUE *argv, VALUE self) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    GDALColorTable *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0);
    {
        CPLErrorReset();
        result = (GDALColorTable *)((GDALColorTable const *)arg1)->Clone();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALColorTable,0);
    return vresult;
}


static VALUE
_wrap_ColorTable_get_palette_interpretation(int argc, VALUE *argv, VALUE self) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    GDALPaletteInterp result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0);
    {
        CPLErrorReset();
        result = (GDALPaletteInterp)((GDALColorTable const *)arg1)->GetPaletteInterpretation();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_ColorTable_GetCount(int argc, VALUE *argv, VALUE self) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0);
    {
        CPLErrorReset();
        result = (int)((GDALColorTable const *)arg1)->GetColorEntryCount();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_ColorTable_get_color_entry(int argc, VALUE *argv, VALUE self) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    int arg2 ;
    GDALColorEntry *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0);
    arg2 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (GDALColorEntry *)(arg1)->GetColorEntry(arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALColorEntry,0);
    return vresult;
}


static VALUE
_wrap_ColorTable_get_color_entry_as_rgb(int argc, VALUE *argv, VALUE self) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    int arg2 ;
    GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_GDALColorEntry, 0);
    {
        CPLErrorReset();
        result = (int)((GDALColorTable const *)arg1)->GetColorEntryAsRGB(arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_ColorTable_set_color_entry(int argc, VALUE *argv, VALUE self) {
    GDALColorTable *arg1 = (GDALColorTable *) 0 ;
    int arg2 ;
    GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GDALColorTable, 0);
    arg2 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_GDALColorEntry, 0);
    {
        CPLErrorReset();
        (arg1)->SetColorEntry(arg2,(GDALColorEntry const *)arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_AllRegister(int argc, VALUE *argv, VALUE self) {
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        GDALAllRegister();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_GetCacheMax(int argc, VALUE *argv, VALUE self) {
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        result = (int)GDALGetCacheMax();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_SetCacheMax(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        GDALSetCacheMax(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    return Qnil;
}


static VALUE
_wrap_GetCacheUsed(int argc, VALUE *argv, VALUE self) {
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        result = (int)GDALGetCacheUsed();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_GetDataTypeSize(int argc, VALUE *argv, VALUE self) {
    GDALDataType arg1 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        /* %typemap(ruby,in) CPLErr */
        arg1 = (GDALDataType) NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        result = (int)GDALGetDataTypeSize(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DataTypeIsComplex(int argc, VALUE *argv, VALUE self) {
    GDALDataType arg1 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        /* %typemap(ruby,in) CPLErr */
        arg1 = (GDALDataType) NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        result = (int)GDALDataTypeIsComplex(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_GetDataTypeName(int argc, VALUE *argv, VALUE self) {
    GDALDataType arg1 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        /* %typemap(ruby,in) CPLErr */
        arg1 = (GDALDataType) NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        result = (char *)GDALGetDataTypeName(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_GetDataTypeByName(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    GDALDataType result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (GDALDataType)GDALGetDataTypeByName((char const *)arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_GetColorInterpretationName(int argc, VALUE *argv, VALUE self) {
    GDALColorInterp arg1 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        /* %typemap(ruby,in) CPLErr */
        arg1 = (GDALColorInterp) NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        result = (char *)GDALGetColorInterpretationName(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_GetPaletteInterpretationName(int argc, VALUE *argv, VALUE self) {
    GDALPaletteInterp arg1 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        /* %typemap(ruby,in) CPLErr */
        arg1 = (GDALPaletteInterp) NUM2INT(argv[0]);
    }
    {
        CPLErrorReset();
        result = (char *)GDALGetPaletteInterpretationName(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_DecToDMS(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    char *arg2 = (char *) 0 ;
    int arg3 = (int) 2 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    arg2 = StringValuePtr(argv[1]);
    if (argc > 2) {
        arg3 = NUM2INT(argv[2]);
    }
    {
        CPLErrorReset();
        result = (char *)GDALDecToDMS(arg1,(char const *)arg2,arg3);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_PackedDMSToDec(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    {
        CPLErrorReset();
        result = (double)GDALPackedDMSToDec(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_DecToPackedDMS(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    {
        CPLErrorReset();
        result = (double)GDALDecToPackedDMS(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_ParseXMLString(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    CPLXMLNode *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (CPLXMLNode *)CPLParseXMLString(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    {
        /* %typemap(ruby,out) (CPLXMLNode*) */
        
        vresult = XMLTreeToRubyArray(result);
    }
    {
        /* %typemap(ruby,ret) (CPLXMLNode*) */
        if ( result ) {
            CPLDestroyXMLNode( result );
        }
    }    return vresult;
}


static VALUE
_wrap_SerializeXMLTree(int argc, VALUE *argv, VALUE self) {
    CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        /* %typemap(ruby,in) (CPLXMLNode* xmlnode ) */
        arg1 = RubyArrayToXMLTree(argv[0]);
        
        if ( !arg1 ) {
            rb_raise(rb_eRuntimeError, "Could not convert Ruby Array to XML tree.");
        }
    }
    {
        CPLErrorReset();
        result = (char *)CPLSerializeXMLTree(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = rb_str_new2(result);
    {
        /* %typemap(ruby,freearg) (CPLXMLNode *xmlnode) */
        
        if ( arg1 ) {
            CPLDestroyXMLNode( arg1 );
        }
    }
    return vresult;
}


static VALUE
_wrap_get_driver_count(int argc, VALUE *argv, VALUE self) {
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        CPLErrorReset();
        result = (int)GetDriverCount();
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_get_driver_by_name(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    GDALDriverShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    {
        CPLErrorReset();
        result = (GDALDriverShadow *)GetDriverByName((char const *)arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALDriverShadow,0);
    return vresult;
}


static VALUE
_wrap_get_driver(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    GDALDriverShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    {
        CPLErrorReset();
        result = (GDALDriverShadow *)GetDriver(arg1);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALDriverShadow,0);
    return vresult;
}


static VALUE
_wrap_open(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
    GDALDatasetShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    if (argc > 1) {
        {
            /* %typemap(ruby,in) CPLErr */
            arg2 = (GDALAccess) NUM2INT(argv[1]);
        }
    }
    {
        CPLErrorReset();
        result = (GDALDatasetShadow *)Open((char const *)arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALDatasetShadow,1);
    return vresult;
}


static VALUE
_wrap_open_shared(int argc, VALUE *argv, VALUE self) {
    char *arg1 = (char *) 0 ;
    GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
    GDALDatasetShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    if (argc > 1) {
        {
            /* %typemap(ruby,in) CPLErr */
            arg2 = (GDALAccess) NUM2INT(argv[1]);
        }
    }
    {
        CPLErrorReset();
        result = (GDALDatasetShadow *)OpenShared((char const *)arg1,arg2);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALDatasetShadow,1);
    return vresult;
}


static VALUE
_wrap_auto_create_warped_vrt(int argc, VALUE *argv, VALUE self) {
    GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    GDALResampleAlg arg4 = (GDALResampleAlg) GRA_NearestNeighbour ;
    double arg5 = (double) 0.0 ;
    GDALDatasetShadow *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_GDALDatasetShadow, 0);
    if (argc > 1) {
        arg2 = StringValuePtr(argv[1]);
    }
    if (argc > 2) {
        arg3 = StringValuePtr(argv[2]);
    }
    if (argc > 3) {
        {
            /* %typemap(ruby,in) CPLErr */
            arg4 = (GDALResampleAlg) NUM2INT(argv[3]);
        }
    }
    if (argc > 4) {
        arg5 = (double) NUM2DBL(argv[4]);
    }
    {
        CPLErrorReset();
        result = (GDALDatasetShadow *)AutoCreateWarpedVRT(arg1,(char const *)arg2,(char const *)arg3,arg4,arg5);
        
        CPLErr eclass = CPLGetLastErrorType();
        if ( eclass == CE_Failure || eclass == CE_Fatal ) {
            SWIG_exception( SWIG_RuntimeError, CPLGetLastErrorMsg() );
        }
    }
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GDALDatasetShadow,1);
    return vresult;
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_GDALDriverShadowTo_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow *)  ((GDALDriverShadow *) x));
}
static void *_p_GDALDatasetShadowTo_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow *)  ((GDALDatasetShadow *) x));
}
static void *_p_GDALRasterBandShadowTo_p_GDALMajorObjectShadow(void *x) {
    return (void *)((GDALMajorObjectShadow *)  ((GDALRasterBandShadow *) x));
}
static swig_type_info _swigt__p_CPLErrorHandler = {"_p_CPLErrorHandler", "CPLErrorHandler *", 0, 0, 0};
static swig_type_info _swigt__p_CPLXMLNode = {"_p_CPLXMLNode", "CPLXMLNode *", 0, 0, 0};
static swig_type_info _swigt__p_GDALColorEntry = {"_p_GDALColorEntry", "GDALColorEntry *", 0, 0, 0};
static swig_type_info _swigt__p_GDALColorTable = {"_p_GDALColorTable", "GDALColorTable *", 0, 0, 0};
static swig_type_info _swigt__p_GDALDatasetShadow = {"_p_GDALDatasetShadow", "GDALDatasetShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDALDriverShadow = {"_p_GDALDriverShadow", "GDALDriverShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDALMajorObjectShadow = {"_p_GDALMajorObjectShadow", "GDALMajorObjectShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDALRasterBandShadow = {"_p_GDALRasterBandShadow", "GDALRasterBandShadow *", 0, 0, 0};
static swig_type_info _swigt__p_GDAL_GCP = {"_p_GDAL_GCP", "GDAL_GCP *", 0, 0, 0};
static swig_type_info _swigt__p_double = {"_p_double", "double *", 0, 0, 0};
static swig_type_info _swigt__p_int = {"_p_int", "int *|GDALPaletteInterp *", 0, 0, 0};
static swig_type_info _swigt__p_p_GDAL_GCP = {"_p_p_GDAL_GCP", "GDAL_GCP **", 0, 0, 0};
static swig_type_info _swigt__p_p_char = {"_p_p_char", "char **", 0, 0, 0};
static swig_type_info _swigt__p_unsigned_long = {"_p_unsigned_long", "unsigned long *|VALUE *", 0, 0, 0};

static swig_type_info *swig_type_initial[] = {
  &_swigt__p_CPLErrorHandler,
  &_swigt__p_CPLXMLNode,
  &_swigt__p_GDALColorEntry,
  &_swigt__p_GDALColorTable,
  &_swigt__p_GDALDatasetShadow,
  &_swigt__p_GDALDriverShadow,
  &_swigt__p_GDALMajorObjectShadow,
  &_swigt__p_GDALRasterBandShadow,
  &_swigt__p_GDAL_GCP,
  &_swigt__p_double,
  &_swigt__p_int,
  &_swigt__p_p_GDAL_GCP,
  &_swigt__p_p_char,
  &_swigt__p_unsigned_long,
};

static swig_cast_info _swigc__p_CPLErrorHandler[] = {  {&_swigt__p_CPLErrorHandler, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_CPLXMLNode[] = {  {&_swigt__p_CPLXMLNode, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALColorEntry[] = {  {&_swigt__p_GDALColorEntry, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALColorTable[] = {  {&_swigt__p_GDALColorTable, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALDatasetShadow[] = {  {&_swigt__p_GDALDatasetShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALDriverShadow[] = {  {&_swigt__p_GDALDriverShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALMajorObjectShadow[] = {  {&_swigt__p_GDALMajorObjectShadow, 0, 0, 0},  {&_swigt__p_GDALDriverShadow, _p_GDALDriverShadowTo_p_GDALMajorObjectShadow, 0, 0},  {&_swigt__p_GDALDatasetShadow, _p_GDALDatasetShadowTo_p_GDALMajorObjectShadow, 0, 0},  {&_swigt__p_GDALRasterBandShadow, _p_GDALRasterBandShadowTo_p_GDALMajorObjectShadow, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDALRasterBandShadow[] = {  {&_swigt__p_GDALRasterBandShadow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GDAL_GCP[] = {  {&_swigt__p_GDAL_GCP, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_double[] = {  {&_swigt__p_double, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_int[] = {  {&_swigt__p_int, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_GDAL_GCP[] = {  {&_swigt__p_p_GDAL_GCP, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_char[] = {  {&_swigt__p_p_char, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_unsigned_long[] = {  {&_swigt__p_unsigned_long, 0, 0, 0},{0, 0, 0, 0}};

static swig_cast_info *swig_cast_initial[] = {
  _swigc__p_CPLErrorHandler,
  _swigc__p_CPLXMLNode,
  _swigc__p_GDALColorEntry,
  _swigc__p_GDALColorTable,
  _swigc__p_GDALDatasetShadow,
  _swigc__p_GDALDriverShadow,
  _swigc__p_GDALMajorObjectShadow,
  _swigc__p_GDALRasterBandShadow,
  _swigc__p_GDAL_GCP,
  _swigc__p_double,
  _swigc__p_int,
  _swigc__p_p_GDAL_GCP,
  _swigc__p_p_char,
  _swigc__p_unsigned_long,
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

/*************************************************************************
 * Type initialization:
 * This problem is tough by the requirement that no dynamic 
 * memory is used. Also, since swig_type_info structures store pointers to 
 * swig_cast_info structures and swig_cast_info structures store pointers back
 * to swig_type_info structures, we need some lookup code at initialization. 
 * The idea is that swig generates all the structures that are needed. 
 * The runtime then collects these partially filled structures. 
 * The SWIG_InitializeModule function takes these initial arrays out of 
 * swig_module, and does all the lookup, filling in the swig_module.types
 * array with the correct data and linking the correct swig_cast_info
 * structures together.

 * The generated swig_type_info structures are assigned staticly to an initial 
 * array. We just loop though that array, and handle each type individually.
 * First we lookup if this type has been already loaded, and if so, use the
 * loaded structure instead of the generated one. Then we have to fill in the
 * cast linked list. The cast data is initially stored in something like a
 * two-dimensional array. Each row corresponds to a type (there are the same
 * number of rows as there are in the swig_type_initial array). Each entry in
 * a column is one of the swig_cast_info structures for that type.
 * The cast_initial array is actually an array of arrays, because each row has
 * a variable number of columns. So to actually build the cast linked list,
 * we find the array of casts associated with the type, and loop through it 
 * adding the casts to the list. The one last trick we need to do is making
 * sure the type pointer in the swig_cast_info struct is correct.

 * First off, we lookup the cast->type name to see if it is already loaded. 
 * There are three cases to handle:
 *  1) If the cast->type has already been loaded AND the type we are adding
 *     casting info to has not been loaded (it is in this module), THEN we
 *     replace the cast->type pointer with the type pointer that has already
 *     been loaded.
 *  2) If BOTH types (the one we are adding casting info to, and the 
 *     cast->type) are loaded, THEN the cast info has already been loaded by
 *     the previous module so we just ignore it.
 *  3) Finally, if cast->type has not already been loaded, then we add that
 *     swig_cast_info to the linked list (because the cast->type) pointer will
 *     be correct.
**/

#ifdef __cplusplus
extern "C" {
#endif

SWIGRUNTIME void
SWIG_InitializeModule(void *clientdata) {
  swig_type_info *type, *ret;
  swig_cast_info *cast;
  size_t i;
  swig_module_info *module_head;
  static int init_run = 0;

  clientdata = clientdata;

  if (init_run) return;
  init_run = 1;

  /* Initialize the swig_module */
  swig_module.type_initial = swig_type_initial;
  swig_module.cast_initial = swig_cast_initial;

  /* Try and load any already created modules */
  module_head = SWIG_GetModule(clientdata);
  if (module_head) {
    swig_module.next = module_head->next;
    module_head->next = &swig_module;
  } else {
    /* This is the first module loaded */
    swig_module.next = &swig_module;
    SWIG_SetModule(clientdata, &swig_module);
  }
		 
  /* Now work on filling in swig_module.types */
  for (i = 0; i < swig_module.size; ++i) {
    type = 0;

    /* if there is another module already loaded */
    if (swig_module.next != &swig_module) {
      type = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, swig_module.type_initial[i]->name);
    }
    if (type) {
      /* Overwrite clientdata field */
      if (swig_module.type_initial[i]->clientdata) type->clientdata = swig_module.type_initial[i]->clientdata;
    } else {
      type = swig_module.type_initial[i];
    }

    /* Insert casting types */
    cast = swig_module.cast_initial[i];
    while (cast->type) {
    
      /* Don't need to add information already in the list */
      ret = 0;
      if (swig_module.next != &swig_module) {
        ret = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, cast->type->name);
      }
      if (ret && type == swig_module.type_initial[i]) {
        cast->type = ret;
        ret = 0;
      }
      
      if (!ret) {
        if (type->cast) {
          type->cast->prev = cast;
          cast->next = type->cast;
        }
        type->cast = cast;
      }

      cast++;
    }

    /* Set entry in modules->types array equal to the type */
    swig_module.types[i] = type;
  }
  swig_module.types[i] = 0;
}

/* This function will propagate the clientdata field of type to
* any new swig_type_info structures that have been added into the list
* of equivalent types.  It is like calling
* SWIG_TypeClientData(type, clientdata) a second time.
*/
SWIGRUNTIME void
SWIG_PropagateClientData(void) {
  size_t i;
  swig_cast_info *equiv;
  static int init_run = 0;

  if (init_run) return;
  init_run = 1;

  for (i = 0; i < swig_module.size; i++) {
    if (swig_module.types[i]->clientdata) {
      equiv = swig_module.types[i]->cast;
      while (equiv) {
        if (!equiv->converter) {
          if (equiv->type && !equiv->type->clientdata)
            SWIG_TypeClientData(equiv->type, swig_module.types[i]->clientdata);
        }
        equiv = equiv->next;
      }
    }
  }
}

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT void Init_gdal(void) {
    size_t i;
    
    SWIG_InitRuntime();
    mGdal = rb_define_module("Gdal");
    mGdal = rb_define_module_under(mGdal, "Gdal");
    
    SWIG_InitializeModule(0);
    for (i = 0; i < swig_module.size; i++) {
        SWIG_define_class(swig_module.types[i]);
    }
    
    SWIG_RubyInitializeTrackings();
    
    /* gdal_ruby.i %init code */
    if ( GDALGetDriverCount() == 0 ) {
        GDALAllRegister();
    }
    
    rb_define_module_function(mGdal, "UseExceptions", VALUEFUNC(_wrap_UseExceptions), -1);
    rb_define_module_function(mGdal, "DontUseExceptions", VALUEFUNC(_wrap_DontUseExceptions), -1);
    rb_define_module_function(mGdal, "debug", VALUEFUNC(_wrap_debug), -1);
    rb_define_module_function(mGdal, "error", VALUEFUNC(_wrap_error), -1);
    rb_define_module_function(mGdal, "push_error_handler", VALUEFUNC(_wrap_push_error_handler), -1);
    rb_define_module_function(mGdal, "pop_error_handler", VALUEFUNC(_wrap_pop_error_handler), -1);
    rb_define_module_function(mGdal, "error_reset", VALUEFUNC(_wrap_error_reset), -1);
    rb_define_module_function(mGdal, "get_last_error_no", VALUEFUNC(_wrap_get_last_error_no), -1);
    rb_define_module_function(mGdal, "get_last_error_type", VALUEFUNC(_wrap_get_last_error_type), -1);
    rb_define_module_function(mGdal, "get_last_error_msg", VALUEFUNC(_wrap_get_last_error_msg), -1);
    rb_define_module_function(mGdal, "push_finder_location", VALUEFUNC(_wrap_push_finder_location), -1);
    rb_define_module_function(mGdal, "pop_finder_location", VALUEFUNC(_wrap_pop_finder_location), -1);
    rb_define_module_function(mGdal, "finder_clean", VALUEFUNC(_wrap_finder_clean), -1);
    rb_define_module_function(mGdal, "find_file", VALUEFUNC(_wrap_find_file), -1);
    rb_define_module_function(mGdal, "set_config_option", VALUEFUNC(_wrap_set_config_option), -1);
    rb_define_module_function(mGdal, "get_config_option", VALUEFUNC(_wrap_get_config_option), -1);
    
    cMajorObject.klass = rb_define_class_under(mGdal, "MajorObject", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_GDALMajorObjectShadow, (void *) &cMajorObject);
    rb_undef_alloc_func(cMajorObject.klass);
    rb_define_method(cMajorObject.klass, "get_description", VALUEFUNC(_wrap_MajorObject_get_description), -1);
    rb_define_method(cMajorObject.klass, "set_description", VALUEFUNC(_wrap_MajorObject_set_description), -1);
    rb_define_method(cMajorObject.klass, "get_metadata_dict", VALUEFUNC(_wrap_MajorObject_get_metadata_dict), -1);
    rb_define_method(cMajorObject.klass, "get_metadata_list", VALUEFUNC(_wrap_MajorObject_get_metadata_list), -1);
    rb_define_method(cMajorObject.klass, "set_metadata", VALUEFUNC(_wrap_MajorObject_set_metadata), -1);
    cMajorObject.mark = 0;
    
    cDriver.klass = rb_define_class_under(mGdal, "Driver", ((swig_class *) SWIGTYPE_p_GDALMajorObjectShadow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_GDALDriverShadow, (void *) &cDriver);
    rb_undef_alloc_func(cDriver.klass);
    rb_define_method(cDriver.klass, "short_name", VALUEFUNC(_wrap_Driver_short_name_get), -1);
    rb_define_method(cDriver.klass, "long_name", VALUEFUNC(_wrap_Driver_long_name_get), -1);
    rb_define_method(cDriver.klass, "help_topic", VALUEFUNC(_wrap_Driver_help_topic_get), -1);
    rb_define_method(cDriver.klass, "create_", VALUEFUNC(_wrap_Driver_create_), -1);
    rb_define_alias(cDriver.klass, "create", "create_");
    rb_define_method(cDriver.klass, "create_copy", VALUEFUNC(_wrap_Driver_create_copy), -1);
    rb_define_method(cDriver.klass, "delete_", VALUEFUNC(_wrap_Driver_delete_), -1);
    rb_define_alias(cDriver.klass, "delete", "delete_");
    cDriver.mark = 0;
    
    cGCP.klass = rb_define_class_under(mGdal, "GCP", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_GDAL_GCP, (void *) &cGCP);
    rb_define_alloc_func(cGCP.klass, _wrap_GCP_allocate);
    rb_define_method(cGCP.klass, "initialize", VALUEFUNC(_wrap_new_GCP), -1);
    rb_define_method(cGCP.klass, "gcpx=", VALUEFUNC(_wrap_GCP_gcpx_set), -1);
    rb_define_method(cGCP.klass, "gcpx", VALUEFUNC(_wrap_GCP_gcpx_get), -1);
    rb_define_method(cGCP.klass, "gcpy=", VALUEFUNC(_wrap_GCP_gcpy_set), -1);
    rb_define_method(cGCP.klass, "gcpy", VALUEFUNC(_wrap_GCP_gcpy_get), -1);
    rb_define_method(cGCP.klass, "gcpz=", VALUEFUNC(_wrap_GCP_gcpz_set), -1);
    rb_define_method(cGCP.klass, "gcpz", VALUEFUNC(_wrap_GCP_gcpz_get), -1);
    rb_define_method(cGCP.klass, "gcppixel=", VALUEFUNC(_wrap_GCP_gcppixel_set), -1);
    rb_define_method(cGCP.klass, "gcppixel", VALUEFUNC(_wrap_GCP_gcppixel_get), -1);
    rb_define_method(cGCP.klass, "gcpline=", VALUEFUNC(_wrap_GCP_gcpline_set), -1);
    rb_define_method(cGCP.klass, "gcpline", VALUEFUNC(_wrap_GCP_gcpline_get), -1);
    rb_define_method(cGCP.klass, "info=", VALUEFUNC(_wrap_GCP_info_set), -1);
    rb_define_method(cGCP.klass, "info", VALUEFUNC(_wrap_GCP_info_get), -1);
    rb_define_method(cGCP.klass, "id=", VALUEFUNC(_wrap_GCP_id_set), -1);
    rb_define_method(cGCP.klass, "id", VALUEFUNC(_wrap_GCP_id_get), -1);
    cGCP.mark = 0;
    cGCP.destroy = (void (*)(void *)) free_GDAL_GCP;
    rb_define_module_function(mGdal, "gdal_gcp_gcpx_get", VALUEFUNC(_wrap_gdal_gcp_gcpx_get), -1);
    rb_define_module_function(mGdal, "gdal_gcp_gcpx_set", VALUEFUNC(_wrap_gdal_gcp_gcpx_set), -1);
    rb_define_module_function(mGdal, "gdal_gcp_gcpy_get", VALUEFUNC(_wrap_gdal_gcp_gcpy_get), -1);
    rb_define_module_function(mGdal, "gdal_gcp_gcpy_set", VALUEFUNC(_wrap_gdal_gcp_gcpy_set), -1);
    rb_define_module_function(mGdal, "gdal_gcp_gcpz_get", VALUEFUNC(_wrap_gdal_gcp_gcpz_get), -1);
    rb_define_module_function(mGdal, "gdal_gcp_gcpz_set", VALUEFUNC(_wrap_gdal_gcp_gcpz_set), -1);
    rb_define_module_function(mGdal, "gdal_gcp_gcppixel_get", VALUEFUNC(_wrap_gdal_gcp_gcppixel_get), -1);
    rb_define_module_function(mGdal, "gdal_gcp_gcppixel_set", VALUEFUNC(_wrap_gdal_gcp_gcppixel_set), -1);
    rb_define_module_function(mGdal, "gdal_gcp_gcpline_get", VALUEFUNC(_wrap_gdal_gcp_gcpline_get), -1);
    rb_define_module_function(mGdal, "gdal_gcp_gcpline_set", VALUEFUNC(_wrap_gdal_gcp_gcpline_set), -1);
    rb_define_module_function(mGdal, "gdal_gcp_info_get", VALUEFUNC(_wrap_gdal_gcp_info_get), -1);
    rb_define_module_function(mGdal, "gdal_gcp_info_set", VALUEFUNC(_wrap_gdal_gcp_info_set), -1);
    rb_define_module_function(mGdal, "gdal_gcp_id_get", VALUEFUNC(_wrap_gdal_gcp_id_get), -1);
    rb_define_module_function(mGdal, "gdal_gcp_id_set", VALUEFUNC(_wrap_gdal_gcp_id_set), -1);
    rb_define_module_function(mGdal, "gdal_gcp_get_gcpx", VALUEFUNC(_wrap_gdal_gcp_get_gcpx), -1);
    rb_define_module_function(mGdal, "gdal_gcp_set_gcpx", VALUEFUNC(_wrap_gdal_gcp_set_gcpx), -1);
    rb_define_module_function(mGdal, "gdal_gcp_get_gcpy", VALUEFUNC(_wrap_gdal_gcp_get_gcpy), -1);
    rb_define_module_function(mGdal, "gdal_gcp_set_gcpy", VALUEFUNC(_wrap_gdal_gcp_set_gcpy), -1);
    rb_define_module_function(mGdal, "gdal_gcp_get_gcpz", VALUEFUNC(_wrap_gdal_gcp_get_gcpz), -1);
    rb_define_module_function(mGdal, "gdal_gcp_set_gcpz", VALUEFUNC(_wrap_gdal_gcp_set_gcpz), -1);
    rb_define_module_function(mGdal, "gdal_gcp_get_gcppixel", VALUEFUNC(_wrap_gdal_gcp_get_gcppixel), -1);
    rb_define_module_function(mGdal, "gdal_gcp_set_gcppixel", VALUEFUNC(_wrap_gdal_gcp_set_gcppixel), -1);
    rb_define_module_function(mGdal, "gdal_gcp_get_gcpline", VALUEFUNC(_wrap_gdal_gcp_get_gcpline), -1);
    rb_define_module_function(mGdal, "gdal_gcp_set_gcpline", VALUEFUNC(_wrap_gdal_gcp_set_gcpline), -1);
    rb_define_module_function(mGdal, "gdal_gcp_get_info", VALUEFUNC(_wrap_gdal_gcp_get_info), -1);
    rb_define_module_function(mGdal, "gdal_gcp_set_info", VALUEFUNC(_wrap_gdal_gcp_set_info), -1);
    rb_define_module_function(mGdal, "gdal_gcp_get_id", VALUEFUNC(_wrap_gdal_gcp_get_id), -1);
    rb_define_module_function(mGdal, "gdal_gcp_set_id", VALUEFUNC(_wrap_gdal_gcp_set_id), -1);
    rb_define_module_function(mGdal, "GCPsToGeoTransform", VALUEFUNC(_wrap_GCPsToGeoTransform), -1);
    
    cDataset.klass = rb_define_class_under(mGdal, "Dataset", ((swig_class *) SWIGTYPE_p_GDALMajorObjectShadow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_GDALDatasetShadow, (void *) &cDataset);
    rb_undef_alloc_func(cDataset.klass);
    rb_define_method(cDataset.klass, "raster_xsize", VALUEFUNC(_wrap_Dataset_raster_xsize_get), -1);
    rb_define_method(cDataset.klass, "raster_ysize", VALUEFUNC(_wrap_Dataset_raster_ysize_get), -1);
    rb_define_method(cDataset.klass, "raster_count", VALUEFUNC(_wrap_Dataset_raster_count_get), -1);
    rb_define_method(cDataset.klass, "get_driver", VALUEFUNC(_wrap_Dataset_get_driver), -1);
    rb_define_method(cDataset.klass, "get_raster_band", VALUEFUNC(_wrap_Dataset_get_raster_band), -1);
    rb_define_method(cDataset.klass, "get_projection", VALUEFUNC(_wrap_Dataset_get_projection), -1);
    rb_define_method(cDataset.klass, "get_projection_ref", VALUEFUNC(_wrap_Dataset_get_projection_ref), -1);
    rb_define_method(cDataset.klass, "set_projection", VALUEFUNC(_wrap_Dataset_set_projection), -1);
    rb_define_method(cDataset.klass, "get_geo_transform", VALUEFUNC(_wrap_Dataset_get_geo_transform), -1);
    rb_define_method(cDataset.klass, "set_geo_transform", VALUEFUNC(_wrap_Dataset_set_geo_transform), -1);
    rb_define_method(cDataset.klass, "build_overviews", VALUEFUNC(_wrap_Dataset_build_overviews), -1);
    rb_define_method(cDataset.klass, "get_gcpcount", VALUEFUNC(_wrap_Dataset_get_gcpcount), -1);
    rb_define_method(cDataset.klass, "get_gcpprojection", VALUEFUNC(_wrap_Dataset_get_gcpprojection), -1);
    rb_define_method(cDataset.klass, "get_gcps", VALUEFUNC(_wrap_Dataset_get_gcps), -1);
    rb_define_method(cDataset.klass, "set_gcps", VALUEFUNC(_wrap_Dataset_set_gcps), -1);
    rb_define_method(cDataset.klass, "flush_cache", VALUEFUNC(_wrap_Dataset_flush_cache), -1);
    rb_define_method(cDataset.klass, "add_band", VALUEFUNC(_wrap_Dataset_add_band), -1);
    rb_define_method(cDataset.klass, "write_raster", VALUEFUNC(_wrap_Dataset_write_raster), -1);
    cDataset.mark = 0;
    cDataset.destroy = (void (*)(void *)) free_GDALDatasetShadow;
    
    cBand.klass = rb_define_class_under(mGdal, "Band", ((swig_class *) SWIGTYPE_p_GDALMajorObjectShadow->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_GDALRasterBandShadow, (void *) &cBand);
    rb_undef_alloc_func(cBand.klass);
    rb_define_method(cBand.klass, "xsize", VALUEFUNC(_wrap_Band_xsize_get), -1);
    rb_define_method(cBand.klass, "ysize", VALUEFUNC(_wrap_Band_ysize_get), -1);
    rb_define_method(cBand.klass, "data_type", VALUEFUNC(_wrap_Band_data_type_get), -1);
    rb_define_method(cBand.klass, "get_raster_color_interpretation", VALUEFUNC(_wrap_Band_get_raster_color_interpretation), -1);
    rb_define_method(cBand.klass, "set_raster_color_interpretation", VALUEFUNC(_wrap_Band_set_raster_color_interpretation), -1);
    rb_define_method(cBand.klass, "get_no_data_value", VALUEFUNC(_wrap_Band_get_no_data_value), -1);
    rb_define_method(cBand.klass, "set_no_data_value", VALUEFUNC(_wrap_Band_set_no_data_value), -1);
    rb_define_method(cBand.klass, "get_minimum", VALUEFUNC(_wrap_Band_get_minimum), -1);
    rb_define_method(cBand.klass, "get_maximum", VALUEFUNC(_wrap_Band_get_maximum), -1);
    rb_define_method(cBand.klass, "get_offset", VALUEFUNC(_wrap_Band_get_offset), -1);
    rb_define_method(cBand.klass, "get_scale", VALUEFUNC(_wrap_Band_get_scale), -1);
    rb_define_method(cBand.klass, "get_overview_count", VALUEFUNC(_wrap_Band_get_overview_count), -1);
    rb_define_method(cBand.klass, "get_overview", VALUEFUNC(_wrap_Band_get_overview), -1);
    rb_define_method(cBand.klass, "checksum", VALUEFUNC(_wrap_Band_checksum), -1);
    rb_define_method(cBand.klass, "compute_raster_min_max", VALUEFUNC(_wrap_Band_compute_raster_min_max), -1);
    rb_define_method(cBand.klass, "fill", VALUEFUNC(_wrap_Band_fill), -1);
    rb_define_method(cBand.klass, "read_raster", VALUEFUNC(_wrap_Band_read_raster), -1);
    rb_define_method(cBand.klass, "write_raster", VALUEFUNC(_wrap_Band_write_raster), -1);
    rb_define_method(cBand.klass, "flush_cache", VALUEFUNC(_wrap_Band_flush_cache), -1);
    rb_define_method(cBand.klass, "get_raster_color_table", VALUEFUNC(_wrap_Band_get_raster_color_table), -1);
    rb_define_method(cBand.klass, "set_raster_color_table", VALUEFUNC(_wrap_Band_set_raster_color_table), -1);
    cBand.mark = 0;
    
    cColorTable.klass = rb_define_class_under(mGdal, "ColorTable", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_GDALColorTable, (void *) &cColorTable);
    rb_define_alloc_func(cColorTable.klass, _wrap_ColorTable_allocate);
    rb_define_method(cColorTable.klass, "initialize", VALUEFUNC(_wrap_new_ColorTable), -1);
    rb_define_method(cColorTable.klass, "clone", VALUEFUNC(_wrap_ColorTable_clone), -1);
    rb_define_method(cColorTable.klass, "get_palette_interpretation", VALUEFUNC(_wrap_ColorTable_get_palette_interpretation), -1);
    rb_define_method(cColorTable.klass, "GetCount", VALUEFUNC(_wrap_ColorTable_GetCount), -1);
    rb_define_method(cColorTable.klass, "get_color_entry", VALUEFUNC(_wrap_ColorTable_get_color_entry), -1);
    rb_define_method(cColorTable.klass, "get_color_entry_as_rgb", VALUEFUNC(_wrap_ColorTable_get_color_entry_as_rgb), -1);
    rb_define_method(cColorTable.klass, "set_color_entry", VALUEFUNC(_wrap_ColorTable_set_color_entry), -1);
    cColorTable.mark = 0;
    cColorTable.destroy = (void (*)(void *)) free_GDALColorTable;
    rb_define_module_function(mGdal, "AllRegister", VALUEFUNC(_wrap_AllRegister), -1);
    rb_define_module_function(mGdal, "GetCacheMax", VALUEFUNC(_wrap_GetCacheMax), -1);
    rb_define_module_function(mGdal, "SetCacheMax", VALUEFUNC(_wrap_SetCacheMax), -1);
    rb_define_module_function(mGdal, "GetCacheUsed", VALUEFUNC(_wrap_GetCacheUsed), -1);
    rb_define_module_function(mGdal, "GetDataTypeSize", VALUEFUNC(_wrap_GetDataTypeSize), -1);
    rb_define_module_function(mGdal, "DataTypeIsComplex", VALUEFUNC(_wrap_DataTypeIsComplex), -1);
    rb_define_module_function(mGdal, "GetDataTypeName", VALUEFUNC(_wrap_GetDataTypeName), -1);
    rb_define_module_function(mGdal, "GetDataTypeByName", VALUEFUNC(_wrap_GetDataTypeByName), -1);
    rb_define_module_function(mGdal, "GetColorInterpretationName", VALUEFUNC(_wrap_GetColorInterpretationName), -1);
    rb_define_module_function(mGdal, "GetPaletteInterpretationName", VALUEFUNC(_wrap_GetPaletteInterpretationName), -1);
    rb_define_module_function(mGdal, "DecToDMS", VALUEFUNC(_wrap_DecToDMS), -1);
    rb_define_module_function(mGdal, "PackedDMSToDec", VALUEFUNC(_wrap_PackedDMSToDec), -1);
    rb_define_module_function(mGdal, "DecToPackedDMS", VALUEFUNC(_wrap_DecToPackedDMS), -1);
    rb_define_module_function(mGdal, "ParseXMLString", VALUEFUNC(_wrap_ParseXMLString), -1);
    rb_define_module_function(mGdal, "SerializeXMLTree", VALUEFUNC(_wrap_SerializeXMLTree), -1);
    rb_define_module_function(mGdal, "get_driver_count", VALUEFUNC(_wrap_get_driver_count), -1);
    rb_define_module_function(mGdal, "get_driver_by_name", VALUEFUNC(_wrap_get_driver_by_name), -1);
    rb_define_module_function(mGdal, "get_driver", VALUEFUNC(_wrap_get_driver), -1);
    rb_define_module_function(mGdal, "open", VALUEFUNC(_wrap_open), -1);
    rb_define_module_function(mGdal, "open_shared", VALUEFUNC(_wrap_open_shared), -1);
    rb_define_module_function(mGdal, "auto_create_warped_vrt", VALUEFUNC(_wrap_auto_create_warped_vrt), -1);
}

