/******************************************************************************
 * $Id: ogdidataset.h,v 1.12 2002/12/09 16:10:10 warmerda Exp $
 *
 * Name:     ogdidataset.h
 * Project:  OGDI Bridge
 * Purpose:  OGDIDataset and related declarations.
 * Author:   Frank Warmerdam, warmerda@home.com
 *
 ******************************************************************************
 * Copyright (c) 1998, Frank Warmerdam
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *****************************************************************************
 *
 * $Log: ogdidataset.h,v $
 * Revision 1.12  2002/12/09 16:10:10  warmerda
 * fix friend class declarations
 *
 * Revision 1.11  2002/06/17 13:57:42  warmerda
 * restored to previous state
 *
 * Revision 1.10  2002/06/17 13:41:25  warmerda
 * ensure gdal_priv.h is included first for largefile handling
 *
 * Revision 1.9  2001/06/23 22:40:53  warmerda
 * added SUBDATASETS support
 *
 * Revision 1.8  2001/06/20 16:09:40  warmerda
 * utilize capabilities data
 *
 * Revision 1.7  2001/04/17 21:46:04  warmerda
 * complete Image support, utilize cln_GetLayerCapabilities()
 *
 * Revision 1.6  2000/10/26 03:30:46  warmerda
 * added math.h so it doesn't get included first from within ecsutil.h
 *
 * Revision 1.5  2000/08/28 21:30:17  warmerda
 * restructure to use cln_GetNextObject
 *
 * Revision 1.4  2000/08/25 21:31:04  warmerda
 * added colortable support
 *
 * Revision 1.3  2000/08/25 14:28:04  warmerda
 * preliminary support with IRasterIO
 *
 * Revision 1.2  1999/02/25 22:20:47  warmerda
 * Explicitly declare OGDIDataset constructor and destructor
 *
 * Revision 1.1  1999/01/11 15:29:16  warmerda
 * New
 *
 */

#ifndef OGDIDATASET_H_INCLUDED
#define OGDIDATASET_H_INCLUDED

#include <math.h>
#include "ecs.h"
#include "gdal_priv.h"

#ifndef MAX
#  define MIN(a,b)      ((a<b) ? a : b)
#  define MAX(a,b)      ((a>b) ? a : b)
#endif

CPL_C_START
void	GDALRegister_OGDI(void);
CPL_C_END


/************************************************************************/
/* ==================================================================== */
/*				OGDIDataset				*/
/* ==================================================================== */
/************************************************************************/

class OGDIRasterBand;

class CPL_DLL OGDIDataset : public GDALDataset
{
    friend class OGDIRasterBand;
    
    int		nClientID;

    ecs_Region	sGlobalBounds;
    ecs_Region  sCurrentBounds;
    int         nCurrentBand;
    int         nCurrentIndex;

    char	*pszProjection;

    static CPLErr CollectLayers(int, char***,char***);
    static CPLErr OverrideGlobalInfo(OGDIDataset*,const char *);

    void        AddSubDataset( const char *pszType, const char *pszLayer );
    char	**papszSubDatasets;

  public:
    		OGDIDataset();
    		~OGDIDataset();
                
    static GDALDataset *Open( GDALOpenInfo * );

    int		GetClientID() { return nClientID; }

    virtual const char *GetProjectionRef(void);
    virtual CPLErr GetGeoTransform( double * );

    virtual void *GetInternalHandle( const char * );

    virtual char **GetMetadata( const char * pszDomain = "" );
};

/************************************************************************/
/* ==================================================================== */
/*                            OGDIRasterBand                             */
/* ==================================================================== */
/************************************************************************/

class OGDIRasterBand : public GDALRasterBand
{
    friend class OGDIDataset;

    int		nOGDIImageType; /* ie. 1 for RGB */

    char	*pszLayerName;
    ecs_Family  eFamily;

    int		nComponent; /* varies only for RGB layers */

    GDALColorTable *poCT;

    virtual CPLErr IRasterIO( GDALRWFlag, int, int, int, int,
                              void *, int, int, GDALDataType,
                              int, int );

    CPLErr         EstablishAccess( int nYOff, int nXOff, int nXSize, 
                                    int nBufXSize );

  public:

                   OGDIRasterBand( OGDIDataset *, int, const char *,
                                   ecs_Family, int );
                   ~OGDIRasterBand();

    virtual CPLErr IReadBlock( int, int, void * );
    virtual int    HasArbitraryOverviews();
    virtual GDALColorInterp GetColorInterpretation();
    virtual GDALColorTable *GetColorTable();
};

#endif /* ndef OGDIDATASET_H_INCLUDED */
