package GCPlugins::GCgames::GCMobyGames;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCgames::GCgamesCommon;

{
    package GCPlugins::GCgames::GCPluginMobyGames;

    use base 'GCPlugins::GCgames::GCgamesPluginsBase';
    use HTML::Entities;

    sub extractTips
    {
        my ($self, $html_ini) = @_;
        my $answer = "";
        my @tmpAnswer = ();
        my $html = $self->loadPage($html_ini);
        $html =~ s|<pre>||g;
        $html =~ s|</pre>||g;
        $html =~ s|<b>||g;
        $html =~ s|</b>||g;
        my $found = index($html,"class=\"sbL sbB sbT\">");
        if ( $found >= 0 )
        {
           $answer = substr($html, $found + length("class=\"sbL sbB sbT\">"),length($html)- $found -length("class=\"sbL sbB sbT\">") );
           $answer = substr($answer, 0, index($answer,"</td><td align="));

           $tmpAnswer[0] = decode_entities($answer);

           $found = index($html,"class=\"sbR sbL sbB\"><p>");
           if ( $found >= 0 )
           {
              my $html2 = substr($html, $found + length("class=\"sbR sbL sbB\"><p>"),length($html)- $found -length("class=\"sbR sbL sbB\"><p>") );
              $html2 = substr($html2, 0, index($html2,"</p>"));
              $html2 =~ s/<br>/\n/g;

              $tmpAnswer[1] = decode_entities($html2);
           }

        }

        return @tmpAnswer;
    }

    sub extractPlayer
    {
        my ($self, $html_ini, $word) = @_;
        my $html = 0;
        my $found = index($html_ini,$word);
        if ( $found >= 0 )
        {
           $html = substr($html_ini, $found + length($word),length($html_ini)- $found -length($word) );
           $html = substr($html,0, index($html,"</a>") );
           $html = reverse($html);
           $html = substr($html,0, index($html,">") );
           $html = reverse($html);
           $html =~ s/&nbsp;/ /g;
           $html =~ s/1 Player/1/;
        }
        return $html;
    }

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;
        if ($self->{parsingList})
        {
            if ( ($tagname eq 'a') && ( substr($attr->{href},0,6) eq '/game/' ) )
            {
                    # This part is executed twice when a cover is available
                    $self->{isGame} = 1;
                    $self->{itemIdx}++;
                    $self->{itemsList}[$self->{itemIdx}]->{url} = 'http://www.mobygames.com'.$attr->{href}.'';
                    $self->{isName} = 1 ;
            }
            elsif ( ($self->{isGame} eq 1 ) && ($tagname eq 'img') )
            {
                    # If a cover is available , the previous part is execute twice, so I remove one
                    $self->{itemIdx}--
            }
            elsif ( ($self->{isGame} eq 1 ) && ($tagname eq 'br') )
            {
                    if ( $self->{itemsList}[$self->{itemIdx}]->{released} eq '' )
                    {
                        $self->{isDate} = 1 ;
                    }
                    elsif ( $self->{itemsList}[$self->{itemIdx}]->{platform} eq '' )
                    {
                        $self->{isPlatform} = 1 ;
                    }
                    
            }
            elsif ( ($tagname eq 'a') && ( substr($attr->{href},0,7) eq '/search' ) )
            {
                        $self->{isGame} = 0;
            }
        }
        elsif ($self->{parsingTips})
        {
            if (($tagname eq 'table') && ($attr->{summary} eq 'List of Tips and Tricks'))
            {
                $self->{isSectionTips} = 2;
            }
            elsif ( ($tagname eq 'b') && ($self->{isSectionTips} eq '2') )
            {
                $self->{isSectionTips} = 1;
            }
            elsif ( ($tagname eq 'tr') && (($attr->{class} eq 'mb1') || ($attr->{class} eq 'mb2')) )
            {
                $self->{isTip} = 1 if ($self->{isTip} eq 2);
                $self->{isCode} = 1 if ($self->{isCode} eq 2);
            }
            elsif ( ($tagname eq 'a') && ($self->{isTip} eq 1))
            {
                my @tips = $self->extractTips('http://www.mobygames.com'.$attr->{href}.'');
                if ($tips[0] =~ m/unlock/i)
                {
                   $Text::Wrap::columns = 80;
                   $tips[1] = Text::Wrap::wrap('', '', $tips[1]);
                   $self->{tmpCheatLine} = {col => []};
                   push @{$self->{tmpCheatLine}->{col}}, @tips;
                   push @{$self->{curInfo}->{unlockable}->{line}}, $self->{tmpCheatLine};
                }
                else
                {
                   my $answer = $tips[0];
                   $answer .= "\n";
                   $answer .= $tips[1];
                   if ( ($self->{curInfo}->{secrets}) && ($answer ne "") )
                   {
                      $self->{curInfo}->{secrets} .= "\n\n\n"
                   }
                   $self->{curInfo}->{secrets} .= $answer;
                }
                $self->{isTip} = 2;
            }
            elsif ( ($tagname eq 'a') && ($self->{isCode} eq 1))
            {
                my @tips = $self->extractTips('http://www.mobygames.com'.$attr->{href}.'');
                @tips = reverse(@tips);
                $Text::Wrap::columns = 80;
                $tips[1] = Text::Wrap::wrap('', '', $tips[1]);
                $self->{tmpCheatLine} = {col => []};
                push @{$self->{tmpCheatLine}->{col}}, @tips;
                push @{$self->{curInfo}->{code}->{line}}, $self->{tmpCheatLine};

                $self->{isCode} = 2;

            }
            elsif ($tagname eq 'br')
            {
                $self->{isTip} = 3;
                $self->{isCode} = 3;
                $self->{isSectionTips} = 0;
            }
            elsif ($tagname eq 'head')
            {
                $self->{isTip} = 0;
                $self->{isCode} = 0;
                $self->{isSectionTips} = 0;
            }

        }
        else
        {

            if ($tagname eq 'div')
            {
                    for ($attr->{id})
                    {
                        /^gameTitle$/ && ($self->{isName} = 1, last);
                        /^gamePlatform/ && ($self->{isPlatform} = 1, last);
                        /^coreGameCover/ && ($self->{isBox} = 1, last);
                        /^coreGameRelease/ && ($self->{isEditor} = 1, last);
                    }

                    if ($self->{curInfo}->{genre})
                    {
                        $self->{isGenre} = 0;
                    }

                    $self->{isDescription} = 0;

            }
            elsif ( ($tagname eq 'a') && ($self->{isName}) )
            {
                    $self->{is} = 'name';
                    $self->{isName} = 0;
            }
            elsif ( ($tagname eq 'a') && ($self->{isPlatform}) )
            {
                    $self->{is} = 'platform';
                    $self->{isPlatform} = 0;
            }
            elsif ( ($tagname eq 'a') && ($self->{isEditor}) )
            {
                    $self->{is} = 'editor';
                    $self->{isEditor} = 0;
            }
            elsif ( ($tagname eq 'a') && ($self->{isDeveloper}) )
            {
                    $self->{is} = 'developer';
                    $self->{isDeveloper} = 0;
            }
            elsif ( ($tagname eq 'a') && ($self->{isDate}) )
            {
                    $self->{is} = 'released';
                    $self->{isDate} = 0;
            }
            elsif ( ($tagname eq 'a') && ($self->{isGenre}) )
            {
                    $self->{is} = 'genre';
            }
            elsif ( ($tagname eq 'img') && ($self->{isBox}) && ($attr->{alt} eq 'No Cover on File') )
            {
                    $self->{isBox} = 0;
            }
            elsif ( ($tagname eq 'a') && ($self->{isBox}) )
            {
                    my $html = $self->loadPage('http://www.mobygames.com'.$attr->{href});
                    my $found = index($html,".jpg");
                    if ( $found >= 0 )
                    {
                       $html = substr($html, 0, $found + length(".jpg") );
                       $html = reverse($html);
                       $html = substr($html, 0, index($html,"\"=crs "));
                       $html = reverse($html);
                       $self->{curInfo}->{boxpic} = $html;
                    }

                    $self->{isBox} = 0;
            }
            elsif ($tagname eq 'html')
            {
                    my $html = $self->loadPage($self->{curInfo}->{$self->{urlField}}.'/techinfo');
                    my $player_offline = $self->extractPlayer($html, "Number&nbsp;of Players: Offline" );
                    my $player_online = $self->extractPlayer($html, "Number&nbsp;of Players: Online" );
                    my $player_total = $self->extractPlayer($html, "Number&nbsp;of Players Supported" );

                    if ($player_total)
                    {
                       $self->{curInfo}->{players} = $player_total;
                    }
                    else
                    {
                       if ($player_offline)
                       {
                          $self->{curInfo}->{players} = 'Offline: '.$player_offline;
                       }
                       if ($player_online)
                       {
                          if ( $self->{curInfo}->{players} )
                          {
                             $self->{curInfo}->{players} .= '; Online: '.$player_online;
                          }
                          else
                          {
                             $self->{curInfo}->{players} = 'Online: '.$player_online;
                          }
                       }
                    }

                    my $html = $self->loadPage($self->{curInfo}->{$self->{urlField}}.'/screenshots');
                    my $found = index($html,"\"><img alt=\"[");
                    if ( $found >= 0 )
                    {
                       $self->{curInfo}->{screenshot1} = substr($html, 0, $found);
                       $self->{curInfo}->{screenshot1} = reverse($self->{curInfo}->{screenshot1});
                       $self->{curInfo}->{screenshot1} = substr($self->{curInfo}->{screenshot1}, 0, index($self->{curInfo}->{screenshot1},"\"=ferh a<>\""));
                       $self->{curInfo}->{screenshot1} = reverse($self->{curInfo}->{screenshot1});
                       $self->{curInfo}->{screenshot1} = 'http://www.mobygames.com'.$self->{curInfo}->{screenshot1};

                       my $html_Screen = $self->loadPage($self->{curInfo}->{screenshot1});
                       my $found2 = index($html_Screen,"<strong>Screenshot: </strong>");
                       if ( $found2 >= 0 )
                       {
                          $html_Screen = substr($html_Screen, $found2 + length('<strong>Screenshot: </strong>'),length($html_Screen)- $found2 -length('<strong>Screenshot: </strong>') );
                          $html_Screen = substr($html_Screen,index($html_Screen," src=\"") + length(" src=\""),index($html_Screen," src=\"")-index($html_Screen," src=\"")-length(" src=\"") );
                          $self->{curInfo}->{screenshot1} = substr($html_Screen,0, index($html_Screen,"\"") );
                          if ( !($self->{curInfo}->{screenshot1} =~ m/http:\/\/www.mobygames.com/i) )
                          {
                             $self->{curInfo}->{screenshot1} = 'http://www.mobygames.com'.$self->{curInfo}->{screenshot1};
                          }

                       }

                       $html = substr($html, $found -2 + length('\"><img alt=\"['),length($html)- $found -length('\"><img alt=\"[') + 2);
                       my $found1 = index($html,"\"><img alt=\"[");
                       if ( $found1 >= 0 )
                       {
                       $self->{curInfo}->{screenshot2} = substr($html, 0, $found1);
                       $self->{curInfo}->{screenshot2} = reverse($self->{curInfo}->{screenshot2});
                       $self->{curInfo}->{screenshot2} = substr($self->{curInfo}->{screenshot2}, 0, index($self->{curInfo}->{screenshot2},"\"=ferh a<>\""));
                       $self->{curInfo}->{screenshot2} = reverse($self->{curInfo}->{screenshot2});
                       $self->{curInfo}->{screenshot2} = 'http://www.mobygames.com'.$self->{curInfo}->{screenshot2};


                          $html_Screen = $self->loadPage($self->{curInfo}->{screenshot2});
                          $found2 = index($html_Screen,"<strong>Screenshot: </strong>");
                          if ( $found2 >= 0 )
                          {
                             $html_Screen = substr($html_Screen, $found2 + length('<strong>Screenshot: </strong>'),length($html_Screen)- $found2 -length('<strong>Screenshot: </strong>') );
                             $html_Screen = substr($html_Screen,index($html_Screen," src=\"") + length(" src=\""),index($html_Screen," src=\"")-index($html_Screen," src=\"")-length(" src=\"") );
                             $self->{curInfo}->{screenshot2} = substr($html_Screen,0, index($html_Screen,"\"") );
                             if ( !($self->{curInfo}->{screenshot2} =~ m/http:\/\/www.mobygames.com/i) )
                             {
                                $self->{curInfo}->{screenshot2} = 'http://www.mobygames.com'.$self->{curInfo}->{screenshot2};
                             }

                          }

                       }

                    }


                    $self->{isBox} = 0;
            }

        }
    }

    sub end
    {
	my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{isName})
            {
                $self->{itemsList}[$self->{itemIdx}]->{name} = $origtext;
                $self->{isName} = 0;
            }
            elsif ($self->{isDate})
            {
                my ($dummy, $released) = split(/--/,$origtext);
                $self->{itemsList}[$self->{itemIdx}]->{released} = $released;
                $self->{isDate} = 0;
            }
            elsif ($self->{isPlatform})
            {
                $self->{itemsList}[$self->{itemIdx}]->{platform} = $origtext;
                $self->{itemsList}[$self->{itemIdx}]->{platform} =~ s/Windows 3.x/PC/;
                $self->{itemsList}[$self->{itemIdx}]->{platform} =~ s/Windows/PC/;
                $self->{isPlatform} = 0;
            }
        }
        elsif ($self->{parsingTips})
        {
            if ($self->{isSectionTips} eq 1)
            {
                if ($origtext =~ m/General Hints\/Tips/i)
                {
                   $self->{isTip} = 2;
                   $self->{isCode} = 0;
                }
                elsif ($origtext =~ m/Cheats\/Codes/i)
                {
                   $self->{isTip} = 0;
                   $self->{isCode} = 2;
                }
                $self->{isSectionTips} = 2;
            }
        }
        else
        {
            if ($self->{is})
            {
                $origtext =~ s/^\s*//;
                
                if ($self->{is} eq 'platform')
                {
                    $self->{curInfo}->{$self->{is}} = $origtext;
                    $self->{curInfo}->{platform} =~ s/DOS/PC/;
                    $self->{curInfo}->{platform} =~ s/Windows/PC/;
                }
                elsif ($self->{is} eq 'genre')
                {
                    if ($self->{curInfo}->{genre})
                    {
                       $self->{curInfo}->{genre} .= ' / '.$origtext;
                    }
                    else
                    {
                       $self->{curInfo}->{genre} = $origtext;
                    }
                }
                else
                {
                    $self->{curInfo}->{$self->{is}} = $origtext;
                }

                $self->{is} = '';
            }
            elsif ($self->{isDescription})
            {
                    $self->{curInfo}->{description} .= $origtext;
            }
            elsif ($origtext eq 'Developed by')
            {
                $self->{isDeveloper} = 1
            }
            elsif ($origtext eq 'Released')
            {
                $self->{isDate} = 1
            }
            elsif ($origtext eq 'Genre')
            {
                $self->{isGenre} = 1
            }
            elsif ($origtext eq 'Description')
            {
                $self->{isDescription} = 1
            }
        }
    } 

    sub getTipsUrl
    {
        my $self = shift;
        return $self->{curInfo}->{$self->{urlField}}.'/hints';
    }

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            name => 1,
            platform => 1,
            released => 1
        };

        $self->{isName} = 0;
        $self->{isGame} = 0;
        $self->{isPlatform} = 0;
        $self->{isEditor} = 0;
        $self->{isDeveloper} = 0;
        $self->{isDate} = 0;
        $self->{isGenre} = 0;
        $self->{isDescription} = 0;
        $self->{isBox} = 0;
        $self->{isScreen} = 0;
        $self->{isSectionTips} = 0;
        $self->{isTip} = 0;
        $self->{isCode} = 0;
        $self->{is} = '';

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        return $html;
    }
    
    sub getSearchUrl
    {
        my ($self, $word) = @_;
        return 'http://www.mobygames.com/search/quick/p,-1/q,'.$word.'/showOnly,9/';
    }
    
    sub getItemUrl
    {
        my ($self, $url) = @_;
		
        return $url unless $url eq '';
        return 'http://www.mobygames.com/';
    }

    sub getName
    {
        return 'mobygames.com';
    }
    
    sub getAuthor
    {
        return 'TPF';
    }
    
    sub getLang
    {
        return 'EN';
    }

    sub getCharset
    {
        my $self = shift;
    
        return "ISO-8859-1";
    }
}

1;
