package GCPlugins::GCbooks::GCbooksCasadelibro;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCbooks::GCbooksCommon;

{
    package GCPlugins::GCbooks::GCPluginCasadelibro;

    use base qw(GCPlugins::GCbooks::GCbooksPluginsBase);
    use URI::Escape;

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {

            if (($tagname eq 'div') && ($attr->{class} eq 'ficha'))
            {
                $self->{isBook} = 1 ;
                $self->{isUrl} = 1 ;
            }
            elsif (($tagname eq 'a') && ($self->{isBook}) && ($self->{isUrl}))
            {
                $self->{itemIdx}++;
                $self->{itemsList}[$self->{itemIdx}]->{url} = "http://www.casadelibro.com" . $attr->{href};
                $self->{isUrl} = 0 ;
            }
            elsif (($tagname eq 'strong') && ($self->{isBook}))
            {
                $self->{isTitle} = 1 ;
            }
            elsif (($tagname eq 'br') && ($attr->{class} eq 'limpiar'))
            {
                $self->{isBook} = 0 ;
            }
            elsif (($tagname eq 'a') && ($attr->{onmouseover} ne '') && ($self->{isBook}))
            {
                $self->{isAuthor} = 1 ;
            }
            elsif (($tagname eq 'p') && ($attr->{class} eq 'editorialLibro') && ($self->{isBook}))
            {
                $self->{isEditionPublication} = 1 ;
            }
            elsif ($tagname eq 'p')
            {
                $self->{isSansAuthor} = 1 ;
            }
        }
        else
        {
            if (($tagname eq 'div') && ($attr->{id} eq 'TPFENDCOMMENTTPF'))
            {
                $self->{isDescription} = 0 ;
            }
            elsif ($self->{isDescription})
            {
            }
            elsif (($tagname eq 'h1') && ($attr->{id} eq 'titul'))
            {
                $self->{isTitle} = 1 ;
            }
            elsif (($tagname eq 'p') && ($attr->{id} eq 'autor'))
            {
                $self->{isSansAuthor} = 1 ;
            }
            elsif (($tagname eq 'a') && ($attr->{href} =~ m|/fichas/fichaautores|i))
            {
                $self->{isAuthor} = 1 ;
            }
            elsif (($tagname eq 'p') && ($attr->{id} eq 'isbn'))
            {
                $self->{isISBN} = 1 ;
            }
            elsif (($tagname eq 'p') && ($self->{curInfo}->{title} ne ''))
            {
                $self->{isAnalyse} = 1 ;
            }
            elsif (($tagname eq 'div') && ($attr->{id} eq 'TPFSTARTCOMMENTTPF'))
            {
                $self->{isDescription} = 1 ;
            }
            elsif (($tagname eq 'img') && ($attr->{class} eq 'fotob') && ($attr->{src} ne '/img/libros/grande.gif') && ($attr->{src} ne '/img/libros/grande/grande.gif'))
            {
                $self->{curInfo}->{cover} = "http://www.casadelibro.com" . $attr->{src} ;
            }

        }
    }

    sub end
    {
        my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{isTitle})
            {
                $_= $origtext;
                # Format : "nombre. Titre"
                if (/^(\d*). *(.*)/)
                {
                   $self->{itemsList}[$self->{itemIdx}]->{title} = $2;
                }
                else
                {
                   $self->{itemsList}[$self->{itemIdx}]->{title} = $origtext;
                }
                $self->{isTitle} = 0 ;
            }
            elsif ($self->{isSansAuthor})
            {
                $_= $origtext;
                # Format : "de nomdelauteur"
                if (/^(de).\s*(.*)/)
                {
                   my @array = split(/;/,$2);
                   my $element;
                   foreach $element (@array)
                   {
                      my @nom_prenom = split(/,/,$element);
                      # Enleve les blancs en debut de chaine
                      $nom_prenom[0] =~ s/^\s//;
                      $nom_prenom[1] =~ s/^\s//;
                      # Enleve les blancs en fin de chaine
                      $nom_prenom[0] =~ s/\s$//;
                      $nom_prenom[1] =~ s/\s$//;
                      if ($self->{itemsList}[$self->{itemIdx}]->{authors} eq '')
                      {
                         if ($nom_prenom[1] ne '')
                         {
                            $self->{itemsList}[$self->{itemIdx}]->{authors} = $nom_prenom[1] ." " . $nom_prenom[0];
                         }
                         else
                         {
                            $self->{itemsList}[$self->{itemIdx}]->{authors} = $nom_prenom[0];
                         }
                       }
                      else
                      {
                         if ($nom_prenom[1] ne '')
                         {
                            $self->{itemsList}[$self->{itemIdx}]->{authors} .= ", " . $nom_prenom[1] ." " . $nom_prenom[0];
                         }
                         else
                         {
                            $self->{itemsList}[$self->{itemIdx}]->{authors} .= ", " . $nom_prenom[0];
                         }
                      }
                   }
                }

                $self->{isSansAuthor} = 0 ;
            }
            elsif ($self->{isAuthor})
            {
                my @array = split(/;/,$origtext);
                my $element;
                foreach $element (@array)
                {
                   my @nom_prenom = split(/,/,$element);
                   # Enleve les blancs en debut de chaine
                   $nom_prenom[0] =~ s/^\s//;
                   $nom_prenom[1] =~ s/^\s//;
                   # Enleve les blancs en fin de chaine
                   $nom_prenom[0] =~ s/\s$//;
                   $nom_prenom[1] =~ s/\s$//;
                   if ($self->{itemsList}[$self->{itemIdx}]->{authors} eq '')
                   {
                      if ($nom_prenom[1] ne '')
                      {
                         $self->{itemsList}[$self->{itemIdx}]->{authors} = $nom_prenom[1] ." " . $nom_prenom[0];
                      }
                      else
                      {
                         $self->{itemsList}[$self->{itemIdx}]->{authors} = $nom_prenom[0];
                      }
                    }
                   else
                   {
                      if ($nom_prenom[1] ne '')
                      {
                         $self->{itemsList}[$self->{itemIdx}]->{authors} .= ", " . $nom_prenom[1] ." " . $nom_prenom[0];
                      }
                      else
                      {
                         $self->{itemsList}[$self->{itemIdx}]->{authors} .= ", " . $nom_prenom[0];
                      }
                   }
                }

                $self->{isAuthor} = 0 ;
            }
            elsif ($self->{isEditionPublication})
            {
                $_= $origtext;
                if (/(.*)\s([0-9][0-9][0-9][0-9]$)/)
                {
                   $self->{itemsList}[$self->{itemIdx}]->{edition} = $1;
                }
                else
                {
                   $self->{itemsList}[$self->{itemIdx}]->{edition} = $origtext;
                }

                $_= $origtext;
                if (/(.*)\s([0-9][0-9][0-9][0-9]$)/)
                {
                   $self->{itemsList}[$self->{itemIdx}]->{publication} = $2;
                }

                $self->{isEditionPublication} = 0 ;
            }
        }
       	else
        {
            if ($self->{isTitle})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{isTitle} = 0 ;
            }
            elsif ($self->{isAnalyse})
            {
                $_= $origtext;
                # Format : "nombre pgs"
                if (/^(\d+).*pgs*/)
                {
                   $self->{curInfo}->{pages} = $1;
                }
                elsif ($origtext =~ m/Lengua/i)
                {
                   my @array = split(/:/,$origtext);
                   $self->{curInfo}->{language} = $array[1];
                   $self->{curInfo}->{language} =~ s/^\s//;
                }
                elsif ($origtext =~ m/Encuadernaci.*n/i)
                {
                   my @array = split(/:/,$origtext);
                   $self->{curInfo}->{format} = $array[1];
                   $self->{curInfo}->{format} =~ s/^\s//;
                }
                elsif ($self->{curInfo}->{publisher} eq '')
                {
                   $self->{curInfo}->{publisher} = $origtext;
                }

                $self->{isAnalyse} = 0 ;
            }
            elsif ($self->{isSansAuthor})
            {
                $_= $origtext;
                # Format : "de nomdelauteur"
                if (/^(de).\s*(.*)/)
                {
                   my @array = split(/;/,$2);
                   my $element;
                   foreach $element (@array)
                   {
                      my @nom_prenom = split(/,/,$element);
                      # Enleve les blancs en debut de chaine
                      $nom_prenom[0] =~ s/^\s//;
                      $nom_prenom[1] =~ s/^\s//;
                      # Enleve les blancs en fin de chaine
                      $nom_prenom[0] =~ s/\s$//;
                      $nom_prenom[1] =~ s/\s$//;
                      if ($self->{curInfo}->{authors} eq '')
                      {
                         if ($nom_prenom[1] ne '')
                         {
                            $self->{curInfo}->{authors} = $nom_prenom[1] ." " . $nom_prenom[0];
                         }
                         else
                         {
                            $self->{curInfo}->{authors} = $nom_prenom[0];
                         }
                       }
                      else
                      {
                         if ($nom_prenom[1] ne '')
                         {
                            $self->{curInfo}->{authors} .= ", " . $nom_prenom[1] ." " . $nom_prenom[0];
                         }
                         else
                         {
                            $self->{curInfo}->{authors} .= ", " . $nom_prenom[0];
                         }
                      }
                   }
                }

                $self->{isSansAuthor} = 0 ;
            }
            elsif ($self->{isAuthor})
            {
                my @array = split(/;/,$origtext);
                my $element;
                foreach $element (@array)
                {
                   my @nom_prenom = split(/,/,$element);
                   # Enleve les blancs en debut de chaine
                   $nom_prenom[0] =~ s/^\s//;
                   $nom_prenom[1] =~ s/^\s//;
                   # Enleve les blancs en fin de chaine
                   $nom_prenom[0] =~ s/\s$//;
                   $nom_prenom[1] =~ s/\s$//;
                   if ($nom_prenom[1] ne '')
                   {
                      $self->{curInfo}->{authors} .= $nom_prenom[1] ." " . $nom_prenom[0];
                   }
                   else
                   {
                      $self->{curInfo}->{authors} .= $nom_prenom[0];
                   }
                   $self->{curInfo}->{authors} .= ",";
                }

                $self->{isAuthor} = 0 ;
            }
            elsif ($self->{isISBN})
            {
                $_= $origtext;
                #Format : "ISBN: numisbn"
                if (/^(\D+):\s*(.*)/)
                {
                   $self->{curInfo}->{isbn} = $2;
                }
                else
                {
                   $self->{curInfo}->{isbn} = $origtext;
                }
                $self->{isISBN} = 0 ;
            }
            elsif ($self->{isDescription})
            {
                $self->{curInfo}->{description} .= $origtext;
            }

        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            authors => 1,
            publication => 1,
            format => 0,
            edition => 1,
        };

        $self->{isBook} = 0;
        $self->{isUrl} = 0;
        $self->{isEditionPublication} = 0 ;
        $self->{isAnalyse} = 0;
        $self->{isTitle} = 0;
        $self->{isSansAuthor} = 0;
        $self->{isAuthor} = 0;
        $self->{isISBN} = 0;
        $self->{isDescription} = 0;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        if ($self->{parsingList})
        {
            $html =~ s|'| |gi;
        }
        else
        {
            my $found = index($html,"<!-- fin modulolibro -->");
            if ( $found >= 0 )
            {
               $html = substr($html, 0, $found);
            }
            $found = index($html,"<div id=\"ottitFic\">");
            if ( $found >= 0 )
            {
               $html = substr($html, 0, $found);
            }
            # Le descriptif pouvant contenir des balises html je le repere maintenant
            $found = index($html,"<div id=\"resumFic\">");
            if ( $found >= 0 )
            {
               my $html2 = substr($html, $found +length('<div id="resumFic">'),length($html)- $found -length('<div id="resumFic">'));
               my $found2 = index($html2,"</div>");
               if ( $found >= 0 )
               {
                  $html2 = substr($html2, 0, $found2);
               }

               $html2 =~ s|<p>|\n|gi;
               $html2 =~ s|</p>||gi;
               $html2 =~ s|<br>|\n|gi;
               $html2 =~ s|<br />|\n|gi;

               $html = substr($html, 0, $found) . "<div id=\"TPFSTARTCOMMENTTPF\">" . $html2 ."</div><div id=\"TPFENDCOMMENTTPF\"></div>";
            }
            $html =~ s|<li>|\n* |gi;
            $html =~ s|<br>|\n|gi;
            $html =~ s|<br />|\n|gi;
            $html =~ s|<b>||gi;
            $html =~ s|</b>||gi;
            $html =~ s|<i>||gi;
            $html =~ s|</i>||gi;
        }
        
        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        if ($self->{searchField} eq 'isbn')
        {
            return "http://www.casadellibro.com/busquedas/quickResults/0,,1-i-" . $word. ",00.html?tBusq=t&tValueForSearch=" .$word. "&cFo=true&rOd=&NotQueryAgain=false";
        }
        else
        {
            return "http://www.casadellibro.com/busquedas/quickResults/0,,1-t-" . $word. ",00.html?tBusq=t&tValueForSearch=" .$word. "&cFo=true&rOd=&NotQueryAgain=false";
        }

    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return $url;
    }

    sub getName
    {
        return "Casadelibro";
    }
    
    sub getImageFile
    {
        return "Casadelibro.png";
    }

    sub getAuthor
    {
        return 'TPF';
    }
    
    sub getLang
    {
        return 'ES';
    }

    sub getSearchFieldsArray
    {
        return ['isbn', 'title'];
    }

}

1;
