package GCPlugins::GCbooks::GCAlapage;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCbooks::GCbooksCommon;

{
    package GCPlugins::GCbooks::GCPluginAlapage;

    use base qw(GCPlugins::GCbooks::GCbooksPluginsBase);
    use URI::Escape;

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {

            if ($tagname eq 'div')
            {
                $self->{isBook} = 0 ;
            }
            elsif (($tagname eq 'td') && ($attr->{class} eq 'tx12gris'))
            {
                $self->{isBook} = 1 ;
                $self->{isUrl} = 1 ;
            }
            elsif (($tagname eq 'a') && ($self->{isUrl}) && ($self->{isBook}))
            {
                $self->{itemIdx}++;
                $self->{itemsList}[$self->{itemIdx}]->{url} = $attr->{href};
                $self->{isUrl} = 0 ;
            }
            elsif (($tagname eq 'u') && ($self->{isBook}))
            {
                $self->{isTitle} = 1 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"mot_auteurs") >= 0) && ($attr->{class} eq 'roll') && ($self->{isBook}))
            {
                $self->{isAuthor} = 1 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"mot_editeur") >= 0) && ($attr->{class} eq 'roll') && ($self->{isBook}))
            {
                $self->{isPublisher} = 1 ;
            }
            elsif (($tagname eq 'span') && ($attr->{class} eq 'tx12gris6') && ($self->{isPublisher}) && ($self->{isBook}))
            {
                $self->{isPublisher} = 2 ;
            }
        }
        else
        {
            if (($tagname eq 'span') && ($attr->{style} eq 'color:#414B55;'))
            {
                $self->{isTitle} = 1 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"mot_auteurs") >= 0) && ($attr->{class} eq 'roll'))
            {
                $self->{isAuthor} = 1 ;
            }
            elsif ($tagname eq 'tpfcouverture')
            {
                $self->{isCover} = 1 ;
            }
            elsif ($tagname eq 'tpfisbn')
            {
                $self->{isISBN} = 1 ;
            }
            elsif (($tagname eq 'span') && ($attr->{class} eq 'tx12noir') && ($self->{isISBN}))
            {
                $self->{isISBN} = 2 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"mot_genre") >= 0) && ($attr->{class} eq 'roll'))
            {
                $self->{isGenre} = 1 ;
            }
            elsif (($tagname eq 'span') && ($attr->{class} eq 'tx12noir') && ($self->{isGenre}))
            {
                $self->{isGenre} = 2 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"mot_editeur") >= 0) && ($attr->{class} eq 'roll'))
            {
                $self->{isPublisher} = 1 ;
            }
            elsif (($tagname eq 'span') && ($attr->{class} eq 'tx12noir') && ($self->{isPublisher}))
            {
                $self->{isPublisher} = 2 ;
            }
            elsif ($tagname eq 'tpfdateparution')
            {
                $self->{isParution} = 1 ;
            }
            elsif (($tagname eq 'span') && ($attr->{class} eq 'tx12noir') && ($self->{isParution}))
            {
                $self->{isParution} = 2 ;
            }
            elsif ($tagname eq 'tpfpage')
            {
                $self->{isPage} = 1 ;
            }
            elsif ($tagname eq 'tpfpresentation')
            {
                $self->{isPresentation} = 1 ;
                $self->{isPage} = 1 ;
            }
            elsif (($tagname eq 'span') && ($attr->{class} eq 'tx12noir') && ($self->{isPresentation}))
            {
                $self->{isPresentation} = 2 ;
            }
            elsif (($tagname eq 'a') && ($attr->{name} eq 'commentaires'))
            {
                $self->{isPage} = 0 ;
                $self->{isDescription} = 1 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"mot_coll_serie") >= 0) && ($attr->{class} eq 'roll'))
            {
                $self->{curInfo}->{serie} = uri_unescape($attr->{href});
                my $found = index($self->{curInfo}->{serie},"mot_coll_serie=");
                if ( $found >= 0 )
                {
                   $self->{curInfo}->{serie} = substr($self->{curInfo}->{serie}, $found +length('mot_coll_serie='),length($self->{curInfo}->{serie})- $found -length('mot_coll_serie='));
                   $self->{curInfo}->{serie} = substr($self->{curInfo}->{serie}, 0, index($self->{curInfo}->{serie},"/"));
                }

            }
            elsif (($tagname eq 'div') && ($attr->{align} eq 'justify') && ($self->{isDescription}))
            {
                $self->{isDescription} = 2 ;
            }

        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{isTitle})
            {
                $self->{itemsList}[$self->{itemIdx}]->{title} = $origtext;
                $self->{isTitle} = 0 ;
            }
            elsif ($self->{isAuthor})
            {
                if ($self->{itemsList}[$self->{itemIdx}]->{authors} eq '')
                {
                   $self->{itemsList}[$self->{itemIdx}]->{authors} = $origtext;
                }
                else
                {
                   $self->{itemsList}[$self->{itemIdx}]->{authors} .= ', ';
                   $self->{itemsList}[$self->{itemIdx}]->{authors} .= $origtext;
                }
                $self->{isAuthor} = 0 ;
            }
            elsif ($self->{isPublisher} eq 2)
            {
                $self->{itemsList}[$self->{itemIdx}]->{edition} = $origtext;
                $self->{isPublisher} = 0 ;
            }
        }
       	else
        {
            # Enleve les blancs en debut de chaine
            $origtext =~ s/^\s+//;
            if ($self->{isTitle})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{curInfo}->{language} = 'Franais';
                $self->{isTitle} = 0 ;
            }
            elsif ($self->{isAuthor})
            {
                $self->{curInfo}->{authors} .= $origtext;
                $self->{curInfo}->{authors} .= "\n";
                $self->{isAuthor} = 0 ;
            }
            elsif ($self->{isISBN} eq 2)
            {
                $self->{curInfo}->{isbn} = $origtext;
                if ($self->{isCover})
                {
                   $self->{curInfo}->{cover} = 'http://imgdata.echo.fr/livre_l?l_isbn=' .$self->{curInfo}->{isbn} .'r';
                   $self->{isCover} = 0 ;
                }
                $self->{isISBN} = 0 ;
            }
            elsif ($self->{isGenre} eq 2)
            {
                my @array = split(/,/,$origtext);
                my $element;
                foreach $element (@array)
                {
                   $element =~ s/^\s+//;
                   $self->{curInfo}->{genre} .= $element;
                   $self->{curInfo}->{genre} .= "\n";
                }
                $self->{isGenre} = 0 ;
            }
            elsif ($self->{isPublisher} eq 2)
            {
                $self->{curInfo}->{publisher} = $origtext;
                $self->{isPublisher} = 0 ;
            }
            elsif ($self->{isParution} eq 2)
            {
                $self->{curInfo}->{publication} = $origtext;
                $self->{isParution} = 0 ;
            }
            elsif ($self->{isPresentation} eq 2)
            {
                $self->{curInfo}->{format} = ucfirst($origtext);
                $self->{isPresentation} = 0 ;
            }
            elsif (($self->{isPage}) && ($origtext =~ m/pages/i) )
            {
                $self->{curInfo}->{pages} = $origtext;
                $self->{isPage} = 0 ;
            }
            elsif ($self->{isDescription} eq 2)
            {
                $self->{curInfo}->{description} = $origtext;
                $self->{isDescription} = 0 ;
            }

        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            authors => 1,
            publication => 0,
            format => 0,
            edition => 1,
        };

        $self->{isBook} = 0;
        $self->{isUrl} = 0;
        $self->{isTitle} = 0;
        $self->{isAuthor} = 0;
        $self->{isPublisher} = 0;
        $self->{isISBN} = 0;
        $self->{isGenre} = 0;
        $self->{isParution} = 0;
        $self->{isPresentation} = 0;
        $self->{isPage} = 0;
        $self->{isCover} = 0;
        $self->{isDescription} = 0;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        if ($self->{parsingList})
        {
        }
        else
        {
            my $found = index($html,"<!--DEBUT ARTICLE-->");
            if ( $found >= 0 )
            {
               $html = substr($html, $found +length('<!--DEBUT ARTICLE-->'),length($html)- $found -length('<!--DEBUT ARTICLE-->'));
            }
            $found = index($html,"<TD width=\"100%\" class=\"tx14grisbold\">&nbsp;Dposez votre avis</TD>");
            if ( $found >= 0 )
            {
               $html = substr($html, 0, $found);
            }
            $html =~ s/> ISBN : </><tpfisbn><\/tpfisbn></g;
            $html =~ s/>Date de Parution : </><tpfdateparution><\/tpfdateparution></g;
            $html =~ s/alt=""><BR>Pr&eacute;sentation :   - </alt=""><BR>Pas de presentation<tpfpage><\/tpfpage></g;
            $html =~ s/alt=""><BR>Pr&eacute;sentation : /alt=""><BR><tpfpresentation><\/tpfpresentation>/g;
            $html =~ s/<\/SPAN>&nbsp;pages/&nbsp;pages<\/SPAN>/g;
            $html =~ s/<A href="javascript:{agrandir\(/<tpfcouverture><\/tpfcouverture><A href="javascript:{agrandir\(/;
        }
        
        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.alapage.com/-/Liste/Livres/fulltext=" . $word;
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return "http://www.alapage.com" . $url;
    }

    sub getName
    {
        return "Alapage";
    }
    
    sub getImageFile
    {
        return "alapage.png";
    }

    sub getAuthor
    {
        return 'TPF';
    }
    
    sub getLang
    {
        return 'FR';
    }

}

1;
