{
    package GCLang;
    
###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use base 'Exporter';
our @EXPORT = qw(%langs @langsNames);

use File::Basename;
use FindBin qw($RealBin $Script);
use GCUtils 'glob';
    
our %langs;
our @langsNames = ();

sub loadLang
{
    my $lang = shift;
    
    eval "use GCLang::${lang}::GCstar";
    my %tmpLang;
    eval "%tmpLang = %GCLang::${lang}::lang";
    $langs{$lang} = \%tmpLang;        
}

sub loadLangs
{
    my $lang = shift;

    return if $#langsNames >= 0;
    if ($lang)
    {
        loadLang($lang);
    }
    else
    {
        foreach (glob $ENV{GCS_LIB_DIR}.'/GCLang/*')
        {
            next if /CVS/ || /pm$/;
            my $lang = basename($_);
            loadLang($lang);
        }
    }

    foreach (keys %langs)
    {
        push @langsNames, $langs{$_}->{LangName};
    }
    @langsNames = sort @langsNames;
}

sub loadPluginsLangs
{
    foreach (glob $ENV{GCS_LIB_DIR}.'/GCLang/*')
    {
        next if /CVS/ || /pm$/;
        my $lang = basename($_);
        foreach my $dir(glob $ENV{GCS_LIB_DIR}."/GCLang/$lang/*")
        {
            next if /\.pm$/;
            foreach my $plugin(glob "$dir/*.pm")
            {
                my $module = basename($dir);
                my %tmpLang;
                ($plugin = basename($plugin)) =~ s/\.pm$//;
                eval "use GCLang::".$lang."::".$module."::".$plugin."\n";
                eval "%tmpLang = %GCLang::".$lang."::".$module."::".$plugin."::lang";
                foreach my $key(keys %tmpLang)
                {
                    $langs{$lang}->{$module.'/'.$plugin.".pm '".$key."'"} = $tmpLang{$key};
                }
            }
        }
    }
    
}

# Used to check languages (which translation are missing)
# Usage: perl -e "use GCLang; GCLang::checkLangs"
sub checkLangs
{
    my @langsToCheck = @_;

    my $ref = 'EN';
    my $otherRef = 'FR';
    
    loadLangs;
    loadPluginsLangs;
    
    my @langsList = scalar @langsToCheck ? @langsToCheck : keys %langs;
    
    my %results;
    foreach (sort keys %{$langs{$ref}})
    {
        foreach my $langName(@langsList)
        {
            next if $langName eq $ref;
            if (! exists $langs{$langName}->{$_})
            {
                push @{$results{$langName}{error}}, $_;
            }
            else
            {
                next if $langName eq $otherRef;
                push @{$results{$langName}{warning}}, $_
                    if ($langs{$langName}->{$_} eq $langs{$ref}->{$_})
                    || ($langs{$langName}->{$_} eq $langs{$otherRef}->{$_});
            }
        }
    }
    
    foreach (sort keys %results)
    {
        print "\n\nLang $_\n-------\n\n";
        print "Errors:\n\n";
        foreach my $value(@{$results{$_}{error}})
        {
            next if $value =~ m|^GC.*?/|;
            print "'$value' => '",$langs{$ref}->{$value},"',\n";
        }
        print "\n";
        foreach my $value(@{$results{$_}{error}})
        {
            next if $value !~ m|^GC.*?/|;
            print "$value => '",$langs{$ref}->{$value},"',\n";
        }
        next if $ENV{GCS_ERRORS_ONLY} eq 'YES';
        print "\nWarnings:\n\n";
        foreach my $value(@{$results{$_}{warning}})
        {
            next if $value =~ m|^GC.*?/|;
            print "'$value' => '",$langs{$_}->{$value},"',\n";
        }
        print "\n";
        foreach my $value(@{$results{$_}{warning}})
        {
            next if $value !~ m|^GC.*?/|;
            print "$value => '",$langs{$_}->{$value},"',\n";
        }
    }
}

    
}


1;
