package GCExport::GCExportCSV;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCExport::GCExportBase;

{
    package GCExport::GCExporterCSV;

    use base qw(GCExport::GCExportBaseClass);

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        
        bless ($self, $class);
        return $self;
    }

    sub getName
    {
        my $self = shift;
        
        return "CSV";
    }
    
    sub getOptions
    {
        my $self = shift;
        
        return [
            {
                name => 'sep',
                type => 'short text',
                label => 'Separator',
                default => ';'
            },

            {
                name => 'rep',
                type => 'short text',
                label => 'Replacement',
                default => ','
            },

            {
                name => 'withHeader',
                type => 'yesno',
                label => 'Header',
                default => '1'
            },

        ];
        
    }
      
    sub wantsFieldsSelection
    {
        return 1;
    }
    
    sub wantsImagesSelection
    {
        return 1;
    }
    
    sub preProcess
    {
        my $self =  shift;
    }

    sub transformValue
    {
        my ($self, $value, $field) = @_;
        
        if ($field)
        {
            $value = $self->SUPER::transformValue($value, $field);
        }
        $value =~ s/,+$//;
        $value =~ s /$self->{options}->{sep}/$self->{options}->{rep}/g;            
        $value =~ s/\n|\r//g;
        $value =~ s/<br\/>/ /g;
        return $value;
    }

    sub getHeader
    {
        my ($self, $number) = @_;
        my $result = '';
        
        if ($self->{options}->{withHeader})
        {
            foreach (@{$self->{options}->{fields}})
            {
                #my $column = $self->{options}->{lang}->{FieldsList}->{$_};
                my $column = $self->{model}->{fieldsInfo}->{$_}->{displayed};
                $result .= $self->transformValue($column).$self->{options}->{sep};
            }
            $result =~ s/$self->{options}->{sep}$//;
            $result .= "\n";
        }
        
        return $result;
    }

    sub getItem
    {
        my ($self, $item, $number) = @_;
        my $result;
        foreach (@{$self->{options}->{fields}})
        {
            my $value = $item->{$_};
            $result .= $self->transformValue($value, $_).$self->{options}->{sep};
        }
        $result =~ s/$self->{options}->{sep}$//;
        $result .= "\n";
        
        return $result;
    }
    
    sub getFooter
    {
        my $self = shift;
        my $result;

        return $result;
    }

    sub postProcess
    {
        my ($self, $header, $body) = @_;
    }

    sub getEndInfo
    {
        my $self = shift;
        my $message;
        
        return $message;
    }
}

1;