/* This file is part of gconjugue
**
** It is distributed under the GNU General Public License.
** See the file COPYING for details.
** 
** (c) 2005-2006 Jakson Aquino: jalvesaq@gmail.com
**
***************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "callbacks.h"
#include "interface.h"


extern GtkWidget *window1;
extern int initWidth, initHeight;
extern char *confFileName;

void finish_gconjugue(){
  int h, w;

  /* Save the window dimensions */
  gtk_window_get_size((GtkWindow*)window1, &w, &h);
  if(w != initWidth || h != initHeight){
    FILE *F = fopen(confFileName, "w");
    if(F){
      fprintf(F, "%s = %d\n", _("height"), h);
      fprintf(F, "%s = %d\n", _("width"), w);
      fclose(F);
    } else{
      fprintf(stderr, _("gconjugue: could not write configuration file \"%s\".\n"),
	  confFileName);
    }
  }

  gtk_main_quit();
}

void erro_fatal(char *s){
  fprintf(stderr, _("gconjugue: FATAL ERROR:\n\n%s\n"), s);
  GtkWidget *dialog;
  dialog = gtk_message_dialog_new (GTK_WINDOW (window1), GTK_DIALOG_MODAL | 
      GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
      _("gconjugue: FATAL ERROR:\n\n%s\n"), s);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
  exit(1);
}

void on_sair1_activate(GtkMenuItem *menuitem, gpointer user_data){
  finish_gconjugue();
}

void on_tips1_activate(GtkMenuItem *menuitem, gpointer user_data){
  GtkWidget *dialog;
  char *s1 = _(
      " - GConjugue is a graphical front end to \"conjugue\", which\n"
      "    was written by Ricardo Ueda Karpischek. The software \n"
      "    \"conjugue\" is part of a package usually called\n"
      "    \"brazilian-conjugate\".\n\n");
  char *s2 = _(
      " - You can use the command line application \"conjugue\" to\n"
      "    conjugate several dozen verbs at once in less than one\n"
      "    second. Save the list of verbs in a file (each line\n"
      "    should contain just one verb), and type in a terminal:\n\n"
      "       conjugue < listOfVerbs > conjugatedVerbs\n\n");
  char *s3 = _(
      " - You can visit the project homepage if you have any\n"
      "    problem with this software. If you do not find a solution\n"
      "    there, please write to Jakson Aquino <jalvesaq@gmail.com>.\n\n"
      "    Homepage: http://gconjugue.codigolivre.org.br/\n\n");
  char *s = (char*)malloc(strlen(s1) + strlen(s2) + strlen(s3) + 1);
  sprintf(s, "%s%s%s", s1, s2, s3);

  dialog = gtk_message_dialog_new (GTK_WINDOW (window1), GTK_DIALOG_MODAL | 
      GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, s);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
  free(s);
}

void on_sobre1_activate(GtkMenuItem *menuitem, gpointer user_data){
  GtkWidget *dialog;
  dialog = gtk_message_dialog_new (GTK_WINDOW (window1), GTK_DIALOG_MODAL | 
      GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, _(
      "gconjugue %s\n(c) 2005-2006 Jakson A. Aquino <jalvesaq@gmail.com>\n\n"
      "gconjugue is a front end to \"conjugue\",\n"
      "which was developed by Ricardo Ueda Karpischek\n\n"
      "gconjugue is free software under GNU GPL license."), VERSION);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

void conjugar(const char *vrb, GtkTextBuffer *b){
  char s[255], *b1, *b2, *b3;
  int i, j, l;

  /* Skipping problematic chars...*/
  while(vrb[0] == ' ' || vrb[0] == '&' || vrb[0] == '>' || vrb[0] == '<'
      || vrb[0] == '(' || vrb[0] == ')' || vrb[0] == '|' || vrb[0] == '"'
      || vrb[0] == '\'' || vrb[0] == '$')
    vrb++;
  i = strlen(vrb);
  char *verbo = (char*)malloc(sizeof(char) * (i + 1));
  if(verbo == NULL)
    return;
  strcpy(verbo, vrb);
  for(j = 0; j < i; j++)
    if(verbo[j] == ' ' ||verbo[j] == '&' || verbo[j] == '>' || verbo[j] == '<'
	|| verbo[j] == '(' || verbo[j] == ')' || verbo[j] == '|' ||
	verbo[j] == '"' || verbo[j] == '\'' || verbo[j] == '$')
      verbo[j] = 0;
  i = strlen(verbo);
  if(i < 2 || i > 40)
    return;

  gchar *verb2 = g_utf8_strdown(verbo, i);
  free(verbo);
  if(strcmp(verb2, "por") == 0){
    g_free(verb2);
    GtkWidget *dialog;
    /* TODO: replace "its homonym" with "the verb pôr" when the libintl-* has
     * support to UTF-8 */
    dialog = gtk_message_dialog_new_with_markup (GTK_WINDOW (window1), GTK_DIALOG_MODAL,
	GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _("I can't conjugate the preposition "
	  "\"<b>por</b>\". Would you like to have its homonym verb conjugated?"));
    gint answer = gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy (dialog);
    if(answer == GTK_RESPONSE_YES)
      verb2 = g_strdup("pôr");
    else
      return;
  }

  i = strlen(verb2);
  char r = verb2[i-1];
  char v = verb2[i-2];
  if(r == 'r' && (v == 'a' || v == 'e' || v == 'i' || 
	(v == 'o' && i > 3 && verb2[i-3] == 'p') || strcmp(verb2, "pôr") == 0)){
    /* Running conjugue */
    sprintf(s, "conjugue -v FORMATO=ll -v CMD=%s", verb2);
    FILE *F = popen(s, "r");
    b1 = (char*)malloc(10000 * sizeof(char));
    size_t tamanho = fread(b1, 1, 9999, F);
    b1[tamanho] = '\0';
    int erro = pclose(F);
    if(erro){
      GtkWidget *dialog;
      dialog = gtk_message_dialog_new (GTK_WINDOW (window1), GTK_DIALOG_MODAL | 
	  GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
	  _("Error trying to execute the command:\n%s\n\nAre you sure "
	    "that \"conjugue\" (brazilian-conjugate) is installed?"), s);
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      return;
    }

    /* Converting the output into UTF-8 (if necessary) */
    GError *er = NULL;
    b2 = g_locale_to_utf8(b1, -1, NULL, NULL, &er);
    if(er != NULL){
      GError *er2 = NULL;
      b2 = g_convert(b1, -1, "UTF-8", "ISO-8859-1", NULL, NULL, &er2);
      if(er2 != NULL){
	GtkWidget *dialog;
	dialog = gtk_message_dialog_new(GTK_WINDOW (window1), GTK_DIALOG_MODAL | 
	    GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
	    _("Errors in character conversion:\n"
	      "Attempt 1: \"%s\"\nAttempt 2: \"%s\"\n"),
	    er->message, er2->message);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
	g_error_free(er2);
	g_error_free (er);
	free(b1);
	return;
      }
      g_error_free (er);
    }
    free(b1);

    /* We use bold and/or blue fonts sometimes */
    l = strlen(b2);
    b3 = (char*)calloc(sizeof(char), (l * 2 + 100));
    if(b3 == NULL)
      erro_fatal(_("Not enough memory!"));
    sprintf(b3, "\n \1%s\5\n\n", verb2);
    char *ptr;
    ptr = strstr(b2, "sou capaz de conjugar");
    if(ptr){
      snprintf(s, 254, _("I can't conjugate \"%s\""), verb2);
      sprintf(b3, "\n \2%s\5\n", s);
    } else{
      ptr = strstr(b2, "consta do banco de verbos");
      if(ptr){
	i = 26;
	snprintf(s, 254, _("[\"%s\" is not in the verb database]"), verb2);
	char s2[255];
	snprintf(s2, 254, "%s \2%s\5\n", b3, s);
	strcpy(b3, s2);
      } else{
	i = 0;
	ptr = b2;
      }
      j = strlen(b3);
      l = strlen(ptr);
      while(i < l){
	if(ptr[i] == '\n' && ptr[i+1] != ' '){
	  b3[j] = '\n'; j++;
	  b3[j] = '\n'; j++;
	  b3[j] = ' '; j++;
	  i++;
	  while(ptr[i] == '\n' && i < l){
	    b3[j] = ptr[i];
	    i++; j++;
	  }
	  b3[j] = 4;
	  j++;
	  while(ptr[i] != '\n' && i < l){
	    b3[j] = ptr[i];
	    i++; j++;
	  }
	  b3[j] = 5;
	  j++;
	} else{
	  if(ptr[i] == '#'){
	    b3[j] = 3;
	    j++; i++;
	    while(ptr[i] != '\n' && i < l){
	      b3[j] = ptr[i];
	      i++; j++;
	    }
	    b3[j] = 5;
	    j++;
	  } else{
	    if(ptr[i-1] == '\n' && ptr[i] == ' '){
	      b3[j] = ' ';
	      j++;
	    }
	    b3[j] = ptr[i];
	    j++;
	    i++;
	  }
	}
      }
    }
    g_free(b2);
  } else{
    snprintf(s, 254, _("I can't conjugate \"%s\""), verb2);
    b3 = (char*)calloc(sizeof(char), (strlen(s) + 16));
    sprintf(b3, "\n \2%s\5\n", s);
  }
  g_free(verb2);

  /* Inserting text with tags in the GtkTextBuffer */
  gtk_text_buffer_set_text(b, " ", 0);
  l = strlen(b3);
  char letra;
  GtkTextIter iter;
  gtk_text_buffer_get_iter_at_offset (b, &iter, 0);
  i = 0;
  j = 0;
  while(i < l){
    if(b3[i] > 0 && b3[i] < 6){
      letra = b3[i];
      gtk_text_buffer_insert(b, &iter, b3+j, i-j);
      i++;
      j = i;
      while(b3[i] != 5)
	i++;
      if(letra == 4)
	gtk_text_buffer_insert_with_tags_by_name(b, &iter, b3+j, i-j,
	    "bold", NULL);
      else
	if(letra == 3)
	  gtk_text_buffer_insert_with_tags_by_name(b, &iter, b3+j, i-j,
	      "blue", NULL);
	else
	  if(letra == 2)
	    gtk_text_buffer_insert_with_tags_by_name(b, &iter, b3+j, i-j,
		"red", NULL);
	  else
	    if(letra == 1)
	      gtk_text_buffer_insert_with_tags_by_name(b, &iter, b3+j, i-j,
		  "large", "bold", NULL);
      i++;
      j = i;
    } else
      i++;
  }
  gtk_text_buffer_insert(b, &iter, b3+j, -1);

  free(b3);
}


gboolean on_window1_delete_event (GtkWidget *widget, GdkEvent *event,
    gpointer user_data){
  finish_gconjugue();
  return FALSE;
}

void read_verb(){
  GtkEntry *e = (GtkEntry*)entry1;
  GtkTextView *v = (GtkTextView*)textview1;
  GtkTextBuffer *b = gtk_text_view_get_buffer(v);
  const char *vrb = gtk_entry_get_text(e);
  conjugar(vrb, b);
  gtk_editable_select_region(GTK_EDITABLE(e), 0, e->text_length);
}

void on_btconjg_clicked(GtkButton *button, gpointer user_data){
  read_verb();
}

void on_entry1_activate (GtkEntry *entry, gpointer user_data){
  read_verb();
}

