/*
** Copyright (C) 17 Feb 2001 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

typedef struct {
	int fd; /* file descriptor where output can be available (ie the fd can
		   read without blocking) */
	int (*callback)(int fd); /* called when data is available on the fd */

	int status; /* TRUE this fd is valid, FALSE not valid */
} pipe_handler;

typedef struct {
	pipe_handler *ph1;
	pipe_handler *ph2;
	void (*end_callback)(void); /* called when both the fds are finnished */
} two_pipe_handlers;

extern int handle_output(gpointer data);

