/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>

#include "comiclist.h"

extern GladeXML *xml;
extern GString *GLADE_FILE;
extern GList *ComicList;

extern gchar *current_filename;
extern gboolean file_changed;

extern gchar *MainWindowKey;
extern gchar *ComicListKey;
extern gchar *ComicToAddKey;
extern gchar *ComicToAddToKey;
extern gchar *ComicToEditKey;
extern gchar *IssueToEditKey;

gboolean on_add_sequence_of_issues_window_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  GtkWidget *add_sequence_of_issues_window;
  GladeXML *temp_xml = user_data;

  add_sequence_of_issues_window = glade_xml_get_widget(temp_xml, "add_sequence_of_issues_window");
  gtk_widget_destroy(add_sequence_of_issues_window);

  return FALSE;
}


void on_add_sequence_of_issues_ok_button_clicked (GtkButton *button, gpointer user_data)
{
  /* FIXME - do something useful */
  GtkWidget *add_sequence_of_issues_window;
  GladeXML *temp_xml = user_data;

  add_sequence_of_issues_window = glade_xml_get_widget(temp_xml, "add_sequence_of_issues_window");
  gtk_widget_destroy(add_sequence_of_issues_window);
}


void on_add_sequence_of_issues_cancel_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *add_sequence_of_issues_window;
  GladeXML *temp_xml = user_data;

  add_sequence_of_issues_window = glade_xml_get_widget(temp_xml, "add_sequence_of_issues_window");
  gtk_widget_destroy(add_sequence_of_issues_window);
}

void connect_add_sequence_of_issues_window_signals (GladeXML *temp_xml)
{
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "ok_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_add_sequence_of_issues_ok_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "cancel_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_add_sequence_of_issues_cancel_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "add_sequence_of_issues_window")), "delete_event",
			   GTK_SIGNAL_FUNC(on_add_sequence_of_issues_window_delete_event), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
}

void create_new_sequence_of_issues (GtkWidget *generic)
{
   GtkWidget *add_sequence_of_issues_window = NULL;
   GtkWidget *comics_tree;
   GList *SelectedItem, *TempComicGList;
   TComic *ComicToAddIssueTo;
   GladeXML *temp_xml;

   comics_tree = glade_xml_get_widget (xml, "comics_tree");
   SelectedItem = GTK_TREE_SELECTION (comics_tree);

   if (SelectedItem != NULL)
     {
       TempComicGList = gtk_object_get_data (GTK_OBJECT (SelectedItem->data), ComicListKey);
      
       ComicToAddIssueTo = TempComicGList->data;
      

       temp_xml = glade_xml_new (GLADE_FILE->str, "add_issue_window");
       add_sequence_of_issues_window = glade_xml_get_widget (temp_xml, "add_sequence_of_issues_window");

       connect_add_sequence_of_issues_window_signals (temp_xml);

       gtk_object_set_data (GTK_OBJECT (add_sequence_of_issues_window), ComicToAddKey, ComicToAddIssueTo);
       gtk_widget_show (add_sequence_of_issues_window);
     }
}
