/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <stdlib.h>

#include "comiclist.h"
#include "functions.h"

extern GladeXML *xml;
extern GString *GLADE_FILE;
extern GList *ComicList;

extern gchar *current_filename;
extern gboolean file_changed;

extern gchar *MainWindowKey;
extern gchar *ComicListKey;
extern gchar *ComicToAddKey;
extern gchar *ComicToAddToKey;
extern gchar *ComicToEditKey;
extern gchar *IssueToEditKey;


extern GList *cover_price_history;
extern GList *current_price_history;
extern GList *purchase_price_history;
extern GList *location_history;

extern GList *writer_history;
extern GList *penciler_history;
extern GList *inker_history;

extern gboolean auto_fill_issue;


/* function prototypes - START */
void on_add_title_button_clicked (GtkButton *button, gpointer user_data);
void on_remove_title_button_clicked (GtkButton *button, gpointer user_data);
void on_add_writer_button_clicked (GtkButton *button, gpointer user_data);
void on_remove_writer_button_clicked (GtkButton *button, gpointer user_data);
void on_add_penciler_button_clicked (GtkButton *button, gpointer user_data);
void on_remove_penciler_button_clicked (GtkButton *button, gpointer user_data);
void on_add_inker_button_clicked (GtkButton  *button, gpointer user_data);
void on_remove_inker_button_clicked (GtkButton *button, gpointer user_data);
void on_add_issue_window_show (GtkWidget *widget, gpointer user_data);
void on_add_issue_window_ok_button_clicked (GtkButton *button, gpointer user_data);
void on_add_issue_window_cancel_button_clicked (GtkButton *button, gpointer user_data);
gboolean on_add_issue_window_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
/* function prototypes - END */


void connect_add_issue_window_signals (GladeXML *temp_xml)
{
  gtk_signal_connect(GTK_OBJECT(glade_xml_get_widget (temp_xml, "add_title_button")), "clicked",
		     GTK_SIGNAL_FUNC(on_add_title_button_clicked), temp_xml);
  gtk_signal_connect(GTK_OBJECT(glade_xml_get_widget (temp_xml, "remove_title_button")), "clicked",
		     GTK_SIGNAL_FUNC(on_remove_title_button_clicked), temp_xml);

  gtk_signal_connect(GTK_OBJECT(glade_xml_get_widget (temp_xml, "add_writer_button")), "clicked",
		     GTK_SIGNAL_FUNC(on_add_writer_button_clicked), temp_xml);
  gtk_signal_connect(GTK_OBJECT(glade_xml_get_widget (temp_xml, "remove_writer_button")), "clicked",
		     GTK_SIGNAL_FUNC(on_remove_writer_button_clicked), temp_xml);

  gtk_signal_connect(GTK_OBJECT(glade_xml_get_widget (temp_xml, "add_penciler_button")), "clicked",
		     GTK_SIGNAL_FUNC(on_add_penciler_button_clicked), temp_xml);
  gtk_signal_connect(GTK_OBJECT(glade_xml_get_widget (temp_xml, "remove_penciler_button")), "clicked",
		     GTK_SIGNAL_FUNC(on_remove_penciler_button_clicked), temp_xml);

  gtk_signal_connect(GTK_OBJECT(glade_xml_get_widget (temp_xml, "add_inker_button")), "clicked",
		     GTK_SIGNAL_FUNC(on_add_inker_button_clicked), temp_xml);
  gtk_signal_connect(GTK_OBJECT(glade_xml_get_widget (temp_xml, "remove_inker_button")), "clicked",
		     GTK_SIGNAL_FUNC(on_remove_inker_button_clicked), temp_xml);

  gtk_signal_connect(GTK_OBJECT(glade_xml_get_widget (temp_xml, "add_issue_window")), "show",
		     GTK_SIGNAL_FUNC(on_add_issue_window_show), temp_xml);

  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "ok_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_add_issue_window_ok_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "cancel_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_add_issue_window_cancel_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "add_issue_window")), "delete_event",
			   GTK_SIGNAL_FUNC(on_add_issue_window_delete_event), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
}

GtkWidget *create_new_issue_window(GtkWidget *generic, GList *selected, gchar *title, gboolean show)
{
  GList *TempComicGList;
  TComic *ComicToAddIssueTo;
  GtkWidget *add_issue_window;
  GtkWindow *main_window;
  GString *wintitle;
  GladeXML *temp_xml;

  wintitle = g_string_new(NULL);
  TempComicGList = gtk_object_get_data (GTK_OBJECT (selected->data), ComicListKey);
  if (!TempComicGList) return NULL;

  ComicToAddIssueTo = TempComicGList->data;

  temp_xml = glade_xml_new (GLADE_FILE->str, "add_issue_window");
  add_issue_window = glade_xml_get_widget (temp_xml, "add_issue_window");

  connect_add_issue_window_signals (temp_xml);
      
  /* set main window as transient, so we can grab it later for refreshes */
  main_window = (GtkWindow *) glade_xml_get_widget (xml, "main_window");
  gtk_window_set_transient_for(GTK_WINDOW(add_issue_window), main_window);

  gtk_object_set_data (GTK_OBJECT (add_issue_window), ComicToAddToKey, ComicToAddIssueTo);
  if (title)
    {
      g_string_sprintf(wintitle, "%s - %s", title, ComicToAddIssueTo->CTitle->str);
      gtk_window_set_title (GTK_WINDOW (add_issue_window), wintitle->str);
    }
  if (show) gtk_widget_show (add_issue_window);

  return add_issue_window;
}


/* callback functions - START */
void on_add_issue_window_ok_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *add_issue_window;
  GtkWidget *IssueNo_Entry, *CoverPrice_Entry, *Location_Entry, *DateEdit, 
    *CurrentPrice_Entry, *PurchasePrice_Entry, *Condition_Optionmenu, *Story_Title_clist;
  GtkWidget *Writer_Combo, *Penciler_Combo, *Inker_Combo, *Writer_clist,
    *Penciler_clist, *Inker_clist;
  GtkWidget *Image_Entry, *Comment_Text;
  GtkWidget *menu, *active_item;
  TComic *ComicToAddTo;
  TIssue *IssueToAdd, *IssueToEdit;
  gchar *TempGCharP;
  GString *TempGString, *GSTemp;
  GList *GLTemp;
  gint i,j;
  GladeXML *temp_xml = user_data;

  add_issue_window = glade_xml_get_widget (temp_xml, "add_issue_window");

  IssueToEdit = gtk_object_get_data (GTK_OBJECT (add_issue_window), IssueToEditKey);
  if (IssueToEdit!=NULL)
    {
      IssueToAdd = IssueToEdit;

      while (IssueToAdd->Title!=NULL)
	{
	  TempGString = IssueToAdd->Title->data;
	  IssueToAdd->Title = g_list_remove (IssueToAdd->Title, TempGString);
	  g_string_free (TempGString, TRUE);
	}
      while (IssueToAdd->Writer!=NULL)
	{
	  TempGString = IssueToAdd->Writer->data;
	  IssueToAdd->Writer = g_list_remove (IssueToAdd->Writer, TempGString);
	  g_string_free (TempGString, TRUE);
	}
      while (IssueToAdd->Penciller!=NULL)
	{
	  TempGString = IssueToAdd->Penciller->data;
	  IssueToAdd->Penciller = g_list_remove (IssueToAdd->Penciller, TempGString);
	  g_string_free (TempGString, TRUE);
	}
      while (IssueToAdd->Inker!=NULL)
	{
	  TempGString = IssueToAdd->Inker->data;
	  IssueToAdd->Inker = g_list_remove (IssueToAdd->Inker, TempGString);
	  g_string_free (TempGString, TRUE);
	}
    }
  else IssueToAdd = Init_Issue ();

  ComicToAddTo = gtk_object_get_data (GTK_OBJECT (add_issue_window), ComicToAddToKey);

  /* BASIC INFO --- START */
  IssueNo_Entry = glade_xml_get_widget (temp_xml, "issue_number_entry");
  CoverPrice_Entry = glade_xml_get_widget (temp_xml, "cover_price_entry");
  CurrentPrice_Entry = glade_xml_get_widget (temp_xml, "current_price_entry");
  PurchasePrice_Entry = glade_xml_get_widget (temp_xml, "purchase_price_entry");
  Location_Entry = glade_xml_get_widget (temp_xml, "location_entry");
  Condition_Optionmenu = glade_xml_get_widget (temp_xml, "condition_optionmenu");
  DateEdit = glade_xml_get_widget (temp_xml, "date_date_edit");
  Story_Title_clist = glade_xml_get_widget (temp_xml, "story_title_clist");

  g_string_assign (IssueToAdd->IssueNo, gtk_entry_get_text (GTK_ENTRY (IssueNo_Entry)));
  g_string_assign (IssueToAdd->Price, gtk_entry_get_text (GTK_ENTRY (CoverPrice_Entry)));
  g_string_assign (IssueToAdd->CurrentPrice, gtk_entry_get_text (GTK_ENTRY (CurrentPrice_Entry)));
  g_string_assign (IssueToAdd->PurchasePrice, gtk_entry_get_text (GTK_ENTRY (PurchasePrice_Entry)));
  g_string_assign (IssueToAdd->Location, gtk_entry_get_text (GTK_ENTRY (Location_Entry)));

  menu = (GTK_OPTION_MENU (Condition_Optionmenu)->menu);
  active_item = gtk_menu_get_active (GTK_MENU (menu));
  IssueToAdd->Condition = g_list_index (GTK_MENU_SHELL (menu)->children, active_item);

  IssueToAdd->Date = gnome_date_edit_get_date (GNOME_DATE_EDIT (DateEdit));

  j = gtk_clist_length (GTK_CLIST (Story_Title_clist));
  for(i=0;i<j;i++)
    {
      gtk_clist_get_text(GTK_CLIST (Story_Title_clist), i, 0, &TempGCharP);
      TempGString = g_string_new(TempGCharP);
      IssueToAdd->Title = g_list_append(IssueToAdd->Title, TempGString);
    }
  /* BASIC INFO --- END */

  /* CREATOR INFO -- START */
  Writer_Combo = glade_xml_get_widget(temp_xml, "writer_combo_entry");
  Penciler_Combo = glade_xml_get_widget(temp_xml, "penciler_combo_entry");
  Inker_Combo = glade_xml_get_widget(temp_xml, "inker_combo_entry");
  Writer_clist = glade_xml_get_widget(temp_xml, "writer_clist");
  Penciler_clist = glade_xml_get_widget(temp_xml, "penciler_clist");
  Inker_clist = glade_xml_get_widget(temp_xml, "inker_clist");

  j = gtk_clist_length(GTK_CLIST (Writer_clist));
  for(i=0;i<j;i++)
    {
      gtk_clist_get_text(GTK_CLIST (Writer_clist), i, 0, &TempGCharP);
      TempGString = g_string_new(TempGCharP);
      IssueToAdd->Writer = g_list_append(IssueToAdd->Writer, TempGString);
    }

  j = gtk_clist_length(GTK_CLIST (Penciler_clist)); 
  for(i=0;i<j;i++)
    {
      gtk_clist_get_text(GTK_CLIST (Penciler_clist), i, 0, &TempGCharP);
      TempGString = g_string_new(TempGCharP);
      IssueToAdd->Penciller = g_list_append(IssueToAdd->Penciller, TempGString);
    }

  j = gtk_clist_length(GTK_CLIST (Inker_clist));
  for(i=0;i<j;i++)
    {
      gtk_clist_get_text(GTK_CLIST (Inker_clist), i, 0, &TempGCharP);
      TempGString = g_string_new(TempGCharP);
      IssueToAdd->Inker = g_list_append(IssueToAdd->Inker, TempGString);
    }
  /* CREATOR INFO -- END */

  /* VARIOUS INFO -- START */
  Image_Entry = glade_xml_get_widget(temp_xml,"Add_Issue_Image_Combo_entry");
  Comment_Text = glade_xml_get_widget(temp_xml, "Add_Issue_Comment_Text"); 
  
  g_string_assign(IssueToAdd->Image, gtk_entry_get_text(GTK_ENTRY (Image_Entry)));
  g_string_assign(IssueToAdd->Comment,
		  gtk_editable_get_chars(GTK_EDITABLE (Comment_Text),
					 0, gtk_text_get_length(GTK_TEXT (Comment_Text))));
  /* VARIOUS INFO -- END */

  GSTemp = g_string_new (IssueToAdd->Location->str);
  location_history = g_list_insert_str_sorted_unique (location_history, GSTemp);
  GLTemp = g_list_copy (IssueToAdd->Writer);
  writer_history = g_list_insert_glist_str_sorted_unique (writer_history, GLTemp);
  GLTemp = g_list_copy (IssueToAdd->Penciller);
  penciler_history = g_list_insert_glist_str_sorted_unique (penciler_history, GLTemp);
  GLTemp = g_list_copy (IssueToAdd->Inker);
  inker_history = g_list_insert_glist_str_sorted_unique (inker_history, GLTemp);

  if (IssueToEdit!=NULL)
    {
      ComicToAddTo->IssueNumbers = g_list_sort(ComicToAddTo->IssueNumbers,
					       CompareTIssue_IssueNo);
    }
  else
    {
      ComicToAddTo->IssueNumbers = g_list_insert_sorted(ComicToAddTo->IssueNumbers, IssueToAdd,
							CompareTIssue_IssueNo);
    }

  file_changed = TRUE;

  refresh_comics_list(add_issue_window);

  /* select the title and issue we're editing */
  /* this must come after the refresh! */
  exp_set_selected_title(add_issue_window, ComicToAddTo);
  if (IssueToEdit != NULL) exp_set_selected_issue(add_issue_window, ComicToAddTo, IssueToEdit);
  else exp_set_selected_issue(add_issue_window, ComicToAddTo, IssueToAdd);

  gtk_widget_destroy(add_issue_window);
}

void on_add_issue_window_cancel_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *add_issue_window;
  GladeXML *temp_xml = user_data;

  add_issue_window = glade_xml_get_widget(temp_xml, "add_issue_window");
  gtk_widget_destroy(add_issue_window);
}

gboolean on_add_issue_window_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  GtkWidget *add_issue_window;
  GladeXML *temp_xml = user_data;

  add_issue_window = glade_xml_get_widget(temp_xml, "add_issue_window");
  gtk_widget_destroy(add_issue_window);

  return FALSE;
}

void on_add_title_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *Title_Entry, *Title_List;
  gchar *list_row[1];
  GladeXML *temp_xml = user_data;

  Title_Entry = glade_xml_get_widget(temp_xml, "story_title_entry");
  Title_List = glade_xml_get_widget(temp_xml, "story_title_clist");

  list_row[0] = gtk_entry_get_text(GTK_ENTRY (Title_Entry));
  
  gtk_clist_append(GTK_CLIST (Title_List), list_row);
}

void on_remove_title_button_clicked (GtkButton *button, gpointer user_data)
{
  GList *SelectedItem;
  GtkCList *Title_List;
  GladeXML *temp_xml = user_data;

  Title_List = GTK_CLIST (glade_xml_get_widget(temp_xml, "story_title_clist"));
  SelectedItem = Title_List->selection;
  
  if (SelectedItem != NULL)
    gtk_clist_remove(Title_List, (gint) SelectedItem->data);
}

void  on_add_writer_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *Writer_Entry, *Writer_List;
  gchar *list_row[1];
  GladeXML *temp_xml = user_data;

  Writer_Entry = glade_xml_get_widget(temp_xml, "writer_entry");
  Writer_List = glade_xml_get_widget(temp_xml, "writer_clist");

  list_row[0] = gtk_entry_get_text(GTK_ENTRY (Writer_Entry));
  
  gtk_clist_append(GTK_CLIST (Writer_List), list_row);
}

void on_remove_writer_button_clicked (GtkButton *button, gpointer user_data)
{
  GList *SelectedItem;
  GtkCList *Writer_List;
  GladeXML *temp_xml = user_data;

  Writer_List = GTK_CLIST (glade_xml_get_widget(temp_xml, "writer_clist"));
  SelectedItem = Writer_List->selection;
  
  if (SelectedItem != NULL)
    gtk_clist_remove(Writer_List, (gint) SelectedItem->data);
}

void on_add_penciler_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *Penciler_Entry, *Penciler_List;
  gchar *list_row[1];
  GladeXML *temp_xml = user_data;

  Penciler_Entry = glade_xml_get_widget(temp_xml, "penciler_entry");
  Penciler_List = glade_xml_get_widget(temp_xml, "penciler_clist");

  list_row[0] = gtk_entry_get_text(GTK_ENTRY (Penciler_Entry));
  
  gtk_clist_append(GTK_CLIST (Penciler_List), list_row);
}

void on_remove_penciler_button_clicked (GtkButton *button, gpointer user_data)
{
  GList *SelectedItem;
  GtkCList *Penciler_List;
  GladeXML *temp_xml = user_data;

  Penciler_List = GTK_CLIST (glade_xml_get_widget(temp_xml, "penciler_clist"));
  SelectedItem = Penciler_List->selection;
  
  if (SelectedItem != NULL)
    gtk_clist_remove(Penciler_List, (gint) SelectedItem->data);
}

void on_add_inker_button_clicked (GtkButton  *button, gpointer user_data)
{
  GtkWidget *Inker_Entry, *Inker_List;
  gchar *list_row[1];
  GladeXML *temp_xml = user_data;

  Inker_Entry = glade_xml_get_widget(temp_xml, "inker_entry");
  Inker_List = glade_xml_get_widget(temp_xml, "inker_clist");

  list_row[0] = gtk_entry_get_text(GTK_ENTRY (Inker_Entry));
  
  gtk_clist_append(GTK_CLIST (Inker_List), list_row);
}

void on_remove_inker_button_clicked (GtkButton *button, gpointer user_data)
{
  GList *SelectedItem;
  GtkCList *Inker_List;
  GladeXML *temp_xml = user_data;

  Inker_List = GTK_CLIST (glade_xml_get_widget(temp_xml, "inker_clist"));
  SelectedItem = Inker_List->selection;
  
  if (SelectedItem != NULL)
    gtk_clist_remove(Inker_List, (gint) SelectedItem->data);
}


void on_add_issue_window_show (GtkWidget *widget, gpointer user_data)
{
  TComic *ComicToAddTo;
  TIssue *IssueToEdit, *LastIssue;
  GtkWidget *add_issue_window;
  GtkWidget *IssueNo_Entry, *CoverPrice_Entry, *Location_Entry, *DateEdit, 
    *CurrentPrice_Entry, *PurchasePrice_Entry, *Condition_Optionmenu, *Story_Title_clist;
  GtkWidget *Writer_Combo, *Penciler_Combo, *Inker_Combo, *Location_Combo, *Writer_clist,
    *Penciler_clist, *Inker_clist;
  GtkWidget *Image_Entry, *Comment_Text;
  gint i,j;
  GString *TempGString;
  gchar *clist_row[1];
  GladeXML *temp_xml = user_data;

  add_issue_window = glade_xml_get_widget(temp_xml, "add_issue_window");

  IssueNo_Entry = glade_xml_get_widget(temp_xml, "issue_number_entry");
  CoverPrice_Entry = glade_xml_get_widget(temp_xml, "cover_price_entry");
  CurrentPrice_Entry = glade_xml_get_widget(temp_xml, "current_price_entry");
  PurchasePrice_Entry = glade_xml_get_widget(temp_xml, "purchase_price_entry");
  Location_Entry = glade_xml_get_widget(temp_xml, "location_entry");
  Condition_Optionmenu = glade_xml_get_widget(temp_xml, "condition_optionmenu");
  DateEdit = glade_xml_get_widget(temp_xml, "date_date_edit");
  Story_Title_clist = glade_xml_get_widget(temp_xml, "story_title_clist");
      
  Writer_Combo = glade_xml_get_widget(temp_xml, "writer_combo_entry");
  Penciler_Combo = glade_xml_get_widget(temp_xml, "penciler_combo_entry");
  Inker_Combo = glade_xml_get_widget(temp_xml, "inker_combo_entry");
  Location_Combo = glade_xml_get_widget(temp_xml, "location_combo_entry");
  Writer_clist = glade_xml_get_widget(temp_xml, "writer_clist");
  Penciler_clist = glade_xml_get_widget(temp_xml, "penciler_clist");
  Inker_clist = glade_xml_get_widget(temp_xml, "inker_clist");
      
  Image_Entry = glade_xml_get_widget(temp_xml,"Add_Issue_Image_Combo_entry");
  Comment_Text = glade_xml_get_widget(temp_xml, "Add_Issue_Comment_Text"); 

  gnome_entry_set_history (GNOME_ENTRY(Location_Combo), location_history);
  gnome_entry_set_history (GNOME_ENTRY(Writer_Combo), writer_history);
  gnome_entry_set_history (GNOME_ENTRY(Penciler_Combo), penciler_history);
  gnome_entry_set_history (GNOME_ENTRY(Inker_Combo), inker_history);

  IssueToEdit = gtk_object_get_data (GTK_OBJECT (add_issue_window), IssueToEditKey);
  if (IssueToEdit!=NULL)
    {
      /* BASIC INFO --- START */
      gtk_entry_set_text(GTK_ENTRY (IssueNo_Entry), IssueToEdit->IssueNo->str);
      gtk_entry_set_text(GTK_ENTRY (CoverPrice_Entry), IssueToEdit->Price->str);
      gtk_entry_set_text(GTK_ENTRY (CurrentPrice_Entry), IssueToEdit->CurrentPrice->str);
      gtk_entry_set_text(GTK_ENTRY (PurchasePrice_Entry), IssueToEdit->PurchasePrice->str);
      gtk_entry_set_text(GTK_ENTRY (Location_Entry), IssueToEdit->Location->str);
      gtk_option_menu_set_history (GTK_OPTION_MENU (Condition_Optionmenu), IssueToEdit->Condition);
      gnome_date_edit_set_time(GNOME_DATE_EDIT (DateEdit), IssueToEdit->Date);
      
      j = g_list_length(IssueToEdit->Title);
      for(i=0;i<j;i++)
	{
	  TempGString = g_list_nth(IssueToEdit->Title, i)->data;
	  clist_row[0] = TempGString->str;
	  gtk_clist_append(GTK_CLIST (Story_Title_clist), clist_row);
	}
      /* BASIC INFO --- END */

      /* CREATOR INFO -- START */
      j = g_list_length(IssueToEdit->Writer);
      for(i=0;i<j;i++)
	{
	  TempGString = g_list_nth(IssueToEdit->Writer, i)->data;
	  clist_row[0] = TempGString->str;
	  gtk_clist_append(GTK_CLIST (Writer_clist), clist_row);
	}
      
      j = g_list_length(IssueToEdit->Penciller);
      for(i=0;i<j;i++)
	{
	  TempGString = g_list_nth(IssueToEdit->Penciller, i)->data;
	  clist_row[0] = TempGString->str;
	  gtk_clist_append(GTK_CLIST (Penciler_clist), clist_row);
	}
      
      j = g_list_length(IssueToEdit->Inker);
      for(i=0;i<j;i++)
	{
	  TempGString = g_list_nth(IssueToEdit->Inker, i)->data;
	  clist_row[0] = TempGString->str;
	  gtk_clist_append(GTK_CLIST (Inker_clist), clist_row);
	}
      /* CREATOR INFO -- END */
      
      /* VARIOUS INFO -- START */
      gtk_entry_set_text(GTK_ENTRY (Image_Entry), IssueToEdit->Image->str);
      gtk_entry_set_text(GTK_ENTRY (CoverPrice_Entry), IssueToEdit->Price->str);
      gtk_text_insert(GTK_TEXT (Comment_Text), NULL, NULL, NULL, IssueToEdit->Comment->str, -1);
      /* VARIOUS INFO -- END */
    }
  else
    {
      if (auto_fill_issue)
	{
	  ComicToAddTo = gtk_object_get_data (GTK_OBJECT (add_issue_window), ComicToAddToKey);

	  if (ComicToAddTo->IssueNumbers != NULL)
	    {
	      j = g_list_length (ComicToAddTo->IssueNumbers);
	      LastIssue = g_list_nth_data (ComicToAddTo->IssueNumbers, j-1);
	      
	      /* fill relevant widgets with entries from last item in ComicToAddTo->IssueNumbers */
	      /* of course with issueno+1 */
	      
	      j = atoi (LastIssue->IssueNo->str); /* FIXME - this will fail on special "numbers" such as 1A, , etc. */
	      gtk_entry_set_text(GTK_ENTRY (IssueNo_Entry), itoa (j+1));
	      gtk_entry_set_text(GTK_ENTRY (CoverPrice_Entry), LastIssue->Price->str);
	      gtk_entry_set_text(GTK_ENTRY (Location_Entry), LastIssue->Location->str);
	      
	      /* CREATOR INFO -- START */
	      j = g_list_length(LastIssue->Writer);
	      for(i=0;i<j;i++)
		{
		  TempGString = g_list_nth(LastIssue->Writer, i)->data;
		  clist_row[0] = TempGString->str;
		  gtk_clist_append(GTK_CLIST (Writer_clist), clist_row);
		}
	      
	      j = g_list_length(LastIssue->Penciller);
	      for(i=0;i<j;i++)
		{
		  TempGString = g_list_nth(LastIssue->Penciller, i)->data;
		  clist_row[0] = TempGString->str;
		  gtk_clist_append(GTK_CLIST (Penciler_clist), clist_row);
		}
	      
	      j = g_list_length(LastIssue->Inker);
	      for(i=0;i<j;i++)
		{
		  TempGString = g_list_nth(LastIssue->Inker, i)->data;
		  clist_row[0] = TempGString->str;
		  gtk_clist_append(GTK_CLIST (Inker_clist), clist_row);
		}
	      /* CREATOR INFO -- END */
	    }
	}
    }
}
/* callback functions - END */

/* exported functions - START */
void new_issue_activate(GtkWidget *generic)
{
  GList *SelectedTitle;

  SelectedTitle = get_selected_title(generic);

  if (SelectedTitle != NULL) 
    { 
      create_new_issue_window(generic, SelectedTitle, "Add Issue", TRUE);
    }
}

void edit_issue_activate(GtkWidget *generic)
{
  GList *SelectedIssueItem, *TempIssueGList;
  GtkWidget *add_issue_window;
  TIssue *IssueToEdit;
  GList *SelectedComicItem;
  GtkCList *issues_clist; 

  SelectedIssueItem = get_selected_issue(generic);
  SelectedComicItem = get_selected_title(generic);
  issues_clist = GTK_CLIST (glade_xml_get_widget (xml, "issues_clist"));
  
  if ((SelectedIssueItem != NULL) && (SelectedComicItem != NULL))
    {
      TempIssueGList = gtk_clist_get_row_data (issues_clist,  (gint) SelectedIssueItem->data);
      IssueToEdit = TempIssueGList->data;

      add_issue_window = create_new_issue_window(generic, SelectedComicItem, "Edit Issue", FALSE);

      gtk_object_set_data (GTK_OBJECT (add_issue_window), IssueToEditKey, IssueToEdit);
      gtk_widget_show (add_issue_window);
    }      
}
/* exported functions - END */
