/* 
 * GChemPaint GOffice component
 * gofficewin.cc
 *
 * Copyright (C) 2006 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include "gchempaint-priv.h"
#include "gofficeapp.h"
#include "gofficewin.h"
#include <lib/document.h>
#include <glib/gi18n-lib.h>

gcpGOfficeWindow::gcpGOfficeWindow (gcpGOfficeApplication *App, GOGChemPaintComponent *gogcp):
	gcpWindow (App)
{
	m_gogcp = gogcp;
	gogcp->window = this;
	/* We must first duplicate the document */
	xmlDocPtr xml = NULL; // makes g++ happy
	try {
		if (gogcp->document && gogcp->document->HasChildren ()) {
			xml = gogcp->document->BuildXMLTree ();
			m_Doc->Load (xml->children);
			xmlFreeDoc (xml);
			xml = NULL;
		}
		SetTitle (m_Doc->GetTitle ());
		gtk_window_present (GetWindow ());
	}
	catch (int i) {
		if (xml)
			xmlFreeDoc (xml);
		xml = NULL;
		throw 1;
	}
}

gcpGOfficeWindow::~gcpGOfficeWindow ()
{
	if (!m_gogcp->document)
		go_component_emit_changed (GO_COMPONENT (m_gogcp));
	m_gogcp->window = NULL;
}

void gcpGOfficeWindow::OnSave ()
{
	delete m_gogcp->document;
	m_gogcp->document = new gcpDocument (GetApplication (), false);
	m_gogcp->document->GetView ()->CreateNewWidget ();
	xmlDocPtr xml = NULL; // makes g++ happy
	try {
		xml = m_Doc->BuildXMLTree ();
		m_gogcp->document->Load (xml->children);
		xmlFreeDoc (xml);
		xml = NULL;
		go_component_emit_changed (GO_COMPONENT (m_gogcp));
	}
	catch (int i) {
		if (xml)
			xmlFreeDoc (xml);
		xml = NULL;
		throw 1;
	}
}

char const *gcpGOfficeWindow::GetDefaultTitle ()
{
	return _("Embedded GChemPaint Object");
}
