------------------------------------------------------------------------------
--                                                                          --
--                            GCH COMPONENTS                                --
--                                                                          --
--                                G C H                                     --
--                                                                          --
--                               S p e c                                    --
--                                                                          --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------

--  The top of the Gch hierarchy
--
--  Gch is an ASIS-based tool built on top of ASIS-for-GNAT.
--
--  Gch is a tool which checks an Ada source file against a given set of
--  rules. As a default set of rules to detect, it has the (subset of the)
--  code style rules of Ada 95 Quaity and Style Guide. If a Gch user is also
--  an ASIS-for-GNAT user, he or she may adjust or replace a set of rules to
--  be checked by Gch by modifying its source and rebuilding the executable
--  for Gch.

with Ada.Unchecked_Deallocation;
with GNAT.OS_Lib;  use GNAT.OS_Lib;
package Gch is

   procedure Free is new Ada.Unchecked_Deallocation
                       (String, String_Access);

end Gch;