------------------------------------------------------------------------------
--                                                                          --
--                            GCH COMPONENTS                                --
--                                                                          --
--                          G C H . O U T P U T                             --
--                                                                          --
--                              S p e c                                     --
--                                                                          --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------
--  This package defines subprograms providing various forms of output needed
--  by Gch

with Ada.Wide_Text_IO;        use Ada.Wide_Text_IO;
with Ada.Characters.Handling; use Ada.Characters.Handling;

with Asis;                    use Asis;
with Asis.Text;               use Asis.Text;
with Asis.Implementation;     use Asis.Implementation;
with Asis.Elements;           use Asis.Elements;

package Gch.Output is

   procedure Brief_Help;
   --  Prints brief help information to stdout.

   procedure Put_Gch_Version;
   --  outputs the Gch version information

   procedure Report_Element  (El : Asis.Element);

   procedure Report_Non_ASIS_Failure (El : Element; Ex_Name : String);
   --  Should be called when non-ASIS exception is caught by
   --  Gch.Check_Rules (it would be too heavy to call it in each
   --  rule checking procedure for each rule). Reports the name of the
   --  exception which was caught (passed as Ex_Name) and the debug image
   --  of the Element for which it happened.

   procedure Output_Statistics;
   --  output statistics for a unit just analysed;

   procedure Output_Global_Statistics;
   --  outputs global statistics

   procedure Output_Diagnostics (Checking_File_Name : String);
   --  outputs Gch Diagnostics using Gch.Rules.Rules

end Gch.Output;