------------------------------------------------------------------------------
--                                                                          --
--                            GCH COMPONENTS                                --
--                                                                          --
--                         G C H . G L O B A L S                            --
--                                                                          --
--                              S p e c                                     --
--                                                                          --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------

--  This package contains the definition of global objects and flags for
--  Gch. This package contains also data structures, objects and procedures
--  to collect the rule violation results.
--
--  We would keep it as a separate package, because error statistic
--  collection and analysis may become
--  non-trivial during the Gch evolution.

with Asis; use Asis;
with Asis.Text; use Asis.Text;

package Gch.Globals is

   Gch_Version : String := "07";
   --  the gch version number

   type Check_State is (Not_Used);
   --  a place-holder type, needed for Traverse_Element instantiation

   Initialized : Boolean := False;
   --  Is set to TRUE if ASIS Checker has been called with the correct set of
   --  parameters

   ASIS_Initialized : Boolean := False;
   --  Is set to TRUE if the ASIS Context to process has been successfully
   --  associated and opened based and a set of Compilation Units to process
   --  has been successfully obtained (if needed)

   Checking_Context : Context;
   --  is set during declaration of checking context in gch-driver

   Check_Constuct_State    : Check_State := Not_Used;
   Check_Construct_Control : Traverse_Control := Continue;
   --  we define these traverse variables as globals, because we would like
   --  to have the same traverse state and control for traversing all the
   --  unit, that is, both context clause elements and a unit declaration

   --  The following counters are used to collect and to compute statistics.
   --  global statistic counters:
   Total_Units       : Natural := 0;
   Checked_Units     : Natural := 0;
   Passed_Units      : Natural := 0;
   Not_Passed_Units  : Natural := 0;
   Rejected_Units    : Natural := 0;
   Total_Errors      : Natural := 0;
   Total_Warnings    : Natural := 0;
   Total_Failures    : Natural := 0;

   --  per unit counters, are updated by error/warning output procedures:
   Errors_Per_Unit   : Natural := 0;
   Warnings_Per_Unit : Natural := 0;
   Failures_Per_Unit : Natural := 0;
   --  the last counter is for the ASIS (and, may be, also non-ASIS failures
   --  which were occured as exception raisings during checking a given
   --  unit and which were caught and reported in rule checking procedures

   procedure Reset_Unit_Statistics;
   --  resers unit statistics counters to zero when starting to process a new
   --  unit

   procedure Update_Global_Statistics;
   --  update global statistic counters in the very end of a unit processing

end Gch.Globals;