package GCExport::GCExportHTML;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCExport::GCExportBase;

{
    package GCExport::GCExporterHTML;


    use File::Copy;
    use File::Basename;
    use base qw(GCExport::GCExportBaseClass);

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        
        $self->{previousLetter} = ' ';	
	
        bless ($self, $class);
        return $self;
    }

    sub getName
    {
        my $self = shift;
        
        return "HTML";
    }
    
    sub getSuffix
    {
        my $self = shift;
        
        return ".html";
    }
    
    sub needsUTF8
    {
        my $self = shift;
    
        return 1;
    }
    
    sub getOptions
    {
        my $self = shift;
	
        $self->{modelsDir} = $ENV{GCF_SHARE_DIR}.'/html_models';
        $self->{modelsDir} = '"'.$self->{modelsDir}.'"' if ($^O =~ /win32/i) && ($self->{modelsDir} =~ / /);

        $self->{modelsFiles} = '';

        my @tmp_filenames;

        foreach (glob $self->{modelsDir}.'/*')
        {
            next if ($_ =~ /\/CVS$/) || ($_ =~ /\.png$/);
            (my $mod = basename($_)) =~ s/_/ /g;
            $self->{modelsFiles} .= $mod.',';
        }
        
        return [
        {
            name => 'withJs',
            type => 'checkBox',
            label => 'ExportHTMLWithJS',
            default => '1'
        },

        {
            name => 'fileExport',
            type => 'list',
            label => 'ExportHTMLFileTemplate',
            default => 'Tian',
            valuesList => $self->{modelsFiles},
            buttonLabel => 'ExportHTMLPreview',
            buttonCallback => sub {shift; $self->preview(@_)}
        },
                      
        {
            name => 'title',
            type => 'shortText',
            label => 'ExportHTMLTitle',
            default => 'Movies list',
        },
	    
    	{
            name => 'height_img',
            type => 'number',
            label => 'ExportHTMLHeightimg',
            default => 160,
            min => 100,
            max => 250,
        },   
                        
        {
            name => 'open',
            type => 'checkBox',
            label => 'ExportHTMLOpenFileInBrowser',
            default => '0'
        },

        ]
    }
    
    sub preview
    {
        my ($self, $data) = @_;
        my ($parent, $list) = @{$data};
        (my $template = $list->child->get_label) =~ s/ /_/g;
        my $dialog = new Gtk2::Dialog($parent->{lang}->{ExportHTMLPreview}.' - '.$list->child->get_label,
                                      $parent,
                                      [qw/modal destroy-with-parent/],
                                      'gtk-ok' => 'ok',
                                     );
                                             
        my $picFile = $self->{modelsDir}.'/'.$template.'.png';
        if (-f $picFile)
        {
            my $image = Gtk2::Image->new_from_file($picFile);
            $image->set_padding(10,10);
            $dialog->vbox->pack_start($image,0,0,0);
        }
        else
        {
            my $label = new Gtk2::Label;
            $label->set_markup('<b>'.$parent->{lang}->{ExportHTMLNoPreview}.'</b>');
            $dialog->vbox->pack_start($label,1,1,0);
            $dialog->set_default_size(300,300);
        }
        $dialog->vbox->show_all;
        $dialog->run;
        $dialog->destroy;
    }
    
    sub wantsFieldsSelection
    {
        return 0;
    }
    
    sub wantsImagesSelection
    {
        return 1;
    }
    
    sub preProcess
    {
        my $self =  shift;
	
        $self->{options}->{fileExport} =~ s/ /_/;
	
        my $model;
        my $file = $self->{modelsDir}.'/'.$self->{options}->{fileExport};
        $file =~ s/"//g;
        #"

        open FILE, $file;
        $model = do { local $/; <FILE> };
        close FILE;

        if ($self->{options}->{withJs})
        {
            $model =~ s/(\[JS_START\])|(\[JS_END\])//gms;
            $model =~ s/\[NOJS_START\].*?\[NOJS_END\]//gms;
        }
        else
        {
            $model =~ s/\[JS_START\].*?\[JS_END\]//gms;
            $model =~ s/(\[NOJS_START\])|(\[NOJS_END\])//gms;
        }

        $model =~ m{
            \[HEADER\]\n?(.*?)\n?\[\/HEADER\].*?
            \[ITEM\]\n?(.*?)\n?\[\/ITEM\].*?
            \[FOOTER\]\n?(.*?)\n?\[\/FOOTER\].*?
            \[POST\]\n?(.*?)\n?\[\/POST\]
        }xms;
        $self->{header} = $1;
        $self->{item} = $2;
        $self->{footer} = $3;
        $self->{post} = $4;
	}

    sub getHeader
    {
        my ($self, $total) = @_;
	
        my $result = $self->{header};

        $self->{total} = $total;
        $result =~ s/\$\$PAGETITLE\$\$/$self->{options}->{title}/g;
        $result =~ s/\$\$TOTALNUMBER\$\$/$total/g;

        #Search form
        $result =~ s/\$\$FORM_INPUT\$\$/$self->{options}->{lang}->{ExportHTMLInputTitle}/g;
        $result =~ s/\$\$FORM_SEARCH1\$\$/$self->{options}->{lang}->{ExportHTMLSearchType1}/g;
        $result =~ s/\$\$FORM_SEARCH2\$\$/$self->{options}->{lang}->{ExportHTMLSearchType2}/g;
        $result =~ s/\$\$FORM_SEARCHBUTTON\$\$/$self->{options}->{lang}->{ExportHTMLSearchButton}/g;
        $result =~ s/\$\$FORM_SEARCHTITLE\$\$/$self->{options}->{lang}->{ExportHTMLSearchTitle}/g;
        $result =~ s/\$\$FORM_ALLBUTTON\$\$/$self->{options}->{lang}->{ExportHTMLAllButton}/g;
        $result =~ s/\$\$FORM_ALLTITLE\$\$/$self->{options}->{lang}->{ExportHTMLAllTitle}/g;
        $result =~ s/\$\$FORM_EXPAND\$\$/$self->{options}->{lang}->{ExportHTMLExpand}/g;
        $result =~ s/\$\$FORM_EXPANDTITLE\$\$/$self->{options}->{lang}->{ExportHTMLExpandTitle}/g;
        $result =~ s/\$\$FORM_COLLAPSE\$\$/$self->{options}->{lang}->{ExportHTMLCollapse}/g;
        $result =~ s/\$\$FORM_COLLAPSETITLE\$\$/$self->{options}->{lang}->{ExportHTMLCollapseTitle}/g;

        #Labels
        $result =~ s/\$\$([A-Z_]*)_LABEL\$\$/$self->{options}->{lang}->{Displayed}->{lc $1}/eg;

        return $result."\n";
    }

    sub getFooter
    {
        my ($self, $movie) = @_;
 
        my $total = $self->{total};
        my $result = $self->{footer};
        $result =~ s/\$\$PAGETITLE\$\$/$self->{options}->{title}/g;
        $result =~ s/\$\$TOTALNUMBER\$\$/$total/g;
        $result =~ s/\$\$GENERATOR_NOTE\$\$/$self->{options}->{lang}->{ExportHTMLNote}/g;
        $result =~ s/\$\$BORROWED_MOVIES\$\$/$self->{options}->{lang}->{BorrowedTitle}/g;

        return $result."\n";
    }

    sub getItem
    {
        my ($self, $movie, $idx) = @_;

        my $total = $self->{total};
        my $result = $self->{item};

        #Separator
        $result =~ s/\$\$SEPARATOR\$\$/$self->{options}->{lang}->{Separator}/g;

        #Labels that need a special process
        $result =~ s/\$\$LENDDATE_LABEL\$\$/$self->{options}->{lang}->{Displayed}->{lendDate}/g;
        $result =~ s/\$\$URL_LABEL\$\$/$self->{options}->{lang}->{PanelWeb}/g;

        #Other labels
        $result =~ s/\$\$([A-Z_]*)_LABEL\$\$/$self->{options}->{lang}->{Displayed}->{lc $1}/eg;

        #Fields that need a special process
        $result =~ s/\$\$LENDDATE\$\$/$movie->{lendDate}/g;
        $result =~ s/\$\$HEIGHT_PIC\$\$/$self->{options}->{height_img}/g;

        #Free text
        (my $synopsis = $movie->{synopsis}) =~ s/[\r\n]/<br \/>/g;
        $synopsis =~ s/<br>/<br \/>/g;
        $result =~ s/\$\$SYNOPSIS\$\$/$synopsis/g;
        (my $comment = $movie->{comment}) =~ s/[\r\n]/<br \/>/g;
        $comment =~ s/<br>/<br \/>/g;
        $result =~ s/\$\$COMMENT\$\$/$comment/g;

        #Borrower
        my $tmpBorrower = $movie->{borrower};
        my $borrowerFlag = 1;
        my $borrowerYesNo = $self->{options}->{lang}->{ExportHTMLBorrowed};
        my $borrowerOrEmpty = $tmpBorrower;
        if (!$tmpBorrower || ($tmpBorrower eq 'none'))
        {
            $tmpBorrower = $self->{options}->{lang}->{PanelNobody};
            $borrowerFlag = 0;
            $borrowerYesNo = $self->{options}->{lang}->{ExportHTMLNotBorrowed};
            $borrowerOrEmpty = '';
        }
        $result =~ s/\$\$BORROWER\$\$/$tmpBorrower/g;
        $result =~ s/\$\$BORROWER_OREMPTY\$\$/$borrowerOrEmpty/g;
        $result =~ s/\$\$BORROWER_FLAG\$\$/$borrowerFlag/g;
        $result =~ s/\$\$BORROWER_YESNO\$\$/$borrowerYesNo/g;
        $result =~ s/\$\$IDX\$\$/$idx/g;
        $result =~ s/\$\$TOP\$\$/$self->{options}->{lang}->{ExportHTMLTop}/g;
        $result =~ s/\$\$TOTALNUMBER\$\$/$total/g;

        #Other fields
        $result =~ s/\$\$([A-Z_]*)\$\$/$movie->{lc $1}/eg;

        return $result."\n";
    }

    sub postProcess
    {
        my ($self, $headerRef, $bodyRef) = @_;

        #Variables to be used in POST section
        my $header = $$headerRef;
        my $body = $$bodyRef;
        my @movies = @{$self->{options}->{movies}};
        
        eval $self->{post};
        print "Errors with HTML template in POST:\n  $@\n" if $@;

        $$headerRef = $header;
        $$bodyRef = $body;
    }

    sub getEndInfo
    {
        my $self = shift;
        
        my $message = '';
        
        if ($self->{options}->{open})
        {
            $self->{options}->{parent}->openUrl($self->{fileName});
        }
        else
        {
            $message = $self->{options}->{lang}->{ExportHTMLInfoFile}.$self->{fileName};
            $message .= '

'.$self->{options}->{lang}->{ExportHTMLInfoDir}.$self->{dirName}
                if $self->{options}->{withPictures};
        }
            
        return $message;
    }
}

1;
