package GCGraphicComponents;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################
use utf8;
use Gtk2;
use GCBorrowings;

use strict;

{
    package GCImageBox;
    
    use base "Gtk2::VBox";
    
    sub new_from_file
    {
        my ($proto, $imageFile, $label) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();

        bless ($self, $class);

        my $image = Gtk2::Image->new_from_file($imageFile);
        $self->init($image, $label);
        
        return $self;
    }
    sub new_from_stock
    {
        my ($proto, $stockId, $label) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();

        bless ($self, $class);

        my $image = Gtk2::Image->new_from_stock($stockId, 'large-toolbar');
        $self->init($image, $label);
         
        return $self;        
    }
    
    sub init
    {
        my ($self, $image, $label) = @_;
        
        $self->{label} = new Gtk2::Label($label);
        
        $self->pack_start($image, 0, 0, 0);
        $self->pack_start($self->{label}, 0, 0, 0);
        
        $self->show_all;
    }
}

{
    package GCAgeChooser;
    use base "Gtk2::OptionMenu";
    
    sub getValue
    {
        my $self = shift;

        my $result = -1;
        my $strValue = $self->child->get_label;

        $result = 0 if $strValue eq '';
        $result = 1 if $strValue eq $self->{unknownLabel};
        $result = 2 if $strValue eq $self->{noneLabel};
        $result = 5 if $strValue eq $self->{parentLabel};
        $result = $strValue if $result == -1;

        return $result;
    }

    sub setValue
    {
        my ($self, $value) = @_;

        $value = 0 if !$value;

        $self->{mainMenu}->set_active($value) if $value < 2;
        $self->{mainMenu}->set_active(2) if ($value > 1) && ($value < 5);
        $self->{mainMenu}->set_active(3) if ($value > 4) && ($value < 10);
        if ($value > 9)
        {
            my $idx = $value - 5;
            $self->{mainMenu}->set_active($idx);
        }
        $self->remove_menu;
        $self->set_menu($self->{mainMenu});
    }

    sub setEditable
    {
        my ($self, $editable) = @_;
        
        GCUtils::sensitive($self,$editable);
    }
    
    sub new
    {
        my ($proto, $lang, $type, $width) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new;

        $self->{lang} = $lang;
        
        if ($type eq 'public')
        {
            $self->{unknownLabel} = '';
            $self->{noneLabel} = $lang->{MenuAgeNone};
            $self->{parentLabel} = $lang->{PanelAgeParent};
        }
        else
        {
            $self->{unknownLabel} = $lang->{PanelAgeUnknown};
            $self->{noneLabel} = $lang->{PanelAgeNone};
            $self->{parentLabel} = $lang->{PanelAgeParent};
        }

        bless ($self, $class);

		$self->{mainMenu} = new Gtk2::Menu();
		my $emptyItem = Gtk2::MenuItem->new_with_label('');
        $self->{mainMenu}->append($emptyItem);
        my $unknownItem = Gtk2::MenuItem->new_with_label($self->{unknownLabel});
        $self->{mainMenu}->append($unknownItem) if $self->{unknownLabel};
        $self->{mainMenu}->append(Gtk2::SeparatorMenuItem->new) if ! $self->{unknownLabel};
        my $noneItem = Gtk2::MenuItem->new_with_label($self->{noneLabel});
        $self->{mainMenu}->append($noneItem);
        my $parentItem = Gtk2::MenuItem->new_with_label($self->{parentLabel});
        $self->{mainMenu}->append($parentItem);
        
        $self->{mainMenu}->append(Gtk2::SeparatorMenuItem->new);
        
		foreach (10..21)
		{
		    my $item = Gtk2::MenuItem->new_with_label($_);
		    $self->{mainMenu}->append($item);
		}

        $self->set_menu($self->{mainMenu});
        #$self->{viewOption}->set_alignment(0.0,0.0);

        
        return $self;
    }
}

{
    package GCAgeChooserSlider;
    use base "Gtk2::HBox";
    
    sub getValue
    {
        my $self = shift;
        return int $self->{ageSlider}->get_value;
    }

    sub setValue
    {
        my ($self, $value) = @_;

        $value = 0 if !$value;
        $self->{ageSlider}->set_value($value);
        $self->setAgeLabel;
    }

    sub setAgeLabel
    {
        my $self = shift;
        my $value = int $self->{ageSlider}->get_value;
        if ($value < 2)
        {
            $value = $self->{unknownLabel};
        }
        elsif ($value < 5)
        {
            $value = $self->{noneLabel};
        }
        elsif ($value < 8)
        {
            $value = $self->{parentLabel};
        }
        $self->{ageValue}->set_label($value);
    }
    
    sub setEditable
    {
        my ($self, $editable) = @_;
        
        GCUtils::sensitive($self->{ageValue},$editable);
        GCUtils::sensitive($self->{ageSlider},$editable);
    }
    
    sub new
    {
        my ($proto, $lang, $type, $width) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new(0,0);

        $self->{lang} = $lang;
        
        if ($type eq 'public')
        {
            $self->{unknownLabel} = $lang->{SearchUndef};
            $self->{noneLabel} = $lang->{MenuAgeNone};
            $self->{parentLabel} = $lang->{PanelAgeParent};
        }
        else
        {
            $self->{unknownLabel} = $lang->{PanelAgeUnknown};
            $self->{noneLabel} = $lang->{PanelAgeNone};
            $self->{parentLabel} = $lang->{PanelAgeParent};
        }

        bless ($self, $class);

        $self->{ageValue} = Gtk2::Label->new;
        $self->{ageValue}->set_size_request(100, 1); 
        $self->pack_start($self->{ageValue},0,0,5);
        my $adj = Gtk2::Adjustment->new(0.0, 0.0, 26.0, 1.0, 5.0, 1.0);
        $self->{ageSlider} = Gtk2::HScale->new($adj);
        $self->{ageSlider}->signal_connect('value_changed' => sub {
            $self->setAgeLabel;
        });
        $self->{ageSlider}->set_size_request($width, 1); 
        $self->{ageSlider}->set_draw_value(0);
        $self->pack_start($self->{ageSlider},0,0,0);
        
        return $self;
    }
}

{
    package GCMoviePanel;
    use File::Basename;
    use base "Gtk2::Frame";

    sub new
    {
        my ($proto, $parent, $options, $readonly, $show) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();

        bless ($self, $class);

        $self->{parent} = $parent;
        $self->{options} = $options;

        $self->set_shadow_type('none');

        $self->{defaultImage} = $parent->{defaultImage};

        $self->{tooltips} = $parent->{tooltips};

        $self->{vboxMain} = new Gtk2::VBox(0, 0);

        my $hboxTitle = new Gtk2::HBox(0,0);
        $self->{id} = Gtk2::Entry->new;
        $self->{id}->set_width_chars(5);
        $self->{title} = Gtk2::Entry->new; 
        $self->{title}->signal_connect('activate', \&searchMovie, $self) if ! $readonly;
        $self->{searchButton} = Gtk2::Button->new_from_stock('gtk-jump-to');
        #$self->{searchButton} = Gtk2::Button->new($parent->{lang}->{PanelSearchButton});
        $self->{searchButton}->signal_connect('clicked', \&searchMovie, $self);
        $self->{tooltips}->set_tip($self->{searchButton}, $parent->{lang}->{PanelSearchTip}, '');
        $hboxTitle->pack_start($self->{id}, 0, 0, 2);
        $hboxTitle->pack_start($self->{title}, 1, 1, 2);
        $hboxTitle->pack_start($self->{searchButton}, 0, 0, 0) if ! $readonly;

        my $framePerso = new Gtk2::Frame();
        $framePerso->set_border_width(2);
        $framePerso->set_label_align(1.0, 0.0);
        my $vboxPerso = new Gtk2::VBox(0,0);
        $vboxPerso->set_border_width(2);

        my $hboxSeenRating = new Gtk2::HBox(0,10);
        $hboxSeenRating->set_border_width(0);
        $self->{seen} = Gtk2::CheckButton->new($parent->{lang}->{PanelSeen});
        $self->{vsepSeenRating} = new Gtk2::VSeparator;
        $self->{ratingLabel} = new Gtk2::Label($parent->{lang}->{PanelRating});
        my $adj1 = Gtk2::Adjustment->new(5, 0, 10, 1, 1, 0) ;
        $self->{rating} = Gtk2::SpinButton->new($adj1, 0, 0);
        $self->{rating}->set_numeric(1);
        $hboxSeenRating->pack_start($self->{seen}, 0, 0, 2);
        $hboxSeenRating->pack_start($self->{vsepSeenRating}, 0, 0, 2);
        $hboxSeenRating->pack_start($self->{ratingLabel}, 0, 0, 0);
        $hboxSeenRating->pack_start($self->{rating}, 0, 0, 0);        

        my $hboxFormat = new Gtk2::HBox(0,0);
        $hboxFormat->set_border_width(0);
        $self->{formatLabel} = new Gtk2::Label($parent->{lang}->{PanelMedia});
		$self->{formatOption} = new Gtk2::OptionMenu();
		$self->{format} = new Gtk2::Menu();
		#my @formats = ('DVD9', 'DVD5', 'DVDR', 'CD', 'S-VCD', 'VHS');
        $options->formats('DVD,DVDR,CD,S-VCD,VHS') if (! $options->exists('formats'));
        my @formats = split m/,/, $options->formats;
		my $format;
		foreach $format(@formats)
		{
		    my $item = Gtk2::MenuItem->new_with_mnemonic($format);
		    $self->{format}->append( $item) ;
		}
		$self->{formats} = \@formats;
		$self->{formatOption}->set_menu($self->{format}) ;

        $self->{numberLabel} = new Gtk2::Label($parent->{lang}->{PanelNumber});
        my  $adj2 = Gtk2::Adjustment->new(1, 1, 100, 1, 1, 0) ;
        $self->{number} = Gtk2::SpinButton->new($adj2, 0, 0);
        $self->{number}->set_numeric(1);
        $self->{placeLabel} = new Gtk2::Label($parent->{lang}->{PanelPlace});
        $self->{place} = Gtk2::Combo->new;
		my @childrenPlace = $self->{place}->get_children;
		$childrenPlace[0]->set_width_chars(15);
	    $hboxFormat->pack_start($self->{formatLabel}, 0, 0, 0);
        $hboxFormat->pack_start($self->{formatOption}, 0, 0, 2);
        $hboxFormat->pack_start($self->{numberLabel}, 0, 0, 2);
        $hboxFormat->pack_start($self->{number}, 0, 0, 2);
        $hboxFormat->pack_start(Gtk2::VSeparator->new, 0, 0, 10);
        $hboxFormat->pack_start($self->{placeLabel}, 0, 0, 2);
        $hboxFormat->pack_start($self->{place}, 0, 0, 2);        

        $self->{frameLang} = new Gtk2::Frame;
        $self->{expanderLang} = new Gtk2::Expander($parent->{lang}->{PanelLanguages});
        $self->{expanderLang}->set_expanded(1);
        $self->{frameLang}->set_border_width(0);
        $self->{frameLang}->set_shadow_type('etched-in');
        $self->{expanderLang}->add($self->{frameLang});
        #$frameLang->set_label_align(1.0, 0.0);

        #$self->{hboxAudio} = new Gtk2::HBox(0,0);
        
        my $hboxAudioSub = new Gtk2::HBox(0,0);
        
        $self->{vboxAudio} = new Gtk2::VBox(0,0);
        $self->{audioList} = new Gtk2::SimpleList($parent->{lang}->{PanelAudio}=>'text',
                                                  $parent->{lang}->{PanelEncoding}=>'text');
        for my $i(0..1)
        {
            $self->{audioList}->get_column($i)->set_resizable(1);
        }
        $self->{audioList}->set_column_editable(1, 1);
        #push @{$self->{audioList}->{data}}, ['test1', 'test2'];
        my $scrollAudio = new Gtk2::ScrolledWindow;
        $scrollAudio->set_policy ('automatic', 'automatic');
        $scrollAudio->set_shadow_type('etched-in');
        $scrollAudio->set_size_request(-1, 120);
        $scrollAudio->add($self->{audioList});
        $self->{vboxAudio}->pack_start($scrollAudio, 1, 1, 2);

        $self->{audioChoices} = Gtk2::Combo->new;
		($self->{audioChoices}->get_children)[0]->set_width_chars(10);
        $self->{encodingChoices} = Gtk2::Combo->new;
		($self->{encodingChoices}->get_children)[0]->set_width_chars(10);
        my $audioAddButton = Gtk2::Button->new_from_stock('gtk-add');
        my $tmpWidget = $audioAddButton;
        $tmpWidget = $tmpWidget->child while ! $tmpWidget->isa('Gtk2::HBox');
        ($tmpWidget->get_children)[1]->destroy;        
        $audioAddButton->signal_connect('clicked' => sub {
            my $audio = ($self->{audioChoices}->get_children)[0]->get_text;
            my $encoding = ($self->{encodingChoices}->get_children)[0]->get_text;
            push @{$self->{audioList}->{data}}, [$audio, $encoding];
        });
        my $audioRemoveButton = Gtk2::Button->new_from_stock('gtk-remove');
        $tmpWidget = $audioRemoveButton;;
        $tmpWidget = $tmpWidget->child while ! $tmpWidget->isa('Gtk2::HBox');
        ($tmpWidget->get_children)[1]->destroy;
        $audioRemoveButton->signal_connect('clicked' => sub {
            my @idx = $self->{audioList}->get_selected_indices;
            my $selected = $idx[0];
            splice @{$self->{audioList}->{data}}, $selected, 1;
            $selected-- if ($selected >= scalar(@{$self->{audioList}->{data}}));
            $selected = 0 if $selected < 0 ;
            $self->{audioList}->select($selected);
        });
		my $hboxAudio = new Gtk2::HBox(0,0);
		$hboxAudio->pack_start($self->{audioChoices}, 0, 0, 2);
		$hboxAudio->pack_start($self->{encodingChoices}, 0, 0, 2);
		$hboxAudio->pack_start($audioAddButton, 0, 0, 2);
		$hboxAudio->pack_start($audioRemoveButton, 0, 0, 2);
		$self->{vboxAudio}->pack_start($hboxAudio, 1, 1, 2);

		$hboxAudioSub->pack_start($self->{vboxAudio}, 0, 0, 4);

        $self->{vboxSub} = new Gtk2::VBox(0,0);
        $self->{subList} = new Gtk2::SimpleList($parent->{lang}->{PanelSub}=>'text');
        my $scrollSub = new Gtk2::ScrolledWindow;
        $scrollSub->set_policy ('automatic', 'automatic');
        $scrollSub->set_shadow_type('etched-in');
        $scrollSub->set_size_request(-1, 120);
        $scrollSub->add($self->{subList});
        $self->{vboxSub}->pack_start($scrollSub, 1, 1, 2);
        $self->{subChoices} = Gtk2::Combo->new;
		my @subChildren = $self->{subChoices}->get_children;
		$subChildren[0]->set_width_chars(12);
        my $subAddButton = Gtk2::Button->new_from_stock('gtk-add');
        $tmpWidget = $subAddButton;
        $tmpWidget = $tmpWidget->child while ! $tmpWidget->isa('Gtk2::HBox');
        ($tmpWidget->get_children)[1]->destroy;
        $subAddButton->signal_connect('clicked' => sub {
            my $sub = ($self->{subChoices}->get_children)[0]->get_text;
            push @{$self->{subList}->{data}}, [$sub];
        });
        my $subRemoveButton = Gtk2::Button->new_from_stock('gtk-remove');
        $tmpWidget = $subRemoveButton;
        $tmpWidget = $tmpWidget->child while ! $tmpWidget->isa('Gtk2::HBox');
        ($tmpWidget->get_children)[1]->destroy;
        $subRemoveButton->signal_connect('clicked' => sub {
            my @idx = $self->{subList}->get_selected_indices;
            my $selected = $idx[0];
            splice @{$self->{subList}->{data}}, $selected, 1;
            $selected-- if ($selected >= scalar(@{$self->{subList}->{data}}));
            $selected = 0 if $selected < 0 ;
            $self->{subList}->select($selected);
        });
		my $hboxSub = new Gtk2::HBox(0,0);
		$hboxSub->pack_start($self->{subChoices}, 0, 0, 2);
		$hboxSub->pack_start($subAddButton, 0, 0, 2);
		$hboxSub->pack_start($subRemoveButton, 0, 0, 2);
		$self->{vboxSub}->pack_start($hboxSub, 1, 1, 2);

		$hboxAudioSub->pack_start($self->{vboxSub}, 0, 0, 4);

		$self->{frameLang}->add($hboxAudioSub);

        my $commentLabel = new Gtk2::Label($parent->{lang}->{PanelComment});
        $commentLabel->set_alignment(0,0);
        $self->{comment} = new Gtk2::TextView;
        $self->{comment}->set_editable(1);
        $self->{comment}->set_wrap_mode('word');
        my $scrollComment = new Gtk2::ScrolledWindow;
        $scrollComment->set_border_width(2);
        $scrollComment->set_shadow_type('in');
        $scrollComment->set_policy('automatic', 'automatic');
        $scrollComment->set_size_request(-1,80);
        $scrollComment->add($self->{comment});
        $self->{vboxComment} = new Gtk2::VBox(0,0);
        $self->{vboxComment}->set_border_width(0);
        $self->{vboxComment}->pack_start($commentLabel,0,0,0);
        $self->{vboxComment}->pack_start($scrollComment,1,1,0);


        $vboxPerso->pack_start($hboxSeenRating,0,0,2);
        $vboxPerso->pack_start($hboxFormat,0,0,2);
        $vboxPerso->pack_start($self->{expanderLang},0,1,2);
        $vboxPerso->pack_start($self->{vboxComment},1,1,2);
        $framePerso->add($vboxPerso);

        my $frameInfo = new Gtk2::Frame();
        $frameInfo->set_label_align(1.0, 0.0);

        $self->{hboxOrig} = new Gtk2::HBox(0,0);
        my $origLabel = new Gtk2::Label($parent->{lang}->{PanelOriginal});
        $self->{orig} = Gtk2::Entry->new;
        $self->{hboxOrig}->pack_start($origLabel,0,0,0);
        $self->{hboxOrig}->pack_start($self->{orig},1,1,0);

        my $vbox = new Gtk2::VBox(0, 0);

        my $hboxpicinfos = new Gtk2::HBox(0,0);
        $self->{image} = Gtk2::Image->new_from_file($self->{defaultImage});
        $self->{imgButton} = Gtk2::Button->new;
        $self->{imgButton}->add($self->{image});
        $self->{imgButton}->set_size_request(130,170);
        $self->{tooltips}->set_tip($self->{imgButton}, $parent->{lang}->{PanelImageTip});
        $self->{imgButton}->signal_connect('clicked', \&changeImage, $self);

        $self->{infosFrame} = new Gtk2::Frame($parent->{lang}->{PanelInfoFrame});
        my $infoTable = new Gtk2::Table(5, 2, 0);
        $infoTable->set_row_spacings(5);
        $infoTable->set_border_width(5);


        $self->{dateLabel} = new Gtk2::Label($parent->{lang}->{PanelDate});
        $self->{dateLabel}->set_alignment(0,0.5);
        $infoTable->attach($self->{dateLabel}, 0, 1, 1, 2, 'fill', 'fill', 0, 0);
        $self->{date} = Gtk2::Entry->new;
        $infoTable->attach($self->{date}, 1, 2, 1, 2, 'fill', 'fill', 0, 0);

        $self->{directorLabel} = new Gtk2::Label($parent->{lang}->{PanelDirector});
        $self->{directorLabel}->set_alignment(0,0.5);
        $infoTable->attach($self->{directorLabel}, 0, 1, 2, 3, 'fill', 'fill', 0, 0);
        $self->{director} = Gtk2::Entry->new;
        $infoTable->attach($self->{director}, 1, 2, 2, 3, 'fill', 'fill', 0, 0);

        $self->{timeLabel} = new Gtk2::Label($parent->{lang}->{PanelTime});
        $self->{timeLabel}->set_alignment(0,0.5);
        $infoTable->attach($self->{timeLabel}, 0, 1, 3, 4, 'fill', 'fill', 0, 0);
        $self->{time} = Gtk2::Entry->new;
        $infoTable->attach($self->{time}, 1, 2, 3, 4, 'fill', 'fill', 0, 0);

        $self->{natLabel} = new Gtk2::Label($parent->{lang}->{PanelCountry});
        $self->{natLabel}->set_alignment(0,0.5);
        $infoTable->attach($self->{natLabel}, 0, 1, 4, 5, 'fill', 'fill', 0, 0);
        $self->{nationality} = Gtk2::Entry->new;
        $infoTable->attach($self->{nationality}, 1, 2, 4, 5, 'fill', 'fill', 0, 0);

        $self->{ageLabel} = new Gtk2::Label($parent->{lang}->{PanelAge});
        $self->{ageLabel}->set_alignment(0,0.5);
        $infoTable->attach($self->{ageLabel}, 0, 1, 5, 6, 'fill', 'fill', 0, 0);
        $self->{age} = new GCAgeChooser($parent->{lang}, 'minimum',100);
        $infoTable->attach($self->{age}, 1, 2, 5, 6, 'fill', 'fill', 0, 0);

        $self->{infosFrame}->add($infoTable);

        $hboxpicinfos->pack_start($self->{imgButton},0,0,2);
        $hboxpicinfos->pack_start($self->{infosFrame},0,0,20);

        $self->{hboxTypes} = new Gtk2::HBox(0,0);
        my $type1Label = new Gtk2::Label($parent->{lang}->{PanelType});
        $self->{type}[0] = Gtk2::Combo->new;
        $self->{type}[1] = Gtk2::Combo->new;
        $self->{type}[2] = Gtk2::Combo->new;
		my @children = $self->{type}[0]->get_children;
		$children[0]->set_width_chars(15);
		@children = $self->{type}[1]->get_children;
		$children[0]->set_width_chars(15);
		@children = $self->{type}[2]->get_children;
		$children[0]->set_width_chars(15);
        $self->{hboxTypes}->pack_start($type1Label,0,0,0);
        $self->{hboxTypes}->pack_start($self->{type}[0],0,0,2);
        $self->{hboxTypes}->pack_start($self->{type}[1],0,0,2);
        $self->{hboxTypes}->pack_start($self->{type}[2],0,0,2);

        $self->{hboxActors} = new Gtk2::HBox(0,0);
        my $actorsLabel = new Gtk2::Label($parent->{lang}->{PanelActors});
        $self->{actors} = Gtk2::Entry->new;
        $self->{hboxActors}->pack_start($actorsLabel,0,0,0);
        $self->{hboxActors}->pack_start($self->{actors},1,1,0);

        my $synopsisLabel = new Gtk2::Label($parent->{lang}->{PanelDescription});
        $self->{synopsis} = new Gtk2::TextView;
        $self->{synopsis}->set_editable(1);
        $self->{synopsis}->set_wrap_mode('word');
        my $scrollPanel = new Gtk2::ScrolledWindow;
        $scrollPanel->set_border_width(2);
        $scrollPanel->set_shadow_type('in');
        $scrollPanel->set_policy('automatic', 'automatic');
        $scrollPanel->add($self->{synopsis});
        $self->{hboxSynopsis} = new Gtk2::HBox(0,0);
        $self->{hboxSynopsis}->pack_start($synopsisLabel,0,0,0);
        $self->{hboxSynopsis}->pack_start($scrollPanel,1,1,0);

        $self->{frameAction} = new Gtk2::Frame();
        $self->{frameAction}->set_border_width(0);
        $self->{frameAction}->set_shadow_type('none');
        $self->{frameAction}->set_label_align(1.0, 0.0);
        my $hboxActions = new Gtk2::HBox(0,0);
        $hboxActions->set_border_width(0);
        my $hBoxUrl = new Gtk2::HBox(0,0);
        $self->{urlImage} = new Gtk2::Image;
        $self->{urlLabel} = new Gtk2::Label($parent->{lang}->{PanelWeb});
        $self->{urlButton} = Gtk2::Button->new;
        $hBoxUrl->pack_start($self->{urlImage}, 1, 0, 0);
        $hBoxUrl->pack_start($self->{urlLabel}, 1, 0, 0);
        $self->{urlButton}->add($hBoxUrl);
        $self->{urlButton}->signal_connect("clicked" => \&viewMoviePage, $self );
        $self->{tooltips}->set_tip($self->{urlButton}, $parent->{lang}->{PanelWebTip}, '');
        $hboxActions->pack_start($self->{urlButton},1,1,20);
        my $deleteButton = Gtk2::Button->new_from_stock('gtk-delete');
        $deleteButton->signal_connect("clicked" => \&deleteMovie, $self);
        $self->{tooltips}->set_tip($deleteButton, $parent->{lang}->{PanelRemoveTip}, '');
        $hboxActions->pack_start($deleteButton,1,1,20);
        $self->{frameAction}->add($hboxActions);

        $vbox->pack_start($self->{hboxOrig},0,0,2);
        $vbox->pack_start($hboxpicinfos,0,0,2);
        $vbox->pack_start($self->{hboxTypes},0,0,10);
        $vbox->pack_start($self->{hboxActors},0,0,2);
        $vbox->pack_start($self->{hboxSynopsis},1,1,2);
        $vbox->set_border_width(2);

        $frameInfo->add($vbox);
        $frameInfo->set_border_width(2);

        $self->{vboxMain}->pack_start($hboxTitle,0,0,2);
        
        my $frameLend = new Gtk2::Frame();
        $frameLend->set_border_width(2);
        $frameLend->set_label_align(1.0, 0.0);
        my $vboxLend = new Gtk2::VBox(0,0);
        $vboxLend->set_border_width(2);
        
        $self->{hboxBorrower} = new Gtk2::HBox(0,0);
        my $borrowerLabel = new Gtk2::Label($parent->{lang}->{PanelBorrower});
        $self->{borrowerOption} = new Gtk2::OptionMenu();

        $self->{hboxBorrower}->pack_start($borrowerLabel,0,0,0);
        $self->{hboxBorrower}->pack_start($self->{borrowerOption},0,0,10);
        
        $self->{lendDate} = Gtk2::Entry->new_with_max_length(10);
        $self->{lendDate}->set_width_chars(12);
        my $lendDateLabel = new Gtk2::Label($parent->{lang}->{PanelLendDate});
        my $dateSelectButton = new Gtk2::Button($parent->{lang}->{PanelLendDateSelect});
        $dateSelectButton->signal_connect('clicked' => sub {
                my $dialog = new GCDateSelectionDialog($parent);
                $dialog->date($self->{lendDate}->get_text);
                if ($dialog->show)
                {
                    $self->{lendDate}->set_text($dialog->date);
                }
            });
        
        $self->{hboxLendDate} = new Gtk2::HBox(0,0);
        $self->{hboxLendDate}->pack_start($lendDateLabel,0,0,0);
        $self->{hboxLendDate}->pack_start($self->{lendDate},0,0,10);
        $self->{hboxLendDate}->pack_start($dateSelectButton,0,0,0) if ! $readonly;
    
        my $hboxMail = new Gtk2::HBox(0,0);
        $self->{mailButton} = new Gtk2::Button($parent->{lang}->{MailTitle});
        $self->{mailButton}->signal_connect('clicked' => \&sendEmail, $self);
        $self->{returnedButton} = new Gtk2::Button($parent->{lang}->{PanelReturned});
        $self->{returnedButton}->signal_connect('clicked' => \&returnedMovie, $self);
        $hboxMail->pack_start($self->{mailButton},1,0,0);
        $hboxMail->pack_start($self->{returnedButton},1,0,0) if ! $readonly;
        
        $self->{historyLabel} = new Gtk2::Label($parent->{lang}->{PanelHistory});
        my $panelBorrower = $parent->{lang}->{PanelBorrower};
        $panelBorrower =~ s/:$//;
        my $panelLendDate = $parent->{lang}->{PanelLendDate};
        $panelLendDate =~ s/:$//;
        $self->{history} = new Gtk2::SimpleList($panelBorrower => "text",
                                                $panelLendDate => "text",
                                                $parent->{lang}->{PanelReturnDate} => "text");
        $self->{history}->set_rules_hint(1);
        my $scrollPanelList = new Gtk2::ScrolledWindow;
        $scrollPanelList->set_policy ('never', 'automatic');
        $scrollPanelList->set_shadow_type('etched-in');
        $scrollPanelList->set_border_width(0);
        $scrollPanelList->add($self->{history});
        $self->{hboxHistory} = new Gtk2::HBox(0,0);
        $self->{hboxHistory}->pack_start($scrollPanelList,1,0,100);
        $self->{hboxHistoryActions} = new Gtk2::HBox(0,0);
        my $removeHistoryButton = new Gtk2::Button($parent->{lang}->{PanelRemove});
        $removeHistoryButton->signal_connect('clicked' => sub {
                my @idx = $self->{history}->get_selected_indices;
                if ($^O =~ /win32/i)
                {
                    my @newData;
                    my $i = 0;
                    foreach (@{$self->{history}->{data}})
                    {
                        push @newData, [$_->[0], $_->[1]] if $i != $idx[0];
                        $i++;
                    }
                    @{$self->{history}->{data}} = @newData;
                }
                else
                {
                    splice @{$self->{history}->{data}}, $idx[0], 1;
                }
            });
        my $clearHistoryButton = new Gtk2::Button($parent->{lang}->{PanelClear});
        $clearHistoryButton->signal_connect('clicked' => sub {
                @{$self->{history}->{data}} = ();
            });
        $self->{hboxHistoryActions}->pack_start($removeHistoryButton,0,0,10);
        $self->{hboxHistoryActions}->pack_start($clearHistoryButton,0,0,10);
        my $hboxLayout = new Gtk2::HBox(0,0);
        $hboxLayout->pack_start($self->{hboxHistoryActions},1,0,0);
 
        $vboxLend->pack_start($self->{hboxBorrower}, 0, 0, 10);
        $vboxLend->pack_start($self->{hboxLendDate}, 0, 0, 10);
        $vboxLend->pack_start($hboxMail, 0, 0, 30);
        $vboxLend->pack_start($self->{historyLabel}, 0, 0, 0);
        $vboxLend->pack_start($self->{hboxHistory}, 1, 1, 5);
        $vboxLend->pack_start($hboxLayout, 1, 0, 5) if ! $readonly;
        $frameLend->add($vboxLend);

        $self->deactivate if ($readonly ||  $parent->{options}->lockPanel) ;
        
		if (!$options->order)
		{
		    $frameInfo->set_shadow_type('none');
    	    $framePerso->set_shadow_type('none');
		    $frameLend->set_shadow_type('none');
		    $hboxSeenRating->set_border_width(7);
		    $hboxFormat->set_border_width(7);
		    $self->{tabs} = Gtk2::Notebook->new();

            $self->{tabs}->set_name('GCInfoTabs');

		    $self->{tabs}->append_page($frameInfo, $parent->{lang}->{PanelMovieInfo});
		    $self->{tabs}->append_page($framePerso, $parent->{lang}->{PanelPrivateInfo});
		    $self->{tabs}->append_page($frameLend, $parent->{lang}->{PanelLendInfo});

		    $self->{vboxMain}->pack_start($self->{tabs}, 1, 1, 2);
		}
		else
		{
		    $frameInfo->set_label($parent->{lang}->{PanelMovieInfo});
		    $framePerso->set_label($parent->{lang}->{PanelPrivateInfo});
		    $frameLend->set_label($parent->{lang}->{PanelLendInfo});
		    $frameInfo->set_shadow_type('etched-in');
		    $framePerso->set_shadow_type('etched-in');
		    $frameLend->set_shadow_type('etched-in');
		    $self->{vboxMain}->pack_start($frameInfo, 1, 1, 2) if ($options->order == 1);
		    $self->{vboxMain}->pack_start($framePerso, 0, 0, 2);
            $self->{vboxMain}->pack_start($frameLend, 1, 1, 2);
		    $self->{vboxMain}->pack_start($frameInfo, 1, 1, 2) if ($options->order == 2);
		}


        $self->{vboxMain}->pack_start($self->{frameAction}, 0, 0, 2) if ! $readonly;

        $self->set_name('GCMovieFrame');

        my $realMain = new Gtk2::VBox(0,0);

        $realMain->pack_start($self->{vboxMain},1,1,0);

        $self->add($realMain);
        $self->show_all;

        $self->{warning} = new Gtk2::Label;
        $realMain->pack_start($self->{warning},1,1,0);

        $self->{imageDialog} = GCFileChooserDialog->new($parent->{lang}->{PanelImageTitle}, $parent, 'open');
        $self->{imageDialog}->setWithImagePreview(1);
        
        $self->setUrlType('image');
        
        
        return $self;
    }

    sub show
    {
        my $self = shift;
        
        $self->{vboxMain}->show;
        $self->{warning}->hide;
    }
    
    sub hide
    {
        my $self = shift;
        
        $self->{warning}->set_markup($self->{parent}->{lang}->{Warning});
        $self->{warning}->show;
        $self->{vboxMain}->hide;
    }
    
    sub deactivate
	{
        my $self = shift;
		$self->change_state($self,1);
	}
		
	sub change_state
    {
		my  ($caller, $self, $lock)  = @_;
		#print  'debug: change_state  (' . " $caller,  $self , $lock ) \n";
        $self->{comment}->set_sensitive(!$lock);
        $self->{synopsis}->set_sensitive(!$lock);
        $self->{id}->set_sensitive(!$lock);
        $self->{title}->set_sensitive(!$lock);
        $self->{orig}->set_sensitive(!$lock);
        $self->{date}->set_sensitive(!$lock);
        $self->{director}->set_sensitive(!$lock);
        $self->{time}->set_sensitive(!$lock);
        $self->{nationality}->set_sensitive(!$lock);
        $self->{actors}->set_sensitive(!$lock);
        $self->{lendDate}->set_sensitive(!$lock);
        
#        $self->{comment}->set_editable(!$lock);
#        $self->{synopsis}->set_editable(!$lock);
#        $self->{title}->set_editable(!$lock);
#        $self->{orig}->set_editable(!$lock);
#        $self->{date}->set_editable(!$lock);
#        $self->{director}->set_editable(!$lock);
#        $self->{time}->set_editable(!$lock);
#        $self->{nationality}->set_editable(!$lock);
#        $self->{actors}->set_editable(!$lock);
#        $self->{lendDate}->set_editable(!$lock);

		
        $self->{searchButton}->set_sensitive(!$lock);

        $self->{type}[0]->set_sensitive(!$lock);
        $self->{type}[1]->set_sensitive(!$lock);
        $self->{type}[2]->set_sensitive(!$lock);
        $self->{place}->set_sensitive(!$lock);
        $self->{vboxAudio}->set_sensitive(!$lock);
        $self->{vboxSub}->set_sensitive(!$lock);
		$self->{rating}->set_sensitive(!$lock);
        $self->{number}->set_sensitive(!$lock);
        $self->{formatOption}->set_sensitive(!$lock);
        $self->{borrowerOption}->set_sensitive(!$lock);
        $self->{seen}->set_sensitive(!$lock);
        
		$self->{imgButton}->sensitive(!$lock);
		$self->{age}->setEditable(!$lock);
        
        my @children;
        
        @children = $self->{type}[0]->get_children;
		#$children[0]->set_editable(!$lock);
		$children[0]->set_sensitive(!$lock);
        @children = $self->{type}[1]->get_children;
		$children[0]->set_sensitive(!$lock);
        @children = $self->{type}[2]->get_children;
		$children[0]->set_sensitive(!$lock);
        @children = $self->{place}->get_children;
		$children[0]->set_sensitive(!$lock);

    }
    
    sub setUrlType
    {
        my ($self, $type) = @_;
       
        $self->{urlType} = $type;
       
        if ($type eq 'text')
        {
            $self->{urlLabel}->show;
            $self->{urlImage}->hide;
        }
        else
        {
            $self->url($self->{url});
            $self->{urlLabel}->hide;
            $self->{urlImage}->show;
        }
   }
    
   sub setShowOption
   {
       my ($self, $show) = @_;
       
       $self->show_all;
        
        $self->{id}->hide if ! $show->{id};
        $self->{searchButton}->hide if ! $show->{search};
        $self->{frameAction}->hide if ! $show->{actions};
        $self->{seen}->hide if ! $show->{seen};
        $self->{rating}->hide if ! $show->{rating};
        $self->{ratingLabel}->hide if ! $show->{rating};
        $self->{vsepSeenRating}->hide if (! $show->{rating}) || (! $show->{seen});
        $self->{formatOption}->hide if ! $show->{format};
        $self->{formatLabel}->hide if ! $show->{format};
        $self->{number}->hide if ! $show->{number};
        $self->{numberLabel}->hide if ! $show->{number};
        $self->{place}->hide if ! $show->{place};
        $self->{placeLabel}->hide if ! $show->{place};
        $self->{vboxAudio}->hide if ! $show->{audio};
        $self->{vboxSub}->hide if ! $show->{subt};
        $self->{expanderLang}->hide if (! $show->{subt}) && (! $show->{audio});
        $self->{vboxComment}->hide if ! $show->{comment};
        $self->{hboxOrig}->hide if ! $show->{orig};
        $self->{imgButton}->hide if ! $show->{image};
        $self->{date}->hide if ! $show->{date};
        $self->{dateLabel}->hide if ! $show->{date};
        $self->{director}->hide if ! $show->{director};
        $self->{directorLabel}->hide if ! $show->{director};
        $self->{time}->hide if ! $show->{time};
        $self->{timeLabel}->hide if ! $show->{time};
        $self->{nationality}->hide if ! $show->{nat};
        $self->{natLabel}->hide if ! $show->{nat};
        $self->{age}->hide if ! $show->{age};
        $self->{ageLabel}->hide if ! $show->{age};
        $self->{infosFrame}->hide if (! $show->{date})
                                  && (! $show->{director})
                                  && (! $show->{time})
                                  && (! $show->{nat})
                                  && (! $show->{age});
        $self->{hboxTypes}->hide if ! $show->{type};
        $self->{hboxActors}->hide if ! $show->{actors};
        $self->{hboxSynopsis}->hide if ! $show->{synopsis};
        $self->{hboxBorrower}->hide if ! $show->{borrower};
        $self->{hboxLendDate}->hide if ! $show->{lendDate};
        $self->{mailButton}->hide if ! $show->{mail};
        $self->{historyLabel}->hide if ! $show->{history};
        $self->{hboxHistory}->hide if ! $show->{history};
        $self->{hboxHistoryActions}->hide if ! $show->{history};
        $self->{returnedButton}->hide if ! $show->{history};
       
       $self->setUrlType($self->{urlType});
       
       $self->{warning}->hide;
       
   }
    
   sub returnedMovie
   {
        use GCDialogs;
    
        shift;
        my $self = shift;
        
        my $dialog = new GCDateSelectionDialog($self->{parent});
        if ($dialog->show)
        {
            my @data = [$self->borrower, $self->lendDate, $dialog->date];
            unshift @{$self->{history}->{data}}, @data;
            $self->borrower('none');
            $self->lendDate('');
            $self->{parent}->{moviesList}->changeCurrent($self->image, 'none') if $self->image;
        }
   }
   
    sub sendEmail
    {
        use GCDialogs;
        
        shift;
        my $self = shift;
        
        my %info;
        
        $info{title} = $self->title;
        $info{borrower} = $self->borrower;
        $info{lendDate} = $self->lendDate;
         
        my $dialog = new GCMailDialog($self->{parent}, \%info);
         
        $dialog->show;
    }
    
    sub selectTitle
    {
        my $self = shift;
        $self->{title}->select_region(0, length($self->{title}->get_text()));
        $self->{title}->grab_focus;
    }

    sub deleteMovie
    {
       my ($widget, $self) = @_;

       $self->{parent}->deleteCurrentMovie;
    }

    sub searchMovie
    {
        my ($widget, $self) = @_;

        $self->{parent}->searchMovie($self->title,0,0);
    }

    sub setBrowser
    {
        my ($self, $cmd) = @_;
        
        $self->{browser} = $cmd;
    }

    sub viewMoviePage
    {
        my ($widget, $self) = @_;
        $self->{parent}->openUrl($self->url);
    }

    sub changeImage
    {
		my ($widget, $self) = @_;
	
		$self->{imageDialog}->set_filename($self->{imageFile});
		my $response = $self->{imageDialog}->run;
		if ($response eq 'ok')
		{
	        if ($self->{imageDialog}->get_filename ne $self->{imageFile})
            {
                my $imagePrefix = $self->{parent}->{imagePrefix};
                if ($self->{imageFile} =~ /(\/|\\)$imagePrefix[0-9]*\./)
                {
                    $self->{parent}->{movies}->markToBeRemoved($self->{imageFile});
                }
            }

            $self->image($self->{imageDialog}->get_filename);
            $self->{parent}->{moviesList}->changeCurrent($self->image, $self->borrower);
        }
        $self->{imageDialog}->hide;
    }

    sub history
    {
        my $self = shift;
        
        if (@_)
        {
            my $value = shift;
            @{$self->{history}->{data}} = ();
            my @lines = split m/,/, $value;
            foreach (@lines)
            {
                my @values = split m/:/;
                my @data = [ $values[0], $values[1], $values[2]];
                push @{$self->{history}->{data}}, @data;
            }
        }
        else
        {
            my $result = '';
            foreach (@{$self->{history}->{data}})
            {
                $result .= $_->[0].':'.$_->[1].':'.$_->[2].',';
            }
            $result =~ s/.$//;
            return $result;
        }
    }
    
    sub type
    {
        my $self = shift;
        if (@_)
        {
            $_ = shift;
            my @styles = split m/,/;
            my @stylesLists = @{$self->{type}};
            my $style;
            foreach $style (@stylesLists)
            {
                my @children = $style->get_children;
                my $type = shift @styles;
                $type =~ s/^\s*//;
                $children[0]->set_text($type);
            }
        }
        else
        {
            my $result = '';
            my @stylesLists = @{$self->{type}};
            my $style;
            foreach $style (@stylesLists)
            {
                my @children = $style->get_children;
                $result .= $children[0]->get_text;
                $result .= ',';
            }
            return $result;
        }
    }
 
    sub place
    {
        my $self = shift;
        my @children = $self->{place}->get_children;
        if (@_)
        {
            my $value = shift;
            $children[0]->set_text($value);
        }
        else
        {
            return $children[0]->get_text;
        }
    }

    sub audio
    {
        my $self = shift;
        if (@_)
        {
            $_ = shift;
            @{$self->{audioList}->{data}} = ();
            my @audios = split m/,/;

            foreach my $info(@audios)
            {
                my @track = split m/;/, $info;
                push @{$self->{audioList}->{data}}, \@track;
            }
        }
        else
        {
            my $result = '';

            foreach (@{$self->{audioList}->{data}})
            {
                $result .= join ';', @$_;
                $result .= ',';
            }

            return $result;
        }
    }
 
    sub subt
    {
        my $self = shift;
        
        if (@_)
        {
            $_ = shift;
            @{$self->{subList}->{data}} = ();
            my @subs = split m/,/;

            foreach my $info(@subs)
            {
                push @{$self->{subList}->{data}}, [$info];
            }
        }
        else
        {
            my $result = '';

            foreach (@{$self->{subList}->{data}})
            {
                $result .= $_->[0].',';
            }

            return $result;
        }
    }

    sub format
    {
        my $self = shift;
		if (@_)
		{
		    my $value = shift;
		    my $i = 0;
		    my $format;
		    foreach $format(@{$self->{formats}})
		    {
                last if (!$value) || ($format eq $value);
                $i++;
		    }
		    $i = 0 if $i >= scalar @{$self->{formats}};
		    $self->{format}->set_active($i);
		    $self->{formatOption}->remove_menu;
		    $self->{formatOption}->set_menu($self->{format});
		}
		else
		{
		    return $self->{formatOption}->child->get_label;
		}
    }
    
    sub borrower
    {
        my $self = shift;
		if (@_)
		{
		    my $value = shift;
		    my $i = 0;
            if ($value && ($value ne 'none'))
            {
                foreach (@{$self->{borrowers}})
                {
                    last if ($_ eq $value);
                    $i++;
                }
                GCUtils::sensitive($self->{mailButton},1);
                GCUtils::sensitive($self->{returnedButton},1);
            }
            else
            {
                GCUtils::sensitive($self->{mailButton},0);
                GCUtils::sensitive($self->{returnedButton},0);
            }
            $i = scalar @{$self->{borrowers}} - 1 if $i >= scalar(@{$self->{borrowers}});
 		    $self->{borrower}->set_active($i);
		    $self->{borrowerOption}->remove_menu;
		    $self->{borrowerOption}->set_menu($self->{borrower});
		}
		else
		{
            return 'none' if $self->{borrowerOption}->child->get_label eq $self->{parent}->{lang}->{PanelNobody};
		    return $self->{borrowerOption}->child->get_label;
		}
    }
 
    sub number
    {
        my $self = shift;
        $self->{number}->set_value(shift) if @_;
        return $self->{number}->get_value;
        
    }

    sub rating
    {
        my $self = shift;
        $self->{rating}->set_value(shift) if @_;
        return $self->{rating}->get_value;
        
    }

    sub comment
    {
        my $self = shift;
        my $buffer = $self->{comment}->get_buffer;
        if (@_)
        {
            my $text = shift;
		    $text =~ s/<br>/\n/g;
		    $buffer->set_text($text);
        }
		else
		{
		    my $text = $buffer->get_text($buffer->get_start_iter,
						 $buffer->get_end_iter, 1);
		    $text =~ s/\n/<br>/g;
		    return $text;
		}
    }

    sub synopsis
    {
        my $self = shift;
        my $buffer = $self->{synopsis}->get_buffer;
        if (@_)
        {
            my $text = shift;
            $text =~s/<br>/\n/g;
            $buffer->set_text($text);
        }
		else
		{
		    my $text = $buffer->get_text($buffer->get_start_iter,
						 $buffer->get_end_iter, 1);
		    $text =~s/\n/<br>/g;
		    return $text;
		}
    }

    sub url
    {
        use GCPlugins;
        my $self = shift;
        if (@_)
        {
            my $url = shift;
            $self->{url} = $url;
            return if ($self->{urlType} eq 'text');
            my $baseUrl;
            my $plugin;
            foreach (values %GCPlugins::pluginsMap)
            {
                ($baseUrl = $_->getMovieUrl) =~ s/http:\/\/(w{3})?//;
                 $plugin = $_;
                last if $url =~ m/$baseUrl/;
            }
            if ($url =~ m/$baseUrl/)
            {
                $self->{urlImage}->set_from_file($ENV{GCF_SHARE_DIR}.'/plugins/'.$plugin->getImageFile);
            }
            else
            {
                $self->{urlImage}->set_from_file($ENV{GCF_SHARE_DIR}.'/default.png');
            }
            $self->{urlImage}->set_size_request(128,32);
        }
        return $self->{url};
    }

    sub seen
   {
        my $self = shift;
        if (@_)
        {
            my $value = shift;
            $self->{seen}->set_active($value);
        }
        else
        {
            if ($self->{seen}->get_active)
            {
                return 1;
            }
            else
            {
                return 0;
            }
        }
   }
   
    sub age
    {
        my $self = shift;
        
        if (@_)
        {
            my $value = shift;
            $self->{age}->setValue($value);
        }
        else
        {
            return $self->{age}->getValue;
        }
    }



    sub image
    {
        my $self = shift;

        if (@_)
        {
            my $displayedImage = $self->{imageFile} = shift;;
            if (File::Spec->file_name_is_absolute($displayedImage))
            {
                $displayedImage = $self->{defaultImage} if (! -e $displayedImage);
            }
            else
            {
                my $dir;
                $dir = '.';
                $dir = dirname($self->{options}->file)
                    if $self->{parent}->{options}->file;
                if (-e $dir.'/'.$displayedImage)
                {
                    $displayedImage = $dir.'/'.$displayedImage;
                }
                else
                {
                    $displayedImage = $self->{defaultImage} unless (-e $displayedImage);
                }
            }
            $displayedImage = $self->{defaultImage} if ! -f $displayedImage;
            my $pixbuf = Gtk2::Gdk::Pixbuf->new_from_file($displayedImage);
            $pixbuf = $pixbuf->scale_simple(120,160,'bilinear') if ($pixbuf->get_width > 120) || ($pixbuf->get_height > 160);
            $self->{image}->set_from_pixbuf($pixbuf);
        }
        else
        {
            return $self->{imageFile};
        }
    }
    
    sub setAgeLabel
    {
        my $self = shift;
        my $value = int $self->{ageSlider}->get_value;
        if ($value < 2)
        {
            $value = $self->{parent}->{lang}->{PanelAgeUnknown};
        }
        elsif ($value < 5)
        {
            $value = $self->{parent}->{lang}->{PanelAgeNone};
        }
        elsif ($value < 8)
        {
            $value = $self->{parent}->{lang}->{PanelAgeParent};
        }
        $self->{ageValue}->set_label($value);
    }
    
    sub setBorrowers
    {
        my ($self, $values) = @_;
        
        my $current = $self->borrower if $self->{borrower};
        
        my @borrowers = ($self->{parent}->{lang}->{PanelNobody}, @{$values}, $self->{parent}->{lang}->{PanelUnknown});

        $self->{borrowerOption}->remove_menu;
        $self->{borrower}->destroy if $self->{borrower};
        $self->{borrower} = new Gtk2::Menu();

        foreach (@borrowers)
        {
            my $item = Gtk2::MenuItem->new_with_mnemonic($_);
		    $self->{borrower}->append($item);
        }
        $self->{borrowers} = \@borrowers;
		$self->{borrowerOption}->set_menu($self->{borrower});
        
        $self->borrower($current) if $self->{borrower};
        
        $self->{borrowerOption}->show_all;
        
        $self->{borrower}->signal_connect('selection-done' => sub {
            my $widget = shift;
            my $borrower = 'none';
            if ($widget->get_active->child->get_label eq $self->{parent}->{lang}->{PanelNobody})
            {
                GCUtils::sensitive($self->{returnedButton},0);
                GCUtils::sensitive($self->{mailButton},0)
            }
            else
            {
                $borrower = $widget->get_active->child->get_label;
                GCUtils::sensitive($self->{returnedButton},1);
                GCUtils::sensitive($self->{mailButton},1);
            }            
            $self->{parent}->{moviesList}->changeCurrent($self->image, $borrower) if $self->image;
        });
        
    }
 
    sub setFormats
    {
        my ($self, $values) = @_;
        
        my $current = $self->format if $self->{format};
        
        my @formats = @{$values};

        $self->{formatOption}->remove_menu;
        $self->{format}->destroy if $self->{format};
        $self->{format} = new Gtk2::Menu();

        foreach (@formats)
        {
            my $item = Gtk2::MenuItem->new_with_mnemonic($_);
		    $self->{format}->append($item);
        }
        $self->{formats} = \@formats;
		$self->{formatOption}->set_menu($self->{format});
        
        $self->format($current) if $self->{format};
        
        $self->{formatOption}->show_all;
    }
    
    sub setTypes
    {
        my ($self, $values) = @_;

        my @stylesLists = @{$self->{type}};
        my $style;
        foreach $style (@stylesLists)
        {
            $style->set_popdown_strings(@$values);
        }
    }

    sub setPlaces
    {
        my ($self, $values) = @_;

        $self->{place}->set_popdown_strings(@$values);
    }

    sub setAudios
    {
        my ($self, $audios, $encodings) = @_;

        #my @audios = ('');
        #my @encodings = ('');

        #foreach (@$values)
        #{
        #    my @track = split ';';
        #    push @audios, $track[0] if ($track[0]);
        #    push @encodings, $track[1] if ($track[1]);
        #}
        $self->{audioChoices}->set_popdown_strings(@$audios);
        $self->{encodingChoices}->set_popdown_strings(@$encodings);

    }

    sub setSubs
    {
        my ($self, $values) = @_;

        $self->{subChoices}->set_popdown_strings(@$values);
    }

    sub clear
    {
        my $self = shift;

        $self->id("");
        $self->title("");
        $self->date("");
        $self->time("");
        $self->director("");
        $self->nationality("");
        $self->type("");
        $self->synopsis("");
        $self->actors("");
        $self->orig("");
        $self->url("");
        $self->number(1);
        $self->rating(5);
        $self->format('DVD');
        $self->comment('');
        $self->place("");
        $self->audio("");
        $self->subt("");
        $self->image($self->{defaultImage});
        $self->seen(0);
        $self->age(0);
        $self->borrower($self->{parent}->{lang}->{PanelNobody});
        $self->history('');
        $self->lendDate('');
    }

    sub AUTOLOAD
    {
        my $self = shift;
        my $name = our $AUTOLOAD;
        return if $name =~ /::DESTROY$/;
        $name =~ s/.*?::(.*)/$1/;
        if (scalar @_)
        {
            my $text = shift;
            $self->{$name}->set_text($text);
        }
        else
        {
            return $self->{$name}->get_text;
        }
    }
}

{
    package GCMenuBar;
    use base "Gtk2::MenuBar";

    use GCExport;
    use GCImport;
    
    sub addHistoryMenu
    {
        my $self = shift;
        my $parent = $self->{parent};

        $parent->{options}->historysize (5) if $parent->{options}->historysize eq "";
        $parent->{options}->history ("none|" x ($parent->{options}->historysize - 1) . "none") if $parent->{options}->history eq "";

        my @tmpHistory = split(/\|/, $parent->{options}->history);
        my $current_size = scalar @tmpHistory;
        if ($current_size < $parent->{options}->historysize)
        {
            $parent->{options}->history ($parent->{options}->history . "|none" x ($parent->{options}->historysize - $current_size));
        }
        elsif ($current_size > $parent->{options}->historysize)
        {
            my $size = $parent->{options}->historysize - 1;
            (my $history = $parent->{options}->history) =~ s/^((?:[^\|]*\|){$size})?([^\|]*)\|.*$/$1$2/;
            $parent->{options}->history ($history);
        }

        my @history_array = split /\|/, $parent->{options}->history;
        foreach my $filename(@history_array)
        {
            next if $filename eq "none";
            next if $filename eq "";
            my $item = Gtk2::MenuItem->new_with_label($filename);
            $item->signal_connect ("activate" => sub {
						$parent->openMovie($filename);
					});
            $self->{menuHistory}->append($item);
            $item->show();
        }
        $self->{menuHistoryItem}->set_submenu($self->{menuHistory});
    }
		
    sub initFilters
    {
        my ($self, $seen, $borrower, $type, $rating, $age) = @_;
		
		$self->{parent}->{menubar}->{deactivateFilters} = 1;
		
		$self->{menuSeen}->set_active($seen + 1);
		$self->{menuSeen}->get_active->set_active(1);

        $self->{menuRating}->set_active(($rating > 0) ? 1 : 0);
		$self->{menuRating}->get_active->set_active(1);

        $self->{menuAge}->set_active(0) if $age < 2;
        $self->{menuAge}->set_active(1) if ($age > 1) && ($age < 5);
        $self->{menuAge}->set_active(2) if ($age > 4) && ($age < 8);
        $self->{menuAge}->set_active(3) if $age > 7;
        $self->{menuAge}->get_active->set_active(1);

        my @children = $self->{menuCategories}->get_children;
        my $idx = 0;
        foreach (@children)
        {
            last if $_->child->get_label eq $type;
            $idx++;
        }
        $self->{menuCategories}->set_active($idx);
        $self->{menuCategories}->get_active->set_active(1);

        $idx = 0;
        $idx = 1 if $borrower eq 'none';
        $self->{menuBorrowing}->set_active($idx);
        $self->{menuBorrowing}->get_active->set_active(1);

		$self->{parent}->{menubar}->{deactivateFilters} = 0;
    }
    
    sub new
    {
        my ($proto, $parent) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();

        $self->{parent} = $parent;
        $self->{accel} = Gtk2::AccelGroup->new();

        $self->{menuFile} = Gtk2::Menu->new();

        my $fto = Gtk2::TearoffMenuItem->new();
        $self->{menuFile}->append($fto);

        my $newmovie = Gtk2::ImageMenuItem->new_from_stock('gtk-add', $self->{accel});
        $self->{menuFile}->append($newmovie);
        $newmovie->signal_connect ("activate" => sub {
            $self->{parent}->newMovie;
        });


        my $savedb = Gtk2::ImageMenuItem->new_from_stock('gtk-save', $self->{accel});
        $self->{menuFile}->append($savedb);
        $savedb->signal_connect ("activate" => sub {
            $self->{parent}->saveList;
        });

        my $fsep1 = Gtk2::SeparatorMenuItem->new();
        $self->{menuFile}->append($fsep1);
        #my $newdb = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuNewList});
        my $newdb = Gtk2::ImageMenuItem->new_from_stock('gtk-new', $self->{accel});
        $newdb->signal_connect ("activate" => sub {
            $self->{parent}->newList;
        });
        $self->{menuFile}->append($newdb);
        my $saveasdb = Gtk2::ImageMenuItem->new_from_stock('gtk-save-as', $self->{accel});
        $saveasdb->signal_connect ("activate" => sub {
            $self->{parent}->saveAs;
        });
        $self->{menuFile}->append($saveasdb);
        my $opendb = Gtk2::ImageMenuItem->new_from_stock('gtk-open', $self->{accel});
        $opendb->signal_connect ("activate" => sub {
            $self->{parent}->openList;
        });
        $self->{menuFile}->append($opendb);

       	$self->{menuHistoryItem} = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuHistory});
        $self->{menuHistory} = Gtk2::Menu->new();
    		addHistoryMenu($self);
        $self->{menuFile}->append($self->{menuHistoryItem});

        my $fsep2 = Gtk2::SeparatorMenuItem->new();
        $self->{menuFile}->append($fsep2);

        my $lend = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuLend});
        $lend->signal_connect ("activate" => sub {
            $self->{parent}->showBorrowed;
        });
        $self->{menuFile}->append($lend);
                
        #my $importItem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuImport});
        my $importItem = Gtk2::ImageMenuItem->new_from_stock('gtk-convert', $self->{accel});
        $self->{menuImport} = Gtk2::Menu->new();        
        foreach my $importer(@GCImport::importersArray)
        {
            my $item = Gtk2::MenuItem->new_with_mnemonic($importer->getName($parent));
            $item->signal_connect ("activate" => sub {
                    $self->{parent}->import($importer);
                });
            $self->{menuImport}->append($item);
        }        
        $importItem->set_submenu($self->{menuImport});
        $self->{menuFile}->append($importItem);        

        #my $exportItem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuExport});
        my $exportItem = Gtk2::ImageMenuItem->new_from_stock('gtk-paste', $self->{accel});
        $self->{menuExport} = Gtk2::Menu->new();        
        foreach my $exporter(@GCExport::exportersArray)
        {
            my $item = Gtk2::MenuItem->new_with_mnemonic($exporter->getName);
            $item->signal_connect ("activate" => sub {
                    $self->{parent}->export($exporter);
                });
            $self->{menuExport}->append($item);
        }        
        $exportItem->set_submenu($self->{menuExport});
        $self->{menuFile}->append($exportItem);        

        my $fsep3 = Gtk2::SeparatorMenuItem->new();
        $self->{menuFile}->append($fsep3);

        my $leave = Gtk2::ImageMenuItem->new_from_stock('gtk-quit', $self->{accel});
        $self->{menuFile}->append($leave);
        $leave->signal_connect("activate" ,sub {
            $self->{parent}->leave;
        });

        my $fileitem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuMovies});
        $fileitem->set_submenu($self->{menuFile});

        $self->append($fileitem);

		#menu edition 
		#création du conteneur d'itemmenu
		$self->{menuEdit} = Gtk2::Menu->new();
		my $eto = Gtk2::TearoffMenuItem->new();  #le détacheur  (avant lavage ;-)
        $self->{menuEdit}->append($eto);

		#création d'une entree
		my $deleteCurrentItem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuEditDeleteCurrent});
        $deleteCurrentItem->signal_connect("activate" , sub {
            $self->{parent}->{panel}->deleteMovie($self,$self->{parent}->{panel});
        });
        $self->{menuEdit}->append($deleteCurrentItem);

		my $lockMoviesItem = Gtk2::CheckMenuItem->new_with_mnemonic($parent->{lang}->{MenuEditLockMovies});
		$self->{menuEdit}->append($lockMoviesItem);
	 	$lockMoviesItem->set_active($parent->{options}->lockPanel);
 		$lockMoviesItem->signal_connect("activate" , sub {
						my $parent = $self;
						my $self = shift;
						$parent->{parent}->{panel}->change_state($parent->{parent}->{panel}, $self->get_active());
						$parent->{parent}->{options}->lockPanel($self->get_active());
						$self->toggled();
			},$lockMoviesItem);
		$self->{menuEditLockMoviesItem}=$lockMoviesItem;
		$lockMoviesItem->{parent}=$self->{menuEdit};

		#L'entête du menu
		my $edititem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuEdit});
        $edititem->set_submenu($self->{menuEdit});
        $self->append($edititem);
		## fin du menu Edition

        $self->{menuDisplay} = Gtk2::Menu->new();

        my $dto = Gtk2::TearoffMenuItem->new();
        $self->{menuDisplay}->append($dto);

        my $allMovies = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuViewAllMovies});
        $allMovies->signal_connect("activate" , sub {
                $self->selectAll;
        });
        $self->{menuDisplay}->append($allMovies);

        #my $searchItem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuSearchMovies});
        #my $searchSelectedMovies = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuSearchSelectedMovies});
        #$searchSelectedMovies->signal_connect("activate" , sub {
        #        $self->{parent}->search('displayed');
        #});
        #my $searchAllMovies = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuSearchAllMovies});
        #$searchAllMovies->signal_connect("activate" , sub {
        #        $self->{parent}->search('all');
        #});        
        #my $searchMenu = Gtk2::Menu->new();
        #$searchMenu->append($searchAllMovies);
        #$searchMenu->append($searchSelectedMovies);
        #$searchItem->set_submenu($searchMenu);
        #$self->{menuDisplay}->append($searchItem);

        my $search = Gtk2::ImageMenuItem->new_from_stock('gtk-find', $self->{accel});
        $search->signal_connect("activate" , sub {
                $self->{parent}->search('all');
        }); 
        $self->{menuDisplay}->append($search);


        $self->{menuDisplay}->append(new Gtk2::SeparatorMenuItem);
        
        $self->{menuSeen} = Gtk2::Menu->new();
        my $allSeen = Gtk2::RadioMenuItem->new_with_mnemonic(undef,$parent->{lang}->{MenuAllMovies});
        $self->{menuSeen}->append($allSeen);
        $allSeen->signal_connect("activate" ,\&on_seenChange, $self);
        $self->{seenGroup} = $allSeen->get_group();
        my $notseen = Gtk2::RadioMenuItem->new_with_mnemonic($self->{seenGroup},$parent->{lang}->{MenuNotSeen});
        $self->{menuSeen}->append($notseen);
        $notseen->signal_connect("activate" ,\&on_seenChange, $self);
        $self->{seenItem} = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuSeenOrNot});
        $self->{seenItem}->set_submenu($self->{menuSeen});
        $self->{menuDisplay}->append($self->{seenItem});

        $self->{menuBorrowing} = Gtk2::Menu->new();
        my $allBorrowed = Gtk2::RadioMenuItem->new_with_mnemonic(undef,$parent->{lang}->{MenuAllMovies});
        $self->{menuBorrowing}->append($allBorrowed);
        $allBorrowed->signal_connect("activate" ,\&on_borrowedChange, $self);
        $self->{borrowedGroup} = $allBorrowed->get_group();
        my $notBorrowed = Gtk2::RadioMenuItem->new_with_mnemonic($self->{borrowedGroup},$parent->{lang}->{MenuNotBorrowed});
        $self->{menuBorrowing}->append($notBorrowed);
        $notBorrowed->signal_connect("activate" ,\&on_borrowedChange, $self);
        my $isBorrowed = Gtk2::RadioMenuItem->new_with_mnemonic($self->{borrowedGroup},$parent->{lang}->{MenuBorrowed});
        $self->{menuBorrowing}->append($isBorrowed);
        $isBorrowed->signal_connect("activate" ,\&on_borrowedChange, $self);
        $self->{borrowedItem} = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuBorrowing});
        $self->{borrowedItem}->set_submenu($self->{menuBorrowing});
        $self->{menuDisplay}->append($self->{borrowedItem});

        $self->{menuCategories} = Gtk2::Menu->new();
        my $allCat = Gtk2::RadioMenuItem->new_with_mnemonic(undef,$parent->{lang}->{MenuAllCategories});
        $self->{menuCategories}->append($allCat);
        $allCat->signal_connect("activate" ,\&on_catChange, $self);
        $self->{catGroup} = $allCat->get_group();
        $self->{catitem} = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuCategories});
        $self->{catitem}->set_submenu($self->{menuCategories});
        $self->{menuDisplay}->append($self->{catitem});

        $self->{menuAge} = Gtk2::Menu->new();
        my $allMoviesAge = Gtk2::RadioMenuItem->new_with_mnemonic(undef,$parent->{lang}->{MenuAllMovies});
        $self->{menuAge}->append($allMoviesAge);
        $allMoviesAge->signal_connect("activate" ,\&on_ageChange, $self);
        $self->{ageGroup} = $allMoviesAge->get_group();
        my $noneAge = Gtk2::RadioMenuItem->new_with_mnemonic($self->{ageGroup},$parent->{lang}->{MenuAgeNone});
        $self->{menuAge}->append($noneAge);
        $noneAge->signal_connect("activate" ,\&on_ageChange, $self);        
        my $parentAge = Gtk2::RadioMenuItem->new_with_mnemonic($self->{ageGroup},$parent->{lang}->{MenuAgeParent});
        $self->{menuAge}->append($parentAge);
        $parentAge->signal_connect("activate" ,\&on_ageChange, $self);        
        my $chooseAge = Gtk2::RadioMenuItem->new_with_mnemonic($self->{ageGroup},$parent->{lang}->{MenuAgeLess});
        $self->{menuAge}->append($chooseAge);
        $chooseAge->signal_connect("activate" ,\&on_ageChange, $self);
        $self->{ageItem} = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuAge});
        $self->{ageItem}->set_submenu($self->{menuAge});
        $self->{menuDisplay}->append($self->{ageItem});

        $self->{menuRating} = Gtk2::Menu->new();
        my $allRating = Gtk2::RadioMenuItem->new_with_mnemonic(undef,$parent->{lang}->{MenuAllRating});
        $self->{menuRating}->append($allRating);
        $allRating->signal_connect("activate" ,\&on_ratingChange, $self);
        $self->{ratingGroup} = $allRating->get_group();
        my $chooseRating = Gtk2::RadioMenuItem->new_with_mnemonic($self->{ratingGroup},$parent->{lang}->{MenuChooseRating});
        $self->{menuRating}->append($chooseRating);
        $chooseRating->signal_connect("activate" ,\&on_ratingChange, $self);
        $self->{ratingItem} = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuRating});
        $self->{ratingItem}->set_submenu($self->{menuRating});
        $self->{menuDisplay}->append($self->{ratingItem});

        $self->{displayItem} = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuDisplay});
        $self->{displayItem}->set_submenu($self->{menuDisplay});

        $self->append($self->{displayItem});

        $self->{menuConfig} = Gtk2::Menu->new();
        my $cto = Gtk2::TearoffMenuItem->new();
        $self->{menuConfig}->append($cto);
        my $options = Gtk2::ImageMenuItem->new_from_stock('gtk-preferences',$self->{accel});
        $options->signal_connect("activate" , sub {
            my ($widget, $window) = @_;
            $window->options;
        }, $self->{parent});
        $self->{menuConfig}->append($options);

        my $displayOptions = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuDisplayOptions});
        $displayOptions->signal_connect ("activate" => sub {
            $self->{parent}->displayOptions;
        });
        $self->{menuConfig}->append($displayOptions);

        my $borrowers = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuBorrowers});
        $borrowers->signal_connect ("activate" => sub {
            $self->{parent}->borrowers;
        });
        $self->{menuConfig}->append($borrowers);

        my $genresConversion = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuGenresConversion});
        $genresConversion->signal_connect ("activate" => sub {
            $self->{parent}->genresConversion;
        });
        $self->{menuConfig}->append($genresConversion);

        my $rename = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuRename});
        $rename->signal_connect ("activate" => sub {
            $self->{parent}->rename;
        });
        $self->{menuConfig}->append($rename);
        
        my $configitem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuConfiguration});
        $configitem->set_submenu($self->{menuConfig});
        $self->append($configitem);

        $self->{menuHelp} = Gtk2::Menu->new();
        my $hto = Gtk2::TearoffMenuItem->new();
        $self->{menuHelp}->append($hto);
        my $help = Gtk2::ImageMenuItem->new_from_stock('gtk-help',$self->{accel});
        $help->signal_connect("activate" , sub {
            my ($widget, $window) = @_;
            $window->help;
        }, $self->{parent});
        $self->{menuHelp}->append($help);
        my $about = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuAbout});
        $about->signal_connect("activate" , sub {
            my ($widget, $window) = @_;
            $window->about;
        }, $self->{parent});
        $self->{menuHelp}->append($about);


        my $helpitem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuHelp});
        $helpitem->set_submenu($self->{menuHelp});
        $self->append($helpitem);

        $parent->add_accel_group($self->{accel});

        $self->{ratingAsk} = new GCRatingDialog($parent);
        $self->{ageAsk} = new GCAgeDialog($parent);

        $self->{deactivateFilters} = 0;
        $self->{contextUpdating} = 0;

        bless ($self, $class);
        return $self;
    }

    sub on_seenChange
    {
        my ($widget, $self) = @_;
        

        
        if ($widget->get_active)
        {
            my $value = $widget->child->get_label();
            my $filter = 'seen';
            my $parameter = '';
            
            if ($value eq $self->{parent}->{lang}->{MenuAllMovies})
            {
                $parameter = 'all';
            }
            else
            {
                $parameter = 'notseen';
            }

            if (! $self->{contextUpdating})
            {
                $self->{contextUpdating} = 1;
                
                $self->{parent}->{contextMenuSeen}->set_active(($parameter eq 'all') ? 0 : 1);
                $self->{parent}->{contextMenuSeen}->get_active->set_active(1);
                
                $self->{contextUpdating} = 0;
            }
            
            return if $self->{deactivateFilters};

            $self->{parent}->setFilter($filter, $parameter);
        }
    }
    sub on_catChange
    {
        my ($widget, $self) = @_;
        
        if ($widget->get_active)
        {
            my $value = $widget->child->get_label();
            my $filter = 'type';
            my $parameter = '';
            
            if ($value eq $self->{parent}->{lang}->{MenuAllCategories})
            {
                $parameter = 'all';
            }
            else
            {
                $parameter = $value;
            }
            
            if (! $self->{contextUpdating})
            {
                $self->{contextUpdating} = 1;
                
                my $pos = 0;
                $pos = GCUtils::findPosition($value,$self->{menuCategories}) - 1 if $parameter ne 'all';
                
                $self->{parent}->{contextMenuCategories}->set_active($pos);
                $self->{parent}->{contextMenuCategories}->get_active->set_active(1);
                
                $self->{contextUpdating} = 0;
            }
            
            return if $self->{deactivateFilters};

            $self->{parent}->setFilter($filter, $parameter);
        }
    }
    sub on_ratingChange
    {
        my ($widget, $self) = @_;

        if ($widget->get_active)
        {
            my $value = $widget->child->get_label();
            my $filter = 'rating';
            my $parameter = '';
            
            if ($value eq $self->{parent}->{lang}->{MenuAllRating})
            {
                $parameter = 'all';
            }
            else
            {
                $parameter = $self->{ratingAsk}->getUserValue;
                return if ($parameter == -1);
            }
            if (! $self->{contextUpdating})
            {
                $self->{contextUpdating} = 1;
                
                $self->{parent}->{contextMenuRating}->set_active(($parameter eq 'all') ? 0 : 1);
                $self->{parent}->{contextMenuRating}->get_active->set_active(1);
                
                $self->{contextUpdating} = 0;
            }
            
            return if $self->{deactivateFilters};        

            $self->{parent}->setFilter($filter, $parameter);
        }
    }
    
    sub on_ageChange
    {
        my ($widget, $self) = @_;

        if ($widget->get_active)
        {
            my $value = $widget->child->get_label();
            my $filter = 'age';
            my $parameter = '';
            

            
            if ($value eq $self->{parent}->{lang}->{MenuAllMovies})
            {
                $parameter = 'all';
            }
            else
            {
                $parameter = 4 if $value eq $self->{parent}->{lang}->{MenuAgeNone};
                $parameter = 7 if $value eq $self->{parent}->{lang}->{MenuAgeParent};
                if (! $parameter)
                {
                    $parameter = $self->{ageAsk}->getUserValue if ! $self->{deactivateFilters};
                    $parameter = 8 if $self->{deactivateFilters};
                }
                return if ($parameter == -1);
            }
            
            if (! $self->{contextUpdating})
            {
                $self->{contextUpdating} = 1;
                
                $self->{parent}->{contextMenuAge}->set_active(0) if $parameter eq 'all';
                $self->{parent}->{contextMenuAge}->set_active(1) if $parameter == 4;
                $self->{parent}->{contextMenuAge}->set_active(2) if $parameter == 7;
                $self->{parent}->{contextMenuAge}->set_active(3) if $parameter > 7;
                $self->{parent}->{contextMenuAge}->get_active->set_active(1);
                
                $self->{contextUpdating} = 0;
            }
            
            return if $self->{deactivateFilters};        

            $self->{parent}->setFilter($filter, $parameter);            
        }
    }
    
    sub on_borrowedChange
    {
        my ($widget, $self) = @_;

        if ($widget->get_active)
        {
            my $value = $widget->child->get_label();
            my $filter = 'borrowing';
            my $parameter = '';
            
            if ($value eq $self->{parent}->{lang}->{MenuAllMovies})
            {
                $parameter = 'all';
            }
            elsif ($value eq $self->{parent}->{lang}->{MenuBorrowed})
            {
                $parameter = 'yes';
            }
            else
            {
                $parameter = 'no';
            }
            if (! $self->{contextUpdating})
            {
                $self->{contextUpdating} = 1;
                
                my $pos = 0;
                $pos = 1 if $parameter eq 'no';
                $pos = 2 if $parameter eq 'yes';
                $self->{parent}->{contextMenuBorrowing}->set_active($pos);
                $self->{parent}->{contextMenuBorrowing}->get_active->set_active(1);
                
                $self->{contextUpdating} = 0;
            }
            
            return if $self->{deactivateFilters};        

            $self->{parent}->setFilter($filter, $parameter);
        }
    }

    sub setTypes
    {
        my ($self, $values, $menu) = @_;

        my $default = 1;
        $default = 0  if $menu;

        $menu = $self->{menuCategories} if $default;
        my $catGroup = $self->{catGroup};
        $catGroup = $menu->{group} if ! $default;

        my @addValues = @$values;

        foreach ($menu->get_children)
        {
            my $label = $_->child->get_label;
            next if $label eq $self->{parent}->{lang}->{MenuAllCategories};
            my $idx = GCUtils::inArray($label, @addValues);

            if ($idx == undef)
            {
                $menu->remove($_);
            }
            else
            {
                splice @addValues, $idx, 1;
            }
        }

        my @itemsArray;

        foreach my $cat(@addValues)
        {
            next if !$cat;
            my $item = Gtk2::RadioMenuItem->new_with_mnemonic($catGroup, $cat);
            my $pos = GCUtils::findPosition($cat, $menu);
            $menu->insert($item, $pos);
            $item->signal_connect("activate", \&on_catChange, $self) if $default;
            splice @itemsArray, $pos - 1, 0, $item if ! $default;
        }

        if (! $default)
        {
            my $pos = 1;
            foreach my $item(@itemsArray)
            {
                $item->signal_connect("activate", sub {
                    shift;
                    my $idx = shift;
                    $self->{parent}->contextDisplayChange(undef, 'menuCategories', $idx);
                }, $pos);
                $pos++;
            }
        }

        $menu->hide_all;
        $menu->show_all;

        return;
    }
    
    sub selectAll
    {
        my $self = shift;
        
        $self->{parent}->removeSearch;
        $self->{parent}->blockListUpdates(1);
        $self->{menuSeen}->set_active(0);
        $self->{menuSeen}->get_active->set_active(1);
        $self->{menuCategories}->set_active(0);
        $self->{menuCategories}->get_active->set_active(1);
        $self->{menuRating}->set_active(0);
        $self->{menuRating}->get_active->set_active(1);
        $self->{menuAge}->set_active(0);
        $self->{menuAge}->get_active->set_active(1);
        $self->{menuBorrowing}->set_active(0);
        $self->{menuBorrowing}->get_active->set_active(1);
        $self->{parent}->blockListUpdates(0);
    }
}

{
    package GCToolBar;
    use base "Gtk2::Toolbar";

    sub new
    {
        my ($proto, $parent) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();

        bless($self, $class);

        $self->{parent} = $parent;
        $self->{lang} = $parent->{lang};
        
        $self->set_name('GCToolbar');

        $self->insert_stock("gtk-add" ,$self->{lang}->{NewMovieTooltip}, undef, sub {$parent->newMovie}, undef, -1);
        $self->insert_stock("gtk-save" ,$self->{lang}->{SaveListTooltip}, undef, sub {$parent->saveList}, undef, -1);
                
        $self->insert_stock("gtk-preferences" ,$self->{lang}->{PreferencesTooltip}, undef, sub {$parent->options}, undef, -1);

        $self->append_space;

        $self->insert_stock("gtk-find" ,$self->{lang}->{SearchTooltip}, undef, sub {$parent->search('all')}, undef, -1);

        $self->insert_stock("gtk-refresh" ,$self->{lang}->{ToolbarAllTooltip}, undef, sub {$parent->allMovies}, undef, -1);

        $self->insert_stock("gtk-execute" ,$self->{lang}->{RandomTooltip}, undef, sub {$parent->randomMovie}, undef, -1);


        $self->append_space;

                                                        
        # Movies list view selection /  Selection de la liste des films
		my %views = %{$self->{lang}->{OptionsViews}};
		if(scalar (keys %views) == 2)
		{
			# On cree le bouton toggle
			$self->{view} = new  Gtk2::ToggleButton->new( $views{$self->{options}->view} ) ;
			$self->{view}->show() ;
			$self->append_widget($self->{view},
												$self->{lang}->{ViewTooltip},
                                                $self->{lang}->{ViewTooltip});   
			$self->{view}->set_active (!$parent->{options}->view);
			$self->{view}->signal_connect( "toggled" => sub {
				my $togglebutton = $_[0];  
				my %views = %{$self->{lang}->{OptionsViews}};
				if ( $togglebutton->get_active )  
				{  
		    	  	# Si le controle arrive la, le bouton est baisse  
					$parent->{options}->view(0);
					$togglebutton->set_label($views{0}); 
      			}  
	      		else  
	      		{  
					# Si le controle arrive la, le bouton est leve  
	      			$parent->{options}->view(1);
					$togglebutton->set_label($views{1}); 
	     		}
				$parent->setMoviesList($parent->{options}->view, $parent->{options}->columns);
				$parent->checkView;
 
	        });
		}
		else
		{
			$self->{viewOption} = new Gtk2::OptionMenu();
			$self->{view} = new Gtk2::Menu();
			my %views = %{$self->{lang}->{OptionsViews}};
			foreach (0..(scalar(keys %views) - 1))
			{
			    my $item = Gtk2::MenuItem->new_with_label($views{$_});
			    $self->{view}->append($item);
			}
	        $self->{viewOption}->set_menu($self->{view}) ;
	        $self->{viewOption}->signal_connect('changed' => sub {
	                return if $self->{viewOption}->child->get_label eq $views{$parent->{options}->view};
	                my $i = 0;
                    $i++ while ($views{$i} ne $self->{viewOption}->child->get_label);
                    $parent->{options}->view($i);
	                $parent->setMoviesList($parent->{options}->view,
                                           $parent->{options}->columns);
                    $parent->checkView;
		        });
	        
	        $self->append_widget($self->{viewOption}, 
	                             $self->{lang}->{ViewTooltip},
	                             $self->{lang}->{ViewTooltip});                                                        
		 }        
        
        return $self;
    }
    
}

1;
