package GCExport::GCExportTarGz;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCExport::GCExportBase;

{
    package GCExport::GCExporterTarGz;

    eval "use Compress::Zlib"; my $hasZlib = $@ ? 0 : 1;
    eval "use Archive::Tar"; my $hasTar = $@ ? 0 : 1;

    use File::Copy;
    use File::Basename;
    use Cwd;
    use base qw(GCExport::GCExportBaseClass);

    sub new
    {
        my ($proto, $parent) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new($parent);
        bless ($self, $class);
        $self->{errors} = '';
        $self->{errors} .= "Compress::Zlib\n" if (!$hasZlib);
        $self->{errors} .= "Archive::Tar\n" if (!$hasTar);

        return $self;
    }
    
    sub process
    {
        my ($self, $options) = @_;
        
        $self->{options} = $options;
        $self->{fileName} = $options->{file};
        $self->{fileName} .= '.tar.gz' if ($self->{fileName} !~ m/\.tar\.gz$/);
        
        $self->{orig} = $options->{collection};
        #$self->{orig} =~ s/\\/\//g if ($^O =~ /win32/i);
        $self->{origDir} = dirname($self->{orig});
        
        my $listFile = 'films.gcf';
        my $baseDir = 'tmp_movies_tar_gz';
        my $imagesSubDir = 'images';
        my $imageDir = $baseDir.'/'.$imagesSubDir;

        mkdir $baseDir;
        mkdir $imageDir;
        my $currentDir = getcwd;

        my @tmpArray = @{$options->{movies}};
        my $movie;
        my $line;
        open LIST, '>'.$baseDir.'/'.$listFile;
        foreach $movie(@tmpArray)
        {
            chdir $self->{origDir};
            my $imageName;
            if ($movie->{image})
            {
                copy($movie->{image}, $currentDir.'/'.$imageDir);
                $imageName = $imagesSubDir.'/'.basename($movie->{image});
            }
            $line = join "|",
              $movie->{title},
              $movie->{date},
              $movie->{time},
              $movie->{director},
              $movie->{nat},
              $movie->{type},
              $imageName,
              $movie->{actors},
              $movie->{orig},
              $movie->{synopsis},
              $movie->{url};

              $line .= "|" . join "|",
              $movie->{seen},
              $movie->{format},
              $movie->{number},
              $movie->{place},
              $movie->{rating};
            
            $line = $movie->{id}."|".$line;

            printf LIST "$line\n";
        }
        close LIST;

        chdir $currentDir;

        my $tar = Archive::Tar->new();
        chdir $baseDir;
        $tar->add_files($listFile, $imagesSubDir);
        my @images = glob $imagesSubDir.'/*';
        $tar->add_files($_) foreach (@images);
        (my $tarfile = $self->{fileName}) =~ s/\.gz$//;
        $tar->write($tarfile);

        my $gz = gzopen($self->{fileName}, "wb");
        open(TAR, $tarfile) or die "Cannot open $tarfile ";
        binmode(TAR);
        my $buff;
        while (read(TAR, $buff, 8 * 2**10))
        {
            $gz->gzwrite($buff);
        }
        $gz->gzclose;
        close TAR;
        unlink foreach (@images);
        unlink $listFile;
        rmdir $imagesSubDir;
        chdir '..';
        rmdir $baseDir;
        $tarfile =~ s/\\/\//g if ($^O =~ /win32/i);
        unlink $tarfile;

        return $self->getEndInfo;
    }

    sub getOptions
    {
        my $self = shift;
        my @options;
        return \@options;
    }

    sub getName
    {
        my $self = shift;
        
        return ".tar.gz";
    }
    
    sub hasErrors
    {
        my $self = shift;

        return '' if !$self->{errors};
        return "Following modules should be present to use this export :\n\n".$self->{errors};
    }

    sub getEndInfo
    {
        my $self = shift;
        my $message = $self->{options}->{lang}->{ExportTarGzInfo}.$self->{fileName};
        return $message;
    }
}
