/* do not edit automatically generated by mc from StdIO.  */
/* StdIO.mod provides general Read and Write procedures.

Copyright (C) 2001-2021 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "Gmcrts.h"
#define _StdIO_H
#define _StdIO_C

#   include "GIO.h"
#   include "GM2RTS.h"

typedef struct StdIO_ProcWrite_p StdIO_ProcWrite;

typedef struct StdIO_ProcRead_p StdIO_ProcRead;

#   define MaxStack 40
typedef struct _T1_a _T1;

typedef struct _T2_a _T2;

typedef void (*StdIO_ProcWrite_t) (char);
struct StdIO_ProcWrite_p { StdIO_ProcWrite_t proc; };

typedef void (*StdIO_ProcRead_t) (char *);
struct StdIO_ProcRead_p { StdIO_ProcRead_t proc; };

struct _T1_a { StdIO_ProcWrite array[MaxStack+1]; };
struct _T2_a { StdIO_ProcRead array[MaxStack+1]; };
static _T1 StackW;
static unsigned int StackWPtr;
static _T2 StackR;
static unsigned int StackRPtr;

/*
   Read - is the generic procedure that all higher application layers
          should use to receive a character.
*/

extern "C" void StdIO_Read (char *ch);

/*
   Write - is the generic procedure that all higher application layers
           should use to emit a character.
*/

extern "C" void StdIO_Write (char ch);

/*
   PushOutput - pushes the current Write procedure onto a stack,
                any future references to Write will actually invoke
                procedure, p.
*/

extern "C" void StdIO_PushOutput (StdIO_ProcWrite p);

/*
   PopOutput - restores Write to use the previous output procedure.
*/

extern "C" void StdIO_PopOutput (void);

/*
   GetCurrentOutput - returns the current output procedure.
*/

extern "C" StdIO_ProcWrite StdIO_GetCurrentOutput (void);

/*
   PushInput - pushes the current Read procedure onto a stack,
               any future references to Read will actually invoke
               procedure, p.
*/

extern "C" void StdIO_PushInput (StdIO_ProcRead p);

/*
   PopInput - restores Write to use the previous output procedure.
*/

extern "C" void StdIO_PopInput (void);

/*
   GetCurrentInput - returns the current input procedure.
*/

extern "C" StdIO_ProcRead StdIO_GetCurrentInput (void);


/*
   Read - is the generic procedure that all higher application layers
          should use to receive a character.
*/

extern "C" void StdIO_Read (char *ch)
{
  (*StackR.array[StackRPtr].proc) (ch);
}


/*
   Write - is the generic procedure that all higher application layers
           should use to emit a character.
*/

extern "C" void StdIO_Write (char ch)
{
  (*StackW.array[StackWPtr].proc) (ch);
}


/*
   PushOutput - pushes the current Write procedure onto a stack,
                any future references to Write will actually invoke
                procedure, p.
*/

extern "C" void StdIO_PushOutput (StdIO_ProcWrite p)
{
  if (StackWPtr == MaxStack)
    {
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
  else
    {
      StackWPtr += 1;
      StackW.array[StackWPtr] = p;
    }
}


/*
   PopOutput - restores Write to use the previous output procedure.
*/

extern "C" void StdIO_PopOutput (void)
{
  if (StackWPtr == 1)
    {
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
  else
    {
      StackWPtr -= 1;
    }
}


/*
   GetCurrentOutput - returns the current output procedure.
*/

extern "C" StdIO_ProcWrite StdIO_GetCurrentOutput (void)
{
  if (StackWPtr > 0)
    {
      return StackW.array[StackWPtr];
    }
  else
    {
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
  ReturnException ("../../gcc-git-devel-modula2/gcc/m2/gm2-libs/StdIO.def", 25, 1);
  __builtin_unreachable ();
}


/*
   PushInput - pushes the current Read procedure onto a stack,
               any future references to Read will actually invoke
               procedure, p.
*/

extern "C" void StdIO_PushInput (StdIO_ProcRead p)
{
  if (StackRPtr == MaxStack)
    {
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
  else
    {
      StackRPtr += 1;
      StackR.array[StackRPtr] = p;
    }
}


/*
   PopInput - restores Write to use the previous output procedure.
*/

extern "C" void StdIO_PopInput (void)
{
  if (StackRPtr == 1)
    {
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
  else
    {
      StackRPtr -= 1;
    }
}


/*
   GetCurrentInput - returns the current input procedure.
*/

extern "C" StdIO_ProcRead StdIO_GetCurrentInput (void)
{
  if (StackRPtr > 0)
    {
      return StackR.array[StackRPtr];
    }
  else
    {
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
  ReturnException ("../../gcc-git-devel-modula2/gcc/m2/gm2-libs/StdIO.def", 25, 1);
  __builtin_unreachable ();
}

extern "C" void _M2_StdIO_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[])
{
  StackWPtr = 0;
  StackRPtr = 0;
  StdIO_PushOutput ((StdIO_ProcWrite) {(StdIO_ProcWrite_t) IO_Write});
  StdIO_PushInput ((StdIO_ProcRead) {(StdIO_ProcRead_t) IO_Read});
}

extern "C" void _M2_StdIO_finish (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[])
{
}
