/* do not edit automatically generated by mc from SysStorage.  */
/* SysStorage.def provides dynamic allocation for the system components.

Copyright (C) 2001-2020 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */


#if !defined (_SysStorage_H)
#   define _SysStorage_H

#   ifdef __cplusplus
extern "C" {
#   endif
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"

#   if defined (_SysStorage_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   ALLOCATE - attempt to allocate memory from the heap.
              NIL is returned in, a, if ALLOCATE fails.
*/

EXTERN void SysStorage_ALLOCATE (void * *a, unsigned int size);

/*
   DEALLOCATE - return, size, bytes to the heap.
                The variable, a, is set to NIL.
*/

EXTERN void SysStorage_DEALLOCATE (void * *a, unsigned int size);

/*
   REALLOCATE - attempts to reallocate storage. The address,
                a, should either be NIL in which case ALLOCATE
                is called, or alternatively it should have already
                been initialized by ALLOCATE. The allocated storage
                is resized accordingly.
*/

EXTERN void SysStorage_REALLOCATE (void * *a, unsigned int size);

/*
   Available - returns TRUE if, size, bytes can be allocated.
*/

EXTERN unsigned int SysStorage_Available (unsigned int size);

/*
   Init - initializes the heap.
          This does nothing on a GNU/Linux system.
          But it remains here since it might be used in an
          embedded system.
*/

EXTERN void SysStorage_Init (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
