/* { dg-do run } */
/* { dg-require-effective-target power10_hw } */
/* { dg-options "-mdejagnu-cpu=power10" } */

#include <altivec.h>

extern void abort (void);

/* Vector string isolate right-justified on array of signed char.  */
vector signed char
sirj (vector signed char arg)
{
  return vec_strir (arg);
}

int main (int argc, char *argv [])
{
  vector signed char input1 =
    { 0x1, 0x2, 0xf3, 0x4, 0x5, 0x6, 0x7, 0x8,
      0x9, 0xa, 0xb, 0xc, 0xd, 0xe2, 0xf, 0x11 };
  vector signed char expected1 =
    { 0x1, 0x2, 0xf3, 0x4, 0x5, 0x6, 0x7, 0x8,
      0x9, 0xa, 0xb, 0xc, 0xd, 0xe2, 0xf, 0x11 };
  vector signed char input2 =
    { 0x1, 0x2, 0xf3, 0x4, 0x5, 0x6, 0x7, 0x8,
      0x9, 0xa, 0xb, 0xc, 0xd, 0x0, 0xf, 0x11 };
  vector signed char expected2 =
    { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
      0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x11 };
  vector signed char input3 =
    { 0x1, 0x2, 0xf3, 0x0, 0x5, 0x6, 0x7, 0x8,
      0x9, 0xa, 0xb, 0xc, 0xd, 0xe2, 0x0, 0x11 };
  vector signed char expected3 =
    { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
      0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11 };
  vector signed char input4 =
    { 0x1, 0x2, 0xf3, 0x4, 0x5, 0x6, 0x7, 0x8,
      0x9, 0xa, 0xb, 0xc, 0xd, 0xe2, 0x0, 0x11 };
  vector signed char expected4 =
    { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
      0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11 };

  if (!vec_all_eq (sirj (input1), expected1))
    abort ();
  if (!vec_all_eq (sirj (input2), expected2))
    abort ();
  if (!vec_all_eq (sirj (input3), expected3))
    abort ();
  if (!vec_all_eq (sirj (input4), expected4))
    abort ();

}
