// Copyright (C) 2017-2019 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

// { dg-options "-std=gnu++17" }
// { dg-do compile }

#include <math.h>

namespace gnu
{
  using ::acos;
  using ::asin;
  using ::atan;
  using ::atan2;
  using ::ceil;
  using ::cos;
  using ::cosh;
  using ::exp;
  using ::fabs;
  using ::floor;
  using ::fmod;
  using ::frexp;
  using ::ldexp;
  using ::log;
  using ::log10;
  using ::modf;
  using ::pow;
  using ::sin;
  using ::sinh;
  using ::sqrt;
  using ::tan;
  using ::tanh;

  using ::assoc_laguerre;
  using ::assoc_laguerref;
  using ::assoc_laguerrel;
  using ::assoc_legendre;
  using ::assoc_legendref;
  using ::assoc_legendrel;
  using ::beta;
  using ::betaf;
  using ::betal;
  using ::comp_ellint_1;
  using ::comp_ellint_1f;
  using ::comp_ellint_1l;
  using ::comp_ellint_2;
  using ::comp_ellint_2f;
  using ::comp_ellint_2l;
  using ::comp_ellint_3;
  using ::comp_ellint_3f;
  using ::comp_ellint_3l;
  using ::cyl_bessel_i;
  using ::cyl_bessel_if;
  using ::cyl_bessel_il;
  using ::cyl_bessel_j;
  using ::cyl_bessel_jf;
  using ::cyl_bessel_jl;
  using ::cyl_bessel_k;
  using ::cyl_bessel_kf;
  using ::cyl_bessel_kl;
  using ::cyl_neumann;
  using ::cyl_neumannf;
  using ::cyl_neumannl;
  using ::ellint_1;
  using ::ellint_1f;
  using ::ellint_1l;
  using ::ellint_2;
  using ::ellint_2f;
  using ::ellint_2l;
  using ::ellint_3;
  using ::ellint_3f;
  using ::ellint_3l;
  using ::expint;
  using ::expintf;
  using ::expintl;
  using ::hermite;
  using ::hermitef;
  using ::hermitel;
  using ::laguerre;
  using ::laguerref;
  using ::laguerrel;
  using ::legendre;
  using ::legendref;
  using ::legendrel;
  using ::riemann_zeta;
  using ::riemann_zetaf;
  using ::riemann_zetal;
  using ::sph_bessel;
  using ::sph_besself;
  using ::sph_bessell;
  using ::sph_legendre;
  using ::sph_legendref;
  using ::sph_legendrel;
  using ::sph_neumann;
  using ::sph_neumannf;
  using ::sph_neumannl;
}
