// { dg-options "-std=gnu++11" }

// 2010-07-07  Stephen M. Webb  <stephen.webb@bregmasoft.com>
//
// Copyright (C) 2010-2014 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

// [28.8.2](11) class template basic_regex constructors

#include <regex>
#include <testsuite_hooks.h>

// Tests copy constructor of the basic_regex class.  
void test01()
{
  typedef std::basic_regex<char> test_type;

  test_type src_re("aaba");

  test_type target_re(src_re);
  
	VERIFY( target_re.flags() == src_re.flags() );
	VERIFY( target_re.mark_count() == src_re.mark_count() );
}

int
main()
{ 
  test01();
  return 0;
}
