;;- Machine description for GNU compiler -- S/390 / zSeries version.
;;  Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004
;;  Free Software Foundation, Inc.
;;  Contributed by Hartmut Penner (hpenner@de.ibm.com) and
;;                 Ulrich Weigand (uweigand@de.ibm.com).

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 2, or (at your option) any later
;; version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to the Free
;; Software Foundation, 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;
;; Special constraints for s/390 machine description:
;;
;;    a -- Any address register from 1 to 15.
;;    d -- Any register from 0 to 15.
;;    I -- An 8-bit constant (0..255).
;;    J -- A 12-bit constant (0..4095).
;;    K -- A 16-bit constant (-32768..32767).
;;    L -- Value appropriate as displacement. 
;;         (0..4095) for short displacement
;;         (-524288..524287) for long displacement
;;    M -- Constant integer with a value of 0x7fffffff.
;;    N -- Multiple letter constraint followed by 4 parameter letters.
;;         0..9:  number of the part counting from most to least significant
;;         H,Q:   mode of the part
;;         D,S,H: mode of the containing operand
;;         0,F:   value of the other parts (F - all bits set)
;;         
;;         The constraint matches if the specified part of a constant
;;         has a value different from its other parts.
;;    Q -- Memory reference without index register and with short displacement.
;;    R -- Memory reference with index register and short displacement.
;;    S -- Memory reference without index register but with long displacement.
;;    T -- Memory reference with index register and long displacement.
;;    U -- Pointer with short displacement.
;;    W -- Pointer with long displacement.
;;    Y -- Shift count operand.
;;
;; Special formats used for outputting 390 instructions.
;;
;;     %C: print opcode suffix for branch condition.
;;     %D: print opcode suffix for inverse branch condition.
;;     %J: print tls_load/tls_gdcall/tls_ldcall suffix
;;     %O: print only the displacement of a memory reference.
;;     %R: print only the base register of a memory reference.
;;     %N: print the second word of a DImode operand.
;;     %M: print the second word of a TImode operand.

;;     %b: print integer X as if it's an unsigned byte.
;;     %x: print integer X as if it's an unsigned word.
;;     %h: print integer X as if it's a signed word.
;;     %i: print the first nonzero HImode part of X
;;     %j: print the first HImode part unequal to 0xffff of X

;;
;; We have a special constraint for pattern matching.
;;
;;   s_operand -- Matches a valid S operand in a RS, SI or SS type instruction.
;;

;;
;; UNSPEC usage
;;

(define_constants
  [; Miscellaneous
   (UNSPEC_ROUND		1)
   (UNSPEC_SETHIGH		10)

   ; GOT/PLT and lt-relative accesses
   (UNSPEC_LTREL_OFFSET		100)
   (UNSPEC_LTREL_BASE		101)
   (UNSPEC_GOTENT		110)
   (UNSPEC_GOT			111)
   (UNSPEC_GOTOFF		112)
   (UNSPEC_PLT			113)
   (UNSPEC_PLTOFF		114)

   ; Literal pool
   (UNSPEC_RELOAD_BASE		210)
   (UNSPEC_MAIN_BASE		211)

   ; TLS relocation specifiers
   (UNSPEC_TLSGD		500)
   (UNSPEC_TLSLDM		501)
   (UNSPEC_NTPOFF               502)
   (UNSPEC_DTPOFF               503)
   (UNSPEC_GOTNTPOFF            504)
   (UNSPEC_INDNTPOFF            505)

   ; TLS support
   (UNSPEC_TP			510)
   (UNSPEC_TLSLDM_NTPOFF	511)
   (UNSPEC_TLS_LOAD		512)

   ; String Functions
   (UNSPEC_SRST		600)
 ])

;;
;; UNSPEC_VOLATILE usage
;;

(define_constants
  [; Blockage
   (UNSPECV_BLOCKAGE		0)

   ; Literal pool
   (UNSPECV_POOL		200)
   (UNSPECV_POOL_START		201)
   (UNSPECV_POOL_END		202)
   (UNSPECV_POOL_ENTRY		203)
   (UNSPECV_MAIN_POOL		300)

   ; TLS support
   (UNSPECV_SET_TP		500)
  ])


;; Processor type.  This attribute must exactly match the processor_type
;; enumeration in s390.h.

(define_attr "cpu" "g5,g6,z900,z990"
  (const (symbol_ref "s390_tune")))

;; Define an insn type attribute.  This is used in function unit delay
;; computations.

(define_attr "type" "none,integer,load,lr,la,larl,lm,stm,
	             cs,vs,store,imul,idiv,
		     branch,jsr,fsimpd,fsimps,
		     floadd,floads,fstored, fstores,
		     fmuld,fmuls,fdivd,fdivs,
		     ftoi,itof,fsqrtd,fsqrts,
                     other,o2,o3"
  (const_string "integer"))

;; Operand type. Used to default length attribute values

(define_attr "op_type"
  "NN,E,RR,RRE,RX,RS,RSI,RI,SI,S,SS,SSE,RXE,RSE,RIL,RIE,RXY,RSY,SIY"
  (const_string "RX"))

;; Insn are devide in two classes:
;;   agen: Insn using agen
;;   reg: Insn not using agen

(define_attr "atype" "agen,reg"
(cond [ (eq_attr "op_type" "E")    (const_string "reg")
         (eq_attr "op_type" "RR")  (const_string "reg")
         (eq_attr "op_type" "RX")  (const_string "agen")
         (eq_attr "op_type" "RI")  (const_string "reg")
         (eq_attr "op_type" "RRE") (const_string "reg")
         (eq_attr "op_type" "RS")  (const_string "agen")
         (eq_attr "op_type" "RSI") (const_string "agen")
         (eq_attr "op_type" "S")   (const_string "agen")
         (eq_attr "op_type" "SI")  (const_string "agen")
         (eq_attr "op_type" "SS")  (const_string "agen")
         (eq_attr "op_type" "SSE") (const_string "agen")
         (eq_attr "op_type" "RXE") (const_string "agen")
         (eq_attr "op_type" "RSE") (const_string "agen")
         (eq_attr "op_type" "RIL") (const_string "agen")
         (eq_attr "op_type" "RXY") (const_string "agen")
         (eq_attr "op_type" "RSY") (const_string "agen")
         (eq_attr "op_type" "SIY") (const_string "agen")]
  (const_string "reg")))

;; Generic pipeline function unit.

(define_function_unit "integer" 1 0
  (eq_attr "type" "none") 0 0)

(define_function_unit "integer" 1 0
  (eq_attr "type" "integer") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "fsimpd") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "fsimps") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "load") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "floadd") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "floads") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "la") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "larl") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "lr") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "branch") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "store") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "fstored") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "fstores") 1 1)

(define_function_unit "integer" 1 0
  (eq_attr "type" "lm") 2 2)

(define_function_unit "integer" 1 0
  (eq_attr "type" "stm") 2 2)

(define_function_unit "integer" 1 0
  (eq_attr "type" "cs") 5 5)

(define_function_unit "integer" 1 0
  (eq_attr "type" "vs") 30 30)

(define_function_unit "integer" 1 0
  (eq_attr "type" "jsr") 5 5)

(define_function_unit "integer" 1 0
  (eq_attr "type" "imul") 7 7)

(define_function_unit "integer" 1 0
  (eq_attr "type" "fmuld") 6 6)

(define_function_unit "integer" 1 0
  (eq_attr "type" "fmuls") 6 6)

(define_function_unit "integer" 1 0
  (eq_attr "type" "idiv") 33 33)

(define_function_unit "integer" 1 0
  (eq_attr "type" "fdivd") 33 33)

(define_function_unit "integer" 1 0
  (eq_attr "type" "fdivs") 33 33)

(define_function_unit "integer" 1 0
  (eq_attr "type" "fsqrtd") 30 30)

(define_function_unit "integer" 1 0
  (eq_attr "type" "fsqrts") 30 30)

(define_function_unit "integer" 1 0
  (eq_attr "type" "ftoi") 2 2)

(define_function_unit "integer" 1 0
  (eq_attr "type" "itof") 2 2)

(define_function_unit "integer" 1 0
  (eq_attr "type" "o2") 2 2)

(define_function_unit "integer" 1 0
  (eq_attr "type" "o3") 3 3)

(define_function_unit "integer" 1 0
  (eq_attr "type" "other") 5 5)

;; Pipeline description for z900

(include "2064.md")
(include "2084.md")

;; Length in bytes.

(define_attr "length" ""
(cond [ (eq_attr "op_type" "E")    (const_int 2)
         (eq_attr "op_type" "RR")  (const_int 2)
         (eq_attr "op_type" "RX")  (const_int 4)
         (eq_attr "op_type" "RI")  (const_int 4)
         (eq_attr "op_type" "RRE") (const_int 4)
         (eq_attr "op_type" "RS")  (const_int 4)
         (eq_attr "op_type" "RSI") (const_int 4)
         (eq_attr "op_type" "S")   (const_int 4)
         (eq_attr "op_type" "SI")  (const_int 4)
         (eq_attr "op_type" "SS")  (const_int 6)
         (eq_attr "op_type" "SSE") (const_int 6)
         (eq_attr "op_type" "RXE") (const_int 6)
         (eq_attr "op_type" "RSE") (const_int 6)
         (eq_attr "op_type" "RIL") (const_int 6)
         (eq_attr "op_type" "RXY") (const_int 6)
         (eq_attr "op_type" "RSY") (const_int 6)
         (eq_attr "op_type" "SIY") (const_int 6)]
         (const_int 4)))

;; Define attributes for `asm' insns.

(define_asm_attributes [(set_attr "type" "other")
                        (set_attr "op_type" "NN")])

;;
;;  Condition Codes
;;
;
;   CCL:  Zero     Nonzero   Zero      Nonzero      (AL, ALR, SL, SLR, N, NC, NI, NR, O, OC, OI, OR, X, XC, XI, XR)
;   CCA:  Zero     <Zero     >Zero     Overflow     (A, AR, AH, AHI, S, SR, SH, SHI, LTR, LCR, LNR, LPR, SLA, SLDA, SLA, SRDA)
;   CCU:  Equal    ULess     UGreater  --           (CL, CLR, CLI, CLM)
;   CCS:  Equal    SLess     SGreater  --           (C, CR, CH, CHI, ICM)
;   CCT:  Zero     Mixed     Mixed     Ones         (TM, TMH, TML)

;   CCZ  -> CCL / CCZ1
;   CCZ1 -> CCA/CCU/CCS/CCT
;   CCS  -> CCA

;   String:    CLC, CLCL, CLCLE, CLST, CUSE, MVCL, MVCLE, MVPG, MVST, SRST
;   Clobber:   CKSM, CFC, CS, CDS, CUUTF, CUTFU, PLO, SPM, STCK, STCKE, TS, TRT, TRE, UPT


;;
;;- Compare instructions.
;;

(define_expand "cmpdi"
  [(set (reg:CC 33)
        (compare:CC (match_operand:DI 0 "register_operand" "")
                    (match_operand:DI 1 "general_operand" "")))]
  "TARGET_64BIT"
{
  s390_compare_op0 = operands[0];
  s390_compare_op1 = operands[1];
  DONE;
})

(define_expand "cmpsi"
  [(set (reg:CC 33)
        (compare:CC (match_operand:SI 0 "register_operand" "")
                    (match_operand:SI 1 "general_operand" "")))]
  ""
{
  s390_compare_op0 = operands[0];
  s390_compare_op1 = operands[1];
  DONE;
})

(define_expand "cmpdf"
  [(set (reg:CC 33)
        (compare:CC (match_operand:DF 0 "register_operand" "")
                    (match_operand:DF 1 "general_operand" "")))]
  "TARGET_HARD_FLOAT"
{
  s390_compare_op0 = operands[0];
  s390_compare_op1 = operands[1];
  DONE;
})

(define_expand "cmpsf"
  [(set (reg:CC 33)
        (compare:CC (match_operand:SF 0 "register_operand" "")
                    (match_operand:SF 1 "general_operand" "")))]
  "TARGET_HARD_FLOAT"
{
  s390_compare_op0 = operands[0];
  s390_compare_op1 = operands[1];
  DONE;
})


; Test-under-Mask (zero_extract) instructions

(define_insn "*tmdi_ext"
  [(set (reg 33)
        (compare (zero_extract:DI (match_operand:DI 0 "register_operand" "d")
	                          (match_operand:DI 1 "const_int_operand" "n")
                                  (match_operand:DI 2 "const_int_operand" "n"))
                 (const_int 0)))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT
   && INTVAL (operands[1]) >= 1 && INTVAL (operands[2]) >= 0
   && INTVAL (operands[1]) + INTVAL (operands[2]) <= 64
   && (INTVAL (operands[1]) + INTVAL (operands[2]) - 1) >> 4
      == INTVAL (operands[2]) >> 4"
{
  int part = INTVAL (operands[2]) >> 4;
  int block = (1 << INTVAL (operands[1])) - 1;
  int shift = 16 - INTVAL (operands[1]) - (INTVAL (operands[2]) & 15);

  operands[2] = GEN_INT (block << shift);

  switch (part)
    {
      case 0: return "tmhh\t%0,%x2";
      case 1: return "tmhl\t%0,%x2";
      case 2: return "tmlh\t%0,%x2";
      case 3: return "tmll\t%0,%x2";
      default: abort ();
    }
}
  [(set_attr "op_type" "RI")])

(define_insn "*tmsi_ext"
  [(set (reg 33)
        (compare (zero_extract:SI (match_operand:SI 0 "register_operand" "d")
	                          (match_operand:SI 1 "const_int_operand" "n")
                                  (match_operand:SI 2 "const_int_operand" "n"))
                 (const_int 0)))]
  "s390_match_ccmode(insn, CCTmode)
   && INTVAL (operands[1]) >= 1 && INTVAL (operands[2]) >= 0
   && INTVAL (operands[1]) + INTVAL (operands[2]) <= 32
   && (INTVAL (operands[1]) + INTVAL (operands[2]) - 1) >> 4
      == INTVAL (operands[2]) >> 4"
{
  int part = INTVAL (operands[2]) >> 4;
  int block = (1 << INTVAL (operands[1])) - 1;
  int shift = 16 - INTVAL (operands[1]) - (INTVAL (operands[2]) & 15);

  operands[2] = GEN_INT (block << shift);

  switch (part)
    {
      case 0: return "tmh\t%0,%x2";
      case 1: return "tml\t%0,%x2";
      default: abort ();
    }
}
  [(set_attr "op_type" "RI")])

(define_insn "*tmqisi_ext"
  [(set (reg 33)
        (compare (zero_extract:SI (match_operand:QI 0 "memory_operand" "Q,S")
	                          (match_operand:SI 1 "const_int_operand" "n,n")
                                  (match_operand:SI 2 "const_int_operand" "n,n"))
                 (const_int 0)))]
  "!TARGET_64BIT && s390_match_ccmode(insn, CCTmode)
   && INTVAL (operands[1]) >= 1 && INTVAL (operands[2]) >= 0
   && INTVAL (operands[1]) + INTVAL (operands[2]) <= 8"
{
  int block = (1 << INTVAL (operands[1])) - 1;
  int shift = 8 - INTVAL (operands[1]) - INTVAL (operands[2]);

  operands[2] = GEN_INT (block << shift);
  return which_alternative == 0 ? "tm\t%0,%b2" : "tmy\t%0,%b2";
}
  [(set_attr "op_type" "SI,SIY")])

(define_insn "*tmqidi_ext"
  [(set (reg 33)
        (compare (zero_extract:DI (match_operand:QI 0 "memory_operand" "Q,S")
	                          (match_operand:SI 1 "const_int_operand" "n,n")
                                  (match_operand:SI 2 "const_int_operand" "n,n"))
                 (const_int 0)))]
  "TARGET_64BIT && s390_match_ccmode(insn, CCTmode)
   && INTVAL (operands[1]) >= 1 && INTVAL (operands[2]) >= 0
   && INTVAL (operands[1]) + INTVAL (operands[2]) <= 8"
{
  int block = (1 << INTVAL (operands[1])) - 1;
  int shift = 8 - INTVAL (operands[1]) - INTVAL (operands[2]);

  operands[2] = GEN_INT (block << shift);
  return which_alternative == 0 ? "tm\t%0,%b2" : "tmy\t%0,%b2";
}
  [(set_attr "op_type" "SI,SIY")])


; Test-under-Mask instructions

(define_insn "*tmdi_mem"
  [(set (reg 33)
        (compare (and:DI (match_operand:DI 0 "memory_operand" "Q,S")
                         (match_operand:DI 1 "immediate_operand" "n,n"))
                 (match_operand:DI 2 "immediate_operand" "n,n")))]
  "s390_match_ccmode (insn, s390_tm_ccmode (operands[1], operands[2], 0))
   && s390_single_part (operands[1], DImode, QImode, 0) >= 0"
{
  int part = s390_single_part (operands[1], DImode, QImode, 0);
  operands[1] = GEN_INT (s390_extract_part (operands[1], QImode, 0));

  operands[0] = gen_rtx_MEM (QImode,
			     plus_constant (XEXP (operands[0], 0), part));
  return which_alternative == 0 ? "tm\t%0,%b1" : "tmy\t%0,%b1";
}
  [(set_attr "op_type" "SI,SIY")])

(define_insn "*tmsi_mem"
  [(set (reg 33)
        (compare (and:SI (match_operand:SI 0 "memory_operand" "Q,S")
                         (match_operand:SI 1 "immediate_operand" "n,n"))
                 (match_operand:SI 2 "immediate_operand" "n,n")))]
  "s390_match_ccmode (insn, s390_tm_ccmode (operands[1], operands[2], 0))
   && s390_single_part (operands[1], SImode, QImode, 0) >= 0"
{
  int part = s390_single_part (operands[1], SImode, QImode, 0);
  operands[1] = GEN_INT (s390_extract_part (operands[1], QImode, 0));

  operands[0] = gen_rtx_MEM (QImode,
			     plus_constant (XEXP (operands[0], 0), part));
  return which_alternative == 0 ? "tm\t%0,%b1" : "tmy\t%0,%b1";
}
  [(set_attr "op_type" "SI")])

(define_insn "*tmhi_mem"
  [(set (reg 33)
        (compare (and:SI (subreg:SI (match_operand:HI 0 "memory_operand" "Q,S") 0)
                         (match_operand:SI 1 "immediate_operand" "n,n"))
                 (match_operand:SI 2 "immediate_operand" "n,n")))]
  "s390_match_ccmode (insn, s390_tm_ccmode (operands[1], operands[2], 0))
   && s390_single_part (operands[1], HImode, QImode, 0) >= 0"
{
  int part = s390_single_part (operands[1], HImode, QImode, 0);
  operands[1] = GEN_INT (s390_extract_part (operands[1], QImode, 0));

  operands[0] = gen_rtx_MEM (QImode,
			     plus_constant (XEXP (operands[0], 0), part));
  return which_alternative == 0 ? "tm\t%0,%b1" : "tmy\t%0,%b1";
}
  [(set_attr "op_type" "SI")])

(define_insn "*tmqi_mem"
  [(set (reg 33)
        (compare (and:SI (subreg:SI (match_operand:QI 0 "memory_operand" "Q,S") 0)
                         (match_operand:SI 1 "immediate_operand" "n,n"))
                 (match_operand:SI 2 "immediate_operand" "n,n")))]
  "s390_match_ccmode (insn, s390_tm_ccmode (operands[1], operands[2], 0))"
  "@
   tm\t%0,%b1
   tmy\t%0,%b1"
  [(set_attr "op_type" "SI,SIY")])

(define_insn "*tmdi_reg"
  [(set (reg 33)
        (compare (and:DI (match_operand:DI 0 "nonimmediate_operand" "d,d,d,d")
                         (match_operand:DI 1 "immediate_operand" 
					     "N0HD0,N1HD0,N2HD0,N3HD0"))
                 (match_operand:DI 2 "immediate_operand" "n,n,n,n")))]
  "TARGET_64BIT
   && s390_match_ccmode (insn, s390_tm_ccmode (operands[1], operands[2], 1))
   && s390_single_part (operands[1], DImode, HImode, 0) >= 0"
  "@
   tmhh\t%0,%i1
   tmhl\t%0,%i1
   tmlh\t%0,%i1
   tmll\t%0,%i1"
  [(set_attr "op_type" "RI")])

(define_insn "*tmsi_reg"
  [(set (reg 33)
        (compare (and:SI (match_operand:SI 0 "nonimmediate_operand" "d,d")
                         (match_operand:SI 1 "immediate_operand" "N0HS0,N1HS0"))
                 (match_operand:SI 2 "immediate_operand" "n,n")))]
  "s390_match_ccmode (insn, s390_tm_ccmode (operands[1], operands[2], 1))
   && s390_single_part (operands[1], SImode, HImode, 0) >= 0"
  "@
   tmh\t%0,%i1
   tml\t%0,%i1"
  [(set_attr "op_type" "RI")])

(define_insn "*tmhi_full"
  [(set (reg 33)
        (compare (match_operand:HI 0 "register_operand" "d")
                 (match_operand:HI 1 "immediate_operand" "n")))]
  "s390_match_ccmode (insn, s390_tm_ccmode (GEN_INT (-1), operands[1], 1))"
  "tml\t%0,65535"
  [(set_attr "op_type" "RX")])

(define_insn "*tmqi_full"
  [(set (reg 33)
        (compare (match_operand:QI 0 "register_operand" "d")
                 (match_operand:QI 1 "immediate_operand" "n")))]
  "s390_match_ccmode (insn, s390_tm_ccmode (GEN_INT (-1), operands[1], 1))"
  "tml\t%0,255"
  [(set_attr "op_type" "RI")])


; Load-and-Test instructions

(define_insn "*tstdi_sign"
  [(set (reg 33)
        (compare (ashiftrt:DI (ashift:DI (subreg:DI (match_operand:SI 0 "register_operand" "d") 0)
					 (const_int 32)) (const_int 32))
                 (match_operand:DI 1 "const0_operand" "")))
   (set (match_operand:DI 2 "register_operand" "=d")
        (sign_extend:DI (match_dup 0)))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_64BIT"
  "ltgfr\t%2,%0"
  [(set_attr "op_type" "RRE")])

(define_insn "*tstdi"
  [(set (reg 33)
        (compare (match_operand:DI 0 "register_operand" "d")
                 (match_operand:DI 1 "const0_operand" "")))
   (set (match_operand:DI 2 "register_operand" "=d")
        (match_dup 0))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_64BIT"
  "ltgr\t%2,%0"
  [(set_attr "op_type" "RRE")])

(define_insn "*tstdi_cconly"
  [(set (reg 33)
        (compare (match_operand:DI 0 "register_operand" "d")
                 (match_operand:DI 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_64BIT"
  "ltgr\t%0,%0"
  [(set_attr "op_type" "RRE")])

(define_insn "*tstdi_cconly_31"
  [(set (reg 33)
        (compare (match_operand:DI 0 "register_operand" "d")
                 (match_operand:DI 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCSmode) && !TARGET_64BIT"
  "srda\t%0,0"
  [(set_attr "op_type" "RS")
   (set_attr "atype"   "reg")])


(define_insn "*tstsi"
  [(set (reg 33)
        (compare (match_operand:SI 0 "nonimmediate_operand" "d,Q,S")
                 (match_operand:SI 1 "const0_operand" "")))
   (set (match_operand:SI 2 "register_operand" "=d,d,d")
        (match_dup 0))]
  "s390_match_ccmode(insn, CCSmode)"
  "@
   ltr\t%2,%0
   icm\t%2,15,%0
   icmy\t%2,15,%0"
  [(set_attr "op_type" "RR,RS,RSY")])

(define_insn "*tstsi_cconly"
  [(set (reg 33)
        (compare (match_operand:SI 0 "nonimmediate_operand" "d,Q,S")
                 (match_operand:SI 1 "const0_operand" "")))
   (clobber (match_scratch:SI 2 "=X,d,d"))]
  "s390_match_ccmode(insn, CCSmode)"
  "@
   ltr\t%0,%0
   icm\t%2,15,%0
   icmy\t%2,15,%0"
  [(set_attr "op_type" "RR,RS,RSY")])

(define_insn "*tstsi_cconly2"
  [(set (reg 33)
        (compare (match_operand:SI 0 "register_operand" "d")
                 (match_operand:SI 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCSmode)"
  "ltr\t%0,%0"
  [(set_attr "op_type" "RR")])

(define_insn "*tsthiCCT"
  [(set (reg 33)
        (compare (match_operand:HI 0 "nonimmediate_operand" "?Q,?S,d")
                 (match_operand:HI 1 "const0_operand" "")))
   (set (match_operand:HI 2 "register_operand" "=d,d,0")
        (match_dup 0))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   icm\t%2,3,%0
   icmy\t%2,3,%0
   tml\t%0,65535"
  [(set_attr "op_type" "RS,RSY,RI")])

(define_insn "*tsthiCCT_cconly"
  [(set (reg 33)
        (compare (match_operand:HI 0 "nonimmediate_operand" "Q,S,d")
                 (match_operand:HI 1 "const0_operand" "")))
   (clobber (match_scratch:HI 2 "=d,d,X"))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   icm\t%2,3,%0
   icmy\t%2,3,%0
   tml\t%0,65535"
  [(set_attr "op_type" "RS,RSY,RI")])

(define_insn "*tsthi"
  [(set (reg 33)
        (compare (match_operand:HI 0 "s_operand" "Q,S")
                 (match_operand:HI 1 "const0_operand" "")))
   (set (match_operand:HI 2 "register_operand" "=d,d")
        (match_dup 0))]
  "s390_match_ccmode(insn, CCSmode)"
  "@
   icm\t%2,3,%0
   icmy\t%2,3,%0"
  [(set_attr "op_type" "RS,RSY")])

(define_insn "*tsthi_cconly"
  [(set (reg 33)
        (compare (match_operand:HI 0 "s_operand" "Q,S")
                 (match_operand:HI 1 "const0_operand" "")))
   (clobber (match_scratch:HI 2 "=d,d"))]
  "s390_match_ccmode(insn, CCSmode)"
  "@
   icm\t%2,3,%0
   icmy\t%2,3,%0"
  [(set_attr "op_type" "RS,RSY")])

(define_insn "*tstqiCCT"
  [(set (reg 33)
        (compare (match_operand:QI 0 "nonimmediate_operand" "?Q,?S,d")
                 (match_operand:QI 1 "const0_operand" "")))
   (set (match_operand:QI 2 "register_operand" "=d,d,0")
        (match_dup 0))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   icm\t%2,1,%0
   icmy\t%2,1,%0
   tml\t%0,255"
  [(set_attr "op_type" "RS,RSY,RI")])

(define_insn "*tstqiCCT_cconly"
  [(set (reg 33)
        (compare (match_operand:QI 0 "nonimmediate_operand" "?Q,?S,d")
                 (match_operand:QI 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   cli\t%0,0
   cliy\t%0,0
   tml\t%0,255"
  [(set_attr "op_type" "SI,SIY,RI")])

(define_insn "*tstqi"
  [(set (reg 33)
        (compare (match_operand:QI 0 "s_operand" "Q,S")
                 (match_operand:QI 1 "const0_operand" "")))
   (set (match_operand:QI 2 "register_operand" "=d,d")
        (match_dup 0))]
  "s390_match_ccmode(insn, CCSmode)"
  "@
   icm\t%2,1,%0
   icmy\t%2,1,%0"
  [(set_attr "op_type" "RS,RSY")])

(define_insn "*tstqi_cconly"
  [(set (reg 33)
        (compare (match_operand:QI 0 "s_operand" "Q,S")
                 (match_operand:QI 1 "const0_operand" "")))
   (clobber (match_scratch:QI 2 "=d,d"))]
  "s390_match_ccmode(insn, CCSmode)"
  "@
   icm\t%2,1,%0
   icmy\t%2,1,%0"
  [(set_attr "op_type" "RS,RSY")])


; Compare (signed) instructions

(define_insn "*cmpdi_ccs_sign"
  [(set (reg 33)
        (compare (sign_extend:DI (match_operand:SI 1 "nonimmediate_operand" "d,m"))
                 (match_operand:DI 0 "register_operand" "d,d")))]
  "s390_match_ccmode(insn, CCSRmode) && TARGET_64BIT"
  "@
   cgfr\t%0,%1
   cgf\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

(define_insn "*cmpdi_ccs"
  [(set (reg 33)
        (compare (match_operand:DI 0 "register_operand" "d,d,d")
                 (match_operand:DI 1 "general_operand" "d,K,m")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_64BIT"
  "@
   cgr\t%0,%1
   cghi\t%0,%c1
   cg\t%0,%1"
  [(set_attr "op_type" "RRE,RI,RXY")])

(define_insn "*cmpsi_ccs_sign"
  [(set (reg 33)
        (compare (sign_extend:SI (match_operand:HI 1 "memory_operand" "R,T"))
                 (match_operand:SI 0 "register_operand" "d,d")))]
  "s390_match_ccmode(insn, CCSRmode)"
  "@
   ch\t%0,%1
   chy\t%0,%1"
  [(set_attr "op_type" "RX,RXY")])

(define_insn "*cmpsi_ccs"
  [(set (reg 33)
        (compare (match_operand:SI 0 "register_operand" "d,d,d,d")
                 (match_operand:SI 1 "general_operand" "d,K,R,T")))]
  "s390_match_ccmode(insn, CCSmode)"
  "@
   cr\t%0,%1
   chi\t%0,%c1
   c\t%0,%1
   cy\t%0,%1"
  [(set_attr "op_type" "RR,RI,RX,RXY")])


; Compare (unsigned) instructions

(define_insn "*cmpdi_ccu_zero"
  [(set (reg 33)
        (compare (zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "d,m"))
                 (match_operand:DI 0 "register_operand" "d,d")))]
  "s390_match_ccmode(insn, CCURmode) && TARGET_64BIT"
  "@
   clgfr\t%0,%1
   clgf\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

(define_insn "*cmpdi_ccu"
  [(set (reg 33)
        (compare (match_operand:DI 0 "register_operand" "d,d")
                 (match_operand:DI 1 "general_operand" "d,m")))]
  "s390_match_ccmode(insn, CCUmode) && TARGET_64BIT"
  "@
   clgr\t%0,%1
   clg\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

(define_insn "*cmpsi_ccu"
  [(set (reg 33)
        (compare (match_operand:SI 0 "register_operand" "d,d,d")
                 (match_operand:SI 1 "general_operand" "d,R,T")))]
  "s390_match_ccmode(insn, CCUmode)"
  "@
   clr\t%0,%1
   cl\t%0,%1
   cly\t%0,%1"
  [(set_attr "op_type" "RR,RX,RXY")])

(define_insn "*cmphi_ccu"
  [(set (reg 33)
        (compare (match_operand:HI 0 "register_operand" "d,d")
                 (match_operand:HI 1 "s_imm_operand" "Q,S")))]
  "s390_match_ccmode(insn, CCUmode)"
  "@
   clm\t%0,3,%1
   clmy\t%0,3,%1"
  [(set_attr "op_type" "RS,RSY")])

(define_insn "*cmpqi_ccu"
  [(set (reg 33)
        (compare (match_operand:QI 0 "register_operand" "d,d")
                 (match_operand:QI 1 "s_imm_operand" "Q,S")))]
  "s390_match_ccmode(insn, CCUmode)"
  "@
   clm\t%0,1,%1
   clmy\t%0,1,%1"
  [(set_attr "op_type" "RS,RSY")])

(define_insn "*cli"
  [(set (reg 33)
        (compare (match_operand:QI 0 "memory_operand" "Q,S")
                 (match_operand:QI 1 "immediate_operand" "n,n")))]
  "s390_match_ccmode (insn, CCUmode)"
  "@
   cli\t%0,%b1
   cliy\t%0,%b1"
  [(set_attr "op_type" "SI,SIY")])

(define_insn "*cmpdi_ccu_mem"
  [(set (reg 33)
        (compare (match_operand:DI 0 "s_operand" "Q")
                 (match_operand:DI 1 "s_imm_operand" "Q")))]
  "s390_match_ccmode(insn, CCUmode)"
  "clc\t%O0(8,%R0),%1"
  [(set_attr "op_type" "SS")])

(define_insn "*cmpsi_ccu_mem"
  [(set (reg 33)
        (compare (match_operand:SI 0 "s_operand" "Q")
                 (match_operand:SI 1 "s_imm_operand" "Q")))]
  "s390_match_ccmode(insn, CCUmode)"
  "clc\t%O0(4,%R0),%1"
   [(set_attr "op_type" "SS")])

(define_insn "*cmphi_ccu_mem"
  [(set (reg 33)
        (compare (match_operand:HI 0 "s_operand" "Q")
                 (match_operand:HI 1 "s_imm_operand" "Q")))]
  "s390_match_ccmode(insn, CCUmode)"
  "clc\t%O0(2,%R0),%1"
  [(set_attr "op_type" "SS")])

(define_insn "*cmpqi_ccu_mem"
  [(set (reg 33)
        (compare (match_operand:QI 0 "s_operand" "Q")
                 (match_operand:QI 1 "s_imm_operand" "Q")))]
  "s390_match_ccmode(insn, CCUmode)"
  "clc\t%O0(1,%R0),%1"
  [(set_attr "op_type" "SS")])


; DF instructions

(define_insn "*cmpdf_ccs_0"
  [(set (reg 33)
        (compare (match_operand:DF 0 "register_operand" "f")
                 (match_operand:DF 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "ltdbr\t%0,%0"
   [(set_attr "op_type" "RRE")
    (set_attr "type"  "fsimpd")])

(define_insn "*cmpdf_ccs_0_ibm"
  [(set (reg 33)
        (compare (match_operand:DF 0 "register_operand" "f")
                 (match_operand:DF 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "ltdr\t%0,%0"
   [(set_attr "op_type" "RR")
    (set_attr "type"  "fsimpd")])

(define_insn "*cmpdf_ccs"
  [(set (reg 33)
        (compare (match_operand:DF 0 "register_operand" "f,f")
                 (match_operand:DF 1 "general_operand" "f,R")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   cdbr\t%0,%1
   cdb\t%0,%1"
   [(set_attr "op_type" "RRE,RXE")
    (set_attr "type"  "fsimpd")])

(define_insn "*cmpdf_ccs_ibm"
  [(set (reg 33)
        (compare (match_operand:DF 0 "register_operand" "f,f")
                 (match_operand:DF 1 "general_operand" "f,R")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   cdr\t%0,%1
   cd\t%0,%1"
   [(set_attr "op_type" "RR,RX")
    (set_attr "type"  "fsimpd")])


; SF instructions

(define_insn "*cmpsf_ccs_0"
  [(set (reg 33)
        (compare (match_operand:SF 0 "register_operand" "f")
                 (match_operand:SF 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "ltebr\t%0,%0"
   [(set_attr "op_type" "RRE")
    (set_attr "type"  "fsimps")])

(define_insn "*cmpsf_ccs_0_ibm"
  [(set (reg 33)
        (compare (match_operand:SF 0 "register_operand" "f")
                 (match_operand:SF 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "lter\t%0,%0"
   [(set_attr "op_type" "RR")
    (set_attr "type"  "fsimps")])

(define_insn "*cmpsf_ccs"
  [(set (reg 33)
        (compare (match_operand:SF 0 "register_operand" "f,f")
                 (match_operand:SF 1 "general_operand" "f,R")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   cebr\t%0,%1
   ceb\t%0,%1"
   [(set_attr "op_type" "RRE,RXE")
    (set_attr "type"  "fsimps")])

(define_insn "*cmpsf_ccs"
  [(set (reg 33)
        (compare (match_operand:SF 0 "register_operand" "f,f")
                 (match_operand:SF 1 "general_operand" "f,R")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   cer\t%0,%1
   ce\t%0,%1"
   [(set_attr "op_type" "RR,RX")
    (set_attr "type"  "fsimps")])


;;
;;- Move instructions.
;;

;
; movti instruction pattern(s).
;

(define_insn "movti"
  [(set (match_operand:TI 0 "nonimmediate_operand" "=d,QS,d,o,Q")
        (match_operand:TI 1 "general_operand" "QS,d,dKm,d,Q"))]
  "TARGET_64BIT"
  "@
   lmg\t%0,%N0,%1
   stmg\t%1,%N1,%0
   #
   #
   mvc\t%O0(16,%R0),%1"
  [(set_attr "op_type" "RSY,RSY,NN,NN,SS")
   (set_attr "type" "lm,stm,*,*,cs")])

(define_split
  [(set (match_operand:TI 0 "nonimmediate_operand" "")
        (match_operand:TI 1 "general_operand" ""))]
  "TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], TImode, 0)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 0, 0, TImode);
  operands[3] = operand_subword (operands[0], 1, 0, TImode);
  operands[4] = operand_subword (operands[1], 0, 0, TImode);
  operands[5] = operand_subword (operands[1], 1, 0, TImode);
})

(define_split
  [(set (match_operand:TI 0 "nonimmediate_operand" "")
        (match_operand:TI 1 "general_operand" ""))]
  "TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], TImode, 1)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 1, 0, TImode);
  operands[3] = operand_subword (operands[0], 0, 0, TImode);
  operands[4] = operand_subword (operands[1], 1, 0, TImode);
  operands[5] = operand_subword (operands[1], 0, 0, TImode);
})

(define_split
  [(set (match_operand:TI 0 "register_operand" "")
        (match_operand:TI 1 "memory_operand" ""))]
  "TARGET_64BIT && reload_completed
   && !s_operand (operands[1], VOIDmode)"
  [(set (match_dup 0) (match_dup 1))]
{
  rtx addr = operand_subword (operands[0], 1, 0, TImode);
  s390_load_address (addr, XEXP (operands[1], 0));
  operands[1] = replace_equiv_address (operands[1], addr);
})

(define_expand "reload_outti"
  [(parallel [(match_operand:TI 0 "memory_operand" "")
              (match_operand:TI 1 "register_operand" "d")
              (match_operand:DI 2 "register_operand" "=&a")])]
  "TARGET_64BIT"
{
  s390_load_address (operands[2], XEXP (operands[0], 0));
  operands[0] = replace_equiv_address (operands[0], operands[2]);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

;
; movdi instruction pattern(s).
;

(define_expand "movdi"
  [(set (match_operand:DI 0 "general_operand" "")
        (match_operand:DI 1 "general_operand" ""))]
  ""
{
  /* Handle symbolic constants.  */
  if (TARGET_64BIT && SYMBOLIC_CONST (operands[1]))
    emit_symbolic_move (operands);

  /* During and after reload, we need to force constants
     to the literal pool ourselves, if necessary.  */
  if ((reload_in_progress || reload_completed)
      && CONSTANT_P (operands[1])
      && (!legitimate_reload_constant_p (operands[1])
          || FP_REG_P (operands[0])))
    operands[1] = force_const_mem (DImode, operands[1]);
})

(define_insn "*movdi_larl"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (match_operand:DI 1 "larl_operand" "X"))]
  "TARGET_64BIT
   && !FP_REG_P (operands[0])"
  "larl\t%0,%1"
   [(set_attr "op_type" "RIL")
    (set_attr "type"    "larl")])

(define_insn "*movdi_64"
  [(set (match_operand:DI 0 "nonimmediate_operand" 
                            "=d,d,d,d,d,d,d,d,m,!*f,!*f,!*f,!R,!T,?Q")
        (match_operand:DI 1 "general_operand" 
                            "K,N0HD0,N1HD0,N2HD0,N3HD0,L,d,m,d,*f,R,T,*f,*f,?Q"))]
  "TARGET_64BIT"
  "@
   lghi\t%0,%h1
   llihh\t%0,%i1
   llihl\t%0,%i1
   llilh\t%0,%i1
   llill\t%0,%i1
   lay\t%0,%a1
   lgr\t%0,%1
   lg\t%0,%1
   stg\t%1,%0
   ldr\t%0,%1
   ld\t%0,%1
   ldy\t%0,%1
   std\t%1,%0
   stdy\t%1,%0
   mvc\t%O0(8,%R0),%1"
  [(set_attr "op_type" "RI,RI,RI,RI,RI,RXY,RRE,RXY,RXY,RR,RX,RXY,RX,RXY,SS")
   (set_attr "type" "*,*,*,*,*,la,lr,load,store,floadd,floadd,floadd,
                     fstored,fstored,cs")])

(define_insn "*movdi_31"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=d,Q,d,o,!*f,!*f,!*f,!R,!T,Q")
        (match_operand:DI 1 "general_operand" "Q,d,dKm,d,*f,R,T,*f,*f,Q"))]
  "!TARGET_64BIT"
  "@
   lm\t%0,%N0,%1
   stm\t%1,%N1,%0
   #
   #
   ldr\t%0,%1
   ld\t%0,%1
   ldy\t%0,%1
   std\t%1,%0
   stdy\t%1,%0
   mvc\t%O0(8,%R0),%1"
  [(set_attr "op_type" "RS,RS,NN,NN,RR,RX,RXY,RX,RXY,SS")
   (set_attr "type" "lm,stm,*,*,floadd,floadd,floadd,fstored,fstored,cs")])

(define_split
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (match_operand:DI 1 "general_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], DImode, 0)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 0, 0, DImode);
  operands[3] = operand_subword (operands[0], 1, 0, DImode);
  operands[4] = operand_subword (operands[1], 0, 0, DImode);
  operands[5] = operand_subword (operands[1], 1, 0, DImode);
})

(define_split
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (match_operand:DI 1 "general_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], DImode, 1)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 1, 0, DImode);
  operands[3] = operand_subword (operands[0], 0, 0, DImode);
  operands[4] = operand_subword (operands[1], 1, 0, DImode);
  operands[5] = operand_subword (operands[1], 0, 0, DImode);
})

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
        (match_operand:DI 1 "memory_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && !FP_REG_P (operands[0])
   && !s_operand (operands[1], VOIDmode)"
  [(set (match_dup 0) (match_dup 1))]
{
  rtx addr = operand_subword (operands[0], 1, 0, DImode);
  s390_load_address (addr, XEXP (operands[1], 0));
  operands[1] = replace_equiv_address (operands[1], addr);
})

(define_expand "reload_outdi"
  [(parallel [(match_operand:DI 0 "memory_operand" "")
              (match_operand:DI 1 "register_operand" "d")
              (match_operand:SI 2 "register_operand" "=&a")])]
  "!TARGET_64BIT"
{
  s390_load_address (operands[2], XEXP (operands[0], 0));
  operands[0] = replace_equiv_address (operands[0], operands[2]);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

(define_peephole2
  [(set (match_operand:DI 0 "register_operand" "")
        (mem:DI (match_operand 1 "address_operand" "")))]
  "TARGET_64BIT
   && !FP_REG_P (operands[0])
   && GET_CODE (operands[1]) == SYMBOL_REF
   && CONSTANT_POOL_ADDRESS_P (operands[1])
   && get_pool_mode (operands[1]) == DImode
   && legitimate_reload_constant_p (get_pool_constant (operands[1]))"
  [(set (match_dup 0) (match_dup 2))]
  "operands[2] = get_pool_constant (operands[1]);")

(define_insn "*la_64"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (match_operand:QI 1 "address_operand" "U,W"))]
  "TARGET_64BIT"
  "@
   la\t%0,%a1
   lay\t%0,%a1"
  [(set_attr "op_type" "RX,RXY")
   (set_attr "type"    "la")])

(define_peephole2
  [(parallel
    [(set (match_operand:DI 0 "register_operand" "")
          (match_operand:QI 1 "address_operand" ""))
     (clobber (reg:CC 33))])]
  "TARGET_64BIT
   && strict_memory_address_p (VOIDmode, operands[1])
   && preferred_la_operand_p (operands[1])"
  [(set (match_dup 0) (match_dup 1))]
  "")

(define_peephole2
  [(set (match_operand:DI 0 "register_operand" "")
        (match_operand:DI 1 "register_operand" ""))
   (parallel
    [(set (match_dup 0)
          (plus:DI (match_dup 0)
                   (match_operand:DI 2 "nonmemory_operand" "")))
     (clobber (reg:CC 33))])]
  "TARGET_64BIT
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && strict_memory_address_p (VOIDmode, gen_rtx_PLUS (DImode, operands[1], operands[2]))
   && preferred_la_operand_p (gen_rtx_PLUS (DImode, operands[1], operands[2]))"
  [(set (match_dup 0) (plus:DI (match_dup 1) (match_dup 2)))]
  "")

(define_expand "reload_indi"
  [(parallel [(match_operand:DI 0 "register_operand" "=a")
              (match_operand:DI 1 "s390_plus_operand" "")
              (match_operand:DI 2 "register_operand" "=&a")])]
  "TARGET_64BIT"
{
  s390_expand_plus_operand (operands[0], operands[1], operands[2]);
  DONE;
})

;
; movsi instruction pattern(s).
;

(define_expand "movsi"
  [(set (match_operand:SI 0 "general_operand" "")
        (match_operand:SI 1 "general_operand" ""))]
  ""
{
  /* Handle symbolic constants.  */
  if (!TARGET_64BIT && SYMBOLIC_CONST (operands[1]))
    emit_symbolic_move (operands);

  /* expr.c tries to load an effective address using
     force_reg.  This fails because we don't have a
     generic load_address pattern.  Convert the move
     to a proper arithmetic operation instead, unless
     it is guaranteed to be OK.  */
  if (GET_CODE (operands[1]) == PLUS
      && !legitimate_la_operand_p (operands[1]))
    {
      operands[1] = force_operand (operands[1], operands[0]);
      if (operands[1] == operands[0])
        DONE;
    }

  /* During and after reload, we need to force constants
     to the literal pool ourselves, if necessary.  */
  if ((reload_in_progress || reload_completed)
      && CONSTANT_P (operands[1])
      && (!legitimate_reload_constant_p (operands[1])
          || FP_REG_P (operands[0])))
    operands[1] = force_const_mem (SImode, operands[1]);
})

(define_insn "*movsi_larl"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (match_operand:SI 1 "larl_operand" "X"))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH
   && !FP_REG_P (operands[0])"
  "larl\t%0,%1"
   [(set_attr "op_type" "RIL")
    (set_attr "type"    "larl")])

(define_insn "*movsi_zarch"
  [(set (match_operand:SI 0 "nonimmediate_operand" 
                            "=d,d,d,d,d,d,d,R,T,!*f,!*f,!*f,!R,!T,?Q")
        (match_operand:SI 1 "general_operand" 
                            "K,N0HS0,N1HS0,L,d,R,T,d,d,*f,R,T,*f,*f,?Q"))]
  "TARGET_ZARCH"
  "@
   lhi\t%0,%h1
   llilh\t%0,%i1
   llill\t%0,%i1
   lay\t%0,%a1
   lr\t%0,%1
   l\t%0,%1
   ly\t%0,%1
   st\t%1,%0
   sty\t%1,%0
   ler\t%0,%1
   le\t%0,%1
   ley\t%0,%1
   ste\t%1,%0
   stey\t%1,%0
   mvc\t%O0(4,%R0),%1"
  [(set_attr "op_type" "RI,RI,RI,RXY,RR,RX,RXY,RX,RXY,RR,RX,RXY,RX,RXY,SS")
   (set_attr "type" "*,*,*,la,lr,load,load,store,store,floads,floads,floads,fstores,fstores,cs")])

(define_insn "*movsi_esa"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=d,d,d,R,!*f,!*f,!R,?Q")
        (match_operand:SI 1 "general_operand" "K,d,R,d,*f,R,*f,?Q"))]
  "!TARGET_ZARCH"
  "@
   lhi\t%0,%h1
   lr\t%0,%1
   l\t%0,%1
   st\t%1,%0
   ler\t%0,%1
   le\t%0,%1
   ste\t%1,%0
   mvc\t%O0(4,%R0),%1"
  [(set_attr "op_type" "RI,RR,RX,RX,RR,RX,RX,SS")
   (set_attr "type" "*,lr,load,store,floads,floads,fstores,cs")])

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
        (mem:SI (match_operand 1 "address_operand" "")))]
  "!FP_REG_P (operands[0])
   && GET_CODE (operands[1]) == SYMBOL_REF
   && CONSTANT_POOL_ADDRESS_P (operands[1])
   && get_pool_mode (operands[1]) == SImode
   && legitimate_reload_constant_p (get_pool_constant (operands[1]))"
  [(set (match_dup 0) (match_dup 2))]
  "operands[2] = get_pool_constant (operands[1]);")

(define_insn "*la_31"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (match_operand:QI 1 "address_operand" "U,W"))]
  "!TARGET_64BIT && legitimate_la_operand_p (operands[1])"
  "@
   la\t%0,%a1
   lay\t%0,%a1"
  [(set_attr "op_type"  "RX,RXY")
   (set_attr "type"     "la")])

(define_peephole2
  [(parallel
    [(set (match_operand:SI 0 "register_operand" "")
          (match_operand:QI 1 "address_operand" ""))
     (clobber (reg:CC 33))])]
  "!TARGET_64BIT
   && strict_memory_address_p (VOIDmode, operands[1])
   && preferred_la_operand_p (operands[1])"
  [(set (match_dup 0) (match_dup 1))]
  "")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
        (match_operand:SI 1 "register_operand" ""))
   (parallel
    [(set (match_dup 0)
          (plus:SI (match_dup 0)
                   (match_operand:SI 2 "nonmemory_operand" "")))
     (clobber (reg:CC 33))])]
  "!TARGET_64BIT
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && strict_memory_address_p (VOIDmode, gen_rtx_PLUS (SImode, operands[1], operands[2]))
   && preferred_la_operand_p (gen_rtx_PLUS (SImode, operands[1], operands[2]))"
  [(set (match_dup 0) (plus:SI (match_dup 1) (match_dup 2)))]
  "")

(define_insn "*la_31_and"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (and:SI (match_operand:QI 1 "address_operand" "U,W")
                (const_int 2147483647)))]
  "!TARGET_64BIT"
  "@
   la\t%0,%a1
   lay\t%0,%a1"
  [(set_attr "op_type"  "RX,RXY")
   (set_attr "type"     "la")])

(define_insn_and_split "*la_31_and_cc"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (and:SI (match_operand:QI 1 "address_operand" "p")
                (const_int 2147483647)))
   (clobber (reg:CC 33))]
  "!TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
        (and:SI (match_dup 1) (const_int 2147483647)))]
  ""
  [(set_attr "op_type"  "RX")
   (set_attr "type"     "la")])

(define_insn "force_la_31"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (match_operand:QI 1 "address_operand" "U,W"))
   (use (const_int 0))]
  "!TARGET_64BIT"
  "@
   la\t%0,%a1
   lay\t%0,%a1"
  [(set_attr "op_type"  "RX")
   (set_attr "type"     "la")])

(define_expand "reload_insi"
  [(parallel [(match_operand:SI 0 "register_operand" "=a")
              (match_operand:SI 1 "s390_plus_operand" "")
              (match_operand:SI 2 "register_operand" "=&a")])]
  "!TARGET_64BIT"
{
  s390_expand_plus_operand (operands[0], operands[1], operands[2]);
  DONE;
})

;
; movhi instruction pattern(s).
;

(define_expand "movhi"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
        (match_operand:HI 1 "general_operand" ""))]
  ""
{
  /* Make it explicit that loading a register from memory 
     always sign-extends (at least) to SImode.  */
  if (optimize && !no_new_pseudos
      && register_operand (operands[0], VOIDmode)
      && GET_CODE (operands[1]) == MEM
      && GET_CODE (XEXP (operands[1], 0)) != ADDRESSOF)
    {
      rtx tmp = gen_reg_rtx (SImode);
      rtx ext = gen_rtx_SIGN_EXTEND (SImode, operands[1]);
      emit_insn (gen_rtx_SET (VOIDmode, tmp, ext));
      operands[1] = gen_lowpart (HImode, tmp);
    }
})

(define_insn "*movhi"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=d,d,d,d,R,T,?Q")
        (match_operand:HI 1 "general_operand" "d,n,R,T,d,d,?Q"))]
  ""
  "@
   lr\t%0,%1
   lhi\t%0,%h1
   lh\t%0,%1
   lhy\t%0,%1
   sth\t%1,%0
   sthy\t%1,%0
   mvc\t%O0(2,%R0),%1"
  [(set_attr "op_type" "RR,RI,RX,RXY,RX,RXY,SS")
   (set_attr "type" "lr,*,*,*,store,store,cs")])

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "")
        (mem:HI (match_operand 1 "address_operand" "")))]
  "GET_CODE (operands[1]) == SYMBOL_REF
   && CONSTANT_POOL_ADDRESS_P (operands[1])
   && get_pool_mode (operands[1]) == HImode
   && GET_CODE (get_pool_constant (operands[1])) == CONST_INT"
  [(set (match_dup 0) (match_dup 2))]
  "operands[2] = get_pool_constant (operands[1]);")

;
; movqi instruction pattern(s).
;

(define_expand "movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
        (match_operand:QI 1 "general_operand" ""))]
  ""
{
  /* On z/Architecture, zero-extending from memory to register
     is just as fast as a QImode load.  */
  if (TARGET_ZARCH && optimize && !no_new_pseudos
      && register_operand (operands[0], VOIDmode)
      && GET_CODE (operands[1]) == MEM
      && GET_CODE (XEXP (operands[1], 0)) != ADDRESSOF)
    {
      rtx tmp = gen_reg_rtx (word_mode);
      rtx ext = gen_rtx_ZERO_EXTEND (word_mode, operands[1]);
      emit_insn (gen_rtx_SET (VOIDmode, tmp, ext));
      operands[1] = gen_lowpart (QImode, tmp);
    }
})

(define_insn "*movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=d,d,d,d,R,T,Q,S,?Q")
        (match_operand:QI 1 "general_operand" "d,n,R,T,d,d,n,n,?Q"))]
  ""
  "@
   lr\t%0,%1
   lhi\t%0,%b1
   ic\t%0,%1
   icy\t%0,%1
   stc\t%1,%0
   stcy\t%1,%0
   mvi\t%0,%b1
   mviy\t%0,%b1
   mvc\t%O0(1,%R0),%1"
  [(set_attr "op_type" "RR,RI,RX,RXY,RX,RXY,SI,SIY,SS")
   (set_attr "type" "lr,*,*,*,store,store,store,store,cs")])

(define_peephole2
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
        (mem:QI (match_operand 1 "address_operand" "")))]
  "GET_CODE (operands[1]) == SYMBOL_REF
   && CONSTANT_POOL_ADDRESS_P (operands[1])
   && get_pool_mode (operands[1]) == QImode
   && GET_CODE (get_pool_constant (operands[1])) == CONST_INT"
  [(set (match_dup 0) (match_dup 2))]
  "operands[2] = get_pool_constant (operands[1]);")

;
; movstrictqi instruction pattern(s).
;

(define_insn "*movstrictqi"
  [(set (strict_low_part (match_operand:QI 0 "register_operand" "+d,d"))
                         (match_operand:QI 1 "memory_operand" "R,T"))]
  ""
  "@
   ic\t%0,%1
   icy\t%0,%1"
  [(set_attr "op_type"  "RX,RXY")])

;
; movstricthi instruction pattern(s).
;

(define_insn "*movstricthi"
  [(set (strict_low_part (match_operand:HI 0 "register_operand" "+d,d"))
                         (match_operand:HI 1 "s_imm_operand" "Q,S"))
   (clobber (reg:CC 33))]
  ""
  "@
   icm\t%0,3,%1
   icmy\t%0,3,%1"
  [(set_attr "op_type" "RS,RSY")])

;
; movstrictsi instruction pattern(s).
;

(define_insn "movstrictsi"
  [(set (strict_low_part (match_operand:SI 0 "register_operand" "+d,d,d"))
                         (match_operand:SI 1 "general_operand" "d,R,T"))]
  "TARGET_64BIT"
  "@
   lr\t%0,%1
   l\t%0,%1
   ly\t%0,%1"
  [(set_attr "op_type" "RR,RX,RXY")
   (set_attr "type" "lr,load,load")])

;
; movdf instruction pattern(s).
;

(define_expand "movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
        (match_operand:DF 1 "general_operand"  ""))]
  ""
{
  /* During and after reload, we need to force constants
     to the literal pool ourselves, if necessary.  */
  if ((reload_in_progress || reload_completed)
      && CONSTANT_P (operands[1]))
    operands[1] = force_const_mem (DFmode, operands[1]);
})

(define_insn "*movdf_64"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f,f,f,R,T,d,d,m,?Q")
        (match_operand:DF 1 "general_operand" "f,R,T,f,f,d,m,d,?Q"))]
  "TARGET_64BIT"
  "@
   ldr\t%0,%1
   ld\t%0,%1
   ldy\t%0,%1
   std\t%1,%0
   stdy\t%1,%0
   lgr\t%0,%1
   lg\t%0,%1
   stg\t%1,%0
   mvc\t%O0(8,%R0),%1"
  [(set_attr "op_type" "RR,RX,RXY,RX,RXY,RRE,RXY,RXY,SS")
   (set_attr "type" "floadd,floadd,floadd,fstored,fstored,lr,load,store,cs")])

(define_insn "*movdf_31"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f,f,f,R,T,d,Q,d,o,Q")
        (match_operand:DF 1 "general_operand" "f,R,T,f,f,Q,d,dKm,d,Q"))]
  "!TARGET_64BIT"
  "@
   ldr\t%0,%1
   ld\t%0,%1
   ldy\t%0,%1
   std\t%1,%0
   stdy\t%1,%0
   lm\t%0,%N0,%1
   stm\t%1,%N1,%0
   #
   #
   mvc\t%O0(8,%R0),%1"
  [(set_attr "op_type" "RR,RX,RXY,RX,RXY,RS,RS,NN,NN,SS")
   (set_attr "type" "floadd,floadd,floadd,fstored,fstored,lm,stm,*,*,cs")])

(define_split
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
        (match_operand:DF 1 "general_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], DFmode, 0)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 0, 0, DFmode);
  operands[3] = operand_subword (operands[0], 1, 0, DFmode);
  operands[4] = operand_subword (operands[1], 0, 0, DFmode);
  operands[5] = operand_subword (operands[1], 1, 0, DFmode);
})

(define_split
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
        (match_operand:DF 1 "general_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], DFmode, 1)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 1, 0, DFmode);
  operands[3] = operand_subword (operands[0], 0, 0, DFmode);
  operands[4] = operand_subword (operands[1], 1, 0, DFmode);
  operands[5] = operand_subword (operands[1], 0, 0, DFmode);
})

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
        (match_operand:DF 1 "memory_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && !FP_REG_P (operands[0])
   && !s_operand (operands[1], VOIDmode)"
  [(set (match_dup 0) (match_dup 1))]
{
  rtx addr = operand_subword (operands[0], 1, 0, DFmode);
  s390_load_address (addr, XEXP (operands[1], 0));
  operands[1] = replace_equiv_address (operands[1], addr);
})

(define_expand "reload_outdf"
  [(parallel [(match_operand:DF 0 "memory_operand" "")
              (match_operand:DF 1 "register_operand" "d")
              (match_operand:SI 2 "register_operand" "=&a")])]
  "!TARGET_64BIT"
{
  s390_load_address (operands[2], XEXP (operands[0], 0));
  operands[0] = replace_equiv_address (operands[0], operands[2]);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

;
; movsf instruction pattern(s).
;

(define_expand "movsf"
  [(set (match_operand:SF 0 "nonimmediate_operand" "")
        (match_operand:SF 1 "general_operand"  ""))]
  ""
{
  /* During and after reload, we need to force constants
     to the literal pool ourselves, if necessary.  */
  if ((reload_in_progress || reload_completed)
      && CONSTANT_P (operands[1]))
    operands[1] = force_const_mem (SFmode, operands[1]);
})

(define_insn "*movsf"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=f,f,f,R,T,d,d,d,R,T,?Q")
        (match_operand:SF 1 "general_operand" "f,R,T,f,f,d,R,T,d,d,?Q"))]
  ""
  "@
   ler\t%0,%1
   le\t%0,%1
   ley\t%0,%1
   ste\t%1,%0
   stey\t%1,%0
   lr\t%0,%1
   l\t%0,%1
   ly\t%0,%1
   st\t%1,%0
   sty\t%1,%0
   mvc\t%O0(4,%R0),%1"
  [(set_attr "op_type" "RR,RX,RXY,RX,RXY,RR,RX,RXY,RX,RXY,SS")
   (set_attr "type" "floads,floads,floads,fstores,fstores,lr,load,load,store,store,cs")])

;
; load_multiple pattern(s).
;
; ??? Due to reload problems with replacing registers inside match_parallel
; we currently support load_multiple/store_multiple only after reload.
;

(define_expand "load_multiple"
  [(match_par_dup 3 [(set (match_operand 0 "" "")
			  (match_operand 1 "" ""))
		     (use (match_operand 2 "" ""))])]
  "reload_completed"
{
  enum machine_mode mode;
  int regno;
  int count;
  rtx from;
  int i, off;

  /* Support only loading a constant number of fixed-point registers from
     memory and only bother with this if more than two */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) < 2
      || INTVAL (operands[2]) > 16
      || GET_CODE (operands[1]) != MEM
      || GET_CODE (operands[0]) != REG
      || REGNO (operands[0]) >= 16)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[0]);
  mode = GET_MODE (operands[0]);
  if (mode != SImode && mode != word_mode)
    FAIL;

  operands[3] = gen_rtx_PARALLEL (VOIDmode, rtvec_alloc (count));
  if (no_new_pseudos)
    {
      if (GET_CODE (XEXP (operands[1], 0)) == REG)
	{
	  from = XEXP (operands[1], 0);
	  off = 0;
	}
      else if (GET_CODE (XEXP (operands[1], 0)) == PLUS
	       && GET_CODE (XEXP (XEXP (operands[1], 0), 0)) == REG
	       && GET_CODE (XEXP (XEXP (operands[1], 0), 1)) == CONST_INT)
	{
	  from = XEXP (XEXP (operands[1], 0), 0);
	  off = INTVAL (XEXP (XEXP (operands[1], 0), 1));
	}
      else
	FAIL;

      if (from == frame_pointer_rtx || from == arg_pointer_rtx)
	FAIL;
    }
  else
    {
      from = force_reg (Pmode, XEXP (operands[1], 0));
      off = 0;
    }

  for (i = 0; i < count; i++)
    XVECEXP (operands[3], 0, i)
      = gen_rtx_SET (VOIDmode, gen_rtx_REG (mode, regno + i),
		     change_address (operands[1], mode,
		       plus_constant (from, off + i * GET_MODE_SIZE (mode))));
})

(define_insn "*load_multiple_di"
  [(match_parallel 0 "load_multiple_operation"
		   [(set (match_operand:DI 1 "register_operand" "=r")
			 (match_operand:DI 2 "s_operand" "QS"))])]
  "reload_completed && word_mode == DImode"
{
  int words = XVECLEN (operands[0], 0);
  operands[0] = gen_rtx_REG (DImode, REGNO (operands[1]) + words - 1);
  return "lmg\t%1,%0,%2";
}
   [(set_attr "op_type" "RSY")
    (set_attr "type"    "lm")])

(define_insn "*load_multiple_si"
  [(match_parallel 0 "load_multiple_operation"
		   [(set (match_operand:SI 1 "register_operand" "=r,r")
			 (match_operand:SI 2 "s_operand" "Q,S"))])]
  "reload_completed"
{
  int words = XVECLEN (operands[0], 0);
  operands[0] = gen_rtx_REG (SImode, REGNO (operands[1]) + words - 1);
  return which_alternative == 0 ? "lm\t%1,%0,%2" : "lmy\t%1,%0,%2";
}
   [(set_attr "op_type" "RS,RSY")
    (set_attr "type"    "lm")])

;
; store multiple pattern(s).
;

(define_expand "store_multiple"
  [(match_par_dup 3 [(set (match_operand 0 "" "")
			  (match_operand 1 "" ""))
		     (use (match_operand 2 "" ""))])]
  "reload_completed"
{
  enum machine_mode mode;
  int regno;
  int count;
  rtx to;
  int i, off;

  /* Support only storing a constant number of fixed-point registers to
     memory and only bother with this if more than two.  */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) < 2
      || INTVAL (operands[2]) > 16
      || GET_CODE (operands[0]) != MEM
      || GET_CODE (operands[1]) != REG
      || REGNO (operands[1]) >= 16)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[1]);
  mode = GET_MODE (operands[1]);
  if (mode != SImode && mode != word_mode)
    FAIL;

  operands[3] = gen_rtx_PARALLEL (VOIDmode, rtvec_alloc (count));

  if (no_new_pseudos)
    {
      if (GET_CODE (XEXP (operands[0], 0)) == REG)
	{
	  to = XEXP (operands[0], 0);
	  off = 0;
	}
      else if (GET_CODE (XEXP (operands[0], 0)) == PLUS
	       && GET_CODE (XEXP (XEXP (operands[0], 0), 0)) == REG
	       && GET_CODE (XEXP (XEXP (operands[0], 0), 1)) == CONST_INT)
	{
	  to = XEXP (XEXP (operands[0], 0), 0);
	  off = INTVAL (XEXP (XEXP (operands[0], 0), 1));
	}
      else
	FAIL;

      if (to == frame_pointer_rtx || to == arg_pointer_rtx)
	FAIL;
    }
  else
    {
      to = force_reg (Pmode, XEXP (operands[0], 0));
      off = 0;
    }

  for (i = 0; i < count; i++)
    XVECEXP (operands[3], 0, i)
      = gen_rtx_SET (VOIDmode,
		     change_address (operands[0], mode,
		       plus_constant (to, off + i * GET_MODE_SIZE (mode))),
		     gen_rtx_REG (mode, regno + i));
})

(define_insn "*store_multiple_di"
  [(match_parallel 0 "store_multiple_operation"
		   [(set (match_operand:DI 1 "s_operand" "=QS")
			 (match_operand:DI 2 "register_operand" "r"))])]
  "reload_completed && word_mode == DImode"
{
  int words = XVECLEN (operands[0], 0);
  operands[0] = gen_rtx_REG (DImode, REGNO (operands[2]) + words - 1);
  return "stmg\t%2,%0,%1";
}
   [(set_attr "op_type" "RSY")
    (set_attr "type"    "stm")])


(define_insn "*store_multiple_si"
  [(match_parallel 0 "store_multiple_operation"
		   [(set (match_operand:SI 1 "s_operand" "=Q,S")
			 (match_operand:SI 2 "register_operand" "r,r"))])]
  "reload_completed"
{
  int words = XVECLEN (operands[0], 0);
  operands[0] = gen_rtx_REG (SImode, REGNO (operands[2]) + words - 1);
  return which_alternative == 0 ? "stm\t%2,%0,%1" : "stmy\t%2,%0,%1";
}
   [(set_attr "op_type" "RS,RSY")
    (set_attr "type"    "stm")])

;;
;; String instructions.
;;

;
; strlenM instruction pattern(s).
;

(define_expand "strlendi"
  [(set (reg:QI 0) (match_operand:QI 2 "immediate_operand" ""))
   (parallel 
    [(set (match_dup 4)
	  (unspec:DI [(const_int 0)
		      (match_operand:BLK 1 "memory_operand" "")
		      (reg:QI 0)
		      (match_operand 3 "immediate_operand" "")] UNSPEC_SRST))
     (clobber (scratch:DI))
     (clobber (reg:CC 33))])
   (parallel
    [(set (match_operand:DI 0 "register_operand" "")
          (minus:DI (match_dup 4) (match_dup 5)))
     (clobber (reg:CC 33))])]
  "TARGET_64BIT"
{
  operands[4] = gen_reg_rtx (DImode);
  operands[5] = gen_reg_rtx (DImode);
  emit_move_insn (operands[5], force_operand (XEXP (operands[1], 0), NULL_RTX));
  operands[1] = replace_equiv_address (operands[1], operands[5]);
})

(define_insn "*strlendi"
  [(set (match_operand:DI 0 "register_operand" "=a")
	(unspec:DI [(match_operand:DI 2 "general_operand" "0")
		    (mem:BLK (match_operand:DI 3 "register_operand" "1"))
		    (reg:QI 0)
		    (match_operand 4 "immediate_operand" "")] UNSPEC_SRST))
   (clobber (match_scratch:DI 1 "=a"))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "srst\t%0,%1\;jo\t.-4"
  [(set_attr "op_type" "NN")
   (set_attr "type"    "vs")
   (set_attr "length"  "8")])

(define_expand "strlensi"
  [(set (reg:QI 0) (match_operand:QI 2 "immediate_operand" ""))
   (parallel 
    [(set (match_dup 4)
	  (unspec:SI [(const_int 0)
		      (match_operand:BLK 1 "memory_operand" "")
		      (reg:QI 0)
		      (match_operand 3 "immediate_operand" "")] UNSPEC_SRST))
     (clobber (scratch:SI))
     (clobber (reg:CC 33))])
   (parallel
    [(set (match_operand:SI 0 "register_operand" "")
          (minus:SI (match_dup 4) (match_dup 5)))
     (clobber (reg:CC 33))])]
  "!TARGET_64BIT"
{
  operands[4] = gen_reg_rtx (SImode);
  operands[5] = gen_reg_rtx (SImode);
  emit_move_insn (operands[5], force_operand (XEXP (operands[1], 0), NULL_RTX));
  operands[1] = replace_equiv_address (operands[1], operands[5]);
})

(define_insn "*strlensi"
  [(set (match_operand:SI 0 "register_operand" "=a")
	(unspec:SI [(match_operand:SI 2 "general_operand" "0")
		    (mem:BLK (match_operand:SI 3 "register_operand" "1"))
		    (reg:QI 0)
		    (match_operand 4 "immediate_operand" "")] UNSPEC_SRST))
   (clobber (match_scratch:SI 1 "=a"))
   (clobber (reg:CC 33))]	
  "!TARGET_64BIT"
  "srst\t%0,%1\;jo\t.-4"
  [(set_attr "op_type" "NN")
   (set_attr "type"    "vs")
   (set_attr "length"  "8")])

;
; movstrM instruction pattern(s).
;

(define_expand "movstrdi"
  [(set (match_operand:BLK 0 "memory_operand" "")
        (match_operand:BLK 1 "memory_operand" ""))
   (use (match_operand:DI 2 "general_operand" ""))
   (match_operand 3 "" "")]
  "TARGET_64BIT"
  "s390_expand_movstr (operands[0], operands[1], operands[2]); DONE;")

(define_expand "movstrsi"
  [(set (match_operand:BLK 0 "memory_operand" "")
        (match_operand:BLK 1 "memory_operand" ""))
   (use (match_operand:SI 2 "general_operand" ""))
   (match_operand 3 "" "")]
  ""
  "s390_expand_movstr (operands[0], operands[1], operands[2]); DONE;")

; Move a block that is up to 256 bytes in length.
; The block length is taken as (operands[2] % 256) + 1.

(define_expand "movstr_short"
  [(parallel
    [(set (match_operand:BLK 0 "memory_operand" "")
          (match_operand:BLK 1 "memory_operand" ""))
     (use (match_operand 2 "nonmemory_operand" ""))
     (clobber (match_dup 3))])]
  ""
  "operands[3] = gen_rtx_SCRATCH (Pmode);")

(define_insn "*movstr_short"
  [(set (match_operand:BLK 0 "memory_operand" "=Q,Q")
        (match_operand:BLK 1 "memory_operand" "Q,Q"))
   (use (match_operand 2 "nonmemory_operand" "n,a"))
   (clobber (match_scratch 3 "=X,&a"))]
  "(GET_MODE (operands[2]) == Pmode || GET_MODE (operands[2]) == VOIDmode)
   && GET_MODE (operands[3]) == Pmode"
{
  switch (which_alternative)
    {
      case 0:
	return "mvc\t%O0(%b2+1,%R0),%1";

      case 1:
	output_asm_insn ("bras\t%3,.+10", operands);
	output_asm_insn ("mvc\t%O0(1,%R0),%1", operands);
	return "ex\t%2,0(%3)";

      default:
        abort ();
    }
}
  [(set_attr "op_type" "SS,NN")
   (set_attr "type"    "cs,cs")
   (set_attr "atype"   "*,agen")
   (set_attr "length"  "*,14")])

; Move a block of arbitrary length.

(define_expand "movstr_long"
  [(parallel
    [(clobber (match_dup 2))
     (clobber (match_dup 3))
     (set (match_operand:BLK 0 "memory_operand" "")
          (match_operand:BLK 1 "memory_operand" ""))
     (use (match_operand 2 "general_operand" ""))
     (use (match_dup 3))
     (clobber (reg:CC 33))])]
  ""
{
  enum machine_mode dword_mode = word_mode == DImode ? TImode : DImode;
  rtx reg0 = gen_reg_rtx (dword_mode);
  rtx reg1 = gen_reg_rtx (dword_mode);
  rtx addr0 = gen_lowpart (Pmode, gen_highpart (word_mode, reg0));
  rtx addr1 = gen_lowpart (Pmode, gen_highpart (word_mode, reg1));
  rtx len0 = gen_lowpart (Pmode, reg0);
  rtx len1 = gen_lowpart (Pmode, reg1);

  emit_insn (gen_rtx_CLOBBER (VOIDmode, reg0));
  emit_move_insn (addr0, force_operand (XEXP (operands[0], 0), NULL_RTX));
  emit_move_insn (len0, operands[2]);

  emit_insn (gen_rtx_CLOBBER (VOIDmode, reg1));
  emit_move_insn (addr1, force_operand (XEXP (operands[1], 0), NULL_RTX));
  emit_move_insn (len1, operands[2]);

  operands[0] = replace_equiv_address_nv (operands[0], addr0);
  operands[1] = replace_equiv_address_nv (operands[1], addr1);
  operands[2] = reg0;
  operands[3] = reg1;
})

(define_insn "*movstr_long_64"
  [(clobber (match_operand:TI 0 "register_operand" "=d"))
   (clobber (match_operand:TI 1 "register_operand" "=d"))
   (set (mem:BLK (subreg:DI (match_operand:TI 2 "register_operand" "0") 0))
        (mem:BLK (subreg:DI (match_operand:TI 3 "register_operand" "1") 0)))
   (use (match_dup 2))
   (use (match_dup 3))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "mvcle\t%0,%1,0\;jo\t.-4"
  [(set_attr "op_type" "NN")
   (set_attr "type"    "vs")
   (set_attr "length"  "8")])

(define_insn "*movstr_long_31"
  [(clobber (match_operand:DI 0 "register_operand" "=d"))
   (clobber (match_operand:DI 1 "register_operand" "=d"))
   (set (mem:BLK (subreg:SI (match_operand:DI 2 "register_operand" "0") 0))
        (mem:BLK (subreg:SI (match_operand:DI 3 "register_operand" "1") 0)))
   (use (match_dup 2))
   (use (match_dup 3))
   (clobber (reg:CC 33))]
  "!TARGET_64BIT"
  "mvcle\t%0,%1,0\;jo\t.-4"
  [(set_attr "op_type" "NN")
   (set_attr "type"    "vs")
   (set_attr "length"  "8")])

;
; clrstrM instruction pattern(s).
;

(define_expand "clrstrdi"
  [(set (match_operand:BLK 0 "memory_operand" "")
        (const_int 0))
   (use (match_operand:DI 1 "general_operand" ""))
   (match_operand 2 "" "")]
  "TARGET_64BIT"
  "s390_expand_clrstr (operands[0], operands[1]); DONE;")

(define_expand "clrstrsi"
  [(set (match_operand:BLK 0 "memory_operand" "")
        (const_int 0))
   (use (match_operand:SI 1 "general_operand" ""))
   (match_operand 2 "" "")]
  ""
  "s390_expand_clrstr (operands[0], operands[1]); DONE;")

; Clear a block that is up to 256 bytes in length.
; The block length is taken as (operands[1] % 256) + 1.

(define_expand "clrstr_short"
  [(parallel
    [(set (match_operand:BLK 0 "memory_operand" "")
          (const_int 0))
     (use (match_operand 1 "nonmemory_operand" ""))
     (clobber (match_dup 2))
     (clobber (reg:CC 33))])]
  ""
  "operands[2] = gen_rtx_SCRATCH (Pmode);")

(define_insn "*clrstr_short"
  [(set (match_operand:BLK 0 "memory_operand" "=Q,Q")
        (const_int 0))
   (use (match_operand 1 "nonmemory_operand" "n,a"))
   (clobber (match_scratch 2 "=X,&a"))
   (clobber (reg:CC 33))]
  "(GET_MODE (operands[1]) == Pmode || GET_MODE (operands[1]) == VOIDmode)
   && GET_MODE (operands[2]) == Pmode"
{
  switch (which_alternative)
    {
      case 0:
	return "xc\t%O0(%b1+1,%R0),%0";

      case 1:
	output_asm_insn ("bras\t%2,.+10", operands);
	output_asm_insn ("xc\t%O0(1,%R0),%0", operands);
	return "ex\t%1,0(%2)";

      default:
        abort ();
    }
}
  [(set_attr "op_type" "SS,NN")
   (set_attr "type"    "cs,cs")
   (set_attr "atype"   "*,agen")
   (set_attr "length"  "*,14")])

; Clear a block of arbitrary length.

(define_expand "clrstr_long"
  [(parallel
    [(clobber (match_dup 1))
     (set (match_operand:BLK 0 "memory_operand" "")
          (const_int 0))
     (use (match_operand 1 "general_operand" ""))
     (use (match_dup 2))
     (clobber (reg:CC 33))])]
  ""
{
  enum machine_mode dword_mode = word_mode == DImode ? TImode : DImode;
  rtx reg0 = gen_reg_rtx (dword_mode);
  rtx reg1 = gen_reg_rtx (dword_mode);
  rtx addr0 = gen_lowpart (Pmode, gen_highpart (word_mode, reg0));
  rtx len0 = gen_lowpart (Pmode, reg0);

  emit_insn (gen_rtx_CLOBBER (VOIDmode, reg0));
  emit_move_insn (addr0, force_operand (XEXP (operands[0], 0), NULL_RTX));
  emit_move_insn (len0, operands[1]);

  emit_move_insn (reg1, const0_rtx);

  operands[0] = replace_equiv_address_nv (operands[0], addr0);
  operands[1] = reg0;
  operands[2] = reg1;
})

(define_insn "*clrstr_long_64"
  [(clobber (match_operand:TI 0 "register_operand" "=d"))
   (set (mem:BLK (subreg:DI (match_operand:TI 2 "register_operand" "0") 0))
        (const_int 0))
   (use (match_dup 2))
   (use (match_operand:TI 1 "register_operand" "d"))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "mvcle\t%0,%1,0\;jo\t.-4"
  [(set_attr "op_type" "NN")
   (set_attr "type"    "vs")
   (set_attr "length"  "8")])

(define_insn "*clrstr_long_31"
  [(clobber (match_operand:DI 0 "register_operand" "=d"))
   (set (mem:BLK (subreg:SI (match_operand:DI 2 "register_operand" "0") 0))
        (const_int 0))
   (use (match_dup 2))
   (use (match_operand:DI 1 "register_operand" "d"))
   (clobber (reg:CC 33))]
  "!TARGET_64BIT"
  "mvcle\t%0,%1,0\;jo\t.-4"
  [(set_attr "op_type" "NN")
   (set_attr "type"    "vs")
   (set_attr "length"  "8")])

;
; cmpmemM instruction pattern(s).
;

(define_expand "cmpmemdi"
  [(set (match_operand:DI 0 "register_operand" "")
        (compare:DI (match_operand:BLK 1 "memory_operand" "")
                    (match_operand:BLK 2 "memory_operand" "") ) )
   (use (match_operand:DI 3 "general_operand" ""))
   (use (match_operand:DI 4 "" ""))]
  "TARGET_64BIT"
  "s390_expand_cmpmem (operands[0], operands[1],
                       operands[2], operands[3]); DONE;")

(define_expand "cmpmemsi"
  [(set (match_operand:SI 0 "register_operand" "")
        (compare:SI (match_operand:BLK 1 "memory_operand" "")
                    (match_operand:BLK 2 "memory_operand" "") ) )
   (use (match_operand:SI 3 "general_operand" ""))
   (use (match_operand:SI 4 "" ""))]
  ""
  "s390_expand_cmpmem (operands[0], operands[1],
                       operands[2], operands[3]); DONE;")

; Compare a block that is up to 256 bytes in length.
; The block length is taken as (operands[2] % 256) + 1.

(define_expand "cmpmem_short"
  [(parallel
    [(set (reg:CCS 33)
          (compare:CCS (match_operand:BLK 0 "memory_operand" "")
                       (match_operand:BLK 1 "memory_operand" "")))
     (use (match_operand 2 "nonmemory_operand" ""))
     (clobber (match_dup 3))])]
  ""
  "operands[3] = gen_rtx_SCRATCH (Pmode);")

(define_insn "*cmpmem_short"
  [(set (reg:CCS 33)
        (compare:CCS (match_operand:BLK 0 "memory_operand" "=Q,Q")
                     (match_operand:BLK 1 "memory_operand" "Q,Q")))
   (use (match_operand 2 "nonmemory_operand" "n,a"))
   (clobber (match_scratch 3 "=X,&a"))]
  "(GET_MODE (operands[2]) == Pmode || GET_MODE (operands[2]) == VOIDmode)
   && GET_MODE (operands[3]) == Pmode"
{
  switch (which_alternative)
    {
      case 0:
	return "clc\t%O0(%b2+1,%R0),%1";

      case 1:
	output_asm_insn ("bras\t%3,.+10", operands);
	output_asm_insn ("clc\t%O0(1,%R0),%1", operands);
	return "ex\t%2,0(%3)";

      default:
        abort ();
    }
}
  [(set_attr "op_type" "SS,NN")
   (set_attr "type"    "cs,cs")
   (set_attr "atype"   "*,agen")
   (set_attr "length"  "*,14")])

; Compare a block of arbitrary length.

(define_expand "cmpmem_long"
  [(parallel
    [(clobber (match_dup 2))
     (clobber (match_dup 3))
     (set (reg:CCS 33)
          (compare:CCS (match_operand:BLK 0 "memory_operand" "")
                       (match_operand:BLK 1 "memory_operand" "")))
     (use (match_operand 2 "general_operand" ""))
     (use (match_dup 3))])]
  ""
{
  enum machine_mode dword_mode = word_mode == DImode ? TImode : DImode;
  rtx reg0 = gen_reg_rtx (dword_mode);
  rtx reg1 = gen_reg_rtx (dword_mode);
  rtx addr0 = gen_lowpart (Pmode, gen_highpart (word_mode, reg0));
  rtx addr1 = gen_lowpart (Pmode, gen_highpart (word_mode, reg1));
  rtx len0 = gen_lowpart (Pmode, reg0);
  rtx len1 = gen_lowpart (Pmode, reg1);

  emit_insn (gen_rtx_CLOBBER (VOIDmode, reg0));
  emit_move_insn (addr0, force_operand (XEXP (operands[0], 0), NULL_RTX));
  emit_move_insn (len0, operands[2]);

  emit_insn (gen_rtx_CLOBBER (VOIDmode, reg1));
  emit_move_insn (addr1, force_operand (XEXP (operands[1], 0), NULL_RTX));
  emit_move_insn (len1, operands[2]);

  operands[0] = replace_equiv_address_nv (operands[0], addr0);
  operands[1] = replace_equiv_address_nv (operands[1], addr1);
  operands[2] = reg0;
  operands[3] = reg1;
})

(define_insn "*cmpmem_long_64"
  [(clobber (match_operand:TI 0 "register_operand" "=d"))
   (clobber (match_operand:TI 1 "register_operand" "=d"))
   (set (reg:CCS 33)
        (compare:CCS (mem:BLK (subreg:DI (match_operand:TI 2 "register_operand" "0") 0))
                     (mem:BLK (subreg:DI (match_operand:TI 3 "register_operand" "1") 0))))
   (use (match_dup 2))
   (use (match_dup 3))]
  "TARGET_64BIT"
  "clcle\t%0,%1,0\;jo\t.-4"
  [(set_attr "op_type" "NN")
   (set_attr "type"    "vs")
   (set_attr "length"  "8")])

(define_insn "*cmpmem_long_31"
  [(clobber (match_operand:DI 0 "register_operand" "=d"))
   (clobber (match_operand:DI 1 "register_operand" "=d"))
   (set (reg:CCS 33)
        (compare:CCS (mem:BLK (subreg:SI (match_operand:DI 2 "register_operand" "0") 0))
                     (mem:BLK (subreg:SI (match_operand:DI 3 "register_operand" "1") 0))))
   (use (match_dup 2))
   (use (match_dup 3))]
  "!TARGET_64BIT"
  "clcle\t%0,%1,0\;jo\t.-4"
  [(set_attr "op_type" "NN")
   (set_attr "type"    "vs")
   (set_attr "length"  "8")])

; Convert condition code to integer in range (-1, 0, 1)

(define_insn "cmpint_si"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (compare:SI (reg:CCS 33) (const_int 0)))]
  ""
{
   output_asm_insn ("lhi\t%0,1", operands);
   output_asm_insn ("jh\t.+12", operands);
   output_asm_insn ("jl\t.+6", operands);
   output_asm_insn ("sr\t%0,%0", operands);
   return "lcr\t%0,%0";
}
  [(set_attr "op_type" "NN")
   (set_attr "length"  "16")
   (set_attr "type"    "other")])

(define_insn "cmpint_di"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (compare:DI (reg:CCS 33) (const_int 0)))]
  "TARGET_64BIT"
{
   output_asm_insn ("lghi\t%0,1", operands);
   output_asm_insn ("jh\t.+16", operands);
   output_asm_insn ("jl\t.+8", operands);
   output_asm_insn ("sgr\t%0,%0", operands);
   return "lcgr\t%0,%0";
}
  [(set_attr "op_type" "NN")
   (set_attr "length"  "20")
   (set_attr "type"    "other")])


;;
;;- Conversion instructions.
;;

(define_insn "*sethighqisi"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (unspec:SI [(match_operand:QI 1 "s_operand" "Q,S")] UNSPEC_SETHIGH))
   (clobber (reg:CC 33))]
  ""
  "@
   icm\t%0,8,%1
   icmy\t%0,8,%1"
  [(set_attr "op_type" "RS,RSY")])

(define_insn "*sethighhisi"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (unspec:SI [(match_operand:HI 1 "s_operand" "Q,S")] UNSPEC_SETHIGH))
   (clobber (reg:CC 33))]
  ""
  "@
   icm\t%0,12,%1
   icmy\t%0,12,%1"
  [(set_attr "op_type" "RS,RSY")])

(define_insn "*sethighqidi_64"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (unspec:DI [(match_operand:QI 1 "s_operand" "QS")] UNSPEC_SETHIGH))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "icmh\t%0,8,%1"
  [(set_attr "op_type" "RSY")])

(define_insn "*sethighqidi_31"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (unspec:DI [(match_operand:QI 1 "s_operand" "Q,S")] UNSPEC_SETHIGH))
   (clobber (reg:CC 33))]
  "!TARGET_64BIT"
  "@
   icm\t%0,8,%1
   icmy\t%0,8,%1"
  [(set_attr "op_type" "RS,RSY")])

(define_insn_and_split "*extractqi"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (zero_extract:SI (match_operand:QI 1 "s_operand" "Q")
                         (match_operand 2 "const_int_operand" "n")
                         (const_int 0)))
   (clobber (reg:CC 33))]
  "!TARGET_64BIT
   && INTVAL (operands[2]) > 0 && INTVAL (operands[2]) < 8"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 0) (unspec:SI [(match_dup 1)] UNSPEC_SETHIGH))
     (clobber (reg:CC 33))])
    (set (match_dup 0) (lshiftrt:SI (match_dup 0) (match_dup 2)))]
{
  operands[2] = GEN_INT (32 - INTVAL (operands[2]));
  operands[1] = change_address (operands[1], QImode, 0);
}
  [(set_attr "atype"   "agen")])

(define_insn_and_split "*extracthi"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (zero_extract:SI (match_operand:QI 1 "s_operand" "Q")
                         (match_operand 2 "const_int_operand" "n")
                         (const_int 0)))
   (clobber (reg:CC 33))]
  "!TARGET_64BIT
   && INTVAL (operands[2]) >= 8 && INTVAL (operands[2]) < 16"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 0) (unspec:SI [(match_dup 1)] UNSPEC_SETHIGH))
     (clobber (reg:CC 33))])
    (set (match_dup 0) (lshiftrt:SI (match_dup 0) (match_dup 2)))]
{
  operands[2] = GEN_INT (32 - INTVAL (operands[2]));
  operands[1] = change_address (operands[1], HImode, 0);
}
  [(set_attr "atype"   "agen")])

;
; extendsidi2 instruction pattern(s).
;

(define_expand "extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (sign_extend:DI (match_operand:SI 1 "nonimmediate_operand" "")))]
  ""
  "
{
  if (!TARGET_64BIT)
    {
      emit_insn (gen_rtx_CLOBBER (VOIDmode, operands[0]));
      emit_move_insn (gen_highpart (SImode, operands[0]), operands[1]);
      emit_move_insn (gen_lowpart (SImode, operands[0]), const0_rtx);
      emit_insn (gen_ashrdi3 (operands[0], operands[0], GEN_INT (32)));
      DONE;
    }
}
")

(define_insn "*extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (sign_extend:DI (match_operand:SI 1 "nonimmediate_operand" "d,m")))]
  "TARGET_64BIT"
  "@
   lgfr\t%0,%1
   lgf\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

;
; extendhidi2 instruction pattern(s).
;

(define_expand "extendhidi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (sign_extend:DI (match_operand:HI 1 "register_operand" "")))]
  ""
  "
{
  if (!TARGET_64BIT)
    {
      rtx tmp = gen_reg_rtx (SImode);
      emit_insn (gen_extendhisi2 (tmp, operands[1]));
      emit_insn (gen_extendsidi2 (operands[0], tmp));
      DONE;
    }
  else
    {
      operands[1] = gen_lowpart (DImode, operands[1]);
      emit_insn (gen_ashldi3 (operands[0], operands[1], GEN_INT (48)));
      emit_insn (gen_ashrdi3 (operands[0], operands[0], GEN_INT (48)));
      DONE;
    }
}
")

(define_insn "*extendhidi2"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (sign_extend:DI (match_operand:HI 1 "memory_operand" "m")))]
  "TARGET_64BIT"
  "lgh\t%0,%1"
  [(set_attr "op_type" "RXY")])

;
; extendqidi2 instruction pattern(s).
;

(define_expand "extendqidi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (sign_extend:DI (match_operand:QI 1 "register_operand" "")))]
  ""
  "
{
  if (!TARGET_64BIT)
    {
      rtx tmp = gen_reg_rtx (SImode);
      emit_insn (gen_extendqisi2 (tmp, operands[1]));
      emit_insn (gen_extendsidi2 (operands[0], tmp));
      DONE;
    }
  else
    {
      operands[1] = gen_lowpart (DImode, operands[1]);
      emit_insn (gen_ashldi3 (operands[0], operands[1], GEN_INT (56)));
      emit_insn (gen_ashrdi3 (operands[0], operands[0], GEN_INT (56)));
      DONE;
    }
}
")

(define_insn "*extendqidi2"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (sign_extend:DI (match_operand:QI 1 "memory_operand" "m")))]
  "TARGET_64BIT && TARGET_LONG_DISPLACEMENT"
  "lgb\t%0,%1"
  [(set_attr "op_type" "RXY")])

(define_insn_and_split "*extendqidi2_short_displ"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (sign_extend:DI (match_operand:QI 1 "s_operand" "Q")))
   (clobber (reg:CC 33))]
  "TARGET_64BIT && !TARGET_LONG_DISPLACEMENT"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 0) (unspec:DI [(match_dup 1)] UNSPEC_SETHIGH))
     (clobber (reg:CC 33))])
   (parallel
    [(set (match_dup 0) (ashiftrt:DI (match_dup 0) (const_int 56)))
     (clobber (reg:CC 33))])]
  "")

;
; extendhisi2 instruction pattern(s).
;

(define_expand "extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "")
        (sign_extend:SI (match_operand:HI 1 "register_operand" "")))]
  ""
  "
{
  operands[1] = gen_lowpart (SImode, operands[1]);
  emit_insn (gen_ashlsi3 (operands[0], operands[1], GEN_INT (16)));
  emit_insn (gen_ashrsi3 (operands[0], operands[0], GEN_INT (16)));
  DONE;
}
")

(define_insn "*extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (sign_extend:SI (match_operand:HI 1 "memory_operand" "R,T")))]
  ""
  "@
   lh\t%0,%1
   lhy\t%0,%1"
  [(set_attr "op_type" "RX,RXY")])

;
; extendqisi2 instruction pattern(s).
;

(define_expand "extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "")
        (sign_extend:SI (match_operand:QI 1 "register_operand" "")))]
  ""
  "
{
  operands[1] = gen_lowpart (SImode, operands[1]);
  emit_insn (gen_ashlsi3 (operands[0], operands[1], GEN_INT (24)));
  emit_insn (gen_ashrsi3 (operands[0], operands[0], GEN_INT (24)));
  DONE;
}
")

(define_insn "*extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (sign_extend:SI (match_operand:QI 1 "memory_operand" "m")))]
  "TARGET_LONG_DISPLACEMENT"
  "lb\t%0,%1"
  [(set_attr "op_type" "RXY")])

(define_insn_and_split "*extendsiqi2_short_displ"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (sign_extend:SI (match_operand:QI 1 "s_operand" "Q")))
   (clobber (reg:CC 33))]
  "!TARGET_LONG_DISPLACEMENT"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 0) (unspec:SI [(match_dup 1)] UNSPEC_SETHIGH))
     (clobber (reg:CC 33))])
   (parallel
    [(set (match_dup 0) (ashiftrt:SI (match_dup 0) (const_int 24)))
     (clobber (reg:CC 33))])]
  "")

;
; extendqihi2 instruction pattern(s).
;


;
; zero_extendsidi2 instruction pattern(s).
;

(define_expand "zero_extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "")))]
  ""
  "
{
  if (!TARGET_64BIT)
    {
      emit_insn (gen_rtx_CLOBBER (VOIDmode, operands[0]));
      emit_move_insn (gen_lowpart (SImode, operands[0]), operands[1]);
      emit_move_insn (gen_highpart (SImode, operands[0]), const0_rtx);
      DONE;
    }
}
")

(define_insn "*zero_extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "d,m")))]
  "TARGET_64BIT"
  "@
   llgfr\t%0,%1
   llgf\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

;
; zero_extendhidi2 instruction pattern(s).
;

(define_expand "zero_extendhidi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (zero_extend:DI (match_operand:HI 1 "register_operand" "")))]
  ""
  "
{
  if (!TARGET_64BIT)
    {
      rtx tmp = gen_reg_rtx (SImode);
      emit_insn (gen_zero_extendhisi2 (tmp, operands[1]));
      emit_insn (gen_zero_extendsidi2 (operands[0], tmp));
      DONE;
    }
  else
    {
      operands[1] = gen_lowpart (DImode, operands[1]);
      emit_insn (gen_ashldi3 (operands[0], operands[1], GEN_INT (48)));
      emit_insn (gen_lshrdi3 (operands[0], operands[0], GEN_INT (48)));
      DONE;
    }
}
")

(define_insn "*zero_extendhidi2"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (zero_extend:DI (match_operand:HI 1 "memory_operand" "m")))]
  "TARGET_64BIT"
  "llgh\t%0,%1"
  [(set_attr "op_type" "RXY")])

;
; LLGT-type instructions (zero-extend from 31 bit to 64 bit).
;

(define_insn "*llgt_sisi"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (and:SI (match_operand:SI 1 "nonimmediate_operand" "d,m")
		(const_int 2147483647)))]
  "TARGET_64BIT"
  "@
   llgtr\t%0,%1
   llgt\t%0,%1"
  [(set_attr "op_type"  "RRE,RXE")])

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
        (and:SI (match_operand:SI 1 "nonimmediate_operand" "")
		(const_int 2147483647)))
   (clobber (reg:CC 33))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 0)
        (and:SI (match_dup 1)
		(const_int 2147483647)))]
  "")

(define_insn "*llgt_didi"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (and:DI (match_operand:DI 1 "nonimmediate_operand" "d,o")
                (const_int 2147483647)))]
  "TARGET_64BIT"
  "@
   llgtr\t%0,%1
   llgt\t%0,%N1"
  [(set_attr "op_type"  "RRE,RXE")])

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
        (and:DI (match_operand:DI 1 "nonimmediate_operand" "")
                (const_int 2147483647)))
   (clobber (reg:CC 33))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 0)
        (and:DI (match_dup 1)
                (const_int 2147483647)))]
  "")

(define_insn "*llgt_sidi"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (and:DI (subreg:DI (match_operand:SI 1 "memory_operand" "m") 0)
		(const_int 2147483647)))]
  "TARGET_64BIT"
  "llgt\t%0,%1"
  [(set_attr "op_type"  "RXE")])

(define_insn_and_split "*llgt_sidi_split"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (and:DI (subreg:DI (match_operand:SI 1 "memory_operand" "m") 0) 
		(const_int 2147483647)))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
        (and:DI (subreg:DI (match_dup 1) 0) 
		(const_int 2147483647)))]
  "")

;
; zero_extendqidi2 instruction pattern(s)
;

(define_expand "zero_extendqidi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (zero_extend:DI (match_operand:QI 1 "register_operand" "")))]
  ""
  "
{
  if (!TARGET_64BIT)
    {
      rtx tmp = gen_reg_rtx (SImode);
      emit_insn (gen_zero_extendqisi2 (tmp, operands[1]));
      emit_insn (gen_zero_extendsidi2 (operands[0], tmp));
      DONE;
    }
  else
    {
      operands[1] = gen_lowpart (DImode, operands[1]);
      emit_insn (gen_ashldi3 (operands[0], operands[1], GEN_INT (56)));
      emit_insn (gen_lshrdi3 (operands[0], operands[0], GEN_INT (56)));
      DONE;
    }
}
")

(define_insn "*zero_extendqidi2"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (zero_extend:DI (match_operand:QI 1 "memory_operand" "m")))]
  "TARGET_64BIT"
  "llgc\t%0,%1"
  [(set_attr "op_type" "RXY")])

;
; zero_extendhisi2 instruction pattern(s).
;

(define_expand "zero_extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "")
        (zero_extend:SI (match_operand:HI 1 "register_operand" "")))]
  ""
  "
{
  operands[1] = gen_lowpart (SImode, operands[1]);
  emit_insn (gen_andsi3 (operands[0], operands[1], GEN_INT (0xffff)));
  DONE;
}
")

(define_insn "*zero_extendhisi2_64"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (zero_extend:SI (match_operand:HI 1 "memory_operand" "m")))]
  "TARGET_64BIT"
  "llgh\t%0,%1"
  [(set_attr "op_type" "RXY")])

(define_insn_and_split "*zero_extendhisi2_31"
  [(set (match_operand:SI 0 "register_operand" "=&d")
        (zero_extend:SI (match_operand:HI 1 "s_operand" "QS")))
   (clobber (reg:CC 33))]
  "!TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(set (match_dup 0) (const_int 0))
   (parallel
    [(set (strict_low_part (match_dup 2)) (match_dup 1))
     (clobber (reg:CC 33))])]
  "operands[2] = gen_lowpart (HImode, operands[0]);"
  [(set_attr "atype" "agen")])

;
; zero_extendqisi2 instruction pattern(s).
;

(define_expand "zero_extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "")
        (zero_extend:SI (match_operand:QI 1 "register_operand" "")))]
  ""
  "
{
  operands[1] = gen_lowpart (SImode, operands[1]);
  emit_insn (gen_andsi3 (operands[0], operands[1], GEN_INT (0xff)));
  DONE;
}
")

(define_insn "*zero_extendqisi2_64"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (zero_extend:SI (match_operand:QI 1 "memory_operand" "m")))]
  "TARGET_ZARCH"
  "llgc\t%0,%1"
  [(set_attr "op_type" "RXY")])

(define_insn_and_split "*zero_extendqisi2_31"
  [(set (match_operand:SI 0 "register_operand" "=&d")
        (zero_extend:SI (match_operand:QI 1 "memory_operand" "m")))]
  "!TARGET_ZARCH"
  "#"
  "&& reload_completed"
  [(set (match_dup 0) (const_int 0))
   (set (strict_low_part (match_dup 2)) (match_dup 1))]
  "operands[2] = gen_lowpart (QImode, operands[0]);"
  [(set_attr "atype" "agen")])

;
; zero_extendqihi2 instruction pattern(s).
;

(define_expand "zero_extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "")
        (zero_extend:HI (match_operand:QI 1 "register_operand" "")))]
  "TARGET_ZARCH"
  "
{
  operands[1] = gen_lowpart (HImode, operands[1]);
  emit_insn (gen_andhi3 (operands[0], operands[1], GEN_INT (0xff)));
  DONE;
}
")

(define_insn "*zero_extendqihi2_64"
  [(set (match_operand:HI 0 "register_operand" "=d")
        (zero_extend:HI (match_operand:QI 1 "memory_operand" "m")))]
  "TARGET_ZARCH"
  "llgc\t%0,%1"
  [(set_attr "op_type" "RXY")])

(define_insn_and_split "*zero_extendqihi2_31"
  [(set (match_operand:HI 0 "register_operand" "=&d")
        (zero_extend:HI (match_operand:QI 1 "memory_operand" "m")))]
  "!TARGET_ZARCH"
  "#"
  "&& reload_completed"
  [(set (match_dup 0) (const_int 0))
   (set (strict_low_part (match_dup 2)) (match_dup 1))]
  "operands[2] = gen_lowpart (QImode, operands[0]);"
  [(set_attr "atype" "agen")])


;
; fixuns_truncdfdi2 and fix_truncdfsi2 instruction pattern(s).
;

(define_expand "fixuns_truncdfdi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (unsigned_fix:DI (match_operand:DF 1 "register_operand" "")))]
  "TARGET_64BIT && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
{
  rtx label1 = gen_label_rtx ();
  rtx label2 = gen_label_rtx ();
  rtx temp = gen_reg_rtx (DFmode);
  operands[1] = force_reg (DFmode, operands[1]);

  emit_insn (gen_cmpdf (operands[1],
	CONST_DOUBLE_FROM_REAL_VALUE (
          REAL_VALUE_ATOF ("9223372036854775808.0", DFmode), DFmode)));
  emit_jump_insn (gen_blt (label1));
  emit_insn (gen_subdf3 (temp, operands[1],
	CONST_DOUBLE_FROM_REAL_VALUE (
          REAL_VALUE_ATOF ("18446744073709551616.0", DFmode), DFmode)));
  emit_insn (gen_fix_truncdfdi2_ieee (operands[0], temp, GEN_INT(7)));
  emit_jump (label2);

  emit_label (label1);
  emit_insn (gen_fix_truncdfdi2_ieee (operands[0], operands[1], GEN_INT(5)));
  emit_label (label2);
  DONE;
})

(define_expand "fix_truncdfdi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (fix:DI (match_operand:DF 1 "nonimmediate_operand" "")))]
  "TARGET_64BIT && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
{
  operands[1] = force_reg (DFmode, operands[1]);
  emit_insn (gen_fix_truncdfdi2_ieee (operands[0], operands[1], GEN_INT(5)));
  DONE;
})

(define_insn "fix_truncdfdi2_ieee"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (fix:DI (match_operand:DF 1 "register_operand" "f")))
   (unspec:DI [(match_operand:DI 2 "immediate_operand" "K")] UNSPEC_ROUND)
   (clobber (reg:CC 33))]
  "TARGET_64BIT && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "cgdbr\t%0,%h2,%1"
  [(set_attr "op_type" "RRE")
   (set_attr "type"    "ftoi")])

;
; fixuns_truncdfsi2 and fix_truncdfsi2 instruction pattern(s).
;

(define_expand "fixuns_truncdfsi2"
  [(set (match_operand:SI 0 "register_operand" "")
        (unsigned_fix:SI (match_operand:DF 1 "register_operand" "")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
{
  rtx label1 = gen_label_rtx ();
  rtx label2 = gen_label_rtx ();
  rtx temp = gen_reg_rtx (DFmode);

  operands[1] = force_reg (DFmode,operands[1]);
  emit_insn (gen_cmpdf (operands[1],
	CONST_DOUBLE_FROM_REAL_VALUE (
          REAL_VALUE_ATOF ("2147483648.0", DFmode), DFmode)));
  emit_jump_insn (gen_blt (label1));
  emit_insn (gen_subdf3 (temp, operands[1],
	CONST_DOUBLE_FROM_REAL_VALUE (
          REAL_VALUE_ATOF ("4294967296.0", DFmode), DFmode)));
  emit_insn (gen_fix_truncdfsi2_ieee (operands[0], temp, GEN_INT (7)));
  emit_jump (label2);

  emit_label (label1);
  emit_insn (gen_fix_truncdfsi2_ieee (operands[0], operands[1], GEN_INT (5)));
  emit_label (label2);
  DONE;
})

(define_expand "fix_truncdfsi2"
  [(set (match_operand:SI 0 "register_operand" "")
        (fix:SI (match_operand:DF 1 "nonimmediate_operand" "")))]
  "TARGET_HARD_FLOAT"
{
  if (TARGET_IBM_FLOAT)
    {
      /* This is the algorithm from POP chapter A.5.7.2.  */

      rtx temp   = assign_stack_local (BLKmode, 8, BITS_PER_WORD);
      rtx two31r = s390_gen_rtx_const_DI (0x4f000000, 0x08000000);
      rtx two32  = s390_gen_rtx_const_DI (0x4e000001, 0x00000000);

      operands[1] = force_reg (DFmode, operands[1]);
      emit_insn (gen_fix_truncdfsi2_ibm (operands[0], operands[1],
					 two31r, two32, temp));
    }
  else
    {
      operands[1] = force_reg (DFmode, operands[1]);
      emit_insn (gen_fix_truncdfsi2_ieee (operands[0], operands[1], GEN_INT (5)));
    }

  DONE;
})

(define_insn "fix_truncdfsi2_ieee"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (fix:SI (match_operand:DF 1 "register_operand" "f")))
    (unspec:SI [(match_operand:SI 2 "immediate_operand" "K")] UNSPEC_ROUND)
    (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "cfdbr\t%0,%h2,%1"
   [(set_attr "op_type" "RRE")
    (set_attr "type"    "other" )])

(define_insn "fix_truncdfsi2_ibm"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (fix:SI (match_operand:DF 1 "nonimmediate_operand" "+f")))
   (use (match_operand:DI 2 "immediate_operand" "m"))
   (use (match_operand:DI 3 "immediate_operand" "m"))
   (use (match_operand:BLK 4 "memory_operand" "m"))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
{
   output_asm_insn ("sd\t%1,%2", operands);
   output_asm_insn ("aw\t%1,%3", operands);
   output_asm_insn ("std\t%1,%4", operands);
   output_asm_insn ("xi\t%N4,128", operands);
   return "l\t%0,%N4";
}
  [(set_attr "op_type" "NN")
   (set_attr "type"    "ftoi")
   (set_attr "atype"   "agen")
   (set_attr "length"  "20")])

;
; fixuns_truncsfdi2 and fix_truncsfdi2 instruction pattern(s).
;

(define_expand "fixuns_truncsfdi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (unsigned_fix:DI (match_operand:SF 1 "register_operand" "")))]
  "TARGET_64BIT && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
{
  rtx label1 = gen_label_rtx ();
  rtx label2 = gen_label_rtx ();
  rtx temp = gen_reg_rtx (SFmode);

  operands[1] = force_reg (SFmode, operands[1]);
  emit_insn (gen_cmpsf (operands[1],
	CONST_DOUBLE_FROM_REAL_VALUE (
          REAL_VALUE_ATOF ("9223372036854775808.0", SFmode), SFmode)));
  emit_jump_insn (gen_blt (label1));

  emit_insn (gen_subsf3 (temp, operands[1],
	CONST_DOUBLE_FROM_REAL_VALUE (
          REAL_VALUE_ATOF ("18446744073709551616.0", SFmode), SFmode)));
  emit_insn (gen_fix_truncsfdi2_ieee (operands[0], temp, GEN_INT(7)));
  emit_jump (label2);

  emit_label (label1);
  emit_insn (gen_fix_truncsfdi2_ieee (operands[0], operands[1], GEN_INT(5)));
  emit_label (label2);
  DONE;
})

(define_expand "fix_truncsfdi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (fix:DI (match_operand:SF 1 "nonimmediate_operand" "")))]
  "TARGET_64BIT && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
{
  operands[1] = force_reg (SFmode, operands[1]);
  emit_insn (gen_fix_truncsfdi2_ieee (operands[0], operands[1], GEN_INT(5)));
  DONE;
})

(define_insn "fix_truncsfdi2_ieee"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (fix:DI (match_operand:SF 1 "register_operand"  "f")))
   (unspec:DI [(match_operand:DI 2 "immediate_operand" "K")] UNSPEC_ROUND)
   (clobber (reg:CC 33))]
  "TARGET_64BIT && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "cgebr\t%0,%h2,%1"
  [(set_attr "op_type" "RRE")
   (set_attr "type"    "ftoi")])

;
; fixuns_truncsfsi2 and fix_truncsfsi2 instruction pattern(s).
;

(define_expand "fixuns_truncsfsi2"
  [(set (match_operand:SI 0 "register_operand" "")
        (unsigned_fix:SI (match_operand:SF 1 "register_operand" "")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
{
  rtx label1 = gen_label_rtx ();
  rtx label2 = gen_label_rtx ();
  rtx temp = gen_reg_rtx (SFmode);

  operands[1] = force_reg (SFmode, operands[1]);
  emit_insn (gen_cmpsf (operands[1],
	CONST_DOUBLE_FROM_REAL_VALUE (
          REAL_VALUE_ATOF ("2147483648.0", SFmode), SFmode)));
  emit_jump_insn (gen_blt (label1));
  emit_insn (gen_subsf3 (temp, operands[1],
	CONST_DOUBLE_FROM_REAL_VALUE (
          REAL_VALUE_ATOF ("4294967296.0", SFmode), SFmode)));
  emit_insn (gen_fix_truncsfsi2_ieee (operands[0], temp, GEN_INT (7)));
  emit_jump (label2);

  emit_label (label1);
  emit_insn (gen_fix_truncsfsi2_ieee (operands[0], operands[1], GEN_INT (5)));
  emit_label (label2);
  DONE;
})

(define_expand "fix_truncsfsi2"
  [(set (match_operand:SI 0 "register_operand" "")
        (fix:SI (match_operand:SF 1 "nonimmediate_operand" "")))]
  "TARGET_HARD_FLOAT"
{
  if (TARGET_IBM_FLOAT)
    {
      /* Convert to DFmode and then use the POP algorithm.  */
      rtx temp = gen_reg_rtx (DFmode);
      emit_insn (gen_extendsfdf2 (temp, operands[1]));
      emit_insn (gen_fix_truncdfsi2 (operands[0], temp));
    }
  else
    {
      operands[1] = force_reg (SFmode, operands[1]);
      emit_insn (gen_fix_truncsfsi2_ieee (operands[0], operands[1], GEN_INT (5)));
    }

  DONE;
})

(define_insn "fix_truncsfsi2_ieee"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (fix:SI (match_operand:SF 1 "register_operand" "f")))
    (unspec:SI [(match_operand:SI 2 "immediate_operand" "K")] UNSPEC_ROUND)
    (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "cfebr\t%0,%h2,%1"
  [(set_attr "op_type" "RRE")
   (set_attr "type"    "ftoi")])

;
; floatdidf2 instruction pattern(s).
;

(define_insn "floatdidf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (float:DF (match_operand:DI 1 "register_operand" "d")))
   (clobber (reg:CC 33))]
  "TARGET_64BIT && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "cdgbr\t%0,%1"
  [(set_attr "op_type" "RRE")
   (set_attr "type"    "itof" )])

;
; floatdisf2 instruction pattern(s).
;

(define_insn "floatdisf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (float:SF (match_operand:DI 1 "register_operand" "d")))
   (clobber (reg:CC 33))]
  "TARGET_64BIT && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "cegbr\t%0,%1"
  [(set_attr "op_type" "RRE")
   (set_attr "type"    "itof" )])

;
; floatsidf2 instruction pattern(s).
;

(define_expand "floatsidf2"
  [(parallel
    [(set (match_operand:DF 0 "register_operand" "")
          (float:DF (match_operand:SI 1 "register_operand" "")))
     (clobber (reg:CC 33))])]
  "TARGET_HARD_FLOAT"
{
  if (TARGET_IBM_FLOAT)
    {
      /* This is the algorithm from POP chapter A.5.7.1.  */

      rtx temp  = assign_stack_local (BLKmode, 8, BITS_PER_WORD);
      rtx two31 = s390_gen_rtx_const_DI (0x4e000000, 0x80000000);

      emit_insn (gen_floatsidf2_ibm (operands[0], operands[1], two31, temp));
      DONE;
    }
})

(define_insn "floatsidf2_ieee"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (float:DF (match_operand:SI 1 "register_operand"  "d")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "cdfbr\t%0,%1"
  [(set_attr "op_type" "RRE")
   (set_attr "type"   "itof" )])

(define_insn "floatsidf2_ibm"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (float:DF (match_operand:SI 1 "register_operand" "d")))
   (use (match_operand:DI 2 "immediate_operand" "m"))
   (use (match_operand:BLK 3 "memory_operand" "m"))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
{
   output_asm_insn ("st\t%1,%N3", operands);
   output_asm_insn ("xi\t%N3,128", operands);
   output_asm_insn ("mvc\t%O3(4,%R3),%2", operands);
   output_asm_insn ("ld\t%0,%3", operands);
   return "sd\t%0,%2";
}
  [(set_attr "op_type" "NN")
   (set_attr "type"    "other" )
   (set_attr "atype"   "agen")
   (set_attr "length"  "20")])

;
; floatsisf2 instruction pattern(s).
;

(define_expand "floatsisf2"
  [(parallel
    [(set (match_operand:SF 0 "register_operand" "")
          (float:SF (match_operand:SI 1 "register_operand" "")))
     (clobber (reg:CC 33))])]
  "TARGET_HARD_FLOAT"
{
  if (TARGET_IBM_FLOAT)
    {
      /* Use the POP algorithm to convert to DFmode and then truncate.  */
      rtx temp = gen_reg_rtx (DFmode);
      emit_insn (gen_floatsidf2 (temp, operands[1]));
      emit_insn (gen_truncdfsf2 (operands[0], temp));
      DONE;
    }
})

(define_insn "floatsisf2_ieee"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (float:SF (match_operand:SI 1 "register_operand" "d")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "cefbr\t%0,%1"
  [(set_attr "op_type" "RRE")
   (set_attr "type"    "itof" )])

;
; truncdfsf2 instruction pattern(s).
;

(define_expand "truncdfsf2"
  [(set (match_operand:SF 0 "register_operand" "")
        (float_truncate:SF (match_operand:DF 1 "general_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "truncdfsf2_ieee"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (float_truncate:SF (match_operand:DF 1 "general_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "ledbr\t%0,%1"
  [(set_attr "op_type"  "RRE")])

(define_insn "truncdfsf2_ibm"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (float_truncate:SF (match_operand:DF 1 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   lrer\t%0,%1
   le\t%0,%1"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"   "floads,floads")])

;
; extendsfdf2 instruction pattern(s).
;

(define_expand "extendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "")
        (float_extend:DF (match_operand:SF 1 "nonimmediate_operand" "")))]
  "TARGET_HARD_FLOAT"
{
  if (TARGET_IBM_FLOAT)
    {
      emit_insn (gen_extendsfdf2_ibm (operands[0], operands[1]));
      DONE;
    }
})

(define_insn "extendsfdf2_ieee"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (float_extend:DF (match_operand:SF 1 "nonimmediate_operand"  "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   ldebr\t%0,%1
   ldeb\t%0,%1"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"   "floads,floads")])

(define_insn "extendsfdf2_ibm"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (float_extend:DF (match_operand:SF 1 "nonimmediate_operand" "f,R")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   sdr\t%0,%0\;ler\t%0,%1
   sdr\t%0,%0\;le\t%0,%1"
  [(set_attr "op_type"  "NN,NN")
   (set_attr "atype"    "reg,agen")
   (set_attr "length"   "4,6")
   (set_attr "type"     "o2,o2")])


;;
;; ARITHMETIC OPERATIONS
;;
;  arithmetic operations set the ConditionCode,
;  because of unpredictable Bits in Register for Halfword and Byte
;  the ConditionCode can be set wrong in operations for Halfword and Byte

;;
;;- Add instructions.
;;

;
; adddi3 instruction pattern(s).
;

(define_insn "*adddi3_sign"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (plus:DI (sign_extend:DI (match_operand:SI 2 "general_operand" "d,m"))
                 (match_operand:DI 1 "register_operand" "0,0")))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "@
   agfr\t%0,%2
   agf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_zero_cc"
  [(set (reg 33)
        (compare (plus:DI (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m"))
                          (match_operand:DI 1 "register_operand" "0,0"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (plus:DI (zero_extend:DI (match_dup 2)) (match_dup 1)))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   algfr\t%0,%2
   algf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_zero_cconly"
  [(set (reg 33)
        (compare (plus:DI (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m"))
                          (match_operand:DI 1 "register_operand" "0,0"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   algfr\t%0,%2
   algf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_zero"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (plus:DI (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m"))
                 (match_operand:DI 1 "register_operand" "0,0")))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "@
   algfr\t%0,%2
   algf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_imm_cc"
  [(set (reg 33)
        (compare (plus:DI (match_operand:DI 1 "nonimmediate_operand" "0")
                          (match_operand:DI 2 "const_int_operand" "K"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d")
        (plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT
   && s390_match_ccmode (insn, CCAmode)
   && CONST_OK_FOR_CONSTRAINT_P (INTVAL (operands[2]), 'K', \"K\")"
  "aghi\t%0,%h2"
  [(set_attr "op_type"  "RI")])

(define_insn "*adddi3_carry1_cc"
  [(set (reg 33)
        (compare (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                          (match_operand:DI 2 "general_operand" "d,m"))
                 (match_dup 1)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (plus:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCL1mode) && TARGET_64BIT"
  "@
   algr\t%0,%2
   alg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_carry1_cconly"
  [(set (reg 33)
        (compare (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                          (match_operand:DI 2 "general_operand" "d,m"))
                 (match_dup 1)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode (insn, CCL1mode) && TARGET_64BIT"
  "@
   algr\t%0,%2
   alg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_carry2_cc"
  [(set (reg 33)
        (compare (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                          (match_operand:DI 2 "general_operand" "d,m"))
                 (match_dup 2)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (plus:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCL1mode) && TARGET_64BIT"
  "@
   algr\t%0,%2
   alg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_carry2_cconly"
  [(set (reg 33)
        (compare (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                          (match_operand:DI 2 "general_operand" "d,m"))
                 (match_dup 2)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode (insn, CCL1mode) && TARGET_64BIT"
  "@
   algr\t%0,%2
   alg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_cc"
  [(set (reg 33)
        (compare (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                          (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (plus:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   algr\t%0,%2
   alg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_cconly"
  [(set (reg 33)
        (compare (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                          (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   algr\t%0,%2
   alg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_cconly2"
  [(set (reg 33)
        (compare (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                 (neg:SI (match_operand:DI 2 "general_operand" "d,m"))))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode(insn, CCLmode) && TARGET_64BIT"
  "@
   algr\t%0,%2
   alg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_64"
  [(set (match_operand:DI 0 "register_operand" "=d,d,d")
        (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0,0")
                 (match_operand:DI 2 "general_operand" "d,K,m") ) )
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "@
   agr\t%0,%2
   aghi\t%0,%h2
   ag\t%0,%2"
  [(set_attr "op_type"  "RRE,RI,RXY")])

(define_insn_and_split "*adddi3_31z"
  [(set (match_operand:DI 0 "register_operand" "=&d")
        (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0")
                 (match_operand:DI 2 "general_operand" "do") ) )
   (clobber (reg:CC 33))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (reg:CCL1 33)
          (compare:CCL1 (plus:SI (match_dup 7) (match_dup 8))
                        (match_dup 7)))
     (set (match_dup 6) (plus:SI (match_dup 7) (match_dup 8)))])
   (parallel
    [(set (match_dup 3) (plus:SI (plus:SI (match_dup 4) (match_dup 5))
                                 (ltu:SI (reg:CCL1 33) (const_int 0))))
     (clobber (reg:CC 33))])]
  "operands[3] = operand_subword (operands[0], 0, 0, DImode);
   operands[4] = operand_subword (operands[1], 0, 0, DImode);
   operands[5] = operand_subword (operands[2], 0, 0, DImode);
   operands[6] = operand_subword (operands[0], 1, 0, DImode);
   operands[7] = operand_subword (operands[1], 1, 0, DImode);
   operands[8] = operand_subword (operands[2], 1, 0, DImode);"
  [(set_attr "op_type"  "NN")])

(define_insn_and_split "*adddi3_31"
  [(set (match_operand:DI 0 "register_operand" "=&d")
        (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0")
                 (match_operand:DI 2 "general_operand" "do") ) )
   (clobber (reg:CC 33))]
  "!TARGET_CPU_ZARCH"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 3) (plus:SI (match_dup 4) (match_dup 5)))
     (clobber (reg:CC 33))])
   (parallel
    [(set (reg:CCL1 33)
          (compare:CCL1 (plus:SI (match_dup 7) (match_dup 8))
                        (match_dup 7)))
     (set (match_dup 6) (plus:SI (match_dup 7) (match_dup 8)))])
   (set (pc)
        (if_then_else (ltu (reg:CCL1 33) (const_int 0))
                      (pc)
                      (label_ref (match_dup 9))))
   (parallel
    [(set (match_dup 3) (plus:SI (match_dup 3) (const_int 1)))
     (clobber (reg:CC 33))])
   (match_dup 9)]
  "operands[3] = operand_subword (operands[0], 0, 0, DImode);
   operands[4] = operand_subword (operands[1], 0, 0, DImode);
   operands[5] = operand_subword (operands[2], 0, 0, DImode);
   operands[6] = operand_subword (operands[0], 1, 0, DImode);
   operands[7] = operand_subword (operands[1], 1, 0, DImode);
   operands[8] = operand_subword (operands[2], 1, 0, DImode);
   operands[9] = gen_label_rtx ();"
  [(set_attr "op_type"  "NN")])

(define_expand "adddi3"
  [(parallel
    [(set (match_operand:DI 0 "register_operand" "")
          (plus:DI (match_operand:DI 1 "nonimmediate_operand" "")
                   (match_operand:DI 2 "general_operand" "")))
     (clobber (reg:CC 33))])]
  ""
  "")

;
; addsi3 instruction pattern(s).
;

(define_insn "*addsi3_imm_cc"
  [(set (reg 33)
        (compare (plus:SI (match_operand:SI 1 "nonimmediate_operand" "0")
                          (match_operand:SI 2 "const_int_operand" "K"))
                 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d")
        (plus:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCAmode)
   && CONST_OK_FOR_CONSTRAINT_P (INTVAL (operands[2]), 'K', \"K\")"
  "ahi\t%0,%h2"
  [(set_attr "op_type"  "RI")])

(define_insn "*addsi3_carry1_cc"
  [(set (reg 33)
        (compare (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                          (match_operand:SI 2 "general_operand" "d,R,T"))
                 (match_dup 1)))
   (set (match_operand:SI 0 "register_operand" "=d,d,d")
        (plus:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCL1mode)"
  "@
   alr\t%0,%2
   al\t%0,%2
   aly\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*addsi3_carry1_cconly"
  [(set (reg 33)
        (compare (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                          (match_operand:SI 2 "general_operand" "d,R,T"))
                 (match_dup 1)))
   (clobber (match_scratch:SI 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCL1mode)"
  "@
   alr\t%0,%2
   al\t%0,%2
   aly\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*addsi3_carry2_cc"
  [(set (reg 33)
        (compare (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                          (match_operand:SI 2 "general_operand" "d,R,T"))
                 (match_dup 2)))
   (set (match_operand:SI 0 "register_operand" "=d,d,d")
        (plus:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCL1mode)"
  "@
   alr\t%0,%2
   al\t%0,%2
   aly\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*addsi3_carry2_cconly"
  [(set (reg 33)
        (compare (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                          (match_operand:SI 2 "general_operand" "d,R,T"))
                 (match_dup 2)))
   (clobber (match_scratch:SI 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCL1mode)"
  "@
   alr\t%0,%2
   al\t%0,%2
   aly\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*addsi3_cc"
  [(set (reg 33)
        (compare (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                          (match_operand:SI 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d,d,d")
        (plus:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCLmode)"
  "@
   alr\t%0,%2
   al\t%0,%2
   aly\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*addsi3_cconly"
  [(set (reg 33)
        (compare (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                          (match_operand:SI 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (clobber (match_scratch:SI 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCLmode)"
  "@
   alr\t%0,%2
   al\t%0,%2
   aly\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*addsi3_cconly2"
  [(set (reg 33)
        (compare (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                 (neg:SI (match_operand:SI 2 "general_operand" "d,R,T"))))
   (clobber (match_scratch:SI 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCLmode)"
  "@
   alr\t%0,%2
   al\t%0,%2
   aly\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*addsi3_sign"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (plus:SI (match_operand:SI 1 "register_operand" "0,0")
                 (sign_extend:SI (match_operand:HI 2 "memory_operand" "R,T"))))
   (clobber (reg:CC 33))]
  ""
  "@
   ah\t%0,%2
   ahy\t%0,%2"
  [(set_attr "op_type"  "RX,RXY")])

(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=d,d,d,d")
        (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0")
                 (match_operand:SI 2 "general_operand" "d,K,R,T")))
   (clobber (reg:CC 33))]
  ""
  "@
   ar\t%0,%2
   ahi\t%0,%h2
   a\t%0,%2
   ay\t%0,%2"
  [(set_attr "op_type"  "RR,RI,RX,RXY")])

;
; adddf3 instruction pattern(s).
;

(define_expand "adddf3"
  [(parallel
    [(set (match_operand:DF 0 "register_operand" "=f,f")
          (plus:DF (match_operand:DF 1 "nonimmediate_operand" "%0,0")
                   (match_operand:DF 2 "general_operand" "f,R")))
     (clobber (reg:CC 33))])]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*adddf3"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (plus:DF (match_operand:DF 1 "nonimmediate_operand" "%0,0")
                 (match_operand:DF 2 "general_operand" "f,R")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   adbr\t%0,%2
   adb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimpd,fsimpd")])

(define_insn "*adddf3_cc"
  [(set (reg 33)
	(compare (plus:DF (match_operand:DF 1 "nonimmediate_operand" "%0,0")
			  (match_operand:DF 2 "general_operand" "f,R"))
		 (match_operand:DF 3 "const0_operand" "")))
   (set (match_operand:DF 0 "register_operand" "=f,f")
	(plus:DF (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   adbr\t%0,%2
   adb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimpd,fsimpd")])

(define_insn "*adddf3_cconly"
  [(set (reg 33)
	(compare (plus:DF (match_operand:DF 1 "nonimmediate_operand" "%0,0")
			  (match_operand:DF 2 "general_operand" "f,R"))
		 (match_operand:DF 3 "const0_operand" "")))
   (clobber (match_scratch:DF 0 "=f,f"))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
  adbr\t%0,%2
  adb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimpd,fsimpd")])

(define_insn "*adddf3_ibm"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (plus:DF (match_operand:DF 1 "nonimmediate_operand" "%0,0")
                 (match_operand:DF 2 "general_operand" "f,R")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   adr\t%0,%2
   ad\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"     "fsimpd,fsimpd")])

;
; addsf3 instruction pattern(s).
;

(define_expand "addsf3"
  [(parallel
    [(set (match_operand:SF 0 "register_operand" "=f,f")
          (plus:SF (match_operand:SF 1 "nonimmediate_operand" "%0,0")
                   (match_operand:SF 2 "general_operand" "f,R")))
     (clobber (reg:CC 33))])]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*addsf3"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (plus:SF (match_operand:SF 1 "nonimmediate_operand" "%0,0")
                 (match_operand:SF 2 "general_operand" "f,R")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   aebr\t%0,%2
   aeb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimps,fsimps")])

(define_insn "*addsf3_cc"
  [(set (reg 33)
	(compare (plus:SF (match_operand:SF 1 "nonimmediate_operand" "%0,0")
			  (match_operand:SF 2 "general_operand" "f,R"))
		 (match_operand:SF 3 "const0_operand" "")))
   (set (match_operand:SF 0 "register_operand" "=f,f")
	(plus:SF (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   aebr\t%0,%2
   aeb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimps,fsimps")])

(define_insn "*addsf3_cconly"
  [(set (reg 33)
	(compare (plus:SF (match_operand:SF 1 "nonimmediate_operand" "%0,0")
			  (match_operand:SF 2 "general_operand" "f,R"))
		 (match_operand:SF 3 "const0_operand" "")))
   (clobber (match_scratch:SF 0 "=f,f"))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   aebr\t%0,%2
   aeb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimps,fsimps")])

(define_insn "*addsf3"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (plus:SF (match_operand:SF 1 "nonimmediate_operand" "%0,0")
                 (match_operand:SF 2 "general_operand" "f,R")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   aer\t%0,%2
   ae\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"     "fsimps,fsimps")])


;;
;;- Subtract instructions.
;;

;
; subdi3 instruction pattern(s).
;

(define_insn "*subdi3_sign"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                  (sign_extend:DI (match_operand:SI 2 "general_operand" "d,m"))))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "@
   sgfr\t%0,%2
   sgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_zero_cc"
  [(set (reg 33)
        (compare (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                           (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m")))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (minus:DI (match_dup 1) (zero_extend:DI (match_dup 2))))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   slgfr\t%0,%2
   slgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_zero_cconly"
  [(set (reg 33)
        (compare (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                           (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m")))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   slgfr\t%0,%2
   slgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_zero"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                  (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m"))))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "@
   slgfr\t%0,%2
   slgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_borrow_cc"
  [(set (reg 33)
        (compare (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                           (match_operand:DI 2 "general_operand" "d,m"))
                 (match_dup 1)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (minus:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCL2mode) && TARGET_64BIT"
  "@
   slgr\t%0,%2
   slg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_borrow_cconly"
  [(set (reg 33)
        (compare (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                           (match_operand:DI 2 "general_operand" "d,m"))
                 (match_dup 1)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode (insn, CCL2mode) && TARGET_64BIT"
  "@
   slgr\t%0,%2
   slg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_cc"
  [(set (reg 33)
        (compare (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                           (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (minus:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   slgr\t%0,%2
   slg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_cconly"
  [(set (reg 33)
        (compare (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                           (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   slgr\t%0,%2
   slg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_64"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                  (match_operand:DI 2 "general_operand" "d,m") ) )
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "@
   sgr\t%0,%2
   sg\t%0,%2"
  [(set_attr "op_type"  "RRE,RRE")])

(define_insn_and_split "*subdi3_31z"
  [(set (match_operand:DI 0 "register_operand" "=&d")
        (minus:DI (match_operand:DI 1 "register_operand" "0")
                  (match_operand:DI 2 "general_operand" "do") ) )
   (clobber (reg:CC 33))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (reg:CCL2 33)
          (compare:CCL2 (minus:SI (match_dup 7) (match_dup 8))
                        (match_dup 7)))
     (set (match_dup 6) (minus:SI (match_dup 7) (match_dup 8)))])
   (parallel
    [(set (match_dup 3) (minus:SI (minus:SI (match_dup 4) (match_dup 5))
                                  (gtu:SI (reg:CCL2 33) (const_int 0))))
     (clobber (reg:CC 33))])]
  "operands[3] = operand_subword (operands[0], 0, 0, DImode);
   operands[4] = operand_subword (operands[1], 0, 0, DImode);
   operands[5] = operand_subword (operands[2], 0, 0, DImode);
   operands[6] = operand_subword (operands[0], 1, 0, DImode);
   operands[7] = operand_subword (operands[1], 1, 0, DImode);
   operands[8] = operand_subword (operands[2], 1, 0, DImode);"
  [(set_attr "op_type"  "NN")])

(define_insn_and_split "*subdi3_31"
  [(set (match_operand:DI 0 "register_operand" "=&d")
        (minus:DI (match_operand:DI 1 "register_operand" "0")
                  (match_operand:DI 2 "general_operand" "do") ) )
   (clobber (reg:CC 33))]
  "!TARGET_CPU_ZARCH"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 3) (minus:SI (match_dup 4) (match_dup 5)))
     (clobber (reg:CC 33))])
   (parallel
    [(set (reg:CCL2 33)
          (compare:CCL2 (minus:SI (match_dup 7) (match_dup 8))
                        (match_dup 7)))
     (set (match_dup 6) (minus:SI (match_dup 7) (match_dup 8)))])
   (set (pc)
        (if_then_else (gtu (reg:CCL2 33) (const_int 0))
                      (pc)
                      (label_ref (match_dup 9))))
   (parallel
    [(set (match_dup 3) (plus:SI (match_dup 3) (const_int -1)))
     (clobber (reg:CC 33))])
   (match_dup 9)]
  "operands[3] = operand_subword (operands[0], 0, 0, DImode);
   operands[4] = operand_subword (operands[1], 0, 0, DImode);
   operands[5] = operand_subword (operands[2], 0, 0, DImode);
   operands[6] = operand_subword (operands[0], 1, 0, DImode);
   operands[7] = operand_subword (operands[1], 1, 0, DImode);
   operands[8] = operand_subword (operands[2], 1, 0, DImode);
   operands[9] = gen_label_rtx ();"
  [(set_attr "op_type"  "NN")])

(define_expand "subdi3"
  [(parallel
    [(set (match_operand:DI 0 "register_operand" "")
          (minus:DI (match_operand:DI 1 "register_operand" "")
                    (match_operand:DI 2 "general_operand" "")))
     (clobber (reg:CC 33))])]
  ""
  "")

;
; subsi3 instruction pattern(s).
;

(define_insn "*subsi3_borrow_cc"
  [(set (reg 33)
        (compare (minus:SI (match_operand:SI 1 "register_operand" "0,0,0")
                           (match_operand:SI 2 "general_operand" "d,R,T"))
                 (match_dup 1)))
   (set (match_operand:SI 0 "register_operand" "=d,d,d")
        (minus:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCL2mode)"
  "@
   slr\t%0,%2
   sl\t%0,%2
   sly\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*subsi3_borrow_cconly"
  [(set (reg 33)
        (compare (minus:SI (match_operand:SI 1 "register_operand" "0,0,0")
                           (match_operand:SI 2 "general_operand" "d,R,T"))
                 (match_dup 1)))
   (clobber (match_scratch:SI 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCL2mode)"
  "@
   slr\t%0,%2
   sl\t%0,%2
   sly\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*subsi3_cc"
  [(set (reg 33)
        (compare (minus:SI (match_operand:SI 1 "register_operand" "0,0,0")
                           (match_operand:SI 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d,d,d")
        (minus:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCLmode)"
  "@
   slr\t%0,%2
   sl\t%0,%2
   sly\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*subsi3_cconly"
  [(set (reg 33)
        (compare (minus:SI (match_operand:SI 1 "register_operand" "0,0,0")
                           (match_operand:SI 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (clobber (match_scratch:SI 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCLmode)"
  "@
   slr\t%0,%2
   sl\t%0,%2
   sly\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*subsi3_sign"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (minus:SI (match_operand:SI 1 "register_operand" "0,0")
                  (sign_extend:SI (match_operand:HI 2 "memory_operand" "R,T"))))
   (clobber (reg:CC 33))]
  ""
  "@
   sh\t%0,%2
   shy\t%0,%2"
  [(set_attr "op_type"  "RX,RXY")])

(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=d,d,d")
        (minus:SI (match_operand:SI 1 "register_operand" "0,0,0")
                  (match_operand:SI 2 "general_operand" "d,R,T")))
   (clobber (reg:CC 33))]
  ""
  "@
   sr\t%0,%2
   s\t%0,%2
   sy\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])


;
; subdf3 instruction pattern(s).
;

(define_expand "subdf3"
  [(parallel
    [(set (match_operand:DF 0 "register_operand" "=f,f")
          (minus:DF (match_operand:DF 1 "register_operand" "0,0")
                    (match_operand:DF 2 "general_operand" "f,R")))
     (clobber (reg:CC 33))])]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*subdf3"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (minus:DF (match_operand:DF 1 "register_operand" "0,0")
                  (match_operand:DF 2 "general_operand" "f,R")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   sdbr\t%0,%2
   sdb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimpd,fsimpd")])

(define_insn "*subdf3_cc"
  [(set (reg 33)
	(compare (minus:DF (match_operand:DF 1 "nonimmediate_operand" "0,0")
			   (match_operand:DF 2 "general_operand" "f,R"))
		 (match_operand:DF 3 "const0_operand" "")))
   (set (match_operand:DF 0 "register_operand" "=f,f")
	(plus:DF (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   sdbr\t%0,%2
   sdb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimpd,fsimpd")])

(define_insn "*subdf3_cconly"
  [(set (reg 33)
	(compare (minus:DF (match_operand:DF 1 "nonimmediate_operand" "0,0")
			   (match_operand:DF 2 "general_operand" "f,R"))
		 (match_operand:DF 3 "const0_operand" "")))
   (clobber (match_scratch:DF 0 "=f,f"))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   sdbr\t%0,%2
   sdb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimpd,fsimpd")])

(define_insn "*subdf3_ibm"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (minus:DF (match_operand:DF 1 "register_operand" "0,0")
                  (match_operand:DF 2 "general_operand" "f,R")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   sdr\t%0,%2
   sd\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"     "fsimpd,fsimpd")])

;
; subsf3 instruction pattern(s).
;

(define_expand "subsf3"
  [(parallel
    [(set (match_operand:SF 0 "register_operand" "=f,f")
          (minus:SF (match_operand:SF 1 "register_operand" "0,0")
                    (match_operand:SF 2 "general_operand" "f,R")))
     (clobber (reg:CC 33))])]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*subsf3"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (minus:SF (match_operand:SF 1 "register_operand" "0,0")
                  (match_operand:SF 2 "general_operand" "f,R")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   sebr\t%0,%2
   seb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimps,fsimps")])

(define_insn "*subsf3_cc"
  [(set (reg 33)
	(compare (minus:SF (match_operand:SF 1 "nonimmediate_operand" "0,0")
			   (match_operand:SF 2 "general_operand" "f,R"))
		 (match_operand:SF 3 "const0_operand" "")))
   (set (match_operand:SF 0 "register_operand" "=f,f")
	(minus:SF (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   sebr\t%0,%2
   seb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimps,fsimps")])

(define_insn "*subsf3_cconly"
  [(set (reg 33)
	(compare (minus:SF (match_operand:SF 1 "nonimmediate_operand" "0,0")
			   (match_operand:SF 2 "general_operand" "f,R"))
		 (match_operand:SF 3 "const0_operand" "")))
   (clobber (match_scratch:SF 0 "=f,f"))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   sebr\t%0,%2
   seb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimps,fsimps")])

(define_insn "*subsf3_ibm"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (minus:SF (match_operand:SF 1 "register_operand" "0,0")
                  (match_operand:SF 2 "general_operand" "f,R")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   ser\t%0,%2
   se\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"     "fsimps,fsimps")])


;;
;;- Conditional add/subtract instructions.
;;

;
; adddicc instruction pattern(s).
;

(define_insn "*adddi3_alc_cc"
  [(set (reg 33) 
        (compare
          (plus:DI (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                            (match_operand:DI 2 "general_operand" "d,m"))
                   (match_operand:DI 3 "s390_alc_comparison" ""))
          (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (plus:DI (plus:DI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT" 
  "@
   alcgr\\t%0,%2
   alcg\\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_alc"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (plus:DI (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                          (match_operand:DI 2 "general_operand" "d,m"))
                 (match_operand:DI 3 "s390_alc_comparison" "")))
   (clobber (reg:CC 33))] 
  "TARGET_64BIT" 
  "@
   alcgr\\t%0,%2
   alcg\\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_slb_cc"
  [(set (reg 33) 
        (compare
          (minus:DI (minus:DI (match_operand:DI 1 "nonimmediate_operand" "0,0")
                              (match_operand:DI 2 "general_operand" "d,m"))
                    (match_operand:DI 3 "s390_slb_comparison" ""))
          (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (minus:DI (minus:DI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT" 
  "@
   slbgr\\t%0,%2
   slbg\\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_slb"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (minus:DI (minus:DI (match_operand:DI 1 "nonimmediate_operand" "0,0")
                            (match_operand:DI 2 "general_operand" "d,m"))
                  (match_operand:DI 3 "s390_slb_comparison" "")))
   (clobber (reg:CC 33))] 
  "TARGET_64BIT" 
  "@
   slbgr\\t%0,%2
   slbg\\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

;
; addsicc instruction pattern(s).
;

(define_insn "*addsi3_alc_cc"
  [(set (reg 33) 
        (compare
          (plus:SI (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0")
                            (match_operand:SI 2 "general_operand" "d,m"))
                   (match_operand:SI 3 "s390_alc_comparison" ""))
          (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d,d")
        (plus:SI (plus:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_CPU_ZARCH" 
  "@
   alcr\\t%0,%2
   alc\\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*addsi3_alc"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (plus:SI (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0")
                          (match_operand:SI 2 "general_operand" "d,m"))
                 (match_operand:SI 3 "s390_alc_comparison" "")))
   (clobber (reg:CC 33))]
  "TARGET_CPU_ZARCH" 
  "@
   alcr\\t%0,%2
   alc\\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subsi3_slb_cc"
  [(set (reg 33) 
        (compare
          (minus:SI (minus:SI (match_operand:SI 1 "nonimmediate_operand" "0,0")
                              (match_operand:SI 2 "general_operand" "d,m"))
                    (match_operand:SI 3 "s390_slb_comparison" ""))
          (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d,d")
        (minus:SI (minus:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_CPU_ZARCH" 
  "@
   slbr\\t%0,%2
   slb\\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subsi3_slb"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (minus:SI (minus:SI (match_operand:SI 1 "nonimmediate_operand" "0,0")
                            (match_operand:SI 2 "general_operand" "d,m"))
                  (match_operand:SI 3 "s390_slb_comparison" "")))
   (clobber (reg:CC 33))] 
  "TARGET_CPU_ZARCH" 
  "@
   slbr\\t%0,%2
   slb\\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])


;;
;;- Multiply instructions.
;;

;
; muldi3 instruction pattern(s).
;

(define_insn "*muldi3_sign"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (mult:DI (sign_extend:DI (match_operand:SI 2 "nonimmediate_operand" "d,m"))
                 (match_operand:DI 1 "register_operand" "0,0")))]
  "TARGET_64BIT"
  "@
   msgfr\t%0,%2
   msgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "imul")])

(define_insn "muldi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d,d")
        (mult:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0,0")
                 (match_operand:DI 2 "general_operand" "d,K,m")))]
  "TARGET_64BIT"
  "@
   msgr\t%0,%2
   mghi\t%0,%h2
   msg\t%0,%2"
  [(set_attr "op_type"  "RRE,RI,RXY")
   (set_attr "type"     "imul")])

;
; mulsi3 instruction pattern(s).
;

(define_insn "*mulsi3_sign"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (mult:SI (sign_extend:SI (match_operand:HI 2 "memory_operand" "R"))
                 (match_operand:SI 1 "register_operand" "0")))]
  ""
  "mh\t%0,%2"
  [(set_attr "op_type"  "RX")
   (set_attr "type"     "imul")])

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "register_operand" "=d,d,d,d")
        (mult:SI  (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0")
                  (match_operand:SI 2 "general_operand" "d,K,R,T")))]
  ""
  "@
   msr\t%0,%2
   mhi\t%0,%h2
   ms\t%0,%2
   msy\t%0,%2"
  [(set_attr "op_type"  "RRE,RI,RX,RXY")
   (set_attr "type"     "imul")])

;
; mulsidi3 instruction pattern(s).
;

(define_insn "mulsidi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (mult:DI (sign_extend:DI
	           (match_operand:SI 1 "register_operand" "%0,0"))
                 (sign_extend:DI
	           (match_operand:SI 2 "nonimmediate_operand" "d,R"))))]
  "!TARGET_64BIT"
  "@
   mr\t%0,%2
   m\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"     "imul")])

;
; umulsidi3 instruction pattern(s).
;

(define_insn "umulsidi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (mult:DI (zero_extend:DI
	           (match_operand:SI 1 "register_operand" "%0,0"))
                 (zero_extend:DI
	           (match_operand:SI 2 "nonimmediate_operand" "d,m"))))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH"
  "@
   mlr\t%0,%2
   ml\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "imul")])

;
; muldf3 instruction pattern(s).
;

(define_expand "muldf3"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (mult:DF (match_operand:DF 1 "nonimmediate_operand" "%0,0")
                 (match_operand:DF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*muldf3"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (mult:DF (match_operand:DF 1 "nonimmediate_operand" "%0,0")
                 (match_operand:DF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   mdbr\t%0,%2
   mdb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fmuld")])

(define_insn "*muldf3_ibm"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (mult:DF (match_operand:DF 1 "nonimmediate_operand" "%0,0")
                 (match_operand:DF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   mdr\t%0,%2
   md\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"    "fmuld")])

(define_insn "*fmadddf"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
	(plus:DF (mult:DF (match_operand:DF 1 "register_operand" "%f,f")
			  (match_operand:DF 2 "nonimmediate_operand"  "f,R"))
		 (match_operand:DF 3 "register_operand" "0,0")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT && TARGET_FUSED_MADD"
  "@
   madbr\t%0,%1,%2
   madb\t%0,%1,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type" "fmuld")])

(define_insn "*fmsubdf"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
	(minus:DF (mult:DF (match_operand:DF 1 "register_operand" "f,f")
			   (match_operand:DF 2 "nonimmediate_operand"  "f,R"))
		 (match_operand:DF 3 "register_operand" "0,0")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT && TARGET_FUSED_MADD"
  "@
   msdbr\t%0,%1,%2
   msdb\t%0,%1,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type" "fmuld")])

;
; mulsf3 instruction pattern(s).
;

(define_expand "mulsf3"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (mult:SF (match_operand:SF 1 "nonimmediate_operand" "%0,0")
                 (match_operand:SF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*mulsf3"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (mult:SF (match_operand:SF 1 "nonimmediate_operand" "%0,0")
                 (match_operand:SF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   meebr\t%0,%2
   meeb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fmuls")])

(define_insn "*mulsf3_ibm"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (mult:SF (match_operand:SF 1 "nonimmediate_operand" "%0,0")
                 (match_operand:SF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   mer\t%0,%2
   me\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"     "fmuls")])

(define_insn "*fmaddsf"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
	(plus:SF (mult:SF (match_operand:SF 1 "register_operand" "%f,f")
			  (match_operand:SF 2 "nonimmediate_operand"  "f,R"))
		 (match_operand:SF 3 "register_operand" "0,0")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT && TARGET_FUSED_MADD"
  "@
   maebr\t%0,%1,%2
   maeb\t%0,%1,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type" "fmuls")])

(define_insn "*fmsubsf"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
	(minus:SF (mult:SF (match_operand:SF 1 "register_operand" "f,f")
			   (match_operand:SF 2 "nonimmediate_operand"  "f,R"))
		  (match_operand:SF 3 "register_operand" "0,0")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT && TARGET_FUSED_MADD"
  "@
   msebr\t%0,%1,%2
   mseb\t%0,%1,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type" "fmuls")])

;;
;;- Divide and modulo instructions.
;;

;
; divmoddi4 instruction pattern(s).
;

(define_expand "divmoddi4"
  [(parallel [(set (match_operand:DI 0 "general_operand" "")
		   (div:DI (match_operand:DI 1 "register_operand" "")
			   (match_operand:DI 2 "general_operand" "")))
	      (set (match_operand:DI 3 "general_operand" "")
		   (mod:DI (match_dup 1) (match_dup 2)))])
   (clobber (match_dup 4))]
  "TARGET_64BIT"
{
  rtx insn, div_equal, mod_equal;

  div_equal = gen_rtx_DIV (DImode, operands[1], operands[2]);
  mod_equal = gen_rtx_MOD (DImode, operands[1], operands[2]);

  operands[4] = gen_reg_rtx(TImode);
  emit_insn (gen_divmodtidi3 (operands[4], operands[1], operands[2]));

  insn = emit_move_insn (operands[0], gen_lowpart (DImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, div_equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[3], gen_highpart (DImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, mod_equal, REG_NOTES (insn));

  DONE;
})

(define_insn "divmodtidi3"
  [(set (match_operand:TI 0 "register_operand" "=d,d")
        (ior:TI
          (zero_extend:TI
            (div:DI (match_operand:DI 1 "register_operand" "0,0")
                    (match_operand:DI 2 "general_operand" "d,m")))
          (ashift:TI
            (zero_extend:TI
              (mod:DI (match_dup 1)
                      (match_dup 2)))
            (const_int 64))))]
  "TARGET_64BIT"
  "@
   dsgr\t%0,%2
   dsg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "idiv")])

(define_insn "divmodtisi3"
  [(set (match_operand:TI 0 "register_operand" "=d,d")
        (ior:TI
          (zero_extend:TI
            (div:DI (match_operand:DI 1 "register_operand" "0,0")
                    (sign_extend:DI (match_operand:SI 2 "nonimmediate_operand" "d,m"))))
          (ashift:TI
            (zero_extend:TI
              (mod:DI (match_dup 1)
                      (sign_extend:DI (match_dup 2))))
            (const_int 64))))]
  "TARGET_64BIT"
  "@
   dsgfr\t%0,%2
   dsgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "idiv")])

;
; udivmoddi4 instruction pattern(s).
;

(define_expand "udivmoddi4"
  [(parallel [(set (match_operand:DI 0 "general_operand" "")
		   (udiv:DI (match_operand:DI 1 "general_operand" "")
			    (match_operand:DI 2 "nonimmediate_operand" "")))
	      (set (match_operand:DI 3 "general_operand" "")
		   (umod:DI (match_dup 1) (match_dup 2)))])
   (clobber (match_dup 4))]
  "TARGET_64BIT"
{
  rtx insn, div_equal, mod_equal, equal;

  div_equal = gen_rtx_UDIV (DImode, operands[1], operands[2]);
  mod_equal = gen_rtx_UMOD (DImode, operands[1], operands[2]);
  equal = gen_rtx_IOR (TImode,
		       gen_rtx_ZERO_EXTEND (TImode, div_equal),
		       gen_rtx_ASHIFT (TImode,
				       gen_rtx_ZERO_EXTEND (TImode, mod_equal),
				       GEN_INT (64)));

  operands[4] = gen_reg_rtx(TImode);
  emit_insn (gen_rtx_CLOBBER (VOIDmode, operands[4]));
  emit_move_insn (gen_lowpart (DImode, operands[4]), operands[1]);
  emit_move_insn (gen_highpart (DImode, operands[4]), const0_rtx);
  insn = emit_insn (gen_udivmodtidi3 (operands[4], operands[4], operands[2]));
  REG_NOTES (insn) =
	gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[0], gen_lowpart (DImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, div_equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[3], gen_highpart (DImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, mod_equal, REG_NOTES (insn));

  DONE;
})

(define_insn "udivmodtidi3"
  [(set (match_operand:TI 0 "register_operand" "=d,d")
        (ior:TI (zero_extend:TI
                  (truncate:DI
                    (udiv:TI (match_operand:TI 1 "register_operand" "0,0")
                             (zero_extend:TI
                               (match_operand:DI 2 "nonimmediate_operand" "d,m")))))
                (ashift:TI
                  (zero_extend:TI
                    (truncate:DI
                      (umod:TI (match_dup 1) (zero_extend:TI (match_dup 2)))))
                  (const_int 64))))]
  "TARGET_64BIT"
  "@
   dlgr\t%0,%2
   dlg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "idiv")])

;
; divmodsi4 instruction pattern(s).
;

(define_expand "divmodsi4"
  [(parallel [(set (match_operand:SI 0 "general_operand" "")
		   (div:SI (match_operand:SI 1 "general_operand" "")
			   (match_operand:SI 2 "nonimmediate_operand" "")))
	      (set (match_operand:SI 3 "general_operand" "")
		   (mod:SI (match_dup 1) (match_dup 2)))])
   (clobber (match_dup 4))]
  "!TARGET_64BIT"
{
  rtx insn, div_equal, mod_equal, equal;

  div_equal = gen_rtx_DIV (SImode, operands[1], operands[2]);
  mod_equal = gen_rtx_MOD (SImode, operands[1], operands[2]);
  equal = gen_rtx_IOR (DImode,
		       gen_rtx_ZERO_EXTEND (DImode, div_equal),
		       gen_rtx_ASHIFT (DImode,
				       gen_rtx_ZERO_EXTEND (DImode, mod_equal),
				       GEN_INT (32)));

  operands[4] = gen_reg_rtx(DImode);
  emit_insn (gen_extendsidi2 (operands[4], operands[1]));
  insn = emit_insn (gen_divmoddisi3 (operands[4], operands[4], operands[2]));
  REG_NOTES (insn) =
	gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[0], gen_lowpart (SImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, div_equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[3], gen_highpart (SImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, mod_equal, REG_NOTES (insn));

  DONE;
})

(define_insn "divmoddisi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (ior:DI (zero_extend:DI
                  (truncate:SI
                    (div:DI (match_operand:DI 1 "register_operand" "0,0")
                            (sign_extend:DI
                              (match_operand:SI 2 "nonimmediate_operand" "d,R")))))
                (ashift:DI
                  (zero_extend:DI
                    (truncate:SI
                      (mod:DI (match_dup 1) (sign_extend:DI (match_dup 2)))))
                  (const_int 32))))]
  "!TARGET_64BIT"
  "@
   dr\t%0,%2
   d\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"     "idiv")])

;
; udivsi3 and umodsi3 instruction pattern(s).
;

(define_expand "udivmodsi4"
  [(parallel [(set (match_operand:SI 0 "general_operand" "")
		   (udiv:SI (match_operand:SI 1 "general_operand" "")
			    (match_operand:SI 2 "nonimmediate_operand" "")))
	      (set (match_operand:SI 3 "general_operand" "")
		   (umod:SI (match_dup 1) (match_dup 2)))])
   (clobber (match_dup 4))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH"
{
  rtx insn, div_equal, mod_equal, equal;

  div_equal = gen_rtx_UDIV (SImode, operands[1], operands[2]);
  mod_equal = gen_rtx_UMOD (SImode, operands[1], operands[2]);
  equal = gen_rtx_IOR (DImode,
		       gen_rtx_ZERO_EXTEND (DImode, div_equal),
		       gen_rtx_ASHIFT (DImode,
				       gen_rtx_ZERO_EXTEND (DImode, mod_equal),
				       GEN_INT (32)));

  operands[4] = gen_reg_rtx(DImode);
  emit_insn (gen_rtx_CLOBBER (VOIDmode, operands[4]));
  emit_move_insn (gen_lowpart (SImode, operands[4]), operands[1]);
  emit_move_insn (gen_highpart (SImode, operands[4]), const0_rtx);
  insn = emit_insn (gen_udivmoddisi3 (operands[4], operands[4], operands[2]));
  REG_NOTES (insn) =
	gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[0], gen_lowpart (SImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, div_equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[3], gen_highpart (SImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, mod_equal, REG_NOTES (insn));

  DONE;
})

(define_insn "udivmoddisi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (ior:DI (zero_extend:DI
                  (truncate:SI
                    (udiv:DI (match_operand:DI 1 "register_operand" "0,0")
                             (zero_extend:DI
                               (match_operand:SI 2 "nonimmediate_operand" "d,m")))))
                (ashift:DI
                  (zero_extend:DI
                    (truncate:SI
                      (umod:DI (match_dup 1) (zero_extend:DI (match_dup 2)))))
                  (const_int 32))))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH"
  "@
   dlr\t%0,%2
   dl\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "idiv")])

(define_expand "udivsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (udiv:SI (match_operand:SI 1 "general_operand" "")
                 (match_operand:SI 2 "general_operand" "")))
   (clobber (match_dup 3))]
  "!TARGET_64BIT && !TARGET_CPU_ZARCH"
{
  rtx insn, udiv_equal, umod_equal, equal;

  udiv_equal = gen_rtx_UDIV (SImode, operands[1], operands[2]);
  umod_equal = gen_rtx_UMOD (SImode, operands[1], operands[2]);
  equal = gen_rtx_IOR (DImode,
		       gen_rtx_ZERO_EXTEND (DImode, udiv_equal),
		       gen_rtx_ASHIFT (DImode,
				       gen_rtx_ZERO_EXTEND (DImode, umod_equal),
				       GEN_INT (32)));

  operands[3] = gen_reg_rtx (DImode);

  if (CONSTANT_P (operands[2]))
    {
      if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) < 0)
        {
          rtx label1 = gen_label_rtx ();

	  operands[1] = make_safe_from (operands[1], operands[0]);
          emit_move_insn (operands[0], const0_rtx);
          emit_insn (gen_cmpsi (operands[1], operands[2]));
          emit_jump_insn (gen_bltu (label1));
          emit_move_insn (operands[0], const1_rtx);
          emit_label (label1);
        }
      else
        {
          operands[2] = force_reg (SImode, operands[2]);
          operands[2] = make_safe_from (operands[2], operands[0]);

	  emit_insn (gen_zero_extendsidi2 (operands[3], operands[1]));
	  insn = emit_insn (gen_divmoddisi3 (operands[3], operands[3],
					     operands[2]));
	  REG_NOTES (insn) =
	    gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

	  insn = emit_move_insn (operands[0],
				 gen_lowpart (SImode, operands[3]));
	  REG_NOTES (insn) =
	    gen_rtx_EXPR_LIST (REG_EQUAL,
			       udiv_equal, REG_NOTES (insn));
        }
    }
  else
    {
      rtx label1 = gen_label_rtx ();
      rtx label2 = gen_label_rtx ();
      rtx label3 = gen_label_rtx ();

      operands[1] = force_reg (SImode, operands[1]);
      operands[1] = make_safe_from (operands[1], operands[0]);
      operands[2] = force_reg (SImode, operands[2]);
      operands[2] = make_safe_from (operands[2], operands[0]);

      emit_move_insn (operands[0], const0_rtx);
      emit_insn (gen_cmpsi (operands[2], operands[1]));
      emit_jump_insn (gen_bgtu (label3));
      emit_insn (gen_cmpsi (operands[2], const1_rtx));
      emit_jump_insn (gen_blt (label2));
      emit_insn (gen_cmpsi (operands[2], const1_rtx));
      emit_jump_insn (gen_beq (label1));
      emit_insn (gen_zero_extendsidi2 (operands[3], operands[1]));
      insn = emit_insn (gen_divmoddisi3 (operands[3], operands[3],
					 operands[2]));
      REG_NOTES (insn) =
      gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

      insn = emit_move_insn (operands[0],
			     gen_lowpart (SImode, operands[3]));
      REG_NOTES (insn) =
      gen_rtx_EXPR_LIST (REG_EQUAL,
			       udiv_equal, REG_NOTES (insn));
      emit_jump (label3);
      emit_label (label1);
      emit_move_insn (operands[0], operands[1]);
      emit_jump (label3);
      emit_label (label2);
      emit_move_insn (operands[0], const1_rtx);
      emit_label (label3);
    }
  emit_move_insn (operands[0], operands[0]);
  DONE;
})

(define_expand "umodsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (umod:SI (match_operand:SI 1 "nonimmediate_operand" "")
                 (match_operand:SI 2 "nonimmediate_operand" "")))
   (clobber (match_dup 3))]
  "!TARGET_64BIT && !TARGET_CPU_ZARCH"
{
  rtx insn, udiv_equal, umod_equal, equal;

  udiv_equal = gen_rtx_UDIV (SImode, operands[1], operands[2]);
  umod_equal = gen_rtx_UMOD (SImode, operands[1], operands[2]);
  equal = gen_rtx_IOR (DImode,
		       gen_rtx_ZERO_EXTEND (DImode, udiv_equal),
		       gen_rtx_ASHIFT (DImode,
				       gen_rtx_ZERO_EXTEND (DImode, umod_equal),
				       GEN_INT (32)));

  operands[3] = gen_reg_rtx (DImode);

  if (CONSTANT_P (operands[2]))
    {
      if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) <= 0)
        {
          rtx label1 = gen_label_rtx ();

          operands[1] = make_safe_from (operands[1], operands[0]);
	  emit_move_insn (operands[0], operands[1]);
          emit_insn (gen_cmpsi (operands[0], operands[2]));
          emit_jump_insn (gen_bltu (label1));
	  emit_insn (gen_abssi2 (operands[0], operands[2]));
          emit_insn (gen_addsi3 (operands[0], operands[0], operands[1]));
          emit_label (label1);
        }
      else
        {
          operands[2] = force_reg (SImode, operands[2]);
          operands[2] = make_safe_from (operands[2], operands[0]);

	  emit_insn (gen_zero_extendsidi2 (operands[3], operands[1]));
	  insn = emit_insn (gen_divmoddisi3 (operands[3], operands[3],
					     operands[2]));
	  REG_NOTES (insn) =
	    gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

	  insn = emit_move_insn (operands[0],
				 gen_highpart (SImode, operands[3]));
	  REG_NOTES (insn) =
	    gen_rtx_EXPR_LIST (REG_EQUAL,
			       umod_equal, REG_NOTES (insn));
        }
    }
  else
    {
      rtx label1 = gen_label_rtx ();
      rtx label2 = gen_label_rtx ();
      rtx label3 = gen_label_rtx ();

      operands[1] = force_reg (SImode, operands[1]);
      operands[1] = make_safe_from (operands[1], operands[0]);
      operands[2] = force_reg (SImode, operands[2]);
      operands[2] = make_safe_from (operands[2], operands[0]);

      emit_move_insn(operands[0], operands[1]);
      emit_insn (gen_cmpsi (operands[2], operands[1]));
      emit_jump_insn (gen_bgtu (label3));
      emit_insn (gen_cmpsi (operands[2], const1_rtx));
      emit_jump_insn (gen_blt (label2));
      emit_insn (gen_cmpsi (operands[2], const1_rtx));
      emit_jump_insn (gen_beq (label1));
      emit_insn (gen_zero_extendsidi2 (operands[3], operands[1]));
      insn = emit_insn (gen_divmoddisi3 (operands[3], operands[3],
					 operands[2]));
      REG_NOTES (insn) =
      gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

      insn = emit_move_insn (operands[0],
			     gen_highpart (SImode, operands[3]));
      REG_NOTES (insn) =
      gen_rtx_EXPR_LIST (REG_EQUAL,
			 umod_equal, REG_NOTES (insn));
      emit_jump (label3);
      emit_label (label1);
      emit_move_insn (operands[0], const0_rtx);
      emit_jump (label3);
      emit_label (label2);
      emit_insn (gen_subsi3 (operands[0], operands[0], operands[2]));
      emit_label (label3);
    }
  DONE;
})

;
; divdf3 instruction pattern(s).
;

(define_expand "divdf3"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (div:DF (match_operand:DF 1 "register_operand" "0,0")
                (match_operand:DF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*divdf3"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (div:DF (match_operand:DF 1 "register_operand" "0,0")
                (match_operand:DF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   ddbr\t%0,%2
   ddb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fdivd")])

(define_insn "*divdf3_ibm"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (div:DF (match_operand:DF 1 "register_operand" "0,0")
                (match_operand:DF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   ddr\t%0,%2
   dd\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"     "fdivd")])

;
; divsf3 instruction pattern(s).
;

(define_expand "divsf3"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (div:SF (match_operand:SF 1 "register_operand" "0,0")
                (match_operand:SF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*divsf3"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (div:SF (match_operand:SF 1 "register_operand" "0,0")
                (match_operand:SF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   debr\t%0,%2
   deb\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fdivs")])

(define_insn "*divsf3"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (div:SF (match_operand:SF 1 "register_operand" "0,0")
                (match_operand:SF 2 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   der\t%0,%2
   de\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"     "fdivs")])


;;
;;- And instructions.
;;

;
; anddi3 instruction pattern(s).
;

(define_insn "*anddi3_cc"
  [(set (reg 33)
        (compare (and:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (and:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT"
  "@
   ngr\t%0,%2
   ng\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*anddi3_cconly"
  [(set (reg 33)
        (compare (and:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT"
  "@
   ngr\t%0,%2
   ng\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "anddi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d,d,d,d,d,d,d")
	(and:DI (match_operand:DI 1 "nonimmediate_operand" "d,o,0,0,0,0,0,0")
 		(match_operand:DI 2 "general_operand" 
				    "M,M,N0HDF,N1HDF,N2HDF,N3HDF,d,m")))
     (clobber (reg:CC 33))]
   "TARGET_64BIT"
   "@
    #
    #
    nihh\t%0,%j2
    nihl\t%0,%j2
    nilh\t%0,%j2
    nill\t%0,%j2
    ngr\t%0,%2
    ng\t%0,%2"
 [(set_attr "op_type" "RRE,RXE,RI,RI,RI,RI,RRE,RXY")])

(define_insn "*anddi3_ss"
  [(set (match_operand:DI 0 "s_operand" "=Q")
        (and:DI (match_dup 0)
                (match_operand:DI 1 "s_imm_operand" "Q")))
   (clobber (reg:CC 33))]
  ""
  "nc\t%O0(8,%R0),%1"
  [(set_attr "op_type"  "SS")])

(define_insn "*anddi3_ss_inv"
  [(set (match_operand:DI 0 "s_operand" "=Q")
        (and:DI (match_operand:DI 1 "s_imm_operand" "Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "nc\t%O0(8,%R0),%1"
  [(set_attr "op_type"  "SS")])

;
; andsi3 instruction pattern(s).
;

(define_insn "*andsi3_cc"
  [(set (reg 33)
        (compare (and:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                         (match_operand:SI 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d,d,d")
        (and:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   nr\t%0,%2
   n\t%0,%2
   ny\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*andsi3_cconly"
  [(set (reg 33)
        (compare (and:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                         (match_operand:SI 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (clobber (match_scratch:SI 0 "=d,d,d"))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   nr\t%0,%2
   n\t%0,%2
   ny\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_expand "andsi3"
  [(parallel 
    [(set (match_operand:SI 0 "register_operand" "")
	  (and:SI (match_operand:SI 1 "nonimmediate_operand" "")
		  (match_operand:SI 2 "general_operand" "")))
     (clobber (reg:CC 33))])]
  ""
  "")

(define_insn "*andsi3_zarch"
  [(set (match_operand:SI 0 "register_operand" "=d,d,d,d,d,d,d")
        (and:SI (match_operand:SI 1 "nonimmediate_operand" "d,o,0,0,0,0,0")
                (match_operand:SI 2 "general_operand" "M,M,N0HSF,N1HSF,d,R,T")))
   (clobber (reg:CC 33))]
  "TARGET_ZARCH"
  "@
   #
   #
   nilh\t%0,%j2
   nill\t%0,%j2   
   nr\t%0,%2
   n\t%0,%2
   ny\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE,RI,RI,RR,RX,RXY")])

(define_insn "*andsi3_esa"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (and:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0")
                (match_operand:SI 2 "general_operand" "d,R")))
   (clobber (reg:CC 33))]
  "!TARGET_ZARCH"
  "@
   nr\t%0,%2
   n\t%0,%2"
  [(set_attr "op_type"  "RR,RX")])

(define_insn "*andsi3_ss"
  [(set (match_operand:SI 0 "s_operand" "=Q")
        (and:SI (match_dup 0)
                (match_operand:SI 1 "s_imm_operand" "Q")))
   (clobber (reg:CC 33))]
  ""
  "nc\t%O0(4,%R0),%1"
  [(set_attr "op_type"  "SS")])

(define_insn "*andsi3_ss_inv"
  [(set (match_operand:SI 0 "s_operand" "=Q")
        (and:SI (match_operand:SI 1 "s_imm_operand" "Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "nc\t%O0(4,%R0),%1"
  [(set_attr "op_type"  "SS")])

;
; andhi3 instruction pattern(s).
;

(define_insn "*andhi3_ni"
  [(set (match_operand:HI 0 "register_operand" "=d,d")
        (and:HI (match_operand:HI 1 "register_operand" "%0,0")
                (match_operand:HI 2 "nonmemory_operand" "d,n")))
   (clobber (reg:CC 33))]
  "TARGET_ZARCH"
  "@
   nr\t%0,%2
   nill\t%0,%x2"
  [(set_attr "op_type"  "RR,RI")])

(define_insn "andhi3"
  [(set (match_operand:HI 0 "register_operand" "=d")
        (and:HI (match_operand:HI 1 "register_operand" "%0")
                (match_operand:HI 2 "nonmemory_operand" "d")))
   (clobber (reg:CC 33))]
  ""
  "nr\t%0,%2"
  [(set_attr "op_type"  "RR")])

(define_insn "*andhi3_ss"
  [(set (match_operand:HI 0 "s_operand" "=Q")
        (and:HI (match_dup 0)
                (match_operand:HI 1 "s_imm_operand" "Q")))
   (clobber (reg:CC 33))]
  ""
  "nc\t%O0(2,%R0),%1"
  [(set_attr "op_type"  "SS")])

(define_insn "*andhi3_ss_inv"
  [(set (match_operand:HI 0 "s_operand" "=Q")
        (and:HI (match_operand:HI 1 "s_imm_operand" "Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "nc\t%O0(2,%R0),%1"
  [(set_attr "op_type"  "SS")])

;
; andqi3 instruction pattern(s).
;

(define_insn "*andqi3_ni"
  [(set (match_operand:QI 0 "register_operand" "=d,d")
        (and:QI (match_operand:QI 1 "register_operand" "%0,0")
                (match_operand:QI 2 "nonmemory_operand" "d,n")))
   (clobber (reg:CC 33))]
  "TARGET_ZARCH"
  "@
   nr\t%0,%2
   nill\t%0,%b2"
  [(set_attr "op_type"  "RR,RI")])

(define_insn "andqi3"
  [(set (match_operand:QI 0 "register_operand" "=d")
        (and:QI (match_operand:QI 1 "register_operand" "%0")
                (match_operand:QI 2 "nonmemory_operand" "d")))
   (clobber (reg:CC 33))]
  ""
  "nr\t%0,%2"
  [(set_attr "op_type"  "RR")])

(define_insn "*andqi3_ss"
  [(set (match_operand:QI 0 "s_operand" "=Q,S,Q")
        (and:QI (match_dup 0)
                (match_operand:QI 1 "s_imm_operand" "n,n,Q")))
   (clobber (reg:CC 33))]
  ""
  "@
   ni\t%0,%b1
   niy\t%0,%b1
   nc\t%O0(1,%R0),%1"
  [(set_attr "op_type"  "SI,SIY,SS")])

(define_insn "*andqi3_ss_inv"
  [(set (match_operand:QI 0 "s_operand" "=Q,S,Q")
        (and:QI (match_operand:QI 1 "s_imm_operand" "n,n,Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "@
   ni\t%0,%b1
   niy\t%0,%b1
   nc\t%O0(1,%R0),%1"
  [(set_attr "op_type"  "SI,SIY,SS")])


;;
;;- Bit set (inclusive or) instructions.
;;

;
; iordi3 instruction pattern(s).
;

(define_insn "*iordi3_cc"
  [(set (reg 33)
        (compare (ior:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (ior:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT"
  "@
   ogr\t%0,%2
   og\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*iordi3_cconly"
  [(set (reg 33)
        (compare (ior:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT"
  "@
   ogr\t%0,%2
   og\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "iordi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d,d,d,d,d")
        (ior:DI (match_operand:DI 1 "nonimmediate_operand" "0,0,0,0,0,0")
                (match_operand:DI 2 "general_operand" "N0HD0,N1HD0,N2HD0,N3HD0,d,m")))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "@
   oihh\t%0,%i2
   oihl\t%0,%i2
   oilh\t%0,%i2
   oill\t%0,%i2
   ogr\t%0,%2
   og\t%0,%2"
  [(set_attr "op_type"  "RI,RI,RI,RI,RRE,RXY")])

(define_insn "*iordi3_ss"
  [(set (match_operand:DI 0 "s_operand" "=Q")
        (ior:DI (match_dup 0)
                (match_operand:DI 1 "s_imm_operand" "Q")))
   (clobber (reg:CC 33))]
  ""
  "oc\t%O0(8,%R0),%1"
  [(set_attr "op_type"  "SS")])

(define_insn "*iordi3_ss_inv"
  [(set (match_operand:DI 0 "s_operand" "=Q")
        (ior:DI (match_operand:DI 1 "s_imm_operand" "Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "oc\t%O0(8,%R0),%1"
  [(set_attr "op_type"  "SS")])

;
; iorsi3 instruction pattern(s).
;

(define_insn "*iorsi3_cc"
  [(set (reg 33)
        (compare (ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                         (match_operand:SI 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d,d,d")
        (ior:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   or\t%0,%2
   o\t%0,%2
   oy\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*iorsi3_cconly"
  [(set (reg 33)
        (compare (ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                         (match_operand:SI 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (clobber (match_scratch:SI 0 "=d,d,d"))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   or\t%0,%2
   o\t%0,%2
   oy\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_expand "iorsi3"
  [(parallel 
    [(set (match_operand:SI 0 "register_operand" "")
	  (ior:SI (match_operand:SI 1 "nonimmediate_operand" "")
		  (match_operand:SI 2 "general_operand" "")))
     (clobber (reg:CC 33))])]
  ""
  "")

(define_insn "iorsi3_zarch"
  [(set (match_operand:SI 0 "register_operand" "=d,d,d,d,d")
        (ior:SI (match_operand:SI 1 "nonimmediate_operand" "0,0,0,0,0")
                (match_operand:SI 2 "general_operand" "N0HS0,N1HS0,d,R,T")))
   (clobber (reg:CC 33))]
  "TARGET_ZARCH"
  "@
   oilh\t%0,%i2
   oill\t%0,%i2
   or\t%0,%2
   o\t%0,%2
   oy\t%0,%2"
  [(set_attr "op_type"  "RI,RI,RR,RX,RXY")])

(define_insn "iorsi3_esa"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (ior:SI (match_operand:SI 1 "nonimmediate_operand" "0,0")
                (match_operand:SI 2 "general_operand" "d,R")))
   (clobber (reg:CC 33))]
  "!TARGET_ZARCH"
  "@
   or\t%0,%2
   o\t%0,%2"
  [(set_attr "op_type"  "RR,RX")])

(define_insn "*iorsi3_ss"
  [(set (match_operand:SI 0 "s_operand" "=Q")
        (ior:SI (match_dup 0)
                (match_operand:SI 1 "s_imm_operand" "Q")))
   (clobber (reg:CC 33))]
  ""
  "oc\t%O0(4,%R0),%1"
  [(set_attr "op_type"  "SS")])

(define_insn "*iorsi3_ss_inv"
  [(set (match_operand:SI 0 "s_operand" "=Q")
        (ior:SI (match_operand:SI 1 "s_imm_operand" "Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "oc\t%O0(4,%R0),%1"
  [(set_attr "op_type"  "SS")])

;
; iorhi3 instruction pattern(s).
;

(define_insn "*iorhi3_oi"
  [(set (match_operand:HI 0 "register_operand" "=d,d")
        (ior:HI (match_operand:HI 1 "register_operand" "%0,0")
                (match_operand:HI 2 "nonmemory_operand" "d,n")))
   (clobber (reg:CC 33))]
  "TARGET_ZARCH"
  "@
   or\t%0,%2
   oill\t%0,%x2"
  [(set_attr "op_type"  "RR,RI")])

(define_insn "iorhi3"
  [(set (match_operand:HI 0 "register_operand" "=d")
        (ior:HI (match_operand:HI 1 "register_operand" "%0")
                (match_operand:HI 2 "nonmemory_operand" "d")))
   (clobber (reg:CC 33))]
  ""
  "or\t%0,%2"
  [(set_attr "op_type"  "RR")])

(define_insn "*iorhi3_ss"
  [(set (match_operand:HI 0 "s_operand" "=Q")
        (ior:HI (match_dup 0)
                (match_operand:HI 1 "s_imm_operand" "Q")))
   (clobber (reg:CC 33))]
  ""
  "oc\t%O0(2,%R0),%1"
  [(set_attr "op_type"  "SS")])

(define_insn "*iorhi3_ss_inv"
  [(set (match_operand:HI 0 "s_operand" "=Q")
        (ior:HI (match_operand:HI 1 "s_imm_operand" "Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "oc\t%O0(2,%R0),%1"
  [(set_attr "op_type"  "SS")])

;
; iorqi3 instruction pattern(s).
;

(define_insn "*iorqi3_oi"
  [(set (match_operand:QI 0 "register_operand" "=d,d")
        (ior:QI (match_operand:QI 1 "register_operand" "%0,0")
                (match_operand:QI 2 "nonmemory_operand" "d,n")))
   (clobber (reg:CC 33))]
  "TARGET_ZARCH"
  "@
   or\t%0,%2
   oill\t%0,%b2"
  [(set_attr "op_type"  "RR,RI")])

(define_insn "iorqi3"
  [(set (match_operand:QI 0 "register_operand" "=d")
        (ior:QI (match_operand:QI 1 "register_operand" "%0")
                (match_operand:QI 2 "nonmemory_operand" "d")))
   (clobber (reg:CC 33))]
  ""
  "or\t%0,%2"
  [(set_attr "op_type"  "RR")])

(define_insn "*iorqi3_ss"
  [(set (match_operand:QI 0 "s_operand" "=Q,S,Q")
        (ior:QI (match_dup 0)
                (match_operand:QI 1 "s_imm_operand" "n,n,Q")))
   (clobber (reg:CC 33))]
  ""
  "@
   oi\t%0,%b1
   oiy\t%0,%b1
   oc\t%O0(1,%R0),%1"
  [(set_attr "op_type"  "SI,SIY,SS")])

(define_insn "*iorqi3_ss_inv"
  [(set (match_operand:QI 0 "s_operand" "=Q,S,Q")
        (ior:QI (match_operand:QI 1 "s_imm_operand" "n,n,Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "@
   oi\t%0,%b1
   oiy\t%0,%b1
   oc\t%O0(1,%R0),%1"
  [(set_attr "op_type"  "SI,SIY,SS")])


;;
;;- Xor instructions.
;;

;
; xordi3 instruction pattern(s).
;

(define_insn "*xordi3_cc"
  [(set (reg 33)
        (compare (xor:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (xor:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT"
  "@
   xgr\t%0,%2
   xg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*xordi3_cconly"
  [(set (reg 33)
        (compare (xor:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT"
  "@
   xgr\t%0,%2
   xr\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "xordi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (xor:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                (match_operand:DI 2 "general_operand" "d,m")))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "@
   xgr\t%0,%2
   xg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*xordi3_ss"
  [(set (match_operand:DI 0 "s_operand" "=Q")
        (xor:DI (match_dup 0)
                (match_operand:DI 1 "s_imm_operand" "Q")))
   (clobber (reg:CC 33))]
  ""
  "xc\t%O0(8,%R0),%1"
  [(set_attr "op_type"  "SS")])

(define_insn "*xordi3_ss_inv"
  [(set (match_operand:DI 0 "s_operand" "=Q")
        (xor:DI (match_operand:DI 1 "s_imm_operand" "Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "xc\t%O0(8,%R0),%1"
  [(set_attr "op_type"  "SS")])

;
; xorsi3 instruction pattern(s).
;

(define_insn "*xorsi3_cc"
  [(set (reg 33)
        (compare (xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                         (match_operand:SI 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d,d,d")
        (xor:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   xr\t%0,%2
   x\t%0,%2
   xy\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*xorsi3_cconly"
  [(set (reg 33)
        (compare (xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                         (match_operand:SI 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (clobber (match_scratch:SI 0 "=d,d,d"))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   xr\t%0,%2
   x\t%0,%2
   xy\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "register_operand" "=d,d,d")
        (xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0")
                (match_operand:SI 2 "general_operand" "d,R,T")))
   (clobber (reg:CC 33))]
  ""
  "@
   xr\t%0,%2
   x\t%0,%2
   xy\t%0,%2"
  [(set_attr "op_type"  "RR,RX,RXY")])

(define_insn "*xorsi3_ss"
  [(set (match_operand:SI 0 "s_operand" "=Q")
        (xor:SI (match_dup 0)
                (match_operand:SI 1 "s_imm_operand" "Q")))
   (clobber (reg:CC 33))]
  ""
  "xc\t%O0(4,%R0),%1"
  [(set_attr "op_type"  "SS")])

(define_insn "*xorsi3_ss_inv"
  [(set (match_operand:SI 0 "s_operand" "=Q")
        (xor:SI (match_operand:SI 1 "s_imm_operand" "Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "xc\t%O0(4,%R0),%1"
  [(set_attr "op_type"  "SS")])

;
; xorhi3 instruction pattern(s).
;

(define_insn "xorhi3"
  [(set (match_operand:HI 0 "register_operand" "=d")
        (xor:HI (match_operand:HI 1 "register_operand" "%0")
                (match_operand:HI 2 "nonmemory_operand" "d")))
   (clobber (reg:CC 33))]
  ""
  "xr\t%0,%2"
  [(set_attr "op_type"  "RR")])

(define_insn "*xorhi3_ss"
  [(set (match_operand:HI 0 "s_operand" "=Q")
        (xor:HI (match_dup 0)
                (match_operand:HI 1 "s_imm_operand" "Q")))
   (clobber (reg:CC 33))]
  ""
  "xc\t%O0(2,%R0),%1"
  [(set_attr "op_type"  "SS")])

(define_insn "*xorhi3_ss_inv"
  [(set (match_operand:HI 0 "s_operand" "=Q")
        (xor:HI (match_operand:HI 1 "s_imm_operand" "Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "xc\t%O0(2,%R0),%1"
  [(set_attr "op_type"  "SS")])

;
; xorqi3 instruction pattern(s).
;

(define_insn "xorqi3"
  [(set (match_operand:QI 0 "register_operand" "=d")
        (xor:QI (match_operand:QI 1 "register_operand" "%0")
                (match_operand:QI 2 "nonmemory_operand" "d")))
   (clobber (reg:CC 33))]
  ""
  "xr\t%0,%2"
  [(set_attr "op_type"  "RR")])

(define_insn "*xorqi3_ss"
  [(set (match_operand:QI 0 "s_operand" "=Q,S,Q")
        (xor:QI (match_dup 0)
                (match_operand:QI 1 "s_imm_operand" "n,n,Q")))
   (clobber (reg:CC 33))]
  ""
  "@
   xi\t%0,%b1
   xiy\t%0,%b1
   xc\t%O0(1,%R0),%1"
  [(set_attr "op_type"  "SI,SIY,SS")])

(define_insn "*xorqi3_ss_inv"
  [(set (match_operand:QI 0 "s_operand" "=Q,S,Q")
        (xor:QI (match_operand:QI 1 "s_imm_operand" "n,n,Q")
                (match_dup 0)))
   (clobber (reg:CC 33))]
  ""
  "@
   xi\t%0,%b1
   xiy\t%0,%b1
   xc\t%O0(1,%R0),%1"
  [(set_attr "op_type"  "SI,SIY,SS")])


;;
;;- Negate instructions.
;;

;
; negdi2 instruction pattern(s).
;

(define_expand "negdi2"
  [(parallel
    [(set (match_operand:DI 0 "register_operand" "=d")
          (neg:DI (match_operand:DI 1 "register_operand" "d")))
     (clobber (reg:CC 33))])]
  ""
  "")

(define_insn "*negdi2_64"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (neg:DI (match_operand:DI 1 "register_operand" "d")))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "lcgr\t%0,%1"
  [(set_attr "op_type"  "RR")])

(define_insn "*negdi2_31"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (neg:DI (match_operand:DI 1 "register_operand" "d")))
   (clobber (reg:CC 33))]
  "!TARGET_64BIT"
{
  rtx xop[1];
  xop[0] = gen_label_rtx ();
  output_asm_insn ("lcr\t%0,%1", operands);
  output_asm_insn ("lcr\t%N0,%N1", operands);
  output_asm_insn ("je\t%l0", xop);
  output_asm_insn ("bctr\t%0,0", operands);
  targetm.asm_out.internal_label (asm_out_file, "L",
			     CODE_LABEL_NUMBER (xop[0]));
  return "";
}
  [(set_attr "op_type"  "NN")
   (set_attr "type"     "other")
   (set_attr "length"   "10")])

;
; negsi2 instruction pattern(s).
;

(define_insn "negsi2"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (neg:SI (match_operand:SI 1 "register_operand" "d")))
   (clobber (reg:CC 33))]
  ""
  "lcr\t%0,%1"
  [(set_attr "op_type"  "RR")])

;
; negdf2 instruction pattern(s).
;

(define_expand "negdf2"
  [(parallel
    [(set (match_operand:DF 0 "register_operand" "=f")
          (neg:DF (match_operand:DF 1 "register_operand" "f")))
     (clobber (reg:CC 33))])]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*negdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (neg:DF (match_operand:DF 1 "register_operand" "f")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lcdbr\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimpd")])

(define_insn "*negdf2_ibm"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (neg:DF (match_operand:DF 1 "register_operand" "f")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "lcdr\t%0,%1"
  [(set_attr "op_type"  "RR")
   (set_attr "type"     "fsimpd")])

;
; negsf2 instruction pattern(s).
;

(define_expand "negsf2"
  [(parallel
    [(set (match_operand:SF 0 "register_operand" "=f")
          (neg:SF (match_operand:SF 1 "register_operand" "f")))
     (clobber (reg:CC 33))])]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*negsf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (neg:SF (match_operand:SF 1 "register_operand" "f")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lcebr\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimps")])

(define_insn "*negsf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (neg:SF (match_operand:SF 1 "register_operand" "f")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "lcer\t%0,%1"
  [(set_attr "op_type"  "RR")
   (set_attr "type"     "fsimps")])


;;
;;- Absolute value instructions.
;;

;
; absdi2 instruction pattern(s).
;

(define_insn "absdi2"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (abs:DI (match_operand:DI 1 "register_operand" "d")))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "lpgr\t%0,%1"
  [(set_attr "op_type"  "RRE")])

;
; abssi2 instruction pattern(s).
;

(define_insn "abssi2"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (abs:SI (match_operand:SI 1 "register_operand" "d")))
   (clobber (reg:CC 33))]
  ""
  "lpr\t%0,%1"
  [(set_attr "op_type"  "RR")])

;
; absdf2 instruction pattern(s).
;

(define_expand "absdf2"
  [(parallel
    [(set (match_operand:DF 0 "register_operand" "=f")
          (abs:DF (match_operand:DF 1 "register_operand" "f")))
     (clobber (reg:CC 33))])]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*absdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (abs:DF (match_operand:DF 1 "register_operand" "f")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lpdbr\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimpd")])

(define_insn "*absdf2_ibm"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (abs:DF (match_operand:DF 1 "register_operand" "f")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "lpdr\t%0,%1"
  [(set_attr "op_type"  "RR")
   (set_attr "type"     "fsimpd")])

;
; abssf2 instruction pattern(s).
;

(define_expand "abssf2"
  [(parallel
    [(set (match_operand:SF 0 "register_operand" "=f")
          (abs:SF (match_operand:SF 1 "register_operand" "f")))
     (clobber (reg:CC 33))])]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*abssf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (abs:SF (match_operand:SF 1 "register_operand" "f")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lpebr\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimps")])

(define_insn "*abssf2_ibm"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (abs:SF (match_operand:SF 1 "register_operand" "f")))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "lper\t%0,%1"
  [(set_attr "op_type"  "RR")
   (set_attr "type"     "fsimps")])

;;
;;- Negated absolute value instructions
;;

;
; Integer
;

(define_insn "*negabssi2"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(neg:SI (abs:SI (match_operand:SI 1 "register_operand" "d"))))
   (clobber (reg:CC 33))]
  ""
  "lnr\t%0,%1"
  [(set_attr "op_type" "RR")])

(define_insn "*negabsdi2"
  [(set (match_operand:DI 0 "register_operand" "=d")
	(neg:DI (abs:DI (match_operand:DI 1 "register_operand" "d"))))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "lngr\t%0,%1"
  [(set_attr "op_type" "RRE")])

;
; Floating point
;

(define_insn "*negabssf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (neg:SF (abs:SF (match_operand:SF 1 "register_operand" "f"))))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lnebr\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimps")])

(define_insn "*negabsdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (neg:DF (abs:DF (match_operand:DF 1 "register_operand" "f"))))
   (clobber (reg:CC 33))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lndbr\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimpd")])

;;
;;- Square root instructions.
;;

;
; sqrtdf2 instruction pattern(s).
;

(define_insn "sqrtdf2"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
	(sqrt:DF (match_operand:DF 1 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   sqdbr\t%0,%1
   sqdb\t%0,%1"
  [(set_attr "op_type"  "RRE,RXE")])

;
; sqrtsf2 instruction pattern(s).
;

(define_insn "sqrtsf2"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
	(sqrt:SF (match_operand:SF 1 "general_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   sqebr\t%0,%1
   sqeb\t%0,%1"
  [(set_attr "op_type"  "RRE,RXE")])

;;
;;- One complement instructions.
;;

;
; one_cmpldi2 instruction pattern(s).
;

(define_expand "one_cmpldi2"
  [(parallel
    [(set (match_operand:DI 0 "register_operand" "")
          (xor:DI (match_operand:DI 1 "register_operand" "")
                  (const_int -1)))
     (clobber (reg:CC 33))])]
  "TARGET_64BIT"
  "")

;
; one_cmplsi2 instruction pattern(s).
;

(define_expand "one_cmplsi2"
  [(parallel
    [(set (match_operand:SI 0 "register_operand" "")
          (xor:SI (match_operand:SI 1 "register_operand" "")
                  (const_int -1)))
     (clobber (reg:CC 33))])]
  ""
  "")

;
; one_cmplhi2 instruction pattern(s).
;

(define_expand "one_cmplhi2"
  [(parallel
    [(set (match_operand:HI 0 "register_operand" "")
          (xor:HI (match_operand:HI 1 "register_operand" "")
                  (const_int -1)))
     (clobber (reg:CC 33))])]
  ""
  "")

;
; one_cmplqi2 instruction pattern(s).
;

(define_expand "one_cmplqi2"
  [(parallel
    [(set (match_operand:QI 0 "register_operand" "")
          (xor:QI (match_operand:QI 1 "register_operand" "")
                  (const_int -1)))
     (clobber (reg:CC 33))])]
  ""
  "")


;;
;;- Rotate instructions.
;;

;
; rotldi3 instruction pattern(s).
;

(define_insn "rotldi3"
  [(set (match_operand:DI 0 "register_operand" "=d")
	(rotate:DI (match_operand:DI 1 "register_operand" "d")
		   (match_operand:SI 2 "shift_count_operand" "Y")))]
  "TARGET_64BIT"
  "rllg\t%0,%1,%Y2"
  [(set_attr "op_type"  "RSE")
   (set_attr "atype"    "reg")])

;
; rotlsi3 instruction pattern(s).
;

(define_insn "rotlsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(rotate:SI (match_operand:SI 1 "register_operand" "d")
		   (match_operand:SI 2 "shift_count_operand" "Y")))]
  "TARGET_CPU_ZARCH"
  "rll\t%0,%1,%Y2"
  [(set_attr "op_type"  "RSE")
   (set_attr "atype"    "reg")])


;;
;;- Arithmetic shift instructions.
;;

;
; ashldi3 instruction pattern(s).
;

(define_expand "ashldi3"
  [(set (match_operand:DI 0 "register_operand" "")
        (ashift:DI (match_operand:DI 1 "register_operand" "")
                   (match_operand:SI 2 "shift_count_operand" "")))]
  ""
  "")

(define_insn "*ashldi3_31"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (ashift:DI (match_operand:DI 1 "register_operand" "0")
                   (match_operand:SI 2 "shift_count_operand" "Y")))]
  "!TARGET_64BIT"
  "sldl\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

(define_insn "*ashldi3_64"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (ashift:DI (match_operand:DI 1 "register_operand" "d")
                   (match_operand:SI 2 "shift_count_operand" "Y")))]
  "TARGET_64BIT"
  "sllg\t%0,%1,%Y2"
  [(set_attr "op_type"  "RSE")
   (set_attr "atype"    "reg")])

;
; ashrdi3 instruction pattern(s).
;

(define_expand "ashrdi3"
  [(parallel
    [(set (match_operand:DI 0 "register_operand" "")
          (ashiftrt:DI (match_operand:DI 1 "register_operand" "")
                       (match_operand:SI 2 "shift_count_operand" "")))
     (clobber (reg:CC 33))])]
  ""
  "")

(define_insn "*ashrdi3_cc_31"
  [(set (reg 33)
        (compare (ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
                              (match_operand:SI 2 "shift_count_operand" "Y"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d")
        (ashiftrt:DI (match_dup 1) (match_dup 2)))]
  "!TARGET_64BIT && s390_match_ccmode(insn, CCSmode)"
  "srda\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

(define_insn "*ashrdi3_cconly_31"
  [(set (reg 33)
        (compare (ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
                              (match_operand:SI 2 "shift_count_operand" "Y"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d"))]
  "!TARGET_64BIT && s390_match_ccmode(insn, CCSmode)"
  "srda\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

(define_insn "*ashrdi3_31"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
                     (match_operand:SI 2 "shift_count_operand" "Y")))
   (clobber (reg:CC 33))]
  "!TARGET_64BIT"
  "srda\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

(define_insn "*ashrdi3_cc_64"
  [(set (reg 33)
        (compare (ashiftrt:DI (match_operand:DI 1 "register_operand" "d")
                              (match_operand:SI 2 "shift_count_operand" "Y"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d")
        (ashiftrt:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_64BIT"
  "srag\t%0,%1,%Y2"
  [(set_attr "op_type"  "RSE")
   (set_attr "atype"    "reg")])

(define_insn "*ashrdi3_cconly_64"
  [(set (reg 33)
        (compare (ashiftrt:DI (match_operand:DI 1 "register_operand" "d")
                              (match_operand:SI 2 "shift_count_operand" "Y"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d"))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_64BIT"
  "srag\t%0,%1,%Y2"
  [(set_attr "op_type"  "RSE")
   (set_attr "atype"    "reg")])

(define_insn "*ashrdi3_64"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (ashiftrt:DI (match_operand:DI 1 "register_operand" "d")
                     (match_operand:SI 2 "shift_count_operand" "Y")))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
  "srag\t%0,%1,%Y2"
  [(set_attr "op_type"  "RSE")
   (set_attr "atype"    "reg")])


;
; ashlsi3 instruction pattern(s).
;

(define_insn "ashlsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (ashift:SI (match_operand:SI 1 "register_operand" "0")
                   (match_operand:SI 2 "shift_count_operand" "Y")))]
  ""
  "sll\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

;
; ashrsi3 instruction pattern(s).
;

(define_insn "*ashrsi3_cc"
  [(set (reg 33)
        (compare (ashiftrt:SI (match_operand:SI 1 "register_operand" "0")
                              (match_operand:SI 2 "shift_count_operand" "Y"))
                 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d")
        (ashiftrt:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCSmode)"
  "sra\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])


(define_insn "*ashrsi3_cconly"
  [(set (reg 33)
        (compare (ashiftrt:SI (match_operand:SI 1 "register_operand" "0")
                              (match_operand:SI 2 "shift_count_operand" "Y"))
                 (const_int 0)))
   (clobber (match_scratch:SI 0 "=d"))]
  "s390_match_ccmode(insn, CCSmode)"
  "sra\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (ashiftrt:SI (match_operand:SI 1 "register_operand" "0")
                     (match_operand:SI 2 "shift_count_operand" "Y")))
   (clobber (reg:CC 33))]
  ""
  "sra\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])


;;
;;- logical shift instructions.
;;

;
; lshrdi3 instruction pattern(s).
;

(define_expand "lshrdi3"
  [(set (match_operand:DI 0 "register_operand" "")
        (lshiftrt:DI (match_operand:DI 1 "register_operand" "")
                     (match_operand:SI 2 "shift_count_operand" "")))]
  ""
  "")

(define_insn "*lshrdi3_31"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (lshiftrt:DI (match_operand:DI 1 "register_operand" "0")
                     (match_operand:SI 2 "shift_count_operand" "Y")))]
  "!TARGET_64BIT"
  "srdl\t%0,%Y2"
   [(set_attr "op_type"  "RS")
    (set_attr "atype"    "reg")])

(define_insn "*lshrdi3_64"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (lshiftrt:DI (match_operand:DI 1 "register_operand" "d")
                     (match_operand:SI 2 "shift_count_operand" "Y")))]
  "TARGET_64BIT"
  "srlg\t%0,%1,%Y2"
  [(set_attr "op_type"  "RSE")
   (set_attr "atype"    "reg")])

;
; lshrsi3 instruction pattern(s).
;

(define_insn "lshrsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (lshiftrt:SI (match_operand:SI 1 "register_operand" "0")
                     (match_operand:SI 2 "shift_count_operand" "Y")))]
  ""
  "srl\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])


;;
;; Branch instruction patterns.
;;

(define_expand "beq"
  [(set (reg:CCZ 33) (compare:CCZ (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (eq (reg:CCZ 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bne"
  [(set (reg:CCZ 33) (compare:CCZ (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (ne (reg:CCZ 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bgt"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (gt (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bgtu"
  [(set (reg:CCU 33) (compare:CCU (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (gtu (reg:CCU 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "blt"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (lt (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bltu"
  [(set (reg:CCU 33) (compare:CCU (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (ltu (reg:CCU 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bge"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (ge (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bgeu"
  [(set (reg:CCU 33) (compare:CCU (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (geu (reg:CCU 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "ble"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (le (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bleu"
  [(set (reg:CCU 33) (compare:CCU (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (leu (reg:CCU 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bunordered"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (unordered (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bordered"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (ordered (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "buneq"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (uneq (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bungt"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (ungt (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bunlt"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (unlt (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bunge"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (unge (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bunle"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (unle (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")

(define_expand "bltgt"
  [(set (reg:CCS 33) (compare:CCS (match_dup 1) (match_dup 2)))
   (set (pc)
        (if_then_else (ltgt (reg:CCS 33) (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "operands[1] = s390_compare_op0; operands[2] = s390_compare_op1;")


;;
;;- Conditional jump instructions.
;;

(define_insn "cjump"
 [(set (pc)
       (if_then_else
         (match_operator 1 "comparison_operator" [(reg 33) (const_int 0)])
	 (label_ref (match_operand 0 "" ""))
	 (pc)))]
  ""
{
  if (get_attr_length (insn) == 4)
    return "j%C1\t%l0";
  else if (TARGET_CPU_ZARCH)
    return "jg%C1\t%l0";
  else
    abort ();
}
  [(set_attr "op_type" "RI")
   (set_attr "type"    "branch")
   (set (attr "length")
        (cond [(lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                (const_int 4)
               (ne (symbol_ref "TARGET_CPU_ZARCH") (const_int 0))
                 (const_int 6)
               (eq (symbol_ref "flag_pic") (const_int 0))
                 (const_int 6)] (const_int 8)))])

(define_insn "*cjump_long"
 [(set (pc)
       (if_then_else
         (match_operator 1 "comparison_operator" [(reg 33) (const_int 0)])
	 (match_operand 0 "address_operand" "U")
	 (pc)))]
  ""
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "b%C1r\t%0";
  else
    return "b%C1\t%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"    "branch")
   (set_attr "atype" "agen")])


;;
;;- Negated conditional jump instructions.
;;

(define_insn "icjump"
 [(set (pc)
       (if_then_else
         (match_operator 1 "comparison_operator" [(reg 33) (const_int 0)])
         (pc)
	 (label_ref (match_operand 0 "" ""))))]
  ""
{
  if (get_attr_length (insn) == 4)
    return "j%D1\t%l0";
  else if (TARGET_CPU_ZARCH)
    return "jg%D1\t%l0";
  else
    abort ();
}
  [(set_attr "op_type" "RI")
   (set_attr "type"    "branch")
   (set (attr "length")
        (cond [(lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                (const_int 4)
               (ne (symbol_ref "TARGET_CPU_ZARCH") (const_int 0))
                 (const_int 6)
               (eq (symbol_ref "flag_pic") (const_int 0))
                 (const_int 6)] (const_int 8)))])

(define_insn "*icjump_long"
 [(set (pc)
       (if_then_else
         (match_operator 1 "comparison_operator" [(reg 33) (const_int 0)])
         (pc)
	 (match_operand 0 "address_operand" "U")))]
  ""
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "b%D1r\t%0";
  else
    return "b%D1\t%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "branch")
   (set_attr "atype" "agen")])

;;
;;- Trap instructions.
;;

(define_insn "trap"
  [(trap_if (const_int 1) (const_int 0))]
  ""
  "j\t.+2"
  [(set_attr "op_type" "RX")
   (set_attr "type"  "branch")])

(define_expand "conditional_trap"
  [(set (match_dup 2) (match_dup 3))
   (trap_if (match_operator 0 "comparison_operator"
			    [(match_dup 2) (const_int 0)])
	    (match_operand:SI 1 "general_operand" ""))]
  ""
{
   enum machine_mode ccmode;

   if (operands[1] != const0_rtx) FAIL;

   ccmode = s390_select_ccmode (GET_CODE (operands[0]),
			        s390_compare_op0, s390_compare_op1);
   operands[2] = gen_rtx_REG (ccmode, 33);
   operands[3] = gen_rtx_COMPARE (ccmode, s390_compare_op0, s390_compare_op1);
})

(define_insn "*trap"
  [(trap_if (match_operator 0 "comparison_operator" [(reg 33) (const_int 0)])
	    (const_int 0))]
  ""
  "j%C0\t.+2";
  [(set_attr "op_type" "RI")
   (set_attr "type"  "branch")])

;;
;;- Loop instructions.
;;
;;  This is all complicated by the fact that since this is a jump insn
;;  we must handle our own output reloads.

(define_expand "doloop_end"
  [(use (match_operand 0 "" ""))        ; loop pseudo
   (use (match_operand 1 "" ""))        ; iterations; zero if unknown
   (use (match_operand 2 "" ""))        ; max iterations
   (use (match_operand 3 "" ""))        ; loop level
   (use (match_operand 4 "" ""))]       ; label
  ""
{
  if (GET_MODE (operands[0]) == SImode)
    emit_jump_insn (gen_doloop_si (operands[4], operands[0], operands[0]));
  else if (GET_MODE (operands[0]) == DImode && TARGET_64BIT)
    emit_jump_insn (gen_doloop_di (operands[4], operands[0], operands[0]));
  else
    FAIL;

  DONE;
})

(define_insn "doloop_si"
  [(set (pc)
        (if_then_else
          (ne (match_operand:SI 1 "register_operand" "d,d")
              (const_int 1))
          (label_ref (match_operand 0 "" ""))
          (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,?*m*d")
        (plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:SI 3 "=X,&d"))
   (clobber (reg:CC 33))]
  ""
{
  if (which_alternative != 0)
    return "#";
  else if (get_attr_length (insn) == 4)
    return "brct\t%1,%l0";
  else if (TARGET_CPU_ZARCH)
    return "ahi\t%1,-1\;jgne\t%l0";
  else
    abort ();
}
  [(set_attr "op_type"  "RI")
   (set_attr "type"  "branch")
   (set (attr "length")
        (cond [(lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                (const_int 4)
               (ne (symbol_ref "TARGET_CPU_ZARCH") (const_int 0))
                 (const_int 10)
               (eq (symbol_ref "flag_pic") (const_int 0))
                 (const_int 6)] (const_int 8)))])

(define_insn "*doloop_si_long"
  [(set (pc)
        (if_then_else
          (ne (match_operand:SI 1 "register_operand" "d,d")
              (const_int 1))
          (match_operand 0 "address_operand" "U,U")
          (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,?*m*d")
        (plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:SI 3 "=X,&d"))
   (clobber (reg:CC 33))]
  ""
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "bctr\t%1,%0";
  else
    return "bct\t%1,%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "branch")
   (set_attr "atype" "agen")])

(define_split
  [(set (pc)
        (if_then_else (ne (match_operand:SI 1 "register_operand" "")
                          (const_int 1))
                      (match_operand 0 "" "")
                      (pc)))
   (set (match_operand:SI 2 "nonimmediate_operand" "")
        (plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:SI 3 ""))
   (clobber (reg:CC 33))]
  "reload_completed
   && (! REG_P (operands[2])
       || ! rtx_equal_p (operands[1], operands[2]))"
  [(set (match_dup 3) (match_dup 1))
   (parallel [(set (reg:CCAN 33)
                   (compare:CCAN (plus:SI (match_dup 3) (const_int -1))
                                 (const_int 0)))
              (set (match_dup 3) (plus:SI (match_dup 3) (const_int -1)))])
   (set (match_dup 2) (match_dup 3))
   (set (pc) (if_then_else (ne (reg:CCAN 33) (const_int 0))
                           (match_dup 0)
                           (pc)))]
  "")

(define_insn "doloop_di"
  [(set (pc)
        (if_then_else
          (ne (match_operand:DI 1 "register_operand" "d,d")
              (const_int 1))
          (label_ref (match_operand 0 "" ""))
          (pc)))
   (set (match_operand:DI 2 "register_operand" "=1,?*m*r")
        (plus:DI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:DI 3 "=X,&d"))
   (clobber (reg:CC 33))]
  "TARGET_64BIT"
{
  if (which_alternative != 0)
    return "#";
  else if (get_attr_length (insn) == 4)
    return "brctg\t%1,%l0";
  else
    return "aghi\t%1,-1\;jgne\t%l0";
}
  [(set_attr "op_type"  "RI")
   (set_attr "type"  "branch")
   (set (attr "length")
        (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                      (const_int 4) (const_int 10)))])

(define_split
  [(set (pc)
        (if_then_else (ne (match_operand:DI 1 "register_operand" "")
                          (const_int 1))
                      (match_operand 0 "" "")
                      (pc)))
   (set (match_operand:DI 2 "nonimmediate_operand" "")
        (plus:DI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:DI 3 ""))
   (clobber (reg:CC 33))]
  "reload_completed
   && (! REG_P (operands[2])
       || ! rtx_equal_p (operands[1], operands[2]))"
  [(set (match_dup 3) (match_dup 1))
   (parallel [(set (reg:CCAN 33)
                   (compare:CCAN (plus:DI (match_dup 3) (const_int -1))
                                 (const_int 0)))
              (set (match_dup 3) (plus:DI (match_dup 3) (const_int -1)))])
   (set (match_dup 2) (match_dup 3))
   (set (pc) (if_then_else (ne (reg:CCAN 33) (const_int 0))
                           (match_dup 0)
                           (pc)))]
  "")

;;
;;- Unconditional jump instructions.
;;

;
; jump instruction pattern(s).
;

(define_insn "jump"
  [(set (pc) (label_ref (match_operand 0 "" "")))]
  ""
{
  if (get_attr_length (insn) == 4)
    return "j\t%l0";
  else if (TARGET_CPU_ZARCH)
    return "jg\t%l0";
  else
    abort ();
}
  [(set_attr "op_type" "RI")
   (set_attr "type"  "branch")
   (set (attr "length")
        (cond [(lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                (const_int 4)
               (ne (symbol_ref "TARGET_CPU_ZARCH") (const_int 0))
                 (const_int 6)
               (eq (symbol_ref "flag_pic") (const_int 0))
                 (const_int 6)] (const_int 8)))])

;
; indirect-jump instruction pattern(s).
;

(define_insn "indirect_jump"
 [(set (pc) (match_operand 0 "address_operand" "U"))]
  ""
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "br\t%0";
  else
    return "b\t%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "branch")
   (set_attr "atype" "agen")])

;
; casesi instruction pattern(s).
;

(define_insn "casesi_jump"
 [(set (pc) (match_operand 0 "address_operand" "U"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "br\t%0";
  else
    return "b\t%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "branch")
   (set_attr "atype" "agen")])

(define_expand "casesi"
  [(match_operand:SI 0 "general_operand" "")
   (match_operand:SI 1 "general_operand" "")
   (match_operand:SI 2 "general_operand" "")
   (label_ref (match_operand 3 "" ""))
   (label_ref (match_operand 4 "" ""))]
  ""
{
   rtx index  = gen_reg_rtx (SImode);
   rtx base   = gen_reg_rtx (Pmode);
   rtx target = gen_reg_rtx (Pmode);

   emit_move_insn (index, operands[0]);
   emit_insn (gen_subsi3 (index, index, operands[1]));
   emit_cmp_and_jump_insns (index, operands[2], GTU, NULL_RTX, SImode, 1,
                            operands[4]);

   if (Pmode != SImode)
     index = convert_to_mode (Pmode, index, 1);
   if (GET_CODE (index) != REG)
     index = copy_to_mode_reg (Pmode, index);

   if (TARGET_64BIT)
       emit_insn (gen_ashldi3 (index, index, GEN_INT (3)));
   else
       emit_insn (gen_ashlsi3 (index, index, GEN_INT (2)));

   emit_move_insn (base, gen_rtx_LABEL_REF (Pmode, operands[3]));

   index = gen_rtx_MEM (Pmode, gen_rtx_PLUS (Pmode, base, index));
   emit_move_insn (target, index);

   if (flag_pic)
     target = gen_rtx_PLUS (Pmode, base, target);
   emit_jump_insn (gen_casesi_jump (target, operands[3]));

   DONE;
})


;;
;;- Jump to subroutine.
;;
;;

;
; untyped call instruction pattern(s).
;

;; Call subroutine returning any type.
(define_expand "untyped_call"
  [(parallel [(call (match_operand 0 "" "")
                    (const_int 0))
              (match_operand 1 "" "")
              (match_operand 2 "" "")])]
  ""
{
  int i;

  emit_call_insn (gen_call (operands[0], const0_rtx, const0_rtx));

  for (i = 0; i < XVECLEN (operands[2], 0); i++)
    {
      rtx set = XVECEXP (operands[2], 0, i);
      emit_move_insn (SET_DEST (set), SET_SRC (set));
    }

  /* The optimizer does not know that the call sets the function value
     registers we stored in the result block.  We avoid problems by
     claiming that all hard registers are used and clobbered at this
     point.  */
  emit_insn (gen_blockage ());

  DONE;
})

;; UNSPEC_VOLATILE is considered to use and clobber all hard registers and
;; all of memory.  This blocks insns from being moved across this point.

(define_insn "blockage"
  [(unspec_volatile [(const_int 0)] UNSPECV_BLOCKAGE)]
  ""
  ""
  [(set_attr "type"    "none")
   (set_attr "length"  "0")])



;
; call instruction pattern(s).
;

(define_expand "call"
  [(call (match_operand 0 "" "")
         (match_operand 1 "" ""))
   (use (match_operand 2 "" ""))]
  ""
{
  bool plt_call = false;
  rtx insn;

  /* Direct function calls need special treatment.  */
  if (GET_CODE (XEXP (operands[0], 0)) == SYMBOL_REF)
    {
      rtx sym = XEXP (operands[0], 0);

      /* When calling a global routine in PIC mode, we must
         replace the symbol itself with the PLT stub.  */
      if (flag_pic && !SYMBOL_REF_LOCAL_P (sym))
        {
          sym = gen_rtx_UNSPEC (Pmode, gen_rtvec (1, sym), UNSPEC_PLT);
          sym = gen_rtx_CONST (Pmode, sym);
	  plt_call = true;
        }

      /* Unless we can use the bras(l) insn, force the
         routine address into a register.  */
      if (!TARGET_SMALL_EXEC && !TARGET_CPU_ZARCH)
	{
	  if (flag_pic)
	    sym = legitimize_pic_address (sym, 0);
	  else
	    sym = force_reg (Pmode, sym);
	}

      operands[0] = gen_rtx_MEM (QImode, sym);
    }

  /* Emit insn.  */
  insn = emit_call_insn (gen_call_exp (operands[0], operands[1],
  				       gen_rtx_REG (Pmode, RETURN_REGNUM)));

  /* 31-bit PLT stubs use the GOT register implicitly.  */
  if (!TARGET_64BIT && plt_call)
    use_reg (&CALL_INSN_FUNCTION_USAGE (insn), pic_offset_table_rtx);
  
  DONE;
})

(define_expand "call_exp"
  [(parallel [(call (match_operand 0 "" "")
                    (match_operand 1 "" ""))
              (clobber (match_operand 2 "" ""))])]
  ""
  "")

(define_insn "*bras"
  [(call (mem:QI (match_operand 0 "bras_sym_operand" "X"))
         (match_operand 1 "const_int_operand" "n"))
   (clobber (match_operand 2 "register_operand" "=r"))]
  "TARGET_SMALL_EXEC && GET_MODE (operands[2]) == Pmode"
  "bras\t%2,%0"
  [(set_attr "op_type" "RI")
   (set_attr "type"    "jsr")])

(define_insn "*brasl"
  [(call (mem:QI (match_operand 0 "bras_sym_operand" "X"))
         (match_operand 1 "const_int_operand" "n"))
   (clobber (match_operand 2 "register_operand" "=r"))]
  "TARGET_CPU_ZARCH && GET_MODE (operands[2]) == Pmode"
  "brasl\t%2,%0"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "jsr")])

(define_insn "*basr"
  [(call (mem:QI (match_operand 0 "address_operand" "U"))
         (match_operand 1 "const_int_operand" "n"))
   (clobber (match_operand 2 "register_operand" "=r"))]
  "GET_MODE (operands[2]) == Pmode"
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "basr\t%2,%0";
  else
    return "bas\t%2,%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "jsr")
   (set_attr "atype" "agen")])

;
; call_value instruction pattern(s).
;

(define_expand "call_value"
  [(set (match_operand 0 "" "")
        (call (match_operand 1 "" "")
              (match_operand 2 "" "")))
   (use (match_operand 3 "" ""))]
  ""
{
  bool plt_call = false;
  rtx insn;

  /* Direct function calls need special treatment.  */
  if (GET_CODE (XEXP (operands[1], 0)) == SYMBOL_REF)
    {
      rtx sym = XEXP (operands[1], 0);

      /* When calling a global routine in PIC mode, we must
         replace the symbol itself with the PLT stub.  */
      if (flag_pic && !SYMBOL_REF_LOCAL_P (sym))
        {
          sym = gen_rtx_UNSPEC (Pmode, gen_rtvec (1, sym), UNSPEC_PLT);
          sym = gen_rtx_CONST (Pmode, sym);
	  plt_call = true;
        }

      /* Unless we can use the bras(l) insn, force the
         routine address into a register.  */
      if (!TARGET_SMALL_EXEC && !TARGET_CPU_ZARCH)
        {
	  if (flag_pic)
	    sym = legitimize_pic_address (sym, 0);
	  else
	    sym = force_reg (Pmode, sym);
        }

      operands[1] = gen_rtx_MEM (QImode, sym);
    }

  /* Emit insn.  */
  insn = emit_call_insn (
	    gen_call_value_exp (operands[0], operands[1], operands[2],
  				gen_rtx_REG (Pmode, RETURN_REGNUM)));

  /* 31-bit PLT stubs use the GOT register implicitly.  */
  if (!TARGET_64BIT && plt_call)
    use_reg (&CALL_INSN_FUNCTION_USAGE (insn), pic_offset_table_rtx);
  
  DONE;
})

(define_expand "call_value_exp"
  [(parallel [(set (match_operand 0 "" "")
                   (call (match_operand 1 "" "")
                         (match_operand 2 "" "")))
              (clobber (match_operand 3 "" ""))])]
  ""
  "")

(define_insn "*bras_r"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "bras_sym_operand" "X"))
              (match_operand:SI 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))]
  "TARGET_SMALL_EXEC && GET_MODE (operands[3]) == Pmode"
  "bras\t%3,%1"
  [(set_attr "op_type" "RI")
   (set_attr "type"    "jsr")])

(define_insn "*brasl_r"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "bras_sym_operand" "X"))
              (match_operand 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))]
  "TARGET_CPU_ZARCH && GET_MODE (operands[3]) == Pmode"
  "brasl\t%3,%1"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "jsr")])

(define_insn "*basr_r"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "address_operand" "U"))
              (match_operand 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))]
  "GET_MODE (operands[3]) == Pmode"
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "basr\t%3,%1";
  else
    return "bas\t%3,%a1";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 1 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "jsr")
   (set_attr "atype" "agen")])

;;
;;- Thread-local storage support.
;;

(define_insn "get_tp_64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=??d,Q")
        (unspec:DI [(const_int 0)] UNSPEC_TP))]
  "TARGET_64BIT"
  "@
   ear\t%0,%%a0\;sllg\t%0,%0,32\;ear\t%0,%%a1
   stam\t%%a0,%%a1,%0"
  [(set_attr "op_type" "NN,RS")
   (set_attr "atype"   "reg,*")
   (set_attr "type"    "o3,*")
   (set_attr "length"  "14,*")])

(define_insn "get_tp_31"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=d,Q")
        (unspec:SI [(const_int 0)] UNSPEC_TP))]
  "!TARGET_64BIT"
  "@
   ear\t%0,%%a0
   stam\t%%a0,%%a0,%0"
  [(set_attr "op_type" "RRE,RS")])

(define_insn "set_tp_64"
  [(unspec_volatile [(match_operand:DI 0 "general_operand" "??d,Q")] UNSPECV_SET_TP)
   (clobber (match_scratch:SI 1 "=d,X"))]
  "TARGET_64BIT"
  "@
   sar\t%%a1,%0\;srlg\t%1,%0,32\;sar\t%%a0,%1
   lam\t%%a0,%%a1,%0"
  [(set_attr "op_type" "NN,RS")
   (set_attr "atype"   "reg,*")
   (set_attr "type"    "o3,*")
   (set_attr "length"  "14,*")])

(define_insn "set_tp_31"
  [(unspec_volatile [(match_operand:SI 0 "general_operand" "d,Q")] UNSPECV_SET_TP)]
  "!TARGET_64BIT"
  "@
   sar\t%%a0,%0
   lam\t%%a0,%%a0,%0"
  [(set_attr "op_type" "RRE,RS")])

(define_insn "*tls_load_64"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (unspec:DI [(match_operand:DI 1 "memory_operand" "m")
                    (match_operand:DI 2 "" "")]
		   UNSPEC_TLS_LOAD))]
  "TARGET_64BIT"
  "lg\t%0,%1%J2"
  [(set_attr "op_type" "RXE")])

(define_insn "*tls_load_31"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (unspec:SI [(match_operand:SI 1 "memory_operand" "R,T")
                    (match_operand:SI 2 "" "")]
		   UNSPEC_TLS_LOAD))]
  "!TARGET_64BIT"
  "@
   l\t%0,%1%J2
   ly\t%0,%1%J2"
  [(set_attr "op_type" "RX,RXY")])

(define_expand "call_value_tls"
  [(set (match_operand 0 "" "")
        (call (const_int 0) (const_int 0)))
   (use (match_operand 1 "" ""))]
  ""
{
  rtx insn, sym;

  if (!flag_pic)
    abort ();

  sym = s390_tls_get_offset ();
  sym = gen_rtx_UNSPEC (Pmode, gen_rtvec (1, sym), UNSPEC_PLT);
  sym = gen_rtx_CONST (Pmode, sym);

  /* Unless we can use the bras(l) insn, force the
     routine address into a register.  */
  if (!TARGET_SMALL_EXEC && !TARGET_CPU_ZARCH)
    {
      if (flag_pic)
	sym = legitimize_pic_address (sym, 0);
      else
	sym = force_reg (Pmode, sym);
    }

  sym = gen_rtx_MEM (QImode, sym);

  /* Emit insn.  */
  insn = emit_call_insn (
	    gen_call_value_tls_exp (operands[0], sym, const0_rtx,
  				    gen_rtx_REG (Pmode, RETURN_REGNUM),
				    operands[1]));

  /* The calling convention of __tls_get_offset uses the
     GOT register implicitly.  */
  use_reg (&CALL_INSN_FUNCTION_USAGE (insn), pic_offset_table_rtx);
  use_reg (&CALL_INSN_FUNCTION_USAGE (insn), operands[0]);
  CONST_OR_PURE_CALL_P (insn) = 1;

  DONE;
})

(define_expand "call_value_tls_exp"
  [(parallel [(set (match_operand 0 "" "")
                   (call (match_operand 1 "" "")
                         (match_operand 2 "" "")))
              (clobber (match_operand 3 "" ""))
	      (use (match_operand 4 "" ""))])]
  ""
  "")

(define_insn "*bras_tls"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "bras_sym_operand" "X"))
              (match_operand 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))
   (use (match_operand 4 "" ""))]
  "TARGET_SMALL_EXEC && GET_MODE (operands[3]) == Pmode"
  "bras\t%3,%1%J4"
  [(set_attr "op_type" "RI")
   (set_attr "type"    "jsr")])

(define_insn "*brasl_tls"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "bras_sym_operand" "X"))
              (match_operand 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))
   (use (match_operand 4 "" ""))]
  "TARGET_CPU_ZARCH && GET_MODE (operands[3]) == Pmode"
  "brasl\t%3,%1%J4"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "jsr")])

(define_insn "*basr_tls"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "address_operand" "U"))
              (match_operand 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))
   (use (match_operand 4 "" ""))]
  "GET_MODE (operands[3]) == Pmode"
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "basr\t%3,%1%J4";
  else
    return "bas\t%3,%a1%J4";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 1 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "jsr")
   (set_attr "atype" "agen")])

;;
;;- Miscellaneous instructions.
;;

;
; allocate stack instruction pattern(s).
;

(define_expand "allocate_stack"
  [(set (reg 15)
        (plus (reg 15) (match_operand 1 "general_operand" "")))
   (set (match_operand 0 "general_operand" "")
        (reg 15))]
 "TARGET_BACKCHAIN"
{
    rtx stack = gen_rtx (REG, Pmode, STACK_POINTER_REGNUM);
    rtx chain = gen_rtx (MEM, Pmode, stack);
    rtx temp = gen_reg_rtx (Pmode);

    emit_move_insn (temp, chain);

    if (TARGET_64BIT)
      emit_insn (gen_adddi3 (stack, stack, negate_rtx (Pmode, operands[1])));
    else
      emit_insn (gen_addsi3 (stack, stack, negate_rtx (Pmode, operands[1])));

    emit_move_insn (chain, temp);

    emit_move_insn (operands[0], virtual_stack_dynamic_rtx);
    DONE;
})


;
; setjmp instruction pattern.
;

(define_expand "builtin_setjmp_receiver"
  [(match_operand 0 "" "")]
  "flag_pic"
{
  s390_load_got (false);
  emit_insn (gen_rtx_USE (VOIDmode, pic_offset_table_rtx));
  DONE;
})

;; These patterns say how to save and restore the stack pointer.  We need not
;; save the stack pointer at function level since we are careful to
;; preserve the backchain.  At block level, we have to restore the backchain
;; when we restore the stack pointer.
;;
;; For nonlocal gotos, we must save both the stack pointer and its
;; backchain and restore both.  Note that in the nonlocal case, the
;; save area is a memory location.

(define_expand "save_stack_function"
  [(match_operand 0 "general_operand" "")
   (match_operand 1 "general_operand" "")]
  ""
  "DONE;")

(define_expand "restore_stack_function"
  [(match_operand 0 "general_operand" "")
   (match_operand 1 "general_operand" "")]
  ""
  "DONE;")

(define_expand "restore_stack_block"
  [(use (match_operand 0 "register_operand" ""))
   (set (match_dup 2) (match_dup 3))
   (set (match_dup 0) (match_operand 1 "register_operand" ""))
   (set (match_dup 3) (match_dup 2))]
  ""
{
  operands[2] = gen_reg_rtx (Pmode);
  operands[3] = gen_rtx_MEM (Pmode, operands[0]);
})

(define_expand "save_stack_nonlocal"
  [(match_operand 0 "memory_operand" "")
   (match_operand 1 "register_operand" "")]
  ""
{
  rtx temp = gen_reg_rtx (Pmode);

  /* Copy the backchain to the first word, sp to the second and the literal pool
     base to the third. */
  emit_move_insn (operand_subword (operands[0], 2, 0,
                  TARGET_64BIT ? OImode : TImode),
                  gen_rtx_REG (Pmode, BASE_REGISTER));
  emit_move_insn (temp, gen_rtx_MEM (Pmode, operands[1]));
  emit_move_insn (operand_subword (operands[0], 0, 0,
                 TARGET_64BIT ? OImode : TImode),
                 temp);
  emit_move_insn (operand_subword (operands[0], 1, 0,
                 TARGET_64BIT ? OImode : TImode),
                 operands[1]);
  DONE;
})

(define_expand "restore_stack_nonlocal"
  [(match_operand 0 "register_operand" "")
   (match_operand 1 "memory_operand" "")]
  ""
{
  rtx temp = gen_reg_rtx (Pmode);
  rtx base = gen_rtx_REG (Pmode, BASE_REGISTER);

  /* Restore the backchain from the first word, sp from the second and the
     literal pool base from the third. */
  emit_move_insn (temp,
                 operand_subword (operands[1], 0, 0,
                 TARGET_64BIT ? OImode : TImode));
  emit_move_insn (operands[0],
                 operand_subword (operands[1], 1, 0,
                 TARGET_64BIT ? OImode : TImode));
  emit_move_insn (gen_rtx_MEM (Pmode, operands[0]), temp);
  emit_move_insn (base,
                  operand_subword (operands[1], 2, 0,
                  TARGET_64BIT ? OImode : TImode));
  emit_insn (gen_rtx_USE (VOIDmode, base));

  DONE;
})


;
; nop instruction pattern(s).
;

(define_insn "nop"
  [(const_int 0)]
  ""
  "lr\t0,0"
  [(set_attr "op_type" "RR")])


;
; Special literal pool access instruction pattern(s).
;

(define_insn "*pool_entry"
  [(unspec_volatile [(match_operand 0 "consttable_operand" "X")]
                    UNSPECV_POOL_ENTRY)]
  ""
{
  enum machine_mode mode = GET_MODE (PATTERN (insn));
  unsigned int align = GET_MODE_BITSIZE (mode);
  s390_output_pool_entry (asm_out_file, operands[0], mode, align);
  return "";
}
  [(set_attr "op_type" "NN")
   (set (attr "length") 
        (symbol_ref "GET_MODE_SIZE (GET_MODE (PATTERN (insn)))"))])

(define_insn "pool_start_31"
  [(unspec_volatile [(const_int 0)] UNSPECV_POOL_START)]
  "!TARGET_CPU_ZARCH"
  ".align\t4"
  [(set_attr "op_type"  "NN")
   (set_attr "length"   "2")])

(define_insn "pool_end_31"
  [(unspec_volatile [(const_int 0)] UNSPECV_POOL_END)]
  "!TARGET_CPU_ZARCH"
  ".align\t2"
  [(set_attr "op_type"  "NN")
   (set_attr "length"   "2")])

(define_insn "pool_start_64"
  [(unspec_volatile [(const_int 0)] UNSPECV_POOL_START)]
  "TARGET_CPU_ZARCH"
  ".section\t.rodata\;.align\t8"
  [(set_attr "op_type"  "NN")
   (set_attr "length"   "0")])

(define_insn "pool_end_64"
  [(unspec_volatile [(const_int 0)] UNSPECV_POOL_END)]
  "TARGET_CPU_ZARCH"
  ".previous"
  [(set_attr "op_type"  "NN")
   (set_attr "length"   "0")])

(define_insn "main_base_31_small"
  [(set (match_operand 0 "register_operand" "=a")
        (unspec [(label_ref (match_operand 1 "" ""))] UNSPEC_MAIN_BASE))]
  "!TARGET_CPU_ZARCH && GET_MODE (operands[0]) == Pmode"
  "basr\t%0,0"
  [(set_attr "op_type" "RR")
   (set_attr "type"    "la")])

(define_insn "main_base_31_large"
  [(set (match_operand 0 "register_operand" "=a")
        (unspec [(label_ref (match_operand 1 "" ""))] UNSPEC_MAIN_BASE))
   (set (pc) (label_ref (match_operand 2 "" "")))]
  "!TARGET_CPU_ZARCH && GET_MODE (operands[0]) == Pmode"
  "bras\t%0,%2"
  [(set_attr "op_type" "RI")])

(define_insn "main_base_64"
  [(set (match_operand 0 "register_operand" "=a")
        (unspec [(label_ref (match_operand 1 "" ""))] UNSPEC_MAIN_BASE))]
  "TARGET_CPU_ZARCH && GET_MODE (operands[0]) == Pmode"
  "larl\t%0,%1"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "larl")])

(define_insn "main_pool"
  [(unspec_volatile [(const_int 0)] UNSPECV_MAIN_POOL)]
  ""
  "* abort ();"
  [(set_attr "op_type" "NN")])

(define_insn "reload_base_31"
  [(set (match_operand 0 "register_operand" "=a")
        (unspec [(label_ref (match_operand 1 "" ""))] UNSPEC_RELOAD_BASE))]
  "!TARGET_CPU_ZARCH && GET_MODE (operands[0]) == Pmode"
  "basr\t%0,0\;la\t%0,%1-.(%0)"
  [(set_attr "op_type" "NN")
   (set_attr "type"    "la")
   (set_attr "length"  "6")])

(define_insn "reload_base_64"
  [(set (match_operand 0 "register_operand" "=a")
        (unspec [(label_ref (match_operand 1 "" ""))] UNSPEC_RELOAD_BASE))]
  "TARGET_CPU_ZARCH && GET_MODE (operands[0]) == Pmode"
  "larl\t%0,%1"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "larl")])

(define_insn "pool"
  [(unspec_volatile [(match_operand 0 "const_int_operand" "n")] UNSPECV_POOL)]
  ""
  "* abort ();"
  [(set_attr "op_type" "NN")
   (set (attr "length") (symbol_ref "INTVAL (operands[0])"))])

;;
;; Insns related to generating the function prologue and epilogue.
;;


(define_expand "prologue"
  [(use (const_int 0))]
  ""
  "s390_emit_prologue (); DONE;")

(define_expand "epilogue"
  [(use (const_int 1))]
  ""
  "s390_emit_epilogue (); DONE;")

(define_insn "*return"
  [(return)
   (use (match_operand 0 "register_operand" "a"))]
  "GET_MODE (operands[0]) == Pmode"
  "br\t%0"
  [(set_attr "op_type" "RR")
   (set_attr "type"    "jsr")
   (set_attr "atype"   "agen")])


;; Instruction definition to extend a 31-bit pointer into a 64-bit
;; pointer. This is used for compatibility.

(define_expand "ptr_extend"
  [(set (match_operand:DI 0 "register_operand" "=r")
        (match_operand:SI 1 "register_operand" "r"))]
  "TARGET_64BIT"
{
  emit_insn (gen_anddi3 (operands[0],
			 gen_lowpart (DImode, operands[1]),
			 GEN_INT (0x7fffffff)));
  DONE;
})
