# -*- coding: utf-8 -*-

# Copyright (C) 2005 Osmo Salomaa
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

import gaupol

from gi.repository import Gdk


class TestModule(gaupol.TestCase):

    def test_hex_to_rgba(self):
        color = gaupol.util.hex_to_rgba("#ff0000")
        assert color.equal(Gdk.RGBA(red=1, green=0, blue=0, alpha=1))

    def test_rgba_to_hex(self):
        rgba = Gdk.RGBA(red=1, green=0, blue=1)
        color = gaupol.util.rgba_to_hex(rgba)
        assert color == "#ff00ff"

    def test_tree_path_to_row(self):
        path = gaupol.util.tree_row_to_path(1)
        assert gaupol.util.tree_path_to_row(path) == 1
        assert gaupol.util.tree_path_to_row("1") == 1

    def test_tree_row_to_path(self):
        path = gaupol.util.tree_row_to_path(1)
        assert gaupol.util.tree_path_to_row(path) == 1
