/*  Note: You are free to use whatever license you want.
    Eventually you will be able to edit it within Glade. */

/*  gato
 *  Copyright (C) <YEAR> <AUTHORS>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gatosig.h"
#include "gatosrc.h"

GtkWidget*
get_widget                             (GtkWidget       *widget,
                                        gchar           *widget_name)
{
  GtkWidget *parent, *found_widget;

  for (;;)
    {
      if (GTK_IS_MENU (widget))
        parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
        parent = widget->parent;
      if (parent == NULL)
        break;
      widget = parent;
    }

  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

/* This is an internally used function to set notebook tab widgets. */
void
set_notebook_tab                       (GtkWidget       *notebook,
                                        gint             page_num,
                                        GtkWidget       *widget)
{
  GtkNotebookPage *page;
  GtkWidget *notebook_page;

  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
  notebook_page = page->child;
  gtk_widget_ref (notebook_page);
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
                            widget, page_num);
  gtk_widget_unref (notebook_page);
}

static GList *pixmaps_directories = NULL;

/* Use this function to set the directory containing installed pixmaps. */
void
add_pixmap_directory                   (gchar           *directory)
{
  pixmaps_directories = g_list_prepend (pixmaps_directories, g_strdup (directory));
}

/* This is an internally used function to check if a pixmap file exists. */
#ifndef G_DIR_SEPARATOR_S
#define G_DIR_SEPARATOR_S "/"
#endif
gchar*
check_file_exists                      (gchar           *directory,
                                        gchar           *filename)
{
  gchar *full_filename;
  struct stat s;
  gint status;

  full_filename = g_malloc (strlen (directory) + 1 + strlen (filename) + 1);
  strcpy (full_filename, directory);
  strcat (full_filename, G_DIR_SEPARATOR_S);
  strcat (full_filename, filename);

  status = stat (full_filename, &s);
  if (status == 0 && S_ISREG (s.st_mode))
    return full_filename;
  g_free (full_filename);
  return NULL;
}

/* This is an internally used function to create pixmaps. */
GtkWidget*
create_pixmap                          (GtkWidget       *widget,
                                        gchar           *filename)
{
  gchar *found_filename = NULL;
  GdkColormap *colormap;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GtkWidget *pixmap;
  GList *elem;

  /* We first try any pixmaps directories set by the application. */
  elem = pixmaps_directories;
  while (elem)
    {
      found_filename = check_file_exists ((gchar*)elem->data, filename);
      if (found_filename)
        break;
      elem = elem->next;
    }

  /* If we haven't found the pixmap, try the source directory. */
  if (!found_filename)
    {
      found_filename = check_file_exists ("../xtra/xpm", filename);
    }

  if (!found_filename)
    {
      g_print ("Couldn't find pixmap file: %s", filename);
      return NULL;
    }

  colormap = gtk_widget_get_colormap (widget);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask,
                                                   NULL, found_filename);
  g_free (found_filename);
  if (gdkpixmap == NULL)
    return NULL;
  pixmap = gtk_pixmap_new (gdkpixmap, mask);
  gdk_pixmap_unref (gdkpixmap);
  gdk_bitmap_unref (mask);
  return pixmap;
}

GtkWidget*
create_win_main ()
{
  GtkWidget *win_main;
  GtkWidget *vbox1;
  GtkWidget *handlebox3;
  GtkWidget *mnu_main;
  GtkWidget *file;
  GtkWidget *file_menu;
  GtkWidget *saveas;
  GtkWidget *separador1;
  GtkWidget *quit;
  GtkWidget *jobs;
  GtkWidget *jobs_menu;
  GtkWidget *refresh;
  GtkWidget *delete;
  GtkWidget *view;
  GtkWidget *Options;
  GtkWidget *Options_menu;
  GtkWidget *hidetoolbar;
  GtkWidget *help;
  GtkWidget *help_menu;
  GtkWidget *about;
  GtkWidget *handlebox2;
  GtkWidget *toolbar1;
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *btn_tbrquit;
  GtkWidget *btn_tbrrefresh;
  GtkWidget *btn_tbrview;
  GtkWidget *btn_tbradd;
  GtkWidget *btn_tbrdel;
  GtkWidget *btn_tbrhlp;
  GtkWidget *hbox1;
  GtkWidget *frame3;
  GtkWidget *vbox4;
  GtkWidget *scrolledwindow1;
  GtkWidget *grd_jobs;
  GtkWidget *label15;
  GtkWidget *label16;
  GtkWidget *label17;
  GtkWidget *label18;
  GtkWidget *label19;
  GtkWidget *vbox3;
  GtkWidget *table2;
  GtkWidget *cbt_queue;
  GtkWidget *label8;
  GtkWidget *cbt_day;
  GtkWidget *cbt_mail;
  GtkWidget *hbox3;
  GtkWidget *edt_action;
  GtkWidget *btn_xtra;
  GtkWidget *frm_date;
  GtkWidget *table4;
  GtkWidget *label12;
  GtkWidget *label13;
  GtkWidget *label14;
  GtkObject *sbt_day_adj;
  GtkWidget *sbt_day;
  GtkObject *sbt_month_adj;
  GtkWidget *sbt_month;
  GtkObject *sbt_year_adj;
  GtkWidget *sbt_year;
  GtkWidget *btn_cal;
  GtkWidget *cmb_day;
  GList *cmb_day_items = NULL;
  GtkWidget *edt_cmbday;  
  GtkWidget *frm_queue;
  GtkWidget *cmb_queue;
  GList *cmb_queue_items = NULL;
  GtkWidget *table3;
  GtkWidget *label10;
  GtkWidget *label11;
  GtkObject *sbt_hour_adj;
  GtkWidget *sbt_hour;
  GtkObject *sbt_minute_adj;
  GtkWidget *sbt_minute;
  GtkWidget *cmb_time;
  GList *cmb_time_items = NULL;
  GtkWidget *edt_cmbtime;  
  GtkWidget *cmb_action;
  GList *cmb_action_items = NULL;
  GtkWidget *hbuttonbox2;
  GtkWidget *btn_add;
  GtkWidget *statusbar1;
  GtkAccelGroup *accel_group;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  win_main = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (win_main), "win_main", win_main);
  gtk_widget_set_usize (win_main, 600, 360);
  gtk_signal_connect (GTK_OBJECT (win_main), "delete_event",
                      GTK_SIGNAL_FUNC (on_win_main_delete_event),
                      NULL);
  gtk_window_set_title (GTK_WINDOW (win_main), "gatO");
  gtk_window_set_policy (GTK_WINDOW (win_main), TRUE, TRUE, FALSE);
  gtk_window_set_wmclass (GTK_WINDOW (win_main), "gatO", "");

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (win_main), vbox1);

  handlebox3 = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "handlebox3", handlebox3);
  gtk_widget_show (handlebox3);
  gtk_box_pack_start (GTK_BOX (vbox1), handlebox3, FALSE, TRUE, 0);

  mnu_main = gtk_menu_bar_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "mnu_main", mnu_main);
  gtk_widget_show (mnu_main);
  gtk_container_add (GTK_CONTAINER (handlebox3), mnu_main);
  gtk_container_border_width (GTK_CONTAINER (mnu_main), 2);

  file = gtk_menu_item_new_with_label ("File");
  gtk_object_set_data (GTK_OBJECT (win_main), "file", file);
  gtk_widget_show (file);
  gtk_container_add (GTK_CONTAINER (mnu_main), file);

  file_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "file_menu", file_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (file), file_menu);

  saveas = gtk_menu_item_new_with_label ("Save as");
  gtk_object_set_data (GTK_OBJECT (win_main), "saveas", saveas);
  gtk_widget_show (saveas);
  gtk_container_add (GTK_CONTAINER (file_menu), saveas);
  gtk_signal_connect (GTK_OBJECT (saveas), "activate",
                      GTK_SIGNAL_FUNC (on_saveas_activate),
                      NULL);
  accel_group = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (win_main), accel_group);
  gtk_widget_add_accelerator (saveas, "activate", accel_group,
                              GDK_S, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  separador1 = gtk_menu_item_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "separador1", separador1);
  gtk_widget_show (separador1);
  gtk_container_add (GTK_CONTAINER (file_menu), separador1);

  quit = gtk_menu_item_new_with_label ("Quit");
  gtk_object_set_data (GTK_OBJECT (win_main), "quit", quit);
  gtk_widget_show (quit);
  gtk_container_add (GTK_CONTAINER (file_menu), quit);
  gtk_signal_connect (GTK_OBJECT (quit), "activate",
                      GTK_SIGNAL_FUNC (on_quit_activate),
                      NULL);
  gtk_widget_add_accelerator (quit, "activate", accel_group,
                              GDK_Q, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  jobs = gtk_menu_item_new_with_label ("Jobs");
  gtk_object_set_data (GTK_OBJECT (win_main), "jobs", jobs);
  gtk_widget_show (jobs);
  gtk_container_add (GTK_CONTAINER (mnu_main), jobs);

  jobs_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "jobs_menu", jobs_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (jobs), jobs_menu);

  refresh = gtk_menu_item_new_with_label ("Refresh");
  gtk_object_set_data (GTK_OBJECT (win_main), "refresh", refresh);
  gtk_widget_show (refresh);
  gtk_container_add (GTK_CONTAINER (jobs_menu), refresh);
  gtk_signal_connect (GTK_OBJECT (refresh), "activate",
                      GTK_SIGNAL_FUNC (on_refresh_activate),
                      NULL);
  gtk_widget_add_accelerator (refresh, "activate", accel_group,
                              GDK_R, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  delete = gtk_menu_item_new_with_label ("Delete");
  gtk_object_set_data (GTK_OBJECT (win_main), "delete", delete);
  gtk_widget_show (delete);
  gtk_container_add (GTK_CONTAINER (jobs_menu), delete);
  gtk_signal_connect (GTK_OBJECT (delete), "activate",
                      GTK_SIGNAL_FUNC (on_delete_activate),
                      NULL);
  gtk_widget_add_accelerator (delete, "activate", accel_group,
                              GDK_D, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  view = gtk_menu_item_new_with_label ("View");
  gtk_object_set_data (GTK_OBJECT (win_main), "view", view);
  gtk_widget_show (view);
  gtk_container_add (GTK_CONTAINER (jobs_menu), view);
  gtk_signal_connect (GTK_OBJECT (view), "activate",
                      GTK_SIGNAL_FUNC (on_view_activate),
                      NULL);
  gtk_widget_add_accelerator (view, "activate", accel_group,
                              GDK_V, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  Options = gtk_menu_item_new_with_label ("Options");
  gtk_object_set_data (GTK_OBJECT (win_main), "Options", Options);
  gtk_widget_show (Options);
  gtk_container_add (GTK_CONTAINER (mnu_main), Options);

  Options_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "Options_menu", Options_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (Options), Options_menu);

  hidetoolbar = gtk_check_menu_item_new_with_label ("Hide toolbar");
  gtk_object_set_data (GTK_OBJECT (win_main), "hidetoolbar", hidetoolbar);
  gtk_widget_show (hidetoolbar);
  gtk_container_add (GTK_CONTAINER (Options_menu), hidetoolbar);
  gtk_signal_connect (GTK_OBJECT (hidetoolbar), "activate",
                      GTK_SIGNAL_FUNC (on_hidetoolbar_activate),
                      NULL);
  gtk_widget_add_accelerator (hidetoolbar, "activate", accel_group,
                              GDK_H, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  help = gtk_menu_item_new_with_label ("Help");
  gtk_object_set_data (GTK_OBJECT (win_main), "help", help);
  gtk_widget_show (help);
  gtk_container_add (GTK_CONTAINER (mnu_main), help);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (help));

  help_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "help_menu", help_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (help), help_menu);

  about = gtk_menu_item_new_with_label ("About");
  gtk_object_set_data (GTK_OBJECT (win_main), "about", about);
  gtk_widget_show (about);
  gtk_container_add (GTK_CONTAINER (help_menu), about);
  gtk_signal_connect (GTK_OBJECT (about), "activate",
                      GTK_SIGNAL_FUNC (on_about_activate),
                      NULL);
  gtk_widget_add_accelerator (about, "activate", accel_group,
                              GDK_B, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  handlebox2 = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "handlebox2", handlebox2);
  gtk_widget_show (handlebox2);
  gtk_box_pack_start (GTK_BOX (vbox1), handlebox2, FALSE, TRUE, 0);

  toolbar1 = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  gtk_object_set_data (GTK_OBJECT (win_main), "toolbar1", toolbar1);
  gtk_widget_show (toolbar1);
  gtk_container_add (GTK_CONTAINER (handlebox2), toolbar1);

  tmp_toolbar_icon = create_pixmap (win_main, "exit.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbrquit = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Exit",
                                "quit this program", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbrquit", btn_tbrquit);
  gtk_widget_show (btn_tbrquit);
  gtk_signal_connect (GTK_OBJECT (btn_tbrquit), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbrquit_clicked),
                      NULL);
  gtk_widget_add_accelerator (btn_tbrquit, "clicked", accel_group,
                              GDK_Q, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  tmp_toolbar_icon = create_pixmap (win_main, "refresh.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbrrefresh = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Refresh",
                                "refresh jobs list", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbrrefresh", btn_tbrrefresh);
  gtk_widget_show (btn_tbrrefresh);
  gtk_signal_connect (GTK_OBJECT (btn_tbrrefresh), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbrrefresh_clicked),
                      NULL);
  gtk_widget_add_accelerator (btn_tbrrefresh, "clicked", accel_group,
                              GDK_R, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  tmp_toolbar_icon = create_pixmap (win_main, "view.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbrview = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "View",
                                "view current selected job", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbrview", btn_tbrview);
  gtk_widget_show (btn_tbrview);
  gtk_signal_connect (GTK_OBJECT (btn_tbrview), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbrview_clicked),
                      NULL);
  gtk_widget_add_accelerator (btn_tbrview, "clicked", accel_group,
                              GDK_V, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  tmp_toolbar_icon = create_pixmap (win_main, "add.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbradd = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Add",
                                "add current job", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbradd", btn_tbradd);
  gtk_widget_show (btn_tbradd);
  gtk_signal_connect (GTK_OBJECT (btn_tbradd), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbradd_clicked),
                      NULL);
  gtk_widget_add_accelerator (btn_tbradd, "clicked", accel_group,
                              GDK_A, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  tmp_toolbar_icon = create_pixmap (win_main, "del.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbrdel = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Del",
                                "deletes current selected job", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbrdel", btn_tbrdel);
  gtk_widget_show (btn_tbrdel);
  gtk_signal_connect (GTK_OBJECT (btn_tbrdel), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbrdel_clicked),
                      NULL);
  gtk_widget_add_accelerator (btn_tbrdel, "clicked", accel_group,
                              GDK_D, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator (btn_tbrdel, "clicked", accel_group,
                              GDK_Delete, 0, GTK_ACCEL_VISIBLE);

  tmp_toolbar_icon = create_pixmap (win_main, "help.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbrhlp = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Help",
                                "Shows the help file", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbrhlp", btn_tbrhlp);
  gtk_widget_show (btn_tbrhlp);
  gtk_signal_connect (GTK_OBJECT (btn_tbrhlp), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbrhlp_clicked),
                      NULL);
  gtk_widget_add_accelerator (btn_tbrhlp, "clicked", accel_group,
                              GDK_H, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  hbox1 = gtk_hbox_new (TRUE, 2);
  gtk_object_set_data (GTK_OBJECT (win_main), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 2);

  frame3 = gtk_frame_new ("Jobs");
  gtk_object_set_data (GTK_OBJECT (win_main), "frame3", frame3);
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (hbox1), frame3, TRUE, TRUE, 0);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "vbox4", vbox4);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (frame3), vbox4);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "scrolledwindow1", scrolledwindow1);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox4), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  grd_jobs = gtk_clist_new (5);
  gtk_object_set_data (GTK_OBJECT (win_main), "grd_jobs", grd_jobs);
  gtk_widget_show (grd_jobs);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), grd_jobs);
  gtk_tooltips_set_tip (tooltips, grd_jobs, "jobs queued", NULL);
  gtk_signal_connect (GTK_OBJECT (grd_jobs), "select_row",
                      GTK_SIGNAL_FUNC (on_grd_jobs_select_row),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (grd_jobs), "unselect_row",
                      GTK_SIGNAL_FUNC (on_grd_jobs_unselect_row),
                      NULL);
  gtk_clist_set_column_width (GTK_CLIST (grd_jobs), 0, 33);
  gtk_clist_set_column_width (GTK_CLIST (grd_jobs), 1, 72);
  gtk_clist_set_column_width (GTK_CLIST (grd_jobs), 2, 30);
  gtk_clist_set_column_width (GTK_CLIST (grd_jobs), 3, 17);
  gtk_clist_set_column_width (GTK_CLIST (grd_jobs), 4, 80);
  gtk_clist_column_titles_show (GTK_CLIST (grd_jobs));

  label15 = gtk_label_new ("job");
  gtk_object_set_data (GTK_OBJECT (win_main), "label15", label15);
  gtk_widget_show (label15);
  gtk_clist_set_column_widget (GTK_CLIST (grd_jobs), 0, label15);

  label16 = gtk_label_new ("Date");
  gtk_object_set_data (GTK_OBJECT (win_main), "label16", label16);
  gtk_widget_show (label16);
  gtk_clist_set_column_widget (GTK_CLIST (grd_jobs), 1, label16);

  label17 = gtk_label_new ("Hour");
  gtk_object_set_data (GTK_OBJECT (win_main), "label17", label17);
  gtk_widget_show (label17);
  gtk_clist_set_column_widget (GTK_CLIST (grd_jobs), 2, label17);

  label18 = gtk_label_new ("Q");
  gtk_object_set_data (GTK_OBJECT (win_main), "label18", label18);
  gtk_widget_show (label18);
  gtk_clist_set_column_widget (GTK_CLIST (grd_jobs), 3, label18);

  label19 = gtk_label_new ("User");
  gtk_object_set_data (GTK_OBJECT (win_main), "label19", label19);
  gtk_widget_show (label19);
  gtk_clist_set_column_widget (GTK_CLIST (grd_jobs), 4, label19);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "vbox3", vbox3);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox3, TRUE, TRUE, 0);

  table2 = gtk_table_new (5, 2, FALSE);
  gtk_object_set_data (GTK_OBJECT (win_main), "table2", table2);
  gtk_widget_show (table2);
  gtk_box_pack_start (GTK_BOX (vbox3), table2, TRUE, TRUE, 0);

  cbt_queue = gtk_check_button_new_with_label ("Queue");
  gtk_object_set_data (GTK_OBJECT (win_main), "cbt_queue", cbt_queue);
  gtk_widget_show (cbt_queue);
  gtk_table_attach (GTK_TABLE (table2), cbt_queue, 0, 1, 4, 5,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_signal_connect (GTK_OBJECT (cbt_queue), "toggled",
                      GTK_SIGNAL_FUNC (on_cbt_queue_toggled),
                      NULL);

  label8 = gtk_label_new ("Hour");
  gtk_object_set_data (GTK_OBJECT (win_main), "label8", label8);
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table2), label8, 0, 1, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label8), 0.05, 0.5);

  cbt_day = gtk_check_button_new_with_label ("Day");
  gtk_object_set_data (GTK_OBJECT (win_main), "cbt_day", cbt_day);
  gtk_widget_show (cbt_day);
  gtk_table_attach (GTK_TABLE (table2), cbt_day, 0, 1, 2, 3,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_signal_connect (GTK_OBJECT (cbt_day), "toggled",
                      GTK_SIGNAL_FUNC (on_cbt_day_toggled),
                      NULL);

  cbt_mail = gtk_check_button_new_with_label ("Mail\nnotification");
  gtk_object_set_data (GTK_OBJECT (win_main), "cbt_mail", cbt_mail);
  gtk_widget_show (cbt_mail);
  gtk_table_attach (GTK_TABLE (table2), cbt_mail, 0, 1, 3, 4,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "hbox3", hbox3);
  gtk_widget_show (hbox3);
  gtk_table_attach (GTK_TABLE (table2), hbox3, 1, 2, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  edt_action = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "edt_action", edt_action);
  gtk_widget_show (edt_action);
  gtk_box_pack_start (GTK_BOX (hbox3), edt_action, TRUE, TRUE, 0);

  btn_xtra = gtk_button_new_with_label ("...");
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_xtra", btn_xtra);
  gtk_widget_show (btn_xtra);
  gtk_box_pack_start (GTK_BOX (hbox3), btn_xtra, FALSE, TRUE, 0);
  gtk_widget_set_usize (btn_xtra, -2, 24);
  gtk_signal_connect (GTK_OBJECT (btn_xtra), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_xtra_clicked),
                      NULL);

  frm_date = gtk_frame_new (NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "frm_date", frm_date);
  gtk_widget_show (frm_date);
  gtk_table_attach (GTK_TABLE (table2), frm_date, 1, 2, 2, 3,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_widget_set_sensitive (frm_date, FALSE);

  table4 = gtk_table_new (3, 4, FALSE);
  gtk_object_set_data (GTK_OBJECT (win_main), "table4", table4);
  gtk_widget_show (table4);
  gtk_container_add (GTK_CONTAINER (frm_date), table4);

  label12 = gtk_label_new ("Day");
  gtk_object_set_data (GTK_OBJECT (win_main), "label12", label12);
  gtk_widget_show (label12);
  gtk_table_attach (GTK_TABLE (table4), label12, 0, 1, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label13 = gtk_label_new ("Month");
  gtk_object_set_data (GTK_OBJECT (win_main), "label13", label13);
  gtk_widget_show (label13);
  gtk_table_attach (GTK_TABLE (table4), label13, 1, 2, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label14 = gtk_label_new ("Year");
  gtk_object_set_data (GTK_OBJECT (win_main), "label14", label14);
  gtk_widget_show (label14);
  gtk_table_attach (GTK_TABLE (table4), label14, 2, 3, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  sbt_day_adj = gtk_adjustment_new (1, 1, 31, 1, 10, 10);
  sbt_day = gtk_spin_button_new (GTK_ADJUSTMENT (sbt_day_adj), 1, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "sbt_day", sbt_day);
  gtk_widget_show (sbt_day);
  gtk_table_attach (GTK_TABLE (table4), sbt_day, 0, 1, 2, 3,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (sbt_day), GTK_UPDATE_IF_VALID);

  sbt_month_adj = gtk_adjustment_new (1, 1, 12, 1, 10, 10);
  sbt_month = gtk_spin_button_new (GTK_ADJUSTMENT (sbt_month_adj), 1, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "sbt_month", sbt_month);
  gtk_widget_show (sbt_month);
  gtk_table_attach (GTK_TABLE (table4), sbt_month, 1, 2, 2, 3,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (sbt_month), GTK_UPDATE_IF_VALID);

  sbt_year_adj = gtk_adjustment_new (1999, 0, 9999, 1, 10, 10);
  sbt_year = gtk_spin_button_new (GTK_ADJUSTMENT (sbt_year_adj), 1, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "sbt_year", sbt_year);
  gtk_widget_show (sbt_year);
  gtk_table_attach (GTK_TABLE (table4), sbt_year, 2, 3, 2, 3,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (sbt_year), GTK_UPDATE_IF_VALID);

  btn_cal = gtk_button_new_with_label ("...");
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_cal", btn_cal);
  gtk_widget_show (btn_cal);
  gtk_table_attach (GTK_TABLE (table4), btn_cal, 3, 4, 2, 3,
                    (GtkAttachOptions) 0, (GtkAttachOptions) GTK_FILL, 0, 0);
  gtk_widget_set_usize (btn_cal, 20, -2);
  gtk_signal_connect (GTK_OBJECT (btn_cal), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_cal_clicked),
                      NULL);

  cmb_day = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "cmb_day", cmb_day);
  gtk_widget_show (cmb_day);
  gtk_table_attach (GTK_TABLE (table4), cmb_day, 0, 4, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  cmb_day_items = g_list_append (cmb_day_items, "Specified");
  cmb_day_items = g_list_append (cmb_day_items, "today");  
  cmb_day_items = g_list_append (cmb_day_items, "tomorrow");  
  cmb_day_items = g_list_append (cmb_day_items, "sun");
  cmb_day_items = g_list_append (cmb_day_items, "mon");
  cmb_day_items = g_list_append (cmb_day_items, "tue");
  cmb_day_items = g_list_append (cmb_day_items, "wed");
  cmb_day_items = g_list_append (cmb_day_items, "thu");
  cmb_day_items = g_list_append (cmb_day_items, "fri");
  cmb_day_items = g_list_append (cmb_day_items, "sat");
  gtk_combo_set_popdown_strings (GTK_COMBO (cmb_day), cmb_day_items);
  g_list_free (cmb_day_items);




  
  edt_cmbday = GTK_COMBO (cmb_day)->entry;
  gtk_widget_ref (edt_cmbday);
  gtk_object_set_data_full (GTK_OBJECT (win_main), "edt_cmbday", edt_cmbday,
                            (GtkDestroyNotify) gtk_widget_unref);
    gtk_signal_connect (GTK_OBJECT (edt_cmbday), "changed",
                      GTK_SIGNAL_FUNC (on_edt_cmbday_changed),
                      NULL);                            
  gtk_widget_show (edt_cmbday);
  gtk_entry_set_editable (GTK_ENTRY (edt_cmbday), FALSE);  
  gtk_entry_set_text (GTK_ENTRY (edt_cmbday), "Specified");
  




  frm_queue = gtk_frame_new (NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "frm_queue", frm_queue);
  gtk_widget_show (frm_queue);
  gtk_table_attach (GTK_TABLE (table2), frm_queue, 1, 2, 4, 5,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_widget_set_sensitive (frm_queue, FALSE);

  cmb_queue = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "cmb_queue", cmb_queue);
  gtk_widget_show (cmb_queue);
  gtk_container_add (GTK_CONTAINER (frm_queue), cmb_queue);
  gtk_widget_set_usize (GTK_COMBO (cmb_queue)->entry, -2, -2);
  gtk_widget_set_usize (cmb_queue, 12, -2);
  gtk_combo_set_case_sensitive (GTK_COMBO (cmb_queue), TRUE);
  cmb_queue_items = g_list_append (cmb_queue_items, "a");
  cmb_queue_items = g_list_append (cmb_queue_items, "b");
  cmb_queue_items = g_list_append (cmb_queue_items, "c");
  cmb_queue_items = g_list_append (cmb_queue_items, "d");
  cmb_queue_items = g_list_append (cmb_queue_items, "e");
  cmb_queue_items = g_list_append (cmb_queue_items, "f");
  cmb_queue_items = g_list_append (cmb_queue_items, "g");
  cmb_queue_items = g_list_append (cmb_queue_items, "h");
  cmb_queue_items = g_list_append (cmb_queue_items, "i");
  cmb_queue_items = g_list_append (cmb_queue_items, "j");
  cmb_queue_items = g_list_append (cmb_queue_items, "k");
  cmb_queue_items = g_list_append (cmb_queue_items, "l");
  cmb_queue_items = g_list_append (cmb_queue_items, "m");
  cmb_queue_items = g_list_append (cmb_queue_items, "n");
  cmb_queue_items = g_list_append (cmb_queue_items, "o");
  cmb_queue_items = g_list_append (cmb_queue_items, "p");
  cmb_queue_items = g_list_append (cmb_queue_items, "q");
  cmb_queue_items = g_list_append (cmb_queue_items, "r");
  cmb_queue_items = g_list_append (cmb_queue_items, "s");
  cmb_queue_items = g_list_append (cmb_queue_items, "t");
  cmb_queue_items = g_list_append (cmb_queue_items, "u");
  cmb_queue_items = g_list_append (cmb_queue_items, "v");
  cmb_queue_items = g_list_append (cmb_queue_items, "w");
  cmb_queue_items = g_list_append (cmb_queue_items, "x");
  cmb_queue_items = g_list_append (cmb_queue_items, "y");
  cmb_queue_items = g_list_append (cmb_queue_items, "z");
  gtk_combo_set_popdown_strings (GTK_COMBO (cmb_queue), cmb_queue_items);
  g_list_free (cmb_queue_items);
  
  
  
  
  


  

  table3 = gtk_table_new (3, 2, FALSE);
  gtk_object_set_data (GTK_OBJECT (win_main), "table3", table3);
  gtk_widget_show (table3);
  gtk_table_attach (GTK_TABLE (table2), table3, 1, 2, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label10 = gtk_label_new ("Hour");
  gtk_object_set_data (GTK_OBJECT (win_main), "label10", label10);
  gtk_widget_show (label10);
  gtk_table_attach (GTK_TABLE (table3), label10, 0, 1, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label11 = gtk_label_new ("Minute");
  gtk_object_set_data (GTK_OBJECT (win_main), "label11", label11);
  gtk_widget_show (label11);
  gtk_table_attach (GTK_TABLE (table3), label11, 1, 2, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  sbt_hour_adj = gtk_adjustment_new (0, 0, 23, 1, 10, 10);
  sbt_hour = gtk_spin_button_new (GTK_ADJUSTMENT (sbt_hour_adj), 1, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "sbt_hour", sbt_hour);
  gtk_widget_show (sbt_hour);
  gtk_table_attach (GTK_TABLE (table3), sbt_hour, 0, 1, 2, 3,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (sbt_hour), GTK_UPDATE_IF_VALID);

  sbt_minute_adj = gtk_adjustment_new (0, 0, 60, 1, 10, 10);
  sbt_minute = gtk_spin_button_new (GTK_ADJUSTMENT (sbt_minute_adj), 1, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "sbt_minute", sbt_minute);
  gtk_widget_show (sbt_minute);
  gtk_table_attach (GTK_TABLE (table3), sbt_minute, 1, 2, 2, 3,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (sbt_minute), GTK_UPDATE_IF_VALID);

  cmb_time = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "cmb_time", cmb_time);
  gtk_widget_show (cmb_time);
  gtk_table_attach (GTK_TABLE (table3), cmb_time, 0, 2, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  cmb_time_items = g_list_append (cmb_time_items, "Specified");
  cmb_time_items = g_list_append (cmb_time_items, "midnight");
  cmb_time_items = g_list_append (cmb_time_items, "noon");
  cmb_time_items = g_list_append (cmb_time_items, "teatime");
  gtk_combo_set_popdown_strings (GTK_COMBO (cmb_time), cmb_time_items);
  g_list_free (cmb_time_items);
  
  edt_cmbtime = GTK_COMBO (cmb_time)->entry;
  gtk_widget_ref (edt_cmbtime);
  gtk_object_set_data_full (GTK_OBJECT (win_main), "edt_cmbtime", edt_cmbtime,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect (GTK_OBJECT (edt_cmbtime), "changed",
                      GTK_SIGNAL_FUNC (on_edt_cmbtime_changed),
                      NULL);                            
  gtk_widget_show (edt_cmbtime);
  gtk_entry_set_editable (GTK_ENTRY (edt_cmbtime), FALSE);  
  gtk_entry_set_text (GTK_ENTRY (edt_cmbtime), "Specified");
  
  

  cmb_action = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "cmb_action", cmb_action);
  gtk_widget_show (cmb_action);
  gtk_table_attach (GTK_TABLE (table2), cmb_action, 0, 1, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_widget_set_usize (GTK_COMBO (cmb_action)->entry, 34, -2);
  gtk_widget_set_usize (cmb_action, 50, -2);
  cmb_action_items = g_list_append (cmb_action_items, "Command");
  cmb_action_items = g_list_append (cmb_action_items, "File");
  gtk_combo_set_popdown_strings (GTK_COMBO (cmb_action), cmb_action_items);
  g_list_free (cmb_action_items);

  hbuttonbox2 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "hbuttonbox2", hbuttonbox2);
  gtk_widget_show (hbuttonbox2);
  gtk_box_pack_start (GTK_BOX (vbox3), hbuttonbox2, FALSE, TRUE, 0);

  btn_add = gtk_button_new_with_label ("Add");
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_add", btn_add);
  gtk_widget_show (btn_add);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), btn_add);
  gtk_tooltips_set_tip (tooltips, btn_add, "add current job", NULL);
  gtk_signal_connect (GTK_OBJECT (btn_add), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_add_clicked),
                      NULL);
  gtk_widget_add_accelerator (btn_add, "clicked", accel_group,
                              GDK_Return, 0, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator (btn_add, "clicked", accel_group,
                              GDK_A, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

  statusbar1 = gtk_statusbar_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "statusbar1", statusbar1);
  gtk_widget_show (statusbar1);
  gtk_box_pack_start (GTK_BOX (vbox1), statusbar1, FALSE, TRUE, 0);

  gtk_object_set_data (GTK_OBJECT (win_main), "tooltips", tooltips);

  return win_main;
}

GtkWidget*
create_win_edit ()
{
  GtkWidget *win_edit;
  GtkWidget *vbox5;
  GtkWidget *scrolledwindow2;
  GtkWidget *edt_text;
  GtkWidget *hbuttonbox6;
  GtkWidget *btn_close;
  GtkAccelGroup *accel_group;

  win_edit = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (win_edit), "win_edit", win_edit);
  gtk_widget_set_usize (win_edit, 400, 400);
  gtk_window_set_policy (GTK_WINDOW (win_edit), TRUE, TRUE, FALSE);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_edit), "vbox5", vbox5);
  gtk_widget_show (vbox5);
  gtk_container_add (GTK_CONTAINER (win_edit), vbox5);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_edit), "scrolledwindow2", scrolledwindow2);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (vbox5), scrolledwindow2, TRUE, TRUE, 0);

  edt_text = gtk_text_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_edit), "edt_text", edt_text);
  gtk_widget_show (edt_text);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), edt_text);
  gtk_widget_set_usize (edt_text, 400, 400);
  gtk_signal_connect (GTK_OBJECT (edt_text), "changed",
                      GTK_SIGNAL_FUNC (on_edt_text_changed),
                      NULL);
  gtk_text_set_editable (GTK_TEXT (edt_text), TRUE);

  hbuttonbox6 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_edit), "hbuttonbox6", hbuttonbox6);
  gtk_widget_show (hbuttonbox6);
  gtk_box_pack_start (GTK_BOX (vbox5), hbuttonbox6, FALSE, TRUE, 0);

  btn_close = gtk_button_new_with_label ("Close");
  gtk_object_set_data (GTK_OBJECT (win_edit), "btn_close", btn_close);
  gtk_widget_show (btn_close);
  gtk_container_add (GTK_CONTAINER (hbuttonbox6), btn_close);
  gtk_signal_connect (GTK_OBJECT (btn_close), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_close_clicked),
                      NULL);
  accel_group = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (win_edit), accel_group);
  gtk_widget_add_accelerator (btn_close, "clicked", accel_group,
                              GDK_Return, 0, GTK_ACCEL_VISIBLE);

  return win_edit;
}

GtkWidget*
create_win_filesel ()
{
  GtkWidget *win_filesel;
  GtkWidget *ok_button1;
  GtkWidget *cancel_button1;
  GtkAccelGroup *accel_group;

  win_filesel = gtk_file_selection_new ("File select");
  gtk_object_set_data (GTK_OBJECT (win_filesel), "win_filesel", win_filesel);
  gtk_container_border_width (GTK_CONTAINER (win_filesel), 10);

  ok_button1 = GTK_FILE_SELECTION (win_filesel)->ok_button;
  gtk_object_set_data (GTK_OBJECT (win_filesel), "ok_button1", ok_button1);
  gtk_widget_show (ok_button1);
  GTK_WIDGET_SET_FLAGS (ok_button1, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (ok_button1), "clicked",
                      GTK_SIGNAL_FUNC (on_ok_button1_clicked),
                      win_filesel);
  accel_group = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (win_filesel), accel_group);
  gtk_widget_add_accelerator (ok_button1, "clicked", accel_group,
                              GDK_Return, 0, GTK_ACCEL_VISIBLE);

  cancel_button1 = GTK_FILE_SELECTION (win_filesel)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (win_filesel), "cancel_button1", cancel_button1);
  gtk_widget_show (cancel_button1);
  GTK_WIDGET_SET_FLAGS (cancel_button1, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (cancel_button1), "clicked",
                      GTK_SIGNAL_FUNC (on_cancel_button1_clicked),
                      NULL);
  gtk_widget_add_accelerator (cancel_button1, "clicked", accel_group,
                              GDK_Escape, 0, GTK_ACCEL_VISIBLE);

  return win_filesel;
}

GtkWidget*
create_win_msg (char *title,char *msg)
{
  GtkWidget *win_msg;
  GtkWidget *vbox6;
  GtkWidget *lbl_msg;
  GtkWidget *hbuttonbox7;
  GtkWidget *btn_msgok;

  win_msg = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (win_msg), "win_msg", win_msg);
  gtk_window_set_title (GTK_WINDOW (win_msg), title);
  gtk_window_set_policy (GTK_WINDOW (win_msg), TRUE, TRUE, FALSE);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_msg), "vbox6", vbox6);
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (win_msg), vbox6);

  lbl_msg = gtk_label_new (msg);
  gtk_object_set_data (GTK_OBJECT (win_msg), "lbl_msg", lbl_msg);
  gtk_widget_show (lbl_msg);
  gtk_box_pack_start (GTK_BOX (vbox6), lbl_msg, TRUE, TRUE, 0);

  hbuttonbox7 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_msg), "hbuttonbox7", hbuttonbox7);
  gtk_widget_show (hbuttonbox7);
  gtk_box_pack_start (GTK_BOX (vbox6), hbuttonbox7, FALSE, TRUE, 3);

  btn_msgok = gtk_button_new_with_label ("Dismiss");
  gtk_object_set_data (GTK_OBJECT (win_msg), "btn_msgok", btn_msgok);
  gtk_widget_show (btn_msgok);
  gtk_container_add (GTK_CONTAINER (hbuttonbox7), btn_msgok);
  gtk_signal_connect (GTK_OBJECT (btn_msgok), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_msgok_clicked),
                      NULL);

  return win_msg;
}



GtkWidget*
create_win_cal ()
{
  GtkWidget *win_cal;
  GtkWidget *vbox7;
  GtkWidget *cal_selday;
  GtkWidget *hbuttonbox8;
  GtkWidget *btn_okcal;
  GtkWidget *btn_cancelcal;
  GtkAccelGroup *accel_group;

  win_cal = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (win_cal), "win_cal", win_cal);
  gtk_window_set_title (GTK_WINDOW (win_cal), "Calendar");
  gtk_window_set_policy (GTK_WINDOW (win_cal), TRUE, TRUE, FALSE);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_cal), "vbox7", vbox7);
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (win_cal), vbox7);

  cal_selday = gtk_calendar_new ();
  gtk_object_set_data (GTK_OBJECT (win_cal), "cal_selday", cal_selday);
  gtk_widget_show (cal_selday);
  gtk_box_pack_start (GTK_BOX (vbox7), cal_selday, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cal_selday), "day_selected",
                      GTK_SIGNAL_FUNC (on_cal_selday_day_selected),
                      NULL);
  gtk_calendar_display_options (GTK_CALENDAR (cal_selday),GTK_CALENDAR_SHOW_HEADING | GTK_CALENDAR_SHOW_DAY_NAMES);
  hbuttonbox8 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_cal), "hbuttonbox8", hbuttonbox8);
  gtk_widget_show (hbuttonbox8);
  gtk_box_pack_start (GTK_BOX (vbox7), hbuttonbox8, FALSE, TRUE, 4);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox8), GTK_BUTTONBOX_SPREAD);

  btn_okcal = gtk_button_new_with_label ("Accept");
  gtk_object_set_data (GTK_OBJECT (win_cal), "btn_okcal", btn_okcal);
  gtk_widget_show (btn_okcal);
  gtk_container_add (GTK_CONTAINER (hbuttonbox8), btn_okcal);
  gtk_signal_connect (GTK_OBJECT (btn_okcal), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_okcal_clicked),
                      NULL);
  accel_group = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (win_cal), accel_group);
  gtk_widget_add_accelerator (btn_okcal, "clicked", accel_group,
                              GDK_Return, 0, GTK_ACCEL_VISIBLE);

  btn_cancelcal = gtk_button_new_with_label ("Cancel");
  gtk_object_set_data (GTK_OBJECT (win_cal), "btn_cancelcal", btn_cancelcal);
  gtk_widget_show (btn_cancelcal);
  gtk_container_add (GTK_CONTAINER (hbuttonbox8), btn_cancelcal);
  gtk_signal_connect (GTK_OBJECT (btn_cancelcal), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_cancelcal_clicked),
                      NULL);
  gtk_widget_add_accelerator (btn_cancelcal, "clicked", accel_group,
                              GDK_Escape, 0, GTK_ACCEL_VISIBLE);

  return win_cal;
}

