#ifndef BANK_H
#define BANK_H

/**
 * Logiciel Gassst (Global Alignment Short Sequence Search Tool)
 * \file Bank.h
 * \brief Classe Bank, responsable de la rcupration des donnes dans les banques de squences
 * \author Dominique Lavenier
 * \author Damien Fleury
 * \version 5.2
 * \date 28/08/2008
 */

#include <iostream>

/// Nombre maximal de partitions
#define MAX_PART 1024
/// Taille d'une ligne d'un fichier au format fasta
#define SIZE_LINE 1024
/// TAille du nom des banques de squences
#define TAILLE_NOM 1024

/**
 * \class Bank, Une banque de squences d'ADN
 * \brief Cette classe dfinit une banque de squences d'ADN, ainsi que les mthodes permettant d'en rcuprer les informations
 */
class Bank{

	public:
	/**
	 * Nom de la banque
	 */
	char fileBank[TAILLE_NOM];
	/**
	 * Nombre de squences total
	 */
	int  nb_tot_seq;
	/**
	 * Nombre de rsidus total
	 */
	long long  int  nb_tot_res;
	/**
	 * Nombre de partitions
	 */
	int  nb_part;
	/**
	 * Numro de la partition en cours de traitement
	 */
	int  num_part;
	/**
	 * Numro de la partition suivante
	 */
	int  next_part;
	/**
	 * Adresses de dpart des partitions dans le fichier
	 */
	long* start_offset;
	/**
	 * Adresses de fin des partitions dans le fichier
	 */
	long* stop_offset;
	/**
	 * Nombre de squences dans chaque partition
	 */
	int* nb_seq;
	/**
	 * Image mmoire de la partie de banque en cours de traitement
	 */
	char* data;
	/**
	 * Tableau des index des sequences , en int donc taille max partition = 2G
	 */
	int* seq;
	/**
	 * Tableau des index des commentaires
	 */
	int* com;
	/**
	 * Tableau des tailles des squences
	 */
	long long* size;
	
	/**
	 * Tableau des positions globales deu dbut des squences
	 */
	long long* pos_seq;
	/**
	 * Longueur maximale des squences de la partition indexe de la banque
	 */
	int tailleMaxSeq;

	int tSeq;


	/**
	 * Constructeur de banque de squences
	 * \param fname, un pointeur de caractres contenant le nom de la banque de squences
	 * \param size_max, la taille maximale de la banque de squences
	 * \param FILE, fichier de sortie, pour mettre header avec noms des contig
	 * \param bankref indique qu on lit la banque de reference
	 */
	Bank(char *fname,long long size_max, FILE *ff, char bankref);
	
	/**
	 * Constructeur de banque par recopie
	 * \param bk, une banque de squences
	 */
	Bank(const Bank& bk);
	
	/**
	 * Oprateur d'affectation
	 * \param bk une banque de squences
	 * \return l'objet Bank affect
	 */
	Bank& operator=(const Bank& bk);
	
	/**
	 * Destructeur de Bank
	 */
	~Bank();
	
	/**
	* Mthode d'affichage d'une banque de squences
	*/
	void writeInfoBank();
	
	/**
	* Mthode de rinitialisation des partitions d'une banque de squences
	*/
	void resetBank();
	
	/**
	 * Mthode permettant d'indexer une partition de la banque
	 * \param lx, un boolen qui indique si on utilise le filtre Low Complexity
	 * \return 1 si une partition a t indexe, 0 si toutes les partitions sont dj t indexes
	 */
	int readBank(bool lx);
	/**
	 * Mthode permettant de faire le "reverse complement" des squences de la partition courante
	 * de la banque
	 * Toutes les squences de la partition courante de la banque seront inverses et leurs bases
	 * seront remplaces par les bases complmentaires
	 */
	void reverseComplement();
};

#endif
