#############################################################################
##
#W  conwdat3.g                  GAP library                     Thomas Breuer
#W                                                              Frank Lübeck
##
#H  @(#)$Id: conwdat3.g,v 4.1.2.2 2005/07/21 08:11:11 gap Exp $
##
#Y  Copyright (C) 2005 The GAP Group
##
##  This file contains the data for precomputed Conway polynomials for
##  primes
##                     1000 < p < 110000
##  (File is only read by 'ConwayPolynomial' if needed.)     
Revision.conwdat3_g :=
    "@(#)$Id: conwdat3.g,v 4.1.2.2 2005/07/21 08:11:11 gap Exp $";

CONWAYPOLDATA[1009]:=[
,,,[15085570,"RPn"],,[873681994957,"JB"],,,[2700584453,"RPn"],];
CONWAYPOLDATA[1013]:=[
,,,[2789805,"RPn"],,[2123953631491,"JB"],,,[9762403570,"RPn"],];
CONWAYPOLDATA[1019]:=[
,,,[9289206,"RPn"],,[2132424228782,"JB"],,,[1008808979,"RPn"],];
CONWAYPOLDATA[1021]:=[
,,,[4082989,"RPn"],,[728072947742,"JB"],,,[2541070916,"RPn"],];
CONWAYPOLDATA[1031]:=[
,,,[4079681,"RPn"],,[5310099608804,"JB"],,,[6354544773,"RPn"],];
CONWAYPOLDATA[1033]:=[
,,,[18091967,"RPn"],,[769030978346,"JB"],,,[12602664041,"RPn"],];
CONWAYPOLDATA[1039]:=[
,,,[8387850,"RPn"],,[1150146153282,"JB"],,,[6612084824,"RPn"],];
CONWAYPOLDATA[1049]:=[
,,,[5376128,"RPn"],,[4023561882637,"JB"],,,[6236319683,"RPn"],];
CONWAYPOLDATA[1051]:=[
,,,[7672307,"RPn"],,[790129179599,"JB"],,,[15964468232,"RPn"],];
CONWAYPOLDATA[1061]:=[
,,,[7442917,"RPn"],,[2312960502005,"JB"],,,[12154601676,"RPn"],];
CONWAYPOLDATA[1063]:=[
,,,[2927505,"RPn"],,[581195438154,"JB"],,,[4710167879,"RPn"],];
CONWAYPOLDATA[1069]:=[
,,,[7995057,"RPn"],,[838182584730,"JB"],,,[5910844143,"RPn"],];
CONWAYPOLDATA[1087]:=[
,,,[12988566,"RPn"],,[5804247075817,"JB"],,,[7533748074,"RPn"],];
CONWAYPOLDATA[1091]:=[
,,,[3413741,"RPn"],,[3838737265573,"JB"],,,[934330216,"RPn"],];
CONWAYPOLDATA[1093]:=[
,,,[8247783,"RPn"],,[940283357783,"JB"],,,[51928503226,"RPn"],];
CONWAYPOLDATA[1097]:=[
,,,[5896378,"RPn"],,[1569097397874,"JB"],,,[21144672,"RPn"],];
CONWAYPOLDATA[1103]:=[
,,,[3336580,"RPn"],,[2549438994451,"JB"],,,[3229751651,"RPn"],];
CONWAYPOLDATA[1109]:=[
,,,[11061168,"RPn"],,[2883269157964,"JB"],,,[5383948800,"RPn"],];
CONWAYPOLDATA[1117]:=[
,,,[8442288,"RPn"],,[1389359108600,"JB"],,,[3804220514,"RPn"],];
CONWAYPOLDATA[1123]:=[
,,,[11342302,"RPn"],,[1300351974959,"JB"],,,[2075640898,"RPn"],];
CONWAYPOLDATA[1129]:=[
,,,[21428431,"RPn"],,[4864233137144,"JB"],,,[21000710758,"RPn"],];
CONWAYPOLDATA[1151]:=[
,,,[6089958,"RPn"],,[2661295257633,"JB"],,,[2788290577,"RPn"],];
CONWAYPOLDATA[1153]:=[
,,,[39555976,"RPn"],,[390534591258,"JB"],,,[5916416567,"RPn"],];
CONWAYPOLDATA[1163]:=[
,,,[5405629,"RPn"],,[4015073741353,"JB"],,,[3526425335,"RPn"],];
CONWAYPOLDATA[1171]:=[
,,,[12272082,"RPn"],,[1673979331397,"JB"],,,[796599681,"RPn"],];
CONWAYPOLDATA[1181]:=[
,,,[5018076,"RPn"],,[5521385646710,"JB"],,,[9988626363,"RPn"],];
CONWAYPOLDATA[1187]:=[
,,,[6535624,"RPn"],,[5446150254926,"JB"],,,[6990726107,"RPn"],];
CONWAYPOLDATA[1193]:=[
,,,[16641160,"RPn"],,[5953640035684,"JB"],,,[6780373742,"RPn"],];
CONWAYPOLDATA[1201]:=[
,,,[30056237,"RPn"],,[1589159272741,"JB"],,,[1572908855,"RPn"],];
CONWAYPOLDATA[1213]:=[
,,,[14308550,"RPn"],,[1085324531439,"JB"],,,[10576148211,"RPn"],];
CONWAYPOLDATA[1217]:=[
,,,[14410500,"RPn"],,[4936364312955,"JB"],,,[1777482045,"RPn"],];
CONWAYPOLDATA[1223]:=[
,,,[6857366,"RPn"],,[6378763106287,"JB"],,,[7548275277,"RPn"],];
CONWAYPOLDATA[1229]:=[
,,,[10487059,"RPn"],,[4540573432286,"JB"],,,[1485935967,"RPn"],];
CONWAYPOLDATA[1231]:=[
,,,[5361008,"RPn"],,[2149557677896,"JB"],,,[46468650928,"RPn"],];
CONWAYPOLDATA[1237]:=[
,,,[10368536,"RPn"],,[1607182833774,"JB"],,,[20707835214,"RPn"],];
CONWAYPOLDATA[1249]:=[
,,,[27509232,"RPn"],,[924620941023,"JB"],,,[1792742151,"RPn"],];
CONWAYPOLDATA[1259]:=[
,,,[10831179,"RPn"],,[4890860854633,"JB"],,,[5250877305,"RPn"],];
CONWAYPOLDATA[1277]:=[
,,,[7484499,"RPn"],,[7393409563076,"JB"],,,[699575077,"RPn"],];
CONWAYPOLDATA[1279]:=[
,,,[10986613,"RPn"],,[334133089149,"JB"],,,[1829301258,"RPn"],];
CONWAYPOLDATA[1283]:=[
,,,[14030890,"RPn"],,[4488738696319,"JB"],,,[3998320670,"RPn"],];
CONWAYPOLDATA[1289]:=[
,,,[6408914,"RPn"],,[5153443722234,"JB"],,,[7520276060,"RPn"],];
CONWAYPOLDATA[1291]:=[
,,,[11160697,"RPn"],,[2248299571463,"JB"],,,[9684201536,"RPn"],];
CONWAYPOLDATA[1297]:=[
,,,[14504361,"RPn"],,[1739635257350,"JB"],,,[14930525735,"RPn"],];
CONWAYPOLDATA[1301]:=[
,,,[6576557,"RPn"],,[5217788081266,"JB"],,,[23897824410,"RPn"],];
CONWAYPOLDATA[1303]:=[
,,,[4458872,"RPn"],,[2718808238740,"JB"],,,[1468996982,"RPn"],];
CONWAYPOLDATA[1307]:=[
,,,[7936106,"RPn"],,[9045938710762,"JB"],,,[1270482418,"RPn"],];
CONWAYPOLDATA[1319]:=[
,,,[10037603,"RPn"],,[5224588291046,"JB"],,,[2107390029,"RPn"],];
CONWAYPOLDATA[1321]:=[
,,,[15575924,"RPn"],,[2433765958931,"JB"],,,[18165625807,"RPn"],];
CONWAYPOLDATA[1327]:=[
,,,[4482609,"RPn"],,[2824402450641,"JB"],,,[29107926796,"RPn"],];
CONWAYPOLDATA[1361]:=[
,,,[1835992,"RPn"],,[5510214291369,"JB"],,,[7626230119,"RPn"],];
CONWAYPOLDATA[1367]:=[
,,,[16346591,"RPn"],,[8280089594770,"JB"],,,[9999912570,"RPn"],];
CONWAYPOLDATA[1373]:=[
,,,[22478758,"RPn"],,[9370651747706,"JB"],,,[10030915572,"RPn"],];
CONWAYPOLDATA[1381]:=[
,,,[20876579,"RPn"],,[4082359251490,"JB"],,,[41357786127,"RPn"],];
CONWAYPOLDATA[1399]:=[
,,,[28749463,"RPn"],,[3188221465360,"JB"],,,[23267362163,"RPn"],];
CONWAYPOLDATA[1409]:=[
,,,[5334477,"RPn"],,[5689144540829,"JB"],,,[4341888448,"RPn"],];
CONWAYPOLDATA[1423]:=[
,,,[10118956,"RPn"],,[12112943274880,"JB"],,,[62192684587,"RPn"],];
CONWAYPOLDATA[1427]:=[
,,,[28026282,"RPn"],,[21462189934655,"JB"],,,[4428487583,"RPn"],];
CONWAYPOLDATA[1429]:=[
,,,[14288577,"RPn"],,[7748957304286,"JB"],,,[5397785987,"RPn"],];
CONWAYPOLDATA[1433]:=[
,,,[7425809,"RPn"],,[8400246574636,"JB"],,,[936797953,"RPn"],];
CONWAYPOLDATA[1439]:=[
,,,[10340661,"RPn"],,[8063317021276,"JB"],,,[2315716499,"RPn"],];
CONWAYPOLDATA[1447]:=[
,,,[11784371,"RPn"],,[1302859796552,"JB"],,,[33020454624,"RPn"],];
CONWAYPOLDATA[1451]:=[
,,,[7417514,"RPn"],,[28475505898975,"JB"],,,[6516239309,"RPn"],];
CONWAYPOLDATA[1453]:=[
,,,[20988587,"RPn"],,[4447964773663,"JB"],,,[21321134561,"RPn"],];
CONWAYPOLDATA[1459]:=[
,,,[16148215,"RPn"],,[1956301004977,"JB"],,,[8585078436,"RPn"],];
CONWAYPOLDATA[1471]:=[
,,,[6220865,"RPn"],,[3085913880201,"JB"],,,[109520489500,"RPn"],];
CONWAYPOLDATA[1481]:=[
,,,[10805379,"RPn"],,[9477365244556,"JB"],,,[14422783661,"RPn"],];
CONWAYPOLDATA[1483]:=[
,,,[32525158,"RPn"],,[3811676539765,"JB"],,,[26052733002,"RPn"],];
CONWAYPOLDATA[1487]:=[
,,,[8838733,"RPn"],,[8816938801643,"JB"],,,[32430293778,"RPn"],];
CONWAYPOLDATA[1489]:=[
,,,[21888314,"RPn"],,[839127081654,"JB"],,,[25751952719,"RPn"],];
CONWAYPOLDATA[1493]:=[
,,,[8359309,"RPn"],,[6517278015145,"JB"],,,[3070448557,"RPn"],];
CONWAYPOLDATA[1499]:=[
,,,[17632739,"RPn"],,[7401377636049,"JB"],,,[26628756151,"RPn"],];
CONWAYPOLDATA[1511]:=[
,,,[9014637,"RPn"],,[5581239246728,"JB"],,,[24473384432,"RPn"],];
CONWAYPOLDATA[1523]:=[
,,,[1710331,"RPn"],,[5620424752752,"JB"],,,[4863692883,"RPn"],];
CONWAYPOLDATA[1531]:=[
,,,[6139312,"RPn"],,[20534280982483,"JB"],,,[28402257700,"RPn"],];
CONWAYPOLDATA[1543]:=[
,,,[9517229,"RPn"],,[5113293485157,"JB"],,,[28470397556,"RPn"],];
CONWAYPOLDATA[1549]:=[
,,,[2069466,"RPn"],,[5287477849526,"JB"],,,[36622540749,"RPn"],];
CONWAYPOLDATA[1553]:=[
,,,[11712729,"RPn"],,[15022609617163,"JB"],,,[1552967384,"RPn"],];
CONWAYPOLDATA[1559]:=[
,,,[6586794,"RPn"],,[10595630375861,"JB"],,,[12618924818,"RPn"],];
CONWAYPOLDATA[1567]:=[
,,,[12271180,"RPn"],,[3293192897994,"JB"],,,[22637590281,"RPn"],];
CONWAYPOLDATA[1571]:=[
,,,[6252582,"RPn"],,[12068569765120,"JB"],,,[24747226199,"RPn"],];
CONWAYPOLDATA[1579]:=[
,,,[17244262,"RPn"],,[4902243235822,"JB"],,,[3057766656,"RPn"],];
CONWAYPOLDATA[1583]:=[
,,,[10017229,"RPn"],,[7356739546103,"JB"],,,[7571430424,"RPn"],];
CONWAYPOLDATA[1597]:=[
,,,[4578610,"RPn"],,[3230402503499,"JB"],,,[39731248755,"RPn"],];
CONWAYPOLDATA[1601]:=[
,,,[19482572,"RPn"],,[14357141182887,"JB"],,,[22065828926,"RPn"],];
CONWAYPOLDATA[1607]:=[
,,,[30970109,"RPn"],,[7513877432736,"JB"],,,[7453765772,"RPn"],];
CONWAYPOLDATA[1609]:=[
,,,[14999105,"RPn"],,[3635814909293,"JB"],,,[33244655985,"RPn"],];
CONWAYPOLDATA[1613]:=[
,,,[2063030,"RPn"],,[19970501092050,"JB"],,,[22449248484,"RPn"],];
CONWAYPOLDATA[1619]:=[
,,,[23252080,"RPn"],,[8274011889363,"JB"],,,[38929933252,"RPn"],];
CONWAYPOLDATA[1621]:=[
,,,[17317145,"RPn"],,[5696612029966,"JB"],,,[25514400592,"RPn"],];
CONWAYPOLDATA[1627]:=[
,,,[9854742,"RPn"],,[4613370818020,"JB"],,,[3584861836,"RPn"],];
CONWAYPOLDATA[1637]:=[
,,,[4094139,"RPn"],,[13537123350921,"JB"],,,[24945359018,"RPn"],];
CONWAYPOLDATA[1657]:=[
,,,[37209603,"RPn"],,[19574605984037,"JB"],,,[34473311667,"RPn"],];
CONWAYPOLDATA[1663]:=[
,,,[8082183,"RPn"],,[6768458616145,"JB"],,,[91532968470,"RPn"],];
CONWAYPOLDATA[1667]:=[
,,,[24343203,"RPn"],,[14712497547796,"JB"],,,[6307177848,"RPn"],];
CONWAYPOLDATA[1669]:=[
,,,[18182088,"RPn"],,[6174282580940,"JB"],,,[29815283038,"RPn"],];
CONWAYPOLDATA[1693]:=[
,,,[11204276,"RPn"],,[6305748514448,"JB"],,,[52991622909,"RPn"],];
CONWAYPOLDATA[1697]:=[
,,,[51006732,"RPn"],,[14294700917840,"JB"],,,[15396828390,"RPn"],];
CONWAYPOLDATA[1699]:=[
,,,[11218500,"RPn"],,[2894420970313,"JB"],,,[112220954817,"RPn"],];
CONWAYPOLDATA[1709]:=[
,,,[2049094,"RPn"],,[15820841524060,"JB"],,,[16896462583,"RPn"],];
CONWAYPOLDATA[1721]:=[
,,,[8783987,"RPn"],,[10937936028517,"JB"],,,[35314345183,"RPn"],];
CONWAYPOLDATA[1723]:=[
,,,[7739719,"RPn"],,[24020906781110,"JB"],,,[9607379077,"RPn"],];
CONWAYPOLDATA[1733]:=[
,,,[7864356,"RPn"],,[17545253287177,"JB"],,,[7393938080,"RPn"],];
CONWAYPOLDATA[1741]:=[
,,,[29851188,"RPn"],,[8675511147440,"JB"],,,[23739722360,"RPn"],];
CONWAYPOLDATA[1747]:=[
,,,[26907296,"RPn"],,[12221058113544,"JB"],,,[14722299181,"RPn"],];
CONWAYPOLDATA[1753]:=[
,,,[44689236,"RPn"],,[8268857792063,"JB"],,,[138351060102,"RPn"],];
CONWAYPOLDATA[1759]:=[
,,,[14388626,"RPn"],,[7254119150375,"JB"],,,[5322193981,"RPn"],];
CONWAYPOLDATA[1777]:=[
,,,[59014175,"RPn"],,[9788581104023,"JB"],,,[66035729607,"RPn"],];
CONWAYPOLDATA[1783]:=[
,,,[18355995,"RPn"],,[16921956015505,"JB"],,,[101614863840,"RPn"],];
CONWAYPOLDATA[1787]:=[
,,,[24294267,"RPn"],,[14733446172137,"JB"],,,[10870079753,"RPn"],];
CONWAYPOLDATA[1789]:=[
,,,[2860617,"RPn"],,[3941773216968,"JB"],,,[65332616224,"RPn"],];
CONWAYPOLDATA[1801]:=[
,,,[81055817,"RPn"],,[10464595832142,"JB"],,,[57195835610,"RPn"],];
CONWAYPOLDATA[1811]:=[
,,,[38605093,"RPn"],,[12922546247817,"JB"],,,[28906171456,"RPn"],];
CONWAYPOLDATA[1823]:=[
,,,[9516065,"RPn"],,[19783266756104,"JB"],,,[9417262510,"RPn"],];
CONWAYPOLDATA[1831]:=[
,,,[16755484,"RPn"],,[10307235208353,"JB"],,,[8882992130,"RPn"],];
CONWAYPOLDATA[1847]:=[
,,,[19181100,"RPn"],,[19357908884422,"JB"],,,[2781862739,"RPn"],];
CONWAYPOLDATA[1861]:=[
,,,[13443866,"RPn"],,[20711543685272,"JB"],,,[28468619583,"RPn"],];
CONWAYPOLDATA[1867]:=[
,,,[26821324,"RPn"],,[6019182481846,"JB"],,,[25890708380,"RPn"],];
CONWAYPOLDATA[1871]:=[
,,,[37786730,"RPn"],,[18170944296562,"JB"],,,[31896430044,"RPn"],];
CONWAYPOLDATA[1873]:=[
,,,[48969595,"RPn"],,[3200109583636,"JB"],,,[69414964548,"RPn"],];
CONWAYPOLDATA[1877]:=[
,,,[23633309,"RPn"],,[24264055303806,"JB"],,,[26324446363,"RPn"],];
CONWAYPOLDATA[1879]:=[
,,,[13767439,"RPn"],,[11818360296677,"JB"],,,[171396566368,"RPn"],];
CONWAYPOLDATA[1889]:=[
,,,[3545656,"RPn"],,[12909469698240,"JB"],,,[43983103864,"RPn"],];
CONWAYPOLDATA[1901]:=[
,,,[31187808,"RPn"],,[19606255398552,"JB"],,,[13212356812,"RPn"],];
CONWAYPOLDATA[1907]:=[
,,,[10705900,"RPn"],,[59969115338549,"JB"],,,[2082304787,"RPn"],];
CONWAYPOLDATA[1913]:=[
,,,[10791236,"RPn"],,[22258902964521,"JB"],,,[31844779366,"RPn"],];
CONWAYPOLDATA[1931]:=[
,,,[28493838,"RPn"],,[19154512539372,"JB"],,,[34261671206,"RPn"],];
CONWAYPOLDATA[1933]:=[
,,,[24630291,"RPn"],,[48748668114582,"JB"],,,[5232663856,"RPn"],];
CONWAYPOLDATA[1949]:=[
,,,[13391581,"RPn"],,[28096562104403,"JB"],,,[19426047461,"RPn"],];
CONWAYPOLDATA[1951]:=[
,,,[13436540,"RPn"],,[11458760285893,"JB"],,,[32379432023,"RPn"],];
CONWAYPOLDATA[1973]:=[
,,,[18540283,"RPn"],,[61272577158633,"JB"],,,[5599360187,"RPn"],];
CONWAYPOLDATA[1979]:=[
,,,[54373027,"RPn"],,[30419726328413,"JB"],,,[26475966401,"RPn"],];
CONWAYPOLDATA[1987]:=[
,,,[31068734,"RPn"],,[7696778747683,"JB"],,,[23126581726,"RPn"],];
CONWAYPOLDATA[1993]:=[
,,,[73645341,"RPn"],,[13853815536319,"JB"],,,[323291238433,"RPn"],];
CONWAYPOLDATA[1997]:=[
,,,[39558575,"RPn"],,[29635547256965,"JB"],,,[30721794079,"RPn"],];
CONWAYPOLDATA[1999]:=[
,,,[14340829,"RPn"],,[8900331332141,"JB"],,,[63102155136,"RPn"],];
CONWAYPOLDATA[2003]:=[
,,,[54826121,"RPn"],,[48119302449408,"JB"],,,[25527471852,"RPn"],];
CONWAYPOLDATA[2011]:=[
,,,[24136025,"RPn"],,[10034328675606,"JB"],,,[232442426420,"RPn"],];
CONWAYPOLDATA[2017]:=[
,,,[27219420,"RPn"],,[15123703527976,"JB"],,,[78461043836,"RPn"],];
CONWAYPOLDATA[2027]:=[
,,,[3849275,"RPn"],,[33595082385949,"JB"],,,[50331867411,"RPn"],];
CONWAYPOLDATA[2029]:=[
,,,[32192116,"RPn"],,[12470154925814,"JB"],,,[174186247365,"RPn"],];
CONWAYPOLDATA[2039]:=[
,,,[61013004,"RPn"],,[50997047992467,"JB"],,,[6891100226,"RPn"],];
CONWAYPOLDATA[2053]:=[
,,,[45391832,"RPn"],,[17738584221463,"JB"],,,[12183739957,"RPn"],];
CONWAYPOLDATA[2063]:=[
,,,[37400132,"RPn"],,[23455592329754,"JB"],,,[64992700420,"RPn"],];
CONWAYPOLDATA[2069]:=[
,,,[28608065,"RPn"],,[85394275425240,"JB"],,,[7550964466,"RPn"],];
CONWAYPOLDATA[2081]:=[
,,,[34051406,"RPn"],,[34668567735876,"JB"],,,[51184246863,"RPn"],];
CONWAYPOLDATA[2083]:=[
,,,[38720889,"RPn"],,[7148855039739,"JB"],,,[79950476708,"RPn"],];
CONWAYPOLDATA[2087]:=[
,,,[28856954,"RPn"],,[23671048603012,"JB"],,,[17504789714,"RPn"],];
CONWAYPOLDATA[2089]:=[
,,,[12874514,"RPn"],,[15839159860765,"JB"],,,[27197148484,"RPn"],];
CONWAYPOLDATA[2099]:=[
,,,[34677581,"RPn"],,[49964103245059,"JB"],,,[53109095304,"RPn"],];
CONWAYPOLDATA[2111]:=[
,,,[12957325,"RPn"],,[133005090321863,"JB"],,,[2745066286,"RPn"],];
CONWAYPOLDATA[2113]:=[
,,,[83066261,"RPn"],,[17488670797755,"JB"],,,[16223964753,"RPn"],];
CONWAYPOLDATA[2129]:=[
,,,[30755537,"RPn"],,[73654810366409,"JB"],,,[58423008851,"RPn"],];
CONWAYPOLDATA[2131]:=[
,,,[13453005,"RPn"],,[9685014720921,"JB"],,,[57946134950,"RPn"],];
CONWAYPOLDATA[2137]:=[
,,,[29864585,"RPn"],,[7163627730598,"JB"],,,[273017215459,"RPn"],];
CONWAYPOLDATA[2141]:=[
,,,[16222359,"RPn"],,[38013913841994,"JB"],,,[1276095946,"RPn"],];
CONWAYPOLDATA[2143]:=[
,,,[17287584,"RPn"],,[15910683645108,"JB"],,,[68646590417,"RPn"],];
CONWAYPOLDATA[2153]:=[
,,,[13415346,"RPn"],,[39789728804784,"JB"],,,[19380027115,"RPn"],];
CONWAYPOLDATA[2161]:=[
,,,[73422159,"RPn"],,[40966042897282,"JB"],,,[65066960110,"RPn"],];
CONWAYPOLDATA[2179]:=[
,,,[32883296,"RPn"],,[21094714231702,"JB"],,,[35700304551,"RPn"],];
CONWAYPOLDATA[2203]:=[
,,,[37497268,"RPn"],,[7941564717175,"JB"],,,[95376545409,"RPn"],];
CONWAYPOLDATA[2207]:=[
,,,[41604162,"RPn"],,[29190369423953,"JB"],,,[7649733456,"RPn"],];
CONWAYPOLDATA[2213]:=[
,,,[34073563,"RPn"],,[39705079533966,"JB"],,,[31553750678,"RPn"],];
CONWAYPOLDATA[2221]:=[
,,,[32444370,"RPn"],,[24299968926751,"JB"],,,[64706578462,"RPn"],];
CONWAYPOLDATA[2237]:=[
,,,[43136073,"RPn"],,[34434552030856,"JB"],,,[59962317465,"RPn"],];
CONWAYPOLDATA[2239]:=[
,,,[59946989,"RPn"],,[12618661486739,"JB"],,,[355948752932,"RPn"],];
CONWAYPOLDATA[2243]:=[
,,,[8514430,"RPn"],,[73000822624156,"JB"],,,[6738723403,"RPn"],];
CONWAYPOLDATA[2251]:=[
,,,[34543853,"RPn"],,[23583826552733,"JB"],,,[28535560080,"RPn"],];
CONWAYPOLDATA[2267]:=[
,,,[55675255,"RPn"],,[117883349232715,"JB"],,,[21240545415,"RPn"],];
CONWAYPOLDATA[2269]:=[
,,,[55134433,"RPn"],,[26404954884018,"JB"],,,[116219493749,"RPn"],];
CONWAYPOLDATA[2273]:=[
,,,[14681310,"RPn"],,[52769530879373,"JB"],,,[21284956158,"RPn"],];
CONWAYPOLDATA[2281]:=[
,,,[3334829,"RPn"],,[14721189149687,"JB"],,,[127257348110,"RPn"],];
CONWAYPOLDATA[2287]:=[
,,,[36322153,"RPn"],,[21678174937596,"JB"],,,[20697455183,"RPn"],];
CONWAYPOLDATA[2293]:=[
,,,[55458500,"RPn"],,[23336280263587,"JB"],,,[94414809267,"RPn"],];
CONWAYPOLDATA[2297]:=[
,,,[46279961,"RPn"],,[53864312559220,"JB"],,,[11262218559,"RPn"],];
CONWAYPOLDATA[2309]:=[
,,,[10348940,"RPn"],,[51950718814312,"JB"],,,[81548541590,"RPn"],];
CONWAYPOLDATA[2311]:=[
,,,[21048591,"RPn"],,[90809867896929,"JB"],,,[21935057554,"RPn"],];
CONWAYPOLDATA[2333]:=[
,,,[41812028,"RPn"],,[53744427190374,"JB"],,,[1114765723,"RPn"],];
CONWAYPOLDATA[2339]:=[
,,,[4135354,"RPn"],,[88568649664313,"JB"],,,[9433975241,"RPn"],];
CONWAYPOLDATA[2341]:=[
,,,[53814915,"RPn"],,[15653669419960,"JB"],,,[434663777416,"RPn"],];
CONWAYPOLDATA[2347]:=[
,,,[19468368,"RPn"],,[30214264426930,"JB"],,,[77185573073,"RPn"],];
CONWAYPOLDATA[2351]:=[
,,,[37446741,"RPn"],,[46759757482070,"JB"],,,[48521186368,"RPn"],];
CONWAYPOLDATA[2357]:=[
,,,[49487574,"RPn"],,[54209594233348,"JB"],,,[10733035543,"RPn"],];
CONWAYPOLDATA[2371]:=[
,,,[44299766,"RPn"],,[80122164931153,"JB"],,,[314758797453,"RPn"],];
CONWAYPOLDATA[2377]:=[
,,,[37903647,"RPn"],,[13095067388610,"JB"],,,[388360311837,"RPn"],];
CONWAYPOLDATA[2381]:=[
,,,[73465758,"RPn"],,[37980644228648,"JB"],,,[54418062146,"RPn"],];
CONWAYPOLDATA[2383]:=[
,,,[50574414,"RPn"],,[101788531647683,"JB"],,,[161238829572,"RPn"],];
CONWAYPOLDATA[2389]:=[
,,,[61017451,"RPn"],,[26753771464702,"JB"],,,[64381624464,"RPn"],];
CONWAYPOLDATA[2393]:=[
,,,[44983617,"RPn"],,[87967008104233,"JB"],,,[18039939194,"RPn"],];
CONWAYPOLDATA[2399]:=[
,,,[21192777,"RPn"],,[91621957129720,"JB"],,,[69209221193,"RPn"],];
CONWAYPOLDATA[2411]:=[
,,,[27304581,"RPn"],,[62051777536539,"JB"],,,[23724493149,"RPn"],];
CONWAYPOLDATA[2417]:=[
,,,[87466399,"RPn"],,[46748525380786,"JB"],,,[7432678636,"RPn"],];
CONWAYPOLDATA[2423]:=[
,,,[61977922,"RPn"],,[63639877550293,"JB"],,,[76503700229,"RPn"],];
CONWAYPOLDATA[2437]:=[
,,,[39513520,"RPn"],,[35227831988887,"JB"],,,[85878576203,"RPn"],];
CONWAYPOLDATA[2441]:=[
,,,[5072404,"RPn"],,[53986410061315,"JB"],,,[4692431934,"RPn"],];
CONWAYPOLDATA[2447]:=[
,,,[15465045,"RPn"],,[66974838899708,"JB"],,,[64958859717,"RPn"],];
CONWAYPOLDATA[2459]:=[
,,,[46598052,"RPn"],,[68363009633730,"JB"],,,[109215435005,"RPn"],];
CONWAYPOLDATA[2467]:=[
,,,[45752984,"RPn"],,[22636036035345,"JB"],,,[144524423820,"RPn"],];
CONWAYPOLDATA[2473]:=[
,,,[70685764,"RPn"],,[69724683961608,"JB"],,,[66627588252,"RPn"],];
CONWAYPOLDATA[2477]:=[
,,,[23249124,"RPn"],,[89872271847638,"JB"],,,[143553526859,"RPn"],];
CONWAYPOLDATA[2503]:=[
,,,[18054142,"RPn"],,[20109544152450,"JB"],,,[116991468994,"RPn"],];
CONWAYPOLDATA[2521]:=[
,,,[151199513,"RPn"],,[71574761155340,"JB"],,,[207863128112,"RPn"],];
CONWAYPOLDATA[2531]:=[
,,,[54727815,"RPn"],,[120110695208635,"JB"],,,[8852220587,"RPn"],];
CONWAYPOLDATA[2539]:=[
,,,[18146235,"RPn"],,[21814122679819,"JB"],,,[129357979981,"RPn"],];
CONWAYPOLDATA[2543]:=[
,,,[25857229,"RPn"],,[110520960734397,"JB"],,,[6626666373,"RPn"],];
CONWAYPOLDATA[2549]:=[
,,,[83683672,"RPn"],,[65264910911109,"JB"],,,[17633980,"RPn"],];
CONWAYPOLDATA[2551]:=[
,,,[24642666,"RPn"],,[31352837654890,"JB"],,,[82590903037,"RPn"],];
CONWAYPOLDATA[2557]:=[
,,,[45478804,"RPn"],,[42698433897007,"JB"],,,[108011369749,"RPn"],];
CONWAYPOLDATA[2579]:=[
,,,[11690609,"RPn"],,[73557557634012,"JB"],,,[125839395886,"RPn"],];
CONWAYPOLDATA[2591]:=[
,,,[39160381,"RPn"],,[73998628473784,"JB"],,,[19481407709,"RPn"],];
CONWAYPOLDATA[2593]:=[
,,,[99903111,"RPn"],,[24277243264861,"JB"],,,[201582685258,"RPn"],];
CONWAYPOLDATA[2609]:=[
,,,[6775576,"RPn"],,[65973457717710,"JB"],,,[69936585270,"RPn"],];
CONWAYPOLDATA[2617]:=[
,,,[74369911,"RPn"],,[27151581285030,"JB"],,,[302981808921,"RPn"],];
CONWAYPOLDATA[2621]:=[
,,,[66856470,"RPn"],,[90226651010532,"JB"],,,[30772739017,"RPn"],];
CONWAYPOLDATA[2633]:=[
,,,[66061973,"RPn"],,[72378405223619,"JB"],,,[774383728,"RPn"],];
CONWAYPOLDATA[2647]:=[
,,,[39416480,"RPn"],,[20412550804153,"JB"],,,[49257948881,"RPn"],];
CONWAYPOLDATA[2657]:=[
,,,[19194171,"RPn"],,[82165359363966,"JB"],,,[22556564299,"RPn"],];
CONWAYPOLDATA[2659]:=[
,,,[18315194,"RPn"],,[35745622750784,"JB"],,,[200769374444,"RPn"],];
CONWAYPOLDATA[2663]:=[
,,,[27301081,"RPn"],,[84269674035151,"JB"],,,[78015833855,"RPn"],];
CONWAYPOLDATA[2671]:=[
,,,[20214135,"RPn"],,[47118199924578,"JB"],,,[321712369116,"RPn"],];
CONWAYPOLDATA[2677]:=[
,,,[49310342,"RPn"],,[13878198805605,"JB"],,,[225156904515,"RPn"],];
CONWAYPOLDATA[2683]:=[
,,,[61306552,"RPn"],,[36812518918459,"JB"],,,[161685959007,"RPn"],];
CONWAYPOLDATA[2687]:=[
,,,[18653159,"RPn"],,[79104155649038,"JB"],,,[74706972687,"RPn"],];
CONWAYPOLDATA[2689]:=[
,,,[178052154,"RPn"],,[46545732596235,"JB"],];
CONWAYPOLDATA[2693]:=[
,,,[6142735,"RPn"],,[104350926311405,"JB"],,,[71957369334,"RPn"],];
CONWAYPOLDATA[2699]:=[
,,,[33240886,"RPn"],,[99490995299669,"JB"],,,[106560333685,"RPn"],];
CONWAYPOLDATA[2707]:=[
,,,[18878620,"RPn"],,[51470587279714,"JB"],,,[394034360595,"RPn"],];
CONWAYPOLDATA[2711]:=[
,,,[18608311,"RPn"],,[89362369648193,"JB"],,,[18248085290,"RPn"],];
CONWAYPOLDATA[2713]:=[
,,,[51074943,"RPn"],,[38347499879863,"JB"],,,[74998304932,"RPn"],];
CONWAYPOLDATA[2719]:=[
,,,[28922006,"RPn"],,[68509044053987,"JB"],,,[56131389467,"RPn"],];
CONWAYPOLDATA[2729]:=[
,,,[7414696,"RPn"],,[107231364986996,"JB"],,,[10044253695,"RPn"],];
CONWAYPOLDATA[2731]:=[
,,,[21992746,"RPn"],,[10440157895239,"JB"],,,[32585420808,"RPn"],];
CONWAYPOLDATA[2741]:=[
,,,[97028661,"RPn"],,[94682434855317,"JB"],,,[115489740781,"RPn"],];
CONWAYPOLDATA[2749]:=[
,,,[4659561,"RPn"],,[15946172671410,"JB"],,,[227888441075,"RPn"],];
CONWAYPOLDATA[2753]:=[
,,,[73571175,"RPn"],,[207242820237056,"JB"],,,[89435326238,"RPn"],];
CONWAYPOLDATA[2767]:=[
,,,[44983122,"RPn"],,[27766287742805,"JB"],,,[126925449911,"RPn"],];
CONWAYPOLDATA[2777]:=[
,,,[5001380,"RPn"],,[266674269680263,"JB"],,,[61492280114,"RPn"],];
CONWAYPOLDATA[2789]:=[
,,,[30093312,"RPn"],,[102229600175668,"JB"],,,[76560696759,"RPn"],];
CONWAYPOLDATA[2791]:=[
,,,[27982572,"RPn"],,[40796955690995,"JB"],,,[84038863218,"RPn"],];
CONWAYPOLDATA[2797]:=[
,,,[76408448,"RPn"],,[61136821482847,"JB"],];
CONWAYPOLDATA[2801]:=[
,,,[59440024,"RPn"],,[74757886676004,"JB"],,,[58803930703,"RPn"],];
CONWAYPOLDATA[2803]:=[
,,,[132626750,"RPn"],,[30716818043764,"JB"],,,[15156289099,"RPn"],];
CONWAYPOLDATA[2819]:=[
,,,[31313454,"RPn"],,[187088381102215,"JB"],,,[30951782755,"RPn"],];
CONWAYPOLDATA[2833]:=[
,,,[182895652,"RPn"],,[15582743434868,"JB"],];
CONWAYPOLDATA[2837]:=[
,,,[152622091,"RPn"],,[249846186017316,"JB"],,,[156406658346,"RPn"],];
CONWAYPOLDATA[2843]:=[
,,,[71956332,"RPn"],,[102516633619656,"JB"],,,[13496662031,"RPn"],];
CONWAYPOLDATA[2851]:=[
,,,[72649184,"RPn"],,[11796941660859,"JB"],,,[226177194131,"RPn"],];
CONWAYPOLDATA[2857]:=[
,,,[179133911,"RPn"],,[66572039505883,"JB"],,,[41184794932,"RPn"],];
CONWAYPOLDATA[2861]:=[
,,,[13787161,"RPn"],,[124635436669087,"JB"],,,[181212877,"RPn"],];
CONWAYPOLDATA[2879]:=[
,,,[21123230,"RPn"],,[134453614285151,"JB"],,,[17854668382,"RPn"],];
CONWAYPOLDATA[2887]:=[
,,,[79796685,"RPn"],,[28199523784015,"JB"],,,[225850890530,"RPn"],];
CONWAYPOLDATA[2897]:=[
,,,[12911932,"RPn"],,[254728073433595,"JB"],,,[47966692196,"RPn"],];
CONWAYPOLDATA[2903]:=[
,,,[40360414,"RPn"],,[220996639394209,"JB"],,,[29173727525,"RPn"],];
CONWAYPOLDATA[2909]:=[
,,,[16566757,"RPn"],,[88445961527874,"JB"],,,[5769617510,"RPn"],];
CONWAYPOLDATA[2917]:=[
,,,[30952292,"RPn"],,[126548076462131,"JB"],,,[23546764913,"RPn"],];
CONWAYPOLDATA[2927]:=[
,,,[92832737,"RPn"],,[128351683750684,"JB"],,,[129054775556,"RPn"],];
CONWAYPOLDATA[2939]:=[
,,,[117809817,"RPn"],,[145919381522460,"JB"],,,[42144954342,"RPn"],];
CONWAYPOLDATA[2953]:=[
,,,[128310816,"RPn"],,[94119915904106,"JB"],,,[275128000880,"RPn"],];
CONWAYPOLDATA[2957]:=[
,,,[59861510,"RPn"],,[137522459211305,"JB"],,,[126623447542,"RPn"],];
CONWAYPOLDATA[2963]:=[
,,,[74975754,"RPn"],,[116296261925105,"JB"],,,[252748907468,"RPn"],];
CONWAYPOLDATA[2969]:=[
,,,[43282085,"RPn"],,[121935170032103,"JB"],,,[15231890387,"RPn"],];
CONWAYPOLDATA[2971]:=[
,,,[49871216,"RPn"],,[75877505137149,"JB"],,,[416411349140,"RPn"],];
CONWAYPOLDATA[2999]:=[
,,,[116262250,"RPn"],,[596131955429237,"JB"],,,[206530765439,"RPn"],];
CONWAYPOLDATA[3001]:=[
,,,[144018004,"RPn"],,[200287641020254,"JB"],,,[16473896455,"RPn"],];
CONWAYPOLDATA[3011]:=[
,,,[70192434,"RPn"],,[153526347135686,"JB"],,,[46867834916,"RPn"],];
CONWAYPOLDATA[3019]:=[
,,,[81742446,"RPn"],,[57766437106156,"JB"],];
CONWAYPOLDATA[3023]:=[
,,,[36542029,"RPn"],,[122393810687045,"JB"],,,[8873829069,"RPn"],];
CONWAYPOLDATA[3037]:=[
,,,[88722920,"RPn"],,[26008690429649,"JB"],,,[135962511528,"RPn"],];
CONWAYPOLDATA[3041]:=[
,,,[80242870,"RPn"],,[424829766961621,"JB"],,,[11835711883,"RPn"],];
CONWAYPOLDATA[3049]:=[
,,,[259558332,"RPn"],,[68211367596603,"JB"],,,[100071729025,"RPn"],];
CONWAYPOLDATA[3061]:=[
,,,[101055860,"RPn"],,[128440816711922,"JB"],,,[14431528339,"RPn"],];
CONWAYPOLDATA[3067]:=[
,,,[82968486,"RPn"],,[78175568697835,"JB"],,,[360260057644,"RPn"],];
CONWAYPOLDATA[3079]:=[
,,,[36984954,"RPn"],,[55675842243326,"JB"],,,[73160602397,"RPn"],];
CONWAYPOLDATA[3083]:=[
,,,[109452668,"RPn"],,[517976249604348,"JB"],,,[175840831873,"RPn"],];
CONWAYPOLDATA[3089]:=[
,,,[18836725,"RPn"],,[541594514867925,"JB"],,,[54221226264,"RPn"],];
CONWAYPOLDATA[3109]:=[
,,,[67648737,"RPn"],,[61357021957486,"JB"],,,[556916827091,"RPn"],];
CONWAYPOLDATA[3119]:=[
,,,[35584678,"RPn"],,[138928818242821,"JB"],,,[34725576752,"RPn"],];
CONWAYPOLDATA[3121]:=[
,,,[5552266,"RPn"],,[86676602777374,"JB"],,,[353623843853,"RPn"],];
CONWAYPOLDATA[3137]:=[
,,,[18354590,"RPn"],,[192534822380433,"JB"],,,[253883916135,"RPn"],];
CONWAYPOLDATA[3163]:=[
,,,[55320873,"RPn"],,[97995157273266,"JB"],];
CONWAYPOLDATA[3167]:=[
,,,[45661811,"RPn"],,[190209998692429,"JB"],,,[53578441404,"RPn"],];
CONWAYPOLDATA[3169]:=[
,,,[7272862,"RPn"],,[100160233978757,"JB"],,,[302198825191,"RPn"],];
CONWAYPOLDATA[3181]:=[
,,,[46471236,"RPn"],,[25808307661544,"JB"],,,[155441645367,"RPn"],];
CONWAYPOLDATA[3187]:=[
,,,[86976419,"RPn"],,[37134417410417,"JB"],,,[181636101403,"RPn"],];
CONWAYPOLDATA[3191]:=[
,,,[57249742,"RPn"],,[296448255351237,"JB"],,,[253935922070,"RPn"],];
CONWAYPOLDATA[3203]:=[
,,,[173381595,"RPn"],,[113418953247011,"JB"],,,[48154164644,"RPn"],];
CONWAYPOLDATA[3209]:=[
,,,[27889422,"RPn"],,[196754601509292,"JB"],];
CONWAYPOLDATA[3217]:=[
,,,[163561936,"RPn"],,[87585566781548,"JB"],,,[230851823485,"RPn"],];
CONWAYPOLDATA[3221]:=[
,,,[88606499,"RPn"],,[198296625870899,"JB"],,,[179810546998,"RPn"],];
CONWAYPOLDATA[3229]:=[
,,,[9690235,"RPn"],,[284316199173835,"JB"],,,[629696373171,"RPn"],];
CONWAYPOLDATA[3251]:=[
,,,[84519504,"RPn"],,[314983851911753,"JB"],,,[403031040900,"RPn"],];
CONWAYPOLDATA[3253]:=[
,,,[40952019,"RPn"],,[100627025766777,"JB"],,,[133518591266,"RPn"],];
CONWAYPOLDATA[3257]:=[
,,,[7497617,"RPn"],,[300254001849391,"JB"],,,[52707568503,"RPn"],];
CONWAYPOLDATA[3259]:=[
,,,[51896319,"RPn"],,[62003339120594,"JB"],,,[135882942563,"RPn"],];
CONWAYPOLDATA[3271]:=[
,,,[41397779,"RPn"],,[106101790872585,"JB"],,,[417144882850,"RPn"],];
CONWAYPOLDATA[3299]:=[
,,,[6119647,"RPn"],,[153115767022943,"JB"],,,[37000610793,"RPn"],];
CONWAYPOLDATA[3301]:=[
,,,[27583162,"RPn"],,[103708566414314,"JB"],,,[359520901918,"RPn"],];
CONWAYPOLDATA[3307]:=[
,,,[30321885,"RPn"],,[58794798942661,"JB"],,,[100314316429,"RPn"],];
CONWAYPOLDATA[3313]:=[
,,,[76142689,"RPn"],,[113947348848562,"JB"],,,[312354768514,"RPn"],];
CONWAYPOLDATA[3319]:=[
,,,[88092904,"RPn"],,[68854135161160,"JB"],,,[244327039939,"RPn"],];
CONWAYPOLDATA[3323]:=[
,,,[87205491,"RPn"],,[189309117793641,"JB"],,,[19890517651,"RPn"],];
CONWAYPOLDATA[3329]:=[
,,,[88384953,"RPn"],,[193478630582401,"JB"],,,[112942390435,"RPn"],];
CONWAYPOLDATA[3331]:=[
,,,[84004492,"RPn"],,[96656994941773,"JB"],];
CONWAYPOLDATA[3343]:=[
,,,[44428475,"RPn"],,[115111636459548,"JB"],,,[623951370044,"RPn"],];
CONWAYPOLDATA[3347]:=[
,,,[87942427,"RPn"],,[189211369388765,"JB"],,,[156154766966,"RPn"],];
CONWAYPOLDATA[3359]:=[
,,,[44177579,"RPn"],,[241935415936098,"JB"],,,[264977533190,"RPn"],];
CONWAYPOLDATA[3361]:=[
,,,[141972023,"RPn"],,[17769679190941,"JB"],,,[209094185795,"RPn"],];
CONWAYPOLDATA[3371]:=[
,,,[41813886,"RPn"],,[493061845650154,"JB"],];
CONWAYPOLDATA[3373]:=[
,,,[238855627,"RPn"],,[85601467447833,"JB"],];
CONWAYPOLDATA[3389]:=[
,,,[57413052,"RPn"],,[526917959613049,"JB"],];
CONWAYPOLDATA[3391]:=[
,,,[76484008,"RPn"],,[123080848661705,"JB"],];
CONWAYPOLDATA[3407]:=[
,,,[67550594,"RPn"],,[212246901631497,"JB"],];
CONWAYPOLDATA[3413]:=[
,,,[66369200,"RPn"],,[363573265522434,"JB"],];
CONWAYPOLDATA[3433]:=[
,,,[77338629,"RPn"],,[71915580901866,"JB"],];
CONWAYPOLDATA[3449]:=[
,,,[93040227,"RPn"],,[163104944360694,"JB"],];
CONWAYPOLDATA[3457]:=[
,,,[103820631,"RPn"],,[141364368853396,"JB"],];
CONWAYPOLDATA[3461]:=[
,,,[46875786,"RPn"],,[283629268657733,"JB"],];
CONWAYPOLDATA[3463]:=[
,,,[59947996,"RPn"],,[20415613814386,"JB"],];
CONWAYPOLDATA[3467]:=[
,,,[188930700,"RPn"],,[288469376299359,"JB"],];
CONWAYPOLDATA[3469]:=[
,,,[152674161,"RPn"],,[144690775298431,"JB"],];
CONWAYPOLDATA[3491]:=[
,,,[31286344,"RPn"],,[420868998869641,"JB"],];
CONWAYPOLDATA[3499]:=[
,,,[84476359,"RPn"],,[103024736478422,"JB"],];
CONWAYPOLDATA[3511]:=[
,,,[70258628,"RPn"],,[114688211819758,"JB"],];
CONWAYPOLDATA[3517]:=[
,,,[47289584,"RPn"],,[149062539027475,"JB"],];
CONWAYPOLDATA[3527]:=[
,,,[33072684,"RPn"],,[416809667686257,"JB"],];
CONWAYPOLDATA[3529]:=[
,,,[268436931,"RPn"],,[14895094700912,"JB"],];
CONWAYPOLDATA[3533]:=[
,,,[49264154,"RPn"],,[363088106910501,"JB"],];
CONWAYPOLDATA[3539]:=[
,,,[60998206,"RPn"],,[276314229909528,"JB"],];
CONWAYPOLDATA[3541]:=[
,,,[62679248,"RPn"],,[128178013897794,"JB"],];
CONWAYPOLDATA[3547]:=[
,,,[113206054,"RPn"],,[94926402701302,"JB"],];
CONWAYPOLDATA[3557]:=[
,,,[162949729,"RPn"],,[285212053806179,"JB"],];
CONWAYPOLDATA[3559]:=[
,,,[32294369,"RPn"],,[86017882221099,"JB"],];
CONWAYPOLDATA[3571]:=[
,,,[111490193,"RPn"],,[159591874712352,"JB"],];
CONWAYPOLDATA[3581]:=[
,,,[84550993,"RPn"],,[343420892659607,"JB"],];
CONWAYPOLDATA[3583]:=[
,,,[166853147,"RPn"],,[113347251656861,"JB"],];
CONWAYPOLDATA[3593]:=[
,,,[37298936,"RPn"],,[275959934220861,"JB"],];
CONWAYPOLDATA[3607]:=[
,,,[231746148,"RPn"],,[381428816087744,"JB"],];
CONWAYPOLDATA[3613]:=[
,,,[129388758,"RPn"],,[104597140080003,"JB"],];
CONWAYPOLDATA[3617]:=[
,,,[9816541,"RPn"],,[173175387202071,"JB"],];
CONWAYPOLDATA[3623]:=[
,,,[33009158,"RPn"],,[638607242297971,"JB"],];
CONWAYPOLDATA[3631]:=[
,,,[77652581,"RPn"],,[170259276043972,"JB"],];
CONWAYPOLDATA[3637]:=[
,,,[165796284,"RPn"],,[83962349727580,"JB"],];
CONWAYPOLDATA[3643]:=[
,,,[34204129,"RPn"],,[102427553347643,"JB"],];
CONWAYPOLDATA[3659]:=[
,,,[61870033,"RPn"],,[505385229152324,"JB"],];
CONWAYPOLDATA[3671]:=[
,,,[91907169,"RPn"],,[755089975196051,"JB"],];
CONWAYPOLDATA[3673]:=[
,,,[144550920,"RPn"],,[149662659861380,"JB"],];
CONWAYPOLDATA[3677]:=[
,,,[88909862,"RPn"],,[522704962640608,"JB"],];
CONWAYPOLDATA[3691]:=[
,,,[162614389,"RPn"],,[181614838026680,"JB"],];
CONWAYPOLDATA[3697]:=[
,,,[212496171,"RPn"],,[179492840692617,"JB"],];
CONWAYPOLDATA[3701]:=[
,,,[21365875,"RPn"],,[479755643391034,"JB"],];
CONWAYPOLDATA[3709]:=[
,,,[51714589,"RPn"],,[9262932871878,"JB"],];
CONWAYPOLDATA[3719]:=[
,,,[109468772,"RPn"],,[737586623574483,"JB"],];
CONWAYPOLDATA[3727]:=[
,,,[51816484,"RPn"],,[61828004614344,"JB"],];
CONWAYPOLDATA[3733]:=[
,,,[96318868,"RPn"],,[194035981267303,"JB"],];
CONWAYPOLDATA[3739]:=[
,,,[24561498,"RPn"],,[153424013031283,"JB"],];
CONWAYPOLDATA[3761]:=[
,,,[69078290,"RPn"],,[614756432250425,"JB"],];
CONWAYPOLDATA[3767]:=[
,,,[78839548,"RPn"],,[357459534754800,"JB"],];
CONWAYPOLDATA[3769]:=[
,,,[69963954,"RPn"],,[116999815077660,"JB"],];
CONWAYPOLDATA[3779]:=[
,,,[53450178,"RPn"],,[214296229921139,"JB"],];
CONWAYPOLDATA[3793]:=[
,,,[157413298,"RPn"],,[199769106177200,"JB"],];
CONWAYPOLDATA[3797]:=[
,,,[55933609,"RPn"],,[302106860951541,"JB"],];
CONWAYPOLDATA[3803]:=[
,,,[111986943,"RPn"],,[346329443603171,"JB"],];
CONWAYPOLDATA[3821]:=[
,,,[214488017,"RPn"],,[567105028075426,"JB"],];
CONWAYPOLDATA[3823]:=[
,,,[271929993,"RPn"],,[136343610545523,"JB"],];
CONWAYPOLDATA[3833]:=[
,,,[25462622,"RPn"],,[415030181323521,"JB"],];
CONWAYPOLDATA[3847]:=[
,,,[259310887,"RPn"],,[203637259731732,"JB"],];
CONWAYPOLDATA[3851]:=[
,,,[111933168,"RPn"],,[311069830203069,"JB"],];
CONWAYPOLDATA[3853]:=[
,,,[147920525,"RPn"],,[193289387899765,"JB"],];
CONWAYPOLDATA[3863]:=[
,,,[117373397,"RPn"],,[393082504708238,"JB"],];
CONWAYPOLDATA[3877]:=[
,,,[98200535,"RPn"],,[156777074677789,"JB"],];
CONWAYPOLDATA[3881]:=[
,,,[148945031,"RPn"],,[587570943973204,"JB"],];
CONWAYPOLDATA[3889]:=[
,,,[190004884,"RPn"],,[153122831990851,"JB"],];
CONWAYPOLDATA[3907]:=[
,,,[130153893,"RPn"],,[1134621551706770,"JB"],];
CONWAYPOLDATA[3911]:=[
,,,[59122600,"RPn"],,[747996037191019,"JB"],];
CONWAYPOLDATA[3917]:=[
,,,[105140116,"RPn"],,[509001856961625,"JB"],];
CONWAYPOLDATA[3919]:=[
,,,[121065751,"RPn"],,[83872331517908,"JB"],];
CONWAYPOLDATA[3923]:=[
,,,[183086412,"RPn"],,[500526703054944,"JB"],];
CONWAYPOLDATA[3929]:=[
,,,[121095712,"RPn"],,[373919417348275,"JB"],];
CONWAYPOLDATA[3931]:=[
,,,[134892267,"RPn"],,[238605325368541,"JB"],];
CONWAYPOLDATA[3943]:=[
,,,[59488044,"RPn"],,[169373675368520,"JB"],];
CONWAYPOLDATA[3947]:=[
,,,[140181654,"RPn"],,[426967289867013,"JB"],];
CONWAYPOLDATA[3967]:=[
,,,[41225070,"RPn"],,[263517873093442,"JB"],];
CONWAYPOLDATA[3989]:=[
,,,[61091537,"RPn"],,[654370673327741,"JB"],];
CONWAYPOLDATA[4001]:=[
,,,[123550883,"RPn"],,[808787833173691,"JB"],];
CONWAYPOLDATA[4003]:=[
,,,[144188062,"RPn"],,[145977040025474,"JB"],];
CONWAYPOLDATA[4007]:=[
,,,[139559808,"RPn"],,[508456829278453,"JB"],];
CONWAYPOLDATA[4013]:=[
,,,[156787912,"RPn"],,[496612232268713,"JB"],];
CONWAYPOLDATA[4019]:=[
,,,[127012459,"RPn"],,[482179375436936,"JB"],];
CONWAYPOLDATA[4021]:=[
,,,[58014990,"RPn"],,[97825581804616,"JB"],];
CONWAYPOLDATA[4027]:=[
,,,[47595116,"RPn"],,[260369786120965,"JB"],];
CONWAYPOLDATA[4049]:=[
,,,[16345816,"RPn"],,[580952555322980,"JB"],];
CONWAYPOLDATA[4051]:=[
,,,[91641732,"RPn"],,[46652605230760,"JB"],];
CONWAYPOLDATA[4057]:=[
,,,[110577597,"RPn"],,[701793169483459,"JB"],];
CONWAYPOLDATA[4073]:=[
,,,[12695544,"RPn"],,[1052443234756807,"JB"],];
CONWAYPOLDATA[4079]:=[
,,,[149103777,"RPn"],,[411084049627808,"JB"],];
CONWAYPOLDATA[4091]:=[
,,,[150597894,"RPn"],,[835529440649671,"JB"],];
CONWAYPOLDATA[4093]:=[
,,,[113228754,"RPn"],,[192497410205293,"JB"],];
CONWAYPOLDATA[4099]:=[
,,,[148605148,"RPn"],,[211994297279958,"JB"],];
CONWAYPOLDATA[4111]:=[
,,,[99243663,"RPn"],,[272367149294748,"JB"],];
CONWAYPOLDATA[4127]:=[
,,,[96014660,"RPn"],,[531635738628791,"JB"],];
CONWAYPOLDATA[4129]:=[
,,,[832158673,"RPn"],,[255033007793009,"JB"],];
CONWAYPOLDATA[4133]:=[
,,,[62180987,"RPn"],,[545365175062751,"JB"],];
CONWAYPOLDATA[4139]:=[
,,,[150986583,"RPn"],,[800577479737374,"JB"],];
CONWAYPOLDATA[4153]:=[
,,,[286216459,"RPn"],,[81465106407623,"JB"],];
CONWAYPOLDATA[4157]:=[
,,,[67630235,"RPn"],,[471989499093308,"JB"],];
CONWAYPOLDATA[4159]:=[
,,,[86469772,"RPn"],,[212514465734443,"JB"],];
CONWAYPOLDATA[4177]:=[
,,,[186582418,"RPn"],,[192513908990070,"JB"],];
CONWAYPOLDATA[4201]:=[
,,,[224148567,"RPn"],,[299547792302615,"JB"],];
CONWAYPOLDATA[4211]:=[
,,,[87993062,"RPn"],,[1257574192618082,"JB"],];
CONWAYPOLDATA[4217]:=[
,,,[17057768,"RPn"],,[503652747009952,"JB"],];
CONWAYPOLDATA[4219]:=[
,,,[160170118,"RPn"],,[293580748200216,"JB"],];
CONWAYPOLDATA[4229]:=[
,,,[135670551,"RPn"],,[352150141962672,"JB"],];
CONWAYPOLDATA[4231]:=[
,,,[67772161,"RPn"],,[270032511205787,"JB"],];
CONWAYPOLDATA[4241]:=[
,,,[17935192,"RPn"],,[548220015826441,"JB"],];
CONWAYPOLDATA[4243]:=[
,,,[155658700,"RPn"],,[323880306382933,"JB"],];
CONWAYPOLDATA[4253]:=[
,,,[118071788,"RPn"],,[1830606732817303,"JB"],];
CONWAYPOLDATA[4259]:=[
,,,[14574300,"RPn"],,[1309103441934785,"JB"],];
CONWAYPOLDATA[4261]:=[
,,,[163375264,"RPn"],,[186940792623279,"JB"],];
CONWAYPOLDATA[4271]:=[
,,,[85744603,"RPn"],,[847989988452654,"JB"],];
CONWAYPOLDATA[4273]:=[
,,,[193464353,"RPn"],,[136893910731861,"JB"],];
CONWAYPOLDATA[4283]:=[
,,,[216368596,"RPn"],,[1148493622290387,"JB"],];
CONWAYPOLDATA[4289]:=[
,,,[18344056,"RPn"],,[625745851474105,"JB"],];
CONWAYPOLDATA[4297]:=[
,,,[126460715,"RPn"],,[303296860570049,"JB"],];
CONWAYPOLDATA[4327]:=[
,,,[66505993,"RPn"],,[288964654715787,"JB"],];
CONWAYPOLDATA[4337]:=[
,,,[36916547,"RPn"],,[660043632915205,"JB"],];
CONWAYPOLDATA[4339]:=[
,,,[161562675,"RPn"],,[296170258465546,"JB"],];
CONWAYPOLDATA[4349]:=[
,,,[124059576,"RPn"],,[1050144447104985,"JB"],];
CONWAYPOLDATA[4357]:=[
,,,[130426797,"RPn"],,[263630417652273,"JB"],];
CONWAYPOLDATA[4363]:=[
,,,[170366426,"RPn"],,[362111018580493,"JB"],];
CONWAYPOLDATA[4373]:=[
,,,[30352995,"RPn"],,[1796690557252501,"JB"],];
CONWAYPOLDATA[4391]:=[
,,,[89378819,"RPn"],,[640612298204281,"JB"],];
CONWAYPOLDATA[4397]:=[
,,,[126453325,"RPn"],,[722483518333511,"JB"],];
CONWAYPOLDATA[4409]:=[
,,,[19386376,"RPn"],,[1012598903046388,"JB"],];
CONWAYPOLDATA[4421]:=[
,,,[75568156,"RPn"],,[1119370734877173,"JB"],];
CONWAYPOLDATA[4423]:=[
,,,[19509856,"RPn"],,[296693567914242,"JB"],];
CONWAYPOLDATA[4441]:=[
,,,[176174491,"RPn"],,[444132870949721,"JB"],];
CONWAYPOLDATA[4447]:=[
,,,[130835190,"RPn"],,[218951471987166,"JB"],];
CONWAYPOLDATA[4451]:=[
,,,[331074284,"RPn"],,[517686094232574,"JB"],];
CONWAYPOLDATA[4457]:=[
,,,[19022479,"RPn"],,[609211845089473,"JB"],];
CONWAYPOLDATA[4463]:=[
,,,[131122945,"RPn"],,[900665484324022,"JB"],];
CONWAYPOLDATA[4481]:=[
,,,[37519416,"RPn"],,[763067601867919,"JB"],];
CONWAYPOLDATA[4483]:=[
,,,[59771841,"RPn"],,[62640910157717,"JB"],];
CONWAYPOLDATA[4493]:=[
,,,[38752127,"RPn"],,[505967624837573,"JB"],];
CONWAYPOLDATA[4507]:=[
,,,[33414900,"RPn"],,[412344961564957,"JB"],];
CONWAYPOLDATA[4513]:=[
,,,[173669273,"RPn"],,[355447972171783,"JB"],];
CONWAYPOLDATA[4517]:=[
,,,[19350830,"RPn"],,[1154212574294741,"JB"],];
CONWAYPOLDATA[4519]:=[
,,,[102088732,"RPn"],,[1163152233025710,"JB"],];
CONWAYPOLDATA[4523]:=[
,,,[96068525,"RPn"],,[1138644101356605,"JB"],];
CONWAYPOLDATA[4547]:=[
,,,[101561794,"RPn"],,[1082229493491854,"JB"],];
CONWAYPOLDATA[4549]:=[
,,,[59846650,"RPn"],,[83492699894010,"JB"],];
CONWAYPOLDATA[4561]:=[
,,,[269614404,"RPn"],,[263559558863831,"JB"],];
CONWAYPOLDATA[4567]:=[
,,,[116979141,"RPn"],,[1697866029669461,"JB"],];
CONWAYPOLDATA[4583]:=[
,,,[251991677,"RPn"],,[849596199235623,"JB"],];
CONWAYPOLDATA[4591]:=[
,,,[55753115,"RPn"],,[271569282960453,"JB"],];
CONWAYPOLDATA[4597]:=[
,,,[82608095,"RPn"],,[233328096323209,"JB"],];
CONWAYPOLDATA[4603]:=[
,,,[188617133,"RPn"],,[448621835199613,"JB"],];
CONWAYPOLDATA[4621]:=[
,,,[146665921,"RPn"],,[86781906777255,"JB"],];
CONWAYPOLDATA[4637]:=[
,,,[97112693,"RPn"],,[542979529589183,"JB"],];
CONWAYPOLDATA[4639]:=[
,,,[82634510,"RPn"],,[160370363575369,"JB"],];
CONWAYPOLDATA[4643]:=[
,,,[33378532,"RPn"],,[867345762322935,"JB"],];
CONWAYPOLDATA[4649]:=[
,,,[105109244,"RPn"],,[982456440726920,"JB"],];
CONWAYPOLDATA[4651]:=[
,,,[145222827,"RPn"],,[422090975201117,"JB"],];
CONWAYPOLDATA[4657]:=[
,,,[17193659,"RPn"],,[438996979412060,"JB"],];
CONWAYPOLDATA[4663]:=[
,,,[126693713,"RPn"],,[432281435253408,"JB"],];
CONWAYPOLDATA[4673]:=[
,,,[11495583,"RPn"],,[1923803619697134,"JB"],];
CONWAYPOLDATA[4679]:=[
,,,[86332240,"RPn"],,[843223216725809,"JB"],];
CONWAYPOLDATA[4691]:=[
,,,[21151721,"RPn"],,[799287744153501,"JB"],];
CONWAYPOLDATA[4703]:=[
,,,[102638277,"RPn"],,[1876358488537330,"JB"],];
CONWAYPOLDATA[4721]:=[
,,,[21074550,"RPn"],,[587031446035740,"JB"],];
CONWAYPOLDATA[4723]:=[
,,,[176966089,"RPn"],,[1276858534476669,"JB"],];
CONWAYPOLDATA[4729]:=[
,,,[513446463,"RPn"],,[481394973695362,"JB"],];
CONWAYPOLDATA[4733]:=[
,,,[16385651,"RPn"],,[2943178032788062,"JB"],];
CONWAYPOLDATA[4751]:=[
,,,[220085343,"RPn"],,[585034934999174,"JB"],];
CONWAYPOLDATA[4759]:=[
,,,[170495937,"RPn"],,[209028236406057,"JB"],];
CONWAYPOLDATA[4783]:=[
,,,[89992151,"RPn"],,[256338008294369,"JB"],];
CONWAYPOLDATA[4787]:=[
,,,[175319090,"RPn"],,[1460814715387230,"JB"],];
CONWAYPOLDATA[4789]:=[
,,,[361660493,"RPn"],,[113821281126144,"JB"],];
CONWAYPOLDATA[4793]:=[
,,,[104271718,"RPn"],,[1055855295185965,"JB"],];
CONWAYPOLDATA[4799]:=[
,,,[67363570,"RPn"],,[757316710458430,"JB"],];
CONWAYPOLDATA[4801]:=[
,,,[728931036,"RPn"],,[497473401571971,"JB"],];
CONWAYPOLDATA[4813]:=[
,,,[298714034,"RPn"],,[298957458345361,"JB"],];
CONWAYPOLDATA[4817]:=[
,,,[180459274,"RPn"],,[914448989466988,"JB"],];
CONWAYPOLDATA[4831]:=[
,,,[60083150,"RPn"],,[313432261470428,"JB"],];
CONWAYPOLDATA[4861]:=[
,,,[229677400,"RPn"],,[231394275407385,"JB"],];
CONWAYPOLDATA[4871]:=[
,,,[252897460,"RPn"],,[1641939793294433,"JB"],];
CONWAYPOLDATA[4877]:=[
,,,[165091329,"RPn"],,[1323320062056694,"JB"],];
CONWAYPOLDATA[4889]:=[
,,,[23843656,"RPn"],,[1708306515109704,"JB"],];
CONWAYPOLDATA[4903]:=[
,,,[62684858,"RPn"],,[211835184295273,"JB"],];
CONWAYPOLDATA[4909]:=[
,,,[187661258,"RPn"],,[564249261429559,"JB"],];
CONWAYPOLDATA[4919]:=[
,,,[240819496,"RPn"],,[1604645382824754,"JB"],];
CONWAYPOLDATA[4931]:=[
,,,[185548605,"RPn"],,[795488318346904,"JB"],];
CONWAYPOLDATA[4933]:=[
,,,[168205436,"RPn"],,[397802803314235,"JB"],];
CONWAYPOLDATA[4937]:=[
,,,[145384779,"RPn"],,[3935132880065116,"JB"],];
CONWAYPOLDATA[4943]:=[
,,,[118869271,"RPn"],,[1154867685177153,"JB"],];
CONWAYPOLDATA[4951]:=[
,,,[114625558,"RPn"],,[497921546233716,"JB"],];
CONWAYPOLDATA[4957]:=[
,,,[164884693,"RPn"],,[603409937531407,"JB"],];
CONWAYPOLDATA[4967]:=[
,,,[311868001,"RPn"],,[1883184096568479,"JB"],];
CONWAYPOLDATA[4969]:=[
,,,[365783008,"RPn"],,[555541366500509,"JB"],];
CONWAYPOLDATA[4973]:=[
,,,[161473312,"RPn"],,[2151383932086490,"JB"],];
CONWAYPOLDATA[4987]:=[
,,,[73747758,"RPn"],,[593706213124695,"JB"],];
CONWAYPOLDATA[4993]:=[
,,,[171035220,"RPn"],,[1572473890208970,"JB"],];
CONWAYPOLDATA[4999]:=[
,,,[98960207,"RPn"],,[624134385227588,"JB"],];
CONWAYPOLDATA[5003]:=[
,,,[297808580,"RPn"],,[964276591208313,"JB"],];
CONWAYPOLDATA[5009]:=[
,,,[25029976,"RPn"],,[1784194488275483,"JB"],];
CONWAYPOLDATA[5011]:=[
,,,[272357874,"RPn"],,[394795936156775,"JB"],];
CONWAYPOLDATA[5021]:=[
,,,[92547075,"RPn"],,[1089094406879912,"JB"],];
CONWAYPOLDATA[5023]:=[
,,,[63852379,"RPn"],,[613651197189594,"JB"],];
CONWAYPOLDATA[5039]:=[
,,,[191663415,"RPn"],,[694589558318906,"JB"],];
CONWAYPOLDATA[5051]:=[
,,,[223082468,"RPn"],,[1751846310484033,"JB"],];
CONWAYPOLDATA[5059]:=[
,,,[45753598,"RPn"],,[654637402286341,"JB"],];
CONWAYPOLDATA[5077]:=[
,,,[172079840,"RPn"],,[664005484386727,"JB"],];
CONWAYPOLDATA[5081]:=[
,,,[18200145,"RPn"],,[2440810864725678,"JB"],];
CONWAYPOLDATA[5087]:=[
,,,[69936081,"RPn"],,[1120207881068333,"JB"],];
CONWAYPOLDATA[5099]:=[
,,,[233962518,"RPn"],,[776613560874379,"JB"],];
CONWAYPOLDATA[5101]:=[
,,,[182121009,"RPn"],,[635751822665336,"JB"],];
CONWAYPOLDATA[5107]:=[
,,,[361509211,"RPn"],,[505660757479992,"JB"],];
CONWAYPOLDATA[5113]:=[
,,,[619184319,"RPn"],,[2030388827879892,"JB"],];
CONWAYPOLDATA[5119]:=[
,,,[101796437,"RPn"],,[672900630244242,"JB"],];
CONWAYPOLDATA[5147]:=[
,,,[204510900,"RPn"],,[1829829083719057,"JB"],];
CONWAYPOLDATA[5153]:=[
,,,[415244204,"RPn"],,[1851129638702130,"JB"],];
CONWAYPOLDATA[5167]:=[
,,,[94333925,"RPn"],,[681577760596485,"JB"],];
CONWAYPOLDATA[5171]:=[
,,,[130629804,"RPn"],,[1066482019456222,"JB"],];
CONWAYPOLDATA[5179]:=[
,,,[48128449,"RPn"],,[1360743394863242,"JB"],];
CONWAYPOLDATA[5189]:=[
,,,[18270471,"RPn"],,[1610275721257444,"JB"],];
CONWAYPOLDATA[5197]:=[
,,,[286572981,"RPn"],,[447508567112480,"JB"],];
CONWAYPOLDATA[5209]:=[
,,,[642551003,"RPn"],,[607227123124241,"JB"],];
CONWAYPOLDATA[5227]:=[
,,,[210449476,"RPn"],,[262722327173633,"JB"],];
CONWAYPOLDATA[5231]:=[
,,,[70132024,"RPn"],,[2364925167115657,"JB"],];
CONWAYPOLDATA[5233]:=[
,,,[354342139,"RPn"],,[596395090822345,"JB"],];
CONWAYPOLDATA[5237]:=[
,,,[218042498,"RPn"],,[3854562027760504,"JB"],];
CONWAYPOLDATA[5261]:=[
,,,[352686920,"RPn"],,[1025352379139491,"JB"],];
CONWAYPOLDATA[5273]:=[
,,,[19699931,"RPn"],,[1394454725843887,"JB"],];
CONWAYPOLDATA[5279]:=[
,,,[295861562,"RPn"],,[1283091641229693,"JB"],];
CONWAYPOLDATA[5281]:=[
,,,[749030642,"RPn"],,[718284298544568,"JB"],];
CONWAYPOLDATA[5297]:=[
,,,[239191335,"RPn"],,[1830625380293442,"JB"],];
CONWAYPOLDATA[5303]:=[
,,,[221585860,"RPn"],,[2640601234102508,"JB"],];
CONWAYPOLDATA[5309]:=[
,,,[187174106,"RPn"],,[2895954485659969,"JB"],];
CONWAYPOLDATA[5323]:=[
,,,[80856375,"RPn"],,[728943366594131,"JB"],];
CONWAYPOLDATA[5333]:=[
,,,[129821221,"RPn"],,[1516588073640857,"JB"],];
CONWAYPOLDATA[5347]:=[
,,,[165944148,"RPn"],,[728852915746231,"JB"],];
CONWAYPOLDATA[5351]:=[
,,,[101438918,"RPn"],,[1029086822481508,"JB"],];
CONWAYPOLDATA[5381]:=[
,,,[318463726,"RPn"],,[2053801241840057,"JB"],];
CONWAYPOLDATA[5387]:=[
,,,[27899275,"RPn"],,[1597436889960894,"JB"],];
CONWAYPOLDATA[5393]:=[
,,,[14987150,"RPn"],,[1914176279643266,"JB"],];
CONWAYPOLDATA[5399]:=[
,,,[113681351,"RPn"],,[1446734643636651,"JB"],];
CONWAYPOLDATA[5407]:=[
,,,[161323255,"RPn"],,[765366953967710,"JB"],];
CONWAYPOLDATA[5413]:=[
,,,[339514191,"RPn"],,[796173553034668,"JB"],];
CONWAYPOLDATA[5417]:=[
,,,[487654594,"RPn"],,[2075887884570879,"JB"],];
CONWAYPOLDATA[5419]:=[
,,,[109788943,"RPn"],,[2395571479257435,"JB"],];
CONWAYPOLDATA[5431]:=[
,,,[112888769,"RPn"],,[834068888681413,"JB"],];
CONWAYPOLDATA[5437]:=[
,,,[197499030,"RPn"],,[800887972522716,"JB"],];
CONWAYPOLDATA[5441]:=[
,,,[29539192,"RPn"],,[1251634131090644,"JB"],];
CONWAYPOLDATA[5443]:=[
,,,[254509239,"RPn"],,[877230359078533,"JB"],];
CONWAYPOLDATA[5449]:=[
,,,[533173759,"RPn"],,[148569635622465,"JB"],];
CONWAYPOLDATA[5471]:=[
,,,[85325723,"RPn"],,[1694716661306260,"JB"],];
CONWAYPOLDATA[5477]:=[
,,,[115142973,"RPn"],,[2818916585039666,"JB"],];
CONWAYPOLDATA[5479]:=[
,,,[150075292,"RPn"],,[513452602517375,"JB"],];
CONWAYPOLDATA[5483]:=[
,,,[234721749,"RPn"],,[1632898334837998,"JB"],];
CONWAYPOLDATA[5501]:=[
,,,[272310504,"RPn"],,[2189732348970173,"JB"],];
CONWAYPOLDATA[5503]:=[
,,,[115904189,"RPn"],,[1727394106935161,"JB"],];
CONWAYPOLDATA[5507]:=[
,,,[86393818,"RPn"],,[1168007376094326,"JB"],];
CONWAYPOLDATA[5519]:=[
,,,[116290862,"RPn"],,[2520740029225847,"JB"],];
CONWAYPOLDATA[5521]:=[
,,,[333010168,"RPn"],,[706751536866068,"JB"],];
CONWAYPOLDATA[5527]:=[
,,,[323406883,"RPn"],,[2848766294837761,"JB"],];
CONWAYPOLDATA[5531]:=[
,,,[59817775,"RPn"],,[1412701323804391,"JB"],];
CONWAYPOLDATA[5557]:=[
,,,[245235969,"RPn"],,[891513709213736,"JB"],];
CONWAYPOLDATA[5563]:=[
,,,[84307267,"RPn"],,[630179602247435,"JB"],];
CONWAYPOLDATA[5569]:=[
,,,[462065512,"RPn"],,[625201488272016,"JB"],];
CONWAYPOLDATA[5573]:=[
,,,[400509220,"RPn"],,[1231339290544661,"JB"],];
CONWAYPOLDATA[5581]:=[
,,,[732450446,"RPn"],,[819099400654234,"JB"],];
CONWAYPOLDATA[5591]:=[
,,,[338713973,"RPn"],,[1176682526754716,"JB"],];
CONWAYPOLDATA[5623]:=[
,,,[183231083,"RPn"],,[421467900346979,"JB"],];
CONWAYPOLDATA[5639]:=[
,,,[317385483,"RPn"],,[1344379035862600,"JB"],];
CONWAYPOLDATA[5641]:=[
,,,[17289679,"RPn"],,[482363454940171,"JB"],];
CONWAYPOLDATA[5647]:=[
,,,[159420460,"RPn"],,[889393238039071,"JB"],];
CONWAYPOLDATA[5651]:=[
,,,[28899216,"RPn"],,[1624757781443190,"JB"],];
CONWAYPOLDATA[5653]:=[
,,,[254305863,"RPn"],,[1901857765679490,"JB"],];
CONWAYPOLDATA[5657]:=[
,,,[26503048,"RPn"],,[2029877475508985,"JB"],];
CONWAYPOLDATA[5659]:=[
,,,[86016802,"RPn"],,[565419660633671,"JB"],];
CONWAYPOLDATA[5669]:=[
,,,[177263964,"RPn"],,[1152571408528129,"JB"],];
CONWAYPOLDATA[5683]:=[
,,,[346628904,"RPn"],,[939773617080626,"JB"],];
CONWAYPOLDATA[5689]:=[
,,,[347228126,"RPn"],,[1025962218296599,"JB"],];
CONWAYPOLDATA[5693]:=[
,,,[252558561,"RPn"],,[2741548925100618,"JB"],];
CONWAYPOLDATA[5701]:=[
,,,[254333014,"RPn"],,[573024276954557,"JB"],];
CONWAYPOLDATA[5711]:=[
,,,[85956280,"RPn"],,[1506342713887011,"JB"],];
CONWAYPOLDATA[5717]:=[
,,,[322027178,"RPn"],,[8349689262795617,"JB"],];
CONWAYPOLDATA[5737]:=[
,,,[417819978,"RPn"],,[1009152679945404,"JB"],];
CONWAYPOLDATA[5741]:=[
,,,[92068419,"RPn"],,[2617072590593413,"JB"],];
CONWAYPOLDATA[5743]:=[
,,,[159006451,"RPn"],,[1064866218748141,"JB"],];
CONWAYPOLDATA[5749]:=[
,,,[216840784,"RPn"],,[620436816790819,"JB"],];
CONWAYPOLDATA[5779]:=[
,,,[296006161,"RPn"],,[938012934963798,"JB"],];
CONWAYPOLDATA[5783]:=[
,,,[186975963,"RPn"],,[1768931815332631,"JB"],];
CONWAYPOLDATA[5791]:=[
,,,[367184152,"RPn"],,[747217830324809,"JB"],];
CONWAYPOLDATA[5801]:=[
,,,[33581992,"RPn"],,[3166020949090532,"JB"],];
CONWAYPOLDATA[5807]:=[
,,,[165772434,"RPn"],,[1712149399027004,"JB"],];
CONWAYPOLDATA[5813]:=[
,,,[336311117,"RPn"],,[1651480611411199,"JB"],];
CONWAYPOLDATA[5821]:=[
,,,[96686816,"RPn"],,[5610593069705829,"JB"],];
CONWAYPOLDATA[5827]:=[
,,,[265647105,"RPn"],,[922142380020910,"JB"],];
CONWAYPOLDATA[5839]:=[
,,,[159404706,"RPn"],,[547636855033920,"JB"],];
CONWAYPOLDATA[5843]:=[
,,,[269782998,"RPn"],,[1927277849562152,"JB"],];
CONWAYPOLDATA[5849]:=[
,,,[265597244,"RPn"],,[4352995564832762,"JB"],];
CONWAYPOLDATA[5851]:=[
,,,[58000965,"RPn"],,[1171379023126621,"JB"],];
CONWAYPOLDATA[5857]:=[
,,,[513793618,"RPn"],,[1691896464824637,"JB"],];
CONWAYPOLDATA[5861]:=[
,,,[437101661,"RPn"],,[2963860754433261,"JB"],];
CONWAYPOLDATA[5867]:=[
,,,[240904892,"RPn"],,[1826769904510476,"JB"],];
CONWAYPOLDATA[5869]:=[
,,,[125901790,"RPn"],,[911114607118929,"JB"],];
CONWAYPOLDATA[5879]:=[
,,,[202437497,"RPn"],,[3253481347872768,"JB"],];
CONWAYPOLDATA[5881]:=[
,,,[587770695,"RPn"],,[833221041861105,"JB"],];
CONWAYPOLDATA[5897]:=[
,,,[301879227,"RPn"],,[1356147476450937,"JB"],];
CONWAYPOLDATA[5903]:=[
,,,[139358029,"RPn"],,[3707249844336377,"JB"],];
CONWAYPOLDATA[5923]:=[
,,,[298951581,"RPn"],,[809546126868320,"JB"],];
CONWAYPOLDATA[5927]:=[
,,,[127987643,"RPn"],,[2328840013345440,"JB"],];
CONWAYPOLDATA[5939]:=[
,,,[277244400,"RPn"],,[2454533112367545,"JB"],];
CONWAYPOLDATA[5953]:=[
,,,[669920862,"RPn"],,[1010806272878976,"JB"],];
CONWAYPOLDATA[5981]:=[
,,,[126037616,"RPn"],,[3351811054751910,"JB"],];
CONWAYPOLDATA[5987]:=[
,,,[284681852,"RPn"],,[3898546365524666,"JB"],];
CONWAYPOLDATA[6007]:=[
,,,[140852139,"RPn"],,[61984973254012,"JB"],];
CONWAYPOLDATA[6011]:=[
,,,[275850803,"RPn"],,[2818895276193139,"JB"],];
CONWAYPOLDATA[6029]:=[
,,,[247357814,"RPn"],,[1598055044676197,"JB"],];
CONWAYPOLDATA[6037]:=[
,,,[134504365,"RPn"],,[1815371832864651,"JB"],];
CONWAYPOLDATA[6043]:=[
,,,[255576604,"RPn"],,[2128797578850486,"JB"],];
CONWAYPOLDATA[6047]:=[
,,,[172170189,"RPn"],,[3484234291626568,"JB"],];
CONWAYPOLDATA[6053]:=[
,,,[329706912,"RPn"],,[2352379968680903,"JB"],];
CONWAYPOLDATA[6067]:=[
,,,[292301995,"RPn"],,[749126447059672,"JB"],];
CONWAYPOLDATA[6073]:=[
,,,[610136101,"RPn"],,[2715583535991015,"JB"],];
CONWAYPOLDATA[6079]:=[
,,,[147768349,"RPn"],,[115442101134364,"JB"],];
CONWAYPOLDATA[6089]:=[
,,,[289787691,"RPn"],,[1971348819772084,"JB"],];
CONWAYPOLDATA[6091]:=[
,,,[252666869,"RPn"],,[4016999552314456,"JB"],];
CONWAYPOLDATA[6101]:=[
,,,[471833039,"RPn"],,[2518492466745079,"JB"],];
CONWAYPOLDATA[6113]:=[
,,,[179642734,"RPn"],,[3864617277813212,"JB"],];
CONWAYPOLDATA[6121]:=[
,,,[625027559,"RPn"],,[985987285709875,"JB"],];
CONWAYPOLDATA[6131]:=[
,,,[142600931,"RPn"],,[2240872726039146,"JB"],];
CONWAYPOLDATA[6133]:=[
,,,[141782699,"RPn"],,[556610680973508,"JB"],];
CONWAYPOLDATA[6143]:=[
,,,[334910222,"RPn"],,[5598112635794095,"JB"],];
CONWAYPOLDATA[6151]:=[
,,,[110650342,"RPn"],,[991191965466482,"JB"],];
CONWAYPOLDATA[6163]:=[
,,,[405654826,"RPn"],,[1440850433895123,"JB"],];
CONWAYPOLDATA[6173]:=[
,,,[150608856,"RPn"],,[3564626760521953,"JB"],];
CONWAYPOLDATA[6197]:=[
,,,[296055480,"RPn"],,[2863745344835955,"JB"],];
CONWAYPOLDATA[6199]:=[
,,,[192113212,"RPn"],,[401271072342325,"JB"],];
CONWAYPOLDATA[6203]:=[
,,,[181245459,"RPn"],,[3036779306316716,"JB"],];
CONWAYPOLDATA[6211]:=[
,,,[332406511,"RPn"],,[348029491609808,"JB"],];
CONWAYPOLDATA[6217]:=[
,,,[720618692,"RPn"],,[823259180478041,"JB"],];
CONWAYPOLDATA[6221]:=[
,,,[145571403,"RPn"],,[6540852246583587,"JB"],];
CONWAYPOLDATA[6229]:=[
,,,[268955764,"RPn"],,[1504748498271271,"JB"],];
CONWAYPOLDATA[6247]:=[
,,,[416793598,"RPn"],,[210507837288809,"JB"],];
CONWAYPOLDATA[6257]:=[
,,,[150618507,"RPn"],,[1719912532385394,"JB"],];
CONWAYPOLDATA[6263]:=[
,,,[297955967,"RPn"],,[6337071657236119,"JB"],];
CONWAYPOLDATA[6269]:=[
,,,[508685469,"RPn"],,[2804252604105814,"JB"],];
CONWAYPOLDATA[6271]:=[
,,,[60828711,"RPn"],,[729180065392114,"JB"],];
CONWAYPOLDATA[6277]:=[
,,,[155067010,"RPn"],,[1009372144183298,"JB"],];
CONWAYPOLDATA[6287]:=[
,,,[231719966,"RPn"],,[2073260456825460,"JB"],];
CONWAYPOLDATA[6299]:=[
,,,[76432068,"RPn"],,[2299810991515227,"JB"],];
CONWAYPOLDATA[6301]:=[
,,,[499417270,"RPn"],,[57427122613436,"JB"],];
CONWAYPOLDATA[6311]:=[
,,,[113490720,"RPn"],,[2413972004167403,"JB"],];
CONWAYPOLDATA[6317]:=[
,,,[275130620,"RPn"],,[2706910744010637,"JB"],];
CONWAYPOLDATA[6323]:=[
,,,[275278130,"RPn"],,[1736955542161444,"JB"],];
CONWAYPOLDATA[6329]:=[
,,,[119042164,"RPn"],,[1780821410795840,"JB"],];
CONWAYPOLDATA[6337]:=[
,,,[274094271,"RPn"],,[1251710902014982,"JB"],];
CONWAYPOLDATA[6343]:=[
,,,[588459142,"RPn"],,[2905679398115034,"JB"],];
CONWAYPOLDATA[6353]:=[
,,,[317573767,"RPn"],,[2008466609023681,"JB"],];
CONWAYPOLDATA[6359]:=[
,,,[120592089,"RPn"],,[3202331994485469,"JB"],];
CONWAYPOLDATA[6361]:=[
,,,[432503492,"RPn"],,[1520631365801217,"JB"],];
CONWAYPOLDATA[6367]:=[
,,,[157965273,"RPn"],,[1190640199018175,"JB"],];
CONWAYPOLDATA[6373]:=[
,,,[365491552,"RPn"],,[1554209670890963,"JB"],];
CONWAYPOLDATA[6379]:=[
,,,[106165699,"RPn"],,[5164025311690616,"JB"],];
CONWAYPOLDATA[6389]:=[
,,,[367329168,"RPn"],,[7743538030263454,"JB"],];
CONWAYPOLDATA[6397]:=[
,,,[408071029,"RPn"],,[521497100895854,"JB"],];
CONWAYPOLDATA[6421]:=[
,,,[103647788,"RPn"],,[2678601253618901,"JB"],];
CONWAYPOLDATA[6427]:=[
,,,[159845920,"RPn"],,[1107207193244685,"JB"],];
CONWAYPOLDATA[6449]:=[
,,,[41512216,"RPn"],,[7288487351515098,"JB"],];
CONWAYPOLDATA[6451]:=[
,,,[246028241,"RPn"],,[1112204871601824,"JB"],];
CONWAYPOLDATA[6469]:=[
,,,[530697355,"RPn"],,[3924869955616893,"JB"],];
CONWAYPOLDATA[6473]:=[
,,,[401811478,"RPn"],,[5849926115309517,"JB"],];
CONWAYPOLDATA[6481]:=[
,,,[710116696,"RPn"],,[643430637293646,"JB"],];
CONWAYPOLDATA[6491]:=[
,,,[319253346,"RPn"],,[2004361917010340,"JB"],];
CONWAYPOLDATA[6521]:=[
,,,[24518966,"RPn"],,[5371562828520358,"JB"],];
CONWAYPOLDATA[6529]:=[
,,,[758761213,"RPn"],,[476568065771791,"JB"],];
CONWAYPOLDATA[6547]:=[
,,,[366972446,"RPn"],,[1836412080736597,"JB"],];
CONWAYPOLDATA[6551]:=[
,,,[109028310,"RPn"],,[2952407829616001,"JB"],];
CONWAYPOLDATA[6553]:=[
,,,[384287589,"RPn"],,[1741382689124961,"JB"],];
CONWAYPOLDATA[6563]:=[
,,,[301458284,"RPn"],,[3055753437077859,"JB"],];
CONWAYPOLDATA[6569]:=[
,,,[342297455,"RPn"],,[3598740067755333,"JB"],];
CONWAYPOLDATA[6571]:=[
,,,[159524170,"RPn"],,[1100128084790152,"JB"],];
CONWAYPOLDATA[6577]:=[
,,,[290907292,"RPn"],,[1782156199119488,"JB"],];
CONWAYPOLDATA[6581]:=[
,,,[83078558,"RPn"],,[3526079849382626,"JB"],];
CONWAYPOLDATA[6599]:=[
,,,[695554410,"RPn"],,[4490039948137208,"JB"],];
CONWAYPOLDATA[6607]:=[
,,,[130197545,"RPn"],,[845891012086470,"JB"],];
CONWAYPOLDATA[6619]:=[
,,,[161483745,"RPn"],,[413264540121615,"JB"],];
CONWAYPOLDATA[6637]:=[
,,,[295326591,"RPn"],,[1939504325077087,"JB"],];
CONWAYPOLDATA[6653]:=[
,,,[290024231,"RPn"],,[3058218239392708,"JB"],];
CONWAYPOLDATA[6659]:=[
,,,[393054136,"RPn"],,[3881644027830145,"JB"],];
CONWAYPOLDATA[6661]:=[
,,,[334422172,"RPn"],,[3213053859786212,"JB"],];
CONWAYPOLDATA[6673]:=[
,,,[667860537,"RPn"],,[7385193521967925,"JB"],];
CONWAYPOLDATA[6679]:=[
,,,[263680248,"RPn"],,[756045962882191,"JB"],];
CONWAYPOLDATA[6689]:=[
,,,[113110993,"RPn"],,[9811350878895587,"JB"],];
CONWAYPOLDATA[6691]:=[
,,,[127088856,"RPn"],,[1826978038563440,"JB"],];
CONWAYPOLDATA[6701]:=[
,,,[313097526,"RPn"],,[3106864969950850,"JB"],];
CONWAYPOLDATA[6703]:=[
,,,[258883271,"RPn"],,[4013315108913316,"JB"],];
CONWAYPOLDATA[6709]:=[
,,,[165524450,"RPn"],,[334841448649067,"JB"],];
CONWAYPOLDATA[6719]:=[
,,,[310370778,"RPn"],,[2883576409856981,"JB"],];
CONWAYPOLDATA[6733]:=[
,,,[306311104,"RPn"],,[1712830960459920,"JB"],];
CONWAYPOLDATA[6737]:=[
,,,[578122184,"RPn"],,[2989988534534712,"JB"],];
CONWAYPOLDATA[6761]:=[
,,,[344932701,"RPn"],,[5762239228795906,"JB"],];
CONWAYPOLDATA[6763]:=[
,,,[25077206,"RPn"],,[2078454746288950,"JB"],];
CONWAYPOLDATA[6779]:=[
,,,[346311996,"RPn"],,[3922214573088243,"JB"],];
CONWAYPOLDATA[6781]:=[
,,,[365421311,"RPn"],,[1758379416201136,"JB"],];
CONWAYPOLDATA[6791]:=[
,,,[226751497,"RPn"],,[5112960191289830,"JB"],];
CONWAYPOLDATA[6793]:=[
,,,[393246780,"RPn"],,[1383976885236889,"JB"],];
CONWAYPOLDATA[6803]:=[
,,,[687048578,"RPn"],,[4090917927581611,"JB"],];
CONWAYPOLDATA[6823]:=[
,,,[232739356,"RPn"],,[2043502008045766,"JB"],];
CONWAYPOLDATA[6827]:=[
,,,[354027741,"RPn"],,[4153532184888115,"JB"],];
CONWAYPOLDATA[6829]:=[
,,,[323407784,"RPn"],,[2046369560618038,"JB"],];
CONWAYPOLDATA[6833]:=[
,,,[230682083,"RPn"],,[5741819760038854,"JB"],];
CONWAYPOLDATA[6841]:=[
,,,[878904338,"RPn"],,[2017976900806982,"JB"],];
CONWAYPOLDATA[6857]:=[
,,,[24534349,"RPn"],,[4264993933406845,"JB"],];
CONWAYPOLDATA[6863]:=[
,,,[307098666,"RPn"],,[3316514137416930,"JB"],];
CONWAYPOLDATA[6869]:=[
,,,[605722160,"RPn"],,[4950208843692178,"JB"],];
CONWAYPOLDATA[6871]:=[
,,,[118971368,"RPn"],,[1466444722555333,"JB"],];
CONWAYPOLDATA[6883]:=[
,,,[407824635,"RPn"],,[2243476842153253,"JB"],];
CONWAYPOLDATA[6899]:=[
,,,[369717412,"RPn"],,[6477013048711569,"JB"],];
CONWAYPOLDATA[6907]:=[
,,,[429311494,"RPn"],,[1924730527970513,"JB"],];
CONWAYPOLDATA[6911]:=[
,,,[140300218,"RPn"],,[2494602771905914,"JB"],];
CONWAYPOLDATA[6917]:=[
,,,[462927144,"RPn"],,[3597296894943891,"JB"],];
CONWAYPOLDATA[6947]:=[
,,,[188520741,"RPn"],,[8860408666571500,"JB"],];
CONWAYPOLDATA[6949]:=[
,,,[180757390,"RPn"],,[1352511416517004,"JB"],];
CONWAYPOLDATA[6959]:=[
,,,[664967252,"RPn"],,[3428335060887773,"JB"],];
CONWAYPOLDATA[6961]:=[
,,,[909962816,"RPn"],,[5467866797781009,"JB"],];
CONWAYPOLDATA[6967]:=[
,,,[850210883,"RPn"],,[2034502273059691,"JB"],];
CONWAYPOLDATA[6971]:=[
,,,[133383116,"RPn"],,[5944612534077766,"JB"],];
CONWAYPOLDATA[6977]:=[
,,,[482920035,"RPn"],,[2735366802914665,"JB"],];
CONWAYPOLDATA[6983]:=[
,,,[242156479,"RPn"],,[11310933768474846,"JB"],];
CONWAYPOLDATA[6991]:=[
,,,[178018830,"RPn"],,[1064416791750587,"JB"],];
CONWAYPOLDATA[6997]:=[
,,,[1020442485,"RPn"],,[882112375970767,"JB"],];
CONWAYPOLDATA[7001]:=[
,,,[79328334,"RPn"],,[3215098911054548,"JB"],];
CONWAYPOLDATA[7013]:=[
,,,[183144497,"RPn"],,[3919531595640742,"JB"],];
CONWAYPOLDATA[7019]:=[
,,,[373158118,"RPn"],,[5659650286412195,"JB"],];
CONWAYPOLDATA[7027]:=[
,,,[380104486,"RPn"],,[2386068230512176,"JB"],];
CONWAYPOLDATA[7039]:=[
,,,[177410959,"RPn"],,[1261635362345407,"JB"],];
CONWAYPOLDATA[7043]:=[
,,,[1282438743,"RPn"],,[6315527245187770,"JB"],];
CONWAYPOLDATA[7057]:=[
,,,[327127240,"RPn"],,[2453523026903042,"JB"],];
CONWAYPOLDATA[7069]:=[
,,,[344479441,"RPn"],,[2496016375402831,"JB"],];
CONWAYPOLDATA[7079]:=[
,,,[295654442,"RPn"],,[4375821427880616,"JB"],];
CONWAYPOLDATA[7103]:=[
,,,[500377943,"RPn"],,[9554984809546154,"JB"],];
CONWAYPOLDATA[7109]:=[
,,,[87874351,"RPn"],,[2646858626156266,"JB"],];
CONWAYPOLDATA[7121]:=[
,,,[50623192,"RPn"],,[3596768987469094,"JB"],];
CONWAYPOLDATA[7127]:=[
,,,[229097420,"RPn"],,[7973285364578001,"JB"],];
CONWAYPOLDATA[7129]:=[
,,,[839945916,"RPn"],,[762254650344690,"JB"],];
CONWAYPOLDATA[7151]:=[
,,,[386075346,"RPn"],,[3019120784105240,"JB"],];
CONWAYPOLDATA[7159]:=[
,,,[198397370,"RPn"],,[1333720193717767,"JB"],];
CONWAYPOLDATA[7177]:=[
,,,[803773771,"RPn"],,[1416201840651647,"JB"],];
CONWAYPOLDATA[7187]:=[
,,,[252680548,"RPn"],,[4784753755131737,"JB"],];
CONWAYPOLDATA[7193]:=[
,,,[596256545,"RPn"],,[3929983353339771,"JB"],];
CONWAYPOLDATA[7207]:=[
,,,[286485460,"RPn"],,[67504650262987,"JB"],];
CONWAYPOLDATA[7211]:=[
,,,[461987139,"RPn"],,[3305960619075278,"JB"],];
CONWAYPOLDATA[7213]:=[
,,,[187119651,"RPn"],,[1206864711329546,"JB"],];
CONWAYPOLDATA[7219]:=[
,,,[446978825,"RPn"],,[13019940811112042,"JB"],];
CONWAYPOLDATA[7229]:=[
,,,[190209450,"RPn"],,[7892882333562569,"JB"],];
CONWAYPOLDATA[7237]:=[
,,,[393917149,"RPn"],,[1778223494389936,"JB"],];
CONWAYPOLDATA[7243]:=[
,,,[555443943,"RPn"],,[6592878664814752,"JB"],];
CONWAYPOLDATA[7247]:=[
,,,[207851212,"RPn"],,[4525003456797010,"JB"],];
CONWAYPOLDATA[7253]:=[
,,,[356702542,"RPn"],,[5499258844212660,"JB"],];
CONWAYPOLDATA[7283]:=[
,,,[156416993,"RPn"],,[5385571981970194,"JB"],];
CONWAYPOLDATA[7297]:=[
,,,[562569517,"RPn"],,[1876783014485640,"JB"],];
CONWAYPOLDATA[7307]:=[
,,,[143662929,"RPn"],,[2901749138786837,"JB"],];
CONWAYPOLDATA[7309]:=[
,,,[575912661,"RPn"],,[4821282722111428,"JB"],];
CONWAYPOLDATA[7321]:=[
,,,[33039680,"RPn"],,[2574936208424285,"JB"],];
CONWAYPOLDATA[7331]:=[
,,,[416782014,"RPn"],,[5635505027172492,"JB"],];
CONWAYPOLDATA[7333]:=[
,,,[1067149497,"RPn"],,[945854402640401,"JB"],];
CONWAYPOLDATA[7349]:=[
,,,[267856354,"RPn"],,[5386388737826043,"JB"],];
CONWAYPOLDATA[7351]:=[
,,,[193485677,"RPn"],,[2798140657736830,"JB"],];
CONWAYPOLDATA[7369]:=[
,,,[34722735,"RPn"],,[8656674692405013,"JB"],];
CONWAYPOLDATA[7393]:=[
,,,[360926265,"RPn"],,[429611660817123,"JB"],];
CONWAYPOLDATA[7411]:=[
,,,[697508500,"RPn"],,[2255286858794945,"JB"],];
CONWAYPOLDATA[7417]:=[
,,,[596608651,"RPn"],,[1676398844235784,"JB"],];
CONWAYPOLDATA[7433]:=[
,,,[274121610,"RPn"],,[5547864367836999,"JB"],];
CONWAYPOLDATA[7451]:=[
,,,[93420640,"RPn"],,[4326673942188215,"JB"],];
CONWAYPOLDATA[7457]:=[
,,,[722807013,"RPn"],,[4433688166222412,"JB"],];
CONWAYPOLDATA[7459]:=[
,,,[488057290,"RPn"],,[3094194344771941,"JB"],];
CONWAYPOLDATA[7477]:=[
,,,[384841192,"RPn"],,[2712216355978554,"JB"],];
CONWAYPOLDATA[7481]:=[
,,,[38115701,"RPn"],,[4437520991927583,"JB"],];
CONWAYPOLDATA[7487]:=[
,,,[332033481,"RPn"],,[5915094303905970,"JB"],];
CONWAYPOLDATA[7489]:=[
,,,[990143164,"RPn"],,[1609835595980899,"JB"],];
CONWAYPOLDATA[7499]:=[
,,,[38109920,"RPn"],,[5351239360857724,"JB"],];
CONWAYPOLDATA[7507]:=[
,,,[507142894,"RPn"],,[2524500386020550,"JB"],];
CONWAYPOLDATA[7517]:=[
,,,[373406977,"RPn"],,[5808780537719190,"JB"],];
CONWAYPOLDATA[7523]:=[
,,,[281518185,"RPn"],,[5914754020710493,"JB"],];
CONWAYPOLDATA[7529]:=[
,,,[163590115,"RPn"],,[9247003846680166,"JB"],];
CONWAYPOLDATA[7537]:=[
,,,[604979923,"RPn"],,[981278280618463,"JB"],];
CONWAYPOLDATA[7541]:=[
,,,[370813595,"RPn"],,[7860285330875727,"JB"],];
CONWAYPOLDATA[7547]:=[
,,,[486819237,"RPn"],,[4634029619934693,"JB"],];
CONWAYPOLDATA[7549]:=[
,,,[440899347,"RPn"],,[2968618449148586,"JB"],];
CONWAYPOLDATA[7559]:=[
,,,[272048423,"RPn"],,[5686182686658220,"JB"],];
CONWAYPOLDATA[7561]:=[
,,,[2041507818,"RPn"],,[3004532227294045,"JB"],];
CONWAYPOLDATA[7573]:=[
,,,[374136494,"RPn"],,[785230466184046,"JB"],];
CONWAYPOLDATA[7577]:=[
,,,[37028802,"RPn"],,[3378589319800388,"JB"],];
CONWAYPOLDATA[7583]:=[
,,,[393580454,"RPn"],,[4383411423019441,"JB"],];
CONWAYPOLDATA[7589]:=[
,,,[387228727,"RPn"],,[9909954664252097,"JB"],];
CONWAYPOLDATA[7591]:=[
,,,[228299331,"RPn"],,[1997165055650580,"JB"],];
CONWAYPOLDATA[7603]:=[
,,,[517954377,"RPn"],,[5925915818793375,"JB"],];
CONWAYPOLDATA[7607]:=[
,,,[507949823,"RPn"],,[5801588412058829,"JB"],];
CONWAYPOLDATA[7621]:=[
,,,[577275510,"RPn"],,[689692095119184,"JB"],];
CONWAYPOLDATA[7639]:=[
,,,[737461428,"RPn"],,[1557854457329947,"JB"],];
CONWAYPOLDATA[7643]:=[
,,,[525685542,"RPn"],,[6632028873531563,"JB"],];
CONWAYPOLDATA[7649]:=[
,,,[524346602,"RPn"],,[11052385692543901,"JB"],];
CONWAYPOLDATA[7669]:=[
,,,[741584633,"RPn"],,[2693501269370584,"JB"],];
CONWAYPOLDATA[7673]:=[
,,,[703729198,"RPn"],,[6250882572094019,"JB"],];
CONWAYPOLDATA[7681]:=[
,,,[882101419,"RPn"],,[2770468715422931,"JB"],];
CONWAYPOLDATA[7687]:=[
,,,[215950897,"RPn"],,[2090502215027079,"JB"],];
CONWAYPOLDATA[7691]:=[
,,,[471304482,"RPn"],,[7591117405951165,"JB"],];
CONWAYPOLDATA[7699]:=[
,,,[167645728,"RPn"],,[2555438131067288,"JB"],];
CONWAYPOLDATA[7703]:=[
,,,[166716034,"RPn"],,[6478850413001227,"JB"],];
CONWAYPOLDATA[7717]:=[
,,,[566504972,"RPn"],,[1347114474876900,"JB"],];
CONWAYPOLDATA[7723]:=[
,,,[214792079,"RPn"],,[5390331970107104,"JB"],];
CONWAYPOLDATA[7727]:=[
,,,[269270501,"RPn"],,[10396700608747396,"JB"],];
CONWAYPOLDATA[7741]:=[
,,,[296890580,"RPn"],,[1062551384837831,"JB"],];
CONWAYPOLDATA[7753]:=[
,,,[883151993,"RPn"],,[3073686070154471,"JB"],];
CONWAYPOLDATA[7757]:=[
,,,[713713815,"RPn"],,[4526944734430438,"JB"],];
CONWAYPOLDATA[7759]:=[
,,,[452838520,"RPn"],,[1044619671272533,"JB"],];
CONWAYPOLDATA[7789]:=[
,,,[408587575,"RPn"],,[1663107994913367,"JB"],];
CONWAYPOLDATA[7793]:=[
,,,[181218425,"RPn"],,[7270136970031275,"JB"],];
CONWAYPOLDATA[7817]:=[
,,,[1025535684,"RPn"],,[10952736653533553,"JB"],];
CONWAYPOLDATA[7823]:=[
,,,[220968463,"RPn"],,[13437923467361759,"JB"],];
CONWAYPOLDATA[7829]:=[
,,,[221427609,"RPn"],,[3949649224481313,"JB"],];
CONWAYPOLDATA[7841]:=[
,,,[852520578,"RPn"],,[7218630627614733,"JB"],];
CONWAYPOLDATA[7853]:=[
,,,[227305087,"RPn"],,[7563976259656587,"JB"],];
CONWAYPOLDATA[7867]:=[
,,,[726446650,"RPn"],,[3283969367454664,"JB"],];
CONWAYPOLDATA[7873]:=[
,,,[670582780,"RPn"],,[3601564977782795,"JB"],];
CONWAYPOLDATA[7877]:=[
,,,[424247345,"RPn"],,[22976000095998968,"JB"],];
CONWAYPOLDATA[7879]:=[
,,,[485976723,"RPn"],,[1997652475085716,"JB"],];
CONWAYPOLDATA[7883]:=[
,,,[487161519,"RPn"],,[6236874569398301,"JB"],];
CONWAYPOLDATA[7901]:=[
,,,[238120340,"RPn"],,[7479774941827951,"JB"],];
CONWAYPOLDATA[7907]:=[
,,,[494764713,"RPn"],,[18794110392940604,"JB"],];
CONWAYPOLDATA[7919]:=[
,,,[246114608,"RPn"],,[17455041266950494,"JB"],];
CONWAYPOLDATA[7927]:=[
,,,[176145870,"RPn"],,[3063816590756221,"JB"],];
CONWAYPOLDATA[7933]:=[
,,,[816543692,"RPn"],,[1009712830262800,"JB"],];
CONWAYPOLDATA[7937]:=[
,,,[420946735,"RPn"],,[11314509602097118,"JB"],];
CONWAYPOLDATA[7949]:=[
,,,[1195338826,"RPn"],,[20085274345282340,"JB"],];
CONWAYPOLDATA[7951]:=[
,,,[243388067,"RPn"],,[15859141056434358,"JB"],];
CONWAYPOLDATA[7963]:=[
,,,[351829234,"RPn"],,[7457335356294591,"JB"],];
CONWAYPOLDATA[7993]:=[
,,,[422533964,"RPn"],,[4015950842615623,"JB"],];
CONWAYPOLDATA[8009]:=[
,,,[64047976,"RPn"],,[7629242690140655,"JB"],];
CONWAYPOLDATA[8011]:=[
,,,[58264017,"RPn"],,[3842297065344730,"JB"],];
CONWAYPOLDATA[8017]:=[
,,,[748715652,"RPn"],,[3849584665971579,"JB"],];
CONWAYPOLDATA[8039]:=[
,,,[643111972,"RPn"],,[13683188761591993,"JB"],];
CONWAYPOLDATA[8053]:=[
,,,[583600912,"RPn"],,[3329418362314918,"JB"],];
CONWAYPOLDATA[8059]:=[
,,,[193818953,"RPn"],,[3336031441731936,"JB"],];
CONWAYPOLDATA[8069]:=[
,,,[228691600,"RPn"],,[8428912795378574,"JB"],];
CONWAYPOLDATA[8081]:=[
,,,[321324806,"RPn"],,[12213151045282855,"JB"],];
CONWAYPOLDATA[8087]:=[
,,,[321555299,"RPn"],,[5295566016073448,"JB"],];
CONWAYPOLDATA[8089]:=[
,,,[1879632858,"RPn"],,[433993896545464,"JB"],];
CONWAYPOLDATA[8093]:=[
,,,[512788668,"RPn"],,[12587616199322911,"JB"],];
CONWAYPOLDATA[8101]:=[
,,,[504554589,"RPn"],,[2042764711825489,"JB"],];
CONWAYPOLDATA[8111]:=[
,,,[231228399,"RPn"],,[5061673051283492,"JB"],];
CONWAYPOLDATA[8117]:=[
,,,[891676803,"RPn"],,[8160490632043423,"JB"],];
CONWAYPOLDATA[8123]:=[
,,,[307374322,"RPn"],,[10339439291535198,"JB"],];
CONWAYPOLDATA[8147]:=[
,,,[921482731,"RPn"],,[8561445916676959,"JB"],];
CONWAYPOLDATA[8161]:=[
,,,[57363676,"RPn"],,[3942920855128471,"JB"],];
CONWAYPOLDATA[8167]:=[
,,,[454395549,"RPn"],,[4132314803221130,"JB"],];
CONWAYPOLDATA[8171]:=[
,,,[573538834,"RPn"],,[7333016528473904,"JB"],];
CONWAYPOLDATA[8179]:=[
,,,[183643089,"RPn"],,[1496705915094704,"JB"],];
CONWAYPOLDATA[8191]:=[
,,,[268304413,"RPn"],,[4257249434739471,"JB"],];
CONWAYPOLDATA[8209]:=[
,,,[36784536,"RPn"],,[2238387825746178,"JB"],];
CONWAYPOLDATA[8219]:=[
,,,[311237094,"RPn"],,[5591188380993148,"JB"],];
CONWAYPOLDATA[8221]:=[
,,,[531890481,"RPn"],,[8587504389763434,"JB"],];
CONWAYPOLDATA[8231]:=[
,,,[194193994,"RPn"],,[6933907697377407,"JB"],];
CONWAYPOLDATA[8233]:=[
,,,[727723113,"RPn"],,[3409095081079626,"JB"],];
CONWAYPOLDATA[8237]:=[
,,,[310979700,"RPn"],,[7893148547452785,"JB"],];
CONWAYPOLDATA[8243]:=[
,,,[590528522,"RPn"],,[6291634023312720,"JB"],];
CONWAYPOLDATA[8263]:=[
,,,[197510492,"RPn"],,[4515842539162083,"JB"],];
CONWAYPOLDATA[8269]:=[
,,,[457366661,"RPn"],,[2424349558259933,"JB"],];
CONWAYPOLDATA[8273]:=[
,,,[177091841,"RPn"],,[5141171873234084,"JB"],];
CONWAYPOLDATA[8287]:=[
,,,[451757521,"RPn"],,[3091070169173497,"JB"],];
CONWAYPOLDATA[8291]:=[
,,,[536676432,"RPn"],,[6050697804093525,"JB"],];
CONWAYPOLDATA[8293]:=[
,,,[272707014,"RPn"],,[4170255959792115,"JB"],];
CONWAYPOLDATA[8297]:=[
,,,[407639910,"RPn"],,[7108827050959535,"JB"],];
CONWAYPOLDATA[8311]:=[
,,,[252355207,"RPn"],,[873865303428904,"JB"],];
CONWAYPOLDATA[8317]:=[
,,,[479849321,"RPn"],,[3916868691180739,"JB"],];
CONWAYPOLDATA[8329]:=[
,,,[58278020,"RPn"],,[1658477304391144,"JB"],];
CONWAYPOLDATA[8353]:=[
,,,[477557721,"RPn"],,[2471106617304144,"JB"],];
CONWAYPOLDATA[8363]:=[
,,,[629399382,"RPn"],,[8805104878692225,"JB"],];
CONWAYPOLDATA[8369]:=[
,,,[69939736,"RPn"],,[8419209674072272,"JB"],];
CONWAYPOLDATA[8377]:=[
,,,[753578171,"RPn"],,[3925754550288456,"JB"],];
CONWAYPOLDATA[8387]:=[
,,,[36189907,"RPn"],,[11809783505454275,"JB"],];
CONWAYPOLDATA[8389]:=[
,,,[819546583,"RPn"],,[3081409875082712,"JB"],];
CONWAYPOLDATA[8419]:=[
,,,[265156408,"RPn"],,[3326083060688620,"JB"],];
CONWAYPOLDATA[8423]:=[
,,,[851262077,"RPn"],,[5071849711582374,"JB"],];
CONWAYPOLDATA[8429]:=[
,,,[565703908,"RPn"],,[13302928641661789,"JB"],];
CONWAYPOLDATA[8431]:=[
,,,[249810533,"RPn"],,[10095845857677607,"JB"],];
CONWAYPOLDATA[8443]:=[
,,,[610217827,"RPn"],,[5079637384817533,"JB"],];
CONWAYPOLDATA[8447]:=[
,,,[681782716,"RPn"],,[9206809463604693,"JB"],];
CONWAYPOLDATA[8461]:=[
,,,[567149297,"RPn"],,[7669061939289487,"JB"],];
CONWAYPOLDATA[8467]:=[
,,,[623577618,"RPn"],,[4254362107858096,"JB"],];
CONWAYPOLDATA[8501]:=[
,,,[845968521,"RPn"],,[16480270602049155,"JB"],];
CONWAYPOLDATA[8513]:=[
,,,[481580415,"RPn"],,[5305056629256504,"JB"],];
CONWAYPOLDATA[8521]:=[
,,,[1858540886,"RPn"],,[4942472693418789,"JB"],];
CONWAYPOLDATA[8527]:=[
,,,[433529739,"RPn"],,[11956817131431550,"JB"],];
CONWAYPOLDATA[8537]:=[
,,,[139400676,"RPn"],,[6792514065141387,"JB"],];
CONWAYPOLDATA[8539]:=[
,,,[206242469,"RPn"],,[4467745677549150,"JB"],];
CONWAYPOLDATA[8543]:=[
,,,[407808653,"RPn"],,[11574894498730171,"JB"],];
CONWAYPOLDATA[8563]:=[
,,,[636633363,"RPn"],,[5325609652565205,"JB"],];
CONWAYPOLDATA[8573]:=[
,,,[127549096,"RPn"],,[7413441449952734,"JB"],];
CONWAYPOLDATA[8581]:=[
,,,[798504961,"RPn"],,[6390414695667242,"JB"],];
CONWAYPOLDATA[8597]:=[
,,,[511555890,"RPn"],,[13522785810674156,"JB"],];
CONWAYPOLDATA[8599]:=[
,,,[287877325,"RPn"],,[2696288490022882,"JB"],];
CONWAYPOLDATA[8609]:=[
,,,[573109742,"RPn"],,[12177421253925394,"JB"],];
CONWAYPOLDATA[8623]:=[
,,,[440825009,"RPn"],,[5454814271862218,"JB"],];
CONWAYPOLDATA[8627]:=[
,,,[203795623,"RPn"],,[9794987907770314,"JB"],];
CONWAYPOLDATA[8629]:=[
,,,[71249659,"RPn"],,[15533339556206983,"JB"],];
CONWAYPOLDATA[8641]:=[
,,,[2015841625,"RPn"],,[5247121661014737,"JB"],];
CONWAYPOLDATA[8647]:=[
,,,[297474097,"RPn"],,[2290750263326045,"JB"],];
CONWAYPOLDATA[8663]:=[
,,,[434986561,"RPn"],,[14508917215395141,"JB"],];
CONWAYPOLDATA[8669]:=[
,,,[128569941,"RPn"],,[8982875751554144,"JB"],];
CONWAYPOLDATA[8677]:=[
,,,[513999451,"RPn"],,[5666672478334327,"JB"],];
CONWAYPOLDATA[8681]:=[
,,,[349826953,"RPn"],,[16256622979512500,"JB"],];
CONWAYPOLDATA[8689]:=[
,,,[2263779939,"RPn"],,[5335325316342032,"JB"],];
CONWAYPOLDATA[8693]:=[
,,,[49080680,"RPn"],,[22785376520704858,"JB"],];
CONWAYPOLDATA[8699]:=[
,,,[286362383,"RPn"],,[8762841217339890,"JB"],];
CONWAYPOLDATA[8707]:=[
,,,[303212573,"RPn"],,[4029499423257128,"JB"],];
CONWAYPOLDATA[8713]:=[
,,,[1208911329,"RPn"],,[22296306777454875,"JB"],];
CONWAYPOLDATA[8719]:=[
,,,[518719470,"RPn"],,[5446259627519825,"JB"],];
CONWAYPOLDATA[8731]:=[
,,,[665957027,"RPn"],,[17975996436420192,"JB"],];
CONWAYPOLDATA[8737]:=[
,,,[2655034513,"RPn"],,[4375744734405416,"JB"],];
CONWAYPOLDATA[8741]:=[
,,,[123606483,"RPn"],,[10628151828206587,"JB"],];
CONWAYPOLDATA[8747]:=[
,,,[667194921,"RPn"],,[6667668047806108,"JB"],];
CONWAYPOLDATA[8753]:=[
,,,[512164292,"RPn"],,[14607363021474566,"JB"],];
CONWAYPOLDATA[8761]:=[
,,,[1579906197,"RPn"],,[6925183958967851,"JB"],];
CONWAYPOLDATA[8779]:=[
,,,[218000139,"RPn"],,[9178323433981842,"JB"],];
CONWAYPOLDATA[8783]:=[
,,,[833919506,"RPn"],,[11585540863763501,"JB"],];
CONWAYPOLDATA[8803]:=[
,,,[679133846,"RPn"],,[6003087621634213,"JB"],];
CONWAYPOLDATA[8807]:=[
,,,[816717150,"RPn"],,[17087913713004744,"JB"],];
CONWAYPOLDATA[8819]:=[
,,,[214239969,"RPn"],,[14712057442678108,"JB"],];
CONWAYPOLDATA[8821]:=[
,,,[839591603,"RPn"],,[203994173201756,"JB"],];
CONWAYPOLDATA[8831]:=[
,,,[389853333,"RPn"],,[10414715788279353,"JB"],];
CONWAYPOLDATA[8837]:=[
,,,[142160821,"RPn"],,[13968384220602935,"JB"],];
CONWAYPOLDATA[8839]:=[
,,,[508931945,"RPn"],,[5840204306799887,"JB"],];
CONWAYPOLDATA[8849]:=[
,,,[78198616,"RPn"],,[7926562286591316,"JB"],];
CONWAYPOLDATA[8861]:=[
,,,[120819737,"RPn"],,[16604846242128802,"JB"],];
CONWAYPOLDATA[8863]:=[
,,,[466379926,"RPn"],,[4534661939988597,"JB"],];
CONWAYPOLDATA[8867]:=[
,,,[1070441976,"RPn"],,[14335133658806012,"JB"],];
CONWAYPOLDATA[8887]:=[
,,,[464283544,"RPn"],,[12106743437532641,"JB"],];
CONWAYPOLDATA[8893]:=[
,,,[924791968,"RPn"],,[5897958084373823,"JB"],];
CONWAYPOLDATA[8923]:=[
,,,[1028108062,"RPn"],,[16245209331772060,"JB"],];
CONWAYPOLDATA[8929]:=[
,,,[2216481397,"RPn"],,[4754305078342164,"JB"],];
CONWAYPOLDATA[8933]:=[
,,,[604987427,"RPn"],,[11557595438491913,"JB"],];
CONWAYPOLDATA[8941]:=[
,,,[940968728,"RPn"],,[5590097056769300,"JB"],];
CONWAYPOLDATA[8951]:=[
,,,[932926939,"RPn"],,[23953650362673166,"JB"],];
CONWAYPOLDATA[8963]:=[
,,,[1085266931,"RPn"],,[8706226038441403,"JB"],];
CONWAYPOLDATA[8969]:=[
,,,[72837252,"RPn"],,[17015776223297714,"JB"],];
CONWAYPOLDATA[8971]:=[
,,,[715984483,"RPn"],,[356086881135045,"JB"],];
CONWAYPOLDATA[8999]:=[
,,,[400815467,"RPn"],,[37200069166214391,"JB"],];
CONWAYPOLDATA[9001]:=[
,,,[1341869087,"RPn"],,[5501280893639131,"JB"],];
CONWAYPOLDATA[9007]:=[
,,,[405594220,"RPn"],,[10965714711868282,"JB"],];
CONWAYPOLDATA[9011]:=[
,,,[404278517,"RPn"],,[12919385456059235,"JB"],];
CONWAYPOLDATA[9013]:=[
,,,[622041213,"RPn"],,[4799804138666747,"JB"],];
CONWAYPOLDATA[9029]:=[
,,,[378242870,"RPn"],,[16957000778939452,"JB"],];
CONWAYPOLDATA[9041]:=[
,,,[406266379,"RPn"],,[7338527638169988,"JB"],];
CONWAYPOLDATA[9043]:=[
,,,[1049087476,"RPn"],,[6388475474042673,"JB"],];
CONWAYPOLDATA[9049]:=[
,,,[51805532,"RPn"],,[1620018963910402,"JB"],];
CONWAYPOLDATA[9059]:=[
,,,[618041218,"RPn"],,[14643565516339496,"JB"],];
CONWAYPOLDATA[9067]:=[
,,,[303390890,"RPn"],,[4988795605582457,"JB"],];
CONWAYPOLDATA[9091]:=[
,,,[67755226,"RPn"],,[1410783967480419,"JB"],];
CONWAYPOLDATA[9103]:=[
,,,[465099585,"RPn"],,[3505584227731361,"JB"],];
CONWAYPOLDATA[9109]:=[
,,,[459521733,"RPn"],,[4784434313219774,"JB"],];
CONWAYPOLDATA[9127]:=[
,,,[464902002,"RPn"],,[5646363922148649,"JB"],];
CONWAYPOLDATA[9133]:=[
,,,[727333860,"RPn"],,[1947434401045214,"JB"],];
CONWAYPOLDATA[9137]:=[
,,,[387947886,"RPn"],,[12527736508748459,"JB"],];
CONWAYPOLDATA[9151]:=[
,,,[242556409,"RPn"],,[4580804568506564,"JB"],];
CONWAYPOLDATA[9157]:=[
,,,[728485141,"RPn"],,[4336022796465665,"JB"],];
CONWAYPOLDATA[9161]:=[
,,,[83813992,"RPn"],,[15109005839502348,"JB"],];
CONWAYPOLDATA[9173]:=[
,,,[324953527,"RPn"],,[17927371907599149,"JB"],];
CONWAYPOLDATA[9181]:=[
,,,[917053368,"RPn"],,[7102609336475791,"JB"],];
CONWAYPOLDATA[9187]:=[
,,,[221186215,"RPn"],,[5537238163883179,"JB"],];
CONWAYPOLDATA[9199]:=[
,,,[326040160,"RPn"],,[7148142986123628,"JB"],];
CONWAYPOLDATA[9203]:=[
,,,[404214168,"RPn"],,[14145513262789957,"JB"],];
CONWAYPOLDATA[9209]:=[
,,,[406199784,"RPn"],,[10373864823699400,"JB"],];
CONWAYPOLDATA[9221]:=[
,,,[1343840879,"RPn"],,[16373012113250577,"JB"],];
CONWAYPOLDATA[9227]:=[
,,,[655412266,"RPn"],,[12606221373198064,"JB"],];
CONWAYPOLDATA[9239]:=[
,,,[674308434,"RPn"],,[20318129064745474,"JB"],];
CONWAYPOLDATA[9241]:=[
,,,[1240955421,"RPn"],,[798956924667943,"JB"],];
CONWAYPOLDATA[9257]:=[
,,,[668660884,"RPn"],,[15515547260361259,"JB"],];
CONWAYPOLDATA[9277]:=[
,,,[997156904,"RPn"],,[6363416778743259,"JB"],];
CONWAYPOLDATA[9281]:=[
,,,[86025592,"RPn"],,[11852612928649755,"JB"],];
CONWAYPOLDATA[9283]:=[
,,,[766803651,"RPn"],,[7423572287704453,"JB"],];
CONWAYPOLDATA[9293]:=[
,,,[586602041,"RPn"],,[10713666857138284,"JB"],];
CONWAYPOLDATA[9311]:=[
,,,[409432610,"RPn"],,[8917461780853603,"JB"],];
CONWAYPOLDATA[9319]:=[
,,,[434181532,"RPn"],,[6570644609065375,"JB"],];
CONWAYPOLDATA[9323]:=[
,,,[782199702,"RPn"],,[15698407768848055,"JB"],];
CONWAYPOLDATA[9337]:=[
,,,[764121411,"RPn"],,[15399733366681326,"JB"],];
CONWAYPOLDATA[9341]:=[
,,,[325440442,"RPn"],,[21075940992562567,"JB"],];
CONWAYPOLDATA[9343]:=[
,,,[934505551,"RPn"],,[27993687694621325,"JB"],];
CONWAYPOLDATA[9349]:=[
,,,[54598162,"RPn"],,[5726721943591194,"JB"],];
CONWAYPOLDATA[9371]:=[
,,,[1196273749,"RPn"],,[10884626700385597,"JB"],];
CONWAYPOLDATA[9377]:=[
,,,[318349153,"RPn"],,[10096478630459088,"JB"],];
CONWAYPOLDATA[9391]:=[
,,,[593069826,"RPn"],,[4572706281006179,"JB"],];
CONWAYPOLDATA[9397]:=[
,,,[604706349,"RPn"],,[4839906291968069,"JB"],];
CONWAYPOLDATA[9403]:=[
,,,[1058420489,"RPn"],,[11334820466521754,"JB"],];
CONWAYPOLDATA[9413]:=[
,,,[405690890,"RPn"],,[35525602329990353,"JB"],];
CONWAYPOLDATA[9419]:=[
,,,[62429134,"RPn"],,[14749028170355055,"JB"],];
CONWAYPOLDATA[9421]:=[
,,,[704709644,"RPn"],,[1422533987623092,"JB"],];
CONWAYPOLDATA[9431]:=[
,,,[235718421,"RPn"],,[14947236452421247,"JB"],];
CONWAYPOLDATA[9433]:=[
,,,[1334618577,"RPn"],,[7713898617888713,"JB"],];
CONWAYPOLDATA[9437]:=[
,,,[147707926,"RPn"],,[11075894232334554,"JB"],];
CONWAYPOLDATA[9439]:=[
,,,[261063884,"RPn"],,[5374301367082746,"JB"],];
CONWAYPOLDATA[9461]:=[
,,,[1320802908,"RPn"],,[11549187805760097,"JB"],];
CONWAYPOLDATA[9463]:=[
,,,[447703996,"RPn"],,[4962883314281614,"JB"],];
CONWAYPOLDATA[9467]:=[
,,,[418933686,"RPn"],,[12765806100000009,"JB"],];
CONWAYPOLDATA[9473]:=[
,,,[138324749,"RPn"],,[16952152224616821,"JB"],];
CONWAYPOLDATA[9479]:=[
,,,[779145370,"RPn"],,[26981845280097900,"JB"],];
CONWAYPOLDATA[9491]:=[
,,,[408559079,"RPn"],,[31828180275117871,"JB"],];
CONWAYPOLDATA[9497]:=[
,,,[1054736823,"RPn"],,[8874476422233006,"JB"],];
CONWAYPOLDATA[9511]:=[
,,,[360523969,"RPn"],,[6465125562716455,"JB"],];
CONWAYPOLDATA[9521]:=[
,,,[682846123,"RPn"],,[16700393972683125,"JB"],];
CONWAYPOLDATA[9533]:=[
,,,[143109398,"RPn"],,[46652020551892089,"JB"],];
CONWAYPOLDATA[9539]:=[
,,,[818865918,"RPn"],,[16196366321318287,"JB"],];
CONWAYPOLDATA[9547]:=[
,,,[958261033,"RPn"],,[2753702934257290,"JB"],];
CONWAYPOLDATA[9551]:=[
,,,[448581828,"RPn"],,[10169079719281620,"JB"],];
CONWAYPOLDATA[9587]:=[
,,,[808164928,"RPn"],,[40845662311698612,"JB"],];
CONWAYPOLDATA[9601]:=[
,,,[3930217368,"RPn"],,[4789208258926695,"JB"],];
CONWAYPOLDATA[9613]:=[
,,,[521082280,"RPn"],,[5825841871035677,"JB"],];
CONWAYPOLDATA[9619]:=[
,,,[807784384,"RPn"],,[7863583994277650,"JB"],];
CONWAYPOLDATA[9623]:=[
,,,[815809076,"RPn"],,[22232252536322437,"JB"],];
CONWAYPOLDATA[9629]:=[
,,,[65380912,"RPn"],,[14481395384239156,"JB"],];
CONWAYPOLDATA[9631]:=[
,,,[606897468,"RPn"],,[6283367788091571,"JB"],];
CONWAYPOLDATA[9643]:=[
,,,[795103924,"RPn"],,[8643974056713133,"JB"],];
CONWAYPOLDATA[9649]:=[
,,,[48264305,"RPn"],,[941827767356482,"JB"],];
CONWAYPOLDATA[9661]:=[
,,,[647972933,"RPn"],,[600080254277813,"JB"],];
CONWAYPOLDATA[9677]:=[
,,,[179914786,"RPn"],,[20669785835046182,"JB"],];
CONWAYPOLDATA[9679]:=[
,,,[259948906,"RPn"],,[6680065398371432,"JB"],];
CONWAYPOLDATA[9689]:=[
,,,[93760456,"RPn"],,[14860205695799945,"JB"],];
CONWAYPOLDATA[9697]:=[
,,,[1001855262,"RPn"],,[2143534857604295,"JB"],];
CONWAYPOLDATA[9719]:=[
,,,[806822802,"RPn"],,[35434071691198474,"JB"],];
CONWAYPOLDATA[9721]:=[
,,,[2173265651,"RPn"],,[5166405808797090,"JB"],];
CONWAYPOLDATA[9733]:=[
,,,[852513472,"RPn"],,[2078938377990154,"JB"],];
CONWAYPOLDATA[9739]:=[
,,,[555327522,"RPn"],,[2249983519883696,"JB"],];
CONWAYPOLDATA[9743]:=[
,,,[620453731,"RPn"],,[13733218697792960,"JB"],];
CONWAYPOLDATA[9749]:=[
,,,[434239960,"RPn"],,[21526716019530297,"JB"],];
CONWAYPOLDATA[9767]:=[
,,,[381538093,"RPn"],,[30335378678569337,"JB"],];
CONWAYPOLDATA[9769]:=[
,,,[1396927937,"RPn"],,[8114699516908150,"JB"],];
CONWAYPOLDATA[9781]:=[
,,,[240250709,"RPn"],,[2086664977880588,"JB"],];
CONWAYPOLDATA[9787]:=[
,,,[256448764,"RPn"],,[8910911970394262,"JB"],];
CONWAYPOLDATA[9791]:=[
,,,[251315399,"RPn"],,[24315733076968943,"JB"],];
CONWAYPOLDATA[9803]:=[
,,,[268739444,"RPn"],,[11259137134310367,"JB"],];
CONWAYPOLDATA[9811]:=[
,,,[645524559,"RPn"],,[4769272185068003,"JB"],];
CONWAYPOLDATA[9817]:=[
,,,[629387509,"RPn"],,[6593381474707452,"JB"],];
CONWAYPOLDATA[9829]:=[
,,,[252074544,"RPn"],,[8101597260890663,"JB"],];
CONWAYPOLDATA[9833]:=[
,,,[1219596826,"RPn"],,[15164374712020363,"JB"],];
CONWAYPOLDATA[9839]:=[
,,,[246870356,"RPn"],,[13073837970324888,"JB"],];
CONWAYPOLDATA[9851]:=[
,,,[446792107,"RPn"],,[24288266338256081,"JB"],];
CONWAYPOLDATA[9857]:=[
,,,[478478499,"RPn"],,[25635736224214067,"JB"],];
CONWAYPOLDATA[9859]:=[
,,,[188208312,"RPn"],,[4818713482504828,"JB"],];
CONWAYPOLDATA[9871]:=[
,,,[356402329,"RPn"],,[13511553986643406,"JB"],];
CONWAYPOLDATA[9883]:=[
,,,[1124102305,"RPn"],,[9073881399625918,"JB"],];
CONWAYPOLDATA[9887]:=[
,,,[658879572,"RPn"],,[16186833010147043,"JB"],];
CONWAYPOLDATA[9901]:=[
,,,[882198904,"RPn"],,[18046676243925526,"JB"],];
CONWAYPOLDATA[9907]:=[
,,,[846127151,"RPn"],,[7367883981553939,"JB"],];
CONWAYPOLDATA[9923]:=[
,,,[92452593,"RPn"],,[16172843744818769,"JB"],];
CONWAYPOLDATA[9929]:=[
,,,[474179256,"RPn"],,[17890064352168048,"JB"],];
CONWAYPOLDATA[9931]:=[
,,,[489290449,"RPn"],,[24920779105190069,"JB"],];
CONWAYPOLDATA[9941]:=[
,,,[774483430,"RPn"],,[20916169724042734,"JB"],];
CONWAYPOLDATA[9949]:=[
,,,[1081058342,"RPn"],,[6864016382765695,"JB"],];
CONWAYPOLDATA[9967]:=[
,,,[496665580,"RPn"],,[9586194719206439,"JB"],];
CONWAYPOLDATA[9973]:=[
,,,[275583920,"RPn"],,[9863967809002268,"JB"],];
CONWAYPOLDATA[10007]:=[
,,,[1201560509,"RPn"],,[17113609900037042,"JB"],];
CONWAYPOLDATA[10009]:=[
,,,[1202020857,"RPn"],,[20015295940805054,"JB"],];
CONWAYPOLDATA[10037]:=[
,,,[171994034,"RPn"],,[16986042323178638,"JB"],];
CONWAYPOLDATA[10039]:=[
,,,[267689938,"RPn"],,[39396287738091765,"JB"],];
CONWAYPOLDATA[10061]:=[
,,,[506078364,"RPn"],,[26866470933958787,"JB"],];
CONWAYPOLDATA[10067]:=[
,,,[1489613992,"RPn"],,[17574792885749842,"JB"],];
CONWAYPOLDATA[10069]:=[
,,,[693401687,"RPn"],,[5416405754804909,"JB"],];
CONWAYPOLDATA[10079]:=[
,,,[1272826526,"RPn"],,[60880785894125243,"JB"],];
CONWAYPOLDATA[10091]:=[
,,,[880601208,"RPn"],,[14246884169940177,"JB"],];
CONWAYPOLDATA[10093]:=[
,,,[365336323,"RPn"],,[4413949370571941,"JB"],];
CONWAYPOLDATA[10099]:=[
,,,[197324363,"RPn"],,[6668277692515156,"JB"],];
CONWAYPOLDATA[10103]:=[
,,,[478498291,"RPn"],,[18388529324817523,"JB"],];
CONWAYPOLDATA[10111]:=[
,,,[391437266,"RPn"],,[15923110612145646,"JB"],];
CONWAYPOLDATA[10133]:=[
,,,[776633654,"RPn"],,[19738450175884832,"JB"],];
CONWAYPOLDATA[10139]:=[
,,,[925122918,"RPn"],,[13509194631709776,"JB"],];
CONWAYPOLDATA[10141]:=[
,,,[391929370,"RPn"],,[8600217612989282,"JB"],];
CONWAYPOLDATA[10151]:=[
,,,[484943730,"RPn"],,[18852448941255667,"JB"],];
CONWAYPOLDATA[10159]:=[
,,,[405801258,"RPn"],,[460178717638544,"JB"],];
CONWAYPOLDATA[10163]:=[
,,,[1838161486,"RPn"],,[21047775378054862,"JB"],];
CONWAYPOLDATA[10169]:=[
,,,[103286536,"RPn"],,[60086416513172299,"JB"],];
CONWAYPOLDATA[10177]:=[
,,,[930686657,"RPn"],,[10608761917050578,"JB"],];
CONWAYPOLDATA[10181]:=[
,,,[372380258,"RPn"],,[19094184647544862,"JB"],];
CONWAYPOLDATA[10193]:=[
,,,[498121720,"RPn"],,[20503606903057578,"JB"],];
CONWAYPOLDATA[10211]:=[
,,,[292626844,"RPn"],,[19611672585030334,"JB"],];
CONWAYPOLDATA[10223]:=[
,,,[1555950828,"RPn"],,[21393178805389575,"JB"],];
CONWAYPOLDATA[10243]:=[
,,,[1461389303,"RPn"],,[8818514641401695,"JB"],];
CONWAYPOLDATA[10247]:=[
,,,[686210854,"RPn"],,[17847622580081043,"JB"],];
CONWAYPOLDATA[10253]:=[
,,,[719063398,"RPn"],,[17198258458306518,"JB"],];
CONWAYPOLDATA[10259]:=[
,,,[86339746,"RPn"],,[18889347123913224,"JB"],];
CONWAYPOLDATA[10267]:=[
,,,[195114070,"RPn"],,[4593428403598804,"JB"],];
CONWAYPOLDATA[10271]:=[
,,,[380900042,"RPn"],,[15229122698772475,"JB"],];
CONWAYPOLDATA[10273]:=[
,,,[1786577440,"RPn"],,[14392843412564529,"JB"],];
CONWAYPOLDATA[10289]:=[
,,,[105740056,"RPn"],,[21349759230630989,"JB"],];
CONWAYPOLDATA[10301]:=[
,,,[96025924,"RPn"],,[25581665764835848,"JB"],];
CONWAYPOLDATA[10303]:=[
,,,[315148167,"RPn"],,[103641324132118319,"JB"],];
CONWAYPOLDATA[10313]:=[
,,,[481431469,"RPn"],,[17767460272613594,"JB"],];
CONWAYPOLDATA[10321]:=[
,,,[60315931,"RPn"],,[8094904026035039,"JB"],];
CONWAYPOLDATA[10331]:=[
,,,[301200307,"RPn"],,[17259255168365068,"JB"],];
CONWAYPOLDATA[10333]:=[
,,,[1239526019,"RPn"],,[5939523465363766,"JB"],];
CONWAYPOLDATA[10337]:=[
,,,[844584588,"RPn"],,[13094956910947378,"JB"],];
CONWAYPOLDATA[10343]:=[
,,,[427869229,"RPn"],,[32629870995538841,"JB"],];
CONWAYPOLDATA[10357]:=[
,,,[1063425691,"RPn"],,[18582520045588673,"JB"],];
CONWAYPOLDATA[10369]:=[
,,,[61322279,"RPn"],,[68695782838458229,"JB"],];
CONWAYPOLDATA[10391]:=[
,,,[408709222,"RPn"],,[27935974428732068,"JB"],];
CONWAYPOLDATA[10399]:=[
,,,[536588406,"RPn"],,[18845594965096580,"JB"],];
CONWAYPOLDATA[10427]:=[
,,,[936407164,"RPn"],,[38392370881190665,"JB"],];
CONWAYPOLDATA[10429]:=[
,,,[936221766,"RPn"],,[3269218566531024,"JB"],];
CONWAYPOLDATA[10433]:=[
,,,[314627984,"RPn"],,[14318741815513952,"JB"],];
CONWAYPOLDATA[10453]:=[
,,,[417764603,"RPn"],,[23901580343649795,"JB"],];
CONWAYPOLDATA[10457]:=[
,,,[712696838,"RPn"],,[26424130919689992,"JB"],];
CONWAYPOLDATA[10459]:=[
,,,[931593591,"RPn"],,[1315849625068837,"JB"],];
CONWAYPOLDATA[10463]:=[
,,,[622067207,"RPn"],,[23961102696745927,"JB"],];
CONWAYPOLDATA[10477]:=[
,,,[761761718,"RPn"],,[7641910266041896,"JB"],];
CONWAYPOLDATA[10487]:=[
,,,[606956104,"RPn"],,[21320653919957927,"JB"],];
CONWAYPOLDATA[10499]:=[
,,,[846691857,"RPn"],,[23881668031086212,"JB"],];
CONWAYPOLDATA[10501]:=[
,,,[717963873,"RPn"],,[11716223732357172,"JB"],];
CONWAYPOLDATA[10513]:=[
,,,[2405416459,"RPn"],,[6423990922452826,"JB"],];
CONWAYPOLDATA[10529]:=[
,,,[1762428255,"RPn"],,[47932075562163929,"JB"],];
CONWAYPOLDATA[10531]:=[
,,,[652353329,"RPn"],,[22126558212605030,"JB"],];
CONWAYPOLDATA[10559]:=[
,,,[552985412,"RPn"],,[22510328170808436,"JB"],];
CONWAYPOLDATA[10567]:=[
,,,[315583461,"RPn"],,[6922871535338386,"JB"],];
CONWAYPOLDATA[10589]:=[
,,,[397225159,"RPn"],,[18654236800094112,"JB"],];
CONWAYPOLDATA[10597]:=[
,,,[431128353,"RPn"],,[11173526135933652,"JB"],];
CONWAYPOLDATA[10601]:=[
,,,[286216402,"RPn"],,[111025205511802316,"JB"],];
CONWAYPOLDATA[10607]:=[
,,,[448135148,"RPn"],,[24088264298712357,"JB"],];
CONWAYPOLDATA[10613]:=[
,,,[982052731,"RPn"],,[33644179568752619,"JB"],];
CONWAYPOLDATA[10627]:=[
,,,[790446892,"RPn"],,[8011231354584914,"JB"],];
CONWAYPOLDATA[10631]:=[
,,,[644164194,"RPn"],,[28382107036908434,"JB"],];
CONWAYPOLDATA[10639]:=[
,,,[632211942,"RPn"],,[32526925397983443,"JB"],];
CONWAYPOLDATA[10651]:=[
,,,[766232947,"RPn"],,[8323305517051516,"JB"],];
CONWAYPOLDATA[10657]:=[
,,,[1677102754,"RPn"],,[11239683274920629,"JB"],];
CONWAYPOLDATA[10663]:=[
,,,[113571616,"RPn"],,[9135025331857957,"JB"],];
CONWAYPOLDATA[10667]:=[
,,,[551963917,"RPn"],,[16436732070684883,"JB"],];
CONWAYPOLDATA[10687]:=[
,,,[456805133,"RPn"],,[54074538074596505,"JB"],];
CONWAYPOLDATA[10691]:=[
,,,[90691755,"RPn"],,[27202886596528078,"JB"],];
CONWAYPOLDATA[10709]:=[
,,,[413988524,"RPn"],,[37968705917486375,"JB"],];
CONWAYPOLDATA[10711]:=[
,,,[306912997,"RPn"],,[7414755266552097,"JB"],];
CONWAYPOLDATA[10723]:=[
,,,[1034769502,"RPn"],,[12452810045533164,"JB"],];
CONWAYPOLDATA[10729]:=[
,,,[87934891,"RPn"],,[17588443746311200,"JB"],];
CONWAYPOLDATA[10733]:=[
,,,[1099252396,"RPn"],,[36238413886059112,"JB"],];
CONWAYPOLDATA[10739]:=[
,,,[651051881,"RPn"],,[26312652073756827,"JB"],];
CONWAYPOLDATA[10753]:=[
,,,[2527826004,"RPn"],,[8351548980090533,"JB"],];
CONWAYPOLDATA[10771]:=[
,,,[341429932,"RPn"],,[4205358103124381,"JB"],];
CONWAYPOLDATA[10781]:=[
,,,[1360529867,"RPn"],,[40108049346217011,"JB"],];
CONWAYPOLDATA[10789]:=[
,,,[2063827812,"RPn"],,[12668467084323508,"JB"],];
CONWAYPOLDATA[10799]:=[
,,,[685207368,"RPn"],,[147325755525773168,"JB"],];
CONWAYPOLDATA[10831]:=[
,,,[345259794,"RPn"],,[13367723025159945,"JB"],];
CONWAYPOLDATA[10837]:=[
,,,[1286677012,"RPn"],,[13788467140085287,"JB"],];
CONWAYPOLDATA[10847]:=[
,,,[1248370388,"RPn"],,[38483656949936729,"JB"],];
CONWAYPOLDATA[10853]:=[
,,,[1060012512,"RPn"],,[25213190422027945,"JB"],];
CONWAYPOLDATA[10859]:=[
,,,[69128396,"RPn"],,[27555250790913475,"JB"],];
CONWAYPOLDATA[10861]:=[
,,,[1528435949,"RPn"],,[12756911929064180,"JB"],];
CONWAYPOLDATA[10867]:=[
,,,[1062749134,"RPn"],,[6690744046734544,"JB"],];
CONWAYPOLDATA[10883]:=[
,,,[325216691,"RPn"],,[39482092594738891,"JB"],];
CONWAYPOLDATA[10889]:=[
,,,[309443605,"RPn"],,[30774959148889265,"JB"],];
CONWAYPOLDATA[10891]:=[
,,,[310066772,"RPn"],,[3302898480214554,"JB"],];
CONWAYPOLDATA[10903]:=[
,,,[676116839,"RPn"],,[2523050714697072,"JB"],];
CONWAYPOLDATA[10909]:=[
,,,[462399785,"RPn"],,[8401717936707678,"JB"],];
CONWAYPOLDATA[10937]:=[
,,,[235998589,"RPn"],,[25291967363424896,"JB"],];
CONWAYPOLDATA[10939]:=[
,,,[477027915,"RPn"],,[8367769996252525,"JB"],];
CONWAYPOLDATA[10949]:=[
,,,[1538049828,"RPn"],,[28094810467495348,"JB"],];
CONWAYPOLDATA[10957]:=[
,,,[912838632,"RPn"],,[56486936206850072,"JB"],];
CONWAYPOLDATA[10973]:=[
,,,[929939806,"RPn"],,[21835378031000607,"JB"],];
CONWAYPOLDATA[10979]:=[
,,,[473699936,"RPn"],,[18124149036834216,"JB"],];
CONWAYPOLDATA[10987]:=[
,,,[1063080148,"RPn"],,[14567929685363437,"JB"],];
CONWAYPOLDATA[10993]:=[
,,,[2644498073,"RPn"],,[11041666320683810,"JB"],];
CONWAYPOLDATA[11003]:=[
,,,[1089517062,"RPn"],];
CONWAYPOLDATA[11027]:=[
,,,[1089721223,"RPn"],];
CONWAYPOLDATA[11047]:=[
,,,[473275577,"RPn"],];
CONWAYPOLDATA[11057]:=[
,,,[971689163,"RPn"],];
CONWAYPOLDATA[11059]:=[
,,,[63699850,"RPn"],];
CONWAYPOLDATA[11069]:=[
,,,[77283760,"RPn"],];
CONWAYPOLDATA[11071]:=[
,,,[456047706,"RPn"],];
CONWAYPOLDATA[11083]:=[
,,,[1099433602,"RPn"],];
CONWAYPOLDATA[11087]:=[
,,,[484878863,"RPn"],];
CONWAYPOLDATA[11093]:=[
,,,[825618713,"RPn"],];
CONWAYPOLDATA[11113]:=[
,,,[1814664009,"RPn"],];
CONWAYPOLDATA[11117]:=[
,,,[583186706,"RPn"],];
CONWAYPOLDATA[11119]:=[
,,,[859220728,"RPn"],];
CONWAYPOLDATA[11131]:=[
,,,[1095724511,"RPn"],];
CONWAYPOLDATA[11149]:=[
,,,[935835921,"RPn"],];
CONWAYPOLDATA[11159]:=[
,,,[618532218,"RPn"],];
CONWAYPOLDATA[11161]:=[
,,,[2104629777,"RPn"],];
CONWAYPOLDATA[11171]:=[
,,,[580735608,"RPn"],];
CONWAYPOLDATA[11173]:=[
,,,[2348173550,"RPn"],];
CONWAYPOLDATA[11177]:=[
,,,[1198621483,"RPn"],];
CONWAYPOLDATA[11197]:=[
,,,[826607330,"RPn"],];
CONWAYPOLDATA[11213]:=[
,,,[229440408,"RPn"],];
CONWAYPOLDATA[11239]:=[
,,,[327628092,"RPn"],];
CONWAYPOLDATA[11243]:=[
,,,[445515123,"RPn"],];
CONWAYPOLDATA[11251]:=[
,,,[318043281,"RPn"],];
CONWAYPOLDATA[11257]:=[
,,,[1377327731,"RPn"],];
CONWAYPOLDATA[11261]:=[
,,,[498378079,"RPn"],];
CONWAYPOLDATA[11273]:=[
,,,[102347570,"RPn"],];
CONWAYPOLDATA[11279]:=[
,,,[338674540,"RPn"],];
CONWAYPOLDATA[11287]:=[
,,,[834617218,"RPn"],];
CONWAYPOLDATA[11299]:=[
,,,[843199177,"RPn"],];
CONWAYPOLDATA[11311]:=[
,,,[639648364,"RPn"],];
CONWAYPOLDATA[11317]:=[
,,,[1152591184,"RPn"],];
CONWAYPOLDATA[11321]:=[
,,,[963722770,"RPn"],];
CONWAYPOLDATA[11329]:=[
,,,[736033808,"RPn"],];
CONWAYPOLDATA[11351]:=[
,,,[349974039,"RPn"],];
CONWAYPOLDATA[11353]:=[
,,,[1158301185,"RPn"],];
CONWAYPOLDATA[11369]:=[
,,,[381793761,"RPn"],];
CONWAYPOLDATA[11383]:=[
,,,[1270513550,"RPn"],];
CONWAYPOLDATA[11393]:=[
,,,[599351554,"RPn"],];
CONWAYPOLDATA[11399]:=[
,,,[755160963,"RPn"],];
CONWAYPOLDATA[11411]:=[
,,,[1039576340,"RPn"],];
CONWAYPOLDATA[11423]:=[
,,,[521894029,"RPn"],];
CONWAYPOLDATA[11437]:=[
,,,[473823475,"RPn"],];
CONWAYPOLDATA[11443]:=[
,,,[1016138402,"RPn"],];
CONWAYPOLDATA[11447]:=[
,,,[1916410957,"RPn"],];
CONWAYPOLDATA[11467]:=[
,,,[367826964,"RPn"],];
CONWAYPOLDATA[11471]:=[
,,,[341044312,"RPn"],];
CONWAYPOLDATA[11483]:=[
,,,[1927800491,"RPn"],];
CONWAYPOLDATA[11489]:=[
,,,[131859256,"RPn"],];
CONWAYPOLDATA[11491]:=[
,,,[364965654,"RPn"],];
CONWAYPOLDATA[11497]:=[
,,,[1168348141,"RPn"],];
CONWAYPOLDATA[11503]:=[
,,,[347747196,"RPn"],];
CONWAYPOLDATA[11519]:=[
,,,[485594971,"RPn"],];
CONWAYPOLDATA[11527]:=[
,,,[358973839,"RPn"],];
CONWAYPOLDATA[11549]:=[
,,,[1198266497,"RPn"],];
CONWAYPOLDATA[11551]:=[
,,,[337243003,"RPn"],];
CONWAYPOLDATA[11579]:=[
,,,[496692786,"RPn"],];
CONWAYPOLDATA[11587]:=[
,,,[1200054005,"RPn"],];
CONWAYPOLDATA[11593]:=[
,,,[1721015634,"RPn"],];
CONWAYPOLDATA[11597]:=[
,,,[1057356478,"RPn"],];
CONWAYPOLDATA[11617]:=[
,,,[2907700259,"RPn"],];
CONWAYPOLDATA[11621]:=[
,,,[932806051,"RPn"],];
CONWAYPOLDATA[11633]:=[
,,,[640792175,"RPn"],];
CONWAYPOLDATA[11657]:=[
,,,[893730536,"RPn"],];
CONWAYPOLDATA[11677]:=[
,,,[2575292290,"RPn"],];
CONWAYPOLDATA[11681]:=[
,,,[371525889,"RPn"],];
CONWAYPOLDATA[11689]:=[
,,,[86510296,"RPn"],];
CONWAYPOLDATA[11699]:=[
,,,[1164459967,"RPn"],];
CONWAYPOLDATA[11701]:=[
,,,[1718607783,"RPn"],];
CONWAYPOLDATA[11717]:=[
,,,[522367296,"RPn"],];
CONWAYPOLDATA[11719]:=[
,,,[673737035,"RPn"],];
CONWAYPOLDATA[11731]:=[
,,,[502016417,"RPn"],];
CONWAYPOLDATA[11743]:=[
,,,[1792545467,"RPn"],];
CONWAYPOLDATA[11777]:=[
,,,[372600729,"RPn"],];
CONWAYPOLDATA[11779]:=[
,,,[414020073,"RPn"],];
CONWAYPOLDATA[11783]:=[
,,,[402860775,"RPn"],];
CONWAYPOLDATA[11789]:=[
,,,[1088207225,"RPn"],];
CONWAYPOLDATA[11801]:=[
,,,[139121992,"RPn"],];
CONWAYPOLDATA[11807]:=[
,,,[970393721,"RPn"],];
CONWAYPOLDATA[11813]:=[
,,,[1329600404,"RPn"],];
CONWAYPOLDATA[11821]:=[
,,,[511010011,"RPn"],];
CONWAYPOLDATA[11827]:=[
,,,[1224484793,"RPn"],];
CONWAYPOLDATA[11831]:=[
,,,[1676026791,"RPn"],];
CONWAYPOLDATA[11833]:=[
,,,[948556951,"RPn"],];
CONWAYPOLDATA[11839]:=[
,,,[529120430,"RPn"],];
CONWAYPOLDATA[11863]:=[
,,,[703606396,"RPn"],];
CONWAYPOLDATA[11867]:=[
,,,[1078235622,"RPn"],];
CONWAYPOLDATA[11887]:=[
,,,[2667038645,"RPn"],];
CONWAYPOLDATA[11897]:=[
,,,[670443541,"RPn"],];
CONWAYPOLDATA[11903]:=[
,,,[566678029,"RPn"],];
CONWAYPOLDATA[11909]:=[
,,,[370453265,"RPn"],];
CONWAYPOLDATA[11923]:=[
,,,[790578366,"RPn"],];
CONWAYPOLDATA[11927]:=[
,,,[1515289574,"RPn"],];
CONWAYPOLDATA[11933]:=[
,,,[658952195,"RPn"],];
CONWAYPOLDATA[11939]:=[
,,,[561407599,"RPn"],];
CONWAYPOLDATA[11941]:=[
,,,[505868534,"RPn"],];
CONWAYPOLDATA[11953]:=[
,,,[959586845,"RPn"],];
CONWAYPOLDATA[11959]:=[
,,,[361412942,"RPn"],];
CONWAYPOLDATA[11969]:=[
,,,[670886391,"RPn"],];
CONWAYPOLDATA[11971]:=[
,,,[817427774,"RPn"],];
CONWAYPOLDATA[11981]:=[
,,,[90744096,"RPn"],];
CONWAYPOLDATA[11987]:=[
,,,[274993769,"RPn"],];
CONWAYPOLDATA[12007]:=[
,,,[562624019,"RPn"],];
CONWAYPOLDATA[12011]:=[
,,,[1410103413,"RPn"],];
CONWAYPOLDATA[12037]:=[
,,,[963248893,"RPn"],];
CONWAYPOLDATA[12041]:=[
,,,[686565782,"RPn"],];
CONWAYPOLDATA[12043]:=[
,,,[401381149,"RPn"],];
CONWAYPOLDATA[12049]:=[
,,,[5183648499,"RPn"],];
CONWAYPOLDATA[12071]:=[
,,,[998211356,"RPn"],];
CONWAYPOLDATA[12073]:=[
,,,[1270864352,"RPn"],];
CONWAYPOLDATA[12097]:=[
,,,[1832804378,"RPn"],];
CONWAYPOLDATA[12101]:=[
,,,[264346348,"RPn"],];
CONWAYPOLDATA[12107]:=[
,,,[582104562,"RPn"],];
CONWAYPOLDATA[12109]:=[
,,,[1134334799,"RPn"],];
CONWAYPOLDATA[12113]:=[
,,,[77838141,"RPn"],];
CONWAYPOLDATA[12119]:=[
,,,[1135429117,"RPn"],];
CONWAYPOLDATA[12143]:=[
,,,[419103512,"RPn"],];
CONWAYPOLDATA[12149]:=[
,,,[424729042,"RPn"],];
CONWAYPOLDATA[12157]:=[
,,,[553471741,"RPn"],];
CONWAYPOLDATA[12161]:=[
,,,[374023719,"RPn"],];
CONWAYPOLDATA[12163]:=[
,,,[395917818,"RPn"],];
CONWAYPOLDATA[12197]:=[
,,,[984968737,"RPn"],];
CONWAYPOLDATA[12203]:=[
,,,[1266927665,"RPn"],];
CONWAYPOLDATA[12211]:=[
,,,[992094908,"RPn"],];
CONWAYPOLDATA[12227]:=[
,,,[380871052,"RPn"],];
CONWAYPOLDATA[12239]:=[
,,,[440604013,"RPn"],];
CONWAYPOLDATA[12241]:=[
,,,[2194431836,"RPn"],];
CONWAYPOLDATA[12251]:=[
,,,[533298283,"RPn"],];
CONWAYPOLDATA[12253]:=[
,,,[547145464,"RPn"],];
CONWAYPOLDATA[12263]:=[
,,,[559756903,"RPn"],];
CONWAYPOLDATA[12269]:=[
,,,[683788179,"RPn"],];
CONWAYPOLDATA[12277]:=[
,,,[982516035,"RPn"],];
CONWAYPOLDATA[12281]:=[
,,,[122392449,"RPn"],];
CONWAYPOLDATA[12289]:=[
,,,[3604167087,"RPn"],];
CONWAYPOLDATA[12301]:=[
,,,[1046999617,"RPn"],];
CONWAYPOLDATA[12323]:=[
,,,[394101865,"RPn"],];
CONWAYPOLDATA[12329]:=[
,,,[1324060629,"RPn"],];
CONWAYPOLDATA[12343]:=[
,,,[136896220,"RPn"],];
CONWAYPOLDATA[12347]:=[
,,,[744672266,"RPn"],];
CONWAYPOLDATA[12373]:=[
,,,[1064226478,"RPn"],];
CONWAYPOLDATA[12377]:=[
,,,[274917930,"RPn"],];
CONWAYPOLDATA[12379]:=[
,,,[1379070118,"RPn"],];
CONWAYPOLDATA[12391]:=[
,,,[586218236,"RPn"],];
CONWAYPOLDATA[12401]:=[
,,,[153635992,"RPn"],];
CONWAYPOLDATA[12409]:=[
,,,[2577225217,"RPn"],];
CONWAYPOLDATA[12413]:=[
,,,[1003082119,"RPn"],];
CONWAYPOLDATA[12421]:=[
,,,[757842480,"RPn"],];
CONWAYPOLDATA[12433]:=[
,,,[1795648471,"RPn"],];
CONWAYPOLDATA[12437]:=[
,,,[595259696,"RPn"],];
CONWAYPOLDATA[12451]:=[
,,,[1225713796,"RPn"],];
CONWAYPOLDATA[12457]:=[
,,,[1369310821,"RPn"],];
CONWAYPOLDATA[12473]:=[
,,,[2617920554,"RPn"],];
CONWAYPOLDATA[12479]:=[
,,,[2286340008,"RPn"],];
CONWAYPOLDATA[12487]:=[
,,,[397798362,"RPn"],];
CONWAYPOLDATA[12491]:=[
,,,[1219084129,"RPn"],];
CONWAYPOLDATA[12497]:=[
,,,[4012236835,"RPn"],];
CONWAYPOLDATA[12503]:=[
,,,[1227331994,"RPn"],];
CONWAYPOLDATA[12511]:=[
,,,[1040902692,"RPn"],];
CONWAYPOLDATA[12517]:=[
,,,[1075861190,"RPn"],];
CONWAYPOLDATA[12527]:=[
,,,[286555130,"RPn"],];
CONWAYPOLDATA[12539]:=[
,,,[1364180507,"RPn"],];
CONWAYPOLDATA[12541]:=[
,,,[310113862,"RPn"],];
CONWAYPOLDATA[12547]:=[
,,,[1240509345,"RPn"],];
CONWAYPOLDATA[12553]:=[
,,,[1068536471,"RPn"],];
CONWAYPOLDATA[12569]:=[
,,,[157828936,"RPn"],];
CONWAYPOLDATA[12577]:=[
,,,[2508369467,"RPn"],];
CONWAYPOLDATA[12583]:=[
,,,[2473893303,"RPn"],];
CONWAYPOLDATA[12589]:=[
,,,[1426258168,"RPn"],];
CONWAYPOLDATA[12601]:=[
,,,[3756610131,"RPn"],];
CONWAYPOLDATA[12611]:=[
,,,[1217175889,"RPn"],];
CONWAYPOLDATA[12613]:=[
,,,[559361326,"RPn"],];
CONWAYPOLDATA[12619]:=[
,,,[433273367,"RPn"],];
CONWAYPOLDATA[12637]:=[
,,,[1079212439,"RPn"],];
CONWAYPOLDATA[12641]:=[
,,,[462749090,"RPn"],];
CONWAYPOLDATA[12647]:=[
,,,[1418664583,"RPn"],];
CONWAYPOLDATA[12653]:=[
,,,[1058258963,"RPn"],];
CONWAYPOLDATA[12659]:=[
,,,[1559044465,"RPn"],];
CONWAYPOLDATA[12671]:=[
,,,[1388006696,"RPn"],];
CONWAYPOLDATA[12689]:=[
,,,[1901814634,"RPn"],];
CONWAYPOLDATA[12697]:=[
,,,[2348424430,"RPn"],];
CONWAYPOLDATA[12703]:=[
,,,[1774926678,"RPn"],];
CONWAYPOLDATA[12713]:=[
,,,[1278991368,"RPn"],];
CONWAYPOLDATA[12721]:=[
,,,[2415094584,"RPn"],];
CONWAYPOLDATA[12739]:=[
,,,[1065375311,"RPn"],];
CONWAYPOLDATA[12743]:=[
,,,[606936352,"RPn"],];
CONWAYPOLDATA[12757]:=[
,,,[1276682291,"RPn"],];
CONWAYPOLDATA[12763]:=[
,,,[1458555642,"RPn"],];
CONWAYPOLDATA[12781]:=[
,,,[581241539,"RPn"],];
CONWAYPOLDATA[12791]:=[
,,,[651202608,"RPn"],];
CONWAYPOLDATA[12799]:=[
,,,[780380641,"RPn"],];
CONWAYPOLDATA[12809]:=[
,,,[163916776,"RPn"],];
CONWAYPOLDATA[12821]:=[
,,,[1089656792,"RPn"],];
CONWAYPOLDATA[12823]:=[
,,,[822095356,"RPn"],];
CONWAYPOLDATA[12829]:=[
,,,[1481159368,"RPn"],];
CONWAYPOLDATA[12841]:=[
,,,[3125794764,"RPn"],];
CONWAYPOLDATA[12853]:=[
,,,[1785204587,"RPn"],];
CONWAYPOLDATA[12889]:=[
,,,[165623663,"RPn"],];
CONWAYPOLDATA[12893]:=[
,,,[831095676,"RPn"],];
CONWAYPOLDATA[12899]:=[
,,,[1313311687,"RPn"],];
CONWAYPOLDATA[12907]:=[
,,,[472654342,"RPn"],];
CONWAYPOLDATA[12911]:=[
,,,[644478410,"RPn"],];
CONWAYPOLDATA[12917]:=[
,,,[1139589410,"RPn"],];
CONWAYPOLDATA[12919]:=[
,,,[825692053,"RPn"],];
CONWAYPOLDATA[12923]:=[
,,,[1462883602,"RPn"],];
CONWAYPOLDATA[12941]:=[
,,,[257318846,"RPn"],];
CONWAYPOLDATA[12953]:=[
,,,[758981038,"RPn"],];
CONWAYPOLDATA[12959]:=[
,,,[497547853,"RPn"],];
CONWAYPOLDATA[12967]:=[
,,,[1849470246,"RPn"],];
CONWAYPOLDATA[12973]:=[
,,,[620848875,"RPn"],];
CONWAYPOLDATA[12979]:=[
,,,[3534986400,"RPn"],];
CONWAYPOLDATA[12983]:=[
,,,[1124418686,"RPn"],];
CONWAYPOLDATA[13001]:=[
,,,[1124313482,"RPn"],];
CONWAYPOLDATA[13003]:=[
,,,[1183442044,"RPn"],];
CONWAYPOLDATA[13007]:=[
,,,[676676173,"RPn"],];
CONWAYPOLDATA[13009]:=[
,,,[2520766946,"RPn"],];
CONWAYPOLDATA[13033]:=[
,,,[1803988766,"RPn"],];
CONWAYPOLDATA[13037]:=[
,,,[643819210,"RPn"],];
CONWAYPOLDATA[13043]:=[
,,,[813778858,"RPn"],];
CONWAYPOLDATA[13049]:=[
,,,[170119816,"RPn"],];
CONWAYPOLDATA[13063]:=[
,,,[941424289,"RPn"],];
CONWAYPOLDATA[13093]:=[
,,,[160520186,"RPn"],];
CONWAYPOLDATA[13099]:=[
,,,[634358375,"RPn"],];
CONWAYPOLDATA[13103]:=[
,,,[1195635652,"RPn"],];
CONWAYPOLDATA[13109]:=[
,,,[659304048,"RPn"],];
CONWAYPOLDATA[13121]:=[
,,,[860685123,"RPn"],];
CONWAYPOLDATA[13127]:=[
,,,[1013955739,"RPn"],];
CONWAYPOLDATA[13147]:=[
,,,[1519319910,"RPn"],];
CONWAYPOLDATA[13151]:=[
,,,[624501550,"RPn"],];
CONWAYPOLDATA[13159]:=[
,,,[1140306307,"RPn"],];
CONWAYPOLDATA[13163]:=[
,,,[825241124,"RPn"],];
CONWAYPOLDATA[13171]:=[
,,,[292027423,"RPn"],];
CONWAYPOLDATA[13177]:=[
,,,[2252950757,"RPn"],];
CONWAYPOLDATA[13183]:=[
,,,[1164810334,"RPn"],];
CONWAYPOLDATA[13187]:=[
,,,[499127952,"RPn"],];
CONWAYPOLDATA[13217]:=[
,,,[1333225227,"RPn"],];
CONWAYPOLDATA[13219]:=[
,,,[469300941,"RPn"],];
CONWAYPOLDATA[13229]:=[
,,,[688741429,"RPn"],];
CONWAYPOLDATA[13241]:=[
,,,[175165192,"RPn"],];
CONWAYPOLDATA[13249]:=[
,,,[129455986,"RPn"],];
CONWAYPOLDATA[13259]:=[
,,,[448631530,"RPn"],];
CONWAYPOLDATA[13267]:=[
,,,[1227025032,"RPn"],];
CONWAYPOLDATA[13291]:=[
,,,[480017758,"RPn"],];
CONWAYPOLDATA[13297]:=[
,,,[2798220685,"RPn"],];
CONWAYPOLDATA[13309]:=[
,,,[2082153129,"RPn"],];
CONWAYPOLDATA[13313]:=[
,,,[4743248834,"RPn"],];
CONWAYPOLDATA[13327]:=[
,,,[1056551236,"RPn"],];
CONWAYPOLDATA[13331]:=[
,,,[1599346734,"RPn"],];
CONWAYPOLDATA[13337]:=[
,,,[4601104959,"RPn"],];
CONWAYPOLDATA[13339]:=[
,,,[1575215851,"RPn"],];
CONWAYPOLDATA[13367]:=[
,,,[1037399508,"RPn"],];
CONWAYPOLDATA[13381]:=[
,,,[1969402209,"RPn"],];
CONWAYPOLDATA[13397]:=[
,,,[4242829902,"RPn"],];
CONWAYPOLDATA[13399]:=[
,,,[897612412,"RPn"],];
CONWAYPOLDATA[13411]:=[
,,,[528152004,"RPn"],];
CONWAYPOLDATA[13417]:=[
,,,[1572901749,"RPn"],];
CONWAYPOLDATA[13421]:=[
,,,[2312639625,"RPn"],];
CONWAYPOLDATA[13441]:=[
,,,[4516256657,"RPn"],];
CONWAYPOLDATA[13451]:=[
,,,[1443023282,"RPn"],];
CONWAYPOLDATA[13457]:=[
,,,[356771987,"RPn"],];
CONWAYPOLDATA[13463]:=[
,,,[1555770822,"RPn"],];
CONWAYPOLDATA[13469]:=[
,,,[1250125237,"RPn"],];
CONWAYPOLDATA[13477]:=[
,,,[1928289162,"RPn"],];
CONWAYPOLDATA[13487]:=[
,,,[727542733,"RPn"],];
CONWAYPOLDATA[13499]:=[
,,,[522019835,"RPn"],];
CONWAYPOLDATA[13513]:=[
,,,[2365653350,"RPn"],];
CONWAYPOLDATA[13523]:=[
,,,[504610747,"RPn"],];
CONWAYPOLDATA[13537]:=[
,,,[3295785712,"RPn"],];
CONWAYPOLDATA[13553]:=[
,,,[125433018,"RPn"],];
CONWAYPOLDATA[13567]:=[
,,,[1241380503,"RPn"],];
CONWAYPOLDATA[13577]:=[
,,,[153012793,"RPn"],];
CONWAYPOLDATA[13591]:=[
,,,[477533379,"RPn"],];
CONWAYPOLDATA[13597]:=[
,,,[2340397227,"RPn"],];
CONWAYPOLDATA[13613]:=[
,,,[868427724,"RPn"],];
CONWAYPOLDATA[13619]:=[
,,,[358138845,"RPn"],];
CONWAYPOLDATA[13627]:=[
,,,[1671160774,"RPn"],];
CONWAYPOLDATA[13633]:=[
,,,[1237140223,"RPn"],];
CONWAYPOLDATA[13649]:=[
,,,[186131416,"RPn"],];
CONWAYPOLDATA[13669]:=[
,,,[1417707679,"RPn"],];
CONWAYPOLDATA[13679]:=[
,,,[2226790738,"RPn"],];
CONWAYPOLDATA[13681]:=[
,,,[2608829912,"RPn"],];
CONWAYPOLDATA[13687]:=[
,,,[1304932270,"RPn"],];
CONWAYPOLDATA[13691]:=[
,,,[290878988,"RPn"],];
CONWAYPOLDATA[13693]:=[
,,,[2040982735,"RPn"],];
CONWAYPOLDATA[13697]:=[
,,,[174486086,"RPn"],];
CONWAYPOLDATA[13709]:=[
,,,[336555952,"RPn"],];
CONWAYPOLDATA[13711]:=[
,,,[713301070,"RPn"],];
CONWAYPOLDATA[13721]:=[
,,,[561202624,"RPn"],];
CONWAYPOLDATA[13723]:=[
,,,[1694790502,"RPn"],];
CONWAYPOLDATA[13729]:=[
,,,[5413825238,"RPn"],];
CONWAYPOLDATA[13751]:=[
,,,[733272086,"RPn"],];
CONWAYPOLDATA[13757]:=[
,,,[1503337448,"RPn"],];
CONWAYPOLDATA[13759]:=[
,,,[726406411,"RPn"],];
CONWAYPOLDATA[13763]:=[
,,,[112526290,"RPn"],];
CONWAYPOLDATA[13781]:=[
,,,[736387742,"RPn"],];
CONWAYPOLDATA[13789]:=[
,,,[926179559,"RPn"],];
CONWAYPOLDATA[13799]:=[
,,,[562971609,"RPn"],];
CONWAYPOLDATA[13807]:=[
,,,[2386457113,"RPn"],];
CONWAYPOLDATA[13829]:=[
,,,[946180182,"RPn"],];
CONWAYPOLDATA[13831]:=[
,,,[676391230,"RPn"],];
CONWAYPOLDATA[13841]:=[
,,,[134603731,"RPn"],];
CONWAYPOLDATA[13859]:=[
,,,[122485844,"RPn"],];
CONWAYPOLDATA[13873]:=[
,,,[1329172135,"RPn"],];
CONWAYPOLDATA[13877]:=[
,,,[1331650799,"RPn"],];
CONWAYPOLDATA[13879]:=[
,,,[493884221,"RPn"],];
CONWAYPOLDATA[13883]:=[
,,,[120837634,"RPn"],];
CONWAYPOLDATA[13901]:=[
,,,[728759927,"RPn"],];
CONWAYPOLDATA[13903]:=[
,,,[1091872108,"RPn"],];
CONWAYPOLDATA[13907]:=[
,,,[944716419,"RPn"],];
CONWAYPOLDATA[13913]:=[
,,,[1874818492,"RPn"],];
CONWAYPOLDATA[13921]:=[
,,,[2861781740,"RPn"],];
CONWAYPOLDATA[13931]:=[
,,,[1728419172,"RPn"],];
CONWAYPOLDATA[13933]:=[
,,,[759264904,"RPn"],];
CONWAYPOLDATA[13963]:=[
,,,[517915599,"RPn"],];
CONWAYPOLDATA[13967]:=[
,,,[1357452735,"RPn"],];
CONWAYPOLDATA[13997]:=[
,,,[1303134699,"RPn"],];
CONWAYPOLDATA[13999]:=[
,,,[776860509,"RPn"],];
CONWAYPOLDATA[14009]:=[
,,,[302202151,"RPn"],];
CONWAYPOLDATA[14011]:=[
,,,[1761028581,"RPn"],];
CONWAYPOLDATA[14029]:=[
,,,[1531588023,"RPn"],];
CONWAYPOLDATA[14033]:=[
,,,[972753530,"RPn"],];
CONWAYPOLDATA[14051]:=[
,,,[1679600338,"RPn"],];
CONWAYPOLDATA[14057]:=[
,,,[2527392375,"RPn"],];
CONWAYPOLDATA[14071]:=[
,,,[582173561,"RPn"],];
CONWAYPOLDATA[14081]:=[
,,,[529980681,"RPn"],];
CONWAYPOLDATA[14083]:=[
,,,[514268914,"RPn"],];
CONWAYPOLDATA[14087]:=[
,,,[1133130111,"RPn"],];
CONWAYPOLDATA[14107]:=[
,,,[1714945671,"RPn"],];
CONWAYPOLDATA[14143]:=[
,,,[519585537,"RPn"],];
CONWAYPOLDATA[14149]:=[
,,,[573444827,"RPn"],];
CONWAYPOLDATA[14153]:=[
,,,[1536492142,"RPn"],];
CONWAYPOLDATA[14159]:=[
,,,[914175848,"RPn"],];
CONWAYPOLDATA[14173]:=[
,,,[1309160012,"RPn"],];
CONWAYPOLDATA[14177]:=[
,,,[185888827,"RPn"],];
CONWAYPOLDATA[14197]:=[
,,,[1609499704,"RPn"],];
CONWAYPOLDATA[14207]:=[
,,,[749334013,"RPn"],];
CONWAYPOLDATA[14221]:=[
,,,[2169157574,"RPn"],];
CONWAYPOLDATA[14243]:=[
,,,[1579235356,"RPn"],];
CONWAYPOLDATA[14249]:=[
,,,[723378986,"RPn"],];
CONWAYPOLDATA[14251]:=[
,,,[1122579775,"RPn"],];
CONWAYPOLDATA[14281]:=[
,,,[6710356299,"RPn"],];
CONWAYPOLDATA[14293]:=[
,,,[1562896677,"RPn"],];
CONWAYPOLDATA[14303]:=[
,,,[1010077865,"RPn"],];
CONWAYPOLDATA[14321]:=[
,,,[1613360900,"RPn"],];
CONWAYPOLDATA[14323]:=[
,,,[1435923724,"RPn"],];
CONWAYPOLDATA[14327]:=[
,,,[803228933,"RPn"],];
CONWAYPOLDATA[14341]:=[
,,,[810883165,"RPn"],];
CONWAYPOLDATA[14347]:=[
,,,[790290151,"RPn"],];
CONWAYPOLDATA[14369]:=[
,,,[206295736,"RPn"],];
CONWAYPOLDATA[14387]:=[
,,,[1619688462,"RPn"],];
CONWAYPOLDATA[14389]:=[
,,,[3901764409,"RPn"],];
CONWAYPOLDATA[14401]:=[
,,,[4291454808,"RPn"],];
CONWAYPOLDATA[14407]:=[
,,,[2470570007,"RPn"],];
CONWAYPOLDATA[14411]:=[
,,,[762774232,"RPn"],];
CONWAYPOLDATA[14419]:=[
,,,[1373957674,"RPn"],];
CONWAYPOLDATA[14423]:=[
,,,[765861305,"RPn"],];
CONWAYPOLDATA[14431]:=[
,,,[792954591,"RPn"],];
CONWAYPOLDATA[14437]:=[
,,,[1592704282,"RPn"],];
CONWAYPOLDATA[14447]:=[
,,,[1592030511,"RPn"],];
CONWAYPOLDATA[14449]:=[
,,,[8334920121,"RPn"],];
CONWAYPOLDATA[14461]:=[
,,,[733866830,"RPn"],];
CONWAYPOLDATA[14479]:=[
,,,[1048149292,"RPn"],];
CONWAYPOLDATA[14489]:=[
,,,[584515241,"RPn"],];
CONWAYPOLDATA[14503]:=[
,,,[2313591078,"RPn"],];
CONWAYPOLDATA[14519]:=[
,,,[989513420,"RPn"],];
CONWAYPOLDATA[14533]:=[
,,,[609601220,"RPn"],];
CONWAYPOLDATA[14537]:=[
,,,[1006309291,"RPn"],];
CONWAYPOLDATA[14543]:=[
,,,[540214283,"RPn"],];
CONWAYPOLDATA[14549]:=[
,,,[199001224,"RPn"],];
CONWAYPOLDATA[14551]:=[
,,,[1470087533,"RPn"],];
CONWAYPOLDATA[14557]:=[
,,,[1477011450,"RPn"],];
CONWAYPOLDATA[14561]:=[
,,,[196209481,"RPn"],];
CONWAYPOLDATA[14563]:=[
,,,[572151147,"RPn"],];
CONWAYPOLDATA[14591]:=[
,,,[1273064761,"RPn"],];
CONWAYPOLDATA[14593]:=[
,,,[3194174217,"RPn"],];
CONWAYPOLDATA[14621]:=[
,,,[1017022141,"RPn"],];
CONWAYPOLDATA[14627]:=[
,,,[1607551183,"RPn"],];
CONWAYPOLDATA[14629]:=[
,,,[124273357,"RPn"],];
CONWAYPOLDATA[14633]:=[
,,,[2065960108,"RPn"],];
CONWAYPOLDATA[14639]:=[
,,,[1710859941,"RPn"],];
CONWAYPOLDATA[14653]:=[
,,,[2711200633,"RPn"],];
CONWAYPOLDATA[14657]:=[
,,,[179694823,"RPn"],];
CONWAYPOLDATA[14669]:=[
,,,[382948916,"RPn"],];
CONWAYPOLDATA[14683]:=[
,,,[858382866,"RPn"],];
CONWAYPOLDATA[14699]:=[
,,,[1040454018,"RPn"],];
CONWAYPOLDATA[14713]:=[
,,,[3246923697,"RPn"],];
CONWAYPOLDATA[14717]:=[
,,,[1442604493,"RPn"],];
CONWAYPOLDATA[14723]:=[
,,,[1720765350,"RPn"],];
CONWAYPOLDATA[14731]:=[
,,,[626362130,"RPn"],];
CONWAYPOLDATA[14737]:=[
,,,[1453362950,"RPn"],];
CONWAYPOLDATA[14741]:=[
,,,[2126713554,"RPn"],];
CONWAYPOLDATA[14747]:=[
,,,[366285988,"RPn"],];
CONWAYPOLDATA[14753]:=[
,,,[1517095252,"RPn"],];
CONWAYPOLDATA[14759]:=[
,,,[871194269,"RPn"],];
CONWAYPOLDATA[14767]:=[
,,,[1480805229,"RPn"],];
CONWAYPOLDATA[14771]:=[
,,,[213101219,"RPn"],];
CONWAYPOLDATA[14779]:=[
,,,[579839289,"RPn"],];
CONWAYPOLDATA[14783]:=[
,,,[2363757356,"RPn"],];
CONWAYPOLDATA[14797]:=[
,,,[829179491,"RPn"],];
CONWAYPOLDATA[14813]:=[
,,,[1513384960,"RPn"],];
CONWAYPOLDATA[14821]:=[
,,,[1476260528,"RPn"],];
CONWAYPOLDATA[14827]:=[
,,,[1891243160,"RPn"],];
CONWAYPOLDATA[14831]:=[
,,,[1089574257,"RPn"],];
CONWAYPOLDATA[14843]:=[
,,,[3075009469,"RPn"],];
CONWAYPOLDATA[14851]:=[
,,,[1981836250,"RPn"],];
CONWAYPOLDATA[14867]:=[
,,,[1059675161,"RPn"],];
CONWAYPOLDATA[14869]:=[
,,,[1511850184,"RPn"],];
CONWAYPOLDATA[14879]:=[
,,,[560432421,"RPn"],];
CONWAYPOLDATA[14887]:=[
,,,[866676482,"RPn"],];
CONWAYPOLDATA[14891]:=[
,,,[1688028871,"RPn"],];
CONWAYPOLDATA[14897]:=[
,,,[392029455,"RPn"],];
CONWAYPOLDATA[14923]:=[
,,,[2362475055,"RPn"],];
CONWAYPOLDATA[14929]:=[
,,,[3707034926,"RPn"],];
CONWAYPOLDATA[14939]:=[
,,,[1754241955,"RPn"],];
CONWAYPOLDATA[14947]:=[
,,,[1977069586,"RPn"],];
CONWAYPOLDATA[14951]:=[
,,,[591775550,"RPn"],];
CONWAYPOLDATA[14957]:=[
,,,[2013301944,"RPn"],];
CONWAYPOLDATA[14969]:=[
,,,[645672849,"RPn"],];
CONWAYPOLDATA[14983]:=[
,,,[1122391516,"RPn"],];
CONWAYPOLDATA[15013]:=[
,,,[1520351499,"RPn"],];
CONWAYPOLDATA[15017]:=[
,,,[1758445652,"RPn"],];
CONWAYPOLDATA[15031]:=[
,,,[806368060,"RPn"],];
CONWAYPOLDATA[15053]:=[
,,,[1121282919,"RPn"],];
CONWAYPOLDATA[15061]:=[
,,,[2410934760,"RPn"],];
CONWAYPOLDATA[15073]:=[
,,,[3605401313,"RPn"],];
CONWAYPOLDATA[15077]:=[
,,,[2204287556,"RPn"],];
CONWAYPOLDATA[15083]:=[
,,,[117798232,"RPn"],];
CONWAYPOLDATA[15091]:=[
,,,[343214615,"RPn"],];
CONWAYPOLDATA[15101]:=[
,,,[220610511,"RPn"],];
CONWAYPOLDATA[15107]:=[
,,,[189139642,"RPn"],];
CONWAYPOLDATA[15121]:=[
,,,[5426533765,"RPn"],];
CONWAYPOLDATA[15131]:=[
,,,[2053079999,"RPn"],];
CONWAYPOLDATA[15137]:=[
,,,[182310031,"RPn"],];
CONWAYPOLDATA[15139]:=[
,,,[624180972,"RPn"],];
CONWAYPOLDATA[15149]:=[
,,,[1811987041,"RPn"],];
CONWAYPOLDATA[15161]:=[
,,,[229673992,"RPn"],];
CONWAYPOLDATA[15173]:=[
,,,[1750964202,"RPn"],];
CONWAYPOLDATA[15187]:=[
,,,[2041345420,"RPn"],];
CONWAYPOLDATA[15193]:=[
,,,[1524009835,"RPn"],];
CONWAYPOLDATA[15199]:=[
,,,[1145867815,"RPn"],];
CONWAYPOLDATA[15217]:=[
,,,[4985576154,"RPn"],];
CONWAYPOLDATA[15227]:=[
,,,[2054700928,"RPn"],];
CONWAYPOLDATA[15233]:=[
,,,[456334984,"RPn"],];
CONWAYPOLDATA[15241]:=[
,,,[3448520117,"RPn"],];
CONWAYPOLDATA[15259]:=[
,,,[610787254,"RPn"],];
CONWAYPOLDATA[15263]:=[
,,,[2007069242,"RPn"],];
CONWAYPOLDATA[15269]:=[
,,,[2313131350,"RPn"],];
CONWAYPOLDATA[15271]:=[
,,,[1562421834,"RPn"],];
CONWAYPOLDATA[15277]:=[
,,,[1801601339,"RPn"],];
CONWAYPOLDATA[15287]:=[
,,,[2034042364,"RPn"],];
CONWAYPOLDATA[15289]:=[
,,,[3952420557,"RPn"],];
CONWAYPOLDATA[15299]:=[
,,,[2064263474,"RPn"],];
CONWAYPOLDATA[15307]:=[
,,,[1400468047,"RPn"],];
CONWAYPOLDATA[15313]:=[
,,,[4923956407,"RPn"],];
CONWAYPOLDATA[15319]:=[
,,,[1855590473,"RPn"],];
CONWAYPOLDATA[15329]:=[
,,,[1795332483,"RPn"],];
CONWAYPOLDATA[15331]:=[
,,,[2005126161,"RPn"],];
CONWAYPOLDATA[15349]:=[
,,,[5344521802,"RPn"],];
CONWAYPOLDATA[15359]:=[
,,,[1585601735,"RPn"],];
CONWAYPOLDATA[15361]:=[
,,,[131874192,"RPn"],];
CONWAYPOLDATA[15373]:=[
,,,[1590828788,"RPn"],];
CONWAYPOLDATA[15377]:=[
,,,[204544857,"RPn"],];
CONWAYPOLDATA[15383]:=[
,,,[593245400,"RPn"],];
CONWAYPOLDATA[15391]:=[
,,,[2500329526,"RPn"],];
CONWAYPOLDATA[15401]:=[
,,,[1634692948,"RPn"],];
CONWAYPOLDATA[15413]:=[
,,,[854203875,"RPn"],];
CONWAYPOLDATA[15427]:=[
,,,[673465687,"RPn"],];
CONWAYPOLDATA[15439]:=[
,,,[843216427,"RPn"],];
CONWAYPOLDATA[15443]:=[
,,,[930440752,"RPn"],];
CONWAYPOLDATA[15451]:=[
,,,[1567102227,"RPn"],];
CONWAYPOLDATA[15461]:=[
,,,[951083417,"RPn"],];
CONWAYPOLDATA[15467]:=[
,,,[933990267,"RPn"],];
CONWAYPOLDATA[15473]:=[
,,,[1584295946,"RPn"],];
CONWAYPOLDATA[15493]:=[
,,,[936830729,"RPn"],];
CONWAYPOLDATA[15497]:=[
,,,[2396115149,"RPn"],];
CONWAYPOLDATA[15511]:=[
,,,[1202893564,"RPn"],];
CONWAYPOLDATA[15527]:=[
,,,[2365709252,"RPn"],];
CONWAYPOLDATA[15541]:=[
,,,[692615753,"RPn"],];
CONWAYPOLDATA[15551]:=[
,,,[857684310,"RPn"],];
CONWAYPOLDATA[15559]:=[
,,,[1641925714,"RPn"],];
CONWAYPOLDATA[15569]:=[
,,,[628240291,"RPn"],];
CONWAYPOLDATA[15581]:=[
,,,[2184798984,"RPn"],];
CONWAYPOLDATA[15583]:=[
,,,[916093409,"RPn"],];
CONWAYPOLDATA[15601]:=[
,,,[2093108188,"RPn"],];
CONWAYPOLDATA[15607]:=[
,,,[894421566,"RPn"],];
CONWAYPOLDATA[15619]:=[
,,,[1699862634,"RPn"],];
CONWAYPOLDATA[15629]:=[
,,,[2160302898,"RPn"],];
CONWAYPOLDATA[15641]:=[
,,,[646223559,"RPn"],];
CONWAYPOLDATA[15643]:=[
,,,[160528471,"RPn"],];
CONWAYPOLDATA[15647]:=[
,,,[1146048873,"RPn"],];
CONWAYPOLDATA[15649]:=[
,,,[6827783903,"RPn"],];
CONWAYPOLDATA[15661]:=[
,,,[3104104168,"RPn"],];
CONWAYPOLDATA[15667]:=[
,,,[2101900389,"RPn"],];
CONWAYPOLDATA[15671]:=[
,,,[918571349,"RPn"],];
CONWAYPOLDATA[15679]:=[
,,,[725232156,"RPn"],];
CONWAYPOLDATA[15683]:=[
,,,[722280567,"RPn"],];
CONWAYPOLDATA[15727]:=[
,,,[702226280,"RPn"],];
CONWAYPOLDATA[15731]:=[
,,,[908842796,"RPn"],];
CONWAYPOLDATA[15733]:=[
,,,[1207256028,"RPn"],];
CONWAYPOLDATA[15737]:=[
,,,[1932267548,"RPn"],];
CONWAYPOLDATA[15739]:=[
,,,[685716754,"RPn"],];
CONWAYPOLDATA[15749]:=[
,,,[2198103681,"RPn"],];
CONWAYPOLDATA[15761]:=[
,,,[623237226,"RPn"],];
CONWAYPOLDATA[15767]:=[
,,,[994330093,"RPn"],];
CONWAYPOLDATA[15773]:=[
,,,[4916191734,"RPn"],];
CONWAYPOLDATA[15787]:=[
,,,[2131418659,"RPn"],];
CONWAYPOLDATA[15791]:=[
,,,[964277444,"RPn"],];
CONWAYPOLDATA[15797]:=[
,,,[1177697946,"RPn"],];
CONWAYPOLDATA[15803]:=[
,,,[2208532464,"RPn"],];
CONWAYPOLDATA[15809]:=[
,,,[1430113761,"RPn"],];
CONWAYPOLDATA[15817]:=[
,,,[3752488353,"RPn"],];
CONWAYPOLDATA[15823]:=[
,,,[937560222,"RPn"],];
CONWAYPOLDATA[15859]:=[
,,,[2243699604,"RPn"],];
CONWAYPOLDATA[15877]:=[
,,,[1711699375,"RPn"],];
CONWAYPOLDATA[15881]:=[
,,,[1993716624,"RPn"],];
CONWAYPOLDATA[15887]:=[
,,,[1462509564,"RPn"],];
CONWAYPOLDATA[15889]:=[
,,,[4681900428,"RPn"],];
CONWAYPOLDATA[15901]:=[
,,,[888563791,"RPn"],];
CONWAYPOLDATA[15907]:=[
,,,[6301080842,"RPn"],];
CONWAYPOLDATA[15913]:=[
,,,[3211736708,"RPn"],];
CONWAYPOLDATA[15919]:=[
,,,[1773838257,"RPn"],];
CONWAYPOLDATA[15923]:=[
,,,[2965388061,"RPn"],];
CONWAYPOLDATA[15937]:=[
,,,[2176117672,"RPn"],];
CONWAYPOLDATA[15959]:=[
,,,[2235504813,"RPn"],];
CONWAYPOLDATA[15971]:=[
,,,[2262675456,"RPn"],];
CONWAYPOLDATA[15973]:=[
,,,[2544371123,"RPn"],];
CONWAYPOLDATA[15991]:=[
,,,[1782148989,"RPn"],];
CONWAYPOLDATA[16001]:=[
,,,[1208427525,"RPn"],];
CONWAYPOLDATA[16007]:=[
,,,[1455756620,"RPn"],];
CONWAYPOLDATA[16033]:=[
,,,[6342895300,"RPn"],];
CONWAYPOLDATA[16057]:=[
,,,[3743978583,"RPn"],];
CONWAYPOLDATA[16061]:=[
,,,[719099165,"RPn"],];
CONWAYPOLDATA[16063]:=[
,,,[685906168,"RPn"],];
CONWAYPOLDATA[16067]:=[
,,,[162212434,"RPn"],];
CONWAYPOLDATA[16069]:=[
,,,[2568163651,"RPn"],];
CONWAYPOLDATA[16073]:=[
,,,[1990078498,"RPn"],];
CONWAYPOLDATA[16087]:=[
,,,[1522554120,"RPn"],];
CONWAYPOLDATA[16091]:=[
,,,[767186704,"RPn"],];
CONWAYPOLDATA[16097]:=[
,,,[477791157,"RPn"],];
CONWAYPOLDATA[16103]:=[
,,,[657115126,"RPn"],];
CONWAYPOLDATA[16111]:=[
,,,[1489623067,"RPn"],];
CONWAYPOLDATA[16127]:=[
,,,[1972251470,"RPn"],];
CONWAYPOLDATA[16139]:=[
,,,[992790587,"RPn"],];
CONWAYPOLDATA[16141]:=[
,,,[2808872967,"RPn"],];
CONWAYPOLDATA[16183]:=[
,,,[1004818656,"RPn"],];
CONWAYPOLDATA[16187]:=[
,,,[761776409,"RPn"],];
CONWAYPOLDATA[16189]:=[
,,,[980956268,"RPn"],];
CONWAYPOLDATA[16193]:=[
,,,[710565038,"RPn"],];
CONWAYPOLDATA[16217]:=[
,,,[674789373,"RPn"],];
CONWAYPOLDATA[16223]:=[
,,,[3158034077,"RPn"],];
CONWAYPOLDATA[16229]:=[
,,,[432356791,"RPn"],];
CONWAYPOLDATA[16231]:=[
,,,[973454228,"RPn"],];
CONWAYPOLDATA[16249]:=[
,,,[5431520749,"RPn"],];
CONWAYPOLDATA[16253]:=[
,,,[982103780,"RPn"],];
CONWAYPOLDATA[16267]:=[
,,,[685898058,"RPn"],];
CONWAYPOLDATA[16273]:=[
,,,[3859141957,"RPn"],];
CONWAYPOLDATA[16301]:=[
,,,[952565238,"RPn"],];
CONWAYPOLDATA[16319]:=[
,,,[3162491655,"RPn"],];
CONWAYPOLDATA[16333]:=[
,,,[3426222411,"RPn"],];
CONWAYPOLDATA[16339]:=[
,,,[2297263402,"RPn"],];
CONWAYPOLDATA[16349]:=[
,,,[1863491720,"RPn"],];
CONWAYPOLDATA[16361]:=[
,,,[791021631,"RPn"],];
CONWAYPOLDATA[16363]:=[
,,,[3961956829,"RPn"],];
CONWAYPOLDATA[16369]:=[
,,,[4475661094,"RPn"],];
CONWAYPOLDATA[16381]:=[
,,,[1866500285,"RPn"],];
CONWAYPOLDATA[16411]:=[
,,,[676083970,"RPn"],];
CONWAYPOLDATA[16417]:=[
,,,[5887957060,"RPn"],];
CONWAYPOLDATA[16421]:=[
,,,[2078882181,"RPn"],];
CONWAYPOLDATA[16427]:=[
,,,[2135707126,"RPn"],];
CONWAYPOLDATA[16433]:=[
,,,[1314902931,"RPn"],];
CONWAYPOLDATA[16447]:=[
,,,[1573287129,"RPn"],];
CONWAYPOLDATA[16451]:=[
,,,[1353111208,"RPn"],];
CONWAYPOLDATA[16453]:=[
,,,[1066187308,"RPn"],];
CONWAYPOLDATA[16477]:=[
,,,[2443308424,"RPn"],];
CONWAYPOLDATA[16481]:=[
,,,[1037874500,"RPn"],];
CONWAYPOLDATA[16487]:=[
,,,[1594259931,"RPn"],];
CONWAYPOLDATA[16493]:=[
,,,[1776395060,"RPn"],];
CONWAYPOLDATA[16519]:=[
,,,[1031495920,"RPn"],];
CONWAYPOLDATA[16529]:=[
,,,[2182654453,"RPn"],];
CONWAYPOLDATA[16547]:=[
,,,[725767969,"RPn"],];
CONWAYPOLDATA[16553]:=[
,,,[2680692141,"RPn"],];
CONWAYPOLDATA[16561]:=[
,,,[3995109403,"RPn"],];
CONWAYPOLDATA[16567]:=[
,,,[996422218,"RPn"],];
CONWAYPOLDATA[16573]:=[
,,,[3454558987,"RPn"],];
CONWAYPOLDATA[16603]:=[
,,,[4672681910,"RPn"],];
CONWAYPOLDATA[16607]:=[
,,,[3022390970,"RPn"],];
CONWAYPOLDATA[16619]:=[
,,,[2183553793,"RPn"],];
CONWAYPOLDATA[16631]:=[
,,,[2382740020,"RPn"],];
CONWAYPOLDATA[16633]:=[
,,,[4038425883,"RPn"],];
CONWAYPOLDATA[16649]:=[
,,,[276989416,"RPn"],];
CONWAYPOLDATA[16651]:=[
,,,[3514493270,"RPn"],];
CONWAYPOLDATA[16657]:=[
,,,[1897248962,"RPn"],];
CONWAYPOLDATA[16661]:=[
,,,[2143321033,"RPn"],];
CONWAYPOLDATA[16673]:=[
,,,[2093045058,"RPn"],];
CONWAYPOLDATA[16691]:=[
,,,[2228548944,"RPn"],];
CONWAYPOLDATA[16693]:=[
,,,[977709012,"RPn"],];
CONWAYPOLDATA[16699]:=[
,,,[1110600396,"RPn"],];
CONWAYPOLDATA[16703]:=[
,,,[705183962,"RPn"],];
CONWAYPOLDATA[16729]:=[
,,,[4690778155,"RPn"],];
CONWAYPOLDATA[16741]:=[
,,,[3231465013,"RPn"],];
CONWAYPOLDATA[16747]:=[
,,,[836077230,"RPn"],];
CONWAYPOLDATA[16759]:=[
,,,[1911766169,"RPn"],];
CONWAYPOLDATA[16763]:=[
,,,[6122920434,"RPn"],];
CONWAYPOLDATA[16787]:=[
,,,[3833747914,"RPn"],];
CONWAYPOLDATA[16811]:=[
,,,[813921383,"RPn"],];
CONWAYPOLDATA[16823]:=[
,,,[2465040549,"RPn"],];
CONWAYPOLDATA[16829]:=[
,,,[3618335976,"RPn"],];
CONWAYPOLDATA[16831]:=[
,,,[1095058528,"RPn"],];
CONWAYPOLDATA[16843]:=[
,,,[3887633890,"RPn"],];
CONWAYPOLDATA[16871]:=[
,,,[1138387613,"RPn"],];
CONWAYPOLDATA[16879]:=[
,,,[1870429509,"RPn"],];
CONWAYPOLDATA[16883]:=[
,,,[144450950,"RPn"],];
CONWAYPOLDATA[16889]:=[
,,,[1410670617,"RPn"],];
CONWAYPOLDATA[16901]:=[
,,,[2570675904,"RPn"],];
CONWAYPOLDATA[16903]:=[
,,,[1641382721,"RPn"],];
CONWAYPOLDATA[16921]:=[
,,,[4854601075,"RPn"],];
CONWAYPOLDATA[16927]:=[
,,,[739692979,"RPn"],];
CONWAYPOLDATA[16931]:=[
,,,[801564335,"RPn"],];
CONWAYPOLDATA[16937]:=[
,,,[2174185756,"RPn"],];
CONWAYPOLDATA[16943]:=[
,,,[2162282608,"RPn"],];
CONWAYPOLDATA[16963]:=[
,,,[2553253799,"RPn"],];
CONWAYPOLDATA[16979]:=[
,,,[171487902,"RPn"],];
CONWAYPOLDATA[16981]:=[
,,,[1087514185,"RPn"],];
CONWAYPOLDATA[16987]:=[
,,,[1100180045,"RPn"],];
CONWAYPOLDATA[16993]:=[
,,,[4312500543,"RPn"],];
CONWAYPOLDATA[17011]:=[
,,,[2549659715,"RPn"],];
CONWAYPOLDATA[17021]:=[
,,,[222651703,"RPn"],];
CONWAYPOLDATA[17027]:=[
,,,[1398733998,"RPn"],];
CONWAYPOLDATA[17029]:=[
,,,[3189650913,"RPn"],];
CONWAYPOLDATA[17033]:=[
,,,[536232909,"RPn"],];
CONWAYPOLDATA[17041]:=[
,,,[277614938,"RPn"],];
CONWAYPOLDATA[17047]:=[
,,,[772587090,"RPn"],];
CONWAYPOLDATA[17053]:=[
,,,[3151718409,"RPn"],];
CONWAYPOLDATA[17077]:=[
,,,[10650275976,"RPn"],];
CONWAYPOLDATA[17093]:=[
,,,[512550700,"RPn"],];
CONWAYPOLDATA[17099]:=[
,,,[815365817,"RPn"],];
CONWAYPOLDATA[17107]:=[
,,,[874783555,"RPn"],];
CONWAYPOLDATA[17117]:=[
,,,[4348060343,"RPn"],];
CONWAYPOLDATA[17123]:=[
,,,[2295475136,"RPn"],];
CONWAYPOLDATA[17137]:=[
,,,[1960215750,"RPn"],];
CONWAYPOLDATA[17159]:=[
,,,[1172697544,"RPn"],];
CONWAYPOLDATA[17167]:=[
,,,[778162946,"RPn"],];
CONWAYPOLDATA[17183]:=[
,,,[2258997466,"RPn"],];
CONWAYPOLDATA[17189]:=[
,,,[447309349,"RPn"],];
CONWAYPOLDATA[17191]:=[
,,,[1081623341,"RPn"],];
CONWAYPOLDATA[17203]:=[
,,,[2648522273,"RPn"],];
CONWAYPOLDATA[17207]:=[
,,,[1184254573,"RPn"],];
CONWAYPOLDATA[17209]:=[
,,,[150595973,"RPn"],];
CONWAYPOLDATA[17231]:=[
,,,[1952031079,"RPn"],];
CONWAYPOLDATA[17239]:=[
,,,[1063853174,"RPn"],];
CONWAYPOLDATA[17257]:=[
,,,[3187316134,"RPn"],];
CONWAYPOLDATA[17291]:=[
,,,[456586152,"RPn"],];
CONWAYPOLDATA[17293]:=[
,,,[2334987332,"RPn"],];
CONWAYPOLDATA[17299]:=[
,,,[2680428155,"RPn"],];
CONWAYPOLDATA[17317]:=[
,,,[2053744251,"RPn"],];
CONWAYPOLDATA[17321]:=[
,,,[792522358,"RPn"],];
CONWAYPOLDATA[17327]:=[
,,,[3510814072,"RPn"],];
CONWAYPOLDATA[17333]:=[
,,,[2073806787,"RPn"],];
CONWAYPOLDATA[17341]:=[
,,,[3595205490,"RPn"],];
CONWAYPOLDATA[17351]:=[
,,,[1056727964,"RPn"],];
CONWAYPOLDATA[17359]:=[
,,,[1156126762,"RPn"],];
CONWAYPOLDATA[17377]:=[
,,,[5365426789,"RPn"],];
CONWAYPOLDATA[17383]:=[
,,,[1208605229,"RPn"],];
CONWAYPOLDATA[17387]:=[
,,,[2617143403,"RPn"],];
CONWAYPOLDATA[17389]:=[
,,,[3872895471,"RPn"],];
CONWAYPOLDATA[17393]:=[
,,,[2989926275,"RPn"],];
CONWAYPOLDATA[17401]:=[
,,,[2576339868,"RPn"],];
CONWAYPOLDATA[17417]:=[
,,,[2043937204,"RPn"],];
CONWAYPOLDATA[17419]:=[
,,,[862536626,"RPn"],];
CONWAYPOLDATA[17431]:=[
,,,[1202965606,"RPn"],];
CONWAYPOLDATA[17443]:=[
,,,[476036915,"RPn"],];
CONWAYPOLDATA[17449]:=[
,,,[6055553321,"RPn"],];
CONWAYPOLDATA[17467]:=[
,,,[848302325,"RPn"],];
CONWAYPOLDATA[17471]:=[
,,,[1696346756,"RPn"],];
CONWAYPOLDATA[17477]:=[
,,,[2024623067,"RPn"],];
CONWAYPOLDATA[17483]:=[
,,,[1207113737,"RPn"],];
CONWAYPOLDATA[17489]:=[
,,,[2057248562,"RPn"],];
CONWAYPOLDATA[17491]:=[
,,,[1112969824,"RPn"],];
CONWAYPOLDATA[17497]:=[
,,,[7242638197,"RPn"],];
CONWAYPOLDATA[17509]:=[
,,,[3937809120,"RPn"],];
CONWAYPOLDATA[17519]:=[
,,,[1212279775,"RPn"],];
CONWAYPOLDATA[17539]:=[
,,,[221956048,"RPn"],];
CONWAYPOLDATA[17551]:=[
,,,[793199897,"RPn"],];
CONWAYPOLDATA[17569]:=[
,,,[6068033938,"RPn"],];
CONWAYPOLDATA[17573]:=[
,,,[578362578,"RPn"],];
CONWAYPOLDATA[17579]:=[
,,,[2380231760,"RPn"],];
CONWAYPOLDATA[17581]:=[
,,,[1186260404,"RPn"],];
CONWAYPOLDATA[17597]:=[
,,,[1162510613,"RPn"],];
CONWAYPOLDATA[17599]:=[
,,,[3306852106,"RPn"],];
CONWAYPOLDATA[17609]:=[
,,,[309865576,"RPn"],];
CONWAYPOLDATA[17623]:=[
,,,[1110125642,"RPn"],];
CONWAYPOLDATA[17627]:=[
,,,[1412768798,"RPn"],];
CONWAYPOLDATA[17657]:=[
,,,[915815622,"RPn"],];
CONWAYPOLDATA[17659]:=[
,,,[1103157733,"RPn"],];
CONWAYPOLDATA[17669]:=[
,,,[2105190676,"RPn"],];
CONWAYPOLDATA[17681]:=[
,,,[312405592,"RPn"],];
CONWAYPOLDATA[17683]:=[
,,,[1744976128,"RPn"],];
CONWAYPOLDATA[17707]:=[
,,,[795327615,"RPn"],];
CONWAYPOLDATA[17713]:=[
,,,[3956304835,"RPn"],];
CONWAYPOLDATA[17729]:=[
,,,[314104696,"RPn"],];
CONWAYPOLDATA[17737]:=[
,,,[6519606834,"RPn"],];
CONWAYPOLDATA[17747]:=[
,,,[2709434492,"RPn"],];
CONWAYPOLDATA[17749]:=[
,,,[4963774087,"RPn"],];
CONWAYPOLDATA[17761]:=[
,,,[10358588200,"RPn"],];
CONWAYPOLDATA[17783]:=[
,,,[2074902662,"RPn"],];
CONWAYPOLDATA[17789]:=[
,,,[5880314053,"RPn"],];
CONWAYPOLDATA[17791]:=[
,,,[2114318025,"RPn"],];
CONWAYPOLDATA[17807]:=[
,,,[4432963620,"RPn"],];
CONWAYPOLDATA[17827]:=[
,,,[3696000604,"RPn"],];
CONWAYPOLDATA[17837]:=[
,,,[2483284979,"RPn"],];
CONWAYPOLDATA[17839]:=[
,,,[1265017013,"RPn"],];
CONWAYPOLDATA[17851]:=[
,,,[2796055685,"RPn"],];
CONWAYPOLDATA[17863]:=[
,,,[1246337242,"RPn"],];
CONWAYPOLDATA[17881]:=[
,,,[9441686556,"RPn"],];
CONWAYPOLDATA[17891]:=[
,,,[3739075874,"RPn"],];
CONWAYPOLDATA[17903]:=[
,,,[2237284206,"RPn"],];
CONWAYPOLDATA[17909]:=[
,,,[1192488676,"RPn"],];
CONWAYPOLDATA[17911]:=[
,,,[1141342656,"RPn"],];
CONWAYPOLDATA[17921]:=[
,,,[606177828,"RPn"],];
CONWAYPOLDATA[17923]:=[
,,,[869570193,"RPn"],];
CONWAYPOLDATA[17929]:=[
,,,[602647488,"RPn"],];
CONWAYPOLDATA[17939]:=[
,,,[489824397,"RPn"],];
CONWAYPOLDATA[17957]:=[
,,,[287832755,"RPn"],];
CONWAYPOLDATA[17959]:=[
,,,[1577338976,"RPn"],];
CONWAYPOLDATA[17971]:=[
,,,[2128503214,"RPn"],];
CONWAYPOLDATA[17977]:=[
,,,[2151936790,"RPn"],];
CONWAYPOLDATA[17981]:=[
,,,[1226142373,"RPn"],];
CONWAYPOLDATA[17987]:=[
,,,[576609264,"RPn"],];
CONWAYPOLDATA[17989]:=[
,,,[3176695501,"RPn"],];
CONWAYPOLDATA[18013]:=[
,,,[2234692782,"RPn"],];
CONWAYPOLDATA[18041]:=[
,,,[325261192,"RPn"],];
CONWAYPOLDATA[18043]:=[
,,,[2852886990,"RPn"],];
CONWAYPOLDATA[18047]:=[
,,,[1502611272,"RPn"],];
CONWAYPOLDATA[18049]:=[
,,,[5161454494,"RPn"],];
CONWAYPOLDATA[18059]:=[
,,,[1193988846,"RPn"],];
CONWAYPOLDATA[18061]:=[
,,,[826688098,"RPn"],];
CONWAYPOLDATA[18077]:=[
,,,[554620439,"RPn"],];
CONWAYPOLDATA[18089]:=[
,,,[820752200,"RPn"],];
CONWAYPOLDATA[18097]:=[
,,,[7799807005,"RPn"],];
CONWAYPOLDATA[18119]:=[
,,,[1313047709,"RPn"],];
CONWAYPOLDATA[18121]:=[
,,,[2946873285,"RPn"],];
CONWAYPOLDATA[18127]:=[
,,,[4271446283,"RPn"],];
CONWAYPOLDATA[18131]:=[
,,,[880260057,"RPn"],];
CONWAYPOLDATA[18133]:=[
,,,[2544531363,"RPn"],];
CONWAYPOLDATA[18143]:=[
,,,[1276741058,"RPn"],];
CONWAYPOLDATA[18149]:=[
,,,[1288306767,"RPn"],];
CONWAYPOLDATA[18169]:=[
,,,[12537900010,"RPn"],];
CONWAYPOLDATA[18181]:=[
,,,[4144177142,"RPn"],];
CONWAYPOLDATA[18191]:=[
,,,[1600808029,"RPn"],];
CONWAYPOLDATA[18199]:=[
,,,[1236840449,"RPn"],];
CONWAYPOLDATA[18211]:=[
,,,[2527741440,"RPn"],];
CONWAYPOLDATA[18217]:=[
,,,[6852852850,"RPn"],];
CONWAYPOLDATA[18223]:=[
,,,[5617057523,"RPn"],];
CONWAYPOLDATA[18229]:=[
,,,[2321153259,"RPn"],];
CONWAYPOLDATA[18233]:=[
,,,[2172224924,"RPn"],];
CONWAYPOLDATA[18251]:=[
,,,[1210552330,"RPn"],];
CONWAYPOLDATA[18253]:=[
,,,[1216836250,"RPn"],];
CONWAYPOLDATA[18257]:=[
,,,[4634101287,"RPn"],];
CONWAYPOLDATA[18269]:=[
,,,[515295416,"RPn"],];
CONWAYPOLDATA[18287]:=[
,,,[2595949377,"RPn"],];
CONWAYPOLDATA[18289]:=[
,,,[5529313383,"RPn"],];
CONWAYPOLDATA[18301]:=[
,,,[2344413009,"RPn"],];
CONWAYPOLDATA[18307]:=[
,,,[978417626,"RPn"],];
CONWAYPOLDATA[18311]:=[
,,,[2284169086,"RPn"],];
CONWAYPOLDATA[18313]:=[
,,,[4672543647,"RPn"],];
CONWAYPOLDATA[18329]:=[
,,,[335732296,"RPn"],];
CONWAYPOLDATA[18341]:=[
,,,[933795336,"RPn"],];
CONWAYPOLDATA[18353]:=[
,,,[303466858,"RPn"],];
CONWAYPOLDATA[18367]:=[
,,,[1867538196,"RPn"],];
CONWAYPOLDATA[18371]:=[
,,,[634148560,"RPn"],];
CONWAYPOLDATA[18379]:=[
,,,[1645563768,"RPn"],];
CONWAYPOLDATA[18397]:=[
,,,[2260237029,"RPn"],];
CONWAYPOLDATA[18401]:=[
,,,[911162320,"RPn"],];
CONWAYPOLDATA[18413]:=[
,,,[589952522,"RPn"],];
CONWAYPOLDATA[18427]:=[
,,,[2558588952,"RPn"],];
CONWAYPOLDATA[18433]:=[
,,,[2323313758,"RPn"],];
CONWAYPOLDATA[18439]:=[
,,,[1699909852,"RPn"],];
CONWAYPOLDATA[18443]:=[
,,,[956380210,"RPn"],];
CONWAYPOLDATA[18451]:=[
,,,[319460617,"RPn"],];
CONWAYPOLDATA[18457]:=[
,,,[2239775412,"RPn"],];
CONWAYPOLDATA[18461]:=[
,,,[329307320,"RPn"],];
CONWAYPOLDATA[18481]:=[
,,,[5746796330,"RPn"],];
CONWAYPOLDATA[18493]:=[
,,,[1242877546,"RPn"],];
CONWAYPOLDATA[18503]:=[
,,,[1979672981,"RPn"],];
CONWAYPOLDATA[18517]:=[
,,,[1597072739,"RPn"],];
CONWAYPOLDATA[18521]:=[
,,,[342805192,"RPn"],];
CONWAYPOLDATA[18523]:=[
,,,[934374215,"RPn"],];
CONWAYPOLDATA[18539]:=[
,,,[1996780079,"RPn"],];
CONWAYPOLDATA[18541]:=[
,,,[891080466,"RPn"],];
CONWAYPOLDATA[18553]:=[
,,,[3626944528,"RPn"],];
CONWAYPOLDATA[18583]:=[
,,,[3798458118,"RPn"],];
CONWAYPOLDATA[18587]:=[
,,,[2660598943,"RPn"],];
CONWAYPOLDATA[18593]:=[
,,,[3419736121,"RPn"],];
CONWAYPOLDATA[18617]:=[
,,,[584164229,"RPn"],];
CONWAYPOLDATA[18637]:=[
,,,[3125909464,"RPn"],];
CONWAYPOLDATA[18661]:=[
,,,[1302948352,"RPn"],];
CONWAYPOLDATA[18671]:=[
,,,[1243469936,"RPn"],];
CONWAYPOLDATA[18679]:=[
,,,[1368124682,"RPn"],];
CONWAYPOLDATA[18691]:=[
,,,[1000734834,"RPn"],];
CONWAYPOLDATA[18701]:=[
,,,[202793646,"RPn"],];
CONWAYPOLDATA[18713]:=[
,,,[2421162795,"RPn"],];
CONWAYPOLDATA[18719]:=[
,,,[1959167985,"RPn"],];
CONWAYPOLDATA[18731]:=[
,,,[2802363643,"RPn"],];
CONWAYPOLDATA[18743]:=[
,,,[2768865909,"RPn"],];
CONWAYPOLDATA[18749]:=[
,,,[6308588526,"RPn"],];
CONWAYPOLDATA[18757]:=[
,,,[2310018337,"RPn"],];
CONWAYPOLDATA[18773]:=[
,,,[4435121252,"RPn"],];
CONWAYPOLDATA[18787]:=[
,,,[4536609614,"RPn"],];
CONWAYPOLDATA[18793]:=[
,,,[2392705972,"RPn"],];
CONWAYPOLDATA[18797]:=[
,,,[1766560860,"RPn"],];
CONWAYPOLDATA[18803]:=[
,,,[2086437294,"RPn"],];
CONWAYPOLDATA[18839]:=[
,,,[989292414,"RPn"],];
CONWAYPOLDATA[18859]:=[
,,,[3037487119,"RPn"],];
CONWAYPOLDATA[18869]:=[
,,,[288997606,"RPn"],];
CONWAYPOLDATA[18899]:=[
,,,[2799282084,"RPn"],];
CONWAYPOLDATA[18911]:=[
,,,[2837746852,"RPn"],];
CONWAYPOLDATA[18913]:=[
,,,[3772973290,"RPn"],];
CONWAYPOLDATA[18917]:=[
,,,[1387410616,"RPn"],];
CONWAYPOLDATA[18919]:=[
,,,[1024274663,"RPn"],];
CONWAYPOLDATA[18947]:=[
,,,[1720993906,"RPn"],];
CONWAYPOLDATA[18959]:=[
,,,[937219219,"RPn"],];
CONWAYPOLDATA[18973]:=[
,,,[2814777363,"RPn"],];
CONWAYPOLDATA[18979]:=[
,,,[3075243288,"RPn"],];
CONWAYPOLDATA[19001]:=[
,,,[360809992,"RPn"],];
CONWAYPOLDATA[19009]:=[
,,,[7518002496,"RPn"],];
CONWAYPOLDATA[19013]:=[
,,,[917168109,"RPn"],];
CONWAYPOLDATA[19031]:=[
,,,[1405496454,"RPn"],];
CONWAYPOLDATA[19037]:=[
,,,[2482957838,"RPn"],];
CONWAYPOLDATA[19051]:=[
,,,[3261912222,"RPn"],];
CONWAYPOLDATA[19069]:=[
,,,[2754974708,"RPn"],];
CONWAYPOLDATA[19073]:=[
,,,[296985686,"RPn"],];
CONWAYPOLDATA[19079]:=[
,,,[1656247997,"RPn"],];
CONWAYPOLDATA[19081]:=[
,,,[3267621267,"RPn"],];
CONWAYPOLDATA[19087]:=[
,,,[6847556704,"RPn"],];
CONWAYPOLDATA[19121]:=[
,,,[240446581,"RPn"],];
CONWAYPOLDATA[19139]:=[
,,,[3285171074,"RPn"],];
CONWAYPOLDATA[19141]:=[
,,,[2752609789,"RPn"],];
CONWAYPOLDATA[19157]:=[
,,,[1348940157,"RPn"],];
CONWAYPOLDATA[19163]:=[
,,,[2895989214,"RPn"],];
CONWAYPOLDATA[19181]:=[
,,,[2460039976,"RPn"],];
CONWAYPOLDATA[19183]:=[
,,,[941348179,"RPn"],];
CONWAYPOLDATA[19207]:=[
,,,[3654688758,"RPn"],];
CONWAYPOLDATA[19211]:=[
,,,[2920994134,"RPn"],];
CONWAYPOLDATA[19213]:=[
,,,[621252360,"RPn"],];
CONWAYPOLDATA[19219]:=[
,,,[1039555712,"RPn"],];
CONWAYPOLDATA[19231]:=[
,,,[3948432002,"RPn"],];
CONWAYPOLDATA[19237]:=[
,,,[2421688221,"RPn"],];
CONWAYPOLDATA[19249]:=[
,,,[204751620,"RPn"],];
CONWAYPOLDATA[19259]:=[
,,,[2951461011,"RPn"],];
CONWAYPOLDATA[19267]:=[
,,,[2080335061,"RPn"],];
CONWAYPOLDATA[19273]:=[
,,,[6940496400,"RPn"],];
CONWAYPOLDATA[19289]:=[
,,,[660262473,"RPn"],];
CONWAYPOLDATA[19301]:=[
,,,[2561879635,"RPn"],];
CONWAYPOLDATA[19309]:=[
,,,[1108838640,"RPn"],];
CONWAYPOLDATA[19319]:=[
,,,[1480299067,"RPn"],];
CONWAYPOLDATA[19333]:=[
,,,[1311183395,"RPn"],];
CONWAYPOLDATA[19373]:=[
,,,[645527735,"RPn"],];
CONWAYPOLDATA[19379]:=[
,,,[1711495145,"RPn"],];
CONWAYPOLDATA[19381]:=[
,,,[1736033701,"RPn"],];
CONWAYPOLDATA[19387]:=[
,,,[4022104570,"RPn"],];
CONWAYPOLDATA[19391]:=[
,,,[2469366297,"RPn"],];
CONWAYPOLDATA[19403]:=[
,,,[960254472,"RPn"],];
CONWAYPOLDATA[19417]:=[
,,,[2562946920,"RPn"],];
CONWAYPOLDATA[19421]:=[
,,,[648001089,"RPn"],];
CONWAYPOLDATA[19423]:=[
,,,[2175220619,"RPn"],];
CONWAYPOLDATA[19427]:=[
,,,[7778357105,"RPn"],];
CONWAYPOLDATA[19429]:=[
,,,[217818525,"RPn"],];
CONWAYPOLDATA[19433]:=[
,,,[257953645,"RPn"],];
CONWAYPOLDATA[19441]:=[
,,,[5564266946,"RPn"],];
CONWAYPOLDATA[19447]:=[
,,,[2251962603,"RPn"],];
CONWAYPOLDATA[19457]:=[
,,,[750495407,"RPn"],];
CONWAYPOLDATA[19463]:=[
,,,[1460386747,"RPn"],];
CONWAYPOLDATA[19469]:=[
,,,[4878950871,"RPn"],];
CONWAYPOLDATA[19471]:=[
,,,[2566219398,"RPn"],];
CONWAYPOLDATA[19477]:=[
,,,[2559102513,"RPn"],];
CONWAYPOLDATA[19483]:=[
,,,[7889387573,"RPn"],];
CONWAYPOLDATA[19489]:=[
,,,[8631463740,"RPn"],];
CONWAYPOLDATA[19501]:=[
,,,[2980571844,"RPn"],];
CONWAYPOLDATA[19507]:=[
,,,[1100975082,"RPn"],];
CONWAYPOLDATA[19531]:=[
,,,[3432905290,"RPn"],];
CONWAYPOLDATA[19541]:=[
,,,[4866138904,"RPn"],];
CONWAYPOLDATA[19543]:=[
,,,[1020887237,"RPn"],];
CONWAYPOLDATA[19553]:=[
,,,[1818839616,"RPn"],];
CONWAYPOLDATA[19559]:=[
,,,[1480753226,"RPn"],];
CONWAYPOLDATA[19571]:=[
,,,[3675942648,"RPn"],];
CONWAYPOLDATA[19577]:=[
,,,[1885304257,"RPn"],];
CONWAYPOLDATA[19583]:=[
,,,[1139867686,"RPn"],];
CONWAYPOLDATA[19597]:=[
,,,[4980283597,"RPn"],];
CONWAYPOLDATA[19603]:=[
,,,[3458361262,"RPn"],];
CONWAYPOLDATA[19609]:=[
,,,[383748143,"RPn"],];
CONWAYPOLDATA[19661]:=[
,,,[1892351591,"RPn"],];
CONWAYPOLDATA[19681]:=[
,,,[11904210309,"RPn"],];
CONWAYPOLDATA[19687]:=[
,,,[1008663450,"RPn"],];
CONWAYPOLDATA[19697]:=[
,,,[1932039339,"RPn"],];
CONWAYPOLDATA[19699]:=[
,,,[2576136732,"RPn"],];
CONWAYPOLDATA[19709]:=[
,,,[3713904835,"RPn"],];
CONWAYPOLDATA[19717]:=[
,,,[2540574886,"RPn"],];
CONWAYPOLDATA[19727]:=[
,,,[1556539213,"RPn"],];
CONWAYPOLDATA[19739]:=[
,,,[1047430298,"RPn"],];
CONWAYPOLDATA[19751]:=[
,,,[1423829846,"RPn"],];
CONWAYPOLDATA[19753]:=[
,,,[5852497857,"RPn"],];
CONWAYPOLDATA[19759]:=[
,,,[1401347801,"RPn"],];
CONWAYPOLDATA[19763]:=[
,,,[224527445,"RPn"],];
CONWAYPOLDATA[19777]:=[
,,,[5084290948,"RPn"],];
CONWAYPOLDATA[19793]:=[
,,,[1103479546,"RPn"],];
CONWAYPOLDATA[19801]:=[
,,,[9729280766,"RPn"],];
CONWAYPOLDATA[19813]:=[
,,,[1551100333,"RPn"],];
CONWAYPOLDATA[19819]:=[
,,,[1114144907,"RPn"],];
CONWAYPOLDATA[19841]:=[
,,,[2958253421,"RPn"],];
CONWAYPOLDATA[19843]:=[
,,,[4238821993,"RPn"],];
CONWAYPOLDATA[19853]:=[
,,,[312347251,"RPn"],];
CONWAYPOLDATA[19861]:=[
,,,[388203117,"RPn"],];
CONWAYPOLDATA[19867]:=[
,,,[3504757339,"RPn"],];
CONWAYPOLDATA[19889]:=[
,,,[395333656,"RPn"],];
CONWAYPOLDATA[19891]:=[
,,,[3397024764,"RPn"],];
CONWAYPOLDATA[19913]:=[
,,,[3771223508,"RPn"],];
CONWAYPOLDATA[19919]:=[
,,,[2603931201,"RPn"],];
CONWAYPOLDATA[19927]:=[
,,,[3118555579,"RPn"],];
CONWAYPOLDATA[19937]:=[
,,,[3413234340,"RPn"],];
CONWAYPOLDATA[19949]:=[
,,,[1558156545,"RPn"],];
CONWAYPOLDATA[19961]:=[
,,,[1839945103,"RPn"],];
CONWAYPOLDATA[19963]:=[
,,,[4683858803,"RPn"],];
CONWAYPOLDATA[19973]:=[
,,,[2999505196,"RPn"],];
CONWAYPOLDATA[19979]:=[
,,,[3140678823,"RPn"],];
CONWAYPOLDATA[19991]:=[
,,,[1473616585,"RPn"],];
CONWAYPOLDATA[19993]:=[
,,,[3410026083,"RPn"],];
CONWAYPOLDATA[19997]:=[
,,,[1533929878,"RPn"],];
CONWAYPOLDATA[20011]:=[
,,,[1511931117,"RPn"],];
CONWAYPOLDATA[20021]:=[
,,,[2004122124,"RPn"],];
CONWAYPOLDATA[20023]:=[
,,,[2004522556,"RPn"],];
CONWAYPOLDATA[20029]:=[
,,,[2762419711,"RPn"],];
CONWAYPOLDATA[20047]:=[
,,,[2626638131,"RPn"],];
CONWAYPOLDATA[20051]:=[
,,,[2720559784,"RPn"],];
CONWAYPOLDATA[20063]:=[
,,,[2363441468,"RPn"],];
CONWAYPOLDATA[20071]:=[
,,,[1480517247,"RPn"],];
CONWAYPOLDATA[20089]:=[
,,,[1132155780,"RPn"],];
CONWAYPOLDATA[20101]:=[
,,,[8016580321,"RPn"],];
CONWAYPOLDATA[20107]:=[
,,,[3638482294,"RPn"],];
CONWAYPOLDATA[20113]:=[
,,,[6869494595,"RPn"],];
CONWAYPOLDATA[20117]:=[
,,,[1155258961,"RPn"],];
CONWAYPOLDATA[20123]:=[
,,,[3644275302,"RPn"],];
CONWAYPOLDATA[20129]:=[
,,,[1907202624,"RPn"],];
CONWAYPOLDATA[20143]:=[
,,,[1534292315,"RPn"],];
CONWAYPOLDATA[20147]:=[
,,,[1142314759,"RPn"],];
CONWAYPOLDATA[20149]:=[
,,,[1446718351,"RPn"],];
CONWAYPOLDATA[20161]:=[
,,,[9162489039,"RPn"],];
CONWAYPOLDATA[20173]:=[
,,,[1475997893,"RPn"],];
CONWAYPOLDATA[20177]:=[
,,,[3920734112,"RPn"],];
CONWAYPOLDATA[20183]:=[
,,,[791234154,"RPn"],];
CONWAYPOLDATA[20201]:=[
,,,[303095810,"RPn"],];
CONWAYPOLDATA[20219]:=[
,,,[1040146238,"RPn"],];
CONWAYPOLDATA[20231]:=[
,,,[1614696832,"RPn"],];
CONWAYPOLDATA[20233]:=[
,,,[4425624794,"RPn"],];
CONWAYPOLDATA[20249]:=[
,,,[409779016,"RPn"],];
CONWAYPOLDATA[20261]:=[
,,,[1603881023,"RPn"],];
CONWAYPOLDATA[20269]:=[
,,,[2852030723,"RPn"],];
CONWAYPOLDATA[20287]:=[
,,,[1470462626,"RPn"],];
CONWAYPOLDATA[20297]:=[
,,,[4784104388,"RPn"],];
CONWAYPOLDATA[20323]:=[
,,,[3694965278,"RPn"],];
CONWAYPOLDATA[20327]:=[
,,,[1652666413,"RPn"],];
CONWAYPOLDATA[20333]:=[
,,,[1139562988,"RPn"],];
CONWAYPOLDATA[20341]:=[
,,,[1451391375,"RPn"],];
CONWAYPOLDATA[20347]:=[
,,,[1054198420,"RPn"],];
CONWAYPOLDATA[20353]:=[
,,,[6622886558,"RPn"],];
CONWAYPOLDATA[20357]:=[
,,,[8123949420,"RPn"],];
CONWAYPOLDATA[20359]:=[
,,,[2050130952,"RPn"],];
CONWAYPOLDATA[20369]:=[
,,,[1121557881,"RPn"],];
CONWAYPOLDATA[20389]:=[
,,,[1053907416,"RPn"],];
CONWAYPOLDATA[20393]:=[
,,,[3161486007,"RPn"],];
CONWAYPOLDATA[20399]:=[
,,,[2295642270,"RPn"],];
CONWAYPOLDATA[20407]:=[
,,,[1665700973,"RPn"],];
CONWAYPOLDATA[20411]:=[
,,,[2305259168,"RPn"],];
CONWAYPOLDATA[20431]:=[
,,,[2087047084,"RPn"],];
CONWAYPOLDATA[20441]:=[
,,,[417589192,"RPn"],];
CONWAYPOLDATA[20443]:=[
,,,[1171179472,"RPn"],];
CONWAYPOLDATA[20477]:=[
,,,[3188391764,"RPn"],];
CONWAYPOLDATA[20479]:=[
,,,[1176846217,"RPn"],];
CONWAYPOLDATA[20483]:=[
,,,[1678131229,"RPn"],];
CONWAYPOLDATA[20507]:=[
,,,[3170833356,"RPn"],];
CONWAYPOLDATA[20509]:=[
,,,[2765002873,"RPn"],];
CONWAYPOLDATA[20521]:=[
,,,[8689576419,"RPn"],];
CONWAYPOLDATA[20533]:=[
,,,[5320777891,"RPn"],];
CONWAYPOLDATA[20543]:=[
,,,[2791547189,"RPn"],];
CONWAYPOLDATA[20549]:=[
,,,[5318142849,"RPn"],];
CONWAYPOLDATA[20551]:=[
,,,[1505484059,"RPn"],];
CONWAYPOLDATA[20563]:=[
,,,[1539407872,"RPn"],];
CONWAYPOLDATA[20593]:=[
,,,[5313858911,"RPn"],];
CONWAYPOLDATA[20599]:=[
,,,[1268774809,"RPn"],];
CONWAYPOLDATA[20611]:=[
,,,[1256199230,"RPn"],];
CONWAYPOLDATA[20627]:=[
,,,[1082360573,"RPn"],];
CONWAYPOLDATA[20639]:=[
,,,[2955257143,"RPn"],];
CONWAYPOLDATA[20641]:=[
,,,[370650444,"RPn"],];
CONWAYPOLDATA[20663]:=[
,,,[1590410452,"RPn"],];
CONWAYPOLDATA[20681]:=[
,,,[1092535871,"RPn"],];
CONWAYPOLDATA[20693]:=[
,,,[4088791951,"RPn"],];
CONWAYPOLDATA[20707]:=[
,,,[1715036573,"RPn"],];
CONWAYPOLDATA[20717]:=[
,,,[2976867166,"RPn"],];
CONWAYPOLDATA[20719]:=[
,,,[1639453035,"RPn"],];
CONWAYPOLDATA[20731]:=[
,,,[3758053489,"RPn"],];
CONWAYPOLDATA[20743]:=[
,,,[2427117692,"RPn"],];
CONWAYPOLDATA[20747]:=[
,,,[3839999994,"RPn"],];
CONWAYPOLDATA[20749]:=[
,,,[4648439970,"RPn"],];
CONWAYPOLDATA[20753]:=[
,,,[314013646,"RPn"],];
CONWAYPOLDATA[20759]:=[
,,,[1225528331,"RPn"],];
CONWAYPOLDATA[20771]:=[
,,,[3677007048,"RPn"],];
CONWAYPOLDATA[20773]:=[
,,,[4551073480,"RPn"],];
CONWAYPOLDATA[20789]:=[
,,,[754640702,"RPn"],];
CONWAYPOLDATA[20807]:=[
,,,[1731641773,"RPn"],];
CONWAYPOLDATA[20809]:=[
,,,[364760968,"RPn"],];
CONWAYPOLDATA[20849]:=[
,,,[434430616,"RPn"],];
CONWAYPOLDATA[20857]:=[
,,,[6467588854,"RPn"],];
CONWAYPOLDATA[20873]:=[
,,,[403767315,"RPn"],];
CONWAYPOLDATA[20879]:=[
,,,[3305667686,"RPn"],];
CONWAYPOLDATA[20887]:=[
,,,[2985629557,"RPn"],];
CONWAYPOLDATA[20897]:=[
,,,[391170946,"RPn"],];
CONWAYPOLDATA[20899]:=[
,,,[3726291702,"RPn"],];
CONWAYPOLDATA[20903]:=[
,,,[1747658029,"RPn"],];
CONWAYPOLDATA[20921]:=[
,,,[437437192,"RPn"],];
CONWAYPOLDATA[20929]:=[
,,,[6451720050,"RPn"],];
CONWAYPOLDATA[20939]:=[
,,,[1569461808,"RPn"],];
CONWAYPOLDATA[20947]:=[
,,,[3878672205,"RPn"],];
CONWAYPOLDATA[20959]:=[
,,,[378666260,"RPn"],];
CONWAYPOLDATA[20963]:=[
,,,[7904790931,"RPn"],];
CONWAYPOLDATA[20981]:=[
,,,[3009178946,"RPn"],];
CONWAYPOLDATA[20983]:=[
,,,[1109706941,"RPn"],];
CONWAYPOLDATA[21001]:=[
,,,[9057815315,"RPn"],];
CONWAYPOLDATA[21011]:=[
,,,[704036590,"RPn"],];
CONWAYPOLDATA[21013]:=[
,,,[2982143949,"RPn"],];
CONWAYPOLDATA[21017]:=[
,,,[5120392730,"RPn"],];
CONWAYPOLDATA[21019]:=[
,,,[3008911890,"RPn"],];
CONWAYPOLDATA[21023]:=[
,,,[2151199503,"RPn"],];
CONWAYPOLDATA[21031]:=[
,,,[1128733782,"RPn"],];
CONWAYPOLDATA[21059]:=[
,,,[1260023149,"RPn"],];
CONWAYPOLDATA[21061]:=[
,,,[2076172326,"RPn"],];
CONWAYPOLDATA[21067]:=[
,,,[3907717832,"RPn"],];
CONWAYPOLDATA[21089]:=[
,,,[2011173577,"RPn"],];
CONWAYPOLDATA[21101]:=[
,,,[4267592848,"RPn"],];
CONWAYPOLDATA[21107]:=[
,,,[394468725,"RPn"],];
CONWAYPOLDATA[21121]:=[
,,,[22537648852,"RPn"],];
CONWAYPOLDATA[21139]:=[
,,,[3419930839,"RPn"],];
CONWAYPOLDATA[21143]:=[
,,,[2591011231,"RPn"],];
CONWAYPOLDATA[21149]:=[
,,,[4919913022,"RPn"],];
CONWAYPOLDATA[21157]:=[
,,,[3414485918,"RPn"],];
CONWAYPOLDATA[21163]:=[
,,,[3824535036,"RPn"],];
CONWAYPOLDATA[21169]:=[
,,,[447300983,"RPn"],];
CONWAYPOLDATA[21179]:=[
,,,[3420853261,"RPn"],];
CONWAYPOLDATA[21187]:=[
,,,[1289885749,"RPn"],];
CONWAYPOLDATA[21191]:=[
,,,[1791868585,"RPn"],];
CONWAYPOLDATA[21193]:=[
,,,[2984970482,"RPn"],];
CONWAYPOLDATA[21211]:=[
,,,[4038913778,"RPn"],];
CONWAYPOLDATA[21221]:=[
,,,[3087103756,"RPn"],];
CONWAYPOLDATA[21227]:=[
,,,[6196904247,"RPn"],];
CONWAYPOLDATA[21247]:=[
,,,[10693976302,"RPn"],];
CONWAYPOLDATA[21269]:=[
,,,[739438056,"RPn"],];
CONWAYPOLDATA[21277]:=[
,,,[3862349985,"RPn"],];
CONWAYPOLDATA[21283]:=[
,,,[3165378035,"RPn"],];
CONWAYPOLDATA[21313]:=[
,,,[2963913663,"RPn"],];
CONWAYPOLDATA[21317]:=[
,,,[2201236056,"RPn"],];
CONWAYPOLDATA[21319]:=[
,,,[2072697151,"RPn"],];
CONWAYPOLDATA[21323]:=[
,,,[329696231,"RPn"],];
CONWAYPOLDATA[21341]:=[
,,,[2070674550,"RPn"],];
CONWAYPOLDATA[21347]:=[
,,,[3606725081,"RPn"],];
CONWAYPOLDATA[21377]:=[
,,,[1350192700,"RPn"],];
CONWAYPOLDATA[21379]:=[
,,,[3887728394,"RPn"],];
CONWAYPOLDATA[21383]:=[
,,,[2076503135,"RPn"],];
CONWAYPOLDATA[21391]:=[
,,,[1750168844,"RPn"],];
CONWAYPOLDATA[21397]:=[
,,,[1735467878,"RPn"],];
CONWAYPOLDATA[21401]:=[
,,,[825971598,"RPn"],];
CONWAYPOLDATA[21407]:=[
,,,[1252266691,"RPn"],];
CONWAYPOLDATA[21419]:=[
,,,[3552898046,"RPn"],];
CONWAYPOLDATA[21433]:=[
,,,[9116055029,"RPn"],];
CONWAYPOLDATA[21467]:=[
,,,[2182142019,"RPn"],];
CONWAYPOLDATA[21481]:=[
,,,[6700375014,"RPn"],];
CONWAYPOLDATA[21487]:=[
,,,[3201627464,"RPn"],];
CONWAYPOLDATA[21491]:=[
,,,[1762562876,"RPn"],];
CONWAYPOLDATA[21493]:=[
,,,[1718107436,"RPn"],];
CONWAYPOLDATA[21499]:=[
,,,[2609656118,"RPn"],];
CONWAYPOLDATA[21503]:=[
,,,[2152106257,"RPn"],];
CONWAYPOLDATA[21517]:=[
,,,[3604140539,"RPn"],];
CONWAYPOLDATA[21521]:=[
,,,[1267307130,"RPn"],];
CONWAYPOLDATA[21523]:=[
,,,[3694530567,"RPn"],];
CONWAYPOLDATA[21529]:=[
,,,[9604905013,"RPn"],];
CONWAYPOLDATA[21557]:=[
,,,[3523426981,"RPn"],];
CONWAYPOLDATA[21559]:=[
,,,[1288150265,"RPn"],];
CONWAYPOLDATA[21563]:=[
,,,[4184515782,"RPn"],];
CONWAYPOLDATA[21569]:=[
,,,[1360248988,"RPn"],];
CONWAYPOLDATA[21577]:=[
,,,[3061085841,"RPn"],];
CONWAYPOLDATA[21587]:=[
,,,[5003391688,"RPn"],];
CONWAYPOLDATA[21589]:=[
,,,[5865839247,"RPn"],];
CONWAYPOLDATA[21599]:=[
,,,[1266910951,"RPn"],];
CONWAYPOLDATA[21601]:=[
,,,[395471115,"RPn"],];
CONWAYPOLDATA[21611]:=[
,,,[4190610623,"RPn"],];
CONWAYPOLDATA[21613]:=[
,,,[3263498163,"RPn"],];
CONWAYPOLDATA[21617]:=[
,,,[445504756,"RPn"],];
CONWAYPOLDATA[21647]:=[
,,,[2174614331,"RPn"],];
CONWAYPOLDATA[21649]:=[
,,,[4924714534,"RPn"],];
CONWAYPOLDATA[21661]:=[
,,,[1854939737,"RPn"],];
CONWAYPOLDATA[21673]:=[
,,,[10114680745,"RPn"],];
CONWAYPOLDATA[21683]:=[
,,,[3755690749,"RPn"],];
CONWAYPOLDATA[21701]:=[
,,,[3539324597,"RPn"],];
CONWAYPOLDATA[21713]:=[
,,,[246464266,"RPn"],];
CONWAYPOLDATA[21727]:=[
,,,[2815428117,"RPn"],];
CONWAYPOLDATA[21737]:=[
,,,[4118791977,"RPn"],];
CONWAYPOLDATA[21739]:=[
,,,[4231996349,"RPn"],];
CONWAYPOLDATA[21751]:=[
,,,[1828911087,"RPn"],];
CONWAYPOLDATA[21757]:=[
,,,[1860897972,"RPn"],];
CONWAYPOLDATA[21767]:=[
,,,[1678039802,"RPn"],];
CONWAYPOLDATA[21773]:=[
,,,[779342764,"RPn"],];
CONWAYPOLDATA[21787]:=[
,,,[5603877867,"RPn"],];
CONWAYPOLDATA[21799]:=[
,,,[2640076897,"RPn"],];
CONWAYPOLDATA[21803]:=[
,,,[2204653953,"RPn"],];
CONWAYPOLDATA[21817]:=[
,,,[10836503907,"RPn"],];
CONWAYPOLDATA[21821]:=[
,,,[3199525948,"RPn"],];
CONWAYPOLDATA[21839]:=[
,,,[2710722208,"RPn"],];
CONWAYPOLDATA[21841]:=[
,,,[11925317057,"RPn"],];
CONWAYPOLDATA[21851]:=[
,,,[349441198,"RPn"],];
CONWAYPOLDATA[21859]:=[
,,,[1321354693,"RPn"],];
CONWAYPOLDATA[21863]:=[
,,,[2802727290,"RPn"],];
CONWAYPOLDATA[21871]:=[
,,,[1330412936,"RPn"],];
CONWAYPOLDATA[21881]:=[
,,,[1200566711,"RPn"],];
CONWAYPOLDATA[21893]:=[
,,,[1885972487,"RPn"],];
CONWAYPOLDATA[21911]:=[
,,,[1329099362,"RPn"],];
CONWAYPOLDATA[21929]:=[
,,,[1374992161,"RPn"],];
CONWAYPOLDATA[21937]:=[
,,,[6203827481,"RPn"],];
CONWAYPOLDATA[21943]:=[
,,,[5777679677,"RPn"],];
CONWAYPOLDATA[21961]:=[
,,,[14883123444,"RPn"],];
CONWAYPOLDATA[21977]:=[
,,,[403717493,"RPn"],];
CONWAYPOLDATA[21991]:=[
,,,[1836094566,"RPn"],];
CONWAYPOLDATA[21997]:=[
,,,[2344374276,"RPn"],];
CONWAYPOLDATA[22003]:=[
,,,[4318022743,"RPn"],];
CONWAYPOLDATA[22013]:=[
,,,[1701891071,"RPn"],];
CONWAYPOLDATA[22027]:=[
,,,[1826148438,"RPn"],];
CONWAYPOLDATA[22031]:=[
,,,[2426626533,"RPn"],];
CONWAYPOLDATA[22037]:=[
,,,[3831881710,"RPn"],];
CONWAYPOLDATA[22039]:=[
,,,[1876620856,"RPn"],];
CONWAYPOLDATA[22051]:=[
,,,[1236774440,"RPn"],];
CONWAYPOLDATA[22063]:=[
,,,[4826435696,"RPn"],];
CONWAYPOLDATA[22067]:=[
,,,[1366874116,"RPn"],];
CONWAYPOLDATA[22073]:=[
,,,[4731656575,"RPn"],];
CONWAYPOLDATA[22079]:=[
,,,[6147809241,"RPn"],];
CONWAYPOLDATA[22091]:=[
,,,[1265968939,"RPn"],];
CONWAYPOLDATA[22093]:=[
,,,[4342887295,"RPn"],];
CONWAYPOLDATA[22109]:=[
,,,[1872521757,"RPn"],];
CONWAYPOLDATA[22111]:=[
,,,[1926177660,"RPn"],];
CONWAYPOLDATA[22123]:=[
,,,[8712966568,"RPn"],];
CONWAYPOLDATA[22129]:=[
,,,[8147654400,"RPn"],];
CONWAYPOLDATA[22133]:=[
,,,[843178770,"RPn"],];
CONWAYPOLDATA[22147]:=[
,,,[12132857456,"RPn"],];
CONWAYPOLDATA[22153]:=[
,,,[3195858244,"RPn"],];
CONWAYPOLDATA[22157]:=[
,,,[3369259893,"RPn"],];
CONWAYPOLDATA[22159]:=[
,,,[1460721286,"RPn"],];
CONWAYPOLDATA[22171]:=[
,,,[4288226138,"RPn"],];
CONWAYPOLDATA[22189]:=[
,,,[13604209036,"RPn"],];
CONWAYPOLDATA[22193]:=[
,,,[3229347819,"RPn"],];
CONWAYPOLDATA[22229]:=[
,,,[341926480,"RPn"],];
CONWAYPOLDATA[22247]:=[
,,,[10290750301,"RPn"],];
CONWAYPOLDATA[22259]:=[
,,,[7713010610,"RPn"],];
CONWAYPOLDATA[22271]:=[
,,,[1279424415,"RPn"],];
CONWAYPOLDATA[22273]:=[
,,,[5452252221,"RPn"],];
CONWAYPOLDATA[22277]:=[
,,,[919304961,"RPn"],];
CONWAYPOLDATA[22279]:=[
,,,[3314892413,"RPn"],];
CONWAYPOLDATA[22283]:=[
,,,[2406809115,"RPn"],];
CONWAYPOLDATA[22291]:=[
,,,[2935457211,"RPn"],];
CONWAYPOLDATA[22303]:=[
,,,[2418291993,"RPn"],];
CONWAYPOLDATA[22307]:=[
,,,[434651897,"RPn"],];
CONWAYPOLDATA[22343]:=[
,,,[3958017769,"RPn"],];
CONWAYPOLDATA[22349]:=[
,,,[773141308,"RPn"],];
CONWAYPOLDATA[22367]:=[
,,,[2001041293,"RPn"],];
CONWAYPOLDATA[22369]:=[
,,,[11456842586,"RPn"],];
CONWAYPOLDATA[22381]:=[
,,,[4957436272,"RPn"],];
CONWAYPOLDATA[22391]:=[
,,,[4436619926,"RPn"],];
CONWAYPOLDATA[22397]:=[
,,,[3906798300,"RPn"],];
CONWAYPOLDATA[22409]:=[
,,,[3779748442,"RPn"],];
CONWAYPOLDATA[22433]:=[
,,,[475736634,"RPn"],];
CONWAYPOLDATA[22441]:=[
,,,[5378815981,"RPn"],];
CONWAYPOLDATA[22447]:=[
,,,[2884910890,"RPn"],];
CONWAYPOLDATA[22453]:=[
,,,[3788741678,"RPn"],];
CONWAYPOLDATA[22469]:=[
,,,[3453934682,"RPn"],];
CONWAYPOLDATA[22481]:=[
,,,[4002854458,"RPn"],];
CONWAYPOLDATA[22483]:=[
,,,[798506230,"RPn"],];
CONWAYPOLDATA[22501]:=[
,,,[1794229742,"RPn"],];
CONWAYPOLDATA[22511]:=[
,,,[2965554129,"RPn"],];
CONWAYPOLDATA[22531]:=[
,,,[1517079825,"RPn"],];
CONWAYPOLDATA[22541]:=[
,,,[5588883166,"RPn"],];
CONWAYPOLDATA[22543]:=[
,,,[3515716111,"RPn"],];
CONWAYPOLDATA[22549]:=[
,,,[3484632266,"RPn"],];
CONWAYPOLDATA[22567]:=[
,,,[7976283586,"RPn"],];
CONWAYPOLDATA[22571]:=[
,,,[4075374624,"RPn"],];
CONWAYPOLDATA[22573]:=[
,,,[3350420104,"RPn"],];
CONWAYPOLDATA[22613]:=[
,,,[1320327846,"RPn"],];
CONWAYPOLDATA[22619]:=[
,,,[434194326,"RPn"],];
CONWAYPOLDATA[22621]:=[
,,,[3534214558,"RPn"],];
CONWAYPOLDATA[22637]:=[
,,,[915666652,"RPn"],];
CONWAYPOLDATA[22639]:=[
,,,[1524827212,"RPn"],];
CONWAYPOLDATA[22643]:=[
,,,[3914680343,"RPn"],];
CONWAYPOLDATA[22651]:=[
,,,[1416525590,"RPn"],];
CONWAYPOLDATA[22669]:=[
,,,[3955332460,"RPn"],];
CONWAYPOLDATA[22679]:=[
,,,[1844415046,"RPn"],];
CONWAYPOLDATA[22691]:=[
,,,[4577977325,"RPn"],];
CONWAYPOLDATA[22697]:=[
,,,[1018459787,"RPn"],];
CONWAYPOLDATA[22699]:=[
,,,[1475480410,"RPn"],];
CONWAYPOLDATA[22709]:=[
,,,[8229809729,"RPn"],];
CONWAYPOLDATA[22717]:=[
,,,[3604778996,"RPn"],];
CONWAYPOLDATA[22721]:=[
,,,[4068876683,"RPn"],];
CONWAYPOLDATA[22727]:=[
,,,[1845614221,"RPn"],];
CONWAYPOLDATA[22739]:=[
,,,[2345482374,"RPn"],];
CONWAYPOLDATA[22741]:=[
,,,[5046182425,"RPn"],];
CONWAYPOLDATA[22751]:=[
,,,[1970737143,"RPn"],];
CONWAYPOLDATA[22769]:=[
,,,[4014265779,"RPn"],];
CONWAYPOLDATA[22777]:=[
,,,[5486091004,"RPn"],];
CONWAYPOLDATA[22783]:=[
,,,[3094045318,"RPn"],];
CONWAYPOLDATA[22787]:=[
,,,[3904529665,"RPn"],];
CONWAYPOLDATA[22807]:=[
,,,[2600705020,"RPn"],];
CONWAYPOLDATA[22811]:=[
,,,[3108705897,"RPn"],];
CONWAYPOLDATA[22817]:=[
,,,[814384367,"RPn"],];
CONWAYPOLDATA[22853]:=[
,,,[3400914903,"RPn"],];
CONWAYPOLDATA[22859]:=[
,,,[300938737,"RPn"],];
CONWAYPOLDATA[22861]:=[
,,,[3927611246,"RPn"],];
CONWAYPOLDATA[22871]:=[
,,,[2615207373,"RPn"],];
CONWAYPOLDATA[22877]:=[
,,,[3501942531,"RPn"],];
CONWAYPOLDATA[22901]:=[
,,,[4185844782,"RPn"],];
CONWAYPOLDATA[22907]:=[
,,,[2016732285,"RPn"],];
CONWAYPOLDATA[22921]:=[
,,,[414870107,"RPn"],];
CONWAYPOLDATA[22937]:=[
,,,[3447316418,"RPn"],];
CONWAYPOLDATA[22943]:=[
,,,[5083572287,"RPn"],];
CONWAYPOLDATA[22961]:=[
,,,[4136584883,"RPn"],];
CONWAYPOLDATA[22963]:=[
,,,[1335206601,"RPn"],];
CONWAYPOLDATA[22973]:=[
,,,[5269799445,"RPn"],];
CONWAYPOLDATA[22993]:=[
,,,[3638182395,"RPn"],];
CONWAYPOLDATA[23003]:=[
,,,[1474308278,"RPn"],];
CONWAYPOLDATA[23011]:=[
,,,[3542520446,"RPn"],];
CONWAYPOLDATA[23017]:=[
,,,[3648194505,"RPn"],];
CONWAYPOLDATA[23021]:=[
,,,[2619582613,"RPn"],];
CONWAYPOLDATA[23027]:=[
,,,[4160817713,"RPn"],];
CONWAYPOLDATA[23029]:=[
,,,[3528480353,"RPn"],];
CONWAYPOLDATA[23039]:=[
,,,[5680726237,"RPn"],];
CONWAYPOLDATA[23041]:=[
,,,[13271754257,"RPn"],];
CONWAYPOLDATA[23053]:=[
,,,[6825532242,"RPn"],];
CONWAYPOLDATA[23057]:=[
,,,[921034927,"RPn"],];
CONWAYPOLDATA[23059]:=[
,,,[8363360949,"RPn"],];
CONWAYPOLDATA[23063]:=[
,,,[6241678073,"RPn"],];
CONWAYPOLDATA[23071]:=[
,,,[3604151623,"RPn"],];
CONWAYPOLDATA[23081]:=[
,,,[532455592,"RPn"],];
CONWAYPOLDATA[23087]:=[
,,,[2111583199,"RPn"],];
CONWAYPOLDATA[23099]:=[
,,,[6788172429,"RPn"],];
CONWAYPOLDATA[23117]:=[
,,,[816191921,"RPn"],];
CONWAYPOLDATA[23131]:=[
,,,[2967799827,"RPn"],];
CONWAYPOLDATA[23143]:=[
,,,[2142301229,"RPn"],];
CONWAYPOLDATA[23159]:=[
,,,[4826960904,"RPn"],];
CONWAYPOLDATA[23167]:=[
,,,[3560513066,"RPn"],];
CONWAYPOLDATA[23173]:=[
,,,[3723993797,"RPn"],];
CONWAYPOLDATA[23189]:=[
,,,[5292842874,"RPn"],];
CONWAYPOLDATA[23197]:=[
,,,[11809082368,"RPn"],];
CONWAYPOLDATA[23201]:=[
,,,[4221329149,"RPn"],];
CONWAYPOLDATA[23203]:=[
,,,[2071308610,"RPn"],];
CONWAYPOLDATA[23209]:=[
,,,[17512907997,"RPn"],];
CONWAYPOLDATA[23227]:=[
,,,[3002391704,"RPn"],];
CONWAYPOLDATA[23251]:=[
,,,[4722254851,"RPn"],];
CONWAYPOLDATA[23269]:=[
,,,[5904718177,"RPn"],];
CONWAYPOLDATA[23279]:=[
,,,[3780090585,"RPn"],];
CONWAYPOLDATA[23291]:=[
,,,[1384999321,"RPn"],];
CONWAYPOLDATA[23293]:=[
,,,[2047827393,"RPn"],];
CONWAYPOLDATA[23297]:=[
,,,[10115743779,"RPn"],];
CONWAYPOLDATA[23311]:=[
,,,[2124681098,"RPn"],];
CONWAYPOLDATA[23321]:=[
,,,[543589192,"RPn"],];
CONWAYPOLDATA[23327]:=[
,,,[5945329168,"RPn"],];
CONWAYPOLDATA[23333]:=[
,,,[4221313030,"RPn"],];
CONWAYPOLDATA[23339]:=[
,,,[4851454593,"RPn"],];
CONWAYPOLDATA[23357]:=[
,,,[3613257831,"RPn"],];
CONWAYPOLDATA[23369]:=[
,,,[1454603408,"RPn"],];
CONWAYPOLDATA[23371]:=[
,,,[1500511686,"RPn"],];
CONWAYPOLDATA[23399]:=[
,,,[2189865629,"RPn"],];
CONWAYPOLDATA[23417]:=[
,,,[2001450993,"RPn"],];
CONWAYPOLDATA[23431]:=[
,,,[2744965084,"RPn"],];
CONWAYPOLDATA[23447]:=[
,,,[3741344007,"RPn"],];
CONWAYPOLDATA[23459]:=[
,,,[957150661,"RPn"],];
CONWAYPOLDATA[23473]:=[
,,,[3602119639,"RPn"],];
CONWAYPOLDATA[23497]:=[
,,,[3859664219,"RPn"],];
CONWAYPOLDATA[23509]:=[
,,,[2102856543,"RPn"],];
CONWAYPOLDATA[23531]:=[
,,,[2154215990,"RPn"],];
CONWAYPOLDATA[23537]:=[
,,,[3816971756,"RPn"],];
CONWAYPOLDATA[23539]:=[
,,,[1968801962,"RPn"],];
CONWAYPOLDATA[23549]:=[
,,,[7037995436,"RPn"],];
CONWAYPOLDATA[23557]:=[
,,,[5304447480,"RPn"],];
CONWAYPOLDATA[23561]:=[
,,,[1426288699,"RPn"],];
CONWAYPOLDATA[23563]:=[
,,,[4961495971,"RPn"],];
CONWAYPOLDATA[23567]:=[
,,,[3700985252,"RPn"],];
CONWAYPOLDATA[23581]:=[
,,,[3892350609,"RPn"],];
CONWAYPOLDATA[23593]:=[
,,,[3655971285,"RPn"],];
CONWAYPOLDATA[23599]:=[
,,,[2784469612,"RPn"],];
CONWAYPOLDATA[23603]:=[
,,,[9960182766,"RPn"],];
CONWAYPOLDATA[23609]:=[
,,,[5311481999,"RPn"],];
CONWAYPOLDATA[23623]:=[
,,,[3277313288,"RPn"],];
CONWAYPOLDATA[23627]:=[
,,,[4940665599,"RPn"],];
CONWAYPOLDATA[23629]:=[
,,,[6119532938,"RPn"],];
CONWAYPOLDATA[23633]:=[
,,,[4994172831,"RPn"],];
CONWAYPOLDATA[23663]:=[
,,,[3133123183,"RPn"],];
CONWAYPOLDATA[23669]:=[
,,,[2770858825,"RPn"],];
CONWAYPOLDATA[23671]:=[
,,,[1446676839,"RPn"],];
CONWAYPOLDATA[23677]:=[
,,,[2107158297,"RPn"],];
CONWAYPOLDATA[23687]:=[
,,,[2244201133,"RPn"],];
CONWAYPOLDATA[23689]:=[
,,,[9386908395,"RPn"],];
CONWAYPOLDATA[23719]:=[
,,,[2095597375,"RPn"],];
CONWAYPOLDATA[23741]:=[
,,,[7107651805,"RPn"],];
CONWAYPOLDATA[23743]:=[
,,,[3670311658,"RPn"],];
CONWAYPOLDATA[23747]:=[
,,,[6141995323,"RPn"],];
CONWAYPOLDATA[23753]:=[
,,,[14624199537,"RPn"],];
CONWAYPOLDATA[23761]:=[
,,,[323933720,"RPn"],];
CONWAYPOLDATA[23767]:=[
,,,[3357278889,"RPn"],];
CONWAYPOLDATA[23773]:=[
,,,[6749701484,"RPn"],];
CONWAYPOLDATA[23789]:=[
,,,[2196509739,"RPn"],];
CONWAYPOLDATA[23801]:=[
,,,[12894953385,"RPn"],];
CONWAYPOLDATA[23813]:=[
,,,[1116115312,"RPn"],];
CONWAYPOLDATA[23819]:=[
,,,[1594229491,"RPn"],];
CONWAYPOLDATA[23827]:=[
,,,[5109366574,"RPn"],];
CONWAYPOLDATA[23831]:=[
,,,[3842772592,"RPn"],];
CONWAYPOLDATA[23833]:=[
,,,[8519916177,"RPn"],];
CONWAYPOLDATA[23857]:=[
,,,[3736960485,"RPn"],];
CONWAYPOLDATA[23869]:=[
,,,[4896295710,"RPn"],];
CONWAYPOLDATA[23873]:=[
,,,[317797379,"RPn"],];
CONWAYPOLDATA[23879]:=[
,,,[1439688796,"RPn"],];
CONWAYPOLDATA[23887]:=[
,,,[3362310236,"RPn"],];
CONWAYPOLDATA[23893]:=[
,,,[2223721515,"RPn"],];
CONWAYPOLDATA[23899]:=[
,,,[5047946782,"RPn"],];
CONWAYPOLDATA[23909]:=[
,,,[3832875701,"RPn"],];
CONWAYPOLDATA[23911]:=[
,,,[1690962015,"RPn"],];
CONWAYPOLDATA[23917]:=[
,,,[3880485418,"RPn"],];
CONWAYPOLDATA[23929]:=[
,,,[14061996502,"RPn"],];
CONWAYPOLDATA[23957]:=[
,,,[1581689056,"RPn"],];
CONWAYPOLDATA[23971]:=[
,,,[507394167,"RPn"],];
CONWAYPOLDATA[23977]:=[
,,,[3846917839,"RPn"],];
CONWAYPOLDATA[23981]:=[
,,,[2875345884,"RPn"],];
CONWAYPOLDATA[23993]:=[
,,,[1574300698,"RPn"],];
CONWAYPOLDATA[24001]:=[
,,,[8542411933,"RPn"],];
CONWAYPOLDATA[24007]:=[
,,,[2305152157,"RPn"],];
CONWAYPOLDATA[24019]:=[
,,,[5130818687,"RPn"],];
CONWAYPOLDATA[24023]:=[
,,,[2308322029,"RPn"],];
CONWAYPOLDATA[24029]:=[
,,,[1005421420,"RPn"],];
CONWAYPOLDATA[24043]:=[
,,,[4525469634,"RPn"],];
CONWAYPOLDATA[24049]:=[
,,,[11986598795,"RPn"],];
CONWAYPOLDATA[24061]:=[
,,,[8473706746,"RPn"],];
CONWAYPOLDATA[24071]:=[
,,,[1711568466,"RPn"],];
CONWAYPOLDATA[24077]:=[
,,,[3997672851,"RPn"],];
CONWAYPOLDATA[24083]:=[
,,,[2701486444,"RPn"],];
CONWAYPOLDATA[24091]:=[
,,,[3940034875,"RPn"],];
CONWAYPOLDATA[24097]:=[
,,,[6246014696,"RPn"],];
CONWAYPOLDATA[24103]:=[
,,,[10283954706,"RPn"],];
CONWAYPOLDATA[24107]:=[
,,,[1554395255,"RPn"],];
CONWAYPOLDATA[24109]:=[
,,,[3859175850,"RPn"],];
CONWAYPOLDATA[24113]:=[
,,,[9637411504,"RPn"],];
CONWAYPOLDATA[24121]:=[
,,,[11584954498,"RPn"],];
CONWAYPOLDATA[24133]:=[
,,,[6273976681,"RPn"],];
CONWAYPOLDATA[24137]:=[
,,,[1136876840,"RPn"],];
CONWAYPOLDATA[24151]:=[
,,,[6305657049,"RPn"],];
CONWAYPOLDATA[24169]:=[
,,,[7577440722,"RPn"],];
CONWAYPOLDATA[24179]:=[
,,,[4548940346,"RPn"],];
CONWAYPOLDATA[24181]:=[
,,,[2258674684,"RPn"],];
CONWAYPOLDATA[24197]:=[
,,,[1071975496,"RPn"],];
CONWAYPOLDATA[24203]:=[
,,,[5245177350,"RPn"],];
CONWAYPOLDATA[24223]:=[
,,,[9775894120,"RPn"],];
CONWAYPOLDATA[24229]:=[
,,,[7344851749,"RPn"],];
CONWAYPOLDATA[24239]:=[
,,,[2187933348,"RPn"],];
CONWAYPOLDATA[24247]:=[
,,,[3903379051,"RPn"],];
CONWAYPOLDATA[24251]:=[
,,,[4704645504,"RPn"],];
CONWAYPOLDATA[24281]:=[
,,,[572618826,"RPn"],];
CONWAYPOLDATA[24317]:=[
,,,[2244994076,"RPn"],];
CONWAYPOLDATA[24329]:=[
,,,[2704289998,"RPn"],];
CONWAYPOLDATA[24337]:=[
,,,[9216154198,"RPn"],];
CONWAYPOLDATA[24359]:=[
,,,[2221419016,"RPn"],];
CONWAYPOLDATA[24371]:=[
,,,[4559253569,"RPn"],];
CONWAYPOLDATA[24373]:=[
,,,[2723853368,"RPn"],];
CONWAYPOLDATA[24379]:=[
,,,[1060827808,"RPn"],];
CONWAYPOLDATA[24391]:=[
,,,[2361414668,"RPn"],];
CONWAYPOLDATA[24407]:=[
,,,[5175138250,"RPn"],];
CONWAYPOLDATA[24413]:=[
,,,[3480073152,"RPn"],];
CONWAYPOLDATA[24419]:=[
,,,[2806573348,"RPn"],];
CONWAYPOLDATA[24421]:=[
,,,[7516026756,"RPn"],];
CONWAYPOLDATA[24439]:=[
,,,[4180755297,"RPn"],];
CONWAYPOLDATA[24443]:=[
,,,[1644671700,"RPn"],];
CONWAYPOLDATA[24469]:=[
,,,[1103551914,"RPn"],];
CONWAYPOLDATA[24473]:=[
,,,[1157156862,"RPn"],];
CONWAYPOLDATA[24481]:=[
,,,[12483571860,"RPn"],];
CONWAYPOLDATA[24499]:=[
,,,[1081900341,"RPn"],];
CONWAYPOLDATA[24509]:=[
,,,[509566621,"RPn"],];
CONWAYPOLDATA[24517]:=[
,,,[6374248386,"RPn"],];
CONWAYPOLDATA[24527]:=[
,,,[11964834726,"RPn"],];
CONWAYPOLDATA[24533]:=[
,,,[3942943762,"RPn"],];
CONWAYPOLDATA[24547]:=[
,,,[4638990250,"RPn"],];
CONWAYPOLDATA[24551]:=[
,,,[3013537053,"RPn"],];
CONWAYPOLDATA[24571]:=[
,,,[4184834443,"RPn"],];
CONWAYPOLDATA[24593]:=[
,,,[4204591434,"RPn"],];
CONWAYPOLDATA[24611]:=[
,,,[4568589165,"RPn"],];
CONWAYPOLDATA[24623]:=[
,,,[2419702215,"RPn"],];
CONWAYPOLDATA[24631]:=[
,,,[1676977007,"RPn"],];
CONWAYPOLDATA[24659]:=[
,,,[1817491597,"RPn"],];
CONWAYPOLDATA[24671]:=[
,,,[2742329687,"RPn"],];
CONWAYPOLDATA[24677]:=[
,,,[4183615197,"RPn"],];
CONWAYPOLDATA[24683]:=[
,,,[501015536,"RPn"],];
CONWAYPOLDATA[24691]:=[
,,,[5798064077,"RPn"],];
CONWAYPOLDATA[24697]:=[
,,,[9148855473,"RPn"],];
CONWAYPOLDATA[24709]:=[
,,,[6534492724,"RPn"],];
CONWAYPOLDATA[24733]:=[
,,,[7852752235,"RPn"],];
CONWAYPOLDATA[24749]:=[
,,,[4166642646,"RPn"],];
CONWAYPOLDATA[24763]:=[
,,,[5297870511,"RPn"],];
CONWAYPOLDATA[24767]:=[
,,,[1803235741,"RPn"],];
CONWAYPOLDATA[24781]:=[
,,,[6626166811,"RPn"],];
CONWAYPOLDATA[24793]:=[
,,,[6529087797,"RPn"],];
CONWAYPOLDATA[24799]:=[
,,,[2222734376,"RPn"],];
CONWAYPOLDATA[24809]:=[
,,,[9808511055,"RPn"],];
CONWAYPOLDATA[24821]:=[
,,,[5958380336,"RPn"],];
CONWAYPOLDATA[24841]:=[
,,,[5920057452,"RPn"],];
CONWAYPOLDATA[24847]:=[
,,,[4147908489,"RPn"],];
CONWAYPOLDATA[24851]:=[
,,,[6165359145,"RPn"],];
CONWAYPOLDATA[24859]:=[
,,,[5514695703,"RPn"],];
CONWAYPOLDATA[24877]:=[
,,,[1092871492,"RPn"],];
CONWAYPOLDATA[24889]:=[
,,,[15486085145,"RPn"],];
CONWAYPOLDATA[24907]:=[
,,,[9151977524,"RPn"],];
CONWAYPOLDATA[24917]:=[
,,,[4103381396,"RPn"],];
CONWAYPOLDATA[24919]:=[
,,,[2339669832,"RPn"],];
CONWAYPOLDATA[24923]:=[
,,,[1563843483,"RPn"],];
CONWAYPOLDATA[24943]:=[
,,,[1803553506,"RPn"],];
CONWAYPOLDATA[24953]:=[
,,,[323316024,"RPn"],];
CONWAYPOLDATA[24967]:=[
,,,[3511159147,"RPn"],];
CONWAYPOLDATA[24971]:=[
,,,[4830814749,"RPn"],];
CONWAYPOLDATA[24977]:=[
,,,[4966151936,"RPn"],];
CONWAYPOLDATA[24979]:=[
,,,[4337328583,"RPn"],];
CONWAYPOLDATA[24989]:=[
,,,[2415886544,"RPn"],];
CONWAYPOLDATA[25013]:=[
,,,[4292430906,"RPn"],];
CONWAYPOLDATA[25031]:=[
,,,[2342776458,"RPn"],];
CONWAYPOLDATA[25033]:=[
,,,[8032564012,"RPn"],];
CONWAYPOLDATA[25037]:=[
,,,[1178015889,"RPn"],];
CONWAYPOLDATA[25057]:=[
,,,[4205165973,"RPn"],];
CONWAYPOLDATA[25073]:=[
,,,[1246077957,"RPn"],];
CONWAYPOLDATA[25087]:=[
,,,[1719538244,"RPn"],];
CONWAYPOLDATA[25097]:=[
,,,[569300351,"RPn"],];
CONWAYPOLDATA[25111]:=[
,,,[2475844159,"RPn"],];
CONWAYPOLDATA[25117]:=[
,,,[4278555370,"RPn"],];
CONWAYPOLDATA[25121]:=[
,,,[4745733718,"RPn"],];
CONWAYPOLDATA[25127]:=[
,,,[5440673934,"RPn"],];
CONWAYPOLDATA[25147]:=[
,,,[1876393701,"RPn"],];
CONWAYPOLDATA[25153]:=[
,,,[4414326357,"RPn"],];
CONWAYPOLDATA[25163]:=[
,,,[7399180152,"RPn"],];
CONWAYPOLDATA[25169]:=[
,,,[5675735348,"RPn"],];
CONWAYPOLDATA[25171]:=[
,,,[485926158,"RPn"],];
CONWAYPOLDATA[25183]:=[
,,,[13317374797,"RPn"],];
CONWAYPOLDATA[25189]:=[
,,,[2295624706,"RPn"],];
CONWAYPOLDATA[25219]:=[
,,,[4160479308,"RPn"],];
CONWAYPOLDATA[25229]:=[
,,,[8040457073,"RPn"],];
CONWAYPOLDATA[25237]:=[
,,,[6055088175,"RPn"],];
CONWAYPOLDATA[25243]:=[
,,,[6883235999,"RPn"],];
CONWAYPOLDATA[25247]:=[
,,,[1733459025,"RPn"],];
CONWAYPOLDATA[25253]:=[
,,,[4880268517,"RPn"],];
CONWAYPOLDATA[25261]:=[
,,,[10155427227,"RPn"],];
CONWAYPOLDATA[25301]:=[
,,,[3200601804,"RPn"],];
CONWAYPOLDATA[25303]:=[
,,,[2436780115,"RPn"],];
CONWAYPOLDATA[25307]:=[
,,,[5086656388,"RPn"],];
CONWAYPOLDATA[25309]:=[
,,,[7498423988,"RPn"],];
CONWAYPOLDATA[25321]:=[
,,,[5577557973,"RPn"],];
CONWAYPOLDATA[25339]:=[
,,,[1660135266,"RPn"],];
CONWAYPOLDATA[25343]:=[
,,,[7029083799,"RPn"],];
CONWAYPOLDATA[25349]:=[
,,,[8115178164,"RPn"],];
CONWAYPOLDATA[25357]:=[
,,,[4916443375,"RPn"],];
CONWAYPOLDATA[25367]:=[
,,,[5124666712,"RPn"],];
CONWAYPOLDATA[25373]:=[
,,,[13985115515,"RPn"],];
CONWAYPOLDATA[25391]:=[
,,,[1913084902,"RPn"],];
CONWAYPOLDATA[25409]:=[
,,,[4935571208,"RPn"],];
CONWAYPOLDATA[25411]:=[
,,,[4316566577,"RPn"],];
CONWAYPOLDATA[25423]:=[
,,,[3756095715,"RPn"],];
CONWAYPOLDATA[25439]:=[
,,,[4279882806,"RPn"],];
CONWAYPOLDATA[25447]:=[
,,,[4401185888,"RPn"],];
CONWAYPOLDATA[25453]:=[
,,,[1925392187,"RPn"],];
CONWAYPOLDATA[25457]:=[
,,,[465684904,"RPn"],];
CONWAYPOLDATA[25463]:=[
,,,[2418883153,"RPn"],];
CONWAYPOLDATA[25469]:=[
,,,[5837851368,"RPn"],];
CONWAYPOLDATA[25471]:=[
,,,[2370585976,"RPn"],];
CONWAYPOLDATA[25523]:=[
,,,[2575730116,"RPn"],];
CONWAYPOLDATA[25537]:=[
,,,[9477316987,"RPn"],];
CONWAYPOLDATA[25541]:=[
,,,[1210183664,"RPn"],];
CONWAYPOLDATA[25561]:=[
,,,[20066407451,"RPn"],];
CONWAYPOLDATA[25577]:=[
,,,[4442264517,"RPn"],];
CONWAYPOLDATA[25579]:=[
,,,[5874396405,"RPn"],];
CONWAYPOLDATA[25583]:=[
,,,[3805829417,"RPn"],];
CONWAYPOLDATA[25589]:=[
,,,[456405406,"RPn"],];
CONWAYPOLDATA[25601]:=[
,,,[4432429138,"RPn"],];
CONWAYPOLDATA[25603]:=[
,,,[5604317481,"RPn"],];
CONWAYPOLDATA[25609]:=[
,,,[12453528662,"RPn"],];
CONWAYPOLDATA[25621]:=[
,,,[6360208292,"RPn"],];
CONWAYPOLDATA[25633]:=[
,,,[4375399307,"RPn"],];
CONWAYPOLDATA[25639]:=[
,,,[2573745379,"RPn"],];
CONWAYPOLDATA[25643]:=[
,,,[5652204419,"RPn"],];
CONWAYPOLDATA[25657]:=[
,,,[6937704119,"RPn"],];
CONWAYPOLDATA[25667]:=[
,,,[5928974334,"RPn"],];
CONWAYPOLDATA[25673]:=[
,,,[4318891774,"RPn"],];
CONWAYPOLDATA[25679]:=[
,,,[1891720583,"RPn"],];
CONWAYPOLDATA[25693]:=[
,,,[2492375160,"RPn"],];
CONWAYPOLDATA[25703]:=[
,,,[6468596906,"RPn"],];
CONWAYPOLDATA[25717]:=[
,,,[2491642981,"RPn"],];
CONWAYPOLDATA[25733]:=[
,,,[655033517,"RPn"],];
CONWAYPOLDATA[25741]:=[
,,,[1781302947,"RPn"],];
CONWAYPOLDATA[25747]:=[
,,,[5798662101,"RPn"],];
CONWAYPOLDATA[25759]:=[
,,,[2402052512,"RPn"],];
CONWAYPOLDATA[25763]:=[
,,,[1718933128,"RPn"],];
CONWAYPOLDATA[25771]:=[
,,,[5857181340,"RPn"],];
CONWAYPOLDATA[25793]:=[
,,,[6401771017,"RPn"],];
CONWAYPOLDATA[25799]:=[
,,,[1934331630,"RPn"],];
CONWAYPOLDATA[25801]:=[
,,,[1683360451,"RPn"],];
CONWAYPOLDATA[25819]:=[
,,,[482014914,"RPn"],];
CONWAYPOLDATA[25841]:=[
,,,[3120119866,"RPn"],];
CONWAYPOLDATA[25847]:=[
,,,[4414021430,"RPn"],];
CONWAYPOLDATA[25849]:=[
,,,[597887377,"RPn"],];
CONWAYPOLDATA[25867]:=[
,,,[5810969818,"RPn"],];
CONWAYPOLDATA[25873]:=[
,,,[564704108,"RPn"],];
CONWAYPOLDATA[25889]:=[
,,,[5128688570,"RPn"],];
CONWAYPOLDATA[25903]:=[
,,,[7168085389,"RPn"],];
CONWAYPOLDATA[25913]:=[
,,,[5321986030,"RPn"],];
CONWAYPOLDATA[25919]:=[
,,,[4646732412,"RPn"],];
CONWAYPOLDATA[25931]:=[
,,,[1978301923,"RPn"],];
CONWAYPOLDATA[25933]:=[
,,,[8724561393,"RPn"],];
CONWAYPOLDATA[25939]:=[
,,,[1776406479,"RPn"],];
CONWAYPOLDATA[25943]:=[
,,,[3794189698,"RPn"],];
CONWAYPOLDATA[25951]:=[
,,,[1923306466,"RPn"],];
CONWAYPOLDATA[25969]:=[
,,,[11391405733,"RPn"],];
CONWAYPOLDATA[25981]:=[
,,,[417540662,"RPn"],];
CONWAYPOLDATA[25997]:=[
,,,[1838767812,"RPn"],];
CONWAYPOLDATA[25999]:=[
,,,[412942124,"RPn"],];
CONWAYPOLDATA[26003]:=[
,,,[5335659584,"RPn"],];
CONWAYPOLDATA[26017]:=[
,,,[10152978153,"RPn"],];
CONWAYPOLDATA[26021]:=[
,,,[4470485865,"RPn"],];
CONWAYPOLDATA[26029]:=[
,,,[7254334364,"RPn"],];
CONWAYPOLDATA[26041]:=[
,,,[14062270218,"RPn"],];
CONWAYPOLDATA[26053]:=[
,,,[4736148819,"RPn"],];
CONWAYPOLDATA[26083]:=[
,,,[7934266026,"RPn"],];
CONWAYPOLDATA[26099]:=[
,,,[1745005241,"RPn"],];
CONWAYPOLDATA[26107]:=[
,,,[5882350921,"RPn"],];
CONWAYPOLDATA[26111]:=[
,,,[4070469908,"RPn"],];
CONWAYPOLDATA[26113]:=[
,,,[18264398388,"RPn"],];
CONWAYPOLDATA[26119]:=[
,,,[2682760850,"RPn"],];
CONWAYPOLDATA[26141]:=[
,,,[6022598851,"RPn"],];
CONWAYPOLDATA[26153]:=[
,,,[3231177000,"RPn"],];
CONWAYPOLDATA[26161]:=[
,,,[22534536032,"RPn"],];
CONWAYPOLDATA[26171]:=[
,,,[6164107974,"RPn"],];
CONWAYPOLDATA[26177]:=[
,,,[5282780373,"RPn"],];
CONWAYPOLDATA[26183]:=[
,,,[3843873869,"RPn"],];
CONWAYPOLDATA[26189]:=[
,,,[1878982185,"RPn"],];
CONWAYPOLDATA[26203]:=[
,,,[2509277892,"RPn"],];
CONWAYPOLDATA[26209]:=[
,,,[8796212173,"RPn"],];
CONWAYPOLDATA[26227]:=[
,,,[2552700140,"RPn"],];
CONWAYPOLDATA[26237]:=[
,,,[4531051191,"RPn"],];
CONWAYPOLDATA[26249]:=[
,,,[1987128050,"RPn"],];
CONWAYPOLDATA[26251]:=[
,,,[5910727664,"RPn"],];
CONWAYPOLDATA[26261]:=[
,,,[5450102898,"RPn"],];
CONWAYPOLDATA[26263]:=[
,,,[3846715350,"RPn"],];
CONWAYPOLDATA[26267]:=[
,,,[5468027659,"RPn"],];
CONWAYPOLDATA[26293]:=[
,,,[3329561475,"RPn"],];
CONWAYPOLDATA[26297]:=[
,,,[3267954490,"RPn"],];
CONWAYPOLDATA[26309]:=[
,,,[2593225514,"RPn"],];
CONWAYPOLDATA[26317]:=[
,,,[4696426558,"RPn"],];
CONWAYPOLDATA[26321]:=[
,,,[692479192,"RPn"],];
CONWAYPOLDATA[26339]:=[
,,,[2026153916,"RPn"],];
CONWAYPOLDATA[26347]:=[
,,,[3994995613,"RPn"],];
CONWAYPOLDATA[26357]:=[
,,,[1921978799,"RPn"],];
CONWAYPOLDATA[26371]:=[
,,,[2713602274,"RPn"],];
CONWAYPOLDATA[26387]:=[
,,,[576793435,"RPn"],];
CONWAYPOLDATA[26393]:=[
,,,[18783317457,"RPn"],];
CONWAYPOLDATA[26399]:=[
,,,[8218510288,"RPn"],];
CONWAYPOLDATA[26407]:=[
,,,[2789212973,"RPn"],];
CONWAYPOLDATA[26417]:=[
,,,[4621654153,"RPn"],];
CONWAYPOLDATA[26423]:=[
,,,[5307376631,"RPn"],];
CONWAYPOLDATA[26431]:=[
,,,[2664694130,"RPn"],];
CONWAYPOLDATA[26437]:=[
,,,[2657103564,"RPn"],];
CONWAYPOLDATA[26449]:=[
,,,[478621111,"RPn"],];
CONWAYPOLDATA[26459]:=[
,,,[1092888997,"RPn"],];
CONWAYPOLDATA[26479]:=[
,,,[2040233432,"RPn"],];
CONWAYPOLDATA[26489]:=[
,,,[5990487353,"RPn"],];
CONWAYPOLDATA[26497]:=[
,,,[11106456028,"RPn"],];
CONWAYPOLDATA[26501]:=[
,,,[2465838549,"RPn"],];
CONWAYPOLDATA[26513]:=[
,,,[1200057922,"RPn"],];
CONWAYPOLDATA[26539]:=[
,,,[6191362929,"RPn"],];
CONWAYPOLDATA[26557]:=[
,,,[4683751864,"RPn"],];
CONWAYPOLDATA[26561]:=[
,,,[5583600301,"RPn"],];
CONWAYPOLDATA[26573]:=[
,,,[5629144603,"RPn"],];
CONWAYPOLDATA[26591]:=[
,,,[3990245482,"RPn"],];
CONWAYPOLDATA[26597]:=[
,,,[5357779473,"RPn"],];
CONWAYPOLDATA[26627]:=[
,,,[1980676024,"RPn"],];
CONWAYPOLDATA[26633]:=[
,,,[1262404203,"RPn"],];
CONWAYPOLDATA[26641]:=[
,,,[12612728560,"RPn"],];
CONWAYPOLDATA[26647]:=[
,,,[4720862464,"RPn"],];
CONWAYPOLDATA[26669]:=[
,,,[6764591852,"RPn"],];
CONWAYPOLDATA[26681]:=[
,,,[360807169,"RPn"],];
CONWAYPOLDATA[26683]:=[
,,,[1802916946,"RPn"],];
CONWAYPOLDATA[26687]:=[
,,,[2848677133,"RPn"],];
CONWAYPOLDATA[26693]:=[
,,,[6367535073,"RPn"],];
CONWAYPOLDATA[26699]:=[
,,,[3520556841,"RPn"],];
CONWAYPOLDATA[26701]:=[
,,,[2834871893,"RPn"],];
CONWAYPOLDATA[26711]:=[
,,,[7521684056,"RPn"],];
CONWAYPOLDATA[26713]:=[
,,,[10573806800,"RPn"],];
CONWAYPOLDATA[26717]:=[
,,,[4840960100,"RPn"],];
CONWAYPOLDATA[26723]:=[
,,,[5466296544,"RPn"],];
CONWAYPOLDATA[26729]:=[
,,,[3301084961,"RPn"],];
CONWAYPOLDATA[26731]:=[
,,,[4154932988,"RPn"],];
CONWAYPOLDATA[26737]:=[
,,,[6387950576,"RPn"],];
CONWAYPOLDATA[26759]:=[
,,,[3455871345,"RPn"],];
CONWAYPOLDATA[26777]:=[
,,,[6848298084,"RPn"],];
CONWAYPOLDATA[26783]:=[
,,,[1949695273,"RPn"],];
CONWAYPOLDATA[26801]:=[
,,,[717971992,"RPn"],];
CONWAYPOLDATA[26813]:=[
,,,[2545813913,"RPn"],];
CONWAYPOLDATA[26821]:=[
,,,[4700433894,"RPn"],];
CONWAYPOLDATA[26833]:=[
,,,[15070673956,"RPn"],];
CONWAYPOLDATA[26839]:=[
,,,[4929707006,"RPn"],];
CONWAYPOLDATA[26849]:=[
,,,[2676469417,"RPn"],];
CONWAYPOLDATA[26861]:=[
,,,[3404819779,"RPn"],];
CONWAYPOLDATA[26863]:=[
,,,[2886375629,"RPn"],];
CONWAYPOLDATA[26879]:=[
,,,[3599178750,"RPn"],];
CONWAYPOLDATA[26881]:=[
,,,[18064193297,"RPn"],];
CONWAYPOLDATA[26891]:=[
,,,[454350342,"RPn"],];
CONWAYPOLDATA[26893]:=[
,,,[16564635783,"RPn"],];
CONWAYPOLDATA[26903]:=[
,,,[2075243619,"RPn"],];
CONWAYPOLDATA[26921]:=[
,,,[2037219767,"RPn"],];
CONWAYPOLDATA[26927]:=[
,,,[3508830448,"RPn"],];
CONWAYPOLDATA[26947]:=[
,,,[6433623199,"RPn"],];
CONWAYPOLDATA[26951]:=[
,,,[3563811590,"RPn"],];
CONWAYPOLDATA[26953]:=[
,,,[15705944355,"RPn"],];
CONWAYPOLDATA[26959]:=[
,,,[4086714816,"RPn"],];
CONWAYPOLDATA[26981]:=[
,,,[1861095421,"RPn"],];
CONWAYPOLDATA[26987]:=[
,,,[13579615519,"RPn"],];
CONWAYPOLDATA[26993]:=[
,,,[8684295935,"RPn"],];
CONWAYPOLDATA[27011]:=[
,,,[4996710870,"RPn"],];
CONWAYPOLDATA[27017]:=[
,,,[3427376625,"RPn"],];
CONWAYPOLDATA[27031]:=[
,,,[3400445744,"RPn"],];
CONWAYPOLDATA[27043]:=[
,,,[7937553190,"RPn"],];
CONWAYPOLDATA[27059]:=[
,,,[5541926733,"RPn"],];
CONWAYPOLDATA[27061]:=[
,,,[4876635751,"RPn"],];
CONWAYPOLDATA[27067]:=[
,,,[2186959468,"RPn"],];
CONWAYPOLDATA[27073]:=[
,,,[12453796589,"RPn"],];
CONWAYPOLDATA[27077]:=[
,,,[9185087019,"RPn"],];
CONWAYPOLDATA[27091]:=[
,,,[6388545440,"RPn"],];
CONWAYPOLDATA[27103]:=[
,,,[4056695734,"RPn"],];
CONWAYPOLDATA[27107]:=[
,,,[7942757607,"RPn"],];
CONWAYPOLDATA[27109]:=[
,,,[3674380976,"RPn"],];
CONWAYPOLDATA[27127]:=[
,,,[2626843048,"RPn"],];
CONWAYPOLDATA[27143]:=[
,,,[4395157423,"RPn"],];
CONWAYPOLDATA[27179]:=[
,,,[7208930783,"RPn"],];
CONWAYPOLDATA[27191]:=[
,,,[3555603950,"RPn"],];
CONWAYPOLDATA[27197]:=[
,,,[5700681581,"RPn"],];
CONWAYPOLDATA[27211]:=[
,,,[1859790227,"RPn"],];
CONWAYPOLDATA[27239]:=[
,,,[3709570461,"RPn"],];
CONWAYPOLDATA[27241]:=[
,,,[15465750875,"RPn"],];
CONWAYPOLDATA[27253]:=[
,,,[8067787351,"RPn"],];
CONWAYPOLDATA[27259]:=[
,,,[6569773369,"RPn"],];
CONWAYPOLDATA[27271]:=[
,,,[4210369696,"RPn"],];
CONWAYPOLDATA[27277]:=[
,,,[9509335023,"RPn"],];
CONWAYPOLDATA[27281]:=[
,,,[631964371,"RPn"],];
CONWAYPOLDATA[27283]:=[
,,,[4380667617,"RPn"],];
CONWAYPOLDATA[27299]:=[
,,,[1247700797,"RPn"],];
CONWAYPOLDATA[27329]:=[
,,,[746546296,"RPn"],];
CONWAYPOLDATA[27337]:=[
,,,[5103899916,"RPn"],];
CONWAYPOLDATA[27361]:=[
,,,[637949083,"RPn"],];
CONWAYPOLDATA[27367]:=[
,,,[4189340363,"RPn"],];
CONWAYPOLDATA[27397]:=[
,,,[2979259370,"RPn"],];
CONWAYPOLDATA[27407]:=[
,,,[6729185901,"RPn"],];
CONWAYPOLDATA[27409]:=[
,,,[9490421081,"RPn"],];
CONWAYPOLDATA[27427]:=[
,,,[8254841330,"RPn"],];
CONWAYPOLDATA[27431]:=[
,,,[2078282301,"RPn"],];
CONWAYPOLDATA[27437]:=[
,,,[9600590420,"RPn"],];
CONWAYPOLDATA[27449]:=[
,,,[753118216,"RPn"],];
CONWAYPOLDATA[27457]:=[
,,,[6740171824,"RPn"],];
CONWAYPOLDATA[27479]:=[
,,,[8943590137,"RPn"],];
CONWAYPOLDATA[27481]:=[
,,,[459509808,"RPn"],];
CONWAYPOLDATA[27487]:=[
,,,[2663572764,"RPn"],];
CONWAYPOLDATA[27509]:=[
,,,[9521580136,"RPn"],];
CONWAYPOLDATA[27527]:=[
,,,[2018472334,"RPn"],];
CONWAYPOLDATA[27529]:=[
,,,[515893467,"RPn"],];
CONWAYPOLDATA[27539]:=[
,,,[5807562017,"RPn"],];
CONWAYPOLDATA[27541]:=[
,,,[394579926,"RPn"],];
CONWAYPOLDATA[27551]:=[
,,,[3036010013,"RPn"],];
CONWAYPOLDATA[27581]:=[
,,,[5169175860,"RPn"],];
CONWAYPOLDATA[27583]:=[
,,,[2035515071,"RPn"],];
CONWAYPOLDATA[27611]:=[
,,,[10431629079,"RPn"],];
CONWAYPOLDATA[27617]:=[
,,,[11213358130,"RPn"],];
CONWAYPOLDATA[27631]:=[
,,,[4421263947,"RPn"],];
CONWAYPOLDATA[27647]:=[
,,,[4554290315,"RPn"],];
CONWAYPOLDATA[27653]:=[
,,,[1400209657,"RPn"],];
CONWAYPOLDATA[27673]:=[
,,,[5960570500,"RPn"],];
CONWAYPOLDATA[27689]:=[
,,,[5800208656,"RPn"],];
CONWAYPOLDATA[27691]:=[
,,,[4488821867,"RPn"],];
CONWAYPOLDATA[27697]:=[
,,,[6531118787,"RPn"],];
CONWAYPOLDATA[27701]:=[
,,,[9843467249,"RPn"],];
CONWAYPOLDATA[27733]:=[
,,,[2771275493,"RPn"],];
CONWAYPOLDATA[27737]:=[
,,,[6008139310,"RPn"],];
CONWAYPOLDATA[27739]:=[
,,,[1961091825,"RPn"],];
CONWAYPOLDATA[27743]:=[
,,,[7374200377,"RPn"],];
CONWAYPOLDATA[27749]:=[
,,,[2216423629,"RPn"],];
CONWAYPOLDATA[27751]:=[
,,,[3850479004,"RPn"],];
CONWAYPOLDATA[27763]:=[
,,,[4377531028,"RPn"],];
CONWAYPOLDATA[27767]:=[
,,,[2946300841,"RPn"],];
CONWAYPOLDATA[27773]:=[
,,,[2023457463,"RPn"],];
CONWAYPOLDATA[27779]:=[
,,,[1935307374,"RPn"],];
CONWAYPOLDATA[27791]:=[
,,,[3614497467,"RPn"],];
CONWAYPOLDATA[27793]:=[
,,,[11586457017,"RPn"],];
CONWAYPOLDATA[27799]:=[
,,,[10801635045,"RPn"],];
CONWAYPOLDATA[27803]:=[
,,,[8315849499,"RPn"],];
CONWAYPOLDATA[27809]:=[
,,,[2265543615,"RPn"],];
CONWAYPOLDATA[27817]:=[
,,,[12115388368,"RPn"],];
CONWAYPOLDATA[27823]:=[
,,,[4439410063,"RPn"],];
CONWAYPOLDATA[27827]:=[
,,,[3498271307,"RPn"],];
CONWAYPOLDATA[27847]:=[
,,,[2080560764,"RPn"],];
CONWAYPOLDATA[27851]:=[
,,,[3769883511,"RPn"],];
CONWAYPOLDATA[27883]:=[
,,,[2820839464,"RPn"],];
CONWAYPOLDATA[27893]:=[
,,,[7564693174,"RPn"],];
CONWAYPOLDATA[27901]:=[
,,,[6702545628,"RPn"],];
CONWAYPOLDATA[27917]:=[
,,,[6060529449,"RPn"],];
CONWAYPOLDATA[27919]:=[
,,,[2900672427,"RPn"],];
CONWAYPOLDATA[27941]:=[
,,,[5333042790,"RPn"],];
CONWAYPOLDATA[27943]:=[
,,,[7752254438,"RPn"],];
CONWAYPOLDATA[27947]:=[
,,,[8501393561,"RPn"],];
CONWAYPOLDATA[27953]:=[
,,,[3873475166,"RPn"],];
CONWAYPOLDATA[27961]:=[
,,,[780727055,"RPn"],];
CONWAYPOLDATA[27967]:=[
,,,[5360127256,"RPn"],];
CONWAYPOLDATA[27983]:=[
,,,[2271659945,"RPn"],];
CONWAYPOLDATA[27997]:=[
,,,[5231183461,"RPn"],];
CONWAYPOLDATA[28001]:=[
,,,[6226778380,"RPn"],];
CONWAYPOLDATA[28019]:=[
,,,[7483258484,"RPn"],];
CONWAYPOLDATA[28027]:=[
,,,[2227698070,"RPn"],];
CONWAYPOLDATA[28031]:=[
,,,[2073677337,"RPn"],];
CONWAYPOLDATA[28051]:=[
,,,[6992216670,"RPn"],];
CONWAYPOLDATA[28057]:=[
,,,[9999122007,"RPn"],];
CONWAYPOLDATA[28069]:=[
,,,[13134271039,"RPn"],];
CONWAYPOLDATA[28081]:=[
,,,[16395232274,"RPn"],];
CONWAYPOLDATA[28087]:=[
,,,[5444524518,"RPn"],];
CONWAYPOLDATA[28097]:=[
,,,[1232250132,"RPn"],];
CONWAYPOLDATA[28099]:=[
,,,[7081509982,"RPn"],];
CONWAYPOLDATA[28109]:=[
,,,[6178217657,"RPn"],];
CONWAYPOLDATA[28111]:=[
,,,[2128058925,"RPn"],];
CONWAYPOLDATA[28123]:=[
,,,[6997058648,"RPn"],];
CONWAYPOLDATA[28151]:=[
,,,[2210979547,"RPn"],];
CONWAYPOLDATA[28163]:=[
,,,[6995661039,"RPn"],];
CONWAYPOLDATA[28181]:=[
,,,[3053129542,"RPn"],];
CONWAYPOLDATA[28183]:=[
,,,[3971294716,"RPn"],];
CONWAYPOLDATA[28201]:=[
,,,[11684322934,"RPn"],];
CONWAYPOLDATA[28211]:=[
,,,[6886982166,"RPn"],];
CONWAYPOLDATA[28219]:=[
,,,[3003743239,"RPn"],];
CONWAYPOLDATA[28229]:=[
,,,[1484252593,"RPn"],];
CONWAYPOLDATA[28277]:=[
,,,[5316415326,"RPn"],];
CONWAYPOLDATA[28279]:=[
,,,[5322956173,"RPn"],];
CONWAYPOLDATA[28283]:=[
,,,[2314963552,"RPn"],];
CONWAYPOLDATA[28289]:=[
,,,[6092064445,"RPn"],];
CONWAYPOLDATA[28297]:=[
,,,[12616245752,"RPn"],];
CONWAYPOLDATA[28307]:=[
,,,[2176100627,"RPn"],];
CONWAYPOLDATA[28309]:=[
,,,[8793568054,"RPn"],];
CONWAYPOLDATA[28319]:=[
,,,[2269597943,"RPn"],];
CONWAYPOLDATA[28349]:=[
,,,[7147208137,"RPn"],];
CONWAYPOLDATA[28351]:=[
,,,[3159038532,"RPn"],];
CONWAYPOLDATA[28387]:=[
,,,[6970740109,"RPn"],];
CONWAYPOLDATA[28393]:=[
,,,[5261052557,"RPn"],];
CONWAYPOLDATA[28403]:=[
,,,[3226808029,"RPn"],];
CONWAYPOLDATA[28409]:=[
,,,[2351327706,"RPn"],];
CONWAYPOLDATA[28411]:=[
,,,[2169833305,"RPn"],];
CONWAYPOLDATA[28429]:=[
,,,[9452301354,"RPn"],];
CONWAYPOLDATA[28433]:=[
,,,[7958965363,"RPn"],];
CONWAYPOLDATA[28439]:=[
,,,[2901488986,"RPn"],];
CONWAYPOLDATA[28447]:=[
,,,[4046045260,"RPn"],];
CONWAYPOLDATA[28463]:=[
,,,[6232685430,"RPn"],];
CONWAYPOLDATA[28477]:=[
,,,[10142112029,"RPn"],];
CONWAYPOLDATA[28493]:=[
,,,[3905649484,"RPn"],];
CONWAYPOLDATA[28499]:=[
,,,[691243247,"RPn"],];
CONWAYPOLDATA[28513]:=[
,,,[5684123581,"RPn"],];
CONWAYPOLDATA[28517]:=[
,,,[4049414002,"RPn"],];
CONWAYPOLDATA[28537]:=[
,,,[5434158230,"RPn"],];
CONWAYPOLDATA[28541]:=[
,,,[6346576549,"RPn"],];
CONWAYPOLDATA[28547]:=[
,,,[1345248830,"RPn"],];
CONWAYPOLDATA[28549]:=[
,,,[7943987644,"RPn"],];
CONWAYPOLDATA[28559]:=[
,,,[3063238351,"RPn"],];
CONWAYPOLDATA[28571]:=[
,,,[7235748607,"RPn"],];
CONWAYPOLDATA[28573]:=[
,,,[6292460354,"RPn"],];
CONWAYPOLDATA[28579]:=[
,,,[2243994503,"RPn"],];
CONWAYPOLDATA[28591]:=[
,,,[3021525474,"RPn"],];
CONWAYPOLDATA[28597]:=[
,,,[5448700800,"RPn"],];
CONWAYPOLDATA[28603]:=[
,,,[7083447143,"RPn"],];
CONWAYPOLDATA[28607]:=[
,,,[3273327373,"RPn"],];
CONWAYPOLDATA[28619]:=[
,,,[16328799404,"RPn"],];
CONWAYPOLDATA[28621]:=[
,,,[3232799205,"RPn"],];
CONWAYPOLDATA[28627]:=[
,,,[4794593100,"RPn"],];
CONWAYPOLDATA[28631]:=[
,,,[6243648074,"RPn"],];
CONWAYPOLDATA[28643]:=[
,,,[7383592542,"RPn"],];
CONWAYPOLDATA[28649]:=[
,,,[3773016005,"RPn"],];
CONWAYPOLDATA[28657]:=[
,,,[1330573172,"RPn"],];
CONWAYPOLDATA[28661]:=[
,,,[3166266655,"RPn"],];
CONWAYPOLDATA[28663]:=[
,,,[4615402252,"RPn"],];
CONWAYPOLDATA[28669]:=[
,,,[9609820137,"RPn"],];
CONWAYPOLDATA[28687]:=[
,,,[6415589373,"RPn"],];
CONWAYPOLDATA[28697]:=[
,,,[2064232607,"RPn"],];
CONWAYPOLDATA[28703]:=[
,,,[3294185909,"RPn"],];
CONWAYPOLDATA[28711]:=[
,,,[3260880539,"RPn"],];
CONWAYPOLDATA[28723]:=[
,,,[7239603429,"RPn"],];
CONWAYPOLDATA[28729]:=[
,,,[10382143500,"RPn"],];
CONWAYPOLDATA[28751]:=[
,,,[5400932866,"RPn"],];
CONWAYPOLDATA[28753]:=[
,,,[8972488672,"RPn"],];
CONWAYPOLDATA[28759]:=[
,,,[3168321515,"RPn"],];
CONWAYPOLDATA[28771]:=[
,,,[7291348219,"RPn"],];
CONWAYPOLDATA[28789]:=[
,,,[3899210956,"RPn"],];
CONWAYPOLDATA[28793]:=[
,,,[5524599292,"RPn"],];
CONWAYPOLDATA[28807]:=[
,,,[557530689,"RPn"],];
CONWAYPOLDATA[28813]:=[
,,,[8033784727,"RPn"],];
CONWAYPOLDATA[28817]:=[
,,,[5506150644,"RPn"],];
CONWAYPOLDATA[28837]:=[
,,,[8064497748,"RPn"],];
CONWAYPOLDATA[28843]:=[
,,,[2323332495,"RPn"],];
CONWAYPOLDATA[28859]:=[
,,,[3837352373,"RPn"],];
CONWAYPOLDATA[28867]:=[
,,,[3032911358,"RPn"],];
CONWAYPOLDATA[28871]:=[
,,,[2929136189,"RPn"],];
CONWAYPOLDATA[28879]:=[
,,,[3312450182,"RPn"],];
CONWAYPOLDATA[28901]:=[
,,,[12186742475,"RPn"],];
CONWAYPOLDATA[28909]:=[
,,,[6305168538,"RPn"],];
CONWAYPOLDATA[28921]:=[
,,,[13833348126,"RPn"],];
CONWAYPOLDATA[28927]:=[
,,,[4994593677,"RPn"],];
CONWAYPOLDATA[28933]:=[
,,,[8098057372,"RPn"],];
CONWAYPOLDATA[28949]:=[
,,,[6661135953,"RPn"],];
CONWAYPOLDATA[28961]:=[
,,,[838391992,"RPn"],];
CONWAYPOLDATA[28979]:=[
,,,[5573936778,"RPn"],];
CONWAYPOLDATA[29009]:=[
,,,[4126124127,"RPn"],];
CONWAYPOLDATA[29017]:=[
,,,[19800881618,"RPn"],];
CONWAYPOLDATA[29021]:=[
,,,[4200035206,"RPn"],];
CONWAYPOLDATA[29023]:=[
,,,[5582109685,"RPn"],];
CONWAYPOLDATA[29027]:=[
,,,[2132468557,"RPn"],];
CONWAYPOLDATA[29033]:=[
,,,[4761208772,"RPn"],];
CONWAYPOLDATA[29059]:=[
,,,[2337186313,"RPn"],];
CONWAYPOLDATA[29063]:=[
,,,[3929375736,"RPn"],];
CONWAYPOLDATA[29077]:=[
,,,[8040924505,"RPn"],];
CONWAYPOLDATA[29101]:=[
,,,[5699663660,"RPn"],];
CONWAYPOLDATA[29123]:=[
,,,[10153442722,"RPn"],];
CONWAYPOLDATA[29129]:=[
,,,[848149096,"RPn"],];
CONWAYPOLDATA[29131]:=[
,,,[7561154969,"RPn"],];
CONWAYPOLDATA[29137]:=[
,,,[5568809130,"RPn"],];
CONWAYPOLDATA[29147]:=[
,,,[3960844126,"RPn"],];
CONWAYPOLDATA[29153]:=[
,,,[1356372481,"RPn"],];
CONWAYPOLDATA[29167]:=[
,,,[7324358709,"RPn"],];
CONWAYPOLDATA[29173]:=[
,,,[9135933374,"RPn"],];
CONWAYPOLDATA[29179]:=[
,,,[2541053228,"RPn"],];
CONWAYPOLDATA[29191]:=[
,,,[2349320878,"RPn"],];
CONWAYPOLDATA[29201]:=[
,,,[6794255075,"RPn"],];
CONWAYPOLDATA[29207]:=[
,,,[3412078573,"RPn"],];
CONWAYPOLDATA[29209]:=[
,,,[741645726,"RPn"],];
CONWAYPOLDATA[29221]:=[
,,,[6669693252,"RPn"],];
CONWAYPOLDATA[29231]:=[
,,,[3881672196,"RPn"],];
CONWAYPOLDATA[29243]:=[
,,,[6778966047,"RPn"],];
CONWAYPOLDATA[29251]:=[
,,,[6782283117,"RPn"],];
CONWAYPOLDATA[29269]:=[
,,,[2305577674,"RPn"],];
CONWAYPOLDATA[29287]:=[
,,,[2400216090,"RPn"],];
CONWAYPOLDATA[29297]:=[
,,,[21938208840,"RPn"],];
CONWAYPOLDATA[29303]:=[
,,,[9280553137,"RPn"],];
CONWAYPOLDATA[29311]:=[
,,,[2317474218,"RPn"],];
CONWAYPOLDATA[29327]:=[
,,,[2305366148,"RPn"],];
CONWAYPOLDATA[29333]:=[
,,,[3362265794,"RPn"],];
CONWAYPOLDATA[29339]:=[
,,,[787605457,"RPn"],];
CONWAYPOLDATA[29347]:=[
,,,[3235154589,"RPn"],];
CONWAYPOLDATA[29363]:=[
,,,[2376494407,"RPn"],];
CONWAYPOLDATA[29383]:=[
,,,[3889486482,"RPn"],];
CONWAYPOLDATA[29387]:=[
,,,[14326515146,"RPn"],];
CONWAYPOLDATA[29389]:=[
,,,[7773214168,"RPn"],];
CONWAYPOLDATA[29399]:=[
,,,[5155144062,"RPn"],];
CONWAYPOLDATA[29401]:=[
,,,[19742742112,"RPn"],];
CONWAYPOLDATA[29411]:=[
,,,[439194465,"RPn"],];
CONWAYPOLDATA[29423]:=[
,,,[4894545478,"RPn"],];
CONWAYPOLDATA[29429]:=[
,,,[6806839415,"RPn"],];
CONWAYPOLDATA[29437]:=[
,,,[11138313188,"RPn"],];
CONWAYPOLDATA[29443]:=[
,,,[17876346895,"RPn"],];
CONWAYPOLDATA[29453]:=[
,,,[2199962384,"RPn"],];
CONWAYPOLDATA[29473]:=[
,,,[13662385993,"RPn"],];
CONWAYPOLDATA[29483]:=[
,,,[2481790493,"RPn"],];
CONWAYPOLDATA[29501]:=[
,,,[2331641038,"RPn"],];
CONWAYPOLDATA[29527]:=[
,,,[5877880839,"RPn"],];
CONWAYPOLDATA[29531]:=[
,,,[2391627099,"RPn"],];
CONWAYPOLDATA[29537]:=[
,,,[5979322598,"RPn"],];
CONWAYPOLDATA[29567]:=[
,,,[6725309825,"RPn"],];
CONWAYPOLDATA[29569]:=[
,,,[18023222156,"RPn"],];
CONWAYPOLDATA[29573]:=[
,,,[6043479136,"RPn"],];
CONWAYPOLDATA[29581]:=[
,,,[6640135823,"RPn"],];
CONWAYPOLDATA[29587]:=[
,,,[2532055462,"RPn"],];
CONWAYPOLDATA[29599]:=[
,,,[8476384039,"RPn"],];
CONWAYPOLDATA[29611]:=[
,,,[6036409630,"RPn"],];
CONWAYPOLDATA[29629]:=[
,,,[4211762357,"RPn"],];
CONWAYPOLDATA[29633]:=[
,,,[4259921551,"RPn"],];
CONWAYPOLDATA[29641]:=[
,,,[735245012,"RPn"],];
CONWAYPOLDATA[29663]:=[
,,,[3519455629,"RPn"],];
CONWAYPOLDATA[29669]:=[
,,,[3471451016,"RPn"],];
CONWAYPOLDATA[29671]:=[
,,,[3440500811,"RPn"],];
CONWAYPOLDATA[29683]:=[
,,,[3115616740,"RPn"],];
CONWAYPOLDATA[29717]:=[
,,,[3391452627,"RPn"],];
CONWAYPOLDATA[29723]:=[
,,,[6678371703,"RPn"],];
CONWAYPOLDATA[29741]:=[
,,,[3142077170,"RPn"],];
CONWAYPOLDATA[29753]:=[
,,,[4320403380,"RPn"],];
CONWAYPOLDATA[29759]:=[
,,,[2450742934,"RPn"],];
CONWAYPOLDATA[29761]:=[
,,,[11269597887,"RPn"],];
CONWAYPOLDATA[29789]:=[
,,,[5824613383,"RPn"],];
CONWAYPOLDATA[29803]:=[
,,,[10394869165,"RPn"],];
CONWAYPOLDATA[29819]:=[
,,,[5104297150,"RPn"],];
CONWAYPOLDATA[29833]:=[
,,,[5983903145,"RPn"],];
CONWAYPOLDATA[29837]:=[
,,,[4164648462,"RPn"],];
CONWAYPOLDATA[29851]:=[
,,,[2366646984,"RPn"],];
CONWAYPOLDATA[29863]:=[
,,,[2519720498,"RPn"],];
CONWAYPOLDATA[29867]:=[
,,,[7052434978,"RPn"],];
CONWAYPOLDATA[29873]:=[
,,,[5973464829,"RPn"],];
CONWAYPOLDATA[29879]:=[
,,,[3429481752,"RPn"],];
CONWAYPOLDATA[29881]:=[
,,,[14948209305,"RPn"],];
CONWAYPOLDATA[29917]:=[
,,,[3478838513,"RPn"],];
CONWAYPOLDATA[29921]:=[
,,,[894907192,"RPn"],];
CONWAYPOLDATA[29927]:=[
,,,[6218651043,"RPn"],];
CONWAYPOLDATA[29947]:=[
,,,[3504697413,"RPn"],];
CONWAYPOLDATA[29959]:=[
,,,[3381712008,"RPn"],];
CONWAYPOLDATA[29983]:=[
,,,[15894827829,"RPn"],];
CONWAYPOLDATA[29989]:=[
,,,[3524097359,"RPn"],];
CONWAYPOLDATA[30011]:=[
,,,[808826463,"RPn"],];
CONWAYPOLDATA[30013]:=[
,,,[11651316719,"RPn"],];
CONWAYPOLDATA[30029]:=[
,,,[1418690078,"RPn"],];
CONWAYPOLDATA[30047]:=[
,,,[3370011431,"RPn"],];
CONWAYPOLDATA[30059]:=[
,,,[7211063925,"RPn"],];
CONWAYPOLDATA[30071]:=[
,,,[2644804605,"RPn"],];
CONWAYPOLDATA[30089]:=[
,,,[2275330183,"RPn"],];
CONWAYPOLDATA[30091]:=[
,,,[5980044633,"RPn"],];
CONWAYPOLDATA[30097]:=[
,,,[19594200405,"RPn"],];
CONWAYPOLDATA[30103]:=[
,,,[6103533768,"RPn"],];
CONWAYPOLDATA[30109]:=[
,,,[30500748201,"RPn"],];
CONWAYPOLDATA[30113]:=[
,,,[668930185,"RPn"],];
CONWAYPOLDATA[30119]:=[
,,,[7942681501,"RPn"],];
CONWAYPOLDATA[30133]:=[
,,,[6156322570,"RPn"],];
CONWAYPOLDATA[30137]:=[
,,,[6883953817,"RPn"],];
CONWAYPOLDATA[30139]:=[
,,,[11532447240,"RPn"],];
CONWAYPOLDATA[30161]:=[
,,,[4272697746,"RPn"],];
CONWAYPOLDATA[30169]:=[
,,,[2410171248,"RPn"],];
CONWAYPOLDATA[30181]:=[
,,,[6038191948,"RPn"],];
CONWAYPOLDATA[30187]:=[
,,,[6971657468,"RPn"],];
CONWAYPOLDATA[30197]:=[
,,,[1566861938,"RPn"],];
CONWAYPOLDATA[30203]:=[
,,,[8209779462,"RPn"],];
CONWAYPOLDATA[30211]:=[
,,,[5966914190,"RPn"],];
CONWAYPOLDATA[30223]:=[
,,,[5411669937,"RPn"],];
CONWAYPOLDATA[30241]:=[
,,,[11480602528,"RPn"],];
CONWAYPOLDATA[30253]:=[
,,,[6140572424,"RPn"],];
CONWAYPOLDATA[30259]:=[
,,,[3650657576,"RPn"],];
CONWAYPOLDATA[30269]:=[
,,,[3407774830,"RPn"],];
CONWAYPOLDATA[30271]:=[
,,,[2339887761,"RPn"],];
CONWAYPOLDATA[30293]:=[
,,,[7074142534,"RPn"],];
CONWAYPOLDATA[30307]:=[
,,,[8139672220,"RPn"],];
CONWAYPOLDATA[30313]:=[
,,,[6066116313,"RPn"],];
CONWAYPOLDATA[30319]:=[
,,,[14267818213,"RPn"],];
CONWAYPOLDATA[30323]:=[
,,,[2688801058,"RPn"],];
CONWAYPOLDATA[30341]:=[
,,,[3635033848,"RPn"],];
CONWAYPOLDATA[30347]:=[
,,,[13427788827,"RPn"],];
CONWAYPOLDATA[30367]:=[
,,,[11065491869,"RPn"],];
CONWAYPOLDATA[30389]:=[
,,,[6243207329,"RPn"],];
CONWAYPOLDATA[30391]:=[
,,,[3500800075,"RPn"],];
CONWAYPOLDATA[30403]:=[
,,,[13540158473,"RPn"],];
CONWAYPOLDATA[30427]:=[
,,,[6975694025,"RPn"],];
CONWAYPOLDATA[30431]:=[
,,,[4215515148,"RPn"],];
CONWAYPOLDATA[30449]:=[
,,,[926776216,"RPn"],];
CONWAYPOLDATA[30467]:=[
,,,[7213519257,"RPn"],];
CONWAYPOLDATA[30469]:=[
,,,[3696620958,"RPn"],];
CONWAYPOLDATA[30491]:=[
,,,[15773421176,"RPn"],];
CONWAYPOLDATA[30493]:=[
,,,[4431059808,"RPn"],];
CONWAYPOLDATA[30497]:=[
,,,[6365882789,"RPn"],];
CONWAYPOLDATA[30509]:=[
,,,[2708985639,"RPn"],];
CONWAYPOLDATA[30517]:=[
,,,[10109610728,"RPn"],];
CONWAYPOLDATA[30529]:=[
,,,[13636541088,"RPn"],];
CONWAYPOLDATA[30539]:=[
,,,[7076497082,"RPn"],];
CONWAYPOLDATA[30553]:=[
,,,[9926761364,"RPn"],];
CONWAYPOLDATA[30557]:=[
,,,[7015214948,"RPn"],];
CONWAYPOLDATA[30559]:=[
,,,[827140460,"RPn"],];
CONWAYPOLDATA[30577]:=[
,,,[14023957593,"RPn"],];
CONWAYPOLDATA[30593]:=[
,,,[4271578221,"RPn"],];
CONWAYPOLDATA[30631]:=[
,,,[2488768753,"RPn"],];
CONWAYPOLDATA[30637]:=[
,,,[3534835788,"RPn"],];
CONWAYPOLDATA[30643]:=[
,,,[8145093260,"RPn"],];
CONWAYPOLDATA[30649]:=[
,,,[28875311728,"RPn"],];
CONWAYPOLDATA[30661]:=[
,,,[6263735692,"RPn"],];
CONWAYPOLDATA[30671]:=[
,,,[3363289858,"RPn"],];
CONWAYPOLDATA[30677]:=[
,,,[6382104436,"RPn"],];
CONWAYPOLDATA[30689]:=[
,,,[941446456,"RPn"],];
CONWAYPOLDATA[30697]:=[
,,,[15957405702,"RPn"],];
CONWAYPOLDATA[30703]:=[
,,,[5389266890,"RPn"],];
CONWAYPOLDATA[30707]:=[
,,,[4506405787,"RPn"],];
CONWAYPOLDATA[30713]:=[
,,,[847003117,"RPn"],];
CONWAYPOLDATA[30727]:=[
,,,[6426306237,"RPn"],];
CONWAYPOLDATA[30757]:=[
,,,[6489603977,"RPn"],];
CONWAYPOLDATA[30763]:=[
,,,[7394071630,"RPn"],];
CONWAYPOLDATA[30773]:=[
,,,[12310369377,"RPn"],];
CONWAYPOLDATA[30781]:=[
,,,[6278492915,"RPn"],];
CONWAYPOLDATA[30803]:=[
,,,[12844481366,"RPn"],];
CONWAYPOLDATA[30809]:=[
,,,[5591956739,"RPn"],];
CONWAYPOLDATA[30817]:=[
,,,[6456315590,"RPn"],];
CONWAYPOLDATA[30829]:=[
,,,[10020442359,"RPn"],];
CONWAYPOLDATA[30839]:=[
,,,[5553949712,"RPn"],];
CONWAYPOLDATA[30841]:=[
,,,[20773449013,"RPn"],];
CONWAYPOLDATA[30851]:=[
,,,[8441543175,"RPn"],];
CONWAYPOLDATA[30853]:=[
,,,[12001847855,"RPn"],];
CONWAYPOLDATA[30859]:=[
,,,[6267185171,"RPn"],];
CONWAYPOLDATA[30869]:=[
,,,[1649731969,"RPn"],];
CONWAYPOLDATA[30871]:=[
,,,[3570231153,"RPn"],];
CONWAYPOLDATA[30881]:=[
,,,[2633439040,"RPn"],];
CONWAYPOLDATA[30893]:=[
,,,[12382624941,"RPn"],];
CONWAYPOLDATA[30911]:=[
,,,[7357374415,"RPn"],];
CONWAYPOLDATA[30931]:=[
,,,[12128137895,"RPn"],];
CONWAYPOLDATA[30937]:=[
,,,[19641777567,"RPn"],];
CONWAYPOLDATA[30941]:=[
,,,[7289111723,"RPn"],];
CONWAYPOLDATA[30949]:=[
,,,[5413939529,"RPn"],];
CONWAYPOLDATA[30971]:=[
,,,[6704973734,"RPn"],];
CONWAYPOLDATA[30977]:=[
,,,[2554797101,"RPn"],];
CONWAYPOLDATA[30983]:=[
,,,[2404590635,"RPn"],];
CONWAYPOLDATA[31013]:=[
,,,[4583845454,"RPn"],];
CONWAYPOLDATA[31019]:=[
,,,[8650144456,"RPn"],];
CONWAYPOLDATA[31033]:=[
,,,[6598981262,"RPn"],];
CONWAYPOLDATA[31039]:=[
,,,[595203871,"RPn"],];
CONWAYPOLDATA[31051]:=[
,,,[5559122643,"RPn"],];
CONWAYPOLDATA[31063]:=[
,,,[2749261881,"RPn"],];
CONWAYPOLDATA[31069]:=[
,,,[7533983950,"RPn"],];
CONWAYPOLDATA[31079]:=[
,,,[5761207478,"RPn"],];
CONWAYPOLDATA[31081]:=[
,,,[18002954400,"RPn"],];
CONWAYPOLDATA[31091]:=[
,,,[7356286057,"RPn"],];
CONWAYPOLDATA[31121]:=[
,,,[4780465692,"RPn"],];
CONWAYPOLDATA[31123]:=[
,,,[11222051236,"RPn"],];
CONWAYPOLDATA[31139]:=[
,,,[2473775579,"RPn"],];
CONWAYPOLDATA[31147]:=[
,,,[8459244879,"RPn"],];
CONWAYPOLDATA[31151]:=[
,,,[12465944885,"RPn"],];
CONWAYPOLDATA[31153]:=[
,,,[15497527155,"RPn"],];
CONWAYPOLDATA[31159]:=[
,,,[2806709246,"RPn"],];
CONWAYPOLDATA[31177]:=[
,,,[12275507279,"RPn"],];
CONWAYPOLDATA[31181]:=[
,,,[3801961694,"RPn"],];
CONWAYPOLDATA[31183]:=[
,,,[4861772716,"RPn"],];
CONWAYPOLDATA[31189]:=[
,,,[7443785076,"RPn"],];
CONWAYPOLDATA[31193]:=[
,,,[6466402484,"RPn"],];
CONWAYPOLDATA[31219]:=[
,,,[6822007109,"RPn"],];
CONWAYPOLDATA[31223]:=[
,,,[5736726687,"RPn"],];
CONWAYPOLDATA[31231]:=[
,,,[3694033917,"RPn"],];
CONWAYPOLDATA[31237]:=[
,,,[7805688988,"RPn"],];
CONWAYPOLDATA[31247]:=[
,,,[11620353094,"RPn"],];
CONWAYPOLDATA[31249]:=[
,,,[27188411216,"RPn"],];
CONWAYPOLDATA[31253]:=[
,,,[3853432396,"RPn"],];
CONWAYPOLDATA[31259]:=[
,,,[8457997704,"RPn"],];
CONWAYPOLDATA[31267]:=[
,,,[2811872579,"RPn"],];
CONWAYPOLDATA[31271]:=[
,,,[2580451656,"RPn"],];
CONWAYPOLDATA[31277]:=[
,,,[5840760813,"RPn"],];
CONWAYPOLDATA[31307]:=[
,,,[13592121894,"RPn"],];
CONWAYPOLDATA[31319]:=[
,,,[4731330018,"RPn"],];
CONWAYPOLDATA[31321]:=[
,,,[799092680,"RPn"],];
CONWAYPOLDATA[31327]:=[
,,,[4611522368,"RPn"],];
CONWAYPOLDATA[31333]:=[
,,,[6686932200,"RPn"],];
CONWAYPOLDATA[31337]:=[
,,,[867376826,"RPn"],];
CONWAYPOLDATA[31357]:=[
,,,[12569578880,"RPn"],];
CONWAYPOLDATA[31379]:=[
,,,[4798915988,"RPn"],];
CONWAYPOLDATA[31387]:=[
,,,[10351369828,"RPn"],];
CONWAYPOLDATA[31391]:=[
,,,[4464616397,"RPn"],];
CONWAYPOLDATA[31393]:=[
,,,[10673117717,"RPn"],];
CONWAYPOLDATA[31397]:=[
,,,[9779631753,"RPn"],];
CONWAYPOLDATA[31469]:=[
,,,[617107092,"RPn"],];
CONWAYPOLDATA[31477]:=[
,,,[530387456,"RPn"],];
CONWAYPOLDATA[31481]:=[
,,,[14828747284,"RPn"],];
CONWAYPOLDATA[31489]:=[
,,,[897058639,"RPn"],];
CONWAYPOLDATA[31511]:=[
,,,[7504596745,"RPn"],];
CONWAYPOLDATA[31513]:=[
,,,[12715306429,"RPn"],];
CONWAYPOLDATA[31517]:=[
,,,[1940501692,"RPn"],];
CONWAYPOLDATA[31531]:=[
,,,[6610221904,"RPn"],];
CONWAYPOLDATA[31541]:=[
,,,[4974047244,"RPn"],];
CONWAYPOLDATA[31543]:=[
,,,[2648287197,"RPn"],];
CONWAYPOLDATA[31547]:=[
,,,[2545653620,"RPn"],];
CONWAYPOLDATA[31567]:=[
,,,[2778527346,"RPn"],];
CONWAYPOLDATA[31573]:=[
,,,[3583409213,"RPn"],];
CONWAYPOLDATA[31583]:=[
,,,[7945745894,"RPn"],];
CONWAYPOLDATA[31601]:=[
,,,[2640137149,"RPn"],];
CONWAYPOLDATA[31607]:=[
,,,[7971759510,"RPn"],];
CONWAYPOLDATA[31627]:=[
,,,[2686682026,"RPn"],];
CONWAYPOLDATA[31643]:=[
,,,[4676835402,"RPn"],];
CONWAYPOLDATA[31649]:=[
,,,[4879041492,"RPn"],];
CONWAYPOLDATA[31657]:=[
,,,[6753261187,"RPn"],];
CONWAYPOLDATA[31663]:=[
,,,[6811344563,"RPn"],];
CONWAYPOLDATA[31667]:=[
,,,[2685709939,"RPn"],];
CONWAYPOLDATA[31687]:=[
,,,[5701600348,"RPn"],];
CONWAYPOLDATA[31699]:=[
,,,[10579319359,"RPn"],];
CONWAYPOLDATA[31721]:=[
,,,[12015407275,"RPn"],];
CONWAYPOLDATA[31723]:=[
,,,[5891405225,"RPn"],];
CONWAYPOLDATA[31727]:=[
,,,[4026283213,"RPn"],];
CONWAYPOLDATA[31729]:=[
,,,[24902061451,"RPn"],];
CONWAYPOLDATA[31741]:=[
,,,[7052310609,"RPn"],];
CONWAYPOLDATA[31751]:=[
,,,[3720613942,"RPn"],];
CONWAYPOLDATA[31769]:=[
,,,[5589501404,"RPn"],];
CONWAYPOLDATA[31771]:=[
,,,[8945506312,"RPn"],];
CONWAYPOLDATA[31793]:=[
,,,[3836048004,"RPn"],];
CONWAYPOLDATA[31799]:=[
,,,[2920261176,"RPn"],];
CONWAYPOLDATA[31817]:=[
,,,[997303868,"RPn"],];
CONWAYPOLDATA[31847]:=[
,,,[4056798253,"RPn"],];
CONWAYPOLDATA[31849]:=[
,,,[10941660266,"RPn"],];
CONWAYPOLDATA[31859]:=[
,,,[7617391325,"RPn"],];
CONWAYPOLDATA[31873]:=[
,,,[17806074572,"RPn"],];
CONWAYPOLDATA[31883]:=[
,,,[4705643855,"RPn"],];
CONWAYPOLDATA[31891]:=[
,,,[7927656128,"RPn"],];
CONWAYPOLDATA[31907]:=[
,,,[4739689131,"RPn"],];
CONWAYPOLDATA[31957]:=[
,,,[13053156222,"RPn"],];
CONWAYPOLDATA[31963]:=[
,,,[11207730063,"RPn"],];
CONWAYPOLDATA[31973]:=[
,,,[9736673746,"RPn"],];
CONWAYPOLDATA[31981]:=[
,,,[23223738719,"RPn"],];
CONWAYPOLDATA[31991]:=[
,,,[5901795660,"RPn"],];
CONWAYPOLDATA[32003]:=[
,,,[556724190,"RPn"],];
CONWAYPOLDATA[32009]:=[
,,,[4721231476,"RPn"],];
CONWAYPOLDATA[32027]:=[
,,,[15033217586,"RPn"],];
CONWAYPOLDATA[32029]:=[
,,,[13052297937,"RPn"],];
CONWAYPOLDATA[32051]:=[
,,,[3892081144,"RPn"],];
CONWAYPOLDATA[32057]:=[
,,,[1677574870,"RPn"],];
CONWAYPOLDATA[32059]:=[
,,,[1622185402,"RPn"],];
CONWAYPOLDATA[32063]:=[
,,,[2635738920,"RPn"],];
CONWAYPOLDATA[32069]:=[
,,,[6711207908,"RPn"],];
CONWAYPOLDATA[32077]:=[
,,,[6866466776,"RPn"],];
CONWAYPOLDATA[32083]:=[
,,,[8958054847,"RPn"],];
CONWAYPOLDATA[32089]:=[
,,,[13018667758,"RPn"],];
CONWAYPOLDATA[32099]:=[
,,,[8009021492,"RPn"],];
CONWAYPOLDATA[32117]:=[
,,,[7888898712,"RPn"],];
CONWAYPOLDATA[32119]:=[
,,,[3957125041,"RPn"],];
CONWAYPOLDATA[32141]:=[
,,,[2638551115,"RPn"],];
CONWAYPOLDATA[32143]:=[
,,,[1825754549,"RPn"],];
CONWAYPOLDATA[32159]:=[
,,,[6070204211,"RPn"],];
CONWAYPOLDATA[32173]:=[
,,,[8044987347,"RPn"],];
CONWAYPOLDATA[32183]:=[
,,,[4142853229,"RPn"],];
CONWAYPOLDATA[32189]:=[
,,,[4732909617,"RPn"],];
CONWAYPOLDATA[32191]:=[
,,,[2835061376,"RPn"],];
CONWAYPOLDATA[32203]:=[
,,,[2854345110,"RPn"],];
CONWAYPOLDATA[32213]:=[
,,,[1803928002,"RPn"],];
CONWAYPOLDATA[32233]:=[
,,,[21684815221,"RPn"],];
CONWAYPOLDATA[32237]:=[
,,,[6827538706,"RPn"],];
CONWAYPOLDATA[32251]:=[
,,,[2893462970,"RPn"],];
CONWAYPOLDATA[32257]:=[
,,,[21536289294,"RPn"],];
CONWAYPOLDATA[32261]:=[
,,,[2000214263,"RPn"],];
CONWAYPOLDATA[32297]:=[
,,,[10148040373,"RPn"],];
CONWAYPOLDATA[32299]:=[
,,,[7977853012,"RPn"],];
CONWAYPOLDATA[32303]:=[
,,,[7967599561,"RPn"],];
CONWAYPOLDATA[32309]:=[
,,,[1857412103,"RPn"],];
CONWAYPOLDATA[32321]:=[
,,,[659865542,"RPn"],];
CONWAYPOLDATA[32323]:=[
,,,[11427828975,"RPn"],];
CONWAYPOLDATA[32327]:=[
,,,[3766321794,"RPn"],];
CONWAYPOLDATA[32341]:=[
,,,[6863180635,"RPn"],];
CONWAYPOLDATA[32353]:=[
,,,[17793276484,"RPn"],];
CONWAYPOLDATA[32359]:=[
,,,[3985269725,"RPn"],];
CONWAYPOLDATA[32363]:=[
,,,[887814181,"RPn"],];
CONWAYPOLDATA[32369]:=[
,,,[5010818313,"RPn"],];
CONWAYPOLDATA[32371]:=[
,,,[7290434767,"RPn"],];
CONWAYPOLDATA[32377]:=[
,,,[16564299844,"RPn"],];
CONWAYPOLDATA[32381]:=[
,,,[2041168718,"RPn"],];
CONWAYPOLDATA[32401]:=[
,,,[649899265,"RPn"],];
CONWAYPOLDATA[32411]:=[
,,,[2038360203,"RPn"],];
CONWAYPOLDATA[32413]:=[
,,,[6954922241,"RPn"],];
CONWAYPOLDATA[32423]:=[
,,,[10096068283,"RPn"],];
CONWAYPOLDATA[32429]:=[
,,,[2666150238,"RPn"],];
CONWAYPOLDATA[32441]:=[
,,,[8333671170,"RPn"],];
CONWAYPOLDATA[32443]:=[
,,,[2881197946,"RPn"],];
CONWAYPOLDATA[32467]:=[
,,,[9375495592,"RPn"],];
CONWAYPOLDATA[32479]:=[
,,,[4099726739,"RPn"],];
CONWAYPOLDATA[32491]:=[
,,,[11165369697,"RPn"],];
CONWAYPOLDATA[32497]:=[
,,,[22721999898,"RPn"],];
CONWAYPOLDATA[32503]:=[
,,,[4210276108,"RPn"],];
CONWAYPOLDATA[32507]:=[
,,,[13401043259,"RPn"],];
CONWAYPOLDATA[32531]:=[
,,,[7954349998,"RPn"],];
CONWAYPOLDATA[32533]:=[
,,,[18819364512,"RPn"],];
CONWAYPOLDATA[32537]:=[
,,,[12587231286,"RPn"],];
CONWAYPOLDATA[32561]:=[
,,,[632595114,"RPn"],];
CONWAYPOLDATA[32563]:=[
,,,[8224111282,"RPn"],];
CONWAYPOLDATA[32569]:=[
,,,[668120473,"RPn"],];
CONWAYPOLDATA[32573]:=[
,,,[6257761897,"RPn"],];
CONWAYPOLDATA[32579]:=[
,,,[760915130,"RPn"],];
CONWAYPOLDATA[32587]:=[
,,,[9422042247,"RPn"],];
CONWAYPOLDATA[32603]:=[
,,,[10366352073,"RPn"],];
CONWAYPOLDATA[32609]:=[
,,,[3819231301,"RPn"],];
CONWAYPOLDATA[32611]:=[
,,,[7316669185,"RPn"],];
CONWAYPOLDATA[32621]:=[
,,,[4147401322,"RPn"],];
CONWAYPOLDATA[32633]:=[
,,,[14765225082,"RPn"],];
CONWAYPOLDATA[32647]:=[
,,,[5900161725,"RPn"],];
CONWAYPOLDATA[32653]:=[
,,,[7129488675,"RPn"],];
CONWAYPOLDATA[32687]:=[
,,,[7401350102,"RPn"],];
CONWAYPOLDATA[32693]:=[
,,,[5032989273,"RPn"],];
CONWAYPOLDATA[32707]:=[
,,,[1828681080,"RPn"],];
CONWAYPOLDATA[32713]:=[
,,,[7017756330,"RPn"],];
CONWAYPOLDATA[32717]:=[
,,,[3105334057,"RPn"],];
CONWAYPOLDATA[32719]:=[
,,,[5352533932,"RPn"],];
CONWAYPOLDATA[32749]:=[
,,,[4227830404,"RPn"],];
CONWAYPOLDATA[32771]:=[
,,,[8574728778,"RPn"],];
CONWAYPOLDATA[32779]:=[
,,,[4076035874,"RPn"],];
CONWAYPOLDATA[32783]:=[
,,,[4174816708,"RPn"],];
CONWAYPOLDATA[32789]:=[
,,,[12884634286,"RPn"],];
CONWAYPOLDATA[32797]:=[
,,,[10619307835,"RPn"],];
CONWAYPOLDATA[32801]:=[
,,,[5053551670,"RPn"],];
CONWAYPOLDATA[32803]:=[
,,,[848482403,"RPn"],];
CONWAYPOLDATA[32831]:=[
,,,[2760594648,"RPn"],];
CONWAYPOLDATA[32833]:=[
,,,[11763998239,"RPn"],];
CONWAYPOLDATA[32839]:=[
,,,[9324042954,"RPn"],];
CONWAYPOLDATA[32843]:=[
,,,[12451011203,"RPn"],];
CONWAYPOLDATA[32869]:=[
,,,[11707609116,"RPn"],];
CONWAYPOLDATA[32887]:=[
,,,[3030043748,"RPn"],];
CONWAYPOLDATA[32909]:=[
,,,[17949687508,"RPn"],];
CONWAYPOLDATA[32911]:=[
,,,[2779169398,"RPn"],];
CONWAYPOLDATA[32917]:=[
,,,[10447329130,"RPn"],];
CONWAYPOLDATA[32933]:=[
,,,[3934307914,"RPn"],];
CONWAYPOLDATA[32939]:=[
,,,[697779778,"RPn"],];
CONWAYPOLDATA[32941]:=[
,,,[4005098546,"RPn"],];
CONWAYPOLDATA[32957]:=[
,,,[10372490708,"RPn"],];
CONWAYPOLDATA[32969]:=[
,,,[1086559336,"RPn"],];
CONWAYPOLDATA[32971]:=[
,,,[8422277106,"RPn"],];
CONWAYPOLDATA[32983]:=[
,,,[3821938111,"RPn"],];
CONWAYPOLDATA[32987]:=[
,,,[3100679041,"RPn"],];
CONWAYPOLDATA[32993]:=[
,,,[2152364344,"RPn"],];
CONWAYPOLDATA[32999]:=[
,,,[6484171511,"RPn"],];
CONWAYPOLDATA[33013]:=[
,,,[7108260126,"RPn"],];
CONWAYPOLDATA[33023]:=[
,,,[8530435319,"RPn"],];
CONWAYPOLDATA[33029]:=[
,,,[4184080693,"RPn"],];
CONWAYPOLDATA[33037]:=[
,,,[7415022504,"RPn"],];
CONWAYPOLDATA[33049]:=[
,,,[22432174024,"RPn"],];
CONWAYPOLDATA[33053]:=[
,,,[5132271524,"RPn"],];
CONWAYPOLDATA[33071]:=[
,,,[1014353723,"RPn"],];
CONWAYPOLDATA[33073]:=[
,,,[7161329768,"RPn"],];
CONWAYPOLDATA[33083]:=[
,,,[9742050261,"RPn"],];
CONWAYPOLDATA[33091]:=[
,,,[4208314837,"RPn"],];
CONWAYPOLDATA[33107]:=[
,,,[5038521225,"RPn"],];
CONWAYPOLDATA[33113]:=[
,,,[749280967,"RPn"],];
CONWAYPOLDATA[33119]:=[
,,,[5484042741,"RPn"],];
CONWAYPOLDATA[33149]:=[
,,,[8248167331,"RPn"],];
CONWAYPOLDATA[33151]:=[
,,,[3063351309,"RPn"],];
CONWAYPOLDATA[33161]:=[
,,,[2880497107,"RPn"],];
CONWAYPOLDATA[33179]:=[
,,,[7679578163,"RPn"],];
CONWAYPOLDATA[33181]:=[
,,,[8454054272,"RPn"],];
CONWAYPOLDATA[33191]:=[
,,,[2882771121,"RPn"],];
CONWAYPOLDATA[33199]:=[
,,,[7298268969,"RPn"],];
CONWAYPOLDATA[33203]:=[
,,,[5123853759,"RPn"],];
CONWAYPOLDATA[33211]:=[
,,,[3041031639,"RPn"],];
CONWAYPOLDATA[33223]:=[
,,,[2990070010,"RPn"],];
CONWAYPOLDATA[33247]:=[
,,,[11953593138,"RPn"],];
CONWAYPOLDATA[33287]:=[
,,,[2990603946,"RPn"],];
CONWAYPOLDATA[33289]:=[
,,,[27183830718,"RPn"],];
CONWAYPOLDATA[33301]:=[
,,,[14276138702,"RPn"],];
CONWAYPOLDATA[33311]:=[
,,,[2917510635,"RPn"],];
CONWAYPOLDATA[33317]:=[
,,,[4407905736,"RPn"],];
CONWAYPOLDATA[33329]:=[
,,,[1110422296,"RPn"],];
CONWAYPOLDATA[33331]:=[
,,,[6194299705,"RPn"],];
CONWAYPOLDATA[33343]:=[
,,,[14452456667,"RPn"],];
CONWAYPOLDATA[33347]:=[
,,,[8697264419,"RPn"],];
CONWAYPOLDATA[33349]:=[
,,,[7638421707,"RPn"],];
CONWAYPOLDATA[33353]:=[
,,,[574738899,"RPn"],];
CONWAYPOLDATA[33359]:=[
,,,[6639875444,"RPn"],];
CONWAYPOLDATA[33377]:=[
,,,[7252154565,"RPn"],];
CONWAYPOLDATA[33391]:=[
,,,[5330806374,"RPn"],];
CONWAYPOLDATA[33403]:=[
,,,[6474870926,"RPn"],];
CONWAYPOLDATA[33409]:=[
,,,[870605138,"RPn"],];
CONWAYPOLDATA[33413]:=[
,,,[15333292528,"RPn"],];
CONWAYPOLDATA[33427]:=[
,,,[11954765428,"RPn"],];
CONWAYPOLDATA[33457]:=[
,,,[14285068386,"RPn"],];
CONWAYPOLDATA[33461]:=[
,,,[4449844549,"RPn"],];
CONWAYPOLDATA[33469]:=[
,,,[11970120914,"RPn"],];
CONWAYPOLDATA[33479]:=[
,,,[3123155490,"RPn"],];
CONWAYPOLDATA[33487]:=[
,,,[5372587312,"RPn"],];
CONWAYPOLDATA[33493]:=[
,,,[10095794992,"RPn"],];
CONWAYPOLDATA[33503]:=[
,,,[6292667477,"RPn"],];
CONWAYPOLDATA[33521]:=[
,,,[12330163520,"RPn"],];
CONWAYPOLDATA[33529]:=[
,,,[851971897,"RPn"],];
CONWAYPOLDATA[33533]:=[
,,,[7380680368,"RPn"],];
CONWAYPOLDATA[33547]:=[
,,,[8953291738,"RPn"],];
CONWAYPOLDATA[33563]:=[
,,,[16510042458,"RPn"],];
CONWAYPOLDATA[33569]:=[
,,,[1126474936,"RPn"],];
CONWAYPOLDATA[33577]:=[
,,,[12356772506,"RPn"],];
CONWAYPOLDATA[33581]:=[
,,,[3317634897,"RPn"],];
CONWAYPOLDATA[33587]:=[
,,,[11039072883,"RPn"],];
CONWAYPOLDATA[33589]:=[
,,,[4282631091,"RPn"],];
CONWAYPOLDATA[33599]:=[
,,,[4284141303,"RPn"],];
CONWAYPOLDATA[33601]:=[
,,,[14542546430,"RPn"],];
CONWAYPOLDATA[33613]:=[
,,,[4004955342,"RPn"],];
CONWAYPOLDATA[33617]:=[
,,,[13495712738,"RPn"],];
CONWAYPOLDATA[33619]:=[
,,,[3208059458,"RPn"],];
CONWAYPOLDATA[33623]:=[
,,,[5215532519,"RPn"],];
CONWAYPOLDATA[33629]:=[
,,,[672849034,"RPn"],];
CONWAYPOLDATA[33637]:=[
,,,[7563548548,"RPn"],];
CONWAYPOLDATA[33641]:=[
,,,[5623126794,"RPn"],];
CONWAYPOLDATA[33647]:=[
,,,[6383744374,"RPn"],];
CONWAYPOLDATA[33679]:=[
,,,[4508776128,"RPn"],];
CONWAYPOLDATA[33703]:=[
,,,[4543434029,"RPn"],];
CONWAYPOLDATA[33713]:=[
,,,[3119160476,"RPn"],];
CONWAYPOLDATA[33721]:=[
,,,[28427005337,"RPn"],];
CONWAYPOLDATA[33739]:=[
,,,[3240664691,"RPn"],];
CONWAYPOLDATA[33749]:=[
,,,[14531610673,"RPn"],];
CONWAYPOLDATA[33751]:=[
,,,[4192954238,"RPn"],];
CONWAYPOLDATA[33757]:=[
,,,[7758607611,"RPn"],];
CONWAYPOLDATA[33767]:=[
,,,[5151290923,"RPn"],];
CONWAYPOLDATA[33769]:=[
,,,[6824444759,"RPn"],];
CONWAYPOLDATA[33773]:=[
,,,[5402329082,"RPn"],];
CONWAYPOLDATA[33791]:=[
,,,[13307166135,"RPn"],];
CONWAYPOLDATA[33797]:=[
,,,[17098409258,"RPn"],];
CONWAYPOLDATA[33809]:=[
,,,[8923547463,"RPn"],];
CONWAYPOLDATA[33811]:=[
,,,[828437137,"RPn"],];
CONWAYPOLDATA[33827]:=[
,,,[10298156574,"RPn"],];
CONWAYPOLDATA[33829]:=[
,,,[8995604708,"RPn"],];
CONWAYPOLDATA[33851]:=[
,,,[7994082907,"RPn"],];
CONWAYPOLDATA[33857]:=[
,,,[5602148508,"RPn"],];
CONWAYPOLDATA[33863]:=[
,,,[6569455868,"RPn"],];
CONWAYPOLDATA[33871]:=[
,,,[5494553635,"RPn"],];
CONWAYPOLDATA[33889]:=[
,,,[32988399838,"RPn"],];
CONWAYPOLDATA[33893]:=[
,,,[5204744654,"RPn"],];
CONWAYPOLDATA[33911]:=[
,,,[4360072925,"RPn"],];
CONWAYPOLDATA[33923]:=[
,,,[27149255362,"RPn"],];
CONWAYPOLDATA[33931]:=[
,,,[4064255182,"RPn"],];
CONWAYPOLDATA[33937]:=[
,,,[7596831392,"RPn"],];
CONWAYPOLDATA[33941]:=[
,,,[4355512768,"RPn"],];
CONWAYPOLDATA[33961]:=[
,,,[16977579367,"RPn"],];
CONWAYPOLDATA[33967]:=[
,,,[6469252922,"RPn"],];
CONWAYPOLDATA[33997]:=[
,,,[4448677437,"RPn"],];
CONWAYPOLDATA[34019]:=[
,,,[747567527,"RPn"],];
CONWAYPOLDATA[34031]:=[
,,,[5790238533,"RPn"],];
CONWAYPOLDATA[34033]:=[
,,,[14552680972,"RPn"],];
CONWAYPOLDATA[34039]:=[
,,,[4475243489,"RPn"],];
CONWAYPOLDATA[34057]:=[
,,,[29836384109,"RPn"],];
CONWAYPOLDATA[34061]:=[
,,,[2116414298,"RPn"],];
CONWAYPOLDATA[34123]:=[
,,,[10479173302,"RPn"],];
CONWAYPOLDATA[34127]:=[
,,,[3483035752,"RPn"],];
CONWAYPOLDATA[34129]:=[
,,,[21904879565,"RPn"],];
CONWAYPOLDATA[34141]:=[
,,,[7593436376,"RPn"],];
CONWAYPOLDATA[34147]:=[
,,,[3092147441,"RPn"],];
CONWAYPOLDATA[34157]:=[
,,,[14658783965,"RPn"],];
CONWAYPOLDATA[34159]:=[
,,,[8864875365,"RPn"],];
CONWAYPOLDATA[34171]:=[
,,,[10136929665,"RPn"],];
CONWAYPOLDATA[34183]:=[
,,,[3236480626,"RPn"],];
CONWAYPOLDATA[34211]:=[
,,,[9229956747,"RPn"],];
CONWAYPOLDATA[34213]:=[
,,,[12449050099,"RPn"],];
CONWAYPOLDATA[34217]:=[
,,,[15093221354,"RPn"],];
CONWAYPOLDATA[34231]:=[
,,,[5312856592,"RPn"],];
CONWAYPOLDATA[34253]:=[
,,,[5459825443,"RPn"],];
CONWAYPOLDATA[34259]:=[
,,,[9167125999,"RPn"],];
CONWAYPOLDATA[34261]:=[
,,,[4454032785,"RPn"],];
CONWAYPOLDATA[34267]:=[
,,,[3111100932,"RPn"],];
CONWAYPOLDATA[34273]:=[
,,,[21844890472,"RPn"],];
CONWAYPOLDATA[34283]:=[
,,,[9289218833,"RPn"],];
CONWAYPOLDATA[34297]:=[
,,,[7914067052,"RPn"],];
CONWAYPOLDATA[34301]:=[
,,,[3404374253,"RPn"],];
CONWAYPOLDATA[34303]:=[
,,,[3067648701,"RPn"],];
CONWAYPOLDATA[34313]:=[
,,,[869457110,"RPn"],];
CONWAYPOLDATA[34319]:=[
,,,[23402366352,"RPn"],];
CONWAYPOLDATA[34327]:=[
,,,[3423774985,"RPn"],];
CONWAYPOLDATA[34337]:=[
,,,[7863207340,"RPn"],];
CONWAYPOLDATA[34351]:=[
,,,[4655350576,"RPn"],];
CONWAYPOLDATA[34361]:=[
,,,[9303859251,"RPn"],];
CONWAYPOLDATA[34367]:=[
,,,[5396684382,"RPn"],];
CONWAYPOLDATA[34369]:=[
,,,[22013310138,"RPn"],];
CONWAYPOLDATA[34381]:=[
,,,[13639252135,"RPn"],];
CONWAYPOLDATA[34403]:=[
,,,[16014665308,"RPn"],];
CONWAYPOLDATA[34421]:=[
,,,[28359496323,"RPn"],];
CONWAYPOLDATA[34429]:=[
,,,[4288889390,"RPn"],];
CONWAYPOLDATA[34439]:=[
,,,[4171113935,"RPn"],];
CONWAYPOLDATA[34457]:=[
,,,[868247489,"RPn"],];
CONWAYPOLDATA[34469]:=[
,,,[9172924759,"RPn"],];
CONWAYPOLDATA[34471]:=[
,,,[4235072595,"RPn"],];
CONWAYPOLDATA[34483]:=[
,,,[10372934681,"RPn"],];
CONWAYPOLDATA[34487]:=[
,,,[5734256956,"RPn"],];
CONWAYPOLDATA[34499]:=[
,,,[8969222517,"RPn"],];
CONWAYPOLDATA[34501]:=[
,,,[15265898984,"RPn"],];
CONWAYPOLDATA[34511]:=[
,,,[5619943802,"RPn"],];
CONWAYPOLDATA[34513]:=[
,,,[10691644229,"RPn"],];
CONWAYPOLDATA[34519]:=[
,,,[4447635077,"RPn"],];
CONWAYPOLDATA[34537]:=[
,,,[8340547357,"RPn"],];
CONWAYPOLDATA[34543]:=[
,,,[4559848721,"RPn"],];
CONWAYPOLDATA[34549]:=[
,,,[7826350423,"RPn"],];
CONWAYPOLDATA[34583]:=[
,,,[5895329432,"RPn"],];
CONWAYPOLDATA[34589]:=[
,,,[7988122018,"RPn"],];
CONWAYPOLDATA[34591]:=[
,,,[3238236468,"RPn"],];
CONWAYPOLDATA[34603]:=[
,,,[10325915835,"RPn"],];
CONWAYPOLDATA[34607]:=[
,,,[5623810545,"RPn"],];
CONWAYPOLDATA[34613]:=[
,,,[2240499492,"RPn"],];
CONWAYPOLDATA[34631]:=[
,,,[4308027145,"RPn"],];
CONWAYPOLDATA[34649]:=[
,,,[9276126336,"RPn"],];
CONWAYPOLDATA[34651]:=[
,,,[10545650691,"RPn"],];
CONWAYPOLDATA[34667]:=[
,,,[9189181692,"RPn"],];
CONWAYPOLDATA[34673]:=[
,,,[1018692743,"RPn"],];
CONWAYPOLDATA[34679]:=[
,,,[7002487724,"RPn"],];
CONWAYPOLDATA[34687]:=[
,,,[6724421825,"RPn"],];
CONWAYPOLDATA[34693]:=[
,,,[10537374282,"RPn"],];
CONWAYPOLDATA[34703]:=[
,,,[6868938310,"RPn"],];
CONWAYPOLDATA[34721]:=[
,,,[10831632605,"RPn"],];
CONWAYPOLDATA[34729]:=[
,,,[17649555645,"RPn"],];
CONWAYPOLDATA[34739]:=[
,,,[2239136990,"RPn"],];
CONWAYPOLDATA[34747]:=[
,,,[10865942854,"RPn"],];
CONWAYPOLDATA[34757]:=[
,,,[13916146690,"RPn"],];
CONWAYPOLDATA[34759]:=[
,,,[5708540094,"RPn"],];
CONWAYPOLDATA[34763]:=[
,,,[10590200322,"RPn"],];
CONWAYPOLDATA[34781]:=[
,,,[4812125257,"RPn"],];
CONWAYPOLDATA[34807]:=[
,,,[4710048436,"RPn"],];
CONWAYPOLDATA[34819]:=[
,,,[4367695362,"RPn"],];
CONWAYPOLDATA[34841]:=[
,,,[1213477192,"RPn"],];
CONWAYPOLDATA[34843]:=[
,,,[10445199699,"RPn"],];
CONWAYPOLDATA[34847]:=[
,,,[8449805108,"RPn"],];
CONWAYPOLDATA[34849]:=[
,,,[1008111879,"RPn"],];
CONWAYPOLDATA[34871]:=[
,,,[3208864298,"RPn"],];
CONWAYPOLDATA[34877]:=[
,,,[4310832079,"RPn"],];
CONWAYPOLDATA[34883]:=[
,,,[871830821,"RPn"],];
CONWAYPOLDATA[34897]:=[
,,,[14292450222,"RPn"],];
CONWAYPOLDATA[34913]:=[
,,,[734813914,"RPn"],];
CONWAYPOLDATA[34919]:=[
,,,[3404113653,"RPn"],];
CONWAYPOLDATA[34939]:=[
,,,[12976973504,"RPn"],];
CONWAYPOLDATA[34949]:=[
,,,[2395299615,"RPn"],];
CONWAYPOLDATA[34961]:=[
,,,[761100973,"RPn"],];
CONWAYPOLDATA[34963]:=[
,,,[3598356999,"RPn"],];
CONWAYPOLDATA[34981]:=[
,,,[8083269558,"RPn"],];
CONWAYPOLDATA[35023]:=[
,,,[4906302029,"RPn"],];
CONWAYPOLDATA[35027]:=[
,,,[14652389561,"RPn"],];
CONWAYPOLDATA[35051]:=[
,,,[9703553893,"RPn"],];
CONWAYPOLDATA[35053]:=[
,,,[15949605744,"RPn"],];
CONWAYPOLDATA[35059]:=[
,,,[3307851719,"RPn"],];
CONWAYPOLDATA[35069]:=[
,,,[2054622574,"RPn"],];
CONWAYPOLDATA[35081]:=[
,,,[5776156815,"RPn"],];
CONWAYPOLDATA[35083]:=[
,,,[14601369187,"RPn"],];
CONWAYPOLDATA[35089]:=[
,,,[13149462405,"RPn"],];
CONWAYPOLDATA[35099]:=[
,,,[9689816031,"RPn"],];
CONWAYPOLDATA[35107]:=[
,,,[11032585394,"RPn"],];
CONWAYPOLDATA[35111]:=[
,,,[8601563015,"RPn"],];
CONWAYPOLDATA[35117]:=[
,,,[5975403371,"RPn"],];
CONWAYPOLDATA[35129]:=[
,,,[6021251119,"RPn"],];
CONWAYPOLDATA[35141]:=[
,,,[9441508177,"RPn"],];
CONWAYPOLDATA[35149]:=[
,,,[8593825055,"RPn"],];
CONWAYPOLDATA[35153]:=[
,,,[9738048910,"RPn"],];
CONWAYPOLDATA[35159]:=[
,,,[4668833939,"RPn"],];
CONWAYPOLDATA[35171]:=[
,,,[2293360228,"RPn"],];
CONWAYPOLDATA[35201]:=[
,,,[1238687992,"RPn"],];
CONWAYPOLDATA[35221]:=[
,,,[3174680062,"RPn"],];
CONWAYPOLDATA[35227]:=[
,,,[14402523725,"RPn"],];
CONWAYPOLDATA[35251]:=[
,,,[9917199084,"RPn"],];
CONWAYPOLDATA[35257]:=[
,,,[15726525885,"RPn"],];
CONWAYPOLDATA[35267]:=[
,,,[9910908677,"RPn"],];
CONWAYPOLDATA[35279]:=[
,,,[3125966382,"RPn"],];
CONWAYPOLDATA[35281]:=[
,,,[40720518760,"RPn"],];
CONWAYPOLDATA[35291]:=[
,,,[10779283042,"RPn"],];
CONWAYPOLDATA[35311]:=[
,,,[4481566198,"RPn"],];
CONWAYPOLDATA[35317]:=[
,,,[8322274470,"RPn"],];
CONWAYPOLDATA[35323]:=[
,,,[6970040332,"RPn"],];
CONWAYPOLDATA[35327]:=[
,,,[5837080215,"RPn"],];
CONWAYPOLDATA[35339]:=[
,,,[5719617152,"RPn"],];
CONWAYPOLDATA[35353]:=[
,,,[10763857209,"RPn"],];
CONWAYPOLDATA[35363]:=[
,,,[9799582384,"RPn"],];
CONWAYPOLDATA[35381]:=[
,,,[18540245480,"RPn"],];
CONWAYPOLDATA[35393]:=[
,,,[9489677342,"RPn"],];
CONWAYPOLDATA[35401]:=[
,,,[18397651906,"RPn"],];
CONWAYPOLDATA[35407]:=[
,,,[12076123868,"RPn"],];
CONWAYPOLDATA[35419]:=[
,,,[11290302118,"RPn"],];
CONWAYPOLDATA[35423]:=[
,,,[7394232448,"RPn"],];
CONWAYPOLDATA[35437]:=[
,,,[8437159899,"RPn"],];
CONWAYPOLDATA[35447]:=[
,,,[6997131464,"RPn"],];
CONWAYPOLDATA[35449]:=[
,,,[8632788636,"RPn"],];
CONWAYPOLDATA[35461]:=[
,,,[8802235809,"RPn"],];
CONWAYPOLDATA[35491]:=[
,,,[8436459144,"RPn"],];
CONWAYPOLDATA[35507]:=[
,,,[3672098435,"RPn"],];
CONWAYPOLDATA[35509]:=[
,,,[9508173914,"RPn"],];
CONWAYPOLDATA[35521]:=[
,,,[18850675018,"RPn"],];
CONWAYPOLDATA[35527]:=[
,,,[7045608062,"RPn"],];
CONWAYPOLDATA[35531]:=[
,,,[6017494635,"RPn"],];
CONWAYPOLDATA[35533]:=[
,,,[8752381963,"RPn"],];
CONWAYPOLDATA[35537]:=[
,,,[6123025103,"RPn"],];
CONWAYPOLDATA[35543]:=[
,,,[4852081564,"RPn"],];
CONWAYPOLDATA[35569]:=[
,,,[23907667792,"RPn"],];
CONWAYPOLDATA[35573]:=[
,,,[5877264343,"RPn"],];
CONWAYPOLDATA[35591]:=[
,,,[5066592413,"RPn"],];
CONWAYPOLDATA[35593]:=[
,,,[13817629721,"RPn"],];
CONWAYPOLDATA[35597]:=[
,,,[12564637495,"RPn"],];
CONWAYPOLDATA[35603]:=[
,,,[10090317438,"RPn"],];
CONWAYPOLDATA[35617]:=[
,,,[41699279484,"RPn"],];
CONWAYPOLDATA[35671]:=[
,,,[10092039323,"RPn"],];
CONWAYPOLDATA[35677]:=[
,,,[26641692721,"RPn"],];
CONWAYPOLDATA[35729]:=[
,,,[3341090251,"RPn"],];
CONWAYPOLDATA[35731]:=[
,,,[8407432840,"RPn"],];
CONWAYPOLDATA[35747]:=[
,,,[716798846,"RPn"],];
CONWAYPOLDATA[35753]:=[
,,,[8556479469,"RPn"],];
CONWAYPOLDATA[35759]:=[
,,,[6245380879,"RPn"],];
CONWAYPOLDATA[35771]:=[
,,,[824163846,"RPn"],];
CONWAYPOLDATA[35797]:=[
,,,[12320253492,"RPn"],];
CONWAYPOLDATA[35801]:=[
,,,[5785942817,"RPn"],];
CONWAYPOLDATA[35803]:=[
,,,[3580837059,"RPn"],];
CONWAYPOLDATA[35809]:=[
,,,[18692083159,"RPn"],];
CONWAYPOLDATA[35831]:=[
,,,[4835859264,"RPn"],];
CONWAYPOLDATA[35837]:=[
,,,[9990603025,"RPn"],];
CONWAYPOLDATA[35839]:=[
,,,[4598358740,"RPn"],];
CONWAYPOLDATA[35851]:=[
,,,[11443961861,"RPn"],];
CONWAYPOLDATA[35863]:=[
,,,[4779892369,"RPn"],];
CONWAYPOLDATA[35869]:=[
,,,[4772155246,"RPn"],];
CONWAYPOLDATA[35879]:=[
,,,[21543796710,"RPn"],];
CONWAYPOLDATA[35897]:=[
,,,[13760109837,"RPn"],];
CONWAYPOLDATA[35899]:=[
,,,[14110173750,"RPn"],];
CONWAYPOLDATA[35911]:=[
,,,[6266541334,"RPn"],];
CONWAYPOLDATA[35923]:=[
,,,[11613905902,"RPn"],];
CONWAYPOLDATA[35933]:=[
,,,[8697690451,"RPn"],];
CONWAYPOLDATA[35951]:=[
,,,[4609816986,"RPn"],];
CONWAYPOLDATA[35963]:=[
,,,[3344523039,"RPn"],];
CONWAYPOLDATA[35969]:=[
,,,[1269166168,"RPn"],];
CONWAYPOLDATA[35977]:=[
,,,[8840556266,"RPn"],];
CONWAYPOLDATA[35983]:=[
,,,[7628108139,"RPn"],];
CONWAYPOLDATA[35993]:=[
,,,[5953638126,"RPn"],];
CONWAYPOLDATA[35999]:=[
,,,[4591132478,"RPn"],];
CONWAYPOLDATA[36007]:=[
,,,[8973268466,"RPn"],];
CONWAYPOLDATA[36011]:=[
,,,[11670877014,"RPn"],];
CONWAYPOLDATA[36013]:=[
,,,[4997487999,"RPn"],];
CONWAYPOLDATA[36017]:=[
,,,[905575434,"RPn"],];
CONWAYPOLDATA[36037]:=[
,,,[8938761630,"RPn"],];
CONWAYPOLDATA[36061]:=[
,,,[13888713847,"RPn"],];
CONWAYPOLDATA[36067]:=[
,,,[1063255165,"RPn"],];
CONWAYPOLDATA[36073]:=[
,,,[20632926326,"RPn"],];
CONWAYPOLDATA[36083]:=[
,,,[2554532070,"RPn"],];
CONWAYPOLDATA[36097]:=[
,,,[19544504073,"RPn"],];
CONWAYPOLDATA[36107]:=[
,,,[6335117580,"RPn"],];
CONWAYPOLDATA[36109]:=[
,,,[4836186699,"RPn"],];
CONWAYPOLDATA[36131]:=[
,,,[4982898474,"RPn"],];
CONWAYPOLDATA[36137]:=[
,,,[2015577315,"RPn"],];
CONWAYPOLDATA[36151]:=[
,,,[5093061336,"RPn"],];
CONWAYPOLDATA[36161]:=[
,,,[2446797907,"RPn"],];
CONWAYPOLDATA[36187]:=[
,,,[7745356922,"RPn"],];
CONWAYPOLDATA[36191]:=[
,,,[6490928239,"RPn"],];
CONWAYPOLDATA[36209]:=[
,,,[1223646949,"RPn"],];
CONWAYPOLDATA[36217]:=[
,,,[15549044629,"RPn"],];
CONWAYPOLDATA[36229]:=[
,,,[13973923821,"RPn"],];
CONWAYPOLDATA[36241]:=[
,,,[29985187322,"RPn"],];
CONWAYPOLDATA[36251]:=[
,,,[10254827886,"RPn"],];
CONWAYPOLDATA[36263]:=[
,,,[11598539240,"RPn"],];
CONWAYPOLDATA[36269]:=[
,,,[10142371969,"RPn"],];
CONWAYPOLDATA[36277]:=[
,,,[4674908161,"RPn"],];
CONWAYPOLDATA[36293]:=[
,,,[8628805924,"RPn"],];
CONWAYPOLDATA[36299]:=[
,,,[10264740119,"RPn"],];
CONWAYPOLDATA[36307]:=[
,,,[10489382758,"RPn"],];
CONWAYPOLDATA[36313]:=[
,,,[24901966572,"RPn"],];
CONWAYPOLDATA[36319]:=[
,,,[2285482038,"RPn"],];
CONWAYPOLDATA[36341]:=[
,,,[9130421865,"RPn"],];
CONWAYPOLDATA[36343]:=[
,,,[3491617395,"RPn"],];
CONWAYPOLDATA[36353]:=[
,,,[3864178491,"RPn"],];
CONWAYPOLDATA[36373]:=[
,,,[9028396943,"RPn"],];
CONWAYPOLDATA[36383]:=[
,,,[6420980994,"RPn"],];
CONWAYPOLDATA[36389]:=[
,,,[16972011548,"RPn"],];
CONWAYPOLDATA[36433]:=[
,,,[9163883196,"RPn"],];
CONWAYPOLDATA[36451]:=[
,,,[6643231208,"RPn"],];
CONWAYPOLDATA[36457]:=[
,,,[8715884366,"RPn"],];
CONWAYPOLDATA[36467]:=[
,,,[10607593896,"RPn"],];
CONWAYPOLDATA[36469]:=[
,,,[12841865441,"RPn"],];
CONWAYPOLDATA[36473]:=[
,,,[10027448947,"RPn"],];
CONWAYPOLDATA[36479]:=[
,,,[7725668543,"RPn"],];
CONWAYPOLDATA[36493]:=[
,,,[8950857070,"RPn"],];
CONWAYPOLDATA[36497]:=[
,,,[8889793275,"RPn"],];
CONWAYPOLDATA[36523]:=[
,,,[24779504151,"RPn"],];
CONWAYPOLDATA[36527]:=[
,,,[5336740813,"RPn"],];
CONWAYPOLDATA[36529]:=[
,,,[1294259006,"RPn"],];
CONWAYPOLDATA[36541]:=[
,,,[5099917757,"RPn"],];
CONWAYPOLDATA[36551]:=[
,,,[3454069507,"RPn"],];
CONWAYPOLDATA[36559]:=[
,,,[4765758128,"RPn"],];
CONWAYPOLDATA[36563]:=[
,,,[19546945432,"RPn"],];
CONWAYPOLDATA[36571]:=[
,,,[3827411149,"RPn"],];
CONWAYPOLDATA[36583]:=[
,,,[1276124796,"RPn"],];
CONWAYPOLDATA[36587]:=[
,,,[1109903234,"RPn"],];
CONWAYPOLDATA[36599]:=[
,,,[13108224661,"RPn"],];
CONWAYPOLDATA[36607]:=[
,,,[7396371139,"RPn"],];
CONWAYPOLDATA[36629]:=[
,,,[5200988341,"RPn"],];
CONWAYPOLDATA[36637]:=[
,,,[2586865301,"RPn"],];
CONWAYPOLDATA[36643]:=[
,,,[3958689865,"RPn"],];
CONWAYPOLDATA[36653]:=[
,,,[17301535510,"RPn"],];
CONWAYPOLDATA[36671]:=[
,,,[6411887692,"RPn"],];
CONWAYPOLDATA[36677]:=[
,,,[17107289789,"RPn"],];
CONWAYPOLDATA[36683]:=[
,,,[15508398546,"RPn"],];
CONWAYPOLDATA[36691]:=[
,,,[11782544141,"RPn"],];
CONWAYPOLDATA[36697]:=[
,,,[9245405488,"RPn"],];
CONWAYPOLDATA[36709]:=[
,,,[9294315003,"RPn"],];
CONWAYPOLDATA[36713]:=[
,,,[10241605335,"RPn"],];
CONWAYPOLDATA[36721]:=[
,,,[17300511651,"RPn"],];
CONWAYPOLDATA[36739]:=[
,,,[4037065017,"RPn"],];
CONWAYPOLDATA[36749]:=[
,,,[2403090610,"RPn"],];
CONWAYPOLDATA[36761]:=[
,,,[6362593886,"RPn"],];
CONWAYPOLDATA[36767]:=[
,,,[6228109203,"RPn"],];
CONWAYPOLDATA[36779]:=[
,,,[11587334289,"RPn"],];
CONWAYPOLDATA[36781]:=[
,,,[4989600119,"RPn"],];
CONWAYPOLDATA[36787]:=[
,,,[11635801676,"RPn"],];
CONWAYPOLDATA[36791]:=[
,,,[10306078892,"RPn"],];
CONWAYPOLDATA[36793]:=[
,,,[18939895832,"RPn"],];
CONWAYPOLDATA[36809]:=[
,,,[3711745945,"RPn"],];
CONWAYPOLDATA[36821]:=[
,,,[12969129443,"RPn"],];
CONWAYPOLDATA[36833]:=[
,,,[13387727346,"RPn"],];
CONWAYPOLDATA[36847]:=[
,,,[7501828121,"RPn"],];
CONWAYPOLDATA[36857]:=[
,,,[10692031418,"RPn"],];
CONWAYPOLDATA[36871]:=[
,,,[5245157862,"RPn"],];
CONWAYPOLDATA[36877]:=[
,,,[13094543301,"RPn"],];
CONWAYPOLDATA[36887]:=[
,,,[5229949526,"RPn"],];
CONWAYPOLDATA[36899]:=[
,,,[6532525164,"RPn"],];
CONWAYPOLDATA[36901]:=[
,,,[9099675899,"RPn"],];
CONWAYPOLDATA[36913]:=[
,,,[8869492558,"RPn"],];
CONWAYPOLDATA[36919]:=[
,,,[4844178912,"RPn"],];
CONWAYPOLDATA[36923]:=[
,,,[16264507656,"RPn"],];
CONWAYPOLDATA[36929]:=[
,,,[6254406230,"RPn"],];
CONWAYPOLDATA[36931]:=[
,,,[3847693168,"RPn"],];
CONWAYPOLDATA[36943]:=[
,,,[15012342198,"RPn"],];
CONWAYPOLDATA[36947]:=[
,,,[901174279,"RPn"],];
CONWAYPOLDATA[36973]:=[
,,,[4957376815,"RPn"],];
CONWAYPOLDATA[36979]:=[
,,,[8910607759,"RPn"],];
CONWAYPOLDATA[36997]:=[
,,,[9022199413,"RPn"],];
CONWAYPOLDATA[37003]:=[
,,,[11919591377,"RPn"],];
CONWAYPOLDATA[37013]:=[
,,,[7949837207,"RPn"],];
CONWAYPOLDATA[37019]:=[
,,,[4944590813,"RPn"],];
CONWAYPOLDATA[37021]:=[
,,,[25879196867,"RPn"],];
CONWAYPOLDATA[37039]:=[
,,,[3695936618,"RPn"],];
CONWAYPOLDATA[37049]:=[
,,,[21464449303,"RPn"],];
CONWAYPOLDATA[37057]:=[
,,,[4017275261,"RPn"],];
CONWAYPOLDATA[37061]:=[
,,,[5117753492,"RPn"],];
CONWAYPOLDATA[37087]:=[
,,,[8207501451,"RPn"],];
CONWAYPOLDATA[37097]:=[
,,,[16105477068,"RPn"],];
CONWAYPOLDATA[37117]:=[
,,,[9587395336,"RPn"],];
CONWAYPOLDATA[37123]:=[
,,,[5218862712,"RPn"],];
CONWAYPOLDATA[37139]:=[
,,,[10446197949,"RPn"],];
CONWAYPOLDATA[37159]:=[
,,,[5400763381,"RPn"],];
CONWAYPOLDATA[37171]:=[
,,,[3659893834,"RPn"],];
CONWAYPOLDATA[37181]:=[
,,,[5110677176,"RPn"],];
CONWAYPOLDATA[37189]:=[
,,,[10806491189,"RPn"],];
CONWAYPOLDATA[37199]:=[
,,,[25649231293,"RPn"],];
CONWAYPOLDATA[37201]:=[
,,,[1025371170,"RPn"],];
CONWAYPOLDATA[37217]:=[
,,,[2333952507,"RPn"],];
CONWAYPOLDATA[37223]:=[
,,,[6646576108,"RPn"],];
CONWAYPOLDATA[37243]:=[
,,,[10437090051,"RPn"],];
CONWAYPOLDATA[37253]:=[
,,,[10768426688,"RPn"],];
CONWAYPOLDATA[37273]:=[
,,,[9618931296,"RPn"],];
CONWAYPOLDATA[37277]:=[
,,,[8188377653,"RPn"],];
CONWAYPOLDATA[37307]:=[
,,,[6503095093,"RPn"],];
CONWAYPOLDATA[37309]:=[
,,,[6285745709,"RPn"],];
CONWAYPOLDATA[37313]:=[
,,,[1129203322,"RPn"],];
CONWAYPOLDATA[37321]:=[
,,,[25821466898,"RPn"],];
CONWAYPOLDATA[37337]:=[
,,,[2105956151,"RPn"],];
CONWAYPOLDATA[37339]:=[
,,,[7742652382,"RPn"],];
CONWAYPOLDATA[37357]:=[
,,,[9333795884,"RPn"],];
CONWAYPOLDATA[37361]:=[
,,,[1395395992,"RPn"],];
CONWAYPOLDATA[37363]:=[
,,,[3582401806,"RPn"],];
CONWAYPOLDATA[37369]:=[
,,,[20803060724,"RPn"],];
CONWAYPOLDATA[37379]:=[
,,,[6690093422,"RPn"],];
CONWAYPOLDATA[37397]:=[
,,,[6601617618,"RPn"],];
CONWAYPOLDATA[37409]:=[
,,,[3597062398,"RPn"],];
CONWAYPOLDATA[37423]:=[
,,,[26608576312,"RPn"],];
CONWAYPOLDATA[37441]:=[
,,,[1258204822,"RPn"],];
CONWAYPOLDATA[37447]:=[
,,,[9154331070,"RPn"],];
CONWAYPOLDATA[37463]:=[
,,,[5613755629,"RPn"],];
CONWAYPOLDATA[37483]:=[
,,,[3826901853,"RPn"],];
CONWAYPOLDATA[37489]:=[
,,,[74332214505,"RPn"],];
CONWAYPOLDATA[37493]:=[
,,,[3831447165,"RPn"],];
CONWAYPOLDATA[37501]:=[
,,,[15348709290,"RPn"],];
CONWAYPOLDATA[37507]:=[
,,,[5626800157,"RPn"],];
CONWAYPOLDATA[37511]:=[
,,,[9638338928,"RPn"],];
CONWAYPOLDATA[37517]:=[
,,,[10564562100,"RPn"],];
CONWAYPOLDATA[37529]:=[
,,,[19318428043,"RPn"],];
CONWAYPOLDATA[37537]:=[
,,,[3951294781,"RPn"],];
CONWAYPOLDATA[37547]:=[
,,,[4030482717,"RPn"],];
CONWAYPOLDATA[37549]:=[
,,,[17632221873,"RPn"],];
CONWAYPOLDATA[37561]:=[
,,,[12023989770,"RPn"],];
CONWAYPOLDATA[37567]:=[
,,,[7981898060,"RPn"],];
CONWAYPOLDATA[37571]:=[
,,,[5467933058,"RPn"],];
CONWAYPOLDATA[37573]:=[
,,,[4954187920,"RPn"],];
CONWAYPOLDATA[37579]:=[
,,,[3555424350,"RPn"],];
CONWAYPOLDATA[37589]:=[
,,,[5548925771,"RPn"],];
CONWAYPOLDATA[37591]:=[
,,,[15377876650,"RPn"],];
CONWAYPOLDATA[37607]:=[
,,,[20911221927,"RPn"],];
CONWAYPOLDATA[37619]:=[
,,,[11185595843,"RPn"],];
CONWAYPOLDATA[37633]:=[
,,,[18364979271,"RPn"],];
CONWAYPOLDATA[37643]:=[
,,,[12340655264,"RPn"],];
CONWAYPOLDATA[37649]:=[
,,,[11124601821,"RPn"],];
CONWAYPOLDATA[37657]:=[
,,,[9586568437,"RPn"],];
CONWAYPOLDATA[37663]:=[
,,,[3666078760,"RPn"],];
CONWAYPOLDATA[37691]:=[
,,,[8033949729,"RPn"],];
CONWAYPOLDATA[37693]:=[
,,,[5095829751,"RPn"],];
CONWAYPOLDATA[37699]:=[
,,,[1303405229,"RPn"],];
CONWAYPOLDATA[37717]:=[
,,,[5478243387,"RPn"],];
CONWAYPOLDATA[37747]:=[
,,,[8092201863,"RPn"],];
CONWAYPOLDATA[37781]:=[
,,,[12381778227,"RPn"],];
CONWAYPOLDATA[37783]:=[
,,,[15702803718,"RPn"],];
CONWAYPOLDATA[37799]:=[
,,,[3578280145,"RPn"],];
CONWAYPOLDATA[37811]:=[
,,,[7062300775,"RPn"],];
CONWAYPOLDATA[37813]:=[
,,,[15029986868,"RPn"],];
CONWAYPOLDATA[37831]:=[
,,,[5497109120,"RPn"],];
CONWAYPOLDATA[37847]:=[
,,,[5175993572,"RPn"],];
CONWAYPOLDATA[37853]:=[
,,,[25212104211,"RPn"],];
CONWAYPOLDATA[37861]:=[
,,,[5134330212,"RPn"],];
CONWAYPOLDATA[37871]:=[
,,,[12759232230,"RPn"],];
CONWAYPOLDATA[37879]:=[
,,,[1094816744,"RPn"],];
CONWAYPOLDATA[37889]:=[
,,,[2387082781,"RPn"],];
CONWAYPOLDATA[37897]:=[
,,,[24388500664,"RPn"],];
CONWAYPOLDATA[37907]:=[
,,,[11340713006,"RPn"],];
CONWAYPOLDATA[37951]:=[
,,,[5431471221,"RPn"],];
CONWAYPOLDATA[37957]:=[
,,,[5491125321,"RPn"],];
CONWAYPOLDATA[37963]:=[
,,,[12349553717,"RPn"],];
CONWAYPOLDATA[37967]:=[
,,,[9992306933,"RPn"],];
CONWAYPOLDATA[37987]:=[
,,,[14312589917,"RPn"],];
CONWAYPOLDATA[37991]:=[
,,,[3977999626,"RPn"],];
CONWAYPOLDATA[37993]:=[
,,,[24426155626,"RPn"],];
CONWAYPOLDATA[37997]:=[
,,,[11219602174,"RPn"],];
CONWAYPOLDATA[38011]:=[
,,,[12300359602,"RPn"],];
CONWAYPOLDATA[38039]:=[
,,,[7049501604,"RPn"],];
CONWAYPOLDATA[38047]:=[
,,,[15923011926,"RPn"],];
CONWAYPOLDATA[38053]:=[
,,,[5617878554,"RPn"],];
CONWAYPOLDATA[38069]:=[
,,,[3714773022,"RPn"],];
CONWAYPOLDATA[38083]:=[
,,,[5104645323,"RPn"],];
CONWAYPOLDATA[38113]:=[
,,,[25871409311,"RPn"],];
CONWAYPOLDATA[38119]:=[
,,,[7265138332,"RPn"],];
CONWAYPOLDATA[38149]:=[
,,,[11290272854,"RPn"],];
CONWAYPOLDATA[38153]:=[
,,,[963401406,"RPn"],];
CONWAYPOLDATA[38167]:=[
,,,[8512805850,"RPn"],];
CONWAYPOLDATA[38177]:=[
,,,[11563469710,"RPn"],];
CONWAYPOLDATA[38183]:=[
,,,[9958470052,"RPn"],];
CONWAYPOLDATA[38189]:=[
,,,[9802772601,"RPn"],];
CONWAYPOLDATA[38197]:=[
,,,[9755437408,"RPn"],];
CONWAYPOLDATA[38201]:=[
,,,[4283210726,"RPn"],];
CONWAYPOLDATA[38219]:=[
,,,[11221327716,"RPn"],];
CONWAYPOLDATA[38231]:=[
,,,[15864297542,"RPn"],];
CONWAYPOLDATA[38237]:=[
,,,[11214759154,"RPn"],];
CONWAYPOLDATA[38239]:=[
,,,[3662034326,"RPn"],];
CONWAYPOLDATA[38261]:=[
,,,[7257805614,"RPn"],];
CONWAYPOLDATA[38273]:=[
,,,[2293777439,"RPn"],];
CONWAYPOLDATA[38281]:=[
,,,[30256843042,"RPn"],];
CONWAYPOLDATA[38287]:=[
,,,[6625297348,"RPn"],];
CONWAYPOLDATA[38299]:=[
,,,[11671352159,"RPn"],];
CONWAYPOLDATA[38303]:=[
,,,[15683814506,"RPn"],];
CONWAYPOLDATA[38317]:=[
,,,[11472416338,"RPn"],];
CONWAYPOLDATA[38321]:=[
,,,[7288922450,"RPn"],];
CONWAYPOLDATA[38327]:=[
,,,[8511468530,"RPn"],];
CONWAYPOLDATA[38329]:=[
,,,[21527904482,"RPn"],];
CONWAYPOLDATA[38333]:=[
,,,[17324676018,"RPn"],];
CONWAYPOLDATA[38351]:=[
,,,[5836293542,"RPn"],];
CONWAYPOLDATA[38371]:=[
,,,[8301297263,"RPn"],];
CONWAYPOLDATA[38377]:=[
,,,[16190104995,"RPn"],];
CONWAYPOLDATA[38393]:=[
,,,[2251019986,"RPn"],];
CONWAYPOLDATA[38431]:=[
,,,[4362187523,"RPn"],];
CONWAYPOLDATA[38447]:=[
,,,[6810040221,"RPn"],];
CONWAYPOLDATA[38449]:=[
,,,[12962080689,"RPn"],];
CONWAYPOLDATA[38453]:=[
,,,[18897380775,"RPn"],];
CONWAYPOLDATA[38459]:=[
,,,[13272662410,"RPn"],];
CONWAYPOLDATA[38461]:=[
,,,[11642721628,"RPn"],];
CONWAYPOLDATA[38501]:=[
,,,[780607777,"RPn"],];
CONWAYPOLDATA[38543]:=[
,,,[5942097229,"RPn"],];
CONWAYPOLDATA[38557]:=[
,,,[15726359263,"RPn"],];
CONWAYPOLDATA[38561]:=[
,,,[1486487992,"RPn"],];
CONWAYPOLDATA[38567]:=[
,,,[10245439256,"RPn"],];
CONWAYPOLDATA[38569]:=[
,,,[23800081396,"RPn"],];
CONWAYPOLDATA[38593]:=[
,,,[23196978736,"RPn"],];
CONWAYPOLDATA[38603]:=[
,,,[6860139132,"RPn"],];
CONWAYPOLDATA[38609]:=[
,,,[11914505749,"RPn"],];
CONWAYPOLDATA[38611]:=[
,,,[8583379747,"RPn"],];
CONWAYPOLDATA[38629]:=[
,,,[5724663286,"RPn"],];
CONWAYPOLDATA[38639]:=[
,,,[4129620432,"RPn"],];
CONWAYPOLDATA[38651]:=[
,,,[7393511141,"RPn"],];
CONWAYPOLDATA[38653]:=[
,,,[5896515152,"RPn"],];
CONWAYPOLDATA[38669]:=[
,,,[23731397316,"RPn"],];
CONWAYPOLDATA[38671]:=[
,,,[5336017941,"RPn"],];
CONWAYPOLDATA[38677]:=[
,,,[5941290006,"RPn"],];
CONWAYPOLDATA[38693]:=[
,,,[4238895538,"RPn"],];
CONWAYPOLDATA[38699]:=[
,,,[10281008536,"RPn"],];
CONWAYPOLDATA[38707]:=[
,,,[13429703308,"RPn"],];
CONWAYPOLDATA[38711]:=[
,,,[8834972826,"RPn"],];
CONWAYPOLDATA[38713]:=[
,,,[9918735161,"RPn"],];
CONWAYPOLDATA[38723]:=[
,,,[17956319778,"RPn"],];
CONWAYPOLDATA[38729]:=[
,,,[4158100359,"RPn"],];
CONWAYPOLDATA[38737]:=[
,,,[9918763803,"RPn"],];
CONWAYPOLDATA[38747]:=[
,,,[6808700336,"RPn"],];
CONWAYPOLDATA[38749]:=[
,,,[9949464485,"RPn"],];
CONWAYPOLDATA[38767]:=[
,,,[23476519865,"RPn"],];
CONWAYPOLDATA[38783]:=[
,,,[6916792923,"RPn"],];
CONWAYPOLDATA[38791]:=[
,,,[7191036795,"RPn"],];
CONWAYPOLDATA[38803]:=[
,,,[10539399244,"RPn"],];
CONWAYPOLDATA[38821]:=[
,,,[10225334939,"RPn"],];
CONWAYPOLDATA[38833]:=[
,,,[28608076940,"RPn"],];
CONWAYPOLDATA[38839]:=[
,,,[3971171239,"RPn"],];
CONWAYPOLDATA[38851]:=[
,,,[3938053916,"RPn"],];
CONWAYPOLDATA[38861]:=[
,,,[907637530,"RPn"],];
CONWAYPOLDATA[38867]:=[
,,,[4086515249,"RPn"],];
CONWAYPOLDATA[38873]:=[
,,,[7327288392,"RPn"],];
CONWAYPOLDATA[38891]:=[
,,,[16153571307,"RPn"],];
CONWAYPOLDATA[38903]:=[
,,,[8610400995,"RPn"],];
CONWAYPOLDATA[38917]:=[
,,,[17601264014,"RPn"],];
CONWAYPOLDATA[38921]:=[
,,,[11584173999,"RPn"],];
CONWAYPOLDATA[38923]:=[
,,,[13634726902,"RPn"],];
CONWAYPOLDATA[38933]:=[
,,,[7357441543,"RPn"],];
CONWAYPOLDATA[38953]:=[
,,,[10484472626,"RPn"],];
CONWAYPOLDATA[38959]:=[
,,,[10309252665,"RPn"],];
CONWAYPOLDATA[38971]:=[
,,,[12990242403,"RPn"],];
CONWAYPOLDATA[38977]:=[
,,,[10136163740,"RPn"],];
CONWAYPOLDATA[38993]:=[
,,,[15064243679,"RPn"],];
CONWAYPOLDATA[39019]:=[
,,,[5884845582,"RPn"],];
CONWAYPOLDATA[39023]:=[
,,,[8570348334,"RPn"],];
CONWAYPOLDATA[39041]:=[
,,,[11705780156,"RPn"],];
CONWAYPOLDATA[39043]:=[
,,,[16123431540,"RPn"],];
CONWAYPOLDATA[39047]:=[
,,,[5886803819,"RPn"],];
CONWAYPOLDATA[39079]:=[
,,,[5694162014,"RPn"],];
CONWAYPOLDATA[39089]:=[
,,,[1527480856,"RPn"],];
CONWAYPOLDATA[39097]:=[
,,,[10346356406,"RPn"],];
CONWAYPOLDATA[39103]:=[
,,,[27407331808,"RPn"],];
CONWAYPOLDATA[39107]:=[
,,,[3862637499,"RPn"],];
CONWAYPOLDATA[39113]:=[
,,,[7329072169,"RPn"],];
CONWAYPOLDATA[39119]:=[
,,,[4041931567,"RPn"],];
CONWAYPOLDATA[39133]:=[
,,,[5544246046,"RPn"],];
CONWAYPOLDATA[39139]:=[
,,,[10541933101,"RPn"],];
CONWAYPOLDATA[39157]:=[
,,,[13254174622,"RPn"],];
CONWAYPOLDATA[39161]:=[
,,,[13639697981,"RPn"],];
CONWAYPOLDATA[39163]:=[
,,,[13803390982,"RPn"],];
CONWAYPOLDATA[39181]:=[
,,,[10745898609,"RPn"],];
CONWAYPOLDATA[39191]:=[
,,,[4472751268,"RPn"],];
CONWAYPOLDATA[39199]:=[
,,,[24462763151,"RPn"],];
CONWAYPOLDATA[39209]:=[
,,,[1536875176,"RPn"],];
CONWAYPOLDATA[39217]:=[
,,,[22571344357,"RPn"],];
CONWAYPOLDATA[39227]:=[
,,,[13848543174,"RPn"],];
CONWAYPOLDATA[39229]:=[
,,,[10150621439,"RPn"],];
CONWAYPOLDATA[39233]:=[
,,,[7319347716,"RPn"],];
CONWAYPOLDATA[39239]:=[
,,,[4507266220,"RPn"],];
CONWAYPOLDATA[39241]:=[
,,,[1228047102,"RPn"],];
CONWAYPOLDATA[39251]:=[
,,,[13190926568,"RPn"],];
CONWAYPOLDATA[39293]:=[
,,,[15193463605,"RPn"],];
CONWAYPOLDATA[39301]:=[
,,,[24684997408,"RPn"],];
CONWAYPOLDATA[39313]:=[
,,,[1283254956,"RPn"],];
CONWAYPOLDATA[39317]:=[
,,,[10700514722,"RPn"],];
CONWAYPOLDATA[39323]:=[
,,,[11695485985,"RPn"],];
CONWAYPOLDATA[39341]:=[
,,,[10512269271,"RPn"],];
CONWAYPOLDATA[39343]:=[
,,,[13322956151,"RPn"],];
CONWAYPOLDATA[39359]:=[
,,,[10370230613,"RPn"],];
CONWAYPOLDATA[39367]:=[
,,,[5849818102,"RPn"],];
CONWAYPOLDATA[39371]:=[
,,,[7603603119,"RPn"],];
CONWAYPOLDATA[39373]:=[
,,,[1511962595,"RPn"],];
CONWAYPOLDATA[39383]:=[
,,,[15466688680,"RPn"],];
CONWAYPOLDATA[39397]:=[
,,,[20063749589,"RPn"],];
CONWAYPOLDATA[39409]:=[
,,,[23041929990,"RPn"],];
CONWAYPOLDATA[39419]:=[
,,,[13261300563,"RPn"],];
CONWAYPOLDATA[39439]:=[
,,,[5609014583,"RPn"],];
CONWAYPOLDATA[39443]:=[
,,,[21438690450,"RPn"],];
CONWAYPOLDATA[39451]:=[
,,,[10810639179,"RPn"],];
CONWAYPOLDATA[39461]:=[
,,,[19513740729,"RPn"],];
CONWAYPOLDATA[39499]:=[
,,,[4052597402,"RPn"],];
CONWAYPOLDATA[39503]:=[
,,,[7428855179,"RPn"],];
CONWAYPOLDATA[39509]:=[
,,,[17170255822,"RPn"],];
CONWAYPOLDATA[39511]:=[
,,,[4169911921,"RPn"],];
CONWAYPOLDATA[39521]:=[
,,,[1561435192,"RPn"],];
CONWAYPOLDATA[39541]:=[
,,,[5486392834,"RPn"],];
CONWAYPOLDATA[39551]:=[
,,,[13579203041,"RPn"],];
CONWAYPOLDATA[39563]:=[
,,,[16675646250,"RPn"],];
CONWAYPOLDATA[39569]:=[
,,,[5528659821,"RPn"],];
CONWAYPOLDATA[39581]:=[
,,,[14099622984,"RPn"],];
CONWAYPOLDATA[39607]:=[
,,,[8707440525,"RPn"],];
CONWAYPOLDATA[39619]:=[
,,,[11779322987,"RPn"],];
CONWAYPOLDATA[39623]:=[
,,,[3976524662,"RPn"],];
CONWAYPOLDATA[39631]:=[
,,,[10611120991,"RPn"],];
CONWAYPOLDATA[39659]:=[
,,,[12220762216,"RPn"],];
CONWAYPOLDATA[39667]:=[
,,,[7662553727,"RPn"],];
CONWAYPOLDATA[39671]:=[
,,,[3955000352,"RPn"],];
CONWAYPOLDATA[39679]:=[
,,,[5876777338,"RPn"],];
CONWAYPOLDATA[39703]:=[
,,,[3969069212,"RPn"],];
CONWAYPOLDATA[39709]:=[
,,,[12568295596,"RPn"],];
CONWAYPOLDATA[39719]:=[
,,,[7835486294,"RPn"],];
CONWAYPOLDATA[39727]:=[
,,,[4562129502,"RPn"],];
CONWAYPOLDATA[39733]:=[
,,,[20108672637,"RPn"],];
CONWAYPOLDATA[39749]:=[
,,,[5917791373,"RPn"],];
CONWAYPOLDATA[39761]:=[
,,,[3990573007,"RPn"],];
CONWAYPOLDATA[39769]:=[
,,,[23390694129,"RPn"],];
CONWAYPOLDATA[39779]:=[
,,,[21616942856,"RPn"],];
CONWAYPOLDATA[39791]:=[
,,,[11897031519,"RPn"],];
CONWAYPOLDATA[39799]:=[
,,,[5577312466,"RPn"],];
CONWAYPOLDATA[39821]:=[
,,,[5673417335,"RPn"],];
CONWAYPOLDATA[39827]:=[
,,,[13801210485,"RPn"],];
CONWAYPOLDATA[39829]:=[
,,,[18865523633,"RPn"],];
CONWAYPOLDATA[39839]:=[
,,,[4556227081,"RPn"],];
CONWAYPOLDATA[39841]:=[
,,,[20546760710,"RPn"],];
CONWAYPOLDATA[39847]:=[
,,,[26875685789,"RPn"],];
CONWAYPOLDATA[39857]:=[
,,,[31469134210,"RPn"],];
CONWAYPOLDATA[39863]:=[
,,,[17170269721,"RPn"],];
CONWAYPOLDATA[39869]:=[
,,,[1400478365,"RPn"],];
CONWAYPOLDATA[39877]:=[
,,,[15411064807,"RPn"],];
CONWAYPOLDATA[39883]:=[
,,,[4284471161,"RPn"],];
CONWAYPOLDATA[39887]:=[
,,,[23416500984,"RPn"],];
CONWAYPOLDATA[39901]:=[
,,,[20419576158,"RPn"],];
CONWAYPOLDATA[39929]:=[
,,,[4124985135,"RPn"],];
CONWAYPOLDATA[39937]:=[
,,,[29521230720,"RPn"],];
CONWAYPOLDATA[39953]:=[
,,,[5641163838,"RPn"],];
CONWAYPOLDATA[39971]:=[
,,,[14326725590,"RPn"],];
CONWAYPOLDATA[39979]:=[
,,,[10742956988,"RPn"],];
CONWAYPOLDATA[39983]:=[
,,,[19183203677,"RPn"],];
CONWAYPOLDATA[39989]:=[
,,,[3063477314,"RPn"],];
CONWAYPOLDATA[40009]:=[
,,,[20438117553,"JB"],];
CONWAYPOLDATA[40013]:=[
,,,[10802549690,"JB"],];
CONWAYPOLDATA[40031]:=[
,,,[22433532543,"JB"],];
CONWAYPOLDATA[40037]:=[
,,,[19042437979,"JB"],];
CONWAYPOLDATA[40039]:=[
,,,[6368603346,"JB"],];
CONWAYPOLDATA[40063]:=[
,,,[8025059596,"JB"],];
CONWAYPOLDATA[40087]:=[
,,,[10510370446,"JB"],];
CONWAYPOLDATA[40093]:=[
,,,[10886011269,"JB"],];
CONWAYPOLDATA[40099]:=[
,,,[5764672342,"JB"],];
CONWAYPOLDATA[40111]:=[
,,,[6000284715,"JB"],];
CONWAYPOLDATA[40123]:=[
,,,[4596771743,"JB"],];
CONWAYPOLDATA[40127]:=[
,,,[10676791530,"JB"],];
CONWAYPOLDATA[40129]:=[
,,,[1506763699,"JB"],];
CONWAYPOLDATA[40151]:=[
,,,[5806798235,"JB"],];
CONWAYPOLDATA[40153]:=[
,,,[33641187230,"JB"],];
CONWAYPOLDATA[40163]:=[
,,,[7989826407,"JB"],];
CONWAYPOLDATA[40169]:=[
,,,[7652756869,"JB"],];
CONWAYPOLDATA[40177]:=[
,,,[29986586084,"JB"],];
CONWAYPOLDATA[40189]:=[
,,,[20717349124,"JB"],];
CONWAYPOLDATA[40193]:=[
,,,[12325625576,"JB"],];
CONWAYPOLDATA[40213]:=[
,,,[1588011376,"JB"],];
CONWAYPOLDATA[40231]:=[
,,,[6407591373,"JB"],];
CONWAYPOLDATA[40237]:=[
,,,[10593154759,"JB"],];
CONWAYPOLDATA[40241]:=[
,,,[4741033659,"JB"],];
CONWAYPOLDATA[40253]:=[
,,,[11087125310,"JB"],];
CONWAYPOLDATA[40277]:=[
,,,[6352246780,"JB"],];
CONWAYPOLDATA[40283]:=[
,,,[14604198822,"JB"],];
CONWAYPOLDATA[40289]:=[
,,,[1622720056,"JB"],];
CONWAYPOLDATA[40343]:=[
,,,[19530207677,"JB"],];
CONWAYPOLDATA[40351]:=[
,,,[5864775747,"JB"],];
CONWAYPOLDATA[40357]:=[
,,,[12569591225,"JB"],];
CONWAYPOLDATA[40361]:=[
,,,[2729775877,"JB"],];
CONWAYPOLDATA[40387]:=[
,,,[22245603859,"JB"],];
CONWAYPOLDATA[40423]:=[
,,,[6222676200,"JB"],];
CONWAYPOLDATA[40427]:=[
,,,[14119614876,"JB"],];
CONWAYPOLDATA[40429]:=[
,,,[17332276175,"JB"],];
CONWAYPOLDATA[40433]:=[
,,,[10906518724,"JB"],];
CONWAYPOLDATA[40459]:=[
,,,[4394616123,"JB"],];
CONWAYPOLDATA[40471]:=[
,,,[4156088406,"JB"],];
CONWAYPOLDATA[40483]:=[
,,,[14123992423,"JB"],];
CONWAYPOLDATA[40487]:=[
,,,[12800491386,"JB"],];
CONWAYPOLDATA[40493]:=[
,,,[6442922218,"JB"],];
CONWAYPOLDATA[40499]:=[
,,,[5836594385,"JB"],];
CONWAYPOLDATA[40507]:=[
,,,[12951303112,"JB"],];
CONWAYPOLDATA[40519]:=[
,,,[19398592813,"JB"],];
CONWAYPOLDATA[40529]:=[
,,,[1642113496,"JB"],];
CONWAYPOLDATA[40531]:=[
,,,[14200076383,"JB"],];
CONWAYPOLDATA[40543]:=[
,,,[5763876684,"JB"],];
CONWAYPOLDATA[40559]:=[
,,,[9372130373,"JB"],];
CONWAYPOLDATA[40577]:=[
,,,[19057069207,"JB"],];
CONWAYPOLDATA[40583]:=[
,,,[24549793029,"JB"],];
CONWAYPOLDATA[40591]:=[
,,,[9177543931,"JB"],];
CONWAYPOLDATA[40597]:=[
,,,[15946217423,"JB"],];
CONWAYPOLDATA[40609]:=[
,,,[42532364089,"JB"],];
CONWAYPOLDATA[40627]:=[
,,,[32585007233,"JB"],];
CONWAYPOLDATA[40637]:=[
,,,[10757426642,"JB"],];
CONWAYPOLDATA[40639]:=[
,,,[5932684422,"JB"],];
CONWAYPOLDATA[40693]:=[
,,,[21508610696,"JB"],];
CONWAYPOLDATA[40697]:=[
,,,[4639824276,"JB"],];
CONWAYPOLDATA[40699]:=[
,,,[5897569995,"JB"],];
CONWAYPOLDATA[40709]:=[
,,,[11042031289,"JB"],];
CONWAYPOLDATA[40739]:=[
,,,[6046971250,"JB"],];
CONWAYPOLDATA[40751]:=[
,,,[6061466758,"JB"],];
CONWAYPOLDATA[40759]:=[
,,,[8306317372,"JB"],];
CONWAYPOLDATA[40763]:=[
,,,[1050992431,"JB"],];
CONWAYPOLDATA[40771]:=[
,,,[14692441425,"JB"],];
CONWAYPOLDATA[40787]:=[
,,,[22500923505,"JB"],];
CONWAYPOLDATA[40801]:=[
,,,[17488818250,"JB"],];
CONWAYPOLDATA[40813]:=[
,,,[11006613094,"JB"],];
CONWAYPOLDATA[40819]:=[
,,,[4349101177,"JB"],];
CONWAYPOLDATA[40823]:=[
,,,[6665906029,"JB"],];
CONWAYPOLDATA[40829]:=[
,,,[5940578673,"JB"],];
CONWAYPOLDATA[40841]:=[
,,,[4530042882,"JB"],];
CONWAYPOLDATA[40847]:=[
,,,[14542920803,"JB"],];
CONWAYPOLDATA[40849]:=[
,,,[34659886323,"JB"],];
CONWAYPOLDATA[40853]:=[
,,,[16067525755,"JB"],];
CONWAYPOLDATA[40867]:=[
,,,[14365813044,"JB"],];
CONWAYPOLDATA[40879]:=[
,,,[5991921189,"JB"],];
CONWAYPOLDATA[40883]:=[
,,,[4361112261,"JB"],];
CONWAYPOLDATA[40897]:=[
,,,[41659606364,"JB"],];
CONWAYPOLDATA[40903]:=[
,,,[6586282869,"JB"],];
CONWAYPOLDATA[40927]:=[
,,,[10022653960,"JB"],];
CONWAYPOLDATA[40933]:=[
,,,[26753235740,"JB"],];
CONWAYPOLDATA[40939]:=[
,,,[4714658059,"JB"],];
CONWAYPOLDATA[40949]:=[
,,,[2802672409,"JB"],];
CONWAYPOLDATA[40961]:=[
,,,[13221063895,"JB"],];
CONWAYPOLDATA[40973]:=[
,,,[11103273272,"JB"],];
CONWAYPOLDATA[40993]:=[
,,,[11585359679,"JB"],];
CONWAYPOLDATA[41011]:=[
,,,[4606314511,"JB"],];
CONWAYPOLDATA[41017]:=[
,,,[11685004999,"JB"],];
CONWAYPOLDATA[41023]:=[
,,,[4408823861,"JB"],];
CONWAYPOLDATA[41039]:=[
,,,[13257279610,"JB"],];
CONWAYPOLDATA[41047]:=[
,,,[18151599110,"JB"],];
CONWAYPOLDATA[41051]:=[
,,,[4476734705,"JB"],];
CONWAYPOLDATA[41057]:=[
,,,[4402665284,"JB"],];
CONWAYPOLDATA[41077]:=[
,,,[11290793915,"JB"],];
CONWAYPOLDATA[41081]:=[
,,,[11801749683,"JB"],];
CONWAYPOLDATA[41113]:=[
,,,[28722939647,"JB"],];
CONWAYPOLDATA[41117]:=[
,,,[15042983388,"JB"],];
CONWAYPOLDATA[41131]:=[
,,,[4236616403,"JB"],];
CONWAYPOLDATA[41141]:=[
,,,[1030870039,"JB"],];
CONWAYPOLDATA[41143]:=[
,,,[6126933277,"JB"],];
CONWAYPOLDATA[41149]:=[
,,,[15238873768,"JB"],];
CONWAYPOLDATA[41161]:=[
,,,[1293649091,"JB"],];
CONWAYPOLDATA[41177]:=[
,,,[3039356727,"JB"],];
CONWAYPOLDATA[41179]:=[
,,,[6634060440,"JB"],];
CONWAYPOLDATA[41183]:=[
,,,[4816145940,"JB"],];
CONWAYPOLDATA[41189]:=[
,,,[1096986639,"JB"],];
CONWAYPOLDATA[41201]:=[
,,,[8131717770,"JB"],];
CONWAYPOLDATA[41203]:=[
,,,[9689421092,"JB"],];
CONWAYPOLDATA[41213]:=[
,,,[11872847107,"JB"],];
CONWAYPOLDATA[41221]:=[
,,,[12825460721,"JB"],];
CONWAYPOLDATA[41227]:=[
,,,[38388603506,"JB"],];
CONWAYPOLDATA[41231]:=[
,,,[13529416654,"JB"],];
CONWAYPOLDATA[41233]:=[
,,,[22023988460,"JB"],];
CONWAYPOLDATA[41243]:=[
,,,[28428717416,"JB"],];
CONWAYPOLDATA[41257]:=[
,,,[15304737982,"JB"],];
CONWAYPOLDATA[41263]:=[
,,,[4308764991,"JB"],];
CONWAYPOLDATA[41269]:=[
,,,[26605794150,"JB"],];
CONWAYPOLDATA[41281]:=[
,,,[28677456626,"JB"],];
CONWAYPOLDATA[41299]:=[
,,,[11382912980,"JB"],];
CONWAYPOLDATA[41333]:=[
,,,[3375666112,"JB"],];
CONWAYPOLDATA[41341]:=[
,,,[13269592841,"JB"],];
CONWAYPOLDATA[41351]:=[
,,,[4574040872,"JB"],];
CONWAYPOLDATA[41357]:=[
,,,[13564268862,"JB"],];
CONWAYPOLDATA[41381]:=[
,,,[6324258233,"JB"],];
CONWAYPOLDATA[41387]:=[
,,,[20474728320,"JB"],];
CONWAYPOLDATA[41389]:=[
,,,[4726209916,"JB"],];
CONWAYPOLDATA[41399]:=[
,,,[31723060131,"JB"],];
CONWAYPOLDATA[41411]:=[
,,,[5038352139,"JB"],];
CONWAYPOLDATA[41413]:=[
,,,[14626408998,"JB"],];
CONWAYPOLDATA[41443]:=[
,,,[15457410142,"JB"],];
CONWAYPOLDATA[41453]:=[
,,,[4415905186,"JB"],];
CONWAYPOLDATA[41467]:=[
,,,[1034601664,"JB"],];
CONWAYPOLDATA[41479]:=[
,,,[6661900714,"JB"],];
CONWAYPOLDATA[41491]:=[
,,,[10055551318,"JB"],];
CONWAYPOLDATA[41507]:=[
,,,[14713152320,"JB"],];
CONWAYPOLDATA[41513]:=[
,,,[11484862044,"JB"],];
CONWAYPOLDATA[41519]:=[
,,,[7987010037,"JB"],];
CONWAYPOLDATA[41521]:=[
,,,[1094202935,"JB"],];
CONWAYPOLDATA[41539]:=[
,,,[2618493946,"JB"],];
CONWAYPOLDATA[41543]:=[
,,,[18463994070,"JB"],];
CONWAYPOLDATA[41549]:=[
,,,[6057387164,"JB"],];
CONWAYPOLDATA[41579]:=[
,,,[8313845789,"JB"],];
CONWAYPOLDATA[41593]:=[
,,,[25949207217,"JB"],];
CONWAYPOLDATA[41597]:=[
,,,[7962372951,"JB"],];
CONWAYPOLDATA[41603]:=[
,,,[8114956373,"JB"],];
CONWAYPOLDATA[41609]:=[
,,,[7846708441,"JB"],];
CONWAYPOLDATA[41611]:=[
,,,[5132051076,"JB"],];
CONWAYPOLDATA[41617]:=[
,,,[19009272244,"JB"],];
CONWAYPOLDATA[41621]:=[
,,,[3367055661,"JB"],];
CONWAYPOLDATA[41627]:=[
,,,[5087360553,"JB"],];
CONWAYPOLDATA[41641]:=[
,,,[55172159681,"JB"],];
CONWAYPOLDATA[41647]:=[
,,,[6213315933,"JB"],];
CONWAYPOLDATA[41651]:=[
,,,[1706608076,"JB"],];
CONWAYPOLDATA[41659]:=[
,,,[11542334156,"JB"],];
CONWAYPOLDATA[41669]:=[
,,,[2921038571,"JB"],];
CONWAYPOLDATA[41681]:=[
,,,[13845302816,"JB"],];
CONWAYPOLDATA[41687]:=[
,,,[6951057133,"JB"],];
CONWAYPOLDATA[41719]:=[
,,,[6430775261,"JB"],];
CONWAYPOLDATA[41729]:=[
,,,[13544899571,"JB"],];
CONWAYPOLDATA[41737]:=[
,,,[11842998966,"JB"],];
CONWAYPOLDATA[41759]:=[
,,,[6956172468,"JB"],];
CONWAYPOLDATA[41761]:=[
,,,[18321385939,"JB"],];
CONWAYPOLDATA[41771]:=[
,,,[13920352836,"JB"],];
CONWAYPOLDATA[41777]:=[
,,,[8191759494,"JB"],];
CONWAYPOLDATA[41801]:=[
,,,[5063313332,"JB"],];
CONWAYPOLDATA[41809]:=[
,,,[32536934473,"JB"],];
CONWAYPOLDATA[41813]:=[
,,,[11882460155,"JB"],];
CONWAYPOLDATA[41843]:=[
,,,[13815303312,"JB"],];
CONWAYPOLDATA[41849]:=[
,,,[1750836616,"JB"],];
CONWAYPOLDATA[41851]:=[
,,,[16998160324,"JB"],];
CONWAYPOLDATA[41863]:=[
,,,[10235670955,"JB"],];
CONWAYPOLDATA[41879]:=[
,,,[4859387899,"JB"],];
CONWAYPOLDATA[41887]:=[
,,,[10043999959,"JB"],];
CONWAYPOLDATA[41893]:=[
,,,[12254247111,"JB"],];
CONWAYPOLDATA[41897]:=[
,,,[15665372097,"JB"],];
CONWAYPOLDATA[41903]:=[
,,,[25714697821,"JB"],];
CONWAYPOLDATA[41911]:=[
,,,[8782491964,"JB"],];
CONWAYPOLDATA[41927]:=[
,,,[10181091488,"JB"],];
CONWAYPOLDATA[41941]:=[
,,,[22502395027,"JB"],];
CONWAYPOLDATA[41947]:=[
,,,[5197149411,"JB"],];
CONWAYPOLDATA[41953]:=[
,,,[26400351657,"JB"],];
CONWAYPOLDATA[41957]:=[
,,,[8514459883,"JB"],];
CONWAYPOLDATA[41959]:=[
,,,[5133054271,"JB"],];
CONWAYPOLDATA[41969]:=[
,,,[1760893336,"JB"],];
CONWAYPOLDATA[41981]:=[
,,,[13729466242,"JB"],];
CONWAYPOLDATA[41983]:=[
,,,[10476227911,"JB"],];
CONWAYPOLDATA[41999]:=[
,,,[13621703677,"JB"],];
CONWAYPOLDATA[42013]:=[
,,,[15184380479,"JB"],];
CONWAYPOLDATA[42017]:=[
,,,[14111241385,"JB"],];
CONWAYPOLDATA[42019]:=[
,,,[4469645070,"JB"],];
CONWAYPOLDATA[42023]:=[
,,,[7063562029,"JB"],];
CONWAYPOLDATA[42043]:=[
,,,[5039946673,"JB"],];
CONWAYPOLDATA[42061]:=[
,,,[13766186757,"JB"],];
CONWAYPOLDATA[42071]:=[
,,,[10163848755,"JB"],];
CONWAYPOLDATA[42073]:=[
,,,[22847363998,"JB"],];
CONWAYPOLDATA[42083]:=[
,,,[13940077918,"JB"],];
CONWAYPOLDATA[42089]:=[
,,,[1770978856,"JB"],];
CONWAYPOLDATA[42101]:=[
,,,[8214410314,"JB"],];
CONWAYPOLDATA[42131]:=[
,,,[11608817873,"JB"],];
CONWAYPOLDATA[42139]:=[
,,,[3116895415,"JB"],];
CONWAYPOLDATA[42157]:=[
,,,[14179970679,"JB"],];
CONWAYPOLDATA[42169]:=[
,,,[22986448418,"JB"],];
CONWAYPOLDATA[42179]:=[
,,,[1496089132,"JB"],];
CONWAYPOLDATA[42181]:=[
,,,[3267129365,"JB"],];
CONWAYPOLDATA[42187]:=[
,,,[15749630536,"JB"],];
CONWAYPOLDATA[42193]:=[
,,,[23016154936,"JB"],];
CONWAYPOLDATA[42197]:=[
,,,[31688470107,"JB"],];
CONWAYPOLDATA[42209]:=[
,,,[8189601228,"JB"],];
CONWAYPOLDATA[42221]:=[
,,,[4681802250,"JB"],];
CONWAYPOLDATA[42223]:=[
,,,[22435233278,"JB"],];
CONWAYPOLDATA[42227]:=[
,,,[8876791034,"JB"],];
CONWAYPOLDATA[42239]:=[
,,,[9842489548,"JB"],];
CONWAYPOLDATA[42257]:=[
,,,[8323445807,"JB"],];
CONWAYPOLDATA[42281]:=[
,,,[1497635312,"JB"],];
CONWAYPOLDATA[42283]:=[
,,,[14143917200,"JB"],];
CONWAYPOLDATA[42293]:=[
,,,[11854051214,"JB"],];
CONWAYPOLDATA[42299]:=[
,,,[4840020778,"JB"],];
CONWAYPOLDATA[42307]:=[
,,,[26304377253,"JB"],];
CONWAYPOLDATA[42323]:=[
,,,[6963741776,"JB"],];
CONWAYPOLDATA[42331]:=[
,,,[14046187761,"JB"],];
CONWAYPOLDATA[42337]:=[
,,,[19350972595,"JB"],];
CONWAYPOLDATA[42349]:=[
,,,[7141142476,"JB"],];
CONWAYPOLDATA[42359]:=[
,,,[4889457018,"JB"],];
CONWAYPOLDATA[42373]:=[
,,,[6471882533,"JB"],];
CONWAYPOLDATA[42379]:=[
,,,[15791220603,"JB"],];
CONWAYPOLDATA[42391]:=[
,,,[3039307533,"JB"],];
CONWAYPOLDATA[42397]:=[
,,,[12194776303,"JB"],];
CONWAYPOLDATA[42403]:=[
,,,[15491724037,"JB"],];
CONWAYPOLDATA[42407]:=[
,,,[4907974150,"JB"],];
CONWAYPOLDATA[42409]:=[
,,,[37452405730,"JB"],];
CONWAYPOLDATA[42433]:=[
,,,[1033201127,"JB"],];
CONWAYPOLDATA[42437]:=[
,,,[6770441419,"JB"],];
CONWAYPOLDATA[42443]:=[
,,,[15676788925,"JB"],];
CONWAYPOLDATA[42451]:=[
,,,[4968677298,"JB"],];
CONWAYPOLDATA[42457]:=[
,,,[41189658561,"JB"],];
CONWAYPOLDATA[42461]:=[
,,,[3011419044,"JB"],];
CONWAYPOLDATA[42463]:=[
,,,[9015361996,"JB"],];
CONWAYPOLDATA[42467]:=[
,,,[5027370866,"JB"],];
CONWAYPOLDATA[42473]:=[
,,,[14291867192,"JB"],];
CONWAYPOLDATA[42487]:=[
,,,[5017374809,"JB"],];
CONWAYPOLDATA[42491]:=[
,,,[14428711363,"JB"],];
CONWAYPOLDATA[42499]:=[
,,,[15876818921,"JB"],];
CONWAYPOLDATA[42509]:=[
,,,[8979643671,"JB"],];
CONWAYPOLDATA[42533]:=[
,,,[22901638654,"JB"],];
CONWAYPOLDATA[42557]:=[
,,,[11851273362,"JB"],];
CONWAYPOLDATA[42569]:=[
,,,[14411351832,"JB"],];
CONWAYPOLDATA[42571]:=[
,,,[15899374511,"JB"],];
CONWAYPOLDATA[42577]:=[
,,,[26769948141,"JB"],];
CONWAYPOLDATA[42589]:=[
,,,[22897081483,"JB"],];
CONWAYPOLDATA[42611]:=[
,,,[16053822085,"JB"],];
CONWAYPOLDATA[42641]:=[
,,,[1817743192,"JB"],];
CONWAYPOLDATA[42643]:=[
,,,[13896841986,"JB"],];
CONWAYPOLDATA[42649]:=[
,,,[26498292850,"JB"],];
CONWAYPOLDATA[42667]:=[
,,,[28579721951,"JB"],];
CONWAYPOLDATA[42677]:=[
,,,[8920858666,"JB"],];
CONWAYPOLDATA[42683]:=[
,,,[14207292650,"JB"],];
CONWAYPOLDATA[42689]:=[
,,,[8216522589,"JB"],];
CONWAYPOLDATA[42697]:=[
,,,[54138984762,"JB"],];
CONWAYPOLDATA[42701]:=[
,,,[6402032830,"JB"],];
CONWAYPOLDATA[42703]:=[
,,,[5098439284,"JB"],];
CONWAYPOLDATA[42709]:=[
,,,[21175463878,"JB"],];
CONWAYPOLDATA[42719]:=[
,,,[12007755572,"JB"],];
CONWAYPOLDATA[42727]:=[
,,,[7086230226,"JB"],];
CONWAYPOLDATA[42737]:=[
,,,[12636006056,"JB"],];
CONWAYPOLDATA[42743]:=[
,,,[19423145838,"JB"],];
CONWAYPOLDATA[42751]:=[
,,,[5273207603,"JB"],];
CONWAYPOLDATA[42767]:=[
,,,[27223718758,"JB"],];
CONWAYPOLDATA[42773]:=[
,,,[13847587661,"JB"],];
CONWAYPOLDATA[42787]:=[
,,,[19791811447,"JB"],];
CONWAYPOLDATA[42793]:=[
,,,[28619487682,"JB"],];
CONWAYPOLDATA[42797]:=[
,,,[16483949304,"JB"],];
CONWAYPOLDATA[42821]:=[
,,,[14530407111,"JB"],];
CONWAYPOLDATA[42829]:=[
,,,[6873754699,"JB"],];
CONWAYPOLDATA[42839]:=[
,,,[10188056669,"JB"],];
CONWAYPOLDATA[42841]:=[
,,,[23722475476,"JB"],];
CONWAYPOLDATA[42853]:=[
,,,[27367168539,"JB"],];
CONWAYPOLDATA[42859]:=[
,,,[10833769453,"JB"],];
CONWAYPOLDATA[42863]:=[
,,,[9023518765,"JB"],];
CONWAYPOLDATA[42899]:=[
,,,[8346601038,"JB"],];
CONWAYPOLDATA[42901]:=[
,,,[5374937593,"JB"],];
CONWAYPOLDATA[42923]:=[
,,,[30647494155,"JB"],];
CONWAYPOLDATA[42929]:=[
,,,[7162617795,"JB"],];
CONWAYPOLDATA[42937]:=[
,,,[20266865123,"JB"],];
CONWAYPOLDATA[42943]:=[
,,,[10359397551,"JB"],];
CONWAYPOLDATA[42953]:=[
,,,[47647505185,"JB"],];
CONWAYPOLDATA[42961]:=[
,,,[30573066778,"JB"],];
CONWAYPOLDATA[42967]:=[
,,,[6810828074,"JB"],];
CONWAYPOLDATA[42979]:=[
,,,[12443065188,"JB"],];
CONWAYPOLDATA[42989]:=[
,,,[1264048558,"JB"],];
CONWAYPOLDATA[43003]:=[
,,,[12944462044,"JB"],];
CONWAYPOLDATA[43013]:=[
,,,[8478034354,"JB"],];
CONWAYPOLDATA[43019]:=[
,,,[15897972585,"JB"],];
CONWAYPOLDATA[43037]:=[
,,,[12845167318,"JB"],];
CONWAYPOLDATA[43049]:=[
,,,[8512035724,"JB"],];
CONWAYPOLDATA[43051]:=[
,,,[16519960232,"JB"],];
CONWAYPOLDATA[43063]:=[
,,,[12871143136,"JB"],];
CONWAYPOLDATA[43067]:=[
,,,[9072192753,"JB"],];
CONWAYPOLDATA[43093]:=[
,,,[3525093591,"JB"],];
CONWAYPOLDATA[43103]:=[
,,,[7431302029,"JB"],];
CONWAYPOLDATA[43117]:=[
,,,[12580807613,"JB"],];
CONWAYPOLDATA[43133]:=[
,,,[7094300177,"JB"],];
CONWAYPOLDATA[43151]:=[
,,,[8661182429,"JB"],];
CONWAYPOLDATA[43159]:=[
,,,[7087916255,"JB"],];
CONWAYPOLDATA[43177]:=[
,,,[27963324993,"JB"],];
CONWAYPOLDATA[43189]:=[
,,,[1587627642,"JB"],];
CONWAYPOLDATA[43201]:=[
,,,[27411725739,"JB"],];
CONWAYPOLDATA[43207]:=[
,,,[11025994333,"JB"],];
CONWAYPOLDATA[43223]:=[
,,,[20372815271,"JB"],];
CONWAYPOLDATA[43237]:=[
,,,[14152075420,"JB"],];
CONWAYPOLDATA[43261]:=[
,,,[19944575571,"JB"],];
CONWAYPOLDATA[43271]:=[
,,,[11233757407,"JB"],];
CONWAYPOLDATA[43283]:=[
,,,[14798457702,"JB"],];
CONWAYPOLDATA[43291]:=[
,,,[12748376974,"JB"],];
CONWAYPOLDATA[43313]:=[
,,,[9260492655,"JB"],];
CONWAYPOLDATA[43319]:=[
,,,[7310471132,"JB"],];
CONWAYPOLDATA[43321]:=[
,,,[27550769741,"JB"],];
CONWAYPOLDATA[43331]:=[
,,,[14899927655,"JB"],];
CONWAYPOLDATA[43391]:=[
,,,[4939284329,"JB"],];
CONWAYPOLDATA[43397]:=[
,,,[14620839875,"JB"],];
CONWAYPOLDATA[43399]:=[
,,,[1786519848,"JB"],];
CONWAYPOLDATA[43403]:=[
,,,[5176589006,"JB"],];
CONWAYPOLDATA[43411]:=[
,,,[4723290447,"JB"],];
CONWAYPOLDATA[43427]:=[
,,,[9409284665,"JB"],];
CONWAYPOLDATA[43441]:=[
,,,[20355540350,"JB"],];
CONWAYPOLDATA[43451]:=[
,,,[14247148392,"JB"],];
CONWAYPOLDATA[43457]:=[
,,,[1127969895,"JB"],];
CONWAYPOLDATA[43481]:=[
,,,[14635008910,"JB"],];
CONWAYPOLDATA[43487]:=[
,,,[16824728922,"JB"],];
CONWAYPOLDATA[43499]:=[
,,,[18088406667,"JB"],];
CONWAYPOLDATA[43517]:=[
,,,[18312823942,"JB"],];
CONWAYPOLDATA[43541]:=[
,,,[24222119548,"JB"],];
CONWAYPOLDATA[43543]:=[
,,,[7341523975,"JB"],];
CONWAYPOLDATA[43573]:=[
,,,[7114686588,"JB"],];
CONWAYPOLDATA[43577]:=[
,,,[35905399884,"JB"],];
CONWAYPOLDATA[43579]:=[
,,,[16794997970,"JB"],];
CONWAYPOLDATA[43591]:=[
,,,[5522413028,"JB"],];
CONWAYPOLDATA[43597]:=[
,,,[18217747601,"JB"],];
CONWAYPOLDATA[43607]:=[
,,,[5268946601,"JB"],];
CONWAYPOLDATA[43609]:=[
,,,[30426784276,"JB"],];
CONWAYPOLDATA[43613]:=[
,,,[12889691313,"JB"],];
CONWAYPOLDATA[43627]:=[
,,,[21956771070,"JB"],];
CONWAYPOLDATA[43633]:=[
,,,[57084923006,"JB"],];
CONWAYPOLDATA[43649]:=[
,,,[5514047226,"JB"],];
CONWAYPOLDATA[43651]:=[
,,,[12786207271,"JB"],];
CONWAYPOLDATA[43661]:=[
,,,[13288487318,"JB"],];
CONWAYPOLDATA[43669]:=[
,,,[22334422714,"JB"],];
CONWAYPOLDATA[43691]:=[
,,,[8731471592,"JB"],];
CONWAYPOLDATA[43711]:=[
,,,[13250596264,"JB"],];
CONWAYPOLDATA[43717]:=[
,,,[43156110895,"JB"],];
CONWAYPOLDATA[43721]:=[
,,,[4883548261,"JB"],];
CONWAYPOLDATA[43753]:=[
,,,[20652816103,"JB"],];
CONWAYPOLDATA[43759]:=[
,,,[7116001065,"JB"],];
CONWAYPOLDATA[43777]:=[
,,,[20634682948,"JB"],];
CONWAYPOLDATA[43781]:=[
,,,[8905493212,"JB"],];
CONWAYPOLDATA[43783]:=[
,,,[12641509376,"JB"],];
CONWAYPOLDATA[43787]:=[
,,,[7046554338,"JB"],];
CONWAYPOLDATA[43789]:=[
,,,[22268063965,"JB"],];
CONWAYPOLDATA[43793]:=[
,,,[8654898179,"JB"],];
CONWAYPOLDATA[43801]:=[
,,,[24717999356,"JB"],];
CONWAYPOLDATA[43853]:=[
,,,[7246313575,"JB"],];
CONWAYPOLDATA[43867]:=[
,,,[11415948083,"JB"],];
CONWAYPOLDATA[43889]:=[
,,,[15053137001,"JB"],];
CONWAYPOLDATA[43891]:=[
,,,[5064450820,"JB"],];
CONWAYPOLDATA[43913]:=[
,,,[3703271119,"JB"],];
CONWAYPOLDATA[43933]:=[
,,,[12843417155,"JB"],];
CONWAYPOLDATA[43943]:=[
,,,[5035648090,"JB"],];
CONWAYPOLDATA[43951]:=[
,,,[7431191135,"JB"],];
CONWAYPOLDATA[43961]:=[
,,,[1845614669,"JB"],];
CONWAYPOLDATA[43963]:=[
,,,[1403298972,"JB"],];
CONWAYPOLDATA[43969]:=[
,,,[32537851453,"JB"],];
CONWAYPOLDATA[43973]:=[
,,,[7537807689,"JB"],];
CONWAYPOLDATA[43987]:=[
,,,[39798161979,"JB"],];
CONWAYPOLDATA[43991]:=[
,,,[8873424627,"JB"],];
CONWAYPOLDATA[43997]:=[
,,,[9645374318,"JB"],];
CONWAYPOLDATA[44017]:=[
,,,[22500962207,"JB"],];
CONWAYPOLDATA[44021]:=[
,,,[6916711585,"JB"],];
CONWAYPOLDATA[44027]:=[
,,,[7730877040,"JB"],];
CONWAYPOLDATA[44029]:=[
,,,[13569693777,"JB"],];
CONWAYPOLDATA[44041]:=[
,,,[65776818987,"JB"],];
CONWAYPOLDATA[44053]:=[
,,,[13142683916,"JB"],];
CONWAYPOLDATA[44059]:=[
,,,[17338670449,"JB"],];
CONWAYPOLDATA[44071]:=[
,,,[7511284959,"JB"],];
CONWAYPOLDATA[44087]:=[
,,,[9348736529,"JB"],];
CONWAYPOLDATA[44089]:=[
,,,[11357679125,"JB"],];
CONWAYPOLDATA[44101]:=[
,,,[14815334047,"JB"],];
CONWAYPOLDATA[44111]:=[
,,,[5426976337,"JB"],];
CONWAYPOLDATA[44119]:=[
,,,[4989417716,"JB"],];
CONWAYPOLDATA[44123]:=[
,,,[16793478540,"JB"],];
CONWAYPOLDATA[44129]:=[
,,,[14737100198,"JB"],];
CONWAYPOLDATA[44131]:=[
,,,[17527597534,"JB"],];
CONWAYPOLDATA[44159]:=[
,,,[6911987486,"JB"],];
CONWAYPOLDATA[44171]:=[
,,,[14896758094,"JB"],];
CONWAYPOLDATA[44179]:=[
,,,[16623320690,"JB"],];
CONWAYPOLDATA[44189]:=[
,,,[4981823673,"JB"],];
CONWAYPOLDATA[44201]:=[
,,,[1285807096,"JB"],];
CONWAYPOLDATA[44203]:=[
,,,[1362911104,"JB"],];
CONWAYPOLDATA[44207]:=[
,,,[7762837619,"JB"],];
CONWAYPOLDATA[44221]:=[
,,,[24881387862,"JB"],];
CONWAYPOLDATA[44249]:=[
,,,[15054350534,"JB"],];
CONWAYPOLDATA[44257]:=[
,,,[20645846248,"JB"],];
CONWAYPOLDATA[44263]:=[
,,,[5771054206,"JB"],];
CONWAYPOLDATA[44267]:=[
,,,[5206374673,"JB"],];
CONWAYPOLDATA[44269]:=[
,,,[20994617521,"JB"],];
CONWAYPOLDATA[44273]:=[
,,,[3497389911,"JB"],];
CONWAYPOLDATA[44279]:=[
,,,[13693502152,"JB"],];
CONWAYPOLDATA[44281]:=[
,,,[1564049208,"JB"],];
CONWAYPOLDATA[44293]:=[
,,,[19101356252,"JB"],];
CONWAYPOLDATA[44351]:=[
,,,[5170705705,"JB"],];
CONWAYPOLDATA[44357]:=[
,,,[13307854071,"JB"],];
CONWAYPOLDATA[44371]:=[
,,,[5410111661,"JB"],];
CONWAYPOLDATA[44381]:=[
,,,[12813327274,"JB"],];
CONWAYPOLDATA[44383]:=[
,,,[7615101994,"JB"],];
CONWAYPOLDATA[44389]:=[
,,,[21078826876,"JB"],];
CONWAYPOLDATA[44417]:=[
,,,[8903121151,"JB"],];
CONWAYPOLDATA[44449]:=[
,,,[17729239296,"JB"],];
CONWAYPOLDATA[44453]:=[
,,,[19216365107,"JB"],];
CONWAYPOLDATA[44483]:=[
,,,[17808324222,"JB"],];
CONWAYPOLDATA[44491]:=[
,,,[17814507850,"JB"],];
CONWAYPOLDATA[44497]:=[
,,,[13678600290,"JB"],];
CONWAYPOLDATA[44501]:=[
,,,[13693135706,"JB"],];
CONWAYPOLDATA[44507]:=[
,,,[14897205014,"JB"],];
CONWAYPOLDATA[44519]:=[
,,,[5606233164,"JB"],];
CONWAYPOLDATA[44531]:=[
,,,[14997506430,"JB"],];
CONWAYPOLDATA[44533]:=[
,,,[19649651856,"JB"],];
CONWAYPOLDATA[44537]:=[
,,,[3533610120,"JB"],];
CONWAYPOLDATA[44543]:=[
,,,[17252706566,"JB"],];
CONWAYPOLDATA[44549]:=[
,,,[1199437278,"JB"],];
CONWAYPOLDATA[44563]:=[
,,,[15215011404,"JB"],];
CONWAYPOLDATA[44579]:=[
,,,[5434269260,"JB"],];
CONWAYPOLDATA[44587]:=[
,,,[5857483367,"JB"],];
CONWAYPOLDATA[44617]:=[
,,,[25522039430,"JB"],];
CONWAYPOLDATA[44621]:=[
,,,[3117580030,"JB"],];
CONWAYPOLDATA[44623]:=[
,,,[19648354742,"JB"],];
CONWAYPOLDATA[44633]:=[
,,,[3119578905,"JB"],];
CONWAYPOLDATA[44641]:=[
,,,[106917650274,"JB"],];
CONWAYPOLDATA[44647]:=[
,,,[7973239853,"JB"],];
CONWAYPOLDATA[44651]:=[
,,,[5297885803,"JB"],];
CONWAYPOLDATA[44657]:=[
,,,[3586894900,"JB"],];
CONWAYPOLDATA[44683]:=[
,,,[17751483510,"JB"],];
CONWAYPOLDATA[44687]:=[
,,,[14995259099,"JB"],];
CONWAYPOLDATA[44699]:=[
,,,[26988675115,"JB"],];
CONWAYPOLDATA[44701]:=[
,,,[7498458649,"JB"],];
CONWAYPOLDATA[44711]:=[
,,,[7469061979,"JB"],];
CONWAYPOLDATA[44729]:=[
,,,[17496195643,"JB"],];
CONWAYPOLDATA[44741]:=[
,,,[13128575337,"JB"],];
CONWAYPOLDATA[44753]:=[
,,,[1799115356,"JB"],];
CONWAYPOLDATA[44771]:=[
,,,[3680041893,"JB"],];
CONWAYPOLDATA[44773]:=[
,,,[21445550637,"JB"],];
CONWAYPOLDATA[44777]:=[
,,,[15641546420,"JB"],];
CONWAYPOLDATA[44789]:=[
,,,[7145233961,"JB"],];
CONWAYPOLDATA[44797]:=[
,,,[39836045831,"JB"],];
CONWAYPOLDATA[44809]:=[
,,,[25994686709,"JB"],];
CONWAYPOLDATA[44819]:=[
,,,[9785601186,"JB"],];
CONWAYPOLDATA[44839]:=[
,,,[21180239724,"JB"],];
CONWAYPOLDATA[44843]:=[
,,,[11862587853,"JB"],];
CONWAYPOLDATA[44851]:=[
,,,[24138539104,"JB"],];
CONWAYPOLDATA[44867]:=[
,,,[17413645441,"JB"],];
CONWAYPOLDATA[44879]:=[
,,,[25773695554,"JB"],];
CONWAYPOLDATA[44887]:=[
,,,[21168439883,"JB"],];
CONWAYPOLDATA[44893]:=[
,,,[7619554216,"JB"],];
CONWAYPOLDATA[44909]:=[
,,,[26060243612,"JB"],];
CONWAYPOLDATA[44917]:=[
,,,[15778803101,"JB"],];
CONWAYPOLDATA[44927]:=[
,,,[1119760555,"JB"],];
CONWAYPOLDATA[44939]:=[
,,,[3656776310,"JB"],];
CONWAYPOLDATA[44953]:=[
,,,[47524131793,"JB"],];
CONWAYPOLDATA[44959]:=[
,,,[7464362937,"JB"],];
CONWAYPOLDATA[44963]:=[
,,,[17379773207,"JB"],];
CONWAYPOLDATA[44971]:=[
,,,[5149314416,"JB"],];
CONWAYPOLDATA[44983]:=[
,,,[7747781957,"JB"],];
CONWAYPOLDATA[44987]:=[
,,,[5754737042,"JB"],];
CONWAYPOLDATA[45007]:=[
,,,[34169044361,"JB"],];
CONWAYPOLDATA[45013]:=[
,,,[20227266747,"JB"],];
CONWAYPOLDATA[45053]:=[
,,,[15474353912,"JB"],];
CONWAYPOLDATA[45061]:=[
,,,[13884736054,"JB"],];
CONWAYPOLDATA[45077]:=[
,,,[34433373685,"JB"],];
CONWAYPOLDATA[45083]:=[
,,,[5694253400,"JB"],];
CONWAYPOLDATA[45119]:=[
,,,[8075127913,"JB"],];
CONWAYPOLDATA[45121]:=[
,,,[29933000681,"JB"],];
CONWAYPOLDATA[45127]:=[
,,,[12037040611,"JB"],];
CONWAYPOLDATA[45131]:=[
,,,[9452101249,"JB"],];
CONWAYPOLDATA[45137]:=[
,,,[52754726356,"JB"],];
CONWAYPOLDATA[45139]:=[
,,,[15650007275,"JB"],];
CONWAYPOLDATA[45161]:=[
,,,[9701486023,"JB"],];
CONWAYPOLDATA[45179]:=[
,,,[3909429234,"JB"],];
CONWAYPOLDATA[45181]:=[
,,,[18371588584,"JB"],];
CONWAYPOLDATA[45191]:=[
,,,[11444846716,"JB"],];
CONWAYPOLDATA[45197]:=[
,,,[9576837529,"JB"],];
CONWAYPOLDATA[45233]:=[
,,,[3435898683,"JB"],];
CONWAYPOLDATA[45247]:=[
,,,[7862209219,"JB"],];
CONWAYPOLDATA[45259]:=[
,,,[8005321405,"JB"],];
CONWAYPOLDATA[45263]:=[
,,,[8194775629,"JB"],];
CONWAYPOLDATA[45281]:=[
,,,[6137477305,"JB"],];
CONWAYPOLDATA[45289]:=[
,,,[26181253891,"JB"],];
CONWAYPOLDATA[45293]:=[
,,,[7483581220,"JB"],];
CONWAYPOLDATA[45307]:=[
,,,[18474201094,"JB"],];
CONWAYPOLDATA[45317]:=[
,,,[7421882311,"JB"],];
CONWAYPOLDATA[45319]:=[
,,,[10268877532,"JB"],];
CONWAYPOLDATA[45329]:=[
,,,[5298370826,"JB"],];
CONWAYPOLDATA[45337]:=[
,,,[13820440411,"JB"],];
CONWAYPOLDATA[45341]:=[
,,,[3973367855,"JB"],];
CONWAYPOLDATA[45343]:=[
,,,[7743314802,"JB"],];
CONWAYPOLDATA[45361]:=[
,,,[26694404179,"JB"],];
CONWAYPOLDATA[45377]:=[
,,,[1687207617,"JB"],];
CONWAYPOLDATA[45389]:=[
,,,[1380778771,"JB"],];
CONWAYPOLDATA[45403]:=[
,,,[5354602808,"JB"],];
CONWAYPOLDATA[45413]:=[
,,,[10188906095,"JB"],];
CONWAYPOLDATA[45427]:=[
,,,[11378509536,"JB"],];
CONWAYPOLDATA[45433]:=[
,,,[25980861057,"JB"],];
CONWAYPOLDATA[45439]:=[
,,,[16114168890,"JB"],];
CONWAYPOLDATA[45481]:=[
,,,[38858056793,"JB"],];
CONWAYPOLDATA[45491]:=[
,,,[16110819616,"JB"],];
CONWAYPOLDATA[45497]:=[
,,,[57413483249,"JB"],];
CONWAYPOLDATA[45503]:=[
,,,[8281910029,"JB"],];
CONWAYPOLDATA[45523]:=[
,,,[17981539479,"JB"],];
CONWAYPOLDATA[45533]:=[
,,,[20528735184,"JB"],];
CONWAYPOLDATA[45541]:=[
,,,[30228931744,"JB"],];
CONWAYPOLDATA[45553]:=[
,,,[14494782393,"JB"],];
CONWAYPOLDATA[45557]:=[
,,,[14497330771,"JB"],];
CONWAYPOLDATA[45569]:=[
,,,[10169770440,"JB"],];
CONWAYPOLDATA[45587]:=[
,,,[28472728462,"JB"],];
CONWAYPOLDATA[45589]:=[
,,,[19988177929,"JB"],];
CONWAYPOLDATA[45599]:=[
,,,[14527339818,"JB"],];
CONWAYPOLDATA[45613]:=[
,,,[26293705078,"JB"],];
CONWAYPOLDATA[45631]:=[
,,,[5391120138,"JB"],];
CONWAYPOLDATA[45641]:=[
,,,[32897165632,"JB"],];
CONWAYPOLDATA[45659]:=[
,,,[3968588964,"JB"],];
CONWAYPOLDATA[45667]:=[
,,,[24279728225,"JB"],];
CONWAYPOLDATA[45673]:=[
,,,[22326378268,"JB"],];
CONWAYPOLDATA[45677]:=[
,,,[26757129832,"JB"],];
CONWAYPOLDATA[45691]:=[
,,,[13707528462,"JB"],];
CONWAYPOLDATA[45697]:=[
,,,[14279398570,"JB"],];
CONWAYPOLDATA[45707]:=[
,,,[7413858230,"JB"],];
CONWAYPOLDATA[45737]:=[
,,,[1761469084,"JB"],];
CONWAYPOLDATA[45751]:=[
,,,[5573112317,"JB"],];
CONWAYPOLDATA[45757]:=[
,,,[16492332783,"JB"],];
CONWAYPOLDATA[45763]:=[
,,,[14659399084,"JB"],];
CONWAYPOLDATA[45767]:=[
,,,[11680013007,"JB"],];
CONWAYPOLDATA[45779]:=[
,,,[13691949554,"JB"],];
CONWAYPOLDATA[45817]:=[
,,,[14597296205,"JB"],];
CONWAYPOLDATA[45821]:=[
,,,[3348736145,"JB"],];
CONWAYPOLDATA[45823]:=[
,,,[5588985490,"JB"],];
CONWAYPOLDATA[45827]:=[
,,,[10245313257,"JB"],];
CONWAYPOLDATA[45833]:=[
,,,[25163004500,"JB"],];
CONWAYPOLDATA[45841]:=[
,,,[37152067662,"JB"],];
CONWAYPOLDATA[45853]:=[
,,,[24379764987,"JB"],];
CONWAYPOLDATA[45863]:=[
,,,[7420679273,"JB"],];
CONWAYPOLDATA[45869]:=[
,,,[7541047078,"JB"],];
CONWAYPOLDATA[45887]:=[
,,,[8119658768,"JB"],];
CONWAYPOLDATA[45893]:=[
,,,[56574045036,"JB"],];
CONWAYPOLDATA[45943]:=[
,,,[11949131104,"JB"],];
CONWAYPOLDATA[45949]:=[
,,,[22672844817,"JB"],];
CONWAYPOLDATA[45953]:=[
,,,[18636652730,"JB"],];
CONWAYPOLDATA[45959]:=[
,,,[16296417981,"JB"],];
CONWAYPOLDATA[45971]:=[
,,,[18939316466,"JB"],];
CONWAYPOLDATA[45979]:=[
,,,[16117616599,"JB"],];
CONWAYPOLDATA[45989]:=[
,,,[20670261931,"JB"],];
CONWAYPOLDATA[46021]:=[
,,,[7790158756,"JB"],];
CONWAYPOLDATA[46027]:=[
,,,[18345855905,"JB"],];
CONWAYPOLDATA[46049]:=[
,,,[18197551725,"JB"],];
CONWAYPOLDATA[46051]:=[
,,,[7530121370,"JB"],];
CONWAYPOLDATA[46061]:=[
,,,[16623000353,"JB"],];
CONWAYPOLDATA[46073]:=[
,,,[5777277767,"JB"],];
CONWAYPOLDATA[46091]:=[
,,,[42128095822,"JB"],];
CONWAYPOLDATA[46093]:=[
,,,[14253799322,"JB"],];
CONWAYPOLDATA[46099]:=[
,,,[18827154295,"JB"],];
CONWAYPOLDATA[46103]:=[
,,,[25505009464,"JB"],];
CONWAYPOLDATA[46133]:=[
,,,[7719388759,"JB"],];
CONWAYPOLDATA[46141]:=[
,,,[20995400817,"JB"],];
CONWAYPOLDATA[46147]:=[
,,,[5422872413,"JB"],];
CONWAYPOLDATA[46153]:=[
,,,[27178763257,"JB"],];
CONWAYPOLDATA[46171]:=[
,,,[7650119164,"JB"],];
CONWAYPOLDATA[46181]:=[
,,,[27214601845,"JB"],];
CONWAYPOLDATA[46183]:=[
,,,[10664162716,"JB"],];
CONWAYPOLDATA[46187]:=[
,,,[5932027347,"JB"],];
CONWAYPOLDATA[46199]:=[
,,,[8537020829,"JB"],];
CONWAYPOLDATA[46219]:=[
,,,[6277141050,"JB"],];
CONWAYPOLDATA[46229]:=[
,,,[6333095628,"JB"],];
CONWAYPOLDATA[46237]:=[
,,,[27592345885,"JB"],];
CONWAYPOLDATA[46261]:=[
,,,[7501406196,"JB"],];
CONWAYPOLDATA[46271]:=[
,,,[10334211418,"JB"],];
CONWAYPOLDATA[46273]:=[
,,,[14426579488,"JB"],];
CONWAYPOLDATA[46279]:=[
,,,[8258996622,"JB"],];
CONWAYPOLDATA[46301]:=[
,,,[3492715937,"JB"],];
CONWAYPOLDATA[46307]:=[
,,,[29179429912,"JB"],];
CONWAYPOLDATA[46309]:=[
,,,[26918958612,"JB"],];
CONWAYPOLDATA[46327]:=[
,,,[5811490518,"JB"],];
CONWAYPOLDATA[46337]:=[
,,,[2065471778,"JB"],];
CONWAYPOLDATA[46349]:=[
,,,[38470828727,"JB"],];
CONWAYPOLDATA[46351]:=[
,,,[8292796466,"JB"],];
CONWAYPOLDATA[46381]:=[
,,,[12415497992,"JB"],];
CONWAYPOLDATA[46399]:=[
,,,[10764150412,"JB"],];
CONWAYPOLDATA[46411]:=[
,,,[16910961717,"JB"],];
CONWAYPOLDATA[46439]:=[
,,,[12750663359,"JB"],];
CONWAYPOLDATA[46441]:=[
,,,[40106076079,"JB"],];
CONWAYPOLDATA[46447]:=[
,,,[10786433260,"JB"],];
CONWAYPOLDATA[46451]:=[
,,,[12727063045,"JB"],];
CONWAYPOLDATA[46457]:=[
,,,[2005734521,"JB"],];
CONWAYPOLDATA[46471]:=[
,,,[8403490346,"JB"],];
CONWAYPOLDATA[46477]:=[
,,,[22824018116,"JB"],];
CONWAYPOLDATA[46489]:=[
,,,[45312084505,"JB"],];
CONWAYPOLDATA[46499]:=[
,,,[16283252317,"JB"],];
CONWAYPOLDATA[46507]:=[
,,,[3583689901,"JB"],];
CONWAYPOLDATA[46511]:=[
,,,[15079470854,"JB"],];
CONWAYPOLDATA[46523]:=[
,,,[12861004217,"JB"],];
CONWAYPOLDATA[46549]:=[
,,,[14683928601,"JB"],];
CONWAYPOLDATA[46559]:=[
,,,[5495032864,"JB"],];
CONWAYPOLDATA[46567]:=[
,,,[14438843425,"JB"],];
CONWAYPOLDATA[46573]:=[
,,,[14991289826,"JB"],];
CONWAYPOLDATA[46589]:=[
,,,[10677919268,"JB"],];
CONWAYPOLDATA[46591]:=[
,,,[3269383658,"JB"],];
CONWAYPOLDATA[46601]:=[
,,,[3903998778,"JB"],];
CONWAYPOLDATA[46619]:=[
,,,[21615924974,"JB"],];
CONWAYPOLDATA[46633]:=[
,,,[23699916531,"JB"],];
CONWAYPOLDATA[46639]:=[
,,,[8132442436,"JB"],];
CONWAYPOLDATA[46643]:=[
,,,[10437024254,"JB"],];
CONWAYPOLDATA[46649]:=[
,,,[9941088511,"JB"],];
CONWAYPOLDATA[46663]:=[
,,,[6139964208,"JB"],];
CONWAYPOLDATA[46679]:=[
,,,[19571291063,"JB"],];
CONWAYPOLDATA[46681]:=[
,,,[32308013473,"JB"],];
CONWAYPOLDATA[46687]:=[
,,,[10898193100,"JB"],];
CONWAYPOLDATA[46691]:=[
,,,[19288425630,"JB"],];
CONWAYPOLDATA[46703]:=[
,,,[20799134352,"JB"],];
CONWAYPOLDATA[46723]:=[
,,,[6247145440,"JB"],];
CONWAYPOLDATA[46727]:=[
,,,[26200389629,"JB"],];
CONWAYPOLDATA[46747]:=[
,,,[18591655878,"JB"],];
CONWAYPOLDATA[46751]:=[
,,,[8343370475,"JB"],];
CONWAYPOLDATA[46757]:=[
,,,[14670102266,"JB"],];
CONWAYPOLDATA[46769]:=[
,,,[2186778136,"JB"],];
CONWAYPOLDATA[46771]:=[
,,,[19053149043,"JB"],];
CONWAYPOLDATA[46807]:=[
,,,[12094928803,"JB"],];
CONWAYPOLDATA[46811]:=[
,,,[1944014021,"JB"],];
CONWAYPOLDATA[46817]:=[
,,,[26055299098,"JB"],];
CONWAYPOLDATA[46819]:=[
,,,[12106503841,"JB"],];
CONWAYPOLDATA[46829]:=[
,,,[7962194385,"JB"],];
CONWAYPOLDATA[46831]:=[
,,,[7953496057,"JB"],];
CONWAYPOLDATA[46853]:=[
,,,[12187121244,"JB"],];
CONWAYPOLDATA[46861]:=[
,,,[49977771977,"JB"],];
CONWAYPOLDATA[46867]:=[
,,,[18835472366,"JB"],];
CONWAYPOLDATA[46877]:=[
,,,[3815412786,"JB"],];
CONWAYPOLDATA[46889]:=[
,,,[5974971495,"JB"],];
CONWAYPOLDATA[46901]:=[
,,,[1262762535,"JB"],];
CONWAYPOLDATA[46919]:=[
,,,[12749440638,"JB"],];
CONWAYPOLDATA[46933]:=[
,,,[8329715775,"JB"],];
CONWAYPOLDATA[46957]:=[
,,,[8375954880,"JB"],];
CONWAYPOLDATA[46993]:=[
,,,[34666783098,"JB"],];
CONWAYPOLDATA[46997]:=[
,,,[10754699488,"JB"],];
CONWAYPOLDATA[47017]:=[
,,,[28011647216,"JB"],];
CONWAYPOLDATA[47041]:=[
,,,[36658298673,"JB"],];
CONWAYPOLDATA[47051]:=[
,,,[8554154108,"JB"],];
CONWAYPOLDATA[47057]:=[
,,,[17150770679,"JB"],];
CONWAYPOLDATA[47059]:=[
,,,[5914469240,"JB"],];
CONWAYPOLDATA[47087]:=[
,,,[8868553933,"JB"],];
CONWAYPOLDATA[47093]:=[
,,,[15503816183,"JB"],];
CONWAYPOLDATA[47111]:=[
,,,[31043322347,"JB"],];
CONWAYPOLDATA[47119]:=[
,,,[8796457637,"JB"],];
CONWAYPOLDATA[47123]:=[
,,,[45837908669,"JB"],];
CONWAYPOLDATA[47129]:=[
,,,[1770495146,"JB"],];
CONWAYPOLDATA[47137]:=[
,,,[53042464776,"JB"],];
CONWAYPOLDATA[47143]:=[
,,,[10623769342,"JB"],];
CONWAYPOLDATA[47147]:=[
,,,[19218955935,"JB"],];
CONWAYPOLDATA[47149]:=[
,,,[2043060470,"JB"],];
CONWAYPOLDATA[47161]:=[
,,,[50192461936,"JB"],];
CONWAYPOLDATA[47189]:=[
,,,[2127940768,"JB"],];
CONWAYPOLDATA[47207]:=[
,,,[10592165044,"JB"],];
CONWAYPOLDATA[47221]:=[
,,,[6376204415,"JB"],];
CONWAYPOLDATA[47237]:=[
,,,[15466716438,"JB"],];
CONWAYPOLDATA[47251]:=[
,,,[1481602366,"JB"],];
CONWAYPOLDATA[47269]:=[
,,,[1648931802,"JB"],];
CONWAYPOLDATA[47279]:=[
,,,[10447855264,"JB"],];
CONWAYPOLDATA[47287]:=[
,,,[12614894856,"JB"],];
CONWAYPOLDATA[47293]:=[
,,,[61776102912,"JB"],];
CONWAYPOLDATA[47297]:=[
,,,[3718632034,"JB"],];
CONWAYPOLDATA[47303]:=[
,,,[10131451151,"JB"],];
CONWAYPOLDATA[47309]:=[
,,,[3957681706,"JB"],];
CONWAYPOLDATA[47317]:=[
,,,[10680582514,"JB"],];
CONWAYPOLDATA[47339]:=[
,,,[20168496918,"JB"],];
CONWAYPOLDATA[47351]:=[
,,,[7879585221,"JB"],];
CONWAYPOLDATA[47353]:=[
,,,[24444849783,"JB"],];
CONWAYPOLDATA[47363]:=[
,,,[17438961876,"JB"],];
CONWAYPOLDATA[47381]:=[
,,,[21619050063,"JB"],];
CONWAYPOLDATA[47387]:=[
,,,[20191885024,"JB"],];
CONWAYPOLDATA[47389]:=[
,,,[21345853773,"JB"],];
CONWAYPOLDATA[47407]:=[
,,,[19924640626,"JB"],];
CONWAYPOLDATA[47417]:=[
,,,[17187050325,"JB"],];
CONWAYPOLDATA[47419]:=[
,,,[19121711752,"JB"],];
CONWAYPOLDATA[47431]:=[
,,,[1740385695,"JB"],];
CONWAYPOLDATA[47441]:=[
,,,[2250079192,"JB"],];
CONWAYPOLDATA[47459]:=[
,,,[14669102312,"JB"],];
CONWAYPOLDATA[47491]:=[
,,,[6611981968,"JB"],];
CONWAYPOLDATA[47497]:=[
,,,[41866800619,"JB"],];
CONWAYPOLDATA[47501]:=[
,,,[11281535004,"JB"],];
CONWAYPOLDATA[47507]:=[
,,,[37927878550,"JB"],];
CONWAYPOLDATA[47513]:=[
,,,[1514761956,"JB"],];
CONWAYPOLDATA[47521]:=[
,,,[46547627374,"JB"],];
CONWAYPOLDATA[47527]:=[
,,,[12968977655,"JB"],];
CONWAYPOLDATA[47533]:=[
,,,[8399556432,"JB"],];
CONWAYPOLDATA[47543]:=[
,,,[7931265894,"JB"],];
CONWAYPOLDATA[47563]:=[
,,,[5966397848,"JB"],];
CONWAYPOLDATA[47569]:=[
,,,[33818942722,"JB"],];
CONWAYPOLDATA[47581]:=[
,,,[28547458058,"JB"],];
CONWAYPOLDATA[47591]:=[
,,,[7998904927,"JB"],];
CONWAYPOLDATA[47599]:=[
,,,[6542196959,"JB"],];
CONWAYPOLDATA[47609]:=[
,,,[17894461573,"JB"],];
CONWAYPOLDATA[47623]:=[
,,,[11339560156,"JB"],];
CONWAYPOLDATA[47629]:=[
,,,[31236050790,"JB"],];
CONWAYPOLDATA[47639]:=[
,,,[5821009417,"JB"],];
CONWAYPOLDATA[47653]:=[
,,,[8743277147,"JB"],];
CONWAYPOLDATA[47657]:=[
,,,[21797549291,"JB"],];
CONWAYPOLDATA[47659]:=[
,,,[17324952023,"JB"],];
CONWAYPOLDATA[47681]:=[
,,,[10370045331,"JB"],];
CONWAYPOLDATA[47699]:=[
,,,[8536499236,"JB"],];
CONWAYPOLDATA[47701]:=[
,,,[17880624450,"JB"],];
CONWAYPOLDATA[47711]:=[
,,,[8190642803,"JB"],];
CONWAYPOLDATA[47713]:=[
,,,[24270457998,"JB"],];
CONWAYPOLDATA[47717]:=[
,,,[8903658183,"JB"],];
CONWAYPOLDATA[47737]:=[
,,,[54181065372,"JB"],];
CONWAYPOLDATA[47741]:=[
,,,[26424929949,"JB"],];
CONWAYPOLDATA[47743]:=[
,,,[11396779276,"JB"],];
CONWAYPOLDATA[47777]:=[
,,,[6778648540,"JB"],];
CONWAYPOLDATA[47779]:=[
,,,[6678166391,"JB"],];
CONWAYPOLDATA[47791]:=[
,,,[3484871936,"JB"],];
CONWAYPOLDATA[47797]:=[
,,,[15531969734,"JB"],];
CONWAYPOLDATA[47807]:=[
,,,[8422302616,"JB"],];
CONWAYPOLDATA[47809]:=[
,,,[38321017103,"JB"],];
CONWAYPOLDATA[47819]:=[
,,,[1386942278,"JB"],];
CONWAYPOLDATA[47837]:=[
,,,[3578016254,"JB"],];
CONWAYPOLDATA[47843]:=[
,,,[6299152911,"JB"],];
CONWAYPOLDATA[47857]:=[
,,,[19486365410,"JB"],];
CONWAYPOLDATA[47869]:=[
,,,[8602346516,"JB"],];
CONWAYPOLDATA[47881]:=[
,,,[43514731639,"JB"],];
CONWAYPOLDATA[47903]:=[
,,,[6360081317,"JB"],];
CONWAYPOLDATA[47911]:=[
,,,[9034289807,"JB"],];
CONWAYPOLDATA[47917]:=[
,,,[15746436628,"JB"],];
CONWAYPOLDATA[47933]:=[
,,,[16026494418,"JB"],];
CONWAYPOLDATA[47939]:=[
,,,[6450240391,"JB"],];
CONWAYPOLDATA[47947]:=[
,,,[31735927514,"JB"],];
CONWAYPOLDATA[47951]:=[
,,,[13192327078,"JB"],];
CONWAYPOLDATA[47963]:=[
,,,[10574786316,"JB"],];
CONWAYPOLDATA[47969]:=[
,,,[2300449336,"JB"],];
CONWAYPOLDATA[47977]:=[
,,,[29325413510,"JB"],];
CONWAYPOLDATA[47981]:=[
,,,[33538239192,"JB"],];
CONWAYPOLDATA[48017]:=[
,,,[11106236069,"JB"],];
CONWAYPOLDATA[48023]:=[
,,,[29585817753,"JB"],];
CONWAYPOLDATA[48029]:=[
,,,[1931822440,"JB"],];
CONWAYPOLDATA[48049]:=[
,,,[47659082382,"JB"],];
CONWAYPOLDATA[48073]:=[
,,,[15385379071,"JB"],];
CONWAYPOLDATA[48079]:=[
,,,[10756185807,"JB"],];
CONWAYPOLDATA[48091]:=[
,,,[15336075634,"JB"],];
CONWAYPOLDATA[48109]:=[
,,,[27437861645,"JB"],];
CONWAYPOLDATA[48119]:=[
,,,[11259124222,"JB"],];
CONWAYPOLDATA[48121]:=[
,,,[19889516096,"JB"],];
CONWAYPOLDATA[48131]:=[
,,,[13418441496,"JB"],];
CONWAYPOLDATA[48157]:=[
,,,[4317130584,"JB"],];
CONWAYPOLDATA[48163]:=[
,,,[8631772863,"JB"],];
CONWAYPOLDATA[48179]:=[
,,,[23049700828,"JB"],];
CONWAYPOLDATA[48187]:=[
,,,[6574296973,"JB"],];
CONWAYPOLDATA[48193]:=[
,,,[29345777953,"JB"],];
CONWAYPOLDATA[48197]:=[
,,,[17924175120,"JB"],];
CONWAYPOLDATA[48221]:=[
,,,[11570291405,"JB"],];
CONWAYPOLDATA[48239]:=[
,,,[20248416735,"JB"],];
CONWAYPOLDATA[48247]:=[
,,,[15557824117,"JB"],];
CONWAYPOLDATA[48259]:=[
,,,[20469151370,"JB"],];
CONWAYPOLDATA[48271]:=[
,,,[6613513174,"JB"],];
CONWAYPOLDATA[48281]:=[
,,,[11411504039,"JB"],];
CONWAYPOLDATA[48299]:=[
,,,[18389651056,"JB"],];
CONWAYPOLDATA[48311]:=[
,,,[11669328813,"JB"],];
CONWAYPOLDATA[48313]:=[
,,,[16323996445,"JB"],];
CONWAYPOLDATA[48337]:=[
,,,[25040692838,"JB"],];
CONWAYPOLDATA[48341]:=[
,,,[8450635236,"JB"],];
CONWAYPOLDATA[48353]:=[
,,,[17611951664,"JB"],];
CONWAYPOLDATA[48371]:=[
,,,[8618744782,"JB"],];
CONWAYPOLDATA[48383]:=[
,,,[9363465229,"JB"],];
CONWAYPOLDATA[48397]:=[
,,,[25311872990,"JB"],];
CONWAYPOLDATA[48407]:=[
,,,[5951398620,"JB"],];
CONWAYPOLDATA[48409]:=[
,,,[67548514756,"JB"],];
CONWAYPOLDATA[48413]:=[
,,,[16311453201,"JB"],];
CONWAYPOLDATA[48437]:=[
,,,[38960736885,"JB"],];
CONWAYPOLDATA[48449]:=[
,,,[6936346435,"JB"],];
CONWAYPOLDATA[48463]:=[
,,,[13875683850,"JB"],];
CONWAYPOLDATA[48473]:=[
,,,[11474819401,"JB"],];
CONWAYPOLDATA[48479]:=[
,,,[6121443337,"JB"],];
CONWAYPOLDATA[48481]:=[
,,,[41592043841,"JB"],];
CONWAYPOLDATA[48487]:=[
,,,[21090535856,"JB"],];
CONWAYPOLDATA[48491]:=[
,,,[18155903240,"JB"],];
CONWAYPOLDATA[48497]:=[
,,,[2173247567,"JB"],];
CONWAYPOLDATA[48523]:=[
,,,[13742247356,"JB"],];
CONWAYPOLDATA[48527]:=[
,,,[20492515362,"JB"],];
CONWAYPOLDATA[48533]:=[
,,,[22725431653,"JB"],];
CONWAYPOLDATA[48539]:=[
,,,[20924628973,"JB"],];
CONWAYPOLDATA[48541]:=[
,,,[18333159046,"JB"],];
CONWAYPOLDATA[48563]:=[
,,,[2322865418,"JB"],];
CONWAYPOLDATA[48571]:=[
,,,[18271681637,"JB"],];
CONWAYPOLDATA[48589]:=[
,,,[9252268801,"JB"],];
CONWAYPOLDATA[48593]:=[
,,,[42367119064,"JB"],];
CONWAYPOLDATA[48611]:=[
,,,[29954584312,"JB"],];
CONWAYPOLDATA[48619]:=[
,,,[8360912194,"JB"],];
CONWAYPOLDATA[48623]:=[
,,,[9419636549,"JB"],];
CONWAYPOLDATA[48647]:=[
,,,[16439669891,"JB"],];
CONWAYPOLDATA[48649]:=[
,,,[6544993222,"JB"],];
CONWAYPOLDATA[48661]:=[
,,,[15989274687,"JB"],];
CONWAYPOLDATA[48673]:=[
,,,[1512221452,"JB"],];
CONWAYPOLDATA[48677]:=[
,,,[11427996646,"JB"],];
CONWAYPOLDATA[48679]:=[
,,,[16319440037,"JB"],];
CONWAYPOLDATA[48731]:=[
,,,[11007796865,"JB"],];
CONWAYPOLDATA[48733]:=[
,,,[16133693181,"JB"],];
CONWAYPOLDATA[48751]:=[
,,,[11883105004,"JB"],];
CONWAYPOLDATA[48757]:=[
,,,[30725003664,"JB"],];
CONWAYPOLDATA[48761]:=[
,,,[6230436778,"JB"],];
CONWAYPOLDATA[48767]:=[
,,,[18506930204,"JB"],];
CONWAYPOLDATA[48779]:=[
,,,[18697868724,"JB"],];
CONWAYPOLDATA[48781]:=[
,,,[18790294863,"JB"],];
CONWAYPOLDATA[48787]:=[
,,,[20695542976,"JB"],];
CONWAYPOLDATA[48799]:=[
,,,[16133534991,"JB"],];
CONWAYPOLDATA[48809]:=[
,,,[2381732776,"JB"],];
CONWAYPOLDATA[48817]:=[
,,,[40328065424,"JB"],];
CONWAYPOLDATA[48821]:=[
,,,[11382420868,"JB"],];
CONWAYPOLDATA[48823]:=[
,,,[6879209528,"JB"],];
CONWAYPOLDATA[48847]:=[
,,,[13355649049,"JB"],];
CONWAYPOLDATA[48857]:=[
,,,[23089231919,"JB"],];
CONWAYPOLDATA[48859]:=[
,,,[4561671678,"JB"],];
CONWAYPOLDATA[48869]:=[
,,,[21192090721,"JB"],];
CONWAYPOLDATA[48871]:=[
,,,[15538729937,"JB"],];
CONWAYPOLDATA[48883]:=[
,,,[20991337862,"JB"],];
CONWAYPOLDATA[48889]:=[
,,,[83552181036,"JB"],];
CONWAYPOLDATA[48907]:=[
,,,[18999635897,"JB"],];
CONWAYPOLDATA[48947]:=[
,,,[21561936654,"JB"],];
CONWAYPOLDATA[48953]:=[
,,,[6767752253,"JB"],];
CONWAYPOLDATA[48973]:=[
,,,[16641074378,"JB"],];
CONWAYPOLDATA[48989]:=[
,,,[9098677983,"JB"],];
CONWAYPOLDATA[48991]:=[
,,,[9097089805,"JB"],];
CONWAYPOLDATA[49003]:=[
,,,[11601460263,"JB"],];
CONWAYPOLDATA[49009]:=[
,,,[78085941701,"JB"],];
CONWAYPOLDATA[49019]:=[
,,,[23853625782,"JB"],];
CONWAYPOLDATA[49031]:=[
,,,[33514159443,"JB"],];
CONWAYPOLDATA[49033]:=[
,,,[21226385710,"JB"],];
CONWAYPOLDATA[49037]:=[
,,,[45479610837,"JB"],];
CONWAYPOLDATA[49043]:=[
,,,[21359795878,"JB"],];
CONWAYPOLDATA[49057]:=[
,,,[16367917112,"JB"],];
CONWAYPOLDATA[49069]:=[
,,,[18426734365,"JB"],];
CONWAYPOLDATA[49081]:=[
,,,[30606911611,"JB"],];
CONWAYPOLDATA[49103]:=[
,,,[28349126025,"JB"],];
CONWAYPOLDATA[49109]:=[
,,,[18533933038,"JB"],];
CONWAYPOLDATA[49117]:=[
,,,[22961067811,"JB"],];
CONWAYPOLDATA[49121]:=[
,,,[11799699260,"JB"],];
CONWAYPOLDATA[49123]:=[
,,,[42855543801,"JB"],];
CONWAYPOLDATA[49139]:=[
,,,[11544372689,"JB"],];
CONWAYPOLDATA[49157]:=[
,,,[30707689704,"JB"],];
CONWAYPOLDATA[49169]:=[
,,,[11406027947,"JB"],];
CONWAYPOLDATA[49171]:=[
,,,[6494259827,"JB"],];
CONWAYPOLDATA[49177]:=[
,,,[41042583258,"JB"],];
CONWAYPOLDATA[49193]:=[
,,,[4708065261,"JB"],];
CONWAYPOLDATA[49199]:=[
,,,[11931200304,"JB"],];
CONWAYPOLDATA[49201]:=[
,,,[59724700299,"JB"],];
CONWAYPOLDATA[49207]:=[
,,,[16785934706,"JB"],];
CONWAYPOLDATA[49211]:=[
,,,[18539309243,"JB"],];
CONWAYPOLDATA[49223]:=[
,,,[6746110601,"JB"],];
CONWAYPOLDATA[49253]:=[
,,,[31269301365,"JB"],];
CONWAYPOLDATA[49261]:=[
,,,[16849528008,"JB"],];
CONWAYPOLDATA[49277]:=[
,,,[15885623600,"JB"],];
CONWAYPOLDATA[49279]:=[
,,,[23975366920,"JB"],];
CONWAYPOLDATA[49297]:=[
,,,[26082106062,"JB"],];
CONWAYPOLDATA[49307]:=[
,,,[2239326714,"JB"],];
CONWAYPOLDATA[49331]:=[
,,,[21436687390,"JB"],];
CONWAYPOLDATA[49333]:=[
,,,[30608166522,"JB"],];
CONWAYPOLDATA[49339]:=[
,,,[16745064543,"JB"],];
CONWAYPOLDATA[49363]:=[
,,,[7091044315,"JB"],];
CONWAYPOLDATA[49367]:=[
,,,[21426018510,"JB"],];
CONWAYPOLDATA[49369]:=[
,,,[26592266280,"JB"],];
CONWAYPOLDATA[49391]:=[
,,,[6287128574,"JB"],];
CONWAYPOLDATA[49393]:=[
,,,[28087724599,"JB"],];
CONWAYPOLDATA[49409]:=[
,,,[2440656376,"JB"],];
CONWAYPOLDATA[49411]:=[
,,,[26556732528,"JB"],];
CONWAYPOLDATA[49417]:=[
,,,[38541010143,"JB"],];
CONWAYPOLDATA[49429]:=[
,,,[16032147865,"JB"],];
CONWAYPOLDATA[49433]:=[
,,,[33058615351,"JB"],];
CONWAYPOLDATA[49451]:=[
,,,[20949668905,"JB"],];
CONWAYPOLDATA[49459]:=[
,,,[1501525784,"JB"],];
CONWAYPOLDATA[49463]:=[
,,,[21178622178,"JB"],];
CONWAYPOLDATA[49477]:=[
,,,[9023169978,"JB"],];
CONWAYPOLDATA[49481]:=[
,,,[2447775592,"JB"],];
CONWAYPOLDATA[49499]:=[
,,,[18506785120,"JB"],];
CONWAYPOLDATA[49523]:=[
,,,[7089663159,"JB"],];
CONWAYPOLDATA[49529]:=[
,,,[19392188431,"JB"],];
CONWAYPOLDATA[49531]:=[
,,,[29438947984,"JB"],];
CONWAYPOLDATA[49537]:=[
,,,[40837064385,"JB"],];
CONWAYPOLDATA[49547]:=[
,,,[18527852917,"JB"],];
CONWAYPOLDATA[49549]:=[
,,,[19576512612,"JB"],];
CONWAYPOLDATA[49559]:=[
,,,[23782372931,"JB"],];
CONWAYPOLDATA[49597]:=[
,,,[29072819062,"JB"],];
CONWAYPOLDATA[49603]:=[
,,,[8860782305,"JB"],];
CONWAYPOLDATA[49613]:=[
,,,[17167636005,"JB"],];
CONWAYPOLDATA[49627]:=[
,,,[13845287852,"JB"],];
CONWAYPOLDATA[49633]:=[
,,,[26007344574,"JB"],];
CONWAYPOLDATA[49639]:=[
,,,[16374863684,"JB"],];
CONWAYPOLDATA[49663]:=[
,,,[12331869196,"JB"],];
CONWAYPOLDATA[49667]:=[
,,,[21473527452,"JB"],];
CONWAYPOLDATA[49669]:=[
,,,[16804016082,"JB"],];
CONWAYPOLDATA[49681]:=[
,,,[35866651476,"JB"],];
CONWAYPOLDATA[49697]:=[
,,,[1636074940,"JB"],];
CONWAYPOLDATA[49711]:=[
,,,[26110603335,"JB"],];
CONWAYPOLDATA[49727]:=[
,,,[9890899213,"JB"],];
CONWAYPOLDATA[49739]:=[
,,,[4665120290,"JB"],];
CONWAYPOLDATA[49741]:=[
,,,[9820614337,"JB"],];
CONWAYPOLDATA[49747]:=[
,,,[14090340283,"JB"],];
CONWAYPOLDATA[49757]:=[
,,,[18794363313,"JB"],];
CONWAYPOLDATA[49783]:=[
,,,[14394654887,"JB"],];
CONWAYPOLDATA[49787]:=[
,,,[34492831898,"JB"],];
CONWAYPOLDATA[49789]:=[
,,,[28551253111,"JB"],];
CONWAYPOLDATA[49801]:=[
,,,[26369131503,"JB"],];
CONWAYPOLDATA[49807]:=[
,,,[36330321557,"JB"],];
CONWAYPOLDATA[49811]:=[
,,,[14127595070,"JB"],];
CONWAYPOLDATA[49823]:=[
,,,[21259723220,"JB"],];
CONWAYPOLDATA[49831]:=[
,,,[8878987254,"JB"],];
CONWAYPOLDATA[49843]:=[
,,,[18708520209,"JB"],];
CONWAYPOLDATA[49853]:=[
,,,[11298683922,"JB"],];
CONWAYPOLDATA[49871]:=[
,,,[9948067613,"JB"],];
CONWAYPOLDATA[49877]:=[
,,,[19273570096,"JB"],];
CONWAYPOLDATA[49891]:=[
,,,[21843926205,"JB"],];
CONWAYPOLDATA[49919]:=[
,,,[9407185638,"JB"],];
CONWAYPOLDATA[49921]:=[
,,,[59808652809,"JB"],];
CONWAYPOLDATA[49927]:=[
,,,[27419359206,"JB"],];
CONWAYPOLDATA[49937]:=[
,,,[4479448777,"JB"],];
CONWAYPOLDATA[49939]:=[
,,,[17212824710,"JB"],];
CONWAYPOLDATA[49943]:=[
,,,[9977013229,"JB"],];
CONWAYPOLDATA[49957]:=[
,,,[24407841194,"JB"],];
CONWAYPOLDATA[49991]:=[
,,,[6724689345,"JB"],];
CONWAYPOLDATA[49993]:=[
,,,[46790248453,"JB"],];
CONWAYPOLDATA[49999]:=[
,,,[34347563038,"JB"],];
CONWAYPOLDATA[50021]:=[
,,,[22518553824,"JB"],];
CONWAYPOLDATA[50023]:=[
,,,[14498666323,"JB"],];
CONWAYPOLDATA[50033]:=[
,,,[11803585233,"JB"],];
CONWAYPOLDATA[50047]:=[
,,,[27007012757,"JB"],];
CONWAYPOLDATA[50051]:=[
,,,[8909828767,"JB"],];
CONWAYPOLDATA[50053]:=[
,,,[16900695770,"JB"],];
CONWAYPOLDATA[50069]:=[
,,,[9246742922,"JB"],];
CONWAYPOLDATA[50077]:=[
,,,[17319681299,"JB"],];
CONWAYPOLDATA[50087]:=[
,,,[9529903234,"JB"],];
CONWAYPOLDATA[50093]:=[
,,,[21734951958,"JB"],];
CONWAYPOLDATA[50101]:=[
,,,[32591001108,"JB"],];
CONWAYPOLDATA[50111]:=[
,,,[10044048413,"JB"],];
CONWAYPOLDATA[50119]:=[
,,,[12559370332,"JB"],];
CONWAYPOLDATA[50123]:=[
,,,[26618871735,"JB"],];
CONWAYPOLDATA[50129]:=[
,,,[12242404125,"JB"],];
CONWAYPOLDATA[50131]:=[
,,,[21714794093,"JB"],];
CONWAYPOLDATA[50147]:=[
,,,[26642198456,"JB"],];
CONWAYPOLDATA[50153]:=[
,,,[24643830072,"JB"],];
CONWAYPOLDATA[50159]:=[
,,,[7307363763,"JB"],];
CONWAYPOLDATA[50177]:=[
,,,[16426043077,"JB"],];
CONWAYPOLDATA[50207]:=[
,,,[42206765590,"JB"],];
CONWAYPOLDATA[50221]:=[
,,,[19916141983,"JB"],];
CONWAYPOLDATA[50227]:=[
,,,[22041867817,"JB"],];
CONWAYPOLDATA[50231]:=[
,,,[21582251471,"JB"],];
CONWAYPOLDATA[50261]:=[
,,,[27787447246,"JB"],];
CONWAYPOLDATA[50263]:=[
,,,[10028222448,"JB"],];
CONWAYPOLDATA[50273]:=[
,,,[4591634185,"JB"],];
CONWAYPOLDATA[50287]:=[
,,,[14922818114,"JB"],];
CONWAYPOLDATA[50291]:=[
,,,[7268960560,"JB"],];
CONWAYPOLDATA[50311]:=[
,,,[6361373154,"JB"],];
CONWAYPOLDATA[50321]:=[
,,,[7571347987,"JB"],];
CONWAYPOLDATA[50329]:=[
,,,[2410356475,"JB"],];
CONWAYPOLDATA[50333]:=[
,,,[9209680677,"JB"],];
CONWAYPOLDATA[50341]:=[
,,,[32558796867,"JB"],];
CONWAYPOLDATA[50359]:=[
,,,[12679942972,"JB"],];
CONWAYPOLDATA[50363]:=[
,,,[6817891127,"JB"],];
CONWAYPOLDATA[50377]:=[
,,,[17487468769,"JB"],];
CONWAYPOLDATA[50383]:=[
,,,[9228654113,"JB"],];
CONWAYPOLDATA[50387]:=[
,,,[11672299713,"JB"],];
CONWAYPOLDATA[50411]:=[
,,,[10137349636,"JB"],];
CONWAYPOLDATA[50417]:=[
,,,[25252362793,"JB"],];
CONWAYPOLDATA[50423]:=[
,,,[22219096647,"JB"],];
CONWAYPOLDATA[50441]:=[
,,,[8937590355,"JB"],];
CONWAYPOLDATA[50459]:=[
,,,[12330615373,"JB"],];
CONWAYPOLDATA[50461]:=[
,,,[40288011946,"JB"],];
CONWAYPOLDATA[50497]:=[
,,,[17138984787,"JB"],];
CONWAYPOLDATA[50503]:=[
,,,[27244297882,"JB"],];
CONWAYPOLDATA[50513]:=[
,,,[1536959054,"JB"],];
CONWAYPOLDATA[50527]:=[
,,,[28082350806,"JB"],];
CONWAYPOLDATA[50539]:=[
,,,[4494433272,"JB"],];
CONWAYPOLDATA[50543]:=[
,,,[6903314574,"JB"],];
CONWAYPOLDATA[50549]:=[
,,,[1381301976,"JB"],];
CONWAYPOLDATA[50551]:=[
,,,[10205539189,"JB"],];
CONWAYPOLDATA[50581]:=[
,,,[25023836970,"JB"],];
CONWAYPOLDATA[50587]:=[
,,,[7222306004,"JB"],];
CONWAYPOLDATA[50591]:=[
,,,[14521741829,"JB"],];
CONWAYPOLDATA[50593]:=[
,,,[29494302401,"JB"],];
CONWAYPOLDATA[50599]:=[
,,,[9755335406,"JB"],];
CONWAYPOLDATA[50627]:=[
,,,[42324728899,"JB"],];
CONWAYPOLDATA[50647]:=[
,,,[9040084327,"JB"],];
CONWAYPOLDATA[50651]:=[
,,,[7255958356,"JB"],];
CONWAYPOLDATA[50671]:=[
,,,[9065244595,"JB"],];
CONWAYPOLDATA[50683]:=[
,,,[23118543622,"JB"],];
CONWAYPOLDATA[50707]:=[
,,,[7433443375,"JB"],];
CONWAYPOLDATA[50723]:=[
,,,[17925812540,"JB"],];
CONWAYPOLDATA[50741]:=[
,,,[11745222236,"JB"],];
CONWAYPOLDATA[50753]:=[
,,,[20049718888,"JB"],];
CONWAYPOLDATA[50767]:=[
,,,[32894629956,"JB"],];
CONWAYPOLDATA[50773]:=[
,,,[9112179548,"JB"],];
CONWAYPOLDATA[50777]:=[
,,,[32817835204,"JB"],];
CONWAYPOLDATA[50789]:=[
,,,[17511437734,"JB"],];
CONWAYPOLDATA[50821]:=[
,,,[27933711831,"JB"],];
CONWAYPOLDATA[50833]:=[
,,,[32579073039,"JB"],];
CONWAYPOLDATA[50839]:=[
,,,[6727575712,"JB"],];
CONWAYPOLDATA[50849]:=[
,,,[7622163405,"JB"],];
CONWAYPOLDATA[50857]:=[
,,,[24955682490,"JB"],];
CONWAYPOLDATA[50867]:=[
,,,[7256787956,"JB"],];
CONWAYPOLDATA[50873]:=[
,,,[4093750313,"JB"],];
CONWAYPOLDATA[50891]:=[
,,,[12759086176,"JB"],];
CONWAYPOLDATA[50893]:=[
,,,[9966834229,"JB"],];
CONWAYPOLDATA[50909]:=[
,,,[23325180168,"JB"],];
CONWAYPOLDATA[50923]:=[
,,,[19779053355,"JB"],];
CONWAYPOLDATA[50929]:=[
,,,[54056702688,"JB"],];
CONWAYPOLDATA[50951]:=[
,,,[36036317597,"JB"],];
CONWAYPOLDATA[50957]:=[
,,,[33415358494,"JB"],];
CONWAYPOLDATA[50969]:=[
,,,[2597227336,"JB"],];
CONWAYPOLDATA[50971]:=[
,,,[23362455910,"JB"],];
CONWAYPOLDATA[50989]:=[
,,,[17728773324,"JB"],];
CONWAYPOLDATA[50993]:=[
,,,[11895086120,"JB"],];
CONWAYPOLDATA[51001]:=[
,,,[1576797924,"JB"],];
CONWAYPOLDATA[51031]:=[
,,,[6729968283,"JB"],];
CONWAYPOLDATA[51043]:=[
,,,[6755847310,"JB"],];
CONWAYPOLDATA[51047]:=[
,,,[7407021799,"JB"],];
CONWAYPOLDATA[51059]:=[
,,,[20463221786,"JB"],];
CONWAYPOLDATA[51061]:=[
,,,[10009385710,"JB"],];
CONWAYPOLDATA[51071]:=[
,,,[12128290020,"JB"],];
CONWAYPOLDATA[51109]:=[
,,,[38593581417,"JB"],];
CONWAYPOLDATA[51131]:=[
,,,[14665751343,"JB"],];
CONWAYPOLDATA[51133]:=[
,,,[17568071610,"JB"],];
CONWAYPOLDATA[51137]:=[
,,,[7067184540,"JB"],];
CONWAYPOLDATA[51151]:=[
,,,[9713472601,"JB"],];
CONWAYPOLDATA[51157]:=[
,,,[5034002276,"JB"],];
CONWAYPOLDATA[51169]:=[
,,,[28386821468,"JB"],];
CONWAYPOLDATA[51193]:=[
,,,[86273771150,"JB"],];
CONWAYPOLDATA[51197]:=[
,,,[9448406352,"JB"],];
CONWAYPOLDATA[51199]:=[
,,,[9579947300,"JB"],];
CONWAYPOLDATA[51203]:=[
,,,[20941207754,"JB"],];
CONWAYPOLDATA[51217]:=[
,,,[17729840112,"JB"],];
CONWAYPOLDATA[51229]:=[
,,,[9730436262,"JB"],];
CONWAYPOLDATA[51239]:=[
,,,[36046021655,"JB"],];
CONWAYPOLDATA[51241]:=[
,,,[49380234343,"JB"],];
CONWAYPOLDATA[51257]:=[
,,,[12078917081,"JB"],];
CONWAYPOLDATA[51263]:=[
,,,[14917071638,"JB"],];
CONWAYPOLDATA[51283]:=[
,,,[23434074550,"JB"],];
CONWAYPOLDATA[51287]:=[
,,,[10521220333,"JB"],];
CONWAYPOLDATA[51307]:=[
,,,[10529427773,"JB"],];
CONWAYPOLDATA[51329]:=[
,,,[6723893687,"JB"],];
CONWAYPOLDATA[51341]:=[
,,,[23722725144,"JB"],];
CONWAYPOLDATA[51343]:=[
,,,[31632627677,"JB"],];
CONWAYPOLDATA[51347]:=[
,,,[23037242328,"JB"],];
CONWAYPOLDATA[51349]:=[
,,,[25248097914,"JB"],];
CONWAYPOLDATA[51361]:=[
,,,[86310927873,"JB"],];
CONWAYPOLDATA[51383]:=[
,,,[10560645229,"JB"],];
CONWAYPOLDATA[51407]:=[
,,,[7891180133,"JB"],];
CONWAYPOLDATA[51413]:=[
,,,[10355092332,"JB"],];
CONWAYPOLDATA[51419]:=[
,,,[21023583694,"JB"],];
CONWAYPOLDATA[51421]:=[
,,,[10327753589,"JB"],];
CONWAYPOLDATA[51427]:=[
,,,[86349378611,"JB"],];
CONWAYPOLDATA[51431]:=[
,,,[10381964529,"JB"],];
CONWAYPOLDATA[51437]:=[
,,,[47575675849,"JB"],];
CONWAYPOLDATA[51439]:=[
,,,[20073915436,"JB"],];
CONWAYPOLDATA[51449]:=[
,,,[6870293667,"JB"],];
CONWAYPOLDATA[51461]:=[
,,,[20473861774,"JB"],];
CONWAYPOLDATA[51473]:=[
,,,[44232498985,"JB"],];
CONWAYPOLDATA[51479]:=[
,,,[33259140495,"JB"],];
CONWAYPOLDATA[51481]:=[
,,,[46923541530,"JB"],];
CONWAYPOLDATA[51487]:=[
,,,[15264402380,"JB"],];
CONWAYPOLDATA[51503]:=[
,,,[9371228370,"JB"],];
CONWAYPOLDATA[51511]:=[
,,,[9741399749,"JB"],];
CONWAYPOLDATA[51517]:=[
,,,[18256079296,"JB"],];
CONWAYPOLDATA[51521]:=[
,,,[12946299925,"JB"],];
CONWAYPOLDATA[51539]:=[
,,,[7480318923,"JB"],];
CONWAYPOLDATA[51551]:=[
,,,[20473221906,"JB"],];
CONWAYPOLDATA[51563]:=[
,,,[22972296199,"JB"],];
CONWAYPOLDATA[51577]:=[
,,,[18389985668,"JB"],];
CONWAYPOLDATA[51581]:=[
,,,[4944864148,"JB"],];
CONWAYPOLDATA[51593]:=[
,,,[6747796880,"JB"],];
CONWAYPOLDATA[51599]:=[
,,,[7598984737,"JB"],];
CONWAYPOLDATA[51607]:=[
,,,[23008774525,"JB"],];
CONWAYPOLDATA[51613]:=[
,,,[27997833143,"JB"],];
CONWAYPOLDATA[51631]:=[
,,,[10050283951,"JB"],];
CONWAYPOLDATA[51637]:=[
,,,[53272550343,"JB"],];
CONWAYPOLDATA[51647]:=[
,,,[17593653851,"JB"],];
CONWAYPOLDATA[51659]:=[
,,,[1823924315,"JB"],];
CONWAYPOLDATA[51673]:=[
,,,[28731273140,"JB"],];
CONWAYPOLDATA[51679]:=[
,,,[9588211592,"JB"],];
CONWAYPOLDATA[51683]:=[
,,,[20838895700,"JB"],];
CONWAYPOLDATA[51691]:=[
,,,[1789128902,"JB"],];
CONWAYPOLDATA[51713]:=[
,,,[4881914055,"JB"],];
CONWAYPOLDATA[51719]:=[
,,,[20565905206,"JB"],];
CONWAYPOLDATA[51721]:=[
,,,[71983322409,"JB"],];
CONWAYPOLDATA[51749]:=[
,,,[4425626231,"JB"],];
CONWAYPOLDATA[51767]:=[
,,,[18148785467,"JB"],];
CONWAYPOLDATA[51769]:=[
,,,[71165653632,"JB"],];
CONWAYPOLDATA[51787]:=[
,,,[15548736031,"JB"],];
CONWAYPOLDATA[51797]:=[
,,,[20580243028,"JB"],];
CONWAYPOLDATA[51803]:=[
,,,[12861597039,"JB"],];
CONWAYPOLDATA[51817]:=[
,,,[1504765690,"JB"],];
CONWAYPOLDATA[51827]:=[
,,,[20575370829,"JB"],];
CONWAYPOLDATA[51829]:=[
,,,[34894807174,"JB"],];
CONWAYPOLDATA[51839]:=[
,,,[6820249881,"JB"],];
CONWAYPOLDATA[51853]:=[
,,,[15810550094,"JB"],];
CONWAYPOLDATA[51859]:=[
,,,[2167187613,"JB"],];
CONWAYPOLDATA[51869]:=[
,,,[13073944535,"JB"],];
CONWAYPOLDATA[51871]:=[
,,,[1815744362,"JB"],];
CONWAYPOLDATA[51893]:=[
,,,[7020863437,"JB"],];
CONWAYPOLDATA[51899]:=[
,,,[21105662534,"JB"],];
CONWAYPOLDATA[51907]:=[
,,,[10303124255,"JB"],];
CONWAYPOLDATA[51913]:=[
,,,[28764733745,"JB"],];
CONWAYPOLDATA[51929]:=[
,,,[7735447701,"JB"],];
CONWAYPOLDATA[51941]:=[
,,,[7120176165,"JB"],];
CONWAYPOLDATA[51949]:=[
,,,[18295918312,"JB"],];
CONWAYPOLDATA[51971]:=[
,,,[7432840451,"JB"],];
CONWAYPOLDATA[51973]:=[
,,,[18865627299,"JB"],];
CONWAYPOLDATA[51977]:=[
,,,[20654412355,"JB"],];
CONWAYPOLDATA[51991]:=[
,,,[28872785929,"JB"],];
CONWAYPOLDATA[52009]:=[
,,,[56421703622,"JB"],];
CONWAYPOLDATA[52021]:=[
,,,[34510471297,"JB"],];
CONWAYPOLDATA[52027]:=[
,,,[7240181376,"JB"],];
CONWAYPOLDATA[52051]:=[
,,,[4830697159,"JB"],];
CONWAYPOLDATA[52057]:=[
,,,[48620300981,"JB"],];
CONWAYPOLDATA[52067]:=[
,,,[45612045744,"JB"],];
CONWAYPOLDATA[52069]:=[
,,,[10311380279,"JB"],];
CONWAYPOLDATA[52081]:=[
,,,[56424607498,"JB"],];
CONWAYPOLDATA[52103]:=[
,,,[10858682029,"JB"],];
CONWAYPOLDATA[52121]:=[
,,,[2715973192,"JB"],];
CONWAYPOLDATA[52127]:=[
,,,[10712359140,"JB"],];
CONWAYPOLDATA[52147]:=[
,,,[24064901856,"JB"],];
CONWAYPOLDATA[52153]:=[
,,,[29321876889,"JB"],];
CONWAYPOLDATA[52163]:=[
,,,[31966321010,"JB"],];
CONWAYPOLDATA[52177]:=[
,,,[17801957573,"JB"],];
CONWAYPOLDATA[52181]:=[
,,,[9663399393,"JB"],];
CONWAYPOLDATA[52183]:=[
,,,[7772762219,"JB"],];
CONWAYPOLDATA[52189]:=[
,,,[64746456248,"JB"],];
CONWAYPOLDATA[52201]:=[
,,,[40587425939,"JB"],];
CONWAYPOLDATA[52223]:=[
,,,[26336058905,"JB"],];
CONWAYPOLDATA[52237]:=[
,,,[2551620745,"JB"],];
CONWAYPOLDATA[52249]:=[
,,,[2727920303,"JB"],];
CONWAYPOLDATA[52253]:=[
,,,[18814737712,"JB"],];
CONWAYPOLDATA[52259]:=[
,,,[10453367772,"JB"],];
CONWAYPOLDATA[52267]:=[
,,,[24586187734,"JB"],];
CONWAYPOLDATA[52289]:=[
,,,[21404659020,"JB"],];
CONWAYPOLDATA[52291]:=[
,,,[18603150749,"JB"],];
CONWAYPOLDATA[52301]:=[
,,,[27322303907,"JB"],];
CONWAYPOLDATA[52313]:=[
,,,[31680177360,"JB"],];
CONWAYPOLDATA[52321]:=[
,,,[51766397417,"JB"],];
CONWAYPOLDATA[52361]:=[
,,,[1491398369,"JB"],];
CONWAYPOLDATA[52363]:=[
,,,[57578564257,"JB"],];
CONWAYPOLDATA[52369]:=[
,,,[95878107855,"JB"],];
CONWAYPOLDATA[52379]:=[
,,,[8096117274,"JB"],];
CONWAYPOLDATA[52387]:=[
,,,[7887543883,"JB"],];
CONWAYPOLDATA[52391]:=[
,,,[15828264149,"JB"],];
CONWAYPOLDATA[52433]:=[
,,,[12668809030,"JB"],];
CONWAYPOLDATA[52453]:=[
,,,[30240465827,"JB"],];
CONWAYPOLDATA[52457]:=[
,,,[5361315231,"JB"],];
CONWAYPOLDATA[52489]:=[
,,,[2083603351,"JB"],];
CONWAYPOLDATA[52501]:=[
,,,[42778969832,"JB"],];
CONWAYPOLDATA[52511]:=[
,,,[9774660102,"JB"],];
CONWAYPOLDATA[52517]:=[
,,,[4462947179,"JB"],];
CONWAYPOLDATA[52529]:=[
,,,[2758665496,"JB"],];
CONWAYPOLDATA[52541]:=[
,,,[13440880999,"JB"],];
CONWAYPOLDATA[52543]:=[
,,,[7101554254,"JB"],];
CONWAYPOLDATA[52553]:=[
,,,[30238470673,"JB"],];
CONWAYPOLDATA[52561]:=[
,,,[2643975990,"JB"],];
CONWAYPOLDATA[52567]:=[
,,,[13816237180,"JB"],];
CONWAYPOLDATA[52571]:=[
,,,[10520929090,"JB"],];
CONWAYPOLDATA[52579]:=[
,,,[13651401246,"JB"],];
CONWAYPOLDATA[52583]:=[
,,,[7864366068,"JB"],];
CONWAYPOLDATA[52609]:=[
,,,[34722466101,"JB"],];
CONWAYPOLDATA[52627]:=[
,,,[8274648467,"JB"],];
CONWAYPOLDATA[52631]:=[
,,,[7723125584,"JB"],];
CONWAYPOLDATA[52639]:=[
,,,[13854111052,"JB"],];
CONWAYPOLDATA[52667]:=[
,,,[40564439404,"JB"],];
CONWAYPOLDATA[52673]:=[
,,,[8209929821,"JB"],];
CONWAYPOLDATA[52691]:=[
,,,[21081616411,"JB"],];
CONWAYPOLDATA[52697]:=[
,,,[12731964082,"JB"],];
CONWAYPOLDATA[52709]:=[
,,,[10738404572,"JB"],];
CONWAYPOLDATA[52711]:=[
,,,[9802770115,"JB"],];
CONWAYPOLDATA[52721]:=[
,,,[7077583369,"JB"],];
CONWAYPOLDATA[52727]:=[
,,,[26501697472,"JB"],];
CONWAYPOLDATA[52733]:=[
,,,[27018068950,"JB"],];
CONWAYPOLDATA[52747]:=[
,,,[15517956415,"JB"],];
CONWAYPOLDATA[52757]:=[
,,,[4617081614,"JB"],];
CONWAYPOLDATA[52769]:=[
,,,[8276078887,"JB"],];
CONWAYPOLDATA[52783]:=[
,,,[11143969229,"JB"],];
CONWAYPOLDATA[52807]:=[
,,,[2612309488,"JB"],];
CONWAYPOLDATA[52813]:=[
,,,[21627346006,"JB"],];
CONWAYPOLDATA[52817]:=[
,,,[13509849165,"JB"],];
CONWAYPOLDATA[52837]:=[
,,,[30025206459,"JB"],];
CONWAYPOLDATA[52859]:=[
,,,[15589757735,"JB"],];
CONWAYPOLDATA[52861]:=[
,,,[2027166500,"JB"],];
CONWAYPOLDATA[52879]:=[
,,,[10022368389,"JB"],];
CONWAYPOLDATA[52883]:=[
,,,[41162170531,"JB"],];
CONWAYPOLDATA[52889]:=[
,,,[9932342647,"JB"],];
CONWAYPOLDATA[52901]:=[
,,,[13992367404,"JB"],];
CONWAYPOLDATA[52903]:=[
,,,[18815480983,"JB"],];
CONWAYPOLDATA[52919]:=[
,,,[13003574205,"JB"],];
CONWAYPOLDATA[52937]:=[
,,,[18368821383,"JB"],];
CONWAYPOLDATA[52951]:=[
,,,[9983805151,"JB"],];
CONWAYPOLDATA[52957]:=[
,,,[33041196230,"JB"],];
CONWAYPOLDATA[52963]:=[
,,,[30483966876,"JB"],];
CONWAYPOLDATA[52967]:=[
,,,[11221800493,"JB"],];
CONWAYPOLDATA[52973]:=[
,,,[27697250890,"JB"],];
CONWAYPOLDATA[52981]:=[
,,,[28005332754,"JB"],];
CONWAYPOLDATA[52999]:=[
,,,[18999452516,"JB"],];
CONWAYPOLDATA[53003]:=[
,,,[21999584191,"JB"],];
CONWAYPOLDATA[53017]:=[
,,,[29964148065,"JB"],];
CONWAYPOLDATA[53047]:=[
,,,[9890825341,"JB"],];
CONWAYPOLDATA[53051]:=[
,,,[13147417132,"JB"],];
CONWAYPOLDATA[53069]:=[
,,,[19493835772,"JB"],];
CONWAYPOLDATA[53077]:=[
,,,[11122444583,"JB"],];
CONWAYPOLDATA[53087]:=[
,,,[11272705933,"JB"],];
CONWAYPOLDATA[53089]:=[
,,,[69485909304,"JB"],];
CONWAYPOLDATA[53093]:=[
,,,[11156856836,"JB"],];
CONWAYPOLDATA[53101]:=[
,,,[21458698213,"JB"],];
CONWAYPOLDATA[53113]:=[
,,,[53291831476,"JB"],];
CONWAYPOLDATA[53117]:=[
,,,[35372469397,"JB"],];
CONWAYPOLDATA[53129]:=[
,,,[21813332920,"JB"],];
CONWAYPOLDATA[53147]:=[
,,,[7258976703,"JB"],];
CONWAYPOLDATA[53149]:=[
,,,[21684632559,"JB"],];
CONWAYPOLDATA[53161]:=[
,,,[56181714356,"JB"],];
CONWAYPOLDATA[53171]:=[
,,,[8236560099,"JB"],];
CONWAYPOLDATA[53173]:=[
,,,[2620737669,"JB"],];
CONWAYPOLDATA[53189]:=[
,,,[13795152231,"JB"],];
CONWAYPOLDATA[53197]:=[
,,,[27158398427,"JB"],];
CONWAYPOLDATA[53201]:=[
,,,[2829707992,"JB"],];
CONWAYPOLDATA[53231]:=[
,,,[21818056148,"JB"],];
CONWAYPOLDATA[53233]:=[
,,,[18821006252,"JB"],];
CONWAYPOLDATA[53239]:=[
,,,[8113357408,"JB"],];
CONWAYPOLDATA[53267]:=[
,,,[25174996275,"JB"],];
CONWAYPOLDATA[53269]:=[
,,,[16886965504,"JB"],];
CONWAYPOLDATA[53279]:=[
,,,[7910599532,"JB"],];
CONWAYPOLDATA[53281]:=[
,,,[69987577247,"JB"],];
CONWAYPOLDATA[53299]:=[
,,,[24790377583,"JB"],];
CONWAYPOLDATA[53309]:=[
,,,[1480284314,"JB"],];
CONWAYPOLDATA[53323]:=[
,,,[41414694350,"JB"],];
CONWAYPOLDATA[53327]:=[
,,,[13653578450,"JB"],];
CONWAYPOLDATA[53353]:=[
,,,[50421519422,"JB"],];
CONWAYPOLDATA[53359]:=[
,,,[19880976454,"JB"],];
CONWAYPOLDATA[53377]:=[
,,,[30612456783,"JB"],];
CONWAYPOLDATA[53381]:=[
,,,[27231943485,"JB"],];
CONWAYPOLDATA[53401]:=[
,,,[2112383364,"JB"],];
CONWAYPOLDATA[53407]:=[
,,,[11409016973,"JB"],];
CONWAYPOLDATA[53411]:=[
,,,[25094196954,"JB"],];
CONWAYPOLDATA[53419]:=[
,,,[24439780111,"JB"],];
CONWAYPOLDATA[53437]:=[
,,,[10186160942,"JB"],];
CONWAYPOLDATA[53441]:=[
,,,[7455607354,"JB"],];
CONWAYPOLDATA[53453]:=[
,,,[19109394049,"JB"],];
CONWAYPOLDATA[53479]:=[
,,,[8459468660,"JB"],];
CONWAYPOLDATA[53503]:=[
,,,[10437900273,"JB"],];
CONWAYPOLDATA[53507]:=[
,,,[8280315266,"JB"],];
CONWAYPOLDATA[53527]:=[
,,,[14325484540,"JB"],];
CONWAYPOLDATA[53549]:=[
,,,[13741262441,"JB"],];
CONWAYPOLDATA[53551]:=[
,,,[19014300022,"JB"],];
CONWAYPOLDATA[53569]:=[
,,,[1632943846,"JB"],];
CONWAYPOLDATA[53591]:=[
,,,[13293622700,"JB"],];
CONWAYPOLDATA[53593]:=[
,,,[18960131545,"JB"],];
CONWAYPOLDATA[53597]:=[
,,,[34388424769,"JB"],];
CONWAYPOLDATA[53609]:=[
,,,[22689902035,"JB"],];
CONWAYPOLDATA[53611]:=[
,,,[1469316687,"JB"],];
CONWAYPOLDATA[53617]:=[
,,,[18940902276,"JB"],];
CONWAYPOLDATA[53623]:=[
,,,[14376916156,"JB"],];
CONWAYPOLDATA[53629]:=[
,,,[1662016345,"JB"],];
CONWAYPOLDATA[53633]:=[
,,,[21599349928,"JB"],];
CONWAYPOLDATA[53639]:=[
,,,[8275907682,"JB"],];
CONWAYPOLDATA[53653]:=[
,,,[11181338855,"JB"],];
CONWAYPOLDATA[53657]:=[
,,,[1691590585,"JB"],];
CONWAYPOLDATA[53681]:=[
,,,[2881005592,"JB"],];
CONWAYPOLDATA[53693]:=[
,,,[10454134488,"JB"],];
CONWAYPOLDATA[53699]:=[
,,,[27460755719,"JB"],];
CONWAYPOLDATA[53717]:=[
,,,[19299712347,"JB"],];
CONWAYPOLDATA[53719]:=[
,,,[10172391003,"JB"],];
CONWAYPOLDATA[53731]:=[
,,,[18889401717,"JB"],];
CONWAYPOLDATA[53759]:=[
,,,[11559690269,"JB"],];
CONWAYPOLDATA[53773]:=[
,,,[19215674006,"JB"],];
CONWAYPOLDATA[53777]:=[
,,,[48574774354,"JB"],];
CONWAYPOLDATA[53783]:=[
,,,[10428577488,"JB"],];
CONWAYPOLDATA[53791]:=[
,,,[7260870559,"JB"],];
CONWAYPOLDATA[53813]:=[
,,,[10239322390,"JB"],];
CONWAYPOLDATA[53819]:=[
,,,[11308717377,"JB"],];
CONWAYPOLDATA[53831]:=[
,,,[16642714953,"JB"],];
CONWAYPOLDATA[53849]:=[
,,,[2899068616,"JB"],];
CONWAYPOLDATA[53857]:=[
,,,[46176399378,"JB"],];
CONWAYPOLDATA[53861]:=[
,,,[28982119353,"JB"],];
CONWAYPOLDATA[53881]:=[
,,,[72020415848,"JB"],];
CONWAYPOLDATA[53887]:=[
,,,[10950485047,"JB"],];
CONWAYPOLDATA[53891]:=[
,,,[8092218671,"JB"],];
CONWAYPOLDATA[53897]:=[
,,,[14482932358,"JB"],];
CONWAYPOLDATA[53899]:=[
,,,[4905779184,"JB"],];
CONWAYPOLDATA[53917]:=[
,,,[22231650529,"JB"],];
CONWAYPOLDATA[53923]:=[
,,,[20353398124,"JB"],];
CONWAYPOLDATA[53927]:=[
,,,[11632269613,"JB"],];
CONWAYPOLDATA[53939]:=[
,,,[13960168348,"JB"],];
CONWAYPOLDATA[53951]:=[
,,,[14553066453,"JB"],];
CONWAYPOLDATA[53959]:=[
,,,[11286496115,"JB"],];
CONWAYPOLDATA[53987]:=[
,,,[14454641343,"JB"],];
CONWAYPOLDATA[53993]:=[
,,,[10491163861,"JB"],];
CONWAYPOLDATA[54001]:=[
,,,[42926042923,"JB"],];
CONWAYPOLDATA[54011]:=[
,,,[5498967934,"JB"],];
CONWAYPOLDATA[54013]:=[
,,,[20382129633,"JB"],];
CONWAYPOLDATA[54037]:=[
,,,[19314985282,"JB"],];
CONWAYPOLDATA[54049]:=[
,,,[66151381846,"JB"],];
CONWAYPOLDATA[54059]:=[
,,,[7764277936,"JB"],];
CONWAYPOLDATA[54083]:=[
,,,[22266403766,"JB"],];
CONWAYPOLDATA[54091]:=[
,,,[10469908054,"JB"],];
CONWAYPOLDATA[54101]:=[
,,,[14634374604,"JB"],];
CONWAYPOLDATA[54121]:=[
,,,[43252853761,"JB"],];
CONWAYPOLDATA[54133]:=[
,,,[19287858570,"JB"],];
CONWAYPOLDATA[54139]:=[
,,,[26335645857,"JB"],];
CONWAYPOLDATA[54151]:=[
,,,[10927292749,"JB"],];
CONWAYPOLDATA[54163]:=[
,,,[26170586668,"JB"],];
CONWAYPOLDATA[54167]:=[
,,,[25597482527,"JB"],];
CONWAYPOLDATA[54181]:=[
,,,[36815230968,"JB"],];
CONWAYPOLDATA[54193]:=[
,,,[38146073359,"JB"],];
CONWAYPOLDATA[54217]:=[
,,,[19892108871,"JB"],];
CONWAYPOLDATA[54251]:=[
,,,[25475130331,"JB"],];
CONWAYPOLDATA[54269]:=[
,,,[26401868502,"JB"],];
CONWAYPOLDATA[54277]:=[
,,,[11339767953,"JB"],];
CONWAYPOLDATA[54287]:=[
,,,[11788096333,"JB"],];
CONWAYPOLDATA[54293]:=[
,,,[8762184393,"JB"],];
CONWAYPOLDATA[54311]:=[
,,,[31415003119,"JB"],];
CONWAYPOLDATA[54319]:=[
,,,[20202539759,"JB"],];
CONWAYPOLDATA[54323]:=[
,,,[23565914955,"JB"],];
CONWAYPOLDATA[54331]:=[
,,,[26275721215,"JB"],];
CONWAYPOLDATA[54347]:=[
,,,[34483606278,"JB"],];
CONWAYPOLDATA[54361]:=[
,,,[50099913022,"JB"],];
CONWAYPOLDATA[54367]:=[
,,,[8302384575,"JB"],];
CONWAYPOLDATA[54371]:=[
,,,[14635368302,"JB"],];
CONWAYPOLDATA[54377]:=[
,,,[5768584050,"JB"],];
CONWAYPOLDATA[54401]:=[
,,,[13601120419,"JB"],];
CONWAYPOLDATA[54403]:=[
,,,[5289114065,"JB"],];
CONWAYPOLDATA[54409]:=[
,,,[52525686881,"JB"],];
CONWAYPOLDATA[54413]:=[
,,,[13870635484,"JB"],];
CONWAYPOLDATA[54419]:=[
,,,[26140003395,"JB"],];
CONWAYPOLDATA[54421]:=[
,,,[26654426224,"JB"],];
CONWAYPOLDATA[54437]:=[
,,,[2185917737,"JB"],];
CONWAYPOLDATA[54443]:=[
,,,[25222026384,"JB"],];
CONWAYPOLDATA[54449]:=[
,,,[1985972829,"JB"],];
CONWAYPOLDATA[54469]:=[
,,,[37132170930,"JB"],];
CONWAYPOLDATA[54493]:=[
,,,[28289822980,"JB"],];
CONWAYPOLDATA[54497]:=[
,,,[14753536837,"JB"],];
CONWAYPOLDATA[54499]:=[
,,,[16881337748,"JB"],];
CONWAYPOLDATA[54503]:=[
,,,[14473925693,"JB"],];
CONWAYPOLDATA[54517]:=[
,,,[70598915318,"JB"],];
CONWAYPOLDATA[54521]:=[
,,,[13619727450,"JB"],];
CONWAYPOLDATA[54539]:=[
,,,[13594063908,"JB"],];
CONWAYPOLDATA[54541]:=[
,,,[20307686860,"JB"],];
CONWAYPOLDATA[54547]:=[
,,,[14757363571,"JB"],];
CONWAYPOLDATA[54559]:=[
,,,[8896335984,"JB"],];
CONWAYPOLDATA[54563]:=[
,,,[23721591630,"JB"],];
CONWAYPOLDATA[54577]:=[
,,,[44679133593,"JB"],];
CONWAYPOLDATA[54581]:=[
,,,[2858789047,"JB"],];
CONWAYPOLDATA[54583]:=[
,,,[11211566537,"JB"],];
CONWAYPOLDATA[54601]:=[
,,,[68458679221,"JB"],];
CONWAYPOLDATA[54617]:=[
,,,[23571113310,"JB"],];
CONWAYPOLDATA[54623]:=[
,,,[13882326209,"JB"],];
CONWAYPOLDATA[54629]:=[
,,,[37924544383,"JB"],];
CONWAYPOLDATA[54631]:=[
,,,[10739252724,"JB"],];
CONWAYPOLDATA[54647]:=[
,,,[23544496014,"JB"],];
CONWAYPOLDATA[54667]:=[
,,,[40497204268,"JB"],];
CONWAYPOLDATA[54673]:=[
,,,[20608221933,"JB"],];
CONWAYPOLDATA[54679]:=[
,,,[2645041953,"JB"],];
CONWAYPOLDATA[54709]:=[
,,,[20922909962,"JB"],];
CONWAYPOLDATA[54713]:=[
,,,[20385407249,"JB"],];
CONWAYPOLDATA[54721]:=[
,,,[62366453968,"JB"],];
CONWAYPOLDATA[54727]:=[
,,,[17818782841,"JB"],];
CONWAYPOLDATA[54751]:=[
,,,[23980828504,"JB"],];
CONWAYPOLDATA[54767]:=[
,,,[16972567140,"JB"],];
CONWAYPOLDATA[54773]:=[
,,,[8722928890,"JB"],];
CONWAYPOLDATA[54779]:=[
,,,[26076885604,"JB"],];
CONWAYPOLDATA[54787]:=[
,,,[23231934269,"JB"],];
CONWAYPOLDATA[54799]:=[
,,,[7743427497,"JB"],];
CONWAYPOLDATA[54829]:=[
,,,[27055589368,"JB"],];
CONWAYPOLDATA[54833]:=[
,,,[5838672676,"JB"],];
CONWAYPOLDATA[54851]:=[
,,,[47581706678,"JB"],];
CONWAYPOLDATA[54869]:=[
,,,[14775288929,"JB"],];
CONWAYPOLDATA[54877]:=[
,,,[38866196236,"JB"],];
CONWAYPOLDATA[54881]:=[
,,,[14676496547,"JB"],];
CONWAYPOLDATA[54907]:=[
,,,[23216052277,"JB"],];
CONWAYPOLDATA[54917]:=[
,,,[17380571498,"JB"],];
CONWAYPOLDATA[54919]:=[
,,,[11400854889,"JB"],];
CONWAYPOLDATA[54941]:=[
,,,[11834511166,"JB"],];
CONWAYPOLDATA[54949]:=[
,,,[27174148768,"JB"],];
CONWAYPOLDATA[54959]:=[
,,,[7751142572,"JB"],];
CONWAYPOLDATA[54973]:=[
,,,[4691560753,"JB"],];
CONWAYPOLDATA[54979]:=[
,,,[11427770006,"JB"],];
CONWAYPOLDATA[54983]:=[
,,,[20823986510,"JB"],];
CONWAYPOLDATA[55001]:=[
,,,[26451190925,"JB"],];
CONWAYPOLDATA[55009]:=[
,,,[74747549423,"JB"],];
CONWAYPOLDATA[55021]:=[
,,,[22744085797,"JB"],];
CONWAYPOLDATA[55049]:=[
,,,[14651731748,"JB"],];
CONWAYPOLDATA[55051]:=[
,,,[8026160547,"JB"],];
CONWAYPOLDATA[55057]:=[
,,,[38501965737,"JB"],];
CONWAYPOLDATA[55061]:=[
,,,[10946236924,"JB"],];
CONWAYPOLDATA[55073]:=[
,,,[23349024448,"JB"],];
CONWAYPOLDATA[55079]:=[
,,,[8147506009,"JB"],];
CONWAYPOLDATA[55103]:=[
,,,[11780194860,"JB"],];
CONWAYPOLDATA[55109]:=[
,,,[29303990316,"JB"],];
CONWAYPOLDATA[55117]:=[
,,,[5282523519,"JB"],];
CONWAYPOLDATA[55127]:=[
,,,[17429448468,"JB"],];
CONWAYPOLDATA[55147]:=[
,,,[12164545853,"JB"],];
CONWAYPOLDATA[55163]:=[
,,,[42294796014,"JB"],];
CONWAYPOLDATA[55171]:=[
,,,[41706351947,"JB"],];
CONWAYPOLDATA[55201]:=[
,,,[2837221005,"JB"],];
CONWAYPOLDATA[55207]:=[
,,,[8530199196,"JB"],];
CONWAYPOLDATA[55213]:=[
,,,[20982375540,"JB"],];
CONWAYPOLDATA[55217]:=[
,,,[36337424231,"JB"],];
CONWAYPOLDATA[55219]:=[
,,,[7667323809,"JB"],];
CONWAYPOLDATA[55229]:=[
,,,[14346285042,"JB"],];
CONWAYPOLDATA[55243]:=[
,,,[8896332722,"JB"],];
CONWAYPOLDATA[55249]:=[
,,,[27256320675,"JB"],];
CONWAYPOLDATA[55259]:=[
,,,[2551971144,"JB"],];
CONWAYPOLDATA[55291]:=[
,,,[1620247475,"JB"],];
CONWAYPOLDATA[55313]:=[
,,,[2921853915,"JB"],];
CONWAYPOLDATA[55331]:=[
,,,[20999165791,"JB"],];
CONWAYPOLDATA[55333]:=[
,,,[26585127187,"JB"],];
CONWAYPOLDATA[55337]:=[
,,,[23547110917,"JB"],];
CONWAYPOLDATA[55339]:=[
,,,[26217625998,"JB"],];
CONWAYPOLDATA[55343]:=[
,,,[52067745924,"JB"],];
CONWAYPOLDATA[55351]:=[
,,,[11770999018,"JB"],];
CONWAYPOLDATA[55373]:=[
,,,[11734590789,"JB"],];
CONWAYPOLDATA[55381]:=[
,,,[36012436733,"JB"],];
CONWAYPOLDATA[55399]:=[
,,,[8583576465,"JB"],];
CONWAYPOLDATA[55411]:=[
,,,[8693653436,"JB"],];
CONWAYPOLDATA[55439]:=[
,,,[14641218157,"JB"],];
CONWAYPOLDATA[55441]:=[
,,,[64100884238,"JB"],];
CONWAYPOLDATA[55457]:=[
,,,[5935174514,"JB"],];
CONWAYPOLDATA[55469]:=[
,,,[4995926425,"JB"],];
CONWAYPOLDATA[55487]:=[
,,,[21128728274,"JB"],];
CONWAYPOLDATA[55501]:=[
,,,[21562305009,"JB"],];
CONWAYPOLDATA[55511]:=[
,,,[17941543788,"JB"],];
CONWAYPOLDATA[55529]:=[
,,,[8540304674,"JB"],];
CONWAYPOLDATA[55541]:=[
,,,[14787458006,"JB"],];
CONWAYPOLDATA[55547]:=[
,,,[13984957098,"JB"],];
CONWAYPOLDATA[55579]:=[
,,,[8716287835,"JB"],];
CONWAYPOLDATA[55589]:=[
,,,[39271627298,"JB"],];
CONWAYPOLDATA[55603]:=[
,,,[26561441896,"JB"],];
CONWAYPOLDATA[55609]:=[
,,,[3090192143,"JB"],];
CONWAYPOLDATA[55619]:=[
,,,[23555147073,"JB"],];
CONWAYPOLDATA[55621]:=[
,,,[23868917837,"JB"],];
CONWAYPOLDATA[55631]:=[
,,,[14525309738,"JB"],];
CONWAYPOLDATA[55633]:=[
,,,[51482388774,"JB"],];
CONWAYPOLDATA[55639]:=[
,,,[21159734259,"JB"],];
CONWAYPOLDATA[55661]:=[
,,,[39252972117,"JB"],];
CONWAYPOLDATA[55663]:=[
,,,[10902656150,"JB"],];
CONWAYPOLDATA[55667]:=[
,,,[43139809656,"JB"],];
CONWAYPOLDATA[55673]:=[
,,,[14701513440,"JB"],];
CONWAYPOLDATA[55681]:=[
,,,[38892009210,"JB"],];
CONWAYPOLDATA[55691]:=[
,,,[8669529354,"JB"],];
CONWAYPOLDATA[55697]:=[
,,,[8158663654,"JB"],];
CONWAYPOLDATA[55711]:=[
,,,[9218164907,"JB"],];
CONWAYPOLDATA[55717]:=[
,,,[30482770702,"JB"],];
CONWAYPOLDATA[55721]:=[
,,,[23703044751,"JB"],];
CONWAYPOLDATA[55733]:=[
,,,[5397852518,"JB"],];
CONWAYPOLDATA[55763]:=[
,,,[14233728804,"JB"],];
CONWAYPOLDATA[55787]:=[
,,,[11842352788,"JB"],];
CONWAYPOLDATA[55793]:=[
,,,[39009572915,"JB"],];
CONWAYPOLDATA[55799]:=[
,,,[17176717775,"JB"],];
CONWAYPOLDATA[55807]:=[
,,,[20275352787,"JB"],];
CONWAYPOLDATA[55813]:=[
,,,[32927214230,"JB"],];
CONWAYPOLDATA[55817]:=[
,,,[2731516532,"JB"],];
CONWAYPOLDATA[55819]:=[
,,,[26776709216,"JB"],];
CONWAYPOLDATA[55823]:=[
,,,[27468544500,"JB"],];
CONWAYPOLDATA[55829]:=[
,,,[23708008168,"JB"],];
CONWAYPOLDATA[55837]:=[
,,,[21456372321,"JB"],];
CONWAYPOLDATA[55843]:=[
,,,[27311694442,"JB"],];
CONWAYPOLDATA[55849]:=[
,,,[33798362740,"JB"],];
CONWAYPOLDATA[55871]:=[
,,,[11435899771,"JB"],];
CONWAYPOLDATA[55889]:=[
,,,[3122909656,"JB"],];
CONWAYPOLDATA[55897]:=[
,,,[39810402375,"JB"],];
CONWAYPOLDATA[55901]:=[
,,,[12115032425,"JB"],];
CONWAYPOLDATA[55903]:=[
,,,[8699009938,"JB"],];
CONWAYPOLDATA[55921]:=[
,,,[27427516970,"JB"],];
CONWAYPOLDATA[55927]:=[
,,,[11376334781,"JB"],];
CONWAYPOLDATA[55931]:=[
,,,[2948850119,"JB"],];
CONWAYPOLDATA[55933]:=[
,,,[21460373442,"JB"],];
CONWAYPOLDATA[55949]:=[
,,,[4710234414,"JB"],];
CONWAYPOLDATA[55967]:=[
,,,[18040178917,"JB"],];
CONWAYPOLDATA[55987]:=[
,,,[27101907027,"JB"],];
CONWAYPOLDATA[55997]:=[
,,,[39738159058,"JB"],];
CONWAYPOLDATA[56003]:=[
,,,[8721123180,"JB"],];
CONWAYPOLDATA[56009]:=[
,,,[8718192916,"JB"],];
CONWAYPOLDATA[56039]:=[
,,,[15701343261,"JB"],];
CONWAYPOLDATA[56041]:=[
,,,[2270949450,"JB"],];
CONWAYPOLDATA[56053]:=[
,,,[31061321528,"JB"],];
CONWAYPOLDATA[56081]:=[
,,,[2802591897,"JB"],];
CONWAYPOLDATA[56087]:=[
,,,[18791556746,"JB"],];
CONWAYPOLDATA[56093]:=[
,,,[21715114813,"JB"],];
CONWAYPOLDATA[56099]:=[
,,,[14999638424,"JB"],];
CONWAYPOLDATA[56101]:=[
,,,[49715471985,"JB"],];
CONWAYPOLDATA[56113]:=[
,,,[53274467787,"JB"],];
CONWAYPOLDATA[56123]:=[
,,,[27631261084,"JB"],];
CONWAYPOLDATA[56131]:=[
,,,[9354343414,"JB"],];
CONWAYPOLDATA[56149]:=[
,,,[3099480955,"JB"],];
CONWAYPOLDATA[56167]:=[
,,,[12592304401,"JB"],];
CONWAYPOLDATA[56171]:=[
,,,[7958082598,"JB"],];
CONWAYPOLDATA[56179]:=[
,,,[12530164163,"JB"],];
CONWAYPOLDATA[56197]:=[
,,,[12429933458,"JB"],];
CONWAYPOLDATA[56207]:=[
,,,[12636682573,"JB"],];
CONWAYPOLDATA[56209]:=[
,,,[3082895030,"JB"],];
CONWAYPOLDATA[56237]:=[
,,,[21872143938,"JB"],];
CONWAYPOLDATA[56239]:=[
,,,[11896966780,"JB"],];
CONWAYPOLDATA[56249]:=[
,,,[9241204462,"JB"],];
CONWAYPOLDATA[56263]:=[
,,,[15827400796,"JB"],];
CONWAYPOLDATA[56267]:=[
,,,[24851783494,"JB"],];
CONWAYPOLDATA[56269]:=[
,,,[24463960594,"JB"],];
CONWAYPOLDATA[56299]:=[
,,,[2651007322,"JB"],];
CONWAYPOLDATA[56311]:=[
,,,[21768481142,"JB"],];
CONWAYPOLDATA[56333]:=[
,,,[2510930811,"JB"],];
CONWAYPOLDATA[56359]:=[
,,,[8685880006,"JB"],];
CONWAYPOLDATA[56369]:=[
,,,[3176787736,"JB"],];
CONWAYPOLDATA[56377]:=[
,,,[76126990645,"JB"],];
CONWAYPOLDATA[56383]:=[
,,,[18331240963,"JB"],];
CONWAYPOLDATA[56393]:=[
,,,[21789240129,"JB"],];
CONWAYPOLDATA[56401]:=[
,,,[46332744701,"JB"],];
CONWAYPOLDATA[56417]:=[
,,,[30749408849,"JB"],];
CONWAYPOLDATA[56431]:=[
,,,[20830149309,"JB"],];
CONWAYPOLDATA[56437]:=[
,,,[12037447732,"JB"],];
CONWAYPOLDATA[56443]:=[
,,,[18294474494,"JB"],];
CONWAYPOLDATA[56453]:=[
,,,[4804601926,"JB"],];
CONWAYPOLDATA[56467]:=[
,,,[8195733316,"JB"],];
CONWAYPOLDATA[56473]:=[
,,,[104385427354,"JB"],];
CONWAYPOLDATA[56477]:=[
,,,[23953138196,"JB"],];
CONWAYPOLDATA[56479]:=[
,,,[11346518148,"JB"],];
CONWAYPOLDATA[56489]:=[
,,,[11285767846,"JB"],];
CONWAYPOLDATA[56501]:=[
,,,[15961589004,"JB"],];
CONWAYPOLDATA[56503]:=[
,,,[8396910833,"JB"],];
CONWAYPOLDATA[56509]:=[
,,,[11825581923,"JB"],];
CONWAYPOLDATA[56519]:=[
,,,[36795281988,"JB"],];
CONWAYPOLDATA[56527]:=[
,,,[12271389906,"JB"],];
CONWAYPOLDATA[56531]:=[
,,,[49578252312,"JB"],];
CONWAYPOLDATA[56533]:=[
,,,[11610408347,"JB"],];
CONWAYPOLDATA[56543]:=[
,,,[12788217229,"JB"],];
CONWAYPOLDATA[56569]:=[
,,,[108145106933,"JB"],];
CONWAYPOLDATA[56591]:=[
,,,[16011857559,"JB"],];
CONWAYPOLDATA[56597]:=[
,,,[18592680472,"JB"],];
CONWAYPOLDATA[56599]:=[
,,,[16017007612,"JB"],];
CONWAYPOLDATA[56611]:=[
,,,[3160139268,"JB"],];
CONWAYPOLDATA[56629]:=[
,,,[28861196368,"JB"],];
CONWAYPOLDATA[56633]:=[
,,,[1786091557,"JB"],];
CONWAYPOLDATA[56659]:=[
,,,[28347347587,"JB"],];
CONWAYPOLDATA[56663]:=[
,,,[12842555629,"JB"],];
CONWAYPOLDATA[56671]:=[
,,,[9020266402,"JB"],];
CONWAYPOLDATA[56681]:=[
,,,[3212055592,"JB"],];
CONWAYPOLDATA[56687]:=[
,,,[15364217737,"JB"],];
CONWAYPOLDATA[56701]:=[
,,,[22334240397,"JB"],];
CONWAYPOLDATA[56711]:=[
,,,[9180773664,"JB"],];
CONWAYPOLDATA[56713]:=[
,,,[34527101257,"JB"],];
CONWAYPOLDATA[56731]:=[
,,,[21030862474,"JB"],];
CONWAYPOLDATA[56737]:=[
,,,[41566263791,"JB"],];
CONWAYPOLDATA[56747]:=[
,,,[25238398493,"JB"],];
CONWAYPOLDATA[56767]:=[
,,,[56583812894,"JB"],];
CONWAYPOLDATA[56773]:=[
,,,[12094465738,"JB"],];
CONWAYPOLDATA[56779]:=[
,,,[28606111887,"JB"],];
CONWAYPOLDATA[56783]:=[
,,,[31086137270,"JB"],];
CONWAYPOLDATA[56807]:=[
,,,[28077541439,"JB"],];
CONWAYPOLDATA[56809]:=[
,,,[87135007633,"JB"],];
CONWAYPOLDATA[56813]:=[
,,,[48355191880,"JB"],];
CONWAYPOLDATA[56821]:=[
,,,[25435750193,"JB"],];
CONWAYPOLDATA[56827]:=[
,,,[28092654760,"JB"],];
CONWAYPOLDATA[56843]:=[
,,,[25372555168,"JB"],];
CONWAYPOLDATA[56857]:=[
,,,[40829750848,"JB"],];
CONWAYPOLDATA[56873]:=[
,,,[1788428361,"JB"],];
CONWAYPOLDATA[56891]:=[
,,,[27763661367,"JB"],];
CONWAYPOLDATA[56893]:=[
,,,[21513519022,"JB"],];
CONWAYPOLDATA[56897]:=[
,,,[28723767691,"JB"],];
CONWAYPOLDATA[56909]:=[
,,,[29147310168,"JB"],];
CONWAYPOLDATA[56911]:=[
,,,[11531705200,"JB"],];
CONWAYPOLDATA[56921]:=[
,,,[24983651481,"JB"],];
CONWAYPOLDATA[56923]:=[
,,,[15655020386,"JB"],];
CONWAYPOLDATA[56929]:=[
,,,[40584854901,"JB"],];
CONWAYPOLDATA[56941]:=[
,,,[30976302589,"JB"],];
CONWAYPOLDATA[56951]:=[
,,,[8675915353,"JB"],];
CONWAYPOLDATA[56957]:=[
,,,[4980889652,"JB"],];
CONWAYPOLDATA[56963]:=[
,,,[22436187701,"JB"],];
CONWAYPOLDATA[56983]:=[
,,,[11821921115,"JB"],];
CONWAYPOLDATA[56989]:=[
,,,[8195417129,"JB"],];
CONWAYPOLDATA[56993]:=[
,,,[5450240593,"JB"],];
CONWAYPOLDATA[56999]:=[
,,,[45483378045,"JB"],];
CONWAYPOLDATA[57037]:=[
,,,[6447063226,"JB"],];
CONWAYPOLDATA[57041]:=[
,,,[21508621004,"JB"],];
CONWAYPOLDATA[57047]:=[
,,,[11727265891,"JB"],];
CONWAYPOLDATA[57059]:=[
,,,[12018565408,"JB"],];
CONWAYPOLDATA[57073]:=[
,,,[35086539923,"JB"],];
CONWAYPOLDATA[57077]:=[
,,,[21242746631,"JB"],];
CONWAYPOLDATA[57089]:=[
,,,[26053935289,"JB"],];
CONWAYPOLDATA[57097]:=[
,,,[44635865242,"JB"],];
CONWAYPOLDATA[57107]:=[
,,,[25113659857,"JB"],];
CONWAYPOLDATA[57119]:=[
,,,[12968412017,"JB"],];
CONWAYPOLDATA[57131]:=[
,,,[24913343696,"JB"],];
CONWAYPOLDATA[57139]:=[
,,,[21321760686,"JB"],];
CONWAYPOLDATA[57143]:=[
,,,[11869515393,"JB"],];
CONWAYPOLDATA[57149]:=[
,,,[2738294337,"JB"],];
CONWAYPOLDATA[57163]:=[
,,,[28244695606,"JB"],];
CONWAYPOLDATA[57173]:=[
,,,[25090656917,"JB"],];
CONWAYPOLDATA[57179]:=[
,,,[9527107803,"JB"],];
CONWAYPOLDATA[57191]:=[
,,,[18769857443,"JB"],];
CONWAYPOLDATA[57193]:=[
,,,[51341812947,"JB"],];
CONWAYPOLDATA[57203]:=[
,,,[35705082948,"JB"],];
CONWAYPOLDATA[57221]:=[
,,,[11616664096,"JB"],];
CONWAYPOLDATA[57223]:=[
,,,[12270213447,"JB"],];
CONWAYPOLDATA[57241]:=[
,,,[68210379046,"JB"],];
CONWAYPOLDATA[57251]:=[
,,,[12433772182,"JB"],];
CONWAYPOLDATA[57259]:=[
,,,[8603336529,"JB"],];
CONWAYPOLDATA[57269]:=[
,,,[41451531278,"JB"],];
CONWAYPOLDATA[57271]:=[
,,,[22535336709,"JB"],];
CONWAYPOLDATA[57283]:=[
,,,[29161400510,"JB"],];
CONWAYPOLDATA[57287]:=[
,,,[25153976974,"JB"],];
CONWAYPOLDATA[57301]:=[
,,,[8739262021,"JB"],];
CONWAYPOLDATA[57329]:=[
,,,[3285926296,"JB"],];
CONWAYPOLDATA[57331]:=[
,,,[29243109827,"JB"],];
CONWAYPOLDATA[57347]:=[
,,,[29597704254,"JB"],];
CONWAYPOLDATA[57349]:=[
,,,[29154511132,"JB"],];
CONWAYPOLDATA[57367]:=[
,,,[19664547098,"JB"],];
CONWAYPOLDATA[57373]:=[
,,,[51182912286,"JB"],];
CONWAYPOLDATA[57383]:=[
,,,[15323212027,"JB"],];
CONWAYPOLDATA[57389]:=[
,,,[12594934276,"JB"],];
CONWAYPOLDATA[57397]:=[
,,,[22493941699,"JB"],];
CONWAYPOLDATA[57413]:=[
,,,[49348482957,"JB"],];
CONWAYPOLDATA[57427]:=[
,,,[36175334674,"JB"],];
CONWAYPOLDATA[57457]:=[
,,,[35642760471,"JB"],];
CONWAYPOLDATA[57467]:=[
,,,[26137658145,"JB"],];
CONWAYPOLDATA[57487]:=[
,,,[12379480534,"JB"],];
CONWAYPOLDATA[57493]:=[
,,,[22381794933,"JB"],];
CONWAYPOLDATA[57503]:=[
,,,[39678450077,"JB"],];
CONWAYPOLDATA[57527]:=[
,,,[8599538654,"JB"],];
CONWAYPOLDATA[57529]:=[
,,,[1686462642,"JB"],];
CONWAYPOLDATA[57557]:=[
,,,[5885088138,"JB"],];
CONWAYPOLDATA[57559]:=[
,,,[38637572377,"JB"],];
CONWAYPOLDATA[57571]:=[
,,,[16482577313,"JB"],];
CONWAYPOLDATA[57587]:=[
,,,[9450141876,"JB"],];
CONWAYPOLDATA[57593]:=[
,,,[32738625667,"JB"],];
CONWAYPOLDATA[57601]:=[
,,,[56078490375,"JB"],];
CONWAYPOLDATA[57637]:=[
,,,[23048459932,"JB"],];
CONWAYPOLDATA[57641]:=[
,,,[2930814289,"JB"],];
CONWAYPOLDATA[57649]:=[
,,,[95776261494,"JB"],];
CONWAYPOLDATA[57653]:=[
,,,[25794759344,"JB"],];
CONWAYPOLDATA[57667]:=[
,,,[22354900888,"JB"],];
CONWAYPOLDATA[57679]:=[
,,,[13120588207,"JB"],];
CONWAYPOLDATA[57689]:=[
,,,[3327328456,"JB"],];
CONWAYPOLDATA[57697]:=[
,,,[22869417592,"JB"],];
CONWAYPOLDATA[57709]:=[
,,,[22926862358,"JB"],];
CONWAYPOLDATA[57713]:=[
,,,[15618638341,"JB"],];
CONWAYPOLDATA[57719]:=[
,,,[25591796541,"JB"],];
CONWAYPOLDATA[57727]:=[
,,,[18595656240,"JB"],];
CONWAYPOLDATA[57731]:=[
,,,[6259425946,"JB"],];
CONWAYPOLDATA[57737]:=[
,,,[39784257223,"JB"],];
CONWAYPOLDATA[57751]:=[
,,,[13059695644,"JB"],];
CONWAYPOLDATA[57773]:=[
,,,[16688366556,"JB"],];
CONWAYPOLDATA[57781]:=[
,,,[66611496893,"JB"],];
CONWAYPOLDATA[57787]:=[
,,,[28521005000,"JB"],];
CONWAYPOLDATA[57791]:=[
,,,[29338179086,"JB"],];
CONWAYPOLDATA[57793]:=[
,,,[21735253789,"JB"],];
CONWAYPOLDATA[57803]:=[
,,,[28810171262,"JB"],];
CONWAYPOLDATA[57809]:=[
,,,[9415178406,"JB"],];
CONWAYPOLDATA[57829]:=[
,,,[12309770095,"JB"],];
CONWAYPOLDATA[57839]:=[
,,,[12775709687,"JB"],];
CONWAYPOLDATA[57847]:=[
,,,[22918634321,"JB"],];
CONWAYPOLDATA[57853]:=[
,,,[35967383664,"JB"],];
CONWAYPOLDATA[57859]:=[
,,,[28580205219,"JB"],];
CONWAYPOLDATA[57881]:=[
,,,[10019490508,"JB"],];
CONWAYPOLDATA[57899]:=[
,,,[28957142670,"JB"],];
CONWAYPOLDATA[57901]:=[
,,,[42732153923,"JB"],];
CONWAYPOLDATA[57917]:=[
,,,[5882745526,"JB"],];
CONWAYPOLDATA[57923]:=[
,,,[30195259902,"JB"],];
CONWAYPOLDATA[57943]:=[
,,,[19619499805,"JB"],];
CONWAYPOLDATA[57947]:=[
,,,[20035522937,"JB"],];
CONWAYPOLDATA[57973]:=[
,,,[26650477970,"JB"],];
CONWAYPOLDATA[57977]:=[
,,,[22037637473,"JB"],];
CONWAYPOLDATA[57991]:=[
,,,[12769966152,"JB"],];
CONWAYPOLDATA[58013]:=[
,,,[25568185518,"JB"],];
CONWAYPOLDATA[58027]:=[
,,,[30066980187,"JB"],];
CONWAYPOLDATA[58031]:=[
,,,[19548844946,"JB"],];
CONWAYPOLDATA[58043]:=[
,,,[16329063063,"JB"],];
CONWAYPOLDATA[58049]:=[
,,,[3368989816,"JB"],];
CONWAYPOLDATA[58057]:=[
,,,[48961558159,"JB"],];
CONWAYPOLDATA[58061]:=[
,,,[15712467823,"JB"],];
CONWAYPOLDATA[58067]:=[
,,,[30181020056,"JB"],];
CONWAYPOLDATA[58073]:=[
,,,[8999863180,"JB"],];
CONWAYPOLDATA[58099]:=[
,,,[8988961092,"JB"],];
CONWAYPOLDATA[58109]:=[
,,,[29845944582,"JB"],];
CONWAYPOLDATA[58111]:=[
,,,[18898336433,"JB"],];
CONWAYPOLDATA[58129]:=[
,,,[3376713623,"JB"],];
CONWAYPOLDATA[58147]:=[
,,,[12865140047,"JB"],];
CONWAYPOLDATA[58151]:=[
,,,[9140930150,"JB"],];
CONWAYPOLDATA[58153]:=[
,,,[2316350306,"JB"],];
CONWAYPOLDATA[58169]:=[
,,,[2523254888,"JB"],];
CONWAYPOLDATA[58171]:=[
,,,[30065215984,"JB"],];
CONWAYPOLDATA[58189]:=[
,,,[29932363417,"JB"],];
CONWAYPOLDATA[58193]:=[
,,,[6665018872,"JB"],];
CONWAYPOLDATA[58199]:=[
,,,[16046861083,"JB"],];
CONWAYPOLDATA[58207]:=[
,,,[8685299303,"JB"],];
CONWAYPOLDATA[58211]:=[
,,,[53384493148,"JB"],];
CONWAYPOLDATA[58217]:=[
,,,[6203894608,"JB"],];
CONWAYPOLDATA[58229]:=[
,,,[6361343565,"JB"],];
CONWAYPOLDATA[58231]:=[
,,,[13260712712,"JB"],];
CONWAYPOLDATA[58237]:=[
,,,[1859216240,"JB"],];
CONWAYPOLDATA[58243]:=[
,,,[10124147720,"JB"],];
CONWAYPOLDATA[58271]:=[
,,,[19170576301,"JB"],];
CONWAYPOLDATA[58309]:=[
,,,[44198746787,"JB"],];
CONWAYPOLDATA[58313]:=[
,,,[2059556850,"JB"],];
CONWAYPOLDATA[58321]:=[
,,,[85032367937,"JB"],];
CONWAYPOLDATA[58337]:=[
,,,[1727008551,"JB"],];
CONWAYPOLDATA[58363]:=[
,,,[29669589771,"JB"],];
CONWAYPOLDATA[58367]:=[
,,,[16159837829,"JB"],];
CONWAYPOLDATA[58369]:=[
,,,[1762043379,"JB"],];
CONWAYPOLDATA[58379]:=[
,,,[16991674984,"JB"],];
CONWAYPOLDATA[58391]:=[
,,,[13460118158,"JB"],];
CONWAYPOLDATA[58393]:=[
,,,[36703737657,"JB"],];
CONWAYPOLDATA[58403]:=[
,,,[25965448175,"JB"],];
CONWAYPOLDATA[58411]:=[
,,,[22316565073,"JB"],];
CONWAYPOLDATA[58417]:=[
,,,[51187545753,"JB"],];
CONWAYPOLDATA[58427]:=[
,,,[26681449103,"JB"],];
CONWAYPOLDATA[58439]:=[
,,,[25892275552,"JB"],];
CONWAYPOLDATA[58441]:=[
,,,[50190825602,"JB"],];
CONWAYPOLDATA[58451]:=[
,,,[40997180704,"JB"],];
CONWAYPOLDATA[58453]:=[
,,,[13398129038,"JB"],];
CONWAYPOLDATA[58477]:=[
,,,[12770792035,"JB"],];
CONWAYPOLDATA[58481]:=[
,,,[15405942241,"JB"],];
CONWAYPOLDATA[58511]:=[
,,,[22962173875,"JB"],];
CONWAYPOLDATA[58537]:=[
,,,[61072588699,"JB"],];
CONWAYPOLDATA[58543]:=[
,,,[16859564404,"JB"],];
CONWAYPOLDATA[58549]:=[
,,,[44532135206,"JB"],];
CONWAYPOLDATA[58567]:=[
,,,[26014700035,"JB"],];
CONWAYPOLDATA[58573]:=[
,,,[68383860356,"JB"],];
CONWAYPOLDATA[58579]:=[
,,,[8928845498,"JB"],];
CONWAYPOLDATA[58601]:=[
,,,[3433373992,"JB"],];
CONWAYPOLDATA[58603]:=[
,,,[9097236707,"JB"],];
CONWAYPOLDATA[58613]:=[
,,,[19361339227,"JB"],];
CONWAYPOLDATA[58631]:=[
,,,[20303387640,"JB"],];
CONWAYPOLDATA[58657]:=[
,,,[54169739505,"JB"],];
CONWAYPOLDATA[58661]:=[
,,,[23945713507,"JB"],];
CONWAYPOLDATA[58679]:=[
,,,[9446673542,"JB"],];
CONWAYPOLDATA[58687]:=[
,,,[37152274852,"JB"],];
CONWAYPOLDATA[58693]:=[
,,,[12421023513,"JB"],];
CONWAYPOLDATA[58699]:=[
,,,[26832897775,"JB"],];
CONWAYPOLDATA[58711]:=[
,,,[13284361843,"JB"],];
CONWAYPOLDATA[58727]:=[
,,,[13795207213,"JB"],];
CONWAYPOLDATA[58733]:=[
,,,[23751214071,"JB"],];
CONWAYPOLDATA[58741]:=[
,,,[23726194794,"JB"],];
CONWAYPOLDATA[58757]:=[
,,,[13736916546,"JB"],];
CONWAYPOLDATA[58763]:=[
,,,[15777160346,"JB"],];
CONWAYPOLDATA[58771]:=[
,,,[8755762362,"JB"],];
CONWAYPOLDATA[58787]:=[
,,,[48044557557,"JB"],];
CONWAYPOLDATA[58789]:=[
,,,[33657584337,"JB"],];
CONWAYPOLDATA[58831]:=[
,,,[9822011954,"JB"],];
CONWAYPOLDATA[58889]:=[
,,,[17154895704,"JB"],];
CONWAYPOLDATA[58897]:=[
,,,[54563653230,"JB"],];
CONWAYPOLDATA[58901]:=[
,,,[13054758741,"JB"],];
CONWAYPOLDATA[58907]:=[
,,,[26269046489,"JB"],];
CONWAYPOLDATA[58909]:=[
,,,[44567191589,"JB"],];
CONWAYPOLDATA[58913]:=[
,,,[26133924629,"JB"],];
CONWAYPOLDATA[58921]:=[
,,,[3469386335,"JB"],];
CONWAYPOLDATA[58937]:=[
,,,[40155487276,"JB"],];
CONWAYPOLDATA[58943]:=[
,,,[23479767226,"JB"],];
CONWAYPOLDATA[58963]:=[
,,,[23962268388,"JB"],];
CONWAYPOLDATA[58967]:=[
,,,[27734597752,"JB"],];
CONWAYPOLDATA[58979]:=[
,,,[26537483094,"JB"],];
CONWAYPOLDATA[58991]:=[
,,,[17399159493,"JB"],];
CONWAYPOLDATA[58997]:=[
,,,[51175944704,"JB"],];
CONWAYPOLDATA[59009]:=[
,,,[16392169122,"JB"],];
CONWAYPOLDATA[59011]:=[
,,,[30587171632,"JB"],];
CONWAYPOLDATA[59021]:=[
,,,[23505467378,"JB"],];
CONWAYPOLDATA[59023]:=[
,,,[66189631688,"JB"],];
CONWAYPOLDATA[59029]:=[
,,,[27466961079,"JB"],];
CONWAYPOLDATA[59051]:=[
,,,[24408435605,"JB"],];
CONWAYPOLDATA[59053]:=[
,,,[26916652680,"JB"],];
CONWAYPOLDATA[59063]:=[
,,,[13953515629,"JB"],];
CONWAYPOLDATA[59069]:=[
,,,[6304316234,"JB"],];
CONWAYPOLDATA[59077]:=[
,,,[5385223017,"JB"],];
CONWAYPOLDATA[59083]:=[
,,,[8817546922,"JB"],];
CONWAYPOLDATA[59093]:=[
,,,[50999209072,"JB"],];
CONWAYPOLDATA[59107]:=[
,,,[6168938485,"JB"],];
CONWAYPOLDATA[59113]:=[
,,,[72807472265,"JB"],];
CONWAYPOLDATA[59119]:=[
,,,[26958973431,"JB"],];
CONWAYPOLDATA[59123]:=[
,,,[13806048224,"JB"],];
CONWAYPOLDATA[59141]:=[
,,,[51326108263,"JB"],];
CONWAYPOLDATA[59149]:=[
,,,[13940591216,"JB"],];
CONWAYPOLDATA[59159]:=[
,,,[17498403981,"JB"],];
CONWAYPOLDATA[59167]:=[
,,,[17503432780,"JB"],];
CONWAYPOLDATA[59183]:=[
,,,[27310113721,"JB"],];
CONWAYPOLDATA[59197]:=[
,,,[12328189631,"JB"],];
CONWAYPOLDATA[59207]:=[
,,,[20188462072,"JB"],];
CONWAYPOLDATA[59209]:=[
,,,[36826044114,"JB"],];
CONWAYPOLDATA[59219]:=[
,,,[10074158625,"JB"],];
CONWAYPOLDATA[59221]:=[
,,,[23750463610,"JB"],];
CONWAYPOLDATA[59233]:=[
,,,[23372986407,"JB"],];
CONWAYPOLDATA[59239]:=[
,,,[23216652688,"JB"],];
CONWAYPOLDATA[59243]:=[
,,,[31281370376,"JB"],];
CONWAYPOLDATA[59263]:=[
,,,[20833374286,"JB"],];
CONWAYPOLDATA[59273]:=[
,,,[41054317266,"JB"],];
CONWAYPOLDATA[59281]:=[
,,,[3372081130,"JB"],];
CONWAYPOLDATA[59333]:=[
,,,[23995689194,"JB"],];
CONWAYPOLDATA[59341]:=[
,,,[27825410301,"JB"],];
CONWAYPOLDATA[59351]:=[
,,,[23416996414,"JB"],];
CONWAYPOLDATA[59357]:=[
,,,[27115108600,"JB"],];
CONWAYPOLDATA[59359]:=[
,,,[10507433391,"JB"],];
CONWAYPOLDATA[59369]:=[
,,,[17004231507,"JB"],];
CONWAYPOLDATA[59377]:=[
,,,[24574062110,"JB"],];
CONWAYPOLDATA[59387]:=[
,,,[26679372204,"JB"],];
CONWAYPOLDATA[59393]:=[
,,,[30138027567,"JB"],];
CONWAYPOLDATA[59399]:=[
,,,[9188193721,"JB"],];
CONWAYPOLDATA[59407]:=[
,,,[19429712830,"JB"],];
CONWAYPOLDATA[59417]:=[
,,,[16502418166,"JB"],];
CONWAYPOLDATA[59419]:=[
,,,[31775142118,"JB"],];
CONWAYPOLDATA[59441]:=[
,,,[16538388315,"JB"],];
CONWAYPOLDATA[59443]:=[
,,,[37401178944,"JB"],];
CONWAYPOLDATA[59447]:=[
,,,[31493296642,"JB"],];
CONWAYPOLDATA[59453]:=[
,,,[34888863445,"JB"],];
CONWAYPOLDATA[59467]:=[
,,,[30705131315,"JB"],];
CONWAYPOLDATA[59471]:=[
,,,[28097668671,"JB"],];
CONWAYPOLDATA[59473]:=[
,,,[23550832226,"JB"],];
CONWAYPOLDATA[59497]:=[
,,,[116207458020,"JB"],];
CONWAYPOLDATA[59509]:=[
,,,[10005843270,"JB"],];
CONWAYPOLDATA[59513]:=[
,,,[5980580399,"JB"],];
CONWAYPOLDATA[59539]:=[
,,,[10037441856,"JB"],];
CONWAYPOLDATA[59557]:=[
,,,[23759907810,"JB"],];
CONWAYPOLDATA[59561]:=[
,,,[27190728162,"JB"],];
CONWAYPOLDATA[59567]:=[
,,,[9777863488,"JB"],];
CONWAYPOLDATA[59581]:=[
,,,[27483285362,"JB"],];
CONWAYPOLDATA[59611]:=[
,,,[27205387404,"JB"],];
CONWAYPOLDATA[59617]:=[
,,,[38818715302,"JB"],];
CONWAYPOLDATA[59621]:=[
,,,[17562856078,"JB"],];
CONWAYPOLDATA[59627]:=[
,,,[28309587808,"JB"],];
CONWAYPOLDATA[59629]:=[
,,,[24810911354,"JB"],];
CONWAYPOLDATA[59651]:=[
,,,[6395064410,"JB"],];
CONWAYPOLDATA[59659]:=[
,,,[21018760588,"JB"],];
CONWAYPOLDATA[59663]:=[
,,,[38171552123,"JB"],];
CONWAYPOLDATA[59669]:=[
,,,[44729374127,"JB"],];
CONWAYPOLDATA[59671]:=[
,,,[12955588519,"JB"],];
CONWAYPOLDATA[59693]:=[
,,,[9207824331,"JB"],];
CONWAYPOLDATA[59699]:=[
,,,[8977953515,"JB"],];
CONWAYPOLDATA[59707]:=[
,,,[20618797434,"JB"],];
CONWAYPOLDATA[59723]:=[
,,,[6816245715,"JB"],];
CONWAYPOLDATA[59729]:=[
,,,[10531178367,"JB"],];
CONWAYPOLDATA[59743]:=[
,,,[20256401840,"JB"],];
CONWAYPOLDATA[59747]:=[
,,,[10207655458,"JB"],];
CONWAYPOLDATA[59753]:=[
,,,[21277923799,"JB"],];
CONWAYPOLDATA[59771]:=[
,,,[32152733574,"JB"],];
CONWAYPOLDATA[59779]:=[
,,,[21402496043,"JB"],];
CONWAYPOLDATA[59791]:=[
,,,[12885618204,"JB"],];
CONWAYPOLDATA[59797]:=[
,,,[27441979445,"JB"],];
CONWAYPOLDATA[59809]:=[
,,,[109832410291,"JB"],];
CONWAYPOLDATA[59833]:=[
,,,[42171973729,"JB"],];
CONWAYPOLDATA[59863]:=[
,,,[59318186842,"JB"],];
CONWAYPOLDATA[59879]:=[
,,,[9887280373,"JB"],];
CONWAYPOLDATA[59887]:=[
,,,[14224959113,"JB"],];
CONWAYPOLDATA[59921]:=[
,,,[6886960217,"JB"],];
CONWAYPOLDATA[59929]:=[
,,,[82106205901,"JB"],];
CONWAYPOLDATA[59951]:=[
,,,[25009159171,"JB"],];
CONWAYPOLDATA[59957]:=[
,,,[20918757474,"JB"],];
CONWAYPOLDATA[59971]:=[
,,,[28719212338,"JB"],];
CONWAYPOLDATA[59981]:=[
,,,[46022041739,"JB"],];
CONWAYPOLDATA[59999]:=[
,,,[14291521811,"JB"],];
CONWAYPOLDATA[60013]:=[
,,,[17539879490,"JB"],];
CONWAYPOLDATA[60017]:=[
,,,[5494016200,"JB"],];
CONWAYPOLDATA[60029]:=[
,,,[28340051076,"JB"],];
CONWAYPOLDATA[60037]:=[
,,,[13126669793,"JB"],];
CONWAYPOLDATA[60041]:=[
,,,[10316724951,"JB"],];
CONWAYPOLDATA[60077]:=[
,,,[13195252205,"JB"],];
CONWAYPOLDATA[60083]:=[
,,,[2821257350,"JB"],];
CONWAYPOLDATA[60089]:=[
,,,[17028801980,"JB"],];
CONWAYPOLDATA[60091]:=[
,,,[24268892081,"JB"],];
CONWAYPOLDATA[60101]:=[
,,,[18060410604,"JB"],];
CONWAYPOLDATA[60103]:=[
,,,[43347726077,"JB"],];
CONWAYPOLDATA[60107]:=[
,,,[17929196818,"JB"],];
CONWAYPOLDATA[60127]:=[
,,,[24443188805,"JB"],];
CONWAYPOLDATA[60133]:=[
,,,[28656321023,"JB"],];
CONWAYPOLDATA[60139]:=[
,,,[23986380014,"JB"],];
CONWAYPOLDATA[60149]:=[
,,,[32560698768,"JB"],];
CONWAYPOLDATA[60161]:=[
,,,[3618623992,"JB"],];
CONWAYPOLDATA[60167]:=[
,,,[9896268165,"JB"],];
CONWAYPOLDATA[60169]:=[
,,,[53167795340,"JB"],];
CONWAYPOLDATA[60209]:=[
,,,[16900907139,"JB"],];
CONWAYPOLDATA[60217]:=[
,,,[45693803728,"JB"],];
CONWAYPOLDATA[60223]:=[
,,,[39894425238,"JB"],];
CONWAYPOLDATA[60251]:=[
,,,[10616647963,"JB"],];
CONWAYPOLDATA[60257]:=[
,,,[28954874414,"JB"],];
CONWAYPOLDATA[60259]:=[
,,,[23706794488,"JB"],];
CONWAYPOLDATA[60271]:=[
,,,[38542219625,"JB"],];
CONWAYPOLDATA[60289]:=[
,,,[61542830340,"JB"],];
CONWAYPOLDATA[60293]:=[
,,,[3351627579,"JB"],];
CONWAYPOLDATA[60317]:=[
,,,[16730307243,"JB"],];
CONWAYPOLDATA[60331]:=[
,,,[20051369848,"JB"],];
CONWAYPOLDATA[60337]:=[
,,,[46898924376,"JB"],];
CONWAYPOLDATA[60343]:=[
,,,[20660055314,"JB"],];
CONWAYPOLDATA[60353]:=[
,,,[17205071125,"JB"],];
CONWAYPOLDATA[60373]:=[
,,,[24958258575,"JB"],];
CONWAYPOLDATA[60383]:=[
,,,[25284415127,"JB"],];
CONWAYPOLDATA[60397]:=[
,,,[27728443896,"JB"],];
CONWAYPOLDATA[60413]:=[
,,,[71883616312,"JB"],];
CONWAYPOLDATA[60427]:=[
,,,[20319908147,"JB"],];
CONWAYPOLDATA[60443]:=[
,,,[16565975670,"JB"],];
CONWAYPOLDATA[60449]:=[
,,,[10033143676,"JB"],];
CONWAYPOLDATA[60457]:=[
,,,[42881061887,"JB"],];
CONWAYPOLDATA[60493]:=[
,,,[25582550195,"JB"],];
CONWAYPOLDATA[60497]:=[
,,,[25324225694,"JB"],];
CONWAYPOLDATA[60509]:=[
,,,[24628131146,"JB"],];
CONWAYPOLDATA[60521]:=[
,,,[17657667484,"JB"],];
CONWAYPOLDATA[60527]:=[
,,,[18022761633,"JB"],];
CONWAYPOLDATA[60539]:=[
,,,[29159335820,"JB"],];
CONWAYPOLDATA[60589]:=[
,,,[10103821642,"JB"],];
CONWAYPOLDATA[60601]:=[
,,,[62337824671,"JB"],];
CONWAYPOLDATA[60607]:=[
,,,[21198389179,"JB"],];
CONWAYPOLDATA[60611]:=[
,,,[17456513509,"JB"],];
CONWAYPOLDATA[60617]:=[
,,,[2270591589,"JB"],];
CONWAYPOLDATA[60623]:=[
,,,[9668944144,"JB"],];
CONWAYPOLDATA[60631]:=[
,,,[16994808675,"JB"],];
CONWAYPOLDATA[60637]:=[
,,,[35670806718,"JB"],];
CONWAYPOLDATA[60647]:=[
,,,[35011209870,"JB"],];
CONWAYPOLDATA[60649]:=[
,,,[91759935594,"JB"],];
CONWAYPOLDATA[60659]:=[
,,,[31704396896,"JB"],];
CONWAYPOLDATA[60661]:=[
,,,[13998314345,"JB"],];
CONWAYPOLDATA[60679]:=[
,,,[13218252684,"JB"],];
CONWAYPOLDATA[60689]:=[
,,,[28747286901,"JB"],];
CONWAYPOLDATA[60703]:=[
,,,[65217907034,"JB"],];
CONWAYPOLDATA[60719]:=[
,,,[25740666396,"JB"],];
CONWAYPOLDATA[60727]:=[
,,,[46779404826,"JB"],];
CONWAYPOLDATA[60733]:=[
,,,[39396768306,"JB"],];
CONWAYPOLDATA[60737]:=[
,,,[25123191946,"JB"],];
CONWAYPOLDATA[60757]:=[
,,,[35491809122,"JB"],];
CONWAYPOLDATA[60761]:=[
,,,[2116062592,"JB"],];
CONWAYPOLDATA[60763]:=[
,,,[21422907098,"JB"],];
CONWAYPOLDATA[60773]:=[
,,,[6972607838,"JB"],];
CONWAYPOLDATA[60779]:=[
,,,[17405403790,"JB"],];
CONWAYPOLDATA[60793]:=[
,,,[24735091087,"JB"],];
CONWAYPOLDATA[60811]:=[
,,,[32571587822,"JB"],];
CONWAYPOLDATA[60821]:=[
,,,[14631099762,"JB"],];
CONWAYPOLDATA[60859]:=[
,,,[13112558425,"JB"],];
CONWAYPOLDATA[60869]:=[
,,,[28561013051,"JB"],];
CONWAYPOLDATA[60887]:=[
,,,[39600417711,"JB"],];
CONWAYPOLDATA[60889]:=[
,,,[31540623799,"JB"],];
CONWAYPOLDATA[60899]:=[
,,,[6203598435,"JB"],];
CONWAYPOLDATA[60901]:=[
,,,[25877504813,"JB"],];
CONWAYPOLDATA[60913]:=[
,,,[24532893494,"JB"],];
CONWAYPOLDATA[60917]:=[
,,,[14589256000,"JB"],];
CONWAYPOLDATA[60919]:=[
,,,[25569958306,"JB"],];
CONWAYPOLDATA[60923]:=[
,,,[13825012700,"JB"],];
CONWAYPOLDATA[60937]:=[
,,,[81098859578,"JB"],];
CONWAYPOLDATA[60943]:=[
,,,[9338844382,"JB"],];
CONWAYPOLDATA[60953]:=[
,,,[17193927008,"JB"],];
CONWAYPOLDATA[60961]:=[
,,,[2813533040,"JB"],];
CONWAYPOLDATA[61001]:=[
,,,[29422124325,"JB"],];
CONWAYPOLDATA[61007]:=[
,,,[55137943584,"JB"],];
CONWAYPOLDATA[61027]:=[
,,,[32297319212,"JB"],];
CONWAYPOLDATA[61031]:=[
,,,[32837729572,"JB"],];
CONWAYPOLDATA[61043]:=[
,,,[77081804080,"JB"],];
CONWAYPOLDATA[61051]:=[
,,,[6981975516,"JB"],];
CONWAYPOLDATA[61057]:=[
,,,[24286642895,"JB"],];
CONWAYPOLDATA[61091]:=[
,,,[28817418885,"JB"],];
CONWAYPOLDATA[61099]:=[
,,,[24505648021,"JB"],];
CONWAYPOLDATA[61121]:=[
,,,[10475589314,"JB"],];
CONWAYPOLDATA[61129]:=[
,,,[10300297636,"JB"],];
CONWAYPOLDATA[61141]:=[
,,,[29426979883,"JB"],];
CONWAYPOLDATA[61151]:=[
,,,[11145809348,"JB"],];
CONWAYPOLDATA[61153]:=[
,,,[32229098682,"JB"],];
CONWAYPOLDATA[61169]:=[
,,,[3740912536,"JB"],];
CONWAYPOLDATA[61211]:=[
,,,[10546532880,"JB"],];
CONWAYPOLDATA[61223]:=[
,,,[20868777900,"JB"],];
CONWAYPOLDATA[61231]:=[
,,,[2450525858,"JB"],];
CONWAYPOLDATA[61253]:=[
,,,[85217623722,"JB"],];
CONWAYPOLDATA[61261]:=[
,,,[40070513797,"JB"],];
CONWAYPOLDATA[61283]:=[
,,,[40195397136,"JB"],];
CONWAYPOLDATA[61291]:=[
,,,[11067315873,"JB"],];
CONWAYPOLDATA[61297]:=[
,,,[32323930908,"JB"],];
CONWAYPOLDATA[61331]:=[
,,,[33445020922,"JB"],];
CONWAYPOLDATA[61333]:=[
,,,[13399052514,"JB"],];
CONWAYPOLDATA[61339]:=[
,,,[24659750138,"JB"],];
CONWAYPOLDATA[61343]:=[
,,,[32527003069,"JB"],];
CONWAYPOLDATA[61357]:=[
,,,[39682087543,"JB"],];
CONWAYPOLDATA[61363]:=[
,,,[9606868557,"JB"],];
CONWAYPOLDATA[61379]:=[
,,,[18802904241,"JB"],];
CONWAYPOLDATA[61381]:=[
,,,[28851893532,"JB"],];
CONWAYPOLDATA[61403]:=[
,,,[40306280068,"JB"],];
CONWAYPOLDATA[61409]:=[
,,,[29747072284,"JB"],];
CONWAYPOLDATA[61417]:=[
,,,[55421349631,"JB"],];
CONWAYPOLDATA[61441]:=[
,,,[47444678776,"JB"],];
CONWAYPOLDATA[61463]:=[
,,,[56408713126,"JB"],];
CONWAYPOLDATA[61469]:=[
,,,[78993381619,"JB"],];
CONWAYPOLDATA[61471]:=[
,,,[25875664214,"JB"],];
CONWAYPOLDATA[61483]:=[
,,,[10035255262,"JB"],];
CONWAYPOLDATA[61487]:=[
,,,[15122358733,"JB"],];
CONWAYPOLDATA[61493]:=[
,,,[81316928863,"JB"],];
CONWAYPOLDATA[61507]:=[
,,,[10374262678,"JB"],];
CONWAYPOLDATA[61511]:=[
,,,[14992937191,"JB"],];
CONWAYPOLDATA[61519]:=[
,,,[10196220582,"JB"],];
CONWAYPOLDATA[61543]:=[
,,,[14169352608,"JB"],];
CONWAYPOLDATA[61547]:=[
,,,[28794333123,"JB"],];
CONWAYPOLDATA[61553]:=[
,,,[1911466865,"JB"],];
CONWAYPOLDATA[61559]:=[
,,,[18559053563,"JB"],];
CONWAYPOLDATA[61561]:=[
,,,[2338948641,"JB"],];
CONWAYPOLDATA[61583]:=[
,,,[25339372266,"JB"],];
CONWAYPOLDATA[61603]:=[
,,,[10726437568,"JB"],];
CONWAYPOLDATA[61609]:=[
,,,[101570260856,"JB"],];
CONWAYPOLDATA[61613]:=[
,,,[14520643777,"JB"],];
CONWAYPOLDATA[61627]:=[
,,,[14436309634,"JB"],];
CONWAYPOLDATA[61631]:=[
,,,[10706968748,"JB"],];
CONWAYPOLDATA[61637]:=[
,,,[2740257748,"JB"],];
CONWAYPOLDATA[61643]:=[
,,,[32971299627,"JB"],];
CONWAYPOLDATA[61651]:=[
,,,[33157387426,"JB"],];
CONWAYPOLDATA[61657]:=[
,,,[26409727786,"JB"],];
CONWAYPOLDATA[61667]:=[
,,,[32774283826,"JB"],];
CONWAYPOLDATA[61673]:=[
,,,[2935943170,"JB"],];
CONWAYPOLDATA[61681]:=[
,,,[140616519607,"JB"],];
CONWAYPOLDATA[61687]:=[
,,,[21823195057,"JB"],];
CONWAYPOLDATA[61703]:=[
,,,[17805449606,"JB"],];
CONWAYPOLDATA[61717]:=[
,,,[14955325159,"JB"],];
CONWAYPOLDATA[61723]:=[
,,,[15238668029,"JB"],];
CONWAYPOLDATA[61729]:=[
,,,[2365146642,"JB"],];
CONWAYPOLDATA[61751]:=[
,,,[25189591429,"JB"],];
CONWAYPOLDATA[61757]:=[
,,,[18444530893,"JB"],];
CONWAYPOLDATA[61781]:=[
,,,[68054180961,"JB"],];
CONWAYPOLDATA[61813]:=[
,,,[25890684117,"JB"],];
CONWAYPOLDATA[61819]:=[
,,,[2441850503,"JB"],];
CONWAYPOLDATA[61837]:=[
,,,[3468808358,"JB"],];
CONWAYPOLDATA[61843]:=[
,,,[34420576942,"JB"],];
CONWAYPOLDATA[61861]:=[
,,,[48591877363,"JB"],];
CONWAYPOLDATA[61871]:=[
,,,[26666462890,"JB"],];
CONWAYPOLDATA[61879]:=[
,,,[13438448070,"JB"],];
CONWAYPOLDATA[61909]:=[
,,,[10474074171,"JB"],];
CONWAYPOLDATA[61927]:=[
,,,[21698911168,"JB"],];
CONWAYPOLDATA[61933]:=[
,,,[15320985545,"JB"],];
CONWAYPOLDATA[61949]:=[
,,,[14816590128,"JB"],];
CONWAYPOLDATA[61961]:=[
,,,[3838421992,"JB"],];
CONWAYPOLDATA[61967]:=[
,,,[11433841010,"JB"],];
CONWAYPOLDATA[61979]:=[
,,,[18088757089,"JB"],];
CONWAYPOLDATA[61981]:=[
,,,[18023764902,"JB"],];
CONWAYPOLDATA[61987]:=[
,,,[56632438968,"JB"],];
CONWAYPOLDATA[61991]:=[
,,,[29933532192,"JB"],];
CONWAYPOLDATA[62003]:=[
,,,[34537593095,"JB"],];
CONWAYPOLDATA[62011]:=[
,,,[25218509460,"JB"],];
CONWAYPOLDATA[62017]:=[
,,,[26395613533,"JB"],];
CONWAYPOLDATA[62039]:=[
,,,[19080652818,"JB"],];
CONWAYPOLDATA[62047]:=[
,,,[22922085260,"JB"],];
CONWAYPOLDATA[62053]:=[
,,,[30153538398,"JB"],];
CONWAYPOLDATA[62057]:=[
,,,[7070960754,"JB"],];
CONWAYPOLDATA[62071]:=[
,,,[13949215837,"JB"],];
CONWAYPOLDATA[62081]:=[
,,,[2878944300,"JB"],];
CONWAYPOLDATA[62099]:=[
,,,[29754735852,"JB"],];
CONWAYPOLDATA[62119]:=[
,,,[22538574658,"JB"],];
CONWAYPOLDATA[62129]:=[
,,,[10300677558,"JB"],];
CONWAYPOLDATA[62131]:=[
,,,[7030184783,"JB"],];
CONWAYPOLDATA[62137]:=[
,,,[57028158004,"JB"],];
CONWAYPOLDATA[62141]:=[
,,,[26021854457,"JB"],];
CONWAYPOLDATA[62143]:=[
,,,[14232052006,"JB"],];
CONWAYPOLDATA[62171]:=[
,,,[2826728859,"JB"],];
CONWAYPOLDATA[62189]:=[
,,,[26091457141,"JB"],];
CONWAYPOLDATA[62191]:=[
,,,[9988185558,"JB"],];
CONWAYPOLDATA[62201]:=[
,,,[3868217992,"JB"],];
CONWAYPOLDATA[62207]:=[
,,,[38501467480,"JB"],];
CONWAYPOLDATA[62213]:=[
,,,[48551585119,"JB"],];
CONWAYPOLDATA[62219]:=[
,,,[11575596076,"JB"],];
CONWAYPOLDATA[62233]:=[
,,,[41360798603,"JB"],];
CONWAYPOLDATA[62273]:=[
,,,[17689019291,"JB"],];
CONWAYPOLDATA[62297]:=[
,,,[6538693123,"JB"],];
CONWAYPOLDATA[62299]:=[
,,,[68476880337,"JB"],];
CONWAYPOLDATA[62303]:=[
,,,[11125945139,"JB"],];
CONWAYPOLDATA[62311]:=[
,,,[18972266353,"JB"],];
CONWAYPOLDATA[62323]:=[
,,,[33966159648,"JB"],];
CONWAYPOLDATA[62327]:=[
,,,[25905033342,"JB"],];
CONWAYPOLDATA[62347]:=[
,,,[10599301738,"JB"],];
CONWAYPOLDATA[62351]:=[
,,,[14834238172,"JB"],];
CONWAYPOLDATA[62383]:=[
,,,[15566305229,"JB"],];
CONWAYPOLDATA[62401]:=[
,,,[68311061128,"JB"],];
CONWAYPOLDATA[62417]:=[
,,,[38550986215,"JB"],];
CONWAYPOLDATA[62423]:=[
,,,[10761038552,"JB"],];
CONWAYPOLDATA[62459]:=[
,,,[9879389872,"JB"],];
CONWAYPOLDATA[62467]:=[
,,,[46409795186,"JB"],];
CONWAYPOLDATA[62473]:=[
,,,[60974397681,"JB"],];
CONWAYPOLDATA[62477]:=[
,,,[45287952900,"JB"],];
CONWAYPOLDATA[62483]:=[
,,,[33870284778,"JB"],];
CONWAYPOLDATA[62497]:=[
,,,[50487014017,"JB"],];
CONWAYPOLDATA[62501]:=[
,,,[14578483254,"JB"],];
CONWAYPOLDATA[62507]:=[
,,,[29977919653,"JB"],];
CONWAYPOLDATA[62533]:=[
,,,[26564768798,"JB"],];
CONWAYPOLDATA[62539]:=[
,,,[33258115124,"JB"],];
CONWAYPOLDATA[62549]:=[
,,,[26259884123,"JB"],];
CONWAYPOLDATA[62563]:=[
,,,[10117187859,"JB"],];
CONWAYPOLDATA[62581]:=[
,,,[42899650988,"JB"],];
CONWAYPOLDATA[62591]:=[
,,,[14736612820,"JB"],];
CONWAYPOLDATA[62597]:=[
,,,[14518622988,"JB"],];
CONWAYPOLDATA[62603]:=[
,,,[33799171893,"JB"],];
CONWAYPOLDATA[62617]:=[
,,,[26927251132,"JB"],];
CONWAYPOLDATA[62627]:=[
,,,[11728033038,"JB"],];
CONWAYPOLDATA[62633]:=[
,,,[17926879896,"JB"],];
CONWAYPOLDATA[62639]:=[
,,,[22103236024,"JB"],];
CONWAYPOLDATA[62653]:=[
,,,[15480365895,"JB"],];
CONWAYPOLDATA[62659]:=[
,,,[21640225538,"JB"],];
CONWAYPOLDATA[62683]:=[
,,,[11752372990,"JB"],];
CONWAYPOLDATA[62687]:=[
,,,[58520257802,"JB"],];
CONWAYPOLDATA[62701]:=[
,,,[26050008266,"JB"],];
CONWAYPOLDATA[62723]:=[
,,,[11604444955,"JB"],];
CONWAYPOLDATA[62731]:=[
,,,[21994366844,"JB"],];
CONWAYPOLDATA[62743]:=[
,,,[6055577909,"JB"],];
CONWAYPOLDATA[62753]:=[
,,,[38462631516,"JB"],];
CONWAYPOLDATA[62761]:=[
,,,[2644874069,"JB"],];
CONWAYPOLDATA[62773]:=[
,,,[94437333303,"JB"],];
CONWAYPOLDATA[62791]:=[
,,,[13820299103,"JB"],];
CONWAYPOLDATA[62801]:=[
,,,[11471293464,"JB"],];
CONWAYPOLDATA[62819]:=[
,,,[30179629620,"JB"],];
CONWAYPOLDATA[62827]:=[
,,,[11164357903,"JB"],];
CONWAYPOLDATA[62851]:=[
,,,[35551793854,"JB"],];
CONWAYPOLDATA[62861]:=[
,,,[15054455171,"JB"],];
CONWAYPOLDATA[62869]:=[
,,,[25936165869,"JB"],];
CONWAYPOLDATA[62873]:=[
,,,[46297476648,"JB"],];
CONWAYPOLDATA[62897]:=[
,,,[31137851720,"JB"],];
CONWAYPOLDATA[62903]:=[
,,,[37754758023,"JB"],];
CONWAYPOLDATA[62921]:=[
,,,[35579119911,"JB"],];
CONWAYPOLDATA[62927]:=[
,,,[10317385071,"JB"],];
CONWAYPOLDATA[62929]:=[
,,,[97977684138,"JB"],];
CONWAYPOLDATA[62939]:=[
,,,[18560585224,"JB"],];
CONWAYPOLDATA[62969]:=[
,,,[3964339336,"JB"],];
CONWAYPOLDATA[62971]:=[
,,,[11252413942,"JB"],];
CONWAYPOLDATA[62981]:=[
,,,[31328953737,"JB"],];
CONWAYPOLDATA[62983]:=[
,,,[15867181229,"JB"],];
CONWAYPOLDATA[62987]:=[
,,,[34518765612,"JB"],];
CONWAYPOLDATA[62989]:=[
,,,[42376983554,"JB"],];
CONWAYPOLDATA[63029]:=[
,,,[26251326386,"JB"],];
CONWAYPOLDATA[63031]:=[
,,,[15186058833,"JB"],];
CONWAYPOLDATA[63059]:=[
,,,[2691547299,"JB"],];
CONWAYPOLDATA[63067]:=[
,,,[34676759282,"JB"],];
CONWAYPOLDATA[63073]:=[
,,,[26764586044,"JB"],];
CONWAYPOLDATA[63079]:=[
,,,[30554899892,"JB"],];
CONWAYPOLDATA[63097]:=[
,,,[42559936057,"JB"],];
CONWAYPOLDATA[63103]:=[
,,,[11687432839,"JB"],];
CONWAYPOLDATA[63113]:=[
,,,[6410324300,"JB"],];
CONWAYPOLDATA[63127]:=[
,,,[27139117954,"JB"],];
CONWAYPOLDATA[63131]:=[
,,,[18587281546,"JB"],];
CONWAYPOLDATA[63149]:=[
,,,[2316494769,"JB"],];
CONWAYPOLDATA[63179]:=[
,,,[34430849169,"JB"],];
CONWAYPOLDATA[63197]:=[
,,,[18182092887,"JB"],];
CONWAYPOLDATA[63199]:=[
,,,[30806668548,"JB"],];
CONWAYPOLDATA[63211]:=[
,,,[26385029939,"JB"],];
CONWAYPOLDATA[63241]:=[
,,,[3256532061,"JB"],];
CONWAYPOLDATA[63247]:=[
,,,[23773914835,"JB"],];
CONWAYPOLDATA[63277]:=[
,,,[26290897455,"JB"],];
CONWAYPOLDATA[63281]:=[
,,,[2750128985,"JB"],];
CONWAYPOLDATA[63299]:=[
,,,[11847294038,"JB"],];
CONWAYPOLDATA[63311]:=[
,,,[15278843647,"JB"],];
CONWAYPOLDATA[63313]:=[
,,,[42296882785,"JB"],];
CONWAYPOLDATA[63317]:=[
,,,[31712889305,"JB"],];
CONWAYPOLDATA[63331]:=[
,,,[35920583230,"JB"],];
CONWAYPOLDATA[63337]:=[
,,,[66597778776,"JB"],];
CONWAYPOLDATA[63347]:=[
,,,[35514988776,"JB"],];
CONWAYPOLDATA[63353]:=[
,,,[7982097885,"JB"],];
CONWAYPOLDATA[63361]:=[
,,,[147496424551,"JB"],];
CONWAYPOLDATA[63367]:=[
,,,[10196954276,"JB"],];
CONWAYPOLDATA[63377]:=[
,,,[3341235443,"JB"],];
CONWAYPOLDATA[63389]:=[
,,,[51268389312,"JB"],];
CONWAYPOLDATA[63391]:=[
,,,[27466242656,"JB"],];
CONWAYPOLDATA[63397]:=[
,,,[27636337227,"JB"],];
CONWAYPOLDATA[63409]:=[
,,,[3963125916,"JB"],];
CONWAYPOLDATA[63419]:=[
,,,[19069776207,"JB"],];
CONWAYPOLDATA[63421]:=[
,,,[26738039918,"JB"],];
CONWAYPOLDATA[63439]:=[
,,,[11960535307,"JB"],];
CONWAYPOLDATA[63443]:=[
,,,[31386076861,"JB"],];
CONWAYPOLDATA[63463]:=[
,,,[15845568771,"JB"],];
CONWAYPOLDATA[63467]:=[
,,,[19323607091,"JB"],];
CONWAYPOLDATA[63473]:=[
,,,[2700966572,"JB"],];
CONWAYPOLDATA[63487]:=[
,,,[23016830931,"JB"],];
CONWAYPOLDATA[63493]:=[
,,,[26236831434,"JB"],];
CONWAYPOLDATA[63499]:=[
,,,[11431407478,"JB"],];
CONWAYPOLDATA[63521]:=[
,,,[18944566564,"JB"],];
CONWAYPOLDATA[63527]:=[
,,,[11826948649,"JB"],];
CONWAYPOLDATA[63533]:=[
,,,[31168273275,"JB"],];
CONWAYPOLDATA[63541]:=[
,,,[26719498830,"JB"],];
CONWAYPOLDATA[63559]:=[
,,,[27735304392,"JB"],];
CONWAYPOLDATA[63577]:=[
,,,[27610918912,"JB"],];
CONWAYPOLDATA[63587]:=[
,,,[47687897283,"JB"],];
CONWAYPOLDATA[63589]:=[
,,,[51337116605,"JB"],];
CONWAYPOLDATA[63599]:=[
,,,[15269483917,"JB"],];
CONWAYPOLDATA[63601]:=[
,,,[68743776867,"JB"],];
CONWAYPOLDATA[63607]:=[
,,,[20228997820,"JB"],];
CONWAYPOLDATA[63611]:=[
,,,[14176156629,"JB"],];
CONWAYPOLDATA[63617]:=[
,,,[2728342282,"JB"],];
CONWAYPOLDATA[63629]:=[
,,,[39899837032,"JB"],];
CONWAYPOLDATA[63647]:=[
,,,[30883115580,"JB"],];
CONWAYPOLDATA[63649]:=[
,,,[71967860658,"JB"],];
CONWAYPOLDATA[63659]:=[
,,,[31229450268,"JB"],];
CONWAYPOLDATA[63667]:=[
,,,[44435109312,"JB"],];
CONWAYPOLDATA[63671]:=[
,,,[16119587081,"JB"],];
CONWAYPOLDATA[63689]:=[
,,,[4055524456,"JB"],];
CONWAYPOLDATA[63691]:=[
,,,[26546345124,"JB"],];
CONWAYPOLDATA[63697]:=[
,,,[60858916473,"JB"],];
CONWAYPOLDATA[63703]:=[
,,,[10940162114,"JB"],];
CONWAYPOLDATA[63709]:=[
,,,[112909995399,"JB"],];
CONWAYPOLDATA[63719]:=[
,,,[27527117765,"JB"],];
CONWAYPOLDATA[63727]:=[
,,,[40393677591,"JB"],];
CONWAYPOLDATA[63737]:=[
,,,[10977805935,"JB"],];
CONWAYPOLDATA[63743]:=[
,,,[27203727601,"JB"],];
CONWAYPOLDATA[63761]:=[
,,,[4064699992,"JB"],];
CONWAYPOLDATA[63773]:=[
,,,[15487273052,"JB"],];
CONWAYPOLDATA[63781]:=[
,,,[27363388403,"JB"],];
CONWAYPOLDATA[63793]:=[
,,,[47727370885,"JB"],];
CONWAYPOLDATA[63799]:=[
,,,[14347693317,"JB"],];
CONWAYPOLDATA[63803]:=[
,,,[11055018206,"JB"],];
CONWAYPOLDATA[63809]:=[
,,,[10600908218,"JB"],];
CONWAYPOLDATA[63823]:=[
,,,[15075758479,"JB"],];
CONWAYPOLDATA[63839]:=[
,,,[19638280887,"JB"],];
CONWAYPOLDATA[63841]:=[
,,,[75418118480,"JB"],];
CONWAYPOLDATA[63853]:=[
,,,[28322764388,"JB"],];
CONWAYPOLDATA[63857]:=[
,,,[18973702699,"JB"],];
CONWAYPOLDATA[63863]:=[
,,,[27715137019,"JB"],];
CONWAYPOLDATA[63901]:=[
,,,[19044798443,"JB"],];
CONWAYPOLDATA[63907]:=[
,,,[43189948277,"JB"],];
CONWAYPOLDATA[63913]:=[
,,,[27752494612,"JB"],];
CONWAYPOLDATA[63929]:=[
,,,[19633043406,"JB"],];
CONWAYPOLDATA[63949]:=[
,,,[28508592100,"JB"],];
CONWAYPOLDATA[63977]:=[
,,,[7139513318,"JB"],];
CONWAYPOLDATA[63997]:=[
,,,[15428780744,"JB"],];
CONWAYPOLDATA[64007]:=[
,,,[36071016841,"JB"],];
CONWAYPOLDATA[64013]:=[
,,,[26937054480,"JB"],];
CONWAYPOLDATA[64019]:=[
,,,[32232926312,"JB"],];
CONWAYPOLDATA[64033]:=[
,,,[51902012188,"JB"],];
CONWAYPOLDATA[64037]:=[
,,,[39476889392,"JB"],];
CONWAYPOLDATA[64063]:=[
,,,[24144768136,"JB"],];
CONWAYPOLDATA[64067]:=[
,,,[55510147418,"JB"],];
CONWAYPOLDATA[64081]:=[
,,,[61052980518,"JB"],];
CONWAYPOLDATA[64091]:=[
,,,[18954080069,"JB"],];
CONWAYPOLDATA[64109]:=[
,,,[19147819686,"JB"],];
CONWAYPOLDATA[64123]:=[
,,,[11769520160,"JB"],];
CONWAYPOLDATA[64151]:=[
,,,[14796299865,"JB"],];
CONWAYPOLDATA[64153]:=[
,,,[64652687722,"JB"],];
CONWAYPOLDATA[64157]:=[
,,,[31273329652,"JB"],];
CONWAYPOLDATA[64171]:=[
,,,[27216589553,"JB"],];
CONWAYPOLDATA[64187]:=[
,,,[36654435661,"JB"],];
CONWAYPOLDATA[64189]:=[
,,,[32359664761,"JB"],];
CONWAYPOLDATA[64217]:=[
,,,[19462567278,"JB"],];
CONWAYPOLDATA[64223]:=[
,,,[16498118029,"JB"],];
CONWAYPOLDATA[64231]:=[
,,,[36127111348,"JB"],];
CONWAYPOLDATA[64237]:=[
,,,[16023148808,"JB"],];
CONWAYPOLDATA[64271]:=[
,,,[15371245180,"JB"],];
CONWAYPOLDATA[64279]:=[
,,,[12255177053,"JB"],];
CONWAYPOLDATA[64283]:=[
,,,[35138694877,"JB"],];
CONWAYPOLDATA[64301]:=[
,,,[6536582458,"JB"],];
CONWAYPOLDATA[64303]:=[
,,,[22763390612,"JB"],];
CONWAYPOLDATA[64319]:=[
,,,[31701098500,"JB"],];
CONWAYPOLDATA[64327]:=[
,,,[22819295656,"JB"],];
CONWAYPOLDATA[64333]:=[
,,,[28055042305,"JB"],];
CONWAYPOLDATA[64373]:=[
,,,[2738234303,"JB"],];
CONWAYPOLDATA[64381]:=[
,,,[53257765870,"JB"],];
CONWAYPOLDATA[64399]:=[
,,,[14948231484,"JB"],];
CONWAYPOLDATA[64403]:=[
,,,[3447428192,"JB"],];
CONWAYPOLDATA[64433]:=[
,,,[3604253157,"JB"],];
CONWAYPOLDATA[64439]:=[
,,,[20669389208,"JB"],];
CONWAYPOLDATA[64451]:=[
,,,[32577982521,"JB"],];
CONWAYPOLDATA[64453]:=[
,,,[27436159683,"JB"],];
CONWAYPOLDATA[64483]:=[
,,,[7419994329,"JB"],];
CONWAYPOLDATA[64489]:=[
,,,[61728419384,"JB"],];
CONWAYPOLDATA[64499]:=[
,,,[32370113132,"JB"],];
CONWAYPOLDATA[64513]:=[
,,,[28234501533,"JB"],];
CONWAYPOLDATA[64553]:=[
,,,[3873696427,"JB"],];
CONWAYPOLDATA[64567]:=[
,,,[24102861103,"JB"],];
CONWAYPOLDATA[64577]:=[
,,,[48213640242,"JB"],];
CONWAYPOLDATA[64579]:=[
,,,[16345461534,"JB"],];
CONWAYPOLDATA[64591]:=[
,,,[15999901204,"JB"],];
CONWAYPOLDATA[64601]:=[
,,,[4172513992,"JB"],];
CONWAYPOLDATA[64609]:=[
,,,[85933135876,"JB"],];
CONWAYPOLDATA[64613]:=[
,,,[15365165241,"JB"],];
CONWAYPOLDATA[64621]:=[
,,,[31908428144,"JB"],];
CONWAYPOLDATA[64627]:=[
,,,[45468390482,"JB"],];
CONWAYPOLDATA[64633]:=[
,,,[53867145828,"JB"],];
CONWAYPOLDATA[64661]:=[
,,,[28475346521,"JB"],];
CONWAYPOLDATA[64663]:=[
,,,[16274901150,"JB"],];
CONWAYPOLDATA[64667]:=[
,,,[37240690630,"JB"],];
CONWAYPOLDATA[64679]:=[
,,,[29019397589,"JB"],];
CONWAYPOLDATA[64693]:=[
,,,[16581204060,"JB"],];
CONWAYPOLDATA[64709]:=[
,,,[12033738606,"JB"],];
CONWAYPOLDATA[64717]:=[
,,,[44655312455,"JB"],];
CONWAYPOLDATA[64747]:=[
,,,[23306135884,"JB"],];
CONWAYPOLDATA[64763]:=[
,,,[69953236348,"JB"],];
CONWAYPOLDATA[64781]:=[
,,,[10898755442,"JB"],];
CONWAYPOLDATA[64783]:=[
,,,[12173697450,"JB"],];
CONWAYPOLDATA[64793]:=[
,,,[40468217564,"JB"],];
CONWAYPOLDATA[64811]:=[
,,,[12208512883,"JB"],];
CONWAYPOLDATA[64817]:=[
,,,[41653543164,"JB"],];
CONWAYPOLDATA[64849]:=[
,,,[61566538180,"JB"],];
CONWAYPOLDATA[64853]:=[
,,,[7967126199,"JB"],];
CONWAYPOLDATA[64871]:=[
,,,[15173975617,"JB"],];
CONWAYPOLDATA[64877]:=[
,,,[29184204806,"JB"],];
CONWAYPOLDATA[64879]:=[
,,,[15355172452,"JB"],];
CONWAYPOLDATA[64891]:=[
,,,[12588789119,"JB"],];
CONWAYPOLDATA[64901]:=[
,,,[28709995768,"JB"],];
CONWAYPOLDATA[64919]:=[
,,,[24597679269,"JB"],];
CONWAYPOLDATA[64921]:=[
,,,[2137199327,"JB"],];
CONWAYPOLDATA[64927]:=[
,,,[28896930039,"JB"],];
CONWAYPOLDATA[64937]:=[
,,,[3475298369,"JB"],];
CONWAYPOLDATA[64951]:=[
,,,[12098227920,"JB"],];
CONWAYPOLDATA[64969]:=[
,,,[62556051353,"JB"],];
CONWAYPOLDATA[64997]:=[
,,,[32981037730,"JB"],];
CONWAYPOLDATA[65003]:=[
,,,[2235323169,"JB"],];
CONWAYPOLDATA[65011]:=[
,,,[37537286391,"JB"],];
CONWAYPOLDATA[65027]:=[
,,,[20483635056,"JB"],];
CONWAYPOLDATA[65029]:=[
,,,[16381845566,"JB"],];
CONWAYPOLDATA[65033]:=[
,,,[3812364529,"JB"],];
CONWAYPOLDATA[65053]:=[
,,,[7945963743,"JB"],];
CONWAYPOLDATA[65063]:=[
,,,[45664661744,"JB"],];
CONWAYPOLDATA[65071]:=[
,,,[15321032024,"JB"],];
CONWAYPOLDATA[65089]:=[
,,,[97440055499,"JB"],];
CONWAYPOLDATA[65099]:=[
,,,[7744177042,"JB"],];
CONWAYPOLDATA[65101]:=[
,,,[46411414316,"JB"],];
CONWAYPOLDATA[65111]:=[
,,,[12313401661,"JB"],];
CONWAYPOLDATA[65119]:=[
,,,[32799528637,"JB"],];
CONWAYPOLDATA[65123]:=[
,,,[37553698936,"JB"],];
CONWAYPOLDATA[65129]:=[
,,,[15152848014,"JB"],];
CONWAYPOLDATA[65141]:=[
,,,[80582934616,"JB"],];
CONWAYPOLDATA[65147]:=[
,,,[45136447482,"JB"],];
CONWAYPOLDATA[65167]:=[
,,,[16986690893,"JB"],];
CONWAYPOLDATA[65171]:=[
,,,[32064066831,"JB"],];
CONWAYPOLDATA[65173]:=[
,,,[29267369458,"JB"],];
CONWAYPOLDATA[65179]:=[
,,,[36559161818,"JB"],];
CONWAYPOLDATA[65183]:=[
,,,[16995033229,"JB"],];
CONWAYPOLDATA[65203]:=[
,,,[46201867757,"JB"],];
CONWAYPOLDATA[65213]:=[
,,,[33984646331,"JB"],];
CONWAYPOLDATA[65239]:=[
,,,[28071885030,"JB"],];
CONWAYPOLDATA[65257]:=[
,,,[54312748535,"JB"],];
CONWAYPOLDATA[65267]:=[
,,,[38337574734,"JB"],];
CONWAYPOLDATA[65269]:=[
,,,[28770314126,"JB"],];
CONWAYPOLDATA[65287]:=[
,,,[23955628339,"JB"],];
CONWAYPOLDATA[65293]:=[
,,,[67948074554,"JB"],];
CONWAYPOLDATA[65309]:=[
,,,[15373542675,"JB"],];
CONWAYPOLDATA[65323]:=[
,,,[11871867345,"JB"],];
CONWAYPOLDATA[65327]:=[
,,,[41143859183,"JB"],];
CONWAYPOLDATA[65353]:=[
,,,[28328957033,"JB"],];
CONWAYPOLDATA[65357]:=[
,,,[16621004029,"JB"],];
CONWAYPOLDATA[65371]:=[
,,,[12363290377,"JB"],];
CONWAYPOLDATA[65381]:=[
,,,[47020903726,"JB"],];
CONWAYPOLDATA[65393]:=[
,,,[58228804495,"JB"],];
CONWAYPOLDATA[65407]:=[
,,,[27877967764,"JB"],];
CONWAYPOLDATA[65413]:=[
,,,[28491809589,"JB"],];
CONWAYPOLDATA[65419]:=[
,,,[32133812803,"JB"],];
CONWAYPOLDATA[65423]:=[
,,,[29336850819,"JB"],];
CONWAYPOLDATA[65437]:=[
,,,[70835814254,"JB"],];
CONWAYPOLDATA[65447]:=[
,,,[23687625397,"JB"],];
CONWAYPOLDATA[65449]:=[
,,,[51401942937,"JB"],];
CONWAYPOLDATA[65479]:=[
,,,[3848004400,"JB"],];
CONWAYPOLDATA[65497]:=[
,,,[62820006623,"JB"],];
CONWAYPOLDATA[65519]:=[
,,,[15597191075,"JB"],];
CONWAYPOLDATA[65521]:=[
,,,[88619838878,"JB"],];
CONWAYPOLDATA[65537]:=[
,,,[33213758381,"JB"],];
CONWAYPOLDATA[65539]:=[
,,,[29278761784,"JB"],];
CONWAYPOLDATA[65543]:=[
,,,[50188962368,"JB"],];
CONWAYPOLDATA[65551]:=[
,,,[30078273009,"JB"],];
CONWAYPOLDATA[65557]:=[
,,,[8260575347,"JB"],];
CONWAYPOLDATA[65563]:=[
,,,[3901588570,"JB"],];
CONWAYPOLDATA[65579]:=[
,,,[32720773210,"JB"],];
CONWAYPOLDATA[65581]:=[
,,,[16614224961,"JB"],];
CONWAYPOLDATA[65587]:=[
,,,[45619562548,"JB"],];
CONWAYPOLDATA[65599]:=[
,,,[16103767315,"JB"],];
CONWAYPOLDATA[65609]:=[
,,,[4303753576,"JB"],];
CONWAYPOLDATA[65617]:=[
,,,[50432504426,"JB"],];
CONWAYPOLDATA[65629]:=[
,,,[12846286091,"JB"],];
CONWAYPOLDATA[65633]:=[
,,,[42251112487,"JB"],];
CONWAYPOLDATA[65647]:=[
,,,[12222552345,"JB"],];
CONWAYPOLDATA[65651]:=[
,,,[12458262017,"JB"],];
CONWAYPOLDATA[65657]:=[
,,,[3598660173,"JB"],];
CONWAYPOLDATA[65677]:=[
,,,[16364672415,"JB"],];
CONWAYPOLDATA[65687]:=[
,,,[24139447009,"JB"],];
CONWAYPOLDATA[65699]:=[
,,,[16817038731,"JB"],];
CONWAYPOLDATA[65701]:=[
,,,[2348285148,"JB"],];
CONWAYPOLDATA[65707]:=[
,,,[12731979685,"JB"],];
CONWAYPOLDATA[65713]:=[
,,,[30057257636,"JB"],];
CONWAYPOLDATA[65717]:=[
,,,[33959194035,"JB"],];
CONWAYPOLDATA[65719]:=[
,,,[21594671932,"JB"],];
CONWAYPOLDATA[65729]:=[
,,,[19755376785,"JB"],];
CONWAYPOLDATA[65731]:=[
,,,[4072889963,"JB"],];
CONWAYPOLDATA[65761]:=[
,,,[73492783821,"JB"],];
CONWAYPOLDATA[65777]:=[
,,,[33654144283,"JB"],];
CONWAYPOLDATA[65789]:=[
,,,[20740903298,"JB"],];
CONWAYPOLDATA[65809]:=[
,,,[102020336452,"JB"],];
CONWAYPOLDATA[65827]:=[
,,,[2742747784,"JB"],];
CONWAYPOLDATA[65831]:=[
,,,[21556558474,"JB"],];
CONWAYPOLDATA[65837]:=[
,,,[81721822177,"JB"],];
CONWAYPOLDATA[65839]:=[
,,,[28522969100,"JB"],];
CONWAYPOLDATA[65843]:=[
,,,[2402216014,"JB"],];
CONWAYPOLDATA[65851]:=[
,,,[15934229877,"JB"],];
CONWAYPOLDATA[65867]:=[
,,,[34381651864,"JB"],];
CONWAYPOLDATA[65881]:=[
,,,[81206172350,"JB"],];
CONWAYPOLDATA[65899]:=[
,,,[16772613483,"JB"],];
CONWAYPOLDATA[65921]:=[
,,,[7921660652,"JB"],];
CONWAYPOLDATA[65927]:=[
,,,[52155640829,"JB"],];
CONWAYPOLDATA[65929]:=[
,,,[63832589665,"JB"],];
CONWAYPOLDATA[65951]:=[
,,,[34676508205,"JB"],];
CONWAYPOLDATA[65957]:=[
,,,[8461095876,"JB"],];
CONWAYPOLDATA[65963]:=[
,,,[32978399741,"JB"],];
CONWAYPOLDATA[65981]:=[
,,,[43302538530,"JB"],];
CONWAYPOLDATA[65983]:=[
,,,[16509870365,"JB"],];
CONWAYPOLDATA[65993]:=[
,,,[6825392021,"JB"],];
CONWAYPOLDATA[66029]:=[
,,,[7141828700,"JB"],];
CONWAYPOLDATA[66037]:=[
,,,[29300947087,"JB"],];
CONWAYPOLDATA[66041]:=[
,,,[12123278455,"JB"],];
CONWAYPOLDATA[66047]:=[
,,,[12019695394,"JB"],];
CONWAYPOLDATA[66067]:=[
,,,[11471675682,"JB"],];
CONWAYPOLDATA[66071]:=[
,,,[32762825005,"JB"],];
CONWAYPOLDATA[66083]:=[
,,,[20355810824,"JB"],];
CONWAYPOLDATA[66089]:=[
,,,[4366962856,"JB"],];
CONWAYPOLDATA[66103]:=[
,,,[17351244267,"JB"],];
CONWAYPOLDATA[66107]:=[
,,,[65106206129,"JB"],];
CONWAYPOLDATA[66109]:=[
,,,[46866124500,"JB"],];
CONWAYPOLDATA[66137]:=[
,,,[2435428891,"JB"],];
CONWAYPOLDATA[66161]:=[
,,,[19911152953,"JB"],];
CONWAYPOLDATA[66169]:=[
,,,[89856972662,"JB"],];
CONWAYPOLDATA[66173]:=[
,,,[20735177206,"JB"],];
CONWAYPOLDATA[66179]:=[
,,,[3060050783,"JB"],];
CONWAYPOLDATA[66191]:=[
,,,[15793768330,"JB"],];
CONWAYPOLDATA[66221]:=[
,,,[29187965288,"JB"],];
CONWAYPOLDATA[66239]:=[
,,,[33258800634,"JB"],];
CONWAYPOLDATA[66271]:=[
,,,[11030078972,"JB"],];
CONWAYPOLDATA[66293]:=[
,,,[6818102466,"JB"],];
CONWAYPOLDATA[66301]:=[
,,,[57144102611,"JB"],];
CONWAYPOLDATA[66337]:=[
,,,[57003450442,"JB"],];
CONWAYPOLDATA[66343]:=[
,,,[12338404802,"JB"],];
CONWAYPOLDATA[66347]:=[
,,,[38692110768,"JB"],];
CONWAYPOLDATA[66359]:=[
,,,[15912954572,"JB"],];
CONWAYPOLDATA[66361]:=[
,,,[157739632490,"JB"],];
CONWAYPOLDATA[66373]:=[
,,,[65982394897,"JB"],];
CONWAYPOLDATA[66377]:=[
,,,[6876126187,"JB"],];
CONWAYPOLDATA[66383]:=[
,,,[47147131712,"JB"],];
CONWAYPOLDATA[66403]:=[
,,,[38395077841,"JB"],];
CONWAYPOLDATA[66413]:=[
,,,[29067641842,"JB"],];
CONWAYPOLDATA[66431]:=[
,,,[42625982605,"JB"],];
CONWAYPOLDATA[66449]:=[
,,,[16503672337,"JB"],];
CONWAYPOLDATA[66457]:=[
,,,[28881547635,"JB"],];
CONWAYPOLDATA[66463]:=[
,,,[11995906880,"JB"],];
CONWAYPOLDATA[66467]:=[
,,,[59964799260,"JB"],];
CONWAYPOLDATA[66491]:=[
,,,[12012729499,"JB"],];
CONWAYPOLDATA[66499]:=[
,,,[29637739815,"JB"],];
CONWAYPOLDATA[66509]:=[
,,,[86849713508,"JB"],];
CONWAYPOLDATA[66523]:=[
,,,[38509100334,"JB"],];
CONWAYPOLDATA[66529]:=[
,,,[117370927522,"JB"],];
CONWAYPOLDATA[66533]:=[
,,,[12122312602,"JB"],];
CONWAYPOLDATA[66541]:=[
,,,[12202288586,"JB"],];
CONWAYPOLDATA[66553]:=[
,,,[30433089638,"JB"],];
CONWAYPOLDATA[66569]:=[
,,,[4125147795,"JB"],];
CONWAYPOLDATA[66571]:=[
,,,[30992129057,"JB"],];
CONWAYPOLDATA[66587]:=[
,,,[11953898003,"JB"],];
CONWAYPOLDATA[66593]:=[
,,,[20899147565,"JB"],];
CONWAYPOLDATA[66601]:=[
,,,[2817022504,"JB"],];
CONWAYPOLDATA[66617]:=[
,,,[2487079081,"JB"],];
CONWAYPOLDATA[66629]:=[
,,,[7479505026,"JB"],];
CONWAYPOLDATA[66643]:=[
,,,[11368496086,"JB"],];
CONWAYPOLDATA[66653]:=[
,,,[6921047563,"JB"],];
CONWAYPOLDATA[66683]:=[
,,,[31125823964,"JB"],];
CONWAYPOLDATA[66697]:=[
,,,[47897450100,"JB"],];
CONWAYPOLDATA[66701]:=[
,,,[15991164547,"JB"],];
CONWAYPOLDATA[66713]:=[
,,,[7869532196,"JB"],];
CONWAYPOLDATA[66721]:=[
,,,[65768090691,"JB"],];
CONWAYPOLDATA[66733]:=[
,,,[47857370753,"JB"],];
CONWAYPOLDATA[66739]:=[
,,,[39037109360,"JB"],];
CONWAYPOLDATA[66749]:=[
,,,[11685613935,"JB"],];
CONWAYPOLDATA[66751]:=[
,,,[35290452691,"JB"],];
CONWAYPOLDATA[66763]:=[
,,,[15671145467,"JB"],];
CONWAYPOLDATA[66791]:=[
,,,[31033503083,"JB"],];
CONWAYPOLDATA[66797]:=[
,,,[29879567245,"JB"],];
CONWAYPOLDATA[66809]:=[
,,,[21803785246,"JB"],];
CONWAYPOLDATA[66821]:=[
,,,[16689814351,"JB"],];
CONWAYPOLDATA[66841]:=[
,,,[109614895342,"JB"],];
CONWAYPOLDATA[66851]:=[
,,,[16973936859,"JB"],];
CONWAYPOLDATA[66853]:=[
,,,[17436599462,"JB"],];
CONWAYPOLDATA[66863]:=[
,,,[13086225776,"JB"],];
CONWAYPOLDATA[66877]:=[
,,,[44092474244,"JB"],];
CONWAYPOLDATA[66883]:=[
,,,[11242631004,"JB"],];
CONWAYPOLDATA[66889]:=[
,,,[92175985133,"JB"],];
CONWAYPOLDATA[66919]:=[
,,,[17681003591,"JB"],];
CONWAYPOLDATA[66923]:=[
,,,[52041533261,"JB"],];
CONWAYPOLDATA[66931]:=[
,,,[12279897504,"JB"],];
CONWAYPOLDATA[66943]:=[
,,,[25268572555,"JB"],];
CONWAYPOLDATA[66947]:=[
,,,[12462920469,"JB"],];
CONWAYPOLDATA[66949]:=[
,,,[57784083604,"JB"],];
CONWAYPOLDATA[66959]:=[
,,,[22416935781,"JB"],];
CONWAYPOLDATA[66973]:=[
,,,[30993430077,"JB"],];
CONWAYPOLDATA[66977]:=[
,,,[30085331658,"JB"],];
CONWAYPOLDATA[67003]:=[
,,,[35469311109,"JB"],];
CONWAYPOLDATA[67021]:=[
,,,[58358870862,"JB"],];
CONWAYPOLDATA[67033]:=[
,,,[74595797131,"JB"],];
CONWAYPOLDATA[67043]:=[
,,,[34544106881,"JB"],];
CONWAYPOLDATA[67049]:=[
,,,[11420389124,"JB"],];
CONWAYPOLDATA[67057]:=[
,,,[94369316105,"JB"],];
CONWAYPOLDATA[67061]:=[
,,,[58424482056,"JB"],];
CONWAYPOLDATA[67073]:=[
,,,[30112959937,"JB"],];
CONWAYPOLDATA[67079]:=[
,,,[13001587186,"JB"],];
CONWAYPOLDATA[67103]:=[
,,,[34226287773,"JB"],];
CONWAYPOLDATA[67121]:=[
,,,[48012389637,"JB"],];
CONWAYPOLDATA[67129]:=[
,,,[79772747157,"JB"],];
CONWAYPOLDATA[67139]:=[
,,,[6905716125,"JB"],];
CONWAYPOLDATA[67141]:=[
,,,[47913563268,"JB"],];
CONWAYPOLDATA[67153]:=[
,,,[49160092338,"JB"],];
CONWAYPOLDATA[67157]:=[
,,,[4299055357,"JB"],];
CONWAYPOLDATA[67169]:=[
,,,[12022915158,"JB"],];
CONWAYPOLDATA[67181]:=[
,,,[29780732673,"JB"],];
CONWAYPOLDATA[67187]:=[
,,,[38741166381,"JB"],];
CONWAYPOLDATA[67189]:=[
,,,[11373417981,"JB"],];
CONWAYPOLDATA[67211]:=[
,,,[40625688952,"JB"],];
CONWAYPOLDATA[67213]:=[
,,,[29400243249,"JB"],];
CONWAYPOLDATA[67217]:=[
,,,[31394372023,"JB"],];
CONWAYPOLDATA[67219]:=[
,,,[8018352864,"JB"],];
CONWAYPOLDATA[67231]:=[
,,,[12232075374,"JB"],];
CONWAYPOLDATA[67247]:=[
,,,[26863360836,"JB"],];
CONWAYPOLDATA[67261]:=[
,,,[17250361411,"JB"],];
CONWAYPOLDATA[67271]:=[
,,,[47689959147,"JB"],];
CONWAYPOLDATA[67273]:=[
,,,[49492342469,"JB"],];
CONWAYPOLDATA[67289]:=[
,,,[35744455115,"JB"],];
CONWAYPOLDATA[67307]:=[
,,,[34273464779,"JB"],];
CONWAYPOLDATA[67339]:=[
,,,[34426525041,"JB"],];
CONWAYPOLDATA[67343]:=[
,,,[18140049229,"JB"],];
CONWAYPOLDATA[67349]:=[
,,,[44209163233,"JB"],];
CONWAYPOLDATA[67369]:=[
,,,[193195226592,"JB"],];
CONWAYPOLDATA[67391]:=[
,,,[16323852373,"JB"],];
CONWAYPOLDATA[67399]:=[
,,,[16158573258,"JB"],];
CONWAYPOLDATA[67409]:=[
,,,[4543164376,"JB"],];
CONWAYPOLDATA[67411]:=[
,,,[39103705471,"JB"],];
CONWAYPOLDATA[67421]:=[
,,,[7200832486,"JB"],];
CONWAYPOLDATA[67427]:=[
,,,[35527151448,"JB"],];
CONWAYPOLDATA[67429]:=[
,,,[17859110084,"JB"],];
CONWAYPOLDATA[67433]:=[
,,,[4185364014,"JB"],];
CONWAYPOLDATA[67447]:=[
,,,[13165991638,"JB"],];
CONWAYPOLDATA[67453]:=[
,,,[98648663442,"JB"],];
CONWAYPOLDATA[67477]:=[
,,,[58331302376,"JB"],];
CONWAYPOLDATA[67481]:=[
,,,[11403816636,"JB"],];
CONWAYPOLDATA[67489]:=[
,,,[127389874308,"JB"],];
CONWAYPOLDATA[67493]:=[
,,,[6852564292,"JB"],];
CONWAYPOLDATA[67499]:=[
,,,[34222735491,"JB"],];
CONWAYPOLDATA[67511]:=[
,,,[17186680347,"JB"],];
CONWAYPOLDATA[67523]:=[
,,,[34928905149,"JB"],];
CONWAYPOLDATA[67531]:=[
,,,[2729265375,"JB"],];
CONWAYPOLDATA[67537]:=[
,,,[76108728508,"JB"],];
CONWAYPOLDATA[67547]:=[
,,,[2514031795,"JB"],];
CONWAYPOLDATA[67559]:=[
,,,[13532675738,"JB"],];
CONWAYPOLDATA[67567]:=[
,,,[29866641013,"JB"],];
CONWAYPOLDATA[67577]:=[
,,,[31913846446,"JB"],];
CONWAYPOLDATA[67579]:=[
,,,[40955306851,"JB"],];
CONWAYPOLDATA[67589]:=[
,,,[3971867587,"JB"],];
CONWAYPOLDATA[67601]:=[
,,,[9114913237,"JB"],];
CONWAYPOLDATA[67607]:=[
,,,[27339932770,"JB"],];
CONWAYPOLDATA[67619]:=[
,,,[12170946669,"JB"],];
CONWAYPOLDATA[67631]:=[
,,,[12608514968,"JB"],];
CONWAYPOLDATA[67651]:=[
,,,[48497175334,"JB"],];
CONWAYPOLDATA[67679]:=[
,,,[45746063452,"JB"],];
CONWAYPOLDATA[67699]:=[
,,,[13222494789,"JB"],];
CONWAYPOLDATA[67709]:=[
,,,[3448961044,"JB"],];
CONWAYPOLDATA[67723]:=[
,,,[2625146654,"JB"],];
CONWAYPOLDATA[67733]:=[
,,,[2498128508,"JB"],];
CONWAYPOLDATA[67741]:=[
,,,[59654418131,"JB"],];
CONWAYPOLDATA[67751]:=[
,,,[25653509657,"JB"],];
CONWAYPOLDATA[67757]:=[
,,,[22954784220,"JB"],];
CONWAYPOLDATA[67759]:=[
,,,[17862830863,"JB"],];
CONWAYPOLDATA[67763]:=[
,,,[49339188984,"JB"],];
CONWAYPOLDATA[67777]:=[
,,,[77169468888,"JB"],];
CONWAYPOLDATA[67783]:=[
,,,[17674010555,"JB"],];
CONWAYPOLDATA[67789]:=[
,,,[13394157360,"JB"],];
CONWAYPOLDATA[67801]:=[
,,,[58212718193,"JB"],];
CONWAYPOLDATA[67807]:=[
,,,[16842987575,"JB"],];
CONWAYPOLDATA[67819]:=[
,,,[3166876034,"JB"],];
CONWAYPOLDATA[67829]:=[
,,,[8943728455,"JB"],];
CONWAYPOLDATA[67843]:=[
,,,[4072547461,"JB"],];
CONWAYPOLDATA[67853]:=[
,,,[30444894719,"JB"],];
CONWAYPOLDATA[67867]:=[
,,,[40544424472,"JB"],];
CONWAYPOLDATA[67883]:=[
,,,[39748687003,"JB"],];
CONWAYPOLDATA[67891]:=[
,,,[12411289495,"JB"],];
CONWAYPOLDATA[67901]:=[
,,,[23052457404,"JB"],];
CONWAYPOLDATA[67927]:=[
,,,[12847984491,"JB"],];
CONWAYPOLDATA[67931]:=[
,,,[36916286784,"JB"],];
CONWAYPOLDATA[67933]:=[
,,,[17295945601,"JB"],];
CONWAYPOLDATA[67939]:=[
,,,[31532799829,"JB"],];
CONWAYPOLDATA[67943]:=[
,,,[16681569194,"JB"],];
CONWAYPOLDATA[67957]:=[
,,,[45528947421,"JB"],];
CONWAYPOLDATA[67961]:=[
,,,[4617881992,"JB"],];
CONWAYPOLDATA[67967]:=[
,,,[18477780493,"JB"],];
CONWAYPOLDATA[67979]:=[
,,,[22922382844,"JB"],];
CONWAYPOLDATA[67987]:=[
,,,[13201987610,"JB"],];
CONWAYPOLDATA[67993]:=[
,,,[69344972817,"JB"],];
CONWAYPOLDATA[68023]:=[
,,,[27657811688,"JB"],];
CONWAYPOLDATA[68041]:=[
,,,[3608010129,"JB"],];
CONWAYPOLDATA[68053]:=[
,,,[17340040511,"JB"],];
CONWAYPOLDATA[68059]:=[
,,,[36600769022,"JB"],];
CONWAYPOLDATA[68071]:=[
,,,[13600109309,"JB"],];
CONWAYPOLDATA[68087]:=[
,,,[59783926529,"JB"],];
CONWAYPOLDATA[68099]:=[
,,,[36317060504,"JB"],];
CONWAYPOLDATA[68111]:=[
,,,[27023175479,"JB"],];
CONWAYPOLDATA[68113]:=[
,,,[92165948034,"JB"],];
CONWAYPOLDATA[68141]:=[
,,,[54908290367,"JB"],];
CONWAYPOLDATA[68147]:=[
,,,[35937184158,"JB"],];
CONWAYPOLDATA[68161]:=[
,,,[166777357228,"JB"],];
CONWAYPOLDATA[68171]:=[
,,,[36180258490,"JB"],];
CONWAYPOLDATA[68207]:=[
,,,[22540912951,"JB"],];
CONWAYPOLDATA[68209]:=[
,,,[116209378538,"JB"],];
CONWAYPOLDATA[68213]:=[
,,,[16326372274,"JB"],];
CONWAYPOLDATA[68219]:=[
,,,[40564995753,"JB"],];
CONWAYPOLDATA[68227]:=[
,,,[37157720515,"JB"],];
CONWAYPOLDATA[68239]:=[
,,,[16890722000,"JB"],];
CONWAYPOLDATA[68261]:=[
,,,[32377011434,"JB"],];
CONWAYPOLDATA[68279]:=[
,,,[36324837681,"JB"],];
CONWAYPOLDATA[68281]:=[
,,,[83547470830,"JB"],];
CONWAYPOLDATA[68311]:=[
,,,[16458305858,"JB"],];
CONWAYPOLDATA[68329]:=[
,,,[59082924718,"JB"],];
CONWAYPOLDATA[68351]:=[
,,,[26063945092,"JB"],];
CONWAYPOLDATA[68371]:=[
,,,[32691183431,"JB"],];
CONWAYPOLDATA[68389]:=[
,,,[17002326070,"JB"],];
CONWAYPOLDATA[68399]:=[
,,,[23330146518,"JB"],];
CONWAYPOLDATA[68437]:=[
,,,[18552791643,"JB"],];
CONWAYPOLDATA[68443]:=[
,,,[32790562204,"JB"],];
CONWAYPOLDATA[68447]:=[
,,,[18739693453,"JB"],];
CONWAYPOLDATA[68449]:=[
,,,[4189626399,"JB"],];
CONWAYPOLDATA[68473]:=[
,,,[69683739596,"JB"],];
CONWAYPOLDATA[68477]:=[
,,,[18493651869,"JB"],];
CONWAYPOLDATA[68483]:=[
,,,[86877944700,"JB"],];
CONWAYPOLDATA[68489]:=[
,,,[12441848721,"JB"],];
CONWAYPOLDATA[68491]:=[
,,,[27902959446,"JB"],];
CONWAYPOLDATA[68501]:=[
,,,[22846590525,"JB"],];
CONWAYPOLDATA[68507]:=[
,,,[21939914808,"JB"],];
CONWAYPOLDATA[68521]:=[
,,,[3028970812,"JB"],];
CONWAYPOLDATA[68531]:=[
,,,[2492609538,"JB"],];
CONWAYPOLDATA[68539]:=[
,,,[17401640868,"JB"],];
CONWAYPOLDATA[68543]:=[
,,,[18708400597,"JB"],];
CONWAYPOLDATA[68567]:=[
,,,[18458510673,"JB"],];
CONWAYPOLDATA[68581]:=[
,,,[12144940715,"JB"],];
CONWAYPOLDATA[68597]:=[
,,,[59457410110,"JB"],];
CONWAYPOLDATA[68611]:=[
,,,[40113146708,"JB"],];
CONWAYPOLDATA[68633]:=[
,,,[8939516886,"JB"],];
CONWAYPOLDATA[68639]:=[
,,,[35711087093,"JB"],];
CONWAYPOLDATA[68659]:=[
,,,[13373194045,"JB"],];
CONWAYPOLDATA[68669]:=[
,,,[17461153322,"JB"],];
CONWAYPOLDATA[68683]:=[
,,,[42455709622,"JB"],];
CONWAYPOLDATA[68687]:=[
,,,[17611758927,"JB"],];
CONWAYPOLDATA[68699]:=[
,,,[3070914001,"JB"],];
CONWAYPOLDATA[68711]:=[
,,,[26569306913,"JB"],];
CONWAYPOLDATA[68713]:=[
,,,[78864452486,"JB"],];
CONWAYPOLDATA[68729]:=[
,,,[4722850696,"JB"],];
CONWAYPOLDATA[68737]:=[
,,,[55865584333,"JB"],];
CONWAYPOLDATA[68743]:=[
,,,[23627725276,"JB"],];
CONWAYPOLDATA[68749]:=[
,,,[3618741119,"JB"],];
CONWAYPOLDATA[68767]:=[
,,,[11995921784,"JB"],];
CONWAYPOLDATA[68771]:=[
,,,[32141846135,"JB"],];
CONWAYPOLDATA[68777]:=[
,,,[3304666076,"JB"],];
CONWAYPOLDATA[68791]:=[
,,,[12635118137,"JB"],];
CONWAYPOLDATA[68813]:=[
,,,[18158443255,"JB"],];
CONWAYPOLDATA[68819]:=[
,,,[42407850639,"JB"],];
CONWAYPOLDATA[68821]:=[
,,,[8737514174,"JB"],];
CONWAYPOLDATA[68863]:=[
,,,[52162689558,"JB"],];
CONWAYPOLDATA[68879]:=[
,,,[80044905824,"JB"],];
CONWAYPOLDATA[68881]:=[
,,,[94890052336,"JB"],];
CONWAYPOLDATA[68891]:=[
,,,[17208076219,"JB"],];
CONWAYPOLDATA[68897]:=[
,,,[45960017454,"JB"],];
CONWAYPOLDATA[68899]:=[
,,,[13601558289,"JB"],];
CONWAYPOLDATA[68903]:=[
,,,[26220072013,"JB"],];
CONWAYPOLDATA[68909]:=[
,,,[37773570896,"JB"],];
CONWAYPOLDATA[68917]:=[
,,,[7401823639,"JB"],];
CONWAYPOLDATA[68927]:=[
,,,[41592343907,"JB"],];
CONWAYPOLDATA[68947]:=[
,,,[170534819795,"JB"],];
CONWAYPOLDATA[68963]:=[
,,,[13198414794,"JB"],];
CONWAYPOLDATA[68993]:=[
,,,[9189867603,"JB"],];
CONWAYPOLDATA[69001]:=[
,,,[156979483051,"JB"],];
CONWAYPOLDATA[69011]:=[
,,,[47279298084,"JB"],];
CONWAYPOLDATA[69019]:=[
,,,[12800263742,"JB"],];
CONWAYPOLDATA[69029]:=[
,,,[13124690859,"JB"],];
CONWAYPOLDATA[69031]:=[
,,,[18099168862,"JB"],];
CONWAYPOLDATA[69061]:=[
,,,[32737400198,"JB"],];
CONWAYPOLDATA[69067]:=[
,,,[42931770934,"JB"],];
CONWAYPOLDATA[69073]:=[
,,,[2853060275,"JB"],];
CONWAYPOLDATA[69109]:=[
,,,[18036481476,"JB"],];
CONWAYPOLDATA[69119]:=[
,,,[21542042267,"JB"],];
CONWAYPOLDATA[69127]:=[
,,,[19113892013,"JB"],];
CONWAYPOLDATA[69143]:=[
,,,[12540673344,"JB"],];
CONWAYPOLDATA[69149]:=[
,,,[13450794333,"JB"],];
CONWAYPOLDATA[69151]:=[
,,,[18352952015,"JB"],];
CONWAYPOLDATA[69163]:=[
,,,[43051200982,"JB"],];
CONWAYPOLDATA[69191]:=[
,,,[27607762539,"JB"],];
CONWAYPOLDATA[69193]:=[
,,,[40728037705,"JB"],];
CONWAYPOLDATA[69197]:=[
,,,[47830765524,"JB"],];
CONWAYPOLDATA[69203]:=[
,,,[76573396314,"JB"],];
CONWAYPOLDATA[69221]:=[
,,,[60638634317,"JB"],];
CONWAYPOLDATA[69233]:=[
,,,[21618488884,"JB"],];
CONWAYPOLDATA[69239]:=[
,,,[17857568975,"JB"],];
CONWAYPOLDATA[69247]:=[
,,,[28125084535,"JB"],];
CONWAYPOLDATA[69257]:=[
,,,[14306072208,"JB"],];
CONWAYPOLDATA[69259]:=[
,,,[41134097505,"JB"],];
CONWAYPOLDATA[69263]:=[
,,,[42475950333,"JB"],];
CONWAYPOLDATA[69313]:=[
,,,[4646258339,"JB"],];
CONWAYPOLDATA[69317]:=[
,,,[22763009633,"JB"],];
CONWAYPOLDATA[69337]:=[
,,,[75490104059,"JB"],];
CONWAYPOLDATA[69341]:=[
,,,[52889362366,"JB"],];
CONWAYPOLDATA[69371]:=[
,,,[41190696156,"JB"],];
CONWAYPOLDATA[69379]:=[
,,,[42242514216,"JB"],];
CONWAYPOLDATA[69383]:=[
,,,[19255725229,"JB"],];
CONWAYPOLDATA[69389]:=[
,,,[22424859466,"JB"],];
CONWAYPOLDATA[69401]:=[
,,,[23336016855,"JB"],];
CONWAYPOLDATA[69403]:=[
,,,[38305111983,"JB"],];
CONWAYPOLDATA[69427]:=[
,,,[41995142616,"JB"],];
CONWAYPOLDATA[69431]:=[
,,,[37956608524,"JB"],];
CONWAYPOLDATA[69439]:=[
,,,[19209466085,"JB"],];
CONWAYPOLDATA[69457]:=[
,,,[33588710635,"JB"],];
CONWAYPOLDATA[69463]:=[
,,,[22583463251,"JB"],];
CONWAYPOLDATA[69467]:=[
,,,[12671336538,"JB"],];
CONWAYPOLDATA[69473]:=[
,,,[3091826395,"JB"],];
CONWAYPOLDATA[69481]:=[
,,,[13563802903,"JB"],];
CONWAYPOLDATA[69491]:=[
,,,[41086414770,"JB"],];
CONWAYPOLDATA[69493]:=[
,,,[33272414486,"JB"],];
CONWAYPOLDATA[69497]:=[
,,,[37720052729,"JB"],];
CONWAYPOLDATA[69499]:=[
,,,[27576925207,"JB"],];
CONWAYPOLDATA[69539]:=[
,,,[36419590933,"JB"],];
CONWAYPOLDATA[69557]:=[
,,,[21985924347,"JB"],];
CONWAYPOLDATA[69593]:=[
,,,[9107844692,"JB"],];
CONWAYPOLDATA[69623]:=[
,,,[31523762699,"JB"],];
CONWAYPOLDATA[69653]:=[
,,,[7697004767,"JB"],];
CONWAYPOLDATA[69661]:=[
,,,[37176961130,"JB"],];
CONWAYPOLDATA[69677]:=[
,,,[24115140025,"JB"],];
CONWAYPOLDATA[69691]:=[
,,,[13546327509,"JB"],];
CONWAYPOLDATA[69697]:=[
,,,[61005505317,"JB"],];
CONWAYPOLDATA[69709]:=[
,,,[57600267875,"JB"],];
CONWAYPOLDATA[69737]:=[
,,,[22283551772,"JB"],];
CONWAYPOLDATA[69739]:=[
,,,[12636148890,"JB"],];
CONWAYPOLDATA[69761]:=[
,,,[23297871890,"JB"],];
CONWAYPOLDATA[69763]:=[
,,,[51688592673,"JB"],];
CONWAYPOLDATA[69767]:=[
,,,[28549702910,"JB"],];
CONWAYPOLDATA[69779]:=[
,,,[38418642706,"JB"],];
CONWAYPOLDATA[69809]:=[
,,,[3493032936,"JB"],];
CONWAYPOLDATA[69821]:=[
,,,[47038407707,"JB"],];
CONWAYPOLDATA[69827]:=[
,,,[121631721129,"JB"],];
CONWAYPOLDATA[69829]:=[
,,,[71181727398,"JB"],];
CONWAYPOLDATA[69833]:=[
,,,[53104155690,"JB"],];
CONWAYPOLDATA[69847]:=[
,,,[18635109763,"JB"],];
CONWAYPOLDATA[69857]:=[
,,,[22555218592,"JB"],];
CONWAYPOLDATA[69859]:=[
,,,[8671318244,"JB"],];
CONWAYPOLDATA[69877]:=[
,,,[32096462658,"JB"],];
CONWAYPOLDATA[69899]:=[
,,,[24120117831,"JB"],];
CONWAYPOLDATA[69911]:=[
,,,[24437110413,"JB"],];
CONWAYPOLDATA[69929]:=[
,,,[13357907512,"JB"],];
CONWAYPOLDATA[69931]:=[
,,,[14622082586,"JB"],];
CONWAYPOLDATA[69941]:=[
,,,[32399468842,"JB"],];
CONWAYPOLDATA[69959]:=[
,,,[28272110923,"JB"],];
CONWAYPOLDATA[69991]:=[
,,,[19491863584,"JB"],];
CONWAYPOLDATA[69997]:=[
,,,[14502748429,"JB"],];
CONWAYPOLDATA[70001]:=[
,,,[24050453576,"JB"],];
CONWAYPOLDATA[70003]:=[
,,,[52009358879,"JB"],];
CONWAYPOLDATA[70009]:=[
,,,[161046253304,"JB"],];
CONWAYPOLDATA[70019]:=[
,,,[27174864039,"JB"],];
CONWAYPOLDATA[70039]:=[
,,,[13428717551,"JB"],];
CONWAYPOLDATA[70051]:=[
,,,[32054567046,"JB"],];
CONWAYPOLDATA[70061]:=[
,,,[19496645143,"JB"],];
CONWAYPOLDATA[70067]:=[
,,,[4845133052,"JB"],];
CONWAYPOLDATA[70079]:=[
,,,[17587376242,"JB"],];
CONWAYPOLDATA[70099]:=[
,,,[12999579157,"JB"],];
CONWAYPOLDATA[70111]:=[
,,,[18749153737,"JB"],];
CONWAYPOLDATA[70117]:=[
,,,[32836912974,"JB"],];
CONWAYPOLDATA[70121]:=[
,,,[36975855121,"JB"],];
CONWAYPOLDATA[70123]:=[
,,,[72405784144,"JB"],];
CONWAYPOLDATA[70139]:=[
,,,[7890918058,"JB"],];
CONWAYPOLDATA[70141]:=[
,,,[63889893808,"JB"],];
CONWAYPOLDATA[70157]:=[
,,,[27556757561,"JB"],];
CONWAYPOLDATA[70163]:=[
,,,[7957326158,"JB"],];
CONWAYPOLDATA[70177]:=[
,,,[33167966046,"JB"],];
CONWAYPOLDATA[70181]:=[
,,,[4582047316,"JB"],];
CONWAYPOLDATA[70183]:=[
,,,[24627986716,"JB"],];
CONWAYPOLDATA[70199]:=[
,,,[43160451187,"JB"],];
CONWAYPOLDATA[70201]:=[
,,,[43271615610,"JB"],];
CONWAYPOLDATA[70207]:=[
,,,[27596054874,"JB"],];
CONWAYPOLDATA[70223]:=[
,,,[17425626786,"JB"],];
CONWAYPOLDATA[70229]:=[
,,,[23030406659,"JB"],];
CONWAYPOLDATA[70237]:=[
,,,[18771821570,"JB"],];
CONWAYPOLDATA[70241]:=[
,,,[23473067145,"JB"],];
CONWAYPOLDATA[70249]:=[
,,,[170715888369,"JB"],];
CONWAYPOLDATA[70271]:=[
,,,[29491192749,"JB"],];
CONWAYPOLDATA[70289]:=[
,,,[24281053897,"JB"],];
CONWAYPOLDATA[70297]:=[
,,,[52738215345,"JB"],];
CONWAYPOLDATA[70309]:=[
,,,[58133098313,"JB"],];
CONWAYPOLDATA[70313]:=[
,,,[58348750862,"JB"],];
CONWAYPOLDATA[70321]:=[
,,,[86665077148,"JB"],];
CONWAYPOLDATA[70327]:=[
,,,[74055104608,"JB"],];
CONWAYPOLDATA[70351]:=[
,,,[14359061212,"JB"],];
CONWAYPOLDATA[70373]:=[
,,,[33306274188,"JB"],];
CONWAYPOLDATA[70379]:=[
,,,[4049255771,"JB"],];
CONWAYPOLDATA[70381]:=[
,,,[8903900320,"JB"],];
CONWAYPOLDATA[70393]:=[
,,,[52953627006,"JB"],];
CONWAYPOLDATA[70423]:=[
,,,[19837314029,"JB"],];
CONWAYPOLDATA[70429]:=[
,,,[14093054197,"JB"],];
CONWAYPOLDATA[70439]:=[
,,,[32375807144,"JB"],];
CONWAYPOLDATA[70451]:=[
,,,[28853347958,"JB"],];
CONWAYPOLDATA[70457]:=[
,,,[24139413687,"JB"],];
CONWAYPOLDATA[70459]:=[
,,,[13592527529,"JB"],];
CONWAYPOLDATA[70481]:=[
,,,[13364043375,"JB"],];
CONWAYPOLDATA[70487]:=[
,,,[72708891219,"JB"],];
CONWAYPOLDATA[70489]:=[
,,,[102590184040,"JB"],];
CONWAYPOLDATA[70501]:=[
,,,[54278085393,"JB"],];
CONWAYPOLDATA[70507]:=[
,,,[13092585846,"JB"],];
CONWAYPOLDATA[70529]:=[
,,,[38823252285,"JB"],];
CONWAYPOLDATA[70537]:=[
,,,[79071694857,"JB"],];
CONWAYPOLDATA[70549]:=[
,,,[18927238467,"JB"],];
CONWAYPOLDATA[70571]:=[
,,,[38723083983,"JB"],];
CONWAYPOLDATA[70573]:=[
,,,[44824440952,"JB"],];
CONWAYPOLDATA[70583]:=[
,,,[19927557229,"JB"],];
CONWAYPOLDATA[70589]:=[
,,,[23395382861,"JB"],];
CONWAYPOLDATA[70607]:=[
,,,[24063501068,"JB"],];
CONWAYPOLDATA[70619]:=[
,,,[14325558485,"JB"],];
CONWAYPOLDATA[70621]:=[
,,,[37863590398,"JB"],];
CONWAYPOLDATA[70627]:=[
,,,[68620910699,"JB"],];
CONWAYPOLDATA[70639]:=[
,,,[19284376364,"JB"],];
CONWAYPOLDATA[70657]:=[
,,,[42492625208,"JB"],];
CONWAYPOLDATA[70663]:=[
,,,[13848676069,"JB"],];
CONWAYPOLDATA[70667]:=[
,,,[19161639720,"JB"],];
CONWAYPOLDATA[70687]:=[
,,,[94935256424,"JB"],];
CONWAYPOLDATA[70709]:=[
,,,[34092697897,"JB"],];
CONWAYPOLDATA[70717]:=[
,,,[32833832385,"JB"],];
CONWAYPOLDATA[70729]:=[
,,,[3404045334,"JB"],];
CONWAYPOLDATA[70753]:=[
,,,[79549366730,"JB"],];
CONWAYPOLDATA[70769]:=[
,,,[23842854562,"JB"],];
CONWAYPOLDATA[70783]:=[
,,,[37675950545,"JB"],];
CONWAYPOLDATA[70793]:=[
,,,[33864185518,"JB"],];
CONWAYPOLDATA[70823]:=[
,,,[14549381364,"JB"],];
CONWAYPOLDATA[70841]:=[
,,,[8463657637,"JB"],];
CONWAYPOLDATA[70843]:=[
,,,[40039896858,"JB"],];
CONWAYPOLDATA[70849]:=[
,,,[178383966462,"JB"],];
CONWAYPOLDATA[70853]:=[
,,,[19804051179,"JB"],];
CONWAYPOLDATA[70867]:=[
,,,[19943603744,"JB"],];
CONWAYPOLDATA[70877]:=[
,,,[13922865251,"JB"],];
CONWAYPOLDATA[70879]:=[
,,,[13134658372,"JB"],];
CONWAYPOLDATA[70891]:=[
,,,[14692088862,"JB"],];
CONWAYPOLDATA[70901]:=[
,,,[19863836865,"JB"],];
CONWAYPOLDATA[70913]:=[
,,,[23096576842,"JB"],];
CONWAYPOLDATA[70919]:=[
,,,[32993220863,"JB"],];
CONWAYPOLDATA[70921]:=[
,,,[74256343722,"JB"],];
CONWAYPOLDATA[70937]:=[
,,,[59328018079,"JB"],];
CONWAYPOLDATA[70949]:=[
,,,[4463046847,"JB"],];
CONWAYPOLDATA[70951]:=[
,,,[19201681989,"JB"],];
CONWAYPOLDATA[70957]:=[
,,,[18793600065,"JB"],];
CONWAYPOLDATA[70969]:=[
,,,[84970261114,"JB"],];
CONWAYPOLDATA[70979]:=[
,,,[14175570987,"JB"],];
CONWAYPOLDATA[70981]:=[
,,,[14773985346,"JB"],];
CONWAYPOLDATA[70991]:=[
,,,[14410676070,"JB"],];
CONWAYPOLDATA[70997]:=[
,,,[48088540006,"JB"],];
CONWAYPOLDATA[70999]:=[
,,,[50106479276,"JB"],];
CONWAYPOLDATA[71011]:=[
,,,[33797046366,"JB"],];
CONWAYPOLDATA[71023]:=[
,,,[19304335498,"JB"],];
CONWAYPOLDATA[71039]:=[
,,,[35168496312,"JB"],];
CONWAYPOLDATA[71059]:=[
,,,[33223138044,"JB"],];
CONWAYPOLDATA[71069]:=[
,,,[48557681045,"JB"],];
CONWAYPOLDATA[71081]:=[
,,,[40301718626,"JB"],];
CONWAYPOLDATA[71089]:=[
,,,[113997751699,"JB"],];
CONWAYPOLDATA[71119]:=[
,,,[45253659774,"JB"],];
CONWAYPOLDATA[71129]:=[
,,,[13178567736,"JB"],];
CONWAYPOLDATA[71143]:=[
,,,[40424875466,"JB"],];
CONWAYPOLDATA[71147]:=[
,,,[23536139072,"JB"],];
CONWAYPOLDATA[71153]:=[
,,,[48586754900,"JB"],];
CONWAYPOLDATA[71161]:=[
,,,[65531595623,"JB"],];
CONWAYPOLDATA[71167]:=[
,,,[14336307485,"JB"],];
CONWAYPOLDATA[71171]:=[
,,,[23923064087,"JB"],];
CONWAYPOLDATA[71191]:=[
,,,[13531842901,"JB"],];
CONWAYPOLDATA[71209]:=[
,,,[3264719030,"JB"],];
CONWAYPOLDATA[71233]:=[
,,,[39476758747,"JB"],];
CONWAYPOLDATA[71237]:=[
,,,[35144132819,"JB"],];
CONWAYPOLDATA[71249]:=[
,,,[25328307013,"JB"],];
CONWAYPOLDATA[71257]:=[
,,,[76162616913,"JB"],];
CONWAYPOLDATA[71261]:=[
,,,[65660312969,"JB"],];
CONWAYPOLDATA[71263]:=[
,,,[14045082149,"JB"],];
CONWAYPOLDATA[71287]:=[
,,,[13098701105,"JB"],];
CONWAYPOLDATA[71293]:=[
,,,[9879213601,"JB"],];
CONWAYPOLDATA[71317]:=[
,,,[64754053077,"JB"],];
CONWAYPOLDATA[71327]:=[
,,,[20349878413,"JB"],];
CONWAYPOLDATA[71329]:=[
,,,[3043323121,"JB"],];
CONWAYPOLDATA[71333]:=[
,,,[59504918607,"JB"],];
CONWAYPOLDATA[71339]:=[
,,,[69190982712,"JB"],];
CONWAYPOLDATA[71341]:=[
,,,[35626482609,"JB"],];
CONWAYPOLDATA[71347]:=[
,,,[39608501093,"JB"],];
CONWAYPOLDATA[71353]:=[
,,,[64042813802,"JB"],];
CONWAYPOLDATA[71359]:=[
,,,[23565881602,"JB"],];
CONWAYPOLDATA[71363]:=[
,,,[54643291369,"JB"],];
CONWAYPOLDATA[71387]:=[
,,,[79648331964,"JB"],];
CONWAYPOLDATA[71389]:=[
,,,[44088275853,"JB"],];
CONWAYPOLDATA[71399]:=[
,,,[12761071882,"JB"],];
CONWAYPOLDATA[71411]:=[
,,,[38558155219,"JB"],];
CONWAYPOLDATA[71413]:=[
,,,[45897849232,"JB"],];
CONWAYPOLDATA[71419]:=[
,,,[40632554510,"JB"],];
CONWAYPOLDATA[71429]:=[
,,,[34198990909,"JB"],];
CONWAYPOLDATA[71437]:=[
,,,[54942696761,"JB"],];
CONWAYPOLDATA[71443]:=[
,,,[28140754724,"JB"],];
CONWAYPOLDATA[71453]:=[
,,,[18028306432,"JB"],];
CONWAYPOLDATA[71471]:=[
,,,[23369444645,"JB"],];
CONWAYPOLDATA[71473]:=[
,,,[33878273478,"JB"],];
CONWAYPOLDATA[71479]:=[
,,,[55115455494,"JB"],];
CONWAYPOLDATA[71483]:=[
,,,[23831574406,"JB"],];
CONWAYPOLDATA[71503]:=[
,,,[35580178815,"JB"],];
CONWAYPOLDATA[71527]:=[
,,,[33503962073,"JB"],];
CONWAYPOLDATA[71537]:=[
,,,[2616966537,"JB"],];
CONWAYPOLDATA[71549]:=[
,,,[25527252222,"JB"],];
CONWAYPOLDATA[71551]:=[
,,,[19946057623,"JB"],];
CONWAYPOLDATA[71563]:=[
,,,[45170064661,"JB"],];
CONWAYPOLDATA[71569]:=[
,,,[168224723744,"JB"],];
CONWAYPOLDATA[71593]:=[
,,,[79501162785,"JB"],];
CONWAYPOLDATA[71597]:=[
,,,[5075439735,"JB"],];
CONWAYPOLDATA[71633]:=[
,,,[23248131988,"JB"],];
CONWAYPOLDATA[71647]:=[
,,,[35085965785,"JB"],];
CONWAYPOLDATA[71663]:=[
,,,[13959020786,"JB"],];
CONWAYPOLDATA[71671]:=[
,,,[18552181707,"JB"],];
CONWAYPOLDATA[71693]:=[
,,,[9089453621,"JB"],];
CONWAYPOLDATA[71699]:=[
,,,[35669177017,"JB"],];
CONWAYPOLDATA[71707]:=[
,,,[9676572824,"JB"],];
CONWAYPOLDATA[71711]:=[
,,,[38740003281,"JB"],];
CONWAYPOLDATA[71713]:=[
,,,[65095396078,"JB"],];
CONWAYPOLDATA[71719]:=[
,,,[20008596937,"JB"],];
CONWAYPOLDATA[71741]:=[
,,,[20113665467,"JB"],];
CONWAYPOLDATA[71761]:=[
,,,[70654875990,"JB"],];
CONWAYPOLDATA[71777]:=[
,,,[50587568279,"JB"],];
CONWAYPOLDATA[71789]:=[
,,,[3508328432,"JB"],];
CONWAYPOLDATA[71807]:=[
,,,[61874081309,"JB"],];
CONWAYPOLDATA[71809]:=[
,,,[92568910098,"JB"],];
CONWAYPOLDATA[71821]:=[
,,,[54971290655,"JB"],];
CONWAYPOLDATA[71837]:=[
,,,[18495585044,"JB"],];
CONWAYPOLDATA[71843]:=[
,,,[43997946376,"JB"],];
CONWAYPOLDATA[71849]:=[
,,,[39264616315,"JB"],];
CONWAYPOLDATA[71861]:=[
,,,[29918752469,"JB"],];
CONWAYPOLDATA[71867]:=[
,,,[14329992334,"JB"],];
CONWAYPOLDATA[71879]:=[
,,,[14549028401,"JB"],];
CONWAYPOLDATA[71881]:=[
,,,[3727676786,"JB"],];
CONWAYPOLDATA[71887]:=[
,,,[14360506558,"JB"],];
CONWAYPOLDATA[71899]:=[
,,,[46083879749,"JB"],];
CONWAYPOLDATA[71909]:=[
,,,[20622638294,"JB"],];
CONWAYPOLDATA[71917]:=[
,,,[33993943313,"JB"],];
CONWAYPOLDATA[71933]:=[
,,,[35537851255,"JB"],];
CONWAYPOLDATA[71941]:=[
,,,[34526572191,"JB"],];
CONWAYPOLDATA[71947]:=[
,,,[46259834539,"JB"],];
CONWAYPOLDATA[71963]:=[
,,,[46607556582,"JB"],];
CONWAYPOLDATA[71971]:=[
,,,[44371057125,"JB"],];
CONWAYPOLDATA[71983]:=[
,,,[30522951493,"JB"],];
CONWAYPOLDATA[71987]:=[
,,,[138139381665,"JB"],];
CONWAYPOLDATA[71993]:=[
,,,[9042392796,"JB"],];
CONWAYPOLDATA[71999]:=[
,,,[40419590616,"JB"],];
CONWAYPOLDATA[72019]:=[
,,,[9705352461,"JB"],];
CONWAYPOLDATA[72031]:=[
,,,[19552310736,"JB"],];
CONWAYPOLDATA[72043]:=[
,,,[44503266481,"JB"],];
CONWAYPOLDATA[72047]:=[
,,,[30479195167,"JB"],];
CONWAYPOLDATA[72053]:=[
,,,[40602297820,"JB"],];
CONWAYPOLDATA[72073]:=[
,,,[55466588002,"JB"],];
CONWAYPOLDATA[72077]:=[
,,,[23862172007,"JB"],];
CONWAYPOLDATA[72089]:=[
,,,[5195958856,"JB"],];
CONWAYPOLDATA[72091]:=[
,,,[14757892794,"JB"],];
CONWAYPOLDATA[72101]:=[
,,,[66936765877,"JB"],];
CONWAYPOLDATA[72103]:=[
,,,[14575333044,"JB"],];
CONWAYPOLDATA[72109]:=[
,,,[34548359319,"JB"],];
CONWAYPOLDATA[72139]:=[
,,,[44880629601,"JB"],];
CONWAYPOLDATA[72161]:=[
,,,[24008541994,"JB"],];
CONWAYPOLDATA[72167]:=[
,,,[20832014893,"JB"],];
CONWAYPOLDATA[72169]:=[
,,,[2672129401,"JB"],];
CONWAYPOLDATA[72173]:=[
,,,[8663286057,"JB"],];
CONWAYPOLDATA[72211]:=[
,,,[14953670515,"JB"],];
CONWAYPOLDATA[72221]:=[
,,,[34334224507,"JB"],];
CONWAYPOLDATA[72223]:=[
,,,[93260476558,"JB"],];
CONWAYPOLDATA[72227]:=[
,,,[14830803274,"JB"],];
CONWAYPOLDATA[72229]:=[
,,,[52126874783,"JB"],];
CONWAYPOLDATA[72251]:=[
,,,[26100384753,"JB"],];
CONWAYPOLDATA[72253]:=[
,,,[33954936087,"JB"],];
CONWAYPOLDATA[72269]:=[
,,,[19870939705,"JB"],];
CONWAYPOLDATA[72271]:=[
,,,[20404343704,"JB"],];
CONWAYPOLDATA[72277]:=[
,,,[10057850494,"JB"],];
CONWAYPOLDATA[72287]:=[
,,,[20901352333,"JB"],];
CONWAYPOLDATA[72307]:=[
,,,[4668139923,"JB"],];
CONWAYPOLDATA[72313]:=[
,,,[35887857210,"JB"],];
CONWAYPOLDATA[72337]:=[
,,,[91842382709,"JB"],];
CONWAYPOLDATA[72341]:=[
,,,[51315956444,"JB"],];
CONWAYPOLDATA[72353]:=[
,,,[3993813250,"JB"],];
CONWAYPOLDATA[72367]:=[
,,,[35953734778,"JB"],];
CONWAYPOLDATA[72379]:=[
,,,[66586508632,"JB"],];
CONWAYPOLDATA[72383]:=[
,,,[26141409987,"JB"],];
CONWAYPOLDATA[72421]:=[
,,,[41511427522,"JB"],];
CONWAYPOLDATA[72431]:=[
,,,[35729777727,"JB"],];
CONWAYPOLDATA[72461]:=[
,,,[34646140237,"JB"],];
CONWAYPOLDATA[72467]:=[
,,,[72734620633,"JB"],];
CONWAYPOLDATA[72469]:=[
,,,[41158551149,"JB"],];
CONWAYPOLDATA[72481]:=[
,,,[44676563601,"JB"],];
CONWAYPOLDATA[72493]:=[
,,,[36582867522,"JB"],];
CONWAYPOLDATA[72497]:=[
,,,[34197994857,"JB"],];
CONWAYPOLDATA[72503]:=[
,,,[14474788937,"JB"],];
CONWAYPOLDATA[72533]:=[
,,,[9949206546,"JB"],];
CONWAYPOLDATA[72547]:=[
,,,[47367097054,"JB"],];
CONWAYPOLDATA[72551]:=[
,,,[50355182379,"JB"],];
CONWAYPOLDATA[72559]:=[
,,,[77069920474,"JB"],];
CONWAYPOLDATA[72577]:=[
,,,[79010515593,"JB"],];
CONWAYPOLDATA[72613]:=[
,,,[35821735614,"JB"],];
CONWAYPOLDATA[72617]:=[
,,,[26106537673,"JB"],];
CONWAYPOLDATA[72623]:=[
,,,[46547276117,"JB"],];
CONWAYPOLDATA[72643]:=[
,,,[93285089596,"JB"],];
CONWAYPOLDATA[72647]:=[
,,,[21110055853,"JB"],];
CONWAYPOLDATA[72649]:=[
,,,[93139287212,"JB"],];
CONWAYPOLDATA[72661]:=[
,,,[20351110874,"JB"],];
CONWAYPOLDATA[72671]:=[
,,,[20291996008,"JB"],];
CONWAYPOLDATA[72673]:=[
,,,[79219674537,"JB"],];
CONWAYPOLDATA[72679]:=[
,,,[18843629694,"JB"],];
CONWAYPOLDATA[72689]:=[
,,,[15602403097,"JB"],];
CONWAYPOLDATA[72701]:=[
,,,[47568409704,"JB"],];
CONWAYPOLDATA[72707]:=[
,,,[41066295035,"JB"],];
CONWAYPOLDATA[72719]:=[
,,,[31036396492,"JB"],];
CONWAYPOLDATA[72727]:=[
,,,[4682164267,"JB"],];
CONWAYPOLDATA[72733]:=[
,,,[36257618701,"JB"],];
CONWAYPOLDATA[72739]:=[
,,,[83151587852,"JB"],];
CONWAYPOLDATA[72763]:=[
,,,[88412138412,"JB"],];
CONWAYPOLDATA[72767]:=[
,,,[24409544621,"JB"],];
CONWAYPOLDATA[72797]:=[
,,,[36803833698,"JB"],];
CONWAYPOLDATA[72817]:=[
,,,[135524815895,"JB"],];
CONWAYPOLDATA[72823]:=[
,,,[29393110557,"JB"],];
CONWAYPOLDATA[72859]:=[
,,,[13706307941,"JB"],];
CONWAYPOLDATA[72869]:=[
,,,[47788510368,"JB"],];
CONWAYPOLDATA[72871]:=[
,,,[14256409575,"JB"],];
CONWAYPOLDATA[72883]:=[
,,,[45463613690,"JB"],];
CONWAYPOLDATA[72889]:=[
,,,[4323775487,"JB"],];
CONWAYPOLDATA[72893]:=[
,,,[35701533542,"JB"],];
CONWAYPOLDATA[72901]:=[
,,,[41975958396,"JB"],];
CONWAYPOLDATA[72907]:=[
,,,[45631251883,"JB"],];
CONWAYPOLDATA[72911]:=[
,,,[34743695553,"JB"],];
CONWAYPOLDATA[72923]:=[
,,,[46556012123,"JB"],];
CONWAYPOLDATA[72931]:=[
,,,[52288463908,"JB"],];
CONWAYPOLDATA[72937]:=[
,,,[34835002953,"JB"],];
CONWAYPOLDATA[72949]:=[
,,,[67682301049,"JB"],];
CONWAYPOLDATA[72953]:=[
,,,[52644562722,"JB"],];
CONWAYPOLDATA[72959]:=[
,,,[95812385341,"JB"],];
CONWAYPOLDATA[72973]:=[
,,,[40614874504,"JB"],];
CONWAYPOLDATA[72977]:=[
,,,[3307463597,"JB"],];
CONWAYPOLDATA[72997]:=[
,,,[52377537412,"JB"],];
CONWAYPOLDATA[73009]:=[
,,,[9805035698,"JB"],];
CONWAYPOLDATA[73013]:=[
,,,[24101080211,"JB"],];
CONWAYPOLDATA[73019]:=[
,,,[19494320546,"JB"],];
CONWAYPOLDATA[73037]:=[
,,,[19281110669,"JB"],];
CONWAYPOLDATA[73039]:=[
,,,[15007104216,"JB"],];
CONWAYPOLDATA[73043]:=[
,,,[42200301080,"JB"],];
CONWAYPOLDATA[73061]:=[
,,,[36328632459,"JB"],];
CONWAYPOLDATA[73063]:=[
,,,[19536753951,"JB"],];
CONWAYPOLDATA[73079]:=[
,,,[24310971706,"JB"],];
CONWAYPOLDATA[73091]:=[
,,,[24582476759,"JB"],];
CONWAYPOLDATA[73121]:=[
,,,[13785794617,"JB"],];
CONWAYPOLDATA[73127]:=[
,,,[21389940013,"JB"],];
CONWAYPOLDATA[73133]:=[
,,,[96200537729,"JB"],];
CONWAYPOLDATA[73141]:=[
,,,[24616115544,"JB"],];
CONWAYPOLDATA[73181]:=[
,,,[40927864691,"JB"],];
CONWAYPOLDATA[73189]:=[
,,,[68366503603,"JB"],];
CONWAYPOLDATA[73237]:=[
,,,[36960004137,"JB"],];
CONWAYPOLDATA[73243]:=[
,,,[15981476117,"JB"],];
CONWAYPOLDATA[73259]:=[
,,,[42060116413,"JB"],];
CONWAYPOLDATA[73277]:=[
,,,[26847300540,"JB"],];
CONWAYPOLDATA[73291]:=[
,,,[64178949846,"JB"],];
CONWAYPOLDATA[73303]:=[
,,,[31479313628,"JB"],];
CONWAYPOLDATA[73309]:=[
,,,[53249458332,"JB"],];
CONWAYPOLDATA[73327]:=[
,,,[26883951340,"JB"],];
CONWAYPOLDATA[73331]:=[
,,,[24656375456,"JB"],];
CONWAYPOLDATA[73351]:=[
,,,[37113478824,"JB"],];
CONWAYPOLDATA[73361]:=[
,,,[25305363434,"JB"],];
CONWAYPOLDATA[73363]:=[
,,,[21528225629,"JB"],];
CONWAYPOLDATA[73369]:=[
,,,[91324742119,"JB"],];
CONWAYPOLDATA[73379]:=[
,,,[10686990941,"JB"],];
CONWAYPOLDATA[73387]:=[
,,,[48470352214,"JB"],];
CONWAYPOLDATA[73417]:=[
,,,[117093654314,"JB"],];
CONWAYPOLDATA[73421]:=[
,,,[18903117504,"JB"],];
CONWAYPOLDATA[73433]:=[
,,,[8933858783,"JB"],];
CONWAYPOLDATA[73453]:=[
,,,[59308963775,"JB"],];
CONWAYPOLDATA[73459]:=[
,,,[46793823756,"JB"],];
CONWAYPOLDATA[73471]:=[
,,,[26989645324,"JB"],];
CONWAYPOLDATA[73477]:=[
,,,[48233535794,"JB"],];
CONWAYPOLDATA[73483]:=[
,,,[48402590755,"JB"],];
CONWAYPOLDATA[73517]:=[
,,,[36336512422,"JB"],];
CONWAYPOLDATA[73523]:=[
,,,[3406173546,"JB"],];
CONWAYPOLDATA[73529]:=[
,,,[3131011881,"JB"],];
CONWAYPOLDATA[73547]:=[
,,,[75217399466,"JB"],];
CONWAYPOLDATA[73553]:=[
,,,[42632422098,"JB"],];
CONWAYPOLDATA[73561]:=[
,,,[89721910347,"JB"],];
CONWAYPOLDATA[73571]:=[
,,,[48373815354,"JB"],];
CONWAYPOLDATA[73583]:=[
,,,[20894628685,"JB"],];
CONWAYPOLDATA[73589]:=[
,,,[78850613502,"JB"],];
CONWAYPOLDATA[73597]:=[
,,,[52547448435,"JB"],];
CONWAYPOLDATA[73607]:=[
,,,[37404795588,"JB"],];
CONWAYPOLDATA[73609]:=[
,,,[81161283419,"JB"],];
CONWAYPOLDATA[73613]:=[
,,,[67789696411,"JB"],];
CONWAYPOLDATA[73637]:=[
,,,[25839591487,"JB"],];
CONWAYPOLDATA[73643]:=[
,,,[79746605485,"JB"],];
CONWAYPOLDATA[73651]:=[
,,,[48360940575,"JB"],];
CONWAYPOLDATA[73673]:=[
,,,[25961112762,"JB"],];
CONWAYPOLDATA[73679]:=[
,,,[37307656380,"JB"],];
CONWAYPOLDATA[73681]:=[
,,,[4268708749,"JB"],];
CONWAYPOLDATA[73693]:=[
,,,[53165593773,"JB"],];
CONWAYPOLDATA[73699]:=[
,,,[10381241142,"JB"],];
CONWAYPOLDATA[73709]:=[
,,,[24654849703,"JB"],];
CONWAYPOLDATA[73721]:=[
,,,[3927560002,"JB"],];
CONWAYPOLDATA[73727]:=[
,,,[65227161629,"JB"],];
CONWAYPOLDATA[73751]:=[
,,,[19435674794,"JB"],];
CONWAYPOLDATA[73757]:=[
,,,[20246739044,"JB"],];
CONWAYPOLDATA[73771]:=[
,,,[35847246948,"JB"],];
CONWAYPOLDATA[73783]:=[
,,,[32545017256,"JB"],];
CONWAYPOLDATA[73819]:=[
,,,[19764446701,"JB"],];
CONWAYPOLDATA[73823]:=[
,,,[13755734887,"JB"],];
CONWAYPOLDATA[73847]:=[
,,,[21813222253,"JB"],];
CONWAYPOLDATA[73849]:=[
,,,[4012363875,"JB"],];
CONWAYPOLDATA[73859]:=[
,,,[21397173879,"JB"],];
CONWAYPOLDATA[73867]:=[
,,,[14692811105,"JB"],];
CONWAYPOLDATA[73877]:=[
,,,[25602813122,"JB"],];
CONWAYPOLDATA[73883]:=[
,,,[5371146336,"JB"],];
CONWAYPOLDATA[73897]:=[
,,,[91957870187,"JB"],];
CONWAYPOLDATA[73907]:=[
,,,[52002738970,"JB"],];
CONWAYPOLDATA[73939]:=[
,,,[10899126175,"JB"],];
CONWAYPOLDATA[73943]:=[
,,,[21366791114,"JB"],];
CONWAYPOLDATA[73951]:=[
,,,[21233994339,"JB"],];
CONWAYPOLDATA[73961]:=[
,,,[5469341992,"JB"],];
CONWAYPOLDATA[73973]:=[
,,,[48953038239,"JB"],];
CONWAYPOLDATA[73999]:=[
,,,[57559308167,"JB"],];
CONWAYPOLDATA[74017]:=[
,,,[59264301652,"JB"],];
CONWAYPOLDATA[74021]:=[
,,,[10434222225,"JB"],];
CONWAYPOLDATA[74027]:=[
,,,[81174528933,"JB"],];
CONWAYPOLDATA[74047]:=[
,,,[32344099838,"JB"],];
CONWAYPOLDATA[74051]:=[
,,,[15392388968,"JB"],];
CONWAYPOLDATA[74071]:=[
,,,[21313041412,"JB"],];
CONWAYPOLDATA[74077]:=[
,,,[21613446295,"JB"],];
CONWAYPOLDATA[74093]:=[
,,,[52999241553,"JB"],];
CONWAYPOLDATA[74099]:=[
,,,[4211935360,"JB"],];
CONWAYPOLDATA[74101]:=[
,,,[49418105104,"JB"],];
CONWAYPOLDATA[74131]:=[
,,,[49391706158,"JB"],];
CONWAYPOLDATA[74143]:=[
,,,[21988441229,"JB"],];
CONWAYPOLDATA[74149]:=[
,,,[42981728385,"JB"],];
CONWAYPOLDATA[74159]:=[
,,,[32996453791,"JB"],];
CONWAYPOLDATA[74161]:=[
,,,[4541026359,"JB"],];
CONWAYPOLDATA[74167]:=[
,,,[14479771749,"JB"],];
CONWAYPOLDATA[74177]:=[
,,,[10921153890,"JB"],];
CONWAYPOLDATA[74189]:=[
,,,[49535550168,"JB"],];
CONWAYPOLDATA[74197]:=[
,,,[37569205773,"JB"],];
CONWAYPOLDATA[74201]:=[
,,,[3463851088,"JB"],];
CONWAYPOLDATA[74203]:=[
,,,[15410033824,"JB"],];
CONWAYPOLDATA[74209]:=[
,,,[5407906685,"JB"],];
CONWAYPOLDATA[74219]:=[
,,,[25379558147,"JB"],];
CONWAYPOLDATA[74231]:=[
,,,[54394843729,"JB"],];
CONWAYPOLDATA[74257]:=[
,,,[181072724225,"JB"],];
CONWAYPOLDATA[74279]:=[
,,,[27586180701,"JB"],];
CONWAYPOLDATA[74287]:=[
,,,[27592494700,"JB"],];
CONWAYPOLDATA[74293]:=[
,,,[36473108253,"JB"],];
CONWAYPOLDATA[74297]:=[
,,,[30827459837,"JB"],];
CONWAYPOLDATA[74311]:=[
,,,[21739980306,"JB"],];
CONWAYPOLDATA[74317]:=[
,,,[36311955055,"JB"],];
CONWAYPOLDATA[74323]:=[
,,,[15950830650,"JB"],];
CONWAYPOLDATA[74353]:=[
,,,[58583992706,"JB"],];
CONWAYPOLDATA[74357]:=[
,,,[10361127453,"JB"],];
CONWAYPOLDATA[74363]:=[
,,,[48217564106,"JB"],];
CONWAYPOLDATA[74377]:=[
,,,[131551492429,"JB"],];
CONWAYPOLDATA[74381]:=[
,,,[9999335356,"JB"],];
CONWAYPOLDATA[74383]:=[
,,,[105122592968,"JB"],];
CONWAYPOLDATA[74411]:=[
,,,[43473212943,"JB"],];
CONWAYPOLDATA[74413]:=[
,,,[42649513303,"JB"],];
CONWAYPOLDATA[74419]:=[
,,,[48175511747,"JB"],];
CONWAYPOLDATA[74441]:=[
,,,[5540569192,"JB"],];
CONWAYPOLDATA[74449]:=[
,,,[80847147073,"JB"],];
CONWAYPOLDATA[74453]:=[
,,,[38255738274,"JB"],];
CONWAYPOLDATA[74471]:=[
,,,[30613464220,"JB"],];
CONWAYPOLDATA[74489]:=[
,,,[44126166268,"JB"],];
CONWAYPOLDATA[74507]:=[
,,,[42247778719,"JB"],];
CONWAYPOLDATA[74509]:=[
,,,[60468300515,"JB"],];
CONWAYPOLDATA[74521]:=[
,,,[60875757787,"JB"],];
CONWAYPOLDATA[74527]:=[
,,,[32011656840,"JB"],];
CONWAYPOLDATA[74531]:=[
,,,[42254307018,"JB"],];
CONWAYPOLDATA[74551]:=[
,,,[16132314554,"JB"],];
CONWAYPOLDATA[74561]:=[
,,,[5558447992,"JB"],];
CONWAYPOLDATA[74567]:=[
,,,[22240651693,"JB"],];
CONWAYPOLDATA[74573]:=[
,,,[37484491317,"JB"],];
CONWAYPOLDATA[74587]:=[
,,,[50033705472,"JB"],];
CONWAYPOLDATA[74597]:=[
,,,[20429358213,"JB"],];
CONWAYPOLDATA[74609]:=[
,,,[14714760028,"JB"],];
CONWAYPOLDATA[74611]:=[
,,,[14262713373,"JB"],];
CONWAYPOLDATA[74623]:=[
,,,[30795046528,"JB"],];
CONWAYPOLDATA[74653]:=[
,,,[19528552925,"JB"],];
CONWAYPOLDATA[74687]:=[
,,,[31504320971,"JB"],];
CONWAYPOLDATA[74699]:=[
,,,[43674339031,"JB"],];
CONWAYPOLDATA[74707]:=[
,,,[44451113244,"JB"],];
CONWAYPOLDATA[74713]:=[
,,,[92826494443,"JB"],];
CONWAYPOLDATA[74717]:=[
,,,[10643361935,"JB"],];
CONWAYPOLDATA[74719]:=[
,,,[3919758747,"JB"],];
CONWAYPOLDATA[74729]:=[
,,,[27207707968,"JB"],];
CONWAYPOLDATA[74731]:=[
,,,[31409588764,"JB"],];
CONWAYPOLDATA[74747]:=[
,,,[43024298455,"JB"],];
CONWAYPOLDATA[74759]:=[
,,,[21858709262,"JB"],];
CONWAYPOLDATA[74761]:=[
,,,[104918690287,"JB"],];
CONWAYPOLDATA[74771]:=[
,,,[26386386818,"JB"],];
CONWAYPOLDATA[74779]:=[
,,,[38424665699,"JB"],];
CONWAYPOLDATA[74797]:=[
,,,[44209739216,"JB"],];
CONWAYPOLDATA[74821]:=[
,,,[39186975009,"JB"],];
CONWAYPOLDATA[74827]:=[
,,,[31976944318,"JB"],];
CONWAYPOLDATA[74831]:=[
,,,[25852239732,"JB"],];
CONWAYPOLDATA[74843]:=[
,,,[44091957220,"JB"],];
CONWAYPOLDATA[74857]:=[
,,,[59213608716,"JB"],];
CONWAYPOLDATA[74861]:=[
,,,[10038860102,"JB"],];
CONWAYPOLDATA[74869]:=[
,,,[210644081240,"JB"],];
CONWAYPOLDATA[74873]:=[
,,,[26319282090,"JB"],];
CONWAYPOLDATA[74887]:=[
,,,[15874621150,"JB"],];
CONWAYPOLDATA[74891]:=[
,,,[53898753138,"JB"],];
CONWAYPOLDATA[74897]:=[
,,,[8963672963,"JB"],];
CONWAYPOLDATA[74903]:=[
,,,[22441538029,"JB"],];
CONWAYPOLDATA[74923]:=[
,,,[22453524029,"JB"],];
CONWAYPOLDATA[74929]:=[
,,,[151586162473,"JB"],];
CONWAYPOLDATA[74933]:=[
,,,[37960083673,"JB"],];
CONWAYPOLDATA[74941]:=[
,,,[47779608789,"JB"],];
CONWAYPOLDATA[74959]:=[
,,,[28093958572,"JB"],];
CONWAYPOLDATA[75011]:=[
,,,[45012450864,"JB"],];
CONWAYPOLDATA[75013]:=[
,,,[61397840450,"JB"],];
CONWAYPOLDATA[75017]:=[
,,,[48430825169,"JB"],];
CONWAYPOLDATA[75029]:=[
,,,[25744775801,"JB"],];
CONWAYPOLDATA[75037]:=[
,,,[60442903798,"JB"],];
CONWAYPOLDATA[75041]:=[
,,,[15819393213,"JB"],];
CONWAYPOLDATA[75079]:=[
,,,[20650328795,"JB"],];
CONWAYPOLDATA[75083]:=[
,,,[42370012649,"JB"],];
CONWAYPOLDATA[75109]:=[
,,,[44813334198,"JB"],];
CONWAYPOLDATA[75133]:=[
,,,[38605589392,"JB"],];
CONWAYPOLDATA[75149]:=[
,,,[4285221429,"JB"],];
CONWAYPOLDATA[75161]:=[
,,,[15595531698,"JB"],];
CONWAYPOLDATA[75167]:=[
,,,[33770127761,"JB"],];
CONWAYPOLDATA[75169]:=[
,,,[4444968484,"JB"],];
CONWAYPOLDATA[75181]:=[
,,,[38561312255,"JB"],];
CONWAYPOLDATA[75193]:=[
,,,[59979651475,"JB"],];
CONWAYPOLDATA[75209]:=[
,,,[5655491176,"JB"],];
CONWAYPOLDATA[75211]:=[
,,,[37995694670,"JB"],];
CONWAYPOLDATA[75217]:=[
,,,[135085820721,"JB"],];
CONWAYPOLDATA[75223]:=[
,,,[21817302808,"JB"],];
CONWAYPOLDATA[75227]:=[
,,,[14229638414,"JB"],];
CONWAYPOLDATA[75239]:=[
,,,[96163944020,"JB"],];
CONWAYPOLDATA[75253]:=[
,,,[20279027936,"JB"],];
CONWAYPOLDATA[75269]:=[
,,,[21604084727,"JB"],];
CONWAYPOLDATA[75277]:=[
,,,[38059524263,"JB"],];
CONWAYPOLDATA[75289]:=[
,,,[231518418220,"JB"],];
CONWAYPOLDATA[75307]:=[
,,,[39049089327,"JB"],];
CONWAYPOLDATA[75323]:=[
,,,[42707387772,"JB"],];
CONWAYPOLDATA[75329]:=[
,,,[5673554296,"JB"],];
CONWAYPOLDATA[75337]:=[
,,,[38508055533,"JB"],];
CONWAYPOLDATA[75347]:=[
,,,[66661977353,"JB"],];
CONWAYPOLDATA[75353]:=[
,,,[54832418925,"JB"],];
CONWAYPOLDATA[75367]:=[
,,,[32493050080,"JB"],];
CONWAYPOLDATA[75377]:=[
,,,[54730862818,"JB"],];
CONWAYPOLDATA[75389]:=[
,,,[20893835185,"JB"],];
CONWAYPOLDATA[75391]:=[
,,,[21797045923,"JB"],];
CONWAYPOLDATA[75401]:=[
,,,[44641463657,"JB"],];
CONWAYPOLDATA[75403]:=[
,,,[14979786192,"JB"],];
CONWAYPOLDATA[75407]:=[
,,,[22744560973,"JB"],];
CONWAYPOLDATA[75431]:=[
,,,[21921908101,"JB"],];
CONWAYPOLDATA[75437]:=[
,,,[21063217394,"JB"],];
CONWAYPOLDATA[75479]:=[
,,,[15524143344,"JB"],];
CONWAYPOLDATA[75503]:=[
,,,[22802510029,"JB"],];
CONWAYPOLDATA[75511]:=[
,,,[16230787409,"JB"],];
CONWAYPOLDATA[75521]:=[
,,,[27243143459,"JB"],];
CONWAYPOLDATA[75527]:=[
,,,[14414403482,"JB"],];
CONWAYPOLDATA[75533]:=[
,,,[21316092399,"JB"],];
CONWAYPOLDATA[75539]:=[
,,,[5366894874,"JB"],];
CONWAYPOLDATA[75541]:=[
,,,[38911773430,"JB"],];
CONWAYPOLDATA[75553]:=[
,,,[60825378162,"JB"],];
CONWAYPOLDATA[75557]:=[
,,,[8827022084,"JB"],];
CONWAYPOLDATA[75571]:=[
,,,[14529960601,"JB"],];
CONWAYPOLDATA[75577]:=[
,,,[102811927737,"JB"],];
CONWAYPOLDATA[75583]:=[
,,,[118604238941,"JB"],];
CONWAYPOLDATA[75611]:=[
,,,[21411825426,"JB"],];
CONWAYPOLDATA[75617]:=[
,,,[15203402789,"JB"],];
CONWAYPOLDATA[75619]:=[
,,,[31504312163,"JB"],];
CONWAYPOLDATA[75629]:=[
,,,[74273501435,"JB"],];
CONWAYPOLDATA[75641]:=[
,,,[17135258297,"JB"],];
CONWAYPOLDATA[75653]:=[
,,,[39128412479,"JB"],];
CONWAYPOLDATA[75659]:=[
,,,[16487987577,"JB"],];
CONWAYPOLDATA[75679]:=[
,,,[27543599093,"JB"],];
CONWAYPOLDATA[75683]:=[
,,,[14830537950,"JB"],];
CONWAYPOLDATA[75689]:=[
,,,[5727916456,"JB"],];
CONWAYPOLDATA[75703]:=[
,,,[55325644980,"JB"],];
CONWAYPOLDATA[75707]:=[
,,,[37784833753,"JB"],];
CONWAYPOLDATA[75709]:=[
,,,[73537665882,"JB"],];
CONWAYPOLDATA[75721]:=[
,,,[119867327384,"JB"],];
CONWAYPOLDATA[75731]:=[
,,,[112585415421,"JB"],];
CONWAYPOLDATA[75743]:=[
,,,[27717317682,"JB"],];
CONWAYPOLDATA[75767]:=[
,,,[43857046052,"JB"],];
CONWAYPOLDATA[75773]:=[
,,,[37674184056,"JB"],];
CONWAYPOLDATA[75781]:=[
,,,[51593902455,"JB"],];
CONWAYPOLDATA[75787]:=[
,,,[17082010870,"JB"],];
CONWAYPOLDATA[75793]:=[
,,,[49996170323,"JB"],];
CONWAYPOLDATA[75797]:=[
,,,[43189509587,"JB"],];
CONWAYPOLDATA[75821]:=[
,,,[3506721252,"JB"],];
CONWAYPOLDATA[75833]:=[
,,,[25934127673,"JB"],];
CONWAYPOLDATA[75853]:=[
,,,[9400158883,"JB"],];
CONWAYPOLDATA[75869]:=[
,,,[4369599188,"JB"],];
CONWAYPOLDATA[75883]:=[
,,,[43329648300,"JB"],];
CONWAYPOLDATA[75913]:=[
,,,[72929846844,"JB"],];
CONWAYPOLDATA[75931]:=[
,,,[20799551040,"JB"],];
CONWAYPOLDATA[75937]:=[
,,,[3265215073,"JB"],];
CONWAYPOLDATA[75941]:=[
,,,[21760893552,"JB"],];
CONWAYPOLDATA[75967]:=[
,,,[28854621580,"JB"],];
CONWAYPOLDATA[75979]:=[
,,,[49913568283,"JB"],];
CONWAYPOLDATA[75983]:=[
,,,[45475825505,"JB"],];
CONWAYPOLDATA[75989]:=[
,,,[5522956511,"JB"],];
CONWAYPOLDATA[75991]:=[
,,,[27768859204,"JB"],];
CONWAYPOLDATA[75997]:=[
,,,[39759046504,"JB"],];
CONWAYPOLDATA[76001]:=[
,,,[15643133831,"JB"],];
CONWAYPOLDATA[76003]:=[
,,,[32362685429,"JB"],];
CONWAYPOLDATA[76031]:=[
,,,[16264551527,"JB"],];
CONWAYPOLDATA[76039]:=[
,,,[21013909935,"JB"],];
CONWAYPOLDATA[76079]:=[
,,,[45664517786,"JB"],];
CONWAYPOLDATA[76081]:=[
,,,[3507866674,"JB"],];
CONWAYPOLDATA[76091]:=[
,,,[49983340901,"JB"],];
CONWAYPOLDATA[76099]:=[
,,,[39802059977,"JB"],];
CONWAYPOLDATA[76103]:=[
,,,[40176219662,"JB"],];
CONWAYPOLDATA[76123]:=[
,,,[22499903482,"JB"],];
CONWAYPOLDATA[76129]:=[
,,,[283982333879,"JB"],];
CONWAYPOLDATA[76147]:=[
,,,[49720183652,"JB"],];
CONWAYPOLDATA[76157]:=[
,,,[40523444330,"JB"],];
CONWAYPOLDATA[76159]:=[
,,,[39998402167,"JB"],];
CONWAYPOLDATA[76163]:=[
,,,[22315911328,"JB"],];
CONWAYPOLDATA[76207]:=[
,,,[34653380492,"JB"],];
CONWAYPOLDATA[76213]:=[
,,,[45686340133,"JB"],];
CONWAYPOLDATA[76231]:=[
,,,[27547596476,"JB"],];
CONWAYPOLDATA[76243]:=[
,,,[32342585575,"JB"],];
CONWAYPOLDATA[76249]:=[
,,,[4330180717,"JB"],];
CONWAYPOLDATA[76253]:=[
,,,[27804131392,"JB"],];
CONWAYPOLDATA[76259]:=[
,,,[45153030161,"JB"],];
CONWAYPOLDATA[76261]:=[
,,,[52341127264,"JB"],];
CONWAYPOLDATA[76283]:=[
,,,[45132531820,"JB"],];
CONWAYPOLDATA[76289]:=[
,,,[27443975996,"JB"],];
CONWAYPOLDATA[76303]:=[
,,,[52323332496,"JB"],];
CONWAYPOLDATA[76333]:=[
,,,[22263664450,"JB"],];
CONWAYPOLDATA[76343]:=[
,,,[4444078721,"JB"],];
CONWAYPOLDATA[76367]:=[
,,,[46038991460,"JB"],];
CONWAYPOLDATA[76369]:=[
,,,[69985620777,"JB"],];
CONWAYPOLDATA[76379]:=[
,,,[3106563069,"JB"],];
CONWAYPOLDATA[76387]:=[
,,,[16848069497,"JB"],];
CONWAYPOLDATA[76403]:=[
,,,[46033189517,"JB"],];
CONWAYPOLDATA[76421]:=[
,,,[40697010080,"JB"],];
CONWAYPOLDATA[76423]:=[
,,,[110967800888,"JB"],];
CONWAYPOLDATA[76441]:=[
,,,[138113981016,"JB"],];
CONWAYPOLDATA[76463]:=[
,,,[33368223816,"JB"],];
CONWAYPOLDATA[76471]:=[
,,,[21160290416,"JB"],];
CONWAYPOLDATA[76481]:=[
,,,[14725345819,"JB"],];
CONWAYPOLDATA[76487]:=[
,,,[15799384186,"JB"],];
CONWAYPOLDATA[76493]:=[
,,,[14980848080,"JB"],];
CONWAYPOLDATA[76507]:=[
,,,[52126437805,"JB"],];
CONWAYPOLDATA[76511]:=[
,,,[68531132240,"JB"],];
CONWAYPOLDATA[76519]:=[
,,,[39698057203,"JB"],];
CONWAYPOLDATA[76537]:=[
,,,[61865699012,"JB"],];
CONWAYPOLDATA[76541]:=[
,,,[52726186344,"JB"],];
CONWAYPOLDATA[76543]:=[
,,,[38261779042,"JB"],];
CONWAYPOLDATA[76561]:=[
,,,[120821373483,"JB"],];
CONWAYPOLDATA[76579]:=[
,,,[15590335729,"JB"],];
CONWAYPOLDATA[76597]:=[
,,,[61998454374,"JB"],];
CONWAYPOLDATA[76603]:=[
,,,[51452626439,"JB"],];
CONWAYPOLDATA[76607]:=[
,,,[46739156417,"JB"],];
CONWAYPOLDATA[76631]:=[
,,,[40636116580,"JB"],];
CONWAYPOLDATA[76649]:=[
,,,[4313652428,"JB"],];
CONWAYPOLDATA[76651]:=[
,,,[33375378423,"JB"],];
CONWAYPOLDATA[76667]:=[
,,,[45898539560,"JB"],];
CONWAYPOLDATA[76673]:=[
,,,[57997374028,"JB"],];
CONWAYPOLDATA[76679]:=[
,,,[27781415139,"JB"],];
CONWAYPOLDATA[76697]:=[
,,,[9784006202,"JB"],];
CONWAYPOLDATA[76717]:=[
,,,[56428038597,"JB"],];
CONWAYPOLDATA[76733]:=[
,,,[21964744519,"JB"],];
CONWAYPOLDATA[76753]:=[
,,,[38369054964,"JB"],];
CONWAYPOLDATA[76757]:=[
,,,[21476455088,"JB"],];
CONWAYPOLDATA[76771]:=[
,,,[52638803862,"JB"],];
CONWAYPOLDATA[76777]:=[
,,,[88419771393,"JB"],];
CONWAYPOLDATA[76781]:=[
,,,[58237083225,"JB"],];
CONWAYPOLDATA[76801]:=[
,,,[121716068041,"JB"],];
CONWAYPOLDATA[76819]:=[
,,,[52337168802,"JB"],];
CONWAYPOLDATA[76829]:=[
,,,[40146840294,"JB"],];
CONWAYPOLDATA[76831]:=[
,,,[16306841962,"JB"],];
CONWAYPOLDATA[76837]:=[
,,,[10527437375,"JB"],];
CONWAYPOLDATA[76847]:=[
,,,[57002107572,"JB"],];
CONWAYPOLDATA[76871]:=[
,,,[16319021468,"JB"],];
CONWAYPOLDATA[76873]:=[
,,,[134625455593,"JB"],];
CONWAYPOLDATA[76883]:=[
,,,[26848773730,"JB"],];
CONWAYPOLDATA[76907]:=[
,,,[45691525400,"JB"],];
CONWAYPOLDATA[76913]:=[
,,,[4035625113,"JB"],];
CONWAYPOLDATA[76919]:=[
,,,[21479323087,"JB"],];
CONWAYPOLDATA[76943]:=[
,,,[29019360232,"JB"],];
CONWAYPOLDATA[76949]:=[
,,,[11481945037,"JB"],];
CONWAYPOLDATA[76961]:=[
,,,[5922071992,"JB"],];
CONWAYPOLDATA[76963]:=[
,,,[46657664308,"JB"],];
CONWAYPOLDATA[76991]:=[
,,,[27975603755,"JB"],];
CONWAYPOLDATA[77003]:=[
,,,[16149454177,"JB"],];
CONWAYPOLDATA[77017]:=[
,,,[64272072813,"JB"],];
CONWAYPOLDATA[77023]:=[
,,,[41425280093,"JB"],];
CONWAYPOLDATA[77029]:=[
,,,[4478928236,"JB"],];
CONWAYPOLDATA[77041]:=[
,,,[4633014624,"JB"],];
CONWAYPOLDATA[77047]:=[
,,,[22528388709,"JB"],];
CONWAYPOLDATA[77069]:=[
,,,[11764043369,"JB"],];
CONWAYPOLDATA[77081]:=[
,,,[5940555592,"JB"],];
CONWAYPOLDATA[77093]:=[
,,,[29397719506,"JB"],];
CONWAYPOLDATA[77101]:=[
,,,[26862296811,"JB"],];
CONWAYPOLDATA[77137]:=[
,,,[29297635394,"JB"],];
CONWAYPOLDATA[77141]:=[
,,,[29753360844,"JB"],];
CONWAYPOLDATA[77153]:=[
,,,[3582908170,"JB"],];
CONWAYPOLDATA[77167]:=[
,,,[74507825201,"JB"],];
CONWAYPOLDATA[77171]:=[
,,,[28082141047,"JB"],];
CONWAYPOLDATA[77191]:=[
,,,[64993664141,"JB"],];
CONWAYPOLDATA[77201]:=[
,,,[16570808648,"JB"],];
CONWAYPOLDATA[77213]:=[
,,,[27078753528,"JB"],];
CONWAYPOLDATA[77237]:=[
,,,[22298630850,"JB"],];
CONWAYPOLDATA[77239]:=[
,,,[16644618308,"JB"],];
CONWAYPOLDATA[77243]:=[
,,,[16013323575,"JB"],];
CONWAYPOLDATA[77249]:=[
,,,[27893764164,"JB"],];
CONWAYPOLDATA[77261]:=[
,,,[118004124786,"JB"],];
CONWAYPOLDATA[77263]:=[
,,,[71633926877,"JB"],];
CONWAYPOLDATA[77267]:=[
,,,[46459488097,"JB"],];
CONWAYPOLDATA[77269]:=[
,,,[59435855685,"JB"],];
CONWAYPOLDATA[77279]:=[
,,,[34206931129,"JB"],];
CONWAYPOLDATA[77291]:=[
,,,[5060473645,"JB"],];
CONWAYPOLDATA[77317]:=[
,,,[118766411751,"JB"],];
CONWAYPOLDATA[77323]:=[
,,,[52394451417,"JB"],];
CONWAYPOLDATA[77339]:=[
,,,[27896796014,"JB"],];
CONWAYPOLDATA[77347]:=[
,,,[16857159877,"JB"],];
CONWAYPOLDATA[77351]:=[
,,,[44941008365,"JB"],];
CONWAYPOLDATA[77359]:=[
,,,[16263569368,"JB"],];
CONWAYPOLDATA[77369]:=[
,,,[45151387868,"JB"],];
CONWAYPOLDATA[77377]:=[
,,,[65618558954,"JB"],];
CONWAYPOLDATA[77383]:=[
,,,[23122427318,"JB"],];
CONWAYPOLDATA[77417]:=[
,,,[58353373421,"JB"],];
CONWAYPOLDATA[77419]:=[
,,,[15708934454,"JB"],];
CONWAYPOLDATA[77431]:=[
,,,[15385462272,"JB"],];
CONWAYPOLDATA[77447]:=[
,,,[29061909308,"JB"],];
CONWAYPOLDATA[77471]:=[
,,,[21447923828,"JB"],];
CONWAYPOLDATA[77477]:=[
,,,[29404225996,"JB"],];
CONWAYPOLDATA[77479]:=[
,,,[34980993716,"JB"],];
CONWAYPOLDATA[77489]:=[
,,,[23336742221,"JB"],];
CONWAYPOLDATA[77491]:=[
,,,[15663488306,"JB"],];
CONWAYPOLDATA[77509]:=[
,,,[45623037546,"JB"],];
CONWAYPOLDATA[77513]:=[
,,,[11456266377,"JB"],];
CONWAYPOLDATA[77521]:=[
,,,[4734595082,"JB"],];
CONWAYPOLDATA[77527]:=[
,,,[63183574681,"JB"],];
CONWAYPOLDATA[77543]:=[
,,,[24051357229,"JB"],];
CONWAYPOLDATA[77549]:=[
,,,[10512154697,"JB"],];
CONWAYPOLDATA[77551]:=[
,,,[22080708481,"JB"],];
CONWAYPOLDATA[77557]:=[
,,,[39352034020,"JB"],];
CONWAYPOLDATA[77563]:=[
,,,[64530244238,"JB"],];
CONWAYPOLDATA[77569]:=[
,,,[6013924583,"JB"],];
CONWAYPOLDATA[77573]:=[
,,,[10118079111,"JB"],];
CONWAYPOLDATA[77587]:=[
,,,[15967714950,"JB"],];
CONWAYPOLDATA[77591]:=[
,,,[39151099566,"JB"],];
CONWAYPOLDATA[77611]:=[
,,,[53928469018,"JB"],];
CONWAYPOLDATA[77617]:=[
,,,[40710892680,"JB"],];
CONWAYPOLDATA[77621]:=[
,,,[54224633424,"JB"],];
CONWAYPOLDATA[77641]:=[
,,,[259094849421,"JB"],];
CONWAYPOLDATA[77647]:=[
,,,[40857230227,"JB"],];
CONWAYPOLDATA[77659]:=[
,,,[53921361767,"JB"],];
CONWAYPOLDATA[77681]:=[
,,,[6033405592,"JB"],];
CONWAYPOLDATA[77687]:=[
,,,[22262608221,"JB"],];
CONWAYPOLDATA[77689]:=[
,,,[53134381607,"JB"],];
CONWAYPOLDATA[77699]:=[
,,,[58414418998,"JB"],];
CONWAYPOLDATA[77711]:=[
,,,[47407051587,"JB"],];
CONWAYPOLDATA[77713]:=[
,,,[75861099217,"JB"],];
CONWAYPOLDATA[77719]:=[
,,,[54258276352,"JB"],];
CONWAYPOLDATA[77723]:=[
,,,[52881174742,"JB"],];
CONWAYPOLDATA[77731]:=[
,,,[16277493250,"JB"],];
CONWAYPOLDATA[77743]:=[
,,,[15546034484,"JB"],];
CONWAYPOLDATA[77747]:=[
,,,[54400819854,"JB"],];
CONWAYPOLDATA[77761]:=[
,,,[99796056820,"JB"],];
CONWAYPOLDATA[77773]:=[
,,,[41363258960,"JB"],];
CONWAYPOLDATA[77783]:=[
,,,[36157271989,"JB"],];
CONWAYPOLDATA[77797]:=[
,,,[63918326393,"JB"],];
CONWAYPOLDATA[77801]:=[
,,,[84740538003,"JB"],];
CONWAYPOLDATA[77813]:=[
,,,[46031992038,"JB"],];
CONWAYPOLDATA[77839]:=[
,,,[39466318978,"JB"],];
CONWAYPOLDATA[77849]:=[
,,,[82958307722,"JB"],];
CONWAYPOLDATA[77863]:=[
,,,[24250275629,"JB"],];
CONWAYPOLDATA[77867]:=[
,,,[15339643268,"JB"],];
CONWAYPOLDATA[77893]:=[
,,,[63843050127,"JB"],];
CONWAYPOLDATA[77899]:=[
,,,[18044991768,"JB"],];
CONWAYPOLDATA[77929]:=[
,,,[58382224802,"JB"],];
CONWAYPOLDATA[77933]:=[
,,,[17416856507,"JB"],];
CONWAYPOLDATA[77951]:=[
,,,[40820834034,"JB"],];
CONWAYPOLDATA[77969]:=[
,,,[17656158022,"JB"],];
CONWAYPOLDATA[77977]:=[
,,,[64143880205,"JB"],];
CONWAYPOLDATA[77983]:=[
,,,[40739254999,"JB"],];
CONWAYPOLDATA[77999]:=[
,,,[47221842595,"JB"],];
CONWAYPOLDATA[78007]:=[
,,,[36448926767,"JB"],];
CONWAYPOLDATA[78017]:=[
,,,[10306357771,"JB"],];
CONWAYPOLDATA[78031]:=[
,,,[4773936587,"JB"],];
CONWAYPOLDATA[78041]:=[
,,,[29802687288,"JB"],];
CONWAYPOLDATA[78049]:=[
,,,[3644263915,"JB"],];
CONWAYPOLDATA[78059]:=[
,,,[21729986363,"JB"],];
CONWAYPOLDATA[78079]:=[
,,,[33670787972,"JB"],];
CONWAYPOLDATA[78101]:=[
,,,[42253187709,"JB"],];
CONWAYPOLDATA[78121]:=[
,,,[102868404754,"JB"],];
CONWAYPOLDATA[78137]:=[
,,,[17959945727,"JB"],];
CONWAYPOLDATA[78139]:=[
,,,[48776551695,"JB"],];
CONWAYPOLDATA[78157]:=[
,,,[52589891381,"JB"],];
CONWAYPOLDATA[78163]:=[
,,,[18199082108,"JB"],];
CONWAYPOLDATA[78167]:=[
,,,[40157358251,"JB"],];
CONWAYPOLDATA[78173]:=[
,,,[4474388003,"JB"],];
CONWAYPOLDATA[78179]:=[
,,,[16514453783,"JB"],];
CONWAYPOLDATA[78191]:=[
,,,[41302519177,"JB"],];
CONWAYPOLDATA[78193]:=[
,,,[40305051013,"JB"],];
CONWAYPOLDATA[78203]:=[
,,,[18293558574,"JB"],];
CONWAYPOLDATA[78229]:=[
,,,[95457842046,"JB"],];
CONWAYPOLDATA[78233]:=[
,,,[17948918960,"JB"],];
CONWAYPOLDATA[78241]:=[
,,,[250751060074,"JB"],];
CONWAYPOLDATA[78259]:=[
,,,[10598538113,"JB"],];
CONWAYPOLDATA[78277]:=[
,,,[49017527068,"JB"],];
CONWAYPOLDATA[78283]:=[
,,,[34329678842,"JB"],];
CONWAYPOLDATA[78301]:=[
,,,[65159038467,"JB"],];
CONWAYPOLDATA[78307]:=[
,,,[72511890467,"JB"],];
CONWAYPOLDATA[78311]:=[
,,,[15917415563,"JB"],];
CONWAYPOLDATA[78317]:=[
,,,[46508707086,"JB"],];
CONWAYPOLDATA[78341]:=[
,,,[53586889163,"JB"],];
CONWAYPOLDATA[78347]:=[
,,,[17416773143,"JB"],];
CONWAYPOLDATA[78367]:=[
,,,[73695699869,"JB"],];
CONWAYPOLDATA[78401]:=[
,,,[6097637788,"JB"],];
CONWAYPOLDATA[78427]:=[
,,,[46919423315,"JB"],];
CONWAYPOLDATA[78437]:=[
,,,[46732686165,"JB"],];
CONWAYPOLDATA[78439]:=[
,,,[64645658734,"JB"],];
CONWAYPOLDATA[78467]:=[
,,,[23623902758,"JB"],];
CONWAYPOLDATA[78479]:=[
,,,[17688146380,"JB"],];
CONWAYPOLDATA[78487]:=[
,,,[36650289523,"JB"],];
CONWAYPOLDATA[78497]:=[
,,,[84326422714,"JB"],];
CONWAYPOLDATA[78509]:=[
,,,[30818001372,"JB"],];
CONWAYPOLDATA[78511]:=[
,,,[21782327376,"JB"],];
CONWAYPOLDATA[78517]:=[
,,,[55483723984,"JB"],];
CONWAYPOLDATA[78539]:=[
,,,[55514820918,"JB"],];
CONWAYPOLDATA[78541]:=[
,,,[66721836158,"JB"],];
CONWAYPOLDATA[78553]:=[
,,,[92557743057,"JB"],];
CONWAYPOLDATA[78569]:=[
,,,[28786974482,"JB"],];
CONWAYPOLDATA[78571]:=[
,,,[12009184497,"JB"],];
CONWAYPOLDATA[78577]:=[
,,,[73214669794,"JB"],];
CONWAYPOLDATA[78583]:=[
,,,[34045770421,"JB"],];
CONWAYPOLDATA[78593]:=[
,,,[79194000674,"JB"],];
CONWAYPOLDATA[78607]:=[
,,,[42421761086,"JB"],];
CONWAYPOLDATA[78623]:=[
,,,[48987553992,"JB"],];
CONWAYPOLDATA[78643]:=[
,,,[17513638825,"JB"],];
CONWAYPOLDATA[78649]:=[
,,,[79049873964,"JB"],];
CONWAYPOLDATA[78653]:=[
,,,[71588623502,"JB"],];
CONWAYPOLDATA[78691]:=[
,,,[42145955315,"JB"],];
CONWAYPOLDATA[78697]:=[
,,,[42810853217,"JB"],];
CONWAYPOLDATA[78707]:=[
,,,[46587302958,"JB"],];
CONWAYPOLDATA[78713]:=[
,,,[53554593517,"JB"],];
CONWAYPOLDATA[78721]:=[
,,,[3559291301,"JB"],];
CONWAYPOLDATA[78737]:=[
,,,[60579775381,"JB"],];
CONWAYPOLDATA[78779]:=[
,,,[48244495939,"JB"],];
CONWAYPOLDATA[78781]:=[
,,,[15937553872,"JB"],];
CONWAYPOLDATA[78787]:=[
,,,[55621258392,"JB"],];
CONWAYPOLDATA[78791]:=[
,,,[21797136206,"JB"],];
CONWAYPOLDATA[78797]:=[
,,,[30183900025,"JB"],];
CONWAYPOLDATA[78803]:=[
,,,[49038161266,"JB"],];
CONWAYPOLDATA[78809]:=[
,,,[5091455448,"JB"],];
CONWAYPOLDATA[78823]:=[
,,,[16877817232,"JB"],];
CONWAYPOLDATA[78839]:=[
,,,[46928205212,"JB"],];
CONWAYPOLDATA[78853]:=[
,,,[41319523976,"JB"],];
CONWAYPOLDATA[78857]:=[
,,,[24654483339,"JB"],];
CONWAYPOLDATA[78877]:=[
,,,[43352928881,"JB"],];
CONWAYPOLDATA[78887]:=[
,,,[66797567255,"JB"],];
CONWAYPOLDATA[78889]:=[
,,,[66982441019,"JB"],];
CONWAYPOLDATA[78893]:=[
,,,[42032691435,"JB"],];
CONWAYPOLDATA[78901]:=[
,,,[35923783112,"JB"],];
CONWAYPOLDATA[78919]:=[
,,,[24570089030,"JB"],];
CONWAYPOLDATA[78929]:=[
,,,[12108261106,"JB"],];
CONWAYPOLDATA[78941]:=[
,,,[5689751518,"JB"],];
CONWAYPOLDATA[78977]:=[
,,,[30804978853,"JB"],];
CONWAYPOLDATA[78979]:=[
,,,[42186474895,"JB"],];
CONWAYPOLDATA[78989]:=[
,,,[5154190230,"JB"],];
CONWAYPOLDATA[79031]:=[
,,,[35403912232,"JB"],];
CONWAYPOLDATA[79039]:=[
,,,[16200228641,"JB"],];
CONWAYPOLDATA[79043]:=[
,,,[30936718815,"JB"],];
CONWAYPOLDATA[79063]:=[
,,,[25003515629,"JB"],];
CONWAYPOLDATA[79087]:=[
,,,[103812838770,"JB"],];
CONWAYPOLDATA[79103]:=[
,,,[35493516105,"JB"],];
CONWAYPOLDATA[79111]:=[
,,,[17116772410,"JB"],];
CONWAYPOLDATA[79133]:=[
,,,[9580948844,"JB"],];
CONWAYPOLDATA[79139]:=[
,,,[56048851389,"JB"],];
CONWAYPOLDATA[79147]:=[
,,,[56377674454,"JB"],];
CONWAYPOLDATA[79151]:=[
,,,[17904193666,"JB"],];
CONWAYPOLDATA[79153]:=[
,,,[161970229839,"JB"],];
CONWAYPOLDATA[79159]:=[
,,,[31330419772,"JB"],];
CONWAYPOLDATA[79181]:=[
,,,[43088716582,"JB"],];
CONWAYPOLDATA[79187]:=[
,,,[10862793478,"JB"],];
CONWAYPOLDATA[79193]:=[
,,,[99848672614,"JB"],];
CONWAYPOLDATA[79201]:=[
,,,[104904734151,"JB"],];
CONWAYPOLDATA[79229]:=[
,,,[23420963921,"JB"],];
CONWAYPOLDATA[79231]:=[
,,,[31387439884,"JB"],];
CONWAYPOLDATA[79241]:=[
,,,[18735187356,"JB"],];
CONWAYPOLDATA[79259]:=[
,,,[85213887190,"JB"],];
CONWAYPOLDATA[79273]:=[
,,,[94262255937,"JB"],];
CONWAYPOLDATA[79279]:=[
,,,[41861690373,"JB"],];
CONWAYPOLDATA[79283]:=[
,,,[29928777521,"JB"],];
CONWAYPOLDATA[79301]:=[
,,,[23206882545,"JB"],];
CONWAYPOLDATA[79309]:=[
,,,[66556985201,"JB"],];
CONWAYPOLDATA[79319]:=[
,,,[16150696830,"JB"],];
CONWAYPOLDATA[79333]:=[
,,,[42649579471,"JB"],];
CONWAYPOLDATA[79337]:=[
,,,[4786163202,"JB"],];
CONWAYPOLDATA[79349]:=[
,,,[42551297997,"JB"],];
CONWAYPOLDATA[79357]:=[
,,,[49258715118,"JB"],];
CONWAYPOLDATA[79367]:=[
,,,[75588495869,"JB"],];
CONWAYPOLDATA[79379]:=[
,,,[18864339973,"JB"],];
CONWAYPOLDATA[79393]:=[
,,,[106924904545,"JB"],];
CONWAYPOLDATA[79397]:=[
,,,[24636015735,"JB"],];
CONWAYPOLDATA[79399]:=[
,,,[43193214801,"JB"],];
CONWAYPOLDATA[79411]:=[
,,,[56754406414,"JB"],];
CONWAYPOLDATA[79423]:=[
,,,[41783169535,"JB"],];
CONWAYPOLDATA[79427]:=[
,,,[31338081706,"JB"],];
CONWAYPOLDATA[79433]:=[
,,,[294888419564,"JB"],];
CONWAYPOLDATA[79451]:=[
,,,[41430200662,"JB"],];
CONWAYPOLDATA[79481]:=[
,,,[3718915996,"JB"],];
CONWAYPOLDATA[79493]:=[
,,,[23435569814,"JB"],];
CONWAYPOLDATA[79531]:=[
,,,[54137149357,"JB"],];
CONWAYPOLDATA[79537]:=[
,,,[132610369830,"JB"],];
CONWAYPOLDATA[79549]:=[
,,,[50258421810,"JB"],];
CONWAYPOLDATA[79559]:=[
,,,[49719203672,"JB"],];
CONWAYPOLDATA[79561]:=[
,,,[6138210718,"JB"],];
CONWAYPOLDATA[79579]:=[
,,,[36512038895,"JB"],];
CONWAYPOLDATA[79589]:=[
,,,[10540607984,"JB"],];
CONWAYPOLDATA[79601]:=[
,,,[15865912121,"JB"],];
CONWAYPOLDATA[79609]:=[
,,,[56472315953,"JB"],];
CONWAYPOLDATA[79613]:=[
,,,[81078516106,"JB"],];
CONWAYPOLDATA[79621]:=[
,,,[63344795561,"JB"],];
CONWAYPOLDATA[79627]:=[
,,,[25311591882,"JB"],];
CONWAYPOLDATA[79631]:=[
,,,[38045621407,"JB"],];
CONWAYPOLDATA[79633]:=[
,,,[41629424891,"JB"],];
CONWAYPOLDATA[79657]:=[
,,,[149449755067,"JB"],];
CONWAYPOLDATA[79669]:=[
,,,[22574290829,"JB"],];
CONWAYPOLDATA[79687]:=[
,,,[41933929074,"JB"],];
CONWAYPOLDATA[79691]:=[
,,,[10307473023,"JB"],];
CONWAYPOLDATA[79693]:=[
,,,[47860906243,"JB"],];
CONWAYPOLDATA[79697]:=[
,,,[29230149905,"JB"],];
CONWAYPOLDATA[79699]:=[
,,,[55438544703,"JB"],];
CONWAYPOLDATA[79757]:=[
,,,[23214231936,"JB"],];
CONWAYPOLDATA[79769]:=[
,,,[6362136136,"JB"],];
CONWAYPOLDATA[79777]:=[
,,,[44189357852,"JB"],];
CONWAYPOLDATA[79801]:=[
,,,[156454089976,"JB"],];
CONWAYPOLDATA[79811]:=[
,,,[57107244643,"JB"],];
CONWAYPOLDATA[79813]:=[
,,,[60615020421,"JB"],];
CONWAYPOLDATA[79817]:=[
,,,[12571257320,"JB"],];
CONWAYPOLDATA[79823]:=[
,,,[55650520207,"JB"],];
CONWAYPOLDATA[79829]:=[
,,,[16580004328,"JB"],];
CONWAYPOLDATA[79841]:=[
,,,[55745225726,"JB"],];
CONWAYPOLDATA[79843]:=[
,,,[54334199461,"JB"],];
CONWAYPOLDATA[79847]:=[
,,,[44129360883,"JB"],];
CONWAYPOLDATA[79861]:=[
,,,[47874034089,"JB"],];
CONWAYPOLDATA[79867]:=[
,,,[54938273026,"JB"],];
CONWAYPOLDATA[79873]:=[
,,,[81308717182,"JB"],];
CONWAYPOLDATA[79889]:=[
,,,[49416938733,"JB"],];
CONWAYPOLDATA[79901]:=[
,,,[23209722383,"JB"],];
CONWAYPOLDATA[79903]:=[
,,,[22858650243,"JB"],];
CONWAYPOLDATA[79907]:=[
,,,[56727976977,"JB"],];
CONWAYPOLDATA[79939]:=[
,,,[41711290874,"JB"],];
CONWAYPOLDATA[79943]:=[
,,,[16525657079,"JB"],];
CONWAYPOLDATA[79967]:=[
,,,[16084722319,"JB"],];
CONWAYPOLDATA[79973]:=[
,,,[43630629693,"JB"],];
CONWAYPOLDATA[79979]:=[
,,,[24618975824,"JB"],];
CONWAYPOLDATA[79987]:=[
,,,[49152171476,"JB"],];
CONWAYPOLDATA[79997]:=[
,,,[42868632368,"JB"],];
CONWAYPOLDATA[79999]:=[
,,,[17959775503,"JB"],];
CONWAYPOLDATA[80021]:=[
,,,[81927660369,"JB"],];
CONWAYPOLDATA[80039]:=[
,,,[23347136194,"JB"],];
CONWAYPOLDATA[80051]:=[
,,,[18607534748,"JB"],];
CONWAYPOLDATA[80071]:=[
,,,[16861751538,"JB"],];
CONWAYPOLDATA[80077]:=[
,,,[42410620973,"JB"],];
CONWAYPOLDATA[80107]:=[
,,,[67409880288,"JB"],];
CONWAYPOLDATA[80111]:=[
,,,[16456802186,"JB"],];
CONWAYPOLDATA[80141]:=[
,,,[25630293917,"JB"],];
CONWAYPOLDATA[80147]:=[
,,,[54659051797,"JB"],];
CONWAYPOLDATA[80149]:=[
,,,[18497106822,"JB"],];
CONWAYPOLDATA[80153]:=[
,,,[42840736514,"JB"],];
CONWAYPOLDATA[80167]:=[
,,,[18106278122,"JB"],];
CONWAYPOLDATA[80173]:=[
,,,[29186740137,"JB"],];
CONWAYPOLDATA[80177]:=[
,,,[18588636568,"JB"],];
CONWAYPOLDATA[80191]:=[
,,,[16998006090,"JB"],];
CONWAYPOLDATA[80207]:=[
,,,[17669201070,"JB"],];
CONWAYPOLDATA[80209]:=[
,,,[81128676408,"JB"],];
CONWAYPOLDATA[80221]:=[
,,,[81786673259,"JB"],];
CONWAYPOLDATA[80231]:=[
,,,[17789619637,"JB"],];
CONWAYPOLDATA[80233]:=[
,,,[89492048673,"JB"],];
CONWAYPOLDATA[80239]:=[
,,,[23840852400,"JB"],];
CONWAYPOLDATA[80251]:=[
,,,[19202539533,"JB"],];
CONWAYPOLDATA[80263]:=[
,,,[16756024935,"JB"],];
CONWAYPOLDATA[80273]:=[
,,,[5310460318,"JB"],];
CONWAYPOLDATA[80279]:=[
,,,[36296945676,"JB"],];
CONWAYPOLDATA[80287]:=[
,,,[24234550666,"JB"],];
CONWAYPOLDATA[80309]:=[
,,,[29320735593,"JB"],];
CONWAYPOLDATA[80317]:=[
,,,[24481906674,"JB"],];
CONWAYPOLDATA[80329]:=[
,,,[81561246871,"JB"],];
CONWAYPOLDATA[80341]:=[
,,,[88680476143,"JB"],];
CONWAYPOLDATA[80347]:=[
,,,[68750678186,"JB"],];
CONWAYPOLDATA[80363]:=[
,,,[58123343382,"JB"],];
CONWAYPOLDATA[80369]:=[
,,,[6458211736,"JB"],];
CONWAYPOLDATA[80387]:=[
,,,[75682591988,"JB"],];
CONWAYPOLDATA[80407]:=[
,,,[37847494496,"JB"],];
CONWAYPOLDATA[80429]:=[
,,,[22729959263,"JB"],];
CONWAYPOLDATA[80447]:=[
,,,[43075507049,"JB"],];
CONWAYPOLDATA[80449]:=[
,,,[108959803811,"JB"],];
CONWAYPOLDATA[80471]:=[
,,,[31675799747,"JB"],];
CONWAYPOLDATA[80473]:=[
,,,[83733041708,"JB"],];
CONWAYPOLDATA[80489]:=[
,,,[18736068445,"JB"],];
CONWAYPOLDATA[80491]:=[
,,,[45016765009,"JB"],];
CONWAYPOLDATA[80513]:=[
,,,[89528282152,"JB"],];
CONWAYPOLDATA[80527]:=[
,,,[18105368575,"JB"],];
CONWAYPOLDATA[80537]:=[
,,,[50863706112,"JB"],];
CONWAYPOLDATA[80557]:=[
,,,[43132634512,"JB"],];
CONWAYPOLDATA[80567]:=[
,,,[71280444750,"JB"],];
CONWAYPOLDATA[80599]:=[
,,,[16650302621,"JB"],];
CONWAYPOLDATA[80603]:=[
,,,[16403516532,"JB"],];
CONWAYPOLDATA[80611]:=[
,,,[45097179064,"JB"],];
CONWAYPOLDATA[80621]:=[
,,,[44266330609,"JB"],];
CONWAYPOLDATA[80627]:=[
,,,[49063142042,"JB"],];
CONWAYPOLDATA[80629]:=[
,,,[23427078468,"JB"],];
CONWAYPOLDATA[80651]:=[
,,,[56744188629,"JB"],];
CONWAYPOLDATA[80657]:=[
,,,[12767599818,"JB"],];
CONWAYPOLDATA[80669]:=[
,,,[117001188236,"JB"],];
CONWAYPOLDATA[80671]:=[
,,,[18898875844,"JB"],];
CONWAYPOLDATA[80677]:=[
,,,[44671580995,"JB"],];
CONWAYPOLDATA[80681]:=[
,,,[50587551770,"JB"],];
CONWAYPOLDATA[80683]:=[
,,,[24308577658,"JB"],];
CONWAYPOLDATA[80687]:=[
,,,[24910820263,"JB"],];
CONWAYPOLDATA[80701]:=[
,,,[51001982889,"JB"],];
CONWAYPOLDATA[80713]:=[
,,,[122755029584,"JB"],];
CONWAYPOLDATA[80737]:=[
,,,[122466725827,"JB"],];
CONWAYPOLDATA[80747]:=[
,,,[50496670645,"JB"],];
CONWAYPOLDATA[80749]:=[
,,,[84025229179,"JB"],];
CONWAYPOLDATA[80761]:=[
,,,[187179123623,"JB"],];
CONWAYPOLDATA[80777]:=[
,,,[11135513338,"JB"],];
CONWAYPOLDATA[80779]:=[
,,,[16420189669,"JB"],];
CONWAYPOLDATA[80783]:=[
,,,[19175379932,"JB"],];
CONWAYPOLDATA[80789]:=[
,,,[43928857174,"JB"],];
CONWAYPOLDATA[80803]:=[
,,,[91212850492,"JB"],];
CONWAYPOLDATA[80809]:=[
,,,[280001972884,"JB"],];
CONWAYPOLDATA[80819]:=[
,,,[51647543590,"JB"],];
CONWAYPOLDATA[80831]:=[
,,,[24718523962,"JB"],];
CONWAYPOLDATA[80833]:=[
,,,[136866435605,"JB"],];
CONWAYPOLDATA[80849]:=[
,,,[6535590616,"JB"],];
CONWAYPOLDATA[80863]:=[
,,,[37481132585,"JB"],];
CONWAYPOLDATA[80897]:=[
,,,[10148528653,"JB"],];
CONWAYPOLDATA[80909]:=[
,,,[32050563081,"JB"],];
CONWAYPOLDATA[80911]:=[
,,,[44617238199,"JB"],];
CONWAYPOLDATA[80917]:=[
,,,[56255925916,"JB"],];
CONWAYPOLDATA[80923]:=[
,,,[51917607266,"JB"],];
CONWAYPOLDATA[80929]:=[
,,,[4596767219,"JB"],];
CONWAYPOLDATA[80933]:=[
,,,[23881871508,"JB"],];
CONWAYPOLDATA[80953]:=[
,,,[58371970187,"JB"],];
CONWAYPOLDATA[80963]:=[
,,,[38812852575,"JB"],];
CONWAYPOLDATA[80989]:=[
,,,[24251103195,"JB"],];
CONWAYPOLDATA[81001]:=[
,,,[97551772339,"JB"],];
CONWAYPOLDATA[81013]:=[
,,,[129796679229,"JB"],];
CONWAYPOLDATA[81017]:=[
,,,[117230950867,"JB"],];
CONWAYPOLDATA[81019]:=[
,,,[19050240529,"JB"],];
CONWAYPOLDATA[81023]:=[
,,,[58652306636,"JB"],];
CONWAYPOLDATA[81031]:=[
,,,[71049196271,"JB"],];
CONWAYPOLDATA[81041]:=[
,,,[38976101669,"JB"],];
CONWAYPOLDATA[81043]:=[
,,,[19540763993,"JB"],];
CONWAYPOLDATA[81047]:=[
,,,[110275952179,"JB"],];
CONWAYPOLDATA[81049]:=[
,,,[151084089299,"JB"],];
CONWAYPOLDATA[81071]:=[
,,,[43012137986,"JB"],];
CONWAYPOLDATA[81077]:=[
,,,[26017852533,"JB"],];
CONWAYPOLDATA[81083]:=[
,,,[96884698291,"JB"],];
CONWAYPOLDATA[81097]:=[
,,,[69217668154,"JB"],];
CONWAYPOLDATA[81101]:=[
,,,[11135978312,"JB"],];
CONWAYPOLDATA[81119]:=[
,,,[25397304364,"JB"],];
CONWAYPOLDATA[81131]:=[
,,,[49646736225,"JB"],];
CONWAYPOLDATA[81157]:=[
,,,[65456204472,"JB"],];
CONWAYPOLDATA[81163]:=[
,,,[16986523109,"JB"],];
CONWAYPOLDATA[81173]:=[
,,,[39040479044,"JB"],];
CONWAYPOLDATA[81181]:=[
,,,[77696630305,"JB"],];
CONWAYPOLDATA[81197]:=[
,,,[44606708710,"JB"],];
CONWAYPOLDATA[81199]:=[
,,,[24514708897,"JB"],];
CONWAYPOLDATA[81203]:=[
,,,[59344776462,"JB"],];
CONWAYPOLDATA[81223]:=[
,,,[79165134077,"JB"],];
CONWAYPOLDATA[81233]:=[
,,,[78441834123,"JB"],];
CONWAYPOLDATA[81239]:=[
,,,[17366054842,"JB"],];
CONWAYPOLDATA[81281]:=[
,,,[51346914604,"JB"],];
CONWAYPOLDATA[81283]:=[
,,,[51228935884,"JB"],];
CONWAYPOLDATA[81293]:=[
,,,[65356970626,"JB"],];
CONWAYPOLDATA[81299]:=[
,,,[25509431129,"JB"],];
CONWAYPOLDATA[81307]:=[
,,,[59000749780,"JB"],];
CONWAYPOLDATA[81331]:=[
,,,[44918623326,"JB"],];
CONWAYPOLDATA[81343]:=[
,,,[26360419301,"JB"],];
CONWAYPOLDATA[81349]:=[
,,,[83320086272,"JB"],];
CONWAYPOLDATA[81353]:=[
,,,[11989642437,"JB"],];
CONWAYPOLDATA[81359]:=[
,,,[16658906133,"JB"],];
CONWAYPOLDATA[81371]:=[
,,,[17122492677,"JB"],];
CONWAYPOLDATA[81373]:=[
,,,[50387382197,"JB"],];
CONWAYPOLDATA[81401]:=[
,,,[19826434568,"JB"],];
CONWAYPOLDATA[81409]:=[
,,,[46193501832,"JB"],];
CONWAYPOLDATA[81421]:=[
,,,[211065622786,"JB"],];
CONWAYPOLDATA[81439]:=[
,,,[17973424425,"JB"],];
CONWAYPOLDATA[81457]:=[
,,,[99527746713,"JB"],];
CONWAYPOLDATA[81463]:=[
,,,[16858442003,"JB"],];
CONWAYPOLDATA[81509]:=[
,,,[3375206183,"JB"],];
CONWAYPOLDATA[81517]:=[
,,,[85577361772,"JB"],];
CONWAYPOLDATA[81527]:=[
,,,[26586280813,"JB"],];
CONWAYPOLDATA[81533]:=[
,,,[38630335403,"JB"],];
CONWAYPOLDATA[81547]:=[
,,,[25385825744,"JB"],];
CONWAYPOLDATA[81551]:=[
,,,[39733849084,"JB"],];
CONWAYPOLDATA[81553]:=[
,,,[99762480057,"JB"],];
CONWAYPOLDATA[81559]:=[
,,,[31775957319,"JB"],];
CONWAYPOLDATA[81563]:=[
,,,[77786388413,"JB"],];
CONWAYPOLDATA[81569]:=[
,,,[18200898818,"JB"],];
CONWAYPOLDATA[81611]:=[
,,,[59942626614,"JB"],];
CONWAYPOLDATA[81619]:=[
,,,[44195953932,"JB"],];
CONWAYPOLDATA[81629]:=[
,,,[44550169558,"JB"],];
CONWAYPOLDATA[81637]:=[
,,,[24494528756,"JB"],];
CONWAYPOLDATA[81647]:=[
,,,[57418497696,"JB"],];
CONWAYPOLDATA[81649]:=[
,,,[6138126884,"JB"],];
CONWAYPOLDATA[81667]:=[
,,,[37955146588,"JB"],];
CONWAYPOLDATA[81671]:=[
,,,[16736021327,"JB"],];
CONWAYPOLDATA[81677]:=[
,,,[32819288789,"JB"],];
CONWAYPOLDATA[81689]:=[
,,,[25512209904,"JB"],];
CONWAYPOLDATA[81701]:=[
,,,[86126416368,"JB"],];
CONWAYPOLDATA[81703]:=[
,,,[39597032141,"JB"],];
CONWAYPOLDATA[81707]:=[
,,,[12727989634,"JB"],];
CONWAYPOLDATA[81727]:=[
,,,[39176981631,"JB"],];
CONWAYPOLDATA[81737]:=[
,,,[50311085191,"JB"],];
CONWAYPOLDATA[81749]:=[
,,,[10975293746,"JB"],];
CONWAYPOLDATA[81761]:=[
,,,[5225427283,"JB"],];
CONWAYPOLDATA[81769]:=[
,,,[3936114364,"JB"],];
CONWAYPOLDATA[81773]:=[
,,,[3664248132,"JB"],];
CONWAYPOLDATA[81799]:=[
,,,[11536767365,"JB"],];
CONWAYPOLDATA[81817]:=[
,,,[44602128470,"JB"],];
CONWAYPOLDATA[81839]:=[
,,,[106858491731,"JB"],];
CONWAYPOLDATA[81847]:=[
,,,[38052634631,"JB"],];
CONWAYPOLDATA[81853]:=[
,,,[12787812348,"JB"],];
CONWAYPOLDATA[81869]:=[
,,,[59679144373,"JB"],];
CONWAYPOLDATA[81883]:=[
,,,[39464658215,"JB"],];
CONWAYPOLDATA[81899]:=[
,,,[12634722530,"JB"],];
CONWAYPOLDATA[81901]:=[
,,,[45918860365,"JB"],];
CONWAYPOLDATA[81919]:=[
,,,[26398643510,"JB"],];
CONWAYPOLDATA[81929]:=[
,,,[57881937284,"JB"],];
CONWAYPOLDATA[81931]:=[
,,,[26684926703,"JB"],];
CONWAYPOLDATA[81937]:=[
,,,[105841382322,"JB"],];
CONWAYPOLDATA[81943]:=[
,,,[38452899957,"JB"],];
CONWAYPOLDATA[81953]:=[
,,,[65266221861,"JB"],];
CONWAYPOLDATA[81967]:=[
,,,[73523907203,"JB"],];
CONWAYPOLDATA[81971]:=[
,,,[57938250396,"JB"],];
CONWAYPOLDATA[81973]:=[
,,,[44917843109,"JB"],];
CONWAYPOLDATA[82003]:=[
,,,[52467979492,"JB"],];
CONWAYPOLDATA[82007]:=[
,,,[18566302798,"JB"],];
CONWAYPOLDATA[82009]:=[
,,,[113563438925,"JB"],];
CONWAYPOLDATA[82013]:=[
,,,[25268861415,"JB"],];
CONWAYPOLDATA[82021]:=[
,,,[47091126857,"JB"],];
CONWAYPOLDATA[82031]:=[
,,,[24662210006,"JB"],];
CONWAYPOLDATA[82037]:=[
,,,[46130061398,"JB"],];
CONWAYPOLDATA[82039]:=[
,,,[18651402587,"JB"],];
CONWAYPOLDATA[82051]:=[
,,,[59023797107,"JB"],];
CONWAYPOLDATA[82067]:=[
,,,[5371613420,"JB"],];
CONWAYPOLDATA[82073]:=[
,,,[5228050103,"JB"],];
CONWAYPOLDATA[82129]:=[
,,,[167062048331,"JB"],];
CONWAYPOLDATA[82139]:=[
,,,[30610658997,"JB"],];
CONWAYPOLDATA[82141]:=[
,,,[18070855724,"JB"],];
CONWAYPOLDATA[82153]:=[
,,,[105022012768,"JB"],];
CONWAYPOLDATA[82163]:=[
,,,[60234434769,"JB"],];
CONWAYPOLDATA[82171]:=[
,,,[17144321784,"JB"],];
CONWAYPOLDATA[82183]:=[
,,,[19629080839,"JB"],];
CONWAYPOLDATA[82189]:=[
,,,[19766372321,"JB"],];
CONWAYPOLDATA[82193]:=[
,,,[58213110062,"JB"],];
CONWAYPOLDATA[82207]:=[
,,,[33789625420,"JB"],];
CONWAYPOLDATA[82217]:=[
,,,[20170872132,"JB"],];
CONWAYPOLDATA[82219]:=[
,,,[25963362479,"JB"],];
CONWAYPOLDATA[82223]:=[
,,,[39646039476,"JB"],];
CONWAYPOLDATA[82231]:=[
,,,[37461318829,"JB"],];
CONWAYPOLDATA[82237]:=[
,,,[73753677796,"JB"],];
CONWAYPOLDATA[82241]:=[
,,,[6762595192,"JB"],];
CONWAYPOLDATA[82261]:=[
,,,[72195708568,"JB"],];
CONWAYPOLDATA[82267]:=[
,,,[12347454032,"JB"],];
CONWAYPOLDATA[82279]:=[
,,,[47388507777,"JB"],];
CONWAYPOLDATA[82301]:=[
,,,[4113403982,"JB"],];
CONWAYPOLDATA[82307]:=[
,,,[58510235548,"JB"],];
CONWAYPOLDATA[82339]:=[
,,,[17638825260,"JB"],];
CONWAYPOLDATA[82349]:=[
,,,[99152807547,"JB"],];
CONWAYPOLDATA[82351]:=[
,,,[33908106604,"JB"],];
CONWAYPOLDATA[82361]:=[
,,,[58904422481,"JB"],];
CONWAYPOLDATA[82373]:=[
,,,[39452630725,"JB"],];
CONWAYPOLDATA[82387]:=[
,,,[58794493908,"JB"],];
CONWAYPOLDATA[82393]:=[
,,,[106440468164,"JB"],];
CONWAYPOLDATA[82421]:=[
,,,[10646979940,"JB"],];
CONWAYPOLDATA[82457]:=[
,,,[6402950967,"JB"],];
CONWAYPOLDATA[82463]:=[
,,,[20099036847,"JB"],];
CONWAYPOLDATA[82469]:=[
,,,[17645891932,"JB"],];
CONWAYPOLDATA[82471]:=[
,,,[44836926102,"JB"],];
CONWAYPOLDATA[82483]:=[
,,,[61061834970,"JB"],];
CONWAYPOLDATA[82487]:=[
,,,[60875323518,"JB"],];
CONWAYPOLDATA[82493]:=[
,,,[47252155388,"JB"],];
CONWAYPOLDATA[82499]:=[
,,,[18040386332,"JB"],];
CONWAYPOLDATA[82507]:=[
,,,[53949842176,"JB"],];
CONWAYPOLDATA[82529]:=[
,,,[19481795743,"JB"],];
CONWAYPOLDATA[82531]:=[
,,,[26650827992,"JB"],];
CONWAYPOLDATA[82549]:=[
,,,[65135371001,"JB"],];
CONWAYPOLDATA[82559]:=[
,,,[18870510637,"JB"],];
CONWAYPOLDATA[82561]:=[
,,,[6217586356,"JB"],];
CONWAYPOLDATA[82567]:=[
,,,[46574475930,"JB"],];
CONWAYPOLDATA[82571]:=[
,,,[33949479511,"JB"],];
CONWAYPOLDATA[82591]:=[
,,,[19864291780,"JB"],];
CONWAYPOLDATA[82601]:=[
,,,[6821933992,"JB"],];
CONWAYPOLDATA[82609]:=[
,,,[154998605839,"JB"],];
CONWAYPOLDATA[82613]:=[
,,,[44877364314,"JB"],];
CONWAYPOLDATA[82619]:=[
,,,[19409846910,"JB"],];
CONWAYPOLDATA[82633]:=[
,,,[45791324854,"JB"],];
CONWAYPOLDATA[82651]:=[
,,,[59577402983,"JB"],];
CONWAYPOLDATA[82657]:=[
,,,[106478086154,"JB"],];
CONWAYPOLDATA[82699]:=[
,,,[26795220294,"JB"],];
CONWAYPOLDATA[82721]:=[
,,,[6025149483,"JB"],];
CONWAYPOLDATA[82723]:=[
,,,[59799298580,"JB"],];
CONWAYPOLDATA[82727]:=[
,,,[18843390611,"JB"],];
CONWAYPOLDATA[82729]:=[
,,,[157412439299,"JB"],];
CONWAYPOLDATA[82757]:=[
,,,[47091629497,"JB"],];
CONWAYPOLDATA[82759]:=[
,,,[17428217813,"JB"],];
CONWAYPOLDATA[82763]:=[
,,,[52330217272,"JB"],];
CONWAYPOLDATA[82781]:=[
,,,[12233127839,"JB"],];
CONWAYPOLDATA[82787]:=[
,,,[78879288028,"JB"],];
CONWAYPOLDATA[82793]:=[
,,,[12897990301,"JB"],];
CONWAYPOLDATA[82799]:=[
,,,[31293550867,"JB"],];
CONWAYPOLDATA[82811]:=[
,,,[51576926699,"JB"],];
CONWAYPOLDATA[82813]:=[
,,,[46651544170,"JB"],];
CONWAYPOLDATA[82837]:=[
,,,[54460025934,"JB"],];
CONWAYPOLDATA[82847]:=[
,,,[60001111285,"JB"],];
CONWAYPOLDATA[82883]:=[
,,,[128281417305,"JB"],];
CONWAYPOLDATA[82889]:=[
,,,[6869591656,"JB"],];
CONWAYPOLDATA[82891]:=[
,,,[61002305196,"JB"],];
CONWAYPOLDATA[82903]:=[
,,,[40490571330,"JB"],];
CONWAYPOLDATA[82913]:=[
,,,[53781268714,"JB"],];
CONWAYPOLDATA[82939]:=[
,,,[17458576563,"JB"],];
CONWAYPOLDATA[82963]:=[
,,,[24973439300,"JB"],];
CONWAYPOLDATA[82981]:=[
,,,[24771156198,"JB"],];
CONWAYPOLDATA[82997]:=[
,,,[25228017113,"JB"],];
CONWAYPOLDATA[83003]:=[
,,,[31428338925,"JB"],];
CONWAYPOLDATA[83009]:=[
,,,[6889497976,"JB"],];
CONWAYPOLDATA[83023]:=[
,,,[59059407329,"JB"],];
CONWAYPOLDATA[83047]:=[
,,,[38439964893,"JB"],];
CONWAYPOLDATA[83059]:=[
,,,[59658954050,"JB"],];
CONWAYPOLDATA[83063]:=[
,,,[20298520630,"JB"],];
CONWAYPOLDATA[83071]:=[
,,,[44992167395,"JB"],];
CONWAYPOLDATA[83077]:=[
,,,[53116110734,"JB"],];
CONWAYPOLDATA[83089]:=[
,,,[4013198707,"JB"],];
CONWAYPOLDATA[83093]:=[
,,,[87741970259,"JB"],];
CONWAYPOLDATA[83101]:=[
,,,[47931077883,"JB"],];
CONWAYPOLDATA[83117]:=[
,,,[46510195277,"JB"],];
CONWAYPOLDATA[83137]:=[
,,,[75208723137,"JB"],];
CONWAYPOLDATA[83177]:=[
,,,[32767828684,"JB"],];
CONWAYPOLDATA[83203]:=[
,,,[61030398938,"JB"],];
CONWAYPOLDATA[83207]:=[
,,,[27468461259,"JB"],];
CONWAYPOLDATA[83219]:=[
,,,[19792806962,"JB"],];
CONWAYPOLDATA[83221]:=[
,,,[96152544755,"JB"],];
CONWAYPOLDATA[83227]:=[
,,,[3525745406,"JB"],];
CONWAYPOLDATA[83231]:=[
,,,[94194686713,"JB"],];
CONWAYPOLDATA[83233]:=[
,,,[62015992744,"JB"],];
CONWAYPOLDATA[83243]:=[
,,,[72859850883,"JB"],];
CONWAYPOLDATA[83257]:=[
,,,[46552485499,"JB"],];
CONWAYPOLDATA[83267]:=[
,,,[34221321463,"JB"],];
CONWAYPOLDATA[83269]:=[
,,,[110206854578,"JB"],];
CONWAYPOLDATA[83273]:=[
,,,[19710136192,"JB"],];
CONWAYPOLDATA[83299]:=[
,,,[3677234357,"JB"],];
CONWAYPOLDATA[83311]:=[
,,,[26457490837,"JB"],];
CONWAYPOLDATA[83339]:=[
,,,[55061327251,"JB"],];
CONWAYPOLDATA[83341]:=[
,,,[27619707456,"JB"],];
CONWAYPOLDATA[83357]:=[
,,,[60183503931,"JB"],];
CONWAYPOLDATA[83383]:=[
,,,[76479304518,"JB"],];
CONWAYPOLDATA[83389]:=[
,,,[55434171976,"JB"],];
CONWAYPOLDATA[83399]:=[
,,,[38573955684,"JB"],];
CONWAYPOLDATA[83401]:=[
,,,[116320208717,"JB"],];
CONWAYPOLDATA[83407]:=[
,,,[27826576973,"JB"],];
CONWAYPOLDATA[83417]:=[
,,,[67645598064,"JB"],];
CONWAYPOLDATA[83423]:=[
,,,[19206227026,"JB"],];
CONWAYPOLDATA[83431]:=[
,,,[48167719828,"JB"],];
CONWAYPOLDATA[83437]:=[
,,,[132000254297,"JB"],];
CONWAYPOLDATA[83443]:=[
,,,[17608141862,"JB"],];
CONWAYPOLDATA[83449]:=[
,,,[184566072640,"JB"],];
CONWAYPOLDATA[83459]:=[
,,,[19875844311,"JB"],];
CONWAYPOLDATA[83471]:=[
,,,[19694982461,"JB"],];
CONWAYPOLDATA[83477]:=[
,,,[48096692661,"JB"],];
CONWAYPOLDATA[83497]:=[
,,,[45740658574,"JB"],];
CONWAYPOLDATA[83537]:=[
,,,[25539934087,"JB"],];
CONWAYPOLDATA[83557]:=[
,,,[54391763380,"JB"],];
CONWAYPOLDATA[83561]:=[
,,,[6981437992,"JB"],];
CONWAYPOLDATA[83563]:=[
,,,[60737599426,"JB"],];
CONWAYPOLDATA[83579]:=[
,,,[80547088198,"JB"],];
CONWAYPOLDATA[83591]:=[
,,,[34936524093,"JB"],];
CONWAYPOLDATA[83597]:=[
,,,[12924179799,"JB"],];
CONWAYPOLDATA[83609]:=[
,,,[27255363477,"JB"],];
CONWAYPOLDATA[83617]:=[
,,,[129672072967,"JB"],];
CONWAYPOLDATA[83621]:=[
,,,[26813491757,"JB"],];
CONWAYPOLDATA[83639]:=[
,,,[59566357595,"JB"],];
CONWAYPOLDATA[83641]:=[
,,,[103115468601,"JB"],];
CONWAYPOLDATA[83653]:=[
,,,[62702440767,"JB"],];
CONWAYPOLDATA[83663]:=[
,,,[67165744024,"JB"],];
CONWAYPOLDATA[83689]:=[
,,,[244301999698,"JB"],];
CONWAYPOLDATA[83701]:=[
,,,[18482436321,"JB"],];
CONWAYPOLDATA[83717]:=[
,,,[69216043564,"JB"],];
CONWAYPOLDATA[83719]:=[
,,,[19517159319,"JB"],];
CONWAYPOLDATA[83737]:=[
,,,[108826028734,"JB"],];
CONWAYPOLDATA[83761]:=[
,,,[75657960871,"JB"],];
CONWAYPOLDATA[83773]:=[
,,,[25383972962,"JB"],];
CONWAYPOLDATA[83777]:=[
,,,[5158066116,"JB"],];
CONWAYPOLDATA[83791]:=[
,,,[48248114668,"JB"],];
CONWAYPOLDATA[83813]:=[
,,,[68576886171,"JB"],];
CONWAYPOLDATA[83833]:=[
,,,[130361823999,"JB"],];
CONWAYPOLDATA[83843]:=[
,,,[4026811606,"JB"],];
CONWAYPOLDATA[83857]:=[
,,,[47417024512,"JB"],];
CONWAYPOLDATA[83869]:=[
,,,[54589661154,"JB"],];
CONWAYPOLDATA[83873]:=[
,,,[69191031353,"JB"],];
CONWAYPOLDATA[83891]:=[
,,,[32106847413,"JB"],];
CONWAYPOLDATA[83903]:=[
,,,[28158518029,"JB"],];
CONWAYPOLDATA[83911]:=[
,,,[47920145616,"JB"],];
CONWAYPOLDATA[83921]:=[
,,,[52898343538,"JB"],];
CONWAYPOLDATA[83933]:=[
,,,[47741677933,"JB"],];
CONWAYPOLDATA[83939]:=[
,,,[52994551896,"JB"],];
CONWAYPOLDATA[83969]:=[
,,,[53874174527,"JB"],];
CONWAYPOLDATA[83983]:=[
,,,[40800705048,"JB"],];
CONWAYPOLDATA[83987]:=[
,,,[27522539902,"JB"],];
CONWAYPOLDATA[84011]:=[
,,,[33988834342,"JB"],];
CONWAYPOLDATA[84017]:=[
,,,[5769531410,"JB"],];
CONWAYPOLDATA[84047]:=[
,,,[32614102167,"JB"],];
CONWAYPOLDATA[84053]:=[
,,,[46096346262,"JB"],];
CONWAYPOLDATA[84059]:=[
,,,[19737305379,"JB"],];
CONWAYPOLDATA[84061]:=[
,,,[32656101348,"JB"],];
CONWAYPOLDATA[84067]:=[
,,,[61480971313,"JB"],];
CONWAYPOLDATA[84089]:=[
,,,[18945672148,"JB"],];
CONWAYPOLDATA[84121]:=[
,,,[105959316339,"JB"],];
CONWAYPOLDATA[84127]:=[
,,,[40605326712,"JB"],];
CONWAYPOLDATA[84131]:=[
,,,[56133717560,"JB"],];
CONWAYPOLDATA[84137]:=[
,,,[25306979274,"JB"],];
CONWAYPOLDATA[84143]:=[
,,,[28319841229,"JB"],];
CONWAYPOLDATA[84163]:=[
,,,[62641426783,"JB"],];
CONWAYPOLDATA[84179]:=[
,,,[55797797615,"JB"],];
CONWAYPOLDATA[84181]:=[
,,,[63777377584,"JB"],];
CONWAYPOLDATA[84191]:=[
,,,[35439864693,"JB"],];
CONWAYPOLDATA[84199]:=[
,,,[39354275815,"JB"],];
CONWAYPOLDATA[84211]:=[
,,,[47176518001,"JB"],];
CONWAYPOLDATA[84221]:=[
,,,[35315212838,"JB"],];
CONWAYPOLDATA[84223]:=[
,,,[18720835777,"JB"],];
CONWAYPOLDATA[84229]:=[
,,,[24858167856,"JB"],];
CONWAYPOLDATA[84239]:=[
,,,[41256302978,"JB"],];
CONWAYPOLDATA[84247]:=[
,,,[76074704017,"JB"],];
CONWAYPOLDATA[84263]:=[
,,,[48658849037,"JB"],];
CONWAYPOLDATA[84299]:=[
,,,[19552984454,"JB"],];
CONWAYPOLDATA[84307]:=[
,,,[83132603493,"JB"],];
CONWAYPOLDATA[84313]:=[
,,,[47151202125,"JB"],];
CONWAYPOLDATA[84317]:=[
,,,[117331742937,"JB"],];
CONWAYPOLDATA[84319]:=[
,,,[75691648564,"JB"],];
CONWAYPOLDATA[84347]:=[
,,,[63987321142,"JB"],];
CONWAYPOLDATA[84349]:=[
,,,[48274788380,"JB"],];
CONWAYPOLDATA[84377]:=[
,,,[5655452805,"JB"],];
CONWAYPOLDATA[84389]:=[
,,,[89239764111,"JB"],];
CONWAYPOLDATA[84391]:=[
,,,[76766273153,"JB"],];
CONWAYPOLDATA[84401]:=[
,,,[20386723949,"JB"],];
CONWAYPOLDATA[84407]:=[
,,,[70856131411,"JB"],];
CONWAYPOLDATA[84421]:=[
,,,[92181147164,"JB"],];
CONWAYPOLDATA[84431]:=[
,,,[25886122452,"JB"],];
CONWAYPOLDATA[84437]:=[
,,,[33570884647,"JB"],];
CONWAYPOLDATA[84443]:=[
,,,[34923935942,"JB"],];
CONWAYPOLDATA[84449]:=[
,,,[35139313352,"JB"],];
CONWAYPOLDATA[84457]:=[
,,,[49432090906,"JB"],];
CONWAYPOLDATA[84463]:=[
,,,[40738532017,"JB"],];
CONWAYPOLDATA[84467]:=[
,,,[84772094806,"JB"],];
CONWAYPOLDATA[84481]:=[
,,,[5106538533,"JB"],];
CONWAYPOLDATA[84499]:=[
,,,[61452827241,"JB"],];
CONWAYPOLDATA[84503]:=[
,,,[39358370804,"JB"],];
CONWAYPOLDATA[84509]:=[
,,,[26130351820,"JB"],];
CONWAYPOLDATA[84521]:=[
,,,[98037598323,"JB"],];
CONWAYPOLDATA[84523]:=[
,,,[19185875772,"JB"],];
CONWAYPOLDATA[84533]:=[
,,,[126714797936,"JB"],];
CONWAYPOLDATA[84551]:=[
,,,[20127450120,"JB"],];
CONWAYPOLDATA[84559]:=[
,,,[26179043608,"JB"],];
CONWAYPOLDATA[84589]:=[
,,,[119633545990,"JB"],];
CONWAYPOLDATA[84629]:=[
,,,[20597852312,"JB"],];
CONWAYPOLDATA[84631]:=[
,,,[19503637111,"JB"],];
CONWAYPOLDATA[84649]:=[
,,,[105643898940,"JB"],];
CONWAYPOLDATA[84653]:=[
,,,[56800215983,"JB"],];
CONWAYPOLDATA[84659]:=[
,,,[4866537958,"JB"],];
CONWAYPOLDATA[84673]:=[
,,,[62588418804,"JB"],];
CONWAYPOLDATA[84691]:=[
,,,[19105103928,"JB"],];
CONWAYPOLDATA[84697]:=[
,,,[92517497506,"JB"],];
CONWAYPOLDATA[84701]:=[
,,,[47235121971,"JB"],];
CONWAYPOLDATA[84713]:=[
,,,[35033061153,"JB"],];
CONWAYPOLDATA[84719]:=[
,,,[46960250027,"JB"],];
CONWAYPOLDATA[84731]:=[
,,,[46980373917,"JB"],];
CONWAYPOLDATA[84737]:=[
,,,[11990539714,"JB"],];
CONWAYPOLDATA[84751]:=[
,,,[18010604518,"JB"],];
CONWAYPOLDATA[84761]:=[
,,,[55791215905,"JB"],];
CONWAYPOLDATA[84787]:=[
,,,[18439052827,"JB"],];
CONWAYPOLDATA[84793]:=[
,,,[157360460472,"JB"],];
CONWAYPOLDATA[84809]:=[
,,,[34834533472,"JB"],];
CONWAYPOLDATA[84811]:=[
,,,[54365038357,"JB"],];
CONWAYPOLDATA[84827]:=[
,,,[26972865327,"JB"],];
CONWAYPOLDATA[84857]:=[
,,,[14331498733,"JB"],];
CONWAYPOLDATA[84859]:=[
,,,[48233261589,"JB"],];
CONWAYPOLDATA[84869]:=[
,,,[19478793407,"JB"],];
CONWAYPOLDATA[84871]:=[
,,,[20044917654,"JB"],];
CONWAYPOLDATA[84913]:=[
,,,[49539772639,"JB"],];
CONWAYPOLDATA[84919]:=[
,,,[27592390997,"JB"],];
CONWAYPOLDATA[84947]:=[
,,,[136456822074,"JB"],];
CONWAYPOLDATA[84961]:=[
,,,[122399064661,"JB"],];
CONWAYPOLDATA[84967]:=[
,,,[49155873546,"JB"],];
CONWAYPOLDATA[84977]:=[
,,,[70588609386,"JB"],];
CONWAYPOLDATA[84979]:=[
,,,[47437062361,"JB"],];
CONWAYPOLDATA[84991]:=[
,,,[48966374779,"JB"],];
CONWAYPOLDATA[85009]:=[
,,,[206287939953,"JB"],];
CONWAYPOLDATA[85021]:=[
,,,[35350711555,"JB"],];
CONWAYPOLDATA[85027]:=[
,,,[77222116591,"JB"],];
CONWAYPOLDATA[85037]:=[
,,,[18496312835,"JB"],];
CONWAYPOLDATA[85049]:=[
,,,[33330107760,"JB"],];
CONWAYPOLDATA[85061]:=[
,,,[49250404063,"JB"],];
CONWAYPOLDATA[85081]:=[
,,,[180014039483,"JB"],];
CONWAYPOLDATA[85087]:=[
,,,[20393226728,"JB"],];
CONWAYPOLDATA[85091]:=[
,,,[33409024063,"JB"],];
CONWAYPOLDATA[85093]:=[
,,,[91820707861,"JB"],];
CONWAYPOLDATA[85103]:=[
,,,[49335570753,"JB"],];
CONWAYPOLDATA[85109]:=[
,,,[13289089480,"JB"],];
CONWAYPOLDATA[85121]:=[
,,,[56774174828,"JB"],];
CONWAYPOLDATA[85133]:=[
,,,[13361028421,"JB"],];
CONWAYPOLDATA[85147]:=[
,,,[56703814946,"JB"],];
CONWAYPOLDATA[85159]:=[
,,,[18871830516,"JB"],];
CONWAYPOLDATA[85193]:=[
,,,[12454364673,"JB"],];
CONWAYPOLDATA[85199]:=[
,,,[36293581221,"JB"],];
CONWAYPOLDATA[85201]:=[
,,,[186898788044,"JB"],];
CONWAYPOLDATA[85213]:=[
,,,[56912228872,"JB"],];
CONWAYPOLDATA[85223]:=[
,,,[20146291090,"JB"],];
CONWAYPOLDATA[85229]:=[
,,,[36284712631,"JB"],];
CONWAYPOLDATA[85237]:=[
,,,[47638362643,"JB"],];
CONWAYPOLDATA[85243]:=[
,,,[27630154565,"JB"],];
CONWAYPOLDATA[85247]:=[
,,,[29067863053,"JB"],];
CONWAYPOLDATA[85259]:=[
,,,[49055129796,"JB"],];
CONWAYPOLDATA[85297]:=[
,,,[48530154650,"JB"],];
CONWAYPOLDATA[85303]:=[
,,,[42469975221,"JB"],];
CONWAYPOLDATA[85313]:=[
,,,[35753313295,"JB"],];
CONWAYPOLDATA[85331]:=[
,,,[62230533006,"JB"],];
CONWAYPOLDATA[85333]:=[
,,,[13488672648,"JB"],];
CONWAYPOLDATA[85361]:=[
,,,[32949431364,"JB"],];
CONWAYPOLDATA[85363]:=[
,,,[27086192081,"JB"],];
CONWAYPOLDATA[85369]:=[
,,,[122150916619,"JB"],];
CONWAYPOLDATA[85381]:=[
,,,[85952028134,"JB"],];
CONWAYPOLDATA[85411]:=[
,,,[62477975680,"JB"],];
CONWAYPOLDATA[85427]:=[
,,,[50588160862,"JB"],];
CONWAYPOLDATA[85429]:=[
,,,[55370122924,"JB"],];
CONWAYPOLDATA[85439]:=[
,,,[36498344661,"JB"],];
CONWAYPOLDATA[85447]:=[
,,,[40481968852,"JB"],];
CONWAYPOLDATA[85451]:=[
,,,[64207539598,"JB"],];
CONWAYPOLDATA[85453]:=[
,,,[49976247069,"JB"],];
CONWAYPOLDATA[85469]:=[
,,,[36524407932,"JB"],];
CONWAYPOLDATA[85487]:=[
,,,[41772538659,"JB"],];
CONWAYPOLDATA[85513]:=[
,,,[50364762641,"JB"],];
CONWAYPOLDATA[85517]:=[
,,,[48627959297,"JB"],];
CONWAYPOLDATA[85523]:=[
,,,[62833577056,"JB"],];
CONWAYPOLDATA[85531]:=[
,,,[21287211887,"JB"],];
CONWAYPOLDATA[85549]:=[
,,,[48678664237,"JB"],];
CONWAYPOLDATA[85571]:=[
,,,[65900965374,"JB"],];
CONWAYPOLDATA[85577]:=[
,,,[57333166923,"JB"],];
CONWAYPOLDATA[85597]:=[
,,,[77029681869,"JB"],];
CONWAYPOLDATA[85601]:=[
,,,[4903738889,"JB"],];
CONWAYPOLDATA[85607]:=[
,,,[33000214400,"JB"],];
CONWAYPOLDATA[85619]:=[
,,,[14533482780,"JB"],];
CONWAYPOLDATA[85621]:=[
,,,[130179452725,"JB"],];
CONWAYPOLDATA[85627]:=[
,,,[65987248774,"JB"],];
CONWAYPOLDATA[85639]:=[
,,,[36669849052,"JB"],];
CONWAYPOLDATA[85643]:=[
,,,[5734398353,"JB"],];
CONWAYPOLDATA[85661]:=[
,,,[57257868266,"JB"],];
CONWAYPOLDATA[85667]:=[
,,,[86783326682,"JB"],];
CONWAYPOLDATA[85669]:=[
,,,[48710536712,"JB"],];
CONWAYPOLDATA[85691]:=[
,,,[63338331270,"JB"],];
CONWAYPOLDATA[85703]:=[
,,,[35556803457,"JB"],];
CONWAYPOLDATA[85711]:=[
,,,[29302276709,"JB"],];
CONWAYPOLDATA[85717]:=[
,,,[79806384267,"JB"],];
CONWAYPOLDATA[85733]:=[
,,,[55843732746,"JB"],];
CONWAYPOLDATA[85751]:=[
,,,[56412238625,"JB"],];
CONWAYPOLDATA[85781]:=[
,,,[34697556692,"JB"],];
CONWAYPOLDATA[85793]:=[
,,,[21481366101,"JB"],];
CONWAYPOLDATA[85817]:=[
,,,[34945540573,"JB"],];
CONWAYPOLDATA[85819]:=[
,,,[55291551141,"JB"],];
CONWAYPOLDATA[85829]:=[
,,,[56896816563,"JB"],];
CONWAYPOLDATA[85831]:=[
,,,[27028954382,"JB"],];
CONWAYPOLDATA[85837]:=[
,,,[66311314264,"JB"],];
CONWAYPOLDATA[85843]:=[
,,,[42118867953,"JB"],];
CONWAYPOLDATA[85847]:=[
,,,[29478486253,"JB"],];
CONWAYPOLDATA[85853]:=[
,,,[50758955045,"JB"],];
CONWAYPOLDATA[85889]:=[
,,,[18987567122,"JB"],];
CONWAYPOLDATA[85903]:=[
,,,[48107483966,"JB"],];
CONWAYPOLDATA[85909]:=[
,,,[6297902883,"JB"],];
CONWAYPOLDATA[85931]:=[
,,,[20295355444,"JB"],];
CONWAYPOLDATA[85933]:=[
,,,[26833352652,"JB"],];
CONWAYPOLDATA[85991]:=[
,,,[57747342052,"JB"],];
CONWAYPOLDATA[85999]:=[
,,,[50490786894,"JB"],];
CONWAYPOLDATA[86011]:=[
,,,[51208369077,"JB"],];
CONWAYPOLDATA[86017]:=[
,,,[110982918153,"JB"],];
CONWAYPOLDATA[86027]:=[
,,,[65852636178,"JB"],];
CONWAYPOLDATA[86029]:=[
,,,[78854869634,"JB"],];
CONWAYPOLDATA[86069]:=[
,,,[7144243416,"JB"],];
CONWAYPOLDATA[86077]:=[
,,,[14520759520,"JB"],];
CONWAYPOLDATA[86083]:=[
,,,[63202827266,"JB"],];
CONWAYPOLDATA[86111]:=[
,,,[42293675994,"JB"],];
CONWAYPOLDATA[86113]:=[
,,,[95486916733,"JB"],];
CONWAYPOLDATA[86117]:=[
,,,[35297291494,"JB"],];
CONWAYPOLDATA[86131]:=[
,,,[20759552015,"JB"],];
CONWAYPOLDATA[86137]:=[
,,,[50360341603,"JB"],];
CONWAYPOLDATA[86143]:=[
,,,[21624735722,"JB"],];
CONWAYPOLDATA[86161]:=[
,,,[167537738167,"JB"],];
CONWAYPOLDATA[86171]:=[
,,,[19041378219,"JB"],];
CONWAYPOLDATA[86179]:=[
,,,[64476370074,"JB"],];
CONWAYPOLDATA[86183]:=[
,,,[27698354375,"JB"],];
CONWAYPOLDATA[86197]:=[
,,,[57780865997,"JB"],];
CONWAYPOLDATA[86201]:=[
,,,[18993355941,"JB"],];
CONWAYPOLDATA[86209]:=[
,,,[109350943971,"JB"],];
CONWAYPOLDATA[86239]:=[
,,,[51631116825,"JB"],];
CONWAYPOLDATA[86243]:=[
,,,[102457805161,"JB"],];
CONWAYPOLDATA[86249]:=[
,,,[7437855016,"JB"],];
CONWAYPOLDATA[86257]:=[
,,,[78289440915,"JB"],];
CONWAYPOLDATA[86263]:=[
,,,[28235173848,"JB"],];
CONWAYPOLDATA[86269]:=[
,,,[22235662218,"JB"],];
CONWAYPOLDATA[86287]:=[
,,,[20737699869,"JB"],];
CONWAYPOLDATA[86291]:=[
,,,[63465477264,"JB"],];
CONWAYPOLDATA[86293]:=[
,,,[81028436658,"JB"],];
CONWAYPOLDATA[86297]:=[
,,,[13635702676,"JB"],];
CONWAYPOLDATA[86311]:=[
,,,[27905554657,"JB"],];
CONWAYPOLDATA[86323]:=[
,,,[58872544971,"JB"],];
CONWAYPOLDATA[86341]:=[
,,,[27905842907,"JB"],];
CONWAYPOLDATA[86351]:=[
,,,[21151763814,"JB"],];
CONWAYPOLDATA[86353]:=[
,,,[183530089501,"JB"],];
CONWAYPOLDATA[86357]:=[
,,,[26293374863,"JB"],];
CONWAYPOLDATA[86369]:=[
,,,[7458567736,"JB"],];
CONWAYPOLDATA[86371]:=[
,,,[18905920935,"JB"],];
CONWAYPOLDATA[86381]:=[
,,,[95290422724,"JB"],];
CONWAYPOLDATA[86389]:=[
,,,[58655712110,"JB"],];
CONWAYPOLDATA[86399]:=[
,,,[81865126087,"JB"],];
CONWAYPOLDATA[86413]:=[
,,,[27222255327,"JB"],];
CONWAYPOLDATA[86423]:=[
,,,[52246506117,"JB"],];
CONWAYPOLDATA[86441]:=[
,,,[7471009192,"JB"],];
CONWAYPOLDATA[86453]:=[
,,,[13439032399,"JB"],];
CONWAYPOLDATA[86461]:=[
,,,[94232028221,"JB"],];
CONWAYPOLDATA[86467]:=[
,,,[20907893536,"JB"],];
CONWAYPOLDATA[86477]:=[
,,,[29494450961,"JB"],];
CONWAYPOLDATA[86491]:=[
,,,[20620751767,"JB"],];
CONWAYPOLDATA[86501]:=[
,,,[59388213063,"JB"],];
CONWAYPOLDATA[86509]:=[
,,,[81887083663,"JB"],];
CONWAYPOLDATA[86531]:=[
,,,[59828917898,"JB"],];
CONWAYPOLDATA[86533]:=[
,,,[58167136470,"JB"],];
CONWAYPOLDATA[86539]:=[
,,,[56713939426,"JB"],];
CONWAYPOLDATA[86561]:=[
,,,[36257892634,"JB"],];
CONWAYPOLDATA[86573]:=[
,,,[94661775111,"JB"],];
CONWAYPOLDATA[86579]:=[
,,,[21322849280,"JB"],];
CONWAYPOLDATA[86587]:=[
,,,[58282835334,"JB"],];
CONWAYPOLDATA[86599]:=[
,,,[18864552965,"JB"],];
CONWAYPOLDATA[86627]:=[
,,,[125020346283,"JB"],];
CONWAYPOLDATA[86629]:=[
,,,[52394778524,"JB"],];
CONWAYPOLDATA[86677]:=[
,,,[73236517674,"JB"],];
CONWAYPOLDATA[86689]:=[
,,,[112575895815,"JB"],];
CONWAYPOLDATA[86693]:=[
,,,[27337077078,"JB"],];
CONWAYPOLDATA[86711]:=[
,,,[27325497570,"JB"],];
CONWAYPOLDATA[86719]:=[
,,,[27539959869,"JB"],];
CONWAYPOLDATA[86729]:=[
,,,[21260139960,"JB"],];
CONWAYPOLDATA[86743]:=[
,,,[19332412413,"JB"],];
CONWAYPOLDATA[86753]:=[
,,,[59202676287,"JB"],];
CONWAYPOLDATA[86767]:=[
,,,[41892929710,"JB"],];
CONWAYPOLDATA[86771]:=[
,,,[43823693556,"JB"],];
CONWAYPOLDATA[86783]:=[
,,,[19972326408,"JB"],];
CONWAYPOLDATA[86813]:=[
,,,[5963879476,"JB"],];
CONWAYPOLDATA[86837]:=[
,,,[59909540998,"JB"],];
CONWAYPOLDATA[86843]:=[
,,,[64885268510,"JB"],];
CONWAYPOLDATA[86851]:=[
,,,[65106549387,"JB"],];
CONWAYPOLDATA[86857]:=[
,,,[172423131276,"JB"],];
CONWAYPOLDATA[86861]:=[
,,,[75286424308,"JB"],];
CONWAYPOLDATA[86869]:=[
,,,[87675578667,"JB"],];
CONWAYPOLDATA[86923]:=[
,,,[65189990004,"JB"],];
CONWAYPOLDATA[86927]:=[
,,,[35375116509,"JB"],];
CONWAYPOLDATA[86929]:=[
,,,[96837341292,"JB"],];
CONWAYPOLDATA[86939]:=[
,,,[34880448436,"JB"],];
CONWAYPOLDATA[86951]:=[
,,,[22398229803,"JB"],];
CONWAYPOLDATA[86959]:=[
,,,[27523132216,"JB"],];
CONWAYPOLDATA[86969]:=[
,,,[29051994453,"JB"],];
CONWAYPOLDATA[86981]:=[
,,,[28716777152,"JB"],];
CONWAYPOLDATA[86993]:=[
,,,[72557207597,"JB"],];
CONWAYPOLDATA[87011]:=[
,,,[57228439867,"JB"],];
CONWAYPOLDATA[87013]:=[
,,,[52642255914,"JB"],];
CONWAYPOLDATA[87037]:=[
,,,[52825888634,"JB"],];
CONWAYPOLDATA[87041]:=[
,,,[21882542608,"JB"],];
CONWAYPOLDATA[87049]:=[
,,,[67792455484,"JB"],];
CONWAYPOLDATA[87071]:=[
,,,[22488436684,"JB"],];
CONWAYPOLDATA[87083]:=[
,,,[20387523630,"JB"],];
CONWAYPOLDATA[87103]:=[
,,,[51973924588,"JB"],];
CONWAYPOLDATA[87107]:=[
,,,[105816276997,"JB"],];
CONWAYPOLDATA[87119]:=[
,,,[5108483929,"JB"],];
CONWAYPOLDATA[87121]:=[
,,,[7149149267,"JB"],];
CONWAYPOLDATA[87133]:=[
,,,[37320370901,"JB"],];
CONWAYPOLDATA[87149]:=[
,,,[11926689248,"JB"],];
CONWAYPOLDATA[87151]:=[
,,,[52502115480,"JB"],];
CONWAYPOLDATA[87179]:=[
,,,[27714552818,"JB"],];
CONWAYPOLDATA[87181]:=[
,,,[29212696663,"JB"],];
CONWAYPOLDATA[87187]:=[
,,,[19263618905,"JB"],];
CONWAYPOLDATA[87211]:=[
,,,[3836935169,"JB"],];
CONWAYPOLDATA[87221]:=[
,,,[67001515011,"JB"],];
CONWAYPOLDATA[87223]:=[
,,,[30202446544,"JB"],];
CONWAYPOLDATA[87251]:=[
,,,[60361288814,"JB"],];
CONWAYPOLDATA[87253]:=[
,,,[60134069578,"JB"],];
CONWAYPOLDATA[87257]:=[
,,,[13646645775,"JB"],];
CONWAYPOLDATA[87277]:=[
,,,[29029115698,"JB"],];
CONWAYPOLDATA[87281]:=[
,,,[60782750246,"JB"],];
CONWAYPOLDATA[87293]:=[
,,,[36741710995,"JB"],];
CONWAYPOLDATA[87299]:=[
,,,[28557510779,"JB"],];
CONWAYPOLDATA[87313]:=[
,,,[97148372890,"JB"],];
CONWAYPOLDATA[87317]:=[
,,,[14413242558,"JB"],];
CONWAYPOLDATA[87323]:=[
,,,[35762086776,"JB"],];
CONWAYPOLDATA[87337]:=[
,,,[50824457100,"JB"],];
CONWAYPOLDATA[87359]:=[
,,,[59654403554,"JB"],];
CONWAYPOLDATA[87383]:=[
,,,[37163290841,"JB"],];
CONWAYPOLDATA[87403]:=[
,,,[68036068456,"JB"],];
CONWAYPOLDATA[87407]:=[
,,,[43016655799,"JB"],];
CONWAYPOLDATA[87421]:=[
,,,[91148806288,"JB"],];
CONWAYPOLDATA[87427]:=[
,,,[66493828830,"JB"],];
CONWAYPOLDATA[87433]:=[
,,,[50461256491,"JB"],];
CONWAYPOLDATA[87443]:=[
,,,[28412154448,"JB"],];
CONWAYPOLDATA[87473]:=[
,,,[80419702123,"JB"],];
CONWAYPOLDATA[87481]:=[
,,,[279723559364,"JB"],];
CONWAYPOLDATA[87491]:=[
,,,[21016738058,"JB"],];
CONWAYPOLDATA[87509]:=[
,,,[22330459113,"JB"],];
CONWAYPOLDATA[87511]:=[
,,,[20781237173,"JB"],];
CONWAYPOLDATA[87517]:=[
,,,[52984104557,"JB"],];
CONWAYPOLDATA[87523]:=[
,,,[67872686134,"JB"],];
CONWAYPOLDATA[87539]:=[
,,,[126785097255,"JB"],];
CONWAYPOLDATA[87541]:=[
,,,[59192072742,"JB"],];
CONWAYPOLDATA[87547]:=[
,,,[81992930775,"JB"],];
CONWAYPOLDATA[87553]:=[
,,,[83786732604,"JB"],];
CONWAYPOLDATA[87557]:=[
,,,[120617997861,"JB"],];
CONWAYPOLDATA[87559]:=[
,,,[51500977977,"JB"],];
CONWAYPOLDATA[87583]:=[
,,,[52503731345,"JB"],];
CONWAYPOLDATA[87587]:=[
,,,[38112869943,"JB"],];
CONWAYPOLDATA[87589]:=[
,,,[26965149542,"JB"],];
CONWAYPOLDATA[87613]:=[
,,,[76254850682,"JB"],];
CONWAYPOLDATA[87623]:=[
,,,[29086805347,"JB"],];
CONWAYPOLDATA[87629]:=[
,,,[36791999571,"JB"],];
CONWAYPOLDATA[87631]:=[
,,,[30211751197,"JB"],];
CONWAYPOLDATA[87641]:=[
,,,[22984816304,"JB"],];
CONWAYPOLDATA[87643]:=[
,,,[19964023687,"JB"],];
CONWAYPOLDATA[87649]:=[
,,,[144724188188,"JB"],];
CONWAYPOLDATA[87671]:=[
,,,[76567204848,"JB"],];
CONWAYPOLDATA[87679]:=[
,,,[30097745691,"JB"],];
CONWAYPOLDATA[87683]:=[
,,,[29797839990,"JB"],];
CONWAYPOLDATA[87691]:=[
,,,[53782994891,"JB"],];
CONWAYPOLDATA[87697]:=[
,,,[89222138544,"JB"],];
CONWAYPOLDATA[87701]:=[
,,,[38220709709,"JB"],];
CONWAYPOLDATA[87719]:=[
,,,[38383115118,"JB"],];
CONWAYPOLDATA[87721]:=[
,,,[160296443035,"JB"],];
CONWAYPOLDATA[87739]:=[
,,,[89849298435,"JB"],];
CONWAYPOLDATA[87743]:=[
,,,[65751708686,"JB"],];
CONWAYPOLDATA[87751]:=[
,,,[38500839004,"JB"],];
CONWAYPOLDATA[87767]:=[
,,,[30811834093,"JB"],];
CONWAYPOLDATA[87793]:=[
,,,[53409486106,"JB"],];
CONWAYPOLDATA[87797]:=[
,,,[28511373376,"JB"],];
CONWAYPOLDATA[87803]:=[
,,,[15009835052,"JB"],];
CONWAYPOLDATA[87811]:=[
,,,[53842719628,"JB"],];
CONWAYPOLDATA[87833]:=[
,,,[205445427321,"JB"],];
CONWAYPOLDATA[87853]:=[
,,,[29492252102,"JB"],];
CONWAYPOLDATA[87869]:=[
,,,[35032315874,"JB"],];
CONWAYPOLDATA[87877]:=[
,,,[52262121565,"JB"],];
CONWAYPOLDATA[87881]:=[
,,,[59645274108,"JB"],];
CONWAYPOLDATA[87887]:=[
,,,[58211251359,"JB"],];
CONWAYPOLDATA[87911]:=[
,,,[37950123797,"JB"],];
CONWAYPOLDATA[87917]:=[
,,,[54047503254,"JB"],];
CONWAYPOLDATA[87931]:=[
,,,[7375300566,"JB"],];
CONWAYPOLDATA[87943]:=[
,,,[53568807536,"JB"],];
CONWAYPOLDATA[87959]:=[
,,,[38683136781,"JB"],];
CONWAYPOLDATA[87961]:=[
,,,[5687470313,"JB"],];
CONWAYPOLDATA[87973]:=[
,,,[83435088743,"JB"],];
CONWAYPOLDATA[87977]:=[
,,,[37518847377,"JB"],];
CONWAYPOLDATA[87991]:=[
,,,[81894983526,"JB"],];
CONWAYPOLDATA[88001]:=[
,,,[6430057074,"JB"],];
CONWAYPOLDATA[88003]:=[
,,,[19483072175,"JB"],];
CONWAYPOLDATA[88007]:=[
,,,[20360243441,"JB"],];
CONWAYPOLDATA[88019]:=[
,,,[27952457889,"JB"],];
CONWAYPOLDATA[88037]:=[
,,,[21630955013,"JB"],];
CONWAYPOLDATA[88069]:=[
,,,[97995080854,"JB"],];
CONWAYPOLDATA[88079]:=[
,,,[50924283145,"JB"],];
CONWAYPOLDATA[88093]:=[
,,,[52307156798,"JB"],];
CONWAYPOLDATA[88117]:=[
,,,[52387495079,"JB"],];
CONWAYPOLDATA[88129]:=[
,,,[68910797110,"JB"],];
CONWAYPOLDATA[88169]:=[
,,,[7281877713,"JB"],];
CONWAYPOLDATA[88177]:=[
,,,[120844726788,"JB"],];
CONWAYPOLDATA[88211]:=[
,,,[58402297827,"JB"],];
CONWAYPOLDATA[88223]:=[
,,,[21456098274,"JB"],];
CONWAYPOLDATA[88237]:=[
,,,[53140203830,"JB"],];
CONWAYPOLDATA[88241]:=[
,,,[20980444886,"JB"],];
CONWAYPOLDATA[88259]:=[
,,,[22400928533,"JB"],];
CONWAYPOLDATA[88261]:=[
,,,[30669461848,"JB"],];
CONWAYPOLDATA[88289]:=[
,,,[12723327793,"JB"],];
CONWAYPOLDATA[88301]:=[
,,,[22358166406,"JB"],];
CONWAYPOLDATA[88321]:=[
,,,[107969154657,"JB"],];
CONWAYPOLDATA[88327]:=[
,,,[44311447730,"JB"],];
CONWAYPOLDATA[88337]:=[
,,,[54512586029,"JB"],];
CONWAYPOLDATA[88339]:=[
,,,[43957398064,"JB"],];
CONWAYPOLDATA[88379]:=[
,,,[131935883120,"JB"],];
CONWAYPOLDATA[88397]:=[
,,,[53521378004,"JB"],];
CONWAYPOLDATA[88411]:=[
,,,[29577634819,"JB"],];
CONWAYPOLDATA[88423]:=[
,,,[22636553275,"JB"],];
CONWAYPOLDATA[88427]:=[
,,,[38568143468,"JB"],];
CONWAYPOLDATA[88463]:=[
,,,[31302455629,"JB"],];
CONWAYPOLDATA[88469]:=[
,,,[28413234856,"JB"],];
CONWAYPOLDATA[88471]:=[
,,,[27617815139,"JB"],];
CONWAYPOLDATA[88493]:=[
,,,[52036361806,"JB"],];
CONWAYPOLDATA[88499]:=[
,,,[30325775334,"JB"],];
CONWAYPOLDATA[88513]:=[
,,,[124009545426,"JB"],];
CONWAYPOLDATA[88523]:=[
,,,[6176603804,"JB"],];
CONWAYPOLDATA[88547]:=[
,,,[124431380128,"JB"],];
CONWAYPOLDATA[88589]:=[
,,,[154579389047,"JB"],];
CONWAYPOLDATA[88591]:=[
,,,[84300449294,"JB"],];
CONWAYPOLDATA[88607]:=[
,,,[94213342109,"JB"],];
CONWAYPOLDATA[88609]:=[
,,,[162750719978,"JB"],];
CONWAYPOLDATA[88643]:=[
,,,[5396497199,"JB"],];
CONWAYPOLDATA[88651]:=[
,,,[20566322795,"JB"],];
CONWAYPOLDATA[88657]:=[
,,,[99788063669,"JB"],];
CONWAYPOLDATA[88661]:=[
,,,[38336395775,"JB"],];
CONWAYPOLDATA[88663]:=[
,,,[86471693958,"JB"],];
CONWAYPOLDATA[88667]:=[
,,,[92660561682,"JB"],];
CONWAYPOLDATA[88681]:=[
,,,[7057233987,"JB"],];
CONWAYPOLDATA[88721]:=[
,,,[62694162327,"JB"],];
CONWAYPOLDATA[88729]:=[
,,,[179998045100,"JB"],];
CONWAYPOLDATA[88741]:=[
,,,[84905702723,"JB"],];
CONWAYPOLDATA[88747]:=[
,,,[92022119295,"JB"],];
CONWAYPOLDATA[88771]:=[
,,,[45447023629,"JB"],];
CONWAYPOLDATA[88789]:=[
,,,[83523634724,"JB"],];
CONWAYPOLDATA[88793]:=[
,,,[19843459643,"JB"],];
CONWAYPOLDATA[88799]:=[
,,,[39425512821,"JB"],];
CONWAYPOLDATA[88801]:=[
,,,[210355360847,"JB"],];
CONWAYPOLDATA[88807]:=[
,,,[31546377773,"JB"],];
CONWAYPOLDATA[88811]:=[
,,,[70755812513,"JB"],];
CONWAYPOLDATA[88813]:=[
,,,[11964620926,"JB"],];
CONWAYPOLDATA[88817]:=[
,,,[14191624348,"JB"],];
CONWAYPOLDATA[88819]:=[
,,,[12904778969,"JB"],];
CONWAYPOLDATA[88843]:=[
,,,[71037085942,"JB"],];
CONWAYPOLDATA[88853]:=[
,,,[20992409782,"JB"],];
CONWAYPOLDATA[88861]:=[
,,,[78692635772,"JB"],];
CONWAYPOLDATA[88867]:=[
,,,[70800783237,"JB"],];
CONWAYPOLDATA[88873]:=[
,,,[68399149259,"JB"],];
CONWAYPOLDATA[88883]:=[
,,,[59648670238,"JB"],];
CONWAYPOLDATA[88897]:=[
,,,[102733017988,"JB"],];
CONWAYPOLDATA[88903]:=[
,,,[28439447382,"JB"],];
CONWAYPOLDATA[88919]:=[
,,,[53332549195,"JB"],];
CONWAYPOLDATA[88937]:=[
,,,[62467303252,"JB"],];
CONWAYPOLDATA[88951]:=[
,,,[39561046204,"JB"],];
CONWAYPOLDATA[88969]:=[
,,,[4632882744,"JB"],];
CONWAYPOLDATA[88993]:=[
,,,[164883204643,"JB"],];
CONWAYPOLDATA[88997]:=[
,,,[94531456441,"JB"],];
CONWAYPOLDATA[89003]:=[
,,,[21510601054,"JB"],];
CONWAYPOLDATA[89009]:=[
,,,[63343254853,"JB"],];
CONWAYPOLDATA[89017]:=[
,,,[51881065979,"JB"],];
CONWAYPOLDATA[89021]:=[
,,,[102744299320,"JB"],];
CONWAYPOLDATA[89041]:=[
,,,[202645651658,"JB"],];
CONWAYPOLDATA[89051]:=[
,,,[60161786990,"JB"],];
CONWAYPOLDATA[89057]:=[
,,,[5542195227,"JB"],];
CONWAYPOLDATA[89069]:=[
,,,[132738640012,"JB"],];
CONWAYPOLDATA[89071]:=[
,,,[23016391761,"JB"],];
CONWAYPOLDATA[89083]:=[
,,,[70987570212,"JB"],];
CONWAYPOLDATA[89087]:=[
,,,[29182674030,"JB"],];
CONWAYPOLDATA[89101]:=[
,,,[60116088298,"JB"],];
CONWAYPOLDATA[89107]:=[
,,,[71414448724,"JB"],];
CONWAYPOLDATA[89113]:=[
,,,[84495699025,"JB"],];
CONWAYPOLDATA[89119]:=[
,,,[30895685807,"JB"],];
CONWAYPOLDATA[89123]:=[
,,,[21243803900,"JB"],];
CONWAYPOLDATA[89137]:=[
,,,[54266605605,"JB"],];
CONWAYPOLDATA[89153]:=[
,,,[14771849726,"JB"],];
CONWAYPOLDATA[89189]:=[
,,,[55091331790,"JB"],];
CONWAYPOLDATA[89203]:=[
,,,[71129134157,"JB"],];
CONWAYPOLDATA[89209]:=[
,,,[7000141043,"JB"],];
CONWAYPOLDATA[89213]:=[
,,,[15392364957,"JB"],];
CONWAYPOLDATA[89227]:=[
,,,[63131314675,"JB"],];
CONWAYPOLDATA[89231]:=[
,,,[20764499869,"JB"],];
CONWAYPOLDATA[89237]:=[
,,,[62753332379,"JB"],];
CONWAYPOLDATA[89261]:=[
,,,[20177716835,"JB"],];
CONWAYPOLDATA[89269]:=[
,,,[71719964368,"JB"],];
CONWAYPOLDATA[89273]:=[
,,,[95026019942,"JB"],];
CONWAYPOLDATA[89293]:=[
,,,[30439805119,"JB"],];
CONWAYPOLDATA[89303]:=[
,,,[22255915059,"JB"],];
CONWAYPOLDATA[89317]:=[
,,,[83995582459,"JB"],];
CONWAYPOLDATA[89329]:=[
,,,[118869117694,"JB"],];
CONWAYPOLDATA[89363]:=[
,,,[6379356486,"JB"],];
CONWAYPOLDATA[89371]:=[
,,,[70628292624,"JB"],];
CONWAYPOLDATA[89381]:=[
,,,[12284882166,"JB"],];
CONWAYPOLDATA[89387]:=[
,,,[62791507118,"JB"],];
CONWAYPOLDATA[89393]:=[
,,,[54218463577,"JB"],];
CONWAYPOLDATA[89399]:=[
,,,[20761934368,"JB"],];
CONWAYPOLDATA[89413]:=[
,,,[62950686174,"JB"],];
CONWAYPOLDATA[89417]:=[
,,,[13920885648,"JB"],];
CONWAYPOLDATA[89431]:=[
,,,[21701952488,"JB"],];
CONWAYPOLDATA[89443]:=[
,,,[85892917889,"JB"],];
CONWAYPOLDATA[89449]:=[
,,,[86536361673,"JB"],];
CONWAYPOLDATA[89459]:=[
,,,[60358971351,"JB"],];
CONWAYPOLDATA[89477]:=[
,,,[78118521191,"JB"],];
CONWAYPOLDATA[89491]:=[
,,,[72077125294,"JB"],];
CONWAYPOLDATA[89501]:=[
,,,[80044413843,"JB"],];
CONWAYPOLDATA[89513]:=[
,,,[180704100214,"JB"],];
CONWAYPOLDATA[89519]:=[
,,,[46036667584,"JB"],];
CONWAYPOLDATA[89521]:=[
,,,[87064454253,"JB"],];
CONWAYPOLDATA[89527]:=[
,,,[29111405066,"JB"],];
CONWAYPOLDATA[89533]:=[
,,,[52612097726,"JB"],];
CONWAYPOLDATA[89561]:=[
,,,[61408574385,"JB"],];
CONWAYPOLDATA[89563]:=[
,,,[62178485811,"JB"],];
CONWAYPOLDATA[89567]:=[
,,,[37176932963,"JB"],];
CONWAYPOLDATA[89591]:=[
,,,[23210698747,"JB"],];
CONWAYPOLDATA[89597]:=[
,,,[55038899520,"JB"],];
CONWAYPOLDATA[89599]:=[
,,,[30218517139,"JB"],];
CONWAYPOLDATA[89603]:=[
,,,[95346552302,"JB"],];
CONWAYPOLDATA[89611]:=[
,,,[68894729022,"JB"],];
CONWAYPOLDATA[89627]:=[
,,,[111088812541,"JB"],];
CONWAYPOLDATA[89633]:=[
,,,[23912471009,"JB"],];
CONWAYPOLDATA[89653]:=[
,,,[28404580701,"JB"],];
CONWAYPOLDATA[89657]:=[
,,,[36336547591,"JB"],];
CONWAYPOLDATA[89659]:=[
,,,[46113058254,"JB"],];
CONWAYPOLDATA[89669]:=[
,,,[31043676809,"JB"],];
CONWAYPOLDATA[89671]:=[
,,,[31641488408,"JB"],];
CONWAYPOLDATA[89681]:=[
,,,[72308176045,"JB"],];
CONWAYPOLDATA[89689]:=[
,,,[6572678994,"JB"],];
CONWAYPOLDATA[89753]:=[
,,,[14549320315,"JB"],];
CONWAYPOLDATA[89759]:=[
,,,[28727906517,"JB"],];
CONWAYPOLDATA[89767]:=[
,,,[45795622490,"JB"],];
CONWAYPOLDATA[89779]:=[
,,,[71529083998,"JB"],];
CONWAYPOLDATA[89783]:=[
,,,[46496640479,"JB"],];
CONWAYPOLDATA[89797]:=[
,,,[32027267416,"JB"],];
CONWAYPOLDATA[89809]:=[
,,,[141613794904,"JB"],];
CONWAYPOLDATA[89819]:=[
,,,[70147740812,"JB"],];
CONWAYPOLDATA[89821]:=[
,,,[53178612873,"JB"],];
CONWAYPOLDATA[89833]:=[
,,,[150757111774,"JB"],];
CONWAYPOLDATA[89839]:=[
,,,[4353867464,"JB"],];
CONWAYPOLDATA[89849]:=[
,,,[22796218736,"JB"],];
CONWAYPOLDATA[89867]:=[
,,,[56230141370,"JB"],];
CONWAYPOLDATA[89891]:=[
,,,[40401150393,"JB"],];
CONWAYPOLDATA[89897]:=[
,,,[4864146879,"JB"],];
CONWAYPOLDATA[89899]:=[
,,,[15632716910,"JB"],];
CONWAYPOLDATA[89909]:=[
,,,[61336009711,"JB"],];
CONWAYPOLDATA[89917]:=[
,,,[184306741333,"JB"],];
CONWAYPOLDATA[89923]:=[
,,,[201009288130,"JB"],];
CONWAYPOLDATA[89939]:=[
,,,[23308501303,"JB"],];
CONWAYPOLDATA[89959]:=[
,,,[29510060404,"JB"],];
CONWAYPOLDATA[89963]:=[
,,,[38366160760,"JB"],];
CONWAYPOLDATA[89977]:=[
,,,[55059535638,"JB"],];
CONWAYPOLDATA[89983]:=[
,,,[28856918222,"JB"],];
CONWAYPOLDATA[89989]:=[
,,,[87913673684,"JB"],];
CONWAYPOLDATA[90001]:=[
,,,[191526268059,"JB"],];
CONWAYPOLDATA[90007]:=[
,,,[46816781028,"JB"],];
CONWAYPOLDATA[90011]:=[
,,,[93744836304,"JB"],];
CONWAYPOLDATA[90017]:=[
,,,[5915107090,"JB"],];
CONWAYPOLDATA[90019]:=[
,,,[21521832553,"JB"],];
CONWAYPOLDATA[90023]:=[
,,,[44637544463,"JB"],];
CONWAYPOLDATA[90031]:=[
,,,[31535788590,"JB"],];
CONWAYPOLDATA[90053]:=[
,,,[32102813866,"JB"],];
CONWAYPOLDATA[90059]:=[
,,,[55185993786,"JB"],];
CONWAYPOLDATA[90067]:=[
,,,[142115818632,"JB"],];
CONWAYPOLDATA[90071]:=[
,,,[20728399521,"JB"],];
CONWAYPOLDATA[90073]:=[
,,,[182899531620,"JB"],];
CONWAYPOLDATA[90089]:=[
,,,[64780117055,"JB"],];
CONWAYPOLDATA[90107]:=[
,,,[126008151798,"JB"],];
CONWAYPOLDATA[90121]:=[
,,,[137879182037,"JB"],];
CONWAYPOLDATA[90127]:=[
,,,[29408530230,"JB"],];
CONWAYPOLDATA[90149]:=[
,,,[15923288319,"JB"],];
CONWAYPOLDATA[90163]:=[
,,,[24221207996,"JB"],];
CONWAYPOLDATA[90173]:=[
,,,[37985827117,"JB"],];
CONWAYPOLDATA[90187]:=[
,,,[21098256595,"JB"],];
CONWAYPOLDATA[90191]:=[
,,,[120465232605,"JB"],];
CONWAYPOLDATA[90197]:=[
,,,[6056187370,"JB"],];
CONWAYPOLDATA[90199]:=[
,,,[40678937212,"JB"],];
CONWAYPOLDATA[90203]:=[
,,,[64858031671,"JB"],];
CONWAYPOLDATA[90217]:=[
,,,[56661237957,"JB"],];
CONWAYPOLDATA[90227]:=[
,,,[15616850070,"JB"],];
CONWAYPOLDATA[90239]:=[
,,,[20922904786,"JB"],];
CONWAYPOLDATA[90247]:=[
,,,[79835113368,"JB"],];
CONWAYPOLDATA[90263]:=[
,,,[61811560827,"JB"],];
CONWAYPOLDATA[90271]:=[
,,,[30576141768,"JB"],];
CONWAYPOLDATA[90281]:=[
,,,[30773452506,"JB"],];
CONWAYPOLDATA[90289]:=[
,,,[71526674956,"JB"],];
CONWAYPOLDATA[90313]:=[
,,,[89528902539,"JB"],];
CONWAYPOLDATA[90353]:=[
,,,[15334259398,"JB"],];
CONWAYPOLDATA[90359]:=[
,,,[88541428726,"JB"],];
CONWAYPOLDATA[90371]:=[
,,,[38591037761,"JB"],];
CONWAYPOLDATA[90373]:=[
,,,[12618691622,"JB"],];
CONWAYPOLDATA[90379]:=[
,,,[72538637297,"JB"],];
CONWAYPOLDATA[90397]:=[
,,,[32189015747,"JB"],];
CONWAYPOLDATA[90401]:=[
,,,[4887078066,"JB"],];
CONWAYPOLDATA[90403]:=[
,,,[29216351140,"JB"],];
CONWAYPOLDATA[90407]:=[
,,,[98080022909,"JB"],];
CONWAYPOLDATA[90437]:=[
,,,[56286180062,"JB"],];
CONWAYPOLDATA[90439]:=[
,,,[21793085843,"JB"],];
CONWAYPOLDATA[90469]:=[
,,,[63780825940,"JB"],];
CONWAYPOLDATA[90473]:=[
,,,[6714091806,"JB"],];
CONWAYPOLDATA[90481]:=[
,,,[69650283232,"JB"],];
CONWAYPOLDATA[90499]:=[
,,,[88412726555,"JB"],];
CONWAYPOLDATA[90511]:=[
,,,[31895895381,"JB"],];
CONWAYPOLDATA[90523]:=[
,,,[65143157015,"JB"],];
CONWAYPOLDATA[90527]:=[
,,,[62956821101,"JB"],];
CONWAYPOLDATA[90529]:=[
,,,[201445311865,"JB"],];
CONWAYPOLDATA[90533]:=[
,,,[81700962654,"JB"],];
CONWAYPOLDATA[90547]:=[
,,,[86760324462,"JB"],];
CONWAYPOLDATA[90583]:=[
,,,[32820757229,"JB"],];
CONWAYPOLDATA[90599]:=[
,,,[29852914105,"JB"],];
CONWAYPOLDATA[90617]:=[
,,,[54175826538,"JB"],];
CONWAYPOLDATA[90619]:=[
,,,[45245613608,"JB"],];
CONWAYPOLDATA[90631]:=[
,,,[31474877469,"JB"],];
CONWAYPOLDATA[90641]:=[
,,,[23427888632,"JB"],];
CONWAYPOLDATA[90647]:=[
,,,[54051355753,"JB"],];
CONWAYPOLDATA[90659]:=[
,,,[97311013468,"JB"],];
CONWAYPOLDATA[90677]:=[
,,,[74000230224,"JB"],];
CONWAYPOLDATA[90679]:=[
,,,[31831049373,"JB"],];
CONWAYPOLDATA[90697]:=[
,,,[57095303354,"JB"],];
CONWAYPOLDATA[90703]:=[
,,,[23339786666,"JB"],];
CONWAYPOLDATA[90709]:=[
,,,[5886107016,"JB"],];
CONWAYPOLDATA[90731]:=[
,,,[71995502157,"JB"],];
CONWAYPOLDATA[90749]:=[
,,,[53881402011,"JB"],];
CONWAYPOLDATA[90787]:=[
,,,[29803737937,"JB"],];
CONWAYPOLDATA[90793]:=[
,,,[87995032124,"JB"],];
CONWAYPOLDATA[90803]:=[
,,,[62364317629,"JB"],];
CONWAYPOLDATA[90821]:=[
,,,[41241906924,"JB"],];
CONWAYPOLDATA[90823]:=[
,,,[74178141265,"JB"],];
CONWAYPOLDATA[90833]:=[
,,,[62474664904,"JB"],];
CONWAYPOLDATA[90841]:=[
,,,[169707975284,"JB"],];
CONWAYPOLDATA[90847]:=[
,,,[24194373045,"JB"],];
CONWAYPOLDATA[90863]:=[
,,,[33023975629,"JB"],];
CONWAYPOLDATA[90887]:=[
,,,[48604458978,"JB"],];
CONWAYPOLDATA[90901]:=[
,,,[63826228053,"JB"],];
CONWAYPOLDATA[90907]:=[
,,,[33055966973,"JB"],];
CONWAYPOLDATA[90911]:=[
,,,[22878207712,"JB"],];
CONWAYPOLDATA[90917]:=[
,,,[63815824223,"JB"],];
CONWAYPOLDATA[90931]:=[
,,,[22975990436,"JB"],];
CONWAYPOLDATA[90947]:=[
,,,[14602723163,"JB"],];
CONWAYPOLDATA[90971]:=[
,,,[39030288813,"JB"],];
CONWAYPOLDATA[90977]:=[
,,,[98116874963,"JB"],];
CONWAYPOLDATA[90989]:=[
,,,[30188876356,"JB"],];
CONWAYPOLDATA[90997]:=[
,,,[173270845591,"JB"],];
CONWAYPOLDATA[91009]:=[
,,,[139961740012,"JB"],];
CONWAYPOLDATA[91019]:=[
,,,[40357005431,"JB"],];
CONWAYPOLDATA[91033]:=[
,,,[124304104977,"JB"],];
CONWAYPOLDATA[91079]:=[
,,,[106215236859,"JB"],];
CONWAYPOLDATA[91081]:=[
,,,[253377960674,"JB"],];
CONWAYPOLDATA[91097]:=[
,,,[5228056833,"JB"],];
CONWAYPOLDATA[91099]:=[
,,,[74262629416,"JB"],];
CONWAYPOLDATA[91121]:=[
,,,[6762453900,"JB"],];
CONWAYPOLDATA[91127]:=[
,,,[29497445397,"JB"],];
CONWAYPOLDATA[91129]:=[
,,,[6682125061,"JB"],];
CONWAYPOLDATA[91139]:=[
,,,[14962927605,"JB"],];
CONWAYPOLDATA[91141]:=[
,,,[64980434212,"JB"],];
CONWAYPOLDATA[91151]:=[
,,,[24886592933,"JB"],];
CONWAYPOLDATA[91153]:=[
,,,[74579470394,"JB"],];
CONWAYPOLDATA[91159]:=[
,,,[24051299407,"JB"],];
CONWAYPOLDATA[91163]:=[
,,,[63078323429,"JB"],];
CONWAYPOLDATA[91183]:=[
,,,[31962376993,"JB"],];
CONWAYPOLDATA[91193]:=[
,,,[22934401152,"JB"],];
CONWAYPOLDATA[91199]:=[
,,,[38517806462,"JB"],];
CONWAYPOLDATA[91229]:=[
,,,[15122940103,"JB"],];
CONWAYPOLDATA[91237]:=[
,,,[54907977635,"JB"],];
CONWAYPOLDATA[91243]:=[
,,,[58276265404,"JB"],];
CONWAYPOLDATA[91249]:=[
,,,[182933805241,"JB"],];
CONWAYPOLDATA[91253]:=[
,,,[107094338296,"JB"],];
CONWAYPOLDATA[91283]:=[
,,,[113142996427,"JB"],];
CONWAYPOLDATA[91291]:=[
,,,[237633211732,"JB"],];
CONWAYPOLDATA[91297]:=[
,,,[56940204262,"JB"],];
CONWAYPOLDATA[91303]:=[
,,,[29916980104,"JB"],];
CONWAYPOLDATA[91309]:=[
,,,[91709572593,"JB"],];
CONWAYPOLDATA[91331]:=[
,,,[32511552727,"JB"],];
CONWAYPOLDATA[91367]:=[
,,,[57290124122,"JB"],];
CONWAYPOLDATA[91369]:=[
,,,[5373959111,"JB"],];
CONWAYPOLDATA[91373]:=[
,,,[172774099021,"JB"],];
CONWAYPOLDATA[91381]:=[
,,,[41243078128,"JB"],];
CONWAYPOLDATA[91387]:=[
,,,[72952231588,"JB"],];
CONWAYPOLDATA[91393]:=[
,,,[399802608422,"JB"],];
CONWAYPOLDATA[91397]:=[
,,,[12856176213,"JB"],];
CONWAYPOLDATA[91411]:=[
,,,[55746632708,"JB"],];
CONWAYPOLDATA[91423]:=[
,,,[24256807478,"JB"],];
CONWAYPOLDATA[91433]:=[
,,,[22241168686,"JB"],];
CONWAYPOLDATA[91453]:=[
,,,[55889671896,"JB"],];
CONWAYPOLDATA[91457]:=[
,,,[7778966595,"JB"],];
CONWAYPOLDATA[91459]:=[
,,,[74617190988,"JB"],];
CONWAYPOLDATA[91463]:=[
,,,[49767945121,"JB"],];
CONWAYPOLDATA[91493]:=[
,,,[80195993320,"JB"],];
CONWAYPOLDATA[91499]:=[
,,,[63237429375,"JB"],];
CONWAYPOLDATA[91513]:=[
,,,[56259538533,"JB"],];
CONWAYPOLDATA[91529]:=[
,,,[8376459496,"JB"],];
CONWAYPOLDATA[91541]:=[
,,,[13666796679,"JB"],];
CONWAYPOLDATA[91571]:=[
,,,[72192287127,"JB"],];
CONWAYPOLDATA[91573]:=[
,,,[33503264077,"JB"],];
CONWAYPOLDATA[91577]:=[
,,,[63802520096,"JB"],];
CONWAYPOLDATA[91583]:=[
,,,[25074692741,"JB"],];
CONWAYPOLDATA[91591]:=[
,,,[41944190044,"JB"],];
CONWAYPOLDATA[91621]:=[
,,,[31494535510,"JB"],];
CONWAYPOLDATA[91631]:=[
,,,[40375550799,"JB"],];
CONWAYPOLDATA[91639]:=[
,,,[31473047997,"JB"],];
CONWAYPOLDATA[91673]:=[
,,,[41226814871,"JB"],];
CONWAYPOLDATA[91691]:=[
,,,[23571188754,"JB"],];
CONWAYPOLDATA[91703]:=[
,,,[33637394029,"JB"],];
CONWAYPOLDATA[91711]:=[
,,,[56846788228,"JB"],];
CONWAYPOLDATA[91733]:=[
,,,[56880973045,"JB"],];
CONWAYPOLDATA[91753]:=[
,,,[75213053712,"JB"],];
CONWAYPOLDATA[91757]:=[
,,,[97218743670,"JB"],];
CONWAYPOLDATA[91771]:=[
,,,[74261643828,"JB"],];
CONWAYPOLDATA[91781]:=[
,,,[106721570087,"JB"],];
CONWAYPOLDATA[91801]:=[
,,,[92460773800,"JB"],];
CONWAYPOLDATA[91807]:=[
,,,[42142259020,"JB"],];
CONWAYPOLDATA[91811]:=[
,,,[65890183994,"JB"],];
CONWAYPOLDATA[91813]:=[
,,,[89972424791,"JB"],];
CONWAYPOLDATA[91823]:=[
,,,[49359453655,"JB"],];
CONWAYPOLDATA[91837]:=[
,,,[55095679575,"JB"],];
CONWAYPOLDATA[91841]:=[
,,,[39658413259,"JB"],];
CONWAYPOLDATA[91867]:=[
,,,[90551923897,"JB"],];
CONWAYPOLDATA[91873]:=[
,,,[57992442557,"JB"],];
CONWAYPOLDATA[91909]:=[
,,,[81037727755,"JB"],];
CONWAYPOLDATA[91921]:=[
,,,[140975744715,"JB"],];
CONWAYPOLDATA[91939]:=[
,,,[30255378061,"JB"],];
CONWAYPOLDATA[91943]:=[
,,,[30946174945,"JB"],];
CONWAYPOLDATA[91951]:=[
,,,[32932066751,"JB"],];
CONWAYPOLDATA[91957]:=[
,,,[40271924458,"JB"],];
CONWAYPOLDATA[91961]:=[
,,,[32624912024,"JB"],];
CONWAYPOLDATA[91967]:=[
,,,[33831348493,"JB"],];
CONWAYPOLDATA[91969]:=[
,,,[141721102067,"JB"],];
CONWAYPOLDATA[91997]:=[
,,,[55878885805,"JB"],];
CONWAYPOLDATA[92003]:=[
,,,[117954746227,"JB"],];
CONWAYPOLDATA[92009]:=[
,,,[21982238229,"JB"],];
CONWAYPOLDATA[92033]:=[
,,,[4670490687,"JB"],];
CONWAYPOLDATA[92041]:=[
,,,[5953303928,"JB"],];
CONWAYPOLDATA[92051]:=[
,,,[23819945225,"JB"],];
CONWAYPOLDATA[92077]:=[
,,,[30996340897,"JB"],];
CONWAYPOLDATA[92083]:=[
,,,[107976249553,"JB"],];
CONWAYPOLDATA[92107]:=[
,,,[72688910155,"JB"],];
CONWAYPOLDATA[92111]:=[
,,,[67111429836,"JB"],];
CONWAYPOLDATA[92119]:=[
,,,[57121886475,"JB"],];
CONWAYPOLDATA[92143]:=[
,,,[48459109421,"JB"],];
CONWAYPOLDATA[92153]:=[
,,,[65093469542,"JB"],];
CONWAYPOLDATA[92173]:=[
,,,[109326856167,"JB"],];
CONWAYPOLDATA[92177]:=[
,,,[74746974545,"JB"],];
CONWAYPOLDATA[92179]:=[
,,,[24850260076,"JB"],];
CONWAYPOLDATA[92189]:=[
,,,[22224831933,"JB"],];
CONWAYPOLDATA[92203]:=[
,,,[99903517953,"JB"],];
CONWAYPOLDATA[92219]:=[
,,,[65241714837,"JB"],];
CONWAYPOLDATA[92221]:=[
,,,[72427975660,"JB"],];
CONWAYPOLDATA[92227]:=[
,,,[33681392630,"JB"],];
CONWAYPOLDATA[92233]:=[
,,,[134433194592,"JB"],];
CONWAYPOLDATA[92237]:=[
,,,[14617811999,"JB"],];
CONWAYPOLDATA[92243]:=[
,,,[41711362172,"JB"],];
CONWAYPOLDATA[92251]:=[
,,,[57841100249,"JB"],];
CONWAYPOLDATA[92269]:=[
,,,[32706038826,"JB"],];
CONWAYPOLDATA[92297]:=[
,,,[56387929183,"JB"],];
CONWAYPOLDATA[92311]:=[
,,,[50914316679,"JB"],];
CONWAYPOLDATA[92317]:=[
,,,[41113929858,"JB"],];
CONWAYPOLDATA[92333]:=[
,,,[32544704845,"JB"],];
CONWAYPOLDATA[92347]:=[
,,,[4336892166,"JB"],];
CONWAYPOLDATA[92353]:=[
,,,[107821019269,"JB"],];
CONWAYPOLDATA[92357]:=[
,,,[124300607950,"JB"],];
CONWAYPOLDATA[92363]:=[
,,,[108705339770,"JB"],];
CONWAYPOLDATA[92369]:=[
,,,[41939497870,"JB"],];
CONWAYPOLDATA[92377]:=[
,,,[89666196942,"JB"],];
CONWAYPOLDATA[92381]:=[
,,,[57208781872,"JB"],];
CONWAYPOLDATA[92383]:=[
,,,[42672723916,"JB"],];
CONWAYPOLDATA[92387]:=[
,,,[73297074192,"JB"],];
CONWAYPOLDATA[92399]:=[
,,,[42603608130,"JB"],];
CONWAYPOLDATA[92401]:=[
,,,[279934281193,"JB"],];
CONWAYPOLDATA[92413]:=[
,,,[30373288299,"JB"],];
CONWAYPOLDATA[92419]:=[
,,,[76870797118,"JB"],];
CONWAYPOLDATA[92431]:=[
,,,[32630176488,"JB"],];
CONWAYPOLDATA[92459]:=[
,,,[64873949811,"JB"],];
CONWAYPOLDATA[92461]:=[
,,,[32734707520,"JB"],];
CONWAYPOLDATA[92467]:=[
,,,[73060488377,"JB"],];
CONWAYPOLDATA[92479]:=[
,,,[31456546898,"JB"],];
CONWAYPOLDATA[92489]:=[
,,,[8553105256,"JB"],];
CONWAYPOLDATA[92503]:=[
,,,[93282707792,"JB"],];
CONWAYPOLDATA[92507]:=[
,,,[76601531436,"JB"],];
CONWAYPOLDATA[92551]:=[
,,,[48593624904,"JB"],];
CONWAYPOLDATA[92557]:=[
,,,[59438531933,"JB"],];
CONWAYPOLDATA[92567]:=[
,,,[41015882303,"JB"],];
CONWAYPOLDATA[92569]:=[
,,,[230702405780,"JB"],];
CONWAYPOLDATA[92581]:=[
,,,[6739341320,"JB"],];
CONWAYPOLDATA[92593]:=[
,,,[128600936217,"JB"],];
CONWAYPOLDATA[92623]:=[
,,,[49238294188,"JB"],];
CONWAYPOLDATA[92627]:=[
,,,[5250746751,"JB"],];
CONWAYPOLDATA[92639]:=[
,,,[66584651813,"JB"],];
CONWAYPOLDATA[92641]:=[
,,,[193220129378,"JB"],];
CONWAYPOLDATA[92647]:=[
,,,[32758960086,"JB"],];
CONWAYPOLDATA[92657]:=[
,,,[8505541975,"JB"],];
CONWAYPOLDATA[92669]:=[
,,,[82883987623,"JB"],];
CONWAYPOLDATA[92671]:=[
,,,[23797264106,"JB"],];
CONWAYPOLDATA[92681]:=[
,,,[65129348409,"JB"],];
CONWAYPOLDATA[92683]:=[
,,,[24530502296,"JB"],];
CONWAYPOLDATA[92693]:=[
,,,[31070230137,"JB"],];
CONWAYPOLDATA[92699]:=[
,,,[21979489096,"JB"],];
CONWAYPOLDATA[92707]:=[
,,,[21923536776,"JB"],];
CONWAYPOLDATA[92717]:=[
,,,[111011083989,"JB"],];
CONWAYPOLDATA[92723]:=[
,,,[31694297693,"JB"],];
CONWAYPOLDATA[92737]:=[
,,,[144335032172,"JB"],];
CONWAYPOLDATA[92753]:=[
,,,[13953390311,"JB"],];
CONWAYPOLDATA[92761]:=[
,,,[254811313152,"JB"],];
CONWAYPOLDATA[92767]:=[
,,,[57875383196,"JB"],];
CONWAYPOLDATA[92779]:=[
,,,[77214023846,"JB"],];
CONWAYPOLDATA[92789]:=[
,,,[57849023685,"JB"],];
CONWAYPOLDATA[92791]:=[
,,,[31795764066,"JB"],];
CONWAYPOLDATA[92801]:=[
,,,[21856398722,"JB"],];
CONWAYPOLDATA[92809]:=[
,,,[75448519710,"JB"],];
CONWAYPOLDATA[92821]:=[
,,,[112003851971,"JB"],];
CONWAYPOLDATA[92831]:=[
,,,[22055253142,"JB"],];
CONWAYPOLDATA[92849]:=[
,,,[76387429397,"JB"],];
CONWAYPOLDATA[92857]:=[
,,,[129335315313,"JB"],];
CONWAYPOLDATA[92861]:=[
,,,[16929953217,"JB"],];
CONWAYPOLDATA[92863]:=[
,,,[49051072373,"JB"],];
CONWAYPOLDATA[92867]:=[
,,,[92100290050,"JB"],];
CONWAYPOLDATA[92893]:=[
,,,[32253935893,"JB"],];
CONWAYPOLDATA[92899]:=[
,,,[7995816937,"JB"],];
CONWAYPOLDATA[92921]:=[
,,,[8633197192,"JB"],];
CONWAYPOLDATA[92927]:=[
,,,[103624012829,"JB"],];
CONWAYPOLDATA[92941]:=[
,,,[92173028519,"JB"],];
CONWAYPOLDATA[92951]:=[
,,,[21661486953,"JB"],];
CONWAYPOLDATA[92957]:=[
,,,[66475409842,"JB"],];
CONWAYPOLDATA[92959]:=[
,,,[48806356735,"JB"],];
CONWAYPOLDATA[92987]:=[
,,,[23022186397,"JB"],];
CONWAYPOLDATA[92993]:=[
,,,[41525001230,"JB"],];
CONWAYPOLDATA[93001]:=[
,,,[76738752153,"JB"],];
CONWAYPOLDATA[93047]:=[
,,,[74120868017,"JB"],];
CONWAYPOLDATA[93053]:=[
,,,[59809164381,"JB"],];
CONWAYPOLDATA[93059]:=[
,,,[66244142211,"JB"],];
CONWAYPOLDATA[93077]:=[
,,,[33706811705,"JB"],];
CONWAYPOLDATA[93083]:=[
,,,[73815191334,"JB"],];
CONWAYPOLDATA[93089]:=[
,,,[6264796614,"JB"],];
CONWAYPOLDATA[93097]:=[
,,,[91746534928,"JB"],];
CONWAYPOLDATA[93103]:=[
,,,[73704058925,"JB"],];
CONWAYPOLDATA[93113]:=[
,,,[103010818790,"JB"],];
CONWAYPOLDATA[93131]:=[
,,,[48087819332,"JB"],];
CONWAYPOLDATA[93133]:=[
,,,[8027505808,"JB"],];
CONWAYPOLDATA[93139]:=[
,,,[77014869461,"JB"],];
CONWAYPOLDATA[93151]:=[
,,,[32930462070,"JB"],];
CONWAYPOLDATA[93169]:=[
,,,[95168406751,"JB"],];
CONWAYPOLDATA[93179]:=[
,,,[76848727999,"JB"],];
CONWAYPOLDATA[93187]:=[
,,,[48474293224,"JB"],];
CONWAYPOLDATA[93199]:=[
,,,[49186704247,"JB"],];
CONWAYPOLDATA[93229]:=[
,,,[68588202390,"JB"],];
CONWAYPOLDATA[93239]:=[
,,,[67041544942,"JB"],];
CONWAYPOLDATA[93241]:=[
,,,[265982353566,"JB"],];
CONWAYPOLDATA[93251]:=[
,,,[77982734019,"JB"],];
CONWAYPOLDATA[93253]:=[
,,,[32594534586,"JB"],];
CONWAYPOLDATA[93257]:=[
,,,[8621516396,"JB"],];
CONWAYPOLDATA[93263]:=[
,,,[16062499969,"JB"],];
CONWAYPOLDATA[93281]:=[
,,,[25246969058,"JB"],];
CONWAYPOLDATA[93283]:=[
,,,[78216769389,"JB"],];
CONWAYPOLDATA[93287]:=[
,,,[34809484333,"JB"],];
CONWAYPOLDATA[93307]:=[
,,,[130543584334,"JB"],];
CONWAYPOLDATA[93319]:=[
,,,[31587921589,"JB"],];
CONWAYPOLDATA[93323]:=[
,,,[67472529002,"JB"],];
CONWAYPOLDATA[93329]:=[
,,,[22891457136,"JB"],];
CONWAYPOLDATA[93337]:=[
,,,[130675906833,"JB"],];
CONWAYPOLDATA[93371]:=[
,,,[104219309637,"JB"],];
CONWAYPOLDATA[93377]:=[
,,,[7255392903,"JB"],];
CONWAYPOLDATA[93383]:=[
,,,[49335359501,"JB"],];
CONWAYPOLDATA[93407]:=[
,,,[40767298341,"JB"],];
CONWAYPOLDATA[93419]:=[
,,,[66032005705,"JB"],];
CONWAYPOLDATA[93427]:=[
,,,[22324101371,"JB"],];
CONWAYPOLDATA[93463]:=[
,,,[50384501358,"JB"],];
CONWAYPOLDATA[93479]:=[
,,,[40973154413,"JB"],];
CONWAYPOLDATA[93481]:=[
,,,[75777007369,"JB"],];
CONWAYPOLDATA[93487]:=[
,,,[25497457412,"JB"],];
CONWAYPOLDATA[93491]:=[
,,,[22317423594,"JB"],];
CONWAYPOLDATA[93493]:=[
,,,[110894291134,"JB"],];
CONWAYPOLDATA[93497]:=[
,,,[6905314435,"JB"],];
CONWAYPOLDATA[93503]:=[
,,,[92688962887,"JB"],];
CONWAYPOLDATA[93523]:=[
,,,[101081341816,"JB"],];
CONWAYPOLDATA[93529]:=[
,,,[214638112118,"JB"],];
CONWAYPOLDATA[93553]:=[
,,,[92961183727,"JB"],];
CONWAYPOLDATA[93557]:=[
,,,[57387302460,"JB"],];
CONWAYPOLDATA[93559]:=[
,,,[34446552623,"JB"],];
CONWAYPOLDATA[93563]:=[
,,,[4637356537,"JB"],];
CONWAYPOLDATA[93581]:=[
,,,[113317607227,"JB"],];
CONWAYPOLDATA[93601]:=[
,,,[112735571649,"JB"],];
CONWAYPOLDATA[93607]:=[
,,,[49052501785,"JB"],];
CONWAYPOLDATA[93629]:=[
,,,[76324956367,"JB"],];
CONWAYPOLDATA[93637]:=[
,,,[69362075940,"JB"],];
CONWAYPOLDATA[93683]:=[
,,,[163667011492,"JB"],];
CONWAYPOLDATA[93701]:=[
,,,[41232843949,"JB"],];
CONWAYPOLDATA[93703]:=[
,,,[22074833854,"JB"],];
CONWAYPOLDATA[93719]:=[
,,,[76632245652,"JB"],];
CONWAYPOLDATA[93739]:=[
,,,[5656867436,"JB"],];
CONWAYPOLDATA[93761]:=[
,,,[5257460559,"JB"],];
CONWAYPOLDATA[93763]:=[
,,,[22415826649,"JB"],];
CONWAYPOLDATA[93787]:=[
,,,[172647236235,"JB"],];
CONWAYPOLDATA[93809]:=[
,,,[8799002776,"JB"],];
CONWAYPOLDATA[93811]:=[
,,,[76192637525,"JB"],];
CONWAYPOLDATA[93827]:=[
,,,[22667758759,"JB"],];
CONWAYPOLDATA[93851]:=[
,,,[75447945114,"JB"],];
CONWAYPOLDATA[93871]:=[
,,,[23175060225,"JB"],];
CONWAYPOLDATA[93887]:=[
,,,[24508074711,"JB"],];
CONWAYPOLDATA[93889]:=[
,,,[94701327642,"JB"],];
CONWAYPOLDATA[93893]:=[
,,,[24714984927,"JB"],];
CONWAYPOLDATA[93901]:=[
,,,[70055122755,"JB"],];
CONWAYPOLDATA[93911]:=[
,,,[25838578640,"JB"],];
CONWAYPOLDATA[93913]:=[
,,,[59340525576,"JB"],];
CONWAYPOLDATA[93923]:=[
,,,[70017811965,"JB"],];
CONWAYPOLDATA[93937]:=[
,,,[128073330067,"JB"],];
CONWAYPOLDATA[93941]:=[
,,,[70131465670,"JB"],];
CONWAYPOLDATA[93949]:=[
,,,[5662869926,"JB"],];
CONWAYPOLDATA[93967]:=[
,,,[25719707581,"JB"],];
CONWAYPOLDATA[93971]:=[
,,,[41169634812,"JB"],];
CONWAYPOLDATA[93979]:=[
,,,[31572151074,"JB"],];
CONWAYPOLDATA[93983]:=[
,,,[52897015793,"JB"],];
CONWAYPOLDATA[93997]:=[
,,,[32990785080,"JB"],];
CONWAYPOLDATA[94007]:=[
,,,[101883282493,"JB"],];
CONWAYPOLDATA[94009]:=[
,,,[8834025743,"JB"],];
CONWAYPOLDATA[94033]:=[
,,,[122032642227,"JB"],];
CONWAYPOLDATA[94049]:=[
,,,[40848678369,"JB"],];
CONWAYPOLDATA[94057]:=[
,,,[131422742226,"JB"],];
CONWAYPOLDATA[94063]:=[
,,,[23508789341,"JB"],];
CONWAYPOLDATA[94079]:=[
,,,[58548654478,"JB"],];
CONWAYPOLDATA[94099]:=[
,,,[22693103040,"JB"],];
CONWAYPOLDATA[94109]:=[
,,,[158220097489,"JB"],];
CONWAYPOLDATA[94111]:=[
,,,[35047783402,"JB"],];
CONWAYPOLDATA[94117]:=[
,,,[96691288186,"JB"],];
CONWAYPOLDATA[94121]:=[
,,,[8857633192,"JB"],];
CONWAYPOLDATA[94151]:=[
,,,[50829017924,"JB"],];
CONWAYPOLDATA[94153]:=[
,,,[59411672841,"JB"],];
CONWAYPOLDATA[94169]:=[
,,,[8866670536,"JB"],];
CONWAYPOLDATA[94201]:=[
,,,[244646496880,"JB"],];
CONWAYPOLDATA[94207]:=[
,,,[26486203849,"JB"],];
CONWAYPOLDATA[94219]:=[
,,,[31918759071,"JB"],];
CONWAYPOLDATA[94229]:=[
,,,[84933780297,"JB"],];
CONWAYPOLDATA[94253]:=[
,,,[42164079552,"JB"],];
CONWAYPOLDATA[94261]:=[
,,,[68439612971,"JB"],];
CONWAYPOLDATA[94273]:=[
,,,[61926708156,"JB"],];
CONWAYPOLDATA[94291]:=[
,,,[75950080428,"JB"],];
CONWAYPOLDATA[94307]:=[
,,,[40435540857,"JB"],];
CONWAYPOLDATA[94309]:=[
,,,[23482941006,"JB"],];
CONWAYPOLDATA[94321]:=[
,,,[6060878825,"JB"],];
CONWAYPOLDATA[94327]:=[
,,,[53214105418,"JB"],];
CONWAYPOLDATA[94331]:=[
,,,[23178258674,"JB"],];
CONWAYPOLDATA[94343]:=[
,,,[53065673273,"JB"],];
CONWAYPOLDATA[94349]:=[
,,,[33365297315,"JB"],];
CONWAYPOLDATA[94351]:=[
,,,[60070073769,"JB"],];
CONWAYPOLDATA[94379]:=[
,,,[23676954111,"JB"],];
CONWAYPOLDATA[94397]:=[
,,,[42747870246,"JB"],];
CONWAYPOLDATA[94399]:=[
,,,[33998366247,"JB"],];
CONWAYPOLDATA[94421]:=[
,,,[33083324403,"JB"],];
CONWAYPOLDATA[94427]:=[
,,,[22316405047,"JB"],];
CONWAYPOLDATA[94433]:=[
,,,[41091292326,"JB"],];
CONWAYPOLDATA[94439]:=[
,,,[24883637678,"JB"],];
CONWAYPOLDATA[94441]:=[
,,,[184195837591,"JB"],];
CONWAYPOLDATA[94447]:=[
,,,[107041696349,"JB"],];
CONWAYPOLDATA[94463]:=[
,,,[69391008397,"JB"],];
CONWAYPOLDATA[94477]:=[
,,,[89075372004,"JB"],];
CONWAYPOLDATA[94483]:=[
,,,[76040863232,"JB"],];
CONWAYPOLDATA[94513]:=[
,,,[96372921332,"JB"],];
CONWAYPOLDATA[94529]:=[
,,,[69193337423,"JB"],];
CONWAYPOLDATA[94531]:=[
,,,[24849553042,"JB"],];
CONWAYPOLDATA[94541]:=[
,,,[35012597565,"JB"],];
CONWAYPOLDATA[94543]:=[
,,,[31959693895,"JB"],];
CONWAYPOLDATA[94547]:=[
,,,[42883871886,"JB"],];
CONWAYPOLDATA[94559]:=[
,,,[24162566722,"JB"],];
CONWAYPOLDATA[94561]:=[
,,,[184232156143,"JB"],];
CONWAYPOLDATA[94573]:=[
,,,[34706021250,"JB"],];
CONWAYPOLDATA[94583]:=[
,,,[35783397229,"JB"],];
CONWAYPOLDATA[94597]:=[
,,,[60070230169,"JB"],];
CONWAYPOLDATA[94603]:=[
,,,[169576539726,"JB"],];
CONWAYPOLDATA[94613]:=[
,,,[61464957001,"JB"],];
CONWAYPOLDATA[94621]:=[
,,,[94060370577,"JB"],];
CONWAYPOLDATA[94649]:=[
,,,[97137795458,"JB"],];
CONWAYPOLDATA[94651]:=[
,,,[76849229224,"JB"],];
CONWAYPOLDATA[94687]:=[
,,,[114953047989,"JB"],];
CONWAYPOLDATA[94693]:=[
,,,[211438200538,"JB"],];
CONWAYPOLDATA[94709]:=[
,,,[70569380664,"JB"],];
CONWAYPOLDATA[94723]:=[
,,,[80751357502,"JB"],];
CONWAYPOLDATA[94727]:=[
,,,[77625271606,"JB"],];
CONWAYPOLDATA[94747]:=[
,,,[79448865141,"JB"],];
CONWAYPOLDATA[94771]:=[
,,,[6464519462,"JB"],];
CONWAYPOLDATA[94777]:=[
,,,[149510338402,"JB"],];
CONWAYPOLDATA[94781]:=[
,,,[62073309055,"JB"],];
CONWAYPOLDATA[94789]:=[
,,,[61186015135,"JB"],];
CONWAYPOLDATA[94793]:=[
,,,[14856243342,"JB"],];
CONWAYPOLDATA[94811]:=[
,,,[24161445620,"JB"],];
CONWAYPOLDATA[94819]:=[
,,,[78749075882,"JB"],];
CONWAYPOLDATA[94823]:=[
,,,[35965226029,"JB"],];
CONWAYPOLDATA[94837]:=[
,,,[59245717109,"JB"],];
CONWAYPOLDATA[94841]:=[
,,,[43564833989,"JB"],];
CONWAYPOLDATA[94847]:=[
,,,[34542708323,"JB"],];
CONWAYPOLDATA[94849]:=[
,,,[60092911843,"JB"],];
CONWAYPOLDATA[94873]:=[
,,,[96058153521,"JB"],];
CONWAYPOLDATA[94889]:=[
,,,[78020108028,"JB"],];
CONWAYPOLDATA[94903]:=[
,,,[51935287141,"JB"],];
CONWAYPOLDATA[94907]:=[
,,,[7893605006,"JB"],];
CONWAYPOLDATA[94933]:=[
,,,[81109805872,"JB"],];
CONWAYPOLDATA[94949]:=[
,,,[44967086810,"JB"],];
CONWAYPOLDATA[94951]:=[
,,,[26950037287,"JB"],];
CONWAYPOLDATA[94961]:=[
,,,[43041643019,"JB"],];
CONWAYPOLDATA[94993]:=[
,,,[61066250060,"JB"],];
CONWAYPOLDATA[94999]:=[
,,,[33532557025,"JB"],];
CONWAYPOLDATA[95003]:=[
,,,[8451751891,"JB"],];
CONWAYPOLDATA[95009]:=[
,,,[9025569976,"JB"],];
CONWAYPOLDATA[95021]:=[
,,,[35995190075,"JB"],];
CONWAYPOLDATA[95027]:=[
,,,[42682517376,"JB"],];
CONWAYPOLDATA[95063]:=[
,,,[35304496945,"JB"],];
CONWAYPOLDATA[95071]:=[
,,,[35214108261,"JB"],];
CONWAYPOLDATA[95083]:=[
,,,[78581345352,"JB"],];
CONWAYPOLDATA[95087]:=[
,,,[60694222279,"JB"],];
CONWAYPOLDATA[95089]:=[
,,,[259139870928,"JB"],];
CONWAYPOLDATA[95093]:=[
,,,[88908721840,"JB"],];
CONWAYPOLDATA[95101]:=[
,,,[33316638231,"JB"],];
CONWAYPOLDATA[95107]:=[
,,,[23712267459,"JB"],];
CONWAYPOLDATA[95111]:=[
,,,[59740931109,"JB"],];
CONWAYPOLDATA[95131]:=[
,,,[61054885545,"JB"],];
CONWAYPOLDATA[95143]:=[
,,,[45260571676,"JB"],];
CONWAYPOLDATA[95153]:=[
,,,[7064444182,"JB"],];
CONWAYPOLDATA[95177]:=[
,,,[114429689094,"JB"],];
CONWAYPOLDATA[95189]:=[
,,,[16981051279,"JB"],];
CONWAYPOLDATA[95191]:=[
,,,[45182027399,"JB"],];
CONWAYPOLDATA[95203]:=[
,,,[68041108087,"JB"],];
CONWAYPOLDATA[95213]:=[
,,,[62746795198,"JB"],];
CONWAYPOLDATA[95219]:=[
,,,[22873889058,"JB"],];
CONWAYPOLDATA[95231]:=[
,,,[51201232854,"JB"],];
CONWAYPOLDATA[95233]:=[
,,,[97207941959,"JB"],];
CONWAYPOLDATA[95239]:=[
,,,[104513469066,"JB"],];
CONWAYPOLDATA[95257]:=[
,,,[61666714609,"JB"],];
CONWAYPOLDATA[95261]:=[
,,,[42281213808,"JB"],];
CONWAYPOLDATA[95267]:=[
,,,[68195834015,"JB"],];
CONWAYPOLDATA[95273]:=[
,,,[116876629118,"JB"],];
CONWAYPOLDATA[95279]:=[
,,,[25860149792,"JB"],];
CONWAYPOLDATA[95287]:=[
,,,[62669497607,"JB"],];
CONWAYPOLDATA[95311]:=[
,,,[61155921909,"JB"],];
CONWAYPOLDATA[95317]:=[
,,,[77319530016,"JB"],];
CONWAYPOLDATA[95327]:=[
,,,[71379999662,"JB"],];
CONWAYPOLDATA[95339]:=[
,,,[43966342564,"JB"],];
CONWAYPOLDATA[95369]:=[
,,,[70979713419,"JB"],];
CONWAYPOLDATA[95383]:=[
,,,[52467326813,"JB"],];
CONWAYPOLDATA[95393]:=[
,,,[107184910305,"JB"],];
CONWAYPOLDATA[95401]:=[
,,,[241293074658,"JB"],];
CONWAYPOLDATA[95413]:=[
,,,[33856253509,"JB"],];
CONWAYPOLDATA[95419]:=[
,,,[72658992190,"JB"],];
CONWAYPOLDATA[95429]:=[
,,,[16292688601,"JB"],];
CONWAYPOLDATA[95441]:=[
,,,[26981838790,"JB"],];
CONWAYPOLDATA[95443]:=[
,,,[51681907288,"JB"],];
CONWAYPOLDATA[95461]:=[
,,,[62735632748,"JB"],];
CONWAYPOLDATA[95467]:=[
,,,[8583819843,"JB"],];
CONWAYPOLDATA[95471]:=[
,,,[43959717464,"JB"],];
CONWAYPOLDATA[95479]:=[
,,,[89008292708,"JB"],];
CONWAYPOLDATA[95483]:=[
,,,[26517538762,"JB"],];
CONWAYPOLDATA[95507]:=[
,,,[100120561144,"JB"],];
CONWAYPOLDATA[95527]:=[
,,,[35226918631,"JB"],];
CONWAYPOLDATA[95531]:=[
,,,[80333928522,"JB"],];
CONWAYPOLDATA[95539]:=[
,,,[33858639447,"JB"],];
CONWAYPOLDATA[95549]:=[
,,,[82165833768,"JB"],];
CONWAYPOLDATA[95561]:=[
,,,[25804623516,"JB"],];
CONWAYPOLDATA[95569]:=[
,,,[118445160406,"JB"],];
CONWAYPOLDATA[95581]:=[
,,,[34044231744,"JB"],];
CONWAYPOLDATA[95597]:=[
,,,[16522698691,"JB"],];
CONWAYPOLDATA[95603]:=[
,,,[41704227474,"JB"],];
CONWAYPOLDATA[95617]:=[
,,,[98525191060,"JB"],];
CONWAYPOLDATA[95621]:=[
,,,[136583410846,"JB"],];
CONWAYPOLDATA[95629]:=[
,,,[96341722939,"JB"],];
CONWAYPOLDATA[95633]:=[
,,,[25481986651,"JB"],];
CONWAYPOLDATA[95651]:=[
,,,[26133001014,"JB"],];
CONWAYPOLDATA[95701]:=[
,,,[99074938757,"JB"],];
CONWAYPOLDATA[95707]:=[
,,,[70282913987,"JB"],];
CONWAYPOLDATA[95713]:=[
,,,[62617837430,"JB"],];
CONWAYPOLDATA[95717]:=[
,,,[26080872445,"JB"],];
CONWAYPOLDATA[95723]:=[
,,,[24731855789,"JB"],];
CONWAYPOLDATA[95731]:=[
,,,[61637840317,"JB"],];
CONWAYPOLDATA[95737]:=[
,,,[62601371198,"JB"],];
CONWAYPOLDATA[95747]:=[
,,,[7119363937,"JB"],];
CONWAYPOLDATA[95773]:=[
,,,[81917903189,"JB"],];
CONWAYPOLDATA[95783]:=[
,,,[36697149229,"JB"],];
CONWAYPOLDATA[95789]:=[
,,,[62160259983,"JB"],];
CONWAYPOLDATA[95791]:=[
,,,[35589613397,"JB"],];
CONWAYPOLDATA[95801]:=[
,,,[42432178923,"JB"],];
CONWAYPOLDATA[95803]:=[
,,,[106303583621,"JB"],];
CONWAYPOLDATA[95813]:=[
,,,[115775255300,"JB"],];
CONWAYPOLDATA[95819]:=[
,,,[41739139678,"JB"],];
CONWAYPOLDATA[95857]:=[
,,,[61478749673,"JB"],];
CONWAYPOLDATA[95869]:=[
,,,[71064430160,"JB"],];
CONWAYPOLDATA[95873]:=[
,,,[5856402208,"JB"],];
CONWAYPOLDATA[95881]:=[
,,,[154853184349,"JB"],];
CONWAYPOLDATA[95891]:=[
,,,[26086667097,"JB"],];
CONWAYPOLDATA[95911]:=[
,,,[25853865074,"JB"],];
CONWAYPOLDATA[95917]:=[
,,,[34805114041,"JB"],];
CONWAYPOLDATA[95923]:=[
,,,[23394660473,"JB"],];
CONWAYPOLDATA[95929]:=[
,,,[4634521874,"JB"],];
CONWAYPOLDATA[95947]:=[
,,,[27383465696,"JB"],];
CONWAYPOLDATA[95957]:=[
,,,[54155539963,"JB"],];
CONWAYPOLDATA[95959]:=[
,,,[32951552931,"JB"],];
CONWAYPOLDATA[95971]:=[
,,,[60365087206,"JB"],];
CONWAYPOLDATA[95987]:=[
,,,[127980139011,"JB"],];
CONWAYPOLDATA[95989]:=[
,,,[80331178337,"JB"],];
CONWAYPOLDATA[96001]:=[
,,,[163951179814,"JB"],];
CONWAYPOLDATA[96013]:=[
,,,[91923902345,"JB"],];
CONWAYPOLDATA[96017]:=[
,,,[15721919600,"JB"],];
CONWAYPOLDATA[96043]:=[
,,,[71763521688,"JB"],];
CONWAYPOLDATA[96053]:=[
,,,[64328903321,"JB"],];
CONWAYPOLDATA[96059]:=[
,,,[44347366414,"JB"],];
CONWAYPOLDATA[96079]:=[
,,,[35515506274,"JB"],];
CONWAYPOLDATA[96097]:=[
,,,[63277952565,"JB"],];
CONWAYPOLDATA[96137]:=[
,,,[72197925633,"JB"],];
CONWAYPOLDATA[96149]:=[
,,,[62088120603,"JB"],];
CONWAYPOLDATA[96157]:=[
,,,[17479419465,"JB"],];
CONWAYPOLDATA[96167]:=[
,,,[54626798852,"JB"],];
CONWAYPOLDATA[96179]:=[
,,,[35377425393,"JB"],];
CONWAYPOLDATA[96181]:=[
,,,[64755108609,"JB"],];
CONWAYPOLDATA[96199]:=[
,,,[70817663445,"JB"],];
CONWAYPOLDATA[96211]:=[
,,,[61296028102,"JB"],];
CONWAYPOLDATA[96221]:=[
,,,[16537791935,"JB"],];
CONWAYPOLDATA[96223]:=[
,,,[37035078029,"JB"],];
CONWAYPOLDATA[96233]:=[
,,,[111006401464,"JB"],];
CONWAYPOLDATA[96259]:=[
,,,[83194054709,"JB"],];
CONWAYPOLDATA[96263]:=[
,,,[90243674615,"JB"],];
CONWAYPOLDATA[96269]:=[
,,,[33187486255,"JB"],];
CONWAYPOLDATA[96281]:=[
,,,[9268875592,"JB"],];
CONWAYPOLDATA[96289]:=[
,,,[135154417948,"JB"],];
CONWAYPOLDATA[96293]:=[
,,,[62548081082,"JB"],];
CONWAYPOLDATA[96323]:=[
,,,[191226969566,"JB"],];
CONWAYPOLDATA[96329]:=[
,,,[42053099256,"JB"],];
CONWAYPOLDATA[96331]:=[
,,,[6466025723,"JB"],];
CONWAYPOLDATA[96337]:=[
,,,[99997613331,"JB"],];
CONWAYPOLDATA[96353]:=[
,,,[118321869415,"JB"],];
CONWAYPOLDATA[96377]:=[
,,,[73994405523,"JB"],];
CONWAYPOLDATA[96401]:=[
,,,[43693946055,"JB"],];
CONWAYPOLDATA[96419]:=[
,,,[4995854072,"JB"],];
CONWAYPOLDATA[96431]:=[
,,,[71679862379,"JB"],];
CONWAYPOLDATA[96443]:=[
,,,[9077118719,"JB"],];
CONWAYPOLDATA[96451]:=[
,,,[25894971580,"JB"],];
CONWAYPOLDATA[96457]:=[
,,,[64015617195,"JB"],];
CONWAYPOLDATA[96461]:=[
,,,[61711310596,"JB"],];
CONWAYPOLDATA[96469]:=[
,,,[27328606551,"JB"],];
CONWAYPOLDATA[96479]:=[
,,,[24114250708,"JB"],];
CONWAYPOLDATA[96487]:=[
,,,[46548319900,"JB"],];
CONWAYPOLDATA[96493]:=[
,,,[71198517971,"JB"],];
CONWAYPOLDATA[96497]:=[
,,,[6065415435,"JB"],];
CONWAYPOLDATA[96517]:=[
,,,[101714054384,"JB"],];
CONWAYPOLDATA[96527]:=[
,,,[108999929364,"JB"],];
CONWAYPOLDATA[96553]:=[
,,,[63734055987,"JB"],];
CONWAYPOLDATA[96557]:=[
,,,[34506864763,"JB"],];
CONWAYPOLDATA[96581]:=[
,,,[117692930535,"JB"],];
CONWAYPOLDATA[96587]:=[
,,,[35422219795,"JB"],];
CONWAYPOLDATA[96589]:=[
,,,[25212916443,"JB"],];
CONWAYPOLDATA[96601]:=[
,,,[192762368860,"JB"],];
CONWAYPOLDATA[96643]:=[
,,,[82443147369,"JB"],];
CONWAYPOLDATA[96661]:=[
,,,[15133536150,"JB"],];
CONWAYPOLDATA[96667]:=[
,,,[79976572449,"JB"],];
CONWAYPOLDATA[96671]:=[
,,,[55667318660,"JB"],];
CONWAYPOLDATA[96697]:=[
,,,[116933071288,"JB"],];
CONWAYPOLDATA[96703]:=[
,,,[51579639549,"JB"],];
CONWAYPOLDATA[96731]:=[
,,,[71427524636,"JB"],];
CONWAYPOLDATA[96737]:=[
,,,[5066987326,"JB"],];
CONWAYPOLDATA[96739]:=[
,,,[63418799276,"JB"],];
CONWAYPOLDATA[96749]:=[
,,,[70283794797,"JB"],];
CONWAYPOLDATA[96757]:=[
,,,[73251531724,"JB"],];
CONWAYPOLDATA[96763]:=[
,,,[25024072961,"JB"],];
CONWAYPOLDATA[96769]:=[
,,,[251038623667,"JB"],];
CONWAYPOLDATA[96779]:=[
,,,[37085035349,"JB"],];
CONWAYPOLDATA[96787]:=[
,,,[27145753105,"JB"],];
CONWAYPOLDATA[96797]:=[
,,,[121367079309,"JB"],];
CONWAYPOLDATA[96799]:=[
,,,[25289125952,"JB"],];
CONWAYPOLDATA[96821]:=[
,,,[80191315505,"JB"],];
CONWAYPOLDATA[96823]:=[
,,,[25342839317,"JB"],];
CONWAYPOLDATA[96827]:=[
,,,[27243341549,"JB"],];
CONWAYPOLDATA[96847]:=[
,,,[64336140032,"JB"],];
CONWAYPOLDATA[96851]:=[
,,,[24770224358,"JB"],];
CONWAYPOLDATA[96857]:=[
,,,[25894137811,"JB"],];
CONWAYPOLDATA[96893]:=[
,,,[65480289402,"JB"],];
CONWAYPOLDATA[96907]:=[
,,,[15695445350,"JB"],];
CONWAYPOLDATA[96911]:=[
,,,[23911044863,"JB"],];
CONWAYPOLDATA[96931]:=[
,,,[81008241563,"JB"],];
CONWAYPOLDATA[96953]:=[
,,,[9171947709,"JB"],];
CONWAYPOLDATA[96959]:=[
,,,[26682147217,"JB"],];
CONWAYPOLDATA[96973]:=[
,,,[61263662482,"JB"],];
CONWAYPOLDATA[96979]:=[
,,,[54525957858,"JB"],];
CONWAYPOLDATA[96989]:=[
,,,[138620267395,"JB"],];
CONWAYPOLDATA[96997]:=[
,,,[33158036464,"JB"],];
CONWAYPOLDATA[97001]:=[
,,,[26160393695,"JB"],];
CONWAYPOLDATA[97003]:=[
,,,[108983258519,"JB"],];
CONWAYPOLDATA[97007]:=[
,,,[54197325870,"JB"],];
CONWAYPOLDATA[97021]:=[
,,,[99790658489,"JB"],];
CONWAYPOLDATA[97039]:=[
,,,[36909948121,"JB"],];
CONWAYPOLDATA[97073]:=[
,,,[128805775411,"JB"],];
CONWAYPOLDATA[97081]:=[
,,,[244439279097,"JB"],];
CONWAYPOLDATA[97103]:=[
,,,[82128260860,"JB"],];
CONWAYPOLDATA[97117]:=[
,,,[71836279498,"JB"],];
CONWAYPOLDATA[97127]:=[
,,,[37734228013,"JB"],];
CONWAYPOLDATA[97151]:=[
,,,[74784216736,"JB"],];
CONWAYPOLDATA[97157]:=[
,,,[55599259136,"JB"],];
CONWAYPOLDATA[97159]:=[
,,,[34092898785,"JB"],];
CONWAYPOLDATA[97169]:=[
,,,[9440648536,"JB"],];
CONWAYPOLDATA[97171]:=[
,,,[81896301836,"JB"],];
CONWAYPOLDATA[97177]:=[
,,,[147993477084,"JB"],];
CONWAYPOLDATA[97187]:=[
,,,[17909328801,"JB"],];
CONWAYPOLDATA[97213]:=[
,,,[18369660124,"JB"],];
CONWAYPOLDATA[97231]:=[
,,,[24429191525,"JB"],];
CONWAYPOLDATA[97241]:=[
,,,[9454645192,"JB"],];
CONWAYPOLDATA[97259]:=[
,,,[17543967462,"JB"],];
CONWAYPOLDATA[97283]:=[
,,,[71709828660,"JB"],];
CONWAYPOLDATA[97301]:=[
,,,[24422161798,"JB"],];
CONWAYPOLDATA[97303]:=[
,,,[25781013671,"JB"],];
CONWAYPOLDATA[97327]:=[
,,,[27017293916,"JB"],];
CONWAYPOLDATA[97367]:=[
,,,[64828409110,"JB"],];
CONWAYPOLDATA[97369]:=[
,,,[141231008175,"JB"],];
CONWAYPOLDATA[97373]:=[
,,,[17891315022,"JB"],];
CONWAYPOLDATA[97379]:=[
,,,[72835986358,"JB"],];
CONWAYPOLDATA[97381]:=[
,,,[64080690623,"JB"],];
CONWAYPOLDATA[97387]:=[
,,,[101191910092,"JB"],];
CONWAYPOLDATA[97397]:=[
,,,[35673112207,"JB"],];
CONWAYPOLDATA[97423]:=[
,,,[53044387928,"JB"],];
CONWAYPOLDATA[97429]:=[
,,,[66446480577,"JB"],];
CONWAYPOLDATA[97441]:=[
,,,[281825973430,"JB"],];
CONWAYPOLDATA[97453]:=[
,,,[63675302937,"JB"],];
CONWAYPOLDATA[97459]:=[
,,,[75205601778,"JB"],];
CONWAYPOLDATA[97463]:=[
,,,[82226121900,"JB"],];
CONWAYPOLDATA[97499]:=[
,,,[44055800643,"JB"],];
CONWAYPOLDATA[97501]:=[
,,,[45843702694,"JB"],];
CONWAYPOLDATA[97511]:=[
,,,[103879540928,"JB"],];
CONWAYPOLDATA[97523]:=[
,,,[85595937102,"JB"],];
CONWAYPOLDATA[97547]:=[
,,,[74367881862,"JB"],];
CONWAYPOLDATA[97549]:=[
,,,[9150193751,"JB"],];
CONWAYPOLDATA[97553]:=[
,,,[119507692865,"JB"],];
CONWAYPOLDATA[97561]:=[
,,,[122189298851,"JB"],];
CONWAYPOLDATA[97571]:=[
,,,[24341817940,"JB"],];
CONWAYPOLDATA[97577]:=[
,,,[65894235988,"JB"],];
CONWAYPOLDATA[97579]:=[
,,,[63357947123,"JB"],];
CONWAYPOLDATA[97583]:=[
,,,[71831529386,"JB"],];
CONWAYPOLDATA[97607]:=[
,,,[38108115373,"JB"],];
CONWAYPOLDATA[97609]:=[
,,,[157665767928,"JB"],];
CONWAYPOLDATA[97613]:=[
,,,[38016749434,"JB"],];
CONWAYPOLDATA[97649]:=[
,,,[76239456753,"JB"],];
CONWAYPOLDATA[97651]:=[
,,,[84502585805,"JB"],];
CONWAYPOLDATA[97673]:=[
,,,[7131789444,"JB"],];
CONWAYPOLDATA[97687]:=[
,,,[34781260981,"JB"],];
CONWAYPOLDATA[97711]:=[
,,,[94593921400,"JB"],];
CONWAYPOLDATA[97729]:=[
,,,[215175314408,"JB"],];
CONWAYPOLDATA[97771]:=[
,,,[37484717006,"JB"],];
CONWAYPOLDATA[97777]:=[
,,,[85522413053,"JB"],];
CONWAYPOLDATA[97787]:=[
,,,[82907045573,"JB"],];
CONWAYPOLDATA[97789]:=[
,,,[37344641212,"JB"],];
CONWAYPOLDATA[97813]:=[
,,,[63653570386,"JB"],];
CONWAYPOLDATA[97829]:=[
,,,[66287169480,"JB"],];
CONWAYPOLDATA[97841]:=[
,,,[62568830301,"JB"],];
CONWAYPOLDATA[97843]:=[
,,,[81949089553,"JB"],];
CONWAYPOLDATA[97847]:=[
,,,[142362003420,"JB"],];
CONWAYPOLDATA[97849]:=[
,,,[44600944099,"JB"],];
CONWAYPOLDATA[97859]:=[
,,,[25950641058,"JB"],];
CONWAYPOLDATA[97861]:=[
,,,[104806390894,"JB"],];
CONWAYPOLDATA[97871]:=[
,,,[24325249831,"JB"],];
CONWAYPOLDATA[97879]:=[
,,,[27102401469,"JB"],];
CONWAYPOLDATA[97883]:=[
,,,[83626341052,"JB"],];
CONWAYPOLDATA[97919]:=[
,,,[46489493248,"JB"],];
CONWAYPOLDATA[97927]:=[
,,,[64327462887,"JB"],];
CONWAYPOLDATA[97931]:=[
,,,[76107860100,"JB"],];
CONWAYPOLDATA[97943]:=[
,,,[45509117012,"JB"],];
CONWAYPOLDATA[97961]:=[
,,,[43398780184,"JB"],];
CONWAYPOLDATA[97967]:=[
,,,[64600811343,"JB"],];
CONWAYPOLDATA[97973]:=[
,,,[47135985978,"JB"],];
CONWAYPOLDATA[97987]:=[
,,,[83253478708,"JB"],];
CONWAYPOLDATA[98009]:=[
,,,[84759849356,"JB"],];
CONWAYPOLDATA[98011]:=[
,,,[5184781910,"JB"],];
CONWAYPOLDATA[98017]:=[
,,,[83414231313,"JB"],];
CONWAYPOLDATA[98041]:=[
,,,[325705437548,"JB"],];
CONWAYPOLDATA[98047]:=[
,,,[38452464653,"JB"],];
CONWAYPOLDATA[98057]:=[
,,,[6564327811,"JB"],];
CONWAYPOLDATA[98081]:=[
,,,[6390369480,"JB"],];
CONWAYPOLDATA[98101]:=[
,,,[93849302662,"JB"],];
CONWAYPOLDATA[98123]:=[
,,,[45923526462,"JB"],];
CONWAYPOLDATA[98129]:=[
,,,[37738941468,"JB"],];
CONWAYPOLDATA[98143]:=[
,,,[27052921669,"JB"],];
CONWAYPOLDATA[98179]:=[
,,,[83900533495,"JB"],];
CONWAYPOLDATA[98207]:=[
,,,[26656620636,"JB"],];
CONWAYPOLDATA[98213]:=[
,,,[93537177285,"JB"],];
CONWAYPOLDATA[98221]:=[
,,,[64213157404,"JB"],];
CONWAYPOLDATA[98227]:=[
,,,[54159224539,"JB"],];
CONWAYPOLDATA[98251]:=[
,,,[73328847844,"JB"],];
CONWAYPOLDATA[98257]:=[
,,,[125118105642,"JB"],];
CONWAYPOLDATA[98269]:=[
,,,[33833230550,"JB"],];
CONWAYPOLDATA[98297]:=[
,,,[15637578248,"JB"],];
CONWAYPOLDATA[98299]:=[
,,,[15320292348,"JB"],];
CONWAYPOLDATA[98317]:=[
,,,[62894073125,"JB"],];
CONWAYPOLDATA[98321]:=[
,,,[9665839192,"JB"],];
CONWAYPOLDATA[98323]:=[
,,,[28915024489,"JB"],];
CONWAYPOLDATA[98327]:=[
,,,[35354751106,"JB"],];
CONWAYPOLDATA[98347]:=[
,,,[101584091507,"JB"],];
CONWAYPOLDATA[98369]:=[
,,,[73211915205,"JB"],];
CONWAYPOLDATA[98377]:=[
,,,[85470724621,"JB"],];
CONWAYPOLDATA[98387]:=[
,,,[86749687255,"JB"],];
CONWAYPOLDATA[98389]:=[
,,,[63982366702,"JB"],];
CONWAYPOLDATA[98407]:=[
,,,[76191226128,"JB"],];
CONWAYPOLDATA[98411]:=[
,,,[63315669182,"JB"],];
CONWAYPOLDATA[98419]:=[
,,,[76535240095,"JB"],];
CONWAYPOLDATA[98429]:=[
,,,[121841420371,"JB"],];
CONWAYPOLDATA[98443]:=[
,,,[85900082043,"JB"],];
CONWAYPOLDATA[98453]:=[
,,,[46207537210,"JB"],];
CONWAYPOLDATA[98459]:=[
,,,[86314574647,"JB"],];
CONWAYPOLDATA[98467]:=[
,,,[54396420214,"JB"],];
CONWAYPOLDATA[98473]:=[
,,,[63124048727,"JB"],];
CONWAYPOLDATA[98479]:=[
,,,[28875815425,"JB"],];
CONWAYPOLDATA[98491]:=[
,,,[64754188340,"JB"],];
CONWAYPOLDATA[98507]:=[
,,,[115350022383,"JB"],];
CONWAYPOLDATA[98519]:=[
,,,[73297150817,"JB"],];
CONWAYPOLDATA[98533]:=[
,,,[183366661413,"JB"],];
CONWAYPOLDATA[98543]:=[
,,,[153956685195,"JB"],];
CONWAYPOLDATA[98561]:=[
,,,[27512218982,"JB"],];
CONWAYPOLDATA[98563]:=[
,,,[28108886283,"JB"],];
CONWAYPOLDATA[98573]:=[
,,,[97078830468,"JB"],];
CONWAYPOLDATA[98597]:=[
,,,[184630178680,"JB"],];
CONWAYPOLDATA[98621]:=[
,,,[48629620623,"JB"],];
CONWAYPOLDATA[98627]:=[
,,,[5110949769,"JB"],];
CONWAYPOLDATA[98639]:=[
,,,[28162420897,"JB"],];
CONWAYPOLDATA[98641]:=[
,,,[202315354324,"JB"],];
CONWAYPOLDATA[98663]:=[
,,,[36863950010,"JB"],];
CONWAYPOLDATA[98669]:=[
,,,[122716608682,"JB"],];
CONWAYPOLDATA[98689]:=[
,,,[145357153016,"JB"],];
CONWAYPOLDATA[98711]:=[
,,,[66685795439,"JB"],];
CONWAYPOLDATA[98713]:=[
,,,[67224145283,"JB"],];
CONWAYPOLDATA[98717]:=[
,,,[64810178427,"JB"],];
CONWAYPOLDATA[98729]:=[
,,,[27968839684,"JB"],];
CONWAYPOLDATA[98731]:=[
,,,[29015461206,"JB"],];
CONWAYPOLDATA[98737]:=[
,,,[64365761672,"JB"],];
CONWAYPOLDATA[98773]:=[
,,,[66160723500,"JB"],];
CONWAYPOLDATA[98779]:=[
,,,[35151099826,"JB"],];
CONWAYPOLDATA[98801]:=[
,,,[46678433652,"JB"],];
CONWAYPOLDATA[98807]:=[
,,,[87652480161,"JB"],];
CONWAYPOLDATA[98809]:=[
,,,[318816427754,"JB"],];
CONWAYPOLDATA[98837]:=[
,,,[123601302211,"JB"],];
CONWAYPOLDATA[98849]:=[
,,,[9769938616,"JB"],];
CONWAYPOLDATA[98867]:=[
,,,[47948616529,"JB"],];
CONWAYPOLDATA[98869]:=[
,,,[67769756052,"JB"],];
CONWAYPOLDATA[98873]:=[
,,,[8599380305,"JB"],];
CONWAYPOLDATA[98887]:=[
,,,[127121216243,"JB"],];
CONWAYPOLDATA[98893]:=[
,,,[97033317137,"JB"],];
CONWAYPOLDATA[98897]:=[
,,,[67010530366,"JB"],];
CONWAYPOLDATA[98899]:=[
,,,[27341123047,"JB"],];
CONWAYPOLDATA[98909]:=[
,,,[38086295178,"JB"],];
CONWAYPOLDATA[98911]:=[
,,,[25259297726,"JB"],];
CONWAYPOLDATA[98927]:=[
,,,[39145809613,"JB"],];
CONWAYPOLDATA[98929]:=[
,,,[87726378980,"JB"],];
CONWAYPOLDATA[98939]:=[
,,,[48007379460,"JB"],];
CONWAYPOLDATA[98947]:=[
,,,[74227664675,"JB"],];
CONWAYPOLDATA[98953]:=[
,,,[8141061226,"JB"],];
CONWAYPOLDATA[98963]:=[
,,,[83733287043,"JB"],];
CONWAYPOLDATA[98981]:=[
,,,[48985795884,"JB"],];
CONWAYPOLDATA[98993]:=[
,,,[8247601798,"JB"],];
CONWAYPOLDATA[98999]:=[
,,,[26208896280,"JB"],];
CONWAYPOLDATA[99013]:=[
,,,[64076064930,"JB"],];
CONWAYPOLDATA[99017]:=[
,,,[67393247594,"JB"],];
CONWAYPOLDATA[99023]:=[
,,,[57279359240,"JB"],];
CONWAYPOLDATA[99041]:=[
,,,[9448313324,"JB"],];
CONWAYPOLDATA[99053]:=[
,,,[65749895607,"JB"],];
CONWAYPOLDATA[99079]:=[
,,,[25936603386,"JB"],];
CONWAYPOLDATA[99083]:=[
,,,[77563163232,"JB"],];
CONWAYPOLDATA[99089]:=[
,,,[85482990324,"JB"],];
CONWAYPOLDATA[99103]:=[
,,,[49106626636,"JB"],];
CONWAYPOLDATA[99109]:=[
,,,[68757760737,"JB"],];
CONWAYPOLDATA[99119]:=[
,,,[64413374232,"JB"],];
CONWAYPOLDATA[99131]:=[
,,,[47079790181,"JB"],];
CONWAYPOLDATA[99133]:=[
,,,[68318101750,"JB"],];
CONWAYPOLDATA[99137]:=[
,,,[263782738233,"JB"],];
CONWAYPOLDATA[99139]:=[
,,,[64031104210,"JB"],];
CONWAYPOLDATA[99149]:=[
,,,[48270690652,"JB"],];
CONWAYPOLDATA[99173]:=[
,,,[65172826201,"JB"],];
CONWAYPOLDATA[99181]:=[
,,,[126287861574,"JB"],];
CONWAYPOLDATA[99191]:=[
,,,[75416405176,"JB"],];
CONWAYPOLDATA[99223]:=[
,,,[49225621756,"JB"],];
CONWAYPOLDATA[99233]:=[
,,,[78319149088,"JB"],];
CONWAYPOLDATA[99241]:=[
,,,[222485718404,"JB"],];
CONWAYPOLDATA[99251]:=[
,,,[25684372292,"JB"],];
CONWAYPOLDATA[99257]:=[
,,,[8712382435,"JB"],];
CONWAYPOLDATA[99259]:=[
,,,[88670446918,"JB"],];
CONWAYPOLDATA[99277]:=[
,,,[96163871836,"JB"],];
CONWAYPOLDATA[99289]:=[
,,,[221907042755,"JB"],];
CONWAYPOLDATA[99317]:=[
,,,[66303234666,"JB"],];
CONWAYPOLDATA[99347]:=[
,,,[26383880833,"JB"],];
CONWAYPOLDATA[99349]:=[
,,,[35174612810,"JB"],];
CONWAYPOLDATA[99367]:=[
,,,[67925095129,"JB"],];
CONWAYPOLDATA[99371]:=[
,,,[38574431008,"JB"],];
CONWAYPOLDATA[99377]:=[
,,,[25659240780,"JB"],];
CONWAYPOLDATA[99391]:=[
,,,[39124173855,"JB"],];
CONWAYPOLDATA[99397]:=[
,,,[104768910867,"JB"],];
CONWAYPOLDATA[99401]:=[
,,,[9879365992,"JB"],];
CONWAYPOLDATA[99409]:=[
,,,[25238453976,"JB"],];
CONWAYPOLDATA[99431]:=[
,,,[39281906890,"JB"],];
CONWAYPOLDATA[99439]:=[
,,,[38735368624,"JB"],];
CONWAYPOLDATA[99469]:=[
,,,[84751168886,"JB"],];
CONWAYPOLDATA[99487]:=[
,,,[37804761542,"JB"],];
CONWAYPOLDATA[99497]:=[
,,,[5996982684,"JB"],];
CONWAYPOLDATA[99523]:=[
,,,[5910272883,"JB"],];
CONWAYPOLDATA[99527]:=[
,,,[64498671409,"JB"],];
CONWAYPOLDATA[99529]:=[
,,,[7176239965,"JB"],];
CONWAYPOLDATA[99551]:=[
,,,[38955600470,"JB"],];
CONWAYPOLDATA[99559]:=[
,,,[69144721093,"JB"],];
CONWAYPOLDATA[99563]:=[
,,,[74827269593,"JB"],];
CONWAYPOLDATA[99571]:=[
,,,[78068941265,"JB"],];
CONWAYPOLDATA[99577]:=[
,,,[155038700426,"JB"],];
CONWAYPOLDATA[99581]:=[
,,,[47244412994,"JB"],];
CONWAYPOLDATA[99607]:=[
,,,[25106641602,"JB"],];
CONWAYPOLDATA[99611]:=[
,,,[6580103440,"JB"],];
CONWAYPOLDATA[99623]:=[
,,,[88171635024,"JB"],];
CONWAYPOLDATA[99643]:=[
,,,[36964563713,"JB"],];
CONWAYPOLDATA[99661]:=[
,,,[66417977181,"JB"],];
CONWAYPOLDATA[99667]:=[
,,,[84487018233,"JB"],];
CONWAYPOLDATA[99679]:=[
,,,[25733629041,"JB"],];
CONWAYPOLDATA[99689]:=[
,,,[129191560797,"JB"],];
CONWAYPOLDATA[99707]:=[
,,,[47909811744,"JB"],];
CONWAYPOLDATA[99709]:=[
,,,[55631838888,"JB"],];
CONWAYPOLDATA[99713]:=[
,,,[117612779772,"JB"],];
CONWAYPOLDATA[99719]:=[
,,,[64884660332,"JB"],];
CONWAYPOLDATA[99721]:=[
,,,[245365714373,"JB"],];
CONWAYPOLDATA[99733]:=[
,,,[69150075018,"JB"],];
CONWAYPOLDATA[99761]:=[
,,,[17508753830,"JB"],];
CONWAYPOLDATA[99767]:=[
,,,[57403337863,"JB"],];
CONWAYPOLDATA[99787]:=[
,,,[25435706302,"JB"],];
CONWAYPOLDATA[99793]:=[
,,,[108261433985,"JB"],];
CONWAYPOLDATA[99809]:=[
,,,[47273434954,"JB"],];
CONWAYPOLDATA[99817]:=[
,,,[118769653063,"JB"],];
CONWAYPOLDATA[99823]:=[
,,,[26253648667,"JB"],];
CONWAYPOLDATA[99829]:=[
,,,[65680693630,"JB"],];
CONWAYPOLDATA[99833]:=[
,,,[47482771129,"JB"],];
CONWAYPOLDATA[99839]:=[
,,,[38282665527,"JB"],];
CONWAYPOLDATA[99859]:=[
,,,[75551721658,"JB"],];
CONWAYPOLDATA[99871]:=[
,,,[26857109581,"JB"],];
CONWAYPOLDATA[99877]:=[
,,,[127789425438,"JB"],];
CONWAYPOLDATA[99881]:=[
,,,[9444247961,"JB"],];
CONWAYPOLDATA[99901]:=[
,,,[127429919364,"JB"],];
CONWAYPOLDATA[99907]:=[
,,,[77998593786,"JB"],];
CONWAYPOLDATA[99923]:=[
,,,[28831282807,"JB"],];
CONWAYPOLDATA[99929]:=[
,,,[16859321380,"JB"],];
CONWAYPOLDATA[99961]:=[
,,,[309362201700,"JB"],];
CONWAYPOLDATA[99971]:=[
,,,[8063460920,"JB"],];
CONWAYPOLDATA[99989]:=[
,,,[6572576939,"JB"],];
CONWAYPOLDATA[99991]:=[
,,,[36350628155,"JB"],];
CONWAYPOLDATA[100003]:=[
,,,[199811994182,"JB"],];
CONWAYPOLDATA[100019]:=[
,,,[119516303786,"JB"],];
CONWAYPOLDATA[100043]:=[
,,,[28035049892,"JB"],];
CONWAYPOLDATA[100049]:=[
,,,[76141190917,"JB"],];
CONWAYPOLDATA[100057]:=[
,,,[245336462129,"JB"],];
CONWAYPOLDATA[100069]:=[
,,,[26543802605,"JB"],];
CONWAYPOLDATA[100103]:=[
,,,[88588352121,"JB"],];
CONWAYPOLDATA[100109]:=[
,,,[129016574951,"JB"],];
CONWAYPOLDATA[100129]:=[
,,,[279229341795,"JB"],];
CONWAYPOLDATA[100151]:=[
,,,[50150212653,"JB"],];
CONWAYPOLDATA[100153]:=[
,,,[108825749040,"JB"],];
CONWAYPOLDATA[100169]:=[
,,,[10032626536,"JB"],];
CONWAYPOLDATA[100183]:=[
,,,[86500707144,"JB"],];
CONWAYPOLDATA[100189]:=[
,,,[90339820168,"JB"],];
CONWAYPOLDATA[100193]:=[
,,,[5411924898,"JB"],];
CONWAYPOLDATA[100207]:=[
,,,[58124769732,"JB"],];
CONWAYPOLDATA[100213]:=[
,,,[95653408715,"JB"],];
CONWAYPOLDATA[100237]:=[
,,,[76525937655,"JB"],];
CONWAYPOLDATA[100267]:=[
,,,[70373496892,"JB"],];
CONWAYPOLDATA[100271]:=[
,,,[76148805543,"JB"],];
CONWAYPOLDATA[100279]:=[
,,,[65472058824,"JB"],];
CONWAYPOLDATA[100291]:=[
,,,[27795750944,"JB"],];
CONWAYPOLDATA[100297]:=[
,,,[48329112433,"JB"],];
CONWAYPOLDATA[100313]:=[
,,,[5512399979,"JB"],];
CONWAYPOLDATA[100333]:=[
,,,[129063555218,"JB"],];
CONWAYPOLDATA[100343]:=[
,,,[99306055443,"JB"],];
CONWAYPOLDATA[100357]:=[
,,,[65889388352,"JB"],];
CONWAYPOLDATA[100361]:=[
,,,[46600924216,"JB"],];
CONWAYPOLDATA[100363]:=[
,,,[90343059171,"JB"],];
CONWAYPOLDATA[100379]:=[
,,,[26264466489,"JB"],];
CONWAYPOLDATA[100391]:=[
,,,[27243206068,"JB"],];
CONWAYPOLDATA[100393]:=[
,,,[167669561881,"JB"],];
CONWAYPOLDATA[100403]:=[
,,,[149184299567,"JB"],];
CONWAYPOLDATA[100411]:=[
,,,[15455361533,"JB"],];
CONWAYPOLDATA[100417]:=[
,,,[68407675417,"JB"],];
CONWAYPOLDATA[100447]:=[
,,,[27675659678,"JB"],];
CONWAYPOLDATA[100459]:=[
,,,[88435162751,"JB"],];
CONWAYPOLDATA[100469]:=[
,,,[36075403832,"JB"],];
CONWAYPOLDATA[100483]:=[
,,,[39157823171,"JB"],];
CONWAYPOLDATA[100493]:=[
,,,[9326353360,"JB"],];
CONWAYPOLDATA[100501]:=[
,,,[65710367830,"JB"],];
CONWAYPOLDATA[100511]:=[
,,,[35400778299,"JB"],];
CONWAYPOLDATA[100517]:=[
,,,[136970696256,"JB"],];
CONWAYPOLDATA[100519]:=[
,,,[38573362104,"JB"],];
CONWAYPOLDATA[100523]:=[
,,,[137655392018,"JB"],];
CONWAYPOLDATA[100537]:=[
,,,[89510805606,"JB"],];
CONWAYPOLDATA[100547]:=[
,,,[25860185667,"JB"],];
CONWAYPOLDATA[100549]:=[
,,,[65751303729,"JB"],];
CONWAYPOLDATA[100559]:=[
,,,[68715484272,"JB"],];
CONWAYPOLDATA[100591]:=[
,,,[50008815656,"JB"],];
CONWAYPOLDATA[100609]:=[
,,,[211204549956,"JB"],];
CONWAYPOLDATA[100613]:=[
,,,[68983593031,"JB"],];
CONWAYPOLDATA[100621]:=[
,,,[100847196026,"JB"],];
CONWAYPOLDATA[100649]:=[
,,,[38284564676,"JB"],];
CONWAYPOLDATA[100669]:=[
,,,[127222260798,"JB"],];
CONWAYPOLDATA[100673]:=[
,,,[16778564875,"JB"],];
CONWAYPOLDATA[100693]:=[
,,,[106982687554,"JB"],];
CONWAYPOLDATA[100699]:=[
,,,[86998800353,"JB"],];
CONWAYPOLDATA[100703]:=[
,,,[58904810013,"JB"],];
CONWAYPOLDATA[100733]:=[
,,,[46720670533,"JB"],];
CONWAYPOLDATA[100741]:=[
,,,[106762188835,"JB"],];
CONWAYPOLDATA[100747]:=[
,,,[107860745672,"JB"],];
CONWAYPOLDATA[100769]:=[
,,,[16088879312,"JB"],];
CONWAYPOLDATA[100787]:=[
,,,[47957881360,"JB"],];
CONWAYPOLDATA[100799]:=[
,,,[47466551514,"JB"],];
CONWAYPOLDATA[100801]:=[
,,,[208884973062,"JB"],];
CONWAYPOLDATA[100811]:=[
,,,[47559504661,"JB"],];
CONWAYPOLDATA[100823]:=[
,,,[68239627803,"JB"],];
CONWAYPOLDATA[100829]:=[
,,,[130754139741,"JB"],];
CONWAYPOLDATA[100847]:=[
,,,[78975100951,"JB"],];
CONWAYPOLDATA[100853]:=[
,,,[128812981458,"JB"],];
CONWAYPOLDATA[100907]:=[
,,,[81180186037,"JB"],];
CONWAYPOLDATA[100913]:=[
,,,[9621751814,"JB"],];
CONWAYPOLDATA[100927]:=[
,,,[56375299028,"JB"],];
CONWAYPOLDATA[100931]:=[
,,,[18036874357,"JB"],];
CONWAYPOLDATA[100937]:=[
,,,[9594364664,"JB"],];
CONWAYPOLDATA[100943]:=[
,,,[78890386567,"JB"],];
CONWAYPOLDATA[100957]:=[
,,,[97282064245,"JB"],];
CONWAYPOLDATA[100981]:=[
,,,[101034418956,"JB"],];
CONWAYPOLDATA[100987]:=[
,,,[26555339548,"JB"],];
CONWAYPOLDATA[100999]:=[
,,,[39117215700,"JB"],];
CONWAYPOLDATA[101009]:=[
,,,[17769301265,"JB"],];
CONWAYPOLDATA[101021]:=[
,,,[70959372864,"JB"],];
CONWAYPOLDATA[101027]:=[
,,,[25836847036,"JB"],];
CONWAYPOLDATA[101051]:=[
,,,[101677314100,"JB"],];
CONWAYPOLDATA[101063]:=[
,,,[51067740285,"JB"],];
CONWAYPOLDATA[101081]:=[
,,,[99977296567,"JB"],];
CONWAYPOLDATA[101089]:=[
,,,[180135543581,"JB"],];
CONWAYPOLDATA[101107]:=[
,,,[59554146250,"JB"],];
CONWAYPOLDATA[101111]:=[
,,,[77769727889,"JB"],];
CONWAYPOLDATA[101113]:=[
,,,[70521059629,"JB"],];
CONWAYPOLDATA[101117]:=[
,,,[80874185538,"JB"],];
CONWAYPOLDATA[101119]:=[
,,,[27485155393,"JB"],];
CONWAYPOLDATA[101141]:=[
,,,[39995803889,"JB"],];
CONWAYPOLDATA[101149]:=[
,,,[117693840783,"JB"],];
CONWAYPOLDATA[101159]:=[
,,,[38413107077,"JB"],];
CONWAYPOLDATA[101161]:=[
,,,[152627366890,"JB"],];
CONWAYPOLDATA[101173]:=[
,,,[70171164650,"JB"],];
CONWAYPOLDATA[101183]:=[
,,,[40801032925,"JB"],];
CONWAYPOLDATA[101197]:=[
,,,[36206060268,"JB"],];
CONWAYPOLDATA[101203]:=[
,,,[169912752797,"JB"],];
CONWAYPOLDATA[101207]:=[
,,,[60130013708,"JB"],];
CONWAYPOLDATA[101209]:=[
,,,[180804008385,"JB"],];
CONWAYPOLDATA[101221]:=[
,,,[129154756934,"JB"],];
CONWAYPOLDATA[101267]:=[
,,,[28015616819,"JB"],];
CONWAYPOLDATA[101273]:=[
,,,[68877083852,"JB"],];
CONWAYPOLDATA[101279]:=[
,,,[46423761642,"JB"],];
CONWAYPOLDATA[101281]:=[
,,,[172473136691,"JB"],];
CONWAYPOLDATA[101287]:=[
,,,[133366618643,"JB"],];
CONWAYPOLDATA[101293]:=[
,,,[70907227155,"JB"],];
CONWAYPOLDATA[101323]:=[
,,,[27170978328,"JB"],];
CONWAYPOLDATA[101333]:=[
,,,[81732664477,"JB"],];
CONWAYPOLDATA[101341]:=[
,,,[108982516766,"JB"],];
CONWAYPOLDATA[101347]:=[
,,,[89450990489,"JB"],];
CONWAYPOLDATA[101359]:=[
,,,[40742567720,"JB"],];
CONWAYPOLDATA[101363]:=[
,,,[28070252866,"JB"],];
CONWAYPOLDATA[101377]:=[
,,,[68815417244,"JB"],];
CONWAYPOLDATA[101383]:=[
,,,[57644346143,"JB"],];
CONWAYPOLDATA[101399]:=[
,,,[51407873421,"JB"],];
CONWAYPOLDATA[101411]:=[
,,,[89307191508,"JB"],];
CONWAYPOLDATA[101419]:=[
,,,[30376207530,"JB"],];
CONWAYPOLDATA[101429]:=[
,,,[92589868368,"JB"],];
CONWAYPOLDATA[101449]:=[
,,,[193880502748,"JB"],];
CONWAYPOLDATA[101467]:=[
,,,[88530566304,"JB"],];
CONWAYPOLDATA[101477]:=[
,,,[39651528890,"JB"],];
CONWAYPOLDATA[101483]:=[
,,,[81878209613,"JB"],];
CONWAYPOLDATA[101489]:=[
,,,[10298799256,"JB"],];
CONWAYPOLDATA[101501]:=[
,,,[26584532916,"JB"],];
CONWAYPOLDATA[101503]:=[
,,,[101281418956,"JB"],];
CONWAYPOLDATA[101513]:=[
,,,[17302383288,"JB"],];
CONWAYPOLDATA[101527]:=[
,,,[112511003081,"JB"],];
CONWAYPOLDATA[101531]:=[
,,,[70823558238,"JB"],];
CONWAYPOLDATA[101533]:=[
,,,[214642995731,"JB"],];
CONWAYPOLDATA[101537]:=[
,,,[79711824927,"JB"],];
CONWAYPOLDATA[101561]:=[
,,,[30778873541,"JB"],];
CONWAYPOLDATA[101573]:=[
,,,[39560855188,"JB"],];
CONWAYPOLDATA[101581]:=[
,,,[68578755236,"JB"],];
CONWAYPOLDATA[101599]:=[
,,,[28548201422,"JB"],];
CONWAYPOLDATA[101603]:=[
,,,[50734848434,"JB"],];
CONWAYPOLDATA[101611]:=[
,,,[68535501781,"JB"],];
CONWAYPOLDATA[101627]:=[
,,,[91828734424,"JB"],];
CONWAYPOLDATA[101641]:=[
,,,[175165761670,"JB"],];
CONWAYPOLDATA[101653]:=[
,,,[72287481365,"JB"],];
CONWAYPOLDATA[101663]:=[
,,,[51371025546,"JB"],];
CONWAYPOLDATA[101681]:=[
,,,[50426048250,"JB"],];
CONWAYPOLDATA[101693]:=[
,,,[30222142672,"JB"],];
CONWAYPOLDATA[101701]:=[
,,,[38868088182,"JB"],];
CONWAYPOLDATA[101719]:=[
,,,[29902029276,"JB"],];
CONWAYPOLDATA[101723]:=[
,,,[110620202197,"JB"],];
CONWAYPOLDATA[101737]:=[
,,,[130282570941,"JB"],];
CONWAYPOLDATA[101741]:=[
,,,[18331896864,"JB"],];
CONWAYPOLDATA[101747]:=[
,,,[19797320780,"JB"],];
CONWAYPOLDATA[101749]:=[
,,,[109328690008,"JB"],];
CONWAYPOLDATA[101771]:=[
,,,[132091430490,"JB"],];
CONWAYPOLDATA[101789]:=[
,,,[70812266155,"JB"],];
CONWAYPOLDATA[101797]:=[
,,,[71233977707,"JB"],];
CONWAYPOLDATA[101807]:=[
,,,[51416301864,"JB"],];
CONWAYPOLDATA[101833]:=[
,,,[133987380753,"JB"],];
CONWAYPOLDATA[101837]:=[
,,,[68797309236,"JB"],];
CONWAYPOLDATA[101839]:=[
,,,[30038125938,"JB"],];
CONWAYPOLDATA[101863]:=[
,,,[68959519332,"JB"],];
CONWAYPOLDATA[101869]:=[
,,,[30490614134,"JB"],];
CONWAYPOLDATA[101873]:=[
,,,[50327095717,"JB"],];
CONWAYPOLDATA[101879]:=[
,,,[59897924235,"JB"],];
CONWAYPOLDATA[101891]:=[
,,,[67866028917,"JB"],];
CONWAYPOLDATA[101917]:=[
,,,[155805002253,"JB"],];
CONWAYPOLDATA[101921]:=[
,,,[47495491774,"JB"],];
CONWAYPOLDATA[101929]:=[
,,,[234125510780,"JB"],];
CONWAYPOLDATA[101939]:=[
,,,[50621786073,"JB"],];
CONWAYPOLDATA[101957]:=[
,,,[80964155659,"JB"],];
CONWAYPOLDATA[101963]:=[
,,,[80524361585,"JB"],];
CONWAYPOLDATA[101977]:=[
,,,[175462238067,"JB"],];
CONWAYPOLDATA[101987]:=[
,,,[82960611243,"JB"],];
CONWAYPOLDATA[101999]:=[
,,,[38934854289,"JB"],];
CONWAYPOLDATA[102001]:=[
,,,[341455181598,"JB"],];
CONWAYPOLDATA[102013]:=[
,,,[71331570125,"JB"],];
CONWAYPOLDATA[102019]:=[
,,,[93205476573,"JB"],];
CONWAYPOLDATA[102023]:=[
,,,[36630643994,"JB"],];
CONWAYPOLDATA[102031]:=[
,,,[38007873906,"JB"],];
CONWAYPOLDATA[102043]:=[
,,,[60923242510,"JB"],];
CONWAYPOLDATA[102059]:=[
,,,[31078700505,"JB"],];
CONWAYPOLDATA[102061]:=[
,,,[70080900079,"JB"],];
CONWAYPOLDATA[102071]:=[
,,,[26881928922,"JB"],];
CONWAYPOLDATA[102077]:=[
,,,[93776710824,"JB"],];
CONWAYPOLDATA[102079]:=[
,,,[37308139160,"JB"],];
CONWAYPOLDATA[102101]:=[
,,,[19995357741,"JB"],];
CONWAYPOLDATA[102103]:=[
,,,[363491989361,"JB"],];
CONWAYPOLDATA[102107]:=[
,,,[26230165125,"JB"],];
CONWAYPOLDATA[102121]:=[
,,,[176671270306,"JB"],];
CONWAYPOLDATA[102139]:=[
,,,[41683334459,"JB"],];
CONWAYPOLDATA[102149]:=[
,,,[47342894883,"JB"],];
CONWAYPOLDATA[102161]:=[
,,,[6876456916,"JB"],];
CONWAYPOLDATA[102181]:=[
,,,[123995621696,"JB"],];
CONWAYPOLDATA[102191]:=[
,,,[70816830146,"JB"],];
CONWAYPOLDATA[102197]:=[
,,,[40084013933,"JB"],];
CONWAYPOLDATA[102199]:=[
,,,[10364613795,"JB"],];
CONWAYPOLDATA[102203]:=[
,,,[9919618776,"JB"],];
CONWAYPOLDATA[102217]:=[
,,,[111872417825,"JB"],];
CONWAYPOLDATA[102229]:=[
,,,[131776861246,"JB"],];
CONWAYPOLDATA[102233]:=[
,,,[79422773043,"JB"],];
CONWAYPOLDATA[102241]:=[
,,,[93739251897,"JB"],];
CONWAYPOLDATA[102251]:=[
,,,[89769220432,"JB"],];
CONWAYPOLDATA[102253]:=[
,,,[104483649197,"JB"],];
CONWAYPOLDATA[102259]:=[
,,,[10300037778,"JB"],];
CONWAYPOLDATA[102293]:=[
,,,[16344580128,"JB"],];
CONWAYPOLDATA[102299]:=[
,,,[37850630002,"JB"],];
CONWAYPOLDATA[102301]:=[
,,,[102132919464,"JB"],];
CONWAYPOLDATA[102317]:=[
,,,[39736444024,"JB"],];
CONWAYPOLDATA[102329]:=[
,,,[29488761907,"JB"],];
CONWAYPOLDATA[102337]:=[
,,,[68192771640,"JB"],];
CONWAYPOLDATA[102359]:=[
,,,[40882184611,"JB"],];
CONWAYPOLDATA[102367]:=[
,,,[38274918936,"JB"],];
CONWAYPOLDATA[102397]:=[
,,,[111934870967,"JB"],];
CONWAYPOLDATA[102407]:=[
,,,[61240614889,"JB"],];
CONWAYPOLDATA[102409]:=[
,,,[152555512628,"JB"],];
CONWAYPOLDATA[102433]:=[
,,,[195210358126,"JB"],];
CONWAYPOLDATA[102437]:=[
,,,[26921263098,"JB"],];
CONWAYPOLDATA[102451]:=[
,,,[29787833155,"JB"],];
CONWAYPOLDATA[102461]:=[
,,,[131891692720,"JB"],];
CONWAYPOLDATA[102481]:=[
,,,[152895503153,"JB"],];
CONWAYPOLDATA[102497]:=[
,,,[80131744615,"JB"],];
CONWAYPOLDATA[102499]:=[
,,,[5806773351,"JB"],];
CONWAYPOLDATA[102503]:=[
,,,[100100842200,"JB"],];
CONWAYPOLDATA[102523]:=[
,,,[90837018370,"JB"],];
CONWAYPOLDATA[102533]:=[
,,,[70184658766,"JB"],];
CONWAYPOLDATA[102539]:=[
,,,[94627500918,"JB"],];
CONWAYPOLDATA[102547]:=[
,,,[93574342596,"JB"],];
CONWAYPOLDATA[102551]:=[
,,,[58621638347,"JB"],];
CONWAYPOLDATA[102559]:=[
,,,[71423215752,"JB"],];
CONWAYPOLDATA[102563]:=[
,,,[114732612767,"JB"],];
CONWAYPOLDATA[102587]:=[
,,,[93179874689,"JB"],];
CONWAYPOLDATA[102593]:=[
,,,[47825471034,"JB"],];
CONWAYPOLDATA[102607]:=[
,,,[112542538422,"JB"],];
CONWAYPOLDATA[102611]:=[
,,,[47681382093,"JB"],];
CONWAYPOLDATA[102643]:=[
,,,[132550296203,"JB"],];
CONWAYPOLDATA[102647]:=[
,,,[42145215853,"JB"],];
CONWAYPOLDATA[102653]:=[
,,,[47606149976,"JB"],];
CONWAYPOLDATA[102667]:=[
,,,[126286056688,"JB"],];
CONWAYPOLDATA[102673]:=[
,,,[158125044537,"JB"],];
CONWAYPOLDATA[102677]:=[
,,,[51173498064,"JB"],];
CONWAYPOLDATA[102679]:=[
,,,[143812515440,"JB"],];
CONWAYPOLDATA[102701]:=[
,,,[133087966480,"JB"],];
CONWAYPOLDATA[102761]:=[
,,,[82114362647,"JB"],];
CONWAYPOLDATA[102763]:=[
,,,[95041388182,"JB"],];
CONWAYPOLDATA[102769]:=[
,,,[248871473782,"JB"],];
CONWAYPOLDATA[102793]:=[
,,,[70962839176,"JB"],];
CONWAYPOLDATA[102797]:=[
,,,[101935663939,"JB"],];
CONWAYPOLDATA[102811]:=[
,,,[92331371961,"JB"],];
CONWAYPOLDATA[102829]:=[
,,,[155508708018,"JB"],];
CONWAYPOLDATA[102841]:=[
,,,[154912380702,"JB"],];
CONWAYPOLDATA[102859]:=[
,,,[19455676994,"JB"],];
CONWAYPOLDATA[102871]:=[
,,,[41165579469,"JB"],];
CONWAYPOLDATA[102877]:=[
,,,[72708525506,"JB"],];
CONWAYPOLDATA[102881]:=[
,,,[40669990994,"JB"],];
CONWAYPOLDATA[102911]:=[
,,,[114576373501,"JB"],];
CONWAYPOLDATA[102913]:=[
,,,[111635905885,"JB"],];
CONWAYPOLDATA[102929]:=[
,,,[6696354888,"JB"],];
CONWAYPOLDATA[102931]:=[
,,,[30241436596,"JB"],];
CONWAYPOLDATA[102953]:=[
,,,[5359218418,"JB"],];
CONWAYPOLDATA[102967]:=[
,,,[137827507523,"JB"],];
CONWAYPOLDATA[102983]:=[
,,,[42115515753,"JB"],];
CONWAYPOLDATA[103001]:=[
,,,[136797688127,"JB"],];
CONWAYPOLDATA[103007]:=[
,,,[112619716252,"JB"],];
CONWAYPOLDATA[103043]:=[
,,,[31796287641,"JB"],];
CONWAYPOLDATA[103049]:=[
,,,[31310717310,"JB"],];
CONWAYPOLDATA[103067]:=[
,,,[30135760132,"JB"],];
CONWAYPOLDATA[103069]:=[
,,,[135707241818,"JB"],];
CONWAYPOLDATA[103079]:=[
,,,[27509001974,"JB"],];
CONWAYPOLDATA[103087]:=[
,,,[125737378730,"JB"],];
CONWAYPOLDATA[103091]:=[
,,,[60645961122,"JB"],];
CONWAYPOLDATA[103093]:=[
,,,[71784686832,"JB"],];
CONWAYPOLDATA[103099]:=[
,,,[8645366655,"JB"],];
CONWAYPOLDATA[103123]:=[
,,,[42312810625,"JB"],];
CONWAYPOLDATA[103141]:=[
,,,[138294031331,"JB"],];
CONWAYPOLDATA[103171]:=[
,,,[84383251401,"JB"],];
CONWAYPOLDATA[103177]:=[
,,,[5740974644,"JB"],];
CONWAYPOLDATA[103183]:=[
,,,[40673706773,"JB"],];
CONWAYPOLDATA[103217]:=[
,,,[103057013653,"JB"],];
CONWAYPOLDATA[103231]:=[
,,,[41641527245,"JB"],];
CONWAYPOLDATA[103237]:=[
,,,[16425935838,"JB"],];
CONWAYPOLDATA[103289]:=[
,,,[10667378056,"JB"],];
CONWAYPOLDATA[103291]:=[
,,,[31324338535,"JB"],];
CONWAYPOLDATA[103307]:=[
,,,[48374949050,"JB"],];
CONWAYPOLDATA[103319]:=[
,,,[70907003161,"JB"],];
CONWAYPOLDATA[103333]:=[
,,,[39478372652,"JB"],];
CONWAYPOLDATA[103349]:=[
,,,[41340943540,"JB"],];
CONWAYPOLDATA[103357]:=[
,,,[93135612848,"JB"],];
CONWAYPOLDATA[103387]:=[
,,,[61206344649,"JB"],];
CONWAYPOLDATA[103391]:=[
,,,[127830357805,"JB"],];
CONWAYPOLDATA[103393]:=[
,,,[70889652774,"JB"],];
CONWAYPOLDATA[103399]:=[
,,,[53456352412,"JB"],];
CONWAYPOLDATA[103409]:=[
,,,[29561324015,"JB"],];
CONWAYPOLDATA[103421]:=[
,,,[92334165389,"JB"],];
CONWAYPOLDATA[103423]:=[
,,,[179847322432,"JB"],];
CONWAYPOLDATA[103451]:=[
,,,[38888058510,"JB"],];
CONWAYPOLDATA[103457]:=[
,,,[138303697114,"JB"],];
CONWAYPOLDATA[103471]:=[
,,,[74580655151,"JB"],];
CONWAYPOLDATA[103483]:=[
,,,[92072033075,"JB"],];
CONWAYPOLDATA[103511]:=[
,,,[32002288855,"JB"],];
CONWAYPOLDATA[103529]:=[
,,,[10717011496,"JB"],];
CONWAYPOLDATA[103549]:=[
,,,[38487920714,"JB"],];
CONWAYPOLDATA[103553]:=[
,,,[81143716591,"JB"],];
CONWAYPOLDATA[103561]:=[
,,,[96326746366,"JB"],];
CONWAYPOLDATA[103567]:=[
,,,[114799876827,"JB"],];
CONWAYPOLDATA[103573]:=[
,,,[16974993267,"JB"],];
CONWAYPOLDATA[103577]:=[
,,,[9588951509,"JB"],];
CONWAYPOLDATA[103583]:=[
,,,[30469250204,"JB"],];
CONWAYPOLDATA[103591]:=[
,,,[40871518280,"JB"],];
CONWAYPOLDATA[103613]:=[
,,,[19884370832,"JB"],];
CONWAYPOLDATA[103619]:=[
,,,[26974616177,"JB"],];
CONWAYPOLDATA[103643]:=[
,,,[95074211334,"JB"],];
CONWAYPOLDATA[103651]:=[
,,,[94495403521,"JB"],];
CONWAYPOLDATA[103657]:=[
,,,[128763865632,"JB"],];
CONWAYPOLDATA[103669]:=[
,,,[29399077040,"JB"],];
CONWAYPOLDATA[103681]:=[
,,,[255508449662,"JB"],];
CONWAYPOLDATA[103687]:=[
,,,[70228034599,"JB"],];
CONWAYPOLDATA[103699]:=[
,,,[95907990433,"JB"],];
CONWAYPOLDATA[103703]:=[
,,,[94181612763,"JB"],];
CONWAYPOLDATA[103723]:=[
,,,[62418323220,"JB"],];
CONWAYPOLDATA[103769]:=[
,,,[10766760136,"JB"],];
CONWAYPOLDATA[103787]:=[
,,,[31614661859,"JB"],];
CONWAYPOLDATA[103801]:=[
,,,[138294798921,"JB"],];
CONWAYPOLDATA[103811]:=[
,,,[83083265254,"JB"],];
CONWAYPOLDATA[103813]:=[
,,,[180717255154,"JB"],];
CONWAYPOLDATA[103837]:=[
,,,[41951186375,"JB"],];
CONWAYPOLDATA[103841]:=[
,,,[10781707192,"JB"],];
CONWAYPOLDATA[103843]:=[
,,,[128291588236,"JB"],];
CONWAYPOLDATA[103867]:=[
,,,[94596662518,"JB"],];
CONWAYPOLDATA[103889]:=[
,,,[29884398076,"JB"],];
CONWAYPOLDATA[103903]:=[
,,,[27088655036,"JB"],];
CONWAYPOLDATA[103913]:=[
,,,[19872114297,"JB"],];
CONWAYPOLDATA[103919]:=[
,,,[53994857541,"JB"],];
CONWAYPOLDATA[103951]:=[
,,,[40489330310,"JB"],];
CONWAYPOLDATA[103963]:=[
,,,[84328963674,"JB"],];
CONWAYPOLDATA[103967]:=[
,,,[52610836883,"JB"],];
CONWAYPOLDATA[103969]:=[
,,,[7853922236,"JB"],];
CONWAYPOLDATA[103979]:=[
,,,[82939161289,"JB"],];
CONWAYPOLDATA[103981]:=[
,,,[82060557434,"JB"],];
CONWAYPOLDATA[103991]:=[
,,,[29247780742,"JB"],];
CONWAYPOLDATA[103993]:=[
,,,[162217016817,"JB"],];
CONWAYPOLDATA[103997]:=[
,,,[72776788611,"JB"],];
CONWAYPOLDATA[104003]:=[
,,,[92484979761,"JB"],];
CONWAYPOLDATA[104009]:=[
,,,[10816623976,"JB"],];
CONWAYPOLDATA[104021]:=[
,,,[179815901652,"JB"],];
CONWAYPOLDATA[104033]:=[
,,,[7315288464,"JB"],];
CONWAYPOLDATA[104047]:=[
,,,[41033535630,"JB"],];
CONWAYPOLDATA[104053]:=[
,,,[10505086833,"JB"],];
CONWAYPOLDATA[104059]:=[
,,,[94182031899,"JB"],];
CONWAYPOLDATA[104087]:=[
,,,[19923604936,"JB"],];
CONWAYPOLDATA[104089]:=[
,,,[6812937324,"JB"],];
CONWAYPOLDATA[104107]:=[
,,,[32107535768,"JB"],];
CONWAYPOLDATA[104113]:=[
,,,[126408486616,"JB"],];
CONWAYPOLDATA[104119]:=[
,,,[32223685197,"JB"],];
CONWAYPOLDATA[104123]:=[
,,,[29828948796,"JB"],];
CONWAYPOLDATA[104147]:=[
,,,[39587107878,"JB"],];
CONWAYPOLDATA[104149]:=[
,,,[86219749656,"JB"],];
CONWAYPOLDATA[104161]:=[
,,,[160914058318,"JB"],];
CONWAYPOLDATA[104173]:=[
,,,[74100234189,"JB"],];
CONWAYPOLDATA[104179]:=[
,,,[28912381156,"JB"],];
CONWAYPOLDATA[104183]:=[
,,,[157499692085,"JB"],];
CONWAYPOLDATA[104207]:=[
,,,[43435978573,"JB"],];
CONWAYPOLDATA[104231]:=[
,,,[71958372401,"JB"],];
CONWAYPOLDATA[104233]:=[
,,,[115781182543,"JB"],];
CONWAYPOLDATA[104239]:=[
,,,[115856645034,"JB"],];
CONWAYPOLDATA[104243]:=[
,,,[29063782346,"JB"],];
CONWAYPOLDATA[104281]:=[
,,,[162634562006,"JB"],];
CONWAYPOLDATA[104287]:=[
,,,[61053155563,"JB"],];
CONWAYPOLDATA[104297]:=[
,,,[82048572557,"JB"],];
CONWAYPOLDATA[104309]:=[
,,,[73121443474,"JB"],];
CONWAYPOLDATA[104311]:=[
,,,[61680241727,"JB"],];
CONWAYPOLDATA[104323]:=[
,,,[59987498496,"JB"],];
CONWAYPOLDATA[104327]:=[
,,,[43536074413,"JB"],];
CONWAYPOLDATA[104347]:=[
,,,[32304996435,"JB"],];
CONWAYPOLDATA[104369]:=[
,,,[31873666389,"JB"],];
CONWAYPOLDATA[104381]:=[
,,,[7203019669,"JB"],];
CONWAYPOLDATA[104383]:=[
,,,[43582825229,"JB"],];
CONWAYPOLDATA[104393]:=[
,,,[126047866351,"JB"],];
CONWAYPOLDATA[104399]:=[
,,,[32031283591,"JB"],];
CONWAYPOLDATA[104417]:=[
,,,[86625387376,"JB"],];
CONWAYPOLDATA[104459]:=[
,,,[87001080709,"JB"],];
CONWAYPOLDATA[104471]:=[
,,,[62003851924,"JB"],];
CONWAYPOLDATA[104473]:=[
,,,[193950676896,"JB"],];
CONWAYPOLDATA[104479]:=[
,,,[7105721276,"JB"],];
CONWAYPOLDATA[104491]:=[
,,,[74490902466,"JB"],];
CONWAYPOLDATA[104513]:=[
,,,[50207418125,"JB"],];
CONWAYPOLDATA[104527]:=[
,,,[39116512051,"JB"],];
CONWAYPOLDATA[104537]:=[
,,,[106356466488,"JB"],];
CONWAYPOLDATA[104543]:=[
,,,[161135053109,"JB"],];
CONWAYPOLDATA[104549]:=[
,,,[17299827581,"JB"],];
CONWAYPOLDATA[104551]:=[
,,,[29232668705,"JB"],];
CONWAYPOLDATA[104561]:=[
,,,[6481527274,"JB"],];
CONWAYPOLDATA[104579]:=[
,,,[30855197320,"JB"],];
CONWAYPOLDATA[104593]:=[
,,,[140931536809,"JB"],];
CONWAYPOLDATA[104597]:=[
,,,[226985531314,"JB"],];
CONWAYPOLDATA[104623]:=[
,,,[62581293687,"JB"],];
CONWAYPOLDATA[104639]:=[
,,,[41562506174,"JB"],];
CONWAYPOLDATA[104651]:=[
,,,[5801956097,"JB"],];
CONWAYPOLDATA[104659]:=[
,,,[98405624752,"JB"],];
CONWAYPOLDATA[104677]:=[
,,,[75340747367,"JB"],];
CONWAYPOLDATA[104681]:=[
,,,[9561248503,"JB"],];
CONWAYPOLDATA[104683]:=[
,,,[128325446186,"JB"],];
CONWAYPOLDATA[104693]:=[
,,,[173905123531,"JB"],];
CONWAYPOLDATA[104701]:=[
,,,[119380813109,"JB"],];
CONWAYPOLDATA[104707]:=[
,,,[96683930834,"JB"],];
CONWAYPOLDATA[104711]:=[
,,,[42541775701,"JB"],];
CONWAYPOLDATA[104717]:=[
,,,[76081822201,"JB"],];
CONWAYPOLDATA[104723]:=[
,,,[32355322805,"JB"],];
CONWAYPOLDATA[104729]:=[
,,,[9090581941,"JB"],];
CONWAYPOLDATA[104743]:=[
,,,[41791409573,"JB"],];
CONWAYPOLDATA[104759]:=[
,,,[32548830825,"JB"],];
CONWAYPOLDATA[104761]:=[
,,,[10145683813,"JB"],];
CONWAYPOLDATA[104773]:=[
,,,[142365133310,"JB"],];
CONWAYPOLDATA[104779]:=[
,,,[60638017220,"JB"],];
CONWAYPOLDATA[104789]:=[
,,,[19891152771,"JB"],];
CONWAYPOLDATA[104801]:=[
,,,[65898240007,"JB"],];
CONWAYPOLDATA[104803]:=[
,,,[60970507692,"JB"],];
CONWAYPOLDATA[104827]:=[
,,,[63443921078,"JB"],];
CONWAYPOLDATA[104831]:=[
,,,[54068475230,"JB"],];
CONWAYPOLDATA[104849]:=[
,,,[87898481569,"JB"],];
CONWAYPOLDATA[104851]:=[
,,,[28487911862,"JB"],];
CONWAYPOLDATA[104869]:=[
,,,[140476430000,"JB"],];
CONWAYPOLDATA[104879]:=[
,,,[62661951262,"JB"],];
CONWAYPOLDATA[104891]:=[
,,,[99018362694,"JB"],];
CONWAYPOLDATA[104911]:=[
,,,[50586615452,"JB"],];
CONWAYPOLDATA[104917]:=[
,,,[138937491339,"JB"],];
CONWAYPOLDATA[104933]:=[
,,,[75545044290,"JB"],];
CONWAYPOLDATA[104947]:=[
,,,[86329402205,"JB"],];
CONWAYPOLDATA[104953]:=[
,,,[206866980937,"JB"],];
CONWAYPOLDATA[104959]:=[
,,,[29634019104,"JB"],];
CONWAYPOLDATA[104971]:=[
,,,[32739510163,"JB"],];
CONWAYPOLDATA[104987]:=[
,,,[82994638203,"JB"],];
CONWAYPOLDATA[104999]:=[
,,,[85534915385,"JB"],];
CONWAYPOLDATA[105019]:=[
,,,[20914953928,"JB"],];
CONWAYPOLDATA[105023]:=[
,,,[63984842663,"JB"],];
CONWAYPOLDATA[105031]:=[
,,,[40891089047,"JB"],];
CONWAYPOLDATA[105037]:=[
,,,[119791232284,"JB"],];
CONWAYPOLDATA[105071]:=[
,,,[84588564338,"JB"],];
CONWAYPOLDATA[105097]:=[
,,,[149406210498,"JB"],];
CONWAYPOLDATA[105107]:=[
,,,[98703671348,"JB"],];
CONWAYPOLDATA[105137]:=[
,,,[88243586843,"JB"],];
CONWAYPOLDATA[105143]:=[
,,,[98466419505,"JB"],];
CONWAYPOLDATA[105167]:=[
,,,[132719912669,"JB"],];
CONWAYPOLDATA[105173]:=[
,,,[41340245939,"JB"],];
CONWAYPOLDATA[105199]:=[
,,,[44046190112,"JB"],];
CONWAYPOLDATA[105211]:=[
,,,[94346596509,"JB"],];
CONWAYPOLDATA[105227]:=[
,,,[61397849965,"JB"],];
CONWAYPOLDATA[105229]:=[
,,,[99657545368,"JB"],];
CONWAYPOLDATA[105239]:=[
,,,[31982553070,"JB"],];
CONWAYPOLDATA[105251]:=[
,,,[30828754659,"JB"],];
CONWAYPOLDATA[105253]:=[
,,,[72219451209,"JB"],];
CONWAYPOLDATA[105263]:=[
,,,[44320775629,"JB"],];
CONWAYPOLDATA[105269]:=[
,,,[106083992600,"JB"],];
CONWAYPOLDATA[105277]:=[
,,,[119948402726,"JB"],];
CONWAYPOLDATA[105319]:=[
,,,[39448600600,"JB"],];
CONWAYPOLDATA[105323]:=[
,,,[98770750849,"JB"],];
CONWAYPOLDATA[105331]:=[
,,,[154412507396,"JB"],];
CONWAYPOLDATA[105337]:=[
,,,[74981404698,"JB"],];
CONWAYPOLDATA[105341]:=[
,,,[50334352645,"JB"],];
CONWAYPOLDATA[105359]:=[
,,,[97096431150,"JB"],];
CONWAYPOLDATA[105361]:=[
,,,[320480346713,"JB"],];
CONWAYPOLDATA[105367]:=[
,,,[44035714212,"JB"],];
CONWAYPOLDATA[105373]:=[
,,,[108863796746,"JB"],];
CONWAYPOLDATA[105379]:=[
,,,[85177424186,"JB"],];
CONWAYPOLDATA[105389]:=[
,,,[77432459972,"JB"],];
CONWAYPOLDATA[105397]:=[
,,,[86250897173,"JB"],];
CONWAYPOLDATA[105401]:=[
,,,[50558857084,"JB"],];
CONWAYPOLDATA[105407]:=[
,,,[108933602004,"JB"],];
CONWAYPOLDATA[105437]:=[
,,,[40123312293,"JB"],];
CONWAYPOLDATA[105449]:=[
,,,[50270596327,"JB"],];
CONWAYPOLDATA[105467]:=[
,,,[55497790072,"JB"],];
CONWAYPOLDATA[105491]:=[
,,,[86576358211,"JB"],];
CONWAYPOLDATA[105499]:=[
,,,[41663454084,"JB"],];
CONWAYPOLDATA[105503]:=[
,,,[95064216681,"JB"],];
CONWAYPOLDATA[105509]:=[
,,,[42514429516,"JB"],];
CONWAYPOLDATA[105517]:=[
,,,[106577656886,"JB"],];
CONWAYPOLDATA[105527]:=[
,,,[96899218012,"JB"],];
CONWAYPOLDATA[105529]:=[
,,,[252924836768,"JB"],];
CONWAYPOLDATA[105533]:=[
,,,[96978917154,"JB"],];
CONWAYPOLDATA[105541]:=[
,,,[72628355775,"JB"],];
CONWAYPOLDATA[105557]:=[
,,,[64341002669,"JB"],];
CONWAYPOLDATA[105563]:=[
,,,[163742675133,"JB"],];
CONWAYPOLDATA[105601]:=[
,,,[229508144569,"JB"],];
CONWAYPOLDATA[105607]:=[
,,,[30783806861,"JB"],];
CONWAYPOLDATA[105613]:=[
,,,[120856757970,"JB"],];
CONWAYPOLDATA[105619]:=[
,,,[85488335460,"JB"],];
CONWAYPOLDATA[105649]:=[
,,,[11037890580,"JB"],];
CONWAYPOLDATA[105653]:=[
,,,[144651212750,"JB"],];
CONWAYPOLDATA[105667]:=[
,,,[31291802715,"JB"],];
CONWAYPOLDATA[105673]:=[
,,,[76980984064,"JB"],];
CONWAYPOLDATA[105683]:=[
,,,[150912047829,"JB"],];
CONWAYPOLDATA[105691]:=[
,,,[33259266646,"JB"],];
CONWAYPOLDATA[105701]:=[
,,,[40950364320,"JB"],];
CONWAYPOLDATA[105727]:=[
,,,[39535871567,"JB"],];
CONWAYPOLDATA[105733]:=[
,,,[8186166065,"JB"],];
CONWAYPOLDATA[105751]:=[
,,,[8252279292,"JB"],];
CONWAYPOLDATA[105761]:=[
,,,[87743556043,"JB"],];
CONWAYPOLDATA[105767]:=[
,,,[40810725790,"JB"],];
CONWAYPOLDATA[105769]:=[
,,,[257300861699,"JB"],];
CONWAYPOLDATA[105817]:=[
,,,[266104993827,"JB"],];
CONWAYPOLDATA[105829]:=[
,,,[100797254368,"JB"],];
CONWAYPOLDATA[105863]:=[
,,,[31272141931,"JB"],];
CONWAYPOLDATA[105871]:=[
,,,[40930469714,"JB"],];
CONWAYPOLDATA[105883]:=[
,,,[95886797738,"JB"],];
CONWAYPOLDATA[105899]:=[
,,,[28082085024,"JB"],];
CONWAYPOLDATA[105907]:=[
,,,[10858115180,"JB"],];
CONWAYPOLDATA[105913]:=[
,,,[74103830981,"JB"],];
CONWAYPOLDATA[105929]:=[
,,,[11219681896,"JB"],];
CONWAYPOLDATA[105943]:=[
,,,[66341718489,"JB"],];
CONWAYPOLDATA[105953]:=[
,,,[7106903431,"JB"],];
CONWAYPOLDATA[105967]:=[
,,,[75311700606,"JB"],];
CONWAYPOLDATA[105971]:=[
,,,[101067933774,"JB"],];
CONWAYPOLDATA[105977]:=[
,,,[51756517380,"JB"],];
CONWAYPOLDATA[105983]:=[
,,,[77828722038,"JB"],];
CONWAYPOLDATA[105997]:=[
,,,[76390659944,"JB"],];
CONWAYPOLDATA[106013]:=[
,,,[39470442123,"JB"],];
CONWAYPOLDATA[106019]:=[
,,,[98942337771,"JB"],];
CONWAYPOLDATA[106031]:=[
,,,[43741816697,"JB"],];
CONWAYPOLDATA[106033]:=[
,,,[134430121867,"JB"],];
CONWAYPOLDATA[106087]:=[
,,,[56271833500,"JB"],];
CONWAYPOLDATA[106103]:=[
,,,[45030962029,"JB"],];
CONWAYPOLDATA[106109]:=[
,,,[20232545795,"JB"],];
CONWAYPOLDATA[106121]:=[
,,,[28424722095,"JB"],];
CONWAYPOLDATA[106123]:=[
,,,[88904649375,"JB"],];
CONWAYPOLDATA[106129]:=[
,,,[254685296482,"JB"],];
CONWAYPOLDATA[106163]:=[
,,,[88106584636,"JB"],];
CONWAYPOLDATA[106181]:=[
,,,[54919255365,"JB"],];
CONWAYPOLDATA[106187]:=[
,,,[167600145265,"JB"],];
CONWAYPOLDATA[106189]:=[
,,,[85533009537,"JB"],];
CONWAYPOLDATA[106207]:=[
,,,[56210054756,"JB"],];
CONWAYPOLDATA[106213]:=[
,,,[75166409037,"JB"],];
CONWAYPOLDATA[106217]:=[
,,,[6999169218,"JB"],];
CONWAYPOLDATA[106219]:=[
,,,[56411954936,"JB"],];
CONWAYPOLDATA[106243]:=[
,,,[44131217343,"JB"],];
CONWAYPOLDATA[106261]:=[
,,,[89412787147,"JB"],];
CONWAYPOLDATA[106273]:=[
,,,[187316045894,"JB"],];
CONWAYPOLDATA[106277]:=[
,,,[39570540520,"JB"],];
CONWAYPOLDATA[106279]:=[
,,,[29254570101,"JB"],];
CONWAYPOLDATA[106291]:=[
,,,[76552372567,"JB"],];
CONWAYPOLDATA[106297]:=[
,,,[179701031137,"JB"],];
CONWAYPOLDATA[106303]:=[
,,,[74100313304,"JB"],];
CONWAYPOLDATA[106307]:=[
,,,[30461420396,"JB"],];
CONWAYPOLDATA[106319]:=[
,,,[77535576098,"JB"],];
CONWAYPOLDATA[106321]:=[
,,,[179682171050,"JB"],];
CONWAYPOLDATA[106331]:=[
,,,[30911485017,"JB"],];
CONWAYPOLDATA[106349]:=[
,,,[20415817532,"JB"],];
CONWAYPOLDATA[106357]:=[
,,,[75298203434,"JB"],];
CONWAYPOLDATA[106363]:=[
,,,[120182638229,"JB"],];
CONWAYPOLDATA[106367]:=[
,,,[74039409530,"JB"],];
CONWAYPOLDATA[106373]:=[
,,,[88726357543,"JB"],];
CONWAYPOLDATA[106391]:=[
,,,[54897649632,"JB"],];
CONWAYPOLDATA[106397]:=[
,,,[113019574870,"JB"],];
CONWAYPOLDATA[106411]:=[
,,,[101789463861,"JB"],];
CONWAYPOLDATA[106417]:=[
,,,[201253169982,"JB"],];
CONWAYPOLDATA[106427]:=[
,,,[32815062620,"JB"],];
CONWAYPOLDATA[106433]:=[
,,,[56242496626,"JB"],];
CONWAYPOLDATA[106441]:=[
,,,[200681519705,"JB"],];
CONWAYPOLDATA[106451]:=[
,,,[89532849023,"JB"],];
CONWAYPOLDATA[106453]:=[
,,,[99056964925,"JB"],];
CONWAYPOLDATA[106487]:=[
,,,[45357498733,"JB"],];
CONWAYPOLDATA[106501]:=[
,,,[102081421504,"JB"],];
CONWAYPOLDATA[106531]:=[
,,,[75888210101,"JB"],];
CONWAYPOLDATA[106537]:=[
,,,[212904073490,"JB"],];
CONWAYPOLDATA[106541]:=[
,,,[43239451771,"JB"],];
CONWAYPOLDATA[106543]:=[
,,,[30453718410,"JB"],];
CONWAYPOLDATA[106591]:=[
,,,[77794268852,"JB"],];
CONWAYPOLDATA[106619]:=[
,,,[86825928985,"JB"],];
CONWAYPOLDATA[106621]:=[
,,,[226680297608,"JB"],];
CONWAYPOLDATA[106627]:=[
,,,[166786699791,"JB"],];
CONWAYPOLDATA[106637]:=[
,,,[21939709656,"JB"],];
CONWAYPOLDATA[106649]:=[
,,,[11372729416,"JB"],];
CONWAYPOLDATA[106657]:=[
,,,[74738932842,"JB"],];
CONWAYPOLDATA[106661]:=[
,,,[74108276124,"JB"],];
CONWAYPOLDATA[106663]:=[
,,,[45507555629,"JB"],];
CONWAYPOLDATA[106669]:=[
,,,[159023745254,"JB"],];
CONWAYPOLDATA[106681]:=[
,,,[247440498706,"JB"],];
CONWAYPOLDATA[106693]:=[
,,,[22112017559,"JB"],];
CONWAYPOLDATA[106699]:=[
,,,[88483026626,"JB"],];
CONWAYPOLDATA[106703]:=[
,,,[41437363136,"JB"],];
CONWAYPOLDATA[106721]:=[
,,,[52541309607,"JB"],];
CONWAYPOLDATA[106727]:=[
,,,[42910444176,"JB"],];
CONWAYPOLDATA[106739]:=[
,,,[21194843015,"JB"],];
CONWAYPOLDATA[106747]:=[
,,,[121378170810,"JB"],];
CONWAYPOLDATA[106751]:=[
,,,[77555989276,"JB"],];
CONWAYPOLDATA[106753]:=[
,,,[146383449960,"JB"],];
CONWAYPOLDATA[106759]:=[
,,,[102410065382,"JB"],];
CONWAYPOLDATA[106781]:=[
,,,[56742889497,"JB"],];
CONWAYPOLDATA[106783]:=[
,,,[147482272625,"JB"],];
CONWAYPOLDATA[106787]:=[
,,,[8182981025,"JB"],];
CONWAYPOLDATA[106801]:=[
,,,[167747204263,"JB"],];
CONWAYPOLDATA[106823]:=[
,,,[45644186029,"JB"],];
CONWAYPOLDATA[106853]:=[
,,,[17165400187,"JB"],];
CONWAYPOLDATA[106859]:=[
,,,[86198880942,"JB"],];
CONWAYPOLDATA[106861]:=[
,,,[55578512968,"JB"],];
CONWAYPOLDATA[106867]:=[
,,,[34054986292,"JB"],];
CONWAYPOLDATA[106871]:=[
,,,[30516479702,"JB"],];
CONWAYPOLDATA[106877]:=[
,,,[20433493001,"JB"],];
CONWAYPOLDATA[106903]:=[
,,,[45712578029,"JB"],];
CONWAYPOLDATA[106907]:=[
,,,[134447098458,"JB"],];
CONWAYPOLDATA[106921]:=[
,,,[122839077731,"JB"],];
CONWAYPOLDATA[106937]:=[
,,,[76220309186,"JB"],];
CONWAYPOLDATA[106949]:=[
,,,[21012270032,"JB"],];
CONWAYPOLDATA[106957]:=[
,,,[239512981428,"JB"],];
CONWAYPOLDATA[106961]:=[
,,,[86614985544,"JB"],];
CONWAYPOLDATA[106963]:=[
,,,[63313538963,"JB"],];
CONWAYPOLDATA[106979]:=[
,,,[77792133390,"JB"],];
CONWAYPOLDATA[106993]:=[
,,,[213405028015,"JB"],];
CONWAYPOLDATA[107021]:=[
,,,[109823665955,"JB"],];
CONWAYPOLDATA[107033]:=[
,,,[112447692440,"JB"],];
CONWAYPOLDATA[107053]:=[
,,,[227229520222,"JB"],];
CONWAYPOLDATA[107057]:=[
,,,[6164235006,"JB"],];
CONWAYPOLDATA[107069]:=[
,,,[22176131282,"JB"],];
CONWAYPOLDATA[107071]:=[
,,,[43727689332,"JB"],];
CONWAYPOLDATA[107077]:=[
,,,[103188605824,"JB"],];
CONWAYPOLDATA[107089]:=[
,,,[10292109619,"JB"],];
CONWAYPOLDATA[107099]:=[
,,,[112640302262,"JB"],];
CONWAYPOLDATA[107101]:=[
,,,[149117257811,"JB"],];
CONWAYPOLDATA[107119]:=[
,,,[79332224284,"JB"],];
CONWAYPOLDATA[107123]:=[
,,,[54215164548,"JB"],];
CONWAYPOLDATA[107137]:=[
,,,[178505455464,"JB"],];
CONWAYPOLDATA[107171]:=[
,,,[33862499367,"JB"],];
CONWAYPOLDATA[107183]:=[
,,,[53018606870,"JB"],];
CONWAYPOLDATA[107197]:=[
,,,[181726571828,"JB"],];
CONWAYPOLDATA[107201]:=[
,,,[88904254930,"JB"],];
CONWAYPOLDATA[107209]:=[
,,,[168792958674,"JB"],];
CONWAYPOLDATA[107227]:=[
,,,[64223075535,"JB"],];
CONWAYPOLDATA[107243]:=[
,,,[156612100566,"JB"],];
CONWAYPOLDATA[107251]:=[
,,,[31565041813,"JB"],];
CONWAYPOLDATA[107269]:=[
,,,[89572082193,"JB"],];
CONWAYPOLDATA[107273]:=[
,,,[20733403624,"JB"],];
CONWAYPOLDATA[107279]:=[
,,,[41954027653,"JB"],];
CONWAYPOLDATA[107309]:=[
,,,[77759427981,"JB"],];
CONWAYPOLDATA[107323]:=[
,,,[31322324886,"JB"],];
CONWAYPOLDATA[107339]:=[
,,,[51915580746,"JB"],];
CONWAYPOLDATA[107347]:=[
,,,[99569924546,"JB"],];
CONWAYPOLDATA[107351]:=[
,,,[66976074217,"JB"],];
CONWAYPOLDATA[107357]:=[
,,,[44168065443,"JB"],];
CONWAYPOLDATA[107377]:=[
,,,[102706959526,"JB"],];
CONWAYPOLDATA[107441]:=[
,,,[11542279192,"JB"],];
CONWAYPOLDATA[107449]:=[
,,,[9367833623,"JB"],];
CONWAYPOLDATA[107453]:=[
,,,[114722625264,"JB"],];
CONWAYPOLDATA[107467]:=[
,,,[34561172268,"JB"],];
CONWAYPOLDATA[107473]:=[
,,,[183256081333,"JB"],];
CONWAYPOLDATA[107507]:=[
,,,[103348199214,"JB"],];
CONWAYPOLDATA[107509]:=[
,,,[80906865537,"JB"],];
CONWAYPOLDATA[107563]:=[
,,,[125541725209,"JB"],];
CONWAYPOLDATA[107581]:=[
,,,[87178048190,"JB"],];
CONWAYPOLDATA[107599]:=[
,,,[43016573817,"JB"],];
CONWAYPOLDATA[107603]:=[
,,,[137485967147,"JB"],];
CONWAYPOLDATA[107609]:=[
,,,[54270662191,"JB"],];
CONWAYPOLDATA[107621]:=[
,,,[180816409764,"JB"],];
CONWAYPOLDATA[107641]:=[
,,,[148913250436,"JB"],];
CONWAYPOLDATA[107647]:=[
,,,[67857547042,"JB"],];
CONWAYPOLDATA[107671]:=[
,,,[125711276056,"JB"],];
CONWAYPOLDATA[107687]:=[
,,,[87877222546,"JB"],];
CONWAYPOLDATA[107693]:=[
,,,[29697960147,"JB"],];
CONWAYPOLDATA[107699]:=[
,,,[102277216944,"JB"],];
CONWAYPOLDATA[107713]:=[
,,,[242905740570,"JB"],];
CONWAYPOLDATA[107717]:=[
,,,[79922674775,"JB"],];
CONWAYPOLDATA[107719]:=[
,,,[33634396001,"JB"],];
CONWAYPOLDATA[107741]:=[
,,,[58040184444,"JB"],];
CONWAYPOLDATA[107747]:=[
,,,[104483989854,"JB"],];
CONWAYPOLDATA[107761]:=[
,,,[11533336561,"JB"],];
CONWAYPOLDATA[107773]:=[
,,,[80675203520,"JB"],];
CONWAYPOLDATA[107777]:=[
,,,[91642028664,"JB"],];
CONWAYPOLDATA[107791]:=[
,,,[42657964880,"JB"],];
CONWAYPOLDATA[107827]:=[
,,,[41416135051,"JB"],];
CONWAYPOLDATA[107837]:=[
,,,[76648059351,"JB"],];
CONWAYPOLDATA[107839]:=[
,,,[66539898185,"JB"],];
CONWAYPOLDATA[107843]:=[
,,,[10743319662,"JB"],];
CONWAYPOLDATA[107857]:=[
,,,[149207324522,"JB"],];
CONWAYPOLDATA[107867]:=[
,,,[215965590451,"JB"],];
CONWAYPOLDATA[107873]:=[
,,,[205140142389,"JB"],];
CONWAYPOLDATA[107881]:=[
,,,[174307107558,"JB"],];
CONWAYPOLDATA[107897]:=[
,,,[29144058673,"JB"],];
CONWAYPOLDATA[107903]:=[
,,,[112443881954,"JB"],];
CONWAYPOLDATA[107923]:=[
,,,[104703548989,"JB"],];
CONWAYPOLDATA[107927]:=[
,,,[46592517613,"JB"],];
CONWAYPOLDATA[107941]:=[
,,,[123489145469,"JB"],];
CONWAYPOLDATA[107951]:=[
,,,[46185108141,"JB"],];
CONWAYPOLDATA[107971]:=[
,,,[80552304408,"JB"],];
CONWAYPOLDATA[107981]:=[
,,,[57083183823,"JB"],];
CONWAYPOLDATA[107999]:=[
,,,[76364148931,"JB"],];
CONWAYPOLDATA[108007]:=[
,,,[32626538557,"JB"],];
CONWAYPOLDATA[108011]:=[
,,,[17626315097,"JB"],];
CONWAYPOLDATA[108013]:=[
,,,[101486530507,"JB"],];
CONWAYPOLDATA[108023]:=[
,,,[90086753062,"JB"],];
CONWAYPOLDATA[108037]:=[
,,,[265441831263,"JB"],];
CONWAYPOLDATA[108041]:=[
,,,[127905526307,"JB"],];
CONWAYPOLDATA[108061]:=[
,,,[124420030609,"JB"],];
CONWAYPOLDATA[108079]:=[
,,,[58404918892,"JB"],];
CONWAYPOLDATA[108089]:=[
,,,[31573661618,"JB"],];
CONWAYPOLDATA[108107]:=[
,,,[151676283142,"JB"],];
CONWAYPOLDATA[108109]:=[
,,,[76915769687,"JB"],];
CONWAYPOLDATA[108127]:=[
,,,[91279515882,"JB"],];
CONWAYPOLDATA[108131]:=[
,,,[6984397558,"JB"],];
CONWAYPOLDATA[108139]:=[
,,,[78539301061,"JB"],];
CONWAYPOLDATA[108161]:=[
,,,[11697503992,"JB"],];
CONWAYPOLDATA[108179]:=[
,,,[104393708613,"JB"],];
CONWAYPOLDATA[108187]:=[
,,,[101390909039,"JB"],];
CONWAYPOLDATA[108191]:=[
,,,[46577199232,"JB"],];
CONWAYPOLDATA[108193]:=[
,,,[77801802699,"JB"],];
CONWAYPOLDATA[108203]:=[
,,,[100650863414,"JB"],];
CONWAYPOLDATA[108211]:=[
,,,[64868057852,"JB"],];
CONWAYPOLDATA[108217]:=[
,,,[148263241940,"JB"],];
CONWAYPOLDATA[108223]:=[
,,,[42968535254,"JB"],];
CONWAYPOLDATA[108233]:=[
,,,[18092769448,"JB"],];
CONWAYPOLDATA[108247]:=[
,,,[34561643398,"JB"],];
CONWAYPOLDATA[108263]:=[
,,,[103775065603,"JB"],];
CONWAYPOLDATA[108271]:=[
,,,[77479377229,"JB"],];
CONWAYPOLDATA[108287]:=[
,,,[115031980661,"JB"],];
CONWAYPOLDATA[108289]:=[
,,,[207477825603,"JB"],];
CONWAYPOLDATA[108293]:=[
,,,[58575142237,"JB"],];
CONWAYPOLDATA[108301]:=[
,,,[93260373728,"JB"],];
CONWAYPOLDATA[108343]:=[
,,,[81238181635,"JB"],];
CONWAYPOLDATA[108347]:=[
,,,[10856802790,"JB"],];
CONWAYPOLDATA[108359]:=[
,,,[93766076763,"JB"],];
CONWAYPOLDATA[108377]:=[
,,,[93529025872,"JB"],];
CONWAYPOLDATA[108379]:=[
,,,[30621294283,"JB"],];
CONWAYPOLDATA[108401]:=[
,,,[54971556316,"JB"],];
CONWAYPOLDATA[108413]:=[
,,,[30133284939,"JB"],];
CONWAYPOLDATA[108421]:=[
,,,[20237863877,"JB"],];
CONWAYPOLDATA[108439]:=[
,,,[79629468678,"JB"],];
CONWAYPOLDATA[108457]:=[
,,,[195441357774,"JB"],];
CONWAYPOLDATA[108461]:=[
,,,[53560102561,"JB"],];
CONWAYPOLDATA[108463]:=[
,,,[47056455629,"JB"],];
CONWAYPOLDATA[108497]:=[
,,,[150061115733,"JB"],];
CONWAYPOLDATA[108499]:=[
,,,[33563080674,"JB"],];
CONWAYPOLDATA[108503]:=[
,,,[30442361206,"JB"],];
CONWAYPOLDATA[108517]:=[
,,,[80381146313,"JB"],];
CONWAYPOLDATA[108529]:=[
,,,[173665935243,"JB"],];
CONWAYPOLDATA[108533]:=[
,,,[45167744480,"JB"],];
CONWAYPOLDATA[108541]:=[
,,,[124865892025,"JB"],];
CONWAYPOLDATA[108553]:=[
,,,[304158992825,"JB"],];
CONWAYPOLDATA[108557]:=[
,,,[81787820815,"JB"],];
CONWAYPOLDATA[108571]:=[
,,,[45396249378,"JB"],];
CONWAYPOLDATA[108587]:=[
,,,[8827688754,"JB"],];
CONWAYPOLDATA[108631]:=[
,,,[45494662806,"JB"],];
CONWAYPOLDATA[108637]:=[
,,,[183520701389,"JB"],];
CONWAYPOLDATA[108643]:=[
,,,[82622241004,"JB"],];
CONWAYPOLDATA[108649]:=[
,,,[269233851746,"JB"],];
CONWAYPOLDATA[108677]:=[
,,,[150640776043,"JB"],];
CONWAYPOLDATA[108707]:=[
,,,[8763523514,"JB"],];
CONWAYPOLDATA[108709]:=[
,,,[103384324477,"JB"],];
CONWAYPOLDATA[108727]:=[
,,,[59107367740,"JB"],];
CONWAYPOLDATA[108739]:=[
,,,[101545153979,"JB"],];
CONWAYPOLDATA[108751]:=[
,,,[44106034322,"JB"],];
CONWAYPOLDATA[108761]:=[
,,,[11827649992,"JB"],];
CONWAYPOLDATA[108769]:=[
,,,[197326653196,"JB"],];
CONWAYPOLDATA[108791]:=[
,,,[30032190721,"JB"],];
CONWAYPOLDATA[108793]:=[
,,,[102349734580,"JB"],];
CONWAYPOLDATA[108799]:=[
,,,[69431713841,"JB"],];
CONWAYPOLDATA[108803]:=[
,,,[101004871386,"JB"],];
CONWAYPOLDATA[108821]:=[
,,,[7490802358,"JB"],];
CONWAYPOLDATA[108827]:=[
,,,[129067516078,"JB"],];
CONWAYPOLDATA[108863]:=[
,,,[41799799526,"JB"],];
CONWAYPOLDATA[108869]:=[
,,,[47143434203,"JB"],];
CONWAYPOLDATA[108877]:=[
,,,[46783249255,"JB"],];
CONWAYPOLDATA[108881]:=[
,,,[31337040613,"JB"],];
CONWAYPOLDATA[108883]:=[
,,,[33749374682,"JB"],];
CONWAYPOLDATA[108887]:=[
,,,[66739455593,"JB"],];
CONWAYPOLDATA[108893]:=[
,,,[93443587842,"JB"],];
CONWAYPOLDATA[108907]:=[
,,,[6847200916,"JB"],];
CONWAYPOLDATA[108917]:=[
,,,[341004205373,"JB"],];
CONWAYPOLDATA[108923]:=[
,,,[89279717259,"JB"],];
CONWAYPOLDATA[108929]:=[
,,,[31432116527,"JB"],];
CONWAYPOLDATA[108943]:=[
,,,[65782833807,"JB"],];
CONWAYPOLDATA[108947]:=[
,,,[32225977867,"JB"],];
CONWAYPOLDATA[108949]:=[
,,,[127514563296,"JB"],];
CONWAYPOLDATA[108959]:=[
,,,[90920292766,"JB"],];
CONWAYPOLDATA[108961]:=[
,,,[176022899794,"JB"],];
CONWAYPOLDATA[108967]:=[
,,,[44428679045,"JB"],];
CONWAYPOLDATA[108971]:=[
,,,[53542464968,"JB"],];
CONWAYPOLDATA[108991]:=[
,,,[31403140872,"JB"],];
CONWAYPOLDATA[109001]:=[
,,,[11879909992,"JB"],];
CONWAYPOLDATA[109013]:=[
,,,[94406021093,"JB"],];
CONWAYPOLDATA[109037]:=[
,,,[23350600663,"JB"],];
CONWAYPOLDATA[109049]:=[
,,,[11890375816,"JB"],];
CONWAYPOLDATA[109063]:=[
,,,[43042149208,"JB"],];
CONWAYPOLDATA[109073]:=[
,,,[20968411669,"JB"],];
CONWAYPOLDATA[109097]:=[
,,,[81630302895,"JB"],];
CONWAYPOLDATA[109103]:=[
,,,[92636520627,"JB"],];
CONWAYPOLDATA[109111]:=[
,,,[77512563514,"JB"],];
CONWAYPOLDATA[109121]:=[
,,,[11906083192,"JB"],];
CONWAYPOLDATA[109133]:=[
,,,[113669113147,"JB"],];
CONWAYPOLDATA[109139]:=[
,,,[101994542784,"JB"],];
CONWAYPOLDATA[109141]:=[
,,,[151666808383,"JB"],];
CONWAYPOLDATA[109147]:=[
,,,[34805122804,"JB"],];
CONWAYPOLDATA[109159]:=[
,,,[58447112535,"JB"],];
CONWAYPOLDATA[109169]:=[
,,,[106351893958,"JB"],];
CONWAYPOLDATA[109171]:=[
,,,[44841005713,"JB"],];
CONWAYPOLDATA[109199]:=[
,,,[70099970472,"JB"],];
CONWAYPOLDATA[109201]:=[
,,,[459228206965,"JB"],];
CONWAYPOLDATA[109211]:=[
,,,[54440482185,"JB"],];
CONWAYPOLDATA[109229]:=[
,,,[21008450488,"JB"],];
CONWAYPOLDATA[109253]:=[
,,,[282017500228,"JB"],];
CONWAYPOLDATA[109267]:=[
,,,[106153218303,"JB"],];
CONWAYPOLDATA[109279]:=[
,,,[42208139529,"JB"],];
CONWAYPOLDATA[109297]:=[
,,,[213950079772,"JB"],];
CONWAYPOLDATA[109303]:=[
,,,[105972537593,"JB"],];
CONWAYPOLDATA[109313]:=[
,,,[82885489123,"JB"],];
CONWAYPOLDATA[109321]:=[
,,,[246346346481,"JB"],];
CONWAYPOLDATA[109331]:=[
,,,[56762359251,"JB"],];
CONWAYPOLDATA[109357]:=[
,,,[42615985483,"JB"],];
CONWAYPOLDATA[109363]:=[
,,,[11840294561,"JB"],];
CONWAYPOLDATA[109367]:=[
,,,[45068062732,"JB"],];
CONWAYPOLDATA[109379]:=[
,,,[68985444681,"JB"],];
CONWAYPOLDATA[109387]:=[
,,,[78646955875,"JB"],];
CONWAYPOLDATA[109391]:=[
,,,[59830969893,"JB"],];
CONWAYPOLDATA[109397]:=[
,,,[211618213184,"JB"],];
CONWAYPOLDATA[109423]:=[
,,,[179151712523,"JB"],];
CONWAYPOLDATA[109433]:=[
,,,[117735025115,"JB"],];
CONWAYPOLDATA[109441]:=[
,,,[102112940095,"JB"],];
CONWAYPOLDATA[109451]:=[
,,,[31850350453,"JB"],];
CONWAYPOLDATA[109453]:=[
,,,[80121018891,"JB"],];
CONWAYPOLDATA[109469]:=[
,,,[42353884509,"JB"],];
CONWAYPOLDATA[109471]:=[
,,,[34393817725,"JB"],];
CONWAYPOLDATA[109481]:=[
,,,[34617454279,"JB"],];
CONWAYPOLDATA[109507]:=[
,,,[31029575001,"JB"],];
CONWAYPOLDATA[109517]:=[
,,,[8364798945,"JB"],];
CONWAYPOLDATA[109519]:=[
,,,[46909835197,"JB"],];
CONWAYPOLDATA[109537]:=[
,,,[179974110633,"JB"],];
CONWAYPOLDATA[109541]:=[
,,,[114134273214,"JB"],];
CONWAYPOLDATA[109547]:=[
,,,[91409631853,"JB"],];
CONWAYPOLDATA[109567]:=[
,,,[35874317578,"JB"],];
CONWAYPOLDATA[109579]:=[
,,,[104113856956,"JB"],];
CONWAYPOLDATA[109583]:=[
,,,[33943005506,"JB"],];
CONWAYPOLDATA[109589]:=[
,,,[11566899774,"JB"],];
CONWAYPOLDATA[109597]:=[
,,,[90783469388,"JB"],];
CONWAYPOLDATA[109609]:=[
,,,[200659442570,"JB"],];
CONWAYPOLDATA[109619]:=[
,,,[92537728946,"JB"],];
CONWAYPOLDATA[109621]:=[
,,,[92295291339,"JB"],];
CONWAYPOLDATA[109639]:=[
,,,[60103113052,"JB"],];
CONWAYPOLDATA[109661]:=[
,,,[60127235964,"JB"],];
CONWAYPOLDATA[109663]:=[
,,,[71493147916,"JB"],];
CONWAYPOLDATA[109673]:=[
,,,[7984523422,"JB"],];
CONWAYPOLDATA[109717]:=[
,,,[126609797344,"JB"],];
CONWAYPOLDATA[109721]:=[
,,,[94254288959,"JB"],];
CONWAYPOLDATA[109741]:=[
,,,[83060768082,"JB"],];
CONWAYPOLDATA[109751]:=[
,,,[84138848145,"JB"],];
CONWAYPOLDATA[109789]:=[
,,,[150735905450,"JB"],];
CONWAYPOLDATA[109793]:=[
,,,[8701424632,"JB"],];
CONWAYPOLDATA[109807]:=[
,,,[48229869773,"JB"],];
CONWAYPOLDATA[109819]:=[
,,,[46043372857,"JB"],];
CONWAYPOLDATA[109829]:=[
,,,[47750573990,"JB"],];
CONWAYPOLDATA[109831]:=[
,,,[47511682462,"JB"],];
CONWAYPOLDATA[109841]:=[
,,,[57170043683,"JB"],];
CONWAYPOLDATA[109843]:=[
,,,[93011427583,"JB"],];
CONWAYPOLDATA[109847]:=[
,,,[176133952461,"JB"],];
CONWAYPOLDATA[109849]:=[
,,,[299680924340,"JB"],];
CONWAYPOLDATA[109859]:=[
,,,[46944069010,"JB"],];
CONWAYPOLDATA[109873]:=[
,,,[6168599854,"JB"],];
CONWAYPOLDATA[109883]:=[
,,,[108170363564,"JB"],];
CONWAYPOLDATA[109891]:=[
,,,[81610880825,"JB"],];
CONWAYPOLDATA[109897]:=[
,,,[153631939821,"JB"],];
CONWAYPOLDATA[109903]:=[
,,,[33082781257,"JB"],];
CONWAYPOLDATA[109913]:=[
,,,[35504756741,"JB"],];
CONWAYPOLDATA[109919]:=[
,,,[48327866909,"JB"],];
CONWAYPOLDATA[109937]:=[
,,,[71042938458,"JB"],];
CONWAYPOLDATA[109943]:=[
,,,[48349413229,"JB"],];
CONWAYPOLDATA[109961]:=[
,,,[12090101992,"JB"],];
CONWAYPOLDATA[109987]:=[
,,,[47347863685,"JB"],];
CONWAYPOLYNOMIALSINFO.conwdat3 := true;
