#############################################################################
##
#W  fastendo.gi           GAP library                    Andrew Solomon
##
#H  @(#)$Id: fastendo.gi,v 4.3 2002/04/15 10:04:39 sal Exp $
##
#Y  Copyright (C)  1997,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St.  Andrews, Scotland
#Y  Copyright (C) 2002 The GAP Group
##
##  Conversion to, and fast methods for, transformation representation
##  of EndoMappings.
##

Revision.fastendo_gi :=
    "@(#)$Id: fastendo.gi,v 4.3 2002/04/15 10:04:39 sal Exp $";


############################################################################
##
#R  IsTransformationRepOfEndo(<obj>)
##
##  An endomorphism of a finite domain <D> with EnumeratorSorted can be 
##  represented as transformation on  [1 .. Length(EnumeratorSorted(D))]
##
DeclareRepresentation("IsTransformationRepOfEndo", 
IsComponentObjectRep and IsAttributeStoringRep,
["transformation"]);

############################################################################
##
#F  EndoMappingByTransformation(<dom>, <gmfam>, <trans>)
##
##  Creates an endo general mapping from <dom> to itself 
##  in the general mappings family <gmfam>, described by transformation
##  <trans>. At present this is a private function.
##
BindGlobal("EndoMappingByTransformation",
function(dom, gmfam, trans)
 local tmap;

 tmap :=  Objectify(gmfam!.transtype,
    rec( transformation := trans));
  SetSource(tmap,dom);
  SetRange(tmap,dom);
	SetIsEndoMapping(tmap, true);

  return tmap;
end);




############################################################################
##
#A  TransformationRepresentation(<obj>)
##
##  The user must deliberately put endomorphisms into this representation
##  since it calls enumerator sorted on the Source.
##
InstallMethod(TransformationRepresentation, 
"for an endo general mapping", true,
[IsEndoMapping], 0,
function(m)
	local trans;

  if not (HasIsFinite(Source(m)) and IsFinite(Source(m))) then
    	TryNextMethod();
  fi;

	# create the type if necessary
	if not IsBound(FamilyObj(m)!.transtype) then
		FamilyObj(m)!.transtype := NewType(FamilyObj(m), 
			IsEndoMapping and IsNonSPGeneralMapping 
			and IsTransformationRepOfEndo);
	fi;

	trans:= Transformation(List([1 .. Size(Source(m))], 
		i -> Position(EnumeratorSorted(Source(m)), 
			EnumeratorSorted(Source(m))[i]^m)));

	return EndoMappingByTransformation(Source(m),FamilyObj(m), trans);

end);

InstallMethod(TransformationRepresentation, 
"for an endo general mapping", true,
[IsEndoMapping and IsTransformationRepOfEndo], 0,m->m);

#############################################################################
##
#M  CompositionMapping2( <endo>, <endo> )  . . for IsTransformationRepOfEndo
##
##  Note: this is the dual of \*
##
InstallMethod(CompositionMapping2, 
	"IsTransformationRepOfEndo, IsTransformationRepOfEndo", IsIdenticalObj,
  [IsTransformationRepOfEndo and IsEndoMapping, 
	IsTransformationRepOfEndo and IsEndoMapping], 0,
function(n, m)
  local mntrans;

  if Source(n) <> Source(m) then
		TryNextMethod();
  fi;

  mntrans := m!.transformation* n!.transformation;

	return EndoMappingByTransformation(Source(m),FamilyObj(m), mntrans);
end);


InstallMethod(CompositionMapping2, 
	"IsEndoMapping, IsTransformationRepOfEndo", IsIdenticalObj,
  [IsEndoMapping, 
	IsTransformationRepOfEndo and IsEndoMapping], 0,
function(n, m)
  local mntrans;

  if Source(n) <> Source(m) then
		TryNextMethod();
  fi;

  mntrans := TransformationRepresentation(m)!.transformation* n!.transformation;

	return EndoMappingByTransformation(Source(m),FamilyObj(m), mntrans);
end);


InstallMethod(CompositionMapping2, 
	"IsTransformationRepOfEndo, IsEndoMapping", IsIdenticalObj,
  [IsTransformationRepOfEndo and IsEndoMapping, 
	IsEndoMapping], 0,
function(n, m)
  local mntrans;

  if Source(n) <> Source(m) then
		TryNextMethod();
  fi;

  mntrans := m!.transformation* TransformationRepresentation(n)!.transformation;

	return EndoMappingByTransformation(Source(m),FamilyObj(m), mntrans);
end);

#############################################################################
##
#M  \=( <endo>, <endo> )  . . . for IsTransformationRepOfEndo
##
InstallMethod(\=, 
	"IsTransformationRepOfEndo, IsTransformationRepOfEndo", IsIdenticalObj,
  [IsTransformationRepOfEndo and IsEndoMapping, 
	IsTransformationRepOfEndo and IsEndoMapping], 0,
function(m, n)

  if Source(n) <> Source(m) then
    return false;
  fi;

  return m!.transformation = n!.transformation;
end);


InstallMethod(\=, 
	"IsTransformationRepOfEndo, IsEndoMapping", IsIdenticalObj,
  [IsTransformationRepOfEndo and IsEndoMapping, 
	IsEndoMapping], 0,
function(m, n)

  if Source(n) <> Source(m) then
    return false;
  fi;

  return m!.transformation = TransformationRepresentation(n)!.transformation;
end);


InstallMethod(\=, 
	"IsEndoMapping, IsTransformationRepOfEndo", IsIdenticalObj,
  [IsEndoMapping, 
	IsTransformationRepOfEndo and IsEndoMapping], 0,
function(m, n)

	if Source(n) <> Source(m) then
		return false;
	fi;

  return TransformationRepresentation(m)!.transformation = n!.transformation;
end);


#############################################################################
##
#M  \<( <endo>, <endo> )  . . . for IsTransformationRepOfEndo
##
InstallMethod(\<, 
	"IsTransformationRepOfEndo, IsTransformationRepOfEndo", IsIdenticalObj,
  [IsEndoMapping and IsTransformationRepOfEndo, 
	IsEndoMapping and IsTransformationRepOfEndo], 0,
function(m, n)
  return TransformationRepresentation(m)!.transformation < 
		TransformationRepresentation(n)!.transformation;
end);


InstallMethod(\<, 
	"IsEndoMapping, IsTransformationRepOfEndo", IsIdenticalObj,
  [IsEndoMapping, 
	IsEndoMapping and IsTransformationRepOfEndo], 0,
function(m, n)
	if Source(n) <> Source(m) then
		TryNextMethod();
	fi;
	if not HasEnumeratorSorted(Source(m)) then
		TryNextMethod();
	fi;

  return TransformationRepresentation(m)!.transformation < 
		TransformationRepresentation(n)!.transformation;
end);


InstallMethod(\<, 
	"IsTransformationRepOfEndo, IsEndoMapping", IsIdenticalObj,
  [IsEndoMapping and IsTransformationRepOfEndo, 
	IsEndoMapping], 0,
function(m, n)
	if Source(n) <> Source(m) then
		TryNextMethod();
	fi;
	if not HasEnumeratorSorted(Source(m)) then
		TryNextMethod();
	fi;

  return TransformationRepresentation(m)!.transformation < 
		TransformationRepresentation(n)!.transformation;
end);

#############################################################################
##
#M  ImagesElm( <endo>, <elm> )  . . . for IsTransformationRepOfEndo
##
InstallMethod( ImagesElm,
    "IsTransformationRepOfEndo",
    FamSourceEqFamElm,
    [IsTransformationRepOfEndo and IsEndoMapping, IsObject ], 0,
function( endo, elm )
	local poselm;

	poselm := Position(EnumeratorSorted(Source(endo)), elm);
	return [EnumeratorSorted(Source(endo))[poselm^(endo!.transformation)]];
end);

############################################################################
##
#E

