%define name ganyremote
%define version 5.4

Summary: GTK frontend for anyRemote
Name: %{name}
Version: %{version}
Release: 1.suse11
License: GPLv2+
Group: System/Management
Source0: %{name}-%{version}.tar.gz
URL: http://anyremote.sourceforge.net/
Requires: python-gtk >= 2.10, pybluez >= 0.9.1, bluez-utils, anyremote >= 4.11
BuildRoot:    %{_tmppath}/%{name}-%{version}-build
BuildArch: noarch

%description
gAnyRemote package is GTK GUI frontend for anyRemote 
(http://anyremote.sourceforge.net/). The overall goal of this project is to 
provide remote control service on Linux through Bluetooth, InfraRed, Wi-Fi 
or TCP/IP connection.

%prep
%setup -q

%build
./configure --prefix=%{_prefix}

%install
make install DESTDIR=$RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{_defaultdocdir}
mv $RPM_BUILD_ROOT/%{_prefix}/share/doc/%{name} $RPM_BUILD_ROOT/%{_defaultdocdir}/%{name}

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && [ -d $RPM_BUILD_ROOT ] \
 && rm -rf $RPM_BUILD_ROOT

%changelog

* Fri Oct 17 2008 Mikhail Fedotov <anyremote at mail.ru> - 5.4
- Enhanced edit configuration file window. Support application details 
  auto wrap. Added Bulgarian translation (thanks to Stanislav Popov)

* Wed Sep 24 2008 Mikhail Fedotov <anyremote at mail.ru> - 5.3
- Add icons to menu and buttons.

* Mon Sep 8 2008 Mikhail Fedotov <anyremote at mail.ru> - 5.2.1
- Small bugfixes.

* Thu Sep 4 2008 Mikhail Fedotov <anyremote at mail.ru> - 5.2
- Added "Details" field to the main window.
  Added French translation.

* Tue Aug 19 2008 Mikhail Fedotov <anyremote at mail.ru> - 5.1
- Added Czech and Dutch translations.

* Mon Jul 21 2008 Mikhail Fedotov <anyremote at mail.ru> - 5.0
- Fixed to work properly under RHEL4. Internationalization support.
  Added Austrian, Brazilian Portuguese, German, Hungarian, Spanish, Italian, 
  Polish and Russian translation.

* Sun Jun 29 2008 Mikhail Fedotov <anyremote at mail.ru> - 4.0
- Small enhancements

* Sun May 25 2008 Mikhail Fedotov <anyremote at mail.ru> - 3.0
- Bugfixes and enhancements to better support anyremote-J2ME client v4.6 and
  anyremote2html v0.5.

* Sat Apr 19 2008 Mikhail Fedotov <anyremote at mail.ru> - 2.8
- Some small enhancements.

* Mon Mar 03 2008 Mikhail Fedotov <anyremote at mail.ru> - 2.7
- Some small enhancements. Corrected to work properly with anyRemote v4.4.

* Mon Feb 15 2008 Mikhail Fedotov <anyremote at mail.ru> - 2.6
- Motorola RIZR Z3 support enhanced

%files
%defattr(-,root,root,-)
%{_bindir}/%{name}
%{_datadir}/applications/ganyremote.desktop
%{_datadir}/pixmaps/ganyremote_flash.png 
%{_datadir}/pixmaps/ganyremote_off.png 
%{_datadir}/pixmaps/ganyremote_light.png  
%{_datadir}/pixmaps/ganyremote.png
%{_defaultdocdir}/%{name}
%{_datadir}/locale/bg/LC_MESSAGES/ganyremote.mo
%{_datadir}/locale/cs_CZ/LC_MESSAGES/ganyremote.mo
%{_datadir}/locale/de_AT/LC_MESSAGES/ganyremote.mo
%{_datadir}/locale/de_DE/LC_MESSAGES/ganyremote.mo
%{_datadir}/locale/es_ES/LC_MESSAGES/ganyremote.mo
%{_datadir}/locale/fr_FR/LC_MESSAGES/ganyremote.mo
%{_datadir}/locale/hu_HU/LC_MESSAGES/ganyremote.mo
%{_datadir}/locale/it_IT/LC_MESSAGES/ganyremote.mo
%{_datadir}/locale/nl_NL/LC_MESSAGES/ganyremote.mo
%{_datadir}/locale/pl_PL/LC_MESSAGES/ganyremote.mo
%{_datadir}/locale/pt_BR/LC_MESSAGES/ganyremote.mo
%{_datadir}/locale/ru_RU/LC_MESSAGES/ganyremote.mo

