/*******************************************
 *
 * $GAMGI/src/engine/gamgi_engine_filter.c
 *
 * Copyright (C) 2001, 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_math.h"
#include "gamgi_chem.h"

#include "gamgi_engine_list.h"
#include "gamgi_engine_unlink.h"
#include "gamgi_engine_remove.h"
#include "gamgi_math_measure.h"

gamgi_dlist *gamgi_engine_filter_bond_length (gamgi_dlist *start, 
double min, double max)
{
gamgi_atom *atom1, *atom2;
gamgi_bond* bond;
gamgi_dlist *dlist;
double length;

for (dlist = start; dlist != NULL; dlist = dlist->next)
  {
  bond = GAMGI_CAST_BOND dlist->data;
  atom1 = bond->atom1;
  atom2 = bond->atom2;
  gamgi_math_measure_length_2atom (atom1, atom2, &length);

  if (length < min || length > max)
    {
    if (dlist->before == NULL) start = dlist->next;
    gamgi_engine_dlist_remove_start (dlist);
    gamgi_engine_unlink_bond (bond);
    gamgi_engine_remove_bond (bond);
    }
  }

return start;
}

gamgi_dlist *gamgi_engine_filter_bond_element (gamgi_dlist *start, 
int z1, int z2)
{
gamgi_bond* bond;
gamgi_dlist *dlist;
int element1, element2;

for (dlist = start; dlist != NULL; dlist = dlist->next)
  {
  bond = GAMGI_CAST_BOND dlist->data;
  element1 = bond->atom1->element;
  element2 = bond->atom2->element;

  if ((z1 != element1 && z1 != element2) || (z2 != element1 && z2 != element2))
    {
    if (dlist->before == NULL) start = dlist->next;
    gamgi_engine_dlist_remove_start (dlist);
    gamgi_engine_unlink_bond (bond);
    gamgi_engine_remove_bond (bond);
    }
  }

return start;
}

gamgi_dlist *gamgi_engine_filter_atom_element (gamgi_dlist *start, 
int z1, int z2)
{
gamgi_atom *atom;
gamgi_dlist *dlist;
int element;

for (dlist = start; dlist != NULL; dlist = dlist->next)
  {
  atom = GAMGI_CAST_ATOM dlist->data;
  element = atom->element;

  if (element != z1 && element != z2)
    {
    if (dlist->before == NULL) start = dlist->next;
    gamgi_engine_dlist_remove_start (dlist);
    }
  }

return start;
}

gamgi_dlist *gamgi_engine_filter_atom_class (gamgi_dlist *start,
gamgi_enum class)
{
gamgi_object *object;
gamgi_dlist *dlist;

/***********************************************
 * unlist objects with specific parent classes *
 ***********************************************/

for (dlist = start; dlist != NULL; dlist = dlist->next)
  {
  object = GAMGI_CAST_OBJECT dlist->data;
  if (object->object->class == class)
    {
    if (dlist->before == NULL) start = dlist->next;
    gamgi_engine_dlist_remove_start (dlist);
    }
  }

return start;
}

gamgi_dlist *gamgi_engine_filter_atom_child (gamgi_dlist *start,
gamgi_object *parent)
{
gamgi_object *object;
gamgi_dlist *dlist;

/**************************************************
 * unlist objects without specific parent objects *
 **************************************************/

for (dlist = start; dlist != NULL; dlist = dlist->next)
  {
  object = GAMGI_CAST_OBJECT dlist->data;
  if (object->object != parent)
    {
    if (dlist->before == NULL) start = dlist->next;
    gamgi_engine_dlist_remove_start (dlist);
    }
  }

return start;
}

gamgi_dlist *gamgi_engine_filter_atom_identical (gamgi_dlist *start)
{
gamgi_atom *atom_i, *atom_j;
gamgi_dlist *dlist_i, *dlist_j;
double x, y, z;

for (dlist_i = start; dlist_i != NULL; dlist_i = dlist_i->next)
  {
  atom_i = GAMGI_CAST_ATOM dlist_i->data;

  dlist_j = dlist_i->next;
  while (dlist_j != NULL)
    {
    atom_j = GAMGI_CAST_ATOM dlist_j->data;
    x = atom_i->position[0] - atom_j->position[0];
    y = atom_i->position[1] - atom_j->position[1];
    z = atom_i->position[2] - atom_j->position[2];

    if (x * x + y * y + z * z < 
    GAMGI_MATH_TOLERANCE_STRUCTURE * GAMGI_MATH_TOLERANCE_STRUCTURE)
      dlist_j = gamgi_engine_dlist_remove_start (dlist_j);
    else dlist_j = dlist_j->next;
    }
  }

return start;
}

gamgi_dlist *gamgi_engine_filter_atom (gamgi_dlist *dlist,
gamgi_enum filter, gamgi_enum class, gamgi_object *parent)
{
if (filter == GAMGI_CHEM_FILTER_IDENTICAL)
  dlist = gamgi_engine_filter_atom_identical (dlist);

if (filter == GAMGI_CHEM_FILTER_CLASS)
  while (class > GAMGI_ENGINE_ATOM)
    dlist = gamgi_engine_filter_atom_class (dlist, class--);

if (filter == GAMGI_CHEM_FILTER_CHILD)
  dlist = gamgi_engine_filter_atom_child (dlist, parent);

return dlist;
}
