/************************************************
 *
 * $GAMGI/src/global/gamgi_global_remove.c
 *
 * Copyright (C) 2009 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"
#include "gamgi_global.h"

#include "gamgi_engine_list.h"
#include "gamgi_gtk_dialog.h"

void gamgi_global_selection_show (char *name)
{
gamgi_window *window;
GtkWidget *button;
GtkWidget *label;
GdkColor color;

gamgi_gtk_dialog_color (&color,
GAMGI_GTK_MOVE_R, GAMGI_GTK_MOVE_G, GAMGI_GTK_MOVE_B);

for (window = gamgi->window_start; window != NULL; window = window->next)
  {
  button = (GtkWidget *) g_object_get_data (G_OBJECT (window->window), name);
  label = gtk_bin_get_child (GTK_BIN (button));
  gamgi_gtk_dialog_color_fg (label, color);
  }
}

void gamgi_global_selection_hide (char *name)
{
gamgi_window *window;
GtkWidget *button;
GtkWidget *label;

for (window = gamgi->window_start; window != NULL; window = window->next)
  {
  button = (GtkWidget *) g_object_get_data (G_OBJECT (window->window), name);
  label = gtk_bin_get_child (GTK_BIN (button));
  gamgi_gtk_dialog_color_default (label, window);
  }
}

void gamgi_global_selection_link (gamgi_dlist *start)
{
gamgi_dlist *dlist;

for (dlist = start; dlist != NULL; dlist = dlist->next)
  (GAMGI_CAST_OBJECT dlist->data)->selection = dlist;
}

void gamgi_global_selection_unlink (gamgi_dlist *start)
{
gamgi_dlist *dlist;

for (dlist = start; dlist != NULL; dlist = dlist->next)
  (GAMGI_CAST_OBJECT dlist->data)->selection = NULL;
}

void gamgi_global_selection_remove (gamgi_dlist **start, char *label)
{
if (*start == NULL) return;

gamgi_global_selection_unlink (*start);
gamgi_engine_dlist_remove_all (*start);
gamgi_global_selection_hide (label);

*start = NULL;
}

void gamgi_global_selection_remove_all (void)
{
gamgi_global_selection_remove (&gamgi->texts, "button_text");
gamgi_global_selection_remove (&gamgi->orbitals, "button_orbital");
gamgi_global_selection_remove (&gamgi->bonds, "button_bond");
gamgi_global_selection_remove (&gamgi->atoms, "button_atom");
gamgi_global_selection_remove (&gamgi->directions, "button_direction");
gamgi_global_selection_remove (&gamgi->planes, "button_plane");
gamgi_global_selection_remove (&gamgi->groups, "button_group");
gamgi_global_selection_remove (&gamgi->molecules, "button_molecule");
gamgi_global_selection_remove (&gamgi->clusters, "button_cluster");
gamgi_global_selection_remove (&gamgi->cells, "button_cell");
gamgi_global_selection_remove (&gamgi->arrows, "button_arrow");
gamgi_global_selection_remove (&gamgi->shapes, "button_shape");
gamgi_global_selection_remove (&gamgi->graphs, "button_graph");
gamgi_global_selection_remove (&gamgi->assemblys, "button_assembly");
gamgi_global_selection_remove (&gamgi->lights, "button_light");
gamgi_global_selection_remove (&gamgi->layers, "button_layer");
gamgi_global_selection_remove (&gamgi->windows, "button_window");
}

void gamgi_global_selection_clean (gamgi_dlist **start,
gamgi_dlist *selection, char *label)
{
/*************************************************************
 * if the selection pointer is NULL for this object to be    *
 * removed soon, then the object is not in the selected list *
 *************************************************************/

if (selection != NULL)
  {
  /***************************************************************
   * When start is not NULL, we are removing an object: disable  *
   * immediately the list of selected objects of this class      *
   *                                                             *
   * When start is NULL we are removing a list of objects: set   *
   * selection->data to NULL, because recursive objects might be *
   * removed recursively and show up later in the selected list. *
   ***************************************************************/

  if (*start != NULL)
    gamgi_global_selection_remove (start, label);
  else
    selection->data = NULL;
  }
}
