/*************************************************
 *
 * $GAMGI/src/gtk/cell/gamgi_gtk_cell_align.c
 *
 * Copyright (C) 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"
#include "gamgi_math.h"
#include "gamgi_phys.h"
#include "gamgi_io.h"
#include "gamgi_global.h"

#include "gamgi_engine_create.h"
#include "gamgi_engine_start.h"
#include "gamgi_engine_remove.h"
#include "gamgi_engine_list.h"
#include "gamgi_engine_find.h"
#include "gamgi_gtk_dialog.h"
#include "gamgi_gtk_object.h"
#include "gamgi_gtk_cell_symmetry.h"
#include "gamgi_mesa_select.h"
#include "gamgi_math_vector.h"
#include "gamgi_math_matrix.h"
#include "gamgi_math_quaternion.h"
#include "gamgi_math_euler.h"
#include "gamgi_math_cell.h"
#include "gamgi_phys_cell.h"
#include "gamgi_phys_direction.h"
#include "gamgi_phys_plane.h"
#include "gamgi_io_token.h"

static struct {
double cell_xyz[3];
gamgi_enum cell_vectors;

gamgi_object *base;
double base_xyz[3];
gamgi_enum base_vectors; } translation;

static struct {
int cell_hkl[3];
int cell_uvw[3];
gamgi_enum cell_vectors;

gamgi_object *base;
int base_hkl[3];
int base_uvw[3];
gamgi_enum base_vectors;
gamgi_enum plane; } rotation;

static void static_translation_remove (gamgi_window *window)
{
GtkWidget *dialog = window->dialog0;
GtkWidget *button;

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_translation");
gtk_button_clicked (GTK_BUTTON (button));
}

static void static_translation_on (gamgi_window *window)
{
GtkWidget *dialog = window->dialog0;
GtkWidget *entry;
GtkWidget *label;
GtkWidget *button;
char token[GAMGI_ENGINE_TOKEN];

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_x");
gtk_widget_set_sensitive (entry, TRUE);
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_y");
gtk_widget_set_sensitive (entry, TRUE);
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_z");
gtk_widget_set_sensitive (entry, TRUE);

label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_x");
gtk_widget_set_sensitive (label, TRUE);
label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_y");
gtk_widget_set_sensitive (label, TRUE);
label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_z");
gtk_widget_set_sensitive (label, TRUE);

if (window->action == GAMGI_GTK_CELL_CREATE && translation.base != NULL)
  {
  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_x");
  sprintf (token, "%.*f", gamgi->gamgi->length, GAMGI_PHYS_CELL_X);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_y");
  sprintf (token, "%.*f", gamgi->gamgi->length, GAMGI_PHYS_CELL_Y);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_z");
  sprintf (token, "%.*f", gamgi->gamgi->length, GAMGI_PHYS_CELL_Z);
  gtk_entry_set_text (GTK_ENTRY (entry), token);
  }

if (window->action == GAMGI_GTK_CELL_MODIFY)
  {
  button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_translation_absolute");
  gtk_widget_set_sensitive (button, TRUE);
  button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_translation_relative");
  gtk_widget_set_sensitive (button, TRUE);
  }
}

static void static_translation_off (gamgi_window *window)
{
GtkWidget *dialog = window->dialog0;
GtkWidget *entry;
GtkWidget *label;
GtkWidget *button;

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_x");
gtk_entry_set_text (GTK_ENTRY (entry), "");
gtk_widget_set_sensitive (entry, FALSE);
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_y");
gtk_entry_set_text (GTK_ENTRY (entry), "");
gtk_widget_set_sensitive (entry, FALSE);
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_z");
gtk_entry_set_text (GTK_ENTRY (entry), "");
gtk_widget_set_sensitive (entry, FALSE);

label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_x");
gtk_widget_set_sensitive (label, FALSE);
label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_y");
gtk_widget_set_sensitive (label, FALSE);
label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_z");
gtk_widget_set_sensitive (label, FALSE);

if (window->action == GAMGI_GTK_CELL_MODIFY)
  {
  button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_translation_absolute");
  gtk_button_clicked (GTK_BUTTON (button));
  gtk_widget_set_sensitive (button, FALSE);
  button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_translation_relative");
  gtk_widget_set_sensitive (button, FALSE);
  }
}

static void static_translation_cancel (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;

static_translation_on (window);
static_translation_remove (window);

/************************************************************
 * disable translation alignment: translation.base is       *
 * used to decide whether to initialize or not the level 0  *
 * entries, so it must be done AFTER static_translation_on) *
 ************************************************************/

translation.base = NULL;
}

static void static_translation_delete (GtkWidget *widget, 
GdkEventButton *event, void *data)
{
static_translation_cancel (widget, data);
}

static void static_translation_layer (gamgi_window *window)
{
GtkWidget *dialog = window->dialog1;
GtkWidget *entry;
GtkWidget *option_menu;
GtkWidget *item;

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_cell");
gtk_entry_set_text (GTK_ENTRY (entry), "");
gtk_widget_set_sensitive (entry, FALSE);

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_base");
gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 0);

item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_base");
gtk_widget_set_sensitive (item, FALSE);
}

static void static_translation_cell (gamgi_window *window)
{
GtkWidget *dialog = window->dialog1;
GtkWidget *entry;
GtkWidget *item;

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_cell");
gtk_widget_set_sensitive (entry, TRUE);

item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_base");
gtk_widget_set_sensitive (item, TRUE);
}

static void static_translation_clicked (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog1;
GtkWidget *button;

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_cell");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button)) == TRUE)
  static_translation_cell (window);
else
  static_translation_layer (window);
}

static void static_translation_ok (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
gamgi_cell *cell;
GtkWidget *dialog = window->dialog1;
GtkWidget *entry;
GtkWidget *button;
GtkWidget *option_menu, *menu;
GtkWidget *item, *item_now;
const char *name;

/************************
 * get Reference object *
 ************************/

translation.base = GAMGI_CAST_OBJECT window->layer;
button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_cell");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button)) == TRUE)
  {
  cell = GAMGI_CAST_CELL gamgi_gtk_object_name_number (dialog,
  "entry_cell", GAMGI_ENGINE_CELL, window);
  if (cell == NULL)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Object", window);
    return;
    }

  translation.base = GAMGI_CAST_OBJECT cell;
  }

/************************
 * get Cell coordinates *
 ************************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_x");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_double_scan (name, &translation.cell_xyz[0], 
-DBL_MAX, DBL_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_y");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_double_scan (name, &translation.cell_xyz[1],
-DBL_MAX, DBL_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_z");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_double_scan (name, &translation.cell_xyz[2],
-DBL_MAX, DBL_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

/********************
 * get Cell vectors *
 ********************/

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_cell");
menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (option_menu));
item_now = gtk_menu_get_active (GTK_MENU (menu));

translation.cell_vectors = GAMGI_PHYS_CONVENTIONAL;
item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_cell");
if (item == item_now) translation.cell_vectors = GAMGI_PHYS_PRIMITIVE;

/*****************************
 * get Reference coordinates *
 *****************************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_x1");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_double_scan (name, &translation.base_xyz[0], 
-DBL_MAX, DBL_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_y1");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_double_scan (name, &translation.base_xyz[1],
-DBL_MAX, DBL_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_z1");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_double_scan (name, &translation.base_xyz[2],
-DBL_MAX, DBL_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

/*************************
 * get Reference vectors *
 *************************/

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_base");
menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (option_menu));
item_now = gtk_menu_get_active (GTK_MENU (menu));

translation.base_vectors = GAMGI_PHYS_CONVENTIONAL;
item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_base");
if (item == item_now) translation.base_vectors = GAMGI_PHYS_PRIMITIVE;

static_translation_off (window);
static_translation_remove (window);
}

static void static_translation_init (gamgi_window *window)
{
gamgi_cell *cell;
GtkWidget *dialog = window->dialog1;
GtkWidget *entry;
GtkWidget *button;
GtkWidget *option_menu;
char string[2 * GAMGI_ENGINE_TOKEN];

static_translation_layer (window);
if (translation.base == NULL) return;

/******************
 * show cell data *
 ******************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_x");
sprintf (string, "%.*f", gamgi->gamgi->length, translation.cell_xyz[0]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_y");
sprintf (string, "%.*f", gamgi->gamgi->length, translation.cell_xyz[1]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_z");
sprintf (string, "%.*f", gamgi->gamgi->length, translation.cell_xyz[2]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_base");
gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), translation.cell_vectors - 1);

/***********************
 * show reference data *
 ***********************/

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_cell");
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_cell");
if (translation.base->class == GAMGI_ENGINE_CELL)
  {
  gtk_button_clicked (GTK_BUTTON (button));
  cell = GAMGI_CAST_CELL translation.base;
  sprintf (string, "%s %d", cell->object.name, cell->object.number);
  gtk_entry_set_text (GTK_ENTRY (entry), string);
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_x1");
sprintf (string, "%.*f", gamgi->gamgi->length, translation.base_xyz[0]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_y1");
sprintf (string, "%.*f", gamgi->gamgi->length, translation.base_xyz[1]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_z1");
sprintf (string, "%.*f", gamgi->gamgi->length, translation.base_xyz[2]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_cell");
gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), translation.base_vectors - 1);
}

static void static_translation (gamgi_window *window)
{
GtkWidget *dialog;
GtkWidget *button;
GtkWidget *label;
GtkWidget *entry;
GtkWidget *table;
GtkWidget *vbox_dialog, *vbox_frame;
GtkWidget *hbox_center, *hbox_left;
GtkWidget *frame;
GtkWidget *option_menu;
GtkWidget *menu;
GtkWidget *item;

dialog = gamgi_gtk_dialog_task1_create ("Align Translation", window);
gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
g_signal_connect (GTK_OBJECT (dialog), "delete_event",
G_CALLBACK (static_translation_delete), window);

vbox_dialog = gtk_vbox_new (FALSE, 5);
gtk_container_add (GTK_CONTAINER (dialog), vbox_dialog);
gtk_widget_show (vbox_dialog);

/********
 * Cell *
 ********/

frame = gtk_frame_new (NULL);
gtk_box_pack_start (GTK_BOX (vbox_dialog), frame, TRUE, TRUE, 0);
gtk_frame_set_label (GTK_FRAME (frame), "Cell");
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_widget_show (frame);

vbox_frame = gtk_vbox_new (FALSE, 5);
gtk_container_add (GTK_CONTAINER (frame), vbox_frame);
gtk_container_set_border_width (GTK_CONTAINER (vbox_frame), 5);
gtk_widget_show (vbox_frame);

/********************
 * Cell coordinates *
 ********************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_frame), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

table = gtk_table_new (1, 7, FALSE);
gtk_box_pack_start (GTK_BOX (hbox_center), table, FALSE, FALSE, 0);
gtk_widget_show (table);

label = gtk_label_new ("Coordinates");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_x", entry);
gtk_widget_show (entry);

label = gtk_label_new ("x");
gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 3, 4, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_y", entry);
gtk_widget_show (entry);

label = gtk_label_new ("y");
gtk_table_attach (GTK_TABLE (table), label, 4, 5, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 5, 6, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_z", entry);
gtk_widget_show (entry);

label = gtk_label_new ("z");
gtk_table_attach (GTK_TABLE (table), label, 6, 7, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

/****************
 * Cell vectors *
 ****************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_frame), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

hbox_left = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (hbox_center), hbox_left, FALSE, FALSE, 0);
gtk_widget_show (hbox_left);

label = gtk_label_new ("Vectors");
gtk_box_pack_start (GTK_BOX (hbox_left), label, FALSE, FALSE, 0);
gtk_widget_show (label);

option_menu = gtk_option_menu_new ();
gtk_box_pack_start (GTK_BOX (hbox_left), option_menu, FALSE, FALSE, 0);
g_object_set_data (G_OBJECT (dialog), "menu_cell", option_menu);
menu = gtk_menu_new ();

item = gtk_radio_menu_item_new_with_label (NULL, "Conventional");
gtk_menu_append (GTK_MENU (menu), item);
gtk_widget_show (item);

item = gtk_radio_menu_item_new_with_label (
gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (item)), "Primitive");
gtk_menu_append (GTK_MENU (menu), item);
g_object_set_data (G_OBJECT (dialog), "item_cell", item);
gtk_widget_show (item);

gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
gtk_widget_show (option_menu);

/*************
 * Reference *
 *************/

frame = gtk_frame_new (NULL);
gtk_box_pack_start (GTK_BOX (vbox_dialog), frame, TRUE, TRUE, 0);
gtk_frame_set_label (GTK_FRAME (frame), "Reference");
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_widget_show (frame);

vbox_frame = gtk_vbox_new (FALSE, 5);
gtk_container_add (GTK_CONTAINER (frame), vbox_frame);
gtk_container_set_border_width (GTK_CONTAINER (vbox_frame), 5);
gtk_widget_show (vbox_frame);

/********************
 * Reference object *
 ********************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_frame), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

hbox_left = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (hbox_center), hbox_left, FALSE, FALSE, 0);
gtk_widget_show (hbox_left);

button = gtk_radio_button_new_with_label (NULL, "Layer");
gtk_box_pack_start (GTK_BOX (hbox_left), button, FALSE, FALSE, 0);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (static_translation_clicked), window);
gtk_widget_show (button);

button = gtk_radio_button_new_with_label (
gtk_radio_button_get_group (GTK_RADIO_BUTTON (button)), "Cell");
gtk_box_pack_start (GTK_BOX (hbox_left), button, FALSE, FALSE, 0);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (static_translation_clicked), window);
g_object_set_data (G_OBJECT (dialog), "button_cell", button);
gtk_widget_show (button);

entry = gtk_entry_new ();
gtk_box_pack_start (GTK_BOX (hbox_left), entry, FALSE, FALSE, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
g_object_set_data (G_OBJECT (dialog), "entry_cell", entry);
gtk_widget_show (entry);

/*************************
 * Reference coordinates *
 *************************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_frame), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

table = gtk_table_new (1, 7, FALSE);
gtk_box_pack_start (GTK_BOX (hbox_center), table, FALSE, FALSE, 0);
gtk_widget_show (table);

label = gtk_label_new ("Coordinates");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_x1", entry);
gtk_widget_show (entry);

label = gtk_label_new ("x");
gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 3, 4, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_y1", entry);
gtk_widget_show (entry);

label = gtk_label_new ("y");
gtk_table_attach (GTK_TABLE (table), label, 4, 5, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 5, 6, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_z1", entry);
gtk_widget_show (entry);

label = gtk_label_new ("z");
gtk_table_attach (GTK_TABLE (table), label, 6, 7, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

/*********************
 * Reference vectors *
 *********************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_frame), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

hbox_left = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (hbox_center), hbox_left, FALSE, FALSE, 0);
gtk_widget_show (hbox_left);

label = gtk_label_new ("Vectors");
gtk_box_pack_start (GTK_BOX (hbox_left), label, FALSE, FALSE, 0);
gtk_widget_show (label);

option_menu = gtk_option_menu_new ();
gtk_box_pack_start (GTK_BOX (hbox_left), option_menu, FALSE, FALSE, 0);
g_object_set_data (G_OBJECT (dialog), "menu_base", option_menu);
menu = gtk_menu_new ();

item = gtk_radio_menu_item_new_with_label (NULL, "Conventional");
gtk_menu_append (GTK_MENU (menu), item);
gtk_widget_show (item);

item = gtk_radio_menu_item_new_with_label (
gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (item)), "Primitive");
gtk_menu_append (GTK_MENU (menu), item);
g_object_set_data (G_OBJECT (dialog), "item_base", item);
gtk_widget_show (item);

gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
gtk_widget_show (option_menu);

/*********************
 * Ok/Cancel buttons *
 *********************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_dialog), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

button = gamgi_gtk_dialog_button_create ("Ok", NULL);
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (static_translation_ok), window);
gtk_box_pack_start (GTK_BOX (hbox_center), button, FALSE, FALSE, 0);
gtk_widget_show (button);

button = gamgi_gtk_dialog_button_create ("Cancel", "red");
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
gtk_box_pack_start (GTK_BOX (hbox_center), button, FALSE, FALSE, 0);
gtk_widget_grab_focus (button);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (static_translation_cancel), window);
gtk_widget_show (button);

gtk_widget_show (dialog);
static_translation_init (window);
}

static void static_rotation_remove (gamgi_window *window)
{
GtkWidget *dialog = window->dialog0;
GtkWidget *button;

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_rotation");
gtk_button_clicked (GTK_BUTTON (button));
}

static void static_rotation_on (gamgi_window *window)
{
GtkWidget *dialog = window->dialog0;
GtkWidget *entry;
GtkWidget *label;
GtkWidget *button;
char token[GAMGI_ENGINE_TOKEN];

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_e1");
gtk_widget_set_sensitive (entry, TRUE);
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_e2");
gtk_widget_set_sensitive (entry, TRUE);
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_e3");
gtk_widget_set_sensitive (entry, TRUE);

label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_e1");
gtk_widget_set_sensitive (label, TRUE);
label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_e2");
gtk_widget_set_sensitive (label, TRUE);
label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_e3");
gtk_widget_set_sensitive (label, TRUE);

if (window->action == GAMGI_GTK_CELL_CREATE && rotation.base != NULL)
  {
  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_e1");
  sprintf (token, "%.*f", gamgi->gamgi->angle, GAMGI_PHYS_CELL_E1);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_e2");
  sprintf (token, "%.*f", gamgi->gamgi->angle, GAMGI_PHYS_CELL_E2);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_e3");
  sprintf (token, "%.*f", gamgi->gamgi->angle, GAMGI_PHYS_CELL_E3);
  gtk_entry_set_text (GTK_ENTRY (entry), token);
  }

if (window->action == GAMGI_GTK_CELL_MODIFY)
  {
  button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_rotation_absolute");
  gtk_widget_set_sensitive (button, TRUE);
  button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_rotation_relative");
  gtk_widget_set_sensitive (button, TRUE);
  }
}

static void static_rotation_off (gamgi_window *window)
{
GtkWidget *dialog = window->dialog0;
GtkWidget *entry;
GtkWidget *label;
GtkWidget *button;

dialog = window->dialog0;
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_e1");
gtk_entry_set_text (GTK_ENTRY (entry), "");
gtk_widget_set_sensitive (entry, FALSE);
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_e2");
gtk_entry_set_text (GTK_ENTRY (entry), "");
gtk_widget_set_sensitive (entry, FALSE);
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_e3");
gtk_entry_set_text (GTK_ENTRY (entry), "");
gtk_widget_set_sensitive (entry, FALSE);

label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_e1");
gtk_widget_set_sensitive (label, FALSE);
label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_e2");
gtk_widget_set_sensitive (label, FALSE);
label = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_e3");
gtk_widget_set_sensitive (label, FALSE);

if (window->action == GAMGI_GTK_CELL_MODIFY)
  {
  button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_rotation_absolute");
  gtk_button_clicked (GTK_BUTTON (button));
  gtk_widget_set_sensitive (button, FALSE);
  button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_rotation_relative");
  gtk_widget_set_sensitive (button, FALSE);
  }
}

static void static_rotation_cancel (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;

static_rotation_on (window);
static_rotation_remove (window);

/*********************************************************
 * disable rotation alignment: rotation.base is used     *
 * to decide whether to initialize or not the level 0    *
 * entries, so it must be done AFTER static_rotation_on) *
 *********************************************************/

rotation.base = NULL;
}

static void static_rotation_delete (GtkWidget *widget, 
GdkEventButton *event, void *data)
{
static_rotation_cancel (widget, data);
}

static void static_rotation_label (gamgi_window *window)
{
GtkWidget *dialog = window->dialog1;
GtkWidget *option_menu, *menu;
GtkWidget *item, *item_now;
GtkWidget *label1, *label2, *label3;

/*******************
 * Option Menu hkl *
 *******************/

label1 = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_h1");
label2 = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_k1");
label3 = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_l1");

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_hkl");
menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (option_menu));
item_now = gtk_menu_get_active (GTK_MENU (menu));

item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_hkl");
if (item == item_now)
  {
  gtk_label_set_text (GTK_LABEL (label1), "h");
  gtk_label_set_text (GTK_LABEL (label2), "k");
  gtk_label_set_text (GTK_LABEL (label3), "l");
  }
else
  {
  gtk_label_set_text (GTK_LABEL (label1), "u");
  gtk_label_set_text (GTK_LABEL (label2), "v");
  gtk_label_set_text (GTK_LABEL (label3), "w");
  }

/*******************
 * Option Menu uvw *
 *******************/
 
label1 = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_u1");
label2 = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_v1");
label3 = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_w1");

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_uvw");
menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (option_menu));
item_now = gtk_menu_get_active (GTK_MENU (menu));

item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_uvw");
if (item == item_now)
  {
  gtk_label_set_text (GTK_LABEL (label1), "h");
  gtk_label_set_text (GTK_LABEL (label2), "k");
  gtk_label_set_text (GTK_LABEL (label3), "l");
  }
else
  {
  gtk_label_set_text (GTK_LABEL (label1), "u");
  gtk_label_set_text (GTK_LABEL (label2), "v");
  gtk_label_set_text (GTK_LABEL (label3), "w");
  }

}

static void static_rotation_hkl (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog1;
GtkWidget *option_menu, *menu;
GtkWidget *item, *item_now;
GtkWidget *button;

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_cell");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button)) == FALSE) return;

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_hkl");
menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (option_menu));
item_now = gtk_menu_get_active (GTK_MENU (menu));

item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_hkl");

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_uvw");

if (item == item_now)
  gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 1);
else
  gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 0);

static_rotation_label (window);
}

static void static_rotation_uvw (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog1;
GtkWidget *option_menu, *menu;
GtkWidget *item, *item_now;
GtkWidget *button;

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_cell");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button)) == FALSE) return;

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_uvw");
menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (option_menu));
item_now = gtk_menu_get_active (GTK_MENU (menu));

item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_uvw");

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_hkl");

if (item == item_now)
  gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 1);
else
  gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 0);

static_rotation_label (window);
}

static void static_rotation_layer (gamgi_window *window)
{
GtkWidget *dialog = window->dialog1;
GtkWidget *entry;
char token[GAMGI_ENGINE_TOKEN];
GtkWidget *option_menu;
GtkWidget *item;

/******************
 * handle entries *
 ******************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_cell");
gtk_entry_set_text (GTK_ENTRY (entry), "");
gtk_widget_set_sensitive (entry, FALSE);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_h1");
sprintf (token, "%d", GAMGI_PHYS_ALIGN_H);
gtk_entry_set_text (GTK_ENTRY (entry), token);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_k1");
sprintf (token, "%d", GAMGI_PHYS_ALIGN_K);
gtk_entry_set_text (GTK_ENTRY (entry), token);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_l1");
sprintf (token, "%d", GAMGI_PHYS_ALIGN_L);
gtk_entry_set_text (GTK_ENTRY (entry), token);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_u1");
sprintf (token, "%d", GAMGI_PHYS_ALIGN_U);
gtk_entry_set_text (GTK_ENTRY (entry), token);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_v1");
sprintf (token, "%d", GAMGI_PHYS_ALIGN_V);
gtk_entry_set_text (GTK_ENTRY (entry), token);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_w1");
sprintf (token, "%d", GAMGI_PHYS_ALIGN_W);
gtk_entry_set_text (GTK_ENTRY (entry), token);

/****************
 * handle menus *
 ****************/

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_hkl");
gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 1);
option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_uvw");
gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 1);

item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_hkl");
gtk_widget_set_sensitive (item, FALSE);
item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_uvw");
gtk_widget_set_sensitive (item, FALSE);

static_rotation_label (window);

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_base");
gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 0);

item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_base");
gtk_widget_set_sensitive (item, FALSE);
}

static void static_rotation_cell (gamgi_window *window)
{
GtkWidget *dialog = window->dialog1;
GtkWidget *entry;
GtkWidget *option_menu;
GtkWidget *item;

/******************
 * handle entries *
 ******************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_cell");
gtk_widget_set_sensitive (entry, TRUE);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_h1");
gtk_entry_set_text (GTK_ENTRY (entry), "");

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_k1");
gtk_entry_set_text (GTK_ENTRY (entry), "");

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_l1");
gtk_entry_set_text (GTK_ENTRY (entry), "");

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_u1");
gtk_entry_set_text (GTK_ENTRY (entry), "");

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_v1");
gtk_entry_set_text (GTK_ENTRY (entry), "");

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_w1");
gtk_entry_set_text (GTK_ENTRY (entry), "");

/****************
 * handle menus *
 ****************/

item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_hkl");
gtk_widget_set_sensitive (item, TRUE);
item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_uvw");
gtk_widget_set_sensitive (item, TRUE);

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_hkl");
gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 0);
option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_uvw");
gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 1);

static_rotation_label (window);

item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_base");
gtk_widget_set_sensitive (item, TRUE);
}

static void static_rotation_clicked (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog1;
GtkWidget *button;

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_cell");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button)) == TRUE)
  static_rotation_cell (window);
else
  static_rotation_layer (window);
}

static void static_rotation_ok (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
gamgi_cell *cell;
GtkWidget *dialog = window->dialog1;
GtkWidget *entry;
GtkWidget *button;
GtkWidget *option_menu, *menu;
GtkWidget *item, *item_now;
const char *name;

/************************
 * get Reference object *
 ************************/
 
rotation.base = GAMGI_CAST_OBJECT window->layer;
button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_cell");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button)) == TRUE)
  {
  cell = GAMGI_CAST_CELL gamgi_gtk_object_name_number (dialog,
  "entry_cell", GAMGI_ENGINE_CELL, window);
  if (cell == NULL)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Object", window);
    return;
    }

  rotation.base = GAMGI_CAST_OBJECT cell;
  }

/**************************
 * get Cell plane indices *
 **************************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_h");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.cell_hkl[0], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_k");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.cell_hkl[1], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_l");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.cell_hkl[2], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

if (gamgi_phys_direction_zero (rotation.cell_hkl) == TRUE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

/******************************
 * get Cell direction indices *
 ******************************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_u");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.cell_uvw[0], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_v");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.cell_uvw[1], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_w");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.cell_uvw[2], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

if (gamgi_phys_direction_zero (rotation.cell_uvw) == TRUE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

/********************
 * get Cell vectors *
 ********************/

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_cell");
menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (option_menu));
item_now = gtk_menu_get_active (GTK_MENU (menu));

rotation.cell_vectors = GAMGI_PHYS_CONVENTIONAL;
item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_cell");
if (item == item_now) rotation.cell_vectors = GAMGI_PHYS_PRIMITIVE;

/************************************
 * get Reference vector (given by   *
 * Plane or Direction) aligned with *
 * Cell vector (given by Plane)     *
 ************************************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_h1");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.base_hkl[0], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_k1");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.base_hkl[1], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_l1");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.base_hkl[2], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

if (gamgi_phys_direction_zero (rotation.base_hkl) == TRUE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

/************************************
 * get Reference vector (given by   *
 * Plane or Direction) aligned with *
 * Cell vector (given by Direction) *
 ************************************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_u1");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.base_uvw[0], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_v1");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.base_uvw[1], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_w1");
name = gtk_entry_get_text (GTK_ENTRY (entry));
if (gamgi_io_token_int_scan (name, &rotation.base_uvw[2], -INT_MAX, INT_MAX) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

if (gamgi_phys_direction_zero (rotation.base_uvw) == TRUE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

/************************************************
 * Cell direction must belong to Cell plane     *
 * and Reference direction must belong to       *
 * Reference plane, so the two Cell vectors     *
 * and the two Reference vectors must be normal *
 *                                              *
 * Wen the Reference is Layer, two Directions   *
 * are used instead, one describing a virtual   *
 * Plane, as there are no Planes in Layers      *
 ************************************************/

if (gamgi_phys_direction_weiss (rotation.cell_hkl, rotation.cell_uvw) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Cell Data", window);
  return;
  }

if (gamgi_phys_direction_weiss (rotation.base_hkl, rotation.base_uvw) == FALSE)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Reference Data", window);
  return;
  }

/*************************
 * get reference vectors *
 *************************/

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_base");
menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (option_menu));
item_now = gtk_menu_get_active (GTK_MENU (menu));

rotation.base_vectors = GAMGI_PHYS_CONVENTIONAL;
item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_base");
if (item == item_now) rotation.base_vectors = GAMGI_PHYS_PRIMITIVE;

/**********************************************
 * get information on which indices represent *
 * a plane, and which represent a direction   *
 **********************************************/

rotation.plane = -1;
if (rotation.base->class == GAMGI_ENGINE_CELL)
  {
  option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_hkl");
  menu = gtk_option_menu_get_menu (GTK_OPTION_MENU (option_menu));
  item_now = gtk_menu_get_active (GTK_MENU (menu));

  item = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "item_hkl");
  if (item == item_now) rotation.plane = 0;
  else rotation.plane = 1;
  }

static_rotation_off (window);
static_rotation_remove (window);
}

static void static_rotation_init (gamgi_window *window)
{
gamgi_cell *cell;
GtkWidget *dialog = window->dialog1;
GtkWidget *entry;
GtkWidget *button;
GtkWidget *option_menu;
char string[2 * GAMGI_ENGINE_TOKEN];

static_rotation_layer (window);
if (rotation.base == NULL) return;

/******************
 * show cell data *
 ******************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_h");
sprintf (string, "%d", rotation.cell_hkl[0]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_k");
sprintf (string, "%d", rotation.cell_hkl[1]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_l");
sprintf (string, "%d", rotation.cell_hkl[2]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_u");
sprintf (string, "%d", rotation.cell_uvw[0]);
gtk_entry_set_text (GTK_ENTRY (entry), string);
 
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_v");
sprintf (string, "%d", rotation.cell_uvw[1]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_w");
sprintf (string, "%d", rotation.cell_uvw[2]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_cell");
gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), rotation.cell_vectors - 1);

/***********************
 * show reference data *
 ***********************/

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_cell");
entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_cell");
if (rotation.base->class == GAMGI_ENGINE_CELL)
  {
  gtk_button_clicked (GTK_BUTTON (button));
  cell = GAMGI_CAST_CELL rotation.base;
  sprintf (string, "%s %d", cell->object.name, cell->object.number);
  gtk_entry_set_text (GTK_ENTRY (entry), string);
  }

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_h1");
sprintf (string, "%d", rotation.base_hkl[0]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_k1");
sprintf (string, "%d", rotation.base_hkl[1]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_l1");
sprintf (string, "%d", rotation.base_hkl[2]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_u1");
sprintf (string, "%d", rotation.base_uvw[0]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_v1");
sprintf (string, "%d", rotation.base_uvw[1]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_w1");
sprintf (string, "%d", rotation.base_uvw[2]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_hkl");
if (rotation.plane != 0)
  gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 1);
else
  gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 0);

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_uvw");
if (rotation.plane != 1)
  gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 1);
else
  gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 0);

option_menu = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "menu_base");
gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), rotation.base_vectors - 1);
}

static void static_rotation (gamgi_window *window)
{
GtkWidget *dialog;
GtkWidget *button;
GtkWidget *label;
GtkWidget *entry;
GtkWidget *table;
GtkWidget *vbox_dialog, *vbox_frame;
GtkWidget *hbox_center, *hbox_left;
GtkWidget *frame;
GtkWidget *option_menu;
GtkWidget *menu;
GtkWidget *item;

dialog = gamgi_gtk_dialog_task1_create ("Align Rotation", window);
gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
g_signal_connect (GTK_OBJECT (dialog), "delete_event",
G_CALLBACK (static_rotation_delete), window);

vbox_dialog = gtk_vbox_new (FALSE, 5);
gtk_container_add (GTK_CONTAINER (dialog), vbox_dialog);
gtk_widget_show (vbox_dialog);

/********
 * Cell *
 ********/

frame = gtk_frame_new (NULL);
gtk_box_pack_start (GTK_BOX (vbox_dialog), frame, TRUE, TRUE, 0);
gtk_frame_set_label (GTK_FRAME (frame), "Cell");
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_widget_show (frame);

vbox_frame = gtk_vbox_new (FALSE, 5);
gtk_container_add (GTK_CONTAINER (frame), vbox_frame);
gtk_container_set_border_width (GTK_CONTAINER (vbox_frame), 5);
gtk_widget_show (vbox_frame);

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_frame), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

table = gtk_table_new (2, 7, FALSE);
gtk_box_pack_start (GTK_BOX (hbox_center), table, FALSE, FALSE, 0);
gtk_widget_show (table);

/**************
 * Cell Plane *
 **************/

label = gtk_label_new ("Plane");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_h", entry);
gtk_widget_show (entry);

label = gtk_label_new ("h");
gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 3, 4, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_k", entry);
gtk_widget_show (entry);

label = gtk_label_new ("k");
gtk_table_attach (GTK_TABLE (table), label, 4, 5, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 5, 6, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_l", entry);
gtk_widget_show (entry);

label = gtk_label_new ("l");
gtk_table_attach (GTK_TABLE (table), label, 6, 7, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

/******************
 * Cell Direction *
 ******************/

label = gtk_label_new ("Direction");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_u", entry);
gtk_widget_show (entry);

label = gtk_label_new ("u");
gtk_table_attach (GTK_TABLE (table), label, 2, 3, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 3, 4, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_v", entry);
gtk_widget_show (entry);

label = gtk_label_new ("v");
gtk_table_attach (GTK_TABLE (table), label, 4, 5, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 5, 6, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_w", entry);
gtk_widget_show (entry);

label = gtk_label_new ("w");
gtk_table_attach (GTK_TABLE (table), label, 6, 7, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

/****************
 * Cell vectors *
 ****************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_frame), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

hbox_left = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (hbox_center), hbox_left, FALSE, FALSE, 0);
gtk_widget_show (hbox_left);

label = gtk_label_new ("Vectors");
gtk_box_pack_start (GTK_BOX (hbox_left), label, FALSE, FALSE, 0);
gtk_widget_show (label);

option_menu = gtk_option_menu_new ();
gtk_box_pack_start (GTK_BOX (hbox_left), option_menu, FALSE, FALSE, 0);
g_object_set_data (G_OBJECT (dialog), "menu_cell", option_menu);
menu = gtk_menu_new ();

item = gtk_radio_menu_item_new_with_label (NULL, "Conventional");
gtk_menu_append (GTK_MENU (menu), item);
gtk_widget_show (item);

item = gtk_radio_menu_item_new_with_label (
gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (item)), "Primitive");
gtk_menu_append (GTK_MENU (menu), item);
g_object_set_data (G_OBJECT (dialog), "item_cell", item);
gtk_widget_show (item);

gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
gtk_widget_show (option_menu);

/*************
 * Reference *
 *************/

frame = gtk_frame_new (NULL);
gtk_box_pack_start (GTK_BOX (vbox_dialog), frame, TRUE, TRUE, 0);
gtk_frame_set_label (GTK_FRAME (frame), "Reference");
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_widget_show (frame);

vbox_frame = gtk_vbox_new (FALSE, 5);
gtk_container_add (GTK_CONTAINER (frame), vbox_frame);
gtk_container_set_border_width (GTK_CONTAINER (vbox_frame), 5);
gtk_widget_show (vbox_frame);

/********************
 * Reference Object *
 ********************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_frame), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

hbox_left = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (hbox_center), hbox_left, FALSE, FALSE, 0);
gtk_widget_show (hbox_left);

button = gtk_radio_button_new_with_label (NULL, "Layer");
gtk_box_pack_start (GTK_BOX (hbox_left), button, FALSE, FALSE, 0);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (static_rotation_clicked), window);
gtk_widget_show (button);

button = gtk_radio_button_new_with_label (
gtk_radio_button_get_group (GTK_RADIO_BUTTON (button)), "Cell");
gtk_box_pack_start (GTK_BOX (hbox_left), button, FALSE, FALSE, 0);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (static_rotation_clicked), window);
g_object_set_data (G_OBJECT (dialog), "button_cell", button);
gtk_widget_show (button);

entry = gtk_entry_new ();
gtk_box_pack_start (GTK_BOX (hbox_left), entry, FALSE, FALSE, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
g_object_set_data (G_OBJECT (dialog), "entry_cell", entry);
gtk_widget_show (entry);

/*********************************************
 * Reference hkl vector (Plane or Direction) *
 *********************************************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_frame), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

table = gtk_table_new (2, 7, FALSE);
gtk_box_pack_start (GTK_BOX (hbox_center), table, FALSE, FALSE, 0);
gtk_widget_show (table);

option_menu = gtk_option_menu_new ();
gtk_table_attach (GTK_TABLE (table), option_menu, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
g_object_set_data (G_OBJECT (dialog), "menu_hkl", option_menu);
menu = gtk_menu_new ();

item = gtk_radio_menu_item_new_with_label (NULL, "Plane");
gtk_menu_append (GTK_MENU (menu), item);
g_signal_connect (GTK_OBJECT (item), "activate",
G_CALLBACK (static_rotation_hkl), window);
g_object_set_data (G_OBJECT (dialog), "item_hkl", item);
gtk_widget_show (item);

item = gtk_radio_menu_item_new_with_label (
gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (item)), "Direction");
gtk_menu_append (GTK_MENU (menu), item);
g_signal_connect (GTK_OBJECT (item), "activate",
G_CALLBACK (static_rotation_hkl), window);
gtk_widget_show (item);

gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
gtk_widget_show (option_menu);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_h1", entry);
gtk_widget_show (entry);

label = gtk_label_new ("h");
gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_h1", label);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 3, 4, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_k1", entry);
gtk_widget_show (entry);

label = gtk_label_new ("k");
gtk_table_attach (GTK_TABLE (table), label, 4, 5, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_k1", label);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 5, 6, 0, 1, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_l1", entry);
gtk_widget_show (entry);

label = gtk_label_new ("l");
gtk_table_attach (GTK_TABLE (table), label, 6, 7, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_l1", label);
gtk_widget_show (label);

/*********************************************
 * Reference uvw vector (Plane or Direction) *
 *********************************************/

option_menu = gtk_option_menu_new ();
gtk_table_attach (GTK_TABLE (table), option_menu, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
g_object_set_data (G_OBJECT (dialog), "menu_uvw", option_menu);
menu = gtk_menu_new ();

item = gtk_radio_menu_item_new_with_label (NULL, "Plane");
gtk_menu_append (GTK_MENU (menu), item);
g_signal_connect (GTK_OBJECT (item), "activate",
G_CALLBACK (static_rotation_uvw), window);
g_object_set_data (G_OBJECT (dialog), "item_uvw", item);
gtk_widget_show (item);

item = gtk_radio_menu_item_new_with_label (
gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (item)), "Direction");
gtk_menu_append (GTK_MENU (menu), item);
g_signal_connect (GTK_OBJECT (item), "activate",
G_CALLBACK (static_rotation_uvw), window);
gtk_widget_show (item);

gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
gtk_widget_show (option_menu);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_u1", entry);
gtk_widget_show (entry);

label = gtk_label_new ("u");
gtk_table_attach (GTK_TABLE (table), label, 2, 3, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_u1", label);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 3, 4, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_v1", entry);
gtk_widget_show (entry);

label = gtk_label_new ("v");
gtk_table_attach (GTK_TABLE (table), label, 4, 5, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_v1", label);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 5, 6, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_w1", entry);
gtk_widget_show (entry);

label = gtk_label_new ("w");
gtk_table_attach (GTK_TABLE (table), label, 6, 7, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_w1", label);
gtk_widget_show (label);

/*********************
 * Reference vectors *
 *********************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_frame), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

hbox_left = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (hbox_center), hbox_left, FALSE, FALSE, 0);
gtk_widget_show (hbox_left);

label = gtk_label_new ("Vectors");
gtk_box_pack_start (GTK_BOX (hbox_left), label, FALSE, FALSE, 0);
gtk_widget_show (label);

option_menu = gtk_option_menu_new ();
gtk_box_pack_start (GTK_BOX (hbox_left), option_menu, FALSE, FALSE, 0);
g_object_set_data (G_OBJECT (dialog), "menu_base", option_menu);
menu = gtk_menu_new ();

item = gtk_radio_menu_item_new_with_label (NULL, "Conventional");
gtk_menu_append (GTK_MENU (menu), item);
gtk_widget_show (item);

item = gtk_radio_menu_item_new_with_label (
gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (item)), "Primitive");
gtk_menu_append (GTK_MENU (menu), item);
g_object_set_data (G_OBJECT (dialog), "item_base", item);
gtk_widget_show (item);

gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
gtk_widget_show (option_menu);

/*********************
 * Ok/Cancel buttons *
 *********************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_dialog), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

button = gamgi_gtk_dialog_button_create ("Ok", NULL);
gtk_box_pack_start (GTK_BOX (hbox_center), button, FALSE, FALSE, 0);
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (static_rotation_ok), window);
gtk_widget_show (button);

button = gamgi_gtk_dialog_button_create ("Cancel", "red");
gtk_box_pack_start (GTK_BOX (hbox_center), button, FALSE, FALSE, 0);
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
gtk_widget_grab_focus (button);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (static_rotation_cancel), window);
gtk_widget_show (button);

gtk_widget_show (dialog);
static_rotation_init (window);
}

static void static_press (gamgi_object *object, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
gamgi_cell *cell;
GtkWidget *dialog = window->dialog1;
GtkWidget *entry;
char string[2 * GAMGI_ENGINE_TOKEN];

cell = GAMGI_CAST_CELL object;

/***************************
 * set Cell identification *
 ***************************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_cell");
sprintf (string, "%s %d", cell->object.name, cell->object.number);
gtk_entry_set_text (GTK_ENTRY (entry), string);
}

void gamgi_gtk_cell_align_press (gamgi_window *window, int x, int y)
{
GtkWidget *dialog = window->dialog1;
GtkWidget *button;

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_cell");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button)) == FALSE) return;

gamgi_mesa_select_object (window, x, y, GAMGI_ENGINE_CELL, FALSE, static_press);
}

void gamgi_gtk_cell_align_start (void)
{
/******************************************
 * disable translation,rotation alignment *
 ******************************************/

translation.base = NULL;
rotation.base = NULL;
}

void gamgi_gtk_cell_align_origin (gamgi_cell *cell, 
double *origin, gamgi_window *window)
{
gamgi_cell *base;
double rotate[9];
double x, y, z;
double offset[3], position[3];
double b[3], c[3];

/************************************************
 * check if align information has been provided *
 ************************************************/

if (translation.base == NULL) return;

/************************
 * get cell position: c *
 ************************/

x = translation.cell_xyz[0];
y = translation.cell_xyz[1];
z = translation.cell_xyz[2];

gamgi_math_quaternion_to_matrix (cell->quaternion, rotate);
gamgi_math_cell_offset (cell, offset);

if (translation.cell_vectors == GAMGI_PHYS_CONVENTIONAL)
  gamgi_math_vector_translation (x, y, z, cell->a1, cell->a2, cell->a3, position);
if (translation.cell_vectors == GAMGI_PHYS_PRIMITIVE)
  gamgi_math_vector_translation (x, y, z, cell->p1, cell->p2, cell->p3, position);

gamgi_math_vector_add (offset, position, position);
gamgi_math_matrix_vector (rotate, position, c);

/************************
 * get base position: b *
 ************************/

x = translation.base_xyz[0];
y = translation.base_xyz[1];
z = translation.base_xyz[2];

if (translation.base->class == GAMGI_ENGINE_CELL)
  {
  base = GAMGI_CAST_CELL translation.base;
  gamgi_math_quaternion_to_matrix (base->quaternion, rotate);
  gamgi_math_vector_copy (base->origin, origin);
  gamgi_math_cell_offset (base, offset);

  if (translation.base_vectors == GAMGI_PHYS_CONVENTIONAL)
    gamgi_math_vector_translation (x, y, z, base->a1, base->a2, base->a3, position);
  if (translation.base_vectors == GAMGI_PHYS_PRIMITIVE)
    gamgi_math_vector_translation (x, y, z, base->p1, base->p2, base->p3, position);
  }
else
  {
  gamgi_math_matrix_unit (rotate);
  gamgi_math_vector_zero (origin);
  gamgi_math_vector_zero (offset);
  gamgi_math_vector_absolute (position, x, y, z);
  }

gamgi_math_vector_add (offset, position, position);
gamgi_math_matrix_vector (rotate, position, b);

/*******************************
 * get cell origin such that   *
 * points b and c are the same *
 *******************************/

gamgi_math_vector_add (origin, b, b);
gamgi_math_vector_sub (b, c, origin);
}

void gamgi_gtk_cell_align_angle (gamgi_cell *cell, 
double *angle, gamgi_window *window)
{
gamgi_cell *base;
double matrix[9], rotate[9], inverse[9];
double a[3], b[3], c[3];
double pole[3];

/************************************************
 * check if align information has been provided *
 ************************************************/

if (rotation.base == NULL) return;

/*****************
 * get cell axes *
 *****************/

gamgi_phys_plane_vector (cell, rotation.cell_hkl, rotation.cell_vectors, a);
gamgi_phys_direction_vector (cell, rotation.cell_uvw, rotation.cell_vectors, b);

gamgi_math_vector_normal (a);
gamgi_math_vector_normal (b);
gamgi_math_vector_cross (a, b, c);

gamgi_math_matrix_absolute (matrix, 
a[0], b[0], c[0], a[1], b[1], c[1], a[2], b[2], c[2]);
gamgi_math_matrix_inverse (matrix, inverse);

/**********************
 * get reference axes *
 **********************/

/*********************************************
 * -1: (no plane) Layer, direction direction *
 *  0: (plane first) Cell, plane direction   *
 * -1: (plane last) Cell, direction plane    *
 *********************************************/

if (rotation.plane == -1)
  {
  gamgi_math_vector_absolute (a, 
  rotation.base_hkl[0], rotation.base_hkl[1], rotation.base_hkl[2]);
  gamgi_math_vector_absolute (b, 
  rotation.base_uvw[0], rotation.base_uvw[1], rotation.base_uvw[2]);
  }

if (rotation.plane == 0)
  {
  base = GAMGI_CAST_CELL rotation.base;
  gamgi_math_quaternion_to_matrix (base->quaternion, rotate);

  gamgi_phys_plane_vector (base, rotation.base_hkl, rotation.base_vectors, pole);
  gamgi_math_matrix_vector (rotate, pole, a);
  gamgi_phys_direction_vector (base, rotation.base_uvw, rotation.base_vectors, pole);
  gamgi_math_matrix_vector (rotate, pole, b);
  }
if (rotation.plane == 1)
  {
  base = GAMGI_CAST_CELL rotation.base;
  gamgi_math_quaternion_to_matrix (base->quaternion, rotate);

  gamgi_phys_direction_vector (base, rotation.base_hkl, rotation.base_vectors, pole);
  gamgi_math_matrix_vector (rotate, pole, a);
  gamgi_phys_plane_vector (base, rotation.base_uvw, rotation.base_vectors, pole);
  gamgi_math_matrix_vector (rotate, pole, a);
  }

gamgi_math_vector_normal (a);
gamgi_math_vector_normal (b);
gamgi_math_vector_cross (a, b, c);
gamgi_math_matrix_absolute (matrix, a[0], b[0], c[0], a[1], b[1], c[1], a[2], b[2], c[2]);

/**************************************************
 * determine Eular angles for the rotation matrix *
 * that converts cell axes into reference axes    *
 **************************************************/

gamgi_math_matrix_matrix (matrix, inverse, rotate);
gamgi_math_euler_from_matrix (rotate, angle);
}

void gamgi_gtk_cell_align_translation (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog0;
GtkWidget *button;

if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)) == TRUE)
  {
  /*********************
   * reset Cell dialog *
   *********************/

  button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_rotation");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), FALSE);

  /***********************
   * create Align dialog *
   ***********************/

  static_translation (window);
  }

/***********************
 * remove Align dialog *
 ***********************/

else gamgi_gtk_dialog_task1_remove (widget, window);
}

void gamgi_gtk_cell_align_rotation (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog0;
GtkWidget *button;

if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)) == TRUE)
  {
  /*********************
   * reset Cell dialog *
   *********************/

  button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_translation");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), FALSE);

  /***********************
   * Create Align Dialog *
   ***********************/

  static_rotation (window);
  }

/***********************
 * remove Align dialog *
 ***********************/

else gamgi_gtk_dialog_task1_remove (widget, window);
}
