/***************************************************************************

  library.h

  GAMBAS plug-in management routines

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __GBX_LIBRARY_H
#define __GBX_LIBRARY_H

#include "gambas.h"
#include "gbx_list.h"
#include "gb_component.h"

#include <dlfcn.h>

#ifdef USE_LTDL
  #include <ltdl.h>
#else
  #define lt_dlsym dlsym
  #define lt_dlclose dlclose
  #define lt_dlerror dlerror
#endif

typedef
  struct _LIBRARY {
    void *class;
    long ref;
    LIST list;
    char *name;
    char *path;
#ifdef USE_LTDL
    lt_dlhandle handle;
#else
    void *handle;
#endif
    unsigned persistent : 1;
    unsigned preload : 1;
    unsigned free_name: 1;
    unsigned _reserved: 13;
    }
  PACKED
  LIBRARY;

#ifndef __GBX_LIBRARY_C
EXTERN LIBRARY *LIBRARY_Current;
EXTERN int LIBRARY_count;
EXTERN const char *LIBRARY_path;
#endif

PUBLIC void LIBRARY_preload(const char *file, char **argv);
PUBLIC void LIBRARY_init(void);
PUBLIC void LIBRARY_exit(void);

PUBLIC LIBRARY *LIBRARY_create(const char *path);
PUBLIC void LIBRARY_delete(LIBRARY *lib);

PUBLIC void LIBRARY_load(LIBRARY *lib);
PUBLIC void LIBRARY_load_all(void);
PUBLIC void LIBRARY_unload(LIBRARY *lib);

PUBLIC void LIBRARY_declare(GB_DESC **desc);

PUBLIC LIBRARY *LIBRARY_find(const char *name);

PUBLIC boolean LIBRARY_get_interface_by_name(const char *name, long version, void *iface);
PUBLIC void LIBRARY_get_interface(LIBRARY *lib, long version, void *iface);

PUBLIC LIBRARY *LIBRARY_next(LIBRARY *lib);

/*PUBLIC const char *LIBRARY_get_control_list(LIBRARY *lib);*/

#define LIBRARY_is_loaded(_lib) ((_lib)->path == NULL || (_lib)->handle != NULL)

#endif
