/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import HTTPClient.Cookie;
import HTTPClient.CookieModule;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PostChangeLog
extends Task {
    public static final String baseUrl = "http://www.gallery2.hu/download/GalleryRemote/";

    public void execute() throws BuildException {
        PropertiesFile changeProps = new PropertiesFile("postchangelog");
        PropertiesFile defaultProps = new PropertiesFile("defaults");
        boolean active = changeProps.getBooleanProperty("active", false);
        if (!active) {
            System.out.println("Not active");
            return;
        }
        int siteBetaBuild = changeProps.getIntProperty("siteBetaBuild", 0);
        String currentBuildS = defaultProps.getProperty("version");
        Pattern buildPattern = Pattern.compile(".*-b(\\d*)");
        Matcher m = buildPattern.matcher(currentBuildS);
        if (!m.matches()) {
            System.out.println("Not a beta build");
            return;
        }
        int currentBetaBuild = Integer.parseInt(m.group(1));
        if (currentBetaBuild == siteBetaBuild) {
            System.out.println("Current and site beta builds are the same: nothing to do");
            return;
        }
        try {
            Pattern header = Pattern.compile("([0-9\\-])\\s*(.*)\\s*<(.*)> \\((.*)\\)");
            String version = null;
            StringBuffer changes = new StringBuffer();
            changes.append("Changes between b").append(siteBetaBuild).append(" and b").append(currentBetaBuild).append(": ");
            File changeLog = new File("ChangeLog");
            BufferedReader in = new BufferedReader(new FileReader(changeLog));
            String line = null;
            while ((line = in.readLine()) != null) {
                System.out.println("Got line: " + line);
                m = header.matcher(line);
                if (m.matches()) {
                    version = m.group(4);
                    System.out.println("Got a header. Version: " + version);
                    m = buildPattern.matcher(version);
                    if (m.matches()) {
                        int myBetaBuild = Integer.parseInt(m.group(1));
                        System.out.println("Beta version: " + myBetaBuild);
                        if (myBetaBuild != siteBetaBuild) continue;
                        System.out.println("Found the right beta: stopping");
                        break;
                    }
                    System.out.println("Found a non-beta... guess it stops here");
                    break;
                }
                if ((line = line.trim()).length() <= 0) continue;
                if (line.startsWith("*")) {
                    changes.append("\\n").append(line).append(" ");
                    continue;
                }
                changes.append(line.trim()).append(" ");
            }
            StringBuffer note = new StringBuffer();
            note.append("version=").append(currentBuildS).append('\n');
            note.append("releaseDate=").append(defaultProps.getProperty("releaseDate")).append('\n');
            note.append("releaseUrl=").append(baseUrl).append("gallery_remote_").append(defaultProps.getProperty("version")).append(".zip").append('\n');
            note.append("releaseUrlMac=").append(baseUrl).append("GalleryRemote.").append(defaultProps.getProperty("version")).append(".MacOSX.NoVM.tgz").append('\n');
            note.append("releaseNotes=").append(changes.toString());
            System.out.println("Got changes: " + changes);
            NVPair[] form_data_login = new NVPair[]{new NVPair("name", changeProps.getProperty("username")), new NVPair("pass", changeProps.getProperty("password")), new NVPair("form_id", "user_login"), new NVPair("op", "Log in")};
            CookieModule.setCookiePolicyHandler(new CookiePolicyHandler(){

                public boolean acceptCookie(Cookie cookie, RoRequest req, RoResponse resp) {
                    System.out.println("Accepting cookie: " + cookie);
                    return true;
                }

                public boolean sendCookie(Cookie cookie, RoRequest req) {
                    System.out.println("Sending cookie: " + cookie);
                    return true;
                }
            });
            HTTPConnection mConnection = new HTTPConnection("gallery.menalto.com");
            HTTPResponse rsp = null;
            String response = null;
            rsp = mConnection.Get("/user");
            response = new String(rsp.getData()).trim();
            System.out.println("Get login response: " + response);
            System.out.println();
            System.out.println();
            System.out.println("*****************************");
            rsp = mConnection.Post("/user", form_data_login);
            response = new String(rsp.getData()).trim();
            System.out.println("Login response: " + response);
            System.out.println();
            System.out.println();
            System.out.println("*****************************");
            rsp = mConnection.Get("/admin/gmc_versioncheck/edit/5");
            response = new String(rsp.getData()).trim();
            System.out.println("Get form response: " + response);
            System.out.println();
            System.out.println();
            System.out.println("*****************************");
            Pattern p = Pattern.compile(".*<input type=\"hidden\" name=\"form_token\" id=\"edit-gmc-versioncheck-form-form-token\" value=\"([0123456789abcdef]*)\"\\s*/>.*", 32);
            m = p.matcher(response);
            if (m.matches()) {
                String formToken = m.group(1);
                System.out.println("Form token: " + formToken);
                NVPair[] form_data_submit = new NVPair[]{new NVPair("url", "galleryremote/beta"), new NVPair("note", note.toString()), new NVPair("id", "5"), new NVPair("form_token", formToken), new NVPair("form_id", "gmc_versioncheck_form"), new NVPair("op", "Update")};
                rsp = mConnection.Post("/admin/gmc_versioncheck/edit/5", form_data_submit);
                response = new String(rsp.getData()).trim();
                System.out.println("Submit response: " + response);
                HTTPConnection mConnection1 = new HTTPConnection("gallery.sourceforge.net");
                rsp = mConnection1.Get("/gallery_remote_version_check_beta.php");
                response = new String(rsp.getData()).trim();
                System.out.println("Test response: " + response);
                if (response.startsWith("version=" + currentBuildS)) {
                    System.out.println("Success: writing to postlogchange properties");
                    changeProps.setIntProperty("siteBetaBuild", currentBetaBuild);
                    changeProps.write();
                } else {
                    System.out.println("Failed to update Menalto");
                }
            } else {
                System.out.println("Could not find the form_token");
                System.out.println("Failed to update Menalto");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ModuleException e) {
            e.printStackTrace();
        }
    }
}

