/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.CoreUtils;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.MainFrame;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PictureInspector
extends JPanel
implements ActionListener,
DocumentListener {
    public static final String MODULE = "PictInspec";
    HashMap extraLabels = new HashMap();
    HashMap extraTextAreas = new HashMap();
    String currentExtraFields = null;
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel8 = new JLabel();
    JPanel jSpacer = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    JButton jDeleteButton = new JButton();
    JButton jUpButton = new JButton();
    JButton jDownButton = new JButton();
    JPanel jIconAreaPanel = new JPanel();
    JTextArea jAlbum = new JTextArea();
    JTextArea jSize = new JTextArea();
    JTextArea jCaption = new JTextArea();
    JTextArea jPath = new JTextArea();
    MainFrame mf = null;
    Object[] pictures = null;
    int emptyIconHeight = 0;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jIcon = new JLabel();
    JButton jRotateLeftButton = new JButton();
    JButton jFlipButton = new JButton();
    JButton jRotateRightButton = new JButton();
    static int FIRST_ROW_EXTRA = 8;
    public Action nextFocusAction = new AbstractAction("Move Focus Forwards"){

        public void actionPerformed(ActionEvent evt) {
            ((Component)evt.getSource()).transferFocus();
        }
    };
    public Action prevFocusAction = new AbstractAction("Move Focus Backwards"){

        public void actionPerformed(ActionEvent evt) {
            ((Component)evt.getSource()).transferFocusBackward();
        }
    };
    public Action nextPictureAction = new AbstractAction("Select Next Picture"){

        public void actionPerformed(ActionEvent evt) {
            CoreUtils.selectNextPicture();
        }
    };
    public Action prevPictureAction = new AbstractAction("Select Prev Picture"){

        public void actionPerformed(ActionEvent evt) {
            CoreUtils.selectPrevPicture();
        }
    };

    public PictureInspector() {
        this.jbInit();
        this.jbInitEvents();
        this.emptyIconHeight = (int)this.jIcon.getPreferredSize().getHeight();
        Log.log(3, MODULE, "emptyIconHeight: " + this.emptyIconHeight);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.jLabel5.setText(GRI18n.getString(MODULE, "Path"));
        this.jLabel6.setText(GRI18n.getString(MODULE, "Album"));
        this.jLabel4.setText(GRI18n.getString(MODULE, "Caption"));
        this.jLabel8.setText(GRI18n.getString(MODULE, "Move"));
        this.jLabel1.setText(GRI18n.getString(MODULE, "Size"));
        this.jLabel2.setText(GRI18n.getString(MODULE, "Delete"));
        this.jAlbum.setRows(0);
        this.jAlbum.setEditable(false);
        this.jAlbum.setFont(UIManager.getFont("Label.font"));
        this.jAlbum.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jSize.setRows(0);
        this.jSize.setEditable(false);
        this.jSize.setFont(UIManager.getFont("Label.font"));
        this.jSize.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jCaption.setLineWrap(true);
        this.jCaption.setEditable(false);
        this.jCaption.setFont(UIManager.getFont("Label.font"));
        this.jCaption.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jPath.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jPath.setFont(UIManager.getFont("Label.font"));
        this.jPath.setEditable(false);
        this.jPath.setLineWrap(true);
        this.setupKeyboardHandling(this.jCaption);
        this.jUpButton.setMaximumSize(new Dimension(120, 23));
        this.jUpButton.setMinimumSize(new Dimension(120, 23));
        this.jUpButton.setPreferredSize(new Dimension(120, 23));
        this.jUpButton.setToolTipText(GRI18n.getString(MODULE, "upBtnTip"));
        this.jUpButton.setText(GRI18n.getString(MODULE, "upBtn"));
        this.jUpButton.setActionCommand("Up");
        this.jUpButton.setHorizontalAlignment(2);
        this.jUpButton.setIcon(GalleryRemote.iUp);
        this.jDownButton.setMaximumSize(new Dimension(120, 23));
        this.jDownButton.setMinimumSize(new Dimension(120, 23));
        this.jDownButton.setPreferredSize(new Dimension(120, 23));
        this.jDownButton.setToolTipText(GRI18n.getString(MODULE, "dnBtnTip"));
        this.jDownButton.setText(GRI18n.getString(MODULE, "dnBtn"));
        this.jDownButton.setActionCommand("Down");
        this.jDownButton.setHorizontalAlignment(2);
        this.jDownButton.setIcon(GalleryRemote.iDown);
        this.jDeleteButton.setMaximumSize(new Dimension(120, 23));
        this.jDeleteButton.setMinimumSize(new Dimension(120, 23));
        this.jDeleteButton.setPreferredSize(new Dimension(120, 23));
        this.jDeleteButton.setToolTipText(GRI18n.getString(MODULE, "delBtnTip"));
        this.jDeleteButton.setActionCommand("Delete");
        this.jDeleteButton.setHorizontalAlignment(2);
        this.jDeleteButton.setText(GRI18n.getString(MODULE, "Delete"));
        this.jDeleteButton.setIcon(GalleryRemote.iDelete);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setBorder(null);
        this.jIconAreaPanel.setLayout(this.gridBagLayout1);
        this.jIcon.setHorizontalAlignment(0);
        this.jIcon.setHorizontalTextPosition(0);
        this.jIcon.setText(GRI18n.getString(MODULE, "icon"));
        this.jIcon.setVerticalTextPosition(3);
        this.jRotateLeftButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jRotateLeftButton.setToolTipText(GRI18n.getString(MODULE, "rotLtTip"));
        this.jRotateLeftButton.setActionCommand("Left");
        this.jRotateLeftButton.setIcon(GalleryRemote.iLeft);
        this.jRotateRightButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jRotateRightButton.setToolTipText(GRI18n.getString(MODULE, "rotRtTip"));
        this.jRotateRightButton.setActionCommand("Right");
        this.jRotateRightButton.setIcon(GalleryRemote.iRight);
        this.jFlipButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jFlipButton.setToolTipText(GRI18n.getString(MODULE, "flipTip"));
        this.jFlipButton.setActionCommand("Flip");
        this.jFlipButton.setIcon(GalleryRemote.iFlip);
        this.add((Component)this.jLabel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(1, 0, 0, 0), 2, 0));
        this.add((Component)this.jLabel6, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 0, 0, 0), 2, 0));
        this.add((Component)this.jLabel4, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 0, 0, 0), 2, 0));
        this.add((Component)this.jLabel8, new GridBagConstraints(0, 4, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 2, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 0, 0, 0), 2, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 2, 0));
        this.add((Component)this.jSpacer, new GridBagConstraints(0, 20, 2, 1, 1.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jIconAreaPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jIconAreaPanel.add((Component)this.jIcon, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (ImageUtils.useJpegtran) {
            this.jIconAreaPanel.add((Component)this.jRotateLeftButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jIconAreaPanel.add((Component)this.jFlipButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jIconAreaPanel.add((Component)this.jRotateRightButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)this.jAlbum, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jSize, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jUpButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)this.jDownButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jDeleteButton, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jScrollPane2, new GridBagConstraints(1, 7, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.jPath, null);
        this.jScrollPane2.getViewport().add((Component)this.jCaption, null);
        this.setMinimumSize(new Dimension(150, 0));
    }

    private void setupKeyboardHandling(JComponent c) {
        c.getInputMap().put(KeyStroke.getKeyStroke(9, 0), this.nextFocusAction.getValue("Name"));
        c.getInputMap().put(KeyStroke.getKeyStroke(9, 1), this.prevFocusAction.getValue("Name"));
        c.getInputMap().put(KeyStroke.getKeyStroke(40, 0), this.nextPictureAction.getValue("Name"));
        c.getInputMap().put(KeyStroke.getKeyStroke(38, 0), this.prevPictureAction.getValue("Name"));
        c.getActionMap().put(this.nextFocusAction.getValue("Name"), this.nextFocusAction);
        c.getActionMap().put(this.prevFocusAction.getValue("Name"), this.prevFocusAction);
        c.getActionMap().put(this.nextPictureAction.getValue("Name"), this.nextPictureAction);
        c.getActionMap().put(this.prevPictureAction.getValue("Name"), this.prevPictureAction);
    }

    private void jbInitEvents() {
        this.jDeleteButton.addActionListener(this);
        this.jUpButton.addActionListener(this);
        this.jDownButton.addActionListener(this);
        this.jRotateLeftButton.addActionListener(this);
        this.jRotateRightButton.addActionListener(this);
        this.jFlipButton.addActionListener(this);
        this.jCaption.getDocument().addDocumentListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Log.log(2, MODULE, "Command selected " + command);
        if (command.equals("Delete")) {
            this.mf.deleteSelectedPictures();
        } else if (command.equals("Up")) {
            this.mf.movePicturesUp();
        } else if (command.equals("Down")) {
            this.mf.movePicturesDown();
        } else if (command.equals("Left")) {
            for (int i = 0; i < this.pictures.length; ++i) {
                ((Picture)this.pictures[i]).rotateLeft();
            }
            this.setPictures(this.pictures);
            this.mf.repaint();
            this.mf.previewFrame.repaint();
        } else if (command.equals("Right")) {
            for (int i = 0; i < this.pictures.length; ++i) {
                ((Picture)this.pictures[i]).rotateRight();
            }
            this.setPictures(this.pictures);
            this.mf.repaint();
            this.mf.previewFrame.repaint();
        } else if (command.equals("Flip")) {
            for (int i = 0; i < this.pictures.length; ++i) {
                ((Picture)this.pictures[i]).flip();
            }
            this.setPictures(this.pictures);
            this.mf.repaint();
            this.mf.previewFrame.repaint();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.textUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textUpdate(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.textUpdate(e);
    }

    public void textUpdate(DocumentEvent e) {
        if (this.pictures != null && this.pictures.length == 1) {
            Picture p = (Picture)this.pictures[0];
            if (e.getDocument() == this.jCaption.getDocument()) {
                p.setCaption(this.jCaption.getText());
            }
            Iterator it = this.extraTextAreas.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                JTextArea field = (JTextArea)this.extraTextAreas.get(name);
                if (e.getDocument() != field.getDocument()) continue;
                String text = field.getText();
                if (text.length() == 0) {
                    p.removeExtraField(name);
                    break;
                }
                p.setExtraField(name, text);
                break;
            }
        }
    }

    public void setMainFrame(MainFrame mf) {
        this.mf = mf;
        this.replaceIcon(this.jIcon, ImageUtils.defaultThumbnail);
    }

    public void setPictures(Object[] pictures) {
        this.pictures = pictures;
        this.jIcon.setPreferredSize(new Dimension(0, GalleryRemote._().properties.getThumbnailSize().height + this.emptyIconHeight + this.jIcon.getIconTextGap()));
        if (pictures == null || pictures.length == 0) {
            this.jIcon.setText(GRI18n.getString(MODULE, "noPicSel"));
            this.replaceIcon(this.jIcon, ImageUtils.defaultThumbnail);
            this.jPath.setText("");
            this.jAlbum.setText("");
            this.jCaption.setText("");
            this.jCaption.setEditable(false);
            this.jCaption.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            this.jSize.setText("");
            this.jUpButton.setEnabled(false);
            this.jDownButton.setEnabled(false);
            this.jDeleteButton.setEnabled(false);
            this.jRotateLeftButton.setEnabled(false);
            this.jRotateRightButton.setEnabled(false);
            this.jFlipButton.setEnabled(false);
            this.removeExtraFields();
        } else if (pictures.length == 1) {
            Picture p = (Picture)pictures[0];
            this.replaceIcon(this.jIcon, this.mf.getThumbnail(p));
            if (p.isOnline()) {
                this.jPath.setText(GRI18n.getString(MODULE, "onServer"));
                this.jIcon.setText(p.getName());
            } else {
                this.jIcon.setText(p.getSource().getName());
                this.jPath.setText(p.getSource().getParent());
            }
            this.jAlbum.setText(p.getParentAlbum().getTitle());
            if (p.getParentAlbum().getGallery().getComm(this.mf.jStatusBar).hasCapability(this.mf.jStatusBar, 3)) {
                this.jCaption.setText(p.getCaption());
                this.jCaption.setEditable(true);
                this.jCaption.setBackground(UIManager.getColor("TextField.background"));
            }
            this.jSize.setText(NumberFormat.getInstance().format((int)p.getFileSize()) + " bytes");
            this.jUpButton.setEnabled(this.isEnabled());
            this.jDownButton.setEnabled(this.isEnabled());
            this.jDeleteButton.setEnabled(this.isEnabled());
            this.jRotateLeftButton.setEnabled(this.isEnabled());
            this.jRotateRightButton.setEnabled(this.isEnabled());
            this.jFlipButton.setEnabled(this.isEnabled());
            this.addExtraFields(p);
        } else {
            Picture p = (Picture)pictures[0];
            Object[] params = new Object[]{new Integer(pictures.length)};
            this.jIcon.setText(GRI18n.getString(MODULE, "countElemSel", params));
            this.replaceIcon(this.jIcon, ImageUtils.defaultThumbnail);
            this.jPath.setText("");
            this.jAlbum.setText(p.getParentAlbum().getTitle());
            this.jCaption.setText("");
            this.jCaption.setEditable(false);
            this.jCaption.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            this.jSize.setText(NumberFormat.getInstance().format(Album.getObjectFileSize(pictures)) + " bytes");
            this.jUpButton.setEnabled(this.isEnabled());
            this.jDownButton.setEnabled(this.isEnabled());
            this.jDeleteButton.setEnabled(this.isEnabled());
            this.jRotateLeftButton.setEnabled(this.isEnabled());
            this.jRotateRightButton.setEnabled(this.isEnabled());
            this.jFlipButton.setEnabled(this.isEnabled());
            this.removeExtraFields();
        }
    }

    void addExtraFields(Picture p) {
        ArrayList newExtraFields = p.getParentAlbum().getExtraFields();
        if (newExtraFields == null) {
            this.removeExtraFields();
        } else {
            if (!newExtraFields.equals(this.currentExtraFields)) {
                this.removeExtraFields();
                int i = 0;
                Iterator it = newExtraFields.iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    JLabel label = new JLabel(name);
                    this.extraLabels.put(name, label);
                    this.add((Component)label, new GridBagConstraints(0, FIRST_ROW_EXTRA + i, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 0, 0, 0), 2, 0));
                    JTextArea field = new JTextArea();
                    this.extraTextAreas.put(name, field);
                    field.setFont(UIManager.getFont("Label.font"));
                    this.add((Component)field, new GridBagConstraints(1, FIRST_ROW_EXTRA + i, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
                    field.getDocument().addDocumentListener(this);
                    this.setupKeyboardHandling(field);
                    ++i;
                }
            }
            Iterator it = newExtraFields.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                String value = p.getExtraField(name);
                JTextArea field = (JTextArea)this.extraTextAreas.get(name);
                if (value == null) {
                    field.setText("");
                    continue;
                }
                field.setText(value);
            }
        }
    }

    void removeExtraFields() {
        Iterator it = this.extraLabels.values().iterator();
        while (it.hasNext()) {
            JLabel label = (JLabel)it.next();
            this.remove(label);
        }
        it = this.extraTextAreas.values().iterator();
        while (it.hasNext()) {
            JTextArea textArea = (JTextArea)it.next();
            this.remove(textArea);
        }
        this.extraLabels.clear();
        this.extraTextAreas.clear();
    }

    public void setEnabled(boolean enabled) {
        this.jIcon.setEnabled(enabled);
        this.jUpButton.setEnabled(enabled);
        this.jDownButton.setEnabled(enabled);
        this.jDeleteButton.setEnabled(enabled);
        this.jRotateLeftButton.setEnabled(enabled);
        this.jRotateRightButton.setEnabled(enabled);
        this.jFlipButton.setEnabled(enabled);
        this.jCaption.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void replaceIcon(JLabel label, Image icon) {
        Icon i = label.getIcon();
        if (i == null || !(i instanceof ImageIcon)) {
            i = new ImageIcon();
            label.setIcon(i);
        }
        ((ImageIcon)i).setImage(icon);
    }
}

