/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.MainFrame;
import com.gallery.GalleryRemote.PictureSelection;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class DroppableTree
extends JTree
implements DropTargetListener {
    protected static final String MODULE = "Droptree";
    MainFrame mf = null;
    DropTarget dropTarget = new DropTarget(this, this);
    int lastRow = -1;
    int scrollPace = 0;

    public void paint(Graphics g) {
        this.lastRow = -1;
        super.paint(g);
    }

    public boolean isDragOK(DropTargetEvent dropTargetEvent) {
        boolean result;
        Point dropLocation;
        if (!this.isEnabled()) {
            return false;
        }
        if (dropTargetEvent instanceof DropTargetDragEvent) {
            dropLocation = ((DropTargetDragEvent)dropTargetEvent).getLocation();
            result = this.getPathForLocation((int)dropLocation.getX(), (int)dropLocation.getY()) == null ? false : ((DropTargetDragEvent)dropTargetEvent).isDataFlavorSupported(DataFlavor.javaFileListFlavor) || ((DropTargetDragEvent)dropTargetEvent).isDataFlavorSupported(PictureSelection.flavors[0]);
        } else {
            dropLocation = ((DropTargetDropEvent)dropTargetEvent).getLocation();
            if (this.getPathForLocation((int)dropLocation.getX(), (int)dropLocation.getY()) == null) {
                result = false;
            } else {
                boolean bl = result = ((DropTargetDropEvent)dropTargetEvent).isDataFlavorSupported(DataFlavor.javaFileListFlavor) || ((DropTargetDropEvent)dropTargetEvent).isDataFlavorSupported(PictureSelection.flavors[0]);
            }
        }
        if (!result && this.lastRow != -1) {
            Graphics g = this.getGraphics();
            g.setXORMode(Color.cyan);
            g.drawRect(0, this.lastRow * this.rowHeight, this.getWidth(), this.rowHeight);
            this.lastRow = -1;
        }
        return result;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        Log.log(3, MODULE, "dragEnter - dtde");
        Iterator<DataFlavor> it = dropTargetDragEvent.getCurrentDataFlavorsAsList().iterator();
        while (it.hasNext()) {
            DataFlavor flavor = it.next();
            Log.log(3, MODULE, "Flavor: " + flavor.getHumanPresentableName() + " -- " + flavor.getMimeType());
        }
        Log.log(3, MODULE, "Action: " + dropTargetDragEvent.getSourceActions() + " -- " + dropTargetDragEvent.getDropAction());
        if (!this.isDragOK(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        Log.log(3, MODULE, "Accepting drag");
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        Log.log(3, MODULE, "dragExit - dtde");
        this.repaint();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOK(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        dropTargetDragEvent.acceptDrag(3);
        this.dragOver((int)dropTargetDragEvent.getLocation().getY());
    }

    public void dragOver(int y) {
        int tmpLastRow;
        int row = this.snapIndex(y);
        int rowHeight = this.getRowHeight();
        Rectangle r = this.getVisibleRect();
        boolean scrolled = false;
        if ((double)y < r.getY() + (double)this.getRowHeight() && row > 0) {
            tmpLastRow = this.lastRow;
            this.scrollRectToVisible(new Rectangle(0, (int)r.getY() - rowHeight, 0, 0));
            this.lastRow = tmpLastRow;
            scrolled = true;
        }
        if ((double)y > r.getY() + r.getHeight() - (double)this.getRowHeight() && row < this.getRowCount() - 1) {
            tmpLastRow = this.lastRow;
            this.scrollRectToVisible(new Rectangle(0, (int)(r.getY() + r.getHeight() + (double)rowHeight), 0, 0));
            this.lastRow = tmpLastRow;
            scrolled = true;
        }
        Graphics g = this.getGraphics();
        g.setXORMode(Color.cyan);
        int xStart = 0;
        int xStop = this.getWidth() - xStart;
        if (this.lastRow != -1) {
            g.drawRect(xStart, this.lastRow * rowHeight, xStop, rowHeight);
        }
        this.lastRow = row;
        if (this.lastRow != -1) {
            g.drawRect(xStart, this.lastRow * rowHeight, xStop, rowHeight);
        }
        if (scrolled) {
            ++this.scrollPace;
            try {
                Thread.sleep(this.scrollPace > 5 ? 10L : 200L);
            }
            catch (InterruptedException e) {}
        } else {
            this.scrollPace = 0;
        }
    }

    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        Log.log(3, MODULE, "drop - dtde");
        if (!this.isDragOK(dropTargetDropEvent)) {
            Log.log(3, MODULE, "Refusing drop");
            dropTargetDropEvent.rejectDrop();
            return;
        }
        Log.log(3, MODULE, "Accepting drop");
        try {
            Transferable tr = dropTargetDropEvent.getTransferable();
            dropTargetDropEvent.acceptDrop(3);
            Point dropLocation = dropTargetDropEvent.getLocation();
            Album album = (Album)this.getPathForLocation((int)dropLocation.getX(), (int)dropLocation.getY()).getLastPathComponent();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                try {
                    fileList = ImageUtils.expandDirectories(fileList);
                }
                catch (IOException ioe) {
                    Log.log(1, MODULE, "i/o exception listing dirs in a drop");
                    Log.logStack(1, MODULE);
                    JOptionPane.showMessageDialog(null, GRI18n.getString(MODULE, "imgError"), GRI18n.getString(MODULE, "dragError"), 0);
                }
                Log.log(3, MODULE, "Adding " + fileList.size() + " new files(s) to album " + album);
                this.mf.addPictures(album, fileList.toArray(new File[0]), false);
            } else {
                List pictureList = (List)tr.getTransferData(PictureSelection.flavors[0]);
                Log.log(3, MODULE, "Adding " + pictureList.size() + " new pictures(s) to album " + album);
                this.mf.addPictures(album, pictureList.toArray(new Picture[0]), false);
            }
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
        }
        catch (IOException io) {
            Log.logException(1, MODULE, io);
            dropTargetDropEvent.getDropTargetContext().dropComplete(false);
        }
        catch (UnsupportedFlavorException ufe) {
            Log.logException(1, MODULE, ufe);
            dropTargetDropEvent.getDropTargetContext().dropComplete(false);
        }
        this.repaint();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        Log.log(3, MODULE, "dropActionChanged - dtde");
        if (!this.isDragOK(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void setMainFrame(MainFrame mf) {
        this.mf = mf;
    }

    public int snap(int y) {
        return this.snapIndex(y) * this.getRowHeight();
    }

    public int snapIndex(int y) {
        int height = this.getRowHeight();
        int row = (int)Math.floor((float)y / (float)height);
        if (row > this.getRowCount()) {
            row = -1;
        }
        return row;
    }

    public Point getToolTipLocation(MouseEvent event) {
        try {
            Point p = event.getPoint();
            int selRow = this.getRowForLocation(p.x, p.y);
            TreePath path = this.getPathForRow(selRow);
            Rectangle pathBounds = this.getPathBounds(path);
            Point location = pathBounds.getLocation();
            location.translate(-4, 0);
            return location;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getToolTipText(MouseEvent event) {
        if (event != null) {
            Point p = event.getPoint();
            int selRow = this.getRowForLocation(p.x, p.y);
            TreeCellRenderer r = this.getCellRenderer();
            if (selRow != -1 && r != null) {
                TreePath path = this.getPathForRow(selRow);
                Object lastPath = path.getLastPathComponent();
                Component rComponent = r.getTreeCellRendererComponent(this, lastPath, this.isRowSelected(selRow), this.isExpanded(selRow), this.getModel().isLeaf(lastPath), selRow, true);
                Rectangle pathBounds = this.getPathBounds(path);
                if (rComponent instanceof JComponent && pathBounds.x + pathBounds.width > this.getParent().getWidth()) {
                    p.translate(-pathBounds.x, -pathBounds.y);
                    MouseEvent newEvent = new MouseEvent(rComponent, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
                    return ((JComponent)rComponent).getToolTipText(newEvent);
                }
            }
        }
        return null;
    }
}

