<?php
/*
 * $RCSfile: GalleryUser.inc,v $
 *
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2005 Bharat Mediratta
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
/**
 * @package GalleryCore
 * @subpackage ClassInterfaces
 * @version $Revision: 1.39 $ $Date: 2005/08/23 03:49:04 $
 * @author Bharat Mediratta <bharat@menalto.com>
 */

/**
 * Interface class for the GalleryUser class.
 * (Class schema version: 1.0)
 *
 * This file is automatically generated from XML embedded in the
 * class, combined with the ClassCode.xsl file.  You should not modify
 * it by hand, as your changes will be lost next time this file is
 * rebuilt.  If you want to add more getters/setters, you should add
 * them in the core class.  If you want to change the format of this
 * file, then you should edit the XSL template.
 *
 * @package GalleryCore
 * @subpackage Classes
 */
class GalleryUser extends GalleryUser_core {
  
    /**
     * Return meta information about the members of this class
     *
     * @return array member => array(type, class)
     */
    function getPersistentMemberInfo() {
	$meta = parent::getPersistentMemberInfo();
	$meta['members']['userName'] = array('class' => 'GalleryUser', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['fullName'] = array('class' => 'GalleryUser', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['hashedPassword'] = array('class' => 'GalleryUser', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['email'] = array('class' => 'GalleryUser', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['language'] = array('class' => 'GalleryUser', 'type' => STORAGE_TYPE_STRING);
    
	return $meta;
    }

    /**
     * Get the data from this persistent object as an associative array
     *
     * @return array memberName => memberValue
     */
    function getMemberData() {
	$data = parent::getMemberData();
        $data['userName'] = isset($this->_userName) ? $this->_userName : null;
        $data['fullName'] = isset($this->_fullName) ? $this->_fullName : null;
        $data['hashedPassword'] = isset($this->_hashedPassword) ? $this->_hashedPassword : null;
        $data['email'] = isset($this->_email) ? $this->_email : null;
        $data['language'] = isset($this->_language) ? $this->_language : null;
	return $data;
    }
  
    /**
     * Return the name of this class with the proper mix of uppercase and
     * lowercase (get_class() always returns lowercase)
     *
     * @return string class name
     */
    function getClassName() {
	return 'GalleryUser';
    }

    /** 
     * Return the path to the PHP file for this class, relative to the gallery2 dir
     * 
     * @return string path
     */ 
    function getClassFile() { 
        return 'modules/' .  
            basename(dirname(dirname(dirname(__FILE__)))) .  
            '/classes/GalleryUser.class'; 
    }
    
    /**
     * Get the value of userName
     *
     * @return STRING the value
     */
    function getuserName() {
	if (!isset($this->_userName)) {
	    return null;
	}
	return $this->_userName;
    }

    /**
     * Set the value of userName
     *
     * @param STRING the value
     */
    function setuserName($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 32);
	$orig = isset($this->_userName) ? $this->_userName : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('userName', $value);
	    $this->_userName = $value;
	}
    }
  
    /**
     * Get the value of fullName
     *
     * @return STRING the value
     */
    function getfullName() {
	if (!isset($this->_fullName)) {
	    return null;
	}
	return $this->_fullName;
    }

    /**
     * Set the value of fullName
     *
     * @param STRING the value
     */
    function setfullName($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_fullName) ? $this->_fullName : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('fullName', $value);
	    $this->_fullName = $value;
	}
    }
  
    /**
     * Get the value of hashedPassword
     *
     * @return STRING the value
     */
    function gethashedPassword() {
	if (!isset($this->_hashedPassword)) {
	    return null;
	}
	return $this->_hashedPassword;
    }

    /**
     * Set the value of hashedPassword
     *
     * @param STRING the value
     */
    function sethashedPassword($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_hashedPassword) ? $this->_hashedPassword : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('hashedPassword', $value);
	    $this->_hashedPassword = $value;
	}
    }
  
    /**
     * Get the value of email
     *
     * @return STRING the value
     */
    function getemail() {
	if (!isset($this->_email)) {
	    return null;
	}
	return $this->_email;
    }

    /**
     * Set the value of email
     *
     * @param STRING the value
     */
    function setemail($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_email) ? $this->_email : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('email', $value);
	    $this->_email = $value;
	}
    }
  
    /**
     * Get the value of language
     *
     * @return STRING the value
     */
    function getlanguage() {
	if (!isset($this->_language)) {
	    return null;
	}
	return $this->_language;
    }

    /**
     * Set the value of language
     *
     * @param STRING the value
     */
    function setlanguage($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_language) ? $this->_language : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('language', $value);
	    $this->_language = $value;
	}
    }
  
}
?>
