<?php
/*
 * $RCSfile: GalleryPhotoItem.inc,v $
 *
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2005 Bharat Mediratta
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
/**
 * @package GalleryCore
 * @subpackage ClassInterfaces
 * @version $Revision: 1.40 $ $Date: 2005/08/23 03:49:04 $
 * @author Bharat Mediratta <bharat@menalto.com>
 */

/**
 * Interface class for the GalleryPhotoItem class.
 * (Class schema version: 1.0)
 *
 * This file is automatically generated from XML embedded in the
 * class, combined with the ClassCode.xsl file.  You should not modify
 * it by hand, as your changes will be lost next time this file is
 * rebuilt.  If you want to add more getters/setters, you should add
 * them in the core class.  If you want to change the format of this
 * file, then you should edit the XSL template.
 *
 * @package GalleryCore
 * @subpackage Classes
 */
class GalleryPhotoItem extends GalleryPhotoItem_core {
  
    /**
     * Return meta information about the members of this class
     *
     * @return array member => array(type, class)
     */
    function getPersistentMemberInfo() {
	$meta = parent::getPersistentMemberInfo();
	$meta['members']['width'] = array('class' => 'GalleryPhotoItem', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['height'] = array('class' => 'GalleryPhotoItem', 'type' => STORAGE_TYPE_INTEGER);
    
	return $meta;
    }

    /**
     * Get the data from this persistent object as an associative array
     *
     * @return array memberName => memberValue
     */
    function getMemberData() {
	$data = parent::getMemberData();if (isset($this->_linkedEntity)) {
            $data['width'] = isset($this->_linkedEntity->_width) ? $this->_linkedEntity->_width : null;
	} else {
            $data['width'] = isset($this->_width) ? $this->_width : null;
        }
	if (isset($this->_linkedEntity)) {
            $data['height'] = isset($this->_linkedEntity->_height) ? $this->_linkedEntity->_height : null;
	} else {
            $data['height'] = isset($this->_height) ? $this->_height : null;
        }
	
	return $data;
    }
  
    /**
     * Return the name of this class with the proper mix of uppercase and
     * lowercase (get_class() always returns lowercase)
     *
     * @return string class name
     */
    function getClassName() {
	return 'GalleryPhotoItem';
    }

    /** 
     * Return the path to the PHP file for this class, relative to the gallery2 dir
     * 
     * @return string path
     */ 
    function getClassFile() { 
        return 'modules/' .  
            basename(dirname(dirname(dirname(__FILE__)))) .  
            '/classes/GalleryPhotoItem.class'; 
    }
    
    /**
     * Get the value of width
     *
     * @return INTEGER the value
     */
    function getwidth() {
	$linkedEntity = $this->getLinkedEntity();
	if (isset($linkedEntity)) {
	    return $linkedEntity->getwidth();
	}
	
	if (!isset($this->_width)) {
	    return null;
	}
	return $this->_width;
    }

    /**
     * Set the value of width
     *
     * @param INTEGER the value
     */
    function setwidth($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_width) ? $this->_width : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('width', $value);
	    $this->_width = $value;
	}
    }
  
    /**
     * Get the value of height
     *
     * @return INTEGER the value
     */
    function getheight() {
	$linkedEntity = $this->getLinkedEntity();
	if (isset($linkedEntity)) {
	    return $linkedEntity->getheight();
	}
	
	if (!isset($this->_height)) {
	    return null;
	}
	return $this->_height;
    }

    /**
     * Set the value of height
     *
     * @param INTEGER the value
     */
    function setheight($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_height) ? $this->_height : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('height', $value);
	    $this->_height = $value;
	}
    }
  
}
?>
