<?php
/*
 * $RCSfile: GalleryComment.inc,v $
 *
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2005 Bharat Mediratta
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
/**
 * @package Comment
 * @subpackage ClassInterfaces
 * @version $Revision: 1.26 $ $Date: 2005/08/23 03:49:02 $
 * @author Bharat Mediratta <bharat@menalto.com>
 */

/**
 * Interface class for the GalleryComment class.
 * (Class schema version: 1.0)
 *
 * This file is automatically generated from XML embedded in the
 * class, combined with the ClassCode.xsl file.  You should not modify
 * it by hand, as your changes will be lost next time this file is
 * rebuilt.  If you want to add more getters/setters, you should add
 * them in the core class.  If you want to change the format of this
 * file, then you should edit the XSL template.
 *
 * @package Comment
 * @subpackage Classes
 */
class GalleryComment extends GalleryComment_core {
  
    /**
     * Return meta information about the members of this class
     *
     * @return array member => array(type, class)
     */
    function getPersistentMemberInfo() {
	$meta = parent::getPersistentMemberInfo();
	$meta['members']['commenterId'] = array('class' => 'GalleryComment', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['host'] = array('class' => 'GalleryComment', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['subject'] = array('class' => 'GalleryComment', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['comment'] = array('class' => 'GalleryComment', 'type' => STORAGE_TYPE_TEXT);
    
	$meta['members']['date'] = array('class' => 'GalleryComment', 'type' => STORAGE_TYPE_INTEGER);
    
	return $meta;
    }

    /**
     * Get the data from this persistent object as an associative array
     *
     * @return array memberName => memberValue
     */
    function getMemberData() {
	$data = parent::getMemberData();
        $data['commenterId'] = isset($this->_commenterId) ? $this->_commenterId : null;
        $data['host'] = isset($this->_host) ? $this->_host : null;
        $data['subject'] = isset($this->_subject) ? $this->_subject : null;
        $data['comment'] = isset($this->_comment) ? $this->_comment : null;
        $data['date'] = isset($this->_date) ? $this->_date : null;
	return $data;
    }
  
    /**
     * Return the name of this class with the proper mix of uppercase and
     * lowercase (get_class() always returns lowercase)
     *
     * @return string class name
     */
    function getClassName() {
	return 'GalleryComment';
    }

    /** 
     * Return the path to the PHP file for this class, relative to the gallery2 dir
     * 
     * @return string path
     */ 
    function getClassFile() { 
        return 'modules/' .  
            basename(dirname(dirname(dirname(__FILE__)))) .  
            '/classes/GalleryComment.class'; 
    }
    
    /**
     * Get the value of commenterId
     *
     * @return INTEGER the value
     */
    function getcommenterId() {
	if (!isset($this->_commenterId)) {
	    return null;
	}
	return $this->_commenterId;
    }

    /**
     * Set the value of commenterId
     *
     * @param INTEGER the value
     */
    function setcommenterId($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_commenterId) ? $this->_commenterId : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('commenterId', $value);
	    $this->_commenterId = $value;
	}
    }
  
    /**
     * Get the value of host
     *
     * @return STRING the value
     */
    function gethost() {
	if (!isset($this->_host)) {
	    return null;
	}
	return $this->_host;
    }

    /**
     * Set the value of host
     *
     * @param STRING the value
     */
    function sethost($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_host) ? $this->_host : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('host', $value);
	    $this->_host = $value;
	}
    }
  
    /**
     * Get the value of subject
     *
     * @return STRING the value
     */
    function getsubject() {
	if (!isset($this->_subject)) {
	    return null;
	}
	return $this->_subject;
    }

    /**
     * Set the value of subject
     *
     * @param STRING the value
     */
    function setsubject($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_subject) ? $this->_subject : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('subject', $value);
	    $this->_subject = $value;
	}
    }
  
    /**
     * Get the value of comment
     *
     * @return TEXT the value
     */
    function getcomment() {
	if (!isset($this->_comment)) {
	    return null;
	}
	return $this->_comment;
    }

    /**
     * Set the value of comment
     *
     * @param TEXT the value
     */
    function setcomment($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_comment) ? $this->_comment : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('comment', $value);
	    $this->_comment = $value;
	}
    }
  
    /**
     * Get the value of date
     *
     * @return INTEGER the value
     */
    function getdate() {
	if (!isset($this->_date)) {
	    return null;
	}
	return $this->_date;
    }

    /**
     * Set the value of date
     *
     * @param INTEGER the value
     */
    function setdate($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_date) ? $this->_date : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('date', $value);
	    $this->_date = $value;
	}
    }
  
}
?>
