/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import com.gallery.GalleryRemote.CancellableTransferListener;
import com.gallery.GalleryRemote.GalleryFileFilter;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.GalleryProperties;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.UrlMessageDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ImageUtils {
    public static final String MODULE = "ImageUtils";
    static ArrayList toDelete;
    static long totalTime;
    static int totalIter;
    public static boolean useIM;
    static String imPath;
    static int jpegQuality;
    static boolean imIgnoreErrorCode;
    public static boolean useJpegtran;
    public static boolean useJpegtranCrop;
    static String jpegtranPath;
    static boolean jpegtranIgnoreErrorCode;
    static File tmpDir;
    public static final int THUMB = 0;
    public static final int PREVIEW = 1;
    public static final int UPLOAD = 2;
    static String[] filterName;
    static String[] format;
    public static final String DEFAULT_RESOURCE = "/default.gif";
    public static final String UNRECOGNIZED_RESOURCE = "/default.gif";
    public static ImageIcon defaultThumbnail;
    public static ImageIcon unrecognizedThumbnail;
    public static boolean deferredStopUsingIM;
    public static boolean deferredStopUsingJpegtran;
    public static boolean deferredStopUsingJpegtranCrop;
    static /* synthetic */ Class class$com$gallery$GalleryRemote$util$ImageUtils;
    static /* synthetic */ Class class$java$lang$String;

    public static ImageIcon load(String filename, Dimension d, int usage) {
        return ImageUtils.load(filename, d, usage, false);
    }

    public static ImageIcon load(String filename, Dimension d, int usage, boolean ignoreFailure) {
        if (!new File(filename).exists()) {
            return null;
        }
        ImageIcon r = null;
        long start = System.currentTimeMillis();
        if (!GalleryFileFilter.canManipulate(filename)) {
            return unrecognizedThumbnail;
        }
        if (useIM) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(imPath);
            if (filterName[usage] != null && filterName[usage].length() > 0) {
                cmd.add("-filter");
                cmd.add(filterName[usage]);
            }
            cmd.add(filename);
            cmd.add("-resize");
            if (GalleryRemote._().properties.getBooleanProperty("slideshowNoStretch")) {
                cmd.add(d.width + "x" + d.height + ">");
            } else {
                cmd.add(d.width + "x" + d.height);
            }
            cmd.add("+profile");
            cmd.add("*");
            File temp = ImageUtils.deterministicTempFile("thumb", "." + format[usage], tmpDir, filename + d);
            if (!temp.exists()) {
                toDelete.add(temp);
                cmd.add(temp.getPath());
                int exitValue = ImageUtils.exec(cmd.toArray(new String[0]));
                if (exitValue != 0 && !imIgnoreErrorCode && !ignoreFailure || !temp.exists()) {
                    if (exitValue != -1 || !temp.exists()) {
                        Log.log(0, MODULE, "ImageMagick doesn't seem to be working. Disabling");
                        ImageUtils.stopUsingIM();
                    }
                } else {
                    r = new ImageIcon(temp.getPath());
                }
            } else {
                r = new ImageIcon(temp.getPath());
            }
        }
        if (!useIM && r == null) {
            r = ImageUtils.loadJava(filename, d, GalleryRemote._().properties.getBooleanProperty("slideshowNoStretch"));
        }
        long time = System.currentTimeMillis() - start;
        Log.log(3, MODULE, "Time: " + time + " - Avg: " + (totalTime += time) / (long)(++totalIter));
        return r;
    }

    public static ImageIcon loadJava(URL url, Dimension d, boolean noStretch) {
        ImageIcon r = new ImageIcon(url);
        return ImageUtils.loadJavaInternal(r, d, noStretch);
    }

    public static ImageIcon loadJava(String filename, Dimension d, boolean noStretch) {
        ImageIcon r = new ImageIcon(filename);
        return ImageUtils.loadJavaInternal(r, d, noStretch);
    }

    private static ImageIcon loadJavaInternal(ImageIcon r, Dimension d, boolean noStretch) {
        Image scaled = null;
        Dimension newD = ImageUtils.getSizeKeepRatio(new Dimension(r.getIconWidth(), r.getIconHeight()), d, noStretch);
        if (newD == null) {
            return r;
        }
        scaled = r.getImage().getScaledInstance(newD.width, newD.height, 2);
        r.getImage().flush();
        r.setImage(scaled);
        return r;
    }

    public static File resize(String filename, Dimension d) {
        return ImageUtils.resize(filename, d, null);
    }

    public static File resize(String filename, Dimension d, Rectangle cropTo) {
        File r = null;
        long start = System.currentTimeMillis();
        if (!GalleryFileFilter.canManipulate(filename)) {
            return new File(filename);
        }
        if (useIM) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(imPath);
            if (filterName[2] != null && filterName[2].length() > 0) {
                cmd.add("-filter");
                cmd.add(filterName[2]);
            }
            cmd.add(filename);
            if (cropTo != null) {
                cmd.add("-crop");
                cmd.add(cropTo.width + "x" + cropTo.height + "+" + cropTo.x + "+" + cropTo.y);
            }
            if (d != null) {
                cmd.add("-resize");
                cmd.add(d.width + "x" + d.height + ">");
            }
            cmd.add("-quality");
            cmd.add("" + jpegQuality);
            r = ImageUtils.deterministicTempFile("res", "." + GalleryFileFilter.getExtension(filename), tmpDir, filename + d + cropTo);
            toDelete.add(r);
            cmd.add(r.getPath());
            int exitValue = ImageUtils.exec(cmd.toArray(new String[0]));
            if (exitValue != 0 && !imIgnoreErrorCode || !r.exists()) {
                if (exitValue != -1 || !r.exists()) {
                    Log.log(0, MODULE, "ImageMagick doesn't seem to be working. Disabling");
                    ImageUtils.stopUsingIM();
                }
                r = null;
            }
        }
        if (!useIM && r == null && (r = ImageUtils.resizeJava(filename, d)) == null) {
            Log.log(3, MODULE, "All methods of resize failed: sending original file");
            r = new File(filename);
        }
        long time = System.currentTimeMillis() - start;
        Log.log(3, MODULE, "Time: " + time + " - Avg: " + (totalTime += time) / (long)(++totalIter));
        return r;
    }

    public static File resizeJava(String filename, Dimension d) {
        File r = null;
        if (!GalleryRemote._().properties.getBooleanProperty("useJavaResize")) {
            return null;
        }
        if (!GalleryRemote._().properties.getBooleanProperty("suppressWarningJava") && ImageUtils.stopUsingJavaResize()) {
            return null;
        }
        try {
            ImageOutputStream ios;
            ImageWriter writer;
            IIOImage image;
            ImageInputStream iis = ImageIO.createImageInputStream(new File(filename));
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return null;
            }
            ImageReader reader = iter.next();
            ImageReadParam param = reader.getDefaultReadParam();
            reader.setInput(iis, true, false);
            BufferedImage rim = (BufferedImage)reader.readAsRenderedImage(0, param);
            iis.close();
            reader.dispose();
            Dimension newD = ImageUtils.getSizeKeepRatio(new Dimension(rim.getWidth(), rim.getHeight()), d, true);
            if (newD != null) {
                Image scaled = rim.getScaledInstance(newD.width, newD.height, 4);
                ImageObserver imageObserver = null;
                BufferedImage scaledB = new BufferedImage(scaled.getWidth(imageObserver), scaled.getHeight(imageObserver), rim.getType());
                scaledB.getGraphics().drawImage(scaled, 0, 0, imageObserver);
                image = new IIOImage(scaledB, null, null);
                r = ImageUtils.deterministicTempFile("jres", "." + GalleryFileFilter.getExtension(filename), tmpDir, filename + d);
                toDelete.add(r);
                writer = ImageIO.getImageWriter(reader);
                if (writer == null) {
                    Log.log(1, MODULE, "No writer to write out " + filename + " ImageIO probably doesn't support it. Resize aborted.");
                    return new File(filename);
                }
                ios = null;
                try {
                    r.delete();
                    ios = ImageIO.createImageOutputStream(r);
                }
                catch (IOException e) {
                    throw new IIOException("Can't create output stream!", e);
                }
            } else {
                return new File(filename);
            }
            writer.setOutput(ios);
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality((float)jpegQuality / 100.0f);
            writer.write(null, image, iwp);
            ios.flush();
            ios.close();
            writer.dispose();
            Log.log(3, MODULE, "Java resized " + filename + " to " + r.getPath());
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
            return new File(filename);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File rotate(String filename, int angle, boolean flip, boolean resetExifOrientation) {
        File r;
        block9: {
            r = null;
            if (!GalleryFileFilter.canManipulateJpeg(filename)) {
                Log.log(3, MODULE, "jpegtran doesn't support rotating anything but jpeg");
                return new File(filename);
            }
            if (useJpegtran) {
                File orig = null;
                File dest = null;
                try {
                    if (GalleryRemote.IS_MAC_OS_X) {
                        orig = new File(filename);
                        dest = ImageUtils.deterministicTempFile("tmp", "." + GalleryFileFilter.getExtension(filename), tmpDir, filename + angle + flip);
                        orig.renameTo(dest);
                        filename = dest.getPath();
                    }
                    if (flip) {
                        r = ImageUtils.jpegtranExec(filename, "-flip", "horizontal", false);
                        filename = r.getPath();
                    }
                    if (angle != 0) {
                        r = ImageUtils.jpegtranExec(filename, "-rotate", "" + angle * 90, false);
                    }
                    Object var8_7 = null;
                    if (orig == null || dest == null) break block9;
                    dest.renameTo(orig);
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (orig != null && dest != null) {
                        dest.renameTo(orig);
                    }
                    throw throwable;
                }
                {
                }
            }
        }
        if (!useJpegtran && r == null) {
            throw new UnsupportedOperationException("jpegtran must be installed for this operation");
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File losslessCrop(String filename, Rectangle cropTo) {
        File r;
        block7: {
            r = null;
            if (!GalleryFileFilter.canManipulateJpeg(filename)) {
                throw new UnsupportedOperationException("jpegtran doesn't support cropping anything but jpeg");
            }
            if (useJpegtran) {
                File orig = null;
                File dest = null;
                try {
                    if (GalleryRemote.IS_MAC_OS_X) {
                        orig = new File(filename);
                        dest = ImageUtils.deterministicTempFile("tmp", "." + GalleryFileFilter.getExtension(filename), tmpDir, filename + cropTo);
                        orig.renameTo(dest);
                        filename = dest.getPath();
                    }
                    r = ImageUtils.jpegtranExec(filename, "-crop", cropTo.width + "x" + cropTo.height + "+" + cropTo.x + "+" + cropTo.y, true);
                    Object var6_5 = null;
                    if (orig == null || dest == null) break block7;
                    dest.renameTo(orig);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (orig != null && dest != null) {
                        dest.renameTo(orig);
                    }
                    throw throwable;
                }
                {
                }
            }
        }
        if (!useJpegtran && r == null) {
            throw new UnsupportedOperationException("jpegtran with CROP PATCH must be installed for this operation");
        }
        return r;
    }

    private static File jpegtranExec(String filename, String arg1, String arg2, boolean crop) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(jpegtranPath);
        cmd.add("-copy");
        cmd.add("all");
        cmd.add(arg1);
        cmd.add(arg2);
        File r = ImageUtils.deterministicTempFile(crop ? "crop" : "rot", "." + GalleryFileFilter.getExtension(filename), tmpDir, filename + arg1 + arg2);
        toDelete.add(r);
        cmd.add("-outfile");
        cmd.add(r.getPath());
        cmd.add(filename);
        int exitValue = ImageUtils.exec(cmd.toArray(new String[0]));
        if (exitValue != 0 && !jpegtranIgnoreErrorCode || !r.exists()) {
            if (exitValue != -1 || !r.exists()) {
                if (crop) {
                    Log.log(0, MODULE, "jpegtran doesn't seem to be working for cropping. Disabling");
                    ImageUtils.stopUsingJpegtranCrop();
                } else {
                    Log.log(0, MODULE, "jpegtran doesn't seem to be working. Disabling");
                    ImageUtils.stopUsingJpegtran();
                }
            }
            r = null;
        }
        return r;
    }

    public static ImageIcon rotateImageIcon(ImageIcon thumb, int angle, boolean flipped, Component c) {
        if (angle != 0 || flipped) {
            int height1;
            int width1;
            int width = thumb.getImage().getWidth(c);
            int height = thumb.getImage().getHeight(c);
            if (angle % 2 == 0) {
                width1 = width;
                height1 = height;
            } else {
                width1 = height;
                height1 = width;
            }
            Image vImg = c.createImage(width1, height1);
            Graphics2D g = (Graphics2D)vImg.getGraphics();
            AffineTransform transform = AffineTransform.getTranslateInstance(width / 2, height / 2);
            if (angle != 0) {
                transform.rotate((double)angle * Math.PI / 2.0);
            }
            if (flipped) {
                transform.scale(-1.0, 1.0);
            }
            transform.translate(-width1 / 2 - (angle == 3 ? width - width1 : 0) + (flipped ? width - width1 : 0) * (angle == 1 ? -1 : 1), -height1 / 2 - (angle == 1 ? height - height1 : 0));
            g.drawImage(thumb.getImage(), transform, c);
            thumb = new ImageIcon(vImg);
        }
        return thumb;
    }

    public static AffineTransform createTransform(Rectangle container, Rectangle contentResized, Dimension content, int angle, boolean flipped) {
        double scale = Math.sqrt(1.0f * (float)content.width * (float)content.height / (float)contentResized.width / (float)contentResized.height);
        AffineTransform transform = new AffineTransform();
        transform.translate(content.width / 2, content.height / 2);
        if (flipped) {
            transform.scale(-scale, scale);
        } else {
            transform.scale(scale, scale);
        }
        if (angle != 0) {
            transform.rotate((double)(-angle) * Math.PI / 2.0);
        }
        transform.translate(-container.width / 2, -container.height / 2);
        return transform;
    }

    public static LocalInfo getLocalFilenameForPicture(Picture p, boolean full) {
        URL u = null;
        Dimension d = null;
        if (!full && p.getSizeResized() == null) {
            return null;
        }
        if (full) {
            u = p.safeGetUrlFull();
            d = p.safeGetSizeFull();
        } else {
            u = p.getUrlResized();
            d = p.getSizeResized();
        }
        String name = u.getPath();
        int i = name.lastIndexOf(47);
        name = name.substring(i + 1);
        i = name.lastIndexOf(46);
        String ext = name.substring(i + 1);
        name = name.substring(0, i);
        String filename = name + "." + ext;
        return new LocalInfo(name, ext, filename, ImageUtils.deterministicTempFile("server", "." + ext, tmpDir, p.getAlbumOnServer().getName() + name + d), u, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File download(Picture p, Dimension d, StatusUpdate su, CancellableTransferListener tl) {
        String filename;
        File f;
        Object resizedInfo;
        if (!p.isOnline()) {
            return p.getSource();
        }
        URL pictureUrl = null;
        LocalInfo fullInfo = ImageUtils.getLocalFilenameForPicture(p, true);
        boolean stop = false;
        if (p.getSizeResized() != null) {
            resizedInfo = ImageUtils.getLocalFilenameForPicture(p, false);
            if ((d.width > p.getSizeResized().width || d.height > p.getSizeResized().height || fullInfo.file.exists()) && !GalleryRemote._().properties.getBooleanProperty("slideshowLowRez")) {
                pictureUrl = fullInfo.url;
                f = fullInfo.file;
                filename = fullInfo.filename;
            } else {
                pictureUrl = ((LocalInfo)resizedInfo).url;
                f = ((LocalInfo)resizedInfo).file;
                filename = ((LocalInfo)resizedInfo).filename;
            }
        } else {
            pictureUrl = fullInfo.url;
            f = fullInfo.file;
            filename = fullInfo.filename;
        }
        Log.log(3, MODULE, "Going to download " + pictureUrl);
        try {
            resizedInfo = p;
            synchronized (resizedInfo) {
                int l;
                if (f.exists()) {
                    Log.log(3, MODULE, filename + " already existed: no need to download it again");
                    return f;
                }
                long start = System.currentTimeMillis();
                URLConnection conn = pictureUrl.openConnection();
                int size = conn.getContentLength();
                su.startProgress(1, 0, size, GRI18n.getString(MODULE, "down.start", new Object[]{filename}), false);
                Log.log(3, MODULE, "Saving " + p + " to " + f.getPath());
                BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                byte[] buffer = new byte[2048];
                int dl = 0;
                long t = -1L;
                while (!stop && (l = in.read(buffer)) != -1) {
                    out.write(buffer, 0, l);
                    dl += l;
                    long now = System.currentTimeMillis();
                    if (t != -1L && now - t > 1000L) {
                        su.updateProgressValue(1, dl);
                        int speed = (int)((long)dl / (now - start) * 1000L / 1024L);
                        su.updateProgressStatus(1, GRI18n.getString(MODULE, "down.progress", new Object[]{filename, new Integer(dl / 1024), new Integer(size / 1024), new Integer(speed)}));
                        t = now;
                    }
                    if (t == -1L) {
                        t = now;
                    }
                    if (tl == null) continue;
                    stop = !tl.dataTransferred(dl, size, 0.0, p);
                }
                in.close();
                out.flush();
                out.close();
                if (stop) {
                    Log.log(3, MODULE, "Stopped downloading " + p);
                    f.delete();
                } else {
                    Log.log(3, MODULE, "Downloaded " + p + " (" + dl + ") in " + (System.currentTimeMillis() - start) / 1000L + "s");
                    toDelete.add(f);
                }
            }
            su.stopProgress(1, GRI18n.getString(MODULE, "down.end", new Object[]{filename}));
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
            f = null;
            su.stopProgress(1, "Downloading " + p + " failed");
        }
        if (stop) {
            return null;
        }
        return f;
    }

    public static Dimension getPictureDimension(Picture p) {
        if (p.isOnline()) {
            return null;
        }
        ImageInputStream iis = null;
        try {
            iis = ImageIO.createImageInputStream(p.getSource());
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return null;
            }
            ImageReader reader = iter.next();
            reader.setInput(iis, true, false);
            Dimension d = new Dimension(reader.getWidth(0), reader.getHeight(0));
            iis.close();
            reader.dispose();
            return d;
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
            return null;
        }
    }

    public static void purgeTemp() {
        Iterator it = toDelete.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            file.delete();
        }
    }

    public static Dimension getSizeKeepRatio(Dimension source, Dimension target, boolean noStretch) {
        if (noStretch && target.width > source.width && target.height > source.height) {
            return null;
        }
        Dimension result = new Dimension();
        float sourceRatio = Math.abs((float)source.width / (float)source.height);
        float targetRatio = Math.abs((float)target.width / (float)target.height);
        if (Math.abs(targetRatio) > Math.abs(sourceRatio)) {
            result.height = target.height;
            result.width = (int)((float)target.height * sourceRatio * (float)(target.height * target.width > 0 ? 1 : -1));
        } else {
            result.width = target.width;
            result.height = (int)((float)target.width / sourceRatio * (float)(target.height * target.width > 0 ? 1 : -1));
        }
        return result;
    }

    public static float getRatio(Dimension source, Dimension target) {
        float heightRatio = (float)target.height / (float)source.height;
        float widthRatio = (float)target.width / (float)source.width;
        if (heightRatio > widthRatio) {
            return widthRatio;
        }
        return heightRatio;
    }

    public static File deterministicTempFile(String prefix, String suffix, File directory, String hash) {
        if (directory == null) {
            directory = new File(System.getProperty("java.io.tmpdir"));
        }
        return new File(directory, prefix + hash.hashCode() + suffix);
    }

    public static String getMetadataCaptionString(String filename) {
        try {
            Class<?> c = Class.forName("com.gallery.GalleryRemote.util.ExifImageUtils");
            Method m = c.getMethod("getMetadataCaptionString", class$java$lang$String == null ? (class$java$lang$String = ImageUtils.class$("java.lang.String")) : class$java$lang$String);
            return (String)m.invoke(null, filename);
        }
        catch (Throwable e) {
            Log.logException(1, MODULE, e);
            return null;
        }
    }

    public static AngleFlip getExifTargetOrientation(String filename) {
        try {
            Class<?> c = Class.forName("com.gallery.GalleryRemote.util.ExifImageUtils");
            Method m = c.getMethod("getExifTargetOrientation", class$java$lang$String == null ? (class$java$lang$String = ImageUtils.class$("java.lang.String")) : class$java$lang$String);
            return (AngleFlip)m.invoke(null, filename);
        }
        catch (Throwable e) {
            Log.logException(1, MODULE, e);
            return null;
        }
    }

    public static List expandDirectories(List filesAndFolders) throws IOException {
        ArrayList<File> allFilesList = new ArrayList<File>();
        Iterator iter = filesAndFolders.iterator();
        while (iter.hasNext()) {
            File f = (File)iter.next();
            if (f.isDirectory()) {
                allFilesList.addAll(ImageUtils.listFilesRecursive(f));
                continue;
            }
            allFilesList.add(f);
        }
        return allFilesList;
    }

    public static List listFilesRecursive(File dir) throws IOException {
        ArrayList<File> ret = new ArrayList<File>();
        File[] fileArray = dir.listFiles();
        if (fileArray == null) {
            if (dir.isDirectory()) {
                throw new IOException("i/o exception listing directory: " + dir.getPath());
            }
            Log.log(0, MODULE, "assertion failed: listFilesRecursive called on a non-dir file");
            return ret;
        }
        List<File> files = Arrays.asList(fileArray);
        Iterator<File> iter = files.iterator();
        while (iter.hasNext()) {
            File f = iter.next();
            if (f.isDirectory()) {
                ret.addAll(ImageUtils.listFilesRecursive(f));
                continue;
            }
            ret.add(f);
        }
        return ret;
    }

    public static int exec(String cmdline) {
        Log.log(3, MODULE, "Executing " + cmdline);
        try {
            Process p = Runtime.getRuntime().exec(cmdline);
            return ImageUtils.pumpExec(p);
        }
        catch (InterruptedException e) {
            Log.logException(1, MODULE, e);
            return -1;
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
            return 1;
        }
    }

    public static int exec(String[] cmd) {
        Log.log(3, MODULE, "Executing " + Arrays.asList(cmd));
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            return ImageUtils.pumpExec(p);
        }
        catch (InterruptedException e) {
            Log.logException(1, MODULE, e);
            return -1;
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
            return 1;
        }
    }

    private static int pumpExec(Process p) throws InterruptedException, IOException {
        DataInputStream out = new DataInputStream(new BufferedInputStream(p.getInputStream()));
        DataInputStream err = new DataInputStream(new BufferedInputStream(p.getErrorStream()));
        int exitValue = p.waitFor();
        String line = null;
        while ((line = out.readLine()) != null) {
            Log.log(3, MODULE, "Out: " + line);
        }
        while ((line = err.readLine()) != null) {
            Log.log(3, MODULE, "Err: " + line);
        }
        Log.log(3, MODULE, "Returned with value " + exitValue);
        return exitValue;
    }

    public static void deferredTasks() {
        if (deferredStopUsingIM) {
            deferredStopUsingIM = false;
            ImageUtils.stopUsingIM();
        }
        if (deferredStopUsingJpegtran) {
            deferredStopUsingJpegtran = false;
            ImageUtils.stopUsingJpegtran();
        }
        if (deferredStopUsingJpegtranCrop) {
            deferredStopUsingJpegtranCrop = false;
            ImageUtils.stopUsingJpegtranCrop();
        }
    }

    static void stopUsingIM() {
        useIM = false;
        if (!GalleryRemote._().properties.getBooleanProperty("suppressWarningIM")) {
            if (GalleryRemote._().getMainFrame() != null && GalleryRemote._().getMainFrame().isVisible()) {
                UrlMessageDialog md = new UrlMessageDialog(GRI18n.getString(MODULE, "warningTextIM"), GRI18n.getString(MODULE, "warningUrlIM"), GRI18n.getString(MODULE, "warningUrlTextIM"));
                if (md.dontShow()) {
                    GalleryRemote._().properties.setBooleanProperty("suppressWarningIM", true);
                }
            } else {
                deferredStopUsingIM = true;
            }
        }
    }

    static boolean stopUsingJavaResize() {
        boolean useJavaResize;
        UrlMessageDialog md = new UrlMessageDialog(GRI18n.getString(MODULE, "warningTextJava"), null, null, GRI18n.getString(MODULE, "useJava"), GRI18n.getString(MODULE, "dontUseJava"));
        boolean bl = useJavaResize = md.getButtonChosen() == 1;
        if (md.dontShow()) {
            GalleryRemote._().properties.setBooleanProperty("suppressWarningJava", true);
            GalleryRemote._().properties.setBooleanProperty("useJavaResize", useJavaResize);
        }
        return !useJavaResize;
    }

    static void stopUsingJpegtran() {
        useJpegtran = false;
        if (!GalleryRemote._().properties.getBooleanProperty("suppressWarningJpegtran")) {
            if (GalleryRemote._().getMainFrame() != null && GalleryRemote._().getMainFrame().isVisible()) {
                UrlMessageDialog md = new UrlMessageDialog(GRI18n.getString(MODULE, "warningTextJpegtran"), GRI18n.getString(MODULE, "warningUrlJpegtran"), GRI18n.getString(MODULE, "warningUrlTextJpegtran"));
                if (md.dontShow()) {
                    GalleryRemote._().properties.setBooleanProperty("suppressWarningJpegtran", true);
                }
            } else {
                deferredStopUsingJpegtran = true;
            }
        }
    }

    static void stopUsingJpegtranCrop() {
        useJpegtranCrop = false;
        if (!GalleryRemote._().properties.getBooleanProperty("suppressWarningJpegtranCrop")) {
            if (GalleryRemote._().getMainFrame() != null && GalleryRemote._().getMainFrame().isVisible()) {
                UrlMessageDialog md = new UrlMessageDialog(GRI18n.getString(MODULE, "warningTextJpegtranCrop"), GRI18n.getString(MODULE, "warningUrlJpegtranCrop"), GRI18n.getString(MODULE, "warningUrlTextJpegtranCrop"));
                if (md.dontShow()) {
                    GalleryRemote._().properties.setBooleanProperty("suppressWarningJpegtranCrop", true);
                }
            } else {
                deferredStopUsingJpegtranCrop = true;
            }
        }
    }

    public static void displayMetadata(Node root) {
        ImageUtils.displayMetadata(root, 0);
    }

    static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
    }

    static void displayMetadata(Node node, int level) {
        Node child;
        ImageUtils.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            System.out.println(">");
            while (child != null) {
                ImageUtils.displayMetadata(child, level + 1);
                child = child.getNextSibling();
            }
            ImageUtils.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GalleryProperties p;
        PropertiesFile pt;
        toDelete = new ArrayList();
        totalTime = 0L;
        totalIter = 0;
        useIM = false;
        imPath = null;
        jpegQuality = 75;
        imIgnoreErrorCode = false;
        useJpegtran = false;
        useJpegtranCrop = false;
        jpegtranPath = null;
        jpegtranIgnoreErrorCode = false;
        tmpDir = null;
        filterName = new String[3];
        format = new String[3];
        defaultThumbnail = null;
        unrecognizedThumbnail = null;
        deferredStopUsingIM = false;
        deferredStopUsingJpegtran = false;
        deferredStopUsingJpegtranCrop = false;
        tmpDir = new File(System.getProperty("java.io.tmpdir"), "thumbs");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        Log.log(2, MODULE, "tmpDir: " + tmpDir.getPath());
        try {
            pt = null;
            pt = new File("imagemagick/im.properties").exists() ? new PropertiesFile("imagemagick/im") : new PropertiesFile("im");
            pt.read();
            p = new GalleryProperties(pt);
            p.copyProperties(GalleryRemote._().properties);
            useIM = p.getBooleanProperty("im.enabled");
            Log.log(2, MODULE, "useIM: " + useIM);
            if (useIM) {
                imPath = p.getProperty("im.convertPath");
                Log.log(2, MODULE, "imPath: " + imPath);
                imIgnoreErrorCode = p.getBooleanProperty("im.ignoreErrorCode", imIgnoreErrorCode);
                Log.log(2, MODULE, "imIgnoreErrorCode: " + imIgnoreErrorCode);
                if (imPath.indexOf("/") == -1 && imPath.indexOf("\\") == -1) {
                    Log.log(0, MODULE, "ImageMagick path is not fully qualified, presence won't be tested until later");
                } else if (!new File(imPath).exists()) {
                    Log.log(0, MODULE, "Can't find ImageMagick Convert at the above path");
                    ImageUtils.stopUsingIM();
                }
            }
            if (useIM) {
                ImageUtils.filterName[0] = p.getProperty("im.thumbnailResizeFilter");
                ImageUtils.filterName[1] = p.getProperty("im.previewResizeFilter");
                ImageUtils.filterName[2] = p.getProperty("im.uploadResizeFilter");
                if (filterName[2] == null) {
                    ImageUtils.filterName[2] = filterName[1];
                }
                ImageUtils.format[0] = p.getProperty("im.thumbnailResizeFormat", "gif");
                ImageUtils.format[1] = p.getProperty("im.previewResizeFormat", "jpg");
                ImageUtils.format[2] = null;
            }
            jpegQuality = p.getIntProperty("im.jpegQuality", jpegQuality);
        }
        catch (Exception e) {
            Log.logException(0, MODULE, e);
            ImageUtils.stopUsingIM();
        }
        defaultThumbnail = ImageUtils.loadJava((class$com$gallery$GalleryRemote$util$ImageUtils == null ? (class$com$gallery$GalleryRemote$util$ImageUtils = ImageUtils.class$("com.gallery.GalleryRemote.util.ImageUtils")) : class$com$gallery$GalleryRemote$util$ImageUtils).getResource("/default.gif"), GalleryRemote._().properties.getThumbnailSize(), true);
        unrecognizedThumbnail = ImageUtils.loadJava((class$com$gallery$GalleryRemote$util$ImageUtils == null ? (class$com$gallery$GalleryRemote$util$ImageUtils = ImageUtils.class$("com.gallery.GalleryRemote.util.ImageUtils")) : class$com$gallery$GalleryRemote$util$ImageUtils).getResource("/default.gif"), GalleryRemote._().properties.getThumbnailSize(), true);
        try {
            pt = null;
            pt = new File("jpegtran/jpegtran.properties").exists() ? new PropertiesFile("jpegtran/jpegtran") : new PropertiesFile("jpegtran");
            pt.read();
            p = new GalleryProperties(pt);
            p.copyProperties(GalleryRemote._().properties);
            useJpegtran = p.getBooleanProperty("jp.enabled");
            useJpegtran = p.getBooleanProperty("jp.crop.enabled");
            Log.log(2, MODULE, "useJpegtran: " + useJpegtran);
            if (useJpegtran) {
                jpegtranPath = p.getProperty("jp.path");
                Log.log(2, MODULE, "jpegtranPath: " + jpegtranPath);
                jpegtranIgnoreErrorCode = p.getBooleanProperty("jp.ignoreErrorCode", jpegtranIgnoreErrorCode);
                Log.log(2, MODULE, "jpegtranIgnoreErrorCode: " + jpegtranIgnoreErrorCode);
                if (jpegtranPath.indexOf("/") == -1 && jpegtranPath.indexOf("\\") == -1) {
                    Log.log(0, MODULE, "jpegtran path is not fully qualified, presence won't be tested until later");
                }
                if (!new File(jpegtranPath).exists()) {
                    Log.log(0, MODULE, "Can't find jpegtran at the above path");
                    ImageUtils.stopUsingJpegtran();
                }
            }
        }
        catch (Exception e) {
            Log.logException(0, MODULE, e);
            ImageUtils.stopUsingJpegtran();
        }
    }

    public static class AngleFlip {
        public int angle = 0;
        public boolean flip = false;

        public AngleFlip(int angle, boolean flip) {
            this.angle = angle;
            this.flip = flip;
        }
    }

    static class LocalInfo {
        String name;
        String ext;
        String filename;
        File file;
        URL url;
        Dimension size;

        public LocalInfo(String name, String ext, String filename, File file, URL url, Dimension size) {
            this.name = name;
            this.ext = ext;
            this.filename = filename;
            this.file = file;
            this.url = url;
            this.size = size;
        }
    }
}

