/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.gallery.GalleryRemote.GalleryFileFilter;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.io.File;
import java.io.FileNotFoundException;

public class ExifImageUtils {
    public static final String MODULE = "ExifUtils";
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;
    static /* synthetic */ Class class$com$drew$metadata$iptc$IptcDirectory;

    public static String getMetadataCaptionString(String filename) {
        if (GalleryFileFilter.canManipulateJpeg(filename)) {
            File jpegFile = new File(filename);
            try {
                Metadata metadata = JpegMetadataReader.readMetadata((File)jpegFile);
                Directory exifDirectory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifImageUtils.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
                String exifDescription = exifDirectory.getString(270);
                if (exifDescription != null) {
                    Log.log(3, MODULE, "Picture " + filename + " EXIF DESCRIPTION: " + exifDescription);
                    return exifDescription.trim();
                }
                Log.log(3, MODULE, "Picture " + filename + " has no EXIF DESCRIPTION tag");
                Directory iptcDirectory = metadata.getDirectory(class$com$drew$metadata$iptc$IptcDirectory == null ? (class$com$drew$metadata$iptc$IptcDirectory = ExifImageUtils.class$("com.drew.metadata.iptc.IptcDirectory")) : class$com$drew$metadata$iptc$IptcDirectory);
                String iptcDescription = iptcDirectory.getString(632);
                if (iptcDescription != null) {
                    Log.log(3, MODULE, "Picture " + filename + " IPTC DESCRIPTION: " + iptcDescription);
                    return iptcDescription.trim();
                }
                Log.log(3, MODULE, "Picture " + filename + " has no IPTC DESCRIPTION tag");
                return null;
            }
            catch (FileNotFoundException e) {
                Log.logException(1, MODULE, e);
                return null;
            }
            catch (JpegProcessingException e) {
                Log.logException(1, MODULE, e);
                return null;
            }
        }
        return null;
    }

    public static ImageUtils.AngleFlip getExifTargetOrientation(String filename) {
        if (GalleryFileFilter.canManipulateJpeg(filename)) {
            File jpegFile = new File(filename);
            try {
                Metadata metadata = JpegMetadataReader.readMetadata((File)jpegFile);
                Directory exifDirectory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifImageUtils.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
                String orientation = exifDirectory.getString(274);
                if (orientation == null) {
                    Log.log(3, MODULE, "Picture " + filename + " has no EXIF ORIENTATION tag");
                    return null;
                }
                Log.log(3, MODULE, "Picture " + filename + " EXIF ORIENTATION: " + orientation);
                int or = 0;
                ImageUtils.AngleFlip af = null;
                try {
                    or = Integer.parseInt(orientation);
                }
                catch (NumberFormatException e) {
                    Log.log(1, MODULE, "Couldn't parse orientation " + orientation + " for " + filename);
                    return null;
                }
                switch (or) {
                    case 1: {
                        af = new ImageUtils.AngleFlip(0, false);
                        break;
                    }
                    case 2: {
                        af = new ImageUtils.AngleFlip(0, true);
                        break;
                    }
                    case 3: {
                        af = new ImageUtils.AngleFlip(2, false);
                        break;
                    }
                    case 4: {
                        af = new ImageUtils.AngleFlip(2, true);
                        break;
                    }
                    case 5: {
                        af = new ImageUtils.AngleFlip(1, true);
                        break;
                    }
                    case 6: {
                        af = new ImageUtils.AngleFlip(1, false);
                        break;
                    }
                    case 7: {
                        af = new ImageUtils.AngleFlip(3, true);
                        break;
                    }
                    case 8: {
                        af = new ImageUtils.AngleFlip(3, false);
                        break;
                    }
                    default: {
                        Log.log(1, MODULE, "Couldn't parse orientation " + orientation + " for " + filename);
                        return null;
                    }
                }
                Log.log(3, MODULE, "Angle: " + af.angle + " Flipped: " + af.flip);
                return af;
            }
            catch (FileNotFoundException e) {
                Log.logException(1, MODULE, e);
                return null;
            }
            catch (JpegProcessingException e) {
                Log.logException(1, MODULE, e);
                return null;
            }
        }
        return null;
    }

    public static void resetExifOrientation(String filename) {
        if (GalleryFileFilter.canManipulateJpeg(filename)) {
            File jpegFile = new File(filename);
            try {
                Metadata metadata = JpegMetadataReader.readMetadata((File)jpegFile);
                Directory exifDirectory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifImageUtils.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
                exifDirectory.setString(274, "1");
            }
            catch (FileNotFoundException e) {
                Log.logException(1, MODULE, e);
            }
            catch (JpegProcessingException e) {
                Log.logException(1, MODULE, e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

