/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.prefs;

import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PreferencePanel;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class UploadPanel
extends PreferencePanel
implements ActionListener,
PreferenceNames {
    public static final String MODULE = "UploadPa";
    JLabel icon = new JLabel(GRI18n.getString("UploadPa", "icon"));
    JPanel jPanel1 = new JPanel();
    JComboBox resizeTo = new JComboBox(defaultSizes);
    JPanel jPanel2 = new JPanel();
    JRadioButton setCaptionNone = new JRadioButton();
    JRadioButton setCaptionWithFilename = new JRadioButton();
    JCheckBox captionStripExtension = new JCheckBox();
    JRadioButton setCaptionWithMetadata = new JRadioButton();
    ButtonGroup buttonGroup2 = new ButtonGroup();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JCheckBox resizeBeforeUpload = new JCheckBox();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JRadioButton resizeToDefault = new JRadioButton();
    JRadioButton resizeToForce = new JRadioButton();
    JCheckBox htmlEscapeCaptionsNot = new JCheckBox();
    JCheckBox exifAutorotate = new JCheckBox();
    public static Vector defaultSizes = new Vector();

    public JLabel getIcon() {
        return this.icon;
    }

    public void readProperties(PropertiesFile props) {
        this.resizeBeforeUpload.setSelected(props.getBooleanProperty("resizeBeforeUpload"));
        int size = props.getIntDimensionProperty("resizeTo");
        if (size == 0) {
            this.resizeToDefault.setSelected(true);
        } else {
            this.resizeToForce.setSelected(true);
        }
        UploadPanel.setupComboValue(size, this.resizeTo);
        this.setCaptionNone.setSelected(props.getBooleanProperty("setCaptionsNone"));
        this.setCaptionWithFilename.setSelected(props.getBooleanProperty("setCaptionsWithFilenames"));
        this.captionStripExtension.setSelected(props.getBooleanProperty("captionStripExtension"));
        this.setCaptionWithMetadata.setSelected(props.getBooleanProperty("setCaptionsWithMetadataComment"));
        this.htmlEscapeCaptionsNot.setSelected(!props.getBooleanProperty("htmlEscapeCaptions"));
        this.exifAutorotate.setSelected(props.getBooleanProperty("exifAutorotate"));
        this.resetUIState();
    }

    public static void setupComboValue(int size, JComboBox resizeTo) {
        MutableComboBoxModel model = (MutableComboBoxModel)resizeTo.getModel();
        boolean found = false;
        for (int i = 0; i < model.getSize(); ++i) {
            Object item = model.getElementAt(i);
            if ((!(item instanceof ResizeSize) || ((ResizeSize)item).size != size) && !String.valueOf(size).equals(item)) continue;
            resizeTo.setSelectedIndex(i);
            found = true;
            break;
        }
        if (!found) {
            String s = size == 0 ? "" : String.valueOf(size);
            resizeTo.addItem(s);
            resizeTo.setSelectedItem(s);
        }
    }

    public void writeProperties(PropertiesFile props) {
        props.setBooleanProperty("resizeBeforeUpload", this.resizeBeforeUpload.isSelected());
        if (this.resizeBeforeUpload.isSelected()) {
            int i = -1;
            if (this.resizeToDefault.isSelected()) {
                i = 0;
            } else {
                try {
                    i = Integer.parseInt(this.resizeTo.getSelectedItem().toString());
                }
                catch (Exception e) {
                    Log.log(1, MODULE, "resizeTo size should be integer numbers");
                }
            }
            if (i != -1) {
                props.setIntDimensionProperty("resizeTo", i);
            }
        }
        props.setBooleanProperty("setCaptionsNone", this.setCaptionNone.isSelected());
        props.setBooleanProperty("setCaptionsWithFilenames", this.setCaptionWithFilename.isSelected());
        props.setBooleanProperty("captionStripExtension", this.captionStripExtension.isSelected());
        props.setBooleanProperty("setCaptionsWithMetadataComment", this.setCaptionWithMetadata.isSelected());
        props.setBooleanProperty("htmlEscapeCaptions", !this.htmlEscapeCaptionsNot.isSelected());
        props.setBooleanProperty("exifAutorotate", this.exifAutorotate.isSelected());
    }

    public void resetUIState() {
        if (this.resizeBeforeUpload.isSelected()) {
            this.resizeToDefault.setEnabled(true);
            this.resizeToForce.setEnabled(true);
            if (this.resizeToForce.isSelected()) {
                this.resizeTo.setEnabled(true);
                this.resizeTo.setBackground(UIManager.getColor("TextField.background"));
            } else {
                this.resizeTo.setEnabled(false);
                this.resizeTo.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            }
        } else {
            this.resizeToDefault.setEnabled(false);
            this.resizeToForce.setEnabled(false);
            this.resizeTo.setEnabled(false);
            this.resizeTo.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        }
        if (this.setCaptionWithFilename.isSelected()) {
            this.captionStripExtension.setEnabled(true);
        } else {
            this.captionStripExtension.setEnabled(false);
        }
    }

    public void buildUI() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.resizeTo.setEditable(true);
        this.resizeTo.setToolTipText(GRI18n.getString(MODULE, "res2W"));
        this.resizeTo.setRenderer(new SizeListRenderer());
        this.jPanel1.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString(MODULE, "res_rot")));
        this.jPanel2.setLayout(new GridBagLayout());
        this.setCaptionNone.setToolTipText(GRI18n.getString(MODULE, "captNoneTip"));
        this.setCaptionNone.setText(GRI18n.getString(MODULE, "captNone"));
        this.setCaptionWithFilename.setToolTipText(GRI18n.getString(MODULE, "captTip"));
        this.setCaptionWithFilename.setText(GRI18n.getString(MODULE, "capt"));
        this.captionStripExtension.setToolTipText(GRI18n.getString(MODULE, "stripExtTip"));
        this.captionStripExtension.setText(GRI18n.getString(MODULE, "stripExt"));
        this.setCaptionWithMetadata.setToolTipText(GRI18n.getString(MODULE, "captMetadataTip"));
        this.setCaptionWithMetadata.setText(GRI18n.getString(MODULE, "captMetadata"));
        this.jPanel2.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString(MODULE, "captions")));
        this.resizeBeforeUpload.setToolTipText(GRI18n.getString(MODULE, "resBfrUpldTip"));
        this.resizeBeforeUpload.setText(GRI18n.getString(MODULE, "resBfrUpld"));
        this.resizeToDefault.setToolTipText(GRI18n.getString(MODULE, "res2Def"));
        this.resizeToDefault.setText(GRI18n.getString(MODULE, "res2Def"));
        this.resizeToForce.setToolTipText(GRI18n.getString(MODULE, "res2FrcTip"));
        this.resizeToForce.setText(GRI18n.getString(MODULE, "res2Frc"));
        this.htmlEscapeCaptionsNot.setToolTipText(GRI18n.getString(MODULE, "escCaptTip"));
        this.htmlEscapeCaptionsNot.setText(GRI18n.getString(MODULE, "escCapt"));
        this.exifAutorotate.setToolTipText(GRI18n.getString(MODULE, "autoRotTip"));
        this.exifAutorotate.setText(GRI18n.getString(MODULE, "autoRot"));
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.jPanel1.add((Component)this.resizeTo, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.resizeToDefault, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.resizeToForce, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.exifAutorotate, new GridBagConstraints(0, 3, 5, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel6, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.resizeBeforeUpload, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.jPanel2.add((Component)this.setCaptionNone, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.setCaptionWithFilename, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.captionStripExtension, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.setCaptionWithMetadata, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.htmlEscapeCaptionsNot, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel7, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonGroup1.add(this.resizeToDefault);
        this.buttonGroup1.add(this.resizeToForce);
        this.buttonGroup2.add(this.setCaptionNone);
        this.buttonGroup2.add(this.setCaptionWithFilename);
        this.buttonGroup2.add(this.setCaptionWithMetadata);
        this.resizeBeforeUpload.addActionListener(this);
        this.resizeToForce.addActionListener(this);
        this.resizeToDefault.addActionListener(this);
        this.setCaptionNone.addActionListener(this);
        this.setCaptionWithFilename.addActionListener(this);
        this.setCaptionWithMetadata.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        this.resetUIState();
    }

    static {
        defaultSizes.add(new ResizeSize(400, "400"));
        defaultSizes.add(new ResizeSize(500, "500"));
        defaultSizes.add(new ResizeSize(600, "600"));
        defaultSizes.add(new ResizeSize(640, "640"));
        defaultSizes.add(new ResizeSize(800, "800"));
        defaultSizes.add(new ResizeSize(1024, "1024"));
        defaultSizes.add(new ResizeSize(1280, "1280 (1 MPix)"));
        defaultSizes.add(new ResizeSize(1600, "1600 (2 MPix)"));
        defaultSizes.add(new ResizeSize(2048, "2048 (3 MPix)"));
    }

    public static class SizeListRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ResizeSize) {
                this.setText(((ResizeSize)value).desc);
            }
            return this;
        }
    }

    static class ResizeSize {
        public int size;
        public String desc;

        public ResizeSize(int size, String desc) {
            this.size = size;
            this.desc = desc;
        }

        public String toString() {
            return String.valueOf(this.size);
        }
    }
}

