/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.prefs;

import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.prefs.GalleryProperties;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;

public class PropertiesFile
extends GalleryProperties {
    public static final String MODULE = "PropsFile";
    protected boolean read = false;
    protected boolean written = false;
    protected String mFilename;
    protected boolean readOnly = false;
    protected boolean alreadyWarned = false;
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static /* synthetic */ Class class$com$gallery$GalleryRemote$prefs$PropertiesFile;

    public PropertiesFile(PropertiesFile p) {
        super(p);
    }

    public PropertiesFile(String name) {
        this.setFilename(name);
    }

    public PropertiesFile(PropertiesFile p, String name) {
        super(p);
        this.setFilename(name);
    }

    public Object setProperty(String name, String value) {
        if (this.readOnly && this.defaults != null) {
            this.defaults.setProperty(name, value);
        }
        this.written = false;
        if (value == null) {
            return this.remove(name);
        }
        return super.setProperty(name, value);
    }

    public synchronized void setFilename(String name) {
        this.mFilename = !name.endsWith(".lax") && !name.endsWith(".properties") ? name + ".properties" : name;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public String getProperty(String name) {
        this.checkRead();
        return super.getProperty(name);
    }

    public Enumeration propertyNames() {
        this.checkRead();
        return super.propertyNames();
    }

    public boolean isOverridden(String name) {
        return this.readOnly && this.get(name) != null;
    }

    protected void checkRead() {
        block4: {
            if (this.defaults != null && this.defaults instanceof PropertiesFile) {
                ((PropertiesFile)this.defaults).checkRead();
            }
            if (!this.read) {
                try {
                    this.read();
                }
                catch (FileNotFoundException e) {
                    if (this.alreadyWarned) break block4;
                    Log.logException(1, MODULE, e);
                    this.alreadyWarned = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void read() throws FileNotFoundException {
        if (this.mFilename != null) {
            InputStream fileIn = null;
            try {
                if (this.mFilename.indexOf("/") == -1) {
                    if (!this.alreadyWarned) {
                        Log.log(3, MODULE, "Trying to find " + this.mFilename + " in Classpath");
                    }
                    fileIn = (class$com$gallery$GalleryRemote$prefs$PropertiesFile == null ? (class$com$gallery$GalleryRemote$prefs$PropertiesFile = PropertiesFile.class$("com.gallery.GalleryRemote.prefs.PropertiesFile")) : class$com$gallery$GalleryRemote$prefs$PropertiesFile).getResourceAsStream("/" + this.mFilename);
                }
                if (fileIn == null) {
                    if (!this.alreadyWarned) {
                        Log.log(3, MODULE, "Trying to find " + this.mFilename + " in Current Working Dir");
                    }
                    fileIn = new FileInputStream(this.mFilename);
                }
                this.load(fileIn);
            }
            catch (FileNotFoundException fnf) {
                throw fnf;
            }
            catch (IOException e) {
            }
            finally {
                try {
                    fileIn.close();
                }
                catch (IOException e2) {
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        this.read = true;
        this.written = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write() {
        if (this.readOnly && this.defaults != null && this.defaults instanceof PropertiesFile) {
            ((PropertiesFile)this.defaults).write();
            this.written = true;
        }
        if (!this.written && !this.readOnly) {
            FileOutputStream fileOut = null;
            try {
                fileOut = new FileOutputStream(this.mFilename);
                this.store(fileOut, null);
            }
            catch (IOException e) {
                Log.logException(1, MODULE, e);
            }
            finally {
                try {
                    fileOut.close();
                }
                catch (IOException e2) {
                }
                catch (NullPointerException nullPointerException) {}
            }
            this.written = true;
        }
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            PropertiesFile.writeln(awriter, "#" + header);
        }
        PropertiesFile.writeln(awriter, "#" + new Date().toString());
        ArrayList<Object> v = new ArrayList<Object>(this.keySet());
        Collections.sort(v);
        Iterator<Object> e = v.iterator();
        while (e.hasNext()) {
            String key = (String)e.next();
            String val = (String)this.get(key);
            key = this.saveConvert(key, true);
            val = this.saveConvert(val, false);
            PropertiesFile.writeln(awriter, key + "=" + val);
        }
        awriter.flush();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertiesFile.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertiesFile.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertiesFile.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertiesFile.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

