/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.CancellableTransferListener;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PreviewFrame
extends JFrame
implements PreferenceNames {
    public static final String MODULE = "PreviewFrame";
    SmartHashtable imageIcons = new SmartHashtable();
    ImageIcon currentImage = null;
    Picture loadPicture = null;
    Picture currentPicture = null;
    PreviewLoader previewLoader = new PreviewLoader();
    int previewCacheSize = 10;
    boolean ignoreIMFailure = false;
    CancellableTransferListener listener = null;
    Rectangle imageRect = null;
    public static final Color darkGray = new Color(64, 64, 64, 128);

    public void initComponents() {
        this.setTitle(GRI18n.getString(MODULE, "title"));
        this.setIconImage(GalleryRemote._().getMainFrame().getIconImage());
        this.setBounds(GalleryRemote._().properties.getPreviewBounds());
        this.setContentPane(new ImageContentPane());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PreviewFrame.this.flushMemory();
            }
        });
        this.previewCacheSize = GalleryRemote._().properties.getIntProperty("previewCacheSize");
        CropGlassPane glass = new CropGlassPane();
        this.setGlassPane(glass);
        glass.setVisible(true);
    }

    public void hide() {
        this.flushMemory();
        super.hide();
        this.displayPicture(null, true);
    }

    public void flushMemory() {
        this.imageIcons.clear();
        if (this.currentPicture != null) {
            this.loadPicture = null;
            this.currentImage = null;
            this.displayPicture(this.currentPicture, true);
            this.currentPicture = null;
        }
    }

    public void displayPicture(Picture picture, boolean async) {
        if (picture == null) {
            this.loadPicture = null;
            this.imageRect = null;
            this.pictureReady(null, null);
        } else if (picture != this.loadPicture) {
            this.loadPicture = picture;
            ImageIcon r = (ImageIcon)this.imageIcons.get(picture);
            if (r != null) {
                Log.log(3, MODULE, "Cache hit: " + picture);
                this.pictureReady(r, picture);
            } else {
                Log.log(3, MODULE, "Cache miss: " + picture);
                if (async) {
                    this.previewLoader.loadPreview(picture, true);
                } else {
                    ImageIcon sizedIcon = this.getSizedIconForce(picture);
                    if (sizedIcon != null) {
                        this.pictureReady(sizedIcon, picture);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageIcon getSizedIconForce(Picture picture) {
        ImageIcon r = (ImageIcon)this.imageIcons.get(picture);
        if (r != null) return r;
        Picture picture2 = picture;
        synchronized (picture2) {
            if (picture.isOnline()) {
                this.pictureStartDownload(picture);
                File f = ImageUtils.download(picture, this.getRootPane().getSize(), GalleryRemote._().getCore().getMainStatusUpdate(), this.listener);
                this.pictureStartProcessing(picture);
                if (f == null) return null;
                r = ImageUtils.load(f.getPath(), this.getRootPane().getSize(), 1, this.ignoreIMFailure);
            } else {
                this.pictureStartProcessing(picture);
                r = ImageUtils.load(picture.getSource().getPath(), this.getRootPane().getSize(), 1, this.ignoreIMFailure);
            }
            Log.log(3, MODULE, "Adding to cache: " + picture);
            this.imageIcons.put(picture, r);
            return r;
        }
    }

    public void pictureReady(ImageIcon image, Picture picture) {
        this.currentImage = image;
        this.currentPicture = picture;
        this.repaint();
    }

    public void pictureStartDownload(Picture picture) {
    }

    public void pictureStartProcessing(Picture picture) {
    }

    public static void paintOutline(Graphics g, String s, int textX, int textY) {
        g.setColor(darkGray);
        g.drawString(s, textX + 1, textY + 1);
        g.drawString(s, textX, textY + 1);
        g.drawString(s, textX - 1, textY + 1);
        g.drawString(s, textX + 1, textY);
        g.drawString(s, textX, textY);
        g.drawString(s, textX - 1, textY);
        g.drawString(s, textX + 1, textY - 1);
        g.drawString(s, textX, textY - 1);
        g.drawString(s, textX - 1, textY - 1);
        g.setColor(Color.white);
        g.drawString(s, textX, textY);
    }

    class CropGlassPane
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        Color background = new Color(100, 100, 100, 150);
        boolean inDrag;
        Point2D start = null;
        Point2D end = null;
        Rectangle oldRect = null;
        boolean centerMode = false;

        public CropGlassPane() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void paint(Graphics g) {
            Rectangle ct;
            this.oldRect = null;
            if (PreviewFrame.this.currentPicture == null || PreviewFrame.this.currentImage == null || PreviewFrame.this.currentPicture.isOnline()) {
                return;
            }
            if (PreviewFrame.this.imageRect != null && this.start != null && this.end != null && (ct = PreviewFrame.this.currentPicture.getCropTo()) != null) {
                AffineTransform t = ImageUtils.createTransform(this.getBounds(), PreviewFrame.this.imageRect, PreviewFrame.this.currentPicture.getDimension(), PreviewFrame.this.currentPicture.getAngle(), PreviewFrame.this.currentPicture.isFlipped());
                Rectangle r = null;
                try {
                    r = this.getRect(t.inverseTransform(ct.getLocation(), null), t.inverseTransform(new Point(ct.x + ct.width, ct.y + ct.height), null));
                    g.setColor(this.background);
                    g.setClip(PreviewFrame.this.imageRect);
                    g.fillRect(0, 0, r.x, this.getHeight());
                    g.fillRect(r.x, 0, this.getWidth() - r.x, r.y);
                    g.fillRect(r.x, r.y + r.height, this.getWidth() - r.x, this.getHeight() - r.y - r.height);
                    g.fillRect(r.x + r.width, r.y, this.getWidth() - r.x - r.width, r.height);
                    g.setColor(Color.black);
                    g.drawRect(r.x, r.y, r.width, r.height);
                    g.setClip(null);
                }
                catch (NoninvertibleTransformException e) {
                    Log.logException(1, PreviewFrame.MODULE, e);
                }
            }
            this.paintInfo(g);
        }

        public void paintInfo(Graphics g) {
            String message = null;
            Rectangle cropTo = PreviewFrame.this.currentPicture.getCropTo();
            message = !this.inDrag ? (cropTo == null ? GRI18n.getString(PreviewFrame.MODULE, "noCrop") : GRI18n.getString(PreviewFrame.MODULE, "crop")) : GRI18n.getString(PreviewFrame.MODULE, "inCrop");
            g.setFont(g.getFont());
            PreviewFrame.paintOutline(g, message, 5, this.getBounds().height - 5);
        }

        public void updateRect() {
            Graphics g = this.getGraphics();
            if (this.oldRect != null) {
                g.setXORMode(Color.cyan);
                g.drawRect(this.oldRect.x, this.oldRect.y, this.oldRect.width, this.oldRect.height);
            }
            if (this.inDrag) {
                g.setXORMode(Color.cyan);
                this.oldRect = this.getRect(this.start, this.end);
                g.drawRect(this.oldRect.x, this.oldRect.y, this.oldRect.width, this.oldRect.height);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (PreviewFrame.this.currentPicture == null) {
                return;
            }
            PreviewFrame.this.currentPicture.setCropTo(null);
            this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (PreviewFrame.this.currentPicture == null || PreviewFrame.this.imageRect == null || PreviewFrame.this.currentPicture.isOnline()) {
                return;
            }
            this.inDrag = true;
            this.start = this.validate(e.getPoint());
            PreviewFrame.this.currentPicture.setCropTo(null);
            this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            this.inDrag = false;
            this.centerMode = false;
            if (PreviewFrame.this.currentPicture == null || this.oldRect == null || PreviewFrame.this.currentPicture.isOnline()) {
                return;
            }
            AffineTransform t = ImageUtils.createTransform(this.getBounds(), PreviewFrame.this.imageRect, PreviewFrame.this.currentPicture.getDimension(), PreviewFrame.this.currentPicture.getAngle(), PreviewFrame.this.currentPicture.isFlipped());
            Rectangle tmpRect = new Rectangle();
            tmpRect.setFrameFromDiagonal(t.transform(this.oldRect.getLocation(), null), t.transform(new Point(this.oldRect.x + this.oldRect.width, this.oldRect.y + this.oldRect.height), null));
            PreviewFrame.this.currentPicture.setCropTo(tmpRect);
            this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            if (PreviewFrame.this.imageRect == null) {
                return;
            }
            Point2D p = this.validate(e.getPoint());
            int modifiers = e.getModifiersEx();
            double px = p.getX();
            double py = p.getY();
            if ((modifiers & 0x40) == 64) {
                double dx = px - this.start.getX();
                double dy = py - this.start.getY();
                if (Math.abs(dx) < Math.abs(dy)) {
                    py = this.start.getY() + (dy * dx > 0.0 ? dx : -dx);
                } else {
                    px = this.start.getX() + (dx * dy > 0.0 ? dy : -dy);
                }
                p.setLocation(px, py);
            } else if ((modifiers & 0x80) == 128) {
                int dx = (int)(px - this.start.getX());
                int dy = (int)(py - this.start.getY());
                int sameOrientation = (Math.abs(dx) - Math.abs(dy)) * (PreviewFrame.this.imageRect.width - PreviewFrame.this.imageRect.height);
                Dimension target = sameOrientation > 0 ? new Dimension(dx, dy) : new Dimension(dy, dx);
                Dimension d = ImageUtils.getSizeKeepRatio(PreviewFrame.this.imageRect.getSize(), target, false);
                if (sameOrientation > 0) {
                    p.setLocation(this.start.getX() + (double)d.width, this.start.getY() + (double)d.height);
                } else {
                    p.setLocation(this.start.getX() + (double)d.height, this.start.getY() + (double)d.width);
                }
            }
            this.centerMode = (modifiers & 0x200) == 512;
            this.end = this.validate(p);
            this.updateRect();
        }

        public void mouseMoved(MouseEvent e) {
        }

        public Rectangle getRect(Point2D p1, Point2D p2) {
            Rectangle r = new Rectangle();
            if (this.centerMode) {
                r.setFrameFromCenter(p1, p2);
                p1 = new Point2D.Double(r.getMinX(), r.getMinY());
                p2 = new Point2D.Double(r.getMaxX(), r.getMaxY());
            }
            r.setFrameFromDiagonal(this.validate(p1), this.validate(p2));
            return r;
        }

        public Point2D validate(Point2D p) {
            double px = p.getX();
            double py = p.getY();
            if (px < (double)PreviewFrame.this.imageRect.x) {
                px = PreviewFrame.this.imageRect.x;
            }
            if (py < (double)PreviewFrame.this.imageRect.y) {
                py = PreviewFrame.this.imageRect.y;
            }
            if (px > (double)(PreviewFrame.this.imageRect.x + PreviewFrame.this.imageRect.width - 1)) {
                px = PreviewFrame.this.imageRect.x + PreviewFrame.this.imageRect.width - 1;
            }
            if (py > (double)(PreviewFrame.this.imageRect.y + PreviewFrame.this.imageRect.height - 1)) {
                py = PreviewFrame.this.imageRect.y + PreviewFrame.this.imageRect.height - 1;
            }
            return new Point2D.Double(px, py);
        }
    }

    public class SmartHashtable
    extends HashMap {
        ArrayList touchOrder = new ArrayList();

        public Object put(Object key, Object value) {
            this.touch(key);
            super.put(key, value);
            if (PreviewFrame.this.previewCacheSize > 0 && this.touchOrder.size() > PreviewFrame.this.previewCacheSize) {
                this.shrink();
            }
            return value;
        }

        public Object get(Object key) {
            return this.get(key, true);
        }

        public Object get(Object key, boolean touch) {
            Object result = super.get(key);
            if (result != null && touch) {
                this.touch(key);
            }
            return result;
        }

        public void clear() {
            Iterator it = this.values().iterator();
            while (it.hasNext()) {
                ImageIcon i = (ImageIcon)it.next();
                if (i == null) continue;
                i.getImage().flush();
            }
            super.clear();
            this.touchOrder.clear();
            Runtime.getRuntime().gc();
        }

        public void touch(Object key) {
            Log.log(3, PreviewFrame.MODULE, "touch " + key);
            int i = this.touchOrder.indexOf(key);
            if (i != -1) {
                this.touchOrder.remove(i);
            }
            this.touchOrder.add(key);
        }

        public void shrink() {
            if (this.touchOrder.size() == 0) {
                Log.log(1, PreviewFrame.MODULE, "Empty SmartHashtable");
                return;
            }
            Object key = this.touchOrder.get(0);
            this.touchOrder.remove(0);
            ImageIcon i = (ImageIcon)this.get(key, false);
            if (i != null) {
                i.getImage().flush();
            }
            this.remove(key);
            Runtime.getRuntime().gc();
            Log.log(3, PreviewFrame.MODULE, "Shrunk " + key);
        }
    }

    class PreviewLoader
    implements Runnable {
        Picture picture;
        boolean stillRunning = false;
        boolean notify = false;

        PreviewLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.log(3, PreviewFrame.MODULE, "Starting " + this.picture);
            Picture tmpPicture = null;
            ImageIcon tmpImage = null;
            while (this.picture != null) {
                Picture picture = this.picture;
                synchronized (picture) {
                    tmpPicture = this.picture;
                    this.picture = null;
                }
                tmpImage = PreviewFrame.this.getSizedIconForce(tmpPicture);
                if (tmpImage != null) continue;
                this.notify = false;
            }
            this.stillRunning = false;
            if (this.notify) {
                PreviewFrame.this.pictureReady(tmpImage, tmpPicture);
                this.notify = false;
            }
            Log.log(3, PreviewFrame.MODULE, "Ending");
        }

        public void loadPreview(Picture picture, boolean notify) {
            Log.log(3, PreviewFrame.MODULE, "loadPreview " + picture);
            this.picture = picture;
            if (notify) {
                this.notify = true;
            }
            if (!this.stillRunning) {
                this.stillRunning = true;
                Log.log(3, PreviewFrame.MODULE, "Calling Start");
                new Thread(this).start();
            }
        }
    }

    class ImageContentPane
    extends JPanel {
        ImageContentPane() {
        }

        public void paintComponent(Graphics g) {
            Color c = GalleryRemote._().properties.getColorProperty("slideshowColor");
            if (c != null) {
                g.setColor(c);
            } else {
                g.setColor(this.getBackground());
            }
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            if (PreviewFrame.this.currentImage != null && PreviewFrame.this.loadPicture != null) {
                ImageIcon tmpImage = ImageUtils.rotateImageIcon(PreviewFrame.this.currentImage, PreviewFrame.this.loadPicture.getAngle(), PreviewFrame.this.loadPicture.isFlipped(), this);
                PreviewFrame.this.imageRect = new Rectangle(this.getLocation().x + (this.getWidth() - tmpImage.getIconWidth()) / 2, this.getLocation().y + (this.getHeight() - tmpImage.getIconHeight()) / 2, tmpImage.getIconWidth(), tmpImage.getIconHeight());
                tmpImage.paintIcon(PreviewFrame.this.getContentPane(), g, PreviewFrame.this.imageRect.x, PreviewFrame.this.imageRect.y);
            }
        }
    }
}

